/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils.moleculetree;

import chemaxon.struc.Molecule;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;

public class AlchemistTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 3155752334517985669L;
    public static final String PROPERTY_KEY_UNIQUE_ID = "UniqueNodeId";
    public static final String PROPERTY_KEY_PARENT_ID = "ParentNodeId";
    public static final String PROPERTY_KEY_CHILDDEPTH = "ChildDepth";
    public static final String PROPERTY_KEY_DEFAULT_NODE_CAPTION = "DefaultNodeCaption";
    public static final String PROPERTY_KEY_BORDER_COLOR = "CustomBorderColor";
    public static final String PROPERTY_KEY_SELECTED_BORDER_COLOR = "SelectedBorderColor";
    public static final String PROPERTY_KEY_TAGGED_BORDER_COLOR = "TaggedBorderColor";
    private boolean excluded = false;
    private boolean loading = false;
    private boolean childrenLoaded = false;
    private boolean tagged = false;
    private int loadPercentage = 0;
    protected Map<String, String> properties = new HashMap<String, String>();

    public AlchemistTreeNode() {
        this(null);
    }

    public AlchemistTreeNode(String uniqueID) {
        this.setUniqueID(uniqueID);
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
    }

    public int getLoadPercentage() {
        return this.loadPercentage;
    }

    public void setLoadPercentage(int loadPercentage) {
        this.loadPercentage = loadPercentage;
    }

    public boolean isChildrenLoaded() {
        return this.childrenLoaded;
    }

    public void setChildrenLoaded(boolean childrenLoaded) {
        this.childrenLoaded = childrenLoaded;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AlchemistTreeNode && ((AlchemistTreeNode)obj).getUniqueID() != null) {
            return this.getUniqueID().equals(((AlchemistTreeNode)obj).getUniqueID());
        }
        return false;
    }

    public int hashCode() {
        return this.getUniqueID().hashCode();
    }

    public String getUniqueID() {
        return this.getProperty(PROPERTY_KEY_UNIQUE_ID);
    }

    public void setUniqueID(String uniqueID) {
        this.setProperty(PROPERTY_KEY_UNIQUE_ID, uniqueID);
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public boolean isExcluded() {
        return this.excluded;
    }

    public void setExcluded(boolean excluded) {
        this.excluded = excluded;
    }

    public boolean isLeaf(boolean ignoreVirtualChildren) {
        if (ignoreVirtualChildren) {
            if (this.getChildCount() > 0) {
                return ((AlchemistTreeNode)this.getChildAt(0)).getUniqueID().startsWith("virtual");
            }
            return true;
        }
        return this.isLeaf();
    }

    public String getParentID() {
        return this.properties.get(PROPERTY_KEY_PARENT_ID);
    }

    public void setParentID(String parentID) {
        this.properties.put(PROPERTY_KEY_PARENT_ID, parentID);
    }

    public void setChildrenDepth(int depth) {
        this.properties.put(PROPERTY_KEY_CHILDDEPTH, String.valueOf(depth));
    }

    public int getChildrenDepth() {
        Integer value = null;
        try {
            value = Integer.valueOf(this.properties.get(PROPERTY_KEY_CHILDDEPTH));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value == null ? 0 : value;
    }

    public Molecule getMolecule() {
        if (this.getUserObject() instanceof Molecule) {
            return (Molecule)this.getUserObject();
        }
        return null;
    }

    public void setMolecule(Molecule molecule) {
        this.setUserObject(molecule);
    }

    public boolean isTagged() {
        return this.tagged;
    }

    public void setTagged(boolean tagged) {
        this.tagged = tagged;
    }
}

