/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.alchemist.utils.transition;

import chemaxon.alchemist.utils.transition.AlchemistTransition;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.Timer;

public class AlchemistFadeScrollPane
extends JScrollPane
implements AlchemistTransition {
    private static final long serialVersionUID = -657701341518231645L;
    float increment = 0.1f;
    boolean fadeIn = true;
    float opacity = 0.0f;
    private final Timer fadeTimer = new Timer(50, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AlchemistFadeScrollPane.this.fadeIn) {
                if (AlchemistFadeScrollPane.this.horizontalScrollBar != null) {
                    AlchemistFadeScrollPane.this.horizontalScrollBar.setVisible(true);
                }
                if (AlchemistFadeScrollPane.this.verticalScrollBar != null) {
                    AlchemistFadeScrollPane.this.verticalScrollBar.setVisible(true);
                }
                AlchemistFadeScrollPane.this.opacity += AlchemistFadeScrollPane.this.increment;
                if (AlchemistFadeScrollPane.this.opacity >= 1.0f) {
                    AlchemistFadeScrollPane.this.opacity = 1.0f;
                    AlchemistFadeScrollPane.this.fadeTimer.stop();
                }
            } else {
                AlchemistFadeScrollPane.this.opacity -= AlchemistFadeScrollPane.this.increment;
                if (AlchemistFadeScrollPane.this.opacity <= 0.0f) {
                    AlchemistFadeScrollPane.this.opacity = 0.0f;
                    AlchemistFadeScrollPane.this.fadeTimer.stop();
                    if (AlchemistFadeScrollPane.this.horizontalScrollBar != null) {
                        AlchemistFadeScrollPane.this.horizontalScrollBar.setVisible(true);
                    }
                    if (AlchemistFadeScrollPane.this.verticalScrollBar != null) {
                        AlchemistFadeScrollPane.this.verticalScrollBar.setVisible(true);
                    }
                }
            }
            AlchemistFadeScrollPane.this.repaint();
        }
    });

    public AlchemistFadeScrollPane() {
        this(null, 20, 30);
    }

    public AlchemistFadeScrollPane(Component view) {
        this(view, 20, 30);
    }

    public AlchemistFadeScrollPane(int vsbPolicy, int hsbPolicy) {
        this(null, vsbPolicy, hsbPolicy);
    }

    public AlchemistFadeScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
        super(view, vsbPolicy, hsbPolicy);
    }

    @Override
    public JScrollBar createHorizontalScrollBar() {
        return new JScrollBar(0){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                Graphics2D g2 = (Graphics2D)g.create();
                float[] colors = AlchemistFadeScrollPane.this.getViewport() == null ? this.getBackground().getColorComponents(null) : AlchemistFadeScrollPane.this.getViewport().getBackground().getRGBColorComponents(null);
                g2.setColor(new Color(colors[0], colors[1], colors[2], 1.0f - AlchemistFadeScrollPane.this.opacity));
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                g2.dispose();
            }
        };
    }

    @Override
    public JScrollBar createVerticalScrollBar() {
        return new JScrollBar(1){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                Graphics2D g2 = (Graphics2D)g.create();
                float[] colors = AlchemistFadeScrollPane.this.getViewport() == null ? this.getBackground().getColorComponents(null) : AlchemistFadeScrollPane.this.getViewport().getBackground().getRGBColorComponents(null);
                g2.setColor(new Color(colors[0], colors[1], colors[2], 1.0f - AlchemistFadeScrollPane.this.opacity));
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                g2.dispose();
            }
        };
    }

    @Override
    public void startTransition() {
        this.fadeIn = true;
        this.fadeTimer.restart();
    }

    public void fadeIn() {
        this.startTransition();
    }

    @Override
    public void startTransitionReversed() {
        this.fadeIn = false;
        this.fadeTimer.restart();
    }

    public void fadeOut() {
        this.startTransitionReversed();
    }

    public float getIncrement() {
        return this.increment;
    }

    public void setIncrement(float increment) {
        this.increment = Math.abs(increment);
    }
}

