/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.beans.editors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditor;
import javax.swing.JList;

public class ListEditor
extends JList
implements PropertyEditor {
    private String propertyName;
    private Object[] propertyValues;

    public ListEditor(String name, Object[] vals, String[] names) {
        super(names);
        this.propertyName = name;
        this.propertyValues = vals;
    }

    public ListEditor(String name, int[] ivals, String[] names) {
        super(names);
        this.propertyName = name;
        this.propertyValues = new Integer[ivals.length];
        for (int i = 0; i < ivals.length; ++i) {
            this.propertyValues[i] = new Integer(ivals[i]);
        }
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return this;
    }

    @Override
    public void setValue(Object o) throws IllegalArgumentException {
        Object old = this.getValue();
        for (int i = 0; i < this.propertyValues.length; ++i) {
            Object v = this.propertyValues[i];
            if ((v != null || o != null) && (v == null || o == null || !v.equals(o))) continue;
            this.setSelectedIndex(i);
            if (old != v) {
                this.firePropertyChange(this.propertyName, old, v);
            }
            return;
        }
        throw new IllegalArgumentException(o != null ? o.toString() : "null");
    }

    @Override
    public Object getValue() {
        int i = this.getSelectedIndex();
        return i >= 0 ? this.propertyValues[i] : null;
    }

    @Override
    public void setAsText(String s) throws IllegalArgumentException {
        Object o;
        block13: {
            Object p = null;
            if (this.propertyValues != null && this.propertyValues.length > 0 && (p = this.propertyValues[0]) == null && this.propertyValues.length > 1) {
                p = this.propertyValues[1];
            }
            o = null;
            if (p == null) {
                throw new IllegalArgumentException("null");
            }
            if (p instanceof String) {
                o = s;
            } else {
                if (s == null) {
                    throw new IllegalArgumentException("null");
                }
                try {
                    if (p instanceof Integer) {
                        o = Integer.valueOf(s);
                        break block13;
                    }
                    if (p instanceof Byte) {
                        o = Byte.valueOf(s);
                        break block13;
                    }
                    if (p instanceof Short) {
                        o = Short.valueOf(s);
                        break block13;
                    }
                    if (p instanceof Long) {
                        o = Long.valueOf(s);
                        break block13;
                    }
                    if (p instanceof Float) {
                        o = Float.valueOf(s);
                        break block13;
                    }
                    if (p instanceof Double) {
                        o = Double.valueOf(s);
                        break block13;
                    }
                    throw new IllegalArgumentException("unknown type");
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException(s);
                }
            }
        }
        this.setValue(o);
    }

    @Override
    public String getAsText() {
        Object o = this.getValue();
        return o != null ? o.toString() : null;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public String getJavaInitializationString() {
        return "\"" + this.getValue() + "\"";
    }

    @Override
    public String[] getTags() {
        String[] tags = new String[this.propertyValues.length];
        for (int i = 0; i < tags.length; ++i) {
            Object v = this.propertyValues[i];
            tags[i] = v != null ? v.toString() : null;
        }
        return tags;
    }
}

