/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

import chemaxon.calculations.CalculationException;
import chemaxon.calculations.Charge;
import chemaxon.calculations.MolStandardizer;
import chemaxon.formats.MolExporter;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.io.IOException;

public class AtomPolarizability {
    protected final Molecule originalMolecule;
    protected Molecule standardizedMolecule = null;
    protected Charge charge;
    protected boolean isMolStandardized = false;
    private boolean polCharge = false;
    private double[][] atomPolarizability;
    protected static final double[] APOL = new double[]{0.314, 1.294, 1.428, 1.8, 1.393, 1.435, 1.262, 1.22, 1.304, 1.29, 1.216, 1.099, 1.046, 3.13, 5.577, 8.82, 3.0, 3.496, 2.982, 3.967, 1.29, 1.29, 3.5, 1.32, 1.38, 1.47, 1.333, 1.32, 1.15, 1.25, 1.3, 1.25, 1.316, 3.5};

    public AtomPolarizability(Molecule molecule) {
        this.originalMolecule = molecule;
    }

    public double calculate(Integer atomIndex) throws CalculationException {
        this.errorCheck();
        return this.getAtomPolarizability(atomIndex, this.polCharge, this.getCharge())[2];
    }

    private void errorCheck() {
        if (this.getCharge().getCriticalErrorFlag()) {
            String molString;
            try {
                molString = ": " + MolExporter.exportToFormat(this.originalMolecule, "smiles");
            }
            catch (IOException e) {
                molString = ".";
            }
            throw new CalculationException("Invalid molecule for polarizibility calculation" + molString);
        }
    }

    public Molecule getMolecule() {
        return this.getStandardizedMolecule();
    }

    protected Molecule getStandardizedMolecule() {
        if (this.standardizedMolecule == null) {
            this.standardizedMolecule = this.createStandardizedMolecule(this.originalMolecule);
        }
        return this.standardizedMolecule;
    }

    public Molecule getOriginalMolecule() {
        return this.originalMolecule;
    }

    protected Molecule createStandardizedMolecule(Molecule molecule) throws CalculationException {
        MolStandardizer standardizer = new MolStandardizer();
        return standardizer.calculate(molecule);
    }

    protected Charge getCharge() {
        if (this.charge == null) {
            this.charge = new Charge();
            this.charge.setMolecule(this.getStandardizedMolecule());
            this.charge.calcCharges();
        }
        return this.charge;
    }

    protected void setChargePolEffect(boolean polCharge) {
        this.polCharge = polCharge;
    }

    protected double[] getAtomPolarizability(int atomIndex, boolean polCharge, Charge charge) {
        double[] cachedValue = this.getFromCache(atomIndex);
        if (cachedValue != null) {
            return cachedValue;
        }
        boolean isImplicitH = atomIndex >= this.getStandardizedMolecule().getAtomCount();
        int protonCount = isImplicitH ? 1 : this.getStandardizedMolecule().getAtom(atomIndex).getAtno();
        switch (protonCount) {
            case 1: {
                cachedValue = this.getHydrogenPolarizability();
                break;
            }
            case 6: {
                cachedValue = this.getCarbonPolarizability(atomIndex, charge, polCharge);
                break;
            }
            case 9: {
                cachedValue = this.getFluorPolarizability(atomIndex, polCharge, charge);
                break;
            }
            case 17: {
                cachedValue = this.getChlorPolarizability(atomIndex, polCharge, charge);
                break;
            }
            case 35: {
                cachedValue = this.getBrominePolarizability(atomIndex, polCharge, charge);
                break;
            }
            case 53: {
                cachedValue = this.getIodinePolarizability(atomIndex, polCharge, charge);
                break;
            }
            case 15: {
                cachedValue = this.getPhosphinePolarizability();
                break;
            }
            case 8: {
                cachedValue = this.getOxigenPolarizability(atomIndex, charge);
                break;
            }
            case 7: {
                cachedValue = this.getNitrogenPolarizability(atomIndex, charge, charge.getCarboxy(atomIndex));
                break;
            }
            case 16: 
            case 34: {
                cachedValue = this.getSulfurPolarizability(atomIndex, charge, protonCount, polCharge);
                break;
            }
            default: {
                cachedValue = this.getDefaultPolarizability(protonCount);
            }
        }
        this.setCache(atomIndex, cachedValue);
        return cachedValue;
    }

    protected double[] getPolarizabilityParameter(int atomIndex) {
        this.errorCheck();
        double[] params = this.getAtomPolarizability(atomIndex, this.polCharge, this.charge);
        return new double[]{params[0], params[1]};
    }

    protected double[] getDefaultPolarizability(int protonCount) {
        double[] result;
        result = new double[]{0.1493 * (double)protonCount + 0.713, protonCount, 4.0 * result[0] * result[0] / (double)protonCount};
        return result;
    }

    protected double[] getSulfurPolarizability(int atomIndex, Charge charge, int protonCount, boolean polCharge) {
        MolAtom atom = this.getStandardizedMolecule().getAtom(atomIndex);
        double[] res = new double[]{0.0, protonCount, 0.0};
        int valence = this.getBondCount(atom);
        switch (valence) {
            case 2: {
                if (atom.hasAromaticBond()) {
                    res[0] = polCharge ? (1.0 - 0.05 * (-0.231 - charge.getTotalCharge(atomIndex))) * APOL[18] : APOL[18];
                    res[2] = 4.0 * res[0] * res[0] / (double)protonCount;
                } else {
                    res[0] = polCharge ? (this.hasAromaticNeighbour(atom) ? (1.0 - 0.05 * (-0.131 - charge.getTotalCharge(atomIndex))) * APOL[17] : (1.0 - 0.05 * (-0.1968 - charge.getTotalCharge(atomIndex))) * APOL[17]) : APOL[17];
                    res[2] = 4.0 * res[0] * res[0] / (double)protonCount;
                }
                return res;
            }
            case 1: {
                res[0] = polCharge ? (1.0 - 0.05 * (-0.17 - charge.getTotalCharge(atomIndex))) * APOL[19] : APOL[19];
                res[2] = 4.0 * res[0] * res[0] / (double)protonCount;
                return res;
            }
            case 3: 
            case 4: {
                res[0] = APOL[33];
                res[2] = 4.0 * res[0] * res[0] / (double)protonCount;
                return res;
            }
        }
        res[0] = APOL[17];
        res[2] = 4.0 * res[0] * res[0] / (double)protonCount;
        return res;
    }

    protected double[] getNitrogenPolarizability(int atomIndex, Charge charge, int carboxyType) {
        MolAtom atom = this.getStandardizedMolecule().getAtom(atomIndex);
        int valence = this.getBondCount(atom);
        int ind = 0;
        double[] res = new double[]{0.0, 7.0, 0.0};
        switch (valence) {
            case 4: {
                res[0] = 1.2;
                res[2] = 4.0 * res[0] * res[0] / 7.0;
                return res;
            }
            case 3: {
                ind = atom.hasAromaticBond() ? 7 : (carboxyType == 1300 || carboxyType == 100 ? 7 : (carboxyType == 200 || carboxyType == 500 ? 7 : (this.hasDelocableCarbonNeighbour(charge, atom) ? 7 : (this.hasAromaticNeighbour(atom) ? 7 : (atom.getCharge() == 1 ? 6 : (this.getNeighbourCountOf(atom, 7, false) > 0 ? 24 : 5))))));
                res[0] = APOL[ind];
                res[2] = 4.0 * res[0] * res[0] / 7.0;
                return res;
            }
            case 2: {
                res[0] = APOL[6];
                res[2] = 4.0 * res[0] * res[0] / 7.0;
                return res;
            }
            case 1: {
                res[0] = APOL[8];
                res[2] = 4.0 * res[0] * res[0] / 7.0;
                return res;
            }
        }
        res[0] = APOL[5];
        res[2] = 4.0 * res[0] * res[0] / 7.0;
        return res;
    }

    protected boolean hasDelocableCarbonNeighbour(Charge charge, MolAtom atom) {
        for (int i = 0; i < atom.getBondCount(); ++i) {
            MolAtom neigbour = atom.getBond(i).getOtherAtom(atom);
            if (6 != neigbour.getAtno() || !charge.isDelocable(this.getStandardizedMolecule().indexOf(neigbour))) continue;
            return true;
        }
        return false;
    }

    protected double[] getOxigenPolarizability(int atomIndex, Charge charge) {
        MolAtom atom = this.getStandardizedMolecule().getAtom(atomIndex);
        int valence = this.getBondCount(atom);
        int ind = 0;
        switch (valence) {
            case 2: {
                ind = 9;
                if (atom.hasAromaticBond()) {
                    ind = 11;
                    break;
                }
                if (charge.getCarboxy(atomIndex) == 1100) {
                    ind = 26;
                    break;
                }
                if (charge.getCarboxy(atomIndex) == 300) {
                    ind = 28;
                    break;
                }
                if (charge.getCarboxy(atomIndex) != 900 || this.isWater(atom)) break;
                ind = 29;
                break;
            }
            case 1: {
                ind = 10;
                if (atom.getCharge() == -1) {
                    ind = 20;
                    break;
                }
                if (charge.getCarboxy(atomIndex) == 1) {
                    if (this.getNeighbourCountOf(atom.getBond(0).getOtherAtom(atom), 6, true) < 2) break;
                    ind = 32;
                    break;
                }
                if (charge.getCarboxy(atomIndex) != 1300 && charge.getCarboxy(atomIndex) != 100) break;
                ind = 23;
                break;
            }
            default: {
                return this.getDefaultPolarizability(8);
            }
        }
        double res = APOL[ind];
        return new double[]{res, 8.0, 4.0 * res * res / 8.0};
    }

    protected boolean isWater(MolAtom atom) {
        for (int i = 0; i < atom.getBondCount(); ++i) {
            if (atom.getBond(i).getOtherAtom(atom).getAtno() <= 1) continue;
            return false;
        }
        return true;
    }

    protected double[] getPhosphinePolarizability() {
        return new double[]{APOL[16], 15.0, 2.4};
    }

    protected double[] getIodinePolarizability(int atomIndex, boolean polCharge, Charge charge) {
        double[] res = new double[]{0.0, 53.0, 0.0};
        MolAtom atom = this.getStandardizedMolecule().getAtom(atomIndex);
        double iodinePol = APOL[15];
        res[0] = polCharge ? (this.hasAromaticNeighbour(atom) ? (1.0 - 0.25 * (-0.09 - charge.getTotalCharge(atomIndex))) * iodinePol : (1.0 - 0.05 * (-0.09 - charge.getTotalCharge(atomIndex))) * iodinePol) : iodinePol;
        res[2] = 4.0 * res[0] * res[0] / 53.0;
        return res;
    }

    protected double[] getBrominePolarizability(int atomIndex, boolean polCharge, Charge charge) {
        double[] res = new double[]{0.0, 35.0, 0.0};
        MolAtom atom = this.getStandardizedMolecule().getAtom(atomIndex);
        double brominePol = APOL[14];
        res[0] = polCharge ? (this.hasAromaticNeighbour(atom) ? (1.0 - 0.25 * (-0.0964 - charge.getTotalCharge(atomIndex))) * brominePol : (1.0 - 0.05 * (-0.0964 - charge.getTotalCharge(atomIndex))) * brominePol) : brominePol;
        res[2] = 4.0 * res[0] * res[0] / 35.0;
        return res;
    }

    protected double[] getChlorPolarizability(int atomIndex, boolean polCharge, Charge charge) {
        double[] res = new double[]{0.0, 17.0, 0.0};
        MolAtom atom = this.getStandardizedMolecule().getAtom(atomIndex);
        double chlorPol = APOL[13];
        res[0] = polCharge ? (this.hasAromaticNeighbour(atom) ? (1.0 - 0.25 * (-0.1303 - charge.getTotalCharge(atomIndex))) * chlorPol : (1.0 - 0.05 * (-0.1303 - charge.getTotalCharge(atomIndex))) * chlorPol) : chlorPol;
        res[2] = 4.0 * res[0] * res[0] / 17.0;
        return res;
    }

    protected double[] getFluorPolarizability(int atomIndex, boolean polCharge, Charge charge) {
        double[] res = new double[]{0.0, 9.0, 0.0};
        MolAtom atom = this.getStandardizedMolecule().getAtom(atomIndex);
        double fluorPol = APOL[12];
        res[0] = polCharge ? (this.hasAromaticNeighbour(atom) ? (1.0 + 0.1 * (-0.1656 - charge.getTotalCharge(atomIndex))) * fluorPol : (1.0 - 0.05 * (-0.2545 - charge.getTotalCharge(atomIndex))) * fluorPol) : fluorPol;
        res[2] = 4.0 * res[0] * res[0] / 9.0;
        return res;
    }

    protected double[] getHydrogenPolarizability() {
        return new double[]{APOL[0], 1.0, 0.394384};
    }

    protected double[] getCarbonPolarizability(int atomIndex, Charge charge, boolean polCharge) {
        MolAtom atom = this.getStandardizedMolecule().getAtom(atomIndex);
        int protonCount = 6;
        double[] res = new double[]{0.0, protonCount, 0.0};
        int valence = this.getBondCount(atom);
        switch (valence) {
            case 4: {
                res[0] = APOL[charge.getHConj(atomIndex) == 1 ? 31 : 1];
                res[2] = 6.697744 / (double)protonCount;
                return res;
            }
            case 3: {
                if (atom.hasAromaticBond()) {
                    res[0] = polCharge ? (1.0 + 0.05 * (-0.0622 - charge.getTotalCharge(atomIndex))) * APOL[2] : APOL[2];
                    if (this.getAromaticNeighbourCount(atom) >= 3) {
                        res[0] = this.getNeighbourCountOf(atom, 6, true) >= 2 ? APOL[3] : APOL[2];
                    }
                } else {
                    res[0] = this.hasAromaticNeighbour(atom) && charge.getCarboxy(atomIndex) == -1 ? APOL[25] : (this.hasAromaticNeighbour(atom) && charge.getCarboxy(atomIndex) == 200 ? APOL[27] : APOL[2]);
                }
                res[2] = 4.0 * res[0] * res[0] / (double)protonCount;
                return res;
            }
            case 2: {
                res[0] = charge.getCarboxy(atomIndex) == 400 && !this.hasAromaticNeighbour(atom) ? (this.getNeighbourCountOf(atom, 1, false) == 0 ? APOL[30] : APOL[4]) : APOL[4];
                res[2] = 4.0 * res[0] * res[0] / (double)protonCount;
                return res;
            }
        }
        return this.getDefaultPolarizability(6);
    }

    protected boolean hasAromaticNeighbour(MolAtom atom) {
        if (atom.hasAromaticBond()) {
            return false;
        }
        for (int i = 0; i < atom.getBondCount(); ++i) {
            if (!atom.getBond(i).getOtherAtom(atom).hasAromaticBond()) continue;
            return true;
        }
        return false;
    }

    protected int getNeighbourCountOf(MolAtom atom, int atno, boolean onlyAromatic) {
        int fit = 0;
        for (int i = 0; i < atom.getBondCount(); ++i) {
            MolAtom other = atom.getBond(i).getOtherAtom(atom);
            if (onlyAromatic && !other.hasAromaticBond() || other.getAtno() != atno) continue;
            ++fit;
        }
        if (atno == 1 && !onlyAromatic) {
            fit += atom.getImplicitHcount();
        }
        return fit;
    }

    protected int getBondCount(MolAtom atom) {
        return atom.getBondCount() + atom.getImplicitHcount();
    }

    protected int getAromaticNeighbourCount(MolAtom atom) {
        int fit = 0;
        for (int i = 0; i < atom.getBondCount(); ++i) {
            if (!atom.getBond(i).getOtherAtom(atom).hasAromaticBond()) continue;
            ++fit;
        }
        return fit;
    }

    private double[] getFromCache(int index) {
        if (this.polCharge) {
            return null;
        }
        if (this.atomPolarizability == null) {
            this.atomPolarizability = new double[this.getStandardizedMolecule().getAtomCount()][];
        }
        if (index < 0 || index >= this.atomPolarizability.length) {
            return null;
        }
        return this.atomPolarizability[index];
    }

    private boolean setCache(int index, double[] valueToCache) {
        if (this.polCharge) {
            return false;
        }
        if (index < 0 || index >= this.atomPolarizability.length) {
            return false;
        }
        this.atomPolarizability[index] = valueToCache;
        return true;
    }
}

