/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

public class BlackHole {
    public static final int APPLE = -1;

    public int getMissingHcount(int pc, int chg, int rc, int vc, int ac) {
        int r = 0;
        int avc = 0;
        if (ac != 0) {
            avc = this.getAromaticVcount(pc, chg, ac, vc);
            if (avc < 0) {
                return -1;
            }
            vc += avc;
        }
        if (pc <= 10) {
            r = this.setCells(pc, chg, 4, vc);
        } else if (pc > 10 && (r = this.setCells(pc, chg, 4, vc)) < 0 && (r = this.setCells(pc, chg, 5, vc)) < 0 && (r = this.setCells(pc, chg, 6, vc)) < 0) {
            r = this.setCells(pc, chg, 7, vc);
        }
        if (r >= 0) {
            return r - rc;
        }
        return -1;
    }

    private int setCells(int pc, int chg, int cellCount, int bc) {
        int i;
        int ck = cellCount;
        boolean falseAtom = false;
        int chgC = chg;
        if (chg < 0) {
            chgC = -chgC;
        }
        int rc = 0;
        int lp = 0;
        int extraChg = 0;
        int maxECount = this.getMainGroupNumber(pc);
        int[] s = new int[ck];
        int k = 0;
        for (i = 0; i < maxECount; ++i) {
            int n = k++;
            s[n] = s[n] + 1;
            if (k != ck) continue;
            k = 0;
        }
        if (chg < 0) {
            i = 0;
            for (k = ck - 1; i < chgC && k >= 0; --k) {
                if (s[k] != 0) continue;
                int n = k;
                s[n] = s[n] + 1;
                ++i;
            }
            if (i != chgC) {
                for (k = 0; i < chgC && k < ck; ++k) {
                    if (s[k] != 1) continue;
                    int n = k;
                    s[n] = s[n] + 1;
                    ++i;
                }
            }
            if (i != chgC) {
                falseAtom = true;
            }
        }
        int sum = 0;
        for (i = 0; i < ck; ++i) {
            sum += s[i];
        }
        if (sum > 2 * ck) {
            falseAtom = true;
        }
        k = ck - 1;
        while (s[k] == 0) {
            --k;
        }
        i = 0;
        while (i < bc) {
            if (k >= 0) {
                if (s[k] == 1) {
                    int n = k;
                    s[n] = s[n] - 1;
                } else if (s[k] == 2) {
                    int n = k;
                    s[n] = s[n] - 2;
                    ++extraChg;
                }
            } else {
                falseAtom = true;
            }
            ++i;
            --k;
        }
        i = 0;
        k = 0;
        if (chg > 0) {
            if (extraChg > chg) {
                falseAtom = true;
            }
            chgC -= extraChg;
            int c = 0;
            while (i < chgC && k < ck) {
                if (s[k] == 2) {
                    int n = k;
                    s[n] = s[n] - 1;
                    ++i;
                    ++c;
                }
                ++k;
            }
            if (c != chgC) {
                i = c - 1;
                for (k = 0; i < chgC && k < ck; ++k) {
                    if (s[k] != 1) continue;
                    int n = k;
                    s[n] = s[n] - 1;
                    ++i;
                    ++c;
                }
            }
            if (c != chgC) {
                falseAtom = true;
            }
        } else if (extraChg != 0) {
            falseAtom = true;
        }
        rc = 0;
        lp = 0;
        for (i = 0; i < ck; ++i) {
            if (s[i] == 1) {
                ++rc;
                continue;
            }
            if (s[i] != 2) continue;
            ++lp;
        }
        if (falseAtom) {
            return -1;
        }
        return rc;
    }

    private int getAromaticVcount(int pc, int chg, int ac, int vc) {
        if (pc == 5) {
            return this.getAromaticBorVcount(chg, ac, vc);
        }
        if (pc == 6 || pc == 14) {
            return this.getAromaticCarbonVcount(chg, ac, vc);
        }
        if (pc == 7) {
            return this.getAromaticNitrogenVcount(chg, ac, vc);
        }
        if (pc == 15 || pc == 33) {
            return this.getAromaticPhosphorousVcount(chg, ac, vc);
        }
        if (pc == 8 || pc == 16 || pc == 34 || pc == 52) {
            return this.getAromaticOxigenVcount(chg, ac, vc);
        }
        return -1;
    }

    private int getAromaticCarbonVcount(int chg, int ac, int vc) {
        if (chg == 0) {
            if (ac == 3) {
                return 4;
            }
            if (ac == 2 && vc == 0) {
                return 3;
            }
            if (ac == 2 && vc == 1) {
                return 3;
            }
            if (ac == 2 && vc == 2) {
                return 2;
            }
            if (ac == 1 && vc == 2) {
                return 2;
            }
            if (ac == 1 && vc == 1) {
                return 2;
            }
            if (ac == 1 && vc == 0) {
                return 2;
            }
        } else if (chg > 0) {
            if (ac == 3) {
                return 3;
            }
            if (ac == 2 && vc == 0) {
                return 3;
            }
            if (ac == 2 && vc == 1) {
                return 2;
            }
            if (ac == 1 && vc == 2) {
                return 1;
            }
        } else if (chg < 0) {
            if (ac == 3) {
                return 3;
            }
            if (ac == 2 && vc == 0) {
                return 3;
            }
            if (ac == 2 && vc == 1) {
                return 2;
            }
            if (ac == 1 && vc == 2) {
                return 1;
            }
        }
        return -1;
    }

    private int getAromaticNitrogenVcount(int chg, int ac, int vc) {
        if (chg == 0) {
            if (ac == 3) {
                return 3;
            }
            if (ac == 2 && vc == 0) {
                return 3;
            }
            if (ac == 2 && vc == 1) {
                return 2;
            }
            if (ac == 1 && vc == 2) {
                return 1;
            }
            if (ac == 1 && vc == 1) {
                return 2;
            }
            if (ac == 1 && vc == 0) {
                return 2;
            }
        } else if (chg < 0) {
            if (ac == 2 && vc == 0) {
                return 2;
            }
            if (ac == 2 && vc == 1) {
                return 2;
            }
            if (ac == 1 && vc == 2) {
                return 1;
            }
            if (ac == 1 && vc == 1) {
                return 1;
            }
            if (ac == 1 && vc == 0) {
                return 1;
            }
        } else if (chg > 0) {
            if (ac == 3 && vc == 0) {
                return 4;
            }
            if (ac == 2 && vc == 1) {
                return 3;
            }
            if (ac == 1 && vc == 1) {
                return 2;
            }
        }
        return -1;
    }

    private int getAromaticPhosphorousVcount(int chg, int ac, int vc) {
        if (chg == 0) {
            if (ac == 2 && vc == 0) {
                return 3;
            }
            if (ac == 2 && vc == 2) {
                return 3;
            }
            if (ac == 1 && vc == 2) {
                return 1;
            }
            if (ac == 1 && vc == 1) {
                return 2;
            }
            if (ac == 1 && vc == 0) {
                return 2;
            }
            if (ac == 1 && vc == 3) {
                return 2;
            }
            if (ac == 1 && vc == 4) {
                return 1;
            }
        } else if (chg == 1 || chg == -1) {
            if (ac == 2 && vc == 0) {
                return 3;
            }
            if (ac == 2 && vc == 1) {
                return 3;
            }
            if (ac == 1 && vc == 2) {
                return 2;
            }
            if (ac == 1 && vc == 1) {
                return 2;
            }
            if (ac == 1 && vc == 0) {
                return 2;
            }
        }
        return -1;
    }

    private int getAromaticOxigenVcount(int chg, int ac, int vc) {
        if (chg == 0) {
            if (ac == 2 && vc == 0) {
                return 2;
            }
            if (ac == 1 && vc == 0) {
                return 1;
            }
            if (ac == 1 && vc == 1) {
                return 1;
            }
        } else if (chg > 0) {
            if (ac == 2 && vc == 0) {
                return 2;
            }
            if (ac == 1 && vc == 0) {
                return 1;
            }
            if (ac == 2 && vc == 1) {
                return 2;
            }
            if (ac == 1 && vc == 1) {
                return 1;
            }
            if (ac == 1 && vc == 2) {
                return 1;
            }
        }
        return -1;
    }

    private int getAromaticBorVcount(int chg, int ac, int vc) {
        if (chg == 0) {
            if (ac == 2 && vc == 0) {
                return 3;
            }
            if (ac == 1 && vc == 1) {
                return 2;
            }
            if (ac == 1 && vc == 0) {
                return 2;
            }
        } else if (chg < 0) {
            if (ac == 2 && vc == 0) {
                return 3;
            }
            if (ac == 2 && vc == 1) {
                return 3;
            }
            if (ac == 1 && vc == 1) {
                return 2;
            }
        }
        return -1;
    }

    private boolean isTransitionMetal(int pc) {
        if (pc >= 21 && pc <= 30) {
            return true;
        }
        if (pc >= 39 && pc <= 48) {
            return true;
        }
        if (pc >= 57 && pc <= 80) {
            return true;
        }
        return pc >= 89 && pc <= 112;
    }

    private boolean isLantanoid(int pc) {
        return pc >= 57 && pc <= 71;
    }

    private boolean isAktinoid(int pc) {
        return pc >= 89 && pc <= 103;
    }

    private int getRow(int pc) {
        if (pc <= 2) {
            return 1;
        }
        if (pc >= 3 && pc <= 10) {
            return 2;
        }
        if (pc >= 11 && pc <= 18) {
            return 3;
        }
        if (pc >= 19 && pc <= 36) {
            return 4;
        }
        if (pc >= 37 && pc <= 54) {
            return 5;
        }
        if (pc >= 55 && pc <= 86) {
            return 6;
        }
        if (pc >= 87 && pc <= 118) {
            return 7;
        }
        return -1;
    }

    private int getMainGroupNumber(int pc) {
        int r = this.getRow(pc);
        switch (r) {
            case 1: {
                if (pc == 1) {
                    return 1;
                }
                if (pc == 2) {
                    return 2;
                }
            }
            case 2: {
                return pc - 2;
            }
            case 3: {
                return pc - 10;
            }
            case 4: {
                if (!this.isTransitionMetal(pc)) {
                    if (pc == 19) {
                        return 1;
                    }
                    if (pc == 20) {
                        return 2;
                    }
                    if (pc >= 31 && pc <= 36) {
                        return pc - 28;
                    }
                }
            }
            case 5: {
                if (!this.isTransitionMetal(pc)) {
                    if (pc == 37) {
                        return 1;
                    }
                    if (pc == 38) {
                        return 2;
                    }
                    if (pc >= 49 && pc <= 54) {
                        return pc - 46;
                    }
                }
            }
            case 6: {
                if (!this.isTransitionMetal(pc)) {
                    if (pc == 55) {
                        return 1;
                    }
                    if (pc == 56) {
                        return 2;
                    }
                    if (pc >= 81 && pc <= 86) {
                        return pc - 78;
                    }
                }
            }
            case 7: {
                if (this.isTransitionMetal(pc)) break;
                if (pc == 87) {
                    return 1;
                }
                if (pc != 88) break;
                return 2;
            }
        }
        return -1;
    }
}

