/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

import chemaxon.calculations.AtomPolarizabilityTautomter;
import chemaxon.calculations.Charge;
import chemaxon.calculations.CriticalErrorCalculation;
import chemaxon.calculations.Tautomerization;
import chemaxon.core.calculations.LonePairCounter;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class CanonicResonant {
    Molecule mol;
    Molecule molCopy;
    Molecule canRes;
    Tautomerization canonicStruc;
    LonePairCounter LPc;
    Charge charge;
    int atomCount;
    int bChargeScore;
    int bRadicalScore;
    int bValenceScore;
    double bFGScore;
    double bPaulingNScore;
    double bPaulingPScore;
    double bPolarNScore;
    double bPolarPScore;
    int actChargeScore;
    int actRadicalScore;
    int actValenceScore;
    double actFGScore;
    double actPaulingNScore;
    double actPaulingPScore;
    double actPolarNScore;
    double actPolarPScore;
    double[] PaulingNScore;
    double[] PaulingPScore;
    double[] polarNScore;
    double[] polarPScore;
    int[] chargeScore;
    int[] radicalScore;
    int[] valenceScore;
    double[] fgScore;
    final int upperB = 10000000;
    final int UNKNOWN = -1;
    boolean rError;
    int tCount;
    int actCHG;
    boolean CanonicalParentConserved = true;
    int bTauIndx;
    boolean showWigglyBond = true;
    boolean protectAmideGroups = false;
    boolean protectSulfuracidGroups = false;
    boolean protectCOOH = false;
    boolean protectAraDiaza = false;
    boolean canTtype = false;

    public void setParentOfCanonicalStructureConserved(boolean pcsc) {
        this.CanonicalParentConserved = pcsc;
    }

    public void setWigglyBondVisibility(boolean wbv) {
        this.showWigglyBond = wbv;
    }

    public void protectAmideGoups(boolean protAG) {
        this.protectAmideGroups = protAG;
    }

    public void protectAraDiaza(boolean protAD) {
        this.protectAraDiaza = protAD;
    }

    public void protectSulfurAcidGroups(boolean protSAG) {
        this.protectSulfuracidGroups = protSAG;
    }

    public void protectCOOHGroups(boolean protCOOH) {
        this.protectCOOH = protCOOH;
    }

    public boolean isParentOfCanonicalStructureConserved() {
        return this.CanonicalParentConserved;
    }

    public boolean getCriticalErrorFlag() {
        return this.rError;
    }

    public boolean isThesame() {
        return this.canRes == null;
    }

    public Molecule getCanonicResonant() {
        if (this.canRes == null) {
            this.molCopy.dearomatize();
            return this.molCopy;
        }
        this.canRes.dearomatize();
        if (this.CanonicalParentConserved) {
            this.molCopy.removeAll();
            this.molCopy.fuse(this.canRes);
            return this.molCopy;
        }
        return this.canRes;
    }

    public void setMolecule(Molecule m) {
        this.molCopy = m;
        this.mol = m.cloneMoleculeWithDocument();
    }

    public Molecule getMolecule() {
        return this.molCopy;
    }

    private void initCalc(Molecule mm) {
        this.canonicStruc = new Tautomerization();
        this.canonicStruc.setMolecule(mm);
        this.canonicStruc.setSymmetryFiltering(true);
        this.canonicStruc.setResChargeCalc(false);
        this.canonicStruc.setResonantCalc(true);
        this.canonicStruc.setCanReso(true);
        this.canonicStruc.setMaxSpeciesCount(200);
        this.canonicStruc.setMaxAllowedTauTypeCount(90, 90, 20);
        this.canonicStruc.setProtectAllTetrahedralStereoCenters(true);
        this.canonicStruc.setWigglyBondVisibility(this.showWigglyBond);
        this.canonicStruc.setProtectSulfurAcidGroups(this.protectSulfuracidGroups);
        this.canonicStruc.setProtectAmideGroups(this.protectAmideGroups);
        this.canonicStruc.setProtectAraDiaza(this.protectAraDiaza);
        this.canonicStruc.setProtectCOOHGroups(this.protectCOOH);
        this.charge = new Charge();
        this.rError = false;
    }

    public void calcCanonicalResonant() {
        this.canRes = null;
        this.atomCount = this.mol.getAtomCount() - this.mol.getExplicitHcount();
        if (!this.isCalcable()) {
            return;
        }
        this.initCalc(this.mol);
        this.tCount = 0;
        this.bChargeScore = 10000000;
        this.bRadicalScore = 10000000;
        this.bValenceScore = 10000000;
        this.bPaulingNScore = 0.0;
        this.bPaulingPScore = 1.0E7;
        this.bPolarNScore = 1.0E7;
        this.bPolarPScore = 0.0;
        this.bFGScore = 0.0;
        boolean find = true;
        for (int cycle = 0; find && cycle < 1; ++cycle) {
            this.canonicStruc.createDACouples();
            if (this.canonicStruc.getCriticalErrorFlag()) {
                this.rError = true;
                this.finishCalc();
                return;
            }
            this.tCount = this.canonicStruc.getTCount();
            find = false;
            if (this.tCount <= 1) continue;
            this.setResonantScore();
            if (this.canonicStruc.getCriticalErrorFlag() || this.rError) {
                this.rError = true;
                this.finishCalc();
                return;
            }
            int resInd = this.getOptimalIndex();
            if (!this.isDarwinistic(this.bChargeScore, this.bRadicalScore, this.bPaulingNScore, this.bPaulingPScore, this.bPolarNScore, this.bPolarPScore, this.bValenceScore, this.bFGScore, resInd)) continue;
            this.bChargeScore = this.actChargeScore;
            this.bRadicalScore = this.actRadicalScore;
            this.bValenceScore = this.actValenceScore;
            this.bPaulingNScore = this.actPaulingNScore;
            this.bPaulingPScore = this.actPaulingPScore;
            this.bPolarNScore = this.actPolarNScore;
            this.bPolarPScore = this.actPolarPScore;
            this.bFGScore = this.actFGScore;
            this.mol = this.canonicStruc.getTMolecule(resInd);
            this.mol.aromatize(2);
            this.canRes = this.mol.cloneMoleculeWithDocument();
            find = true;
            this.bTauIndx = resInd == this.tCount - 1 ? -1 : resInd;
            if (this.isGlobalMin()) {
                this.finishCalc();
                return;
            }
            this.initCalc(this.mol);
        }
        this.finishCalc();
    }

    private void finishCalc() {
        this.canonicStruc.setResonantCalc(false);
        this.canonicStruc.setCanReso(false);
        this.canonicStruc.setProtectAllTetrahedralStereoCenters(false);
    }

    private boolean isGlobalMin() {
        return this.bChargeScore == 0 && this.bRadicalScore == 0 && this.bFGScore == 0.0 && this.bPaulingNScore == 0.0 && this.bPaulingPScore == 0.0 && this.bPolarNScore == 0.0 && this.bPolarPScore == 0.0 && this.bValenceScore == 0;
    }

    private boolean isDarwinistic(int p1, int p2, double p3, double p4, double p5, double p6, int p7, double p8, int ti) {
        if (ti == -1) {
            return false;
        }
        if (this.actChargeScore < p1) {
            return true;
        }
        if (this.actChargeScore == p1) {
            if (this.actRadicalScore < p2) {
                return true;
            }
            if (this.actRadicalScore == p2) {
                if (this.actFGScore > p8) {
                    return true;
                }
                if (this.actFGScore == p8) {
                    if (this.actValenceScore < p7) {
                        return true;
                    }
                    if (this.actValenceScore == p7) {
                        if (this.actPaulingNScore > p3) {
                            return true;
                        }
                        if (this.actPaulingNScore == p3) {
                            if (this.actPaulingPScore < p4) {
                                return true;
                            }
                            if (this.actPaulingPScore == p4) {
                                if (this.actPolarNScore < p5) {
                                    return true;
                                }
                                if (this.actPolarNScore == p5 && this.actPolarPScore > p6) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    protected void setCalcAbleType(boolean canT) {
        this.canTtype = canT;
    }

    private boolean isCalcable() {
        boolean cond1 = false;
        boolean cond2 = false;
        boolean cond3 = false;
        for (int i = 0; i < this.atomCount; ++i) {
            MolAtom a = this.mol.getAtom(i);
            int chg = a.getCharge();
            if (chg != 0) {
                if (this.canTtype) {
                    if (chg > 0) {
                        int implicitHCount = a.getImplicitHcount();
                        if (implicitHCount > 0) {
                            cond1 = true;
                            continue;
                        }
                        if (this.araBondExist(i, this.mol)) continue;
                        cond1 = true;
                        continue;
                    }
                    if (chg >= 0) continue;
                    cond2 = true;
                    continue;
                }
                return true;
            }
            if (a.getRadicalCount() == 0) continue;
            if (this.canTtype) {
                cond3 = true;
                continue;
            }
            return true;
        }
        return cond1 || cond2 || cond3;
    }

    private boolean araBondExist(int i, Molecule m) {
        MolAtom a = m.getAtom(i);
        return a.hasAromaticBond();
    }

    private int getOptimalIndex() {
        this.actChargeScore = 10000000;
        this.actRadicalScore = 10000000;
        this.actValenceScore = 10000000;
        this.actPaulingNScore = 0.0;
        this.actPaulingPScore = 1.0E7;
        this.actPolarNScore = 1.0E7;
        this.actPolarPScore = 0.0;
        this.actFGScore = 0.0;
        int maxIndex = -1;
        for (int i = 0; i < this.tCount; ++i) {
            if (this.chargeScore[i] < this.actChargeScore) {
                this.actChargeScore = this.chargeScore[i];
                this.actRadicalScore = this.radicalScore[i];
                this.actFGScore = this.fgScore[i];
                this.actValenceScore = this.valenceScore[i];
                this.actPaulingNScore = this.PaulingNScore[i];
                this.actPaulingPScore = this.PaulingPScore[i];
                this.actPolarNScore = this.polarNScore[i];
                this.actPolarPScore = this.polarPScore[i];
                maxIndex = i;
                continue;
            }
            if (this.chargeScore[i] != this.actChargeScore) continue;
            if (this.radicalScore[i] < this.actRadicalScore) {
                this.actRadicalScore = this.radicalScore[i];
                this.actFGScore = this.fgScore[i];
                this.actValenceScore = this.valenceScore[i];
                this.actPaulingNScore = this.PaulingNScore[i];
                this.actPaulingPScore = this.PaulingPScore[i];
                this.actPolarNScore = this.polarNScore[i];
                this.actPolarPScore = this.polarPScore[i];
                maxIndex = i;
                continue;
            }
            if (this.radicalScore[i] != this.actRadicalScore) continue;
            if (this.fgScore[i] > this.actFGScore) {
                this.actFGScore = this.fgScore[i];
                this.actValenceScore = this.valenceScore[i];
                this.actPaulingNScore = this.PaulingNScore[i];
                this.actPaulingPScore = this.PaulingPScore[i];
                this.actPolarNScore = this.polarNScore[i];
                this.actPolarPScore = this.polarPScore[i];
                maxIndex = i;
                continue;
            }
            if (this.fgScore[i] != this.actFGScore) continue;
            if (this.valenceScore[i] < this.actValenceScore) {
                this.actValenceScore = this.valenceScore[i];
                this.actPaulingNScore = this.PaulingNScore[i];
                this.actPaulingPScore = this.PaulingPScore[i];
                this.actPolarNScore = this.polarNScore[i];
                this.actPolarPScore = this.polarPScore[i];
                maxIndex = i;
                continue;
            }
            if (this.valenceScore[i] != this.actValenceScore) continue;
            if (this.PaulingNScore[i] > this.actPaulingNScore) {
                this.actPaulingNScore = this.PaulingNScore[i];
                this.actPaulingPScore = this.PaulingPScore[i];
                this.actPolarNScore = this.polarNScore[i];
                this.actPolarPScore = this.polarPScore[i];
                maxIndex = i;
                continue;
            }
            if (this.PaulingNScore[i] != this.actPaulingNScore) continue;
            if (this.PaulingPScore[i] < this.actPaulingPScore) {
                this.actPaulingPScore = this.PaulingPScore[i];
                this.actPolarNScore = this.polarNScore[i];
                this.actPolarPScore = this.polarPScore[i];
                maxIndex = i;
                continue;
            }
            if (this.PaulingPScore[i] != this.actPaulingPScore) continue;
            if (this.polarNScore[i] < this.actPolarNScore) {
                this.actPolarNScore = this.polarNScore[i];
                this.actPolarPScore = this.polarPScore[i];
                maxIndex = i;
                continue;
            }
            if (this.polarNScore[i] != this.actPolarNScore || !(this.polarPScore[i] > this.actPolarPScore)) continue;
            this.actPolarPScore = this.polarPScore[i];
            maxIndex = i;
        }
        return maxIndex;
    }

    private void setResonantScore() {
        this.PaulingNScore = new double[this.tCount];
        this.PaulingPScore = new double[this.tCount];
        this.chargeScore = new int[this.tCount];
        this.radicalScore = new int[this.tCount];
        this.valenceScore = new int[this.tCount];
        this.polarNScore = new double[this.tCount];
        this.polarPScore = new double[this.tCount];
        this.fgScore = new double[this.tCount];
        for (int i = 0; i < this.tCount; ++i) {
            Molecule m0 = this.canonicStruc.getTMolecule(i);
            m0.aromatize(2);
            this.charge.setMolecule(m0);
            this.charge.baseInfoAvailable = false;
            this.charge.setAromatizationType(2);
            this.charge.setChargeCalcType(true);
            this.charge.calcCharges();
            if (this.charge.getCriticalErrorFlag()) {
                this.rError = true;
                return;
            }
            for (int j = 0; j < this.atomCount; ++j) {
                MolAtom a = m0.getAtom(j);
                int chg = a.getCharge();
                int n = i;
                this.chargeScore[n] = this.chargeScore[n] + (chg < 0 ? -chg : chg);
                int rad = a.getRadicalCount();
                int n2 = i;
                this.radicalScore[n2] = this.radicalScore[n2] + rad;
                this.actCHG = chg;
                if (chg != 0) {
                    int pc = a.getAtno();
                    int en = MolAtom.electronegOf(pc);
                    if (chg < 0) {
                        int n3 = i;
                        this.PaulingNScore[n3] = this.PaulingNScore[n3] + (double)en;
                        int n4 = i;
                        this.polarNScore[n4] = this.polarNScore[n4] + this.setPolSize(j, this.atomCount, 0.75);
                    } else if (chg > 0) {
                        int n5 = i;
                        this.PaulingPScore[n5] = this.PaulingPScore[n5] + (double)en;
                        int n6 = i;
                        this.polarPScore[n6] = this.polarPScore[n6] + this.setPolSize(j, this.atomCount, 0.75);
                    }
                }
                this.setFGScore(m0, j, i);
            }
            this.setOpenValenceCount(m0, i);
        }
    }

    private double setPolSize(int atom, int aC, double dFact) {
        int MAXSPHERE = aC;
        int actAtom = atom;
        int sphereSize = 0;
        int hCount = 0;
        int[] sAtom = new int[this.atomCount];
        int[] sphere = new int[this.atomCount];
        for (int i = 0; i < this.atomCount; ++i) {
            sphere[i] = -1;
        }
        int distance = 1;
        boolean sChange = true;
        double hInc = 0.0;
        int i = 0;
        while (distance < MAXSPHERE + 1 & sChange) {
            sChange = false;
            if (actAtom != -1) {
                int length = this.charge.cHtab[actAtom].length;
                for (int j = 0; j < length; ++j) {
                    int sphereAtom = this.charge.cHtab[actAtom][j];
                    if (sphereAtom < this.atomCount) {
                        if (sAtom[sphereAtom] != 0 || sphereAtom == atom) continue;
                        sAtom[sphereAtom] = distance;
                        sphere[sphereSize] = sphereAtom;
                        ++sphereSize;
                        continue;
                    }
                    ++hCount;
                    hInc += 0.314 * Math.pow(dFact, distance - 1);
                }
            }
            if (sphere[i] != -1) {
                actAtom = sphere[i];
                distance = sAtom[actAtom] + 1;
                sChange = true;
            } else {
                sChange = false;
            }
            if (++i != this.atomCount) continue;
            sChange = false;
        }
        double sum1 = 0.0;
        double sum2 = 0.0;
        double[] res = new double[]{0.0, 0.0, 0.0};
        double apol = 0.0;
        AtomPolarizabilityTautomter atomPol = new AtomPolarizabilityTautomter(this.charge);
        for (i = 0; i < sphereSize; ++i) {
            int a = sphere[i];
            distance = sAtom[a];
            res = atomPol.getPolarizabilityParameter(a);
            sum1 += Math.pow(dFact, distance - 1) * res[0];
            sum2 += res[1];
        }
        sum1 = Math.pow(sum1 + hInc, 2.0);
        apol = 4.0 * sum1 / (sum2 += (double)hCount);
        return apol;
    }

    private void setOpenValenceCount(Molecule mm, int ti) {
        this.LPc = new LonePairCounter();
        this.LPc.setMolecule(mm);
        this.LPc.calcLonePairCount();
        int[] veC = this.LPc.getAllEC();
        for (int i = 0; i < this.atomCount; ++i) {
            MolAtom a = mm.getAtom(i);
            int pc = a.getAtno();
            int gn = this.canonicStruc.getGroupNumber(pc);
            int chg = a.getCharge();
            if (gn == 0 || chg == 0) continue;
            if (pc <= 10) {
                if (veC[i] == 8) continue;
                int n = ti;
                this.valenceScore[n] = this.valenceScore[n] + 1;
                continue;
            }
            if (gn > 5) {
                if (veC[i] > 12 || !this.canonicStruc.isOddNumber(veC[i])) continue;
                int n = ti;
                this.valenceScore[n] = this.valenceScore[n] + 1;
                continue;
            }
            if (gn > 5) continue;
            if (veC[i] <= 10) {
                if (!this.canonicStruc.isOddNumber(veC[i])) continue;
                int n = ti;
                this.valenceScore[n] = this.valenceScore[n] + 1;
                continue;
            }
            int n = ti;
            this.valenceScore[n] = this.valenceScore[n] + 1;
        }
    }

    private boolean isExocyclic(Molecule m0, int a) {
        for (int i = 0; i < this.charge.cHtab[a].length; ++i) {
            int nb = this.charge.cHtab[a][i];
            if (nb >= this.atomCount || this.charge.isArA(nb) || m0.getBond(this.charge.bHtab[a][nb]).getType() != 2) continue;
            return true;
        }
        return false;
    }

    private void setFGScore(Molecule m0, int ai, int ti) {
        if (this.charge.getPolarGroups().carboxy[ai] != -1) {
            int type = this.charge.getPolarGroups().carboxy[ai];
            int prop = this.charge.getPolarGroups().groupProperty[ai];
            int gtype = this.charge.getPolarGroups().groupType[ai];
            if (type == 2) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
            } else if (type == 100 || type == 1300) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
            } else if (type == 300) {
                if (gtype == 870) {
                    int n = ti;
                    this.fgScore[n] = this.fgScore[n] + -0.5;
                } else if (prop != 600 && prop != 800) {
                    int n = ti;
                    this.fgScore[n] = this.fgScore[n] + 1.0;
                }
            } else if (gtype == 850) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.5;
            } else if (type == 1000 || type == 400 || type == 800) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
            } else if (type == 200 && prop == 409) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
            } else if (type == 600 || type == 700) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
            } else if (type == 500 && prop == 409) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
            } else if (type == 200 && prop == 410) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
            } else if (type == 500 && prop == 410) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
            } else if (type == 200 && prop == 411) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
            } else if (type == 500 && prop == 411) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
            } else if (prop == 700) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
            } else if (type == 1 && prop != 1100) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
            } else if (type == 1 && prop == 1100) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + -0.5;
            } else if (prop == 422) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
            } else if (type == 1600) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
            } else if (type == 1500) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
                if (this.actCHG > 0 && !this.isHExist(ai, m0) && this.isDBondExist(ai, m0)) {
                    int n2 = ti;
                    this.fgScore[n2] = this.fgScore[n2] + -0.5;
                }
            } else if (type == 1700) {
                if (this.charge.sAra[ai] == 1 || this.charge.isArA(ai)) {
                    int n = ti;
                    this.fgScore[n] = this.fgScore[n] + 1.0;
                } else if (this.isEXoNbExist(ai, m0)) {
                    int n = ti;
                    this.fgScore[n] = this.fgScore[n] + -0.5;
                }
            } else if (type == 1200) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
                if (this.charge.isArA(ai)) {
                    int n3 = ti;
                    this.fgScore[n3] = this.fgScore[n3] + 1.0;
                }
            } else if (this.charge.isArA(ai)) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
            }
        } else if (this.charge.isArA(ai)) {
            if (this.actCHG == 0) {
                if (this.isExocyclic(m0, ai)) {
                    int n = ti;
                    this.fgScore[n] = this.fgScore[n] + 0.5;
                } else {
                    int n = ti;
                    this.fgScore[n] = this.fgScore[n] + 1.0;
                }
            } else if (this.actCHG != 0) {
                if (this.charge.getSymbol(ai).equals("C")) {
                    if (this.actCHG > 0) {
                        int n = ti;
                        this.fgScore[n] = this.fgScore[n] + -0.5;
                    } else {
                        int n = ti;
                        this.fgScore[n] = this.fgScore[n] + 0.5;
                    }
                } else {
                    int n = ti;
                    this.fgScore[n] = this.fgScore[n] + 0.85;
                }
            } else {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 0.85;
            }
        } else if (this.charge.sAra[ai] == 1) {
            if (this.actCHG == 0) {
                if (this.isExocyclic(m0, ai)) {
                    int n = ti;
                    this.fgScore[n] = this.fgScore[n] + 0.5;
                } else {
                    int n = ti;
                    this.fgScore[n] = this.fgScore[n] + 1.0;
                }
            } else if (this.actCHG != 0) {
                if (this.charge.getSymbol(ai).equals("C")) {
                    if (this.actCHG > 0) {
                        int n = ti;
                        this.fgScore[n] = this.fgScore[n] + -0.5;
                    } else {
                        int n = ti;
                        this.fgScore[n] = this.fgScore[n] + 0.5;
                    }
                } else {
                    int n = ti;
                    this.fgScore[n] = this.fgScore[n] + 0.85;
                }
            } else {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 0.85;
            }
        } else if (this.actCHG > 0) {
            if (this.charge.getSymbol(ai).equals("N")) {
                if (this.isEXoNbExist(ai, m0)) {
                    int n = ti;
                    this.fgScore[n] = this.fgScore[n] + -0.5;
                } else if (!this.isHExist(ai, m0) && this.isDBondExist(ai, m0)) {
                    int n = ti;
                    this.fgScore[n] = this.fgScore[n] + -0.5;
                }
            } else if (!this.charge.getSymbol(ai).equals("C")) {
                if (this.isDBondExist(ai, m0) && this.isMetalNbExist(ai, m0)) {
                    int n = ti;
                    this.fgScore[n] = this.fgScore[n] + 1.0;
                }
            } else if (this.charge.cHtab[ai].length == 3) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + -1.0;
            }
        }
    }

    private boolean isMetalNbExist(int ai, Molecule mm) {
        int L = this.charge.cHtab[ai].length;
        for (int i = 0; i < L; ++i) {
            MolAtom a;
            int pc;
            int nb = this.charge.cHtab[ai][i];
            if (nb >= this.atomCount || !CriticalErrorCalculation.isMetal(pc = (a = mm.getAtom(nb)).getAtno(), a)) continue;
            return true;
        }
        return false;
    }

    private boolean isDBondExist(int ai, Molecule mm) {
        int L = this.charge.cHtab[ai].length;
        for (int i = 0; i < L; ++i) {
            int nb = this.charge.cHtab[ai][i];
            if (nb >= this.atomCount || mm.getBond(this.charge.bHtab[ai][nb]).getType() < 2) continue;
            return true;
        }
        return false;
    }

    private boolean isEXoNbExist(int ai, Molecule mm) {
        int L = this.charge.cHtab[ai].length;
        for (int i = 0; i < L; ++i) {
            int nb = this.charge.cHtab[ai][i];
            if (nb >= this.atomCount || mm.getBond(this.charge.bHtab[ai][nb]).getType() != 2 || !this.isExocyclic(mm, nb)) continue;
            return true;
        }
        return false;
    }

    private boolean isHExist(int ai, Molecule mm) {
        MolAtom a = mm.getAtom(ai);
        int s = a.getImplicitHcount();
        return s != 0;
    }
}

