/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

import chemaxon.calculations.AtomPolarizabilityTautomter;
import chemaxon.calculations.Charge;
import chemaxon.calculations.CriticalErrorCalculation;
import chemaxon.calculations.Tautomerization;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class CanonicTautomer {
    Molecule mol;
    Molecule molCopy;
    Molecule canTau;
    int tCount;
    Tautomerization canonicStruc;
    Charge charge;
    int[] sphere;
    int[] usedAtom;
    int[] sAtom;
    double[] polarScore;
    double[] aromScore;
    int[] delocRScore;
    double[] fgScore;
    double[] delocScore;
    double[] radicalScore;
    int[] delocProxyScore;
    double actPolarScore;
    double actAromScore;
    int actDRScore;
    double actFGScore;
    double actRadicalScore;
    double actDelocScore;
    int actDelocProxyScore;
    double bPolarScore;
    double bAromScore;
    int bDelocRScore;
    double bFGScore;
    double bRadicalScore;
    double bDelocScore;
    int bDelocProxyScore;
    int pL = 4;
    boolean showWigglyBond = true;
    int sphereSize;
    int atomCount;
    final int KNOWN = 1;
    final int UNKNOWN = -1;
    final int MAXi = 10000000;
    boolean structureError;
    Molecule[] taurus;
    boolean CanonicalParentConserved = true;
    boolean calcDominantCanonic = false;
    boolean itAllowed = false;
    boolean expH = false;
    boolean protectAromAtomCount = true;
    boolean protectAntiAromAtomCount = true;
    boolean exclChgAtoms = true;
    boolean protectCTInfo = false;
    boolean excludeSCC = false;
    boolean excludeCC = false;
    boolean protectAmideGroups = false;
    boolean protectAraDiaza = false;
    boolean protectSulfuracidGroups = false;
    boolean protectCOOH = false;
    boolean ketenAllowed = true;
    boolean stdCanonic = false;
    boolean ratTu = false;
    int actExoAtom;
    int bTauIndx;
    int[] catIndx;
    boolean partialNeutralization = false;
    int actCHG;

    public void setParentOfCanonicalStructureConserved(boolean pcsc) {
        this.CanonicalParentConserved = pcsc;
    }

    public boolean isParentOfCanonicalStructureConserved() {
        return this.CanonicalParentConserved;
    }

    public void setCanonicType(boolean Ctype) {
        this.calcDominantCanonic = Ctype;
    }

    public Molecule getCanonicalTautomer() {
        if (this.canTau == null) {
            if ((this.canonicStruc.oMolNeutralized || !this.canonicStruc.noResonant) && this.canonicStruc.getNeutraloMol() != null) {
                return this.canonicStruc.getNeutraloMol();
            }
            this.molCopy.dearomatize();
            return this.molCopy;
        }
        this.canTau.dearomatize();
        if (this.canonicStruc.protectExpH) {
            this.canonicStruc.setExplicitHydrogens(this.canTau, this.bTauIndx);
        }
        if (this.CanonicalParentConserved) {
            this.molCopy.removeAll();
            this.molCopy.fuse(this.canTau);
            return this.molCopy;
        }
        return this.canTau;
    }

    public void setMolecule(Molecule m) {
        this.molCopy = m;
        this.mol = m.cloneMoleculeWithDocument();
    }

    public void setPartialNeutralization(boolean pn) {
        this.partialNeutralization = pn;
    }

    public Molecule getMolecule() {
        return this.molCopy;
    }

    public boolean getCriticalErrorFlag() {
        return this.canonicStruc.getCriticalErrorFlag();
    }

    public void setTautomerPathLengthCriteria(int p) {
        this.pL = p;
    }

    public void setRatTauFlag(boolean rt) {
        this.ratTu = rt;
    }

    public void setWigglyBondVisibility(boolean sWb) {
        this.showWigglyBond = sWb;
    }

    public void protectAmideGoups(boolean protAG) {
        this.protectAmideGroups = protAG;
    }

    public void protectAraDiaza(boolean protAD) {
        this.protectAraDiaza = protAD;
    }

    public void protectSulfurAcidGroups(boolean protSAG) {
        this.protectSulfuracidGroups = protSAG;
    }

    public void protectCOOHGroups(boolean protCOOH) {
        this.protectCOOH = protCOOH;
    }

    public void protectAromaticAtomCount(boolean protA) {
        this.protectAromAtomCount = protA;
    }

    public void protectAntiAromaticAtomCount(boolean protA) {
        this.protectAntiAromAtomCount = protA;
    }

    public void setKetenFormationAllowed(boolean allowKF) {
        this.ketenAllowed = allowKF;
    }

    public void setStdCanonicFlag(boolean stdCan) {
        this.stdCanonic = stdCan;
    }

    public void protectCT(boolean delct) {
        this.protectCTInfo = delct;
    }

    public void excludeStrictChiralCenter(boolean escc) {
        this.excludeSCC = escc;
    }

    public void excludeChiralCenter(boolean ecc) {
        this.excludeCC = ecc;
    }

    public void excludeChargedAtoms(boolean exclChg) {
        this.exclChgAtoms = exclChg;
    }

    private void initCalc(Molecule mm) {
        this.canonicStruc = new Tautomerization();
        this.canonicStruc.setMolecule(mm);
        this.canonicStruc.setTakeDominantTautomers(false);
        this.canonicStruc.setTautomerPathLengthCriteria(this.pL);
        this.canonicStruc.setWigglyBondVisibility(this.showWigglyBond);
        this.canonicStruc.setProtectAmideGroups(this.protectAmideGroups);
        this.canonicStruc.setProtectAraDiaza(this.protectAraDiaza);
        this.canonicStruc.setRationalTautomerGeneration(this.ratTu);
        this.canonicStruc.setProtectSulfurAcidGroups(this.protectSulfuracidGroups);
        this.canonicStruc.setProtectCOOHGroups(this.protectCOOH);
        this.canonicStruc.setKetenFormationAllowed(this.ketenAllowed);
        this.canonicStruc.setStdCanonicFlag(this.stdCanonic);
        this.canonicStruc.setSymmetryFiltering(false);
        this.canonicStruc.setResChargeCalc(false);
        this.canonicStruc.setCanTaur(true);
        this.canonicStruc.setPartialNeutralization(this.partialNeutralization);
        this.canonicStruc.protectAromaticity(this.protectAromAtomCount);
        this.canonicStruc.excludeAntiAroma(this.protectAntiAromAtomCount);
        this.canonicStruc.protectCharge(this.exclChgAtoms);
        this.canonicStruc.setProtectDoubleBondStereo(this.protectCTInfo);
        this.canonicStruc.setProtectLabeledTetrahedralStereoCenters(this.excludeSCC);
        this.canonicStruc.setProtectAllTetrahedralStereoCenters(this.excludeCC);
        if (this.itAllowed) {
            this.canonicStruc.setMaxSpeciesCount(100);
        }
        this.charge = new Charge();
    }

    private void initDomCalc(Molecule mm) {
        this.canonicStruc = new Tautomerization();
        this.canonicStruc.setMolecule(mm);
        this.canonicStruc.setTakeDominantTautomers(true);
        this.canonicStruc.setSymmetryFiltering(false);
        this.canonicStruc.setCanTaur(true);
        this.canonicStruc.setTautomerPathLengthCriteria(this.pL);
        this.canonicStruc.setWigglyBondVisibility(this.showWigglyBond);
        this.canonicStruc.protectAromaticity(this.protectAromAtomCount);
        this.canonicStruc.excludeAntiAroma(this.protectAntiAromAtomCount);
        this.canonicStruc.protectCharge(this.exclChgAtoms);
        this.canonicStruc.setProtectDoubleBondStereo(this.protectCTInfo);
        this.canonicStruc.setProtectLabeledTetrahedralStereoCenters(this.excludeSCC);
        this.canonicStruc.setProtectAllTetrahedralStereoCenters(this.excludeCC);
        this.canonicStruc.setProtectAmideGroups(this.protectAmideGroups);
        this.canonicStruc.setProtectAraDiaza(this.protectAraDiaza);
        this.canonicStruc.setRationalTautomerGeneration(this.ratTu);
        this.canonicStruc.setProtectSulfurAcidGroups(this.protectSulfuracidGroups);
        this.canonicStruc.setProtectCOOHGroups(this.protectCOOH);
        this.canonicStruc.setKetenFormationAllowed(this.ketenAllowed);
        if (this.itAllowed) {
            this.canonicStruc.setMaxSpeciesCount(200);
        }
        this.charge = new Charge();
    }

    private void finishCalc() {
        this.canonicStruc.setResChargeCalc(false);
        this.canonicStruc.setCanTaur(false);
        this.canonicStruc.setTakeDominantTautomers(false);
        this.canonicStruc.protectExplicitHydrogens(this.expH);
    }

    public int[] getcatIndx() {
        return this.catIndx;
    }

    public void calcCanonicalTautomer() {
        int maxCycle;
        this.bPolarScore = 0.0;
        this.bAromScore = 0.0;
        this.bDelocRScore = 0;
        this.bFGScore = 0.0;
        this.bRadicalScore = 1.0E7;
        this.bDelocScore = 0.0;
        this.bDelocProxyScore = 10000000;
        boolean find = true;
        int cycle = 0;
        this.canTau = null;
        if (this.calcDominantCanonic) {
            this.initDomCalc(this.mol);
            maxCycle = this.itAllowed ? 10 : 1;
        } else {
            this.initCalc(this.mol);
            maxCycle = this.itAllowed ? 10 : 1;
        }
        this.bTauIndx = -1;
        while (find && cycle < maxCycle) {
            this.canonicStruc.createDACouples();
            this.tCount = this.canonicStruc.getTCount();
            if (cycle == 0 && this.tCount == 1) {
                this.finishCalc();
                return;
            }
            if (cycle == 0) {
                this.expH = this.canonicStruc.getExplicitHFlag();
                this.canonicStruc.protectExplicitHydrogens(false);
                this.atomCount = this.canonicStruc.getImplicitizedAtomCount();
                this.catIndx = this.canonicStruc.getFixedAtomIndexesForPartialClean();
            }
            if (this.canonicStruc.getCriticalErrorFlag()) {
                this.finishCalc();
                return;
            }
            this.tCount = this.canonicStruc.getTCount();
            find = false;
            if (this.tCount > 1) {
                this.setScoreOfTautomers();
                if (this.canonicStruc.getCriticalErrorFlag()) {
                    this.finishCalc();
                    return;
                }
                int tauInd = this.getLargestFitIndex();
                if (this.isMoreFit(this.bAromScore, this.bPolarScore, this.bFGScore, this.bDelocScore, this.bDelocProxyScore, this.bDelocRScore, this.bRadicalScore, tauInd)) {
                    this.bPolarScore = this.actPolarScore;
                    this.bAromScore = this.actAromScore;
                    this.bDelocRScore = this.actDRScore;
                    this.bFGScore = this.actFGScore;
                    this.bRadicalScore = this.actRadicalScore;
                    this.bDelocScore = this.actDelocScore;
                    this.bDelocProxyScore = this.actDelocProxyScore;
                    this.mol = this.canonicStruc.getTMolecule(tauInd);
                    this.mol.aromatize(2);
                    this.canTau = this.mol.cloneMoleculeWithDocument();
                    find = true;
                    if (!this.calcDominantCanonic) {
                        if (this.itAllowed) {
                            this.initCalc(this.mol);
                        }
                    } else if (this.itAllowed) {
                        this.initDomCalc(this.mol);
                    }
                    this.bTauIndx = tauInd == this.tCount - 1 ? -1 : tauInd;
                }
            }
            ++cycle;
        }
        this.finishCalc();
    }

    private void setScoreOfTautomers() {
        this.polarScore = new double[this.tCount];
        this.fgScore = new double[this.tCount];
        this.delocScore = new double[this.tCount];
        this.delocProxyScore = new int[this.tCount];
        this.aromScore = new double[this.tCount];
        this.delocRScore = new int[this.tCount];
        this.radicalScore = new double[this.tCount];
        this.usedAtom = new int[this.atomCount];
        for (int i = 0; i < this.tCount; ++i) {
            int j;
            Molecule m0 = this.canonicStruc.getTMolecule(i);
            int n = i;
            this.radicalScore[n] = this.radicalScore[n] + (double)this.canonicStruc.getRadCount(i);
            m0.aromatize(2);
            this.charge.baseInfoAvailable = false;
            this.charge.setAromatizationType(2);
            this.charge.setMolecule(m0);
            this.charge.calcCharges();
            this.excludeHConjAtoms();
            if (this.canonicStruc.getCriticalErrorFlag() || this.charge.getCriticalErrorFlag()) {
                this.finishCalc();
                this.canonicStruc.setCriticalErrorFlag(true);
                return;
            }
            this.polarScore[i] = 0.0;
            this.delocScore[i] = 0.0;
            this.delocRScore[i] = 0;
            this.fgScore[i] = 0.0;
            this.delocProxyScore[i] = 0;
            for (j = 0; j < this.atomCount; ++j) {
                this.usedAtom[j] = -1;
            }
            for (j = 0; j < this.atomCount; ++j) {
                if (this.charge.delocAble[j] == 1) {
                    int n2 = i;
                    this.polarScore[n2] = this.polarScore[n2] + this.setAtomSphere(j, this.atomCount, 0.75);
                    int n3 = i;
                    this.delocProxyScore[n3] = this.delocProxyScore[n3] + this.setDelocProxyScore(j);
                    this.setDelocScore(m0, j, this.atomCount, i);
                    if (this.charge.isInRing()[j] && this.isDBonded(m0, j)) {
                        int n4 = i;
                        this.delocRScore[n4] = this.delocRScore[n4] + 1;
                    }
                }
                this.setFGScore(m0, j, i);
            }
            this.setAromCountScore(m0, i);
        }
    }

    private boolean isDBonded(Molecule m0, int ai) {
        for (int i = 0; i < this.charge.cHtab[ai].length; ++i) {
            int nb = this.charge.cHtab[ai][i];
            if (nb >= this.atomCount || m0.getBond(this.charge.bHtab[ai][nb]).getType() != 2) continue;
            return true;
        }
        return false;
    }

    private void excludeHConjAtoms() {
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.charge.hconj == null) {
                this.charge.setCriticalErrorFlag(true);
                return;
            }
            if (this.charge.hconj[i] != 1) continue;
            this.charge.delocAble[i] = -1;
        }
    }

    private void setAromCountScore(Molecule m0, int ti) {
        m0.aromatize(2);
        this.aromScore[ti] = 0.0;
        for (int j = 0; j < this.atomCount; ++j) {
            MolAtom a = m0.getAtom(j);
            if (!a.hasAromaticBond()) continue;
            if (this.charge.getPolarGroups().carboxy[j] == 1) {
                int n = ti;
                this.aromScore[n] = this.aromScore[n] + 0.5;
                continue;
            }
            if (this.charge.getPolarGroups().carboxy[j] == 2) {
                int n = ti;
                this.aromScore[n] = this.aromScore[n] + 1.5;
                continue;
            }
            if (this.charge.getPolarGroups().carboxy[j] == 200 || this.charge.getPolarGroups().carboxy[j] == 500) {
                int n = ti;
                this.aromScore[n] = this.aromScore[n] + 1.5;
                continue;
            }
            if (this.isExocyclicBond(m0, j)) {
                int pc = this.charge.atomArray[this.actExoAtom].getAtno();
                if (pc == 8) {
                    int n = ti;
                    this.aromScore[n] = this.aromScore[n] + 0.5;
                    continue;
                }
                int n = ti;
                this.aromScore[n] = this.aromScore[n] + 0.25;
                continue;
            }
            if (this.isNH(j) && !this.isPyrroleLikeN(j)) {
                int n = ti;
                this.aromScore[n] = this.aromScore[n] + 0.5;
                continue;
            }
            int n = ti;
            this.aromScore[n] = this.aromScore[n] + 1.0;
        }
    }

    private int getLargestFitIndex() {
        this.actAromScore = 0.0;
        this.actFGScore = 0.0;
        this.actRadicalScore = 1.0E7;
        this.actPolarScore = 0.0;
        this.actDelocScore = 0.0;
        this.actDelocProxyScore = 10000000;
        int maxIndex = -1;
        for (int i = 0; i < this.tCount; ++i) {
            if (this.aromScore[i] > this.actAromScore) {
                this.actAromScore = this.aromScore[i];
                this.actDRScore = this.delocRScore[i];
                this.actFGScore = this.fgScore[i];
                this.actRadicalScore = this.radicalScore[i];
                this.actDelocScore = this.delocScore[i];
                this.actDelocProxyScore = this.delocProxyScore[i];
                this.actPolarScore = this.polarScore[i];
                maxIndex = i;
                continue;
            }
            if (this.aromScore[i] != this.actAromScore) continue;
            if (this.fgScore[i] > this.actFGScore) {
                this.actFGScore = this.fgScore[i];
                this.actRadicalScore = this.radicalScore[i];
                this.actDRScore = this.delocRScore[i];
                this.actDelocScore = this.delocScore[i];
                this.actDelocProxyScore = this.delocProxyScore[i];
                this.actPolarScore = this.polarScore[i];
                maxIndex = i;
                continue;
            }
            if (this.fgScore[i] != this.actFGScore) continue;
            if (this.radicalScore[i] < this.actRadicalScore) {
                this.actRadicalScore = this.radicalScore[i];
                this.actDRScore = this.delocRScore[i];
                this.actDelocScore = this.delocScore[i];
                this.actDelocProxyScore = this.delocProxyScore[i];
                this.actPolarScore = this.polarScore[i];
                maxIndex = i;
                continue;
            }
            if (this.radicalScore[i] != this.actRadicalScore) continue;
            if (this.delocRScore[i] > this.actDRScore) {
                this.actDRScore = this.delocRScore[i];
                this.actDelocScore = this.delocScore[i];
                this.actDelocProxyScore = this.delocProxyScore[i];
                this.actPolarScore = this.polarScore[i];
                maxIndex = i;
                continue;
            }
            if (this.delocRScore[i] != this.actDRScore) continue;
            if (this.delocProxyScore[i] < this.actDelocProxyScore) {
                this.actDelocScore = this.delocScore[i];
                this.actDelocProxyScore = this.delocProxyScore[i];
                this.actPolarScore = this.polarScore[i];
                maxIndex = i;
                continue;
            }
            if (this.delocProxyScore[i] != this.actDelocProxyScore) continue;
            if (this.delocScore[i] > this.actDelocScore) {
                this.actDelocScore = this.delocScore[i];
                this.actPolarScore = this.polarScore[i];
                maxIndex = i;
                continue;
            }
            if (this.delocScore[i] != this.actDelocScore || !(this.polarScore[i] > this.actPolarScore)) continue;
            this.actPolarScore = this.polarScore[i];
            maxIndex = i;
        }
        return maxIndex;
    }

    private boolean isMoreFit(double p1, double p2, double p3, double p4, int p5, int p6, double p7, int tauInd) {
        if (tauInd == -1) {
            return false;
        }
        if (this.actAromScore > p1) {
            return true;
        }
        if (this.actAromScore == p1) {
            if (this.actFGScore > p3) {
                return true;
            }
            if (this.actFGScore == p3) {
                if (this.actRadicalScore < p7) {
                    return true;
                }
                if (this.actRadicalScore == p7) {
                    if (this.actDRScore > p6) {
                        return true;
                    }
                    if (this.actDRScore == p6) {
                        if (this.actDelocProxyScore < p5) {
                            return true;
                        }
                        if (this.actDelocProxyScore == p5) {
                            if (this.actDelocScore > p4) {
                                return true;
                            }
                            if (this.actDelocScore == p4 && this.actPolarScore > p2) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private double setAtomSphere(int atom, int shellCount, double dFact) {
        int MAXSPHERE = shellCount;
        int actAtom = atom;
        this.sphereSize = 0;
        int hCount = 0;
        this.sAtom = new int[this.atomCount];
        this.sphere = new int[this.atomCount];
        for (int i = 0; i < this.atomCount; ++i) {
            this.sphere[i] = -1;
        }
        int distance = 1;
        boolean sChange = true;
        double hInc = 0.0;
        int i = 0;
        while (distance < MAXSPHERE + 1 & sChange) {
            sChange = false;
            if (actAtom != -1) {
                int length = this.charge.cHtab[actAtom].length;
                for (int j = 0; j < length; ++j) {
                    int sphereAtom = this.charge.cHtab[actAtom][j];
                    if (sphereAtom < this.atomCount) {
                        if (this.sAtom[sphereAtom] != 0 || sphereAtom == atom) continue;
                        this.sAtom[sphereAtom] = distance;
                        this.sphere[this.sphereSize] = sphereAtom;
                        ++this.sphereSize;
                        continue;
                    }
                    ++hCount;
                    hInc += 0.314 * Math.pow(dFact, distance - 1);
                }
            }
            if (this.sphere[i] != -1) {
                actAtom = this.sphere[i];
                distance = this.sAtom[actAtom] + 1;
                sChange = true;
            } else {
                sChange = false;
            }
            if (++i != this.atomCount) continue;
            sChange = false;
        }
        double sum1 = 0.0;
        double sum2 = 0.0;
        double[] res = new double[]{0.0, 0.0, 0.0};
        double apol = 0.0;
        AtomPolarizabilityTautomter atomPol = new AtomPolarizabilityTautomter(this.charge);
        for (i = 0; i < this.sphereSize; ++i) {
            int a = this.sphere[i];
            distance = this.sAtom[a];
            res = atomPol.getPolarizabilityParameter(a);
            sum1 += Math.pow(dFact, distance - 1) * res[0];
            sum2 += res[1];
        }
        sum1 = Math.pow(sum1 + hInc, 2.0);
        apol = 4.0 * sum1 / (sum2 += (double)hCount);
        return apol;
    }

    private void setDelocScore(Molecule m0, int ai, int maxDist, int ti) {
        if (this.usedAtom[ai] == -1) {
            this.charge.getDelocalizationIsland(ai, maxDist);
            double s = 0.0;
            int size = this.charge.getSphereSize();
            for (int i = 0; i < size; ++i) {
                int a = this.charge.sAtoms[i];
                int delocNBCount = this.isCrossAtom(m0, a);
                s = this.charge.isInRing()[a] ? (delocNBCount == 3 ? (s += 1.1) : (this.isThreeRingCentered(a) ? (this.isDoubleThreeCentered(m0, a) ? (s += 2.0) : (delocNBCount == 2 ? (s += 1.2) : (s += 1.5))) : (this.isRingAliBond(m0, a) ? (s += 1.2) : (s += 2.0)))) : (delocNBCount == 3 ? (s += 0.0) : (s += 1.0));
                this.usedAtom[a] = 1;
            }
            if (this.delocScore[ti] < s) {
                this.delocScore[ti] = s;
            }
        }
    }

    private int isCrossAtom(Molecule m0, int a) {
        int nb;
        int c = 0;
        if (this.charge.cHtab[a].length != 3) {
            return 0;
        }
        for (int i = 0; i < this.charge.cHtab[a].length; ++i) {
            nb = this.charge.cHtab[a][i];
            if (nb >= this.atomCount || this.charge.delocAble[nb] != 1) continue;
            ++c;
        }
        if (c == 3) {
            int c1 = 0;
            int c2 = 0;
            for (int i = 0; i < this.charge.cHtab[a].length; ++i) {
                nb = this.charge.cHtab[a][i];
                if (m0.getBond(this.charge.bHtab[a][nb]).getType() == 1) {
                    ++c1;
                    continue;
                }
                if (m0.getBond(this.charge.bHtab[a][nb]).getType() != 2) continue;
                ++c2;
            }
            if (c1 == 2 && c2 == 1) {
                return 3;
            }
        }
        return c;
    }

    private boolean isThreeRingCentered(int a) {
        int c = 0;
        for (int i = 0; i < this.charge.cHtab[a].length; ++i) {
            int nb = this.charge.cHtab[a][i];
            if (nb >= this.atomCount || !this.charge.isInRing()[nb]) continue;
            ++c;
        }
        return c == 3;
    }

    private boolean isDoubleThreeCentered(Molecule m0, int a) {
        for (int i = 0; i < this.charge.cHtab[a].length; ++i) {
            int nb = this.charge.cHtab[a][i];
            if (nb >= this.atomCount || this.charge.delocAble[nb] != 1 || !this.charge.isInRing()[nb] || m0.getBond(this.charge.bHtab[a][nb]).getType() != 2 || !this.isThreeRingCentered(nb)) continue;
            return true;
        }
        return false;
    }

    private boolean isRingAliBond(Molecule m0, int a) {
        for (int i = 0; i < this.charge.cHtab[a].length; ++i) {
            int nb = this.charge.cHtab[a][i];
            if (nb >= this.atomCount || this.charge.delocAble[nb] != 1 || this.charge.isInRing()[nb] || m0.getBond(this.charge.bHtab[a][nb]).getType() != 2) continue;
            return true;
        }
        return false;
    }

    private boolean isExocyclicBond(Molecule m0, int a) {
        this.actExoAtom = -1;
        for (int i = 0; i < this.charge.cHtab[a].length; ++i) {
            int nb = this.charge.cHtab[a][i];
            if (nb >= this.atomCount || this.charge.isArA(nb) || m0.getBond(this.charge.bHtab[a][nb]).getType() != 2) continue;
            this.actExoAtom = nb;
            return true;
        }
        return false;
    }

    private void setFGScore(Molecule m0, int ai, int ti) {
        if (this.isKeteneCarbon(m0, ai)) {
            int n = ti;
            this.fgScore[n] = this.fgScore[n] + -0.5;
        } else if (this.charge.getPolarGroups().carboxy[ai] != -1) {
            int type = this.charge.getPolarGroups().carboxy[ai];
            int prop = this.charge.getPolarGroups().groupProperty[ai];
            int gType = this.charge.getPolarGroups().groupType[ai];
            if (this.isPyrroleLikeN(ai)) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
            }
            if (type == 2) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
            } else if (type == 100 || type == 1300) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
            } else if (type == 600 || type == 700) {
                if (prop != 3500) {
                    int n = ti;
                    this.fgScore[n] = this.fgScore[n] + 1.0;
                }
            } else if (type == 300) {
                if (gType == 870) {
                    int n = ti;
                    this.fgScore[n] = this.fgScore[n] + -0.5;
                } else if (prop != 600 && prop != 800) {
                    int n = ti;
                    this.fgScore[n] = this.fgScore[n] + 1.0;
                }
            } else if (gType == 850) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.5;
            } else if (type == 1000 || type == 400 || type == 800) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
            } else if (type == 1700 && prop == 3200) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + -1.0;
            } else if (type == 1700 && prop == -1) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 0.5;
            } else if (type == 200 && prop == 409) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
            } else if (type == 500 && prop == 409) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
            } else if (type == 200 && prop == 410) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
            } else if (type == 500 && prop == 410) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
            } else if (type == 200 && prop == 411) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
            } else if (type == 500 && prop == 411) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
            } else if (prop == 700) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
            } else if (type == 1 && prop != 1100) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
            } else if (prop == 422) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
            } else if (type == 1600) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
            } else if (type == 1500) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
            } else if (type == 1200) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 0.45;
            } else if (type == 900 && this.isSemiAraEsterCanBeFormed(m0, ai)) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + -0.5;
            }
        } else if (this.charge.isArA(ai)) {
            if (this.actCHG == 0) {
                if (this.isExocyclicBond(m0, ai)) {
                    int n = ti;
                    this.fgScore[n] = this.fgScore[n] + 0.5;
                } else {
                    int n = ti;
                    this.fgScore[n] = this.fgScore[n] + 1.0;
                }
            } else if (this.actCHG != 0) {
                if (this.charge.getSymbol(ai).equals("C")) {
                    int n = ti;
                    this.fgScore[n] = this.fgScore[n] + 0.5;
                } else {
                    int n = ti;
                    this.fgScore[n] = this.fgScore[n] + 0.85;
                }
            } else {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 0.85;
            }
        } else if (this.charge.sAra[ai] == 1) {
            if (this.actCHG == 0) {
                if (this.isExocyclicBond(m0, ai)) {
                    int n = ti;
                    this.fgScore[n] = this.fgScore[n] + 0.5;
                } else {
                    int n = ti;
                    this.fgScore[n] = this.fgScore[n] + 1.0;
                }
            } else if (this.actCHG != 0) {
                if (this.charge.getSymbol(ai).equals("C")) {
                    int n = ti;
                    this.fgScore[n] = this.fgScore[n] + 0.5;
                } else {
                    int n = ti;
                    this.fgScore[n] = this.fgScore[n] + 0.85;
                }
            } else {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 0.85;
            }
        } else if (this.actCHG > 0) {
            if (this.charge.getSymbol(ai).equals("N")) {
                if (this.isEXoNbExist(ai, m0)) {
                    int n = ti;
                    this.fgScore[n] = this.fgScore[n] + -0.5;
                }
            } else if (!this.charge.getSymbol(ai).equals("C") && this.isDBonded(m0, ai) && this.isMetalNbExist(ai, m0)) {
                int n = ti;
                this.fgScore[n] = this.fgScore[n] + 1.0;
            }
        }
    }

    private boolean isMetalNbExist(int ai, Molecule mm) {
        int L = this.charge.cHtab[ai].length;
        for (int i = 0; i < L; ++i) {
            MolAtom a;
            int pc;
            int nb = this.charge.cHtab[ai][i];
            if (nb >= this.atomCount || !CriticalErrorCalculation.isMetal(pc = (a = mm.getAtom(nb)).getAtno(), a)) continue;
            return true;
        }
        return false;
    }

    private boolean isEXoNbExist(int ai, Molecule mm) {
        int L = this.charge.cHtab[ai].length;
        for (int i = 0; i < L; ++i) {
            int nb = this.charge.cHtab[ai][i];
            if (nb >= this.atomCount || mm.getBond(this.charge.bHtab[ai][nb]).getType() != 2 || !this.isExocyclicBond(mm, nb)) continue;
            return true;
        }
        return false;
    }

    private boolean isSemiAraEsterCanBeFormed(Molecule m0, int ai) {
        int c = 0;
        int x = 0;
        for (int i = 0; i < this.charge.cHtab[ai].length; ++i) {
            int nb = this.charge.cHtab[ai][i];
            if (nb >= this.atomCount || !this.charge.isArA(nb)) continue;
            for (int j = 0; j < this.charge.cHtab[nb].length; ++j) {
                int nnb = this.charge.cHtab[nb][j];
                if (nnb >= this.atomCount || !this.charge.isArA(nnb)) continue;
                int pc = this.charge.atomArray[nnb].getAtno();
                int chg = this.charge.atomArray[nnb].getCharge();
                int L = this.charge.cHtab[nnb].length;
                if (chg != 0) continue;
                if (pc == 6 && L == 3) {
                    ++c;
                    continue;
                }
                if (pc == 7 && L == 2) {
                    ++c;
                    continue;
                }
                if (pc != 8 && pc != 16 && pc != 34 && pc != 52) continue;
                ++x;
            }
        }
        return c == 1 && x == 1;
    }

    private boolean isKeteneCarbon(Molecule m0, int ai) {
        if (this.charge.cHtab[ai].length == 2 && this.charge.atomArray[ai].getAtno() == 6 && !this.charge.isArA(ai)) {
            int c = 0;
            for (int i = 0; i < this.charge.cHtab[ai].length; ++i) {
                int t;
                int nb = this.charge.cHtab[ai][i];
                if (nb >= this.atomCount || (t = m0.getBond(this.charge.bHtab[ai][nb]).getType()) != 2) continue;
                ++c;
            }
            if (c == 2) {
                return true;
            }
        }
        return false;
    }

    private boolean isPyrroleLikeN(int ai) {
        int L;
        int ri;
        if (!this.charge.isInRing()[ai] && !this.charge.isArA(ai)) {
            return false;
        }
        if (!this.charge.getSymbol(ai).equals("N")) {
            return false;
        }
        if (this.charge.cHtab[ai].length == 2 && this.charge.atomArray[ai].getCharge() == 0) {
            return false;
        }
        if (this.charge.cHtab[ai].length == 3 && this.charge.atomArray[ai].getCharge() == 1) {
            return false;
        }
        if (this.charge.isArA(ai) && (ri = this.charge.findSmallestAraRing(ai)) != -1 && ((L = this.charge.aAtoms[ri].length) & 1) == 1) {
            return true;
        }
        ri = this.charge.getNonARingIndex(ai);
        int s = 0;
        if (ri != -1 && ((s = this.charge.isSemiAromaticRing(ri)) == 100 || s == 200) && ((L = this.charge.nonAring[ri].length) & 1) == 1) {
            if (this.charge.cHtab[ai].length == 3 && this.charge.atomArray[ai].getCharge() == 0) {
                return true;
            }
            if (this.charge.cHtab[ai].length == 2 && this.charge.atomArray[ai].getCharge() == -1) {
                return true;
            }
        }
        return false;
    }

    private boolean isNH(int ai) {
        if (this.charge.getSymbol(ai).equals("N")) {
            if (this.charge.cHtab[ai].length == 2) {
                return this.charge.atomArray[ai].getCharge() == -1;
            }
            if (this.charge.cHtab[ai].length == 3 && this.charge.atomArray[ai].getCharge() == 0) {
                return true;
            }
        }
        return false;
    }

    private int setDelocProxyScore(int ai) {
        int sumDist = 0;
        for (int i = 0; i < this.sphereSize; ++i) {
            int a = this.sphere[i];
            if (this.charge.delocAble[a] != 1 || a == ai) continue;
            sumDist += this.sAtom[a];
        }
        return sumDist;
    }

    public double calcTautomerScore(Molecule m) {
        int j;
        this.molCopy = m;
        Molecule m0 = m.cloneMoleculeWithDocument();
        this.tCount = 1;
        this.polarScore = new double[1];
        this.fgScore = new double[1];
        this.delocScore = new double[1];
        this.delocProxyScore = new int[1];
        this.aromScore = new double[1];
        this.delocRScore = new int[1];
        this.atomCount = m0.getAtomCount();
        double score = 0.0;
        this.usedAtom = new int[this.atomCount];
        this.charge = new Charge();
        m0.aromatize(2);
        this.charge.setMolecule(m0);
        this.charge.baseInfoAvailable = false;
        this.charge.setAromatizationType(2);
        this.charge.setChargeCalcType(true);
        this.charge.calcCharges();
        for (int k = 0; k < this.atomCount; ++k) {
            if (this.charge.hconj == null) {
                return score;
            }
            if (this.charge.hconj[k] != 1) continue;
            this.charge.delocAble[k] = -1;
        }
        this.polarScore[0] = 0.0;
        this.delocScore[0] = 0.0;
        this.delocRScore[0] = 0;
        this.fgScore[0] = 0.0;
        this.delocProxyScore[0] = 0;
        for (j = 0; j < this.atomCount; ++j) {
            this.usedAtom[j] = -1;
        }
        for (j = 0; j < this.atomCount; ++j) {
            if (this.charge.delocAble[j] == 1) {
                this.polarScore[0] = this.polarScore[0] + this.setAtomSphere(j, this.atomCount, 0.75);
                this.delocProxyScore[0] = this.delocProxyScore[0] + this.setDelocProxyScore(j);
                this.setDelocScore(m0, j, this.atomCount, 0);
                if (this.charge.isInRing()[j] && this.isDBonded(m0, j)) {
                    this.delocRScore[0] = this.delocRScore[0] + 1;
                }
            }
            MolAtom a = m0.getAtom(j);
            this.actCHG = a.getCharge();
            this.setFGScore(m0, j, 0);
        }
        this.setAromCountScore(m0, 0);
        score = 0.25 * (this.polarScore[0] + this.delocScore[0] + (double)this.delocRScore[0]) + this.fgScore[0] + this.aromScore[0];
        return score;
    }
}

