/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

import chemaxon.calculations.FunctionArea;
import chemaxon.marvin.modelling.struc.MolGeom;
import chemaxon.struc.MDocument;
import chemaxon.struc.MPoint;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.PeriodicSystem;
import chemaxon.struc.graphics.MPolyline;
import java.awt.Color;
import java.util.Vector;

class FunctionAreaGauss
extends FunctionArea {
    private Atom[] atoms;
    private Vector<Node> atomlist;
    private double distanceLimit = 2.9;
    private double distanceLimitThr = 0.1;
    private double ratioLimit = 0.89;
    private double ratioLimitThr = 0.02;
    int step = 0;
    Molecule m;
    boolean opt = true;
    int tot = 0;

    public FunctionAreaGauss(Molecule m, double distanceLimit, double distanceLimitThr, double ratioLimit, double ratioLimitThr) {
        this.m = m;
        this.atoms = new Atom[m.getAtomCount()];
        this.atomlist = new Vector();
        for (int i = 0; i < m.getAtomCount(); ++i) {
            MolAtom a = m.getAtom(i);
            double vdw = PeriodicSystem.getVanDerWaalsRadius(a.getAtno());
            this.atoms[i] = new Atom(new double[]{a.getX(), a.getY(), a.getZ()}, vdw);
        }
        this.distanceLimit = distanceLimit;
        this.distanceLimitThr = distanceLimitThr;
        this.ratioLimit = ratioLimit;
        this.ratioLimitThr = ratioLimitThr;
    }

    @Override
    public boolean setVariables(double[] var) {
        MolGeom.arrayCopy(var, this.variables);
        this.atomlist.clear();
        for (int i = 0; i < this.atoms.length; ++i) {
            this.atoms[i].resetParameters();
            this.atoms[i].projectOnPlane();
            if (this.opt) {
                this.add(this.atoms[i]);
                continue;
            }
            this.addSimple(this.atoms[i]);
        }
        return true;
    }

    @Override
    public Molecule outputAsMol() {
        MPoint mp2 = new MPoint(0.0, 0.0, 0.0);
        MPoint mp1 = new MPoint(this.variables[0], this.variables[1], this.variables[2]);
        MPolyline arrow = new MPolyline(mp1, mp2);
        arrow.setArrow(true);
        arrow.setArrowLength(MPolyline.HEAD, 0.8);
        arrow.setArrowWidth(MPolyline.HEAD, 0.5);
        MDocument md = this.m.getDocument();
        md = new MDocument(this.m);
        md.addObject(arrow);
        return this.m;
    }

    private void add(Atom g) {
        int count = 0;
        int max = this.atomlist.size();
        double overlap = 0.0;
        while (count < max) {
            double rlimit;
            int n = count++;
            Node gs = this.atomlist.get(n);
            double rSQ = g.getDistSQ(gs);
            double r = Math.sqrt(rSQ);
            double s = FunctionAreaGauss.scale(r - (rlimit = (g.radius + gs.radius) * this.distanceLimit), this.distanceLimitThr);
            if (!(s > 0.0)) continue;
            Product p = new Product(g, gs, rSQ);
            p.p *= s;
            overlap += p.integral2D();
            this.atomlist.add(p);
        }
        if (max > 0) {
            double rat = Math.abs(overlap / g.integral2D());
            double s = FunctionAreaGauss.scale(rat - this.ratioLimit, this.ratioLimitThr);
            if (s == 0.0) {
                this.atomlist.setSize(max);
                return;
            }
            if (s != 1.0) {
                for (int i = max; i < this.atomlist.size(); ++i) {
                    Product node = (Product)this.atomlist.elementAt(i);
                    node.p *= s;
                }
                g.p *= s;
            }
        }
        this.atomlist.add(g);
    }

    private void addSimple(Atom g) {
        int count = 0;
        int max = this.atomlist.size();
        double overlap = 0.0;
        while (count < max) {
            double rlimit;
            double rlimitSQ;
            int n = count++;
            Node gs = this.atomlist.get(n);
            double rSQ = g.getDistSQ(gs);
            if (!(rSQ < (rlimitSQ = (rlimit = (g.radius + gs.radius) * this.distanceLimit + this.distanceLimitThr) * rlimit))) continue;
            Product p = new Product(g, gs, rSQ);
            overlap += p.integral2D();
            this.atomlist.add(p);
        }
        double rat = Math.abs(overlap / g.integral2D());
        if (rat > this.ratioLimit + this.ratioLimitThr) {
            this.atomlist.setSize(max);
            return;
        }
        this.atomlist.add(g);
    }

    @Override
    public double getFunctionValue() {
        double f = 0.0;
        for (Node node : this.atomlist) {
            f += node.integral2D() * this.sign;
        }
        return f;
    }

    @Override
    public double[] getFunctionGradient() {
        ++this.step;
        this.getNumericDerivate(this.gradient);
        return this.gradient;
    }

    double maxRadius() {
        double radius = -1.0;
        for (int i = 0; i < this.atoms.length - 1; ++i) {
            for (int j = i + 1; j < this.atoms.length; ++j) {
                double d = (Math.sqrt(this.atoms[i].getDistSQ(this.atoms[j])) + this.atoms[i].radius + this.atoms[j].radius) / 2.0;
                if (radius != -1.0 && !(d > radius)) continue;
                radius = d;
            }
        }
        return radius;
    }

    double maxZ() {
        MolGeom.normalize(this.variables);
        double[] tmp = new double[3];
        double maxZ = -1.0;
        for (int i = 0; i < this.atoms.length - 1; ++i) {
            for (int j = i + 1; j < this.atoms.length; ++j) {
                MolGeom.minusVec(this.atoms[i].xyz, this.atoms[j].xyz, tmp);
                double d = Math.abs(MolGeom.dot3D(tmp, this.variables)) + this.atoms[i].radius + this.atoms[j].radius;
                if (!(d > maxZ)) continue;
                maxZ = d;
            }
        }
        return maxZ;
    }

    void addCirclePointCoordinates(MDocument md, Color c) {
        int pointsPerCircle = 40;
        double[] ci = new double[3];
        double[] cj = new double[3];
        double[] center = new double[3];
        double[] nnorm = new double[3];
        int imax = 0;
        int jmax = 0;
        double radius = -1.0;
        for (int i = 0; i < this.atoms.length - 1; ++i) {
            for (int j = i + 1; j < this.atoms.length; ++j) {
                double d = (Math.sqrt(this.atoms[i].getDistSQ(this.atoms[j])) + this.atoms[i].radius + this.atoms[j].radius) / 2.0;
                if (!(d > radius)) continue;
                radius = d;
                imax = i;
                jmax = j;
            }
        }
        double ri = this.atoms[imax].radius;
        double rj = this.atoms[jmax].radius;
        MolGeom.minusVec(this.atoms[imax].pxyz, this.atoms[jmax].pxyz, ci);
        double li = MolGeom.getLength(ci);
        MolGeom.arrayCopy(ci, cj);
        MolGeom.mul(ci, (li + ri) / li);
        MolGeom.mul(cj, -rj / li);
        MolGeom.plusVec(cj, this.atoms[jmax].pxyz, cj);
        MolGeom.plusVec(ci, this.atoms[jmax].pxyz, ci);
        MolGeom.plusVec(ci, cj, center);
        MolGeom.mul(center, 0.5);
        MolGeom.arrayCopy(this.variables, nnorm);
        MolGeom.normalize(nnorm);
        MolGeom.arrayCopy(ci, cj);
        Object crds = new double[][]{MolGeom.arrayCopy(ci)};
        double p = (double)pointsPerCircle * radius;
        double theta = Math.PI * 2 / p;
        int i = 1;
        while ((double)i < p) {
            crds = MolGeom.rot(crds, theta, center[0], center[1], center[2], nnorm[0], nnorm[1], nnorm[2]);
            MPoint mp = new MPoint(cj[0], cj[1], cj[2]);
            MPoint mp2 = new MPoint(crds[0][0], crds[0][1], crds[0][2]);
            MPolyline l = new MPolyline(mp, mp2, c, c);
            md.addObject(l);
            MolGeom.arrayCopy(crds[0], cj);
            ++i;
        }
        MPoint mp = new MPoint(cj[0], cj[1], cj[2]);
        MPoint mp2 = new MPoint(ci[0], ci[1], ci[2]);
        MPolyline l = new MPolyline(mp, mp2, c, c);
        md.addObject(l);
        MolGeom.arrayCopy(crds[0], cj);
    }

    private class Product
    extends Node {
        Product(Node g1, Node g2, double rSQ) {
            this.a = g1.getA() + g2.getA();
            this.p = -1.0 * g1.getP() * g2.getP() * Math.exp(-g1.getA() * g2.getA() * rSQ / this.a);
            this.pxyz[0] = (g1.getA() * g1.pxyz[0] + g2.getA() * g2.pxyz[0]) / this.a;
            this.pxyz[1] = (g1.getA() * g1.pxyz[1] + g2.getA() * g2.pxyz[1]) / this.a;
            this.pxyz[2] = (g1.getA() * g1.pxyz[2] + g2.getA() * g2.pxyz[2]) / this.a;
            this.radius = Math.sqrt(Math.abs(this.p / this.a));
        }
    }

    private class Node {
        double[] pxyz = new double[3];
        double a;
        double p;
        double radius;

        public double integral2D() {
            return this.p * Math.PI / this.a;
        }

        public double getA() {
            return this.a;
        }

        public double getP() {
            return this.p;
        }

        public double getDistSQ(Node a) {
            double abx = this.pxyz[0] - a.pxyz[0];
            double aby = this.pxyz[1] - a.pxyz[1];
            double abz = this.pxyz[2] - a.pxyz[2];
            return abx * abx + aby * aby + abz * abz;
        }

        public double getRadius() {
            return this.radius;
        }
    }

    class Atom
    extends Node {
        double[] xyz;
        double pOrig;
        double aOrig;

        public Atom(double[] xyz, double vdw) {
            this.xyz = xyz;
            this.p = 2.05477;
            this.a = this.p / vdw / vdw;
            this.pOrig = this.p;
            this.aOrig = this.a;
            this.radius = vdw;
        }

        public void resetParameters() {
            this.p = this.pOrig;
            this.a = this.aOrig;
        }

        public void projectOnPlane() {
            MolGeom.parallelToPlaneUnnormalized(this.xyz, this.pxyz, FunctionAreaGauss.this.variables[0], FunctionAreaGauss.this.variables[1], FunctionAreaGauss.this.variables[2]);
        }

        @Override
        public double integral2D() {
            return super.integral2D();
        }
    }
}

