/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

import chemaxon.calculations.ProjectedSurfaceArea;
import chemaxon.calculations.VanDerWaalsVolume;
import chemaxon.calculations.clean.Cleaner;
import chemaxon.calculations.hydrogenize.Hydrogenize;
import chemaxon.common.util.GeomCalc;
import chemaxon.common.util.MProgressMonitor;
import chemaxon.marvin.modelling.linalg.GradientOptimization;
import chemaxon.marvin.modelling.mm.mmff94.MMFF94;
import chemaxon.marvin.modelling.mm.mmff94.MMFF94Exception;
import chemaxon.struc.Molecule;
import chemaxon.struc.PeriodicSystem;
import chemaxon.util.DDistanceMatrix;

public class Geometry {
    private Molecule mol;
    private boolean lecc = false;
    private double conformerEnergy = Double.NEGATIVE_INFINITY;
    private MMFF94 mmff;
    private double mmff94Energy;
    private int inputMolDim;
    private DDistanceMatrix dtab;
    private String optlimit = "1";
    private ProjectedSurfaceArea proj;
    private MProgressMonitor progressMonitor = null;
    private VanDerWaalsVolume volume;
    private boolean accuratemode = false;
    private String licenseEnvironment;

    public void setMolecule(Molecule mol) {
        this.inputMolDim = mol.getDim();
        this.mol = mol.cloneMolecule();
        Hydrogenize.addHAtoms(this.mol);
        this.dtab = null;
    }

    public void setProgressMonitor(MProgressMonitor pmon) {
        this.progressMonitor = pmon;
    }

    public Molecule get3DMolecule() {
        return this.mol != null && this.mol.getDim() == 3 ? this.mol : null;
    }

    public int getInputMolDim() {
        return this.inputMolDim;
    }

    public void setOptimization(int opt) {
        this.optlimit = Integer.toString(opt);
    }

    public boolean calculateLowestEnergyConformer() {
        boolean success;
        this.lecc = success = Cleaner.clean(this.mol, 3, "c3S{fine}L{" + this.optlimit + "}E", this.progressMonitor);
        String energyStr = this.mol.getProperty("Energy");
        if (energyStr != null) {
            if (energyStr.equals("CLEAN3D_ABORTED")) {
                this.conformerEnergy = Double.NaN;
                this.mol = null;
                return false;
            }
            if (energyStr.equals("CLEAN3D_FAILED")) {
                this.conformerEnergy = Double.POSITIVE_INFINITY;
                this.mol = null;
                return false;
            }
            this.conformerEnergy = Double.parseDouble(energyStr);
        }
        return success;
    }

    public Molecule getLowestEnergyConformer() {
        return this.lecc ? this.mol : null;
    }

    public void calculateDreidingEnergy() {
        Cleaner.clean(this.mol, 3, "c2L{" + this.optlimit + "}E");
        String energyStr = this.mol.getProperty("Energy");
        if (energyStr != null) {
            this.conformerEnergy = energyStr.equals("CLEAN3D_ABORTED") ? Double.NaN : (energyStr.equals("CLEAN3D_FAILED") ? Double.POSITIVE_INFINITY : Double.parseDouble(energyStr));
        }
    }

    public double dreidingEnergy() {
        return this.conformerEnergy;
    }

    public boolean calculateMMFF94Energy(boolean optimize) throws GradientOptimization.GradientOptimizationException, MMFF94Exception {
        if (this.mmff == null) {
            this.mmff = new MMFF94();
        }
        if (!this.mmff.init(this.mol)) {
            return false;
        }
        if (optimize && !this.mmff.optimize()) {
            return false;
        }
        this.mmff94Energy = this.mmff.getEnergy();
        return !Double.isNaN(this.mmff94Energy);
    }

    public double getMMFF94Energy() {
        return this.mmff94Energy;
    }

    public double getMaxZ() {
        return this.proj.getMaxZ();
    }

    public double getMinZ() {
        return this.proj.getMinZ();
    }

    private void initializeDistanceMatrix() {
        int n = this.mol.getAtomCount();
        this.dtab = new DDistanceMatrix(n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                this.dtab.setDistance(i, j, this.mol.getAtom(i).getLocation().distance(this.mol.getAtom(j).getLocation()));
            }
        }
    }

    public double distance(int atom1, int atom2) {
        if (this.dtab == null) {
            double[] a1 = new double[]{this.mol.getAtom(atom1).getX(), this.mol.getAtom(atom1).getY(), this.mol.getAtom(atom1).getZ()};
            double[] a2 = new double[]{this.mol.getAtom(atom2).getX(), this.mol.getAtom(atom2).getY(), this.mol.getAtom(atom2).getZ()};
            return GeomCalc.distance(a1, a2);
        }
        return this.dtab.getDistance(atom1, atom2);
    }

    public double angle(int atom1, int atom2, int atom3) {
        double[] a1 = new double[]{this.mol.getAtom(atom1).getX(), this.mol.getAtom(atom1).getY(), this.mol.getAtom(atom1).getZ()};
        double[] a2 = new double[]{this.mol.getAtom(atom2).getX(), this.mol.getAtom(atom2).getY(), this.mol.getAtom(atom2).getZ()};
        double[] a3 = new double[]{this.mol.getAtom(atom3).getX(), this.mol.getAtom(atom3).getY(), this.mol.getAtom(atom3).getZ()};
        return GeomCalc.angle(a1, a2, a3);
    }

    public double dihedral(int atom1, int atom2, int atom3, int atom4) {
        double[] a1 = new double[]{this.mol.getAtom(atom1).getX(), this.mol.getAtom(atom1).getY(), this.mol.getAtom(atom1).getZ()};
        double[] a2 = new double[]{this.mol.getAtom(atom2).getX(), this.mol.getAtom(atom2).getY(), this.mol.getAtom(atom2).getZ()};
        double[] a3 = new double[]{this.mol.getAtom(atom3).getX(), this.mol.getAtom(atom3).getY(), this.mol.getAtom(atom3).getZ()};
        double[] a4 = new double[]{this.mol.getAtom(atom4).getX(), this.mol.getAtom(atom4).getY(), this.mol.getAtom(atom4).getZ()};
        return GeomCalc.dihedral(a1, a2, a3, a4);
    }

    public double longestAtomDistance() {
        return this.dtab.getMaxDistance();
    }

    public double stericHindrance(int a) {
        if (this.dtab == null) {
            this.initializeDistanceMatrix();
        }
        double h = 0.0;
        double crad = PeriodicSystem.getCovalentRadius(6);
        for (int i = 0; i < this.dtab.length(); ++i) {
            if (i == a || this.dtab.getDistance(a, i) == 0.0) continue;
            double r = PeriodicSystem.getCovalentRadius(this.mol.getAtom(i).getAtno()) / crad;
            h += r * r * r / (this.dtab.getDistance(a, i) * this.dtab.getDistance(a, i) * this.dtab.getDistance(a, i));
        }
        return h;
    }

    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    public void calculateMoleculeProjection() {
        if (this.proj == null) {
            this.proj = new ProjectedSurfaceArea();
        }
        this.proj.setLicenseEnvironment(this.licenseEnvironment);
        this.proj.setAccurateMode(this.accuratemode);
        this.proj.setMolecule(this.mol);
        this.proj.run();
    }

    public double getMinimalArea() {
        return this.proj.getMinArea();
    }

    public double getMaximalArea() {
        return this.proj.getMaxArea();
    }

    public double getMinimalRadius() {
        return this.proj.getMinRadius();
    }

    public double getMaximalRadius() {
        return this.proj.getMaxRadius();
    }

    public void setAccurateMode(boolean acc) {
        this.accuratemode = acc;
    }

    public void volume() {
        if (this.volume == null) {
            this.volume = new VanDerWaalsVolume();
        }
        this.volume.setLicenseEnvironment(this.licenseEnvironment);
        this.volume.setMolecule(this.mol);
        this.volume.run();
    }

    public double getVolume() {
        return this.volume.getVolume();
    }

    public Molecule getMoleculeWithCirclesAndVectors() {
        return this.proj.getMoleculeWithCirclesAndVectors();
    }
}

