/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

import chemaxon.calculations.Aza;
import chemaxon.calculations.Charge;
import chemaxon.calculations.PolarGroups;
import chemaxon.calculations.Tautomerization;
import chemaxon.core.calculations.LonePairCounter;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;

public class HMO {
    LonePairCounter LPc;
    private double P1;
    private double P2;
    private double P3;
    private double P4;
    private Tautomerization res;
    private PolarGroups pg;
    private Charge chg;
    private double[][] a;
    public double[][] EigenVector;
    private double[] real;
    private double[] EigenValue;
    private int[] hyperC;
    private int[] carboxy;
    private int[] azaA;
    private int[] electrons;
    private double[] qh;
    private double[] pic;
    private double[] piCdens;
    private int[] sigmaC;
    public int[] map;
    private double[] d;
    private double[] e;
    public int[] orbType;
    private int[] moe;
    int ne = 0;
    public int islandECount = -1;
    public int islandACount = -1;
    public int islandChg = 0;
    boolean radical = false;
    boolean takeResonance = false;
    boolean resCalculated;
    boolean allowResParam = false;
    protected Molecule mol;
    protected Molecule oMol;
    protected Molecule resMol;
    boolean standardHMO = false;
    public double piEnergy;
    private boolean simpleHMO = true;
    protected boolean calcStatus = true;
    private int ParamSet = 1;
    int chgIsland;
    int initChgP;
    int initChgN;
    final int UNCHARGED = 0;
    final int CHARGED = 2;
    final int NEGATIVE = -1;
    final int POSITIVE = 1;
    private MolAtom[] atomArray;
    private int eCorrection = 0;
    private int aCorrection = 0;
    private int[] sa;
    private int[][] bHtab;
    private int[][] cHtab;
    double[] singleAtomE;
    private int maxDelocLength;
    private int MOLATOMS;
    public final int HOMO = 1;
    public final int LUMO = 2;
    public final int BONDING = 3;
    public final int NONBONDING = 4;
    public final int ANTIBONDING = 5;
    int nelectrons;
    int natoms;
    int netcharge;
    int actEcount;
    int addedchg;
    double actFGValue;
    private final int RNO = 1200;
    private final int ARNO2 = 1300;
    private final int CONH2 = 200;
    private final int NO2 = 100;
    private final int RNHSO2 = 800;
    private final int CARBOXYL = 300;
    private final int CYANO = 400;
    final double[] resonance = new double[]{1.8, 1.2, 0.9, 1.0, 1.6, 0.9};
    final double[] coulomb = new double[]{1.6, 1.5, 1.8, 0.7, 1.0};
    boolean enuCalc = false;
    double[][] Kres = new double[][]{{1.0, 0.73, 1.02, 0.89, 1.06, 0.66, 0.52, 0.75, 0.77, 0.76, 0.81, 0.69, 0.62}, {0.73, 0.87, 0.66, 0.53, 0.6, 0.35, 0.26, 0.57, 0.53, 0.54, 0.51, 0.44, 0.41}, {1.02, 0.66, 1.09, 0.99, 1.14, 0.8, 0.65, 0.72, 0.78, 0.81, 0.83, 0.78, 0.77}, {0.89, 0.53, 0.99, 0.98, 1.13, 0.89, 0.77, 0.43, 0.55, 0.64, 0.68, 0.73, 0.8}, {1.06, 0.6, 1.14, 1.13, 1.26, 1.02, 0.92, 0.65, 0.75, 0.82, 0.84, 0.85, 0.88}, {0.66, 0.35, 0.8, 0.89, 1.02, 0.95, 0.94, 0.24, 0.31, 0.39, 0.43, 0.54, 0.7}, {0.52, 0.26, 0.65, 0.77, 0.92, 0.94, 1.04, 0.17, 0.21, 0.22, 0.28, 0.32, 0.51}, {0.75, 0.57, 0.72, 0.43, 0.65, 0.24, 0.17, 0.64, 0.62, 0.52, 0.61, 0.4, 0.34}, {0.77, 0.53, 0.78, 0.55, 0.75, 0.31, 0.21, 0.62, 0.63, 0.58, 0.65, 0.48, 0.35}, {0.76, 0.54, 0.81, 0.64, 0.82, 0.39, 0.22, 0.52, 0.58, 0.63, 0.65, 0.6, 0.55}, {0.81, 0.51, 0.83, 0.68, 0.84, 0.43, 0.28, 0.61, 0.65, 0.65, 0.68, 0.58, 0.52}, {0.69, 0.44, 0.78, 0.73, 0.85, 0.54, 0.32, 0.4, 0.48, 0.6, 0.58, 0.63, 0.59}, {0.62, 0.41, 0.77, 0.8, 0.88, 0.7, 0.51, 0.34, 0.35, 0.55, 0.52, 0.59, 0.68}};
    double[] HCol = new double[]{0.0, -0.45, 0.51, 1.37, 0.97, 2.09, 2.71, 0.0, 0.19, 0.75, 0.46, 1.11, 1.48};

    public HMO() {
    }

    public HMO(Molecule m) {
        this.mol = m;
    }

    public void setMolecule(Molecule m) {
        this.mol = m;
    }

    protected void setStdHMOCalc(boolean stdHMO) {
        this.standardHMO = stdHMO;
    }

    protected void setTakeResonance(boolean takeRes) {
        this.takeResonance = takeRes;
        this.takeResonance = false;
    }

    protected void setENuCalc(boolean enuc) {
        this.enuCalc = enuc;
    }

    private void transformMatrix(double[][] a, double[] d, double[] e) {
        int k;
        int j;
        double g;
        int l;
        int N;
        int i;
        for (i = N = a[0].length - 1; i >= 2; --i) {
            l = i - 1;
            double h = 0.0;
            double scale = 0.0;
            if (l > 1) {
                int k2;
                for (k2 = 1; k2 <= l; ++k2) {
                    scale += Math.abs(a[i][k2]);
                }
                if (scale == 0.0) {
                    e[i] = a[i][l];
                } else {
                    for (k2 = 1; k2 <= l; ++k2) {
                        a[i][k2] = a[i][k2] / scale;
                        h += a[i][k2] * a[i][k2];
                    }
                    double f = a[i][l];
                    g = f >= 0.0 ? -Math.sqrt(h) : Math.sqrt(h);
                    e[i] = scale * g;
                    h -= f * g;
                    a[i][l] = f - g;
                    f = 0.0;
                    for (j = 1; j <= l; ++j) {
                        a[j][i] = a[i][j] / h;
                        g = 0.0;
                        for (k = 1; k <= j; ++k) {
                            g += a[j][k] * a[i][k];
                        }
                        for (k = j + 1; k <= l; ++k) {
                            g += a[k][j] * a[i][k];
                        }
                        e[j] = g / h;
                        f += e[j] * a[i][j];
                    }
                    double hh = f / (h + h);
                    for (j = 1; j <= l; ++j) {
                        f = a[i][j];
                        e[j] = g = e[j] - hh * f;
                        for (k = 1; k <= j; ++k) {
                            double[] dArray = a[j];
                            int n = k;
                            dArray[n] = dArray[n] - (f * e[k] + g * a[i][k]);
                        }
                    }
                }
            } else {
                e[i] = a[i][l];
            }
            d[i] = h;
        }
        d[1] = 0.0;
        e[1] = 0.0;
        for (i = 1; i <= N; ++i) {
            l = i - 1;
            if (d[i] != 0.0) {
                for (j = 1; j <= l; ++j) {
                    g = 0.0;
                    for (k = 1; k <= l; ++k) {
                        g += a[i][k] * a[k][j];
                    }
                    for (k = 1; k <= l; ++k) {
                        double[] dArray = a[k];
                        int n = j;
                        dArray[n] = dArray[n] - g * a[k][i];
                    }
                }
            }
            d[i] = a[i][i];
            a[i][i] = 1.0;
            for (j = 1; j <= l; ++j) {
                a[i][j] = 0.0;
                a[j][i] = 0.0;
            }
        }
    }

    public void setRequiredParameterType(int rpt) {
        this.ParamSet = rpt;
    }

    public void setHMOCalcType(boolean calcType) {
        this.simpleHMO = calcType;
    }

    public void setHMOVariables(int atoms, Molecule mol, int[] sphereA, int mdl, int[] hpc, int[] carb) {
        this.atomArray = mol.getAtomArray();
        this.cHtab = mol.createCHtab();
        this.bHtab = mol.createBHtab();
        this.MOLATOMS = atoms;
        this.hyperC = new int[this.MOLATOMS];
        this.carboxy = new int[this.MOLATOMS];
        this.sa = new int[this.MOLATOMS];
        this.azaA = Aza.calculate(mol);
        for (int i = 0; i < this.MOLATOMS; ++i) {
            this.sa[i] = sphereA[i];
            this.hyperC[i] = hpc[i];
            this.carboxy[i] = carb[i];
        }
        this.maxDelocLength = mdl;
    }

    public void setAddedCharge(int adchg) {
        this.addedchg = adchg;
    }

    private int getNetIslandCharge() {
        return this.netcharge;
    }

    private void initCalc(Molecule m) {
        int size = this.maxDelocLength;
        this.a = new double[size + 1][size + 1];
        this.map = new int[this.MOLATOMS];
        int k = 1;
        this.piEnergy = 0.0;
        int nchg = 0;
        int pchg = 0;
        this.chgIsland = 0;
        this.resCalculated = false;
        this.singleAtomE = new double[this.MOLATOMS];
        for (int i = 0; i < this.MOLATOMS; ++i) {
            this.singleAtomE[i] = 0.0;
            if (this.getSphereAtomIndex(i) == -1) continue;
            this.map[i] = k++;
            int chg = this.atomArray[i].getCharge();
            if (chg < 0) {
                ++nchg;
                continue;
            }
            if (chg <= 0) continue;
            ++pchg;
        }
        if (this.standardHMO) {
            if (pchg == nchg) {
                this.netcharge = 0;
            } else if (nchg > pchg) {
                this.netcharge = -1;
            } else if (pchg > nchg) {
                this.netcharge = 1;
            }
        }
        if (!this.standardHMO) {
            this.initChgP = pchg;
            this.initChgN = nchg;
            if (nchg != 0 || pchg != 0) {
                if (nchg != 0 && pchg != 0) {
                    if (this.takeResonance) {
                        this.generateResStructure();
                    }
                } else if (nchg > pchg) {
                    this.chgIsland = -1;
                } else if (pchg > nchg) {
                    this.chgIsland = 1;
                }
            }
        }
        this.setCalcStatus(k);
        if (this.calcStatus) {
            if (!this.standardHMO) {
                this.setSigmaSceleton();
                this.setSecularDeterminant();
            } else {
                this.setStandardSigmaSceleton();
                this.setStandardSecularDeterminant();
            }
        } else {
            this.setFinishInfo();
        }
    }

    private void setFinishInfo() {
        this.electrons = new int[this.MOLATOMS];
        this.sigmaC = new int[this.MOLATOMS];
    }

    private boolean isDelocNbExist(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.MOLATOMS || this.getSphereAtomIndex(nb) == -1) continue;
            return true;
        }
        return false;
    }

    protected boolean isNewResStrucGenerated() {
        return this.resCalculated;
    }

    protected Molecule getNewResStruct() {
        return this.resMol;
    }

    private void generateResStructure() {
        int i;
        this.oMol = this.mol.cloneMoleculeWithDocument();
        this.mol.dearomatize();
        this.mol.aromatize(2);
        int H = this.a.length - 1;
        this.res = new Tautomerization();
        this.res.setMolecule(this.mol);
        this.res.setSymmetryFiltering(false);
        this.res.setImplicitizeFlag(false);
        this.res.setResonantCalc(true);
        this.res.setMajorResonantCalc(true);
        this.res.setMaxSpeciesCount(200);
        this.res.setCanReso(true);
        this.res.createDACouples();
        this.res.setResChargeCalc(false);
        this.res.setImplicitizeFlag(true);
        int resCount = this.res.getTCount();
        this.res.setCanReso(false);
        if (resCount == 1) {
            resCount = 0;
            this.mol = this.oMol;
            return;
        }
        int c = 0;
        int minChg = 1000;
        int minInd = -1;
        int minChgP = 0;
        int minChgN = 0;
        for (i = 0; i < resCount; ++i) {
            this.mol = this.res.getTMolecule(i);
            int nchg = 0;
            int pchg = 0;
            c = 0;
            int radCount = 0;
            for (int j = 0; j < this.MOLATOMS; ++j) {
                if (this.map[j] == 0) continue;
                MolAtom a = this.mol.getAtom(j);
                int chg = a.getCharge();
                radCount += a.getRadicalCount();
                if (chg == 0) continue;
                ++c;
                if (chg < 0) {
                    ++nchg;
                    continue;
                }
                ++pchg;
            }
            if (c >= minChg || radCount != 0) continue;
            minChg = c;
            minInd = i;
            minChgP = pchg;
            minChgN = nchg;
        }
        if (minInd != -1) {
            if (minChgP != 0 && minChgN != 0) {
                this.mol = this.oMol;
                this.chgIsland = 2;
                return;
            }
            if (minChgN > minChgP) {
                this.chgIsland = -1;
            } else if (minChgP > minChgN) {
                this.chgIsland = 1;
            } else if (minChgP == minChgN) {
                this.chgIsland = 0;
            }
            this.mol = this.res.getTMolecule(minInd);
            this.mol.aromatize(1);
            this.atomArray = this.mol.getAtomArray();
            this.cHtab = this.mol.createCHtab();
            this.bHtab = this.mol.createBHtab();
            this.pg = new PolarGroups(this.mol);
            this.pg.setGroups();
            for (i = 0; i < this.MOLATOMS; ++i) {
                this.carboxy[i] = this.pg.carboxy[i];
            }
            this.resCalculated = true;
            this.resMol = this.mol.cloneMoleculeWithDocument();
        } else {
            this.mol = this.oMol;
        }
    }

    private double getSingleAtomColumb_h(int ai) {
        MolAtom a = this.mol.getAtom(ai);
        int pc = a.getAtno();
        int impHc = a.getImplicitHcount();
        int chg = a.getCharge();
        this.actEcount = 0;
        switch (pc) {
            case 6: {
                return this.HCol[0];
            }
            case 5: {
                if (chg < 0) {
                    this.actEcount = 2;
                }
                return this.HCol[1];
            }
            case 7: {
                if (chg < 0 || chg == 0) {
                    this.actEcount = 2;
                    return this.HCol[3];
                }
                return 0.0;
            }
            case 8: {
                if (chg < 0 || chg == 0) {
                    this.actEcount = 2;
                    return this.HCol[5];
                }
                return 0.0;
            }
            case 9: {
                this.actEcount = 2;
                return this.HCol[6];
            }
            case 14: {
                if (chg < 0) {
                    this.actEcount = 2;
                }
                return this.HCol[7];
            }
            case 15: {
                if (chg < 0 || chg == 0) {
                    this.actEcount = 2;
                    return this.HCol[9];
                }
                return 0.0;
            }
            case 16: {
                if (chg < 0 || chg == 0) {
                    this.actEcount = 2;
                    return this.HCol[11];
                }
                return 0.0;
            }
            case 17: {
                this.actEcount = 2;
                return this.HCol[12];
            }
        }
        return 0.0;
    }

    private double getCoulomb_h(int ai) {
        MolAtom a = this.mol.getAtom(ai);
        int pc = a.getAtno();
        switch (pc) {
            case 6: {
                return this.HCol[0];
            }
            case 5: {
                return this.HCol[1];
            }
            case 7: {
                if (this.isN1(a)) {
                    return this.HCol[2];
                }
                return this.HCol[3];
            }
            case 8: {
                if (this.isO1(a)) {
                    return this.HCol[4];
                }
                return this.HCol[5];
            }
            case 9: {
                return this.HCol[6];
            }
            case 14: {
                return this.HCol[7];
            }
            case 15: {
                if (this.isP1(a)) {
                    return this.HCol[8];
                }
                return this.HCol[9];
            }
            case 16: {
                if (this.isS1(a)) {
                    return this.HCol[10];
                }
                return this.HCol[11];
            }
            case 17: {
                return this.HCol[12];
            }
        }
        return 0.0;
    }

    private boolean isN1(MolAtom ai) {
        int impHc = ai.getImplicitHcount();
        int nbc = this.getNbCount(ai) + impHc;
        int chg = ai.getCharge();
        int exc = this.getElectronCorrection();
        int axc = this.getAtomCorrection();
        if (nbc == 1) {
            return true;
        }
        if (nbc == 2) {
            return true;
        }
        if (nbc == 3) {
            return false;
        }
        return false;
    }

    private boolean isO1(MolAtom ai) {
        int impHc = ai.getImplicitHcount();
        int nbc = this.getNbCount(ai) + impHc;
        int chg = ai.getCharge();
        int exc = this.getElectronCorrection();
        int axc = this.getAtomCorrection();
        return nbc == 1;
    }

    private boolean isP1(MolAtom a) {
        int impHc = a.getImplicitHcount();
        int nbc = this.getNbCount(a) + impHc;
        boolean c = false;
        if (nbc == 1) {
            return true;
        }
        return nbc == 2;
    }

    private boolean isS1(MolAtom a) {
        int impHc = a.getImplicitHcount();
        int nbc = this.getNbCount(a) + impHc;
        boolean c = false;
        return nbc == 1;
    }

    private double getResonant_k(int a0, int ai) {
        MolAtom a = this.mol.getAtom(a0);
        int pc = a.getAtno();
        switch (pc) {
            case 6: {
                return this.getKres(0, ai);
            }
            case 5: {
                return this.getKres(1, ai);
            }
            case 7: {
                if (this.isN1(a)) {
                    return this.getKres(2, ai);
                }
                return this.getKres(3, ai);
            }
            case 8: {
                if (this.isO1(a)) {
                    return this.getKres(4, ai);
                }
                return this.getKres(5, ai);
            }
            case 9: {
                return this.getKres(6, ai);
            }
            case 14: {
                return this.getKres(7, ai);
            }
            case 15: {
                if (this.isP1(a)) {
                    return this.getKres(8, ai);
                }
                return this.getKres(9, ai);
            }
            case 16: {
                if (this.isS1(a)) {
                    return this.getKres(10, ai);
                }
                return this.getKres(11, ai);
            }
            case 17: {
                return this.getKres(12, ai);
            }
        }
        return 1.0;
    }

    private double getKres(int indx, int ai) {
        MolAtom other = this.mol.getAtom(ai);
        int pc_other = other.getAtno();
        switch (pc_other) {
            case 6: {
                return this.Kres[indx][0];
            }
            case 7: {
                if (this.isN1(other)) {
                    return this.Kres[indx][2];
                }
                return this.Kres[indx][3];
            }
            case 8: {
                if (this.isO1(other)) {
                    return this.Kres[indx][4];
                }
                return this.Kres[indx][5];
            }
            case 5: {
                return this.Kres[indx][1];
            }
            case 9: {
                return this.Kres[indx][6];
            }
            case 14: {
                return this.Kres[indx][7];
            }
            case 15: {
                if (this.isP1(other)) {
                    return this.Kres[indx][8];
                }
                return this.Kres[indx][9];
            }
            case 16: {
                if (this.isS1(other)) {
                    return this.Kres[indx][10];
                }
                return this.Kres[indx][11];
            }
            case 17: {
                return this.Kres[indx][12];
            }
        }
        return 0.0;
    }

    private boolean isDBExist(MolAtom a) {
        int impHc = a.getImplicitHcount();
        int nbc = this.getNbCount(a) + impHc;
        for (int i = 0; i < nbc - impHc; ++i) {
            if (a.getBond(i).getType() <= 1) continue;
            return true;
        }
        return false;
    }

    private int getNbCount(MolAtom a) {
        int bc = a.getBondCount();
        return bc;
    }

    private void setStandardSecularDeterminant() {
        for (int i = 0; i < this.MOLATOMS; ++i) {
            if (this.getSphereAtomIndex(i) == -1) continue;
            double ci = this.setColNO2Value(i);
            if (Double.isNaN(ci)) {
                ci = this.getCoulomb_h(i);
            }
            this.a[this.map[i]][this.map[i]] = ci;
            int n = this.cHtab[i].length;
            for (int w = 0; w < n; ++w) {
                int nb = this.cHtab[i][w];
                if (nb >= this.MOLATOMS || this.getSphereAtomIndex(nb) == -1) continue;
                double ri_nb = this.setResNO2Value(i, nb);
                if (Double.isNaN(ri_nb)) {
                    ri_nb = this.getResonant_k(i, nb);
                }
                this.a[this.map[i]][this.map[nb]] = ri_nb;
            }
        }
    }

    private double setResNO2Value(int i, int nb) {
        int ti = this.carboxy[i];
        boolean tiOk = false;
        int tnb = this.carboxy[nb];
        boolean tnbOk = false;
        if (ti == 1300 || ti == 100) {
            tiOk = true;
        }
        if (tnb == 1300 || tnb == 100) {
            tnbOk = true;
        }
        if (tiOk && tnbOk) {
            return 1.67;
        }
        if ((tiOk || tnbOk) && (this.getSymbol(i).equals("C") || this.getSymbol(nb).equals("C"))) {
            return 1.2;
        }
        return Double.NaN;
    }

    private double setColNO2Value(int i) {
        if (this.carboxy[i] == 1300) {
            if (this.getSymbol(i).equals("O")) {
                return 1.4;
            }
            if (this.getSymbol(i).equals("N")) {
                return 2.2;
            }
        } else if (this.getSymbol(i).equals("C") && this.isARNO2NbExist(i)) {
            return 0.11;
        }
        return Double.NaN;
    }

    private boolean isARNO2NbExist(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.MOLATOMS || this.carboxy[nb] != 1300 && this.carboxy[nb] != 100) continue;
            return true;
        }
        return false;
    }

    private void setSecularDeterminant() {
        for (int i = 0; i < this.MOLATOMS; ++i) {
            if (this.getSphereAtomIndex(i) == -1) continue;
            double ci = this.setColNO2Value(i);
            if (Double.isNaN(ci)) {
                ci = this.getHeteroIncrement(i);
            }
            this.a[this.map[i]][this.map[i]] = ci;
            int n = this.cHtab[i].length;
            for (int w = 0; w < n; ++w) {
                int nb = this.cHtab[i][w];
                if (nb >= this.MOLATOMS || this.getSphereAtomIndex(nb) == -1) continue;
                double ri = this.setResNO2Value(i, nb);
                if (Double.isNaN(ri)) {
                    ri = !this.getSymbol(nb).equals("C") && !this.getSymbol(i).equals("C") ? this.getHHResInc(nb, i) : (!this.getSymbol(nb).equals("C") ? (this.ParamSet == 1 ? this.getCHResIncCDens(nb) : this.getCHResIncENu(nb)) : (!this.getSymbol(i).equals("C") ? (this.ParamSet == 1 ? this.getCHResIncCDens(i) : this.getCHResIncENu(i)) : (this.isHyperCRes(nb, i) ? 0.7 : (this.isTripleBond(nb, i) ? 3.0 : 1.0))));
                }
                this.a[this.map[i]][this.map[nb]] = ri;
            }
        }
    }

    private boolean isHyperCRes(int atom1, int atom2) {
        return this.isHyperC(atom1) || this.isHyperC(atom2);
    }

    private boolean isTripleBond(int atom1, int atom2) {
        return this.mol.getBond(this.bHtab[atom1][atom2]).getType() == 3;
    }

    private double getHHResInc(int nb, int i) {
        if (this.carboxy[nb] == 100 || this.carboxy[nb] == 1300) {
            if (this.ParamSet == 2) {
                return this.resonance[0];
            }
            return 0.7;
        }
        if (this.carboxy[nb] == 800 && this.carboxy[i] == 800) {
            String symb1 = this.getSymbol(nb);
            String symb2 = this.getSymbol(i);
            String bond = symb1 + symb2;
            if (bond.equals("SO") || bond.equals("OS")) {
                return 1.2;
            }
            if (bond.equals("SN") || bond.equals("NS")) {
                return 0.5;
            }
        } else {
            String symb1 = this.getSymbol(nb);
            String symb2 = this.getSymbol(i);
            String bond = symb1 + symb2;
            if (bond.equals("BN") || bond.equals("NB")) {
                return 0.8;
            }
            if (bond.equals("SO") || bond.equals("OS")) {
                return 1.2;
            }
            if (bond.equals("NN")) {
                if (this.isDiazonium(nb)) {
                    return 4.0;
                }
                if (this.isDoubleAza(nb)) {
                    return this.resonance[4];
                }
                return 1.4;
            }
        }
        return 1.0;
    }

    private double getHeteroIncrement(int atom) {
        double maxResInc = 0.0;
        int charge = this.atomArray[atom].getCharge();
        if (!this.getSymbol(atom).equals("C")) {
            maxResInc = this.ParamSet == 1 ? this.getColumbIncCDens(atom) : this.getColumbIncENu(atom);
        } else if (this.cHtab[atom].length == 4) {
            maxResInc = this.isCH2X(atom) ? 1.0 : this.getColumbIncCDens(atom);
        } else if (this.carboxy[atom] == 400) {
            maxResInc = -0.15;
        } else if (this.cHtab[atom].length == 2 && !this.isKetene(atom, charge)) {
            maxResInc = charge != 0 ? 1.1 : 0.1;
        } else {
            for (int i = 0; i < this.cHtab[atom].length; ++i) {
                double resInc;
                int nb = this.cHtab[atom][i];
                if (nb >= this.MOLATOMS) continue;
                if (!this.getSymbol(nb).equals("C")) {
                    if (this.ParamSet == 2) {
                        charge = this.atomArray[nb].getCharge();
                        resInc = this.carboxy[nb] == 1300 ? 0.1 * this.getColumbIncENu(nb) : (this.carboxy[nb] == 400 ? 0.1 * this.getColumbIncENu(nb) : (charge != 0 ? 0.1 * this.getColumbIncENu(nb) : (this.azaA[nb] != -1 ? 0.1 * this.getColumbIncENu(nb) : 0.0)));
                    } else {
                        resInc = 0.0;
                    }
                    if (!(resInc > maxResInc)) continue;
                    maxResInc = resInc;
                    continue;
                }
                if (this.isHyperC(nb)) {
                    resInc = this.enuCalc ? 1.0 : 0.24499999999999997;
                    if (!(resInc > maxResInc)) continue;
                    maxResInc = resInc;
                    continue;
                }
                if (this.carboxy[nb] != 400) continue;
                maxResInc = 0.15;
            }
        }
        return maxResInc;
    }

    private boolean isCH2X(int atom) {
        for (int i = 0; i < 4; ++i) {
            String s;
            int nb = this.cHtab[atom][i];
            if (nb >= this.MOLATOMS || (s = this.getSymbol(nb)).equals("C") || s.equals("H")) continue;
            return true;
        }
        return false;
    }

    protected void setAllowedResParameters(boolean arp) {
        this.allowResParam = arp;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private double getCHResIncCDens(int atom) {
        int pc = this.atomArray[atom].getAtno();
        int n = this.cHtab[atom].length;
        int c = this.atomArray[atom].getCharge();
        int x = this.mol.getAtom(atom).getRadical();
        switch (pc) {
            case 7: {
                if (this.chgIsland != 0 && (this.takeResonance || this.allowResParam)) {
                    switch (this.chgIsland) {
                        case -1: {
                            return 1.0;
                        }
                        case 1: {
                            return 1.0;
                        }
                        case 2: {
                            return 1.0;
                        }
                    }
                } else {
                    if (c == 1) {
                        if (this.isDiazonium(atom)) {
                            return 3.5;
                        }
                        if (x == 0) return 2.0;
                        return 1.0;
                    }
                    if (n == 3) {
                        if (!this.isChargeOne(atom)) return 1.0;
                        return 0.7;
                    }
                    if (this.isChargeOne(atom)) {
                        return 1.0;
                    }
                    if (this.carboxy[atom] != 400) return 1.0;
                    return 0.7;
                }
            }
            case 8: {
                if (this.chgIsland != 0 && (this.takeResonance || this.allowResParam)) {
                    switch (this.chgIsland) {
                        case -1: {
                            return 0.8;
                        }
                        case 1: {
                            return 0.8;
                        }
                        case 2: {
                            return 0.8;
                        }
                    }
                } else {
                    if (c == 1) {
                        return 0.8;
                    }
                    if (c == -1) return 0.8;
                    if (n == 2) {
                        return 0.8;
                    }
                    if (n != 1) return 0.7;
                    if (!this.isChargeOne(atom)) return 1.0;
                    return 1.0;
                }
            }
            case 9: {
                return 0.7;
            }
            case 17: {
                return 0.4;
            }
            case 35: {
                return 0.3;
            }
            case 53: {
                return 0.15;
            }
            case 5: {
                return 0.7;
            }
            case 16: {
                return 0.9;
            }
        }
        return 1.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double getColumbIncCDens(int atom) {
        int pc = this.atomArray[atom].getAtno();
        int n = this.cHtab[atom].length;
        int c = this.atomArray[atom].getCharge();
        int x = this.mol.getAtom(atom).getRadical();
        switch (pc) {
            case 7: {
                if (this.chgIsland != 0 && (this.takeResonance || this.allowResParam)) {
                    switch (this.chgIsland) {
                        case -1: {
                            return 0.5;
                        }
                        case 1: {
                            return 0.5;
                        }
                        case 2: {
                            return 0.5;
                        }
                    }
                } else {
                    if (c == 1) {
                        if (this.isDiazonium(atom)) {
                            return 0.3;
                        }
                        if (this.isNR4(atom)) {
                            return 0.2;
                        }
                        if (x == 0) return 2.0;
                        return 0.5;
                    }
                    if (c == -1) {
                        return 0.5;
                    }
                    if (this.isChargeOne(atom)) {
                        if (this.carboxy[atom] != 100 && this.carboxy[atom] != 1300) return 1.25;
                        return 2.0;
                    }
                    if (this.carboxy[atom] == 400) {
                        return 1.0;
                    }
                    if (this.cHtab[atom].length != 3 || !this.isAromatic(atom)) return 0.5;
                    return 1.5;
                }
            }
            case 8: {
                if (this.chgIsland != 0 && (this.takeResonance || this.allowResParam)) {
                    switch (this.chgIsland) {
                        case -1: {
                            return 2.0;
                        }
                        case 1: {
                            if (x == 0) return 2.5;
                            return 1.0;
                        }
                        case 2: {
                            return 1.0;
                        }
                    }
                } else {
                    if (c == 1) {
                        if (x == 0) return 2.5;
                        return 1.0;
                    }
                    if (n == 2) {
                        return 2.0;
                    }
                    if (n != 1) return 3.0;
                    if (this.isChargeOne(atom)) {
                        return 1.5;
                    }
                    if (c != -1) return 1.0;
                    return 2.0;
                }
            }
            case 9: {
                return 3.0;
            }
            case 17: {
                return 2.0;
            }
            case 35: {
                return 1.5;
            }
            case 53: {
                return 1.0;
            }
            case 5: {
                return -1.0;
            }
            case 16: {
                if (this.chgIsland != 0 && (this.takeResonance || this.allowResParam)) {
                    switch (this.chgIsland) {
                        case -1: {
                            return 2.0;
                        }
                        case 1: {
                            return 1.5;
                        }
                        case 2: {
                            return 1.0;
                        }
                    }
                } else {
                    if (this.isChargeOne(atom)) {
                        return 1.5;
                    }
                    if (c != -1) return 1.5;
                    return 2.0;
                }
            }
            case 6: {
                if (this.chgIsland != 0 && (this.takeResonance || this.allowResParam)) {
                    switch (this.chgIsland) {
                        case -1: {
                            return 0.8;
                        }
                        case 1: {
                            return 0.8;
                        }
                        case 2: {
                            return 0.8;
                        }
                    }
                    return 0.8;
                }
                if (!this.isCH3NbExist(atom)) return 0.8;
                return 2.0;
            }
        }
        return 0.8;
    }

    private boolean isCH3NbExist(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.MOLATOMS || !this.isHyperC(nb)) continue;
            return true;
        }
        return false;
    }

    private boolean isHyperC(int ai) {
        MolAtom a;
        if (this.getSphereAtomIndex(ai) == -1) {
            return false;
        }
        return this.getSymbol(ai).equals("C") && !(a = this.mol.getAtom(ai)).hasAromaticBond() && !this.isUnSaturatedAtom(ai);
    }

    private boolean isUnSaturatedAtom(int a) {
        MolAtom ma = this.mol.getAtom(a);
        if (this.isDBbonded(ma)) {
            return true;
        }
        if (ma.getCharge() != 0) {
            return true;
        }
        int[] LPCount = new int[this.MOLATOMS];
        this.LPc = new LonePairCounter();
        LPCount = this.LPc.getLonePairCount(this.mol);
        return LPCount[a] != 0;
    }

    private boolean isDBbonded(MolAtom a) {
        for (int i = 0; i < a.getBondCount(); ++i) {
            MolBond b = a.getBond(i);
            int t = b.getType();
            if (t <= 1) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double getCHResIncENu(int atom) {
        int pc = this.atomArray[atom].getAtno();
        int n = this.cHtab[atom].length;
        int c = this.atomArray[atom].getCharge();
        switch (pc) {
            case 7: {
                if (this.chgIsland != 0 && (this.takeResonance || this.allowResParam)) {
                    switch (this.chgIsland) {
                        case -1: {
                            return 0.2;
                        }
                        case 1: {
                            return 1.0;
                        }
                        case 2: {
                            return 1.25;
                        }
                    }
                } else {
                    if (c == 1) {
                        if (this.isAromatic(atom)) {
                            return 1.2;
                        }
                        if (this.isNR4(atom)) {
                            return 1.0;
                        }
                        if (!this.isDiazonium(atom)) return 0.5;
                        return 1.5;
                    }
                    if (c == -1) {
                        return 0.2;
                    }
                    if (n == 3) {
                        if (this.isChargeOne(atom)) {
                            if (this.carboxy[atom] != 1300) return 1.0;
                            return this.resonance[1];
                        }
                        if (this.isAliAmin(atom)) {
                            return this.resonance[2];
                        }
                        if (!this.isPyrrole(atom)) return 0.8;
                        return 1.0;
                    }
                    if (this.isChargeOne(atom)) {
                        return 1.0;
                    }
                    if (this.carboxy[atom] == 400) {
                        return 0.1;
                    }
                    if (this.azaA[atom] != -1) {
                        if (!this.isDoubleAza(atom)) return 0.4;
                        return this.resonance[3];
                    }
                    if (!this.isPyridine(atom)) return 1.0;
                    return this.resonance[5];
                }
            }
            case 8: {
                if (this.chgIsland != 0 && (this.takeResonance || this.allowResParam)) {
                    switch (this.chgIsland) {
                        case -1: {
                            return 0.8;
                        }
                        case 1: {
                            return 0.8;
                        }
                        case 2: {
                            return 1.0;
                        }
                    }
                } else {
                    if (c == 1) {
                        return 0.8;
                    }
                    if (c == -1 || n == 2) {
                        return 0.8;
                    }
                    if (n != 1) return 0.7;
                    if (!this.isChargeOne(atom)) return 1.0;
                    return 0.9;
                }
            }
            case 9: {
                return 0.7;
            }
            case 17: {
                return 0.4;
            }
            case 35: {
                return 0.3;
            }
            case 53: {
                return 0.15;
            }
            case 5: {
                return 0.7;
            }
            case 16: {
                if (this.chgIsland != 0 && (this.takeResonance || this.allowResParam)) {
                    switch (this.chgIsland) {
                        case -1: {
                            return 0.9;
                        }
                        case 1: {
                            return 0.9;
                        }
                        case 2: {
                            return 1.0;
                        }
                    }
                    return 1.0;
                }
                if (!this.isChargeOne(atom)) return 0.9;
                return 0.2;
            }
        }
        return 1.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double getColumbIncENu(int atom) {
        int pc = this.atomArray[atom].getAtno();
        int n = this.cHtab[atom].length;
        int c = this.atomArray[atom].getCharge();
        switch (pc) {
            case 7: {
                if (this.chgIsland != 0 && (this.takeResonance || this.allowResParam)) {
                    switch (this.chgIsland) {
                        case -1: {
                            return 0.0;
                        }
                        case 1: {
                            return 1.5;
                        }
                        case 2: {
                            return 1.25;
                        }
                    }
                } else {
                    if (c == 1) {
                        if (this.isAromatic(atom)) {
                            return 1.5;
                        }
                        if (this.isNR4(atom)) {
                            return 0.2;
                        }
                        if (!this.isDiazonium(atom)) return 2.0;
                        return 3.0;
                    }
                    if (c == -1) {
                        return 0.0;
                    }
                    if (this.isChargeOne(atom)) {
                        if (this.carboxy[atom] != 1300) return 1.25;
                        return this.coulomb[1];
                    }
                    if (this.carboxy[atom] == 400) {
                        return 0.8;
                    }
                    if (this.azaA[atom] != -1) {
                        if (!this.isDoubleAza(atom)) return 0.5;
                        return this.coulomb[3];
                    }
                    if (this.isAliAmin(atom)) {
                        return this.coulomb[2];
                    }
                    if (this.isPyridine(atom)) {
                        return this.coulomb[4];
                    }
                    if (!this.isPyrrole(atom)) return 0.5;
                    return 0.5;
                }
            }
            case 8: {
                if (this.chgIsland != 0 && (this.takeResonance || this.allowResParam)) {
                    switch (this.chgIsland) {
                        case -1: {
                            return 1.5;
                        }
                        case 1: {
                            return 1.5;
                        }
                        case 2: {
                            return 1.5;
                        }
                    }
                } else {
                    if (c == 1) {
                        return 2.5;
                    }
                    if (n == 2) {
                        return 2.0;
                    }
                    if (n != 1) return 3.0;
                    if (!this.isChargeOne(atom)) return 1.0;
                    if (this.carboxy[atom] != 1300) return 1.5;
                    return this.coulomb[0];
                }
            }
            case 9: {
                return 3.0;
            }
            case 17: {
                return 2.0;
            }
            case 35: {
                return 1.5;
            }
            case 53: {
                return 1.0;
            }
            case 5: {
                return -1.0;
            }
            case 16: {
                if (this.chgIsland != 0 && (this.takeResonance || this.allowResParam)) {
                    switch (this.chgIsland) {
                        case -1: {
                            return 1.5;
                        }
                        case 1: {
                            return 1.5;
                        }
                        case 2: {
                            return 1.5;
                        }
                    }
                    return 0.8;
                }
                if (!this.isChargeOne(atom)) return 1.5;
                return 2.0;
            }
        }
        return 0.8;
    }

    private boolean isPyridine(int atom) {
        return this.isAromatic(atom) && this.cHtab[atom].length == 2;
    }

    private boolean isPyrrole(int atom) {
        return this.isAromatic(atom) && this.cHtab[atom].length == 3;
    }

    private boolean isDoubleAza(int atom) {
        return this.mol.getBond(this.bHtab[atom][this.azaA[atom]]).getType() == 2;
    }

    private boolean isAliAmin(int atom) {
        return !this.isAromatic(atom) && this.cHtab[atom].length == 3;
    }

    private boolean isAromatic(int atom) {
        return this.atomArray[atom].hasAromaticBond();
    }

    private boolean isDiazonium(int atom) {
        return this.carboxy[atom] == 400;
    }

    private boolean isNR4(int atom) {
        return this.cHtab[atom].length == 4;
    }

    private boolean isChargeOne(int atom) {
        switch (this.carboxy[atom]) {
            case 200: {
                return true;
            }
            case 500: {
                return true;
            }
            case 600: {
                return true;
            }
            case 700: {
                return true;
            }
            case 800: {
                return true;
            }
            case 1200: {
                return true;
            }
            case 100: {
                return true;
            }
            case 1300: {
                return true;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    private void setEigenValue(double[] eigval) {
        int size = eigval.length;
        this.EigenValue = new double[size - 1];
        for (int i = 0; i < size - 1; ++i) {
            this.EigenValue[i] = eigval[i + 1];
        }
    }

    public double[] getRealEigenValue() {
        return this.EigenValue;
    }

    private void setCalcStatus(int delAtomCount) {
        this.calcStatus = delAtomCount > 2 ? true : delAtomCount > 0;
    }

    private String getSymbol(int atomIndex) {
        if (atomIndex >= this.MOLATOMS) {
            return "H";
        }
        return this.atomArray[atomIndex].getSymbol();
    }

    private double sign(double a1, double a2) {
        a1 = a2 < 0.0 ? -1.0 * Math.abs(a1) : 1.0 * Math.abs(a1);
        return a1;
    }

    private void eig2(double[] d, double[] e, double[][] a) {
        int i;
        int n = a[0].length - 1;
        for (i = 2; i <= n; ++i) {
            e[i - 1] = e[i];
        }
        e[n] = 0.0;
        for (int l = 1; l <= n; ++l) {
            int m;
            int iter = 0;
            do {
                for (m = l; m <= n - 1; ++m) {
                    double dd = Math.abs(d[m]) + Math.abs(d[m + 1]);
                    double v = Math.abs(e[m]) + dd;
                    if (v == dd) break;
                }
                if (m == l || iter > 30) continue;
                ++iter;
                double g = (d[l + 1] - d[l]) / (2.0 * e[l]);
                double r = Math.sqrt(g * g + 1.0);
                g = d[m] - d[l] + e[l] / (g + this.sign(r, g));
                double s = 1.0;
                double c = 1.0;
                double p = 0.0;
                for (i = m - 1; i >= l; --i) {
                    double f = s * e[i];
                    double b = c * e[i];
                    if (Math.abs(f) >= Math.abs(g)) {
                        c = g / f;
                        r = Math.sqrt(c * c + 1.0);
                        e[i + 1] = f * r;
                        s = 1.0 / r;
                        c *= s;
                    } else {
                        s = f / g;
                        r = Math.sqrt(s * s + 1.0);
                        e[i + 1] = g * r;
                        c = 1.0 / r;
                        s *= c;
                    }
                    g = d[i + 1] - p;
                    r = s * (d[i] - g) + 2.0 * c * b;
                    p = s * r;
                    d[i + 1] = g + p;
                    g = c * r - b;
                    for (int k = 1; k <= n; ++k) {
                        f = a[k][i + 1];
                        a[k][i + 1] = s * a[k][i] + c * f;
                        a[k][i] = c * a[k][i] - s * f;
                    }
                }
                d[l] = d[l] - p;
                e[l] = g;
                e[m] = 0.0;
            } while (m != l);
        }
    }

    public void calcHMO(Molecule m) {
        this.initCalc(m);
        if (this.calcStatus) {
            int H = this.a[0].length - 1;
            this.real = new double[H + 1];
            this.d = new double[H + 1];
            this.e = new double[H + 1];
            this.transformMatrix(this.a, this.d, this.e);
            this.eig2(this.d, this.e, this.a);
            for (int i = 1; i <= H; ++i) {
                this.real[i] = this.d[i];
            }
            this.calcPiCharge(this.a, this.real);
        }
        this.addSingleAtomPienergy();
        if (this.resCalculated) {
            this.mol = this.oMol;
        }
    }

    private void printEigv(int size, double[][] eigVec) {
        for (int i = 1; i <= size; ++i) {
            for (int j = 1; j <= size; ++j) {
                System.out.print(eigVec[i][j] + " ");
            }
            System.out.println();
        }
        System.out.println();
    }

    public void printResult(int size) {
        int i;
        System.out.println();
        for (i = 1; i <= this.MOLATOMS; ++i) {
            System.out.println(i + "HMO charge  " + this.qh[i - 1]);
        }
        System.out.println();
        System.out.println("EIGENVALUE");
        for (i = 1; i <= size; ++i) {
            System.out.print(this.real[i] + " " + "(" + this.moe[i] + ")" + "  ");
            if (this.orbType[i] == 1) {
                System.out.println("HOMO  ");
                continue;
            }
            if (this.orbType[i] == 2) {
                System.out.println("LUMO");
                continue;
            }
            if (this.orbType[i] == 3) {
                System.out.println("BONDING");
                continue;
            }
            if (this.orbType[i] == 4) {
                System.out.println("NONBONDING");
                continue;
            }
            if (this.orbType[i] != 5) continue;
            System.out.println("ANTIBONDING");
        }
        System.out.println();
        if (this.radical) {
            System.out.println("RADICAL");
        }
        System.out.println();
        System.out.println("PI ENERGY= " + this.piEnergy);
    }

    private int getElectronCorrection() {
        return this.eCorrection;
    }

    private int getAtomCorrection() {
        return this.aCorrection;
    }

    public void setAtomCorrection(int ac) {
        this.aCorrection = ac;
    }

    public void setElectronCorrection(int ec) {
        this.eCorrection = ec;
    }

    private void addElectronCorrection() {
        if (this.islandECount > 0) {
            this.ne = this.islandECount + this.eCorrection;
        }
    }

    public void setIslandECount(int size) {
        this.islandECount = 0;
        this.islandACount = size;
        for (int i = 1; i <= size; ++i) {
            this.islandECount += this.electrons[i];
        }
        this.islandChg = this.getNetIslandCharge();
    }

    public void reSetIslandEACount() {
        this.islandECount = 0;
        this.islandACount = 0;
        this.islandChg = 0;
    }

    private void calcPiCharge(double[][] eigVec, double[] eigVal) {
        this.sortEig(eigVec, eigVal);
        this.setEigenVector(eigVec);
        this.setEigenValue(eigVal);
        int H = eigVec[0].length - 1;
        this.ne = 0;
        for (int i = 1; i <= H; ++i) {
            this.ne += this.electrons[i];
        }
        if (this.standardHMO) {
            this.addElectronCorrection();
        }
        this.pic = new double[H + 1];
        this.moe = new int[H + 1];
        this.orbType = new int[H + 1];
        double el = this.ne;
        this.radical = false;
        this.piEnergy = 0.0;
        for (int moOrb = 1; moOrb <= H; ++moOrb) {
            int moElectrons = 0;
            if (el > 0.0) {
                moElectrons = el - 2.0 >= 0.0 ? 2 : (el - 1.0 >= 0.0 ? 1 : 0);
                if (moOrb < H & el == 2.0 && Math.abs(this.real[moOrb] - this.real[moOrb + 1]) < 1.0E-7) {
                    moElectrons = 1;
                    this.radical = true;
                }
                if ((el -= (double)moElectrons) == 0.0) {
                    this.orbType[moOrb] = 1;
                    if (moOrb < H) {
                        this.orbType[moOrb + 1] = 2;
                    }
                } else {
                    this.orbType[moOrb] = this.real[moOrb] < 0.0 ? 5 : 3;
                }
            } else if (this.orbType[moOrb] != 2 & this.orbType[moOrb] != 1 & this.orbType[moOrb] != 5) {
                this.orbType[moOrb] = Math.abs(this.real[moOrb]) < 1.0E-8 ? 4 : 5;
            }
            for (int atom = 1; atom <= H; ++atom) {
                int n = atom;
                this.pic[n] = this.pic[n] + (double)(-1 * moElectrons) * eigVec[atom][moOrb] * eigVec[atom][moOrb];
            }
            this.piEnergy += (double)moElectrons * this.real[moOrb];
            this.moe[moOrb] = moElectrons;
        }
        this.setPiChargeDens(this.pic);
        for (int atom = 1; atom <= H; ++atom) {
            int n = atom;
            this.pic[n] = this.pic[n] + (double)this.sigmaC[atom];
        }
        this.qh = new double[this.MOLATOMS];
        int k = 1;
        for (int i = 0; i < this.MOLATOMS; ++i) {
            if (this.map[i] != 0) {
                this.qh[i] = this.pic[k];
                ++k;
                continue;
            }
            this.qh[i] = Double.NaN;
        }
    }

    private void addSingleAtomPienergy() {
        for (int i = 0; i < this.MOLATOMS; ++i) {
            this.piEnergy += this.singleAtomE[i];
        }
    }

    public double getPiEnergy() {
        return this.piEnergy;
    }

    private void setPiChargeDens(double[] picd) {
        this.piCdens = new double[this.MOLATOMS];
        int k = 1;
        for (int i = 0; i < this.MOLATOMS; ++i) {
            if (this.map[i] != 0) {
                this.piCdens[i] = picd[k];
                ++k;
                continue;
            }
            this.piCdens[i] = Double.NaN;
        }
    }

    public double[] getPiChargeDens() {
        return this.piCdens;
    }

    private void setEigenVector(double[][] eigv) {
        int size = eigv.length;
        this.EigenVector = new double[size - 1][size - 1];
        for (int i = 0; i < size - 1; ++i) {
            for (int j = 0; j < size - 1; ++j) {
                this.EigenVector[i][j] = eigv[i + 1][j + 1];
            }
        }
    }

    public double[][] getEigenVector() {
        return this.EigenVector;
    }

    public double[][] getHuckelOrbital() {
        double[][] y = null;
        if (this.EigenVector != null) {
            int L = this.EigenVector[0].length;
            y = new double[L][L];
            for (int i = 0; i < L; ++i) {
                for (int j = 0; j < L; ++j) {
                    y[i][j] = this.EigenVector[j][i];
                }
            }
        }
        return y;
    }

    private void sortEig(double[][] eigVec, double[] eigVal) {
        int H = eigVec[0].length - 1;
        for (int i = 1; i <= H - 1; ++i) {
            int j;
            int k = i;
            double p = eigVal[i];
            for (j = i + 1; j <= H; ++j) {
                if (!(eigVal[j] >= p)) continue;
                k = j;
                p = eigVal[j];
            }
            if (k == i) continue;
            eigVal[k] = eigVal[i];
            eigVal[i] = p;
            for (j = 1; j <= H; ++j) {
                p = eigVec[j][k];
                eigVec[j][k] = eigVec[j][i];
                eigVec[j][i] = p;
            }
        }
    }

    private void setStandardSigmaSceleton() {
        int i;
        int size = this.MOLATOMS;
        this.sigmaC = new int[size + 1];
        this.electrons = new int[size + 1];
        int[] y = new int[2];
        this.oMol = this.mol.cloneMoleculeWithDocument();
        this.mol.dearomatize();
        this.natoms = 0;
        for (i = 0; i < this.MOLATOMS; ++i) {
            int vs;
            if (this.map[i] == 0) continue;
            ++this.natoms;
            int k = this.map[i];
            int na = this.cHtab[i].length;
            int c = this.atomArray[i].getCharge();
            int x = this.mol.getAtom(i).getRadical();
            String Symbol2 = this.getSymbol(i);
            if (Symbol2.equals("N")) {
                if (na == 5 && this.carboxy[i] == 1200) {
                    this.sigmaC[k] = 1;
                    this.electrons[k] = 1;
                    continue;
                }
                if (na == 3) {
                    if (c > 0) {
                        if (this.isDBExist(i)) {
                            this.sigmaC[k] = c + 1;
                            this.electrons[k] = 1;
                            continue;
                        }
                        this.sigmaC[k] = c;
                        this.electrons[k] = 0;
                        continue;
                    }
                    if (c != 0) continue;
                    this.sigmaC[k] = 2;
                    this.electrons[k] = 2;
                    continue;
                }
                if (na == 2) {
                    if (c > 0) {
                        this.sigmaC[k] = 1;
                        this.electrons[k] = 0;
                        continue;
                    }
                    if (c == 0) {
                        vs = this.getBondingElectrons(i);
                        if (vs == 4) {
                            this.sigmaC[k] = 2;
                            this.electrons[k] = 2;
                            continue;
                        }
                        this.sigmaC[k] = 1;
                        this.electrons[k] = 1;
                        continue;
                    }
                    if (c >= 0) continue;
                    this.sigmaC[k] = 1;
                    this.electrons[k] = 2;
                    continue;
                }
                if (na != 1 || c != 0) continue;
                this.sigmaC[k] = 1;
                this.electrons[k] = 1;
                continue;
            }
            if (Symbol2.equals("C") || Symbol2.equals("Si")) {
                if (na == 3) {
                    if (c == 0) {
                        this.sigmaC[k] = 1;
                        this.electrons[k] = 1;
                        continue;
                    }
                    if (c > 0) {
                        this.sigmaC[k] = c;
                        this.electrons[k] = 0;
                        continue;
                    }
                    if (c >= 0) continue;
                    this.sigmaC[k] = 1;
                    this.electrons[k] = 2;
                    continue;
                }
                if (na != 2) continue;
                if (c == 0) {
                    if (this.isKetene(i, c)) {
                        this.sigmaC[k] = 2;
                        this.electrons[k] = 2;
                        continue;
                    }
                    this.sigmaC[k] = 1;
                    this.electrons[k] = 1;
                    continue;
                }
                if (c > 0) {
                    vs = this.getBondingElectrons(i);
                    if (vs == 3) {
                        this.sigmaC[k] = 2;
                        this.electrons[k] = 1;
                        continue;
                    }
                    if (vs != 2) continue;
                    this.sigmaC[k] = 2;
                    this.electrons[k] = 0;
                    continue;
                }
                if (c >= 0) continue;
                vs = this.getBondingElectrons(i);
                if (vs == 3) {
                    this.sigmaC[k] = 1;
                    this.electrons[k] = 1;
                }
                if (vs != 2) continue;
                this.sigmaC[k] = 1;
                this.electrons[k] = 2;
                continue;
            }
            if (Symbol2.equals("P")) {
                y = this.getDBandSBCount(i);
                if (c == 0) {
                    this.sigmaC[k] = y[0];
                    this.electrons[k] = y[0];
                    continue;
                }
                if (c < 0) {
                    this.sigmaC[k] = 1;
                    this.electrons[k] = 2;
                    continue;
                }
                if (c <= 0) continue;
                this.sigmaC[k] = y[0] + c;
                this.electrons[k] = y[0];
                continue;
            }
            if (Symbol2.equals("O")) {
                if (na == 1) {
                    if (c == 0) {
                        this.sigmaC[k] = 1;
                        this.electrons[k] = 1;
                        continue;
                    }
                    if (c < 0) {
                        this.sigmaC[k] = 1;
                        this.electrons[k] = 2;
                        continue;
                    }
                    if (c <= 0) continue;
                    if (x != 0) {
                        this.sigmaC[k] = 1;
                        this.electrons[k] = 0;
                        continue;
                    }
                    this.sigmaC[k] = 2;
                    this.electrons[k] = 1;
                    continue;
                }
                if (na != 2) continue;
                if (c > 0) {
                    this.sigmaC[k] = 2;
                    this.electrons[k] = 1;
                    continue;
                }
                this.sigmaC[k] = 2;
                this.electrons[k] = 2;
                continue;
            }
            if (Symbol2.equals("F")) {
                this.sigmaC[k] = 2;
                this.electrons[k] = 2;
                continue;
            }
            if (Symbol2.equals("Cl")) {
                this.sigmaC[k] = 2;
                this.electrons[k] = 2;
                continue;
            }
            if (Symbol2.equals("B")) {
                this.sigmaC[k] = 0;
                this.electrons[k] = 0;
                continue;
            }
            if (Symbol2.equals("S")) {
                if (na == 1) {
                    if (c == 0) {
                        this.sigmaC[k] = 1;
                        this.electrons[k] = 1;
                        continue;
                    }
                    if (c < 0) {
                        this.sigmaC[k] = 1;
                        this.electrons[k] = 2;
                        continue;
                    }
                    if (c <= 0) continue;
                    if (x != 0) {
                        this.sigmaC[k] = 1;
                        this.electrons[k] = 0;
                        continue;
                    }
                    this.sigmaC[k] = 2;
                    this.electrons[k] = 1;
                    continue;
                }
                if (na == 2) {
                    if (c > 0) {
                        this.sigmaC[k] = 2;
                        this.electrons[k] = 1;
                        continue;
                    }
                    this.sigmaC[k] = 2;
                    this.electrons[k] = 2;
                    continue;
                }
                if (na == 3) {
                    y = this.getDBandSBCount(i);
                    if (c > 0) {
                        if (y[0] == 0 && y[1] == 3) {
                            this.sigmaC[k] = c;
                            this.electrons[k] = 0;
                            continue;
                        }
                        if (y[0] == 2 && y[1] == 1) {
                            this.sigmaC[k] = 2 + c;
                            this.electrons[k] = 2;
                            continue;
                        }
                        this.sigmaC[k] = y[0] + c;
                        this.electrons[k] = y[0];
                        continue;
                    }
                    if (c != 0) continue;
                    if (y[0] == 2 && y[1] == 1) {
                        this.sigmaC[k] = 2;
                        this.electrons[k] = 2;
                        continue;
                    }
                    this.sigmaC[k] = y[0];
                    this.electrons[k] = y[0];
                    continue;
                }
                y = this.getDBandSBCount(i);
                this.sigmaC[k] = y[0] + c;
                this.electrons[k] = y[0];
                continue;
            }
            this.map[i] = 0;
        }
        this.mol = this.oMol;
        this.nelectrons = 0;
        for (i = 0; i < size + 1; ++i) {
            this.nelectrons += this.electrons[i];
        }
    }

    private void setSigmaSceleton() {
        int size = this.MOLATOMS;
        this.sigmaC = new int[size + 1];
        this.electrons = new int[size + 1];
        int[] y = new int[2];
        this.oMol = this.mol.cloneMoleculeWithDocument();
        this.mol.dearomatize();
        for (int i = 0; i < this.MOLATOMS; ++i) {
            int vs;
            if (this.map[i] == 0) continue;
            int k = this.map[i];
            int na = this.cHtab[i].length;
            int c = this.atomArray[i].getCharge();
            int x = this.mol.getAtom(i).getRadical();
            String Symbol2 = this.getSymbol(i);
            if (Symbol2.equals("N")) {
                if (na == 4) {
                    this.sigmaC[k] = 1;
                    this.electrons[k] = -1;
                    continue;
                }
                if (na == 5 && this.carboxy[i] == 1200) {
                    this.sigmaC[k] = 1;
                    this.electrons[k] = 1;
                    continue;
                }
                if (na == 3) {
                    if (c > 0) {
                        if (this.isDBExist(i)) {
                            this.sigmaC[k] = c + 1;
                            this.electrons[k] = 1;
                            continue;
                        }
                        this.sigmaC[k] = c;
                        this.electrons[k] = 0;
                        continue;
                    }
                    if (c != 0) continue;
                    vs = this.getBondingElectrons(i);
                    if (vs == 5) {
                        this.sigmaC[k] = 2;
                        this.electrons[k] = 2;
                        continue;
                    }
                    this.sigmaC[k] = 2;
                    this.electrons[k] = 2;
                    continue;
                }
                if (na == 2) {
                    if (c > 0) {
                        this.sigmaC[k] = 1;
                        this.electrons[k] = 0;
                        continue;
                    }
                    if (c == 0) {
                        vs = this.getBondingElectrons(i);
                        if (vs == 4) {
                            this.sigmaC[k] = 2;
                            this.electrons[k] = 2;
                            continue;
                        }
                        this.sigmaC[k] = 1;
                        this.electrons[k] = 1;
                        continue;
                    }
                    if (c >= 0) continue;
                    this.sigmaC[k] = 1;
                    this.electrons[k] = 2;
                    continue;
                }
                if (na != 1 || c != 0) continue;
                this.sigmaC[k] = 1;
                this.electrons[k] = 1;
                continue;
            }
            if (Symbol2.equals("C")) {
                if (na == 4) {
                    this.sigmaC[k] = 2;
                    this.electrons[k] = 2;
                    continue;
                }
                if (na == 3) {
                    if (c == 0) {
                        this.sigmaC[k] = 1;
                        this.electrons[k] = 1;
                        continue;
                    }
                    if (c > 0) {
                        this.sigmaC[k] = c;
                        this.electrons[k] = 0;
                        continue;
                    }
                    if (c >= 0) continue;
                    this.sigmaC[k] = 1;
                    this.electrons[k] = 2;
                    continue;
                }
                if (na != 2) continue;
                if (c == 0) {
                    if (this.isKetene(i, c)) {
                        this.sigmaC[k] = 2;
                        this.electrons[k] = 2;
                        continue;
                    }
                    this.sigmaC[k] = 1;
                    this.electrons[k] = 1;
                    continue;
                }
                if (c > 0) {
                    vs = this.getBondingElectrons(i);
                    if (vs == 3) {
                        this.sigmaC[k] = 2;
                        this.electrons[k] = 1;
                        continue;
                    }
                    if (vs != 2) continue;
                    this.sigmaC[k] = 2;
                    this.electrons[k] = 0;
                    continue;
                }
                if (c >= 0) continue;
                vs = this.getBondingElectrons(i);
                if (vs == 3) {
                    this.sigmaC[k] = 0;
                    this.electrons[k] = 1;
                }
                if (vs != 2) continue;
                this.sigmaC[k] = -2;
                this.electrons[k] = 2;
                continue;
            }
            if (Symbol2.equals("O")) {
                if (na == 1) {
                    if (c == 0) {
                        this.sigmaC[k] = 1;
                        this.electrons[k] = 1;
                        continue;
                    }
                    if (c < 0) {
                        this.sigmaC[k] = 1;
                        this.electrons[k] = 2;
                        continue;
                    }
                    if (c <= 0) continue;
                    if (x != 0) {
                        this.sigmaC[k] = 1;
                        this.electrons[k] = 0;
                        continue;
                    }
                    this.sigmaC[k] = 2;
                    this.electrons[k] = 1;
                    continue;
                }
                if (na != 2) continue;
                if (c > 0) {
                    this.sigmaC[k] = 2;
                    this.electrons[k] = 1;
                    continue;
                }
                this.sigmaC[k] = 2;
                this.electrons[k] = 2;
                continue;
            }
            if (Symbol2.equals("F")) {
                this.sigmaC[k] = 2;
                this.electrons[k] = 2;
                continue;
            }
            if (Symbol2.equals("Cl")) {
                this.sigmaC[k] = 2;
                this.electrons[k] = 2;
                continue;
            }
            if (Symbol2.equals("Br")) {
                this.sigmaC[k] = 2;
                this.electrons[k] = 2;
                continue;
            }
            if (Symbol2.equals("I")) {
                this.sigmaC[k] = 2;
                this.electrons[k] = 2;
                continue;
            }
            if (Symbol2.equals("B")) {
                this.sigmaC[k] = 0;
                this.electrons[k] = 0;
                continue;
            }
            if (Symbol2.equals("S")) {
                if (na == 1) {
                    if (c == 0) {
                        this.sigmaC[k] = 1;
                        this.electrons[k] = 1;
                        continue;
                    }
                    if (c < 0) {
                        this.sigmaC[k] = 1;
                        this.electrons[k] = 2;
                        continue;
                    }
                    if (c <= 0) continue;
                    if (x != 0) {
                        this.sigmaC[k] = 1;
                        this.electrons[k] = 0;
                        continue;
                    }
                    this.sigmaC[k] = 2;
                    this.electrons[k] = 1;
                    continue;
                }
                if (na == 2) {
                    if (c > 0) {
                        this.sigmaC[k] = 2;
                        this.electrons[k] = 1;
                        continue;
                    }
                    this.sigmaC[k] = 2;
                    this.electrons[k] = 2;
                    continue;
                }
                if (na == 3) {
                    y = this.getDBandSBCount(i);
                    if (c > 0) {
                        if (y[0] == 0 && y[1] == 3) {
                            this.sigmaC[k] = c;
                            this.electrons[k] = 0;
                            continue;
                        }
                        if (y[0] == 2 && y[1] == 1) {
                            this.sigmaC[k] = 2 + c;
                            this.electrons[k] = 2;
                            continue;
                        }
                        this.sigmaC[k] = y[0] + c;
                        this.electrons[k] = y[0];
                        continue;
                    }
                    if (c != 0) continue;
                    if (y[0] == 2 && y[1] == 1) {
                        this.sigmaC[k] = 2;
                        this.electrons[k] = 2;
                        continue;
                    }
                    this.sigmaC[k] = y[0];
                    this.electrons[k] = y[0];
                    continue;
                }
                y = this.getDBandSBCount(i);
                this.sigmaC[k] = y[0] + c;
                this.electrons[k] = y[0];
                continue;
            }
            y = this.getDBandSBCount(i);
            if (c == 0) {
                this.sigmaC[k] = 2;
                this.electrons[k] = 2;
                continue;
            }
            this.sigmaC[k] = y[0] + c;
            this.electrons[k] = y[0];
        }
        this.mol = this.oMol;
    }

    private boolean isDBExist(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.MOLATOMS || this.mol.getBond(this.bHtab[ai][nb]).getType() <= 1) continue;
            return true;
        }
        return false;
    }

    private boolean isPartialPlus(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.MOLATOMS) continue;
            int chg = this.atomArray[nb].getCharge();
            if (chg > 0) {
                return true;
            }
            if ((this.chgIsland == 1 || this.chgIsland == 2) && (this.takeResonance || this.allowResParam)) {
                return true;
            }
            if (!this.isEWDgroup(nb)) continue;
            return true;
        }
        return false;
    }

    private boolean isEWDgroup(int ai) {
        switch (this.carboxy[ai]) {
            case 200: {
                return true;
            }
            case 500: {
                return true;
            }
            case 400: {
                return true;
            }
            case 600: {
                return true;
            }
            case 700: {
                return true;
            }
            case 800: {
                return true;
            }
            case 1200: {
                return true;
            }
            case 100: {
                return true;
            }
            case 1300: {
                return true;
            }
            case 1400: {
                return true;
            }
            case 1: {
                return true;
            }
            case 1700: {
                return true;
            }
        }
        return false;
    }

    private boolean isKetene(int atom, int ch) {
        if (this.cHtab[atom].length == 2 && ch == 0) {
            int nb1 = this.cHtab[atom][0];
            int nb2 = this.cHtab[atom][1];
            if (nb1 < this.MOLATOMS && nb2 < this.MOLATOMS && this.mol.getBond(this.bHtab[atom][nb1]).getType() != 3 && this.mol.getBond(this.bHtab[atom][nb2]).getType() != 3) {
                return true;
            }
        }
        return false;
    }

    private int getBondingElectrons(int atom1) {
        int j = this.cHtab[atom1].length;
        int valence = 0;
        for (int i = 0; i < j; ++i) {
            int atom2 = this.cHtab[atom1][i];
            if (this.bHtab[atom1][atom2] == -2) {
                ++valence;
                continue;
            }
            valence += this.mol.getBond(this.bHtab[atom1][atom2]).getType();
        }
        return valence;
    }

    private int[] getDBandSBCount(int atom) {
        int j = this.cHtab[atom].length;
        int[] b = new int[2];
        for (int i = 0; i < j; ++i) {
            int nb = this.cHtab[atom][i];
            if (nb < this.MOLATOMS) {
                int bt = this.mol.getBond(this.bHtab[nb][atom]).getType();
                if (bt == 2) {
                    b[0] = b[0] + 1;
                    continue;
                }
                if (bt != 1) continue;
                b[1] = b[1] + 1;
                continue;
            }
            b[1] = b[1] + 1;
        }
        return b;
    }

    public double[] getTotalCharge() {
        return this.qh;
    }

    public int[] getMappingVector() {
        return this.map;
    }

    public int getHOMOLevel() {
        for (int i = 1; i < this.orbType.length; ++i) {
            if (this.orbType[i] != 1) continue;
            return i;
        }
        return 0;
    }

    public void setP1P2P3P4(double p1, double p2, double p3, double p4) {
        this.P1 = p1;
        this.P2 = p2;
        this.P3 = p3;
        this.P4 = p4;
    }

    private int getSphereAtomIndex(int a) {
        for (int i = 0; i < this.sa.length; ++i) {
            if (this.sa[i] != a) continue;
            return i;
        }
        return -1;
    }

    private int getMappedAtom(int mapIndx) {
        for (int i = 0; i < this.MOLATOMS; ++i) {
            if (this.map[i] != mapIndx) continue;
            return i;
        }
        return -1;
    }
}

