/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

import chemaxon.calculations.Charge;
import chemaxon.calculations.HMO;
import chemaxon.core.calculations.LonePairCounter;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;

public class HuckelAnalysis
extends HMO {
    LonePairCounter LPc;
    private double[] eigVal = null;
    private double[][] eigVec = null;
    private double[] piChargeDens = null;
    private double[] totalChargeDens = null;
    private double[] efilLocEnergy = null;
    private double[] nfilLocEnergy = null;
    private int[] eOrder = null;
    private int[] nOrder = null;
    private int[] Order = null;
    private double[][] bondOrder = null;
    private int[] mapping = null;
    private double[] fv = null;
    private boolean[] araCh = null;
    private Charge chg;
    private int homo = 0;
    private double piE = Double.NaN;
    int MOLATOMS;
    private final int UNKNOWN = -1;
    private boolean onlyArACH = false;
    boolean aromaticFlag = false;
    boolean resultFlag;
    boolean hValenceError;
    int sphSize;
    Molecule molCopy;
    boolean standardCalc = true;
    boolean allowHyperconj = !this.standardCalc;

    public HuckelAnalysis() {
    }

    public HuckelAnalysis(boolean hmo) {
        this.setStandardHMOCalc(hmo);
    }

    public HuckelAnalysis(Molecule m) {
        this.mol = m.cloneMoleculeWithDocument();
        this.hValenceError = false;
        this.init();
    }

    @Override
    public void setMolecule(Molecule m) {
        this.mol = m.cloneMoleculeWithDocument();
        this.hValenceError = false;
        this.init();
    }

    public void setStandardHMOCalc(boolean stdHMO) {
        this.standardCalc = stdHMO;
        if (this.standardCalc) {
            this.allowHyperconjugation(false);
        } else {
            this.allowHyperconjugation(true);
        }
    }

    protected void allowHyperconjugation(boolean hypConj) {
        this.allowHyperconj = hypConj;
    }

    public boolean isResultAvailable() {
        return this.resultFlag;
    }

    private void setResultFlag(boolean r) {
        this.resultFlag = this.hasCriticalError() ? false : r;
    }

    public boolean getCriticalErrorFlag() {
        return this.hasCriticalError();
    }

    private void initHMO() {
        this.chg = new Charge();
        this.chg.setMolecule(this.mol);
        this.chg.allowHMOHypConj(this.allowHyperconj);
        this.chg.initHMOCalc();
        this.setStdHMOCalc(this.standardCalc);
    }

    private boolean hasCriticalError() {
        return this.chg != null && this.chg.getCriticalErrorFlag();
    }

    private void init() {
        this.MOLATOMS = this.mol.getAtomCount();
        this.araCh = new boolean[this.MOLATOMS];
        this.eigVal = null;
        this.eigVec = null;
        this.piChargeDens = null;
        this.totalChargeDens = null;
        this.efilLocEnergy = null;
        this.nfilLocEnergy = null;
        this.eOrder = null;
        this.nOrder = null;
        this.Order = null;
        this.bondOrder = null;
        this.piE = Double.NaN;
        this.aromaticFlag = false;
        this.setCHArA(this.mol);
    }

    private void setElectrophilicOrder() {
        int i;
        if (this.hasCriticalError()) {
            return;
        }
        for (i = 0; i < this.MOLATOMS; ++i) {
            this.Order[i] = i;
        }
        for (i = 0; i < this.MOLATOMS; ++i) {
            for (int j = i + 1; j < this.MOLATOMS; ++j) {
                if (this.onlyArACH) {
                    if (!this.araCh[i] && this.araCh[j]) {
                        this.changeOrder(i, j, this.Order);
                    }
                    if (this.araCh[i] && !this.araCh[j]) {
                        this.changeOrder(j, i, this.Order);
                    }
                    if (!this.araCh[i] || !this.araCh[j] || !(this.efilLocEnergy[j] <= this.efilLocEnergy[i])) continue;
                    this.changeOrder(i, j, this.Order);
                    continue;
                }
                if (this.efilLocEnergy[j] <= this.efilLocEnergy[i]) {
                    this.changeOrder(i, j, this.Order);
                    continue;
                }
                if (Double.isNaN(this.efilLocEnergy[i]) && !Double.isNaN(this.efilLocEnergy[j])) {
                    this.changeOrder(i, j, this.Order);
                    continue;
                }
                if (Double.isNaN(this.efilLocEnergy[i]) || !Double.isNaN(this.efilLocEnergy[j])) continue;
                this.changeOrder(j, i, this.Order);
            }
        }
        if (this.onlyArACH) {
            for (i = 0; i < this.MOLATOMS; ++i) {
                int ind = this.Order[i];
                if (!Double.isNaN(this.efilLocEnergy[ind])) {
                    if (this.araCh[ind]) {
                        this.eOrder[ind] = i;
                        continue;
                    }
                    this.eOrder[ind] = -1;
                    continue;
                }
                this.eOrder[ind] = -1;
            }
        } else {
            for (i = 0; i < this.MOLATOMS; ++i) {
                int ind = this.Order[i];
                this.eOrder[ind] = !Double.isNaN(this.efilLocEnergy[ind]) ? i : -1;
            }
        }
    }

    private void setCHArA(Molecule m) {
        for (int atom = 0; atom < this.MOLATOMS; ++atom) {
            this.araCh[atom] = false;
            if (!m.getAtom(atom).hasAromaticBond()) continue;
            this.araCh[atom] = true;
            this.aromaticFlag = true;
        }
    }

    private void changeOrder(int index1, int index2, int[] ordered) {
        int indexOf1 = 0;
        while (ordered[indexOf1] != index1) {
            ++indexOf1;
        }
        int indexOf2 = 0;
        while (ordered[indexOf2] != index2) {
            ++indexOf2;
        }
        if (indexOf2 - indexOf1 > 1) {
            int a = ordered[indexOf2];
            int i = 0;
            while (indexOf2 - i > indexOf1) {
                ordered[indexOf2 - i] = ordered[indexOf2 - i - 1];
                ++i;
            }
            ordered[indexOf1] = a;
        } else if (indexOf2 > indexOf1) {
            int a = ordered[indexOf1];
            ordered[indexOf1] = ordered[indexOf2];
            ordered[indexOf2] = a;
        }
    }

    public void calcAtomicElectrophility() {
        this.efilLocEnergy = new double[this.MOLATOMS];
        this.Order = new int[this.MOLATOMS];
        this.eOrder = new int[this.MOLATOMS];
        int[] usedAtoms = new int[this.MOLATOMS];
        double[] locEnergy = new double[this.MOLATOMS];
        this.setRequiredParameterType(1);
        this.setENuCalc(true);
        this.initHMO();
        if (this.hasCriticalError()) {
            return;
        }
        double pienergy = -1.0;
        for (int i = 0; i < this.MOLATOMS; ++i) {
            int j;
            int a;
            if (this.chg.delocAble[i] != 1 || usedAtoms[i] != 0 || this.isForbidden(i)) continue;
            pienergy = this.calcPiEnergy(i);
            if (this.sphSize == 1) {
                a = this.chg.sAtoms[0];
                usedAtoms[a] = 1;
                locEnergy[a] = pienergy;
                continue;
            }
            this.setIslandECount(this.sphSize);
            for (j = 0; j < this.sphSize; ++j) {
                a = this.chg.sAtoms[j];
                usedAtoms[a] = 1;
            }
            for (j = 0; j < this.sphSize; ++j) {
                a = this.chg.sAtoms[j];
                locEnergy[a] = pienergy - this.calcTruncPiEnergy(a, 1);
            }
            this.reSetIslandEACount();
        }
        if (this.piEnergy == -1.0) {
            this.setResultFlag(false);
        } else {
            this.setResultFlag(true);
        }
        this.setELocEnergy(locEnergy);
        this.setElectrophilicOrder();
        this.setENuCalc(false);
    }

    private boolean isForbidden(int ai) {
        int y;
        MolAtom a;
        return this.standardCalc && (a = this.mol.getAtom(ai)).getAtno() == 6 && (y = a.getBondCount() + a.getImplicitHcount()) == 4;
    }

    private double calcTruncPiEnergy(int exclAtom, int chag) {
        if (this.hasCriticalError()) {
            return Double.NaN;
        }
        this.getRebuildMol(exclAtom, chag);
        int si = this.getSphereAtomIndex(exclAtom);
        this.chg.sAtoms[si] = -1;
        --this.chg.maxDelocLength;
        this.setHMOVariables(this.chg.MOLATOMS, this.mol, this.chg.sAtoms, this.chg.maxDelocLength, this.chg.hyperC, this.chg.getPolarGroups().carboxy);
        if (this.standardCalc) {
            this.setTakeResonance(false);
        } else {
            this.setTakeResonance(false);
        }
        this.calcHMO(this.mol);
        double pie = this.getPiEnergy();
        this.chg.sAtoms[si] = exclAtom;
        ++this.chg.maxDelocLength;
        this.mol = this.molCopy;
        this.setElectronCorrection(0);
        return pie;
    }

    private double calcPiEnergy(int ai) {
        if (this.hasCriticalError()) {
            return Double.NaN;
        }
        if (!this.standardCalc) {
            this.setTakeResonance(true);
            this.setAllowedResParameters(true);
        } else {
            this.setTakeResonance(false);
            this.setAllowedResParameters(false);
        }
        this.chg.calcHMODelocIsland(ai);
        this.sphSize = this.chg.maxDelocLength;
        this.setHMOVariables(this.chg.MOLATOMS, this.mol, this.chg.sAtoms, this.chg.maxDelocLength, this.chg.hyperC, this.chg.getPolarGroups().carboxy);
        this.calcHMO(this.mol);
        if (this.isNewResStrucGenerated()) {
            this.mol = this.getNewResStruct();
            this.initAgain();
            this.setTakeResonance(false);
            this.setAllowedResParameters(true);
            this.chg.calcHMODelocIsland(ai);
            this.sphSize = this.chg.maxDelocLength;
            this.setHMOVariables(this.chg.MOLATOMS, this.mol, this.chg.sAtoms, this.chg.maxDelocLength, this.chg.hyperC, this.chg.getPolarGroups().carboxy);
            this.calcHMO(this.mol);
        }
        this.setAllowedResParameters(false);
        return this.getPiEnergy();
    }

    private void initAgain() {
        this.araCh = new boolean[this.MOLATOMS];
        this.initHMO();
        this.aromaticFlag = false;
        this.setCHArA(this.mol);
    }

    private void setEigenParameters() {
        this.eigVal = this.getRealEigenValue();
        this.eigVec = this.getEigenVector();
    }

    private void setELocEnergy(double[] loce) {
        for (int i = 0; i < this.MOLATOMS; ++i) {
            this.efilLocEnergy[i] = loce[i] == 0.0 ? Double.NaN : loce[i];
        }
    }

    public double[] getElecLocEnergy() {
        return this.efilLocEnergy;
    }

    public int[] getElectrophilicOrder() {
        return this.eOrder;
    }

    public void calcAtomicNucleophility() {
        this.nfilLocEnergy = new double[this.MOLATOMS];
        this.nOrder = new int[this.MOLATOMS];
        this.Order = new int[this.MOLATOMS];
        int[] usedAtoms = new int[this.MOLATOMS];
        double[] locEnergy = new double[this.MOLATOMS];
        this.setRequiredParameterType(1);
        this.setENuCalc(true);
        this.initHMO();
        if (this.hasCriticalError()) {
            return;
        }
        double pienergy = -1.0;
        for (int i = 0; i < this.MOLATOMS; ++i) {
            int j;
            int a;
            if (this.chg.delocAble[i] != 1 || usedAtoms[i] != 0 || this.isForbidden(i)) continue;
            pienergy = this.calcPiEnergy(i);
            if (this.sphSize == 1) {
                a = this.chg.sAtoms[0];
                usedAtoms[a] = 1;
                locEnergy[a] = pienergy;
                continue;
            }
            this.setIslandECount(this.sphSize);
            for (j = 0; j < this.sphSize; ++j) {
                a = this.chg.sAtoms[j];
                usedAtoms[a] = 1;
            }
            for (j = 0; j < this.sphSize; ++j) {
                a = this.chg.sAtoms[j];
                locEnergy[a] = pienergy - this.calcExtendedPiEnergy(a, -1);
            }
            this.reSetIslandEACount();
        }
        if (this.piEnergy == -1.0) {
            this.setResultFlag(false);
        } else {
            this.setResultFlag(true);
        }
        this.setNLocEnergy(locEnergy);
        this.setNucleophilicOrder();
        this.setENuCalc(false);
    }

    private boolean isUnSaturatedAtom(int a) {
        MolAtom ma = this.mol.getAtom(a);
        if (this.isDBbonded(ma)) {
            return true;
        }
        if (ma.getCharge() != 0) {
            return true;
        }
        int[] LPCount = new int[this.MOLATOMS];
        this.LPc = new LonePairCounter();
        LPCount = this.LPc.getLonePairCount(this.mol);
        return LPCount[a] != 0;
    }

    private double calcExtendedPiEnergy(int exclAtom, int chag) {
        if (this.hasCriticalError()) {
            return Double.NaN;
        }
        this.getRebuildMol(exclAtom, chag);
        int si = this.getSphereAtomIndex(exclAtom);
        this.chg.sAtoms[si] = -1;
        --this.chg.maxDelocLength;
        this.setHMOVariables(this.chg.MOLATOMS, this.mol, this.chg.sAtoms, this.chg.maxDelocLength, this.chg.hyperC, this.chg.getPolarGroups().carboxy);
        if (this.standardCalc) {
            this.setTakeResonance(false);
        } else {
            this.setTakeResonance(true);
        }
        this.calcHMO(this.mol);
        double pie = this.getPiEnergy();
        this.chg.sAtoms[si] = exclAtom;
        ++this.chg.maxDelocLength;
        this.mol = this.molCopy;
        this.setElectronCorrection(0);
        return pie;
    }

    private void getRebuildMol(int ai, int chag) {
        this.molCopy = this.mol.cloneMoleculeWithDocument();
        if (this.standardCalc) {
            if (chag > 0) {
                this.setElectronCorrection(-2);
            } else if (chag < 0) {
                this.setElectronCorrection(0);
            }
            return;
        }
        this.mol.dearomatize();
        MolAtom a = this.mol.getAtom(ai);
        boolean find = false;
        for (int i = 0; !find && i < a.getBondCount(); ++i) {
            MolBond b = a.getBond(i);
            int t = b.getType();
            MolAtom aa = b.getOtherAtom(a);
            int initHc = aa.getImplicitHcount();
            int initChg = aa.getCharge();
            int pc = aa.getAtno();
            if (t <= 1) continue;
            b.setType(t - 1);
            if (chag == 1) {
                if (pc == 7) {
                    aa.setRadical(2);
                } else if (pc == 8) {
                    aa.setRadical(2);
                } else if (pc == 16) {
                    aa.setRadical(2);
                }
                aa.setCharge(chag + initChg);
            } else if (chag == -1) {
                aa.setCharge(chag + initChg);
            }
            aa.setImplicitHcount(initHc);
            find = true;
        }
        this.mol.aromatize(1);
    }

    private boolean isDBbonded(MolAtom a) {
        for (int i = 0; i < a.getBondCount(); ++i) {
            MolBond b = a.getBond(i);
            int t = b.getType();
            if (t <= 1) continue;
            return true;
        }
        return false;
    }

    private void setNLocEnergy(double[] loce) {
        for (int i = 0; i < this.MOLATOMS; ++i) {
            this.nfilLocEnergy[i] = loce[i] == 0.0 ? Double.NaN : loce[i];
        }
    }

    private void setNucleophilicOrder() {
        int i;
        for (i = 0; i < this.MOLATOMS; ++i) {
            this.Order[i] = i;
        }
        for (i = 0; i < this.MOLATOMS; ++i) {
            for (int j = i + 1; j < this.MOLATOMS; ++j) {
                if (this.onlyArACH) {
                    if (!this.araCh[i] && this.araCh[j]) {
                        this.changeOrder(i, j, this.Order);
                    }
                    if (this.araCh[i] && !this.araCh[j]) {
                        this.changeOrder(j, i, this.Order);
                    }
                    if (!this.araCh[i] || !this.araCh[j] || !(this.nfilLocEnergy[j] <= this.nfilLocEnergy[i])) continue;
                    this.changeOrder(i, j, this.Order);
                    continue;
                }
                if (this.nfilLocEnergy[j] <= this.nfilLocEnergy[i]) {
                    this.changeOrder(i, j, this.Order);
                    continue;
                }
                if (Double.isNaN(this.nfilLocEnergy[i]) && !Double.isNaN(this.nfilLocEnergy[j])) {
                    this.changeOrder(i, j, this.Order);
                    continue;
                }
                if (Double.isNaN(this.nfilLocEnergy[i]) || !Double.isNaN(this.nfilLocEnergy[j])) continue;
                this.changeOrder(j, i, this.Order);
            }
        }
        if (this.onlyArACH) {
            for (i = 0; i < this.MOLATOMS; ++i) {
                int ind = this.Order[i];
                if (!Double.isNaN(this.nfilLocEnergy[ind])) {
                    if (this.araCh[ind]) {
                        this.nOrder[ind] = i;
                        continue;
                    }
                    this.nOrder[ind] = -1;
                    continue;
                }
                this.nOrder[ind] = -1;
            }
        } else {
            for (i = 0; i < this.MOLATOMS; ++i) {
                int ind = this.Order[i];
                this.nOrder[ind] = !Double.isNaN(this.nfilLocEnergy[ind]) ? i : -1;
            }
        }
    }

    public double[] getNucLocEnergy() {
        return this.nfilLocEnergy;
    }

    public int[] getNucleophilicOrder() {
        return this.nOrder;
    }

    public void calcHMOPiEnergy() {
        this.initHMO();
        if (this.hasCriticalError()) {
            return;
        }
        this.setRequiredParameterType(1);
        int[] usedAtoms = new int[this.MOLATOMS];
        this.piE = 0.0;
        for (int i = 0; i < this.MOLATOMS; ++i) {
            if (this.chg.delocAble[i] != 1 || usedAtoms[i] != 0 || this.isForbidden(i)) continue;
            this.piE += this.calcPiEnergy(i);
            this.setIslandECount(this.sphSize);
            for (int j = 0; j < this.sphSize; ++j) {
                int a = this.chg.sAtoms[j];
                usedAtoms[a] = 1;
            }
            this.reSetIslandEACount();
        }
        if (this.piE == 0.0) {
            this.piE = Double.NaN;
            this.setResultFlag(false);
        } else {
            this.setResultFlag(true);
        }
    }

    public double getTotalPiEnergy() {
        return this.piE;
    }

    public void calcHMOChargeDensity() {
        this.setRequiredParameterType(1);
        int[] usedAtoms = new int[this.MOLATOMS];
        double[] pich = new double[this.MOLATOMS];
        double[] totch = new double[this.MOLATOMS];
        this.piChargeDens = new double[this.MOLATOMS];
        this.totalChargeDens = new double[this.MOLATOMS];
        this.initHMO();
        if (this.hasCriticalError()) {
            return;
        }
        for (int i = 0; i < this.MOLATOMS; ++i) {
            this.piChargeDens[i] = Double.NaN;
            this.totalChargeDens[i] = Double.NaN;
        }
        int iac = 0;
        for (int i = 0; i < this.MOLATOMS; ++i) {
            int a;
            int j;
            if (this.chg.delocAble[i] != 1 || usedAtoms[i] != 0 || this.isForbidden(i)) continue;
            this.calcPiEnergy(i);
            if (this.sphSize <= 1) continue;
            for (j = 0; j < this.sphSize; ++j) {
                a = this.chg.sAtoms[j];
                usedAtoms[a] = 1;
                ++iac;
            }
            pich = this.getPiChargeDens();
            totch = this.getTotalCharge();
            for (j = 0; j < this.sphSize; ++j) {
                a = this.chg.sAtoms[j];
                this.piChargeDens[a] = -1.0 * pich[a];
                this.totalChargeDens[a] = totch[a];
            }
        }
        if (iac == 0) {
            this.setResultFlag(false);
        } else {
            this.setResultFlag(true);
        }
    }

    public double[] getPiCDens() {
        return this.piChargeDens;
    }

    public double[] getTotCDens() {
        return this.totalChargeDens;
    }

    private void calcBondOrders() {
        this.setRequiredParameterType(1);
        int[] usedAtoms = new int[this.MOLATOMS];
        this.bondOrder = new double[this.MOLATOMS][this.MOLATOMS];
        this.fv = new double[this.MOLATOMS];
        if (this.hasCriticalError()) {
            return;
        }
        for (int i = 0; i < this.MOLATOMS; ++i) {
            int a;
            int j;
            if (this.chg.delocAble[i] != 1 || usedAtoms[i] != 0 || this.isForbidden(i)) continue;
            this.calcPiEnergy(i);
            for (j = 0; j < this.sphSize; ++j) {
                a = this.chg.sAtoms[j];
                usedAtoms[a] = 1;
            }
            this.mapping = this.getMappingVector();
            this.homo = this.getHOMOLevel();
            this.setEigenParameters();
            for (j = 0; j < this.sphSize; ++j) {
                a = this.chg.sAtoms[j];
                this.setBondOrder(a);
            }
        }
    }

    private void setBondOrder(int atom) {
        int i;
        int r = atom;
        int rr = this.mapping[r] - 1;
        for (int j = 0; j < this.chg.cHtab[r].length; ++j) {
            int s = this.chg.cHtab[r][j];
            if (s >= this.MOLATOMS) continue;
            if (this.getSphereAtomIndex(s) != -1) {
                int ss = this.mapping[s] - 1;
                i = 0;
                while (i < this.homo) {
                    int ii = i++;
                    double[] dArray = this.bondOrder[r];
                    int n = s;
                    dArray[n] = dArray[n] + 2.0 * this.eigVec[rr][ii] * this.eigVec[ss][ii];
                }
                this.bondOrder[r][s] = 1.0 + this.bondOrder[r][s];
                continue;
            }
            this.bondOrder[r][s] = 0.0;
        }
        int nc = 0;
        for (i = 0; i < this.MOLATOMS; ++i) {
            if (this.bondOrder[r][i] == 0.0) continue;
            int n = r;
            this.fv[n] = this.fv[n] + this.bondOrder[r][i];
            ++nc;
        }
        int diff = this.chg.cHtab[r].length - nc;
        this.fv[r] = this.fv[r] + (double)diff;
        int w = r + 1;
    }

    public boolean getHValenceError() {
        return this.hValenceError;
    }

    private int getSphereAtomIndex(int a) {
        for (int i = 0; i < this.chg.maxDelocLength; ++i) {
            if (this.chg.sAtoms[i] != a) continue;
            return i;
        }
        return -1;
    }
}

