/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

import chemaxon.calculations.MoleculeProjector;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.linalg.GradientOptimization;
import chemaxon.marvin.modelling.linalg.JLinAlg;
import chemaxon.marvin.modelling.struc.ConformerEquivalenceUtils;
import chemaxon.marvin.modelling.struc.MolGeom;
import chemaxon.struc.Molecule;
import java.io.IOException;

public class MPOptimizer
implements Runnable,
GradientOptimization.FunctionToMinimize {
    private Molecule m = null;
    private double[] area = new double[3];
    private boolean minimize = true;
    private MoleculeProjector mp = null;
    private boolean areaMode = true;
    private double[] var0 = null;
    private double[] var = null;
    private double[] grad = null;
    private double[] rot = null;
    private double step = 1.0E-4;
    private double[] center = null;
    private double[][] coord = null;
    private double minimalArea = 0.0;
    private Molecule minimalAreaProjection = null;
    private double maximalArea = 0.0;
    private Molecule maximalAreaProjection = null;
    private double originalArea = 0.0;
    private Molecule originalAreaProjection = null;
    private double minimalRadius = 0.0;
    private double maximalRadius = 0.0;
    private double radius = 0.0;
    private double origRadius = 0.0;
    private boolean valid = false;
    private double[] radii = null;
    private boolean fullMode = true;
    private boolean optimize = false;

    public MPOptimizer() {
    }

    public MPOptimizer(Molecule m) {
        this.setMolecule(m);
    }

    public static void main(String[] args) {
        String usage = "Usage:\n\t... MPOptimizer [-h] [-g] filename(s)\n\nParameters:\n\t-h: This help\n\t-g: GUI display\n";
        boolean useGui = false;
        if (args.length == 0) {
            System.err.println(usage);
        }
        for (int i = 0; i < args.length; ++i) {
            String inputName = args[i];
            if (inputName.equals("-g")) {
                useGui = true;
                continue;
            }
            if (inputName.equals("-h")) {
                System.err.println(usage);
                System.exit(0);
            }
            try {
                System.err.println("Reading file: " + inputName);
                MolImporter mi = !inputName.equals("-") ? new MolImporter(inputName) : new MolImporter(System.in);
                Molecule m = null;
                int counter = 0;
                while ((m = mi.read()) != null) {
                    long time = System.currentTimeMillis();
                    System.err.println("Processing molecule #" + ++counter + " of " + inputName);
                    MPOptimizer mp = null;
                    try {
                        mp = new MPOptimizer(m);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    String areaString = null;
                    String radiusString = null;
                    System.out.print(MolExporter.exportToFormat(mp.getM(), "sdf"));
                    mp.run();
                    System.err.println("Original orientation, XY projection:");
                    String label = "Area: " + debugPrintout.formatNumber(8, 2, mp.getArea()) + " Angstrom^2";
                    System.err.println(label);
                    label = "Radius: " + debugPrintout.formatNumber(8, 2, mp.getRadius()) + " Angstrom";
                    System.err.println(label);
                    areaString = debugPrintout.formatNumber(8, 2, mp.getMinimalArea());
                    mp.getMinimalAreaProjection().setProperty("projectionarea", areaString);
                    radiusString = debugPrintout.formatNumber(8, 2, mp.getMinimalRadius());
                    mp.getMinimalAreaProjection().setProperty("projectionradius", radiusString);
                    System.err.println("Minimal projection:");
                    label = "Area: " + debugPrintout.formatNumber(8, 2, mp.getMinimalArea()) + " Angstrom^2";
                    System.err.println(label);
                    label = "Radius: " + debugPrintout.formatNumber(8, 2, mp.getMinimalRadius()) + " Angstrom";
                    System.err.println(label);
                    System.out.print(MolExporter.exportToFormat(mp.getMinimalAreaProjection(), "sdf"));
                    areaString = debugPrintout.formatNumber(8, 2, mp.getMaximalArea());
                    mp.getMaximalAreaProjection().setProperty("projectionarea", areaString);
                    radiusString = debugPrintout.formatNumber(8, 2, mp.getMaximalRadius());
                    mp.getMaximalAreaProjection().setProperty("projectionradius", radiusString);
                    System.err.println("Maximal projection:");
                    label = "Radius: " + debugPrintout.formatNumber(8, 2, mp.getMaximalRadius()) + " Angstrom";
                    label = label + "\nArea: " + debugPrintout.formatNumber(8, 2, mp.getMaximalArea()) + " Angstrom^2";
                    System.err.println(label);
                    System.out.print(MolExporter.exportToFormat(mp.getMaximalAreaProjection(), "sdf"));
                    long elapsed = System.currentTimeMillis() - time;
                    System.err.println("Elapsed time (ms): " + elapsed);
                }
                continue;
            }
            catch (MolFormatException e) {
                e.printStackTrace();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        MoleculeProjector molProj = new MoleculeProjector(this.m);
        this.area[0] = molProj.getArea();
        this.originalArea = this.area[0];
        this.origRadius = molProj.radius;
        this.area[1] = molProj.getMinimalArea();
        this.area[2] = molProj.getMaximalArea();
        if (!this.valid) {
            this.getOriginalArea();
            this.m = this.maximalAreaProjection.cloneMolecule();
            this.getMaximalArea();
            this.m = this.minimalAreaProjection.cloneMolecule();
            this.getMinimalArea();
            this.setValid(true);
        }
    }

    @Override
    public double[] getFunctionGradient() {
        double e0 = this.getFunctionValue();
        int i = 0;
        while (i < this.grad.length) {
            int n = i;
            this.var[n] = this.var[n] + this.step;
            this.setVariables(this.var);
            double e1 = this.getFunctionValue();
            int n2 = i;
            this.var[n2] = this.var[n2] - 2.0 * this.step;
            this.setVariables(this.var);
            double e2 = this.getFunctionValue();
            this.grad[i] = (e1 - e2) / (2.0 * this.step);
            int n3 = i++;
            this.var[n3] = this.var[n3] + this.step;
            this.setVariables(this.var);
        }
        return this.grad;
    }

    @Override
    public double getFunctionValue() {
        double val = 0.0;
        if (this.areaMode) {
            this.mp.setM(this.m);
            val = this.mp.calculateArea();
        } else {
            this.mp.setM(this.m);
            val = this.mp.calculateArea();
            val = this.mp.radius;
        }
        if (!this.minimize) {
            val = -val;
        }
        return val;
    }

    @Override
    public double[] getVariables() {
        return this.var;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public void print() {
        System.err.println();
    }

    @Override
    public void print(String comment) {
        System.err.println(comment);
    }

    @Override
    public boolean setVariables(double[] var) {
        if (this.rot == null) {
            double[] rot = new double[var.length];
        }
        if (this.var.length == var.length) {
            for (int i = 0; i < var.length; ++i) {
                this.rot[i] = var[i] - this.var0[i];
                this.var0[i] = var[i];
            }
        }
        this.coord = ConformerEquivalenceUtils.getMolCoordinates(this.m, this.coord);
        this.coord = this.rot(this.coord, this.rot);
        ConformerEquivalenceUtils.setMolCoordinates(this.m, this.coord);
        return true;
    }

    private double[][] rot(double[][] coord, double[] rot) {
        double theta = JLinAlg.VLength(rot);
        double[] a = JLinAlg.VectUnit(2, rot, 0, null);
        double ax = a[0];
        double ay = a[1];
        double az = 0.0;
        if (this.center == null) {
            this.center = new double[3];
            for (int i = 0; i < coord.length; ++i) {
                this.center[0] = this.center[0] + coord[i][0];
                this.center[1] = this.center[1] + coord[i][1];
                this.center[2] = this.center[2] + coord[i][2];
            }
            this.center[0] = this.center[0] / (double)coord.length;
            this.center[1] = this.center[1] / (double)coord.length;
            this.center[2] = this.center[2] / (double)coord.length;
        }
        coord = MolGeom.rot(coord, theta, this.center[0], this.center[1], this.center[2], ax, ay, az);
        return coord;
    }

    public Molecule getM() {
        return this.m;
    }

    protected void setM(Molecule m) {
        this.mp = new MoleculeProjector(m);
        this.setValid(false);
        this.m = m.cloneMolecule();
    }

    public void scaleRadii(double s) {
        if (this.mp == null) {
            throw new UnsupportedOperationException("Set molecule first then scale radii.");
        }
        this.mp.scaleRadii(s);
    }

    public void setMolecule(Molecule m) {
        this.m = m.cloneMolecule();
        this.originalAreaProjection = m.cloneMolecule();
        this.coord = ConformerEquivalenceUtils.getMolCoordinates(m);
        this.center = null;
        this.var0 = new double[2];
        this.var = new double[2];
        this.grad = new double[2];
        this.rot = new double[2];
        this.mp = new MoleculeProjector(m);
        this.originalArea = this.mp.calculateArea();
        double area = this.mp.getMaximalArea();
        if (area > this.originalArea) {
            this.maximalArea = area;
            this.maximalAreaProjection = this.mp.getMaximalProjection();
        } else {
            this.maximalArea = this.originalArea;
            this.maximalAreaProjection = m.cloneMolecule();
        }
        area = this.mp.getMinimalArea();
        if (area < this.originalArea) {
            this.minimalArea = area;
            this.minimalAreaProjection = this.mp.getMinimalProjection();
        } else {
            this.minimalArea = this.originalArea;
            this.minimalAreaProjection = m.cloneMolecule();
        }
        area = this.mp.getMaximalArea();
        if (area < this.minimalArea) {
            this.minimalArea = area;
            this.minimalAreaProjection = this.mp.getMaximalProjection();
        }
    }

    public boolean isMinimize() {
        return this.minimize;
    }

    public void setMinimize(boolean minimize) {
        this.minimize = minimize;
    }

    private void setMinimalMode(boolean minimize) {
        this.setMinimize(minimize);
    }

    public boolean isAreaMode() {
        return this.areaMode;
    }

    public void setAreaMode(boolean areaMode) {
        this.areaMode = areaMode;
    }

    public double getMinimalArea() {
        if (!this.isValid()) {
            this.setMinimalMode(true);
            this.areaMode = true;
            this.center = null;
            GradientOptimization o = new GradientOptimization(this);
            o.setGradientRMSLimit(0.01);
            if (this.isOptimize()) {
                try {
                    o.run();
                }
                catch (GradientOptimization.GradientOptimizationException e) {
                    e.printStackTrace();
                }
            }
            this.minimalArea = this.getFunctionValue();
            this.areaMode = false;
            this.minimalRadius = this.getFunctionValue();
            this.areaMode = true;
            this.minimalAreaProjection = this.m.cloneMolecule();
        }
        return this.minimalArea;
    }

    private void setMinimalArea(double minimalArea) {
        this.minimalArea = minimalArea;
    }

    public double getMaximalArea() {
        if (!this.isValid()) {
            this.setMinimalMode(false);
            this.areaMode = true;
            this.center = null;
            GradientOptimization o = new GradientOptimization(this);
            o.setGradientRMSLimit(0.01);
            if (this.isOptimize()) {
                try {
                    o.run();
                }
                catch (GradientOptimization.GradientOptimizationException e) {
                    e.printStackTrace();
                }
            }
            this.maximalArea = -this.getFunctionValue();
            this.areaMode = false;
            this.maximalRadius = -this.getFunctionValue();
            this.areaMode = true;
            this.maximalAreaProjection = this.m.cloneMolecule();
        }
        return this.maximalArea;
    }

    private void setMaximalArea(double maximalArea) {
        this.maximalArea = maximalArea;
    }

    public double getArea() {
        if (!this.isValid()) {
            this.fullMode = false;
            this.setMinimalMode(true);
            this.setAreaMode(false);
            this.run();
        }
        return this.getOriginalArea();
    }

    public double getOriginalArea() {
        if (!this.isValid()) {
            this.mp = new MoleculeProjector(this.m);
            this.originalArea = this.mp.calculateArea();
            this.radius = this.mp.getRadius();
        }
        return this.originalArea;
    }

    private void setOriginalArea(double originalArea) {
        this.originalArea = originalArea;
    }

    public double getMinimalRadius() {
        if (!this.isValid()) {
            this.fullMode = false;
            this.center = null;
            this.setMinimalMode(true);
            this.setAreaMode(false);
            this.center = null;
            GradientOptimization o = new GradientOptimization(this);
            o.setGradientRMSLimit(0.01);
            try {
                o.run();
            }
            catch (GradientOptimization.GradientOptimizationException e) {
                e.printStackTrace();
            }
            this.minimalRadius = this.getFunctionValue();
            this.areaMode = true;
        }
        return this.minimalRadius;
    }

    private void setMinimalRadius(double minimalRadius) {
        this.minimalRadius = minimalRadius;
    }

    public double getMaximalRadius() {
        if (!this.isValid()) {
            this.center = null;
            this.fullMode = false;
            this.setMinimalMode(false);
            this.setAreaMode(false);
            this.center = null;
            GradientOptimization o = new GradientOptimization(this);
            o.setGradientRMSLimit(0.01);
            try {
                o.run();
            }
            catch (GradientOptimization.GradientOptimizationException e) {
                e.printStackTrace();
            }
            this.maximalRadius = -this.getFunctionValue();
            this.areaMode = true;
        }
        return this.maximalRadius;
    }

    private void setMaximalRadius(double maximalRadius) {
        this.maximalRadius = maximalRadius;
    }

    public double getRadius() {
        if (!this.isValid()) {
            this.fullMode = false;
            this.setAreaMode(false);
            this.run();
        }
        return this.getOrigRadius();
    }

    public double getOrigRadius() {
        if (!this.isValid()) {
            this.fullMode = false;
            this.setAreaMode(false);
            this.run();
        }
        return this.origRadius;
    }

    private void setOrigRadius(double origRadius) {
        this.origRadius = origRadius;
    }

    public boolean isValid() {
        return this.valid;
    }

    private void setValid(boolean valid) {
        this.valid = valid;
    }

    public Molecule getMinimalAreaProjection() {
        if (!this.isValid()) {
            this.fullMode = false;
            this.setAreaMode(true);
            this.setMinimalMode(true);
            this.run();
        }
        return this.minimalAreaProjection;
    }

    public Molecule getMaximalAreaProjection() {
        if (!this.isValid()) {
            this.fullMode = false;
            this.setAreaMode(true);
            this.setMinimalMode(true);
            this.run();
        }
        return this.maximalAreaProjection;
    }

    public Molecule getOriginalAreaProjection() {
        return this.originalAreaProjection;
    }

    public boolean isOptimize() {
        return this.optimize;
    }

    public void setOptimize(boolean optimize) {
        this.optimize = optimize;
    }
}

