/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

import chemaxon.calculations.CalculationException;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.PeriodicSystem;

public class MolStandardizer {
    protected MolStandardizer() {
    }

    public Molecule calculate(Molecule input) throws CalculationException {
        Molecule molecule = input.cloneMoleculeWithDocument();
        molecule.expandSgroups();
        this.transformIonicGroups(molecule);
        molecule.dearomatize();
        molecule.aromatize(1);
        return molecule;
    }

    private static boolean hasValenceError(Molecule molecule) {
        for (int i = 0; i < molecule.getAtomCount(); ++i) {
            MolAtom a = molecule.getAtom(i);
            int chg = a.getCharge();
            int valence = a.getValence();
            if (a.hasValenceError()) {
                if (1 == a.getAtno()) {
                    return true;
                }
                if (a.getAtno() <= 10 && valence > 4) {
                    if (MolStandardizer.isRNO(a)) continue;
                    return true;
                }
                if (a.getAtno() > 10 && valence > 8) {
                    return true;
                }
                if (PeriodicSystem.isMetal(a.getAtno())) continue;
                return true;
            }
            if (7 != a.getAtno() || chg >= 0 || a.getBondCount() + (a.getImplicitHcount() - chg) <= 3) continue;
            return true;
        }
        return false;
    }

    protected void transformIonicGroups(Molecule mol) {
        block0: for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            MolAtom a = mol.getAtom(i);
            if (a.getAtno() == 7 && a.getCharge() == 1) {
                int radical = a.getRadical();
                if (radical == 2 || radical == 6 || radical == 10) continue;
                for (int j = a.getBondCount() - 1; j >= 0; --j) {
                    MolBond b;
                    MolAtom o = a.getLigand(j);
                    if (o.getAtno() != 8 || (b = a.getBond(j)).getType() != 1 || o.getCharge() != -1) continue;
                    MolStandardizer.transformIonic(mol, a, o, b);
                    continue block0;
                }
                continue;
            }
            if (a.getAtno() != 16 || a.getCharge() != 1) continue;
            int sc = 0;
            MolBond b1 = null;
            MolAtom o1 = null;
            for (int j = a.getBondCount() - 1; j >= 0; --j) {
                MolBond b;
                MolAtom o = a.getLigand(j);
                if (o.getAtno() == 8) {
                    b = a.getBond(j);
                    if (b.getType() != 1 || o.getCharge() != -1) continue;
                    b1 = b;
                    o1 = o;
                    continue;
                }
                if (o.getAtno() != 6 || (b = a.getBond(j)).getType() != 1 || o.getCharge() != 0) continue;
                ++sc;
            }
            if (b1 == null || sc < 2) continue;
            MolStandardizer.transformIonic(mol, a, o1, b1);
        }
    }

    private static void transformIonic(Molecule mol, MolAtom a1, MolAtom a2, MolBond b) {
        MolAtom a = a1.getCharge() > 0 ? a1 : a2;
        int type = 2;
        if (a.getImplicitHcount() > 0) {
            type = 1;
        } else {
            for (int i = a.getBondCount() - 1; i >= 0; --i) {
                MolAtom ligand = a.getLigand(i);
                if (!ligand.isImplicitizableH(0)) continue;
                mol.removeAtom(ligand);
                type = 1;
                break;
            }
        }
        b.setType(type);
        a1.setCharge(0);
        a2.setCharge(0);
        a1.valenceCheck();
        a2.valenceCheck();
    }

    private static boolean isRNO(MolAtom a) {
        if (a.getAtno() == 7) {
            for (int i = 0; i < a.getBondCount(); ++i) {
                if (a.getBond(i).getType() != 2) continue;
                return true;
            }
        }
        return false;
    }
}

