/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

import chemaxon.calculations.ProjectionArea;
import chemaxon.common.util.IntVector;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.linalg.JLinAlg;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.PeriodicSystem;
import chemaxon.util.DoubleIntQuickSort;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Vector;

class MoleculeProjector
implements Runnable {
    private Molecule m = null;
    private boolean minimalMode = true;
    private double minimalArea = 0.0;
    private Molecule minimalProjection = null;
    private double maximalArea = 0.0;
    private Molecule maximalProjection = null;
    private double originalArea = 0.0;
    private double minimalRadius = 0.0;
    private double maximalRadius = 0.0;
    protected double radius = 0.0;
    private double origRadius = 0.0;
    private boolean valid = false;
    private double[] radii = null;
    private double small = 1.0E-6;
    private String debugLine = "";

    public MoleculeProjector() {
    }

    public MoleculeProjector(Molecule m) {
        this.setM(m);
    }

    private double getAngle(double x1, double y1, double x2, double y2) {
        double cos;
        double d2;
        double d1 = Math.sqrt(x1 * x1 + y1 * y1);
        double sin = (-y1 * x2 + x1 * y2) / (d1 * (d2 = Math.sqrt(x2 * x2 + y2 * y2)));
        double alpha = Math.atan2(sin, cos = (x1 * x2 + y1 * y2) / (d1 * d2));
        if (alpha < 0.0) {
            alpha += Math.PI * 2;
        }
        return alpha;
    }

    protected double calculateArea() {
        double areaNew;
        int i;
        int i2;
        double area = 0.0;
        int nP = this.m.getAtomCount();
        if (nP == 0) {
            return 0.0;
        }
        int[][] orders = new int[4][nP];
        int[][] reverse = new int[4][nP];
        double[][] edges = new double[4][nP];
        for (i2 = 0; i2 < nP; ++i2) {
            for (int j = 0; j < orders.length; ++j) {
                orders[j][i2] = i2;
            }
            MolAtom a = this.m.getAtom(i2);
            edges[0][i2] = a.getX() - this.getRadii()[i2];
            edges[1][i2] = a.getY() - this.getRadii()[i2];
            edges[2][i2] = a.getX() + this.getRadii()[i2];
            edges[3][i2] = a.getY() + this.getRadii()[i2];
        }
        for (i2 = 0; i2 < edges.length; ++i2) {
            DoubleIntQuickSort dqs = new DoubleIntQuickSort(1, edges[i2], orders[i2]);
            dqs.qsort();
        }
        for (i2 = 0; i2 < nP; ++i2) {
            for (int j = 0; j < 4; ++j) {
                reverse[j][orders[j][i2]] = i2;
            }
        }
        BitSet overlapFlags = new BitSet();
        Vector<int[]> overlapPairs = new Vector<int[]>();
        for (int i3 = 0; i3 < orders[0].length; ++i3) {
            overlapFlags.clear();
            int indx = orders[0][i3];
            double ELimit = this.m.getAtom(indx).getX() + this.radii[indx];
            double SLimit = this.m.getAtom(indx).getY() - this.radii[indx];
            double NLimit = this.m.getAtom(indx).getY() + this.radii[indx];
            for (int j = i3 + 1; j < orders[0].length && edges[0][j] <= ELimit; ++j) {
                overlapFlags.set(orders[0][j]);
            }
            int iTest = overlapFlags.nextSetBit(0);
            while (iTest >= 0) {
                if (edges[1][reverse[1][iTest]] > NLimit || edges[3][reverse[3][iTest]] < SLimit) {
                    overlapFlags.clear(iTest);
                } else if (this.calculateCrossSections(indx, iTest) == null) {
                    overlapFlags.clear(iTest);
                }
                iTest = overlapFlags.nextSetBit(iTest + 1);
            }
            iTest = overlapFlags.nextSetBit(0);
            while (iTest >= 0) {
                int[] pair = new int[]{indx, iTest};
                overlapPairs.addElement(pair);
                iTest = overlapFlags.nextSetBit(iTest + 1);
            }
        }
        if (overlapPairs.size() == 0) {
            int iC = orders[0][0];
            this.radius = this.radii[iC];
            area = this.radius * this.radius * Math.PI;
            return area;
        }
        int[][] oPairs = new int[overlapPairs.size()][];
        overlapPairs.toArray((T[])oPairs);
        int[] nOverlap = new int[nP];
        for (int i4 = 0; i4 < oPairs.length; ++i4) {
            int n = oPairs[i4][0];
            nOverlap[n] = nOverlap[n] + 1;
            int n2 = oPairs[i4][1];
            nOverlap[n2] = nOverlap[n2] + 1;
        }
        int[][] oTab = new int[nP][];
        for (i = 0; i < nOverlap.length; ++i) {
            oTab[i] = new int[nOverlap[i]];
        }
        Arrays.fill(nOverlap, 0);
        for (i = 0; i < oPairs.length; ++i) {
            int i1;
            int i0 = oPairs[i][0];
            oTab[i0][nOverlap[i0]] = i1 = oPairs[i][1];
            int n = i0;
            nOverlap[n] = nOverlap[n] + 1;
            oTab[i1][nOverlap[i1]] = i0;
            int n3 = i1;
            nOverlap[n3] = nOverlap[n3] + 1;
        }
        boolean finished = false;
        Vector<double[][]> around = new Vector<double[][]>();
        IntVector aroundIndeces = new IntVector();
        Object surround = new double[2][2];
        surround[0][0] = edges[0][0];
        surround[0][1] = this.m.getAtom(orders[0][0]).getY();
        surround[1][0] = this.m.getAtom(orders[0][0]).getX();
        surround[1][1] = this.m.getAtom(orders[0][0]).getY();
        around.addElement((double[][])surround);
        aroundIndeces.addElement(orders[0][0]);
        BitSet surroundingAtoms = new BitSet(nP);
        if (oPairs.length == 0) {
            double r = this.radii[orders[0][0]];
            area = r * r * Math.PI;
            surroundingAtoms.set(orders[0][0]);
        } else {
            double[] lastCX = null;
            do {
                surround = new double[2][];
                double[] refCrossSection = ((double[][])around.elementAt(around.size() - 1))[0];
                double[] refCenter = ((double[][])around.elementAt(around.size() - 1))[1];
                int refIndex = aroundIndeces.elementAt(aroundIndeces.size() - 1);
                double[] refVector = new double[]{refCrossSection[0] - refCenter[0], refCrossSection[1] - refCenter[1]};
                int bestIdx = -1;
                double bestAngle = Math.PI * 2;
                for (int i5 = 0; i5 < oTab[refIndex].length; ++i5) {
                    int testIdx = oTab[refIndex][i5];
                    double cx = this.m.getAtom(testIdx).getX();
                    double cy = this.m.getAtom(testIdx).getY();
                    double[] testCenter = new double[]{cx, cy};
                    double[][] crosses = this.calculateCrossSections(refIndex, testIdx);
                    for (int j = 0; j < crosses.length; ++j) {
                        double[] testVector = new double[]{crosses[j][0] - refCenter[0], crosses[j][1] - refCenter[1]};
                        if (refVector[0] == testVector[0] && refVector[1] == testVector[1]) continue;
                        double alpha = this.getAngle(refVector[0], refVector[1], testVector[0], testVector[1]);
                        double d = 1.0;
                        if (alpha < 1.0E-5) {
                            alpha = Math.PI * 2;
                        }
                        if (!(alpha <= bestAngle)) continue;
                        surround[0] = crosses[j];
                        double[] c = new double[]{cx, cy};
                        surround[1] = c;
                        bestIdx = testIdx;
                        bestAngle = alpha;
                    }
                }
                if (bestIdx == -1) {
                    throw new UnsupportedOperationException("Internal error in MoleculeProjection.calculateArea");
                }
                if (lastCX == null) {
                    lastCX = surround[0];
                } else {
                    void d = (lastCX[0] - surround[0][0]) * (lastCX[0] - surround[0][0]) + (lastCX[1] - surround[0][1]) * (lastCX[1] - surround[0][1]);
                    boolean bl = finished = d < 1.0E-8;
                }
                if (finished) {
                    around.removeElementAt(0);
                    aroundIndeces.removeElementAt(0);
                } else {
                    around.addElement((double[][])surround);
                    aroundIndeces.addElement(bestIdx);
                }
                if (!finished) continue;
            } while (!finished);
            Object p0 = null;
            double yMax = edges[3][edges[3].length - 1];
            for (int i6 = 0; i6 < around.size(); ++i6) {
                boolean concave;
                surroundingAtoms.set(aroundIndeces.get(i6));
                double[] p1 = ((double[][])around.elementAt(i6))[0];
                double[] c = ((double[][])around.elementAt(i6))[1];
                double[] p2 = ((double[][])around.elementAt((i6 + 1) % around.size()))[0];
                double[] v1 = new double[]{p1[0] - c[0], p1[1] - c[1]};
                double[] v2 = new double[]{p2[0] - c[0], p2[1] - c[1]};
                double r = this.getRadii()[aroundIndeces.elementAt(i6)];
                double[] m = new double[]{p1[1] - p2[1], p2[0] - p1[0]};
                double at = Math.sqrt((p1[0] - p2[0]) * (p1[0] - p2[0]) + (p1[1] - p2[1]) * (p1[1] - p2[1])) * Math.sqrt(m[0] * m[0] + m[1] * m[1]) / 2.0;
                double alpha = this.getAngle(v1[0], v1[1], v2[0], v2[1]);
                double ac = r * r * Math.PI * this.getAngle(v1[0], v1[1], v2[0], v2[1]) / (Math.PI * 2);
                boolean bl = concave = alpha > Math.PI;
                if (!concave) {
                    at = -at;
                }
                area += ac + at;
                double atr = (yMax - Math.max(p1[1], p2[1])) * Math.abs(p1[0] - p2[0]) + Math.abs((p1[0] - p2[0]) * (p1[1] - p2[1])) / 2.0;
                if (m[1] < 0.0) {
                    atr = -atr;
                }
                area += atr;
            }
        }
        int maxI = -1;
        int maxJ = -1;
        double maxD = 0.0;
        double[] origo = new double[]{0.0, 0.0};
        int i7 = surroundingAtoms.nextSetBit(0);
        while (i7 >= 0) {
            int n;
            double[] pi = new double[]{this.m.getAtom(i7).getX(), this.m.getAtom(i7).getY()};
            int j = surroundingAtoms.nextSetBit(i7 + 1);
            while (j >= 0) {
                double[] dArray = new double[]{this.m.getAtom(j).getX(), this.m.getAtom(j).getY()};
                double[] pj = dArray;
                double d0 = Math.sqrt(this.d2(pi, pj));
                double d = this.radii[i7] + this.radii[j] + d0;
                if (d > maxD && pi[0] < pj[0]) {
                    maxI = i7;
                    maxJ = j;
                    origo[0] = (pi[0] - this.radii[maxI] + (pj[0] + this.radii[maxJ])) / 2.0;
                    if (pi[1] < pj[1]) {
                        origo[1] = (pi[1] - this.radii[maxI] + (pj[1] + this.radii[maxJ])) / 2.0;
                    }
                    maxD = d;
                }
                j = surroundingAtoms.nextSetBit(j + 1);
            }
            IntVector iv = new IntVector();
            iv.addElement(maxI);
            iv.addElement(maxJ);
            this.radius = maxD / 2.0;
            do {
                double maxR = this.radius + 1.0E-6;
                n = iv.size();
                int maxL = -1;
                int ii = surroundingAtoms.nextSetBit(0);
                while (ii >= 0) {
                    double[] dArray = new double[]{this.m.getAtom(ii).getX(), this.m.getAtom(ii).getY()};
                    double[] p = dArray;
                    double d = Math.sqrt(this.d2(p, origo)) + this.radii[ii];
                    if (d > maxR) {
                        maxL = ii;
                        maxR = d;
                    }
                    ii = surroundingAtoms.nextSetBit(ii + 1);
                }
                if (maxL < 0) continue;
                boolean contains = false;
                for (int ii2 = 0; ii2 < iv.size(); ++ii2) {
                    boolean bl = contains = iv.elementAt(ii2) == maxL;
                    if (contains) break;
                }
                if (!contains) {
                    iv.addElement(maxL);
                }
                double[] circle = null;
                int[] idx = iv.toArray();
                if (idx.length > 2) {
                    circle = this.calculateBestCircle(idx);
                }
                if (circle == null) continue;
                origo[0] = circle[0];
                origo[1] = circle[1];
                this.radius = circle[2];
            } while (iv.size() > n);
            i7 = surroundingAtoms.nextSetBit(i7 + 1);
        }
        ProjectionArea pa = new ProjectionArea(this.m);
        area = areaNew = pa.getArea();
        return area;
    }

    private double d2(int i, int j) {
        double xi = this.m.getAtom(i).getX();
        double yi = this.m.getAtom(i).getY();
        double xj = this.m.getAtom(j).getX();
        double yj = this.m.getAtom(j).getY();
        return (xi - xj) * (xi - xj) + (yi - yj) * (yi - yj);
    }

    private double d2(double[] p1, double[] p2) {
        double l2 = 0.0;
        for (int i = 0; i < Math.min(p1.length, p2.length); ++i) {
            double d = p2[i] - p1[i];
            l2 += d * d;
        }
        return l2;
    }

    private double[] calculateBestCircle(int[] idx) {
        double[] circle = null;
        double[] bestCircle = null;
        int[] bestIdx = new int[3];
        double rMin = Double.POSITIVE_INFINITY;
        for (int i = 0; i < idx.length; ++i) {
            for (int j = i + 1; j < idx.length; ++j) {
                for (int k = j + 1; k < idx.length; ++k) {
                    try {
                        circle = this.calculateCircle(idx[i], idx[j], idx[k]);
                    }
                    catch (Exception e) {
                        return circle;
                    }
                    double r = circle[2] + 1.0E-6;
                    if (!(circle[2] < rMin)) continue;
                    boolean circleOK = true;
                    for (int l = 0; l < idx.length; ++l) {
                        double[] dArray = new double[]{this.m.getAtom(idx[l]).getX(), this.m.getAtom(idx[l]).getY()};
                        double[] p = dArray;
                        if (!(Math.sqrt(this.d2(circle, p)) + this.radii[idx[l]] > r)) continue;
                        circleOK = false;
                        break;
                    }
                    if (!circleOK) continue;
                    bestIdx[0] = idx[i];
                    bestIdx[1] = idx[j];
                    bestIdx[2] = idx[k];
                    bestCircle = circle;
                }
            }
        }
        return bestCircle;
    }

    private double[][] calculateCrossSections(int i, int j) {
        double r1 = this.radii[i];
        double r2 = this.radii[j];
        double x1 = this.m.getAtom(i).getX();
        double x2 = this.m.getAtom(j).getX();
        double y1 = this.m.getAtom(i).getY();
        double y2 = this.m.getAtom(j).getY();
        double[] dArray = new double[]{x2 - x1, y2 - y1};
        double[] dVec = dArray;
        double d2 = dVec[0] * dVec[0] + dVec[1] * dVec[1];
        double d = Math.sqrt(d2);
        if (d < this.small) {
            return null;
        }
        double sc = 0.5 + (r1 * r1 - r2 * r2) / (2.0 * d2);
        double res2 = r1 * r1 - sc * sc * d2;
        if (res2 < 0.0) {
            return null;
        }
        double res = Math.sqrt(res2);
        double[] perpU = new double[]{-dVec[1] / d, dVec[0] / d};
        if (res == 0.0) {
            double[][] cs = new double[][]{{x1 + dVec[0] * sc, y1 + dVec[1] * sc}};
            return cs;
        }
        double[][] cs = new double[][]{{x1 + dVec[0] * sc + res * perpU[0], y1 + dVec[1] * sc + res * perpU[1]}, {x1 + dVec[0] * sc - res * perpU[0], y1 + dVec[1] * sc - res * perpU[1]}};
        return cs;
    }

    private double[] calculateCircle(int i1, int i2, int i3) {
        double[] pi2;
        double[] pi3;
        int ii;
        double rr;
        double r1 = this.radii[i1];
        double r2 = this.radii[i2];
        double r3 = this.radii[i3];
        while (!(r1 <= r2) || !(r2 <= r3)) {
            if (r1 > r2) {
                rr = r1;
                ii = i1;
                r1 = r2;
                i1 = i2;
                r2 = rr;
                i2 = ii;
            }
            if (!(r2 > r3)) continue;
            rr = r3;
            ii = i3;
            r3 = r2;
            i3 = i2;
            r2 = rr;
            i2 = ii;
        }
        r2 -= r1;
        r3 -= r1;
        double x1 = this.m.getAtom(i1).getX();
        double y1 = this.m.getAtom(i1).getY();
        double x2 = this.m.getAtom(i2).getX();
        double y2 = this.m.getAtom(i2).getY();
        double x3 = this.m.getAtom(i3).getX();
        double y3 = this.m.getAtom(i3).getY();
        double rinv2 = this.d2(i1, i2);
        double d12 = Math.sqrt(rinv2);
        double d13 = Math.sqrt(this.d2(i1, i3));
        double[] u12 = new double[]{(x2 - x1) / d12, (y2 - y1) / d12};
        double[] u13 = new double[]{(x3 - x1) / d13, (y3 - y1) / d13};
        double[] cPlus = new double[]{x3 + u13[0] * r3, y3 + u13[1] * r3};
        double[] cMinus = new double[]{x3 - u13[0] * r3, y3 - u13[1] * r3};
        double[] c3Plus = this.cInvert(x1, y1, rinv2, cPlus[0], cPlus[1]);
        double[] c3Minus = this.cInvert(x1, y1, rinv2, cMinus[0], cMinus[1]);
        double ri3 = Math.sqrt(this.d2(c3Plus, c3Minus)) / 2.0;
        double[] c3 = new double[]{(c3Plus[0] + c3Minus[0]) / 2.0, (c3Plus[1] + c3Minus[1]) / 2.0};
        cPlus[0] = x2 + u12[0] * r2;
        cPlus[1] = y2 + u12[1] * r2;
        cMinus[0] = x2 - u12[0] * r2;
        cMinus[1] = y2 - u12[1] * r2;
        double[] c2Plus = this.cInvert(x1, y1, rinv2, cPlus[0], cPlus[1]);
        double[] c2Minus = this.cInvert(x1, y1, rinv2, cMinus[0], cMinus[1]);
        double ri2 = Math.sqrt(this.d2(c2Plus, c2Minus)) / 2.0;
        double[] c2 = new double[]{(c2Plus[0] + c2Minus[0]) / 2.0, (c2Plus[1] + c2Minus[1]) / 2.0};
        if (ri3 < ri2) {
            rr = r3;
            ii = i3;
            r3 = r2;
            i3 = i2;
            r2 = rr;
            i2 = ii;
            double[] cc = c3;
            c3 = c2;
            c2 = cc;
            rr = ri3;
            ri3 = ri2;
            ri2 = rr;
        }
        if ((ri3 -= ri2) > 0.0) {
            double d = Math.sqrt(this.d2(c3, c2));
            double l = Math.sqrt(d * d - ri3 * ri3);
            double m = ri3 * l * d / (d * d);
            double a = l * m / ri3;
            double[] aVec = new double[]{(c3[0] - c2[0]) * a / d, (c3[1] - c2[1]) * a / d};
            double[] mVec = new double[]{-aVec[1] * m / a, aVec[0] * m / a};
            double[] dArray = new double[]{c2[0] + aVec[0], c2[1] + aVec[1]};
            double[] pp = dArray;
            pi3 = pp;
            if ((pi3[0] - x1) * mVec[0] + (pi3[1] - y1) * mVec[1] > 0.0) {
                mVec[0] = mVec[0] * -1.0;
                mVec[1] = mVec[1] * -1.0;
            }
            pp[0] = pp[0] + mVec[0];
            pp[1] = pp[1] + mVec[1];
            double[] sv = new double[]{(pp[0] - c3[0]) * ri2 / ri3, (pp[1] - c3[1]) * ri2 / ri3};
            pi3[0] = pp[0] + sv[0];
            pi3[1] = pp[1] + sv[1];
            pi2 = new double[]{c2[0] + sv[0], c2[1] + sv[1]};
        } else {
            pi2 = c2;
            pi3 = c3;
        }
        double[] t2 = this.cInvert(x1, y1, rinv2, pi2[0], pi2[1]);
        double[] t3 = this.cInvert(x1, y1, rinv2, pi3[0], pi3[1]);
        double[] t1 = new double[]{x1, y1};
        double[] circle = this.calculateCircle(t1, t2, t3);
        circle[2] = circle[2] + r1;
        return circle;
    }

    private double[] calculateCircle(double[] p1, double[] p2, double[] p3) {
        double x1 = (p1[0] + p2[0]) / 2.0;
        double y1 = (p1[1] + p2[1]) / 2.0;
        double x2 = (p1[0] + p3[0]) / 2.0;
        double y2 = (p1[1] + p3[1]) / 2.0;
        double dx1 = p1[1] - p2[1];
        double dy1 = p2[0] - p1[0];
        double dx2 = p1[1] - p3[1];
        double dy2 = p3[0] - p1[0];
        double x = (dx1 * dx2 * (y2 - y1) + x1 * dx2 * dy1 - x2 * dx1 * dy2) / (dx2 * dy1 - dx1 * dy2);
        double y = dx1 * dx1 > dx2 * dx2 ? y1 + (x - x1) / dx1 * dy1 : y2 + (x - x2) / dx2 * dy2;
        double[] c = new double[]{x, y};
        double r = Math.sqrt(this.d2(c, p1));
        double[] circle = new double[]{x, y, r};
        return circle;
    }

    private double[] cInvert(double c1, double c2, double ri2, double x, double y) {
        double[] v = new double[]{x - c1, y - c2};
        double l2 = v[0] * v[0] + v[1] * v[1];
        v[0] = c1 + v[0] * ri2 / l2;
        v[1] = c2 + v[1] * ri2 / l2;
        return v;
    }

    @Override
    public void run() {
        int i;
        int i2;
        this.originalArea = this.calculateArea();
        ProjectionArea pa = new ProjectionArea(this.m);
        this.originalArea = pa.getArea();
        this.origRadius = this.radius;
        double cx = 0.0;
        double cy = 0.0;
        double cz = 0.0;
        double sumWeight = 0.0;
        for (i2 = 0; i2 < this.m.getAtomCount(); ++i2) {
            double weight = this.getRadii()[i2] * this.getRadii()[i2];
            cx += this.m.getAtom(i2).getX() * weight;
            cy += this.m.getAtom(i2).getY() * weight;
            cz += this.m.getAtom(i2).getZ() * weight;
            sumWeight += weight;
        }
        cx /= sumWeight;
        cy /= sumWeight;
        cz /= sumWeight;
        for (i2 = 0; i2 < this.m.getAtomCount(); ++i2) {
            this.m.getAtom(i2).setX(this.m.getAtom(i2).getX() - cx);
            this.m.getAtom(i2).setY(this.m.getAtom(i2).getY() - cy);
            this.m.getAtom(i2).setZ(this.m.getAtom(i2).getZ() - cz);
        }
        BitSet matrixType = new BitSet();
        matrixType.set(2);
        matrixType.set(1);
        JLinAlg.Matrix s = new JLinAlg.Matrix(3, 3, matrixType);
        for (i = 0; i < this.m.getAtomCount(); ++i) {
            double weight = this.getRadii()[i] * this.getRadii()[i];
            double x = this.m.getAtom(i).getX() * weight;
            double y = this.m.getAtom(i).getY() * weight;
            double z = this.m.getAtom(i).getZ() * weight;
            s.setElement(0, 0, s.getElement(0, 0) + x * x);
            s.setElement(1, 0, s.getElement(1, 0) + y * x);
            s.setElement(1, 1, s.getElement(1, 1) + y * y);
            s.setElement(2, 0, s.getElement(2, 0) + z * x);
            s.setElement(2, 1, s.getElement(2, 1) + z * y);
            s.setElement(2, 2, s.getElement(2, 2) + z * z);
        }
        s.diagonalize(0.0, 0.0);
        for (i = 0; i < this.m.getAtomCount(); ++i) {
            double[] xyz = new double[]{this.m.getAtom(i).getX(), this.m.getAtom(i).getY(), this.m.getAtom(i).getZ()};
            double[] trxyz = JLinAlg.mVMultiply(s.aREV, xyz);
            this.m.getAtom(i).setX(trxyz[0]);
            this.m.getAtom(i).setY(trxyz[1]);
            this.m.getAtom(i).setZ(trxyz[2]);
        }
        boolean minimal = this.isMinimalMode();
        this.valid = true;
        this.setMinimalMode(true);
        this.minimalArea = this.calculateArea();
        this.minimalProjection = this.m.cloneMolecule();
        pa.setM(this.minimalProjection);
        this.minimalArea = pa.getArea();
        this.minimalRadius = this.radius;
        this.setMinimalMode(false);
        this.maximalArea = this.calculateArea();
        this.maximalProjection = this.m.cloneMolecule();
        this.maximalRadius = this.radius;
        pa.setM(this.maximalProjection);
        this.maximalArea = pa.getArea();
        this.setMinimalMode(minimal);
    }

    public Molecule getM() {
        return this.m;
    }

    public void setM(Molecule m) {
        if (m.getFragCount(1) > 1) {
            throw new UnsupportedOperationException("Molecule contains multiple fragments in MoleculeProjector.");
        }
        this.m = m.cloneMolecule();
        this.valid = false;
        this.radii = null;
    }

    public boolean isMinimalMode() {
        return this.minimalMode;
    }

    public void setMinimalMode(boolean minimalMode) {
        block4: {
            if (minimalMode == this.minimalMode) break block4;
            this.minimalMode = minimalMode;
            if (minimalMode) {
                for (int i = 0; i < this.m.getAtomCount(); ++i) {
                    double[] xyz = new double[]{this.m.getAtom(i).getX(), this.m.getAtom(i).getY(), this.m.getAtom(i).getZ()};
                    this.m.getAtom(i).setX(xyz[2]);
                    this.m.getAtom(i).setY(xyz[0]);
                    this.m.getAtom(i).setZ(xyz[1]);
                }
            } else {
                for (int i = 0; i < this.m.getAtomCount(); ++i) {
                    double[] xyz = new double[]{this.m.getAtom(i).getX(), this.m.getAtom(i).getY(), this.m.getAtom(i).getZ()};
                    this.m.getAtom(i).setX(xyz[1]);
                    this.m.getAtom(i).setY(xyz[2]);
                    this.m.getAtom(i).setZ(xyz[0]);
                }
            }
        }
    }

    public double getMinimalArea() {
        if (!this.isValid()) {
            this.run();
        }
        return this.minimalArea;
    }

    public double getMaximalArea() {
        if (!this.isValid()) {
            this.run();
        }
        return this.maximalArea;
    }

    public double getArea() {
        if (!this.isValid()) {
            this.run();
        }
        return this.originalArea;
    }

    public double getMinimalRadius() {
        if (!this.isValid()) {
            this.getMinimalArea();
        }
        return this.minimalRadius;
    }

    public double getMaximalRadius() {
        if (!this.isValid()) {
            this.getMaximalArea();
        }
        return this.maximalRadius;
    }

    public double getRadius() {
        if (!this.isValid()) {
            this.run();
        }
        return this.origRadius;
    }

    public boolean isValid() {
        return this.valid;
    }

    public double[] getRadii() {
        if (this.m == null) {
            return null;
        }
        if (this.radii == null) {
            this.radii = new double[this.m.getAtomCount()];
            for (int i = 0; i < this.radii.length; ++i) {
                this.radii[i] = PeriodicSystem.getVanDerWaalsRadius(this.m.getAtom(i).getAtno());
            }
        }
        return this.radii;
    }

    public void setRadii(double[] radii) {
        this.valid = false;
        this.radii = radii;
    }

    public void scaleRadii(double sc) {
        this.radii = this.getRadii();
        this.valid = false;
        int i = 0;
        while (i < this.radii.length) {
            int n = i++;
            this.radii[n] = this.radii[n] * sc;
        }
    }

    public double getSmall() {
        return this.small;
    }

    public void setSmall(double small) {
        this.small = small;
    }

    private void debug(double a) {
        this.debugLine = this.debugLine + "\t" + debugPrintout.formatNumber(7, 4, a);
    }

    private void debug(double[] v) {
        for (int i = 0; i < v.length; ++i) {
            this.debugLine = this.debugLine + "\t" + debugPrintout.formatNumber(7, 4, v[i]);
        }
    }

    private void debug(int i) {
        this.debugLine = this.debugLine + "\t" + i;
    }

    private void debug(int[] iv) {
        for (int j = 0; j < iv.length; ++j) {
            this.debugLine = this.debugLine + "\t" + iv[j];
        }
    }

    private void debug(String message) {
        this.debugLine = this.debugLine + message;
    }

    private void printDebug() {
        System.err.println(this.debugLine);
        this.debugLine = "";
    }

    private double degree(double rad) {
        return rad / Math.PI * 180.0;
    }

    public static void main(String[] args) {
        String usage = "Usage:\n\t... MoleculeProjector [-h] filename(s)\n\nParameters:\n\t-h: This help\n";
        boolean useGui = false;
        MoleculeProjector mp = new MoleculeProjector();
        ProjectionArea pa = null;
        if (args.length == 0) {
            System.err.println(usage);
        }
        for (int i = 0; i < args.length; ++i) {
            String inputName = args[i];
            if (inputName.equals("-h")) {
                System.err.println(usage);
                System.exit(0);
            }
            try {
                System.err.println("Reading file: " + inputName);
                MolImporter mi = !inputName.equals("-") ? new MolImporter(inputName) : new MolImporter(System.in);
                Molecule m = null;
                int counter = 0;
                while ((m = mi.read()) != null) {
                    long time = System.currentTimeMillis();
                    System.err.println("Processing molecule #" + ++counter + " of " + inputName);
                    try {
                        mp.setM(m);
                        pa = new ProjectionArea(m);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    pa.getArea();
                    String areaString = null;
                    String radiusString = null;
                    System.out.print(MolExporter.exportToFormat(mp.getM(), "sdf"));
                    mp.run();
                    System.err.println("Original orientation, XY projection:");
                    String label = "Area: " + debugPrintout.formatNumber(8, 2, mp.getArea()) + " Angstrom^2";
                    System.err.println(label);
                    label = "Radius: " + debugPrintout.formatNumber(8, 2, mp.getRadius()) + " Angstrom";
                    System.err.println(label);
                    areaString = debugPrintout.formatNumber(8, 2, mp.getMinimalArea());
                    mp.getM().setProperty("projectionarea", areaString);
                    radiusString = debugPrintout.formatNumber(8, 2, mp.getMinimalRadius());
                    mp.getM().setProperty("projectionradius", radiusString);
                    System.err.println("Minimal projection:");
                    label = "Area: " + debugPrintout.formatNumber(8, 2, mp.getMinimalArea()) + " Angstrom^2";
                    System.err.println(label);
                    label = "Radius: " + debugPrintout.formatNumber(8, 2, mp.getMinimalRadius()) + " Angstrom";
                    System.err.println(label);
                    System.out.print(MolExporter.exportToFormat(mp.getMinimalProjection(), "sdf"));
                    areaString = debugPrintout.formatNumber(8, 2, mp.getMaximalArea());
                    mp.getM().setProperty("projectionarea", areaString);
                    radiusString = debugPrintout.formatNumber(8, 2, mp.getMaximalRadius());
                    mp.getM().setProperty("projectionradius", radiusString);
                    System.err.println("Maximal projection:");
                    label = "Area: " + debugPrintout.formatNumber(8, 2, mp.getMaximalArea()) + " Angstrom^2";
                    System.err.println(label);
                    label = "Radius: " + debugPrintout.formatNumber(8, 2, mp.getMaximalRadius()) + " Angstrom";
                    System.err.println(label);
                    System.out.print(MolExporter.exportToFormat(mp.getMaximalProjection(), "sdf"));
                    long elapsed = System.currentTimeMillis() - time;
                    System.err.println("Elapsed time (ms): " + elapsed);
                }
                continue;
            }
            catch (MolFormatException e) {
                e.printStackTrace();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Molecule getMinimalProjection() {
        if (!this.isValid()) {
            this.getMinimalArea();
        }
        return this.minimalProjection;
    }

    public Molecule getMaximalProjection() {
        if (!this.isValid()) {
            this.getMaximalArea();
        }
        return this.maximalProjection;
    }
}

