/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class PolarGroups {
    int UNKNOWN = -1;
    protected int[] groupIndex;
    protected int[] groupType;
    protected int[] groupProperty;
    protected int[] chargeState;
    protected int[][] groups;
    protected int[] carboxy;
    int atomCount;
    Molecule mol;
    int[][] cHtab;
    int[][] bHtab;
    boolean[] isArom;
    protected int gCount;
    int actAtom;
    int actPyrO;
    int actChg;

    public PolarGroups() {
    }

    public PolarGroups(Molecule m) {
        this.mol = m;
    }

    public void setMolecule(Molecule m) {
        this.mol = m;
    }

    private void init() {
        this.atomCount = this.mol.getAtomCount();
        this.cHtab = this.mol.createCHtab();
        this.bHtab = this.mol.createBHtab();
        this.carboxy = new int[this.atomCount];
        this.groupIndex = new int[this.atomCount];
        this.groupType = new int[this.atomCount];
        this.groupProperty = new int[this.atomCount];
        this.chargeState = new int[this.atomCount];
    }

    public int[] getCarboxy() {
        return this.carboxy;
    }

    private MolAtom getAtom(int ai) {
        MolAtom a = this.mol.getAtom(ai);
        return a;
    }

    public void setGroups() {
        this.init();
        this.gCount = 0;
        for (int i = 0; i < this.atomCount; ++i) {
            this.carboxy[i] = -1;
            this.groupIndex[i] = -1;
            this.groupType[i] = -1;
            this.groupProperty[i] = -1;
            this.chargeState[i] = 0;
        }
        boolean alphaAra = false;
        boolean alkoxy = false;
        boolean keto = false;
        boolean alkohol = false;
        boolean amide = false;
        boolean nitro = false;
        boolean cyano = false;
        boolean halo = false;
        boolean crossAtom = false;
        boolean nitroso = false;
        boolean vinil = false;
        int OR = -1;
        int OH = -1;
        int RXO2 = -1;
        int rootC = -1;
        int[] aN = new int[]{-1, -1, -1, -1, -1, -1};
        int[] amideNType = new int[]{-1, -1, -1, -1, -1, -1};
        int[] ORIndex = new int[]{-1, -1, -1, -1, -1, -1};
        int[] OHIndex = new int[]{-1, -1, -1, -1, -1, -1};
        int t = 0;
        int q = 0;
        int ARA = 1;
        int ALI = 2;
        for (int i = 0; i < this.atomCount; ++i) {
            String symb;
            if (this.isDbBonded(i)) {
                int z;
                int amideN;
                int k;
                int j;
                int nb;
                symb = this.getSymbol(i);
                rootC = nb = this.cHtab[i][0];
                alphaAra = false;
                alkoxy = false;
                keto = false;
                alkohol = false;
                amide = false;
                nitro = false;
                nitroso = false;
                cyano = false;
                crossAtom = false;
                halo = false;
                vinil = false;
                OR = -1;
                OH = -1;
                RXO2 = -1;
                int aCount = 0;
                int carbon = -1;
                int orCount = 0;
                int ohCount = 0;
                for (j = 0; j < 6; ++j) {
                    amideNType[j] = -1;
                    aN[j] = -1;
                    ORIndex[j] = -1;
                    OHIndex[j] = -1;
                }
                if (!symb.equals("H") && rootC < this.atomCount) {
                    if (symb.equals("O") || symb.equals("S") || symb.equals("Se") || symb.equals("Te")) {
                        if (this.getSymbol(nb).equals("N")) {
                            nitro = true;
                        }
                        keto = true;
                        for (j = 0; j < this.cHtab[nb].length; ++j) {
                            int chg;
                            int nnb = this.cHtab[nb][j];
                            if (!(nnb != i & nnb < this.atomCount)) continue;
                            String symb2 = this.getSymbol(nnb);
                            if (symb2.equals("O") || symb2.equals("S") || symb2.equals("Se") || symb2.equals("Te")) {
                                if (this.cHtab[nnb].length == 2) {
                                    int ind = this.isAlkohol(nnb);
                                    if (ind == 900) {
                                        OH = nnb;
                                        alkohol = true;
                                        OHIndex[ohCount] = OH;
                                        ++ohCount;
                                        continue;
                                    }
                                    if (ind != 1000) continue;
                                    OR = nnb;
                                    alkoxy = true;
                                    ORIndex[orCount] = OR;
                                    ++orCount;
                                    continue;
                                }
                                if (this.cHtab[nnb].length != 1) continue;
                                chg = this.getAtom(nnb).getCharge();
                                if (chg == 0) {
                                    crossAtom = true;
                                    RXO2 = nnb;
                                    continue;
                                }
                                if (chg > 0) {
                                    crossAtom = true;
                                    RXO2 = nnb;
                                    continue;
                                }
                                if (chg >= 0) continue;
                                OH = nnb;
                                alkohol = true;
                                OHIndex[ohCount] = OH;
                                ++ohCount;
                                continue;
                            }
                            if (symb2.equals("N")) {
                                if (this.cHtab[nnb].length == 3) {
                                    if (this.getAtom(nnb).getCharge() == 1) continue;
                                    amide = true;
                                    aN[aCount] = nnb;
                                    amideNType[aCount] = ALI;
                                    for (k = 0; k < this.cHtab[nnb].length; ++k) {
                                        if (!this.isArA(this.cHtab[nnb][k])) continue;
                                        alphaAra = true;
                                        amideNType[aCount] = ARA;
                                    }
                                    ++aCount;
                                    continue;
                                }
                                if (this.cHtab[nnb].length == 4) {
                                    if (this.getAtom(nnb).getCharge() != 1) continue;
                                    amide = true;
                                    aN[aCount] = nnb;
                                    amideNType[aCount] = ALI;
                                    for (k = 0; k < this.cHtab[nnb].length; ++k) {
                                        if (!this.isArA(this.cHtab[nnb][k])) continue;
                                        alphaAra = true;
                                        amideNType[aCount] = ARA;
                                    }
                                    ++aCount;
                                    continue;
                                }
                                if (this.cHtab[nnb].length != 2) continue;
                                chg = this.getAtom(nnb).getCharge();
                                if (chg < 0) {
                                    amide = true;
                                    aN[aCount] = nnb;
                                    amideNType[aCount] = ALI;
                                    for (k = 0; k < this.cHtab[nnb].length; ++k) {
                                        if (!this.isArA(this.cHtab[nnb][k])) continue;
                                        alphaAra = true;
                                        amideNType[aCount] = ARA;
                                    }
                                    ++aCount;
                                    continue;
                                }
                                vinil = true;
                                continue;
                            }
                            if (!symb2.equals("C")) continue;
                            carbon = nnb;
                            if (!this.isVinyl(nb, nnb)) continue;
                            vinil = true;
                        }
                    } else if (symb.equals("N")) {
                        cyano = true;
                    } else if (symb.equals("F") || symb.equals("Cl") || symb.equals("Br") || symb.equals("I")) {
                        halo = true;
                    }
                }
                if (nitro) {
                    nitroso = this.isNitroso(rootC);
                }
                if (amide && crossAtom) {
                    this.carboxy[i] = 800;
                    this.carboxy[rootC] = 800;
                    this.carboxy[RXO2] = 800;
                    amideN = aN[0];
                    this.carboxy[amideN] = 200;
                    int[] c = this.isGroupAssignedYet(i, aN, rootC);
                    if (c[0] == 410) {
                        this.groupIndex[i] = c[2];
                        this.groupIndex[rootC] = c[2];
                        this.groupIndex[RXO2] = c[2];
                        this.groupIndex[amideN] = c[2];
                        this.groupType[i] = 850;
                        this.groupType[rootC] = 850;
                        this.groupType[RXO2] = 850;
                        this.groupType[amideN] = 850;
                        this.groupProperty[i] = 410;
                        this.groupProperty[rootC] = 410;
                        this.groupProperty[RXO2] = 410;
                        this.groupProperty[amideN] = 410;
                    } else if (c[0] == 409 || c[0] == 411) {
                        for (k = 0; k < this.atomCount; ++k) {
                            if (this.groupIndex[k] != c[2]) continue;
                            this.groupProperty[k] = 410;
                        }
                        this.groupIndex[i] = c[2];
                        this.groupIndex[rootC] = c[2];
                        this.groupIndex[RXO2] = c[2];
                        this.groupIndex[amideN] = c[2];
                        this.groupType[i] = 850;
                        this.groupType[rootC] = 850;
                        this.groupType[RXO2] = 850;
                        this.groupType[amideN] = 850;
                        this.groupProperty[i] = 410;
                        this.groupProperty[rootC] = 410;
                        this.groupProperty[RXO2] = 410;
                        this.groupProperty[amideN] = 410;
                    } else {
                        this.groupIndex[i] = this.gCount;
                        this.groupIndex[rootC] = this.gCount;
                        this.groupIndex[RXO2] = this.gCount;
                        this.groupIndex[amideN] = this.gCount++;
                        this.groupType[i] = 850;
                        this.groupType[rootC] = 850;
                        this.groupType[RXO2] = 850;
                        this.groupType[amideN] = 850;
                        this.groupProperty[i] = 410;
                        this.groupProperty[rootC] = 410;
                        this.groupProperty[RXO2] = 410;
                        this.groupProperty[amideN] = 410;
                    }
                } else if (amide & (alkoxy || alkohol) & !alphaAra) {
                    int k2;
                    int[] c;
                    amideN = aN[0];
                    this.carboxy[i] = 600;
                    this.carboxy[amideN] = 200;
                    this.carboxy[rootC] = 600;
                    int OH_OR1 = -1;
                    int OH_OR2 = -1;
                    if (alkohol) {
                        this.carboxy[OH] = 300;
                        OH_OR2 = OH;
                    }
                    if (alkoxy) {
                        this.carboxy[OR] = 2;
                        OH_OR1 = OR;
                    }
                    if ((c = this.isGroupAssignedYet(i, aN, rootC))[0] == 409) {
                        for (k2 = 0; k2 < this.atomCount; ++k2) {
                            if (this.groupIndex[k2] != c[2]) continue;
                            this.groupType[k2] = c[1];
                            this.groupProperty[k2] = 410;
                        }
                        this.groupProperty[i] = 410;
                        this.groupProperty[aN[0]] = 410;
                        this.groupProperty[rootC] = 410;
                        this.groupType[i] = c[1];
                        this.groupType[aN[0]] = c[1];
                        this.groupType[rootC] = c[1];
                        this.groupIndex[i] = c[2];
                        this.groupIndex[aN[0]] = c[2];
                        this.groupIndex[rootC] = c[2];
                        if (OH_OR1 != -1) {
                            this.groupProperty[OH_OR1] = 410;
                            this.groupType[OH_OR1] = c[1];
                            this.groupIndex[OH_OR1] = c[2];
                        }
                        if (OH_OR2 != -1) {
                            this.groupProperty[OH_OR2] = 410;
                            this.groupType[OH_OR2] = c[1];
                            this.groupIndex[OH_OR2] = c[2];
                        }
                    } else if (c[0] == 410) {
                        this.groupProperty[i] = c[0];
                        this.groupProperty[aN[0]] = c[0];
                        this.groupProperty[rootC] = c[0];
                        this.groupType[i] = c[1];
                        this.groupType[aN[0]] = c[1];
                        this.groupType[rootC] = c[1];
                        this.groupIndex[i] = c[2];
                        this.groupIndex[aN[0]] = c[2];
                        this.groupIndex[rootC] = c[2];
                        if (OH_OR1 != -1) {
                            this.groupProperty[OH_OR1] = 410;
                            this.groupType[OH_OR1] = c[1];
                            this.groupIndex[OH_OR1] = c[2];
                        }
                        if (OH_OR2 != -1) {
                            this.groupProperty[OH_OR2] = 410;
                            this.groupType[OH_OR2] = c[1];
                            this.groupIndex[OH_OR2] = c[2];
                        }
                    } else if (c[0] == 411) {
                        for (k2 = 0; k2 < this.atomCount; ++k2) {
                            if (this.groupIndex[k2] != c[2]) continue;
                            this.groupType[k2] = c[1];
                            this.groupProperty[k2] = 410;
                        }
                        this.groupIndex[i] = c[2];
                        this.groupIndex[aN[0]] = c[2];
                        this.groupIndex[rootC] = c[2];
                        this.groupType[i] = c[1];
                        this.groupType[aN[0]] = c[1];
                        this.groupType[rootC] = c[1];
                        this.groupProperty[i] = 410;
                        this.groupProperty[aN[0]] = 410;
                        this.groupProperty[rootC] = 410;
                        if (OH_OR1 != -1) {
                            this.groupProperty[OH_OR1] = 410;
                            this.groupType[OH_OR1] = c[1];
                            this.groupIndex[OH_OR1] = c[2];
                        }
                        if (OH_OR2 != -1) {
                            this.groupProperty[OH_OR2] = 410;
                            this.groupType[OH_OR2] = c[1];
                            this.groupIndex[OH_OR2] = c[2];
                        }
                    } else {
                        this.groupIndex[i] = this.gCount;
                        this.groupType[i] = 16;
                        this.groupProperty[i] = 409;
                        if (OH_OR1 != -1) {
                            this.groupIndex[OH_OR1] = this.gCount;
                            this.groupType[OH_OR1] = 16;
                            this.groupProperty[aN[0]] = 409;
                            this.groupProperty[OH_OR1] = 409;
                        }
                        if (OH_OR2 != -1) {
                            this.groupIndex[OH_OR2] = this.gCount;
                            this.groupType[OH_OR2] = 16;
                            this.groupProperty[aN[0]] = 409;
                            this.groupProperty[OH_OR2] = 409;
                        }
                        this.groupIndex[amideN] = this.gCount;
                        this.groupType[amideN] = 16;
                        this.groupProperty[rootC] = 409;
                        this.groupIndex[rootC] = this.gCount++;
                        this.groupType[rootC] = 16;
                    }
                    if (this.getSymbol(rootC).equals("S") && (this.cHtab[rootC].length == 5 || this.getDBCount(rootC) == 2)) {
                        this.groupProperty[i] = 3500;
                        this.groupProperty[rootC] = 3500;
                        this.groupProperty[amideN] = 3500;
                    }
                } else if (amide && (alkoxy || alkohol) && alphaAra) {
                    this.carboxy[i] = 700;
                    this.groupIndex[i] = this.gCount;
                    this.groupType[i] = 15;
                    if (alkoxy) {
                        this.carboxy[OR] = 2;
                        this.groupIndex[OR] = this.gCount;
                        this.groupType[OR] = 15;
                    }
                    if (alkohol) {
                        this.carboxy[OH] = 300;
                        this.groupIndex[OH] = this.gCount;
                        this.groupType[OH] = 15;
                    }
                    amideN = aN[0];
                    this.carboxy[amideN] = 700;
                    this.groupIndex[amideN] = this.gCount;
                    this.groupType[amideN] = 15;
                    this.carboxy[rootC] = 700;
                    this.groupIndex[rootC] = this.gCount;
                    this.groupType[rootC] = 15;
                    if (this.getSymbol(rootC).equals("S") && (this.cHtab[rootC].length == 5 || this.getDBCount(rootC) == 2)) {
                        this.groupProperty[i] = 3500;
                        this.groupProperty[rootC] = 3500;
                        this.groupProperty[amideN] = 3500;
                    }
                    ++this.gCount;
                } else if (amide && alphaAra && aCount == 1) {
                    q = this.getSymbol(i).equals("O") ? 13 : 11;
                    this.carboxy[i] = 500;
                    this.carboxy[aN[0]] = 500;
                    this.carboxy[rootC] = 500;
                    int[] c = this.isGroupAssignedYet(i, aN, rootC);
                    if (c[0] == 409) {
                        for (k = 0; k < this.atomCount; ++k) {
                            if (this.groupIndex[k] != c[2]) continue;
                            this.groupType[k] = q;
                            this.groupProperty[k] = 410;
                        }
                        this.groupProperty[i] = 410;
                        this.groupProperty[aN[0]] = 410;
                        this.groupProperty[rootC] = 410;
                        this.groupType[i] = c[1];
                        this.groupType[aN[0]] = c[1];
                        this.groupType[rootC] = c[1];
                        this.groupIndex[i] = c[2];
                        this.groupIndex[aN[0]] = c[2];
                        this.groupIndex[rootC] = c[2];
                    } else if (c[0] == 410) {
                        this.groupProperty[i] = c[0];
                        this.groupProperty[aN[0]] = c[0];
                        this.groupProperty[rootC] = c[0];
                        this.groupType[i] = c[1];
                        this.groupType[aN[0]] = c[1];
                        this.groupType[rootC] = c[1];
                        this.groupIndex[i] = c[2];
                        this.groupIndex[aN[0]] = c[2];
                        this.groupIndex[rootC] = c[2];
                    } else if (c[0] == 411) {
                        for (k = 0; k < this.atomCount; ++k) {
                            if (this.groupIndex[k] != c[2]) continue;
                            this.groupType[k] = q;
                            this.groupProperty[k] = 410;
                        }
                        this.groupIndex[i] = c[2];
                        this.groupIndex[aN[0]] = c[2];
                        this.groupIndex[rootC] = c[2];
                        this.groupType[i] = q;
                        this.groupType[aN[0]] = q;
                        this.groupType[rootC] = q;
                        this.groupProperty[i] = 410;
                        this.groupProperty[aN[0]] = 410;
                        this.groupProperty[rootC] = 410;
                    } else {
                        this.groupIndex[i] = this.gCount;
                        this.groupIndex[aN[0]] = this.gCount;
                        this.groupIndex[rootC] = this.gCount++;
                        this.groupType[i] = q;
                        this.groupType[aN[0]] = q;
                        this.groupType[rootC] = q;
                        this.groupProperty[i] = 409;
                        this.groupProperty[aN[0]] = 409;
                        this.groupProperty[rootC] = 409;
                    }
                } else if (amide & alphaAra & aCount == 2) {
                    q = this.getSymbol(i).equals("O") ? 10 : 12;
                    this.carboxy[i] = 500;
                    this.carboxy[rootC] = 500;
                    this.carboxy[aN[0]] = amideNType[0] == ARA ? 500 : 200;
                    this.carboxy[aN[1]] = amideNType[1] == ARA ? 500 : 200;
                    int[] c = this.isGroupAssignedYet(i, aN, rootC);
                    if (c[0] == 410 || c[0] == 409) {
                        if (c[0] == 409) {
                            for (k = 0; k < this.atomCount; ++k) {
                                if (this.groupIndex[k] != c[2]) continue;
                                this.groupType[k] = c[1];
                                this.groupProperty[k] = 410;
                            }
                        }
                        this.groupProperty[i] = 410;
                        this.groupProperty[aN[0]] = 410;
                        this.groupProperty[aN[1]] = 410;
                        this.groupProperty[rootC] = 410;
                        this.groupType[i] = c[1];
                        this.groupType[aN[0]] = c[1];
                        this.groupType[aN[1]] = c[1];
                        this.groupType[rootC] = c[1];
                        this.groupIndex[i] = c[2];
                        this.groupIndex[aN[0]] = c[2];
                        this.groupIndex[aN[1]] = c[2];
                        this.groupIndex[rootC] = c[2];
                    } else if (c[0] == 411) {
                        for (k = 0; k < this.atomCount; ++k) {
                            if (this.groupIndex[k] != c[2]) continue;
                            this.groupType[k] = q;
                            this.groupProperty[k] = 409;
                        }
                        this.groupIndex[i] = c[2];
                        this.groupIndex[aN[0]] = c[2];
                        this.groupIndex[aN[1]] = c[2];
                        this.groupIndex[rootC] = c[2];
                        this.groupType[i] = q;
                        this.groupType[aN[0]] = q;
                        this.groupType[aN[1]] = q;
                        this.groupType[rootC] = q;
                        this.groupProperty[i] = 409;
                        this.groupProperty[aN[0]] = 409;
                        this.groupProperty[aN[1]] = 409;
                        this.groupProperty[rootC] = 409;
                    } else {
                        this.groupIndex[i] = this.gCount;
                        this.groupIndex[aN[0]] = this.gCount;
                        this.groupIndex[aN[1]] = this.gCount;
                        this.groupIndex[rootC] = this.gCount++;
                        this.groupType[i] = q;
                        this.groupType[aN[0]] = q;
                        this.groupType[aN[1]] = q;
                        this.groupType[rootC] = q;
                        this.groupProperty[i] = 411;
                        this.groupProperty[aN[0]] = 411;
                        this.groupProperty[aN[1]] = 411;
                        this.groupProperty[rootC] = 411;
                    }
                } else if (amide && keto && aCount == 1 && !nitro) {
                    q = this.getSymbol(i).equals("O") ? 13 : 11;
                    this.carboxy[i] = 200;
                    this.carboxy[aN[0]] = 200;
                    this.carboxy[rootC] = 200;
                    int[] c = this.isGroupAssignedYet(i, aN, rootC);
                    if (c[0] == 409 || c[0] == 3500) {
                        for (k = 0; k < this.atomCount; ++k) {
                            if (this.groupIndex[k] != c[2]) continue;
                            this.groupType[k] = q;
                            this.groupProperty[k] = 410;
                        }
                        this.groupProperty[i] = 410;
                        this.groupProperty[aN[0]] = 410;
                        this.groupProperty[rootC] = 410;
                        this.groupType[i] = c[1];
                        this.groupType[aN[0]] = c[1];
                        this.groupType[rootC] = c[1];
                        this.groupIndex[i] = c[2];
                        this.groupIndex[aN[0]] = c[2];
                        this.groupIndex[rootC] = c[2];
                    } else if (c[0] == 410) {
                        this.groupProperty[i] = c[0];
                        this.groupProperty[aN[0]] = c[0];
                        this.groupProperty[rootC] = c[0];
                        this.groupType[i] = c[1];
                        this.groupType[aN[0]] = c[1];
                        this.groupType[rootC] = c[1];
                        this.groupIndex[i] = c[2];
                        this.groupIndex[aN[0]] = c[2];
                        this.groupIndex[rootC] = c[2];
                    } else if (c[0] == 411) {
                        for (k = 0; k < this.atomCount; ++k) {
                            if (this.groupIndex[k] != c[2]) continue;
                            this.groupType[k] = q;
                            this.groupProperty[k] = 410;
                        }
                        this.groupIndex[i] = c[2];
                        this.groupIndex[aN[0]] = c[2];
                        this.groupIndex[rootC] = c[2];
                        this.groupType[i] = q;
                        this.groupType[aN[0]] = q;
                        this.groupType[rootC] = q;
                        this.groupProperty[i] = 410;
                        this.groupProperty[aN[0]] = 410;
                        this.groupProperty[rootC] = 410;
                    } else {
                        this.groupIndex[i] = this.gCount;
                        this.groupIndex[aN[0]] = this.gCount;
                        this.groupIndex[rootC] = this.gCount++;
                        this.groupType[i] = q;
                        this.groupType[aN[0]] = q;
                        this.groupType[rootC] = q;
                        this.groupProperty[i] = 409;
                        this.groupProperty[aN[0]] = 409;
                        this.groupProperty[rootC] = 409;
                    }
                } else if (amide && keto && aCount == 2 && !nitro) {
                    q = this.getSymbol(i).equals("O") ? 13 : 11;
                    this.carboxy[i] = 200;
                    this.carboxy[aN[0]] = 200;
                    this.carboxy[aN[1]] = 200;
                    this.carboxy[rootC] = 200;
                    int[] c = this.isGroupAssignedYet(i, aN, rootC);
                    if (c[0] == 409) {
                        for (k = 0; k < this.atomCount; ++k) {
                            if (this.groupIndex[k] != c[2]) continue;
                            this.groupType[k] = q;
                            this.groupProperty[k] = 410;
                        }
                        this.groupProperty[i] = 410;
                        this.groupProperty[aN[0]] = 410;
                        this.groupProperty[aN[1]] = 410;
                        this.groupProperty[rootC] = 410;
                        this.groupType[i] = c[1];
                        this.groupType[aN[0]] = c[1];
                        this.groupType[aN[1]] = c[1];
                        this.groupType[rootC] = c[1];
                        this.groupIndex[i] = c[2];
                        this.groupIndex[aN[0]] = c[2];
                        this.groupIndex[aN[1]] = c[2];
                        this.groupIndex[rootC] = c[2];
                    } else if (c[0] == 410) {
                        this.groupProperty[i] = c[0];
                        this.groupProperty[aN[0]] = c[0];
                        this.groupProperty[aN[1]] = c[0];
                        this.groupProperty[rootC] = c[0];
                        this.groupType[i] = c[1];
                        this.groupType[aN[0]] = c[1];
                        this.groupType[aN[1]] = c[1];
                        this.groupType[rootC] = c[1];
                        this.groupIndex[i] = c[2];
                        this.groupIndex[aN[0]] = c[2];
                        this.groupIndex[aN[1]] = c[2];
                        this.groupIndex[rootC] = c[2];
                    } else if (c[0] == 411) {
                        for (k = 0; k < this.atomCount; ++k) {
                            if (this.groupIndex[k] != c[2]) continue;
                            this.groupType[k] = q;
                            this.groupProperty[k] = 410;
                        }
                        this.groupIndex[i] = c[2];
                        this.groupIndex[aN[0]] = c[2];
                        this.groupIndex[aN[1]] = c[2];
                        this.groupIndex[rootC] = c[2];
                        this.groupType[i] = q;
                        this.groupType[aN[0]] = q;
                        this.groupType[aN[1]] = q;
                        this.groupType[rootC] = q;
                        this.groupProperty[i] = 410;
                        this.groupProperty[aN[0]] = 410;
                        this.groupProperty[aN[1]] = 410;
                        this.groupProperty[rootC] = 410;
                    } else {
                        this.groupIndex[i] = this.gCount;
                        this.groupIndex[aN[0]] = this.gCount;
                        this.groupIndex[aN[1]] = this.gCount;
                        this.groupIndex[rootC] = this.gCount++;
                        this.groupType[i] = q;
                        this.groupType[aN[0]] = q;
                        this.groupType[aN[1]] = q;
                        this.groupType[rootC] = q;
                        this.groupProperty[i] = 411;
                        this.groupProperty[aN[0]] = 411;
                        this.groupProperty[aN[1]] = 411;
                        this.groupProperty[rootC] = 411;
                    }
                } else if (alkohol && nitroso) {
                    this.carboxy[i] = 300;
                    this.groupIndex[i] = this.gCount;
                    this.groupProperty[i] = 600;
                    this.carboxy[OH] = 300;
                    this.groupIndex[OH] = this.gCount;
                    this.groupProperty[OH] = 600;
                    this.carboxy[rootC] = 300;
                    this.groupIndex[rootC] = this.gCount++;
                    this.groupProperty[rootC] = 600;
                } else if (alkoxy && nitroso) {
                    this.carboxy[i] = 2;
                    this.groupIndex[i] = this.gCount;
                    this.groupType[i] = 14;
                    this.carboxy[OR] = 2;
                    this.groupIndex[OR] = this.gCount;
                    this.groupType[OR] = 14;
                    this.carboxy[rootC] = 2;
                    this.groupIndex[rootC] = this.gCount++;
                    this.groupType[rootC] = 14;
                } else if (nitroso) {
                    this.carboxy[i] = 1200;
                    this.groupIndex[i] = this.gCount;
                    this.carboxy[rootC] = 1200;
                    this.groupIndex[rootC] = this.gCount++;
                } else if (nitro) {
                    t = 100;
                    if (carbon != -1 && this.isArA(carbon)) {
                        t = 1300;
                    }
                    this.carboxy[i] = t;
                    this.groupIndex[i] = this.gCount;
                    this.carboxy[rootC] = t;
                    this.groupIndex[rootC] = this.gCount;
                    if (RXO2 != -1) {
                        this.carboxy[RXO2] = t;
                        this.groupIndex[RXO2] = this.gCount;
                    }
                    ++this.gCount;
                } else if (cyano) {
                    this.carboxy[i] = 400;
                    this.groupIndex[i] = this.gCount;
                    this.carboxy[rootC] = 400;
                    this.groupIndex[rootC] = this.gCount;
                    if (this.isAraNbExist(rootC)) {
                        this.groupType[i] = 24;
                        this.groupType[rootC] = 24;
                    }
                    if (this.getAtom(rootC).getCharge() == 1 && this.getSymbol(rootC).equals("N")) {
                        if (this.isDiazoMethanLike(rootC, i)) {
                            this.groupProperty[i] = 3650;
                            this.groupProperty[rootC] = 3650;
                        } else {
                            this.groupProperty[i] = 3600;
                            this.groupProperty[rootC] = 3600;
                        }
                    }
                    ++this.gCount;
                } else if (alkoxy && keto && alkohol) {
                    q = 2;
                    if (this.getSymbol(rootC).equals("S")) {
                        q = 19;
                    } else if (this.getSymbol(rootC).equals("P")) {
                        q = 20;
                    }
                    int g = this.gCount;
                    for (z = 0; ORIndex[z] != -1 && z < 6; ++z) {
                        if (q != 20 || this.groupProperty[ORIndex[z]] != 500) continue;
                        g = this.groupIndex[ORIndex[z]];
                    }
                    for (z = 0; ORIndex[z] != -1 && z < 6; ++z) {
                        this.carboxy[ORIndex[z]] = 2;
                        this.groupIndex[ORIndex[z]] = g;
                        this.groupType[ORIndex[z]] = q;
                        this.groupProperty[ORIndex[z]] = 500;
                    }
                    for (z = 0; OHIndex[z] != -1 && z < 6; ++z) {
                        this.carboxy[OHIndex[z]] = 300;
                        this.groupIndex[OHIndex[z]] = g;
                        this.groupType[OHIndex[z]] = 17;
                        if (q == 20) {
                            this.groupProperty[OHIndex[z]] = 3000;
                            continue;
                        }
                        if (q != 19) continue;
                        this.groupProperty[OHIndex[z]] = 700;
                    }
                    if (crossAtom) {
                        this.carboxy[RXO2] = 300;
                        this.groupIndex[RXO2] = g;
                        this.groupType[RXO2] = 17;
                        this.groupProperty[RXO2] = q;
                        this.groupProperty[rootC] = q;
                    }
                    this.carboxy[i] = 300;
                    this.groupIndex[i] = g;
                    this.groupType[i] = 17;
                    this.carboxy[rootC] = 300;
                    this.groupIndex[rootC] = g;
                    this.groupType[rootC] = 17;
                    ++this.gCount;
                } else if (alkoxy && keto) {
                    z = 0;
                    q = 0;
                    if (this.getSymbol(rootC).equals("S")) {
                        q = 19;
                    } else if (this.getSymbol(rootC).equals("P")) {
                        q = 20;
                    }
                    if (crossAtom) {
                        this.carboxy[i] = 2;
                        this.groupIndex[i] = this.gCount;
                        this.groupType[i] = q;
                        this.carboxy[rootC] = 2;
                        this.groupIndex[rootC] = this.gCount;
                        this.groupType[rootC] = q;
                        this.carboxy[RXO2] = 2;
                        this.groupIndex[RXO2] = this.gCount;
                        this.groupType[RXO2] = q;
                        while (ORIndex[z] != -1 && z < 6) {
                            this.carboxy[ORIndex[z]] = 2;
                            this.groupIndex[ORIndex[z]] = this.gCount;
                            this.groupType[ORIndex[z]] = q;
                            this.groupProperty[ORIndex[z]] = 500;
                            ++z;
                        }
                    } else {
                        this.carboxy[i] = 2;
                        this.groupIndex[i] = this.gCount;
                        this.carboxy[OR] = 2;
                        this.groupIndex[OR] = this.gCount;
                        this.carboxy[rootC] = 2;
                        this.groupIndex[rootC] = this.gCount;
                        this.groupProperty[OR] = 500;
                        if (q != 0) {
                            this.groupType[i] = q;
                            this.groupType[OR] = q;
                            this.groupType[rootC] = q;
                        } else if (this.getSymbol(i).equals("S")) {
                            this.groupType[i] = 22;
                            this.groupType[OR] = 22;
                            this.groupType[rootC] = 22;
                        } else {
                            this.groupType[i] = 14;
                            this.groupType[OR] = 14;
                            this.groupType[rootC] = 14;
                        }
                    }
                    ++this.gCount;
                } else if (alkohol && keto) {
                    this.carboxy[i] = 300;
                    this.groupIndex[i] = this.gCount;
                    this.groupType[i] = 17;
                    this.carboxy[rootC] = 300;
                    this.groupIndex[rootC] = this.gCount;
                    this.groupType[rootC] = 17;
                    for (int k3 = 0; k3 < ohCount; ++k3) {
                        this.carboxy[OHIndex[k3]] = 300;
                        this.groupIndex[OHIndex[k3]] = this.gCount;
                        this.groupType[OHIndex[k3]] = 17;
                    }
                    if (crossAtom) {
                        this.groupProperty[i] = 700;
                        this.groupProperty[OH] = 700;
                        this.groupProperty[rootC] = 700;
                        this.groupProperty[RXO2] = 700;
                        this.carboxy[RXO2] = 300;
                        this.groupIndex[RXO2] = this.gCount;
                        this.groupType[RXO2] = 17;
                    } else if (!this.getSymbol(rootC).equals("C") && this.isCrossAtom(rootC)) {
                        this.groupProperty[i] = 800;
                        this.groupProperty[OH] = 800;
                        this.groupProperty[rootC] = 800;
                    }
                    ++this.gCount;
                } else if (keto) {
                    q = this.getSymbol(i).equals("O") ? 21 : 18;
                    this.carboxy[i] = 1;
                    this.carboxy[rootC] = 1;
                    if (this.isArA(rootC)) {
                        this.groupProperty[rootC] = 1100;
                        this.groupProperty[i] = 1100;
                    }
                    this.groupIndex[rootC] = this.gCount;
                    this.groupIndex[i] = this.gCount;
                    this.groupType[i] = q;
                    this.groupType[rootC] = q;
                    if (crossAtom) {
                        this.groupProperty[rootC] = 422;
                        this.groupProperty[i] = 422;
                        this.groupProperty[RXO2] = 422;
                    } else {
                        int[] type = this.isAldehyde(rootC, i);
                        if (type[0] == 1) {
                            this.groupProperty[rootC] = 421;
                            this.groupProperty[i] = 421;
                        } else if (type[0] == 2) {
                            this.groupProperty[rootC] = 3100;
                            this.groupProperty[i] = 3100;
                            this.groupProperty[type[1]] = 3100;
                        } else if (type[1] == 3) {
                            this.groupProperty[rootC] = 4500;
                            this.groupProperty[i] = 4500;
                        } else if (vinil && this.groupProperty[rootC] != 1100) {
                            this.groupProperty[rootC] = 3500;
                            this.groupProperty[i] = 3500;
                        }
                    }
                    ++this.gCount;
                }
                if (!halo) continue;
                this.carboxy[i] = 1400;
                this.groupIndex[i] = this.gCount++;
                continue;
            }
            if (this.cHtab[i].length == 2) {
                if (this.carboxy[i] != -1 || !(symb = this.getSymbol(i)).equals("S") && !symb.equals("O")) continue;
                if (this.getAtom(i).getCharge() == 1) {
                    int nitrogen = this.chargedNitroso(i);
                    if (nitrogen == -1) continue;
                    this.carboxy[i] = 1200;
                    this.groupIndex[i] = this.gCount;
                    if (this.carboxy[nitrogen] == -1) {
                        this.carboxy[nitrogen] = 1200;
                        this.groupIndex[nitrogen] = this.gCount;
                    }
                    ++this.gCount;
                    continue;
                }
                this.carboxy[i] = this.isAlkohol(i);
                if (this.carboxy[i] == 1000) {
                    if (this.isDiArylEther(i)) {
                        this.carboxy[i] = 1100;
                        this.groupIndex[i] = this.gCount;
                    } else if (this.isArOR(i)) {
                        this.groupType[i] = 23;
                    }
                }
                this.groupIndex[i] = this.gCount++;
                continue;
            }
            if (this.cHtab[i].length != 3 || this.carboxy[i] != -1 || !(symb = this.getSymbol(i)).equals("N")) continue;
            if (this.isAnilineLike(i)) {
                this.carboxy[i] = 880;
                this.groupIndex[i] = this.gCount++;
                continue;
            }
            if (!this.isPyrRNOLike(i)) continue;
            this.carboxy[i] = 1200;
            this.carboxy[this.actPyrO] = 1200;
            this.groupIndex[i] = this.gCount;
            this.groupIndex[this.actPyrO] = this.gCount++;
            this.groupProperty[i] = 4000;
            this.groupProperty[this.actPyrO] = 4000;
        }
        this.resetFalseGroups();
        this.setAtomicGroups();
    }

    private boolean isDiazoMethanLike(int r, int g) {
        for (int i = 0; i < this.cHtab[r].length; ++i) {
            MolAtom am;
            int pc;
            int nb = this.cHtab[r][i];
            if (nb >= this.atomCount || nb == g || (pc = (am = this.getAtom(nb)).getAtno()) != 6 || am.getCharge() != -1) continue;
            this.actAtom = nb;
            return true;
        }
        return false;
    }

    private boolean isPyrRNOLike(int ai) {
        if (!this.isArA(ai)) {
            return false;
        }
        int chg_n = this.mol.getAtom(ai).getCharge();
        this.mol.getAtom(ai).getCharge();
        int L = this.cHtab[ai].length;
        if (L == 3) {
            for (int i = 0; i < L; ++i) {
                int chg_o;
                int nb = this.cHtab[ai][i];
                if (nb >= this.atomCount || !this.getSymbol(nb).equals("O") || this.isArA(nb)) continue;
                int bt_nO = this.mol.getBond(this.bHtab[nb][ai]).getType();
                if (bt_nO == 2) {
                    if (chg_n != 0 || (chg_o = this.mol.getAtom(nb).getCharge()) != 0 && chg_o != 1) continue;
                    this.actPyrO = nb;
                    return true;
                }
                if (bt_nO != 1 || chg_n != 1 || (chg_o = this.mol.getAtom(nb).getCharge()) != -1) continue;
                this.actPyrO = nb;
                return true;
            }
        }
        return false;
    }

    private boolean isAnilineLike(int i) {
        if (this.isArA(i)) {
            return false;
        }
        int a = 0;
        int b = 0;
        boolean bad = false;
        for (int j = 0; j < this.cHtab[i].length; ++j) {
            int nb = this.cHtab[i][j];
            if (nb >= this.atomCount) continue;
            String symb = this.getSymbol(nb);
            if (this.isArA(nb)) {
                ++a;
                continue;
            }
            if (symb.equals("C") || symb.equals("c")) {
                if (this.cHtab[nb].length == 4) {
                    ++b;
                    continue;
                }
                bad = true;
                continue;
            }
            bad = true;
        }
        if (bad) {
            return false;
        }
        if (a == 0) {
            return false;
        }
        if (a > 1) {
            this.groupProperty[i] = 570;
        } else if (a == 1 && b == 0) {
            this.groupProperty[i] = 550;
        }
        return true;
    }

    private void print() {
        for (int i = 0; i < this.gCount; ++i) {
            for (int j = 0; j < this.groups[i].length; ++j) {
                System.out.print(this.groups[i][j] + "  ");
                int a = this.groups[i][j];
                System.out.println("atom = " + (a + 1) + "  " + this.carboxy[a] + "  " + this.groupProperty[a] + "  " + this.groupType[a] + "  " + this.chargeState[a] + "  " + this.groupIndex[a]);
            }
        }
    }

    private boolean isVinyl(int nnb, int nb) {
        return this.mol.getBond(this.bHtab[nnb][nb]).getType() > 1;
    }

    private void setAtomicGroups() {
        int i;
        int gi;
        this.groups = new int[this.gCount][];
        int[] gc = new int[this.gCount];
        for (int i2 = 0; i2 < this.atomCount; ++i2) {
            if (this.carboxy[i2] == -1) continue;
            int n = gi = this.groupIndex[i2];
            gc[n] = gc[n] + 1;
        }
        for (i = 0; i < this.gCount; ++i) {
            int gSize = gc[i];
            this.groups[i] = new int[gSize];
            for (int j = 0; j < gSize; ++j) {
                this.groups[i][j] = -1;
            }
        }
        for (i = 0; i < this.atomCount; ++i) {
            if (this.carboxy[i] == -1) continue;
            gi = this.groupIndex[i];
            int k = 0;
            while (this.groups[gi][k] != -1) {
                ++k;
            }
            this.groups[gi][k] = i;
        }
    }

    private boolean isDbBonded(int i) {
        if (this.cHtab[i].length == 1) {
            if (this.getAtom(i).getCharge() != -1) {
                int nb = this.cHtab[i][0];
                if (nb < this.atomCount && this.mol.getBond(this.bHtab[i][nb]).getType() > 1) {
                    return true;
                }
                String symb = this.getSymbol(i);
                if (symb.equals("F") || symb.equals("Cl") || symb.equals("Br") || symb.equals("I")) {
                    return true;
                }
            } else {
                this.chargeState[i] = 1000;
                this.setAlcoholate(i);
            }
        } else if (this.cHtab[i].length == 2) {
            if (this.getAtom(i).getCharge() == 1) {
                int nb1 = this.cHtab[i][0];
                int nb2 = this.cHtab[i][1];
                if (nb1 < this.atomCount) {
                    if (this.mol.getBond(this.bHtab[i][nb1]).getType() > 1) {
                        if (nb2 >= this.atomCount) {
                            this.chargeState[i] = 900;
                            return true;
                        }
                        if (this.getSymbol(i).equals("H")) {
                            this.chargeState[i] = 900;
                            return true;
                        }
                    }
                } else if (nb2 < this.atomCount && this.mol.getBond(this.bHtab[i][nb2]).getType() > 1) {
                    if (nb1 >= this.atomCount) {
                        this.chargeState[i] = 900;
                        return true;
                    }
                    if (this.getSymbol(i).equals("H")) {
                        this.chargeState[i] = 900;
                        return true;
                    }
                }
            } else if (this.getAtom(i).getCharge() == -1) {
                this.chargeState[i] = 1000;
            }
        } else if (this.getAtom(i).getCharge() == -1) {
            this.chargeState[i] = 1000;
        }
        if (this.cHtab[i].length == 2) {
            if (this.getSymbol(i).equals("N")) {
                if (!this.setGuaOrAmidine(i) && this.carboxy[i] == -1) {
                    this.setImidLikeN(i);
                }
            } else if (!this.isArA(i) && this.getSymbol(i).equals("C")) {
                this.isTripBondExist(i);
            }
        } else if (this.getAtom(i).getCharge() == 1 && this.getSymbol(i).equals("N")) {
            this.chargeState[i] = 900;
            if (this.cHtab[i].length == 3) {
                int dbc = this.getDBCount(i);
                if (dbc == 1) {
                    if (!this.setGuaOrAmidine(i) && this.carboxy[i] == -1) {
                        this.setImidLikeN(i);
                    }
                } else if (dbc == 2 && this.isArA(i) && this.isPyrRNOLike(i)) {
                    this.carboxy[i] = 1200;
                    this.carboxy[this.actPyrO] = 1200;
                    this.groupIndex[i] = this.gCount;
                    this.groupIndex[this.actPyrO] = this.gCount++;
                    this.groupProperty[i] = 4000;
                    this.groupProperty[this.actPyrO] = 4000;
                }
            }
        }
        return false;
    }

    private void setAlcoholate(int i) {
        if (this.carboxy[i] == -1 && this.getSymbol(i).equals("O")) {
            this.carboxy[i] = 900;
            this.groupIndex[i] = this.gCount++;
        }
    }

    private int getDBCount(int ai) {
        int c = 0;
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.atomCount || this.mol.getBond(this.bHtab[ai][nb]).getType() <= 1) continue;
            ++c;
        }
        return c;
    }

    private boolean isTripBondExist(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int bt;
            int nb = this.cHtab[ai][i];
            if (nb >= this.atomCount || (bt = this.mol.getBond(this.bHtab[ai][nb]).getType()) != 3) continue;
            int pc = this.mol.getAtom(nb).getAtno();
            if (pc != 7) {
                this.carboxy[ai] = 1840;
                this.groupIndex[ai] = this.gCount;
                this.carboxy[nb] = 1840;
                this.groupIndex[nb] = this.gCount++;
            }
            return true;
        }
        return false;
    }

    private boolean isDBExist(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.atomCount || this.mol.getBond(this.bHtab[ai][nb]).getType() <= 1) continue;
            this.actAtom = nb;
            return true;
        }
        return false;
    }

    private void setImidLikeN(int ai) {
        boolean a = false;
        boolean b = false;
        int root = 0;
        boolean cc = false;
        boolean nm = false;
        int nminus = 0;
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb < this.atomCount) {
                if (this.mol.getBond(this.bHtab[ai][nb]).getType() > 1) {
                    if (this.getSymbol(nb).equals("C") || this.getSymbol(nb).equals("c")) {
                        cc = true;
                    } else if (this.getSymbol(nb).equals("N") && this.getAtom(nb).getCharge() == -1) {
                        nm = true;
                        nminus = nb;
                    }
                    b = true;
                    root = nb;
                    continue;
                }
                a = true;
                continue;
            }
            a = true;
        }
        if (nm && cc) {
            this.carboxy[ai] = 1700;
            this.carboxy[nminus] = 1700;
            this.groupProperty[ai] = 3650;
            this.groupProperty[nminus] = 3650;
            this.groupIndex[ai] = this.gCount;
            this.groupIndex[nminus] = this.gCount++;
            this.groupType[ai] = 3200;
            this.groupType[nminus] = 3200;
        } else if (a && b) {
            this.carboxy[ai] = 1700;
            this.groupIndex[ai] = this.gCount;
            if (this.carboxy[root] == -1) {
                this.carboxy[root] = 1700;
                this.groupIndex[root] = this.gCount;
            }
            if (this.isKetene(ai, root)) {
                this.groupProperty[ai] = 3200;
            } else {
                int yy = this.isEster(ai, root);
                if (yy == 2) {
                    this.groupProperty[ai] = 2;
                    this.groupProperty[root] = 2;
                    this.groupProperty[this.actAtom] = 2;
                    this.groupIndex[this.actAtom] = this.gCount;
                    this.carboxy[this.actAtom] = 2;
                    this.carboxy[ai] = 2;
                    this.carboxy[root] = 2;
                    this.groupType[ai] = 1700;
                    this.groupType[root] = 1700;
                    this.groupType[this.actAtom] = 1700;
                } else if (yy == 300) {
                    this.groupProperty[ai] = 300;
                    this.groupProperty[root] = 300;
                    this.groupProperty[this.actAtom] = 300;
                    this.groupType[ai] = 870;
                    this.groupType[root] = 870;
                    this.groupType[this.actAtom] = 870;
                    this.groupIndex[this.actAtom] = this.gCount;
                    this.carboxy[this.actAtom] = 300;
                    this.carboxy[ai] = 300;
                    this.carboxy[root] = 300;
                } else if (this.isAraAliDiaza(ai, root)) {
                    this.groupProperty[ai] = 3800;
                    this.groupProperty[root] = 3800;
                    this.groupIndex[ai] = this.gCount;
                    this.groupIndex[root] = this.gCount;
                    this.groupType[ai] = 875;
                    this.groupType[root] = 875;
                }
            }
            ++this.gCount;
        }
    }

    private boolean isKetene(int n, int c) {
        for (int i = 0; i < this.cHtab[c].length; ++i) {
            int b;
            int nb = this.cHtab[c][i];
            if (nb >= this.atomCount || nb == n || (b = this.mol.getBond(this.bHtab[nb][c]).getType()) != 2) continue;
            return true;
        }
        return false;
    }

    private boolean isAraAliDiaza(int n, int root) {
        int b;
        String symb = this.getSymbol(root);
        return symb.equals("N") && (b = this.mol.getBond(this.bHtab[n][root]).getType()) == 2 && this.isAraNbExist(n) && this.isAraNbExist(root) && !this.isArA(n) && !this.isArA(root);
    }

    private int isEster(int n, int root) {
        this.actAtom = -1;
        for (int i = 0; i < this.cHtab[root].length; ++i) {
            String symb;
            int b;
            int nb = this.cHtab[root][i];
            if (nb >= this.atomCount || nb == n || (b = this.mol.getBond(this.bHtab[nb][root]).getType()) != 1 || (symb = this.getSymbol(nb)).equals("N") || symb.equals("C")) continue;
            if (!this.isHexist(nb)) {
                if (this.cHtab[nb].length > 1) {
                    this.actAtom = nb;
                    return 2;
                }
                if (this.getAtom(nb).getCharge() != -1) continue;
                this.actAtom = nb;
                return 300;
            }
            if (this.cHtab[nb].length != 2) continue;
            this.actAtom = nb;
            return 300;
        }
        return -1;
    }

    private boolean setGuaOrAmidine(int ai) {
        int k = 0;
        int[] n = new int[]{-1, -1};
        int root = -1;
        int c = 0;
        int a = 0;
        int eb = 0;
        int w = 0;
        boolean Oanion = false;
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.atomCount) continue;
            if (this.getSymbol(nb).equals("C")) {
                if (this.mol.getBond(this.bHtab[ai][nb]).getType() != 2) continue;
                root = nb;
                if (++c > 1) {
                    return false;
                }
                for (int j = 0; j < this.cHtab[nb].length; ++j) {
                    int nnb = this.cHtab[nb][j];
                    if (nnb >= this.atomCount || nnb == ai || !this.getSymbol(nnb).equals("N") || this.isDBExist(nnb) || nnb == ai || this.carboxy[nnb] != -1) continue;
                    n[k] = nnb;
                    ++k;
                }
                continue;
            }
            int y = this.isMaybeAlkohol(nb);
            if (y == 900 && this.actChg == -1) {
                Oanion = true;
            }
            if (y == 900) {
                ++a;
                continue;
            }
            if (y != 1000) continue;
            ++eb;
            w = nb;
        }
        if (root == -1) {
            return false;
        }
        if (a != 0) {
            if (k == 1) {
                this.carboxy[n[0]] = 1500;
                this.groupIndex[n[0]] = this.gCount;
            } else if (k == 2) {
                this.carboxy[n[0]] = 1600;
                this.groupIndex[n[0]] = this.gCount;
                this.carboxy[n[1]] = 1600;
                this.groupIndex[n[1]] = this.gCount;
            }
            if (Oanion) {
                this.carboxy[ai] = 1200;
                this.groupIndex[ai] = this.gCount;
                this.carboxy[root] = 1200;
                this.groupIndex[root] = this.gCount++;
            } else {
                this.carboxy[ai] = 1800;
                this.groupIndex[ai] = this.gCount;
                this.carboxy[root] = 1800;
                this.groupIndex[root] = this.gCount++;
            }
            return true;
        }
        if (k == 1) {
            this.carboxy[ai] = 1500;
            this.carboxy[n[0]] = 1500;
            this.groupIndex[ai] = this.gCount;
            this.groupIndex[n[0]] = this.gCount;
            this.carboxy[root] = 1500;
            this.groupIndex[root] = this.gCount++;
            return true;
        }
        if (k == 2) {
            this.carboxy[ai] = 1600;
            this.carboxy[n[0]] = 1600;
            this.carboxy[n[1]] = 1600;
            this.groupIndex[ai] = this.gCount;
            this.groupIndex[n[0]] = this.gCount;
            this.groupIndex[n[1]] = this.gCount;
            this.carboxy[root] = 1600;
            this.groupIndex[root] = this.gCount++;
            return true;
        }
        if (eb != 0) {
            this.carboxy[ai] = 1830;
            this.carboxy[root] = 1830;
            this.carboxy[w] = 1830;
            this.groupIndex[ai] = this.gCount;
            this.groupIndex[root] = this.gCount;
            this.groupIndex[w] = this.gCount++;
            this.groupType[ai] = 1700;
            this.groupType[root] = 1700;
            this.groupType[w] = 1700;
            return true;
        }
        return false;
    }

    private boolean isCrossAtom(int ai) {
        int c = 0;
        int bt = 0;
        int b = 0;
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb < this.atomCount) {
                bt = this.mol.getBond(this.bHtab[ai][nb]).getType();
                b += bt;
                if (bt <= 1) continue;
                ++c;
                continue;
            }
            ++b;
        }
        if (c >= 2) {
            return true;
        }
        return b > 4;
    }

    private boolean isAraNbExist(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.atomCount || !this.isArA(this.cHtab[ai][i])) continue;
            return true;
        }
        return false;
    }

    private boolean isNitroso(int nitrogen) {
        int oCount = 0;
        for (int i = 0; i < this.cHtab[nitrogen].length; ++i) {
            int nb = this.cHtab[nitrogen][i];
            if (!this.getSymbol(nb).equals("O") && !this.getSymbol(nb).equals("S")) continue;
            if (this.cHtab[nb].length == 1 && this.getAtom(nb).getCharge() != -1) {
                ++oCount;
                continue;
            }
            if (this.cHtab[nb].length != 2 || this.chargeState[nb] != 900 || this.mol.getBond(this.bHtab[nitrogen][nb]).getType() != 2) continue;
            ++oCount;
        }
        return oCount == 1;
    }

    private String getSymbol(int i) {
        if (i >= this.atomCount) {
            return "H";
        }
        MolAtom a = this.mol.getAtom(i);
        return a.getSymbol();
    }

    private int isMaybeAlkohol(int atom) {
        String symb2 = this.getSymbol(atom);
        this.actChg = 0;
        if (symb2.equals("O") || symb2.equals("S") || symb2.equals("Se") || symb2.equals("Te")) {
            int chg;
            if (this.cHtab[atom].length == 2) {
                return this.isAlkohol(atom);
            }
            if (this.cHtab[atom].length == 1 && (chg = this.getAtom(atom).getCharge()) < 0) {
                this.actChg = chg;
                return 900;
            }
        }
        return -1;
    }

    private int isAlkohol(int atom) {
        int nb1 = this.cHtab[atom][0];
        int nb2 = this.cHtab[atom][1];
        if (!this.getSymbol(nb1).equals("H") && !this.getSymbol(nb2).equals("H")) {
            return 1000;
        }
        return 900;
    }

    private void resetFalseGroups() {
        for (int i = 0; i < this.atomCount; ++i) {
            int nb;
            int j;
            if (this.carboxy[i] == 900) {
                for (j = 0; j < this.cHtab[i].length; ++j) {
                    nb = this.cHtab[i][j];
                    if (nb >= this.atomCount) continue;
                    if (this.carboxy[nb] == 1 || this.carboxy[nb] == 300 || this.carboxy[nb] == 1200 || this.carboxy[nb] == 1800) {
                        this.carboxy[i] = this.carboxy[nb];
                        this.groupIndex[i] = this.groupIndex[nb];
                        this.groupType[i] = this.groupType[nb];
                        this.groupProperty[i] = this.groupProperty[nb];
                        continue;
                    }
                    if (this.carboxy[nb] != 1700) continue;
                    this.setPreAmide(i, nb);
                }
                continue;
            }
            if (this.carboxy[i] == 200) {
                if (!this.getSymbol(i).equals("N")) continue;
                for (j = 0; j < this.cHtab[i].length; ++j) {
                    nb = this.cHtab[i][j];
                    if (nb >= this.atomCount || !this.getSymbol(nb).equals("N") || this.carboxy[nb] != -1) continue;
                    this.carboxy[nb] = 1820;
                    this.groupIndex[nb] = this.gCount++;
                    this.groupType[nb] = this.groupType[i];
                    this.groupProperty[nb] = this.groupProperty[i];
                }
                this.setFalseCONHGroup(i);
                continue;
            }
            if (this.carboxy[i] == 1000 || this.carboxy[i] == 2) {
                this.setFalsePESTERGroup(i);
                continue;
            }
            if (this.carboxy[i] == 1 && this.groupProperty[i] == 422) {
                if (!this.getSymbol(i).equals("S")) continue;
                for (j = 0; j < this.cHtab[i].length; ++j) {
                    nb = this.cHtab[i][j];
                    if (nb >= this.atomCount || this.groupProperty[nb] != 422) continue;
                    this.carboxy[nb] = this.carboxy[i];
                    this.groupIndex[nb] = this.groupIndex[i];
                    this.groupType[nb] = this.groupType[i];
                    this.groupProperty[nb] = this.groupProperty[i];
                }
                continue;
            }
            if (this.carboxy[i] == 1500) {
                if (!this.getSymbol(i).equals("N") || !this.isDBExist(i)) continue;
                this.setFalseAmidineGuanidine(i, this.actAtom);
                continue;
            }
            if (this.carboxy[i] != -1 || this.chargeState[i] != 1000) continue;
            for (j = 0; j < this.cHtab[i].length; ++j) {
                nb = this.cHtab[i][j];
                if (nb >= this.atomCount || this.carboxy[nb] == -1) continue;
                this.carboxy[i] = this.carboxy[nb];
                this.groupIndex[i] = this.groupIndex[nb];
                this.groupType[i] = this.groupType[nb];
                this.groupProperty[i] = this.groupProperty[nb];
            }
        }
    }

    private void setPreAmide(int oai, int cai) {
        for (int i = 0; i < this.cHtab[cai].length; ++i) {
            int nb = this.cHtab[cai][i];
            if (nb >= this.atomCount || !this.getSymbol(nb).equals("N") || this.carboxy[nb] != 1700) continue;
            this.groupType[nb] = 870;
            this.groupType[cai] = 870;
            this.groupType[oai] = 870;
            this.carboxy[nb] = 300;
            this.carboxy[cai] = 300;
            this.carboxy[oai] = 300;
            this.groupProperty[nb] = 300;
            this.groupProperty[cai] = 300;
            this.groupProperty[oai] = 300;
            this.groupIndex[oai] = this.groupIndex[nb];
        }
    }

    private void setFalseAmidineGuanidine(int nIndx, int dbatom) {
        int type = this.carboxy[nIndx];
        int k = 0;
        int g = 0;
        int vv = -1;
        for (int i = 0; i < this.cHtab[dbatom].length; ++i) {
            int nb = this.cHtab[dbatom][i];
            if (nb >= this.atomCount || nb == nIndx || !this.getSymbol(nb).equals("N")) continue;
            if (this.carboxy[nb] != this.carboxy[nIndx]) {
                --k;
                continue;
            }
            ++g;
            vv = nb;
        }
        int y = g + k;
        if (type == 1500) {
            if (y == -1) {
                this.carboxy[dbatom] = 1700;
                this.carboxy[nIndx] = 1700;
            }
        } else if (type == 1600) {
            if (y == -2) {
                this.carboxy[dbatom] = 1700;
                this.carboxy[nIndx] = 1700;
            } else if (y == 0) {
                this.carboxy[dbatom] = 1500;
                this.carboxy[nIndx] = 1500;
                this.carboxy[vv] = 1500;
            }
        }
    }

    private void setFalseCONHGroup(int nIndx) {
        int nb;
        boolean find = false;
        int ai = -1;
        int pi = -1;
        for (int i = 0; !find && i < this.cHtab[nIndx].length; ++i) {
            nb = this.cHtab[nIndx][i];
            if (nb >= this.atomCount || this.carboxy[nb] == -1 || this.groupIndex[nb] == this.groupIndex[nIndx] || !this.isDBExist(nb)) continue;
            if (this.groupProperty[nb] == 409 && this.groupProperty[nIndx] == 410) {
                find = true;
                ai = nb;
                pi = nIndx;
                continue;
            }
            if (this.groupProperty[nIndx] != 409 || this.groupProperty[nb] != 410) continue;
            find = true;
            ai = nIndx;
            pi = nb;
        }
        if (find) {
            this.carboxy[ai] = this.carboxy[pi];
            this.groupIndex[ai] = this.groupIndex[pi];
            this.groupType[ai] = this.groupType[pi];
            this.groupProperty[ai] = this.groupProperty[pi];
            for (int j = 0; j < this.cHtab[ai].length; ++j) {
                nb = this.cHtab[ai][j];
                if (nb >= this.atomCount || this.mol.getBond(this.bHtab[ai][nb]).getType() != 2) continue;
                this.carboxy[nb] = this.carboxy[pi];
                this.groupIndex[nb] = this.groupIndex[pi];
                this.groupType[nb] = this.groupType[pi];
                this.groupProperty[nb] = this.groupProperty[pi];
            }
        }
    }

    private void setFalsePESTERGroup(int ror) {
        int nb;
        int i;
        boolean find = false;
        if (this.getSymbol(ror).equals("P")) {
            for (i = 0; i < this.cHtab[ror].length; ++i) {
                nb = this.cHtab[ror][i];
                if (nb >= this.atomCount || this.isDBExist(nb) || this.carboxy[nb] != 2) continue;
                this.groupIndex[ror] = this.groupIndex[nb];
                find = true;
            }
            if (find) {
                for (i = 0; i < this.cHtab[ror].length; ++i) {
                    nb = this.cHtab[ror][i];
                    if (nb >= this.atomCount) continue;
                    this.groupIndex[nb] = this.groupIndex[ror];
                }
                return;
            }
        }
        for (i = 0; i < this.cHtab[ror].length; ++i) {
            nb = this.cHtab[ror][i];
            if (nb >= this.atomCount || !this.getSymbol(nb).equals("P") || this.carboxy[nb] == -1 || !this.isDBExist(nb)) continue;
            if (this.carboxy[ror] != 2) {
                this.carboxy[ror] = 2;
                this.groupIndex[ror] = this.groupIndex[nb];
                this.groupType[ror] = 20;
                this.groupProperty[ror] = 500;
                continue;
            }
            if (this.groupIndex[ror] == this.groupIndex[nb]) continue;
            this.groupIndex[nb] = this.groupIndex[ror];
            for (int j = 0; j < this.cHtab[nb].length; ++j) {
                int pnb = this.cHtab[nb][j];
                if (pnb >= this.atomCount) continue;
                this.groupIndex[pnb] = this.groupIndex[ror];
            }
        }
        if (this.carboxy[ror] == 1000) {
            for (i = 0; i < this.cHtab[ror].length; ++i) {
                if (this.cHtab[ror][i] >= this.atomCount || this.carboxy[this.cHtab[ror][i]] != 200 || !this.getSymbol(this.cHtab[ror][i]).equals("N")) continue;
                this.groupProperty[ror] = 3700;
            }
        }
    }

    private boolean isArOR(int atom) {
        return this.isArA(this.cHtab[atom][0]) || this.isArA(this.cHtab[atom][1]);
    }

    private boolean isDiArylEther(int atom) {
        return this.isArA(this.cHtab[atom][0]) && this.isArA(this.cHtab[atom][1]);
    }

    private boolean isArA(int atom) {
        if (atom >= this.atomCount || atom < 0) {
            return false;
        }
        if (this.isArom == null) {
            this.isArom = new boolean[this.atomCount];
            for (int i = 0; i < this.atomCount; ++i) {
                this.isArom[i] = this.mol.getAtom(i).hasAromaticBond();
            }
        }
        return this.isArom[atom];
    }

    private boolean isHexist(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb < this.atomCount) continue;
            return true;
        }
        return false;
    }

    private int[] isAldehyde(int ketoRoot, int keto) {
        int c = 0;
        boolean Hexist = false;
        int hetero = 0;
        int[] r = new int[]{-1, -1};
        int carbon = 0;
        for (int i = 0; i < this.cHtab[ketoRoot].length; ++i) {
            int nb = this.cHtab[ketoRoot][i];
            if (nb < this.atomCount) {
                ++c;
                if (!this.getSymbol(nb).equals("C")) {
                    ++hetero;
                    continue;
                }
                if (this.cHtab[nb].length != 4) continue;
                ++carbon;
                continue;
            }
            Hexist = true;
        }
        if (c == 2) {
            if (Hexist) {
                if (carbon == 1) {
                    r[1] = 3;
                }
                r[0] = 1;
                return r;
            }
            if (!Hexist && hetero == 2) {
                r[0] = 2;
                r[1] = this.cHtab[ketoRoot][0] != keto ? this.cHtab[ketoRoot][0] : this.cHtab[ketoRoot][1];
                return r;
            }
        } else if (c > 2 && hetero == 1 && carbon == 2) {
            r[1] = 3;
        }
        return r;
    }

    private int chargedNitroso(int SorO) {
        String symb1 = "";
        String symb2 = "";
        if (this.cHtab[SorO][0] < this.atomCount) {
            symb1 = this.getSymbol(this.cHtab[SorO][0]);
        }
        if (this.cHtab[SorO][1] < this.atomCount) {
            symb2 = this.getSymbol(this.cHtab[SorO][1]);
        }
        if (symb1.equals("N")) {
            return this.cHtab[SorO][0];
        }
        if (symb2.equals("N")) {
            return this.cHtab[SorO][1];
        }
        return -1;
    }

    private int[] isGroupAssignedYet(int i, int[] aN, int rootC) {
        int[] c = new int[]{-1, -1, -1};
        if (this.groupProperty[i] != -1) {
            c[0] = this.groupProperty[i];
            c[1] = this.groupType[i];
            c[2] = this.groupIndex[i];
            return c;
        }
        if (aN[0] != -1 && this.groupProperty[aN[0]] != -1) {
            c[0] = this.groupProperty[aN[0]];
            c[1] = this.groupType[aN[0]];
            c[2] = this.groupIndex[aN[0]];
            return c;
        }
        if (aN[1] != -1 && this.groupProperty[aN[1]] != -1) {
            c[0] = this.groupProperty[aN[1]];
            c[1] = this.groupType[aN[1]];
            c[2] = this.groupIndex[aN[1]];
            return c;
        }
        if (this.groupProperty[i] != -1) {
            c[0] = this.groupProperty[rootC];
            c[1] = this.groupType[rootC];
            c[2] = this.groupIndex[rootC];
            return c;
        }
        return c;
    }

    public int[] getGroupIndex() {
        return this.groupIndex;
    }

    public int[] getGroupType() {
        return this.groupType;
    }

    public int[] getGroupProperty() {
        return this.groupProperty;
    }

    public int[][] getGroups() {
        return this.groups;
    }

    public int[] getChargeState() {
        return this.chargeState;
    }

    public void setChargeState(int index, int value) {
        this.chargeState[index] = value;
    }

    public int getGroupType(int index) {
        return this.groupType[index];
    }

    public int getGCount() {
        return this.gCount;
    }
}

