/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

import chemaxon.calculations.FunctionAreaGauss;
import chemaxon.calculations.PointsOnSphere;
import chemaxon.calculations.clean.Cleaner;
import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.modelling.linalg.GradientOptimization;
import chemaxon.marvin.modelling.struc.MolGeom;
import chemaxon.struc.MDocument;
import chemaxon.struc.MPoint;
import chemaxon.struc.Molecule;
import chemaxon.struc.graphics.MPolyline;
import java.awt.Color;

public class ProjectedSurfaceArea
implements Licensable {
    private Molecule molecule;
    private String generate3Dopts = "";
    private String licenseEnvironment = "";
    private FunctionAreaGauss f;
    private double distanceLimit = 1.0;
    private double distanceLimitThr = 0.1;
    private double ratioLimit = 0.89;
    private double ratioLimitThr = 0.02;
    private double minArea;
    private double maxArea;
    private double minZ;
    private double maxZ;
    double[] minV = new double[3];
    double[] maxV = new double[3];
    private int numberOfPoints = 100;
    private boolean accurateMode = false;
    private double maxRadius;
    private double minRadius;

    void checkLicense() throws LicenseException {
        LicenseHandler.getInstance().checkLicense("Geometry Plugin Group", this.licenseEnvironment);
    }

    void setDistanceLimit(double distanceLimit) {
        this.distanceLimit = distanceLimit;
    }

    void setDistanceLimitThr(double distanceLimitThr) {
        this.distanceLimitThr = distanceLimitThr;
    }

    void setRatioLimit(double ratioLimit) {
        this.ratioLimit = ratioLimit;
    }

    void setRatioLimitThr(double ratioLimitThr) {
        this.ratioLimitThr = ratioLimitThr;
    }

    double getDistanceLimit() {
        return this.distanceLimit;
    }

    double getDistanceLimitThr() {
        return this.distanceLimitThr;
    }

    double getRatioLimit() {
        return this.ratioLimit;
    }

    double getRatioLimitThr() {
        return this.ratioLimitThr;
    }

    int getStep() {
        return this.f.step;
    }

    int tot() {
        return this.f.tot;
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("Geometry Plugin Group", this.licenseEnvironment);
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    public void setMolecule(Molecule molecule) {
        this.molecule = molecule;
        if (molecule.getDim() != 3) {
            Cleaner.clean(molecule, 3, this.generate3Dopts);
        }
        this.f = new FunctionAreaGauss(molecule, this.distanceLimit, this.distanceLimitThr, this.ratioLimit, this.ratioLimitThr);
    }

    public void setGenerate3Dopts(String generate3Dopts) {
        this.generate3Dopts = generate3Dopts;
    }

    private void optimize() {
        GradientOptimization g = new GradientOptimization(this.f);
        g.setGradientRMSLimit(1.0);
        try {
            this.f.step = 0;
            g.run();
            if (!this.f.isCancelled() && !g.isOptimizationConverged()) {
                throw new UnsupportedOperationException("[BUG] Optimization was not converged.");
            }
        }
        catch (GradientOptimization.GradientOptimizationException ex) {
            throw new UnsupportedOperationException(ex);
        }
    }

    private void scanN() {
        this.minArea = -1.0;
        this.maxArea = -1.0;
        PointsOnSphere p = new PointsOnSphere(this.numberOfPoints);
        double[] var = this.f.getVariables();
        while (p.hasNext()) {
            double[] angles = p.next();
            if (!(angles[1] <= Math.PI)) continue;
            var[0] = Math.sin(angles[0]) * Math.cos(angles[1]);
            var[1] = Math.sin(angles[0]) * Math.sin(angles[1]);
            var[2] = Math.cos(angles[0]);
            this.f.setVariables(var);
            double fv = this.f.getFunctionValue();
            if (this.minArea == -1.0 || fv < this.minArea) {
                this.minArea = fv;
                MolGeom.arrayCopy(var, this.minV);
            }
            if (this.maxArea != -1.0 && !(fv > this.maxArea)) continue;
            this.maxArea = fv;
            MolGeom.arrayCopy(var, this.maxV);
        }
    }

    public void run() {
        this.checkLicense();
        this.f.opt = this.accurateMode;
        this.scanN();
        if (this.accurateMode) {
            this.f.setMax(true);
            this.f.setVariables(this.maxV);
            this.optimize();
            MolGeom.normalize(this.f.getVariables());
            MolGeom.arrayCopy(this.f.getVariables(), this.maxV);
            this.maxArea = this.f.getFunctionValue() * this.f.getSign();
            this.f.setMax(false);
            this.f.setVariables(this.minV);
            this.optimize();
            MolGeom.normalize(this.f.getVariables());
            MolGeom.arrayCopy(this.f.getVariables(), this.minV);
            this.minArea = this.f.getFunctionValue() * this.f.getSign();
        }
        this.f.setVariables(this.maxV);
        this.maxZ = this.f.maxZ();
        this.maxRadius = this.f.maxRadius();
        this.f.setVariables(this.minV);
        this.minZ = this.f.maxZ();
        this.minRadius = this.f.maxRadius();
    }

    public double getMaxZ() {
        return this.maxZ;
    }

    public double getMinZ() {
        return this.minZ;
    }

    public double getMaxRadius() {
        return this.maxRadius;
    }

    public double getMinRadius() {
        return this.minRadius;
    }

    static MPolyline arrow(double[] crd1, double[] crd2, Color color) {
        MPoint mp1 = new MPoint(crd1[0], crd1[1], crd1[2]);
        MPoint mp2 = new MPoint(crd2[0], crd2[1], crd2[2]);
        MPolyline arrow = new MPolyline(mp1, mp2, color, color);
        arrow.setArrow(true);
        arrow.setArrowLength(MPolyline.HEAD, 0.8);
        arrow.setArrowWidth(MPolyline.HEAD, 0.5);
        return arrow;
    }

    public Molecule getMoleculeWithCirclesAndVectors() {
        double[][] crd = MolGeom.getCoordniates(this.molecule);
        double[] center = MolGeom.getCenter(crd);
        MDocument md = this.molecule.getDocument();
        md = new MDocument(this.molecule);
        this.f.setVariables(this.maxV);
        this.f.addCirclePointCoordinates(md, Color.YELLOW);
        double[] maxTmp = MolGeom.arrayCopy(this.maxV);
        MolGeom.normalize(maxTmp);
        MolGeom.mul(maxTmp, this.maxZ);
        MolGeom.plusVec(maxTmp, center, maxTmp);
        md.addObject(ProjectedSurfaceArea.arrow(center, maxTmp, Color.YELLOW));
        this.f.setVariables(this.minV);
        this.f.addCirclePointCoordinates(md, Color.GREEN);
        double[] minTmp = MolGeom.arrayCopy(this.minV);
        MolGeom.normalize(minTmp);
        MolGeom.mul(minTmp, this.minZ);
        MolGeom.plusVec(minTmp, center, minTmp);
        md.addObject(ProjectedSurfaceArea.arrow(center, minTmp, Color.GREEN));
        return this.molecule;
    }

    public void setAccurateMode(boolean accurateMode) {
        this.accurateMode = accurateMode;
    }

    public double getMaxArea() {
        return this.maxArea;
    }

    public double getMinArea() {
        return this.minArea;
    }
}

