/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

import chemaxon.core.util.BondTable;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class Refractivity {
    private Molecule mol;
    private MolAtom[] atomArray;
    protected int[][] ctab;
    protected BondTable btab;
    private double[][] aRefInc;
    private int MOLATOMS;
    private int hCounter;
    private int rCounter;
    private int xCounter;
    private int dbCCounter;
    private int arRCounter;
    private int arXCounter;
    private int arSingleBond;
    private int Ar;
    private int xTripBond;
    private int hybridState;
    private int fragmentId;
    private int actualAtom;
    boolean alphaKeto = false;
    private double AtomicRefrac;
    boolean hValenceError;
    public boolean criticalError;
    final double[] EN = new double[]{2.1, 2.5, 3.0, 3.5, 4.0, 3.0, 2.8, 2.5, 2.5, 2.4, 2.1};

    public void setMolecule(Molecule m) {
        this.mol = m;
        this.setCriticalErrorFlag();
        this.hValenceError = false;
    }

    public Molecule getMolecule() {
        return this.mol;
    }

    public boolean getCriticalErrorFlag() {
        return this.criticalError;
    }

    protected void setCriticalErrorFlag() {
        this.criticalError = false;
        int n = this.mol.getAtomCount();
        for (int i = 0; i < n; ++i) {
            MolAtom a = this.mol.getAtom(i);
            if (!a.hasValenceError()) continue;
            int vc = a.getValence();
            int pc = a.getAtno();
            if (pc == 1 && vc > 1) {
                this.criticalError = true;
                return;
            }
            if (pc <= 10 && vc > 4) {
                this.criticalError = true;
                return;
            }
            if (pc <= 10 || vc <= 8) continue;
            this.criticalError = true;
            return;
        }
    }

    public double[] getAtomRefracIncrement(int atom) {
        return this.aRefInc[atom];
    }

    private void initAtomicRefrac() {
        this.MOLATOMS = this.mol.getAtomCount();
        this.aRefInc = new double[this.MOLATOMS][3];
        this.atomArray = this.mol.getAtomArray();
        this.ctab = this.mol.getCtab();
        this.btab = this.mol.getBondTable();
    }

    private double getAtomicRefracInc(int atom) {
        int pc = this.atomArray[atom].getAtno();
        this.actualAtom = atom;
        this.aRefInc[atom][0] = atom;
        double hInc = 0.0;
        double dInc = 0.0;
        this.aRefInc[atom][2] = 0.0;
        this.setFragmentId(atom);
        this.aRefInc[atom][1] = dInc = this.getIncrement(pc);
        if (pc == 1) {
            int nb = this.ctab[atom][0];
            int n = this.ctab[nb].length;
            int impH = this.atomArray[nb].getImplicitHcount();
            int hs = n + impH;
            pc = this.atomArray[nb].getAtno();
            this.aRefInc[atom][1] = hInc = this.getHidrogenIncrement(nb, hs, pc);
            if (this.ctab[atom].length > 1) {
                this.hValenceError = true;
            }
        }
        if (this.hCounter != 0) {
            this.hCounter -= this.atomArray[this.actualAtom].getExplicitHcount();
            hInc = (double)this.hCounter * this.getHidrogenIncrement(this.actualAtom, this.hybridState, pc);
            if (this.hCounter != 0) {
                this.aRefInc[atom][2] = hInc;
            }
        }
        return dInc + hInc;
    }

    private void setFragmentId(int atom) {
        int n = this.ctab[atom].length;
        this.xTripBond = 0;
        this.Ar = 0;
        this.arSingleBond = 0;
        this.arXCounter = 0;
        this.arRCounter = 0;
        this.dbCCounter = 0;
        this.xCounter = 0;
        this.rCounter = 0;
        this.hCounter = this.atomArray[atom].getImplicitHcount();
        this.hybridState = n + this.hCounter;
        for (int i = 0; i < n; ++i) {
            int nb = this.ctab[atom][i];
            this.setAtomTypeCounter(nb);
        }
        this.fragmentId = this.hCounter * 1 + this.rCounter * 6 + this.xCounter * 36 + this.dbCCounter * 216 + this.arRCounter * 1296 + this.arXCounter * 7776 + this.arSingleBond * 46656 + this.Ar * 50 + this.xTripBond * 150;
    }

    private double getIncrement(int keyAtom) {
        switch (keyAtom) {
            case 6: {
                switch (this.hybridState) {
                    case 4: {
                        switch (this.fragmentId) {
                            case 9: {
                                return 2.968;
                            }
                            case 4: {
                                return 2.968;
                            }
                            case 53: {
                                return 2.968;
                            }
                            case 14: {
                                return 2.9116;
                            }
                            case 19: {
                                return 2.8028;
                            }
                            case 24: {
                                return 2.6205;
                            }
                            case 68: {
                                return 2.6205;
                            }
                            case 39: {
                                return 3.015;
                            }
                            case 88: {
                                return 2.9244;
                            }
                            case 44: {
                                return 2.9244;
                            }
                            case 74: {
                                return 2.6329;
                            }
                            case 49: {
                                return 2.504;
                            }
                            case 123: {
                                return 2.377;
                            }
                            case 79: {
                                return 2.377;
                            }
                            case 109: {
                                return 2.559;
                            }
                            case 54: {
                                return 2.303;
                            }
                            case 84: {
                                return 2.3006;
                            }
                            case 114: {
                                return 2.9627;
                            }
                            case 144: {
                                return 2.3038;
                            }
                            case 58: {
                                return 2.9116;
                            }
                            case 158: {
                                return 2.9627;
                            }
                            case 63: {
                                return 2.8028;
                            }
                            case 107: {
                                return 2.8028;
                            }
                            case 93: {
                                return 2.504;
                            }
                            case 102: {
                                return 2.9116;
                            }
                            case 137: {
                                return 2.504;
                            }
                            case 151: {
                                return 2.8028;
                            }
                            case 200: {
                                return 2.6205;
                            }
                            case 142: {
                                return 2.504;
                            }
                            case 172: {
                                return 2.3006;
                            }
                            case 128: {
                                return 2.3006;
                            }
                            case 98: {
                                return 2.303;
                            }
                        }
                    }
                    case 3: {
                        switch (this.fragmentId) {
                            case 38: {
                                return 3.2001;
                            }
                            case 218: {
                                return 3.2001;
                            }
                            case 223: {
                                return 4.2654;
                            }
                            case 228: {
                                return 3.9392;
                            }
                            case 272: {
                                return 3.9392;
                            }
                            case 43: {
                                return 4.019;
                            }
                            case 238: {
                                return 3.9392;
                            }
                            case 48: {
                                return 3.9031;
                            }
                            case 73: {
                                return 3.6005;
                            }
                            case 253: {
                                return 3.6005;
                            }
                            case 258: {
                                return 4.487;
                            }
                            case 78: {
                                return 3.4986;
                            }
                            case 284: {
                                return 3.2001;
                            }
                            case 108: {
                                return 3.4997;
                            }
                            case 2593: {
                                return 3.4491;
                            }
                            case 3888: {
                                return 3.8821;
                            }
                            case 2598: {
                                return 3.8821;
                            }
                            case 2628: {
                                return 3.7593;
                            }
                            case 9073: {
                                return 2.5009;
                            }
                            case 9078: {
                                return 2.5;
                            }
                            case 10368: {
                                return 2.5;
                            }
                            case 9108: {
                                return 3.0627;
                            }
                            case 16848: {
                                return 3.0627;
                            }
                            case 15553: {
                                return 2.5009;
                            }
                            case 15558: {
                                return 2.5009;
                            }
                            case 15588: {
                                return 2.6632;
                            }
                            case 47953: {
                                return 3.4671;
                            }
                            case 47958: {
                                return 3.6842;
                            }
                            case 49248: {
                                return 3.6842;
                            }
                            case 47988: {
                                return 2.9372;
                            }
                            case 55728: {
                                return 2.6267;
                            }
                            case 94608: {
                                return 2.6267;
                            }
                            case 62208: {
                                return 2.6267;
                            }
                            case 54433: {
                                return 2.7784;
                            }
                            case 54438: {
                                return 2.6267;
                            }
                            case 54468: {
                                return 2.5;
                            }
                            case 87: {
                                return 4.77;
                            }
                            case 92: {
                                return 3.9964;
                            }
                            case 122: {
                                return 3.9964;
                            }
                            case 93313: {
                                return 2.5009;
                            }
                            case 48002: {
                                return 3.6842;
                            }
                            case 2642: {
                                return 3.8821;
                            }
                            case 267: {
                                return 4.2654;
                            }
                            case 136: {
                                return 3.9964;
                            }
                            case 9122: {
                                return 2.5;
                            }
                            case 302: {
                                return 4.487;
                            }
                        }
                    }
                    case 2: {
                        switch (this.fragmentId) {
                            case 7: {
                                return 3.4825;
                            }
                            case 151: {
                                return 3.4825;
                            }
                            case 12: {
                                return 4.2817;
                            }
                            case 156: {
                                return 3.4986;
                            }
                            case 432: {
                                return 4.2817;
                            }
                            case 72: {
                                return 3.4986;
                            }
                            case 186: {
                                return 3.9556;
                            }
                            case 48: {
                                return 3.9556;
                            }
                            case 200: {
                                return 3.4825;
                            }
                        }
                    }
                }
            }
            case 7: {
                switch (this.hybridState) {
                    case 4: {
                        switch (this.fragmentId) {
                            case 54: {
                                return 3.5;
                            }
                        }
                    }
                    case 3: {
                        if (this.isAlphaKeto(this.actualAtom)) {
                            switch (this.fragmentId) {
                                case 57: {
                                    return 4.2808;
                                }
                            }
                            return 2.5;
                        }
                        switch (this.fragmentId) {
                            case 8: {
                                return 2.6221;
                            }
                            case 13: {
                                return 2.5;
                            }
                            case 18: {
                                return 2.898;
                            }
                            case 48: {
                                return 2.5;
                            }
                            case 52: {
                                return 3.6841;
                            }
                            case 38: {
                                return 3.6841;
                            }
                            case 57: {
                                return 4.2808;
                            }
                            case 62: {
                                return 3.6189;
                            }
                            case 101: {
                                return 2.7956;
                            }
                            case 150: {
                                return 2.7956;
                            }
                            case 106: {
                                return 2.7956;
                            }
                            case 2593: {
                                return 2.7956;
                            }
                            case 2598: {
                                return 2.7956;
                            }
                            case 78: {
                                return 3.0009;
                            }
                            case 108: {
                                return 4.0184;
                            }
                            case 122: {
                                return 4.0184;
                            }
                            case 2628: {
                                if (this.ispyridineOxide(this.actualAtom)) {
                                    return 4.0184;
                                }
                                return 4.2063;
                            }
                            case 3888: {
                                return 4.2063;
                            }
                            case 258: {
                                return 4.7142;
                            }
                            case 9073: {
                                return 2.7956;
                            }
                            case 15553: {
                                return 2.7956;
                            }
                            case 87: {
                                return 4.2063;
                            }
                            case 9122: {
                                return 2.7956;
                            }
                        }
                    }
                    case 1: 
                    case 2: {
                        if (this.isAlphaKeto(this.actualAtom)) {
                            return 2.5;
                        }
                        switch (this.fragmentId) {
                            case 2592: {
                                return 4.2063;
                            }
                            case 9072: {
                                return 4.2063;
                            }
                            case 6: {
                                return 2.7;
                            }
                            case 12: {
                                return 2.7;
                            }
                            case 42: {
                                return 2.7;
                            }
                            case 86: {
                                return 4.7142;
                            }
                            case 72: {
                                return 4.7142;
                            }
                            case 252: {
                                return 2.7;
                            }
                            case 222: {
                                return 2.7;
                            }
                            case 47952: {
                                return 4.2063;
                            }
                            case 15552: {
                                return 4.2063;
                            }
                            case 54432: {
                                return 2.7;
                            }
                            case 266: {
                                return 4.7142;
                            }
                        }
                    }
                }
            }
            case 8: {
                switch (this.hybridState) {
                    case 2: {
                        switch (this.fragmentId) {
                            case 2: {
                                return 2.1;
                            }
                            case 7: {
                                this.isAlphaKeto(this.actualAtom);
                                if (this.alphaKeto) {
                                    return 1.4778;
                                }
                                return 1.7646;
                            }
                            case 37: {
                                return 1.7646;
                            }
                            case 51: {
                                return 1.7646;
                            }
                            case 12: {
                                if (this.isAlphaKeto(this.actualAtom)) {
                                    return 1.3502;
                                }
                                return 1.6191;
                            }
                            case 72: {
                                return 1.3502;
                            }
                            case 86: {
                                return 1.3502;
                            }
                            case 42: {
                                return 1.3502;
                            }
                            case 56: {
                                return 1.3502;
                            }
                            case 100: {
                                return 1.3502;
                            }
                            case 15552: {
                                return 1.3502;
                            }
                            case 2592: {
                                return 1.3502;
                            }
                            case 9072: {
                                return 1.3502;
                            }
                        }
                    }
                    case 1: {
                        switch (this.fragmentId) {
                            case 216: {
                                return 1.4429;
                            }
                            case 36: {
                                if (this.isNitroTypeOxigen(this.actualAtom)) {
                                    return 1.945;
                                }
                                return 1.4429;
                            }
                        }
                    }
                }
            }
            case 34: {
                switch (this.fragmentId) {
                    case 23: {
                        return 11.1366;
                    }
                }
                return 13.1149;
            }
            case 16: {
                switch (this.fragmentId) {
                    case 7: {
                        return 7.8916;
                    }
                    case 42: {
                        return 7.7935;
                    }
                    case 12: {
                        return 7.7935;
                    }
                    case 6: {
                        return 9.4338;
                    }
                    case 216: {
                        return 9.4338;
                    }
                    case 36: {
                        return 9.4338;
                    }
                    case 48: {
                        return 7.7223;
                    }
                    case 84: {
                        return 5.7558;
                    }
                    case 100: {
                        return 7.7935;
                    }
                    case 51: 
                    case 56: {
                        return 7.7935;
                    }
                    case 158: {
                        return 5.7558;
                    }
                    case 172: {
                        return 5.7558;
                    }
                    case 144: {
                        return 5.7558;
                    }
                    case 114: {
                        return 5.7558;
                    }
                    case 128: {
                        return 5.7558;
                    }
                    case 2592: {
                        return 5.7558;
                    }
                    case 9072: {
                        return 5.7558;
                    }
                    case 15552: {
                        return 5.7558;
                    }
                    case 92: {
                        return 7.7223;
                    }
                    case 122: {
                        return 7.7223;
                    }
                    case 136: {
                        return 7.7223;
                    }
                }
                return 5.7558;
            }
            case 15: {
                switch (this.fragmentId) {
                    case 54: {
                        return 5.5306;
                    }
                    case 144: {
                        return 5.5152;
                    }
                    case 114: {
                        return 5.2806;
                    }
                    case 108: {
                        return 6.836;
                    }
                    case 18: {
                        return 10.0101;
                    }
                }
                return 5.2;
            }
            case 9: 
            case 17: 
            case 35: 
            case 53: {
                return this.getHalogenIncrement(this.actualAtom);
            }
        }
        return 0.0;
    }

    private double getHalogenIncrement(int atom) {
        int pc = this.atomArray[atom].getAtno();
        int oxnumber = 0;
        try {
            int nb = this.ctab[atom][0];
            if (this.atomArray[this.ctab[atom][0]].getAtno() != 6) {
                switch (pc) {
                    case 9: {
                        return 1.5013;
                    }
                    case 17: {
                        return 6.1363;
                    }
                    case 35: {
                        return 8.7352;
                    }
                    case 53: {
                        return 13.3408;
                    }
                }
            }
            this.hybridState = this.ctab[nb].length + this.atomArray[nb].getImplicitHcount();
            oxnumber = this.getFormalOxidationNumber(nb, this.EN[1]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        switch (oxnumber) {
            case 0: {
                switch (pc) {
                    case 9: {
                        return 0.8725;
                    }
                    case 17: {
                        return 5.6156;
                    }
                    case 35: {
                        return 8.5991;
                    }
                    case 53: {
                        return 13.9462;
                    }
                }
            }
            case 1: {
                switch (this.hybridState) {
                    case 4: {
                        switch (pc) {
                            case 9: {
                                return 0.8725;
                            }
                            case 17: {
                                return 5.6156;
                            }
                            case 35: {
                                return 8.5991;
                            }
                            case 53: {
                                return 13.9462;
                            }
                        }
                    }
                    case 3: {
                        switch (pc) {
                            case 9: {
                                return 0.8001;
                            }
                            case 17: {
                                return 5.3885;
                            }
                            case 35: {
                                return 8.2065;
                            }
                            case 53: {
                                return 12.9918;
                            }
                        }
                    }
                    case 1: {
                        switch (pc) {
                            case 9: {
                                return 1.5013;
                            }
                            case 17: {
                                return 6.1363;
                            }
                            case 35: {
                                return 8.7352;
                            }
                            case 53: {
                                return 13.3408;
                            }
                        }
                    }
                }
            }
            case 2: {
                switch (this.hybridState) {
                    case 4: {
                        switch (pc) {
                            case 9: {
                                return 1.1837;
                            }
                            case 17: {
                                return 6.1022;
                            }
                            case 35: {
                                return 8.9188;
                            }
                            case 53: {
                                return 14.0792;
                            }
                        }
                    }
                    case 3: {
                        switch (pc) {
                            case 9: {
                                return 1.5013;
                            }
                            case 17: {
                                return 6.1363;
                            }
                            case 35: {
                                return 8.7352;
                            }
                            case 53: {
                                return 13.3408;
                            }
                        }
                    }
                }
            }
            case 3: {
                switch (this.hybridState) {
                    case 4: {
                        switch (pc) {
                            case 9: {
                                return 1.1573;
                            }
                            case 17: {
                                return 5.9921;
                            }
                            case 35: {
                                return 8.8006;
                            }
                            case 53: {
                                return 14.073;
                            }
                        }
                    }
                    case 3: {
                        switch (pc) {
                            case 9: {
                                return 1.5013;
                            }
                            case 17: {
                                return 6.1363;
                            }
                            case 35: {
                                return 8.7352;
                            }
                            case 53: {
                                return 13.3408;
                            }
                        }
                    }
                }
            }
            case 4: {
                switch (this.hybridState) {
                    case 2: 
                    case 3: {
                        switch (pc) {
                            case 9: {
                                return 1.5013;
                            }
                            case 17: {
                                return 6.1363;
                            }
                            case 35: {
                                return 8.7352;
                            }
                            case 53: {
                                return 13.3408;
                            }
                        }
                    }
                }
            }
        }
        return 0.0;
    }

    private double getHidrogenIncrement(int actualAtom, int hybridState, int keyAtom) {
        switch (keyAtom) {
            case 6: {
                if (this.isAlphaCarbon(actualAtom)) {
                    return 0.8188;
                }
                int oxnumber = this.getFormalOxidationNumber(actualAtom, this.EN[1]);
                switch (oxnumber) {
                    case 0: {
                        switch (hybridState) {
                            case 4: {
                                int xAtoms = this.getBetaXAtoms(actualAtom);
                                switch (xAtoms) {
                                    case 0: {
                                        return 0.8447;
                                    }
                                    case 1: {
                                        return 0.9217;
                                    }
                                    case 2: {
                                        return 0.9769;
                                    }
                                    case 3: {
                                        return 0.7701;
                                    }
                                }
                                return 0.7701;
                            }
                            case 3: {
                                return 0.8939;
                            }
                            case 2: {
                                return 0.8005;
                            }
                        }
                    }
                    case 1: {
                        switch (hybridState) {
                            case 4: {
                                return 0.8939;
                            }
                            case 3: {
                                return 0.8005;
                            }
                        }
                    }
                    case 2: {
                        switch (hybridState) {
                            case 4: {
                                return 0.8005;
                            }
                            case 3: {
                                return 0.832;
                            }
                        }
                    }
                    case 3: {
                        switch (hybridState) {
                            case 4: {
                                return 0.832;
                            }
                            case 3: {
                                return 0.832;
                            }
                            case 2: {
                                return 0.832;
                            }
                        }
                    }
                }
            }
        }
        return 0.8;
    }

    private int getBetaXAtoms(int atom) {
        int xAtom = 0;
        for (int i = 0; i < this.ctab[atom].length; ++i) {
            int nb = this.ctab[atom][i];
            for (int j = 0; j < this.ctab[nb].length; ++j) {
                int pc;
                int nnb = this.ctab[nb][j];
                if (nnb == atom || (pc = this.atomArray[nnb].getAtno()) <= 6) continue;
                ++xAtom;
            }
        }
        return xAtom;
    }

    private boolean isAlphaCarbon(int atom) {
        this.alphaKeto = false;
        for (int i = 0; i < this.ctab[atom].length; ++i) {
            int bondOrder;
            int nb = this.ctab[atom][i];
            int pc = this.atomArray[nb].getAtno();
            if (!(pc == 6 & (bondOrder = this.mol.getBond(this.btab.getBondIndex(atom, nb)).getType()) == 1)) continue;
            for (int j = 0; j < this.ctab[nb].length; ++j) {
                int nnb = this.ctab[nb][j];
                bondOrder = this.mol.getBond(this.btab.getBondIndex(nb, nnb)).getType();
                if (bondOrder <= 1 || this.isPyrroleN(nnb)) continue;
                this.alphaKeto = true;
                pc = this.atomArray[nnb].getAtno();
                if (pc <= 6) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPyrroleN(int atom) {
        boolean pn = false;
        if (this.isArA(atom)) {
            int pc = this.atomArray[atom].getAtno();
            if (pc == 7) {
                int implicitH = this.atomArray[atom].getImplicitHcount();
                double charge = this.atomArray[atom].getCharge();
                if (this.ctab[atom].length + implicitH == 2 && charge == 0.0) {
                    return false;
                }
                if (this.ctab[atom].length + implicitH == 3) {
                    return charge != 1.0;
                }
                if (this.ctab[atom].length + implicitH == 2 && charge == -1.0) {
                    return true;
                }
                if (this.ispyridineOxide(atom)) {
                    return false;
                }
            } else if (pc != 6) {
                return true;
            }
        }
        return false;
    }

    private boolean isArA(int atom) {
        return this.atomArray[atom].hasAromaticBond();
    }

    private boolean isAlphaKeto(int atom) {
        this.alphaKeto = false;
        for (int i = 0; i < this.ctab[atom].length; ++i) {
            int nb = this.ctab[atom][i];
            int pc = this.atomArray[nb].getAtno();
            int bondOrder = this.mol.getBond(this.btab.getBondIndex(atom, nb)).getType();
            if (bondOrder != 1) continue;
            for (int j = 0; j < this.ctab[nb].length; ++j) {
                int nnb = this.ctab[nb][j];
                pc = this.atomArray[nnb].getAtno();
                if (pc != 8 && pc != 16 || (bondOrder = this.mol.getBond(this.btab.getBondIndex(nb, nnb)).getType()) != 2) continue;
                this.alphaKeto = true;
                return true;
            }
        }
        return false;
    }

    private boolean isNitroTypeOxigen(int atom) {
        int nb = this.ctab[atom][0];
        int pc = this.atomArray[nb].getAtno();
        int oCount = 0;
        if (pc == 7) {
            for (int i = 0; i < this.ctab[nb].length; ++i) {
                int nnb = this.ctab[nb][i];
                int bondOrder = this.mol.getBond(this.btab.getBondIndex(nb, nnb)).getType();
                if (bondOrder <= 1 || (pc = this.atomArray[nnb].getAtno()) != 8) continue;
                ++oCount;
            }
            if (this.atomArray[nb].hasAromaticBond() ? oCount == 1 : oCount == 2) {
                return true;
            }
        }
        return false;
    }

    private int getFormalOxidationNumber(int atom, double en) {
        int oxsum = 0;
        int bondOrder = 0;
        for (int i = 0; i < this.ctab[atom].length; ++i) {
            int nb = this.ctab[atom][i];
            double elene = this.getEN(nb);
            boolean pyridineType = false;
            if (!(elene > en)) continue;
            bondOrder = this.mol.getBond(this.btab.getBondIndex(atom, nb)).getType();
            if (bondOrder == 4) {
                double pc = this.atomArray[nb].getAtno();
                if (pc == 7.0) {
                    int implicitH = this.atomArray[nb].getImplicitHcount();
                    if (this.ispyridineOxide(nb)) {
                        pyridineType = true;
                    }
                    if (this.ctab[nb].length + implicitH == 2 || pyridineType) {
                        oxsum += 2;
                        continue;
                    }
                    if (this.ctab[nb].length + implicitH != 3) continue;
                    ++oxsum;
                    continue;
                }
                if (pc == 7.0) continue;
                ++oxsum;
                continue;
            }
            if (bondOrder == 4) continue;
            oxsum += bondOrder;
        }
        if (oxsum > 4) {
            oxsum = 4;
        }
        return oxsum;
    }

    private boolean ispyridineOxide(int atom) {
        for (int i = 0; i < this.ctab[atom].length; ++i) {
            int nb;
            int bondOrder;
            int pc = this.atomArray[this.ctab[atom][i]].getAtno();
            if (pc != 8 || (bondOrder = this.mol.getBond(this.btab.getBondIndex(atom, nb = this.ctab[atom][i])).getType()) != 2) continue;
            return true;
        }
        return false;
    }

    private double getEN(int atom) {
        int pc = this.atomArray[atom].getAtno();
        switch (pc) {
            case 1: {
                return this.EN[0];
            }
            case 6: {
                return this.EN[1];
            }
            case 7: {
                return this.EN[2];
            }
            case 8: {
                return this.EN[3];
            }
            case 9: {
                return this.EN[4];
            }
            case 15: {
                return this.EN[10];
            }
            case 16: {
                return this.EN[8];
            }
            case 17: {
                return this.EN[5];
            }
            case 34: {
                return this.EN[9];
            }
            case 35: {
                return this.EN[6];
            }
            case 53: {
                return this.EN[7];
            }
        }
        return this.EN[1];
    }

    private boolean isCharged(int atom) {
        double charge = this.atomArray[atom].getCharge();
        return charge != 0.0;
    }

    private void setAtomTypeCounter(int atom) {
        int pc = this.atomArray[atom].getAtno();
        switch (pc) {
            case 1: {
                ++this.hCounter;
                break;
            }
            case 6: {
                int bondorder = this.mol.getBond(this.btab.getBondIndex(this.actualAtom, atom)).getType();
                if (bondorder == 4) {
                    ++this.arRCounter;
                    break;
                }
                if (bondorder == 2) {
                    ++this.dbCCounter;
                    break;
                }
                if (this.atomArray[atom].hasAromaticBond()) {
                    ++this.Ar;
                    break;
                }
                ++this.rCounter;
                break;
            }
            default: {
                int bondorder = this.mol.getBond(this.btab.getBondIndex(this.actualAtom, atom)).getType();
                if (bondorder == 4) {
                    int implicitH = this.atomArray[atom].getImplicitHcount();
                    if (this.ctab[atom].length + implicitH == 3) {
                        ++this.arSingleBond;
                        break;
                    }
                    if (this.ctab[atom].length + implicitH == 2) {
                        double charge = this.atomArray[atom].getCharge();
                        if (charge == 0.0) {
                            if (pc == 7) {
                                ++this.arXCounter;
                                break;
                            }
                            ++this.arSingleBond;
                            break;
                        }
                        if (charge != -1.0) break;
                        ++this.arSingleBond;
                        break;
                    }
                    ++this.arXCounter;
                    break;
                }
                if (bondorder == 3) {
                    ++this.xTripBond;
                    break;
                }
                ++this.xCounter;
                break;
            }
        }
    }

    public double getRefractivity() {
        return this.AtomicRefrac;
    }

    public double calcAtomicRefrac() {
        this.initAtomicRefrac();
        this.AtomicRefrac = 0.0;
        for (int i = 0; i < this.MOLATOMS; ++i) {
            this.AtomicRefrac += this.getAtomicRefracInc(i);
        }
        return this.AtomicRefrac;
    }

    public boolean getHValenceError() {
        return this.hValenceError;
    }
}

