/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

import chemaxon.formats.MolImporter;
import chemaxon.marvin.modules.SubstructureSearch;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.io.IOException;

public class TPSA {
    private double TPSA;
    private Molecule mol;
    private MolAtom[] atomArray;
    protected int[][] ctab;
    protected int[][] bHtab;
    private int MOLATOMS;
    private int actualAtom;
    private int hCounter;
    private int xCounter;
    private int dbCCounter;
    private int arXCounter;
    private int xTripBond;
    private int hybridState;
    private int fragmentId;
    private SubstructureSearch subs;
    boolean hValenceError;
    boolean excSulfur = true;
    boolean excPhosphorous = true;
    public boolean criticalError;
    int[] check;
    MolImporter mi;
    static final String[] NITROGEN = new String[]{"[N+](-*)(-*)(-*)-*", "[NH+](-*)(-*)-*", "[NH2+](-*)-*", "[NH3+]-*", "[N+](-*)(-*)=*", "[NH+](-*)=*", "[NH2+]=*", "[n+](:*)(:*):*", "[n+](-*)(:*):*", "[nH+](:*):*", "[N]1(-*)-*-*-1", "[NH]1-*-*-1", "[N](-*)(-*)-*", "[N](-*)(=*)=*", "[NH](-*)-*", "[NH2]-*", "[n](:*)(:*):*", "[nH](:*):*", "[n](-*)(:*):*", "[n](=*)(:*):*", "[N+](-*)#*", "[N](-*)=*", "[N]#*", "[N](=*)#*", "[NH]=*", "[n](:*):*"};
    static final String[] OXIGEN = new String[]{"[O]1-*-*-1", "[O](-*)-*", "[OH]-*", "[o](:*):*", "[O-]-*", "[O]=*"};
    static final String[] SULFUR = new String[]{"[S](-*)-*", "[S]=*", "[S](-*)(-*)=*", "[S](-*)(-*)(=*)=*", "[SH]-*", "[s](:*):*", "[s](=*)(:*):*"};
    static final String[] PHOSPHOROUS = new String[]{"[P](-*)(-*)-*", "[P](-*)=*", "[P](-*)(-*)(-*)=*", "[P](-*)(-*)=*"};
    static final double[] NINC = new double[]{0.0, 4.44, 16.61, 27.64, 3.01, 13.97, 25.59, 4.1, 3.88, 14.14, 3.01, 21.94, 3.24, 11.68, 12.03, 26.02, 4.41, 15.79, 4.93, 8.39, 4.36, 12.36, 23.79, 13.6, 23.85, 12.89};
    static final double[] OXINC = new double[]{12.53, 9.23, 20.23, 13.14, 23.06, 17.07};
    static final double[] SINC = new double[]{25.3, 32.09, 19.21, 8.38, 38.8, 28.24, 21.7};
    static final double[] PINC = new double[]{13.59, 34.14, 9.81, 23.47};

    public TPSA() {
    }

    public TPSA(Molecule m) {
        this.getTPSA(m);
    }

    public boolean getCriticalErrorFlag() {
        return this.criticalError;
    }

    public void excludeSulfur(boolean excS) {
        this.excSulfur = excS;
    }

    public void excludePhosphorus(boolean excP) {
        this.excPhosphorous = excP;
    }

    public void setMolecule(Molecule m) {
        this.mol = m;
        this.setCriticalErrorFlag();
        this.hValenceError = false;
    }

    private double calcPSA() {
        int n = this.mol.getAtomCount();
        this.check = new int[n];
        double tpsa = 0.0;
        this.mi = new MolImporter();
        this.subs = new SubstructureSearch();
        this.subs.setIgnoreQueryProperties(false);
        this.subs.setIgnoreCharge(false);
        this.subs.setIgnoreAtomType(false);
        this.subs.setIgnoreHybridization(false);
        this.subs.setIgnoreBondType(false);
        boolean Sul = false;
        boolean Ph = false;
        boolean Nit = false;
        boolean Ox = false;
        for (int i = 0; i < n; ++i) {
            MolAtom a = this.mol.getAtom(i);
            int pc = a.getAtno();
            int L = 0;
            int actIndx = 0;
            if (pc == 16 && !Sul) {
                L = SULFUR.length;
                Sul = true;
            } else if (pc == 15 && !Ph) {
                L = PHOSPHOROUS.length;
                Ph = true;
            } else if (pc == 7 && !Nit) {
                L = NITROGEN.length;
                Nit = true;
            } else if (pc == 8 && !Ox) {
                L = OXIGEN.length;
                Ox = true;
            }
            if (L == 0) continue;
            for (int j = 0; j < n; ++j) {
                this.check[j] = -1;
            }
            while (actIndx < L) {
                Molecule query = this.getQuery(pc, actIndx);
                this.subs.setMolecules(query, this.mol);
                int c = 0;
                if (this.subs.findFirst()) {
                    int k;
                    int[] y = this.subs.getResult();
                    for (k = 0; k < y.length; ++k) {
                        System.err.println(y[k] + "  ");
                    }
                    this.check[c] = y[0];
                    ++c;
                    while (this.subs.findNext()) {
                        y = this.subs.getResult();
                        for (k = 0; k < y.length; ++k) {
                            System.err.println(y[k] + "  ");
                        }
                        if (this.isAddedYet(y[0])) continue;
                        this.check[c] = y[0];
                        ++c;
                    }
                    tpsa += (double)c * this.getIncrement(pc, actIndx);
                }
                ++actIndx;
            }
        }
        return tpsa;
    }

    private boolean isAddedYet(int q) {
        for (int i = 0; i < this.MOLATOMS; ++i) {
            if (this.check[i] != q) continue;
            return true;
        }
        return false;
    }

    private double getIncrement(int pc, int indx) {
        if (pc == 16) {
            return SINC[indx];
        }
        if (pc == 15) {
            return PINC[indx];
        }
        if (pc == 8) {
            return OXINC[indx];
        }
        if (pc == 7) {
            return NINC[indx];
        }
        return 0.0;
    }

    private Molecule getQuery(int pc, int indx) {
        try {
            if (pc == 16) {
                Molecule query = MolImporter.importMol(SULFUR[indx], "smarts");
                return query;
            }
            if (pc == 15) {
                Molecule query = MolImporter.importMol(PHOSPHOROUS[indx], "smarts");
                return query;
            }
            if (pc == 7) {
                Molecule query = MolImporter.importMol(NITROGEN[indx], "smarts");
                return query;
            }
            if (pc == 8) {
                Molecule query = MolImporter.importMol(OXIGEN[indx], "smarts");
                return query;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public Molecule getMolecule() {
        return this.mol;
    }

    public double getTPSA(Molecule m) {
        this.mol = m;
        this.hValenceError = false;
        this.setCriticalErrorFlag();
        this.calcTPSA();
        return this.TPSA;
    }

    protected void setCriticalErrorFlag() {
        this.criticalError = false;
        int n = this.mol.getAtomCount();
        for (int i = 0; i < n; ++i) {
            MolAtom a = this.mol.getAtom(i);
            if (!a.hasValenceError()) continue;
            int vc = a.getValence();
            int pc = a.getAtno();
            if (pc == 1 && vc > 1) {
                this.criticalError = true;
                return;
            }
            if (pc <= 10 && vc > 4) {
                this.criticalError = true;
                return;
            }
            if (pc <= 10 || vc <= 8) continue;
            this.criticalError = true;
            return;
        }
    }

    private void initTPSA() {
        this.MOLATOMS = this.mol.getAtomCount();
        this.atomArray = this.mol.getAtomArray();
        this.ctab = this.mol.getCtab();
        this.bHtab = this.mol.createBHtab();
    }

    public void calcTPSA() {
        this.initTPSA();
        this.TPSA = 0.0;
        for (int i = 0; i < this.MOLATOMS; ++i) {
            this.TPSA += this.getTPSAIncrement(i);
        }
    }

    public double getTPSA() {
        return this.TPSA;
    }

    private double getTPSAIncrement(int atom) {
        int pc = this.atomArray[atom].getAtno();
        if (pc == 1 && this.ctab[atom].length > 1) {
            this.hValenceError = true;
        }
        this.actualAtom = atom;
        double dTPSA = 0.0;
        if (pc == 16 && this.excSulfur) {
            return 0.0;
        }
        if (pc == 15 && this.excPhosphorous) {
            return 0.0;
        }
        this.setFragmentId(atom);
        dTPSA = this.getIncrement(pc);
        return dTPSA;
    }

    private void setFragmentId(int atom) {
        int n = this.ctab[atom].length;
        this.xTripBond = 0;
        this.arXCounter = 0;
        this.dbCCounter = 0;
        this.xCounter = 0;
        this.hCounter = this.atomArray[atom].getImplicitHcount();
        this.hybridState = n + this.hCounter;
        for (int i = 0; i < n; ++i) {
            int nb = this.ctab[atom][i];
            this.setAtomTypeCounter(nb);
        }
        this.fragmentId = this.hCounter * 1 + this.xCounter * 36 + this.dbCCounter * 216 + this.arXCounter * 7776 + this.xTripBond * 150;
    }

    /*
     * Unable to fully structure code
     */
    private double getIncrement(int keyAtom) {
        bt = new int[4];
        switch (keyAtom) {
            case 7: {
                switch (this.hybridState) {
                    case 4: {
                        switch (this.fragmentId) {
                            case 144: {
                                return 0.0;
                            }
                            case 109: {
                                return 4.44;
                            }
                            case 74: {
                                return 16.61;
                            }
                            case 39: {
                                return 27.64;
                            }
                        }
                    }
                    case 3: {
                        if (!this.isCharged(this.actualAtom)) ** GOTO lbl31
                        switch (this.fragmentId) {
                            case 288: {
                                return 3.01;
                            }
                            case 253: {
                                return 13.97;
                            }
                            case 218: {
                                return 25.59;
                            }
                            case 23436: {
                                return 4.1;
                            }
                            case 15660: {
                                return 3.88;
                            }
                            case 15625: {
                                return 14.14;
                            }
                        }
                        ** GOTO lbl55
lbl31:
                        // 1 sources

                        if (!this.isThreeMemRing(this.actualAtom, 7)) ** GOTO lbl38
                        switch (this.fragmentId) {
                            case 108: {
                                return 3.01;
                            }
                            case 73: {
                                return 21.94;
                            }
                        }
                        ** GOTO lbl55
lbl38:
                        // 1 sources

                        switch (this.fragmentId) {
                            case 108: {
                                return 3.24;
                            }
                            case 468: {
                                return 11.68;
                            }
                            case 73: {
                                return 12.03;
                            }
                            case 38: {
                                return 26.02;
                            }
                            case 23436: {
                                return 4.41;
                            }
                            case 15625: {
                                return 15.79;
                            }
                            case 15660: {
                                return 4.93;
                            }
                            case 15840: {
                                return 8.39;
                            }
                        }
                    }
lbl55:
                    // 4 sources

                    case 1: 
                    case 2: {
                        if (this.isCharged(this.actualAtom)) {
                            switch (this.fragmentId) {
                                case 222: {
                                    return 4.36;
                                }
                            }
                        }
                        switch (this.fragmentId) {
                            case 252: {
                                return 12.36;
                            }
                            case 186: {
                                return 23.79;
                            }
                            case 402: {
                                return 13.6;
                            }
                            case 217: {
                                return 23.85;
                            }
                            case 15624: {
                                return 12.89;
                            }
                        }
                    }
                }
            }
            case 8: {
                switch (this.hybridState) {
                    case 2: {
                        if (this.isThreeMemRing(this.actualAtom, 8)) {
                            return 12.53;
                        }
                        switch (this.fragmentId) {
                            case 72: {
                                return 9.23;
                            }
                            case 37: {
                                return 20.23;
                            }
                            case 15624: {
                                return 13.14;
                            }
                        }
                    }
                    case 1: {
                        if (this.isCharged(this.actualAtom)) {
                            switch (this.fragmentId) {
                                case 36: {
                                    return 23.06;
                                }
                            }
                        }
                        switch (this.fragmentId) {
                            case 216: {
                                return 17.07;
                            }
                        }
                    }
                }
            }
            case 16: {
                switch (this.fragmentId) {
                    case 72: {
                        return 25.3;
                    }
                    case 216: {
                        return 32.09;
                    }
                    case 288: {
                        return 19.21;
                    }
                    case 504: {
                        return 8.38;
                    }
                    case 37: {
                        return 38.8;
                    }
                    case 15624: {
                        return 28.24;
                    }
                    case 15840: {
                        return 21.7;
                    }
                }
                bt = this.getDefaultType(this.actualAtom);
                if (bt[0] != 2) ** GOTO lbl116
                if (bt[1] == 0) {
                    return 25.3;
                }
                if (bt[1] == 1) {
                    return 19.21;
                }
                if (bt[1] == 2) {
                    return 8.38;
                }
                ** GOTO lbl121
lbl116:
                // 1 sources

                if (bt[3] == 2) {
                    if (bt[1] == 1) {
                        return 21.7;
                    }
                    if (bt[1] == 0) {
                        return 28.24;
                    }
                }
            }
lbl121:
            // 6 sources

            case 15: {
                switch (this.fragmentId) {
                    case 38: {
                        return 13.59;
                    }
                    case 108: {
                        return 13.59;
                    }
                    case 73: {
                        return 13.59;
                    }
                    case 3: {
                        return 13.59;
                    }
                    case 217: {
                        return 34.14;
                    }
                    case 252: {
                        return 34.14;
                    }
                    case 324: {
                        return 9.81;
                    }
                    case 219: {
                        return 9.81;
                    }
                    case 289: {
                        return 23.47;
                    }
                    case 254: {
                        return 23.47;
                    }
                }
                bt = this.getDefaultType(this.actualAtom);
                if (bt[0] == 3) {
                    if (bt[1] == 1) {
                        return 9.81;
                    }
                    return 13.59;
                }
                if (bt[0] == 2) {
                    if (bt[1] == 1) {
                        return 23.47;
                    }
                } else if (bt[0] == 1 && bt[1] == 1) {
                    return 34.14;
                }
                return 0.0;
            }
        }
        return 0.0;
    }

    private void setAtomTypeCounter(int atom) {
        int pc = this.atomArray[atom].getAtno();
        switch (pc) {
            case 1: {
                ++this.hCounter;
                break;
            }
            default: {
                int bondorder = this.mol.getBond(this.bHtab[this.actualAtom][atom]).getType();
                if (bondorder == 4) {
                    ++this.arXCounter;
                } else if (bondorder == 3) {
                    ++this.xTripBond;
                }
                if (bondorder == 2) {
                    ++this.dbCCounter;
                    break;
                }
                ++this.xCounter;
                break;
            }
        }
    }

    private int[] getDefaultType(int ai) {
        MolAtom a = this.mol.getAtom(ai);
        int bc = a.getBondCount();
        int[] bt = new int[4];
        int impHc = a.getImplicitHcount();
        for (int i = 0; i < bc; ++i) {
            MolBond b = a.getBond(i);
            int t = b.getType();
            if (t == 1) {
                bt[0] = bt[0] + 1;
                continue;
            }
            if (t == 2) {
                bt[1] = bt[1] + 1;
                continue;
            }
            if (t == 3) {
                bt[2] = bt[2] + 1;
                continue;
            }
            if (t != 4) continue;
            bt[3] = bt[3] + 1;
        }
        bt[0] = bt[0] + impHc;
        return bt;
    }

    private boolean isThreeMemRing(int atom, int pc) {
        if (pc == 8 & this.hCounter == 0) {
            int nb1 = this.ctab[atom][0];
            int nb2 = this.ctab[atom][1];
            if (this.bHtab[nb1][nb2] > 0) {
                return true;
            }
        } else if (pc == 7) {
            int nb2;
            int nb1;
            if (this.hCounter == 0) {
                int nb12 = this.ctab[atom][0];
                int nb22 = this.ctab[atom][1];
                int nb3 = this.ctab[atom][2];
                if (this.bHtab[nb12][nb22] > 0) {
                    return true;
                }
                if (this.bHtab[nb12][nb3] > 0) {
                    return true;
                }
                if (this.bHtab[nb22][nb3] > 0) {
                    return true;
                }
            } else if (this.hCounter == 1 && this.bHtab[nb1 = this.ctab[atom][0]][nb2 = this.ctab[atom][1]] > 0) {
                return true;
            }
        }
        return false;
    }

    private boolean isCharged(int atom) {
        double charge = this.atomArray[atom].getCharge();
        return charge != 0.0;
    }

    public boolean getHValenceError() {
        return this.hValenceError;
    }
}

