/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

import chemaxon.calculations.Aza;
import chemaxon.calculations.CanonicResonant;
import chemaxon.calculations.CanonicTautomer;
import chemaxon.calculations.Charge;
import chemaxon.calculations.CriticalErrorCalculation;
import chemaxon.calculations.Interaction;
import chemaxon.calculations.PolarGroups;
import chemaxon.calculations.RingAnalyzer;
import chemaxon.calculations.hydrogenize.Hydrogenize;
import chemaxon.calculations.pka.Ionizer;
import chemaxon.common.util.MProgressMonitor;
import chemaxon.core.calculations.DearomatizePlus;
import chemaxon.core.calculations.LonePairCounter;
import chemaxon.formats.MolExporter;
import chemaxon.marvin.io.formats.smiles.SmilesImport;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.sgroup.DataSgroup;
import java.io.IOException;
import java.util.StringTokenizer;

public class Tautomerization {
    boolean aromatizalj = true;
    private Molecule inputMol;
    public static final String SGROUP_PROPERTY_NAME = "BEC";
    public static final String ELECTRON_SEPARATOR = "e";
    public static final String DEUTERIUM_SEPARATOR = "D";
    public static final String TRICIUM_SEPARATOR = "T";
    private MProgressMonitor progressMonitor = null;
    Molecule mol;
    Molecule oMol;
    Molecule neutraloMol;
    MolAtom[] atomArray;
    MolAtom[] oAtoms;
    int[] atomIndexMap;
    Interaction HBDA;
    private Charge charge;
    private PolarGroups polarGroups;
    private boolean criticalError;
    private RingAnalyzer rings;
    private Ionizer ionizer;
    LonePairCounter LPc;
    DearomatizePlus DP;
    CanonicTautomer canT;
    CanonicTautomer canonicTautomer;
    CanonicResonant canonicResonant;
    int[][] cHtab;
    int[][] ocHtab;
    int[][] bHtab;
    int[] Acceptors;
    int[] Donors;
    int[] DonAcc;
    int dCount;
    int aCount;
    protected int[][] tAtoms;
    protected int[][] tPath;
    protected int[][] latentPath;
    int atomCount;
    int[] sumTautomer;
    int tautomerCount;
    int latentTauCount;
    int sphereSize;
    int[][] di;
    int[] delocAble;
    int[] sAtom;
    int[] aAtom;
    int[][] tCharge;
    int[][] tHCount;
    int[][] tExpHCount;
    int[][] tECount;
    int[][] tLPCount;
    int[][] tRCount;
    int[][] implicitRCount;
    int[][] initBonds;
    String[] tSmiles;
    int[] tExist;
    int[] initCharge;
    int[] initHCount;
    int[] hydrogenType;
    int[] initECount;
    int[] initLPCount;
    int[] initRCount;
    int[] gn;
    int[] nbCount;
    int[] protonC;
    double[] mass;
    int[] donorType;
    int[] acceptorType;
    int[] notSpontanDonor;
    int[] biasedDonor;
    int[] notSpontanAcceptor;
    int[][][] tCtab;
    int[][][] tBtab;
    int aSize;
    int actMultiplicity;
    double pH = Double.NaN;
    double calcStatus;
    final int EMPTY = -100;
    final int UNKNOWN = -1;
    final int KNOWN = 1;
    final int DELOCABLE = 1;
    final int DONOR = -1;
    final int ACCEPTOR = 1;
    final int SIMPLETAUTOMER = 1;
    final int COMBINEDTAUTOMER = 2;
    final int LATENTTAUTOMER = 3;
    int Tmax = 5000;
    boolean tauStop;
    boolean latentTauStop;
    boolean baseTautomer;
    boolean latentTautomer;
    boolean latentTCreation;
    boolean restrict;
    boolean OpenChine;
    boolean chargeFlag;
    boolean falseTautomer;
    boolean commonParentAtom;
    boolean DDorAACouple;
    boolean allowPosResonance;
    boolean radicalExist;
    boolean TauCreated;
    boolean itStep;
    boolean methylDonor;
    boolean postFilterStep;
    boolean resChgCalc;
    int ActDonorType;
    int ActAcceptorType;
    final int RADICAL = 1;
    final int BOND = 2;
    final int LP = 3;
    final int HOLE = 4;
    final int HOLELP = 5;
    final int RADLP = 6;
    final int RADRAD = 7;
    final int RADJUMP = 8;
    final int LP_RADJUMP = 9;
    final int MAXMULTIPLICITY = 6;
    boolean chargeResonance = true;
    boolean allowSymmetryFiltering = true;
    boolean getResStructures = false;
    boolean getMajorRestructures = true;
    boolean storeAtomIndex = false;
    boolean dominantTautomerization = false;
    int fixBondType;
    int crossAtom;
    int mainPath;
    int parentT1;
    int parentT2;
    int tautomerType;
    int tCount;
    int[] IslandIndex;
    boolean CanonicalParentConserved = true;
    boolean canTaur;
    boolean canReso;
    double[] tauRatio;
    int[][] tauND;
    double[] tauDist;
    int[] tauDistOrder;
    boolean majorTautomericFormAvailable;
    boolean pHTauDistAvailable;
    boolean dominantTauDistCalc = false;
    double tauMinValue = 1.0E-5;
    double pHLower = 0.0;
    double pHUpper = 14.0;
    double pHStepSize = 1.0;
    double[] pHPoints = null;
    int pHStepCount;
    double[][][] pHTauDistVal;
    Molecule[][] pHTauDistMol;
    int[][] pHTauDistInfo;
    int[] shortTauIndex;
    int sumMspCount;
    int sumTauRatioCount;
    int domTauCount;
    boolean molSymmetry;
    int[] atomSymInfo;
    int[] daSymInfo;
    int pL = 4;
    boolean applyPathLengthCriteria = true;
    final double mpKaTol = 17.0;
    int chgCount;
    protected boolean protectExpH = true;
    boolean protectAromacity = true;
    boolean oneCR4Allowed = false;
    boolean protectCharge = true;
    boolean excludeAntiAromaticity = true;
    boolean protectRadicalCount = true;
    boolean impHFlag = true;
    int AraOx;
    int actRInd;
    boolean tauError;
    boolean structError;
    int[] scIndx;
    double[] tauScore;
    boolean canonicParentProtected = true;
    boolean canonicType = false;
    int sMax = 200;
    int combMax = 200;
    int latMax = 200;
    boolean sTStop;
    boolean cTStop;
    boolean lTStop;
    int exclAra;
    int araCount;
    int[] exAra;
    int exclAli;
    int[] exAli;
    int[] heteroD;
    int[] heteroA;
    int[] araIsland;
    int[] protectedDB;
    int[] chiralAtoms;
    boolean tSearch;
    boolean insulatorAtom;
    int tauCoupleType;
    final int SIMPLE = 1;
    final int COMB = 2;
    final int LATENT = 3;
    int islandCount;
    boolean protectCisTransinfo = false;
    boolean excludeChiralCenters = false;
    boolean genericCalc;
    boolean excludeStrictChiralCenters = false;
    int[] lAra;
    int[] CAtIndx;
    int[] indxShift;
    int[][] tauCouples;
    int[] initExpHCount;
    int actAraCount;
    boolean ketenAllowed = true;
    boolean protectStableGroups = false;
    boolean protectEsterGroups = true;
    boolean protectAmideGroups = false;
    boolean protectSulfuracidGroups = false;
    boolean protectCOOH = false;
    boolean protectAraDiaza = false;
    boolean stdCanonic = false;
    boolean resonanceRecomended;
    boolean oMolNeutralized;
    boolean noResonant;
    boolean molAbsStereo;
    int expHCount;
    boolean partialNeutralization = false;
    boolean showWigglyBond = true;
    boolean protectKekuleForm = false;
    boolean ringChainTau = true;
    int tRingCount;
    int tRIndex;
    int actAtomIndx;
    int[][] ringTauInfo;
    int[][] ringTauCounter;
    int[] rsize;
    boolean ringTauStep = false;
    int actRingLpAtom;
    int actTindex;
    private int[] aza;
    int[] spl;
    boolean ratTau = false;
    boolean[] osetting;
    int opL;
    boolean allTau = true;

    public Molecule createGenericTautomer() {
        boolean pEster = this.protectEsterGroups;
        boolean pCisTrans = this.protectCisTransinfo;
        boolean pAromacity = this.protectAromacity;
        boolean pAntiAra = this.excludeAntiAromaticity;
        boolean pSChiralCent = this.excludeStrictChiralCenters;
        this.protectEsterGroups = false;
        this.protectCisTransinfo = false;
        this.protectAromacity = false;
        this.excludeAntiAromaticity = false;
        this.excludeStrictChiralCenters = false;
        this.genericCalc = true;
        this.initCalc();
        if (this.criticalError) {
            return this.mol;
        }
        this.setTauIslands();
        if (this.islandCount != 0) {
            this.createDataSgroups();
        } else {
            this.setExplicitHydrogens(this.oMol, -1);
            if (this.aromatizalj) {
                this.oMol.aromatize(2);
            }
        }
        this.genericCalc = false;
        this.protectEsterGroups = pEster;
        this.protectCisTransinfo = pCisTrans;
        this.protectAromacity = pAromacity;
        this.excludeAntiAromaticity = pAntiAra;
        this.excludeStrictChiralCenters = pSChiralCent;
        return this.oMol;
    }

    public void setPartialNeutralization(boolean pn) {
        this.partialNeutralization = pn;
    }

    private void dearomatize(Molecule m, Molecule k) {
        if (k != null && this.protectKekuleForm) {
            this.setKekuleBondPattern(m, k);
        }
        m.dearomatize();
    }

    public Molecule createCanonicTautomer() {
        Molecule m = this.mol.cloneMoleculeWithDocument();
        Molecule res = new Molecule();
        if (m.getFragCount() > 1) {
            MoleculeGraph[] frags = m.findFrags(Molecule.class);
            MoleculeGraph frag = frags[0];
            for (int i = 0; i < frags.length; ++i) {
                frag = frags[i];
                m = (Molecule)frag;
                Molecule r = this.generateCanonicTautomer(m);
                if (r == null) {
                    res.fuse(frags[i]);
                    continue;
                }
                res.fuse(r);
            }
        } else {
            Molecule r = this.generateCanonicTautomer(m);
            return r;
        }
        return res;
    }

    private Molecule generateCanonicTautomer(Molecule mm) {
        this.canTaur = true;
        this.setRatTauConditions(true);
        this.canonicTautomer = new CanonicTautomer();
        if (this.canonicParentProtected) {
            this.canonicTautomer.setMolecule(mm.cloneMoleculeWithDocument());
        } else {
            this.canonicTautomer.setMolecule(mm);
        }
        this.canonicTautomer.setCanonicType(this.canonicType);
        this.canonicTautomer.setTautomerPathLengthCriteria(this.pL);
        this.canonicTautomer.setWigglyBondVisibility(this.showWigglyBond);
        this.canonicTautomer.protectAmideGoups(this.protectAmideGroups);
        this.canonicTautomer.protectAraDiaza(this.protectAraDiaza);
        this.canonicTautomer.protectSulfurAcidGroups(this.protectSulfuracidGroups);
        this.canonicTautomer.protectCOOHGroups(this.protectCOOH);
        this.canonicTautomer.setRatTauFlag(this.ratTau);
        if (this.stdCanonic) {
            this.canonicTautomer.setKetenFormationAllowed(false);
        } else {
            this.canonicTautomer.setKetenFormationAllowed(this.ketenAllowed);
        }
        this.canonicTautomer.setStdCanonicFlag(this.stdCanonic);
        this.canonicTautomer.setParentOfCanonicalStructureConserved(this.canonicParentProtected);
        this.canonicTautomer.setPartialNeutralization(this.partialNeutralization);
        this.canonicTautomer.protectAromaticAtomCount(this.protectAromacity);
        this.canonicTautomer.protectAntiAromaticAtomCount(this.excludeAntiAromaticity);
        this.canonicTautomer.excludeChargedAtoms(this.protectCharge);
        this.canonicTautomer.protectCT(this.protectCisTransinfo);
        this.canonicTautomer.excludeStrictChiralCenter(this.excludeStrictChiralCenters);
        this.canonicTautomer.excludeChiralCenter(this.excludeChiralCenters);
        this.canonicTautomer.calcCanonicalTautomer();
        this.tauError = this.canonicTautomer.getCriticalErrorFlag();
        this.CAtIndx = this.canonicTautomer.getcatIndx();
        this.setRatTauConditions(false);
        return this.canonicTautomer.getCanonicalTautomer();
    }

    protected Molecule createCanonicResonant() {
        this.canonicResonant = new CanonicResonant();
        if (this.canonicParentProtected) {
            this.canonicResonant.setMolecule(this.mol.cloneMoleculeWithDocument());
        } else {
            this.canonicResonant.setMolecule(this.mol);
        }
        this.canonicResonant.setParentOfCanonicalStructureConserved(this.canonicParentProtected);
        this.canonicResonant.calcCanonicalResonant();
        this.tauError = this.canonicResonant.getCriticalErrorFlag();
        return this.canonicResonant.getCanonicResonant();
    }

    public Molecule createStandardTautomer() {
        int opL = this.pL;
        boolean sWb = this.showWigglyBond;
        this.showWigglyBond = true;
        boolean ka = this.ketenAllowed;
        this.pL = 4;
        this.ketenAllowed = false;
        this.protectAmideGroups = true;
        this.protectAraDiaza = true;
        this.protectSulfuracidGroups = true;
        this.protectCOOH = true;
        this.stdCanonic = true;
        Molecule st = this.createCanonicTautomer();
        this.pL = opL;
        this.showWigglyBond = sWb;
        this.protectAmideGroups = false;
        this.protectAraDiaza = false;
        this.protectSulfuracidGroups = false;
        this.protectCOOH = false;
        this.stdCanonic = false;
        this.ketenAllowed = ka;
        return st;
    }

    private void setStandardPathLength() {
        int i;
        this.spl = new int[this.dCount + this.aCount];
        for (i = 0; i < this.dCount; ++i) {
            int da = this.getDonAccAtom(i);
            this.spl[i] = this.pL;
            if (this.protonC[da] != 6 || !this.charge.isInRing()[da]) continue;
            this.spl[i] = 2;
        }
        for (i = this.dCount; i < this.spl.length; ++i) {
            this.spl[i] = this.pL;
        }
    }

    public boolean isRingChainTauotmerizationAllowed() {
        return this.ringChainTau;
    }

    public void setRingChainTautomerizationAllowed(boolean rct) {
        this.ringChainTau = rct;
    }

    public void setKetenFormationAllowed(boolean allowKF) {
        this.ketenAllowed = allowKF;
    }

    public void setRationalTautomerGeneration(boolean rt) {
        this.ratTau = rt;
    }

    public void setProtectStableGroups(boolean fixSG) {
        this.protectStableGroups = fixSG;
    }

    public void setProtectEsterGroups(boolean fixEG) {
        this.protectEsterGroups = fixEG;
    }

    public void setProtectAmideGroups(boolean fixAG) {
        this.protectAmideGroups = fixAG;
    }

    public void setProtectAraDiaza(boolean fixAD) {
        this.protectAraDiaza = fixAD;
    }

    public void setProtectSulfurAcidGroups(boolean fixSAG) {
        this.protectSulfuracidGroups = fixSAG;
    }

    public void setStdCanonicFlag(boolean stdCan) {
        this.stdCanonic = stdCan;
    }

    public void setProtectCOOHGroups(boolean fixCOOH) {
        this.protectCOOH = fixCOOH;
    }

    public void setProtectAllTetrahedralStereoCenters(boolean ecc) {
        this.excludeChiralCenters = ecc;
    }

    public void setProtectLabeledTetrahedralStereoCenters(boolean escc) {
        this.excludeStrictChiralCenters = escc;
    }

    public void setProtectDoubleBondStereo(boolean dct) {
        this.protectCisTransinfo = dct;
    }

    public void setParentOfCanonicalStructureConserved(boolean pcsc) {
        this.canonicParentProtected = pcsc;
    }

    public void setCanonicTautomerType(boolean Ctype) {
        this.canonicType = Ctype;
    }

    public void setTautomerPathLengthCriteria(int p) {
        this.pL = p;
    }

    public void setWigglyBondVisibility(boolean sWb) {
        this.showWigglyBond = sWb;
    }

    public boolean isParentOfCanonicalStructureConserved() {
        return this.CanonicalParentConserved;
    }

    public void setProgressMonitor(MProgressMonitor pmon) {
        this.progressMonitor = pmon;
    }

    public void setMolecule(Molecule m) {
        this.mol = m;
        if (this.inputMol == null) {
            this.inputMol = m.cloneMoleculeWithDocument();
        }
    }

    public static final boolean isFromPDB(Molecule molecule) {
        return "pdb".equalsIgnoreCase(molecule.getInputFormat());
    }

    public void setRowInputMolecule(Molecule m) {
        this.inputMol = m;
    }

    public int getTCount() {
        int a = 0;
        int rc = 0;
        if (this.ringChainTau) {
            rc = this.tRingCount;
        }
        if (this.dominantTautomerization && !Double.isNaN(this.pH) && this.pHTauDistAvailable) {
            a = -1;
        }
        if (this.tautomerCount >= 1) {
            if (this.tautomerCount > this.Tmax) {
                this.tautomerCount = this.Tmax;
                return this.Tmax + 1 + a + rc;
            }
            return this.tautomerCount + 1 + a + rc;
        }
        return 1 + rc;
    }

    public void setApplyPathLengthCriteria(boolean b) {
        this.applyPathLengthCriteria = b;
    }

    public void protectExplicitHydrogens(boolean protectH) {
        this.protectExpH = protectH;
    }

    public boolean getExplicitHFlag() {
        return this.protectExpH;
    }

    public void protectAromaticity(boolean pa) {
        this.protectAromacity = pa;
    }

    public void protectCharge(boolean pc) {
        this.protectCharge = pc;
    }

    protected void protectRadicalCount(boolean pr) {
        this.protectRadicalCount = pr;
    }

    public void excludeAntiAroma(boolean aa) {
        this.excludeAntiAromaticity = aa;
    }

    protected void setMaxAllowedTauTypeCount(int s, int c, int l) {
        this.sMax = s;
        this.combMax = c;
        this.latMax = l;
    }

    public void setSymmetryFiltering(boolean filtering) {
        this.allowSymmetryFiltering = filtering;
    }

    public void setResonantCalc(boolean resStruc) {
        this.getResStructures = resStruc;
    }

    protected void setResChargeCalc(boolean rchg) {
        this.resChgCalc = rchg;
    }

    public void setMajorResonantCalc(boolean majorResStruc) {
        this.getMajorRestructures = majorResStruc;
    }

    public void setTakeDominantTautomers(boolean dominantTau) {
        this.dominantTautomerization = dominantTau;
        this.ratTau = dominantTau;
    }

    public void setStoreAtomIndex(boolean sAimp) {
        this.storeAtomIndex = sAimp;
    }

    public int[] getAtomIndexMap() {
        return this.atomIndexMap;
    }

    public void setpH(double pH) {
        this.pH = pH;
    }

    public void setMaxSpeciesCount(int maxCount) {
        this.Tmax = maxCount - 1;
    }

    public boolean getCriticalErrorFlag() {
        if (this.HBDA != null) {
            return this.criticalError;
        }
        return this.tauError;
    }

    public void setCriticalErrorFlag(boolean cr) {
        this.criticalError = cr;
    }

    protected void setCanTaur(boolean cT) {
        this.canTaur = cT;
    }

    protected void setCanReso(boolean cR) {
        this.canReso = cR;
    }

    public Molecule getTMolecule(int tIndex) {
        if (this.getCriticalErrorFlag()) {
            return null;
        }
        if (this.ringChainTau) {
            this.actTindex = tIndex = this.calcParentTauIndex(tIndex);
        }
        if (this.dominantTautomerization && !Double.isNaN(this.pH)) {
            if (this.pHTauDistAvailable && this.tautomerCount > 0) {
                int shortInd = this.shortTauIndex[tIndex];
                return this.getpHTauMolecule(shortInd);
            }
        } else if (this.dominantTautomerization && this.majorTautomericFormAvailable && this.tautomerCount > 0) {
            int shortInd;
            tIndex = shortInd = this.shortTauIndex[tIndex];
        }
        if (this.tautomerCount == 0) {
            if (this.ringChainTau) {
                if (this.getRingTauFlag()) {
                    Molecule m = this.oMol.cloneMoleculeWithDocument();
                    this.createRingChainTautomers(m, -1);
                    if (this.protectExpH) {
                        this.setExplicitHydrogens(m, -1);
                    }
                    this.setWigglyBond(m);
                    return m;
                }
            } else {
                return this.inputMol;
            }
        }
        this.incProgressValue(25.0 / (double)this.tautomerCount);
        if (this.allowSymmetryFiltering) {
            if (tIndex == this.tautomerCount) {
                Molecule m = this.oMol.cloneMoleculeWithDocument();
                if (this.getRingTauFlag()) {
                    this.createRingChainTautomers(m, -1);
                }
                if (this.protectExpH) {
                    this.setExplicitHydrogens(m, -1);
                }
                this.setWigglyBond(m);
                return m;
            }
            Molecule m = this.createTMolecule(this.tExist[tIndex], true);
            return m;
        }
        if (tIndex == this.tautomerCount) {
            Molecule m = this.oMol.cloneMoleculeWithDocument();
            if (this.getRingTauFlag()) {
                this.createRingChainTautomers(m, -1);
            }
            if (this.protectExpH) {
                this.setExplicitHydrogens(m, -1);
            }
            return this.setWigglyBond(m);
        }
        return this.createTMolecule(tIndex, true);
    }

    private int getConvertedTauIndex(int tIndex) {
        if (this.dominantTautomerization && !Double.isNaN(this.pH)) {
            if (this.pHTauDistAvailable && this.tautomerCount > 0) {
                int shortInd = this.shortTauIndex[tIndex];
                return shortInd;
            }
        } else if (this.dominantTautomerization && this.majorTautomericFormAvailable && this.tautomerCount > 0) {
            int shortInd;
            tIndex = shortInd = this.shortTauIndex[tIndex];
        }
        if (this.allowSymmetryFiltering) {
            if (tIndex == this.tautomerCount) {
                return -1;
            }
            return this.tExist[tIndex];
        }
        if (tIndex == this.tautomerCount) {
            return -1;
        }
        return tIndex;
    }

    public void setChargeResonanceFlag(boolean chrFlag) {
        this.chargeResonance = chrFlag;
    }

    private void calcDonorAcceptorSites() {
        this.HBDA = new Interaction();
        this.HBDA.setMolecule(this.oMol);
        this.HBDA.setExcludeSulfur(false);
        this.HBDA.setAromatizationType(2);
        this.HBDA.calcTautomerAcceptorDonorCount();
        this.HBDA.setResonanceFlag(this.getResStructures);
        this.polarGroups = new PolarGroups(this.oMol);
        this.polarGroups.setGroups();
        this.charge = new Charge(this.oMol, this.polarGroups);
        this.charge.setAromatizationType(2);
        this.charge.initChargeCalc();
        this.rings = new RingAnalyzer(this.oMol, 2);
        this.criticalError = CriticalErrorCalculation.calculate(this.oMol);
        if (this.criticalError) {
            return;
        }
        this.Acceptors = this.HBDA.getTautomerAbleAcceptorAtoms();
        this.Donors = this.HBDA.getTautomerAbleDonorAtoms();
        this.dCount = this.Donors.length;
        this.aCount = this.Acceptors.length;
        this.atomCount = this.oMol.getAtomCount();
    }

    public int getImplicitizedAtomCount() {
        return this.atomCount;
    }

    private void printDonAcc() {
        int i;
        System.err.println("DONOR");
        for (i = 0; i < this.dCount; ++i) {
            System.err.println(this.Donors[i]);
        }
        System.err.println("ACCEPTOR");
        for (i = 0; i < this.aCount; ++i) {
            System.err.println(this.Acceptors[i]);
        }
    }

    private void setNeutralState() {
        this.resonanceRecomended = false;
        this.oMolNeutralized = false;
        for (int i = 0; i < this.atomCount; ++i) {
            MolAtom a = this.oMol.getAtom(i);
            int charge = a.getCharge();
            if (charge == 0) continue;
            int pc = a.getAtno();
            int bc = a.getBondCount();
            boolean bukta = false;
            for (int j = 0; j < bc; ++j) {
                MolBond actBond = a.getBond(j);
                MolAtom aa = actBond.getOtherAtom(a);
                if (aa.getCharge() == 0) continue;
                bukta = true;
                this.resonanceRecomended = true;
            }
            if (bukta) continue;
            if (pc == 8 || pc == 7 || pc == 16 || pc == 15 || pc == 6 && charge == -1) {
                int implicitHCount = a.getImplicitHcount();
                if (charge < 0) {
                    int absChg = -1 * charge;
                    a.setImplicitHcount(implicitHCount + absChg);
                    a.setCharge(0);
                    this.oMolNeutralized = true;
                    continue;
                }
                if (implicitHCount > 0) {
                    a.setImplicitHcount(implicitHCount - charge);
                    a.setCharge(0);
                    this.oMolNeutralized = true;
                    continue;
                }
                this.resonanceRecomended = true;
                continue;
            }
            this.resonanceRecomended = true;
        }
    }

    protected Molecule getNeutraloMol() {
        return this.neutraloMol;
    }

    private void setCommonForm() {
        if (this.dominantTauDistCalc || this.canTaur) {
            CanonicResonant cr = new CanonicResonant();
            cr.setMolecule(this.oMol);
            cr.setParentOfCanonicalStructureConserved(true);
            if (this.canTaur) {
                cr.setWigglyBondVisibility(false);
            }
            cr.protectSulfurAcidGroups(this.protectSulfuracidGroups);
            cr.protectAmideGoups(this.protectAmideGroups);
            cr.protectAraDiaza(this.protectAraDiaza);
            cr.protectCOOHGroups(this.protectCOOH);
            cr.setCalcAbleType(this.canTaur || this.dominantTauDistCalc);
            cr.calcCanonicalResonant();
            this.oMol = cr.getCanonicResonant();
            this.noResonant = cr.isThesame();
            if (this.dominantTauDistCalc || this.partialNeutralization) {
                this.atomCount = this.oMol.getAtomCount();
                this.setNeutralState();
            }
            this.neutraloMol = this.oMol;
            this.oMol.aromatize(2);
        }
    }

    private void setKekuleBondPattern(Molecule Am, Molecule Km) {
        for (int i = 0; i < Am.getAtomCount(); ++i) {
            if (!this.isArA(i)) continue;
            MolAtom a = Am.getAtom(i);
            MolAtom ka = Km.getAtom(i);
            for (int j = 0; j < a.getBondCount(); ++j) {
                MolBond AactBond = a.getBond(j);
                if (AactBond.getType() != 4) continue;
                MolAtom aa = AactBond.getOtherAtom(a);
                int ai = Am.indexOf(aa);
                boolean find = false;
                for (int k = 0; !find && k < ka.getBondCount(); ++k) {
                    MolBond KactBond = ka.getBond(k);
                    aa = KactBond.getOtherAtom(ka);
                    int ki = Km.indexOf(aa);
                    if (ki != ai) continue;
                    int bt = KactBond.getType();
                    AactBond.setType(bt);
                    find = true;
                }
            }
        }
    }

    private void setRatTauConditions(boolean init) {
        if (this.getResStructures || this.dominantTautomerization || this.canTaur || this.canReso || this.genericCalc) {
            this.allTau = false;
        } else {
            this.allTau = true;
            this.ratTau = false;
        }
        if (!this.ratTau) {
            return;
        }
        if (init) {
            this.osetting = new boolean[11];
            this.opL = this.pL;
            this.osetting[0] = this.showWigglyBond;
            this.osetting[1] = this.ketenAllowed;
            this.osetting[2] = this.protectAmideGroups;
            this.osetting[3] = this.protectAraDiaza;
            this.osetting[4] = this.protectSulfuracidGroups;
            this.osetting[5] = this.protectCOOH;
            this.osetting[6] = this.protectAromacity;
            this.osetting[7] = this.protectCharge;
            this.osetting[8] = this.excludeAntiAromaticity;
            this.osetting[9] = this.protectEsterGroups;
            this.osetting[10] = this.stdCanonic;
            this.pL = 4;
            this.showWigglyBond = true;
            this.ketenAllowed = false;
            this.protectAmideGroups = true;
            this.protectAraDiaza = true;
            this.protectSulfuracidGroups = true;
            this.protectCOOH = true;
            this.protectAromacity = true;
            this.protectCharge = true;
            this.excludeAntiAromaticity = true;
            this.protectEsterGroups = true;
            this.stdCanonic = true;
        } else {
            this.pL = this.opL;
            this.showWigglyBond = this.osetting[0];
            this.ketenAllowed = this.osetting[1];
            this.protectAmideGroups = this.osetting[2];
            this.protectAraDiaza = this.osetting[3];
            this.protectSulfuracidGroups = this.osetting[4];
            this.protectCOOH = this.osetting[5];
            this.protectAromacity = this.osetting[6];
            this.protectCharge = this.osetting[7];
            this.excludeAntiAromaticity = this.osetting[8];
            this.protectEsterGroups = this.osetting[9];
            this.stdCanonic = this.osetting[10];
        }
    }

    private void initCalc() {
        if (this.getResStructures || this.dominantTautomerization || this.canTaur || this.canReso || this.genericCalc) {
            this.ringChainTau = false;
        }
        this.oMol = this.mol.cloneMoleculeWithDocument();
        int ac = this.oMol.getAtomCount();
        this.expHCount = this.oMol.getExplicitHcount();
        if (ac == this.expHCount) {
            this.expHCount = 0;
        }
        boolean imp = false;
        int[] eH = new int[this.expHCount];
        if (this.expHCount != 0) {
            int q = 0;
            for (int h = 0; h < ac; ++h) {
                MolAtom a = this.oMol.getAtom(h);
                int pc = a.getAtno();
                if (pc != 1) continue;
                eH[q] = h;
                ++q;
                if (a.getCharge() != 1 && a.getCharge() != -1 && a.getRadical() != 1 && a.getExplicitHcount() == 0) continue;
                --this.expHCount;
            }
            this.setIndexShift(eH);
        }
        this.protectExpH = this.expHCount != 0 && this.impHFlag;
        if (!Double.isNaN(this.pH)) {
            this.implicitize(this.oMol);
            imp = true;
        }
        this.majorTautomericFormAvailable = false;
        this.pHTauDistAvailable = false;
        this.molSymmetry = false;
        ac = 0;
        int impH = 0;
        if (this.storeAtomIndex) {
            this.oAtoms = this.oMol.getAtomArray();
            this.ocHtab = this.oMol.createCHtab();
            ac = this.mol.getAtomCount();
            impH = this.mol.getImplicitHcount();
        }
        if (!imp && this.expHCount != 0) {
            if (this.getResStructures) {
                if (this.impHFlag) {
                    this.implicitize(this.oMol);
                }
            } else {
                this.implicitize(this.oMol);
            }
        }
        this.setCommonForm();
        if (this.storeAtomIndex) {
            int nnb;
            int k;
            boolean find;
            int newai;
            int nb;
            int i;
            int i2;
            this.storeAtomIndex = false;
            this.cHtab = this.oMol.createCHtab();
            this.atomIndexMap = new int[ac + impH];
            boolean[] used = new boolean[ac + impH];
            for (i2 = 0; i2 < ac + impH; ++i2) {
                this.atomIndexMap[i2] = -2;
            }
            for (i2 = 0; i2 < ac + impH; ++i2) {
                used[i2] = false;
            }
            int acc = this.oMol.getAtomCount();
            for (int i3 = 0; i3 < this.oAtoms.length; ++i3) {
                int newIndex;
                this.atomIndexMap[i3] = newIndex = this.oMol.indexOf(this.oAtoms[i3]);
            }
            for (i = 0; i < this.oAtoms.length; ++i) {
                int newIndex = this.oMol.indexOf(this.oAtoms[i]);
                if (newIndex != -1) continue;
                nb = this.ocHtab[i][0];
                newai = this.atomIndexMap[nb];
                find = false;
                for (k = 0; k < this.cHtab[newai].length && !find; ++k) {
                    nnb = this.cHtab[newai][k];
                    if (nnb < acc || used[nnb]) continue;
                    this.atomIndexMap[i] = nnb;
                    used[nnb] = true;
                    find = true;
                }
            }
            for (i = 0; i < ac + impH; ++i) {
                if (this.atomIndexMap[i] != -2) continue;
                nb = this.ocHtab[i][0];
                newai = this.atomIndexMap[nb];
                find = false;
                for (k = 0; k < this.cHtab[newai].length && !find; ++k) {
                    nnb = this.cHtab[newai][k];
                    if (nnb < acc || used[nnb]) continue;
                    this.atomIndexMap[i] = nnb;
                    used[nnb] = true;
                    find = true;
                }
            }
        }
        this.calcDonorAcceptorSites();
        if (this.criticalError) {
            return;
        }
        this.setArAtoms();
        this.sTStop = false;
        this.cTStop = false;
        this.lTStop = false;
        this.tauStop = false;
        this.latentTauStop = false;
        this.postFilterStep = false;
        if (this.getResStructures) {
            this.setTakeDominantTautomers(false);
        }
        if (this.araCount != 0) {
            this.dearomatize(this.oMol, this.inputMol);
        }
        this.setBasicInfo();
        this.setProtonCount();
        this.setMassNumber();
        this.setRCount();
        this.setInitHCount();
        this.setNbCount();
        this.setInitCharge();
        this.setGroupNumber();
        if (this.radicalExist) {
            this.extendDonAccCount();
        }
        if (this.getResStructures) {
            this.extendLPDonors();
        }
        if (!this.getResStructures && this.araCount != 0) {
            this.addHyperConjugateCarbon();
        }
        if (this.getResStructures) {
            this.reduceHDonors();
        }
        this.setDelocAbleAtoms();
        this.setInitECount();
        this.setInitBonds();
        this.extendAccCount();
        this.setChargeFlag();
        if (this.chargeFlag) {
            this.excludeDualAccDonAtoms();
        }
        this.extendHeteroAcceptors();
        if (!this.chargeFlag && !this.radicalExist) {
            this.reduceDonAccCount();
        } else if (this.canTaur) {
            this.reduceDonAccCount();
        }
        if (!this.getResStructures) {
            if (this.protectStableGroups) {
                this.fixStableGroupsWithoutpKa();
            } else if (this.protectEsterGroups || this.ratTau) {
                this.fixEsterGroupsWithoutpKa();
            }
        }
        this.IslandIndex = new int[this.oMol.getAtomCount()];
        this.islandCount = 0;
        if (!this.getResStructures) {
            this.setDonAccIslands();
        }
        if (this.protectAromacity) {
            this.excludeCarbonAraAceptors();
        }
        if (this.dominantTautomerization) {
            this.setDominanceConditions();
            this.excludeNonSpontanDonAcc();
        }
        if (this.canTaur && !this.dominantTautomerization) {
            this.resetArrays();
        } else if (this.canTaur) {
            this.resetArrays();
        }
        this.excludeRNO();
        this.setDonAccArray();
        this.addCTinfo();
        this.setCAtIndx();
        this.setInitHDTCount(this.expHCount);
        if (this.canTaur || this.dominantTautomerization) {
            this.oneCR4Allowed = false;
        }
        this.setStandardPathLength();
    }

    private void setCAtIndx() {
        int ac = this.oMol.getAtomCount();
        this.CAtIndx = new int[ac];
        for (int i = 0; i < ac; ++i) {
            this.CAtIndx[i] = i;
        }
    }

    private void setBasicInfo() {
        this.setLPCount();
        this.cHtab = this.oMol.createCHtab();
        this.bHtab = this.oMol.createBHtab();
        this.atomArray = this.oMol.getAtomArray();
        this.sAtom = new int[this.atomCount];
    }

    private void setIndexShift(int[] eH) {
        int ac = this.oMol.getAtomCount();
        this.indxShift = new int[ac - this.expHCount];
        int k = 0;
        for (int i = 0; i < ac; ++i) {
            MolAtom a = this.oMol.getAtom(i);
            if (a.getAtno() == 1) continue;
            int shift = 0;
            for (int j = 0; j < this.expHCount; ++j) {
                if (eH[j] >= i) continue;
                ++shift;
            }
            this.indxShift[k] = -shift;
            ++k;
        }
    }

    protected void setImplicitizeFlag(boolean impHf) {
        this.impHFlag = impHf;
    }

    private void implicitize(Molecule m) {
        Hydrogenize.removeHAtoms(m, 2047);
    }

    private void resetArrays() {
        this.setLPCount();
        this.cHtab = this.oMol.createCHtab();
        this.bHtab = this.oMol.createBHtab();
        this.atomArray = this.oMol.getAtomArray();
        this.setInitHCount();
        this.setNbCount();
        this.setInitCharge();
        this.setDelocAbleAtoms();
        this.setInitECount();
        this.setInitBonds();
    }

    private void setDominanceConditions() {
        int i;
        Molecule ooMol = this.oMol.cloneMoleculeWithDocument();
        int atomCount = ooMol.getAtomCount();
        this.notSpontanDonor = new int[atomCount];
        this.biasedDonor = new int[atomCount];
        this.notSpontanAcceptor = new int[atomCount];
        this.ionizer = new Ionizer();
        this.ionizer.setpKaPrefixType(1);
        ooMol.dearomatize();
        ooMol.aromatize(1);
        this.ionizer.setMolecule(ooMol);
        this.ionizer.setLargeModelFlag(true);
        this.ionizer.setTautomerCalculationFlag(true);
        this.ionizer.micropKaCalc = true;
        this.ionizer.calculatepKa(0.0);
        this.ionizer.setLargeModelFlag(false);
        this.ionizer.setTautomerCalculationFlag(false);
        this.charge.setCriticalErrorFlag(this.ionizer.getCriticalErrorFlag());
        this.criticalError = this.ionizer.getCriticalErrorFlag();
        if (this.criticalError) {
            return;
        }
        for (i = 0; i < atomCount; ++i) {
            if (this.isDonor(i) || this.isAcceptor(i)) {
                int[] pkaBasicType = this.ionizer.getBasicPKaType(i);
                int type = this.polarGroups.carboxy[i];
                int prop = this.polarGroups.groupProperty[i];
                int gType = this.polarGroups.groupType[i];
                double apKa = this.ionizer.getpKa(i, -1);
                int bType = pkaBasicType[0];
                int sbType = pkaBasicType[1];
                int semiAraType = pkaBasicType[7];
                if (type != 1600) {
                    if (type == 1800) {
                        this.notSpontanAcceptor[i] = -1;
                        this.notSpontanDonor[i] = -1;
                    } else if (type == 800 || gType == 850) {
                        this.notSpontanAcceptor[i] = -1;
                        this.notSpontanDonor[i] = -1;
                    } else if (type == 200 && prop == 409 && gType == 13) {
                        this.notSpontanAcceptor[i] = -1;
                        this.notSpontanDonor[i] = -1;
                    } else if (bType == 1000) {
                        if (sbType == 20 || sbType == 25) {
                            if (semiAraType == -1) {
                                if (this.getAza(i) != -1) {
                                    this.notSpontanAcceptor[i] = -1;
                                    this.notSpontanDonor[i] = -1;
                                } else if (!(this.rings.isInRing()[i] && apKa < 25.0 || apKa < 22.0)) {
                                    this.notSpontanAcceptor[i] = -1;
                                    this.notSpontanDonor[i] = -1;
                                }
                            } else if (!(apKa < 25.0)) {
                                this.notSpontanAcceptor[i] = -1;
                                this.notSpontanDonor[i] = -1;
                            }
                        }
                    } else if (Double.isNaN(apKa)) {
                        if (this.protonC[i] == 6) {
                            if (this.cHtab[i].length == 4) {
                                this.biasedDonor[i] = 1;
                            } else if (this.initRCount[i] == 0) {
                                if (this.isCX(type)) {
                                    this.notSpontanAcceptor[i] = -1;
                                }
                                this.notSpontanDonor[i] = -1;
                            }
                        } else {
                            this.notSpontanDonor[i] = -1;
                        }
                    } else if (apKa > 17.0) {
                        this.notSpontanDonor[i] = -1;
                    } else if (type == 300) {
                        if (prop != 600) {
                            if (prop != 800) {
                                this.notSpontanDonor[i] = -1;
                            } else if (gType == 870) {
                                // empty if block
                            }
                        }
                    } else if ((type == 200 || type == 800 || type == 500 || type == 600 || type == 700) && !this.isArA(i) && apKa > 7.0) {
                        if (this.rings.isInRing()[i]) {
                            int ri = this.rings.getLargestRingIndex(i);
                            int ra = this.charge.isSemiAromaticRing(ri);
                            if (ra != 200 && ra != 100 && !(apKa < 10.0)) {
                                this.notSpontanDonor[i] = -1;
                            }
                        } else if (!(apKa < 10.0)) {
                            if (type == 200 || type == 500) {
                                this.notSpontanAcceptor[i] = -1;
                                this.notSpontanDonor[i] = -1;
                            } else {
                                this.notSpontanDonor[i] = -1;
                            }
                        }
                    }
                }
                if (type == 400) {
                    this.notSpontanAcceptor[i] = -1;
                    continue;
                }
                if (type == 2) {
                    int s = this.getNb(i);
                    if (s != -1) {
                        if (this.ionizer.getpKa(s, -1) < 7.0) continue;
                        this.notSpontanAcceptor[i] = -1;
                        continue;
                    }
                    this.notSpontanAcceptor[i] = -1;
                    continue;
                }
                if (type != 300 || gType == 870) continue;
                this.notSpontanAcceptor[i] = -1;
                continue;
            }
            this.notSpontanDonor[i] = -1;
            this.notSpontanAcceptor[i] = -1;
            this.biasedDonor[i] = -1;
        }
        for (i = 0; i < atomCount; ++i) {
            if (this.notSpontanAcceptor[i] == -1 || this.protonC[i] == 6) continue;
            this.notSpontanDonor[i] = 0;
        }
    }

    private boolean isCX(int CarbonType) {
        if (CarbonType == 1600) {
            return true;
        }
        if (CarbonType == 1500) {
            return true;
        }
        return CarbonType == 1;
    }

    private int getNb(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int L;
            int nb = this.cHtab[ai][i];
            if (nb >= this.atomCount || (L = this.cHtab[nb].length) != 3) continue;
            for (int j = 0; j < this.cHtab[nb].length; ++j) {
                int nnb = this.cHtab[nb][j];
                if (nnb >= this.atomCount || this.polarGroups.carboxy[nnb] == 2) continue;
                return nnb;
            }
        }
        return -1;
    }

    private boolean isDiazoLike(int c) {
        for (int i = 0; i < this.cHtab[c].length; ++i) {
            int nb = this.cHtab[c][i];
            if (nb >= this.atomCount || this.polarGroups.groupProperty[nb] != 3650) continue;
            return true;
        }
        return false;
    }

    private void excludeCarbonAraAceptors() {
        int i;
        int[] ta = new int[this.aCount];
        int j = 0;
        int[] used = new int[this.oMol.getAtomCount()];
        for (i = 0; i < this.aCount; ++i) {
            int a = this.Acceptors[i];
            if (this.isArA(a)) {
                if (used[a] == 1) continue;
                int ri = this.charge.getLargestRing(a);
                if (this.isCarbonAraRing(ri)) {
                    for (int k = 0; k < this.charge.aAtoms[ri].length; ++k) {
                        if (this.isDiazoLike(this.charge.aAtoms[ri][k])) {
                            ta[j] = this.charge.aAtoms[ri][k];
                            ++j;
                        }
                        used[this.charge.aAtoms[ri][k]] = 1;
                    }
                    continue;
                }
                ta[j] = a;
                ++j;
                continue;
            }
            ta[j] = a;
            ++j;
        }
        this.aCount = j;
        this.Acceptors = new int[this.aCount];
        for (i = 0; i < this.aCount; ++i) {
            this.Acceptors[i] = ta[i];
        }
    }

    private void reduceDonAccCount() {
        int i;
        int a;
        int i2;
        int[] td = new int[this.dCount];
        int j = 0;
        for (i2 = 0; i2 < this.dCount; ++i2) {
            a = this.Donors[i2];
            if (this.isArA(a)) {
                if (this.protonC[a] == 7) {
                    if (this.isNMePyrroleType(a)) continue;
                    td[j] = a;
                    ++j;
                    continue;
                }
                if (this.protonC[a] != 6) {
                    td[j] = a;
                    ++j;
                    continue;
                }
                if (this.initCharge[a] == 0) continue;
                td[j] = a;
                ++j;
                continue;
            }
            td[j] = a;
            ++j;
        }
        this.dCount = j;
        this.Donors = new int[this.dCount];
        for (i2 = 0; i2 < this.dCount; ++i2) {
            this.Donors[i2] = td[i2];
        }
        int[] ta = new int[this.aCount];
        j = 0;
        for (i = 0; i < this.aCount; ++i) {
            a = this.Acceptors[i];
            if (this.isArA(a)) {
                if (this.protonC[a] == 7) {
                    if (this.isNMePyrroleType(a)) continue;
                    ta[j] = a;
                    ++j;
                    continue;
                }
                if (this.protonC[a] != 6) {
                    ta[j] = a;
                    ++j;
                    continue;
                }
                if (this.initCharge[a] == 0) continue;
                ta[j] = a;
                ++j;
                continue;
            }
            ta[j] = a;
            ++j;
        }
        this.aCount = j;
        this.Acceptors = new int[this.aCount];
        for (i = 0; i < this.aCount; ++i) {
            this.Acceptors[i] = ta[i];
        }
    }

    private boolean isCarbonAraRing(int ri) {
        for (int i = 0; i < this.charge.aAtoms[ri].length; ++i) {
            int ra = this.charge.aAtoms[ri][i];
            if (this.charge.getSymbol(ra).equals("C")) continue;
            return false;
        }
        return true;
    }

    private boolean isNMePyrroleType(int ai) {
        return this.initHCount[ai] == 0 && this.cHtab[ai].length == 3 && this.initCharge[ai] == 0;
    }

    private void setGroupNumber() {
        this.gn = new int[139];
        this.gn[1] = 1;
        this.gn[3] = 1;
        this.gn[11] = 1;
        this.gn[19] = 1;
        this.gn[37] = 1;
        this.gn[55] = 1;
        this.gn[87] = 1;
        this.gn[4] = 2;
        this.gn[12] = 2;
        this.gn[20] = 2;
        this.gn[38] = 2;
        this.gn[56] = 2;
        this.gn[88] = 2;
        this.gn[5] = 3;
        this.gn[6] = 4;
        this.gn[14] = 4;
        this.gn[7] = 5;
        this.gn[15] = 5;
        this.gn[33] = 5;
        this.gn[8] = 6;
        this.gn[16] = 6;
        this.gn[34] = 6;
        this.gn[52] = 6;
        this.gn[9] = 7;
        this.gn[17] = 7;
        this.gn[35] = 7;
        this.gn[53] = 7;
        this.gn[85] = 7;
        this.gn[2] = 8;
        this.gn[10] = 8;
        this.gn[18] = 8;
        this.gn[36] = 8;
        this.gn[54] = 8;
        this.gn[86] = 8;
    }

    protected int getGroupNumber(int protonCount) {
        return this.gn[protonCount];
    }

    private void extendAccCount() {
        int i;
        int[] ta = new int[this.atomCount];
        int j = 0;
        for (i = 0; i < this.atomCount; ++i) {
            boolean v = true;
            if (this.isAcceptor(i)) {
                ta[j] = i;
                ++j;
                v = false;
            }
            if (this.isDonor(i) || !v || !this.isEmptyShell(i)) continue;
            ta[j] = i;
            ++j;
        }
        this.aCount = j;
        this.Acceptors = new int[this.aCount];
        for (i = 0; i < this.aCount; ++i) {
            this.Acceptors[i] = ta[i];
        }
    }

    private boolean isVinil(int a) {
        if (this.delocAble[a] == -1) {
            return false;
        }
        if (this.protonC[a] != 7) {
            return false;
        }
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int b;
            int nb = this.cHtab[a][i];
            if (nb >= this.atomCount || (b = this.oMol.getBond(this.bHtab[a][nb]).getType()) != 2 && b != 3) continue;
            return true;
        }
        return false;
    }

    private boolean isEmptyShell(int a) {
        if (this.delocAble[a] == -1) {
            return false;
        }
        int lpc = this.initLPCount[a];
        int be = 2 * lpc + 2 * this.initHCount[a] + this.initRCount[a];
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int nb = this.cHtab[a][i];
            if (nb >= this.atomCount) continue;
            be += 2 * this.oMol.getBond(this.bHtab[a][nb]).getType();
        }
        if (be < 8) {
            return true;
        }
        if (be == 8) {
            if (this.initCharge[a] > 1) {
                return true;
            }
            if (this.initCharge[a] != 0 && this.protonC[a] > 9 && this.getGroupNumber(this.protonC[a]) >= 5) {
                return true;
            }
        }
        return false;
    }

    private void excludeRNO() {
        int i;
        int[] ta = new int[this.aCount];
        for (int i2 = 0; i2 < this.aCount; ++i2) {
            int type;
            int a = this.Acceptors[i2];
            if (this.protonC[a] != 7 || this.initCharge[a] != 0 || this.cHtab[a].length != 4 || (type = this.polarGroups.carboxy[a]) != 1200) continue;
            for (int k = 0; k < this.cHtab[a].length; ++k) {
                int nb = this.cHtab[a][k];
                if (nb >= this.atomCount || this.oMol.getBond(this.bHtab[nb][a]).getType() != 2) continue;
                ta[i2] = -1;
                ta[this.getAcceptorIndex((int)nb)] = -1;
            }
        }
        int c = 0;
        for (int i3 = 0; i3 < this.aCount; ++i3) {
            if (ta[i3] != -1) continue;
            ++c;
        }
        int[] r = new int[this.aCount - c];
        int j = 0;
        for (i = 0; i < this.aCount; ++i) {
            if (ta[i] == -1) continue;
            r[j] = this.Acceptors[i];
            ++j;
        }
        this.aCount -= c;
        this.Acceptors = new int[this.aCount];
        for (i = 0; i < this.aCount; ++i) {
            this.Acceptors[i] = r[i];
        }
    }

    private void extendDonAccCount() {
        int i;
        int i2;
        int[] td = new int[this.atomCount];
        int j = 0;
        for (i2 = 0; i2 < this.atomCount; ++i2) {
            if (this.initRCount[i2] != 0) {
                td[j] = i2;
                ++j;
                continue;
            }
            if (!this.isDonor(i2)) continue;
            td[j] = i2;
            ++j;
        }
        this.dCount = j;
        this.Donors = new int[this.dCount];
        for (i2 = 0; i2 < this.dCount; ++i2) {
            this.Donors[i2] = td[i2];
        }
        int[] ta = new int[this.atomCount];
        j = 0;
        for (i = 0; i < this.atomCount; ++i) {
            if (this.initRCount[i] != 0) {
                if (!this.isAcceptor(i) || this.isDonor(i)) continue;
                ta[j] = i;
                ++j;
                continue;
            }
            if (!this.isAcceptor(i)) continue;
            ta[j] = i;
            ++j;
        }
        this.aCount = j;
        this.Acceptors = new int[this.aCount];
        for (i = 0; i < this.aCount; ++i) {
            this.Acceptors[i] = ta[i];
        }
    }

    private void extendLPDonors() {
        int i;
        int[] td = new int[this.atomCount];
        int j = 0;
        for (i = 0; i < this.atomCount; ++i) {
            if (this.isDonor(i)) {
                td[j] = i;
                ++j;
                continue;
            }
            if (this.initLPCount[i] == 0 || this.isAcceptor(i) || this.polarGroups.carboxy[i] == 1400) continue;
            td[j] = i;
            ++j;
        }
        this.dCount = j;
        this.Donors = new int[this.dCount];
        for (i = 0; i < this.dCount; ++i) {
            this.Donors[i] = td[i];
        }
    }

    private void addHyperConjugateCarbon() {
        int i;
        int[] td = new int[this.atomCount];
        int j = 0;
        for (int i2 = 0; i2 < this.atomCount; ++i2) {
            if (this.isDonor(i2) || !this.isToluolLike(i2)) continue;
            td[j] = i2;
            ++j;
        }
        int[] dd = new int[this.dCount + j];
        for (i = 0; i < this.dCount; ++i) {
            dd[i] = this.Donors[i];
        }
        this.Donors = new int[this.dCount + j];
        for (i = 0; i < this.dCount; ++i) {
            this.Donors[i] = dd[i];
        }
        for (i = this.dCount; i < this.dCount + j; ++i) {
            this.Donors[i] = td[i - this.dCount];
        }
        this.dCount += j;
    }

    private void excludeDualAccDonAtoms() {
        int[] y = new int[this.aCount];
        for (int i = 0; i < this.aCount; ++i) {
            y[i] = this.Acceptors[i];
        }
        int c = 0;
        for (int i = 0; i < this.dCount; ++i) {
            if (!this.isAcceptor(this.Donors[i]) || this.atomArray[this.Donors[i]].getCharge() >= 0) continue;
            y[this.getAcceptorIndex((int)this.Donors[i])] = -1;
            ++c;
        }
        if (c != 0) {
            this.aCount -= c;
            this.Acceptors = new int[this.aCount];
            int k = 0;
            for (int i = 0; i < this.aCount + c; ++i) {
                if (y[i] == -1) continue;
                this.Acceptors[k] = y[i];
                ++k;
            }
        }
    }

    private void extendHeteroAcceptors() {
        int[] ta = new int[this.atomCount];
        int j = 0;
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.initHCount[i] != 0 || this.protonC[i] == 6 || this.isArA(i)) continue;
            boolean a = this.isAcceptor(i);
            boolean d = this.isDonor(i);
            if (a || d || !this.isDoubleBondedAtom(i)) continue;
            ta[j] = i;
            ++j;
        }
        if (j != 0) {
            int i;
            int[] ac = new int[this.aCount];
            for (i = 0; i < this.aCount; ++i) {
                ac[i] = this.Acceptors[i];
            }
            this.Acceptors = new int[this.aCount + j];
            for (i = 0; i < this.aCount; ++i) {
                this.Acceptors[i] = ac[i];
            }
            for (i = this.aCount; i < this.aCount + j; ++i) {
                this.Acceptors[i] = ta[i - this.aCount];
            }
            this.aCount += j;
        }
    }

    private boolean isToluolLike(int ai) {
        int h = 0;
        int a = 0;
        if (this.isArA(ai)) {
            return false;
        }
        if (this.protonC[ai] != 6) {
            return false;
        }
        if (this.cHtab[ai].length != 4) {
            return false;
        }
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb < this.atomCount) {
                if (!this.isArA(nb)) continue;
                ++a;
                continue;
            }
            ++h;
        }
        return h > 0 && a > 0;
    }

    private void reduceHDonors() {
        int i;
        int[] td = new int[this.atomCount];
        int j = 0;
        for (i = 0; i < this.atomCount; ++i) {
            if (!this.isDonor(i)) continue;
            if (this.protonC[i] == 6 || this.protonC[i] == 14) {
                if (this.cHtab[i].length == 4) continue;
                td[j] = i;
                ++j;
                continue;
            }
            td[j] = i;
            ++j;
        }
        this.dCount = j;
        this.Donors = new int[this.dCount];
        for (i = 0; i < this.dCount; ++i) {
            this.Donors[i] = td[i];
        }
    }

    private boolean getGroupHeteroCount(int gi, int maxSize, int maxHCount, int ai, boolean limit) {
        int a;
        int i;
        if (this.polarGroups.groupType[ai] == 1700 && !this.stdCanonic) {
            return false;
        }
        int L = this.polarGroups.groups[gi].length;
        if (L != maxSize && limit) {
            return false;
        }
        int c = 0;
        for (i = 0; i < L; ++i) {
            a = this.polarGroups.groups[gi][i];
            if (this.protonC[a] == 6) continue;
            ++c;
        }
        if (c != maxHCount && limit) {
            return false;
        }
        for (i = 0; i < L; ++i) {
            a = this.polarGroups.groups[gi][i];
            if (!this.isHeteroNbExist(a, gi)) continue;
            return false;
        }
        return true;
    }

    private boolean isHeteroNbExist(int a, int gi) {
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int nb = this.cHtab[a][i];
            if (nb >= this.atomCount || this.polarGroups.groupIndex[nb] == gi || this.protonC[nb] == 6) continue;
            return true;
        }
        return false;
    }

    private boolean isInstableRing(int ai) {
        int gi = this.polarGroups.groupIndex[ai];
        int L = this.polarGroups.groups[gi].length;
        for (int i = 0; i < L; ++i) {
            int ri;
            int info;
            int ra = this.polarGroups.groups[gi][i];
            if (!this.rings.isInRing()[ra] || (info = this.charge.isSemiAromaticRing(ri = this.charge.getSmallestRingIndex(ai))) != 4 && info != 8 || this.getHeteroCount(ri) < 2) continue;
            return true;
        }
        return false;
    }

    private int getHeteroCount(int ri) {
        int c = 0;
        for (int i = 0; i < this.charge.nonAring[ri].length; ++i) {
            int ra = this.charge.nonAring[ri][i];
            if (this.protonC[ra] == 6) continue;
            ++c;
        }
        return c;
    }

    private void fixEsterGroupsWithoutpKa() {
        int i;
        int[] td = new int[this.atomCount];
        int[] ta = new int[this.atomCount];
        int j = 0;
        int k = 0;
        int[] used = new int[this.polarGroups.groups.length];
        boolean[] gState = new boolean[this.polarGroups.groups.length];
        for (int i2 = 0; i2 < this.polarGroups.groups.length; ++i2) {
            used[i2] = -1;
            gState[i2] = false;
        }
        boolean exclude = true;
        for (i = 0; i < this.atomCount; ++i) {
            boolean limit;
            boolean preExcluded;
            boolean sa;
            int gi;
            int gtype;
            int prop;
            int type;
            int ms = 3;
            int mhc = 2;
            if (this.isDonor(i)) {
                type = this.polarGroups.carboxy[i];
                prop = this.polarGroups.groupProperty[i];
                gtype = this.polarGroups.groupType[i];
                gi = this.polarGroups.groupIndex[i];
                sa = false;
                if (this.isArA(i)) {
                    sa = true;
                }
                if (gi >= 0) {
                    if (used[gi] == -1) {
                        preExcluded = false;
                        if (type == 200 && (this.ratTau || this.stdCanonic) && this.isInstableRing(i)) {
                            gState[gi] = false;
                            exclude = false;
                            preExcluded = true;
                        }
                        limit = true;
                        if (type == 300 && prop == 700) {
                            ms = 4;
                            mhc = 4;
                        } else if (type == 800) {
                            limit = false;
                            exclude = true;
                            gState[gi] = true;
                        } else if (type == 300) {
                            limit = false;
                        } else if (type == 200 && gtype == 850) {
                            limit = false;
                        } else if (gtype == 21 && prop == 422) {
                            mhc = 3;
                        } else if (gtype == 19) {
                            limit = false;
                        } else if (gtype == 10) {
                            limit = false;
                        } else if (type == 880) {
                            limit = false;
                        } else if (type == 200 && prop == 410 && gtype == 13) {
                            limit = false;
                        }
                        if (this.getGroupHeteroCount(gi, ms, mhc, i, limit) && !preExcluded) {
                            exclude = true;
                            gState[gi] = true;
                        } else {
                            exclude = false;
                        }
                        used[gi] = 0;
                    } else {
                        exclude = gState[gi];
                    }
                }
                if (exclude) {
                    if (this.isDBCarbon(i) && !this.ketenAllowed || type == 2 || type == 1830 || type == 1700 && prop == 2 || gtype == 19 || gtype == 20 || prop == 500 || this.protectAmideGroups && !sa && (type == 200 || type == 500 || gtype == 10 && prop == 411) || this.protectAraDiaza && !sa && (type == 1700 && prop == 3800 || type == 880 && !this.allTau) || this.protectSulfuracidGroups && (type == 300 && prop == 700 || type == 800) || this.protectCOOH && type == 300 && gtype == 17 && prop != 800) continue;
                    td[j] = i;
                    ++j;
                    continue;
                }
                td[j] = i;
                ++j;
                continue;
            }
            if (!this.isAcceptor(i)) continue;
            type = this.polarGroups.carboxy[i];
            prop = this.polarGroups.groupProperty[i];
            gtype = this.polarGroups.groupType[i];
            gi = this.polarGroups.groupIndex[i];
            sa = false;
            if (this.isArA(i)) {
                sa = true;
            }
            if (gi >= 0) {
                if (used[gi] == -1) {
                    preExcluded = false;
                    if (type == 200 && (this.ratTau || this.stdCanonic) && this.isInstableRing(i)) {
                        gState[gi] = false;
                        exclude = false;
                        preExcluded = true;
                    }
                    limit = true;
                    if (type == 300 && prop == 700) {
                        ms = 4;
                        mhc = 4;
                    } else if (type == 800) {
                        limit = false;
                        exclude = true;
                        gState[gi] = true;
                    } else if (type == 300) {
                        limit = false;
                    } else if (type == 200 && gtype == 850) {
                        limit = false;
                    } else if (gtype == 21 && prop == 422) {
                        mhc = 3;
                    } else if (gtype == 19) {
                        limit = false;
                    } else if (type == 400) {
                        limit = false;
                    } else if (gtype == 10) {
                        limit = false;
                    } else if (type == 200 && prop == 410 && gtype == 13) {
                        limit = false;
                    } else if (type == 1 && (prop == 421 || prop == 4500)) {
                        limit = false;
                        exclude = true;
                        gState[gi] = true;
                    }
                    if (this.getGroupHeteroCount(gi, ms, mhc, i, limit) && !preExcluded) {
                        exclude = true;
                        gState[gi] = true;
                    } else {
                        exclude = false;
                    }
                    used[gi] = 0;
                } else {
                    exclude = gState[gi];
                }
            }
            if (exclude) {
                if (type == 2 || type == 1830 || type == 1700 && prop == 2 || gtype == 19 || gtype == 20 || prop == 500 || this.protectAmideGroups && !sa && (type == 200 || type == 500 || gtype == 10 && prop == 411) || this.protectAraDiaza && !sa && (type == 1700 && prop == 3800 || type == 400) || this.protectSulfuracidGroups && (type == 300 && prop == 700 || type == 800 || prop == 422 && gtype == 21) || this.protectCOOH && (type == 300 && gtype == 17 && prop != 800 || type == 1 && (prop == 421 || prop == 4500) && !this.allTau)) continue;
                ta[k] = i;
                ++k;
                continue;
            }
            ta[k] = i;
            ++k;
        }
        this.dCount = j;
        this.Donors = new int[this.dCount];
        for (i = 0; i < this.dCount; ++i) {
            this.Donors[i] = td[i];
        }
        this.aCount = k;
        this.Acceptors = new int[this.aCount];
        for (i = 0; i < this.aCount; ++i) {
            this.Acceptors[i] = ta[i];
        }
    }

    private void fixStableGroupsWithoutpKa() {
        int i;
        int[] td = new int[this.atomCount];
        int[] ta = new int[this.atomCount];
        int j = 0;
        int k = 0;
        for (i = 0; i < this.atomCount; ++i) {
            int gtype;
            int prop;
            int type;
            if (this.isDonor(i)) {
                type = this.polarGroups.carboxy[i];
                prop = this.polarGroups.groupProperty[i];
                gtype = this.polarGroups.groupType[i];
                if (this.isDBCarbon(i) && !this.ketenAllowed || type == 1200 && this.cHtab[i].length == 4 || prop == 422 || type == 1400 || type == 2 || type == 1830 || type == 1700 && prop == 2 || gtype == 19 || gtype == 20 || prop == 500 || type == 700 || type == 600 || type == 100 || type == 1300) continue;
                if (prop == 600) {
                    td[j] = i;
                    ++j;
                    continue;
                }
                if (prop == 800) {
                    td[j] = i;
                    ++j;
                    continue;
                }
                if (type == 300 && gtype == 870) {
                    td[j] = i;
                    ++j;
                    continue;
                }
                if (type == 300 || type == 1000 || type == 400 || type == 800) continue;
                if (type == 200 || type == 500) {
                    if (prop == 409 && !this.isPartOfDelocAbleRing(i)) continue;
                    td[j] = i;
                    ++j;
                    continue;
                }
                td[j] = i;
                ++j;
                continue;
            }
            if (!this.isAcceptor(i)) continue;
            type = this.polarGroups.carboxy[i];
            prop = this.polarGroups.groupProperty[i];
            gtype = this.polarGroups.groupType[i];
            if (type == 1200 && this.cHtab[i].length == 4 || prop == 422 || type == 1400 || type == 2 || type == 1830 || type == 1700 && prop == 2 || gtype == 19 || gtype == 20 || prop == 500 || type == 100 || type == 1300 || prop == 600 || type == 700 || type == 600) continue;
            if (type == 200 || type == 500) {
                if (prop == 409 && !this.isPartOfDelocAbleRing(i)) continue;
                ta[k] = i;
                ++k;
                continue;
            }
            if (type == 300 && gtype == 870) {
                ta[k] = i;
                ++k;
                continue;
            }
            if (type == 300 || type == 1000 || type == 400 || type == 800) continue;
            ta[k] = i;
            ++k;
        }
        this.dCount = j;
        this.Donors = new int[this.dCount];
        for (i = 0; i < this.dCount; ++i) {
            this.Donors[i] = td[i];
        }
        this.aCount = k;
        this.Acceptors = new int[this.aCount];
        for (i = 0; i < this.aCount; ++i) {
            this.Acceptors[i] = ta[i];
        }
    }

    private boolean isPartOfDelocAbleRing(int ai) {
        if (this.isArA(ai)) {
            return true;
        }
        if (this.rings.isInRing()[ai]) {
            return !this.isStableRing(ai);
        }
        if (this.protonC[ai] == 7) {
            return false;
        }
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.atomCount) continue;
            if (this.isArA(nb)) {
                return true;
            }
            if (!this.rings.isInRing()[nb]) continue;
            return !this.isStableRing(nb);
        }
        return false;
    }

    private void excludeNonSpontanDonAcc() {
        int i;
        int a;
        int[] td = new int[this.dCount];
        int k = 0;
        for (int i2 = 0; i2 < this.dCount; ++i2) {
            td[i2] = a = this.Donors[i2];
            if (this.notSpontanDonor[a] != -1 || this.notSpontanAcceptor[a] != -1) continue;
            td[i2] = -1;
            ++k;
        }
        int d = this.dCount - k;
        this.Donors = new int[d];
        k = 0;
        for (int i3 = 0; i3 < this.dCount; ++i3) {
            if (td[i3] == -1) continue;
            this.Donors[k] = td[i3];
            ++k;
        }
        this.dCount = d;
        int[] ta = new int[this.aCount];
        k = 0;
        for (i = 0; i < this.aCount; ++i) {
            ta[i] = a = this.Acceptors[i];
            if (this.notSpontanDonor[a] != -1 || this.notSpontanAcceptor[a] != -1) continue;
            ta[i] = -1;
            ++k;
        }
        d = this.aCount - k;
        this.Acceptors = new int[d];
        k = 0;
        for (i = 0; i < this.aCount; ++i) {
            if (ta[i] == -1) continue;
            this.Acceptors[k] = ta[i];
            ++k;
        }
        this.aCount = d;
    }

    private boolean isStableRing(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.atomCount || this.protonC[nb] == 6 && this.cHtab[nb].length == 4 || this.polarGroups.groupIndex[nb] == this.polarGroups.groupIndex[ai]) continue;
            return false;
        }
        return true;
    }

    private void setInitCharge() {
        this.initCharge = new int[this.atomCount];
        this.chgCount = 0;
        for (int i = 0; i < this.atomCount; ++i) {
            this.initCharge[i] = this.atomArray[i].getCharge();
            if (this.initCharge[i] == 0) continue;
            ++this.chgCount;
        }
    }

    private void setChargeFlag() {
        int i = 0;
        this.chargeFlag = false;
        if (this.protectCharge && !this.getResStructures) {
            return;
        }
        if (!this.chargeResonance) {
            return;
        }
        if (this.getResStructures) {
            this.chargeFlag = true;
            return;
        }
        if (this.chgCount == 0) {
            return;
        }
        boolean nCharge = false;
        boolean pCharge = false;
        boolean rXdb = false;
        int[] d = new int[this.chgCount];
        for (int x = 0; x < this.chgCount; ++x) {
            d[x] = -1;
        }
        int k = 0;
        while (i < this.atomCount) {
            if (this.initCharge[i] != 0 && this.isDelocNeighbours(i)) {
                if (this.isDonor(i) || this.isAcceptor(i)) {
                    this.chargeFlag = true;
                    if (this.initCharge[i] < 0) {
                        nCharge = true;
                    } else if (this.initCharge[i] > 0) {
                        if (this.isDBonded(i)) {
                            pCharge = true;
                        } else if (this.isEmptyShell(i)) {
                            pCharge = true;
                        } else if (this.isVinil(i)) {
                            pCharge = true;
                        }
                    }
                } else if (this.initCharge[i] > 0 && this.isDBonded(i)) {
                    d[k] = i;
                    ++k;
                    rXdb = true;
                }
            }
            ++i;
        }
        if (nCharge && rXdb) {
            this.setAccPlusKeto(d);
            this.chargeFlag = true;
            this.reduceDonAccCount();
            return;
        }
        if (pCharge) {
            this.chargeFlag = true;
            this.reduceDonAccCount();
            return;
        }
        if (!pCharge || !nCharge) {
            this.chargeFlag = false;
            return;
        }
        if (pCharge && nCharge) {
            this.chargeFlag = true;
            this.reduceDonAccCount();
            return;
        }
    }

    private void setAccPlusKeto(int[] p) {
        int i;
        int[] ta = new int[this.atomCount];
        for (int i2 = 0; i2 < this.aCount; ++i2) {
            ta[i2] = this.Acceptors[i2];
        }
        int j = this.aCount;
        for (i = 0; i < this.chgCount; ++i) {
            if (p[i] == -1) continue;
            ta[j] = p[i];
            ++j;
        }
        this.aCount = j;
        this.Acceptors = new int[this.aCount];
        for (i = 0; i < this.aCount; ++i) {
            this.Acceptors[i] = ta[i];
        }
    }

    private boolean isDBonded(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int bt;
            int nb = this.cHtab[ai][i];
            if (nb >= this.atomCount || (bt = this.oMol.getBond(this.bHtab[ai][nb]).getType()) <= 1) continue;
            this.setActAtomIndex(nb);
            return true;
        }
        return false;
    }

    private boolean isDelocNeighbours(int a) {
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int nb = this.cHtab[a][i];
            if (nb >= this.atomCount || this.delocAble[nb] != 1) continue;
            return true;
        }
        return false;
    }

    private void setDonAccArray() {
        int i;
        int j = 0;
        this.DonAcc = new int[this.dCount + this.aCount];
        for (i = 0; i < this.dCount; ++i) {
            this.DonAcc[i] = this.Donors[i];
        }
        while (i < this.dCount + this.aCount) {
            this.DonAcc[i] = this.Acceptors[j];
            ++i;
            ++j;
        }
    }

    private void setDonAccIslands() {
        int i;
        this.excludeSaturatedAliCarbonDonors();
        this.setDonAccArray();
        this.createSaturatedAliCarbonDonors();
        this.setDonAccArray();
        this.heteroD = new int[this.dCount];
        for (i = 0; i < this.dCount; ++i) {
            this.heteroD[i] = -1;
        }
        this.heteroA = new int[this.aCount];
        for (i = 0; i < this.aCount; ++i) {
            this.heteroA[i] = this.Acceptors[i];
        }
        int x = 0;
        int p = 0;
        int x0 = 0;
        int p0 = 0;
        int dc0 = this.dCount;
        int dc = 0;
        int dd0 = this.dCount;
        int aa0 = this.aCount;
        int d0 = dd0 + 1;
        int a0 = aa0 + 1;
        boolean next = false;
        while (dd0 != d0 || aa0 != a0 || next) {
            int y;
            d0 = this.dCount;
            a0 = this.aCount;
            this.setTrueHeteroDonor();
            this.addLatentCarbonAraAcceptors();
            dc0 = this.dCount;
            dc = 0;
            while (dc0 != dc) {
                dc = this.dCount;
                this.addTerminalCarbonAliDonors();
                dc0 = this.dCount;
            }
            dc0 = this.dCount;
            dc = dc0 + 1;
            while (dc0 != dc) {
                dc = this.dCount;
                this.addLatentCarbonAliDonors();
                dc0 = this.dCount;
            }
            dc0 = this.dCount;
            dc = dc0 + 1;
            while (dc0 != dc) {
                dc = this.dCount;
                this.addLatentToluolCarbon3();
                dc0 = this.dCount;
            }
            dd0 = this.dCount;
            aa0 = this.aCount;
            x = 0;
            p = 0;
            for (y = 0; y < this.heteroA.length; ++y) {
                if (this.heteroA[y] == -1) continue;
                ++x;
            }
            for (y = 0; y < this.heteroD.length; ++y) {
                if (this.heteroD[y] == -1) continue;
                ++p;
            }
            next = false;
            if (x == x0 && p == p0) continue;
            next = true;
            x0 = x;
            p0 = p;
        }
        this.exAli = new int[this.dCount + this.aCount];
        this.exclAli = 0;
        for (int i2 = 0; i2 < this.dCount + this.aCount; ++i2) {
            this.exAli[i2] = -1;
        }
        int w0 = this.dCount + this.aCount;
        int wc = w0 + 1;
        while (w0 < wc) {
            wc = this.dCount + this.aCount;
            this.excludeFalseDonAccAtom();
            w0 = this.dCount + this.aCount;
            this.excludeTerminalDBondedAtom();
        }
        this.excludeFalseHeteroDonor();
        this.excludeFalseHeteroAraAcceptor();
        this.excludeLoneDA();
        this.setDonAccArray();
        this.setInitECount();
        this.setInitBonds();
        if (!(this.dCount != 0 && this.aCount != 0 || this.isKetenCanExist(0))) {
            this.excludeAllDA();
        }
    }

    private boolean isKetenCanExist(int islandIndx) {
        if (this.aCount != 0) {
            for (int i = 0; i < this.aCount; ++i) {
                int a = this.Acceptors[i];
                if (this.IslandIndex[a] != this.islandCount || this.protonC[a] == 6 || !this.isHExist(a) || this.polarGroups.groupProperty[a] != 3200) continue;
                return true;
            }
        }
        return this.isKeteneCanBeFormed(islandIndx);
    }

    private boolean isKeteneCanBeFormed(int islandIndx) {
        if (this.aCount != 0) {
            boolean cond1 = false;
            boolean cond2 = false;
            for (int i = 0; i < this.aCount; ++i) {
                int a = this.Acceptors[i];
                if (this.IslandIndex[a] != this.islandCount || !this.isDBonded(a)) continue;
                if (this.isHExist(a)) {
                    cond2 = true;
                    continue;
                }
                if (this.protonC[a] == 6) continue;
                cond1 = true;
            }
            if (cond1 && cond2) {
                return true;
            }
        }
        return false;
    }

    private boolean isHExist(int ai) {
        MolAtom a = this.oMol.getAtom(ai);
        int hc = a.getImplicitHcount();
        return hc > 0;
    }

    private int getExAraIndx(int ai) {
        for (int i = 0; i < this.exclAra; ++i) {
            if (this.exAra[i] != ai) continue;
            return i;
        }
        return -1;
    }

    private boolean isExAraAtom(int ai) {
        for (int i = 0; i < this.exclAra; ++i) {
            if (this.exAra[i] != ai) continue;
            return true;
        }
        return false;
    }

    private void excludeAllDA() {
        this.dCount = 0;
        this.Donors = new int[0];
        this.aCount = 0;
        this.Acceptors = new int[0];
    }

    private void setTauIslands() {
        this.tSearch = true;
        int size0 = this.dCount + this.aCount;
        this.islandCount = 0;
        int keyAtom = 0;
        this.clearFalseAraIslands();
        int[] tauAtoms = new int[size0];
        for (int i = 0; i < size0; ++i) {
            tauAtoms[i] = this.getDonAccAtom(i);
        }
        boolean find = false;
        if (size0 != 0) {
            find = true;
            this.islandCount = 1;
            keyAtom = tauAtoms[0];
        }
        while (find) {
            this.restrict = false;
            this.calcDelocPath(keyAtom, -1, -1);
            this.IslandIndex[keyAtom] = this.islandCount;
            int j = 0;
            int ya = 0;
            int yd = 0;
            if (this.isDonor(keyAtom)) {
                ++yd;
            }
            if (this.isAcceptor(keyAtom)) {
                ++ya;
            }
            while (j < this.sphereSize) {
                int sa = this.sAtom[j];
                if (this.isDonor(sa)) {
                    this.IslandIndex[sa] = this.islandCount;
                    ++yd;
                } else if (this.isAcceptor(sa)) {
                    this.IslandIndex[sa] = this.islandCount;
                    ++ya;
                } else if (this.isExcludedAtom(sa)) {
                    this.IslandIndex[sa] = this.islandCount;
                }
                ++j;
            }
            if (!(ya != 0 && yd != 0 || this.isKetenCanExist(this.islandCount))) {
                for (int i = 0; i < this.atomCount; ++i) {
                    if (this.IslandIndex[i] != this.islandCount) continue;
                    this.IslandIndex[i] = -1;
                }
                --this.islandCount;
            }
            find = false;
            for (int k = 0; k < size0 && !find; ++k) {
                if (this.IslandIndex[tauAtoms[k]] != 0) continue;
                find = true;
                keyAtom = tauAtoms[k];
                ++this.islandCount;
            }
        }
        this.tSearch = false;
    }

    private void clearFalseAraIslands() {
        int ind = 0;
        int[] used = new int[this.atomCount];
        for (int i = 0; i < this.atomCount; ++i) {
            int a;
            int j;
            if (!this.isArA(i) || used[i] != 0 || (ind = this.charge.getLargestAraRingIndex(i)) == -1) continue;
            int c = 0;
            for (j = 0; j < this.charge.aAtoms[ind].length; ++j) {
                a = this.charge.aAtoms[ind][j];
                used[a] = 1;
                if (!this.isExAraAtom(a)) continue;
                ++c;
            }
            if (c != this.charge.aAtoms[ind].length) continue;
            for (j = 0; j < this.charge.aAtoms[ind].length; ++j) {
                a = this.charge.aAtoms[ind][j];
                this.exAra[this.getExAraIndx((int)a)] = -1;
            }
        }
    }

    private void createDataSgroups() {
        int hd = 0;
        int ht = 0;
        int[] hType = new int[9];
        for (int i = 0; i < this.islandCount; ++i) {
            MolAtom[] a = this.getIslandMolAtoms(i + 1);
            DataSgroup dsg = new DataSgroup(this.oMol);
            for (int j = 0; j < a.length; ++j) {
                this.oMol.setSgroupParent(a[j], dsg, true);
                int indx = this.oMol.indexOf(a[j]);
                if (!this.isDonor(indx) && !this.isAcceptor(indx) && this.initExpHCount[indx] == 0) continue;
                hType = this.getExpHDTCountTypes(this.initExpHCount[indx]);
                hd += hType[1] + hType[4];
                ht += hType[0] + hType[5];
                this.removeIsotopeHydrogens(hType, indx);
            }
            dsg.setFieldName(SGROUP_PROPERTY_NAME);
            String be = String.valueOf(this.getBondingElectronCount(i + 1));
            be = be + ELECTRON_SEPARATOR + String.valueOf(hd) + DEUTERIUM_SEPARATOR + String.valueOf(ht) + TRICIUM_SEPARATOR;
            dsg.setData(be);
        }
        this.setAnyBondType();
        this.setExplicitHydrogens(this.oMol, -1);
    }

    private void removeIsotopeHydrogens(int[] hType, int aindx) {
        int n = aindx;
        this.initExpHCount[n] = this.initExpHCount[n] + (-100000 * hType[5] - 10000 * hType[4] - 10 * hType[1] - hType[0]);
    }

    private int getBondingElectronCount(int rIndex) {
        int sing = 0;
        int doub = 0;
        int trip = 0;
        int secret = 0;
        for (int aind = 0; aind < this.atomCount; ++aind) {
            if (this.IslandIndex[aind] != rIndex) continue;
            for (int kk = 0; kk < this.cHtab[aind].length; ++kk) {
                int bt;
                int nb = this.cHtab[aind][kk];
                if (nb >= this.atomCount) continue;
                if (this.IslandIndex[nb] == rIndex) {
                    bt = this.oMol.getBond(this.bHtab[nb][aind]).getType();
                    switch (bt) {
                        case 1: {
                            ++sing;
                            break;
                        }
                        case 2: {
                            ++doub;
                            break;
                        }
                        case 3: {
                            ++trip;
                        }
                    }
                    continue;
                }
                bt = this.oMol.getBond(this.bHtab[nb][aind]).getType();
                secret += bt - 1;
            }
        }
        return secret + 1 * sing + 2 * doub + 3 * trip;
    }

    private MolAtom[] getIslandMolAtoms(int indx) {
        int c = 0;
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.IslandIndex[i] != indx) continue;
            ++c;
        }
        MolAtom[] y = new MolAtom[c];
        int k = 0;
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.IslandIndex[i] != indx) continue;
            y[k] = this.oMol.getAtom(i);
            ++k;
        }
        return y;
    }

    private void setAnyBondType() {
        int indx = 0;
        if (this.aromatizalj) {
            this.oMol.aromatize(2);
        }
        while (indx < this.islandCount) {
            for (int i = 0; i < this.atomCount; ++i) {
                if (this.IslandIndex[i] != indx + 1) continue;
                MolAtom a = this.oMol.getAtom(i);
                for (int j = 0; j < a.getBondCount(); ++j) {
                    MolBond actBond = a.getBond(j);
                    MolAtom aa = actBond.getOtherAtom(a);
                    int aindx = this.oMol.indexOf(aa);
                    if (this.IslandIndex[aindx] != indx + 1) continue;
                    actBond.setType(0);
                }
            }
            ++indx;
        }
    }

    private void excludeSaturatedAliCarbonDonors() {
        int i;
        int j = 0;
        int[] td = new int[this.atomCount];
        for (i = 0; i < this.dCount; ++i) {
            int a = this.Donors[i];
            if (!this.isArA(a)) {
                if (this.protonC[a] == 6) {
                    if (this.cHtab[a].length != 4) {
                        td[j] = a;
                        ++j;
                        continue;
                    }
                    this.delocAble[a] = -1;
                    continue;
                }
                td[j] = a;
                ++j;
                continue;
            }
            td[j] = a;
            ++j;
        }
        this.dCount = j;
        this.Donors = new int[this.dCount];
        for (i = 0; i < this.dCount; ++i) {
            this.Donors[i] = td[i];
        }
    }

    private void createSaturatedAliCarbonDonors() {
        int i;
        int j = 0;
        int[] td = new int[this.atomCount];
        int[] z = new int[4];
        for (i = 0; i < this.atomCount; ++i) {
            if (this.isDonor(i)) {
                td[j] = i;
                ++j;
                continue;
            }
            if (this.protonC[i] != 6 || this.cHtab[i].length != 4 || !this.isHExist(i)) continue;
            this.restrict = false;
            this.calcDelocPath(i, -1, -1);
            int t = this.getUnsaturatedBondCount(i);
            if (this.isHeteroAcceptorExist(t)) {
                td[j] = i;
                this.delocAble[i] = 1;
                ++j;
                continue;
            }
            if (!this.rings.isInRing()[i]) continue;
            this.restrict = true;
            z = this.getNbSphereAtoms(this.nbCount[i]);
            boolean find = false;
            for (int v = 0; v < 4 && !find; ++v) {
                if (z[v] == -1 || !this.rings.isInRing()[z[v]]) continue;
                this.calcDelocPath(i, z[v], i);
                t = this.getUnsaturatedBondCount(i);
                if (!this.isHeteroAcceptorExist(t)) continue;
                td[j] = i;
                this.delocAble[i] = 1;
                ++j;
                find = true;
            }
        }
        this.dCount = j;
        this.Donors = new int[this.dCount];
        for (i = 0; i < this.dCount; ++i) {
            this.Donors[i] = td[i];
        }
    }

    private void excludeFalseHeteroDonor() {
        int i;
        int j = 0;
        int[] td = new int[this.atomCount];
        for (i = 0; i < this.dCount; ++i) {
            int a = this.Donors[i];
            if (this.heteroD[i] == -1) continue;
            td[j] = a;
            ++j;
        }
        this.dCount = j;
        this.Donors = new int[this.dCount];
        for (i = 0; i < this.dCount; ++i) {
            this.Donors[i] = td[i];
        }
    }

    private void excludeFalseHeteroAraAcceptor() {
        int j = 0;
        int[] ta = new int[this.atomCount];
        int k = 0;
        int[] exa = new int[this.atomCount];
        int[] usedAra = new int[this.atomCount];
        for (int i = 0; i < this.atomCount; ++i) {
            usedAra[i] = -1;
        }
        for (int i = 0; i < this.aCount; ++i) {
            int a = this.Acceptors[i];
            boolean yy = false;
            if (this.isArA(a)) {
                yy = true;
            }
            if (yy && this.heteroA[i] == -1) {
                if (usedAra[a] != -1) continue;
                exa[k] = a;
                ++k;
                usedAra[a] = 1;
                continue;
            }
            if (yy) {
                if (usedAra[a] != -1) continue;
                int ri = this.charge.getLargestAraRingIndex(a);
                if (ri != -1) {
                    int ra;
                    int h;
                    if (!this.isAorDNbJoining(ri)) {
                        for (h = 0; h < this.charge.aAtoms[ri].length; ++h) {
                            ra = this.charge.aAtoms[ri][h];
                            if (usedAra[ra] == -1) {
                                exa[k] = ra;
                                ++k;
                            }
                            usedAra[ra] = 1;
                        }
                        continue;
                    }
                    for (h = 0; h < this.charge.aAtoms[ri].length; ++h) {
                        ra = this.charge.aAtoms[ri][h];
                        if (!this.singleBondedHeteroAra(ra) && usedAra[ra] == -1 && this.delocAble[ra] == 1 && !this.isDonor(ra)) {
                            ta[j] = ra;
                            ++j;
                        }
                        usedAra[ra] = 1;
                    }
                    continue;
                }
                if (usedAra[a] != -1) continue;
                if (!this.isDonor(a)) {
                    ta[j] = a;
                    ++j;
                }
                usedAra[a] = 1;
                continue;
            }
            ta[j] = a;
            ++j;
            usedAra[a] = 1;
        }
        if (k != 0) {
            int i;
            int[] ea = new int[this.exclAra];
            for (i = 0; i < this.exclAra; ++i) {
                ea[i] = this.exAra[i];
            }
            this.exAra = new int[this.exclAra + k];
            for (i = 0; i < this.exclAra; ++i) {
                this.exAra[i] = ea[i];
            }
            for (i = this.exclAra; i < this.exclAra + k; ++i) {
                this.exAra[i] = exa[i - this.exclAra];
            }
            this.exclAra += k;
            this.aCount = j;
            this.Acceptors = new int[this.aCount];
            for (i = 0; i < this.aCount; ++i) {
                this.Acceptors[i] = ta[i];
            }
        }
    }

    private boolean singleBondedHeteroAra(int ra) {
        if (this.protonC[ra] != 6) {
            int ac = this.oMol.getAtomCount();
            for (int i = 0; i < this.cHtab[ra].length; ++i) {
                int bt;
                int nb = this.cHtab[ra][i];
                if (nb >= ac || (bt = this.oMol.getBond(this.bHtab[ra][nb]).getType()) == 1) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean isAorDNbJoining(int riIndx) {
        for (int i = 0; i < this.charge.aAtoms[riIndx].length; ++i) {
            int ra = this.charge.aAtoms[riIndx][i];
            if (this.isAorDNbExist(riIndx, ra)) {
                return true;
            }
            if (this.protonC[ra] == 6 || !this.isDonor(ra)) continue;
            return true;
        }
        return false;
    }

    private boolean isAorDNbExist(int rIndex, int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.atomCount || !(!this.isArA(nb) ? this.isAcceptor(nb) || this.isDonor(nb) : !this.isTheSameAraRing(rIndex, nb) && (this.isAcceptor(nb) || this.isDonor(nb)))) continue;
            return true;
        }
        return false;
    }

    private boolean isTheSameAraRing(int ri, int ai) {
        if (ri == -1) {
            return false;
        }
        for (int i = 0; i < this.charge.aAtoms[ri].length; ++i) {
            if (this.charge.aAtoms[ri][i] != ai) continue;
            return true;
        }
        return false;
    }

    private void setTrueHeteroDonor() {
        for (int i = 0; i < this.dCount; ++i) {
            int a = this.Donors[i];
            if (this.protonC[a] != 6) {
                if (this.isSingleBondedAlphaAtom(a)) {
                    if (this.isBetaAcceptor(a)) {
                        this.heteroD[i] = a;
                        continue;
                    }
                    for (int j = 0; j < this.cHtab[a].length; ++j) {
                        int nb = this.cHtab[a][j];
                        if (nb >= this.atomCount) continue;
                        if (this.protonC[nb] == 6) {
                            if (!this.isDonor(nb) && !this.isAcceptor(nb)) continue;
                            this.heteroD[i] = a;
                            continue;
                        }
                        if (!this.isDonor(nb) || !this.isHeteroDCorrect(nb)) continue;
                        this.heteroD[i] = a;
                    }
                    continue;
                }
                this.heteroD[i] = a;
                continue;
            }
            this.heteroD[i] = a;
        }
    }

    private boolean isHeteroDCorrect(int ai) {
        for (int i = 0; i < this.heteroD.length; ++i) {
            if (this.heteroD[i] != ai) continue;
            return true;
        }
        return false;
    }

    private boolean isHeteroACorrect(int ai) {
        for (int i = 0; i < this.heteroA.length; ++i) {
            if (this.heteroA[i] != ai) continue;
            return true;
        }
        return false;
    }

    private boolean isSingleBondedAlphaAtom(int a) {
        boolean c = false;
        for (int i = 0; i < this.initBonds[a].length; ++i) {
            if (this.initBonds[a][i] != 1) {
                return false;
            }
            if (this.initHCount[a] == 0 && this.initRCount[a] == 0 && this.initCharge[a] == 0) continue;
            c = true;
        }
        return c;
    }

    private boolean isBetaAcceptor(int a) {
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int nb = this.cHtab[a][i];
            if (nb >= this.atomCount) continue;
            if (this.isDonor(nb) || this.isAcceptor(nb)) {
                for (int j = 0; j < this.cHtab[nb].length; ++j) {
                    int nnb = this.cHtab[nb][j];
                    if (nnb >= this.atomCount || nnb == a) continue;
                    if (this.isAcceptor(nnb)) {
                        return true;
                    }
                    if (this.isArA(nb) && this.isArA(nnb)) {
                        if (this.oMol.getBond(this.bHtab[nb][nnb]).getType() != 2) continue;
                        if (this.protonC[a] == 6) {
                            if (this.protonC[nnb] == 6) continue;
                            return true;
                        }
                        return true;
                    }
                    if (!this.isArA(nnb) || this.oMol.getBond(this.bHtab[nb][nnb]).getType() != 2) continue;
                    return true;
                }
                continue;
            }
            if (!this.isArA(nb) || this.isSingleBondedAlphaAtom(nb)) continue;
            return true;
        }
        return false;
    }

    private void excludeLoneDA() {
        int nb;
        int j;
        boolean find;
        int a;
        int i;
        int k = 0;
        int[] t = new int[this.atomCount];
        for (i = 0; i < this.dCount; ++i) {
            a = this.Donors[i];
            find = false;
            for (j = 0; j < this.cHtab[a].length && !find; ++j) {
                nb = this.cHtab[a][j];
                if (nb >= this.atomCount || !this.isDonor(nb) && !this.isAcceptor(nb) && !this.isExcludedAtom(nb)) continue;
                find = true;
                t[k] = a;
                ++k;
            }
        }
        this.dCount = k;
        this.Donors = new int[this.dCount];
        for (i = 0; i < this.dCount; ++i) {
            this.Donors[i] = t[i];
        }
        k = 0;
        for (i = 0; i < this.aCount; ++i) {
            a = this.Acceptors[i];
            find = false;
            for (j = 0; j < this.cHtab[a].length && !find; ++j) {
                nb = this.cHtab[a][j];
                if (nb >= this.atomCount || !this.isDonor(nb) && !this.isAcceptor(nb) && !this.isExcludedAtom(nb)) continue;
                find = true;
                t[k] = a;
                ++k;
            }
        }
        this.aCount = k;
        this.Acceptors = new int[this.aCount];
        for (i = 0; i < this.aCount; ++i) {
            this.Acceptors[i] = t[i];
        }
    }

    private void addLatentCarbonAraAcceptors() {
        int i;
        int[] c = new int[this.araCount];
        int j = 0;
        int[] ta = new int[this.atomCount];
        this.exclAra = 0;
        for (i = 0; i < this.atomCount; ++i) {
            if (this.aAtom[i] != 1 || this.protonC[i] != 6 || this.isDonor(i) || this.isAcceptor(i)) continue;
            this.restrict = false;
            this.calcDelocPath(i, -1, -1);
            int t = this.getUnsaturatedBondCount(i);
            if (this.isHeteroExist(t)) {
                ta[j] = i;
                ++j;
                continue;
            }
            c[this.exclAra] = i;
            ++this.exclAra;
        }
        this.exAra = new int[this.exclAra];
        for (i = 0; i < this.exclAra; ++i) {
            this.exAra[i] = c[i];
        }
        if (j != 0) {
            int i2;
            int i3;
            int[] ac = new int[this.aCount];
            for (i3 = 0; i3 < this.aCount; ++i3) {
                ac[i3] = this.Acceptors[i3];
            }
            this.Acceptors = new int[this.aCount + j];
            for (i3 = 0; i3 < this.aCount; ++i3) {
                this.Acceptors[i3] = ac[i3];
            }
            for (i3 = this.aCount; i3 < this.aCount + j; ++i3) {
                this.Acceptors[i3] = ta[i3 - this.aCount];
            }
            int[] ha = new int[this.aCount];
            for (i2 = 0; i2 < this.aCount; ++i2) {
                ha[i2] = this.heteroA[i2];
            }
            this.heteroA = new int[this.aCount + j];
            for (i2 = 0; i2 < this.aCount; ++i2) {
                this.heteroA[i2] = ha[i2];
            }
            for (i2 = this.aCount; i2 < this.aCount + j; ++i2) {
                this.heteroA[i2] = ta[i2 - this.aCount];
            }
            this.aCount += j;
        }
    }

    private void addTerminalCarbonAliDonors() {
        int[] td = new int[this.atomCount];
        int[] used = new int[this.atomCount];
        int j = 0;
        int k = 0;
        int[] y = new int[4];
        int[] z = new int[4];
        for (int i = 0; i < this.dCount; ++i) {
            int a = this.Donors[i];
            if (this.heteroD[i] == -1 || this.isArA(a) || (y = this.getNewTerminalCarbonDonor(a)) == null) continue;
            int c = 0;
            for (k = 0; y[k] != -1 && k < 4; ++k) {
                this.restrict = false;
                this.calcDelocPath(y[k], -1, -1);
                c = this.getUnsaturatedBondCount(y[k]);
                if (used[y[k]] != 0) continue;
                if (this.isHeteroExist(c)) {
                    td[j] = y[k];
                    used[y[k]] = 1;
                    ++j;
                    continue;
                }
                if (!this.rings.isInRing()[y[k]]) continue;
                this.restrict = true;
                z = this.getNbSphereAtoms(this.nbCount[y[k]]);
                boolean find = false;
                for (int v = 0; v < 4 && !find; ++v) {
                    if (z[v] == -1 || !this.rings.isInRing()[z[v]]) continue;
                    this.calcDelocPath(y[k], z[v], y[k]);
                    c = this.getUnsaturatedBondCount(y[k]);
                    if (!this.isHeteroExist(c)) continue;
                    td[j] = y[k];
                    used[y[k]] = 1;
                    ++j;
                    find = true;
                }
            }
        }
        if (j != 0) {
            int i;
            int i2;
            int[] d = new int[this.dCount];
            for (i2 = 0; i2 < this.dCount; ++i2) {
                d[i2] = this.Donors[i2];
            }
            this.Donors = new int[this.dCount + j];
            for (i2 = 0; i2 < this.dCount; ++i2) {
                this.Donors[i2] = d[i2];
            }
            for (i2 = this.dCount; i2 < this.dCount + j; ++i2) {
                this.Donors[i2] = td[i2 - this.dCount];
                this.delocAble[td[i2 - this.dCount]] = 1;
            }
            int[] h = new int[this.dCount];
            for (i = 0; i < this.dCount; ++i) {
                h[i] = this.heteroD[i];
            }
            this.heteroD = new int[this.dCount + j];
            for (i = 0; i < this.dCount; ++i) {
                this.heteroD[i] = h[i];
            }
            for (i = this.dCount; i < this.dCount + j; ++i) {
                this.heteroD[i] = td[i - this.dCount];
            }
            this.dCount += j;
        }
    }

    private void addLatentToluolCarbon3() {
        int i;
        int newd = -1;
        boolean find = false;
        int[] z = new int[4];
        int v = 0;
        for (i = 0; i < this.atomCount && !find; ++i) {
            if (this.isDonor(i) || this.protonC[i] != 6 || this.delocAble[i] != -1 || this.cHtab[i].length != 4 || !this.isHExist(i) || !this.isAlphaAraExist(i)) continue;
            this.restrict = false;
            this.calcDelocPath(i, -1, -1);
            int c = this.getUnsaturatedBondCount(i);
            if (this.isHeteroDonorExist(c)) {
                newd = i;
                find = true;
                continue;
            }
            if (!this.rings.isInRing()[i]) continue;
            this.restrict = true;
            z = this.getNbSphereAtoms(this.nbCount[i]);
            find = false;
            for (v = 0; v < 4 && !find; ++v) {
                if (z[v] == -1 || !this.rings.isInRing()[z[v]]) continue;
                this.calcDelocPath(i, z[v], i);
                c = this.getUnsaturatedBondCount(i);
                if (!this.isHeteroDonorExist(c)) continue;
                newd = i;
                find = true;
            }
        }
        if (find) {
            int[] d = new int[this.dCount];
            for (i = 0; i < this.dCount; ++i) {
                d[i] = this.Donors[i];
            }
            this.Donors = new int[this.dCount + 1];
            for (i = 0; i < this.dCount; ++i) {
                this.Donors[i] = d[i];
            }
            this.Donors[this.dCount] = newd;
            this.delocAble[newd] = 1;
            int[] h = new int[this.dCount];
            for (i = 0; i < this.dCount; ++i) {
                h[i] = this.heteroD[i];
            }
            this.heteroD = new int[this.dCount + 1];
            for (i = 0; i < this.dCount; ++i) {
                this.heteroD[i] = h[i];
            }
            this.heteroD[this.dCount] = newd;
            ++this.dCount;
        }
    }

    private boolean isAlphaAraExist(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.atomCount || !this.isArA(nb)) continue;
            return true;
        }
        return false;
    }

    private void addLatentCarbonAliDonors() {
        int[] td = new int[this.atomCount];
        int[] used = new int[this.atomCount];
        int j = 0;
        int k = 0;
        int[] y = new int[4];
        int[] z = new int[4];
        for (int i = 0; i < this.aCount; ++i) {
            int a = this.Acceptors[i];
            if (this.isArA(a) || (y = this.getNewTerminalCarbonDonor(a)) == null) continue;
            int c = 0;
            for (k = 0; y[k] != -1 && k < 4; ++k) {
                this.restrict = false;
                this.calcDelocPath(y[k], -1, -1);
                c = this.getUnsaturatedBondCount(y[k]);
                if (used[y[k]] != 0) continue;
                if (this.isHeteroDonorExist(c)) {
                    td[j] = y[k];
                    used[y[k]] = 1;
                    ++j;
                    continue;
                }
                if (!this.rings.isInRing()[y[k]]) continue;
                this.restrict = true;
                z = this.getNbSphereAtoms(this.nbCount[y[k]]);
                boolean find = false;
                for (int v = 0; v < 4 && !find; ++v) {
                    if (z[v] == -1 || !this.rings.isInRing()[z[v]]) continue;
                    this.calcDelocPath(y[k], z[v], y[k]);
                    c = this.getUnsaturatedBondCount(y[k]);
                    if (!this.isHeteroDonorExist(c)) continue;
                    td[j] = y[k];
                    used[y[k]] = 1;
                    ++j;
                    find = true;
                }
            }
        }
        if (j != 0) {
            int i;
            int i2;
            int[] d = new int[this.dCount];
            for (i2 = 0; i2 < this.dCount; ++i2) {
                d[i2] = this.Donors[i2];
            }
            this.Donors = new int[this.dCount + j];
            for (i2 = 0; i2 < this.dCount; ++i2) {
                this.Donors[i2] = d[i2];
            }
            for (i2 = this.dCount; i2 < this.dCount + j; ++i2) {
                this.Donors[i2] = td[i2 - this.dCount];
                this.delocAble[td[i2 - this.dCount]] = 1;
            }
            int[] h = new int[this.dCount];
            for (i = 0; i < this.dCount; ++i) {
                h[i] = this.heteroD[i];
            }
            this.heteroD = new int[this.dCount + j];
            for (i = 0; i < this.dCount; ++i) {
                this.heteroD[i] = h[i];
            }
            for (i = this.dCount; i < this.dCount + j; ++i) {
                this.heteroD[i] = td[i - this.dCount];
            }
            this.dCount += j;
        }
    }

    private int[] getNbSphereAtoms(int L) {
        int k = 0;
        int[] z = new int[]{-1, -1, -1, -1, -1, -1};
        for (int i = 0; i < this.sphereSize && k < L; ++i) {
            int sa = this.sAtom[i];
            if (this.di[sa][1] != 1) continue;
            z[k] = sa;
            ++k;
        }
        return z;
    }

    private int getUnsaturatedBondCount(int a) {
        int j;
        int c = 0;
        for (int i = 0; i < this.sphereSize; ++i) {
            int sa = this.sAtom[i];
            for (j = 0; j < this.initBonds[sa].length; ++j) {
                if (this.initBonds[sa][j] == 3) {
                    c += 2;
                    continue;
                }
                if (this.initBonds[sa][j] == 1) continue;
                ++c;
            }
        }
        for (j = 0; j < this.initBonds[a].length; ++j) {
            if (this.initBonds[a][j] == 3) {
                c += 2;
                continue;
            }
            if (this.initBonds[a][j] == 1) continue;
            ++c;
        }
        return c / 2;
    }

    private boolean isHeteroExist(int c) {
        int j = 0;
        if (c == 0) {
            return false;
        }
        int y = this.pL;
        if (c < this.pL / 2) {
            y = 2 * c;
        }
        while (j < this.sphereSize) {
            int sa = this.sAtom[j];
            if (this.protonC[sa] != 6 && this.di[sa][1] <= y && !this.isOddNumber(this.di[sa][1]) && (this.isDonor(sa) ? this.isHeteroDCorrect(sa) : this.isHeteroACorrect(sa))) {
                return true;
            }
            ++j;
        }
        return false;
    }

    private boolean isHeteroAcceptorExist(int c) {
        int j = 0;
        if (c == 0) {
            return false;
        }
        int y = this.pL;
        if (c < this.pL / 2) {
            y = 2 * c;
        }
        while (j < this.sphereSize) {
            int sa = this.sAtom[j];
            if (this.protonC[sa] != 6 && this.di[sa][1] <= y && !this.isOddNumber(this.di[sa][1]) && this.isAcceptor(sa) && (this.isArA(sa) ? this.isDoubleBondedAtom(sa) : this.isUnsaturatedAcceptor(sa, this.di[sa][1]))) {
                return true;
            }
            ++j;
        }
        return false;
    }

    private boolean isHeteroDonorExist(int c) {
        int j = 0;
        if (c == 0) {
            return false;
        }
        int y = this.pL;
        if (c < this.pL / 2) {
            y = 2 * c;
        }
        while (j < this.sphereSize) {
            int sa = this.sAtom[j];
            if (this.protonC[sa] != 6 && this.di[sa][1] <= y && !this.isOddNumber(this.di[sa][1]) && (this.isDonor(sa) ? this.isHeteroDCorrect(sa) : this.isAcceptor(sa) && this.isHeteroACorrect(sa))) {
                return true;
            }
            ++j;
        }
        return false;
    }

    private boolean isUnsaturatedAcceptor(int acc, int dist) {
        for (int i = 0; i < this.cHtab[acc].length; ++i) {
            int bt;
            int nb = this.cHtab[acc][i];
            if (nb >= this.atomCount || (bt = this.oMol.getBond(this.bHtab[acc][nb]).getType()) == 1 || this.di[nb][1] >= dist) continue;
            return true;
        }
        return false;
    }

    private int[] getNewTerminalCarbonDonor(int a) {
        int c = 0;
        int k = 0;
        int[] y = new int[]{-1, -1, -1, -1};
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int nb = this.cHtab[a][i];
            if (nb >= this.atomCount) continue;
            if (this.isDonor(nb) || this.isAcceptor(nb)) {
                ++c;
                continue;
            }
            if (this.isArA(nb)) {
                ++c;
                continue;
            }
            if (this.initHCount[nb] == 0 || this.protonC[nb] != 6 || this.cHtab[nb].length != 4) continue;
            y[k] = nb;
            ++k;
        }
        if (c != 0 && k != 0) {
            return y;
        }
        return null;
    }

    private void excludeFalseDonAccAtom() {
        int i;
        int t;
        int a;
        int i2;
        int[] td = new int[this.atomCount];
        int j = 0;
        int[] h = new int[this.dCount];
        for (i2 = 0; i2 < this.dCount; ++i2) {
            a = this.Donors[i2];
            if (this.protonC[a] == 6) {
                if (this.isExcludedAtom(a)) continue;
                this.restrict = false;
                this.calcDelocPath(a, -1, -1);
                t = this.getUnsaturatedBondCount(a);
                if (this.isJustCarbon(a, t)) {
                    this.heteroD[i2] = -1;
                    continue;
                }
                td[j] = a;
                h[j] = this.heteroD[i2];
                ++j;
                continue;
            }
            td[j] = a;
            h[j] = this.heteroD[i2];
            ++j;
        }
        this.dCount = j;
        this.Donors = new int[this.dCount];
        for (i2 = 0; i2 < this.dCount; ++i2) {
            this.Donors[i2] = td[i2];
        }
        this.heteroD = new int[this.dCount];
        for (i2 = 0; i2 < this.dCount; ++i2) {
            this.heteroD[i2] = h[i2];
        }
        int[] ta = new int[this.atomCount];
        int[] ha = new int[this.aCount];
        j = 0;
        for (i = 0; i < this.aCount; ++i) {
            a = this.Acceptors[i];
            if (this.protonC[a] == 6) {
                if (this.isExcludedAtom(a)) continue;
                this.restrict = false;
                this.calcDelocPath(a, -1, -1);
                t = this.getUnsaturatedBondCount(a);
                if (this.isJustCarbon(a, t)) {
                    this.heteroA[i] = -1;
                    continue;
                }
                if (this.isBlockedDBondedAcceptor(a)) {
                    this.heteroA[i] = -1;
                    continue;
                }
                ta[j] = a;
                ha[j] = this.heteroA[i];
                ++j;
                continue;
            }
            ta[j] = a;
            ha[j] = this.heteroA[i];
            ++j;
        }
        this.aCount = j;
        this.Acceptors = new int[this.aCount];
        for (i = 0; i < this.aCount; ++i) {
            this.Acceptors[i] = ta[i];
        }
        this.heteroA = new int[this.aCount];
        for (i = 0; i < this.aCount; ++i) {
            this.heteroA[i] = ha[i];
        }
    }

    private void addExclAraAtoms(int ai) {
        int i;
        int[] ea = new int[this.exclAra];
        for (i = 0; i < this.exclAra; ++i) {
            ea[i] = this.exAra[i];
        }
        this.exAra = new int[this.exclAra + 1];
        for (i = 0; i < this.exclAra; ++i) {
            this.exAra[i] = ea[i];
        }
        this.exAra[this.exclAra] = ai;
        ++this.exclAra;
    }

    private boolean isJustCarbon(int ai, int c) {
        int[] z = new int[4];
        boolean active = this.isActiveAtom(c);
        boolean notIns = false;
        if (!this.insulatorAtom) {
            notIns = true;
        }
        if (!active && (this.rings.isInRing()[ai] || this.isChargedAra(ai))) {
            this.restrict = true;
            z = this.getNbSphereAtoms(this.nbCount[ai]);
            boolean find = false;
            for (int v = 0; v < 4 && !find; ++v) {
                if (z[v] == -1 || !this.rings.isInRing()[z[v]] && !this.isChargedAra(z[v])) continue;
                this.calcDelocPath(ai, z[v], ai);
                c = this.getUnsaturatedBondCount(ai);
                active = this.isActiveAtom(c);
                if (active) {
                    find = true;
                }
                if (this.insulatorAtom) continue;
                notIns = true;
            }
        }
        if (active) {
            return false;
        }
        if (!active) {
            if (this.cHtab[ai].length != 4) {
                if (!this.isTerminalDBCarbonAcceptor(ai) && notIns && !this.isExcludedAtom(ai)) {
                    if (!this.isArA(ai)) {
                        this.exAli[this.exclAli] = ai;
                        ++this.exclAli;
                    } else {
                        this.addExclAraAtoms(ai);
                    }
                }
            } else {
                this.delocAble[ai] = -1;
            }
        }
        return true;
    }

    private boolean isChargedAra(int ai) {
        return this.isArA(ai) && this.atomArray[ai].getCharge() != 0;
    }

    private boolean isTerminalDBCarbonAcceptor(int ai) {
        int c = 0;
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int bt;
            int nb = this.cHtab[ai][i];
            if (nb >= this.atomCount || (bt = this.oMol.getBond(this.bHtab[ai][nb]).getType()) != 2 && bt != 3) continue;
            c = 0;
            for (int j = 0; j < this.cHtab[ai].length; ++j) {
                int nnb = this.cHtab[ai][j];
                if (nnb >= this.atomCount || !this.isDonor(nnb) && !this.isAcceptor(nnb) && !this.isExcludedAtom(nnb)) continue;
                ++c;
            }
        }
        return c == 1;
    }

    private boolean isBlockedDBondedAcceptor(int ai) {
        int c = 0;
        boolean db = false;
        if (this.isDBonded(ai)) {
            db = true;
        }
        if (db) {
            for (int i = 0; i < this.cHtab[ai].length; ++i) {
                int nb = this.cHtab[ai][i];
                if (nb >= this.atomCount) continue;
                if (this.isDonor(nb) || this.isAcceptor(nb)) {
                    ++c;
                    continue;
                }
                if (!this.isExcludedAtom(nb)) continue;
                ++c;
            }
        }
        return c == 0;
    }

    private boolean isTerminalDBondedAtom(int ai) {
        int c = 0;
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.atomCount || !this.isDonor(nb) && !this.isAcceptor(nb) && !this.isExcludedAtom(nb)) continue;
            ++c;
        }
        return c == 1;
    }

    private void excludeTerminalDBondedAtom() {
        int[] exa = new int[this.exclAli];
        int k = 0;
        for (int i = 0; i < this.exclAli; ++i) {
            if (this.isTerminalDBondedAtom(this.exAli[i])) {
                exa[i] = -1;
                ++k;
                continue;
            }
            exa[i] = this.exAli[i];
        }
        if (k != 0) {
            this.exclAli -= k;
            this.exAli = new int[this.exclAli];
            int y = 0;
            for (int i = 0; i < this.exclAli + k; ++i) {
                if (exa[i] == -1) continue;
                this.exAli[y] = exa[i];
                ++y;
            }
        }
    }

    private boolean isActiveAtom(int c) {
        if (c == 0) {
            return false;
        }
        int y = this.pL;
        if (c < this.pL / 2) {
            y = 2 * c;
        }
        boolean active = false;
        this.insulatorAtom = true;
        for (int j = 0; j < this.sphereSize; ++j) {
            int sa = this.sAtom[j];
            if (this.protonC[sa] == 6 || this.di[sa][1] > y) continue;
            if (!this.isOddNumber(this.di[sa][1])) {
                active = true;
            }
            this.insulatorAtom = false;
        }
        return active;
    }

    private boolean isExcludedAtom(int ai) {
        if (this.isArA(ai)) {
            for (int i = 0; i < this.exclAra; ++i) {
                if (this.exAra[i] != ai) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.exclAli; ++i) {
                if (this.exAli[i] != ai) continue;
                return true;
            }
        }
        return false;
    }

    private void setInitHCount() {
        this.initHCount = new int[this.atomCount];
        for (int i = 0; i < this.atomCount; ++i) {
            this.initHCount[i] = this.atomArray[i].getImplicitHcount();
        }
    }

    private void setInitECount() {
        this.initECount = new int[this.atomCount];
        for (int i = 0; i < this.atomCount; ++i) {
            this.initECount[i] = this.delocAble[i] != -1 ? this.getBondingECount(i) : 0;
        }
    }

    private int getBondingECount(int ai) {
        int c = 0;
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.atomCount) continue;
            int bt = this.oMol.getBond(this.bHtab[ai][nb]).getType();
            if (this.delocAble[nb] == -1) continue;
            c += 2 * bt;
        }
        return c;
    }

    private void setNbCount() {
        this.nbCount = new int[this.atomCount];
        for (int i = 0; i < this.atomCount; ++i) {
            this.nbCount[i] = this.cHtab[i].length - this.atomArray[i].getImplicitHcount();
        }
    }

    private void setProtonCount() {
        this.protonC = new int[this.atomCount];
        for (int i = 0; i < this.atomCount; ++i) {
            this.protonC[i] = this.atomArray[i].getAtno();
        }
    }

    private void setMassNumber() {
        this.mass = new double[this.atomCount];
        for (int i = 0; i < this.atomCount; ++i) {
            this.mass[i] = this.atomArray[i].getMass();
        }
    }

    private void setArAtoms() {
        this.aAtom = new int[this.atomCount];
        this.araCount = 0;
        for (int i = 0; i < this.atomCount; ++i) {
            if (!this.oMol.getAtom(i).hasAromaticBond()) continue;
            this.aAtom[i] = 1;
            ++this.araCount;
        }
    }

    private void setInitBonds() {
        this.initBonds = new int[this.atomCount][];
        for (int i = 0; i < this.atomCount; ++i) {
            int s = 0;
            for (int x = 0; x < this.cHtab[i].length; ++x) {
                if (this.cHtab[i][x] >= this.atomCount || this.delocAble[this.cHtab[i][x]] == -1) continue;
                ++s;
            }
            this.initBonds[i] = new int[s];
            int k = 0;
            for (int j = 0; j < this.cHtab[i].length; ++j) {
                int nb = this.cHtab[i][j];
                if (nb >= this.atomCount || this.delocAble[nb] == -1) continue;
                this.initBonds[i][k] = this.oMol.getBond(this.bHtab[i][nb]).getType();
                ++k;
            }
        }
    }

    private void setLPCount() {
        this.initLPCount = new int[this.atomCount];
        this.LPc = new LonePairCounter();
        this.initLPCount = this.LPc.getLonePairCount(this.oMol);
    }

    private void setRCount() {
        this.radicalExist = false;
        this.initRCount = new int[this.atomCount];
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.protonC[i] == 130) continue;
            int rc = this.atomArray[i].getRadical();
            switch (rc) {
                case 1: {
                    rc = 1;
                    break;
                }
                case 2: {
                    rc = 2;
                    break;
                }
                case 3: {
                    rc = 3;
                    break;
                }
                case 7: {
                    rc = 3;
                    break;
                }
                case 11: {
                    rc = 3;
                    break;
                }
                case 6: {
                    rc = 2;
                    break;
                }
                case 10: {
                    rc = 2;
                    break;
                }
                default: {
                    rc = 0;
                }
            }
            if (rc != 0) {
                this.radicalExist = true;
            }
            this.initRCount[i] = rc;
        }
        if (this.getResStructures) {
            this.radicalExist = true;
        }
    }

    protected int getRadCount(int tindex) {
        if (this.radicalExist) {
            int rc = 0;
            if (tindex == this.tautomerCount) {
                for (int i = 0; i < this.atomCount; ++i) {
                    rc += this.initRCount[i];
                }
            } else {
                for (int i = 0; i < this.atomCount; ++i) {
                    rc += this.getResonantRCount(i, tindex);
                }
            }
            return rc;
        }
        return 0;
    }

    private void initSimpleTauCreation() {
        this.baseTautomer = true;
        this.latentTCreation = false;
        this.DDorAACouple = false;
        this.tautomerType = 1;
    }

    private void createSimpleTautomers() {
        int d;
        int a;
        int j;
        int i;
        this.initSimpleTauCreation();
        for (i = 0; i < this.dCount && !this.isTauStop(); ++i) {
            for (j = 0; j < this.aCount && !this.isTauStop(); ++j) {
                a = this.Acceptors[j];
                d = this.Donors[i];
                if (this.IslandIndex[a] != this.IslandIndex[d]) continue;
                this.createDelocIsland(d, a);
                a = this.Donors[i];
                d = this.Acceptors[j];
                this.createDelocIsland(d, a);
            }
        }
        this.DDorAACouple = true;
        for (i = 0; i < this.dCount - 1 && !this.isTauStop(); ++i) {
            for (j = i + 1; j < this.dCount && !this.isTauStop(); ++j) {
                a = this.Donors[j];
                d = this.Donors[i];
                if (this.IslandIndex[a] != this.IslandIndex[d]) continue;
                this.createDelocIsland(d, a);
                a = this.Donors[i];
                d = this.Donors[j];
                this.createDelocIsland(d, a);
            }
        }
        for (i = 0; i < this.aCount - 1 && !this.isTauStop(); ++i) {
            for (j = i + 1; j < this.aCount && !this.isTauStop(); ++j) {
                a = this.Acceptors[j];
                d = this.Acceptors[i];
                if (this.IslandIndex[a] != this.IslandIndex[d]) continue;
                this.createDelocIsland(d, a);
                a = this.Acceptors[i];
                d = this.Acceptors[j];
                this.createDelocIsland(d, a);
            }
        }
        if (this.tautomerCount != 0 && !this.latentTauStop) {
            this.setReverseLPath(this.latentTauCount);
        }
    }

    private void setDonorType(int don, int ti) {
        this.donorType = new int[6];
        for (int i = 0; i < 6; ++i) {
            this.donorType[i] = -1;
        }
        int donNb = this.tPath[ti][this.tPath[ti].length - 2];
        int acc = this.tPath[ti][0];
        int accNb = this.tPath[ti][1];
        int lpc = this.getParentLPCount(don);
        int dbc = 0;
        int pchg = 0;
        this.methylDonor = false;
        this.actMultiplicity = 1;
        if (this.radicalExist && this.getParentRCount(don) > 0) {
            this.donorType[4] = 8;
            this.donorType[5] = 7;
            if (this.getBondType(acc, accNb) > 1) {
                this.donorType[0] = 1;
            }
            this.actMultiplicity = 6;
        }
        if (this.getResStructures) {
            this.actMultiplicity = 6;
            pchg = this.getParentCharge(don);
            dbc = this.getParentBType(don, donNb);
            if (lpc > 0) {
                this.donorType[1] = 3;
            }
            if (pchg < 0) {
                if (lpc > 0) {
                    this.donorType[1] = 3;
                } else if (dbc > 1) {
                    this.donorType[2] = 2;
                    if (this.donorType[0] == 1) {
                        this.donorType[3] = 6;
                    }
                }
            }
            if (dbc > 1) {
                if (pchg == 0 || pchg > 0) {
                    this.donorType[2] = 2;
                }
                if (this.donorType[0] == 1) {
                    this.donorType[3] = 6;
                }
            }
            if (pchg == 0) {
                if (this.isSingleBonded(don)) {
                    if (this.protonC[don] != 6 && lpc > 0) {
                        this.donorType[1] = 3;
                    }
                } else {
                    this.donorType[2] = dbc > 1 ? 2 : 2;
                }
            }
        } else if (this.chargeFlag || this.radicalExist) {
            pchg = this.getParentCharge(don);
            dbc = this.getBondType(don, donNb);
            if (this.donorType[0] != 1) {
                if (pchg < 0) {
                    if (lpc != 0) {
                        if (this.isRightLP(don)) {
                            this.donorType[0] = 3;
                        } else if (dbc > 1) {
                            this.donorType[0] = 2;
                        }
                    } else if (dbc > 1) {
                        this.donorType[0] = 2;
                    }
                } else if (pchg == 0) {
                    if (this.isSingleBonded(don)) {
                        if (this.protonC[don] == 6 && this.getParentHCount(don) != 0) {
                            this.methylDonor = true;
                            this.donorType[0] = 3;
                        } else if (lpc > 0) {
                            this.donorType[0] = 3;
                        }
                    } else if (dbc > 1) {
                        this.donorType[0] = 2;
                    } else if (dbc == 1 && this.protonC[don] == 16 && this.getParentHCount(don) != 0) {
                        this.donorType[0] = 3;
                    }
                }
            } else if (dbc > 1 && don == accNb) {
                this.donorType[0] = 6;
            }
        } else if (this.isSingleBonded(don)) {
            if (this.protonC[don] == 6 && this.getParentHCount(don) != 0) {
                this.methylDonor = true;
                this.donorType[0] = 3;
            } else if (lpc > 0) {
                if (this.getParentHCount(don) != 0) {
                    this.donorType[0] = 3;
                }
            } else if (this.protonC[don] > 10 && this.getParentHCount(don) != 0) {
                this.methylDonor = true;
                this.donorType[0] = 3;
            }
        } else if (lpc > 0) {
            if (this.getParentHCount(don) != 0 && this.isTerminalKetene(don)) {
                this.donorType[0] = 3;
            }
        } else if (this.isCHdbX(don)) {
            this.donorType[0] = 3;
        }
    }

    private boolean isCHdbX(int a) {
        if (this.isArA(a)) {
            return false;
        }
        if (this.getParentHCount(a) == 0) {
            return false;
        }
        if (this.protonC[a] == 6) {
            if (this.nbCount[a] != 2) {
                return false;
            }
            for (int i = 0; i < this.cHtab[a].length; ++i) {
                int bt;
                int nb = this.cHtab[a][i];
                if (nb >= this.atomCount || (bt = this.getParentBType(nb, a)) != 2) continue;
                return true;
            }
        }
        return true;
    }

    private boolean isTerminalKetene(int a) {
        if (this.protonC[a] != 7) {
            return false;
        }
        if (this.nbCount[a] != 1) {
            return false;
        }
        return this.isParentTerminalKetene(a);
    }

    private boolean isParentTerminalKetene(int a) {
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int nb = this.cHtab[a][i];
            if (nb >= this.atomCount) continue;
            if (this.protonC[nb] > 7) {
                return false;
            }
            int bt = this.getParentBType(nb, a);
            if (bt == -1) {
                return false;
            }
            if (bt != 2) continue;
            for (int j = 0; j < this.cHtab[nb].length; ++j) {
                int nnb = this.cHtab[nb][j];
                if (nnb >= this.atomCount || nnb == a || (bt = this.getParentBType(nnb, nb)) != 2) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isResonantTerminalKetene(int a, int ti) {
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int nb = this.cHtab[a][i];
            if (nb >= this.atomCount) continue;
            if (this.protonC[nb] > 7) {
                return false;
            }
            int bt = this.getResonantBondType(nb, a, ti);
            if (bt == -1) {
                return false;
            }
            if (bt != 2) continue;
            for (int j = 0; j < this.cHtab[nb].length; ++j) {
                int nnb = this.cHtab[nb][j];
                if (nnb >= this.atomCount || nnb == a || (bt = this.getResonantBondType(nnb, nb, ti)) != 2) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRightLP(int don) {
        return !this.isArA(don) || this.isSingleBonded(don);
    }

    private boolean isHSender(int don) {
        if (!this.getResStructures) {
            if (this.methylDonor) {
                return true;
            }
            if (this.ActDonorType == 3 && this.ActAcceptorType == 3) {
                if (this.getParentCharge(don) < 0) {
                    return false;
                }
                if (this.getParentHCount(don) != 0) {
                    return true;
                }
            }
        }
        return false;
    }

    private void setAcceptorType(int acc, int ti) {
        int accNb = this.tPath[ti][1];
        int don = this.tPath[ti][this.tPath[ti].length - 1];
        this.acceptorType = new int[6];
        for (int i = 0; i < 6; ++i) {
            this.acceptorType[i] = -1;
        }
        int accType = -1;
        boolean find = false;
        int QUESTION = -2;
        boolean RadAcc = false;
        if (this.chargeFlag || this.radicalExist) {
            if (this.getParentRCount(acc) > 0) {
                RadAcc = true;
            }
            if (this.getParentCharge(acc) > 0) {
                if (this.getBondType(acc, accNb) > 1) {
                    if (don == accNb) {
                        accType = QUESTION;
                        find = true;
                    } else {
                        accType = this.isSingleBonded(acc) ? 4 : 5;
                        find = true;
                    }
                } else {
                    accType = 4;
                    find = true;
                }
            } else if (this.getBondType(acc, accNb) > 1) {
                accType = 3;
                find = true;
            } else if (this.isNeutralHole(acc, ti)) {
                accType = 4;
                find = true;
            }
        } else if (this.getBondType(acc, accNb) > 1) {
            accType = 3;
            find = true;
        } else if (this.isNeutralHole(acc, ti)) {
            accType = 4;
            find = true;
        }
        if (!find) {
            accType = 3;
        }
        for (int i = 0; i < this.actMultiplicity; ++i) {
            if (this.donorType[i] == 8) {
                if (don == accNb && RadAcc) {
                    this.acceptorType[i] = 8;
                } else {
                    this.donorType[i] = -1;
                }
            } else if (this.donorType[i] == 3 && accType == QUESTION) {
                this.acceptorType[i] = 4;
            } else if (this.donorType[i] == 6) {
                if (don == accNb) {
                    this.acceptorType[i] = 6;
                } else {
                    this.donorType[i] = -1;
                }
            } else {
                this.acceptorType[i] = accType == QUESTION ? 5 : accType;
            }
            if (this.donorType[i] == 1 && don == accNb && accType != 1) {
                this.donorType[i] = -1;
                this.acceptorType[i] = -1;
            }
            if (this.donorType[i] != 7) continue;
            if (don == accNb) {
                if (RadAcc) {
                    this.acceptorType[i] = 7;
                    continue;
                }
                this.donorType[i] = -1;
                this.acceptorType[i] = -1;
                continue;
            }
            this.donorType[i] = -1;
            this.acceptorType[i] = -1;
        }
    }

    private boolean isNeutralHole(int a, int ti) {
        int be;
        return this.getParentLPCount(a) == 0 && this.getParentRCount(a) == 0 && this.isOpenShell(a, be = this.getBondingECount(a, ti));
    }

    private int getBondingECount(int a, int ti) {
        int be = 2 * this.getParentECount(a);
        be += 2 * this.getParentHCount(a);
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int nb = this.cHtab[a][i];
            if (nb >= this.atomCount || this.delocAble[nb] != -1) continue;
            be += 2 * this.oMol.getBond(this.bHtab[a][nb]).getType();
        }
        return be;
    }

    private int getValenceCount(int a, int ti) {
        int ai = this.getDonAccIndex(a);
        if (ai == -1) {
            return -1;
        }
        int RAD1Count = 0;
        int RAD2Count = 0;
        if (this.radicalExist) {
            RAD1Count = this.tRCount[ti][ai];
        }
        if (this.chargeFlag || this.radicalExist) {
            RAD2Count = this.implicitRCount[ti][ai];
        }
        int lpc = this.tLPCount[ti][ai];
        int be = 2 * this.tECount[ti][a];
        be += 2 * this.tHCount[ti][ai];
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int nb = this.cHtab[a][i];
            if (nb >= this.atomCount || this.delocAble[nb] != -1) continue;
            be += 2 * this.oMol.getBond(this.bHtab[a][nb]).getType();
        }
        return be += RAD1Count + 2 * lpc + RAD2Count;
    }

    private boolean isOpenShell(int a, int ve) {
        return this.protonC[a] <= 10 ? ve < 8 : (this.gn[this.protonC[a]] > 5 ? ve < 12 : this.gn[this.protonC[a]] <= 5 && ve < 10);
    }

    private boolean isRightShell(int ai, int ti) {
        int a = this.getDonAccAtom(ai);
        if (!this.isPathAtom(a, ti)) {
            return true;
        }
        if (this.radicalExist && this.getParentRCount(a) > 0) {
            return true;
        }
        int ve = this.getValenceCount(a, ti);
        if (this.protonC[a] <= 10) {
            if (ve == 8) {
                return true;
            }
            if (ve < 8) {
                return this.protonC[a] == 6;
            }
        } else if (this.gn[this.protonC[a]] > 5 ? ve <= 12 && !this.isOddNumber(ve) : this.gn[this.protonC[a]] <= 5 && ve <= 10 && !this.isOddNumber(ve)) {
            return true;
        }
        return false;
    }

    private void storeSimpleADorAAorDD(int d, int a, int ti) {
        int actT = this.tautomerCount;
        int ai = this.getDonAccIndex(a);
        int di = this.getDonAccIndex(d);
        this.tAtoms[actT][ai] = 1;
        this.tAtoms[actT][di] = -1;
        boolean lpStored = false;
        boolean find = false;
        this.setDonorType(d, actT);
        this.setAcceptorType(a, actT);
        this.TauCreated = false;
        this.ActAcceptorType = -1;
        this.ActDonorType = -1;
        if (this.isAllowedCouple(d, a, actT)) {
            for (int i = 0; i < this.actMultiplicity && !this.isTauStop(); ++i) {
                this.ActDonorType = this.donorType[i];
                this.ActAcceptorType = this.acceptorType[i];
                this.latentTautomer = false;
                this.TauCreated = false;
                if (this.ActDonorType != -1) {
                    this.CopyPath(actT, ti);
                    this.setTautomer(actT);
                    if (this.isTautomerRight(actT)) {
                        this.setSimpleTauCounter(actT, d, a);
                        this.tauCouples[actT][0] = 0;
                        this.tauCouples[actT][1] = 0;
                    }
                }
                if (!this.TauCreated && !lpStored) {
                    this.latentTautomer = true;
                    this.storeLatentPath(d, a, actT);
                    lpStored = true;
                }
                if (!this.TauCreated) continue;
                find = true;
                if (!lpStored) {
                    this.latentTautomer = true;
                    this.storeLatentPath(d, a, actT);
                    lpStored = true;
                }
                actT = this.tautomerCount;
                this.tAtoms[actT][ai] = 1;
                this.tAtoms[actT][di] = -1;
            }
            this.resetTa(actT);
        } else {
            this.resetTa(actT);
            this.latentTautomer = true;
            this.storeLatentPath(d, a, actT);
        }
        this.setTauStop(this.tautomerCount);
        if (find) {
            this.TauCreated = true;
        }
    }

    private void CopyPath(int tnew, int texist) {
        if (this.tPath[tnew] == null) {
            int L = this.tPath[texist].length;
            this.tPath[tnew] = new int[L];
            for (int i = 0; i < L; ++i) {
                this.tPath[tnew][i] = this.tPath[texist][i];
            }
        }
    }

    private void setSimpleTauCounter(int ti, int d, int a) {
        int ac;
        if (this.chargeFlag) {
            this.setBaseTauCharge(ti);
        }
        this.setBaseHCount(ti);
        this.setTauLPCount(ti);
        if (this.getResStructures && this.getMajorRestructures && !this.falseTautomer) {
            this.isLowEnergyLewisStructure(ti);
        }
        if (!this.getResStructures && this.protectRadicalCount) {
            this.isRadicalCountChanged(ti);
        }
        if (!this.falseTautomer && !this.getResStructures && this.protectAromacity && !this.oneCR4Allowed && this.araCount > (ac = this.getAromaticAtomCount(ti))) {
            this.falseTautomer = true;
        }
        if (!this.falseTautomer && !this.getResStructures && this.excludeAntiAromaticity) {
            this.isAntiAromatic(ti);
        }
        if (!this.falseTautomer && !this.isTauExistYet(ti)) {
            ++this.tautomerCount;
            this.TauCreated = true;
        }
    }

    private void isLowEnergyLewisStructure(int ti) {
        int size = this.dCount + this.aCount;
        int i = 0;
        if (this.isRadicalCountIncreased(ti)) {
            this.falseTautomer = true;
        }
        if (this.isChgCountDecreased(ti)) {
            return;
        }
        if (this.isRadCountDecreased(ti)) {
            return;
        }
        if (!this.getResStructures && this.isAromationBreaked(ti)) {
            this.falseTautomer = true;
        }
        if (this.isMultiChargeFormed(ti)) {
            this.falseTautomer = true;
        }
        if (this.isRingKetenFormed(ti)) {
            this.falseTautomer = true;
        }
        while (i < size && !this.falseTautomer) {
            if (!this.isRightShell(i, ti) && !this.isNO2Form(i, ti)) {
                this.falseTautomer = true;
            }
            if (this.isChargeRepulsionCouple(i, ti)) {
                this.falseTautomer = true;
            }
            if (this.isCarbonChegedBond(i, ti)) {
                this.falseTautomer = true;
            }
            if (this.tautomerType != 2 && this.isAllowedChargeFormation(i, ti)) {
                this.falseTautomer = true;
            }
            ++i;
        }
    }

    private boolean isChgCountDecreased(int ti) {
        if (this.tautomerType != 2) {
            int size = this.dCount + this.aCount;
            int pChgCount = 0;
            int cChgCount = 0;
            for (int i = 0; i < size; ++i) {
                int a = this.getDonAccAtom(i);
                int c = this.getParentCharge(a);
                pChgCount = c < 0 ? (pChgCount += -1 * c) : (pChgCount += c);
                c = this.getResonantCharge(a, ti);
                if (c < 0) {
                    cChgCount += -1 * c;
                    continue;
                }
                cChgCount += c;
            }
            if (cChgCount < pChgCount) {
                return true;
            }
        }
        return false;
    }

    private boolean isRadCountDecreased(int ti) {
        if (this.tautomerType != 2) {
            int size = this.dCount + this.aCount;
            int pRCount = 0;
            int cRCount = 0;
            for (int i = 0; i < size; ++i) {
                int a = this.getDonAccAtom(i);
                int c = this.getParentRCount(a);
                pRCount = c < 0 ? (pRCount += -1 * c) : (pRCount += c);
                c = this.getResonantRCount(a, ti);
                if (c < 0) {
                    cRCount += -1 * c;
                    continue;
                }
                cRCount += c;
            }
            if (cRCount < pRCount) {
                return true;
            }
        }
        return false;
    }

    private boolean isNO2Form(int ai, int ti) {
        int a = this.getDonAccAtom(ai);
        int bc = this.getBECount(a, ai, ti);
        return this.isNO2TypeForm(a, bc, ti);
    }

    private boolean isAromationBreaked(int ti) {
        int z = 0;
        int y = 0;
        for (int i = 0; i < this.atomCount; ++i) {
            boolean valid;
            if (this.tCtab[ti][i] == null || !this.isArA(i)) continue;
            if (this.protonC[i] == 6) {
                boolean pe = false;
                if (this.isParentCarbonExocylic(i)) {
                    ++z;
                    pe = true;
                }
                boolean che = false;
                if (this.isChildCarbonExocylic(i, ti)) {
                    ++y;
                    che = true;
                }
                boolean bl = valid = this.getResonantCharge(i, ti) != 0 || this.isPzBondExist(i, ti) || this.isHiddenHole(i, ti) || pe || che;
                if (valid) continue;
                return true;
            }
            if (this.protonC[i] != 7) continue;
            boolean bl = valid = this.getResonantLPCount(i, ti) != 0 || this.getResonantCharge(i, ti) < 0 || this.isPzBondExist(i, ti) || this.isNPlusHole(i, ti);
            if (valid) continue;
            return true;
        }
        return (z != 0 || y != 0) && z != y;
    }

    private boolean isPzBondExist(int i, int ti) {
        for (int j = 0; j < this.tCtab[ti][i].length; ++j) {
            int a2 = this.tCtab[ti][i][j];
            if (this.tBtab[ti][i][j] != 2 || !this.isArA(a2)) continue;
            return true;
        }
        return false;
    }

    private boolean isDoubleBondedAtom(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int bt;
            int nb = this.cHtab[ai][i];
            if (nb >= this.atomCount || (bt = this.oMol.getBond(this.bHtab[ai][nb]).getType()) < 2) continue;
            return true;
        }
        return false;
    }

    private boolean isHiddenHole(int i, int ti) {
        for (int j = 0; j < this.tCtab[ti][i].length; ++j) {
            int a2 = this.tCtab[ti][i][j];
            if (this.tBtab[ti][i][j] != 2 || this.isArA(a2)) continue;
            int en1 = MolAtom.electronegOf(this.protonC[i]);
            int en2 = MolAtom.electronegOf(this.protonC[a2]);
            if (en2 <= en1) continue;
            return !this.rings.isInRing()[a2];
        }
        return false;
    }

    private boolean isParentCarbonExocylic(int a) {
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int bt;
            int nb = this.cHtab[a][i];
            if (nb >= this.atomCount || this.isArA(nb) || this.protonC[nb] != 6 || (bt = this.getParentBType(nb, a)) != 2) continue;
            this.AraOx = nb;
            return true;
        }
        return false;
    }

    private boolean isChildCarbonExocylic(int a, int tChild) {
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int bt;
            int nb = this.cHtab[a][i];
            if (nb >= this.atomCount || this.isArA(nb) || this.protonC[nb] != 6 || (bt = this.getResonantBondType(a, nb, tChild)) != 2) continue;
            this.AraOx = nb;
            return true;
        }
        return false;
    }

    private boolean isNPlusHole(int a, int ti) {
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int bt;
            int nb = this.cHtab[a][i];
            if (nb >= this.atomCount || (bt = this.getResonantBondType(a, nb, ti)) == 1) continue;
            return false;
        }
        return this.getResonantCharge(a, ti) > 0;
    }

    private boolean isMultiChargeFormed(int ti) {
        int size = this.dCount + this.aCount;
        for (int i = 0; i < size; ++i) {
            int chg;
            int ai = this.getDonAccAtom(i);
            if (this.protonC[ai] > 10 || (chg = this.getResonantCharge(ai, ti)) < 2 && chg > -2) continue;
            return true;
        }
        return false;
    }

    private boolean isRingKetenFormed(int ti) {
        int size = this.dCount + this.aCount;
        for (int i = 0; i < size; ++i) {
            int ai = this.getDonAccAtom(i);
            int c = 0;
            if (!this.rings.isInRing()[ai] || this.tCtab[ti][ai] == null) continue;
            for (int j = 0; j < this.cHtab[ai].length; ++j) {
                int bt;
                int nb = this.cHtab[ai][j];
                if (nb >= this.atomCount || !this.rings.isInRing()[nb] || (bt = this.getResonantBondType(ai, nb, ti)) < 2) continue;
                ++c;
            }
            if (c < 2) continue;
            return true;
        }
        return false;
    }

    private boolean isRadicalCountIncreased(int ti) {
        if (this.radicalExist) {
            int size = this.dCount + this.aCount;
            int rc = 0;
            int ac = 0;
            for (int i = 0; i < size; ++i) {
                int a = this.getDonAccAtom(i);
                rc += this.getResonantRCount(a, ti) + this.implicitRCount[ti][i];
                ac += this.initRCount[a];
            }
            if (rc > ac) {
                return true;
            }
        }
        return false;
    }

    private boolean isChargeRepulsionCouple(int ai, int ti) {
        int a = this.getDonAccAtom(ai);
        int chg = this.getResonantCharge(a, ti);
        if (chg == 0) {
            return false;
        }
        if (this.isKetenBreaked(a, ti)) {
            return false;
        }
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int nb = this.cHtab[a][i];
            if (nb >= this.atomCount) continue;
            int chgNb = this.getResonantCharge(nb, ti);
            if ((chg >= 0 || chgNb >= 0) && (chg <= 0 || chgNb <= 0)) continue;
            if (this.isKetenBreaked(nb, ti)) {
                return false;
            }
            if (this.isThisInitChg(a, nb)) continue;
            return true;
        }
        return false;
    }

    private boolean isThisInitChg(int a1, int a2) {
        return -this.initCharge[a1] == -this.initCharge[a2];
    }

    private boolean isKetenBreaked(int ai, int ti) {
        return this.isParentTerminalKetene(ai) && !this.isResonantTerminalKetene(ai, ti);
    }

    private boolean isCarbonChegedBond(int ai, int ti) {
        int a = this.getDonAccAtom(ai);
        int chg = this.getResonantCharge(a, ti);
        if (chg == 0) {
            return false;
        }
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int chgNb;
            int nb = this.cHtab[a][i];
            if (nb >= this.atomCount || chg == (chgNb = this.getResonantCharge(nb, ti)) || chgNb == 0 || this.protonC[a] != 6 || this.protonC[a] != this.protonC[nb]) continue;
            return true;
        }
        return false;
    }

    private boolean isAllowedChargeFormation(int ai, int ti) {
        int L = this.tPath[ti].length;
        int don = this.tPath[ti][L - 1];
        int acc = this.tPath[ti][0];
        int donChg = this.getResonantCharge(don, ti);
        int accChg = this.getResonantCharge(acc, ti);
        if (donChg != 0 && accChg != 0 && this.ActDonorType == 2 && this.ActAcceptorType == 3) {
            int Endon;
            int Enacc = MolAtom.electronegOf(this.protonC[acc]);
            if (Enacc < (Endon = MolAtom.electronegOf(this.protonC[don]))) {
                return true;
            }
            if (Enacc == Endon) {
                return true;
            }
        }
        return false;
    }

    private void setReverseLPath(int ltc) {
        for (int i = 0; i < ltc && !this.latentTauStop; ++i) {
            int L = this.latentPath[i].length;
            if (this.isReverseLPathStoredYet(this.latentPath[i][L - 1], this.latentPath[i][0], i, ltc)) continue;
            this.latentPath[this.latentTauCount] = new int[L];
            for (int j = 0; j < L; ++j) {
                this.latentPath[this.latentTauCount][j] = this.latentPath[i][L - 1 - j];
            }
            ++this.latentTauCount;
            this.setLatentTauStop(this.latentTauCount);
        }
    }

    private void createCombinedTautomers() {
        if (this.resChgCalc) {
            return;
        }
        this.tautomerType = 2;
        if (this.tautomerCount != 0) {
            this.baseTautomer = false;
            int actTCount = this.tautomerCount;
            boolean search = true;
            int p2 = 0;
            while (search && !this.isTauStop()) {
                boolean find = false;
                for (int i = 0; i < actTCount && !this.isTauStop(); ++i) {
                    for (int j = p2; j < actTCount && !this.isTauStop(); ++j) {
                        if (i == j) continue;
                        this.parentT1 = i;
                        this.parentT2 = j;
                        if (!this.isNewADCombination(i, j)) continue;
                        this.addTautomers(i, j);
                        if (!this.falseTautomer) {
                            this.tauCouples[this.tautomerCount][0] = this.parentT1;
                            this.tauCouples[this.tautomerCount][1] = this.parentT2;
                            ++this.tautomerCount;
                            this.setTauStop(this.tautomerCount);
                            find = true;
                            continue;
                        }
                        this.resetTa(this.tautomerCount);
                    }
                }
                if (!find) {
                    search = false;
                    continue;
                }
                p2 = actTCount;
                actTCount = this.tautomerCount;
            }
        }
    }

    private void countRingChainTautomers() {
        int tc = this.getTCount();
        this.tRingCount = 0;
        int g = 0;
        this.rsize = new int[2];
        this.rsize[0] = 5;
        this.rsize[1] = 6;
        int L = this.rsize.length;
        this.ringTauInfo = new int[tc][L];
        this.ringTauCounter = new int[tc][L];
        for (int j = 0; j < L; ++j) {
            for (int i = 0; i < tc; ++i) {
                int y = this.getConvertedTauIndex(i);
                g = this.tRingCount;
                this.countRingChainTautomers(this.oMol, y, this.rsize[j]);
                int[] nArray = this.ringTauInfo[i];
                int n = j;
                nArray[n] = nArray[n] + (this.tRingCount - g);
            }
        }
    }

    private void countRingChainTautomers(Molecule m, int texist, int size) {
        int j = 0;
        for (int i = 0; i < this.atomCount; ++i) {
            boolean bt;
            int hc;
            int lpc;
            if (texist != -1) {
                lpc = this.getResonantLPCount(i, texist);
                hc = this.getResonantHCount(i, texist);
            } else {
                lpc = this.initLPCount[i];
                hc = this.initHCount[i];
            }
            if (this.isArA(i) || lpc == 0 || this.rings.isInRing()[i] || hc <= 0 || (bt = texist != -1 ? this.isResonantDBExist(i, texist) : this.isDBonded(i))) continue;
            this.getChain(m, i);
            j = 0;
            while (j < this.sphereSize) {
                int sa = this.sAtom[j];
                if (this.di[sa][1] == 1 && this.isArA(sa)) {
                    j = this.sphereSize;
                    continue;
                }
                if (this.di[sa][1] == size - 1) {
                    int type = this.polarGroups.carboxy[sa];
                    int gIndx = this.polarGroups.groupIndex[sa];
                    MolAtom u = m.getAtom(sa);
                    if ((type == 1 || type == 200 || type == 300 || type == 2 || type == 500) && u.getSymbol().equals("C") && (bt = texist != -1 ? this.isResonantDBExist(sa, texist) : this.isDBonded(sa))) {
                        int x = this.getActAtomIndex();
                        int type2 = this.polarGroups.carboxy[x];
                        int gIndx2 = this.polarGroups.groupIndex[x];
                        if (type == type2 && gIndx == gIndx2) {
                            ++this.tRingCount;
                        }
                    }
                }
                ++j;
            }
        }
    }

    private boolean isResonantDBExist(int ai, int texist) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.atomCount || this.getResonantBondType(ai, nb, texist) <= 1) continue;
            this.setActAtomIndex(nb);
            return true;
        }
        return false;
    }

    private void setActAtomIndex(int ai) {
        this.actAtomIndx = ai;
    }

    private int getActAtomIndex() {
        return this.actAtomIndx;
    }

    private void setRingTauFlag(boolean rts) {
        this.ringTauStep = rts;
    }

    private boolean getRingTauFlag() {
        return this.ringTauStep;
    }

    private void setParentTauIndex(int ri) {
        this.tRIndex = ri;
    }

    private int calcParentTauIndex(int rIndex) {
        int y = rIndex - this.tautomerCount;
        int tauIndx = rIndex;
        this.setRingTauFlag(false);
        int L = this.rsize.length;
        if (y > 0) {
            int i;
            int sum = 0;
            for (i = 0; i <= this.tautomerCount && sum < y; ++i) {
                for (int j = 0; j < L; ++j) {
                    sum += this.ringTauInfo[i][j];
                }
            }
            tauIndx = i - 1;
            this.setRingTauFlag(true);
        }
        this.setParentTauIndex(tauIndx);
        return tauIndx;
    }

    private void setActRingLpAtom(int i) {
        this.actRingLpAtom = i;
    }

    private int getActRingLpAtom() {
        return this.actRingLpAtom;
    }

    private void setActTindex(int i) {
        this.actTindex = i;
    }

    private int getActTindex() {
        return this.actTindex;
    }

    private void createRingChainTautomers(Molecule m, int texist) {
        int s;
        int j = 0;
        int actCount = 0;
        if (texist == -1) {
            s = this.getTCount() - this.tRingCount - 1;
        } else {
            s = texist;
            s = this.getActTindex();
        }
        if (s >= this.ringTauCounter.length) {
            return;
        }
        int actSize = 5;
        int sizeIndex = 0;
        boolean find = false;
        for (int k = 0; k < this.rsize.length && !find; ++k) {
            if (this.ringTauCounter[s][k] == this.ringTauInfo[s][k]) continue;
            actSize = this.rsize[k];
            sizeIndex = k;
            find = true;
        }
        for (int i = 0; i < this.atomCount; ++i) {
            boolean bt;
            int hc;
            int lpc;
            if (texist != -1) {
                lpc = this.getResonantLPCount(i, texist);
                hc = this.getResonantHCount(i, texist);
            } else {
                lpc = this.initLPCount[i];
                hc = this.initHCount[i];
            }
            if (this.isArA(i) || lpc == 0 || this.rings.isInRing()[i] || hc <= 0 || (bt = texist != -1 ? this.isResonantDBExist(i, texist) : this.isDBonded(i))) continue;
            this.getChain(m, i);
            j = 0;
            this.setActRingLpAtom(i);
            while (j < this.sphereSize) {
                int sa = this.sAtom[j];
                if (this.di[sa][1] == 1 && this.isArA(sa)) {
                    j = this.sphereSize;
                    continue;
                }
                if (this.di[sa][1] == actSize - 1) {
                    int type = this.polarGroups.carboxy[sa];
                    int gIndx = this.polarGroups.groupIndex[sa];
                    MolAtom u = m.getAtom(sa);
                    if ((type == 1 || type == 200 || type == 300 || type == 2 || type == 500) && u.getSymbol().equals("C") && (bt = texist != -1 ? this.isResonantDBExist(sa, texist) : this.isDBonded(sa))) {
                        int x = this.getActAtomIndex();
                        int type2 = this.polarGroups.carboxy[x];
                        int gIndx2 = this.polarGroups.groupIndex[x];
                        if (type == type2 && gIndx == gIndx2) {
                            if (this.ringTauCounter[s][sizeIndex] == actCount) {
                                this.reduceBondOrder(m, sa);
                                MolAtom a = m.getAtom(sa);
                                MolAtom g = m.getAtom(i);
                                MolBond b = new MolBond(a, g);
                                m.add(b);
                                MolAtom at = m.getAtom(i);
                                hc = at.getImplicitHcount();
                                if (hc != 0) {
                                    at.setImplicitHcount(hc - 1);
                                }
                                int[] nArray = this.ringTauCounter[s];
                                int n = sizeIndex;
                                nArray[n] = nArray[n] + 1;
                                this.setActRingLpAtom(i);
                                return;
                            }
                            ++actCount;
                        }
                    }
                }
                ++j;
            }
        }
    }

    private void reduceBondOrder(Molecule m, int ai) {
        MolAtom a = m.getAtom(ai);
        int bc = a.getBondCount();
        for (int j = 0; j < bc; ++j) {
            MolBond b = a.getBond(j);
            int bt = b.getType();
            if (bt <= 1) continue;
            b.setFlags(bt - 1);
            return;
        }
    }

    private void createLatentTautomers() {
        if (this.resChgCalc) {
            return;
        }
        this.latentTCreation = true;
        this.baseTautomer = true;
        this.tautomerType = 3;
        this.itStep = true;
        if (this.tautomerCount == 0) {
            this.itStep = false;
        }
        while (this.itStep) {
            this.itStep = false;
            for (int i = 0; i < this.latentTauCount && !this.isTauStop(); ++i) {
                this.makeLatentTau(i, this.tautomerCount);
            }
        }
    }

    private void makeLatentTau(int i, int actTCount) {
        this.setLatentPath(i, actTCount);
        for (int j = 0; j < this.tautomerCount && !this.isTauStop(); ++j) {
            boolean latentPTauAble = this.isLatentPathExist(i, j, actTCount);
            if (!latentPTauAble) continue;
            for (int k = 0; k < this.actMultiplicity && !this.isTauStop(); ++k) {
                this.ActDonorType = this.donorType[k];
                this.ActAcceptorType = this.acceptorType[k];
                if (this.ActDonorType == -1) continue;
                this.copytCtab(j, actTCount);
                if (this.falseTautomer) continue;
                this.setEmptyTBtab(actTCount);
                this.setNewTBtab(actTCount);
                if (!this.isTautomerRight(actTCount)) continue;
                this.setLatentTauCounter(j, actTCount);
                if (this.falseTautomer || this.isTauExistYet(actTCount)) continue;
                this.setTauStop(++actTCount);
                if (!this.isTauStop()) {
                    this.tauCouples[actTCount - 1][0] = j;
                    this.tauCouples[actTCount - 1][1] = -1;
                    this.setLatentPath(i, actTCount);
                    this.itStep = true;
                    continue;
                }
                this.itStep = false;
            }
        }
        this.resetTa(actTCount);
        this.tautomerCount = actTCount;
    }

    private void setLatentTauCounter(int j, int actTCount) {
        if (this.chargeFlag) {
            this.setLTauCharge(j, actTCount);
        }
        this.setLTauHCount(j, actTCount);
        this.setTauLPCount(actTCount);
        if (this.getResStructures && this.getMajorRestructures && !this.falseTautomer) {
            this.isLowEnergyLewisStructure(actTCount);
        }
        if (!this.getResStructures && this.protectRadicalCount) {
            this.isRadicalCountChanged(actTCount);
        }
        if (!this.falseTautomer && !this.getResStructures && this.protectAromacity && !this.oneCR4Allowed && this.actAraCount > this.getAromaticAtomCount(actTCount)) {
            this.falseTautomer = true;
        }
        if (!this.falseTautomer && !this.getResStructures && this.excludeAntiAromaticity) {
            this.isAntiAromatic(actTCount);
        }
        if (!this.falseTautomer) {
            this.addLTatoms(j, actTCount);
        }
    }

    private boolean isTauExistYet(int child) {
        for (int parent = 0; parent < child; ++parent) {
            boolean NextTau = false;
            for (int j = 0; j < this.atomCount && !NextTau; ++j) {
                if (this.tBtab[child][j] != null) {
                    if (this.tBtab[parent][j] != null) {
                        int Lexist = this.tBtab[parent][j].length;
                        int Lnew = this.tBtab[child][j].length;
                        if (Lexist != Lnew) continue;
                        int k = 0;
                        if (this.chargeFlag && this.getResonantCharge(j, child) != this.getResonantCharge(j, parent)) {
                            NextTau = true;
                        }
                        if (this.getResonantHCount(j, child) != this.getResonantHCount(j, parent)) {
                            NextTau = true;
                        }
                        if (this.radicalExist && this.getResonantRCount(j, child) != this.getResonantRCount(j, parent)) {
                            NextTau = true;
                        }
                        while (k < Lexist && !NextTau) {
                            if (this.tBtab[parent][j][k] != this.tBtab[child][j][k]) {
                                int x = this.tCtab[parent][j][k];
                                if (!this.isArA(j) || !this.isArA(x)) {
                                    NextTau = true;
                                }
                            }
                            ++k;
                        }
                        continue;
                    }
                    NextTau = true;
                    continue;
                }
                if (this.tBtab[parent][j] == null) continue;
                NextTau = true;
            }
            if (NextTau) continue;
            return true;
        }
        return this.isOriginalMol(child);
    }

    private boolean isOriginalMol(int tChild) {
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.tBtab[tChild][i] == null) continue;
            int L = this.initBonds[i].length;
            if (L == this.tBtab[tChild][i].length) {
                if (this.initCharge[i] != this.getResonantCharge(i, tChild)) {
                    return false;
                }
                if (this.initHCount[i] != this.getResonantHCount(i, tChild)) {
                    return false;
                }
                if (this.initRCount[i] != this.getResonantRCount(i, tChild)) {
                    return false;
                }
                for (int k = 0; k < L; ++k) {
                    if (this.initBonds[i][k] == this.tBtab[tChild][i][k]) continue;
                    int x = this.tCtab[tChild][i][k];
                    if (this.isArA(i) && this.isArA(x)) continue;
                    return false;
                }
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean isLatentPathExist(int lti, int texist, int tnew) {
        this.lAra = new int[this.atomCount];
        if (!this.getResStructures && this.applyPathLengthCriteria && this.latentPath[lti].length > this.pL + 1) {
            return false;
        }
        this.parentT1 = texist;
        int acc = this.tPath[tnew][0];
        int don = this.tPath[tnew][this.tPath[tnew].length - 1];
        this.setLatentAromaticAtom(this.parentT1);
        this.setDonorType(don, tnew);
        this.setAcceptorType(acc, tnew);
        if (!this.isAllowedCouple(don, acc, tnew)) {
            return false;
        }
        int c = 0;
        for (int i = 0; i < this.actMultiplicity; ++i) {
            if (this.acceptorType[i] == -1) continue;
            ++c;
        }
        return c != 0;
    }

    private boolean isParentDonorNow(int a, int texist) {
        if (this.chargeFlag) {
            if (this.getParentCharge(a) < 0) {
                return true;
            }
            if (this.getParentCharge(a) > 0) {
                return false;
            }
        }
        if (this.getParentRCount(a) > 0) {
            return true;
        }
        for (int i = 0; i < this.tCtab[texist][a].length; ++i) {
            int nb = this.tCtab[texist][a][i];
            if (this.getBondType(nb, a) <= 1) continue;
            return false;
        }
        return true;
    }

    private int getResonantLPCount(int a, int texist) {
        int ai = this.getDonAccIndex(a);
        if (ai != -1) {
            return this.tLPCount[texist][ai];
        }
        return this.initLPCount[a];
    }

    private int getResonantRCount(int a, int texist) {
        if (!this.radicalExist) {
            return this.initRCount[a];
        }
        int ai = this.getDonAccIndex(a);
        if (ai != -1) {
            return this.tRCount[texist][ai];
        }
        return this.initRCount[a];
    }

    private int getParentRCount(int a) {
        int ai;
        if (this.tautomerType == 1) {
            return this.initRCount[a];
        }
        if (this.tautomerType == 3) {
            return this.getResonantRCount(a, this.parentT1);
        }
        if (this.tautomerType == 2 && (ai = this.getDonAccIndex(a)) != -1) {
            if (this.tAtoms[this.parentT1][ai] != 0) {
                return this.getResonantRCount(a, this.parentT1);
            }
            if (this.tAtoms[this.parentT2][ai] != 0) {
                return this.getResonantRCount(a, this.parentT2);
            }
        }
        return this.initRCount[a];
    }

    private int getResonantCharge(int a, int texist) {
        if (!this.chargeFlag) {
            return this.initCharge[a];
        }
        int ai = this.getDonAccIndex(a);
        if (ai != -1) {
            return this.tCharge[texist][ai];
        }
        return this.initCharge[a];
    }

    private int getParentCharge(int a) {
        int ai;
        if (this.tautomerType == 1) {
            return this.initCharge[a];
        }
        if (this.tautomerType == 3) {
            return this.getResonantCharge(a, this.parentT1);
        }
        if (this.tautomerType == 2 && (ai = this.getDonAccIndex(a)) != -1) {
            if (this.tAtoms[this.parentT1][ai] != 0) {
                return this.getResonantCharge(a, this.parentT1);
            }
            if (this.tAtoms[this.parentT2][ai] != 0) {
                return this.getResonantCharge(a, this.parentT2);
            }
        }
        return this.initCharge[a];
    }

    private int getResonantHCount(int a, int texist) {
        if (this.getResStructures) {
            return this.initHCount[a];
        }
        int ai = this.getDonAccIndex(a);
        if (ai != -1) {
            return this.tHCount[texist][ai];
        }
        return this.initHCount[a];
    }

    private int getParentHCount(int a) {
        int ai;
        if (this.getResStructures) {
            return this.initHCount[a];
        }
        if (this.tautomerType == 1) {
            return this.initHCount[a];
        }
        if (this.tautomerType == 3) {
            return this.getResonantHCount(a, this.parentT1);
        }
        if (this.tautomerType == 2 && (ai = this.getDonAccIndex(a)) != -1) {
            if (this.tAtoms[this.parentT1][ai] != 0) {
                return this.getResonantHCount(a, this.parentT1);
            }
            if (this.tAtoms[this.parentT2][ai] != 0) {
                return this.getResonantHCount(a, this.parentT2);
            }
        }
        return this.initHCount[a];
    }

    private int getParentECount(int a) {
        int ai;
        if (this.tautomerType == 1) {
            int inc = this.initECount[a] / 2;
            return inc;
        }
        if (this.tautomerType == 3) {
            return this.tECount[this.parentT1][a];
        }
        if (this.tautomerType == 2 && (ai = this.getDonAccIndex(a)) != -1) {
            if (this.tAtoms[this.parentT1][ai] != 0) {
                return this.tECount[this.parentT1][a];
            }
            if (this.tAtoms[this.parentT2][ai] != 0) {
                return this.tECount[this.parentT2][a];
            }
        }
        return this.initECount[a] / 2;
    }

    private int getParentLPCount(int a) {
        int ai = this.getDonAccIndex(a);
        if (ai == -1) {
            return this.initLPCount[a];
        }
        if (this.tautomerType == 1) {
            int lpc = this.initLPCount[a];
            return lpc;
        }
        if (this.tautomerType == 3) {
            int lpc = this.tLPCount[this.parentT1][ai] + this.implicitRCount[this.parentT1][ai] / 2;
            return lpc;
        }
        if (this.tautomerType == 2 && ai != -1) {
            if (this.tAtoms[this.parentT1][ai] != 0) {
                int lpc = this.tLPCount[this.parentT1][ai] + this.implicitRCount[this.parentT1][ai] / 2;
                return lpc;
            }
            if (this.tAtoms[this.parentT2][ai] != 0) {
                int lpc = this.tLPCount[this.parentT2][ai] + this.implicitRCount[this.parentT2][ai] / 2;
                return lpc;
            }
        }
        return this.initLPCount[a];
    }

    private void setLatentPath(int lti, int ti) {
        int L = this.latentPath[lti].length;
        int ai = this.getDonAccIndex(this.latentPath[lti][0]);
        int di = this.getDonAccIndex(this.latentPath[lti][L - 1]);
        this.tAtoms[ti][ai] = 1;
        this.tAtoms[ti][di] = -1;
        this.tPath[ti] = new int[this.latentPath[lti].length];
        for (int j = 0; j < this.latentPath[lti].length; ++j) {
            this.tPath[ti][j] = this.latentPath[lti][j];
        }
    }

    private void copytCtab(int parenT, int childT) {
        this.tCtab[childT] = new int[this.atomCount][];
        this.tBtab[childT] = new int[this.atomCount][];
        int acc = this.tPath[childT][0];
        int don = this.tPath[childT][this.tPath[childT].length - 1];
        int check = 0;
        this.falseTautomer = false;
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.tCtab[parenT][i] == null) continue;
            this.tCtab[childT][i] = new int[this.tCtab[parenT][i].length];
            for (int j = 0; j < this.tCtab[parenT][i].length; ++j) {
                this.tCtab[childT][i][j] = this.tCtab[parenT][i][j];
            }
            if (i != acc && i != don) continue;
            ++check;
        }
        if (check != 2) {
            this.falseTautomer = true;
        }
    }

    private Molecule setWigglyBond(Molecule m) {
        Molecule inp = null;
        if (this.protectKekuleForm) {
            inp = m.cloneMolecule();
        }
        m.aromatize(2);
        int ac = m.getAtomCount();
        int[] used = new int[ac];
        for (int i = 0; i < ac; ++i) {
            int h;
            int bc;
            MolAtom a = m.getAtom(i);
            if (a.getAtno() == 1) continue;
            if (this.isDonor(i) || this.isAcceptor(i) || this.isExcludedAtom(i)) {
                a = m.getAtom(i);
                bc = a.getBondCount();
                h = a.getImplicitHcount();
                if (this.chiralAtoms[i] != -1) {
                    this.setChiralCenterParity(i, m, bc + h);
                }
                for (int j = 0; j < bc; ++j) {
                    MolBond mb = a.getBond(j);
                    if (mb.getType() != 2 || this.protectedDB[i] == -1) continue;
                    MolAtom aa = mb.getOtherAtom(a);
                    int indx1 = m.indexOf(a);
                    int indx2 = m.indexOf(aa);
                    if (used[indx1] == -1 && used[indx2] == -1 || !m.canBeCT(indx1, indx2)) continue;
                    MolAtom a1 = mb.getCTAtom1();
                    MolAtom a4 = mb.getCTAtom4();
                    if (this.showWigglyBond) {
                        mb.setStereo2Flags(a1, a4, 192);
                    }
                    used[indx1] = -1;
                    used[indx2] = -1;
                }
                continue;
            }
            if (this.chiralAtoms[i] == -1) continue;
            a = m.getAtom(i);
            bc = a.getBondCount();
            h = a.getImplicitHcount();
            this.setChiralCenterParity(i, m, bc + h);
        }
        CleanUtil.setCTWigglyBond(m);
        this.dearomatize(m, inp);
        SmilesImport.fixCisInSmallRings(m);
        m.stereoClean();
        return m;
    }

    private void setChiralCenterParity(int i, Molecule m, int bc) {
        if (bc == 4) {
            m.setParity(i, this.chiralAtoms[i]);
            MolAtom a = m.getAtom(i);
            a.setFlags(this.chiralAtoms[i], 7);
            if (this.molAbsStereo) {
                m.setAbsStereo(true);
            }
        }
    }

    private void deleteWedgeBond(int protectEnhancedStereo, boolean molAbsStereo) {
        int[] used = new int[this.atomCount];
        for (int i = 0; i < this.atomCount; ++i) {
            MolAtom a = this.oMol.getAtom(i);
            int enhance = 0;
            int L = this.cHtab[i].length;
            if (protectEnhancedStereo == 1 && L >= 4) {
                enhance = 11;
            } else if (protectEnhancedStereo == 2 && L >= 4) {
                enhance = molAbsStereo ? 111 : a.getStereoGroupType();
            }
            int bc = a.getBondCount();
            int par = this.oMol.getLocalParity(i);
            if (par == 0 || enhance != 0) continue;
            for (int j = 0; j < bc; ++j) {
                MolBond mb = a.getBond(j);
                if (mb.getStereo1(a) == 0) continue;
                a.setFlags(0, 7);
                MolAtom aa = mb.getOtherAtom(a);
                int indx1 = this.oMol.indexOf(a);
                int indx2 = this.oMol.indexOf(aa);
                if (used[indx1] == -1 && used[indx2] == -1) continue;
                used[indx1] = -1;
                used[indx2] = -1;
            }
        }
        this.oMol.stereoClean();
    }

    private void addCTinfo() {
        MolAtom ma;
        int par;
        int i;
        this.protectedDB = new int[this.atomCount];
        this.chiralAtoms = new int[this.atomCount];
        for (int i2 = 0; i2 < this.atomCount; ++i2) {
            this.chiralAtoms[i2] = -1;
        }
        boolean ff = false;
        for (int i3 = 0; i3 < this.atomCount; ++i3) {
            if (!this.isDonor(i3) && !this.isAcceptor(i3)) continue;
            for (int j = 0; j < this.cHtab[i3].length; ++j) {
                int size;
                int ridx;
                MolBond mb;
                int nb = this.cHtab[i3][j];
                if (nb >= this.atomCount || this.protectedDB[nb] == -1 || (mb = this.oMol.getBond(this.bHtab[nb][i3])).getType() != 2) continue;
                if (this.oMol.getStereo2(mb) != 0) {
                    if (!this.protectCisTransinfo) continue;
                    ff = true;
                    this.protectedDB[nb] = -1;
                    this.protectedDB[i3] = -1;
                    continue;
                }
                if (!this.oMol.canBeCT(nb, i3) || (ridx = this.isAliphaticRingDB(nb, i3)) == -1) continue;
                if (this.protectCisTransinfo) {
                    ff = true;
                    this.protectedDB[nb] = -1;
                    this.protectedDB[i3] = -1;
                }
                if ((size = this.charge.nonAring[ridx].length) > 7) continue;
                MolAtom a1 = this.oMol.getAtom(this.getA1Indx(nb, i3, ridx));
                MolAtom a4 = this.oMol.getAtom(this.getA4Indx(nb, i3, ridx));
                mb.setStereo2Flags(a1, a4, 128);
            }
        }
        int[] td = new int[this.atomCount];
        int[] ta = new int[this.atomCount];
        int nd = 0;
        int na = 0;
        boolean findD = false;
        boolean findA = false;
        this.molAbsStereo = false;
        if (ff) {
            for (i = 0; i < this.atomCount; ++i) {
                if (this.protectedDB[i] == -1) {
                    this.delocAble[i] = -1;
                }
                if (this.isDonor(i) && this.protectedDB[i] != -1) {
                    td[nd] = i;
                    ++nd;
                }
                if (!this.isAcceptor(i) || this.protectedDB[i] == -1) continue;
                ta[na] = i;
                ++na;
            }
            this.dCount = nd;
            this.Donors = new int[this.dCount];
            for (i = 0; i < this.dCount; ++i) {
                this.Donors[i] = td[i];
            }
            this.aCount = na;
            this.Acceptors = new int[this.aCount];
            for (i = 0; i < this.aCount; ++i) {
                this.Acceptors[i] = ta[i];
            }
            this.setDonAccArray();
            this.setInitECount();
            this.setInitBonds();
        }
        for (i = 0; i < this.atomCount; ++i) {
            ta[i] = 0;
            td[i] = 0;
        }
        nd = 0;
        na = 0;
        findD = false;
        findA = false;
        if (this.oMol.isAbsStereo()) {
            this.molAbsStereo = true;
        }
        if (this.excludeChiralCenters) {
            for (i = 0; i < this.atomCount; ++i) {
                par = this.oMol.getLocalParity(i);
                ma = this.oMol.getAtom(i);
                if (this.isDonor(i)) {
                    if (par != 0) {
                        findD = true;
                        this.delocAble[i] = -1;
                        continue;
                    }
                    td[nd] = i;
                    ++nd;
                    continue;
                }
                if (!this.isAcceptor(i)) continue;
                if (par != 0) {
                    findA = true;
                    this.delocAble[i] = -1;
                    continue;
                }
                ta[na] = i;
                ++na;
            }
            this.deleteWedgeBond(1, this.molAbsStereo);
        } else if (this.excludeStrictChiralCenters) {
            for (i = 0; i < this.atomCount; ++i) {
                par = this.oMol.getLocalParity(i);
                ma = this.oMol.getAtom(i);
                int enhance = this.molAbsStereo ? 111 : ma.getStereoGroupType();
                if (this.isDonor(i)) {
                    if (par != 0 && enhance != 0) {
                        findD = true;
                        this.delocAble[i] = -1;
                        continue;
                    }
                    td[nd] = i;
                    ++nd;
                    continue;
                }
                if (!this.isAcceptor(i)) continue;
                if (par != 0 && enhance != 0) {
                    findA = true;
                    this.delocAble[i] = -1;
                    continue;
                }
                ta[na] = i;
                ++na;
            }
            this.deleteWedgeBond(2, this.molAbsStereo);
        } else {
            this.deleteChiralLabel();
            this.deleteWedgeBond(3, this.molAbsStereo);
        }
        if (findD) {
            this.dCount = nd;
            this.Donors = new int[this.dCount];
            for (i = 0; i < this.dCount; ++i) {
                this.Donors[i] = td[i];
            }
        }
        if (findA) {
            this.aCount = na;
            this.Acceptors = new int[this.aCount];
            for (i = 0; i < this.aCount; ++i) {
                this.Acceptors[i] = ta[i];
            }
        }
        if (findD || findA) {
            this.setDonAccArray();
            this.setInitECount();
            this.setInitBonds();
        }
    }

    private int isAliphaticRingDB(int nb, int i) {
        int ri;
        if (this.rings.isInRing()[nb] && this.rings.isInRing()[i] && this.isTheSameAliphaticRing(ri = this.charge.getNonARingIndex(nb), i)) {
            return ri;
        }
        return -1;
    }

    private int getA1Indx(int A2, int A3, int ridx) {
        int A1 = 0;
        for (int i = 0; i < this.cHtab[A2].length; ++i) {
            A1 = this.cHtab[A2][i];
            if (A1 >= this.atomCount || !this.rings.isInRing()[A1] || A1 == A3 || !this.isTheSameAliphaticRing(ridx, A1)) continue;
            return A1;
        }
        return A1;
    }

    private int getA4Indx(int A2, int A3, int ridx) {
        int A4 = 0;
        for (int i = 0; i < this.cHtab[A3].length; ++i) {
            A4 = this.cHtab[A3][i];
            if (A4 >= this.atomCount || !this.rings.isInRing()[A4] || A4 == A2 || !this.isTheSameAliphaticRing(ridx, A4)) continue;
            return A4;
        }
        return A4;
    }

    private boolean isTheSameAliphaticRing(int ri, int ai) {
        if (ri == -1) {
            return false;
        }
        for (int i = 0; i < this.charge.nonAring[ri].length; ++i) {
            if (this.charge.nonAring[ri][i] != ai) continue;
            return true;
        }
        return false;
    }

    private void deleteChiralLabel() {
        if (this.oMol.isAbsStereo()) {
            for (int i = 0; i < this.atomCount; ++i) {
                int par = this.oMol.getLocalParity(i);
                if (par == 0) continue;
                this.chiralAtoms[i] = par;
            }
            this.oMol.setAbsStereo(false);
            return;
        }
        int enhance = 0;
        for (int i = 0; i < this.atomCount; ++i) {
            int par = this.oMol.getLocalParity(i);
            MolAtom ma = this.oMol.getAtom(i);
            enhance = ma.getStereoGroupType();
            if (this.isDonor(i)) {
                if (par == 0) continue;
                this.chiralAtoms[i] = par;
                if (enhance == 0) continue;
                ma.setStereoGroupType(0);
                continue;
            }
            if (this.isAcceptor(i)) {
                if (par == 0) continue;
                this.chiralAtoms[i] = par;
                if (enhance == 0) continue;
                ma.setStereoGroupType(0);
                continue;
            }
            if (par == 0) continue;
            this.chiralAtoms[i] = par;
        }
    }

    public void createDACouples() {
        this.calculateDACouples();
    }

    private void calculateDACouples() {
        if (!this.getResStructures && this.ratTau) {
            this.setRatTauConditions(true);
        }
        this.initCalc();
        this.tautomerCount = 0;
        this.latentTauCount = 0;
        this.tCount = 0;
        if (this.structError) {
            this.charge.setCriticalErrorFlag(true);
            return;
        }
        if (this.charge.getCriticalErrorFlag()) {
            return;
        }
        if (this.isTauAble()) {
            this.initProgressMonitor();
            this.setProgressValue(10.0);
            this.setDACalcVariables();
            this.createSimpleTautomers();
            this.setProgressValue(35.0);
            this.createCombinedTautomers();
            if (this.latentTauCount == 0) {
                this.setProgressValue(65.0);
            } else {
                this.setProgressValue(40.0);
            }
            boolean LatCreation = true;
            if (this.getResStructures && this.getMajorRestructures && this.canReso) {
                LatCreation = false;
            }
            if (LatCreation) {
                this.createLatentTautomers();
                this.tautomerType = -1;
            }
            this.setProgressValue(70.0);
            if (this.allowSymmetryFiltering) {
                this.postFiltering();
            }
            if (this.ringChainTau) {
                this.countRingChainTautomers();
            }
            this.setProgressValue(75.0);
        } else {
            this.initProgressMonitor();
            if (this.ringChainTau) {
                this.countRingChainTautomers();
            }
        }
        this.setProgressValue(100.0);
        if (this.dominantTauDistCalc) {
            this.calcTautomerDistr();
        } else if (this.dominantTautomerization && !Double.isNaN(this.pH)) {
            this.calcTautomerDistr();
        }
        if (!this.getResStructures && this.ratTau) {
            this.setRatTauConditions(false);
        }
    }

    private boolean isTauAble() {
        if (this.dCount > 0 && this.aCount > 0) {
            return true;
        }
        if ((this.aCount > 0 || this.dCount > 0) && this.chargeFlag) {
            return true;
        }
        if ((this.aCount > 0 || this.dCount > 0) && this.canTaur) {
            return true;
        }
        if ((this.aCount > 0 || this.dCount > 0) && this.radicalExist) {
            return true;
        }
        return this.dCount > 1 || this.aCount > 1;
    }

    private void setDACalcVariables() {
        this.aSize = this.getSize(this.dCount, this.aCount);
        if (this.dominantTautomerization && this.aSize > 500) {
            this.aSize = 500;
            if (this.aSize > this.Tmax) {
                this.aSize = this.Tmax;
            }
        }
        int size = this.dCount + this.aCount;
        this.tAtoms = new int[this.aSize][size];
        this.latentPath = new int[this.aSize][];
        this.tPath = new int[this.aSize][];
        this.tCtab = new int[this.aSize][][];
        this.tBtab = new int[this.aSize][][];
        this.tCharge = new int[this.aSize][];
        this.tHCount = new int[this.aSize][];
        this.tExpHCount = new int[this.aSize][];
        this.tECount = new int[this.aSize][];
        this.tLPCount = new int[this.aSize][];
        this.tRCount = new int[this.aSize][];
        this.implicitRCount = new int[this.aSize][];
        this.sumTautomer = new int[size];
        this.tauCouples = new int[this.aSize][2];
    }

    private int getSize(int dC, int aC) {
        int dif;
        int s = 0;
        int n = dif = dC > aC ? dC - aC : aC - dC;
        s = dif != 0 ? (dC > aC ? dC * dC * (dC * dC) : aC * aC * (aC * aC)) : dC * aC * (dC * aC);
        if (dC == 0) {
            s = aC * aC * (aC * aC);
        } else if (aC == 0) {
            s = dC * dC * (dC * dC);
        } else if (this.chargeFlag) {
            if (aC > dC) {
                s = aC * aC * (dC * aC);
            } else if (dC > aC) {
                s = dC * dC * (aC * dC);
            }
        }
        if (this.chargeFlag || this.radicalExist) {
            s = 3 * s;
        }
        if (s > this.Tmax) {
            s = this.Tmax;
        }
        if (s < 60) {
            s = 100;
        }
        return s;
    }

    private void initProgressMonitor() {
        if (this.progressMonitor != null) {
            this.progressMonitor = this.progressMonitor.newInstance();
            this.progressMonitor.initProgressMonitor("calculation in progress ...", 0, 100);
        }
        this.setProgressValue(0.0);
    }

    private void setProgressValue(double value) {
        this.calcStatus = value;
        if (this.progressMonitor != null) {
            this.progressMonitor.setProgressValue((int)this.calcStatus);
        }
    }

    private void incProgressValue(double value) {
        this.setProgressValue(this.calcStatus + value);
    }

    private void resetTa(int ti) {
        int size = this.dCount + this.aCount;
        for (int i = 0; i < size; ++i) {
            this.tAtoms[ti][i] = 0;
        }
    }

    private void setTautomer(int ti) {
        this.tCtab[ti] = new int[this.atomCount][];
        this.tBtab[ti] = new int[this.atomCount][];
        for (int i = 0; i < this.atomCount; ++i) {
            int nb;
            int j;
            if (this.di[i][0] != 1) continue;
            int c = 0;
            for (j = 0; j < this.cHtab[i].length; ++j) {
                nb = this.cHtab[i][j];
                if (nb >= this.atomCount || this.di[nb][0] != 1) continue;
                ++c;
            }
            this.tCtab[ti][i] = new int[c];
            int k = 0;
            for (j = 0; j < this.cHtab[i].length; ++j) {
                nb = this.cHtab[i][j];
                if (nb >= this.atomCount || this.di[nb][0] != 1) continue;
                this.tCtab[ti][i][k] = nb;
                ++k;
            }
        }
        this.setEmptyTBtab(ti);
        this.setNewTBtab(ti);
    }

    private void setNewTBtab(int tnew) {
        int acc = this.tPath[tnew][0];
        int a2 = this.tPath[tnew][1];
        int ind = this.getTCtabIndex(acc, a2, tnew);
        this.tBtab[tnew][acc][ind] = this.getAccBtype(acc, a2);
        ind = this.getTCtabIndex(a2, acc, tnew);
        this.tBtab[tnew][a2][ind] = this.getAccBtype(acc, a2);
        int L = this.tPath[tnew].length;
        int a3 = this.tPath[tnew][L - 2];
        int don = this.tPath[tnew][L - 1];
        ind = this.getTCtabIndex(a3, don, tnew);
        this.tBtab[tnew][a3][ind] = this.getDonorBtype(a3, don);
        ind = this.getTCtabIndex(don, a3, tnew);
        this.tBtab[tnew][don][ind] = this.getDonorBtype(a3, don);
        this.setFixableSingleCarbonBond(tnew);
        this.setFixAbleDonors(tnew, don);
        this.setLatentFixablePAthBond(don, acc, tnew);
        this.setNotFixBonds(tnew);
        this.setTRestBonds(tnew);
    }

    private void setLatentFixablePAthBond(int don, int acc, int tnew) {
        int ind1;
        int ind0;
        int ai;
        int i;
        int L = this.tPath[tnew].length;
        int prev = -1;
        int next = -1;
        int accNb = this.tPath[tnew][1];
        int sb = this.getResonantBondType(acc, accNb, tnew);
        int donNb = this.tPath[tnew][L - 2];
        int eb = this.getResonantBondType(don, donNb, tnew);
        int step = -1;
        if (eb > sb) {
            step = 1;
        }
        int prevB = sb;
        for (i = 1; i < L - 2; ++i) {
            ai = this.tPath[tnew][i];
            next = this.tPath[tnew][i + 1];
            ind0 = this.getTCtabIndex(ai, next, tnew);
            this.tBtab[tnew][ai][ind0] = prevB + step;
            ind1 = this.getTCtabIndex(next, ai, tnew);
            this.tBtab[tnew][next][ind1] = prevB + step;
            prevB += step;
            step = -1 * step;
        }
        for (i = 0; i < L - 1; ++i) {
            ai = this.tPath[tnew][i];
            next = this.tPath[tnew][i + 1];
            for (int j = 0; j < this.cHtab[ai].length; ++j) {
                int nb = this.cHtab[ai][j];
                if (!this.isPathAtom(nb, tnew) || nb == next || nb == prev) continue;
                ind0 = this.getTCtabIndex(ai, nb, tnew);
                this.tBtab[tnew][ai][ind0] = this.getParentBType(ai, nb);
                ind1 = this.getTCtabIndex(nb, ai, tnew);
                this.tBtab[tnew][nb][ind1] = this.tBtab[tnew][ai][ind0];
            }
            prev = ai;
        }
    }

    private void setFixableSingleCarbonBond(int tnew) {
        for (int i = 0; i < this.atomCount; ++i) {
            if (!this.isArA(i) || this.cHtab[i].length != 3 || this.getAraNbCount(i) != 3 || this.initECount[i] / 2 != 2 || this.protonC[i] != 6 || this.tCtab[tnew][i] == null) continue;
            for (int j = 0; j < this.tCtab[tnew][i].length; ++j) {
                int a2 = this.tCtab[tnew][i][j];
                int ind0 = this.getTCtabIndex(i, a2, tnew);
                this.tBtab[tnew][i][ind0] = 1;
                int ind1 = this.getTCtabIndex(a2, i, tnew);
                this.tBtab[tnew][a2][ind1] = 1;
            }
        }
    }

    private void setFixAbleDonors(int tnew, int actDon) {
        block48: {
            int ind;
            boolean sb;
            boolean cond;
            int a2;
            block49: {
                block47: {
                    int pc;
                    if (this.getResStructures && this.isArA(actDon) && this.ActDonorType == 2 && ((pc = this.protonC[actDon]) == 6 || pc == 14)) {
                        for (int j = 0; j < this.tCtab[tnew][actDon].length; ++j) {
                            a2 = this.tCtab[tnew][actDon][j];
                            this.tBtab[tnew][actDon][j] = 1;
                            int ind2 = this.getTCtabIndex(a2, actDon, tnew);
                            this.tBtab[tnew][a2][ind2] = this.tBtab[tnew][actDon][j];
                        }
                    }
                    if (this.tautomerType != 1) break block47;
                    for (int a1 = 0; a1 < this.atomCount; ++a1) {
                        int j;
                        if (!this.isArA(a1) || this.tCtab[tnew][a1] == null) continue;
                        cond = false;
                        boolean cond2 = false;
                        sb = this.isSingleBonded(a1);
                        if (!this.isEmptyBond(tnew, a1)) {
                            if (this.isFixableAraAliBond(tnew, a1)) {
                                cond2 = true;
                            } else {
                                cond = false;
                            }
                        } else if (a1 == actDon) {
                            cond = false;
                        } else if (this.isDonor(a1) && sb) {
                            cond = true;
                        } else if (this.getParentRCount(a1) > 0 && sb) {
                            cond = true;
                        } else if (this.nbCount[a1] == 2) {
                            if (sb) {
                                cond = true;
                            }
                        } else if (this.nbCount[a1] == 3 && sb && this.getParentCharge(a1) == 0) {
                            cond = true;
                        }
                        if (cond) {
                            for (j = 0; j < this.tCtab[tnew][a1].length; ++j) {
                                a2 = this.tCtab[tnew][a1][j];
                                this.tBtab[tnew][a1][j] = this.getUnUsedBondType(a1, a2);
                                ind = this.getTCtabIndex(a2, a1, tnew);
                                this.tBtab[tnew][a2][ind] = this.tBtab[tnew][a1][j];
                            }
                            continue;
                        }
                        if (!cond2) continue;
                        for (j = 0; j < this.tCtab[tnew][a1].length; ++j) {
                            a2 = this.tCtab[tnew][a1][j];
                            if (!this.isArA(a2)) continue;
                            this.tBtab[tnew][a1][j] = this.getParentBType(a1, a2);
                            ind = this.getTCtabIndex(a2, a1, tnew);
                            this.tBtab[tnew][a2][ind] = this.tBtab[tnew][a1][j];
                        }
                    }
                    break block48;
                }
                if (this.tautomerType != 2) break block49;
                for (int a1 = 0; a1 < this.atomCount; ++a1) {
                    if (!this.isArA(a1) || this.tCtab[tnew][a1] == null) continue;
                    cond = false;
                    sb = this.isSingleBonded(a1);
                    if (!this.isEmptyBond(tnew, a1)) {
                        cond = false;
                    } else if (this.isDonor(a1) && sb) {
                        cond = true;
                    } else if (this.getParentRCount(a1) > 0 && sb) {
                        cond = true;
                    } else if (this.nbCount[a1] == 2) {
                        if (sb) {
                            cond = true;
                        }
                    } else if (this.nbCount[a1] == 3 && sb && this.getParentCharge(a1) == 0) {
                        cond = true;
                    }
                    if (!cond) continue;
                    for (int j = 0; j < this.tCtab[tnew][a1].length; ++j) {
                        a2 = this.tCtab[tnew][a1][j];
                        this.tBtab[tnew][a1][j] = this.getUnUsedBondType(a1, a2);
                        ind = this.getTCtabIndex(a2, a1, tnew);
                        this.tBtab[tnew][a2][ind] = this.tBtab[tnew][a1][j];
                    }
                }
                break block48;
            }
            if (this.tautomerType != 3) break block48;
            for (int a1 = 0; a1 < this.atomCount; ++a1) {
                if (!this.isArA(a1) || this.tCtab[tnew][a1] == null) continue;
                cond = false;
                sb = this.isSingleBonded(a1);
                if (!this.isEmptyBond(tnew, a1)) {
                    cond = false;
                } else if (a1 == actDon) {
                    cond = false;
                } else if (this.isDonor(a1) && sb) {
                    if (this.isParentDonorNow(a1, this.parentT1)) {
                        cond = true;
                    }
                } else if (this.getParentRCount(a1) > 0 && sb) {
                    cond = true;
                } else if (this.nbCount[a1] == 2) {
                    if (sb) {
                        cond = true;
                    }
                } else if (this.nbCount[a1] == 3 && sb && this.getParentCharge(a1) == 0) {
                    cond = true;
                }
                if (!cond) continue;
                for (int j = 0; j < this.tCtab[tnew][a1].length; ++j) {
                    this.tBtab[tnew][a1][j] = this.getParentBondType(a1, j, this.parentT1);
                    a2 = this.tCtab[tnew][a1][j];
                    ind = this.getTCtabIndex(a2, a1, tnew);
                    this.tBtab[tnew][a2][ind] = this.tBtab[tnew][a1][j];
                }
            }
        }
    }

    private boolean isEmptyBond(int ti, int a1) {
        for (int j = 0; j < this.tCtab[ti][a1].length; ++j) {
            if (this.tBtab[ti][a1][j] == -100) continue;
            return false;
        }
        return true;
    }

    private boolean isFixableAraAliBond(int ti, int a1) {
        boolean find = false;
        for (int j = 0; j < this.tCtab[ti][a1].length; ++j) {
            int a2 = this.tCtab[ti][a1][j];
            if (this.tBtab[ti][a1][j] != -100) {
                if (!this.isArA(a2)) {
                    find = true;
                    continue;
                }
                return false;
            }
            if (!this.isPathBond(a1, a2, ti)) continue;
            return false;
        }
        return find;
    }

    private boolean isSingleBonded(int a) {
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int nb = this.cHtab[a][i];
            if (nb >= this.atomCount) continue;
            int bt = this.getParentBType(nb, a);
            if (bt == -1) {
                bt = this.oMol.getBond(this.bHtab[nb][a]).getType();
            }
            if (bt == 1) continue;
            return false;
        }
        return true;
    }

    private int getDonorBtype(int nbDon, int don) {
        int bt = this.getBondType(nbDon, don);
        if (bt > 3) {
            if (this.ActDonorType == 1) {
                return 2;
            }
            if (this.ActDonorType == 2) {
                return 1;
            }
            if (this.ActDonorType == 3) {
                return 2;
            }
            if (this.ActDonorType == 6) {
                return 1;
            }
            if (this.ActDonorType == 8) {
                return this.getParentBType(don, nbDon);
            }
        } else {
            if (this.ActDonorType == 1) {
                return bt + 1;
            }
            if (this.ActDonorType == 2) {
                return bt - 1;
            }
            if (this.ActDonorType == 3) {
                return bt + 1;
            }
            if (this.ActDonorType == 6) {
                return bt - 1;
            }
            if (this.ActDonorType == 8) {
                return bt;
            }
            if (this.ActDonorType == 7) {
                return bt + 1;
            }
        }
        return -1;
    }

    private int getAccBtype(int acc, int a2) {
        int bt = this.getBondType(acc, a2);
        if (bt > 3) {
            if (this.ActAcceptorType == 4) {
                return 2;
            }
            if (this.ActAcceptorType == 5) {
                return 1;
            }
            if (this.ActAcceptorType == 3) {
                return 1;
            }
            if (this.ActAcceptorType == 6) {
                return 1;
            }
            if (this.ActAcceptorType == 8) {
                return this.getParentBType(acc, a2);
            }
        } else {
            if (this.ActAcceptorType == 4) {
                return bt + 1;
            }
            if (this.ActAcceptorType == 5) {
                return bt - 1;
            }
            if (this.ActAcceptorType == 3) {
                if (this.isArA(acc)) {
                    return 1;
                }
                return bt - 1;
            }
            if (this.ActAcceptorType == 6) {
                return bt - 1;
            }
            if (this.ActAcceptorType == 8) {
                return bt;
            }
            if (this.ActAcceptorType == 7) {
                return bt + 1;
            }
        }
        return -1;
    }

    private boolean isArabondFixable(int a1, int a2, int ti) {
        if (this.isArA(a1)) {
            for (int i = 0; i < this.cHtab[a1].length; ++i) {
                int nb = this.cHtab[a1][i];
                if (nb != a2 || !this.isArA(nb) || this.tautomerType != 1 || this.getInputBondType(a1, nb) != 4) continue;
                if (this.isFixedAra(a1, a2, ti)) {
                    return true;
                }
                if (this.isFixedAra(a2, a1, ti)) {
                    return true;
                }
                if (this.isDBExist(a1, ti)) {
                    return true;
                }
                if (!this.isDBExist(a2, ti)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isFixedAra(int ai, int ar, int ti) {
        int b1 = this.tBtab[ti][ai].length;
        int c = 0;
        int j = 0;
        for (int i = 0; i < b1; ++i) {
            int a;
            if (this.tCtab[ti][ai] == null || !this.isArA(a = this.tCtab[ti][ai][i]) || a == ar) continue;
            ++j;
            if (this.tBtab[ti][ai][i] == -100) continue;
            ++c;
        }
        return j == c;
    }

    private boolean isDBExist(int ai, int ti) {
        int b1 = this.tBtab[ti][ai].length;
        for (int i = 0; i < b1; ++i) {
            if (this.tCtab[ti][ai] == null) continue;
            int a = this.tCtab[ti][ai][i];
            if (this.isArA(a) && this.tBtab[ti][ai][i] == 2) {
                return true;
            }
            if (!this.isArA(ai) || this.tBtab[ti][ai][i] != 2 || this.protonC[ai] != 6) continue;
            return true;
        }
        return false;
    }

    private int getParentBondType(int a1, int a2i, int texist) {
        return this.tBtab[texist][a1][a2i];
    }

    private boolean isCrossBond(int a1, int a2, int ti) {
        int c = 0;
        this.crossAtom = -1;
        int L1 = this.tCtab[ti][a1].length;
        int L2 = this.tCtab[ti][a2].length;
        if (L1 > 2) {
            ++c;
            this.crossAtom = a1;
        }
        if (L2 > 2) {
            ++c;
            this.crossAtom = a2;
        }
        return c == 2;
    }

    private int getNbInc(int ai, int tnew) {
        int d = this.nbCount[ai] - this.tCtab[tnew][ai].length + this.getChildHcount(ai, tnew);
        return d;
    }

    private boolean isFixableBond(int a1, int a2, int ti) {
        int i;
        int b1 = this.tBtab[ti][a1].length;
        int c1 = 0;
        int c2 = 0;
        for (i = 0; i < b1; ++i) {
            if (this.tBtab[ti][a1][i] == -100) continue;
            ++c1;
            if (this.tBtab[ti][a1][i] <= 1) continue;
            return true;
        }
        if (c1 != 0) {
            c1 += this.getNbInc(a1, ti);
        } else if (this.isNotDelocAraNbExist(a1)) {
            c1 += this.getNbInc(a1, ti);
        }
        b1 = this.tBtab[ti][a2].length;
        for (i = 0; i < b1; ++i) {
            if (this.tBtab[ti][a2][i] == -100) continue;
            ++c2;
            if (this.tBtab[ti][a2][i] <= 1) continue;
            return true;
        }
        if (c2 != 0) {
            c2 += this.getNbInc(a2, ti);
        } else if (this.isNotDelocAraNbExist(a2)) {
            c2 += this.getNbInc(a2, ti);
        }
        if (this.crossAtom == -1) {
            if (c1 >= 1 || c2 >= 1) {
                return true;
            }
        } else {
            if (this.crossAtom == a1 && (c2 >= 1 || c1 > 1)) {
                return true;
            }
            if (this.crossAtom == a2 && (c1 >= 1 || c2 > 1)) {
                return true;
            }
        }
        return false;
    }

    private boolean isNotDelocAraNbExist(int ai) {
        if (!this.isArA(ai)) {
            return false;
        }
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (!this.isArA(nb) || this.delocAble[nb] != -1 || this.getInputBondType(nb, ai) != 4) continue;
            return true;
        }
        return false;
    }

    private boolean isFixAbleCrossBond(int a1, int a2, int ti) {
        int c1 = 0;
        int c2 = 0;
        int b1 = this.tBtab[ti][a1].length;
        for (int i = 0; i < b1; ++i) {
            if (this.tBtab[ti][a1][i] == -100) continue;
            ++c1;
            if (this.tBtab[ti][a1][i] <= 1) continue;
            return true;
        }
        int b2 = this.tBtab[ti][a2].length;
        for (int i = 0; i < b2; ++i) {
            if (this.tBtab[ti][a2][i] == -100) continue;
            ++c2;
            if (this.tBtab[ti][a2][i] <= 1) continue;
            return true;
        }
        return c2 >= b2 - 1 || c1 >= b1 - 1;
    }

    private boolean isFixAbleCommonBond(int a1, int a2) {
        return true;
    }

    private void setTRestBonds(int ti) {
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.tCtab[ti][i] == null) continue;
            for (int j = 0; j < this.tCtab[ti][i].length; ++j) {
                if (this.tBtab[ti][i][j] != -100) continue;
                int a = this.getTCtabAtomIndex(i, j, ti);
                this.tBtab[ti][i][j] = this.getUnUsedBondType(i, a);
                int ind = this.getTCtabIndex(a, i, ti);
                this.tBtab[ti][a][ind] = this.tBtab[ti][i][j];
                if (!this.isArA(i) && !this.isArA(a)) continue;
                this.setNotFixBonds(ti);
            }
        }
    }

    private int getUnUsedBondType(int a, int b) {
        if (this.isArA(a) || this.isArA(b)) {
            if (this.protectKekuleForm) {
                return this.oMol.getBond(this.bHtab[a][b]).getType();
            }
            return 1;
        }
        return this.getBondType(a, b);
    }

    private void printTBtab(int ti) {
        System.err.println();
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.tBtab[ti][i] == null) continue;
            for (int j = 0; j < this.tBtab[ti][i].length; ++j) {
                int a = this.getTCtabAtomIndex(i, j, ti);
                int x = i;
                int y = a;
                System.err.println("T =" + ti + "  a1=" + x + " a2=" + y + " btype = " + this.tBtab[ti][i][j]);
            }
        }
        System.err.println();
    }

    private int getTBtabValue(int a1, int a2, int ti) {
        boolean type1 = false;
        int type2 = 0;
        int type2Count = 0;
        boolean onlyDB = false;
        boolean oneORtwo = false;
        int t1 = 0;
        int t2 = 0;
        for (int i = 0; i < this.tBtab[ti][a1].length; ++i) {
            if (this.tBtab[ti][a1][i] == 2) {
                type1 = true;
                ++t1;
                continue;
            }
            if (this.tBtab[ti][a1][i] != 1) continue;
            if (this.isDBondAble(ti, a1) && this.isDBondAble(ti, a2)) {
                type2 = 2;
                ++type2Count;
                ++t2;
                continue;
            }
            type1 = true;
            ++t1;
        }
        boolean type = this.polarGroups.carboxy[a1] == 1200 | this.polarGroups.groupProperty[a1] == 4000;
        if (t2 == 1 && t1 == 1) {
            if (type && this.isArA(a1)) {
                return 2;
            }
        } else if (t2 == 0 && t1 == 1 && type && this.isArA(a1)) {
            if (this.isDBExist(a1, ti)) {
                return 1;
            }
            oneORtwo = true;
        }
        if (t1 == 0 && t2 != 0) {
            onlyDB = true;
        }
        type2Count = 0;
        int t21 = 0;
        int t22 = 0;
        for (int i = 0; i < this.tBtab[ti][a2].length; ++i) {
            if (this.tBtab[ti][a2][i] == 2) {
                type1 = true;
                ++t21;
                continue;
            }
            if (this.tBtab[ti][a2][i] != 1) continue;
            if (this.isDBondAble(ti, a2) && this.isDBondAble(ti, a1)) {
                type2 = 2;
                ++type2Count;
                ++t22;
                continue;
            }
            type1 = true;
            ++t21;
        }
        if (t21 == 0 && t22 != 0) {
            onlyDB = true;
        }
        type = this.polarGroups.carboxy[a2] == 1200 | this.polarGroups.groupProperty[a2] == 4000;
        if (t22 == 1 && t21 == 1) {
            if (type && this.isArA(a2)) {
                return 2;
            }
        } else if (t22 == 0 && t21 == 1 && type && this.isArA(a2)) {
            if (this.isDBExist(a1, ti)) {
                return 1;
            }
            oneORtwo = true;
        }
        if (oneORtwo && onlyDB) {
            return 2;
        }
        if (type1) {
            return 1;
        }
        if (type2 != 0) {
            return 2;
        }
        return -100;
    }

    private boolean isNewADCombination(int t1i, int t2i) {
        if (this.isCorrectCombination(t1i, t2i) && !this.isCommonADExist(t1i, t2i) && !this.isTautomerCreatedYet(this.sumTautomer)) {
            return this.isAllowedDelocalization(t1i, t2i);
        }
        return false;
    }

    private boolean isCommonADExist(int t1i, int t2i) {
        int size = this.dCount + this.aCount;
        for (int i = 0; i < size; ++i) {
            if (this.tAtoms[t1i][i] == 0 && this.tAtoms[t2i][i] == 0 || this.tAtoms[t1i][i] != this.tAtoms[t2i][i]) continue;
            return true;
        }
        return false;
    }

    private boolean isCorrectCombination(int t1, int t2) {
        int[] c1 = this.getTautomerDACount(this.tAtoms[t1]);
        int[] c2 = this.getTautomerDACount(this.tAtoms[t2]);
        this.setSumTautomer(t1, t2);
        int[] s = this.getTautomerDACount(this.sumTautomer);
        return c1[0] - s[0] == c1[1] - s[1] && c2[0] - s[0] == c2[1] - s[1];
    }

    private void setSumTautomer(int t1, int t2) {
        int size = this.dCount + this.aCount;
        for (int i = 0; i < size; ++i) {
            this.sumTautomer[i] = 0;
            if (this.tAtoms[t1][i] != 0) {
                this.sumTautomer[i] = this.tAtoms[t1][i];
            }
            if (this.tAtoms[t2][i] == 0) continue;
            this.sumTautomer[i] = this.tAtoms[t2][i];
        }
    }

    private boolean isTautomerCreatedYet(int[] t) {
        int size = this.dCount + this.aCount;
        for (int i = 0; i < this.tautomerCount; ++i) {
            int c = 0;
            boolean passed = false;
            for (int j = 0; j < size && !passed; ++j) {
                if (this.tAtoms[i][j] == t[j]) {
                    ++c;
                    continue;
                }
                passed = true;
            }
            if (c != size) continue;
            return true;
        }
        return false;
    }

    private int[] getTautomerDACount(int[] t) {
        int[] a = new int[]{0, 0};
        int size = this.dCount + this.aCount;
        for (int i = 0; i < size; ++i) {
            if (t[i] == -1) {
                a[0] = a[0] + 1;
                continue;
            }
            if (t[i] != 1) continue;
            a[1] = a[1] + 1;
        }
        return a;
    }

    private void addTautomers(int t1, int t2) {
        this.addTAtoms(t1, t2, this.tautomerCount);
        this.addTPathes(t1, t2);
        this.addLPCount(t1, t2, this.tautomerCount);
        this.addRCounts(t1, t2, this.tautomerCount);
        if (this.chargeFlag || this.getResStructures) {
            this.addCharges(t1, t2, this.tautomerCount);
        }
        this.addHCounts(t1, t2, this.tautomerCount);
        this.falseTautomer = false;
        if (this.getResStructures && this.getMajorRestructures) {
            this.isLowEnergyLewisStructure(this.tautomerCount);
        }
    }

    private void addTAtoms(int t1, int t2, int tnew) {
        int size = this.dCount + this.aCount;
        for (int i = 0; i < size; ++i) {
            if (this.tAtoms[t1][i] != 0) {
                this.tAtoms[tnew][i] = this.tAtoms[t1][i];
            }
            if (this.tAtoms[t2][i] == 0) continue;
            this.tAtoms[tnew][i] = this.tAtoms[t2][i];
        }
    }

    private void addLTatoms(int texist, int tnew) {
        int i;
        int size = this.dCount + this.aCount;
        for (i = 0; i < size; ++i) {
            this.sumTautomer[i] = 0;
            if (this.tAtoms[texist][i] != 0) {
                this.sumTautomer[i] = this.tAtoms[texist][i];
            }
            if (this.tAtoms[tnew][i] == 0) continue;
            this.sumTautomer[i] = this.tAtoms[tnew][i];
        }
        for (i = 0; i < size; ++i) {
            this.tAtoms[tnew][i] = this.sumTautomer[i];
        }
    }

    private void addTPathes(int t1, int t2) {
        int i;
        this.tPath[this.tautomerCount] = new int[this.tPath[t1].length + this.tPath[t2].length];
        for (i = 0; i < this.tPath[t1].length; ++i) {
            this.tPath[this.tautomerCount][i] = this.tPath[t1][i];
        }
        for (int j = 0; j < this.tPath[t2].length; ++j) {
            this.tPath[this.tautomerCount][i] = this.tPath[t2][j];
            ++i;
        }
    }

    private boolean isAllowedDelocalization(int t1i, int t2i) {
        this.tCtab[this.tautomerCount] = new int[this.atomCount][];
        this.tBtab[this.tautomerCount] = new int[this.atomCount][];
        this.setCombinedTCtab(t1i, t2i);
        if (this.commonParentAtom) {
            this.setEmptyTBtab(this.tautomerCount);
            this.setFixTBonds(t1i, t2i);
            if (this.falseTautomer) {
                return false;
            }
            this.setFixAbleDonors(this.tautomerCount, 0);
            this.setNotFixBonds(this.tautomerCount);
            this.setTRestBonds(this.tautomerCount);
        } else {
            this.addTBTabs(this.tautomerCount);
        }
        return this.isTautomerRight(this.tautomerCount);
    }

    private void addTBTabs(int t) {
        int i;
        int t1i = this.parentT1;
        int t2i = this.parentT2;
        for (i = 0; i < this.atomCount; ++i) {
            if (this.tCtab[t1i][i] != null) {
                this.tBtab[t][i] = new int[this.tCtab[t1i][i].length];
                continue;
            }
            if (this.tCtab[t2i][i] == null) continue;
            this.tBtab[t][i] = new int[this.tCtab[t2i][i].length];
        }
        for (i = 0; i < this.atomCount; ++i) {
            int ind;
            int a2;
            int j;
            if (this.tCtab[t1i][i] != null) {
                for (j = 0; j < this.tCtab[t1i][i].length; ++j) {
                    this.tBtab[t][i][j] = this.tBtab[t1i][i][j];
                    a2 = this.getTCtabAtomIndex(i, j, t);
                    ind = this.getTCtabIndex(a2, i, t);
                    this.tBtab[t][a2][ind] = this.tBtab[t1i][i][j];
                }
                continue;
            }
            if (this.tCtab[t2i][i] == null) continue;
            for (j = 0; j < this.tCtab[t2i][i].length; ++j) {
                this.tBtab[t][i][j] = this.tBtab[t2i][i][j];
                a2 = this.getTCtabAtomIndex(i, j, t);
                ind = this.getTCtabIndex(a2, i, t);
                this.tBtab[t][a2][ind] = this.tBtab[t2i][i][j];
            }
        }
    }

    private boolean isTautomerRight(int ti) {
        int ChildECount = 0;
        int ParentECount = 0;
        int hBalance = 0;
        int parentInc = 0;
        this.tECount[ti] = new int[this.atomCount];
        int ad = 0;
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.tCtab[ti][i] == null) continue;
            boolean find = false;
            ad = 0;
            int childInc = 0;
            for (int j = 0; j < this.tBtab[ti][i].length; ++j) {
                int bt = this.tBtab[ti][i][j];
                int aj = this.tCtab[ti][i][j];
                if (bt > 0) {
                    if (bt == 4) {
                        if (!this.isArA(i) || !this.isArA(aj)) {
                            return false;
                        }
                        find = true;
                        continue;
                    }
                    if (bt == 3) {
                        if (this.isTenValencedNitrogen(i, aj)) {
                            return false;
                        }
                        ad += this.tBtab[ti][i][j];
                        childInc += this.tBtab[ti][i][j];
                        continue;
                    }
                    ad += this.tBtab[ti][i][j];
                    childInc += this.tBtab[ti][i][j];
                    continue;
                }
                return false;
            }
            parentInc = this.getParentECount(i);
            ParentECount += parentInc;
            if (find) {
                childInc += parentInc - ad;
            }
            ChildECount += childInc;
            this.tECount[ti][i] = childInc;
            if (childInc == parentInc) continue;
            if (!this.isADTauAtom(ti, i)) {
                return false;
            }
            if (this.tautomerType == 2) {
                return false;
            }
            hBalance += this.getHCountChange(i, ti, childInc, parentInc);
            if (!this.falseTautomer) continue;
            return false;
        }
        if (this.tautomerType == 1 || this.tautomerType == 3) {
            ChildECount -= this.getBondCorr();
        }
        return ChildECount == ParentECount && hBalance == 0;
    }

    private boolean isTenValencedNitrogen(int i, int aj) {
        if (this.protonC[i] == 7) {
            int y = this.getParentECount(i);
            if (y > 4) {
                return true;
            }
            if (this.nbCount[i] == 3) {
                return true;
            }
        } else if (this.protonC[aj] == 7) {
            int y = this.getParentECount(aj);
            if (y > 4) {
                return true;
            }
            if (this.nbCount[i] == 3) {
                return true;
            }
        }
        return false;
    }

    private int getBondCorr() {
        if (this.ActDonorType == 2 && this.ActAcceptorType == 5) {
            return -2;
        }
        if (this.ActDonorType == 2 && this.ActAcceptorType == 3) {
            return -2;
        }
        if (this.ActDonorType == 3 && this.ActAcceptorType == 4) {
            return 2;
        }
        if (this.ActDonorType == 6 && this.ActAcceptorType == 6) {
            return -2;
        }
        if (this.ActDonorType == 7 && this.ActAcceptorType == 7) {
            return 2;
        }
        return 0;
    }

    private int getHCountChange(int a, int ti, int cInc, int pInc) {
        int parentChg;
        int chiledChg;
        this.falseTautomer = false;
        int L = this.tPath[ti].length;
        int don = this.tPath[ti][L - 1];
        int acc = this.tPath[ti][0];
        if (this.isHSender(don)) {
            if (a == don) {
                return -1;
            }
            if (a == acc) {
                return 1;
            }
            this.falseTautomer = true;
            return 0;
        }
        if (this.chargeFlag && (chiledChg = this.getChildCharge(a, ti)) != (parentChg = this.getParentCharge(a))) {
            return 0;
        }
        if (cInc > pInc) {
            if (this.isDeRadicalized(a, ti)) {
                return 0;
            }
            this.falseTautomer = true;
            return 0;
        }
        if (cInc < pInc) {
            if (this.isRadicalized(a, ti)) {
                return 0;
            }
            this.falseTautomer = true;
            return 0;
        }
        this.falseTautomer = true;
        return 0;
    }

    private boolean isRadicalized(int a, int tChild) {
        int acc;
        if (!this.radicalExist) {
            return false;
        }
        if (this.ActDonorType == 1 && a == (acc = this.tPath[tChild][0])) {
            return true;
        }
        if (this.ActDonorType == 6) {
            int don = this.tPath[tChild][this.tPath[tChild].length - 1];
            int acc2 = this.tPath[tChild][0];
            if (a == don || a == acc2) {
                return true;
            }
        }
        return false;
    }

    private boolean isDeRadicalized(int a, int tChild) {
        int don;
        if (!this.radicalExist) {
            return false;
        }
        return this.ActDonorType == 1 && a == (don = this.tPath[tChild][this.tPath[tChild].length - 1]);
    }

    private int getResonantBondType(int a, int b, int texist) {
        if (this.tCtab[texist][a] != null) {
            for (int ind = 0; ind < this.tCtab[texist][a].length; ++ind) {
                if (this.tCtab[texist][a][ind] != b) continue;
                return this.tBtab[texist][a][ind];
            }
        } else {
            return this.oMol.getBond(this.bHtab[a][b]).getType();
        }
        return -1;
    }

    private int getParentBType(int a, int b) {
        if (this.tautomerType == 1) {
            return this.oMol.getBond(this.bHtab[a][b]).getType();
        }
        if (this.tautomerType == 2) {
            int p = this.parentT1;
            for (int i = 0; i < 2; ++i) {
                if (this.tCtab[p][a] != null) {
                    for (int ind = 0; ind < this.tCtab[p][a].length; ++ind) {
                        if (this.tCtab[p][a][ind] != b) continue;
                        return this.tBtab[p][a][ind];
                    }
                }
                p = this.parentT2;
            }
            return -1;
        }
        if (this.tautomerType == 3) {
            if (this.tCtab[this.parentT1][a] != null) {
                for (int ind = 0; ind < this.tCtab[this.parentT1][a].length; ++ind) {
                    if (this.tCtab[this.parentT1][a][ind] != b) continue;
                    return this.tBtab[this.parentT1][a][ind];
                }
            }
        }
        return -1;
    }

    private boolean isADTauAtom(int ti, int a) {
        int ai = this.getDonAccIndex(a);
        if (ai == -1) {
            return false;
        }
        return this.tautomerType == 1 ? this.tAtoms[ti][ai] != 0 : (this.tautomerType == 3 ? this.tAtoms[this.parentT1][ai] != 0 || this.tAtoms[ti][ai] != 0 : this.tautomerType == 2 && (this.tAtoms[this.parentT1][ai] != 0 || this.tAtoms[this.parentT2][ai] != 0));
    }

    private void setCombinedTCtab(int t1i, int t2i) {
        int j;
        int i;
        this.commonParentAtom = false;
        for (i = 0; i < this.atomCount; ++i) {
            if (this.tCtab[t1i][i] == null) continue;
            this.tCtab[this.tautomerCount][i] = new int[this.tCtab[t1i][i].length];
            for (j = 0; j < this.tCtab[t1i][i].length; ++j) {
                this.tCtab[this.tautomerCount][i][j] = this.tCtab[t1i][i][j];
            }
        }
        for (i = 0; i < this.atomCount; ++i) {
            if (this.tCtab[t2i][i] == null) continue;
            if (this.tCtab[this.tautomerCount][i] == null) {
                this.tCtab[this.tautomerCount][i] = new int[this.tCtab[t2i][i].length];
                for (j = 0; j < this.tCtab[t2i][i].length; ++j) {
                    this.tCtab[this.tautomerCount][i][j] = this.tCtab[t2i][i][j];
                }
                continue;
            }
            this.commonParentAtom = true;
        }
    }

    private void setEmptyTBtab(int ti) {
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.tCtab[ti][i] == null) continue;
            this.tBtab[ti][i] = new int[this.tCtab[ti][i].length];
            for (int j = 0; j < this.tCtab[ti][i].length; ++j) {
                this.tBtab[ti][i][j] = -100;
            }
        }
    }

    private void setFixTBonds(int t1i, int t2i) {
        int ind;
        int a2;
        int ai;
        int i;
        int t = this.tautomerCount;
        int size = this.dCount + this.aCount;
        this.falseTautomer = false;
        for (i = 0; i < size; ++i) {
            if (this.tAtoms[t1i][i] != 1 && this.tAtoms[t1i][i] != -1) continue;
            ai = this.getDonAccAtom(i);
            if (this.tCtab[t1i][ai] != null) {
                for (int j = 0; j < this.tCtab[t1i][ai].length; ++j) {
                    this.tBtab[t][ai][j] = this.tBtab[t1i][ai][j];
                    a2 = this.getTCtabAtomIndex(ai, j, t);
                    ind = this.getTCtabIndex(a2, ai, t);
                    this.tBtab[t][a2][ind] = this.tBtab[t1i][ai][j];
                }
                continue;
            }
            this.falseTautomer = true;
            return;
        }
        for (i = 0; i < size && !this.falseTautomer; ++i) {
            if (this.tAtoms[t2i][i] != 1 && this.tAtoms[t2i][i] != -1) continue;
            ai = this.getDonAccAtom(i);
            if (this.tCtab[t2i][ai] != null) {
                for (int j = 0; j < this.tCtab[t2i][ai].length; ++j) {
                    a2 = this.getTCtabAtomIndex(ai, j, t);
                    int adInd = this.getDonAccIndex(a2);
                    if (adInd != -1 && this.tAtoms[t1i][adInd] != 0 && this.tBtab[t2i][ai][j] != this.tBtab[t][ai][j]) {
                        this.falseTautomer = true;
                    }
                    this.tBtab[t][ai][j] = this.tBtab[t2i][ai][j];
                    ind = this.getTCtabIndex(a2, ai, t);
                    this.tBtab[t][a2][ind] = this.tBtab[t2i][ai][j];
                }
                continue;
            }
            this.falseTautomer = true;
            return;
        }
    }

    private void setNotFixBonds(int ti) {
        boolean ready = false;
        int e0 = 0;
        while (!ready) {
            int e = 0;
            for (int i = 0; i < this.atomCount; ++i) {
                if (this.tCtab[ti][i] == null) continue;
                for (int j = 0; j < this.tBtab[ti][i].length; ++j) {
                    if (this.tBtab[ti][i][j] != -100) continue;
                    int a2 = this.getTCtabAtomIndex(i, j, ti);
                    this.tBtab[ti][i][j] = this.getNotFixBondType(i, a2, ti);
                    int ind = this.getTCtabIndex(a2, i, ti);
                    this.tBtab[ti][a2][ind] = this.tBtab[ti][i][j];
                    ++e;
                }
            }
            if (e == e0) {
                ready = true;
                continue;
            }
            e0 = e;
        }
    }

    private MolBond getBondBetweenTwoAtoms(Molecule m, int a1Indx, int a2Indx) {
        MolAtom a1 = m.getAtom(a1Indx);
        MolAtom a2 = m.getAtom(a2Indx);
        MolBond f = null;
        int g = a1.getBondCount();
        for (int i = 0; i < g; ++i) {
            f = a1.getBond(i);
            MolAtom x = f.getOtherAtom(a1);
            if (!x.equals(a2)) continue;
            return f;
        }
        return null;
    }

    private int getInputBondType(int a1, int a2) {
        if (this.expHCount == 0) {
            return this.mol.getBond(this.bHtab[a1][a2]).getType();
        }
        int a1_inmol = a1 - this.indxShift[a1];
        int a2_inmol = a2 - this.indxShift[a2];
        MolBond z = this.getBondBetweenTwoAtoms(this.mol, a1_inmol, a2_inmol);
        if (z != null) {
            return z.getType();
        }
        return -1;
    }

    private int getNotFixBondType(int a1, int a2, int ti) {
        if (this.tautomerType == 1 && this.isArA(a1) && this.isArA(a2)) {
            if (!this.isPathAtom(a1, ti) && !this.isPathAtom(a2, ti)) {
                if (this.getInputBondType(a1, a2) != 4) {
                    this.fixBondType = this.oMol.getBond(this.bHtab[a1][a2]).getType();
                    return this.fixBondType;
                }
                if (this.protectKekuleForm) {
                    this.fixBondType = this.oMol.getBond(this.bHtab[a1][a2]).getType();
                    return this.fixBondType;
                }
            }
            if (!this.isArabondFixable(a1, a2, ti)) {
                return -100;
            }
        }
        this.fixBondType = -1;
        if (this.isChangeAbleBond(a1, a2, ti)) {
            if (this.fixBondType != -1) {
                return this.fixBondType;
            }
            return this.getTBtabValue(a1, a2, ti);
        }
        return -100;
    }

    private int getTCtabIndex(int a1, int a2, int ti) {
        if (this.tCtab[ti][a1] != null) {
            for (int i = 0; i < this.tCtab[ti][a1].length; ++i) {
                if (this.tCtab[ti][a1][i] != a2) continue;
                return i;
            }
        }
        return -1;
    }

    private int getTCtabAtomIndex(int ai, int aai, int ti) {
        return this.tCtab[ti][ai][aai];
    }

    private boolean isChangeAbleBond(int a1, int a2, int ti) {
        if (!this.isArA(a1) || !this.isArA(a2)) {
            if (this.isPathBond(a1, a2, ti)) {
                if (this.isCommonBond(a1, a2)) {
                    return this.isFixAbleCommonBond(a1, a2);
                }
                if (this.isSeparatorBond(a1, a2, ti)) {
                    this.fixBondType = this.getBondType(a1, a2);
                    return true;
                }
                return this.isNbPathBondExist(a1, a2, this.mainPath);
            }
            if (this.isRestBond(a1, a2, ti)) {
                this.fixBondType = this.getBondType(a1, a2);
                return true;
            }
        }
        if (this.baseTautomer && (this.tPath[ti][0] == a1 || this.tPath[ti][0] == a2)) {
            this.fixBondType = 1;
            return true;
        }
        if (this.isCrossBond(a1, a2, ti)) {
            return this.isFixAbleCrossBond(a1, a2, ti);
        }
        return this.isFixableBond(a1, a2, ti);
    }

    private boolean isPathBond(int a1, int a2, int ti) {
        return this.isPathAtom(a1, ti) && this.isPathAtom(a2, ti);
    }

    private boolean isRestBond(int a1, int a2, int ti) {
        return !this.isPathAtom(a1, ti) || !this.isPathAtom(a2, ti);
    }

    private boolean isSeparatorBond(int a1, int a2, int ti) {
        if (this.baseTautomer) {
            this.mainPath = ti;
            return false;
        }
        int t = this.parentT1;
        int c = 0;
        int p1 = -1;
        int p2 = -1;
        for (int i = 0; i < 2; ++i) {
            int j;
            for (j = 0; j < this.tPath[t].length; ++j) {
                if (this.tPath[t][j] != a1) continue;
                ++c;
                this.mainPath = p1 = t;
            }
            for (j = 0; j < this.tPath[t].length; ++j) {
                if (this.tPath[t][j] != a2) continue;
                ++c;
                this.mainPath = p2 = t;
            }
            t = this.parentT2;
        }
        return c == 2 && p1 >= 0 && p2 >= 0 && p1 != p2;
    }

    private boolean isCommonBond(int a1, int a2) {
        if (this.baseTautomer) {
            return false;
        }
        return this.isCombinedPathAtom(a1) && this.isCombinedPathAtom(a2);
    }

    private boolean isCombinedPathAtom(int a) {
        int t = this.parentT1;
        int c = 0;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < this.tPath[t].length; ++j) {
                if (this.tPath[t][j] != a) continue;
                ++c;
            }
            t = this.parentT2;
        }
        return c == 2;
    }

    private boolean isNbPathBondExist(int a1, int a2, int mPath) {
        int a = a1;
        int aa = a2;
        int ti = mPath;
        for (int j = 0; j < 2; ++j) {
            for (int i = 0; i < this.tCtab[mPath][a].length; ++i) {
                int nb = this.tCtab[mPath][a][i];
                if (nb == aa || !this.isMainPathAtom(nb, mPath) || !this.isMainPathBond(a1, nb, mPath) || this.tBtab[ti][a][i] == -100) continue;
                this.fixSinglePathBond(a, aa, i, ti);
                return true;
            }
            a = a2;
            aa = a1;
        }
        return false;
    }

    private void fixSinglePathBond(int a, int aa, int i, int ti) {
        int bt = this.getBondType(aa, a);
        this.fixBondType = this.isNbDecreased(a, i, ti) ? bt + 1 : (bt > 1 ? bt - 1 : bt);
    }

    private boolean isNbDecreased(int a, int nbi, int ti) {
        int nb = this.tCtab[ti][a][nbi];
        int bt1 = this.getBondType(a, nb);
        int bt2 = this.tBtab[ti][a][nbi];
        if (bt1 > 3) {
            return bt2 == 1;
        }
        return bt1 > bt2;
    }

    private boolean isSingleBondAllowed(int ti, int ai) {
        int don;
        return (this.tautomerType == 1 || this.tautomerType == 3) && ai == (don = this.tPath[ti][this.tPath[ti].length - 1]);
    }

    private boolean isDBondAble(int tnew, int a) {
        int t = this.polarGroups.carboxy[a];
        if (this.isArA(a)) {
            if ((this.ActDonorType == 2 || this.ActDonorType == 6) && this.isSingleBondAllowed(tnew, a)) {
                return false;
            }
            return !this.isSingleBonded(a);
        }
        if (t == 1000 || t == 1100) {
            return this.getResStructures;
        }
        return true;
    }

    private int getPrevPathAtom(int ai, int tIndex) {
        int aindex = this.getPathAtomIndex(ai, tIndex);
        if (aindex != -1 && aindex != 0) {
            return this.tPath[tIndex][aindex - 1];
        }
        return -1;
    }

    private int getPathAtomIndex(int ai, int tIndex) {
        for (int i = 0; i < this.tPath[tIndex].length; ++i) {
            if (this.tPath[tIndex][i] != ai) continue;
            return i;
        }
        return -1;
    }

    protected boolean isAcceptor(int a) {
        for (int i = 0; i < this.aCount; ++i) {
            if (this.Acceptors[i] != a) continue;
            return true;
        }
        return false;
    }

    protected boolean isDonor(int a) {
        for (int i = 0; i < this.dCount; ++i) {
            if (this.Donors[i] != a) continue;
            return true;
        }
        return false;
    }

    private int getAcceptorIndex(int a) {
        for (int i = 0; i < this.aCount; ++i) {
            if (this.Acceptors[i] != a) continue;
            return i;
        }
        return -1;
    }

    private int getDonAccAtom(int DonAccIndex) {
        return this.DonAcc[DonAccIndex];
    }

    private int getDonAccIndex(int a) {
        for (int i = 0; i < this.dCount + this.aCount; ++i) {
            if (this.DonAcc[i] != a) continue;
            return i;
        }
        return -1;
    }

    private boolean isPathAtom(int a, int tIndex) {
        if (this.baseTautomer) {
            for (int i = 0; i < this.tPath[tIndex].length; ++i) {
                if (this.tPath[tIndex][i] != a) continue;
                return true;
            }
        } else {
            int t = this.parentT1;
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < this.tPath[t].length; ++j) {
                    if (this.tPath[t][j] != a) continue;
                    return true;
                }
                t = this.parentT2;
            }
        }
        return false;
    }

    private boolean isMainPathAtom(int a, int pi) {
        for (int i = 0; i < this.tPath[pi].length; ++i) {
            if (this.tPath[pi][i] != a) continue;
            return true;
        }
        return false;
    }

    private boolean isMainPathBond(int a1, int nb, int pIndex) {
        int ind = 0;
        int L = this.tPath[pIndex].length;
        for (int i = 0; i < L; ++i) {
            if (this.tPath[pIndex][i] != a1) continue;
            ind = i;
        }
        if (ind - 1 >= 0 && this.tPath[pIndex][ind - 1] == nb) {
            return true;
        }
        return ind + 1 < L && this.tPath[pIndex][ind + 1] == nb;
    }

    private boolean isAllowedCouple(int don, int acc, int ti) {
        int donChg = this.getParentCharge(don);
        int accChg = this.getParentCharge(acc);
        if (this.getResStructures && this.methylDonor) {
            return false;
        }
        int an1 = this.protonC[don];
        int an2 = this.protonC[acc];
        if (!this.ketenAllowed && !this.getResStructures && an1 == 6 && this.isDBCarbon(don)) {
            return false;
        }
        if (this.dominantTautomerization) {
            int rdc = 0;
            if (this.radicalExist) {
                rdc = this.getParentRCount(don);
            }
            if (this.biasedDonor[don] == 1 && rdc == 0 ? !this.isMicropKaCorrect(don) : (this.notSpontanDonor[don] == -1 && accChg == 0 ? rdc == 0 : this.isDBCarbon(don))) {
                return false;
            }
            if (this.notSpontanAcceptor[acc] == -1) {
                return false;
            }
            if (this.isAraCAcc(acc)) {
                return false;
            }
        }
        if (!this.getResStructures) {
            if (this.chargeFlag) {
                if (accChg != 0 && donChg == 0) {
                    return accChg > 0 && an2 == 7 && this.isCationAccOk(acc);
                }
                if (accChg == 0 && donChg != 0) {
                    return false;
                }
            }
            if (this.isDBCarbon(don) && this.isN5(ti)) {
                return false;
            }
            if (this.isN5Forbidden(ti)) {
                return false;
            }
        }
        int donLPc = this.getParentLPCount(don);
        int rDon = this.getParentRCount(don);
        int rAcc = this.getParentRCount(acc);
        if (rDon > 0 || rAcc > 0) {
            return true;
        }
        if (donChg < 0 && accChg > 0) {
            return true;
        }
        if (donChg > 0 && accChg > 0) {
            return false;
        }
        if (donChg < 0 && accChg < 0) {
            return false;
        }
        if (an1 == 6 && accChg > 0) {
            if (this.isArA(don)) {
                return true;
            }
            return this.isDBCarbon(don);
        }
        if (!this.getResStructures && this.isArA(acc) && donChg == 0 && donLPc == 0 && rDon == 0 && this.getParentHCount(don) == 0) {
            return false;
        }
        if (donChg < 0 || accChg > 0) {
            return true;
        }
        if (donChg > 0 && accChg == 0) {
            return true;
        }
        if (an1 == 6 && an2 == 6) {
            return this.getResStructures;
        }
        if (an1 == 6) {
            if (this.getResStructures) {
                return true;
            }
            if (this.isACEdgeCorrect(ti)) {
                return !this.isRingEtenHdonor(don, donChg);
            }
            return false;
        }
        if (an2 == 6 && this.isArA(acc)) {
            if (this.getResStructures) {
                return true;
            }
            if (this.protectAromacity && !this.oneCR4Allowed) {
                return false;
            }
        }
        return true;
    }

    private boolean isCationAccOk(int acc) {
        if (this.getParentHCount(acc) != 0) {
            return true;
        }
        for (int i = 0; i < this.cHtab[acc].length; ++i) {
            int bt;
            int nb = this.cHtab[acc][i];
            if (nb >= this.atomCount || (bt = this.getParentBType(nb, acc)) <= 1) continue;
            return true;
        }
        return false;
    }

    private boolean isN5(int ti) {
        int L = this.tPath[ti].length;
        int n5 = this.tPath[ti][L - 2];
        int d = this.tPath[ti][L - 1];
        int bt = this.getParentBType(n5, d);
        return bt > 1 && this.getParentCharge(n5) == 0;
    }

    private boolean isN5Forbidden(int ti) {
        int ac = this.tPath[ti][0];
        for (int i = 0; i < this.tPath[ti].length; ++i) {
            int n5 = this.tPath[ti][i];
            if (this.protonC[n5] != 7 || this.nbCount[n5] != 3) continue;
            int oc = 0;
            int any = 0;
            boolean cond = false;
            for (int j = 0; j < this.cHtab[n5].length; ++j) {
                int bt;
                int nb = this.cHtab[n5][j];
                if (nb >= this.atomCount || (bt = this.getParentBType(n5, nb)) <= 1) continue;
                if (this.protonC[nb] == 8) {
                    ++oc;
                    if (nb != ac) continue;
                    cond = true;
                    continue;
                }
                if (nb == ac) {
                    cond = true;
                }
                if (this.isPathAtom(nb, ti)) continue;
                ++any;
            }
            if (oc == 1 && any == 1) {
                if (!cond) {
                    return true;
                }
                if (this.protonC[ac] != 8) continue;
                return true;
            }
            if (oc != 0 || any < 2) continue;
            return true;
        }
        return false;
    }

    private boolean isRingEtenHdonor(int cDon, int dChg) {
        if (this.protonC[cDon] != 6) {
            return false;
        }
        int hc = this.getParentHCount(cDon);
        if (hc == 0) {
            return false;
        }
        int n = this.nbCount[cDon] + hc;
        return dChg == 0 && n < 4 && this.rings.isInRing()[cDon];
    }

    private boolean isDBCarbon(int don) {
        int n = this.nbCount[don] + this.getParentHCount(don);
        int chg = this.getParentCharge(don);
        int pc = this.protonC[don];
        if (pc == 6) {
            if (n < 4 && chg == 0) {
                return true;
            }
            if (n == 2 && chg < 0) {
                return true;
            }
        }
        return false;
    }

    private boolean isMicropKaCorrect(int don) {
        int n;
        if (this.tautomerType == 3 && (n = this.nbCount[don] + this.getParentHCount(don)) == 4) {
            boolean p = this.protectExpH;
            this.protectExpH = false;
            Molecule m = this.createTMolecule(this.parentT1, true);
            this.ionizer = new Ionizer();
            this.ionizer.setpKaPrefixType(1);
            m.dearomatize();
            m.aromatize(1);
            this.ionizer.setMolecule(m);
            this.ionizer.setLargeModelFlag(true);
            this.ionizer.setTautomerCalculationFlag(true);
            this.ionizer.micropKaCalc = true;
            this.ionizer.calculatepKa(0.0);
            this.ionizer.setLargeModelFlag(false);
            this.ionizer.setTautomerCalculationFlag(false);
            double apKa = this.ionizer.getpKa(don, -1);
            this.protectExpH = p;
            if (Double.isNaN(apKa)) {
                return false;
            }
            return !(apKa > 17.0);
        }
        return false;
    }

    private boolean isAraCAcc(int acc) {
        if (this.tautomerType == 3 && this.protonC[acc] == 6) {
            boolean p = this.protectExpH;
            this.protectExpH = false;
            Molecule m = this.createTMolecule(this.parentT1, true);
            m.aromatize(1);
            MolAtom a = m.getAtom(acc);
            this.protectExpH = p;
            if (a.hasAromaticBond()) {
                return true;
            }
        }
        return false;
    }

    private boolean isCommonNbExist(int a, int d) {
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            if (this.cHtab[a][i] >= this.atomCount) continue;
            for (int j = 0; j < this.cHtab[d].length; ++j) {
                if (this.cHtab[a][i] != this.cHtab[d][j]) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isHiddenSymmetric(int a, int d) {
        if (this.protonC[a] != this.protonC[d]) {
            return false;
        }
        if (this.isIsotopeCouple(a, d)) {
            return false;
        }
        if (this.nbCount[a] != 1) {
            return false;
        }
        if (this.nbCount[d] != 1) {
            return false;
        }
        if (this.initCharge[a] != this.initCharge[d]) {
            return false;
        }
        if (this.initRCount[a] != this.initRCount[d]) {
            return false;
        }
        return this.isCommonNbExist(a, d);
    }

    private boolean isIsotopeCouple(int don, int acc) {
        return this.protonC[don] == this.protonC[acc] && this.mass[don] != this.mass[acc];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean createDelocIsland(int donor, int acceptor) {
        if (donor == acceptor) {
            return false;
        }
        if (!this.chargeFlag && !this.radicalExist && this.protonC[donor] == 6 && this.protonC[acceptor] == 6) {
            return false;
        }
        if (this.allowSymmetryFiltering && this.isHiddenSymmetric(acceptor, donor)) {
            return false;
        }
        boolean stop = false;
        int s = 0;
        int[] p = null;
        int t = this.tautomerCount;
        int resA = -1;
        int resB = -1;
        this.restrict = false;
        if (this.isNbAtoms(donor, acceptor)) {
            if (this.OpenChine && !this.chargeFlag && !this.radicalExist) {
                return false;
            }
            if (this.setResNeighBours(donor, acceptor)) {
                this.calcDelocPath(acceptor, resA, resB);
                if (this.isContiniousIsland(donor)) {
                    this.storeSimpleADorAAorDD(donor, acceptor, t);
                }
            }
            t = this.tautomerCount;
            if (this.OpenChine) {
                return true;
            }
            this.restrict = true;
            resA = donor;
            resB = acceptor;
        }
        int k = 0;
        int L = 0;
        while (!stop) {
            this.calcDelocPath(acceptor, resA, resB);
            if (this.isContiniousIsland(donor)) {
                this.setResPath(donor, acceptor);
                if (this.isPathTauable(t, donor)) return true;
                if (k == 0) {
                    p = new int[this.tPath[t].length];
                    for (int j = 0; j < this.tPath[t].length; ++j) {
                        p[j] = this.tPath[t][j];
                    }
                    s = p.length - 3;
                    L = p.length;
                }
                if (s > 0) {
                    if (k <= L - 2) {
                        resA = p[k + 1];
                        resB = p[k];
                        this.restrict = true;
                    } else {
                        stop = true;
                    }
                } else if (k == 0) {
                    this.restrict = true;
                    resA = p[2];
                    resB = p[1];
                } else {
                    stop = true;
                }
            } else if (k == 0) {
                stop = true;
            } else if (s > 0) {
                if (k <= L - 2) {
                    resA = p[k + 1];
                    resB = p[k];
                    this.restrict = true;
                } else {
                    stop = true;
                }
            } else {
                stop = true;
            }
            ++k;
        }
        return false;
    }

    protected boolean isOddNumber(int d) {
        int y = d & 1;
        return y == 1;
    }

    private boolean isNbAtoms(int a1, int a2) {
        this.OpenChine = false;
        for (int i = 0; i < this.cHtab[a1].length; ++i) {
            if (this.cHtab[a1][i] != a2) continue;
            if (this.isArA(a1) && this.isArA(a2)) {
                return true;
            }
            if (this.rings.isInRing()[a1] && this.rings.isInRing()[a2]) {
                return true;
            }
            this.OpenChine = true;
            return true;
        }
        return false;
    }

    private boolean isContiniousIsland(int donor) {
        boolean find = false;
        for (int m = 0; m < this.sphereSize && !find; ++m) {
            if (this.sAtom[m] != donor) continue;
            find = true;
        }
        return find;
    }

    private boolean setResNeighBours(int don, int acc) {
        boolean allowed = false;
        if (this.getBondType(don, acc) != 1) {
            allowed = true;
        } else if (this.getParentCharge(don) != 0 && this.getParentCharge(acc) != 0) {
            allowed = true;
        } else if (this.getParentLPCount(don) != 0) {
            allowed = true;
        } else if (this.getParentRCount(don) != 0) {
            allowed = true;
        }
        if (allowed) {
            this.tPath[this.tautomerCount] = new int[2];
            this.tPath[this.tautomerCount][0] = acc;
            this.tPath[this.tautomerCount][1] = don;
            return true;
        }
        return false;
    }

    private void setResPath(int donor, int acceptor) {
        int aDest = donor;
        int[] endAtom = new int[this.atomCount];
        int[] path = new int[this.atomCount];
        path[0] = acceptor;
        int pLe = 0;
        boolean find = false;
        for (int i = 0; i < this.sphereSize && !find; ++i) {
            int aStart = this.sAtom[i];
            if (this.di[aStart][1] != 1) continue;
            pLe = 1;
            path[pLe] = aStart;
            for (int j = 0; j < this.sphereSize && !find; ++j) {
                int a = aStart;
                pLe = 2;
                for (int k = 0; k < this.sphereSize && !find; ++k) {
                    int root;
                    int b = this.sAtom[k];
                    if (b == a || endAtom[b] == -1 || (root = this.di[b][2]) != a) continue;
                    a = b;
                    if (a == aDest) {
                        find = true;
                    }
                    path[pLe] = b;
                    ++pLe;
                }
                endAtom[a] = -1;
            }
        }
        if (find) {
            this.tPath[this.tautomerCount] = new int[pLe];
            for (int f = 0; f < pLe; ++f) {
                this.tPath[this.tautomerCount][f] = path[f];
            }
        }
    }

    private boolean isPathTauable(int ti, int don) {
        boolean odd = this.isOddNumber(this.di[don][1]);
        int acc = this.tPath[ti][0];
        int di = this.getDonAccIndex(don);
        int ai = this.getDonAccIndex(acc);
        int ppL = this.pL;
        if (this.stdCanonic) {
            int ppL1 = this.spl[di];
            int ppL2 = this.spl[ai];
            ppL = ppL1 <= ppL2 ? ppL1 : ppL2;
        }
        if (!this.getResStructures && this.applyPathLengthCriteria && this.tPath[ti].length > ppL + 1) {
            return false;
        }
        if (this.allowPosResonance ? this.tPath[ti].length < 3 : odd) {
            return false;
        }
        int F = 1;
        int L = this.tPath[ti].length - 1;
        for (int i = F; i < L; ++i) {
            int a1 = this.tPath[ti][i];
            for (int j = 0; j < this.cHtab[a1].length; ++j) {
                int a2;
                int bt2;
                int bt1;
                int nb = this.cHtab[a1][j];
                if (nb >= this.atomCount || this.isPathAtom(nb, ti) || (bt1 = this.getBondType(a1, nb)) != 2 && bt1 != 3 || (bt2 = this.getBondType(a2 = this.getPrevPathAtom(a1, ti), a1)) != 1) continue;
                this.latentTautomer = true;
                this.storeLatentPath(don, acc, ti);
                return false;
            }
        }
        this.storeSimpleADorAAorDD(don, acc, ti);
        return this.TauCreated;
    }

    private boolean isACEdgeCorrect(int ti) {
        int a1 = this.tPath[ti][0];
        int a2 = this.tPath[ti][1];
        if (this.chargeFlag && this.getParentCharge(a1) > 0) {
            return true;
        }
        if (this.getBondType(a2, a1) == 1) {
            return this.tautomerType == 1 ? this.isDonor(a2) || this.isAcceptor(a2) : this.tautomerType == 3 && this.isArA(a1);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getBondType(int a, int b) {
        if (!this.latentTCreation) {
            if (!this.isArA(a) || !this.isArA(b)) return this.oMol.getBond(this.bHtab[a][b]).getType();
            return 4;
        } else {
            if (this.tCtab[this.parentT1][a] == null) {
                if (!this.isArA(a) || !this.isArA(b)) return this.oMol.getBond(this.bHtab[a][b]).getType();
                return 4;
            }
            for (int ind = 0; ind < this.tCtab[this.parentT1][a].length; ++ind) {
                if (this.tCtab[this.parentT1][a][ind] != b) continue;
                return this.tBtab[this.parentT1][a][ind];
            }
        }
        return this.oMol.getBond(this.bHtab[a][b]).getType();
    }

    private void setTauStop(int tc) {
        if (tc >= this.aSize - 2) {
            this.tauStop = true;
        }
        this.setTypeLimit(tc);
    }

    private void setTypeLimit(int tc) {
        if (this.stdCanonic || this.canReso) {
            if (tc >= this.sMax + this.combMax + this.latMax) {
                this.lTStop = true;
            }
            if (tc >= this.sMax + this.combMax) {
                this.cTStop = true;
            }
            if (tc >= this.sMax) {
                this.sTStop = true;
            }
        }
    }

    private void setLatentTauStop(int ltc) {
        if (ltc >= this.aSize - 2) {
            this.latentTauStop = true;
        } else if ((this.stdCanonic || this.canReso) && ltc > this.latMax) {
            this.latentTauStop = true;
        }
    }

    private boolean isTauStop() {
        if ((this.tautomerType == 1 || this.tautomerType == 2) && this.tauStop) {
            return true;
        }
        if (this.tautomerType == 3 && this.tauStop) {
            return true;
        }
        if (this.stdCanonic || this.canReso) {
            if (this.tautomerType == 1) {
                return this.sTStop;
            }
            if (this.tautomerType == 2) {
                return this.cTStop;
            }
            if (this.tautomerType == 3) {
                return this.lTStop;
            }
        }
        return false;
    }

    private void storeLatentPath(int don, int acc, int ti) {
        this.setTauStop(this.tautomerCount);
        this.setLatentTauStop(this.latentTauCount);
        if (this.isLatentPathStoredYet(don, acc, ti)) {
            this.latentTautomer = false;
            return;
        }
        if (this.latentTautomer && !this.latentTauStop) {
            int L = this.tPath[ti].length;
            this.latentPath[this.latentTauCount] = new int[L];
            for (int i = 0; i < L; ++i) {
                this.latentPath[this.latentTauCount][i] = this.tPath[ti][i];
            }
            ++this.latentTauCount;
            this.latentTautomer = false;
            this.setLatentTauStop(this.latentTauCount);
        }
    }

    private boolean isLatentPathStoredYet(int don, int acc, int ti) {
        int L = this.tPath[ti].length;
        int c = 0;
        for (int i = 0; i < this.latentTauCount; ++i) {
            if (this.latentPath[i].length != L || this.latentPath[i][0] != acc || this.latentPath[i][L - 1] != don) continue;
            c = 0;
            for (int j = 0; j < L; ++j) {
                if (this.latentPath[i][j] != this.tPath[ti][j]) continue;
                ++c;
            }
            if (c != L) continue;
            return true;
        }
        return false;
    }

    private boolean isReverseLPathStoredYet(int don, int acc, int ti, int ltc) {
        int L = this.latentPath[ti].length;
        int c = 0;
        for (int i = 0; i < ltc; ++i) {
            if (this.latentPath[i].length != L || i == ti || this.latentPath[i][0] != don || this.latentPath[i][L - 1] != acc) continue;
            c = 0;
            for (int j = 0; j < L; ++j) {
                if (this.latentPath[i][j] != this.latentPath[ti][L - 1 - j]) continue;
                ++c;
            }
            if (c != L) continue;
            return true;
        }
        return false;
    }

    private void setDelocAbleAtoms() {
        this.delocAble = new int[this.atomCount];
        for (int i = 0; i < this.atomCount; ++i) {
            this.delocAble[i] = -1;
            if (!this.isRightAtom(i)) continue;
            this.delocAble[i] = 1;
        }
    }

    private boolean isRightAtom(int atom) {
        int protonCount = this.protonC[atom];
        if (protonCount == 1) {
            return false;
        }
        if (protonCount == 7) {
            if (this.cHtab[atom].length == 3) {
                if (!this.getResStructures) {
                    if (this.isHExist(atom)) {
                        return true;
                    }
                    if (this.isArA(atom)) {
                        if (this.atomArray[atom].getCharge() != 0) {
                            return true;
                        }
                        return this.isDBonded(atom);
                    }
                    if (this.isDBonded(atom)) {
                        return true;
                    }
                    return this.isRadical(atom);
                }
                return true;
            }
            if (this.cHtab[atom].length != 4) {
                return true;
            }
            if (this.cHtab[atom].length == 4) {
                return this.atomArray[atom].getCharge() == 0;
            }
            return false;
        }
        if (protonCount == 6) {
            if (this.cHtab[atom].length != 4) {
                return true;
            }
            return this.isAcceptor(atom) || this.isDonor(atom);
        }
        if (!this.getResStructures) {
            if (this.isDBonded(atom)) {
                return true;
            }
            if (this.isHExist(atom)) {
                return true;
            }
            if (this.isRadical(atom)) {
                return true;
            }
            return this.atomArray[atom].getCharge() != 0;
        }
        return true;
    }

    public void calcDelocPath(int acc, int resA, int resB) {
        int actAtom = acc;
        this.sphereSize = 0;
        this.allowPosResonance = false;
        this.di = new int[this.atomCount][3];
        for (int i = 0; i < this.atomCount; ++i) {
            this.sAtom[i] = -1;
        }
        int distance = 1;
        boolean sChange = true;
        boolean jump = false;
        int i = 0;
        int y = this.atomCount + 1;
        while (distance < y & sChange) {
            sChange = false;
            int length = this.cHtab[actAtom].length;
            for (int j = 0; j < length; ++j) {
                int pa = this.cHtab[actAtom][j];
                if (this.restrict) {
                    jump = false;
                    if (actAtom == resB && pa == resA) {
                        jump = true;
                    }
                }
                if (pa >= this.atomCount || jump || this.di[pa][0] == 1 || pa == acc || this.delocAble[pa] != 1 || this.isBlocking(pa)) continue;
                this.di[pa][0] = 1;
                this.di[pa][1] = distance;
                this.di[pa][2] = actAtom;
                this.sAtom[this.sphereSize] = pa;
                ++this.sphereSize;
                if (this.initCharge[pa] <= 0) continue;
                this.allowPosResonance = true;
            }
            if (this.sAtom[i] != -1) {
                actAtom = this.sAtom[i];
                distance = this.di[actAtom][1] + 1;
                sChange = true;
            } else {
                sChange = false;
            }
            if (++i != this.atomCount) continue;
            sChange = false;
        }
        if (this.sphereSize != 0) {
            this.di[acc][0] = 1;
            this.di[acc][1] = 0;
            if (this.initCharge[acc] > 0) {
                this.allowPosResonance = true;
            }
        }
        if (this.getResStructures) {
            this.allowPosResonance = true;
        }
    }

    private boolean isBlocking(int ai) {
        if (this.tSearch) {
            if (this.isDonor(ai)) {
                return false;
            }
            if (this.isAcceptor(ai)) {
                return false;
            }
            return !this.isExcludedAtom(ai);
        }
        return false;
    }

    private void getChain(Molecule m, int acc) {
        int actAtom = acc;
        this.sphereSize = 0;
        this.di = new int[this.atomCount][3];
        for (int i = 0; i < this.atomCount; ++i) {
            this.sAtom[i] = -1;
        }
        int distance = 1;
        boolean sChange = true;
        int i = 0;
        int y = this.atomCount + 1;
        MolAtom a = m.getAtom(actAtom);
        int bc = a.getBondCount();
        while (distance < y & sChange) {
            sChange = false;
            for (int j = 0; j < bc; ++j) {
                MolBond b = a.getBond(j);
                MolAtom aa = b.getOtherAtom(a);
                int pa = m.indexOf(aa);
                if (this.di[pa][0] == 1 || pa == acc) continue;
                this.di[pa][0] = 1;
                this.di[pa][1] = distance;
                this.di[pa][2] = actAtom;
                this.sAtom[this.sphereSize] = pa;
                ++this.sphereSize;
            }
            if (this.sAtom[i] != -1) {
                actAtom = this.sAtom[i];
                distance = this.di[actAtom][1] + 1;
                sChange = true;
                a = m.getAtom(actAtom);
                bc = a.getBondCount();
            } else {
                sChange = false;
            }
            if (++i != this.atomCount) continue;
            sChange = false;
        }
        if (this.sphereSize != 0) {
            this.di[acc][0] = 1;
            this.di[acc][1] = 0;
        }
    }

    private boolean isArA(int atom) {
        if (atom >= this.atomCount) {
            return false;
        }
        if (this.aAtom[atom] == 1) {
            return true;
        }
        return this.tautomerType == 3 && this.lAra[atom] == 1;
    }

    private String getSmiles(Molecule mol) {
        try {
            String cxsmiles = MolExporter.exportToFormat(mol, "cxsmiles");
            StringTokenizer st = new StringTokenizer(cxsmiles);
            return st.nextToken();
        }
        catch (IllegalArgumentException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private void postFiltering() {
        boolean pexpH = this.protectExpH;
        this.protectExpH = false;
        this.postFilterStep = true;
        this.tSmiles = new String[this.tautomerCount + 1];
        this.tExist = new int[this.tautomerCount + 1];
        for (int i = 0; i <= this.tautomerCount; ++i) {
            this.tExist[i] = i;
        }
        Molecule m = this.oMol.cloneMoleculeWithDocument();
        this.setWigglyBond(m);
        String s = this.getSmiles(m);
        if (s == null) {
            this.tautomerCount = 0;
            this.postFilterStep = false;
            this.protectExpH = pexpH;
        }
        this.tCount = 1;
        for (int i = 0; i < this.tautomerCount; ++i) {
            m = this.createTMolecule(i, true);
            this.tSmiles[i] = this.getSmiles(m);
            int indx = this.isExistYet(this.tSmiles[i], i);
            if (indx == -1) {
                if (s.equals(this.tSmiles[i])) continue;
                this.tExist[this.tCount - 1] = i;
                ++this.tCount;
                continue;
            }
            this.tauCouples[i][0] = -1;
            this.tauCouples[i][1] = indx;
        }
        this.tautomerCount = this.tCount - 1;
        this.postFilterStep = false;
        this.protectExpH = pexpH;
    }

    private int isExistYet(String smiles, int actInd) {
        for (int i = 0; i < actInd; ++i) {
            if (!this.tSmiles[i].equals(smiles)) continue;
            return i;
        }
        return -1;
    }

    private Molecule createTMolecule(int ti, boolean p) {
        Molecule m = null;
        m = p ? this.oMol.cloneMoleculeWithDocument() : this.oMol;
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.tBtab[ti][i] == null) continue;
            for (int j = 0; j < this.tBtab[ti][i].length; ++j) {
                int bt = this.tBtab[ti][i][j];
                int nb = this.getTCtabAtomIndex(i, j, ti);
                MolBond actBond = m.getBond(this.bHtab[i][nb]);
                actBond.setFlags(bt);
            }
        }
        this.setTauCharge(m, ti);
        this.setTauRadical(m, ti);
        this.setTauH(m, ti);
        if (!this.postFilterStep && this.ringChainTau && this.getRingTauFlag()) {
            this.createRingChainTautomers(m, ti);
        }
        if (this.protectExpH) {
            this.setExplicitHydrogens(m, ti);
        }
        this.setWigglyBond(m);
        return m;
    }

    private void setTauCharge(Molecule m, int ti) {
        if (this.chargeFlag || this.radicalExist) {
            int size = this.dCount + this.aCount;
            for (int i = 0; i < size; ++i) {
                int tc;
                int ai = this.getDonAccAtom(i);
                MolAtom a = m.getAtom(ai);
                int actualCharge = a.getCharge();
                if (actualCharge == (tc = this.getResonantCharge(ai, ti))) continue;
                a.setCharge(tc);
            }
        }
    }

    private void setTauRadical(Molecule m, int ti) {
        int size = this.dCount + this.aCount;
        block8: for (int i = 0; i < size; ++i) {
            int ai = this.getDonAccAtom(i);
            MolAtom a = m.getAtom(ai);
            int rc = this.getResonantRCount(ai, ti) + this.implicitRCount[ti][i];
            switch (rc) {
                case 0: {
                    a.setRadical(0);
                    continue block8;
                }
                case 1: {
                    a.setRadical(1);
                    continue block8;
                }
                case 2: {
                    a.setRadical(6);
                    continue block8;
                }
                case 3: {
                    if (this.tLPCount[ti][i] != 0) {
                        a.setRadical(1);
                        continue block8;
                    }
                    a.setRadical(3);
                    continue block8;
                }
                case 4: {
                    int rchg = this.getResonantCharge(ai, ti);
                    if (rchg == 0 || rchg < 0) {
                        a.setRadical(0);
                        continue block8;
                    }
                    if (rchg <= 0) continue block8;
                    a.setRadical(6);
                    continue block8;
                }
                case 5: {
                    int rchg = this.getResonantCharge(ai, ti);
                    if (rchg == 0 || rchg < 0) {
                        a.setRadical(1);
                        continue block8;
                    }
                    if (rchg <= 0) continue block8;
                    a.setRadical(6);
                    continue block8;
                }
                default: {
                    a.setRadical(3);
                }
            }
        }
    }

    private void setTauH(Molecule m, int ti) {
        int size = this.dCount + this.aCount;
        for (int i = 0; i < size; ++i) {
            int hc;
            int ai = this.getDonAccAtom(i);
            MolAtom a = m.getAtom(ai);
            int actualHCount = a.getImplicitHcount();
            if (actualHCount != (hc = this.getResStructures ? this.initHCount[ai] : this.tHCount[ti][i])) {
                a.setImplicitHcount(hc);
            }
            if (this.getResStructures || hc == 0 || this.protonC[ai] == 6 || this.protonC[ai] == 7 || this.protonC[ai] == 8) continue;
            int vc = this.getBEC(ti, ai);
            a.setValenceProp(vc);
            a.setValenceProp(-1);
        }
    }

    private int getBEC(int ti, int a) {
        int be = 0;
        int ai = this.getDonAccIndex(a);
        if (this.tECount[ti][a] == 0) {
            be += this.tHCount[ti][ai];
            for (int i = 0; i < this.cHtab[a].length; ++i) {
                int nb = this.cHtab[a][i];
                if (nb >= this.atomCount) continue;
                be += this.oMol.getBond(this.bHtab[a][nb]).getType();
            }
        } else {
            be = this.tECount[ti][a];
            be += this.tHCount[ti][ai];
            for (int i = 0; i < this.cHtab[a].length; ++i) {
                int nb = this.cHtab[a][i];
                if (nb >= this.atomCount || this.delocAble[nb] != -1) continue;
                be += this.oMol.getBond(this.bHtab[a][nb]).getType();
            }
        }
        return be;
    }

    private int[] getExplicitHydrogenType(int idx) {
        int oidx = this.getExpAtomIdx(idx);
        MolAtom a = this.mol.getAtom(oidx);
        int[] htype = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        int bc = a.getBondCount();
        for (int j = 0; j < bc; ++j) {
            MolBond b = a.getBond(j);
            MolAtom aa = b.getOtherAtom(a);
            if (aa.getSymbol().equals("H")) {
                int m = aa.getMassno();
                switch (m) {
                    case 0: {
                        htype[2] = htype[2] + 1;
                        break;
                    }
                    case 1: {
                        htype[3] = htype[3] + 1;
                        break;
                    }
                    case 2: {
                        htype[4] = htype[4] + 1;
                        break;
                    }
                    case 3: {
                        htype[5] = htype[5] + 1;
                        break;
                    }
                    case 4: {
                        htype[6] = htype[6] + 1;
                        break;
                    }
                    case 5: {
                        htype[7] = htype[7] + 1;
                        break;
                    }
                    case 6: {
                        htype[8] = htype[8] + 1;
                    }
                }
                continue;
            }
            if (aa.getSymbol().equals(DEUTERIUM_SEPARATOR)) {
                htype[1] = htype[1] + 1;
                continue;
            }
            if (!aa.getSymbol().equals(TRICIUM_SEPARATOR)) continue;
            htype[0] = htype[0] + 1;
        }
        return htype;
    }

    public void setExplicitHydrogens(Molecule m, int ti) {
        this.addExplicitHydrogens(m, ti);
    }

    private int getExpAtomIdx(int ai) {
        return ai - this.indxShift[ai];
    }

    private void addExplicitHydrogens(MoleculeGraph m, int ti) {
        int ac = m.getAtomCount();
        int y = 0;
        int[] htype = new int[9];
        int addedHcount = 0;
        for (int i = 0; i < ac; ++i) {
            int removedH = 0;
            if (this.ringChainTau && this.getRingTauFlag() && this.getActRingLpAtom() == i) {
                removedH = -1;
            }
            if (ti != -1) {
                int indx = this.getDonAccIndex(i);
                if (indx != -1) {
                    y = this.getExpHDTCount(this.tExpHCount[ti][indx]) + removedH;
                    htype = this.getExpHDTCountTypes(this.tExpHCount[ti][indx]);
                } else {
                    y = this.getExpHDTCount(this.initExpHCount[i]) + removedH;
                    htype = this.getExpHDTCountTypes(this.initExpHCount[i]);
                }
            } else {
                y = this.getExpHDTCount(this.initExpHCount[i]) + removedH;
                htype = this.getExpHDTCountTypes(this.initExpHCount[i]);
            }
            int t = 0;
            MolAtom g = m.getAtom(i);
            MolAtom[] ma = new MolAtom[]{g};
            for (int j = 0; j < y; ++j) {
                MolAtom a = new MolAtom(1);
                m.add(a);
                MolBond b = new MolBond(a, g);
                m.add(b);
                try {
                    a = m.getAtom(addedHcount + ac);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    continue;
                }
                ++addedHcount;
                boolean find = false;
                String ht = "H";
                while (!find && t < 9) {
                    if (htype[t] != 0) {
                        if (t == 2) {
                            ht = "H";
                            a.setForSpecIsotopeSymbol(ht);
                        } else if (t == 3) {
                            ht = "H";
                            a.setForSpecIsotopeSymbol(ht);
                            a.setMassno(1);
                        } else if (t == 1) {
                            ht = DEUTERIUM_SEPARATOR;
                            a.setForSpecIsotopeSymbol(ht);
                        } else if (t == 0) {
                            ht = TRICIUM_SEPARATOR;
                            a.setForSpecIsotopeSymbol(ht);
                        } else if (t == 4) {
                            ht = "H";
                            a.setForSpecIsotopeSymbol(ht);
                            a.setMassno(2);
                        } else if (t == 5) {
                            ht = "H";
                            a.setForSpecIsotopeSymbol(ht);
                            a.setMassno(3);
                        } else if (t == 6) {
                            ht = "H";
                            a.setForSpecIsotopeSymbol(ht);
                            a.setMassno(4);
                        } else if (t == 7) {
                            ht = "H";
                            a.setForSpecIsotopeSymbol(ht);
                            a.setMassno(5);
                        } else if (t == 8) {
                            ht = "H";
                            a.setForSpecIsotopeSymbol(ht);
                            a.setMassno(6);
                        }
                        int n = t;
                        htype[n] = htype[n] - 1;
                        find = true;
                        continue;
                    }
                    ++t;
                }
            }
        }
    }

    private int getExpHDTCount(int hType) {
        if (hType == 0) {
            return 0;
        }
        int[] y = new int[9];
        int m = 100000000;
        int s = 0;
        int sum = 0;
        for (int i = 8; i >= 0; --i) {
            y[i] = (hType - s) / m;
            s += y[i] * m;
            m /= 10;
            sum += y[i];
        }
        if (this.genericCalc) {
            sum = sum - y[2] - y[3];
        }
        return sum;
    }

    private int[] getExpHTypes(int hType) {
        int[] y = new int[9];
        if (hType == 0) {
            return y;
        }
        int m = 100000000;
        int s = 0;
        for (int i = 8; i >= 0; --i) {
            y[i] = (hType - s) / m;
            s += y[i] * m;
            m /= 10;
        }
        return y;
    }

    public int[] getFixedAtomIndexesForPartialClean() {
        return this.CAtIndx;
    }

    private int getChildCharge(int a, int tnew) {
        if (!this.chargeFlag) {
            return this.initCharge[a];
        }
        int aind = this.getDonAccIndex(a);
        if (aind == -1) {
            return this.initCharge[a];
        }
        if (this.ActDonorType == 1 || this.ActDonorType == 6) {
            return this.getParentCharge(a);
        }
        if (this.tautomerType == 1) {
            int achg;
            int dchg;
            int don = this.tPath[tnew][this.tPath[tnew].length - 1];
            int acc = this.tPath[tnew][0];
            if (this.isHSender(don)) {
                return this.getParentCharge(a);
            }
            if (this.initCharge[don] < 0 || this.initCharge[acc] > 0) {
                dchg = this.initCharge[don] + 1;
                achg = this.initCharge[acc] - 1;
                if (a == don) {
                    return dchg;
                }
                if (a == acc) {
                    return achg;
                }
            }
            if (this.getResStructures) {
                dchg = this.initCharge[don] + 1;
                achg = this.initCharge[acc] - 1;
                if (a == don) {
                    return dchg;
                }
                if (a == acc) {
                    return achg;
                }
            }
            return this.initCharge[a];
        }
        if (this.tautomerType == 2) {
            int a1 = this.tAtoms[this.parentT1][aind];
            int a2 = this.tAtoms[this.parentT2][aind];
            if (a1 != 0) {
                return this.tCharge[this.parentT1][aind];
            }
            if (a2 != 0) {
                return this.tCharge[this.parentT2][aind];
            }
            if (this.tCharge[this.parentT1][aind] != 0) {
                return this.tCharge[this.parentT1][aind];
            }
            if (this.tCharge[this.parentT2][aind] != 0) {
                return this.tCharge[this.parentT2][aind];
            }
        } else if (this.tautomerType == 3) {
            int achg;
            int dchg;
            int don = this.tPath[tnew][this.tPath[tnew].length - 1];
            int acc = this.tPath[tnew][0];
            if (this.isHSender(don)) {
                return this.getParentCharge(a);
            }
            int di = this.getDonAccIndex(don);
            int ai = this.getDonAccIndex(acc);
            if (this.tCharge[this.parentT1][di] < 0 || this.tCharge[this.parentT1][ai] > 0) {
                dchg = this.tCharge[this.parentT1][di] + 1;
                achg = this.tCharge[this.parentT1][ai] - 1;
                if (a == don) {
                    return dchg;
                }
                if (a == acc) {
                    return achg;
                }
            }
            if (this.getResStructures) {
                dchg = this.tCharge[this.parentT1][di] + 1;
                achg = this.tCharge[this.parentT1][ai] - 1;
                if (a == don) {
                    return dchg;
                }
                if (a == acc) {
                    return achg;
                }
            }
            return this.tCharge[this.parentT1][aind];
        }
        return this.initCharge[a];
    }

    private void setBaseTauCharge(int ti) {
        int size = this.dCount + this.aCount;
        this.tCharge[ti] = new int[size];
        for (int i = 0; i < size; ++i) {
            this.tCharge[ti][i] = this.initCharge[this.getDonAccAtom(i)];
        }
        boolean change = true;
        int don = this.tPath[ti][this.tPath[ti].length - 1];
        int acc = this.tPath[ti][0];
        if (this.ActDonorType == 1 || this.ActDonorType == 6 || this.ActDonorType == 7) {
            change = false;
        }
        if (this.isHSender(don)) {
            change = false;
        }
        if (change) {
            if (this.getResStructures) {
                int di = this.getDonAccIndex(don);
                int ai = this.getDonAccIndex(acc);
                this.tCharge[ti][ai] = this.initCharge[acc] - 1;
                this.tCharge[ti][di] = this.initCharge[don] + 1;
            } else if (this.initCharge[don] < 0 || this.initCharge[acc] > 0) {
                int di = this.getDonAccIndex(don);
                int ai = this.getDonAccIndex(acc);
                this.tCharge[ti][ai] = this.initCharge[acc] - 1;
                this.tCharge[ti][di] = this.initCharge[don] + 1;
            }
        }
    }

    private void setLTauCharge(int texist, int tnew) {
        int size = this.dCount + this.aCount;
        this.tCharge[tnew] = new int[size];
        for (int i = 0; i < size; ++i) {
            this.tCharge[tnew][i] = this.tCharge[texist][i];
        }
        boolean change = true;
        int don = this.tPath[tnew][this.tPath[tnew].length - 1];
        int acc = this.tPath[tnew][0];
        if (this.ActDonorType == 1 || this.ActDonorType == 6 || this.ActDonorType == 7) {
            change = false;
        }
        if (this.isHSender(don)) {
            change = false;
        }
        if (change) {
            int di = this.getDonAccIndex(don);
            int ai = this.getDonAccIndex(acc);
            if (this.getResStructures) {
                this.tCharge[tnew][di] = this.tCharge[texist][di] + 1;
                this.tCharge[tnew][ai] = this.tCharge[texist][ai] - 1;
            } else if (this.tCharge[texist][di] < 0 || this.tCharge[texist][ai] > 0) {
                this.tCharge[tnew][di] = this.tCharge[texist][di] + 1;
                this.tCharge[tnew][ai] = this.tCharge[texist][ai] - 1;
            }
        }
    }

    private void addCharges(int t1, int t2, int tnew) {
        int size = this.dCount + this.aCount;
        this.tCharge[tnew] = new int[size];
        for (int i = 0; i < size; ++i) {
            int a1 = this.tAtoms[t1][i];
            int a2 = this.tAtoms[t2][i];
            if (a1 != 0) {
                this.tCharge[tnew][i] = this.tCharge[t1][i];
                continue;
            }
            if (a2 != 0) {
                this.tCharge[tnew][i] = this.tCharge[t2][i];
                continue;
            }
            if (this.tCharge[t1][i] != 0) {
                this.tCharge[tnew][i] = this.tCharge[t1][i];
                continue;
            }
            if (this.tCharge[t2][i] == 0) continue;
            this.tCharge[tnew][i] = this.tCharge[t2][i];
        }
    }

    private void setBaseHCount(int ti) {
        int size = this.dCount + this.aCount;
        this.tHCount[ti] = new int[size];
        this.tExpHCount[ti] = new int[size];
        for (int i = 0; i < size; ++i) {
            int indx = this.getDonAccAtom(i);
            this.tHCount[ti][i] = this.initHCount[indx];
            this.tExpHCount[ti][i] = this.initExpHCount[indx];
        }
        boolean Change = true;
        int don = this.tPath[ti][this.tPath[ti].length - 1];
        int acc = this.tPath[ti][0];
        if (this.ActDonorType == 1 || this.ActDonorType == 2 || this.ActDonorType == 6 || this.ActDonorType == 8 || this.ActDonorType == 7) {
            Change = false;
        }
        if (this.getResStructures) {
            Change = false;
        }
        if (!this.isHSender(don)) {
            Change = false;
        }
        if (Change) {
            int di = this.getDonAccIndex(don);
            int ai = this.getDonAccIndex(acc);
            if (this.initCharge[don] == 0 && this.initCharge[acc] == 0) {
                this.tHCount[ti][ai] = this.initHCount[acc] + 1;
                this.tHCount[ti][di] = this.initHCount[don] - 1;
                if (this.initExpHCount[don] != 0) {
                    this.tExpHCount[ti][di] = this.setExpHDTCount(this.initExpHCount[don], this.initExpHCount[acc], -1);
                    this.tExpHCount[ti][ai] = this.setExpHDTCount(this.initExpHCount[don], this.initExpHCount[acc], 1);
                }
            } else if (this.initCharge[don] == 0 && this.initCharge[acc] != 0 && this.methylDonor) {
                this.tHCount[ti][ai] = this.initHCount[acc] + 1;
                this.tHCount[ti][di] = this.initHCount[don] - 1;
                if (this.initExpHCount[don] != 0) {
                    this.tExpHCount[ti][di] = this.setExpHDTCount(this.initExpHCount[don], this.initExpHCount[acc], -1);
                    this.tExpHCount[ti][ai] = this.setExpHDTCount(this.initExpHCount[don], this.initExpHCount[acc], 1);
                }
            }
        }
    }

    private void setLTauHCount(int texist, int tnew) {
        int size = this.dCount + this.aCount;
        this.tHCount[tnew] = new int[size];
        this.tExpHCount[tnew] = new int[size];
        for (int i = 0; i < size; ++i) {
            this.tHCount[tnew][i] = this.tHCount[texist][i];
            this.tExpHCount[tnew][i] = this.tExpHCount[texist][i];
        }
        boolean Change = true;
        int don = this.tPath[tnew][this.tPath[tnew].length - 1];
        int acc = this.tPath[tnew][0];
        if (this.ActDonorType == 1 || this.ActDonorType == 2 || this.ActDonorType == 6 || this.ActDonorType == 8 || this.ActDonorType == 7) {
            Change = false;
        }
        if (this.getResStructures) {
            Change = false;
        }
        if (!this.isHSender(don)) {
            Change = false;
        }
        if (Change) {
            int di = this.getDonAccIndex(don);
            int ai = this.getDonAccIndex(acc);
            int donChg = this.initCharge[don];
            int accChg = this.initCharge[acc];
            if (this.chargeFlag) {
                donChg = this.tCharge[texist][di];
                accChg = this.tCharge[texist][ai];
            }
            if (donChg == 0 && accChg == 0) {
                this.tHCount[tnew][di] = this.tHCount[texist][di] - 1;
                this.tHCount[tnew][ai] = this.tHCount[texist][ai] + 1;
                if (this.tExpHCount[texist][di] != 0) {
                    this.tExpHCount[tnew][di] = this.setExpHDTCount(this.tExpHCount[texist][di], this.tExpHCount[texist][ai], -1);
                    this.tExpHCount[tnew][ai] = this.setExpHDTCount(this.tExpHCount[texist][di], this.tExpHCount[texist][ai], 1);
                }
            } else if (donChg == 0 && accChg != 0 && this.methylDonor) {
                this.tHCount[tnew][di] = this.tHCount[texist][di] - 1;
                this.tHCount[tnew][ai] = this.tHCount[texist][ai] + 1;
                if (this.tExpHCount[texist][di] != 0) {
                    this.tExpHCount[tnew][di] = this.setExpHDTCount(this.tExpHCount[texist][di], this.tExpHCount[texist][ai], -1);
                    this.tExpHCount[tnew][ai] = this.setExpHDTCount(this.tExpHCount[texist][di], this.tExpHCount[texist][ai], 1);
                }
            }
        }
    }

    private void addHCounts(int t1, int t2, int tnew) {
        int size = this.dCount + this.aCount;
        this.tHCount[tnew] = new int[size];
        this.tExpHCount[tnew] = new int[size];
        for (int i = 0; i < size; ++i) {
            if (this.tAtoms[t1][i] != 0) {
                this.tHCount[tnew][i] = this.tHCount[t1][i];
                this.tExpHCount[tnew][i] = this.tExpHCount[t1][i];
                continue;
            }
            if (this.tAtoms[t2][i] != 0) {
                this.tHCount[tnew][i] = this.tHCount[t2][i];
                this.tExpHCount[tnew][i] = this.tExpHCount[t2][i];
                continue;
            }
            if (this.tHCount[t1][i] != 0) {
                this.tHCount[tnew][i] = this.tHCount[t1][i];
                this.tExpHCount[tnew][i] = this.tExpHCount[t1][i];
                continue;
            }
            if (this.tHCount[t2][i] == 0) continue;
            this.tHCount[tnew][i] = this.tHCount[t2][i];
            this.tExpHCount[tnew][i] = this.tExpHCount[t2][i];
        }
    }

    private void setInitHDTCount(int exph) {
        int y = this.oMol.getAtomCount();
        this.initExpHCount = new int[y];
        int[] h = new int[9];
        if (exph != 0 && this.protectExpH) {
            for (int i = 0; i < y; ++i) {
                h = this.getExplicitHydrogenType(i);
                int m = 1;
                for (int j = 0; j < 9; ++j) {
                    int n = i;
                    this.initExpHCount[n] = this.initExpHCount[n] + h[j] * m;
                    m = 10 * m;
                }
            }
        }
    }

    private int setExpHDTCount(int dHType, int aHType, int lg) {
        int[] h = new int[9];
        h = this.getExpHTypes(dHType);
        switch (lg) {
            case 1: {
                if (h[2] != 0) {
                    aHType += 100;
                } else if (h[3] != 0) {
                    aHType += 1000;
                } else if (h[1] != 0) {
                    aHType += 10;
                } else if (h[0] != 0) {
                    ++aHType;
                } else if (h[4] != 0) {
                    aHType += 10000;
                } else if (h[5] != 0) {
                    aHType += 100000;
                } else if (h[6] != 0) {
                    aHType += 1000000;
                } else if (h[7] != 0) {
                    aHType += 10000000;
                } else if (h[8] != 0) {
                    aHType += 100000000;
                }
                return aHType;
            }
            case -1: {
                if (h[2] != 0) {
                    dHType -= 100;
                } else if (h[3] != 0) {
                    dHType -= 1000;
                } else if (h[1] != 0) {
                    dHType -= 10;
                } else if (h[0] != 0) {
                    --dHType;
                } else if (h[4] != 0) {
                    dHType -= 10000;
                } else if (h[5] != 0) {
                    dHType -= 100000;
                } else if (h[6] != 0) {
                    dHType -= 1000000;
                } else if (h[7] != 0) {
                    dHType -= 10000000;
                } else if (h[8] != 0) {
                    dHType -= 100000000;
                }
                return dHType;
            }
        }
        return -1;
    }

    private int[] getExpHDTCountTypes(int hType) {
        int[] h = new int[9];
        if (hType == 0) {
            return h;
        }
        h = this.getExpHTypes(hType);
        if (this.genericCalc) {
            h[2] = 0;
            h[3] = 0;
        }
        return h;
    }

    private int getChildHcount(int a, int tnew) {
        if (this.getResStructures) {
            return this.initHCount[a];
        }
        if (this.ActDonorType == 1 || this.ActDonorType == 6 || this.ActDonorType == 8 || this.ActDonorType == 2 || this.ActDonorType == 7) {
            return this.getParentHCount(a);
        }
        int aind = this.getDonAccIndex(a);
        if (aind == -1) {
            return this.initHCount[a];
        }
        if (this.tautomerType == 1) {
            int don = this.tPath[tnew][this.tPath[tnew].length - 1];
            int acc = this.tPath[tnew][0];
            if (!this.isHSender(don)) {
                return this.getParentHCount(a);
            }
            if (this.initCharge[don] == 0 && this.initCharge[acc] == 0) {
                int dHc = this.initHCount[don] - 1;
                int aHc = this.initHCount[acc] + 1;
                if (a == don) {
                    return dHc;
                }
                if (a == acc) {
                    return aHc;
                }
            } else if (this.initCharge[don] == 0 && this.initCharge[acc] < 0 && this.methylDonor) {
                int dHc = this.initHCount[don] - 1;
                int aHc = this.initHCount[acc] + 1;
                if (a == don) {
                    return dHc;
                }
                if (a == acc) {
                    return aHc;
                }
            }
            return this.initHCount[a];
        }
        if (this.tautomerType == 2) {
            int a1 = this.tAtoms[this.parentT1][aind];
            int a2 = this.tAtoms[this.parentT2][aind];
            if (a1 != 0) {
                return this.tHCount[this.parentT1][aind];
            }
            if (a2 != 0) {
                return this.tHCount[this.parentT2][aind];
            }
            if (this.tHCount[this.parentT1][aind] != 0) {
                return this.tHCount[this.parentT1][aind];
            }
            if (this.tHCount[this.parentT2][aind] != 0) {
                return this.tHCount[this.parentT2][aind];
            }
        } else if (this.tautomerType == 3) {
            int don = this.tPath[tnew][this.tPath[tnew].length - 1];
            int acc = this.tPath[tnew][0];
            if (!this.isHSender(don)) {
                return this.getParentHCount(a);
            }
            int di = this.getDonAccIndex(don);
            int ai = this.getDonAccIndex(acc);
            int donChg = this.initCharge[don];
            int accChg = this.initCharge[acc];
            if (this.chargeFlag) {
                donChg = this.tCharge[this.parentT1][di];
                accChg = this.tCharge[this.parentT1][ai];
            }
            if (donChg == 0 && accChg == 0) {
                int dHc = this.tHCount[this.parentT1][di] - 1;
                int aHc = this.tHCount[this.parentT1][ai] + 1;
                if (a == don) {
                    return dHc;
                }
                if (a == acc) {
                    return aHc;
                }
            } else if (donChg == 0 && accChg < 0 && this.methylDonor) {
                int dHc = this.tHCount[this.parentT1][di] - 1;
                int aHc = this.tHCount[this.parentT1][ai] + 1;
                if (a == don) {
                    return dHc;
                }
                if (a == acc) {
                    return aHc;
                }
            }
            return this.tHCount[this.parentT1][aind];
        }
        return 0;
    }

    private void addRCounts(int t1, int t2, int tnew) {
        int size = this.dCount + this.aCount;
        this.tRCount[tnew] = new int[size];
        if (this.radicalExist) {
            for (int i = 0; i < size; ++i) {
                int a1 = this.tAtoms[t1][i];
                int a2 = this.tAtoms[t2][i];
                if (a1 != 0) {
                    this.tRCount[tnew][i] = this.tRCount[t1][i];
                    continue;
                }
                if (a2 != 0) {
                    this.tRCount[tnew][i] = this.tRCount[t2][i];
                    continue;
                }
                if (this.tRCount[t1][i] != 0) {
                    this.tRCount[tnew][i] = this.tRCount[t1][i];
                    continue;
                }
                if (this.tRCount[t2][i] == 0) continue;
                this.tRCount[tnew][i] = this.tRCount[t2][i];
            }
        }
    }

    private void setTauLPCount(int tnew) {
        this.falseTautomer = false;
        int size = this.dCount + this.aCount;
        int don = this.tPath[tnew][this.tPath[tnew].length - 1];
        int acc = this.tPath[tnew][0];
        this.tLPCount[tnew] = new int[size];
        this.tRCount[tnew] = new int[size];
        this.implicitRCount[tnew] = new int[size];
        for (int i = 0; i < size; ++i) {
            int ai = this.getDonAccAtom(i);
            if (ai == don || ai == acc) continue;
            if (this.tautomerType == 1) {
                this.tLPCount[tnew][i] = this.initLPCount[ai];
                this.tRCount[tnew][i] = this.initRCount[ai];
                this.implicitRCount[tnew][i] = 0;
                continue;
            }
            this.tLPCount[tnew][i] = this.tLPCount[this.parentT1][i];
            this.tRCount[tnew][i] = this.tRCount[this.parentT1][i];
            this.implicitRCount[tnew][i] = this.implicitRCount[this.parentT1][i];
        }
        this.setShell(don, tnew);
        if (!this.falseTautomer) {
            this.setShell(acc, tnew);
        }
    }

    private void addLPCount(int t1, int t2, int tnew) {
        int a2;
        int a1;
        int i;
        int size = this.dCount + this.aCount;
        this.tLPCount[tnew] = new int[size];
        this.implicitRCount[tnew] = new int[size];
        for (i = 0; i < size; ++i) {
            a1 = this.tAtoms[t1][i];
            a2 = this.tAtoms[t2][i];
            if (a1 != 0) {
                this.tLPCount[tnew][i] = this.tLPCount[t1][i];
                continue;
            }
            if (a2 != 0) {
                this.tLPCount[tnew][i] = this.tLPCount[t2][i];
                continue;
            }
            if (this.tLPCount[t1][i] != 0) {
                this.tLPCount[tnew][i] = this.tLPCount[t1][i];
                continue;
            }
            if (this.tLPCount[t2][i] == 0) continue;
            this.tLPCount[tnew][i] = this.tLPCount[t2][i];
        }
        if (this.chargeFlag || this.radicalExist) {
            for (i = 0; i < size; ++i) {
                a1 = this.tAtoms[t1][i];
                a2 = this.tAtoms[t2][i];
                if (a1 != 0) {
                    this.implicitRCount[tnew][i] = this.implicitRCount[t1][i];
                    continue;
                }
                if (a2 != 0) {
                    this.implicitRCount[tnew][i] = this.implicitRCount[t2][i];
                    continue;
                }
                if (this.implicitRCount[t1][i] != 0) {
                    this.implicitRCount[tnew][i] = this.implicitRCount[t1][i];
                    continue;
                }
                if (this.implicitRCount[t2][i] == 0) continue;
                this.implicitRCount[tnew][i] = this.implicitRCount[t2][i];
            }
        }
    }

    private void setShell(int a, int ti) {
        int ai = this.getDonAccIndex(a);
        int bc = this.getBECount(a, ai, ti);
        if (this.protonC[a] <= 10) {
            this.setCells(4, a, ai, bc, ti);
        } else if (this.protonC[a] > 10) {
            this.setCells(4, a, ai, bc, ti);
            if (this.falseTautomer) {
                this.setCells(5, a, ai, bc, ti);
                if (this.falseTautomer) {
                    this.setCells(6, a, ai, bc, ti);
                }
            }
        }
    }

    private boolean isNO2TypeForm(int a, int bc, int ti) {
        int chg;
        if (this.protonC[a] == 7 && bc == 5 && (chg = this.getResonantCharge(a, ti)) == 0) {
            boolean cond1 = false;
            boolean cond2 = false;
            boolean cond3 = false;
            for (int i = 0; i < this.cHtab[a].length; ++i) {
                int nb = this.cHtab[a][i];
                if (nb >= this.atomCount) continue;
                int bt = this.getResonantBondType(nb, a, ti);
                if (bt == 2 && this.protonC[nb] == 8) {
                    if (this.cHtab[nb].length == 2) continue;
                    cond1 = true;
                    continue;
                }
                if (bt == 3) {
                    cond2 = true;
                    continue;
                }
                if (bt != 2) continue;
                cond3 = true;
            }
            if (cond1) {
                return true;
            }
            if (cond2 && cond3) {
                return true;
            }
        }
        return false;
    }

    private void setCells(int cellCount, int a, int ai, int bc, int ti) {
        int i;
        int chg;
        int ck = cellCount;
        this.falseTautomer = false;
        int chgC = chg = this.getResonantCharge(a, ti);
        if (chg < 0) {
            chgC = -chgC;
        }
        int pc = this.protonC[a];
        int rc = 0;
        int lp = 0;
        int extraChg = 0;
        int maxECount = this.gn[pc];
        if (maxECount == 0) {
            this.falseTautomer = true;
            return;
        }
        int[] s = new int[ck];
        int k = 0;
        for (i = 0; i < maxECount; ++i) {
            int n = k++;
            s[n] = s[n] + 1;
            if (k != ck) continue;
            k = 0;
        }
        if (chg < 0) {
            i = 0;
            for (k = ck - 1; i < chgC && k >= 0; --k) {
                if (s[k] != 0) continue;
                int n = k;
                s[n] = s[n] + 1;
                ++i;
            }
            if (i != chgC) {
                for (k = 0; i < chgC && k < ck; ++k) {
                    if (s[k] != 1) continue;
                    int n = k;
                    s[n] = s[n] + 1;
                    ++i;
                }
            }
            if (i != chgC) {
                this.falseTautomer = true;
            }
        }
        int sum = 0;
        for (i = 0; i < ck; ++i) {
            sum += s[i];
        }
        if (sum > 2 * ck) {
            this.falseTautomer = true;
        }
        k = ck - 1;
        while (s[k] == 0) {
            --k;
        }
        i = 0;
        while (i < bc) {
            if (k >= 0) {
                if (s[k] == 1) {
                    int n = k;
                    s[n] = s[n] - 1;
                } else if (s[k] == 2) {
                    int n = k;
                    s[n] = s[n] - 2;
                    ++extraChg;
                }
            } else {
                this.falseTautomer = true;
            }
            ++i;
            --k;
        }
        i = 0;
        k = 0;
        if (chg > 0) {
            if (extraChg > chg) {
                this.falseTautomer = true;
            }
            chgC -= extraChg;
            int c = 0;
            while (i < chgC && k < ck) {
                if (s[k] == 2) {
                    int n = k;
                    s[n] = s[n] - 1;
                    ++i;
                    ++c;
                }
                ++k;
            }
            if (c != chgC) {
                i = c - 1;
                for (k = 0; i < chgC && k < ck; ++k) {
                    if (s[k] != 1) continue;
                    int n = k;
                    s[n] = s[n] - 1;
                    ++i;
                    ++c;
                }
            }
            if (c != chgC) {
                this.falseTautomer = true;
            }
        } else if (extraChg != 0) {
            this.falseTautomer = true;
        }
        rc = 0;
        lp = 0;
        for (i = 0; i < ck; ++i) {
            if (s[i] == 1) {
                ++rc;
                continue;
            }
            if (s[i] != 2) continue;
            ++lp;
        }
        this.tLPCount[ti][ai] = lp;
        if (this.radicalExist) {
            this.tRCount[ti][ai] = rc;
        } else if (rc != 0) {
            this.implicitRCount[ti][ai] = rc;
        }
    }

    private int getBECount(int a, int ai, int ti) {
        int be = this.tECount[ti][a];
        be += this.tHCount[ti][ai];
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int nb = this.cHtab[a][i];
            if (nb >= this.atomCount || this.delocAble[nb] != -1) continue;
            be += this.oMol.getBond(this.bHtab[a][nb]).getType();
        }
        return be;
    }

    private Molecule getMajorTautomericForm() {
        if (this.majorTautomericFormAvailable) {
            return this.getTMolecule(0);
        }
        return null;
    }

    private double getTauScore(Molecule m) {
        this.canT = new CanonicTautomer();
        return this.canT.calcTautomerScore(m);
    }

    public Molecule calcMostStableTautomer() {
        this.mol = this.calcCanonicResonantRepresentator();
        this.mol.aromatize(2);
        boolean pCt = this.canonicType;
        this.canonicType = true;
        this.ratTau = true;
        Molecule m = this.createCanonicTautomer();
        this.canonicType = pCt;
        this.ratTau = false;
        return m;
    }

    public Molecule calcMajorTautomer(Molecule m) {
        Molecule mm = m.cloneMoleculeWithDocument();
        this.setMolecule(mm);
        this.calcDominantTautomerDistribution();
        int tc = this.getTCount();
        if (tc == 1) {
            if (!Double.isNaN(this.pH)) {
                this.getMajorTautomericForm();
            } else {
                return m;
            }
        }
        return this.getMajorTautomericForm();
    }

    public double getTauDistribution(int ti) {
        if (this.getTCount() == 1) {
            return 100.0;
        }
        if (this.dominantTautomerization && !Double.isNaN(this.pH)) {
            if (this.pHTauDistAvailable) {
                int shortInd = this.shortTauIndex[ti];
                return this.tauDist[shortInd];
            }
            return this.tauDist[ti];
        }
        if (this.majorTautomericFormAvailable) {
            int shortInd = this.shortTauIndex[ti];
            return this.tauDist[shortInd];
        }
        return this.tauDist[ti];
    }

    private Molecule getTauDistMolecule(int ti) {
        if (this.getTCount() == 1) {
            return this.oMol;
        }
        if (this.majorTautomericFormAvailable) {
            return this.getTMolecule(ti);
        }
        return null;
    }

    private Molecule calcCanonicResonantRepresentator() {
        CanonicResonant cr = new CanonicResonant();
        cr.setMolecule(this.mol);
        cr.setParentOfCanonicalStructureConserved(true);
        cr.calcCanonicalResonant();
        return cr.getCanonicResonant();
    }

    public void calcDominantTautomerDistribution() {
        this.setTakeDominantTautomers(true);
        this.setSymmetryFiltering(true);
        this.dominantTauDistCalc = true;
        this.createDACouples();
        this.dominantTauDistCalc = false;
        this.ratTau = false;
    }

    private void calcTautomerDistr() {
        boolean pexpH = this.protectExpH;
        this.protectExpH = false;
        boolean ready = false;
        this.majorTautomericFormAvailable = false;
        this.pHTauDistAvailable = false;
        if (this.tautomerCount == 0) {
            this.majorTautomericFormAvailable = true;
            if (Double.isNaN(this.pH)) {
                ready = true;
            }
        }
        if (this.criticalError) {
            return;
        }
        if (!ready) {
            int tc = this.getTCount();
            this.tauScore = new double[tc];
            this.scIndx = new int[tc];
            for (int i = 0; i < tc; ++i) {
                Molecule rt = this.getTMolecule(i);
                this.tauScore[i] = this.getTauScore(rt);
                this.scIndx[i] = i;
            }
            this.sortTauScore(tc);
            this.calcTauDistr();
            if (this.charge.getCriticalErrorFlag()) {
                return;
            }
            if (!Double.isNaN(this.pH)) {
                this.calTaupHDistribution(this.pH);
            } else {
                this.setShortIndex(this.tautomerCount + 1);
            }
        }
        this.protectExpH = pexpH;
    }

    private void sortTauScore(int tc) {
        int w1 = 0;
        for (int i = 0; i < tc; ++i) {
            int kk = i;
            double p = this.tauScore[i];
            for (int jj = i + 1; jj < tc; ++jj) {
                if (!(this.tauScore[jj] >= p)) continue;
                kk = jj;
                p = this.tauScore[jj];
                w1 = this.scIndx[jj];
            }
            if (kk == i) continue;
            this.tauScore[kk] = this.tauScore[i];
            this.tauScore[i] = p;
            this.scIndx[kk] = this.scIndx[i];
            this.scIndx[i] = w1;
        }
    }

    private void calcTauDistr() {
        int i;
        int tauCount = this.getTCount();
        int ratioCount = tauCount * (tauCount - 1) / 2;
        this.tauRatio = new double[ratioCount];
        this.tauND = new int[ratioCount][2];
        int[] at = new int[]{-1, -1, -1};
        int acc = 0;
        int don = 0;
        int y = 0;
        int x = 0;
        boolean missingRatio = false;
        for (i = 0; i < tauCount; ++i) {
            int ii = this.scIndx[i];
            Molecule parentM = this.getTMolecule(ii);
            int pInd = ii;
            Molecule dpM = parentM.cloneMoleculeWithDocument();
            parentM.aromatize(1);
            for (int j = i + 1; j < tauCount; ++j) {
                int jj = this.scIndx[j];
                Molecule childM = this.getTMolecule(jj);
                int cInd = jj;
                Molecule dcM = childM.cloneMoleculeWithDocument();
                childM.aromatize(1);
                at = this.getActADCouple(dpM, dcM);
                if (at != null) {
                    if (at[0] == -1 || at[1] == -1) continue;
                    acc = at[0];
                    don = at[1];
                    double R = 1.0;
                    this.calcpKa(parentM, true, false, 20.0, -10.0);
                    double pka1 = this.ionizer.getpKa(don, -1);
                    if (Double.isNaN(pka1)) {
                        pka1 = 30.0;
                    }
                    this.calcpKa(childM, true, false, 20.0, -10.0);
                    double pka2 = this.ionizer.getpKa(acc, -1);
                    if (Double.isNaN(pka2)) {
                        pka2 = 30.0;
                    }
                    double ka_enol = Math.pow(10.0, -pka1);
                    double ka_keto = Math.pow(10.0, -pka2);
                    R = ka_enol / ka_keto;
                    this.tauND[x][0] = cInd;
                    this.tauND[x][1] = pInd;
                    double corr = 1.0;
                    int D = this.getDist(acc, don, this.tCount);
                    if (D != 0) {
                        if (D >= 4) {
                            MolAtom a = childM.getAtom(acc);
                            if (a.getCharge() == 0 && this.isCacc(acc)) {
                                corr = 1.0E-4;
                            }
                        } else {
                            corr = 1.0206 * Math.pow(2.718282, -0.0316 * (double)D);
                        }
                    }
                    this.tauRatio[x] = R *= corr;
                    ++x;
                    ++y;
                    continue;
                }
                this.tauRatio[x] = 0.0;
                this.tauND[x][0] = pInd;
                this.tauND[x][1] = cInd;
                ++x;
                missingRatio = true;
            }
        }
        this.tauDist = new double[tauCount];
        this.tauDistOrder = new int[tauCount];
        if (missingRatio) {
            boolean stop = false;
            int maxCycle = 10;
            for (int cc = 0; !stop && cc < maxCycle; ++cc) {
                this.sortTauRatio(ratioCount);
                this.setMissingTauRatio(ratioCount, y);
                y = this.getExistingTauRatioCount(ratioCount);
                if (y != ratioCount) continue;
                stop = true;
            }
        }
        if (x != 0) {
            this.sortTauRatio(ratioCount);
            for (i = 0; i < tauCount; ++i) {
                this.tauDistOrder[i] = this.getTauOrder(i, ratioCount);
            }
            this.setTauOrder(tauCount, ratioCount);
            this.setTauDist(tauCount, ratioCount);
        }
        this.majorTautomericFormAvailable = true;
    }

    private boolean isCacc(int acc) {
        return this.protonC[acc] == 6;
    }

    private int getTauOrder(int ti, int rc) {
        int c = 0;
        for (int i = 0; i < rc; ++i) {
            if (this.tauND[i][0] == ti) {
                if (!(this.tauRatio[i] < 1.0)) continue;
                ++c;
                continue;
            }
            if (this.tauND[i][1] != ti || !(this.tauRatio[i] > 1.0)) continue;
            ++c;
        }
        return c;
    }

    private int getExistingTauRatioCount(int ratioCount) {
        int c = 0;
        for (int i = 0; i < ratioCount; ++i) {
            if (this.tauRatio[i] == 0.0) continue;
            ++c;
        }
        return c;
    }

    private void setTauOrder(int tc, int rc) {
        boolean run = true;
        int maxCycle = 10;
        this.scaleTauIndex(tc);
        for (int c = 0; c < maxCycle && run; ++c) {
            run = false;
            for (int i = 0; i < tc; ++i) {
                int w1 = this.tauDistOrder[i];
                for (int j = 0; j < tc; ++j) {
                    int w2 = this.tauDistOrder[j];
                    if (j == i || w1 != w2) continue;
                    if (this.getTauRatio(i, j, rc) > 1.0) {
                        if (w2 <= tc - 1) {
                            if (this.isPreviousTauOrderExist(w2, tc)) {
                                int n = j;
                                this.tauDistOrder[n] = this.tauDistOrder[n] + 1;
                            } else if (!this.isPreviousTauOrderExist(w2, tc)) {
                                if (w2 != 0) {
                                    int n = i;
                                    this.tauDistOrder[n] = this.tauDistOrder[n] - 1;
                                } else {
                                    int n = j;
                                    this.tauDistOrder[n] = this.tauDistOrder[n] + 1;
                                }
                            } else {
                                int n = j;
                                this.tauDistOrder[n] = this.tauDistOrder[n] + 1;
                            }
                        } else {
                            int n = i;
                            this.tauDistOrder[n] = this.tauDistOrder[n] - 1;
                        }
                        run = true;
                        continue;
                    }
                    if (w2 <= tc - 1) {
                        if (!this.isNextTauOrderExist(w2, tc)) {
                            int n = i;
                            this.tauDistOrder[n] = this.tauDistOrder[n] + 1;
                        } else if (!this.isPreviousTauOrderExist(w2, tc)) {
                            if (w2 != 0) {
                                int n = j;
                                this.tauDistOrder[n] = this.tauDistOrder[n] - 1;
                            } else {
                                int n = i;
                                this.tauDistOrder[n] = this.tauDistOrder[n] + 1;
                            }
                        } else {
                            int n = i;
                            this.tauDistOrder[n] = this.tauDistOrder[n] + 1;
                        }
                    } else {
                        int n = j;
                        this.tauDistOrder[n] = this.tauDistOrder[n] - 1;
                    }
                    run = true;
                }
            }
        }
    }

    private void scaleTauIndex(int tc) {
        int i;
        if (tc == 1) {
            return;
        }
        int[] a = new int[tc];
        int[] h = new int[tc];
        for (i = 0; i < tc; ++i) {
            int j;
            int b = this.tauDistOrder[i];
            int c = 0;
            for (j = 0; j < tc; ++j) {
                int n = this.tauDistOrder[j];
                if (n >= b) continue;
                a[n] = 1;
            }
            for (j = 0; j < tc; ++j) {
                if (a[j] != 1) continue;
                ++c;
            }
            int hole = b - c;
            for (j = 0; j < tc; ++j) {
                a[j] = 0;
            }
            h[i] = hole;
        }
        for (i = 0; i < tc; ++i) {
            this.tauDistOrder[i] = this.tauDistOrder[i] - h[i];
        }
    }

    private boolean isPreviousTauOrderExist(int j, int tc) {
        int z = j - 1;
        for (int i = 0; i < tc; ++i) {
            if (this.tauDistOrder[i] != z) continue;
            return true;
        }
        return false;
    }

    private boolean isNextTauOrderExist(int j, int tc) {
        int z = j + 1;
        for (int i = 0; i < tc; ++i) {
            if (this.tauDistOrder[i] != z) continue;
            return true;
        }
        return false;
    }

    private void setTauDist(int tc, int rc) {
        int i;
        int i2;
        int maxIndex = -1;
        for (i2 = 0; i2 < tc; ++i2) {
            if (this.tauDistOrder[i2] != 0) continue;
            this.tauDist[i2] = 100.0;
            maxIndex = i2;
        }
        for (i2 = 0; i2 < rc; ++i2) {
            int Ti;
            if (this.tauND[i2][0] == maxIndex) {
                Ti = this.tauND[i2][1];
                this.tauDist[Ti] = this.tauDist[maxIndex] / this.tauRatio[i2];
            }
            if (this.tauND[i2][1] != maxIndex) continue;
            Ti = this.tauND[i2][0];
            this.tauDist[Ti] = this.tauDist[maxIndex] * this.tauRatio[i2];
        }
        double sum = 0.0;
        for (i = 0; i < tc; ++i) {
            sum += this.tauDist[i];
        }
        for (i = 0; i < tc; ++i) {
            this.tauDist[i] = 100.0 * this.tauDist[i] / sum;
        }
    }

    private void setMissingTauRatio(int rc, int y) {
        for (int i = y; i < rc; ++i) {
            if (this.tauRatio[i] != 0.0) continue;
            int p = this.tauND[i][0];
            int c = this.tauND[i][1];
            this.tauRatio[i] = this.getMissingTauRatio(p, c, y);
        }
    }

    private double getMissingTauRatio(int p, int c, int y) {
        return this.getLargestTauRatio(p, c, y);
    }

    private double getLargestTauRatio(int p, int c, int y) {
        int x = -1;
        double r1 = 0.0;
        double r2 = 0.0;
        double R = 0.0;
        double Rmax = 0.0;
        for (int i = 0; i < y; ++i) {
            int j;
            if (this.tauND[i][0] == p) {
                x = this.tauND[i][1];
                r1 = this.tauRatio[i];
                r2 = -1.0;
                for (j = 0; j < y; ++j) {
                    if (this.tauND[j][0] == x && this.tauND[j][1] == c) {
                        r2 = this.tauRatio[j];
                        R = r1 * r2;
                        if (!(R > Rmax)) continue;
                        Rmax = R;
                        continue;
                    }
                    if (this.tauND[j][0] != c || this.tauND[j][1] != x || !((R = r1 * (1.0 / (r2 = this.tauRatio[j]))) > Rmax)) continue;
                    Rmax = R;
                }
                continue;
            }
            if (this.tauND[i][1] != p) continue;
            x = this.tauND[i][0];
            r1 = this.tauRatio[i];
            r2 = -1.0;
            for (j = 0; j < y; ++j) {
                if (this.tauND[j][0] == x && this.tauND[j][1] == c) {
                    r2 = this.tauRatio[j];
                    R = 1.0 / r1 * r2;
                    if (!(R > Rmax)) continue;
                    Rmax = R;
                    continue;
                }
                if (this.tauND[j][0] != c || this.tauND[j][1] != x || !((R = 1.0 / r1 * (1.0 / (r2 = this.tauRatio[j]))) > Rmax)) continue;
                Rmax = R;
            }
        }
        return Rmax;
    }

    private double getTauRatio(int N, int D, int rc) {
        if (N == D) {
            return 1.0;
        }
        for (int i = 0; i < rc; ++i) {
            int N_exist = this.tauND[i][0];
            int D_exist = this.tauND[i][1];
            if (N == N_exist && D == D_exist) {
                return this.tauRatio[i];
            }
            if (N != D_exist || D != N_exist) continue;
            return 1.0 / this.tauRatio[i];
        }
        return 0.0;
    }

    private void sortTauRatio(int ratioCount) {
        int w1 = 0;
        int w2 = 0;
        for (int i = 0; i < ratioCount; ++i) {
            int kk = i;
            double p = this.tauRatio[i];
            for (int jj = i + 1; jj < ratioCount; ++jj) {
                if (!(this.tauRatio[jj] >= p)) continue;
                kk = jj;
                p = this.tauRatio[jj];
                w1 = this.tauND[jj][0];
                w2 = this.tauND[jj][1];
            }
            if (kk == i) continue;
            this.tauRatio[kk] = this.tauRatio[i];
            this.tauRatio[i] = p;
            this.tauND[kk][0] = this.tauND[i][0];
            this.tauND[kk][1] = this.tauND[i][1];
            this.tauND[i][0] = w1;
            this.tauND[i][1] = w2;
        }
    }

    private int[] getActADCouple(Molecule p, Molecule c) {
        MolAtom a2;
        MolAtom a1;
        int[] AD = new int[]{-1, -1, -1};
        int size = this.dCount + this.aCount;
        int k = 0;
        int acc = 0;
        int don = 0;
        for (int i = 0; i < size; ++i) {
            int cc;
            int ai = this.getDonAccAtom(i);
            a1 = p.getAtom(ai);
            a2 = c.getAtom(ai);
            int pc = this.getTauBondType(a1);
            if (pc == (cc = this.getTauBondType(a2))) continue;
            if (pc > cc) {
                acc = ai;
            } else {
                don = ai;
            }
            if (++k == 2) {
                AD[0] = acc;
                AD[1] = don;
                continue;
            }
            if (k <= 2) continue;
            return null;
        }
        if (AD[0] != -1 && AD[1] != -1) {
            int chg2;
            if (this.protonC[AD[0]] == 6 && this.protonC[AD[1]] == 6) {
                return null;
            }
            a1 = p.getAtom(AD[0]);
            a2 = p.getAtom(AD[1]);
            int chg1 = a1.getCharge();
            if (chg1 * (chg2 = a2.getCharge()) < 0) {
                AD[2] = 1;
            } else {
                a1 = c.getAtom(AD[0]);
                a2 = c.getAtom(AD[1]);
                chg1 = a1.getCharge();
                if (chg1 * (chg2 = a2.getCharge()) < 0) {
                    AD[2] = 2;
                }
            }
        }
        return AD;
    }

    private int getTauBondType(MolAtom a) {
        int ne = a.getBondCount();
        int max = 0;
        for (int i = 0; i < ne; ++i) {
            MolBond b = a.getBond(i);
            int t = b.getType();
            if (t < 1 || t > 4 || t <= max) continue;
            max = t;
        }
        return max;
    }

    private int getDist(int ac, int don, int tc) {
        int Lmin = 1000;
        boolean find = false;
        for (int i = 0; !find && i < tc; ++i) {
            int ti = i;
            if (this.tPath[ti] == null) continue;
            int L = this.tPath[ti].length;
            int a = this.tPath[ti][0];
            int d = this.tPath[ti][L - 1];
            if ((a != ac || d != don) && (d != ac || a != don) || L >= Lmin) continue;
            Lmin = L;
            find = true;
        }
        if (!find) {
            return 0;
        }
        return Lmin - 1;
    }

    private void calcpKa(Molecule m, boolean micpKa, boolean onlyMsp, double acutoff, double bcutoff) {
        m.dearomatize();
        m.aromatize(1);
        this.ionizer = new Ionizer();
        this.ionizer.setpKaPrefixType(1);
        this.ionizer.setBasicpKaLowerLimit(bcutoff);
        this.ionizer.setAcidicpKaUpperLimit(acutoff);
        this.ionizer.setMolecule(m);
        this.ionizer.micropKaCalc = micpKa;
        this.ionizer.setTautomerCalculationFlag(true);
        if (onlyMsp) {
            this.ionizer.calcMicroSpecies();
        } else {
            this.ionizer.calculatepKa(0.0);
        }
        this.molSymmetry = this.ionizer.isSymmetric();
        if (this.ionizer.getCriticalErrorFlag()) {
            this.charge.setCriticalErrorFlag(true);
        }
    }

    private void calTaupHDistribution(double pH) {
        this.pHStepSize = 0.0;
        this.pHLower = pH;
        this.pHUpper = pH;
        this.calTaupHDistribution();
        this.pHStepSize = 1.0;
        this.pHLower = 0.0;
        this.pHUpper = 14.0;
    }

    private void calTaupHDistribution() {
        int N;
        int actDomy;
        int tauCount = this.getTCount();
        this.domTauCount = 0;
        this.sumMspCount = 0;
        for (int i = 0; i < tauCount; ++i) {
            this.getTauDistribution(i);
            ++this.domTauCount;
        }
        this.setpH();
        this.pHTauDistVal = new double[this.domTauCount][][];
        this.pHTauDistMol = new Molecule[this.domTauCount][];
        this.pHTauDistInfo = new int[this.domTauCount][3];
        int k = 0;
        for (actDomy = 0; actDomy < this.domTauCount && this.sumMspCount < this.Tmax; ++actDomy) {
            Molecule m = this.getTauDistMolecule(actDomy);
            this.calcpKa(m, false, true, 200.0, -100.0);
            this.setSymmetryInfo();
            int ionCount = this.ionizer.getIonizableAtomCount();
            if (ionCount != 0) {
                this.ionizer.calcMsDistribution(this.pHLower);
                m.dearomatize();
                this.setMolpHVaule(k, m);
                ++k;
                continue;
            }
            m.dearomatize();
            this.setSingleMolpHValue(k, m);
            ++k;
        }
        if (this.tautomerCount != 0) {
            int j;
            int i;
            double sum = 0.0;
            for (i = 0; i < actDomy; ++i) {
                double f = this.tauDist[i];
                int g = this.pHTauDistInfo[i][2];
                double d = this.pHTauDistVal[i][g][0];
                double c = f / d;
                N = this.pHTauDistInfo[i][1] - this.pHTauDistInfo[i][0];
                for (j = 0; j <= N; ++j) {
                    this.pHTauDistVal[i][j][0] = c * this.pHTauDistVal[i][j][0];
                    sum += this.pHTauDistVal[i][j][0];
                }
            }
            for (i = 0; i < actDomy; ++i) {
                N = this.pHTauDistInfo[i][1] - this.pHTauDistInfo[i][0];
                for (j = 0; j <= N; ++j) {
                    this.pHTauDistVal[i][j][0] = 100.0 * this.pHTauDistVal[i][j][0] / sum;
                }
            }
        }
        if (this.sumMspCount == 0) {
            this.tautomerCount = this.sumMspCount;
            this.pHTauDistAvailable = true;
            return;
        }
        this.tauDist = new double[this.sumMspCount];
        int z = 0;
        for (int i = 0; i < actDomy; ++i) {
            N = this.pHTauDistInfo[i][1] - this.pHTauDistInfo[i][0];
            for (int j = 0; j <= N; ++j) {
                this.tauDist[z] = this.pHTauDistVal[i][j][0];
                ++z;
            }
        }
        this.tautomerCount = this.sumMspCount;
        this.setShortIndex(this.tautomerCount);
        this.pHTauDistAvailable = true;
    }

    private void setSingleMolpHValue(int domTauInd, Molecule dTau) {
        int maxDomMspCount = 1;
        this.pHTauDistVal[domTauInd] = new double[maxDomMspCount][3];
        this.pHTauDistMol[domTauInd] = new Molecule[maxDomMspCount];
        this.pHTauDistInfo[domTauInd][0] = this.sumMspCount;
        this.pHTauDistInfo[domTauInd][1] = this.sumMspCount + maxDomMspCount - 1;
        this.pHTauDistMol[domTauInd][0] = dTau;
        this.pHTauDistVal[domTauInd][0][0] = 100.0;
        this.pHTauDistInfo[domTauInd][2] = 0;
        this.sumMspCount += maxDomMspCount;
    }

    private void setMolpHVaule(int domTauInd, Molecule dTau) {
        int msCount = this.ionizer.getMicroSpeciesCount();
        int maxDomMspCount = 0;
        int[] mspInd = new int[msCount];
        for (int i = 0; i < msCount; ++i) {
            mspInd[i] = -1;
            if (this.getMspDegIndex(i) == 0 || this.isDeletAbleMsp(i)) continue;
            mspInd[i] = i;
            ++maxDomMspCount;
        }
        this.pHTauDistVal[domTauInd] = new double[maxDomMspCount][3];
        this.pHTauDistMol[domTauInd] = new Molecule[maxDomMspCount];
        int k = 0;
        this.pHTauDistInfo[domTauInd][0] = this.sumMspCount;
        this.pHTauDistInfo[domTauInd][1] = this.sumMspCount + maxDomMspCount - 1;
        this.pHTauDistInfo[domTauInd][2] = 0;
        for (int i = 0; i < msCount; ++i) {
            if (mspInd[i] == -1) continue;
            double d = this.ionizer.getMsDist(i);
            int deg = this.getMspDegIndex(i);
            if (deg == 0) continue;
            Molecule m = this.ionizer.getMicroSpecies(i);
            m.dearomatize();
            this.pHTauDistMol[domTauInd][k] = m;
            this.pHTauDistVal[domTauInd][k][0] = d * (double)deg;
            ++k;
        }
        this.sumMspCount += maxDomMspCount;
    }

    private boolean isDeletAbleMsp(int mspInd) {
        if (mspInd == 0) {
            return false;
        }
        double d = this.ionizer.getMsDist(mspInd);
        return !(d >= this.tauMinValue);
    }

    private void setpH() {
        double dpH = this.pHUpper - this.pHLower;
        this.pHStepCount = this.pHStepSize > dpH || this.pHStepSize == 0.0 ? 0 : (int)Math.round(dpH / this.pHStepSize);
        this.pHPoints = new double[this.pHStepCount + 1];
        for (int i = 0; i <= this.pHStepCount; ++i) {
            this.pHPoints[i] = this.pHLower + (double)i * this.pHStepSize;
        }
    }

    private Molecule getpHTauMolecule(int ti) {
        int p = this.getMainMspSet(ti);
        int ind = this.getMspIndex(p, ti);
        if (this.protectExpH && Double.isNaN(this.pH)) {
            this.setExplicitHydrogens(this.pHTauDistMol[p][ind], ti);
        }
        return this.pHTauDistMol[p][ind];
    }

    private int getMainMspSet(int ind) {
        for (int i = 0; i < this.domTauCount; ++i) {
            int begin = this.pHTauDistInfo[i][0];
            int end = this.pHTauDistInfo[i][1];
            if (ind > end || ind < begin) continue;
            return i;
        }
        return -1;
    }

    private int getMspIndex(int dTauInd, int ind) {
        return ind - this.pHTauDistInfo[dTauInd][0];
    }

    private void setShortIndex(int t) {
        this.shortTauIndex = new int[t];
        for (int i = 0; i < t; ++i) {
            this.shortTauIndex[i] = i;
        }
        double[] x = new double[t];
        for (int i = 0; i < t; ++i) {
            x[i] = this.tauDist[i];
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            for (int i = 0; i < t; ++i) {
                for (int j = i + 1; j < t; ++j) {
                    if (!(x[j] > x[i])) continue;
                    int a = this.shortTauIndex[i];
                    this.shortTauIndex[i] = this.shortTauIndex[j];
                    this.shortTauIndex[j] = a;
                    double b = x[i];
                    x[i] = x[j];
                    x[j] = b;
                    changed = true;
                }
            }
        }
    }

    private void setSymmetryInfo() {
        if (this.molSymmetry) {
            this.ionizer.setDegIndex();
        }
    }

    private int getMspDegIndex(int mspInd) {
        if (this.molSymmetry) {
            return this.ionizer.getDegIndex(mspInd);
        }
        return 1;
    }

    private void isRadicalCountChanged(int ti) {
        if (!this.radicalExist) {
            return;
        }
        int cr = 0;
        int pr = 0;
        if (this.tautomerType == 1 || this.tautomerType == 3) {
            for (int i = 0; i < this.tPath[ti].length; ++i) {
                int ai = this.tPath[ti][i];
                cr += this.getResonantRCount(ai, ti);
                pr += this.getParentRCount(ai);
            }
            if (cr != pr) {
                this.falseTautomer = true;
            }
        }
    }

    private int getAraNbCount(int ai) {
        int c = 0;
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int bt;
            int nb = this.cHtab[ai][i];
            if (!this.isArA(nb) || (bt = this.getInputBondType(ai, nb)) != 4) continue;
            ++c;
        }
        return c;
    }

    private boolean isRadical(int ai) {
        return this.atomArray[ai].getRadical() != 0;
    }

    private void isAntiAromatic(int ti) {
        int i;
        int c = 0;
        int p = 0;
        int ac = this.tPath[ti].length;
        int[] w = new int[ac];
        for (i = 0; i < ac; ++i) {
            w[i] = -1;
        }
        if (this.tautomerType == 1 || this.tautomerType == 3) {
            for (i = 0; i < ac; ++i) {
                int L;
                int ai = this.tPath[ti][i];
                if (this.isArA(ai) || !this.rings.isInRing()[ai]) continue;
                this.actRInd = this.charge.getNonARingIndex(ai);
                boolean stop = false;
                for (int k = 0; k < ac; ++k) {
                    if (w[k] != this.actRInd) continue;
                    stop = true;
                }
                if (stop) continue;
                c = 0;
                p = 0;
                int chg = this.getResonantCharge(ai, ti);
                c = this.getNonAraPieCount(ai, chg, L = this.nbCount[ai] + this.getResonantHCount(ai, ti), ti, 0);
                if (c == -1 || c == (p = this.getNonAraPieCount(ai, chg = this.getParentCharge(ai), L = this.nbCount[ai] + this.getParentHCount(ai), ti, 1))) continue;
                int y = 0;
                stop = false;
                int LL = this.charge.nonAring[this.actRInd].length;
                for (int j = 0; j < LL && !stop; ++j) {
                    int ri = this.charge.nonAring[this.actRInd][j];
                    chg = this.getResonantCharge(ri, ti);
                    int z = this.getNonAraPieCount(ri, chg, L = this.nbCount[ri] + this.getResonantHCount(ri, ti), ti, 0);
                    if (z == -1) {
                        stop = true;
                    }
                    y += z;
                }
                w[i] = this.actRInd;
                if (stop || !this.isAntic(y)) continue;
                this.falseTautomer = true;
                return;
            }
        }
    }

    private boolean isAntic(int y) {
        if (y < 4) {
            return false;
        }
        int d = y / 4;
        int c = y - 4 * d;
        return c == 0;
    }

    private int getNonAraPieCount(int ai, int chg, int L, int ti, int type) {
        int pc = this.protonC[ai];
        if (pc == 6 || pc == 14) {
            if (chg == -1) {
                if (L == 3) {
                    int piEcount = 2;
                    return piEcount;
                }
                if (L == 2) {
                    int piEcount = 1;
                    return piEcount;
                }
            } else if (chg == 1) {
                if (L == 3) {
                    int piEcount = 0;
                    return piEcount;
                }
                if (L == 2) {
                    int piEcount = 1;
                    return piEcount;
                }
            } else if (chg == 0) {
                if (L == 4) {
                    int piEcount = -1;
                    return piEcount;
                }
                if (L == 3) {
                    if (this.isExocyclic(ai, ti, type) && this.protonC[this.AraOx] != 6) {
                        int piEcount = 0;
                        return piEcount;
                    }
                    int piEcount = 1;
                    return piEcount;
                }
                if (L == 2) {
                    int piEcount = 1;
                    return piEcount;
                }
            }
        } else if (pc == 7) {
            if (chg == 0) {
                if (L == 3) {
                    int piEcount = 2;
                    return piEcount;
                }
                if (L == 2) {
                    int piEcount = 1;
                    return piEcount;
                }
            } else if (chg == 1) {
                if (L == 3) {
                    int piEcount = 1;
                    return piEcount;
                }
                if (L == 4) {
                    int piEcount = -1;
                    return piEcount;
                }
            } else if (chg == -1 && L == 2) {
                int piEcount = 2;
                return piEcount;
            }
        } else if (pc == 8) {
            if (chg == 0) {
                if (L == 2) {
                    int piEcount = 2;
                    return piEcount;
                }
            } else if (chg == 1) {
                if (L == 2) {
                    int piEcount = 1;
                    return piEcount;
                }
                if (L == 3) {
                    int piEcount = 2;
                    return piEcount;
                }
            }
        }
        if (pc == 16) {
            if (chg == 0) {
                if (L == 2) {
                    int piEcount = 2;
                    return piEcount;
                }
                if (L == 3) {
                    int piEcount = 1;
                    return piEcount;
                }
            } else if (chg == 1) {
                if (L == 2) {
                    int piEcount = 1;
                    return piEcount;
                }
                if (L == 3) {
                    int piEcount = 0;
                    return piEcount;
                }
            }
        }
        return -1;
    }

    private boolean isExocyclic(int ai, int ti, int type) {
        if (type == 0) {
            if (this.isNonAraChildExocylic(ai, ti)) {
                return this.protonC[this.AraOx] == 6 || !this.rings.isInRing()[this.AraOx];
            }
        } else if (type == 1 && this.isNonAraParentExocylic(ai)) {
            return this.protonC[this.AraOx] == 6 || !this.rings.isInRing()[this.AraOx];
        }
        return false;
    }

    private boolean isNonAraChildExocylic(int a, int tChild) {
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int ri;
            int bt;
            int nb = this.cHtab[a][i];
            if (nb >= this.atomCount || this.isArA(nb)) continue;
            if (!this.rings.isInRing()[nb]) {
                bt = this.getResonantBondType(a, nb, tChild);
                if (bt != 2) continue;
                this.AraOx = nb;
                return true;
            }
            if (!this.rings.isInRing()[nb] || (ri = this.charge.getNonARingIndex(nb)) == this.actRInd || (bt = this.getResonantBondType(a, nb, tChild)) != 2) continue;
            this.AraOx = nb;
            return true;
        }
        return false;
    }

    private boolean isNonAraParentExocylic(int a) {
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int ri;
            int bt;
            int nb = this.cHtab[a][i];
            if (nb >= this.atomCount || this.isArA(nb)) continue;
            if (!this.rings.isInRing()[nb]) {
                bt = this.getParentBType(nb, a);
                if (bt != 2) continue;
                this.AraOx = nb;
                return true;
            }
            if (!this.rings.isInRing()[nb] || (ri = this.charge.getNonARingIndex(nb)) == this.actRInd || (bt = this.getParentBType(nb, a)) != 2) continue;
            this.AraOx = nb;
            return true;
        }
        return false;
    }

    private void setLatentAromaticAtom(int parent) {
        Molecule m = this.getLatentTMolecule(parent);
        m.aromatize(2);
        this.actAraCount = 0;
        for (int i = 0; i < this.atomCount; ++i) {
            MolAtom a = m.getAtom(i);
            if (!a.hasAromaticBond()) continue;
            this.lAra[i] = 1;
            ++this.actAraCount;
        }
    }

    private int getAromaticAtomCount(int ti) {
        Molecule m = this.getLatentTMolecule(ti);
        m.aromatize(2);
        int c = 0;
        for (int i = 0; i < this.atomCount; ++i) {
            MolAtom a = m.getAtom(i);
            if (!a.hasAromaticBond()) continue;
            ++c;
        }
        return c;
    }

    private Molecule getLatentTMolecule(int ti) {
        Molecule m = null;
        m = this.oMol.cloneMoleculeWithDocument();
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.tBtab[ti][i] == null) continue;
            for (int j = 0; j < this.tBtab[ti][i].length; ++j) {
                int bt = this.tBtab[ti][i][j];
                int nb = this.getTCtabAtomIndex(i, j, ti);
                MolBond actBond = m.getBond(this.bHtab[i][nb]);
                actBond.setFlags(bt);
            }
        }
        this.setTauCharge(m, ti);
        this.setTauRadical(m, ti);
        this.setTauH(m, ti);
        return m;
    }

    private int getAza(int index) {
        if (this.aza == null) {
            this.aza = Aza.calculate(this.charge.getMolecule());
        }
        if (index < 0 || index >= this.aza.length) {
            return -1;
        }
        return this.aza[index];
    }
}

