/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations;

import chemaxon.calculations.clean.Cleaner;
import chemaxon.calculations.hydrogenize.Hydrogenize;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class TholePolarizability {
    Molecule mol;
    int MOLATOMS;
    double atomPol;
    double aveMolPol;
    int size;
    MolAtom[] atomArray;
    double[] pq = null;
    int[] indx = null;
    double[] b = null;
    double[] ap = null;
    double[][] tpq = null;
    double[][] xyz = null;
    double[][] R = null;
    double[][] y = null;
    double[][] pT = null;
    double[] d;
    double[] e;
    final double damping = 1.7278;
    boolean hValenceError;
    public boolean criticalError;

    public void setMolecule(Molecule m) {
        this.mol = m;
        this.setCriticalErrorFlag();
        this.hValenceError = false;
    }

    public Molecule getMolecule() {
        return this.mol;
    }

    public boolean getCriticalErrorFlag() {
        return this.criticalError;
    }

    protected void setCriticalErrorFlag() {
        this.criticalError = false;
        int n = this.mol.getAtomCount();
        for (int i = 0; i < n; ++i) {
            MolAtom a = this.mol.getAtom(i);
            if (!a.hasValenceError()) continue;
            int vc = a.getValence();
            int pc = a.getAtno();
            if (pc == 1 && vc > 1) {
                this.criticalError = true;
                return;
            }
            if (pc <= 10 && vc > 4) {
                this.criticalError = true;
                return;
            }
            if (pc <= 10 || vc <= 8) continue;
            this.criticalError = true;
            return;
        }
    }

    public void calcPolTensor() {
        this.calc3DCoordinates();
        this.size = 3 * this.MOLATOMS;
        this.pq = new double[3];
        this.tpq = new double[3][3];
        this.ap = new double[this.MOLATOMS];
        this.R = new double[this.size][this.size];
        this.setAtomPol();
        this.calculateRelayMatrix();
        this.invertR();
        this.setPolTensor();
        this.calcPrincComps();
        this.aveMolPol = 0.3333333333333333 * (this.d[0] + this.d[1] + this.d[2]);
    }

    public double[] getPrincipalPolComp() {
        return this.d;
    }

    public double getAveragePolComp() {
        return this.aveMolPol;
    }

    private void calc3DCoordinates() {
        Molecule cmol = this.mol.cloneMoleculeWithDocument();
        int dim = cmol.getDim();
        Object[] args = new Object[]{cmol, "S3"};
        boolean do3DAgain = false;
        if (cmol.hasImplicitH()) {
            Hydrogenize.addHAtoms(cmol);
            this.MOLATOMS = cmol.getAtomCount();
            args[0] = cmol;
            if (dim == 3) {
                do3DAgain = true;
            }
        } else {
            this.MOLATOMS = cmol.getAtomCount();
            if (dim == 3) {
                this.atomArray = cmol.getAtomArray();
            }
        }
        if (dim <= 2 || do3DAgain) {
            if (!Cleaner.clean((Molecule)args[0], 3, (String)args[1])) {
                this.hValenceError = true;
            }
            this.atomArray = cmol.getAtomArray();
        }
        this.xyz = new double[this.MOLATOMS][3];
        int[][] cHtab = cmol.createCHtab();
        for (int i = 0; i < this.MOLATOMS; ++i) {
            this.xyz[i][0] = this.atomArray[i].getX();
            this.xyz[i][1] = this.atomArray[i].getY();
            this.xyz[i][2] = this.atomArray[i].getZ();
            if (this.atomArray[i].getAtno() != 1 || cHtab[i].length <= 1) continue;
            this.hValenceError = true;
        }
    }

    private void calculateRelayMatrix() {
        for (int i = 0; i < this.MOLATOMS; ++i) {
            for (int j = 0; j < this.MOLATOMS; ++j) {
                if (i == j) {
                    this.atomPol = this.getAtomPol(i);
                    this.addAPtoR(i, j);
                    continue;
                }
                if (i < j) {
                    this.setDipoleFieldTensor(i, j);
                    this.addDFTtoR(i, j);
                    continue;
                }
                this.setSymmetricElement(i, j);
            }
        }
    }

    private void setSymmetricElement(int Gi, int Gj) {
        Gi = 3 * Gi;
        Gj = 3 * Gj;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.R[Gi + i][Gj + j] = this.R[Gj + j][Gi + i];
            }
        }
    }

    private void addAPtoR(int Gi, int Gj) {
        Gi = 3 * Gi;
        Gj = 3 * Gj;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.R[Gi + i][Gj + j] = i == j ? 1.0 / this.atomPol : 0.0;
            }
        }
    }

    private void addDFTtoR(int Gi, int Gj) {
        Gi = 3 * Gi;
        Gj = 3 * Gj;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.R[Gi + i][Gj + j] = this.tpq[i][j];
            }
        }
    }

    private double getAtomPol(int atom) {
        return this.ap[atom];
    }

    private void setAtomPol() {
        block11: for (int i = 0; i < this.MOLATOMS; ++i) {
            int protonCount = this.atomArray[i].getAtno();
            switch (protonCount) {
                case 1: {
                    this.ap[i] = 0.5189963999999999;
                    continue block11;
                }
                case 6: {
                    this.ap[i] = 1.5080239199999999;
                    continue block11;
                }
                case 7: {
                    this.ap[i] = 1.12703136;
                    continue block11;
                }
                case 8: {
                    this.ap[i] = 0.9475908;
                    continue block11;
                }
                case 9: {
                    this.ap[i] = 0.43590066;
                    continue block11;
                }
                case 16: {
                    this.ap[i] = 2.92579404;
                    continue block11;
                }
                case 17: {
                    this.ap[i] = 2.3881688999999997;
                    continue block11;
                }
                case 35: {
                    this.ap[i] = 3.35926422;
                    continue block11;
                }
                case 53: {
                    this.ap[i] = 5.07487188;
                    continue block11;
                }
                default: {
                    this.ap[i] = 1.7784;
                }
            }
        }
    }

    private void setDipoleFieldTensor(int p, int q) {
        this.setPQVector(p, q);
        double dist = this.getDistance(p, q);
        double[] c = new double[]{1.0, 1.0};
        c = this.getDamping(p, q, dist);
        double r_2 = 1.0 / Math.pow(dist, 2.0);
        double r_3 = 1.0 / Math.pow(dist, 3.0);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.tpq[i][j] = i == j ? r_3 * (c[0] * 1.0 - c[1] * r_2 * 3.0 * this.pq[i] * this.pq[j]) : r_3 * (-c[1] * r_2 * 3.0 * this.pq[i] * this.pq[j]);
            }
        }
    }

    private double[] getDamping(int p, int q, double dist) {
        double v = 0.0;
        double f = this.getAtomPol(p) * this.getAtomPol(q);
        double s = 1.7278 * Math.pow(f, 0.16666666666666666);
        v = dist < s ? dist / s : 1.0;
        double[] c = new double[]{4.0 * Math.pow(v, 3.0) - 3.0 * Math.pow(v, 4.0), Math.pow(v, 4.0)};
        return c;
    }

    private double getDistance(int p, int q) {
        double d1 = this.xyz[p][0] - this.xyz[q][0];
        double d2 = this.xyz[p][1] - this.xyz[q][1];
        double d3 = this.xyz[p][2] - this.xyz[q][2];
        double sum = d1 * d1 + d2 * d2 + d3 * d3;
        return Math.sqrt(sum);
    }

    private void setPQVector(int p, int q) {
        this.pq[0] = this.xyz[p][0] - this.xyz[q][0];
        this.pq[1] = this.xyz[p][1] - this.xyz[q][1];
        this.pq[2] = this.xyz[p][2] - this.xyz[q][2];
    }

    private void invertR() {
        int j;
        int i;
        int n = this.size;
        this.y = new double[n][n];
        double[] b = new double[n];
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                if (i != j) continue;
                this.y[i][j] = 1.0;
            }
        }
        this.calcLUDecomp();
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                b[j] = this.y[j][i];
            }
            this.solveLinEqu(b);
            for (j = 0; j < n; ++j) {
                this.y[j][i] = b[j];
            }
        }
    }

    private void calcLUDecomp() {
        int j;
        int i;
        int d = 1;
        int imax = -1;
        int n = this.size;
        double[] vv = new double[n];
        this.indx = new int[n];
        double aamax = 0.0;
        for (i = 0; i < n; ++i) {
            aamax = 0.0;
            for (j = 0; j < n; ++j) {
                if (!(Math.abs(this.R[i][j]) > aamax)) continue;
                aamax = Math.abs(this.R[i][j]);
            }
            vv[i] = 1.0 / aamax;
        }
        for (j = 0; j < n; ++j) {
            double dum;
            int k;
            double sum;
            for (i = 0; i <= j - 1; ++i) {
                sum = this.R[i][j];
                for (k = 0; k <= i - 1; ++k) {
                    sum -= this.R[i][k] * this.R[k][j];
                }
                this.R[i][j] = sum;
            }
            aamax = 0.0;
            for (i = j; i < n; ++i) {
                sum = this.R[i][j];
                for (k = 0; k <= j - 1; ++k) {
                    sum -= this.R[i][k] * this.R[k][j];
                }
                this.R[i][j] = sum;
                dum = vv[i] * Math.abs(sum);
                if (!(dum >= aamax)) continue;
                imax = i;
                aamax = dum;
            }
            if (j != imax) {
                for (k = 0; k < n; ++k) {
                    dum = this.R[imax][k];
                    this.R[imax][k] = this.R[j][k];
                    this.R[j][k] = dum;
                }
                d = -d;
                vv[imax] = vv[j];
            }
            this.indx[j] = imax;
            if (this.R[j][j] == 0.0) {
                this.R[j][j] = 0.0;
            }
            if (j == n - 1) continue;
            dum = 1.0 / this.R[j][j];
            for (i = j + 1; i < n; ++i) {
                this.R[i][j] = this.R[i][j] * dum;
            }
        }
    }

    private void solveLinEqu(double[] b) {
        int j;
        double sum;
        int i;
        int ii = -1;
        int n = this.size;
        for (i = 0; i < n; ++i) {
            int ll = this.indx[i];
            sum = b[ll];
            b[ll] = b[i];
            if (ii != -1) {
                for (j = ii; j <= i - 1; ++j) {
                    sum -= this.R[i][j] * b[j];
                }
            } else if (sum != 0.0) {
                ii = i;
            }
            b[i] = sum;
        }
        for (i = n - 1; i >= 0; --i) {
            sum = b[i];
            for (j = i + 1; j < n; ++j) {
                sum -= this.R[i][j] * b[j];
            }
            b[i] = sum / this.R[i][i];
        }
    }

    private void setPolTensor() {
        this.pT = new double[3][3];
        for (int i = 0; i < this.MOLATOMS; ++i) {
            for (int j = 0; j < this.MOLATOMS; ++j) {
                this.addUnitBlocks(i, j);
            }
        }
    }

    private void addUnitBlocks(int Gi, int Gj) {
        Gi = 3 * Gi;
        Gj = 3 * Gj;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                double[] dArray = this.pT[i];
                int n = j;
                dArray[n] = dArray[n] + this.y[Gi + i][Gj + j];
            }
        }
    }

    private void calcPrincComps() {
        this.triagonalize(3);
        this.calcEigenParameters(3);
    }

    private void triagonalize(int n) {
        int k;
        int j;
        double g;
        int l;
        int i;
        this.d = new double[n];
        this.e = new double[n];
        for (i = n - 1; i > 0; --i) {
            l = i - 1;
            double h = 0.0;
            double scale = 0.0;
            if (l > 0) {
                int k2;
                for (k2 = 0; k2 <= l; ++k2) {
                    scale += Math.abs(this.pT[i][k2]);
                }
                if (scale == 0.0) {
                    this.e[i] = this.pT[i][l];
                } else {
                    for (k2 = 0; k2 <= l; ++k2) {
                        this.pT[i][k2] = this.pT[i][k2] / scale;
                        h += this.pT[i][k2] * this.pT[i][k2];
                    }
                    double f = this.pT[i][l];
                    g = f >= 0.0 ? -Math.sqrt(h) : Math.sqrt(h);
                    this.e[i] = scale * g;
                    h -= f * g;
                    this.pT[i][l] = f - g;
                    f = 0.0;
                    for (j = 0; j <= l; ++j) {
                        this.pT[j][i] = this.pT[i][j] / h;
                        g = 0.0;
                        for (k = 0; k <= j; ++k) {
                            g += this.pT[j][k] * this.pT[i][k];
                        }
                        for (k = j + 1; k <= l; ++k) {
                            g += this.pT[k][j] * this.pT[i][k];
                        }
                        this.e[j] = g / h;
                        f += this.e[j] * this.pT[i][j];
                    }
                    double hh = f / (h + h);
                    for (j = 0; j <= l; ++j) {
                        f = this.pT[i][j];
                        this.e[j] = g = this.e[j] - hh * f;
                        for (k = 0; k <= j; ++k) {
                            double[] dArray = this.pT[j];
                            int n2 = k;
                            dArray[n2] = dArray[n2] - (f * this.e[k] + g * this.pT[i][k]);
                        }
                    }
                }
            } else {
                this.e[i] = this.pT[i][l];
            }
            this.d[i] = h;
        }
        this.d[0] = 0.0;
        this.e[0] = 0.0;
        for (i = 0; i < n; ++i) {
            l = i - 1;
            if (this.d[i] != 0.0) {
                for (j = 0; j <= l; ++j) {
                    g = 0.0;
                    for (k = 0; k <= l; ++k) {
                        g += this.pT[i][k] * this.pT[k][j];
                    }
                    for (k = 0; k <= l; ++k) {
                        double[] dArray = this.pT[k];
                        int n3 = j;
                        dArray[n3] = dArray[n3] - g * this.pT[k][i];
                    }
                }
            }
            this.d[i] = this.pT[i][i];
            this.pT[i][i] = 1.0;
            for (j = 0; j <= l; ++j) {
                this.pT[i][j] = 0.0;
                this.pT[j][i] = 0.0;
            }
        }
    }

    private void calcEigenParameters(int n) {
        int i;
        for (i = 1; i < n; ++i) {
            this.e[i - 1] = this.e[i];
        }
        this.e[n - 1] = 0.0;
        for (int l = 0; l < n; ++l) {
            int m;
            int iter = 0;
            do {
                for (m = l; m <= n - 2; ++m) {
                    double dd = Math.abs(this.d[m]) + Math.abs(this.d[m + 1]);
                    double v = Math.abs(this.e[m]) + dd;
                    if (v == dd) break;
                }
                if (m == l || iter > 30) continue;
                ++iter;
                double g = (this.d[l + 1] - this.d[l]) / (2.0 * this.e[l]);
                double r = Math.sqrt(g * g + 1.0);
                g = this.d[m] - this.d[l] + this.e[l] / (g + this.sign(r, g));
                double s = 1.0;
                double c = 1.0;
                double p = 0.0;
                for (i = m - 1; i >= l; --i) {
                    double f = s * this.e[i];
                    double b = c * this.e[i];
                    if (Math.abs(f) >= Math.abs(g)) {
                        c = g / f;
                        r = Math.sqrt(c * c + 1.0);
                        this.e[i + 1] = f * r;
                        s = 1.0 / r;
                        c *= s;
                    } else {
                        s = f / g;
                        r = Math.sqrt(s * s + 1.0);
                        this.e[i + 1] = g * r;
                        c = 1.0 / r;
                        s *= c;
                    }
                    g = this.d[i + 1] - p;
                    r = s * (this.d[i] - g) + 2.0 * c * b;
                    p = s * r;
                    this.d[i + 1] = g + p;
                    g = c * r - b;
                    for (int k = 0; k < n; ++k) {
                        f = this.pT[k][i + 1];
                        this.pT[k][i + 1] = s * this.pT[k][i] + c * f;
                        this.pT[k][i] = c * this.pT[k][i] - s * f;
                    }
                }
                this.d[l] = this.d[l] - p;
                this.e[l] = g;
                this.e[m] = 0.0;
            } while (m != l);
        }
    }

    private double sign(double a1, double a2) {
        a1 = a2 < 0.0 ? -1.0 * Math.abs(a1) : 1.0 * Math.abs(a1);
        return a1;
    }

    public boolean getHValenceError() {
        return this.hValenceError;
    }
}

