/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.clean;

import chemaxon.calculations.clean.Clean2D;
import chemaxon.calculations.clean.Clean3D;
import chemaxon.common.util.MProgressMonitor;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.Expandable;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;

public class Cleaner {
    public static boolean clean(MoleculeGraph mg, int dim, String opts, MProgressMonitor pmon) {
        if (mg instanceof SelectionMolecule) {
            return Cleaner.cleanSelectionMol((SelectionMolecule)mg, dim, opts, pmon);
        }
        if (mg instanceof Molecule) {
            return Cleaner.cleanMol((Molecule)mg, dim, opts, pmon);
        }
        if (mg instanceof MoleculeGraph) {
            return Cleaner.cleanMolGraph(mg, dim, opts, pmon);
        }
        return false;
    }

    public static boolean clean(MoleculeGraph mg, int dim, String opts) {
        return Cleaner.clean(mg, dim, opts, null);
    }

    public static boolean partialClean(MoleculeGraph mg, MoleculeGraph template, int[] map, String opts) {
        Clean2D clean2D = new Clean2D();
        return clean2D.clean(mg, opts, template, map) == 0;
    }

    public static boolean partialClean(MoleculeGraph mg, int dim, int[] fixed, String opts) {
        if (mg instanceof Molecule) {
            return Cleaner.partialCleanMol((Molecule)mg, dim, fixed, opts);
        }
        if (mg instanceof MoleculeGraph) {
            return Cleaner.partialCleanMolGraph(mg, dim, fixed, opts);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean partialClean(Molecule m, Molecule[] template, String opts) {
        boolean xg;
        boolean bl = xg = m.getSgroupCount() != 0 && !m.isGUIContracted();
        if (xg) {
            m.setGUIContracted(true);
        }
        try {
            boolean success;
            Sgroup[] sgroupsToClean = Cleaner.getContractedSgroups(m);
            Clean2D clean2D = new Clean2D();
            boolean bl2 = success = clean2D.clean(m, opts, template) == 0;
            if (success) {
                Cleaner.postClean(m);
            }
            Cleaner.cleanSgroups(sgroupsToClean, 2, opts);
            boolean bl3 = success;
            return bl3;
        }
        finally {
            if (xg) {
                m.setGUIContracted(false);
            }
        }
    }

    private static boolean cleanMolGraph(MoleculeGraph mg, int dim, String opts, MProgressMonitor pmon) {
        Clean2D clean2D;
        if (dim == 2 && (clean2D = new Clean2D()).clean(mg, opts) == 0) {
            mg.setDim(dim);
            return true;
        }
        if (dim == 3 && mg instanceof Molecule) {
            Clean3D clean3D = new Clean3D();
            int r = clean3D.optimization3D((Molecule)mg, opts, pmon);
            if (r != 0) {
                return false;
            }
            mg.setDim(dim);
            return true;
        }
        return false;
    }

    private static boolean partialCleanMolGraph(MoleculeGraph mg, int dim, int[] fixed, String opts) {
        Clean2D clean2D;
        if (dim == 2 && (clean2D = new Clean2D()).clean(mg, "f" + (opts == null ? "" : opts), fixed) == 0) {
            mg.setDim(dim);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean cleanMol(Molecule m, int dim, String opts, MProgressMonitor pmon) {
        boolean l;
        if (dim == 3) {
            boolean success;
            if (m.isGUIContracted()) {
                m.setGUIContracted(false);
            }
            if (opts != null && opts.contains("prehydrogenize")) {
                m.ungroupSgroup(1);
                m.ungroupSgroup(0);
            }
            if (success = Cleaner.cleanMolGraph(m, dim, opts, pmon)) {
                Cleaner.postClean(m);
            }
            return success;
        }
        boolean bl = l = m.getSgroupCount() != 0 && !m.isGUIContracted();
        if (l) {
            m.setGUIContracted(true);
        }
        try {
            Sgroup[] sgroupsToClean = Cleaner.getContractedSgroups(m);
            boolean success = Cleaner.cleanMolGraph(m, dim, opts, null);
            if (success) {
                Cleaner.postClean(m);
            }
            Cleaner.cleanSgroups(sgroupsToClean, dim, opts);
            boolean bl2 = success;
            return bl2;
        }
        finally {
            if (l) {
                m.setGUIContracted(false);
            }
        }
    }

    private static void cleanSgroups(Sgroup[] sgroups, int dim, String opts) {
        int l = sgroups == null ? 0 : sgroups.length;
        for (int i = 0; i < l; ++i) {
            MolAtom a;
            int j;
            if (!(sgroups[i] instanceof SuperatomSgroup)) continue;
            SuperatomSgroup sg = (SuperatomSgroup)sgroups[i];
            SelectionMolecule m = sg.getParentSgroupGraph();
            MolAtom[] attach = sg.getAttachAtoms();
            for (j = 0; j < attach.length; ++j) {
                a = attach[j];
                MolAtom pseudo = new MolAtom(136);
                pseudo.setAliasstr("attach");
                MolBond b = new MolBond(a, pseudo);
                m.add(pseudo);
                sg.getParentMolecule().add(b);
            }
            Cleaner.cleanMolGraph(m, dim, opts, null);
            block2: for (j = 0; j < attach.length; ++j) {
                a = attach[j];
                for (int k = 0; k < a.getBondCount(); ++k) {
                    MolAtom lig = a.getLigand(k);
                    if (lig.getAtno() != 136 || lig.getAliasstr() != "attach") continue;
                    MolBond b = a.getBond(k);
                    sg.getParentMolecule().removeBond(b);
                    m.removeAtom(lig);
                    continue block2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean partialCleanMol(Molecule m, int dim, int[] fixed, String opts) {
        boolean xg;
        dim &= 3;
        boolean bl = xg = m.getSgroupCount() != 0 && !m.isGUIContracted();
        if (xg) {
            MolAtom[] originalOrder = m.getAtomArray();
            m.setGUIContracted(true);
            int l = fixed.length;
            int n = 0;
            int[] tmp = new int[l];
            for (int i = 0; i < l; ++i) {
                int fidx = fixed[i];
                MolAtom a = originalOrder[fidx];
                int contractedIdx = m.indexOf(a);
                if (contractedIdx < 0) continue;
                tmp[n++] = contractedIdx;
            }
            fixed = new int[n];
            System.arraycopy(tmp, 0, fixed, 0, n);
        }
        try {
            boolean bl2 = Cleaner.partialCleanMolGraph(m, dim, fixed, opts);
            return bl2;
        }
        finally {
            if (xg) {
                m.setGUIContracted(false);
            }
        }
    }

    private static boolean cleanSelectionMol(SelectionMolecule sm, int dim, String opts, MProgressMonitor pmon) {
        if ((dim &= 3) == 2) {
            MolAtom a;
            int i;
            boolean parentNull = false;
            int[] fixed = null;
            SelectionMolecule fusedmol = new SelectionMolecule();
            for (i = sm.getAtomCount() - 1; i >= 0; --i) {
                a = sm.getAtom(i);
                if (a.getParent() == null) {
                    parentNull = true;
                    break;
                }
                fusedmol.fuse(a.getParent());
            }
            if (parentNull) {
                fusedmol = sm;
            } else {
                fixed = new int[fusedmol.getAtomCount() - sm.getAtomCount()];
                int n = 0;
                for (int i2 = fusedmol.getAtomCount() - 1; i2 >= 0; --i2) {
                    MolAtom a2 = fusedmol.getAtom(i2);
                    if (sm.contains(a2)) continue;
                    fixed[n++] = i2;
                }
            }
            for (i = 0; i < fusedmol.getAtomCount(); ++i) {
                a = fusedmol.getAtom(i);
                a.setFlags(fusedmol.getLocalParity(i));
            }
            opts = opts == null ? "2" : opts + "2";
            return Cleaner.partialCleanMolGraph(fusedmol, 2, fixed, opts);
        }
        return Cleaner.cleanMolGraph(sm, dim, opts, pmon);
    }

    private static Sgroup[] getContractedSgroups(Molecule m) {
        Sgroup[] sgroups = m.getSortedSgroups();
        int l = sgroups.length;
        Sgroup[] s = new Sgroup[l];
        int n = 0;
        for (int i = sgroups.length - 1; i >= 0; --i) {
            Expandable x;
            Sgroup sg = sgroups[i];
            if (!(sg instanceof Expandable) || (x = (Expandable)((Object)sg)).isExpanded()) continue;
            s[n++] = sg;
        }
        if (n > 0) {
            Sgroup[] tmp = new Sgroup[n];
            System.arraycopy(s, 0, tmp, 0, n);
            return tmp;
        }
        return null;
    }

    private static void contractExpandedSgroups(Molecule m) {
        for (int i = 0; i < m.getSgroupCount(); ++i) {
            SuperatomSgroup supsg;
            Sgroup sg = m.getSgroup(i);
            if (!(sg instanceof SuperatomSgroup) || (supsg = (SuperatomSgroup)sg).getXState() != 3) continue;
            supsg.contract(0);
        }
    }

    private static boolean isPeptideChain(Molecule m) {
        boolean isPeptideChain;
        if (m.getInputFormat() == null) {
            return false;
        }
        boolean bl = isPeptideChain = m.getInputFormat().indexOf("peptide") >= 0;
        if (isPeptideChain) {
            int atomCount = m.getAtomCount();
            for (int i = 1; i < atomCount - 1 && isPeptideChain; ++i) {
                MolAtom node = m.getAtom(i);
                isPeptideChain = node instanceof SgroupAtom;
            }
            if (atomCount > 3 && isPeptideChain) {
                MolAtom ending = m.getAtom(atomCount - 1);
                boolean bl2 = isPeptideChain = ending.getAtno() == 8;
                if (isPeptideChain) {
                    ending = m.getAtom(0);
                    isPeptideChain = ending.getAtno() == 1;
                }
            } else {
                isPeptideChain = false;
            }
        }
        return isPeptideChain;
    }

    private static void makeBiopolymerSnake(Molecule mol) {
        int chainCount = 0;
        double xShift = 0.0;
        double chainRightEndX = 0.0;
        boolean rightEndSet = false;
        double chainLeftEndX = 0.0;
        double yIncrement = 0.0;
        int MAX_CHAINLENGTH = 15;
        boolean dirRight = true;
        DPoint3 firstLoc = new DPoint3();
        DPoint3 lastLoc = new DPoint3();
        int sGroupCount = mol.getSgroupCount();
        for (int i = 0; i < sGroupCount; ++i) {
            boolean newChain;
            Sgroup sg = mol.getSgroup(i);
            SgroupAtom sga = ((SuperatomSgroup)sg).getSuperAtom();
            DPoint3 loc = sga.getLocation();
            if (i == 0) {
                chainLeftEndX = loc.x;
            } else if (!rightEndSet && chainCount == 14) {
                rightEndSet = true;
                chainRightEndX = loc.x;
            }
            if (i == 0) {
                xShift = loc.x;
            } else if (i == 1) {
                xShift -= loc.x;
            }
            loc.y -= yIncrement;
            loc.x = dirRight ? chainLeftEndX - xShift * (double)chainCount : chainRightEndX + xShift * (double)chainCount;
            if (chainCount == 14) {
                dirRight = !dirRight;
                newChain = true;
                chainCount = 0;
                yIncrement += 1.5;
            } else {
                newChain = false;
            }
            sga.setLocation(loc);
            if (i == 0) {
                firstLoc = loc;
            } else if (i == sGroupCount - 1) {
                lastLoc = loc;
            }
            if (newChain) continue;
            ++chainCount;
        }
        int atomCount = mol.getAtomCount();
        MolAtom endingOH = mol.getAtom(atomCount - 1);
        MolAtom endingH = mol.getAtom(0);
        lastLoc.x = chainCount == 0 ? (dirRight ? (lastLoc.x += xShift) : (lastLoc.x -= xShift)) : (dirRight ? (lastLoc.x -= xShift) : (lastLoc.x += xShift));
        DPoint3 hLoc = new DPoint3(firstLoc);
        hLoc.x += xShift;
        endingOH.setLocation(lastLoc);
        endingH.setLocation(hLoc);
        if (firstLoc.x - hLoc.x < 0.0) {
            for (int i = 0; i < atomCount; ++i) {
                MolAtom node = mol.getAtom(i);
                DPoint3 location = node.getLocation();
                location.x = -location.x;
                node.setLocation(location);
            }
        }
    }

    private static void postClean(Molecule m) {
        Cleaner.contractExpandedSgroups(m);
        if (m instanceof RgMolecule) {
            Molecule root = ((RgMolecule)m).getRoot();
            if (Cleaner.isPeptideChain(root)) {
                Cleaner.makeBiopolymerSnake(root);
            } else if (root instanceof RxnMolecule) {
                Cleaner.postClean(root);
            }
        } else if (m instanceof RxnMolecule) {
            ((RxnMolecule)m).recalcReactionArrow();
        } else if (Cleaner.isPeptideChain(m)) {
            Cleaner.makeBiopolymerSnake(m);
        }
    }
}

