/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.clean;

import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.SelectionMolecule;
import java.util.BitSet;

public class DistanceMatrixCalculator {
    static final double LINEAR = Math.PI;
    static final double TRIGONAL = 2.0943951023931953;
    static final double TETRAHEDRAL = 1.9106119;
    static final double TRIGONAL_BIPYRAMIDAL_1 = 1.5707963267948966;
    static final double TRIGONAL_BIPYRAMIDAL_2 = 2.0943951023931953;
    static final double TRIGONAL_BIPYRAMIDAL_3 = Math.PI;
    static final double OCTAHEDRAL_1 = 1.5707963267948966;
    static final double OCTAHEDRAL_2 = Math.PI;
    static final int AROMATIC = 4;
    static final int SINGLE_OR_AROMATIC = 6;
    static final int DOUBLE_OR_AROMATIC = 7;
    static final int SINGLE_OR_DOUBLE = 5;
    static final int SINGLE = 1;
    static final int DOUBLE = 2;
    static final int TRIPLE = 3;
    static final int CIS = 128;
    static final int TRANS = 64;
    static final int PARITY_EVEN = 2;
    static final int PARITY_ODD = 1;
    static final int PARITY_MASK = 7;
    static final int PARITY_UNSPEC = 4;
    static final int BOND_TYPE = 1;
    static final int BOND_ANGLE_TYPE = 2;
    static final int PLANAR_DIHEDRAL_TYPE = 3;
    static final int DIHEDRAL_TYPE = 4;
    static final int CONDITIONAL = 1;
    static final int OVERWRITESAME = 2;
    static final int UNCONDITIONAL = 3;
    static final double PI = Math.PI;
    static SelectionMolecule m = null;
    debugPrintout debug;

    public static double myToDegrees(double r) {
        return r * 180.0 / Math.PI;
    }

    public static boolean assignHybridizationStates(SelectionMolecule m) {
        int i;
        int me = m.getBondCount();
        int mn = m.getAtomCount();
        int[][] ctab = m.getCtab();
        for (i = 0; i < me; ++i) {
            MolAtom a2;
            MolAtom a1;
            MolBond b = m.getBond(i);
            if (b.getType() == 4) {
                a1 = b.getAtom1();
                a2 = b.getAtom2();
                if (a1.getHybridizationState() == 0) {
                    a1.setHybridizationState(3);
                }
                if (a2.getHybridizationState() == 0) {
                    a2.setHybridizationState(3);
                }
            }
            if (b.getType() == 3) {
                a1 = b.getAtom1();
                a2 = b.getAtom2();
                if (a1.getHybridizationState() == 0) {
                    a1.setHybridizationState(2);
                }
                if (a2.getHybridizationState() == 0) {
                    a2.setHybridizationState(2);
                }
            }
            if (b.getType() != 2) continue;
            a1 = b.getAtom1();
            a2 = b.getAtom2();
            if (a1.getHybridizationState() == 0) {
                if (DistanceMatrixCalculator.has2doubleBond(a1)) {
                    a1.setHybridizationState(2);
                } else {
                    a1.setHybridizationState(3);
                }
            }
            if (a2.getHybridizationState() != 0) continue;
            if (DistanceMatrixCalculator.has2doubleBond(a2)) {
                a2.setHybridizationState(2);
                continue;
            }
            a2.setHybridizationState(3);
        }
        for (i = 0; i < mn; ++i) {
            MolAtom a = m.getAtom(i);
            if (a.getHybridizationState() == 2 && ctab[i].length > 2) {
                a.setHybridizationState(4);
            }
            if (a.getHybridizationState() != 0) continue;
            a.setHybridizationState(4);
        }
        return true;
    }

    public static boolean has2doubleBond(MolAtom a) {
        int doublebonds = 0;
        for (int i = 0; i < a.getBondCount(); ++i) {
            MolBond b = a.getBond(i);
            if (b.getType() != 2) continue;
            ++doublebonds;
        }
        return doublebonds == 2;
    }

    public static void parityToAtomFlags(SelectionMolecule m, debugPrintout debug) {
        if (debug != null) {
            debug.incLevel("Set parity infos.");
        }
        for (int i = 0; i < m.getAtomCount(); ++i) {
            if (m.getParity(i) == 2) {
                m.getAtom(i).setFlags(2, 7);
                if (debug == null) continue;
                debug.println("Parity info: " + i + " EVEN");
                continue;
            }
            if (m.getParity(i) == 1) {
                if (debug != null) {
                    debug.println("Parity info: " + i + " ODD");
                }
                m.getAtom(i).setFlags(1, 7);
                continue;
            }
            if (debug == null) continue;
            debug.println("Parity info: " + i + " " + m.getParity(i));
        }
    }

    public static BitSet[] getInitialCisPairs(SelectionMolecule m, debugPrintout debug) {
        debug.incLevel("Get C/T info");
        int mn = m.getAtomCount();
        int me = m.getBondCount();
        int[][] ctab = m.getCtab();
        debug.println("Initialize BitSet array");
        BitSet[] cisPair = new BitSet[mn];
        for (int i = 0; i < mn; ++i) {
            cisPair[i] = new BitSet(mn);
        }
        debug.println("Walk through bonds");
        for (int b = 0; b < me; ++b) {
            int ii1 = m.indexOf(m.getBond(b).getAtom1());
            int ii2 = m.indexOf(m.getBond(b).getAtom2());
            if (m.getBond(b).getType() == 1) continue;
            for (int i = 0; i < ctab[ii1].length; ++i) {
                int ii0 = ctab[ii1][i];
                for (int j = 0; j < ctab[ii2].length; ++j) {
                    int ii3 = ctab[ii2][j];
                    if (ii0 == ii2 || ii3 == ii1 || m.getStereo2(ii0, ii1, ii2, ii3) != 128) continue;
                    debug.println(ii0 + "-" + ii1 + "-" + ii2 + "-" + ii3 + ": CIS");
                    cisPair[ii0].set(ii3);
                    cisPair[ii3].set(ii0);
                }
            }
        }
        debug.decLevel();
        return cisPair;
    }

    public static void distanceMatrix(double[][][] M2, BitSet[] cis, BitSet[] distanceAtoms, SelectionMolecule m_orig, debugPrintout deb) {
        int j;
        int i;
        debugPrintout myDebug = deb;
        m = (SelectionMolecule)m_orig.clone();
        m.aromatize(true);
        int mn = m.getAtomCount();
        int me = m.getBondCount();
        Object ctab = new int[mn][];
        ctab = m.getCtab();
        myDebug.println("<CENTER><B>Bond lengths</B></CENTER>");
        BitSet bondFor2D = new BitSet(me);
        for (int i2 = 0; i2 < me; ++i2) {
            boolean conjugated;
            double len = m.getDesiredLength(m.getBond(i2));
            int[] ii = new int[]{m.indexOf(m.getBond(i2).getAtom1()), m.indexOf(m.getBond(i2).getAtom2())};
            myDebug.println(ii[0] + "-" + ii[1] + " (" + m.getBond(i2).getType() + "): " + len);
            DistanceMatrixCalculator.setMetridM(M2, ii, len, 1, 1, myDebug);
            boolean bl = conjugated = m.getAtom(ii[0]).getHybridizationState() == 3 && m.getAtom(ii[1]).getHybridizationState() == 3;
            if (m.getBond(i2).getType() == 1 && !conjugated) continue;
            bondFor2D.set(i2);
        }
        myDebug.println("<CENTER><B>Walk through the rings</B></CENTER>");
        BitSet[] cisPair = new BitSet[mn];
        for (int i3 = 0; i3 < mn; ++i3) {
            cisPair[i3] = new BitSet(mn);
        }
        BitSet[] bigRingPair = new BitSet[mn];
        for (int i4 = 0; i4 < mn; ++i4) {
            bigRingPair[i4] = new BitSet(mn);
        }
        BitSet bondForRing = new BitSet(me);
        int[][] sssrAtoms = m.getSSSR();
        MolBond[][] allEdges = new MolBond[m.getAtomCount()][m.getAtomCount()];
        for (int i5 = 0; i5 < m.getBondCount(); ++i5) {
            MolBond myEdge;
            allEdges[DistanceMatrixCalculator.m.indexOf((MolAtom)myEdge.getAtom1())][DistanceMatrixCalculator.m.indexOf((MolAtom)myEdge.getAtom2())] = myEdge = m.getBond(i5);
            allEdges[DistanceMatrixCalculator.m.indexOf((MolAtom)myEdge.getAtom2())][DistanceMatrixCalculator.m.indexOf((MolAtom)myEdge.getAtom1())] = myEdge;
        }
        MolBond[][] rings = new MolBond[sssrAtoms.length][0];
        for (i = 0; i < rings.length; ++i) {
            rings[i] = new MolBond[sssrAtoms[i].length];
            for (int j2 = 0; j2 < rings[i].length; ++j2) {
                rings[i][j2] = allEdges[sssrAtoms[i][j2]][sssrAtoms[i][(j2 + 1) % rings[i].length]];
            }
        }
        for (i = 0; i < sssrAtoms.length; ++i) {
            int nra = sssrAtoms[i].length;
            boolean aromaticRing = true;
            for (int j3 = 0; j3 < nra; ++j3) {
                int i2;
                int i1;
                boolean bl = aromaticRing = aromaticRing && (rings[i][j3].getType() == 4 || rings[i][j3].getType() == 6 || rings[i][j3].getType() == 7);
                if (nra > 3 && nra < 9) {
                    i1 = sssrAtoms[i][j3];
                    i2 = sssrAtoms[i][(j3 + 3) % nra];
                    cisPair[i1].set(i2);
                    cisPair[i2].set(i1);
                }
                if (nra < 9) continue;
                i1 = sssrAtoms[i][j3];
                i2 = sssrAtoms[i][(j3 + 3) % nra];
                bigRingPair[i1].set(i2);
                bigRingPair[i2].set(i1);
            }
            if (aromaticRing || nra < 5) {
                double desiredAngle = Math.PI - Math.PI * 2 / (double)nra;
                for (int j4 = 0; j4 < nra; ++j4) {
                    bondFor2D.set(m.indexOf(rings[i][j4]));
                    if (!aromaticRing && nra >= 5) continue;
                    int[] ii = new int[]{sssrAtoms[i][(j4 + nra - 1) % nra], sssrAtoms[i][j4], sssrAtoms[i][(j4 + 1) % nra]};
                    myDebug.println(ii[0] + "-" + ii[1] + "-" + ii[2] + ": " + DistanceMatrixCalculator.myToDegrees(desiredAngle));
                    DistanceMatrixCalculator.setMetridM(M2, ii, desiredAngle, 2, 2, myDebug);
                }
            }
            String s = aromaticRing ? i + " Ar " : i + "    ";
            for (j = 0; j < nra; ++j) {
                s = s + " - " + sssrAtoms[i][j] + " (" + rings[i][j].getType() + ")";
            }
            myDebug.println(s);
            for (j = 0; j < nra; ++j) {
                bondForRing.set(m.indexOf(rings[i][j]));
            }
        }
        myDebug.println("<CENTER><B>Walk through atoms to assign angles</B></CENTER>");
        for (i = 0; i < mn; ++i) {
            int k;
            myDebug.println("<B>Atom: " + i + "</B>");
            int[] ii = new int[]{0, i, 0};
            double ang = DistanceMatrixCalculator.getAngleFromHybridization(m.getAtom(i).getHybridizationState());
            if (ang == 0.0) {
                myDebug.println("Default angle not found for center " + i);
                ang = 1.5707963267948966;
            }
            if (ctab[i].length == 5 || ctab[i].length == 6) {
                ang = 1.5707963267948966;
            }
            if (m.getAtom(i).getHybridizationState() == 3 && ctab[i].length == 3) {
                double totAng = Math.PI * 2;
                int nAng = 3;
                for (int j5 = 0; j5 < ctab[i].length; ++j5) {
                    ii[0] = ctab[i][j5];
                    for (int k2 = 0; k2 < j5; ++k2) {
                        ii[2] = ctab[i][k2];
                        if (!(DistanceMatrixCalculator.getTypeM(M2, ii[0], ii[2]) > 0.0)) continue;
                        double angle = DistanceMatrixCalculator.getValueFromMetrids(M2, ii, 3, 2);
                        --nAng;
                        totAng -= angle;
                    }
                }
                ang = totAng / (double)nAng;
            }
            if (ctab[i].length <= 4) {
                for (j = 0; j < ctab[i].length; ++j) {
                    ii[0] = ctab[i][j];
                    for (k = 0; k < j; ++k) {
                        ii[2] = ctab[i][k];
                        myDebug.println(ii[0] + "-" + ii[1] + "-" + ii[2] + ": " + m.getAtom(i).getHybridizationState() + " " + DistanceMatrixCalculator.myToDegrees(ang));
                        DistanceMatrixCalculator.setMetridM(M2, ii, ang, 2, 1, myDebug);
                    }
                }
                continue;
            }
            for (j = 0; j < ctab[i].length; ++j) {
                ii[0] = ctab[i][j];
                for (k = 0; k < j; ++k) {
                    boolean toIgnore = false;
                    if (ctab[i].length == 6) {
                        toIgnore = k + 3 == j;
                        ang = 1.5707963267948966;
                    }
                    if (ctab[i].length == 5) {
                        ang = k + j == 1 ? Math.PI : (k <= 1 ? 1.5707963267948966 : 2.0943951023931953);
                    }
                    if (ctab[i].length > 6) {
                        double om = 0.5235987755982988;
                        double fi1 = (double)j / (double)ctab[i].length * 2.0 * Math.PI;
                        double x1 = Math.sin(fi1) * Math.cos(om);
                        double z1 = Math.cos(fi1) * Math.cos(om);
                        double y1 = (double)(j % 2 == 0 ? 1 : -1) * Math.sin(om);
                        double fi2 = (double)k / (double)ctab[i].length * 2.0 * Math.PI;
                        double x2 = Math.sin(fi2) * Math.cos(om);
                        double z2 = Math.cos(fi2) * Math.cos(om);
                        double y2 = (double)(k % 2 == 0 ? 1 : -1) * Math.sin(om);
                        double c = x1 * x2 + y1 * y2 + z1 * z2;
                        if (c > 1.0) {
                            c = 1.0;
                        }
                        if (c < -1.0) {
                            c = -1.0;
                        }
                        ang = Math.acos(c);
                    }
                    if (!toIgnore) {
                        ii[2] = ctab[i][k];
                        myDebug.println(ii[0] + "-" + ii[1] + "-" + ii[2] + ": " + m.getAtom(i).getHybridizationState() + " " + DistanceMatrixCalculator.myToDegrees(ang));
                        DistanceMatrixCalculator.setMetridM(M2, ii, ang, 2, 1, myDebug);
                        continue;
                    }
                    myDebug.println(j + " " + k + " ignored ");
                }
            }
        }
        myDebug.println("<CENTER><B>Walk through the bonds (dihedrals)</B></CENTER>");
        for (int b = 0; b < me; ++b) {
            int i6;
            int i7;
            myDebug.println("<B>Bond " + b + "</B>");
            int[] ii = new int[]{0, m.indexOf(m.getBond(b).getAtom1()), m.indexOf(m.getBond(b).getAtom2()), 0};
            int np1 = Math.max(DistanceMatrixCalculator.getPeriodFromHybridization(m.getAtom(ii[1]).getHybridizationState()), ctab[ii[1]].length - 1);
            int np2 = Math.max(DistanceMatrixCalculator.getPeriodFromHybridization(m.getAtom(ii[2]).getHybridizationState()), ctab[ii[2]].length - 1);
            if (np1 * np2 * (ctab[ii[1]].length - 1) * (ctab[ii[2]].length - 1) <= 0 || np1 >= 4 || np2 >= 4) continue;
            myDebug.println("Dihedrals are processed for bond:" + ii[1] + "(" + np1 + "," + (ctab[ii[1]].length - 1) + ")-" + ii[2] + "(" + np2 + "," + (ctab[ii[2]].length - 1) + ")");
            int[] atoms1 = new int[np1];
            int[] atoms2 = new int[np2];
            int ind1 = 0;
            for (i7 = 0; i7 < ctab[ii[1]].length; ++i7) {
                if (ctab[ii[1]][i7] == ii[2]) continue;
                atoms1[ind1] = ctab[ii[1]][i7];
                ++ind1;
            }
            for (i7 = ctab[ii[1]].length - 1; i7 < np1; ++i7) {
                atoms1[i7] = -1;
            }
            int ind2 = 0;
            for (i6 = 0; i6 < ctab[ii[2]].length; ++i6) {
                if (ctab[ii[2]][i6] == ii[1]) continue;
                atoms2[ind2] = ctab[ii[2]][i6];
                ++ind2;
            }
            for (i6 = ctab[ii[2]].length - 1; i6 < np2; ++i6) {
                atoms2[i6] = -1;
            }
            if (m.getBond(b).getType() != 1) {
                for (i6 = 0; i6 < ctab[ii[1]].length - 1; ++i6) {
                    for (int j6 = 0; j6 < ctab[ii[2]].length - 1; ++j6) {
                        if (!cis[atoms1[i6]].get(atoms2[j6])) continue;
                        bondFor2D.set(b);
                        myDebug.println(atoms1[i6] + "-" + ii[1] + "-" + ii[2] + "-" + atoms2[j6] + ": CIS");
                        cisPair[atoms1[i6]].set(atoms2[j6]);
                        cisPair[atoms2[j6]].set(atoms1[i6]);
                    }
                }
                myDebug.println("Higher order bond:" + ii[1] + "(" + np1 + "," + (ctab[ii[1]].length - 1) + ")-" + ii[2] + "(" + np2 + "," + (ctab[ii[2]].length - 1) + ")");
            }
            int nRot = 12;
            double zeroShift = 0.0;
            int dihed_type = 3;
            double shiftAngle = Math.PI * 2 / (double)np1;
            double[] angleSet1 = new double[np1];
            for (int i8 = 0; i8 < np1; ++i8) {
                angleSet1[i8] = (double)i8 * shiftAngle;
            }
            shiftAngle = Math.PI * 2 / (double)np2;
            if (np1 == np2) {
                nRot = np2;
                if (!bondFor2D.get(b)) {
                    zeroShift = shiftAngle / 2.0;
                }
            }
            if (!bondFor2D.get(b)) {
                dihed_type = 4;
            }
            double[] angleSet2 = new double[np2];
            for (int i9 = 0; i9 < np2; ++i9) {
                angleSet2[i9] = zeroShift + (double)i9 * shiftAngle;
            }
            int[] holes1 = new int[np1];
            int[] iloop1 = new int[np1];
            int ilevel1 = 0;
            boolean firstRound = true;
            boolean hasParity1 = DistanceMatrixCalculator.getParity(m.getAtom(ii[1])) == 2 || DistanceMatrixCalculator.getParity(m.getAtom(ii[1])) == 1;
            int parity1 = 4;
            boolean hasParity2 = DistanceMatrixCalculator.getParity(m.getAtom(ii[2])) == 2 || DistanceMatrixCalculator.getParity(m.getAtom(ii[2])) == 1;
            int parity2 = 4;
            double lowestEnergy = 0.0;
            while (iloop1[0] <= np1 && atoms1[holes1[0]] >= 0) {
                for (int i10 = 0; i10 < ilevel1; ++i10) {
                    if (holes1[i10] != holes1[ilevel1]) continue;
                    int n = ilevel1;
                    holes1[n] = holes1[n] + 1;
                    i10 = -1;
                }
                int n = ilevel1++;
                iloop1[n] = iloop1[n] + 1;
                if (ilevel1 != np1) continue;
                int[] holes2 = new int[np2];
                int[] iloop2 = new int[np2];
                int ilevel2 = 0;
                while (iloop2[0] <= np2 && atoms2[holes2[0]] >= 0) {
                    int i11;
                    for (i11 = 0; i11 < ilevel2; ++i11) {
                        if (holes2[i11] != holes2[ilevel2]) continue;
                        int n2 = ilevel2;
                        holes2[n2] = holes2[n2] + 1;
                        i11 = -1;
                    }
                    int n3 = ilevel2++;
                    iloop2[n3] = iloop2[n3] + 1;
                    if (ilevel2 != np2) continue;
                    myDebug.startPrint();
                    for (i11 = 0; i11 < np1; ++i11) {
                        myDebug.print(" " + atoms1[holes1[i11]]);
                    }
                    myDebug.print(" -");
                    for (i11 = 0; i11 < np2; ++i11) {
                        myDebug.print(" " + atoms2[holes2[i11]]);
                    }
                    myDebug.println();
                    boolean parityOK = true;
                    if (np1 == 3) {
                        boolean bl = parityOK = !hasParity1 || DistanceMatrixCalculator.getParity(m.getAtom(ii[1])) == DistanceMatrixCalculator.chkParity(false, ii[2], holes1, atoms1);
                    }
                    if (parityOK && np2 == 3) {
                        boolean bl = parityOK = !hasParity2 || DistanceMatrixCalculator.getParity(m.getAtom(ii[2])) == DistanceMatrixCalculator.chkParity(true, ii[1], holes2, atoms2);
                    }
                    if (np1 != 3 || np2 != 3 || parityOK) {
                        // empty if block
                    }
                    myDebug.print(" Parity check: " + ii[1] + ":" + DistanceMatrixCalculator.getParity(m.getAtom(ii[1])) + "-" + DistanceMatrixCalculator.chkParity(false, ii[2], holes1, atoms1));
                    myDebug.println(" | " + ii[2] + ":" + DistanceMatrixCalculator.getParity(m.getAtom(ii[2])) + "-" + DistanceMatrixCalculator.chkParity(true, ii[1], holes2, atoms2));
                    if (parityOK) {
                        shiftAngle = Math.PI * 2 / (double)nRot;
                        double bestShift = 0.0;
                        for (int i12 = 0; i12 < nRot; ++i12) {
                            double energy = 0.0;
                            for (int i1 = 0; i1 < np1; ++i1) {
                                int iAt1 = atoms1[holes1[i1]];
                                for (int i2 = 0; i2 < np2; ++i2) {
                                    double dihed;
                                    int iAt2 = atoms2[holes2[i2]];
                                    if (iAt1 < 0 || iAt2 < 0) continue;
                                    ii[0] = iAt1;
                                    ii[3] = iAt2;
                                    double ee = 0.0;
                                    if (bondForRing.get(b)) {
                                        dihed = angleSet1[i1] - (angleSet2[i2] + (double)i12 * shiftAngle);
                                        ee = DistanceMatrixCalculator.getDihedralMetrid(M2, ii, dihed);
                                    } else {
                                        dihed = angleSet1[i1] - (angleSet2[i2] + (double)i12 * shiftAngle);
                                        ee = DistanceMatrixCalculator.getDihedralMetrid(M2, ii, dihed);
                                    }
                                    if (cisPair[iAt1].get(iAt2) || ii[0] == ii[3]) {
                                        energy += 10.0 * ee;
                                        continue;
                                    }
                                    energy -= ee;
                                }
                            }
                            if (!firstRound && !(energy < lowestEnergy)) continue;
                            firstRound = false;
                            lowestEnergy = energy;
                            bestShift = (double)i12 * shiftAngle;
                            if (np1 == 3) {
                                parity1 = DistanceMatrixCalculator.chkParity(false, ii[2], holes1, atoms1);
                            }
                            if (np2 == 3) {
                                parity2 = DistanceMatrixCalculator.chkParity(true, ii[1], holes2, atoms2);
                            }
                            boolean hasDihed = false;
                            for (int i1 = 0; i1 < np1; ++i1) {
                                int iAt1 = atoms1[holes1[i1]];
                                for (int i2 = 0; i2 < np2; ++i2) {
                                    int iAt2 = atoms2[holes2[i2]];
                                    if (iAt1 < 0 || iAt2 < 0) continue;
                                    ii[0] = iAt1;
                                    ii[3] = iAt2;
                                    double dihed = 0.0;
                                    dihed = DistanceMatrixCalculator.defDihed(bondForRing.get(b), angleSet1, angleSet2, i1, i2, (double)i12 * shiftAngle);
                                    if (bondForRing.get(b)) {
                                        myDebug.println("R " + DistanceMatrixCalculator.myToDegrees(dihed));
                                    } else {
                                        myDebug.println("  " + DistanceMatrixCalculator.myToDegrees(dihed));
                                    }
                                    if (!hasDihed) {
                                        if (cisPair[iAt1].get(iAt2) || bigRingPair[iAt1].get(iAt2)) {
                                            DistanceMatrixCalculator.setMetridM(M2, ii, dihed, 3, 2, myDebug);
                                        } else if (!bondForRing.get(b)) {
                                            DistanceMatrixCalculator.setMetridM(M2, ii, dihed, dihed_type, 2, myDebug);
                                        }
                                    }
                                    if (bondForRing.get(b)) continue;
                                    hasDihed = true;
                                }
                            }
                        }
                        if (bondForRing.get(b)) {
                            myDebug.println("R +/-" + Math.abs(DistanceMatrixCalculator.myToDegrees(bestShift + angleSet2[0])) + " " + lowestEnergy);
                        } else {
                            myDebug.println("     " + DistanceMatrixCalculator.myToDegrees(bestShift + angleSet2[0]) + " " + lowestEnergy);
                        }
                    }
                    --ilevel2;
                    while ((iloop2[ilevel2] == np2 - ilevel2 || atoms2[holes2[ilevel2]] < 0) && ilevel2 > 0) {
                        iloop2[ilevel2] = 0;
                        holes2[ilevel2] = 0;
                        --ilevel2;
                    }
                    if (iloop2[ilevel2] >= np2 - ilevel2) continue;
                    int n4 = ilevel2;
                    holes2[n4] = holes2[n4] + 1;
                }
                --ilevel1;
                while ((iloop1[ilevel1] == np1 - ilevel1 || atoms1[holes1[ilevel1]] < 0) && ilevel1 > 0) {
                    iloop1[ilevel1] = 0;
                    holes1[ilevel1] = 0;
                    --ilevel1;
                }
                if (iloop1[ilevel1] >= np1 - ilevel1) continue;
                int n5 = ilevel1;
                holes1[n5] = holes1[n5] + 1;
            }
            if (!hasParity1 && np1 == 3 && parity1 != 4) {
                m.getAtom(ii[1]).setFlags(parity1, 7);
                myDebug.println("Set parity: " + ii[1] + " " + DistanceMatrixCalculator.getParity(m.getAtom(ii[1])));
            }
            if (hasParity2 || np2 != 3 || parity2 == 4) continue;
            m.getAtom(ii[2]).setFlags(parity2, 7);
            myDebug.println("Set parity: " + ii[2] + " " + DistanceMatrixCalculator.getParity(m.getAtom(ii[2])));
        }
        for (i = 0; i < mn; ++i) {
            distanceAtoms[i] = new BitSet(mn);
            distanceAtoms[i].set(i);
            for (int j7 = 0; j7 < mn; ++j7) {
                if (!(DistanceMatrixCalculator.getTypeM(M2, i, j7) > 0.0)) continue;
                distanceAtoms[i].set(j7);
            }
        }
        for (i = 0; i < mn; ++i) {
            m_orig.getAtom(i).setFlags(m.getAtom(i).getFlags());
        }
    }

    public static double defDihed(boolean ring, double[] angleSet1, double[] angleSet2, int i1, int i2, double shift) {
        double dihed = 0.0;
        if (ring) {
            double dihed2;
            double dihed1;
            for (dihed1 = angleSet1[i1] - (angleSet2[i2] + shift); dihed1 > Math.PI; dihed1 -= Math.PI * 2) {
            }
            while (dihed1 < -Math.PI) {
                dihed1 += Math.PI * 2;
            }
            for (dihed2 = angleSet1[i1] - (angleSet2[i2] + shift - 2.0 * angleSet2[0]); dihed2 > Math.PI; dihed2 -= Math.PI * 2) {
            }
            while (dihed2 < -Math.PI) {
                dihed2 += Math.PI * 2;
            }
            dihed = dihed1;
        } else {
            dihed = angleSet1[i1] - (angleSet2[i2] + shift);
        }
        return dihed;
    }

    public static int getParity(MolAtom a) {
        return a.getFlags() & 7;
    }

    public static int chkParity(boolean evenParity, int connectedAtom, int[] holes, int[] atoms) {
        int j;
        int i;
        int actualParity = 4;
        if (holes.length != 3 || atoms.length != 3) {
            return actualParity;
        }
        int[] iA = new int[]{atoms[holes[0]], atoms[holes[1]], atoms[holes[2]], connectedAtom};
        for (int i2 = 0; i2 < 4; ++i2) {
            if (iA[i2] == -1) {
                iA[i2] = Integer.MAX_VALUE;
                continue;
            }
            if (m.getAtom(iA[i2]).getAtno() != 1 || m.getAtom(iA[i2]).getMassno() != 0) continue;
            iA[i2] = Integer.MAX_VALUE;
        }
        int[] iO = new int[]{0, 0, 0, 0};
        int nAt = 4;
        for (i = 0; i < nAt; ++i) {
            for (j = 0; j < nAt; ++j) {
                if (i == j) continue;
                if (iA[i] == iA[j]) {
                    return actualParity;
                }
                if (iA[i] <= iA[j]) continue;
                int n = i;
                iO[n] = iO[n] + 1;
            }
        }
        for (i = 0; i < nAt - 1; ++i) {
            if (iO[i] == i) continue;
            for (j = i + 1; j < nAt; ++j) {
                if (iO[j] != i) continue;
                evenParity = !evenParity;
                int iOi = iO[i];
                iO[i] = iO[j];
                iO[j] = iOi;
            }
        }
        actualParity = evenParity ? 2 : 1;
        return actualParity;
    }

    public static void getAtomsAtBondDist(double[][][] M2, int idx, BitSet dA, SelectionMolecule m, int[][] ctab, int[][] btab, debugPrintout debug) {
        dA.set(idx);
        for (int i = 0; i < ctab[idx].length; ++i) {
            int aN1 = ctab[idx][i];
            if (aN1 == idx) continue;
            MolAtom a1 = m.getAtom(aN1);
            MolBond b1 = m.getBond(btab[idx][aN1]);
            double length1 = m.getDesiredLength(b1);
            if (DistanceMatrixCalculator.getTypeM(M2, aN1, idx) != 1.0) {
                DistanceMatrixCalculator.setDistM(M2, idx, aN1, length1 * length1, 1);
                dA.set(aN1);
                debug.println(idx + "-" + aN1);
            }
            for (int j = 0; j < ctab[aN1].length; ++j) {
                int aN2 = ctab[aN1][j];
                MolBond b2 = m.getBond(btab[aN1][aN2]);
                int hybr1 = a1.getHybridizationState();
                double fi1 = DistanceMatrixCalculator.getAngleFromHybridization(hybr1);
                double length2 = m.getDesiredLength(b2);
                if (DistanceMatrixCalculator.getTypeM(M2, aN2, idx) != 0.0 && !(DistanceMatrixCalculator.getTypeM(M2, aN2, idx) > 2.0)) continue;
                debug.println(idx + "-" + aN1 + "-" + aN2);
                double lenSin = length2 * Math.sin(fi1);
                double lenCos = length2 * Math.cos(fi1);
                double dist2 = lenSin * lenSin + (length1 - lenCos) * (length1 - lenCos);
                DistanceMatrixCalculator.setDistM(M2, idx, aN2, dist2, 2);
                dA.set(aN2);
            }
        }
    }

    static double getAngleFromHybridization(int hybr) {
        if (hybr == 2) {
            return Math.PI;
        }
        if (hybr == 3) {
            return 2.0943951023931953;
        }
        if (hybr == 4) {
            return 1.9106119;
        }
        return 0.0;
    }

    public static int getPeriodFromHybridization(int hybr) {
        int period = 0;
        if (hybr == 2) {
            period = 1;
        } else if (hybr == 3) {
            period = 2;
        } else if (hybr == 4) {
            period = 3;
        }
        return period;
    }

    public static double getValueFromMetrids(double[][][] M2, int[] ii, int numAt, int t) {
        double ang = 0.0;
        if (numAt == 3 && t == 2) {
            double ab;
            double cosang;
            double a2 = DistanceMatrixCalculator.getDistM(M2, ii[0], ii[1]);
            double b2 = DistanceMatrixCalculator.getDistM(M2, ii[1], ii[2]);
            double c2 = DistanceMatrixCalculator.getDistM(M2, ii[0], ii[2]);
            if (a2 * b2 < 0.0) {
                // empty if block
            }
            if (Math.abs(cosang = (a2 + b2 - c2) / (2.0 * (ab = Math.sqrt(a2 * b2)))) > 1.0) {
                // empty if block
            }
            ang = Math.acos(cosang);
        } else if (numAt != 4 || t == 4) {
            // empty if block
        }
        return ang;
    }

    public static double getDihedralDistance(double l1, double l2, double l3, double phy1, double phy2, double dihed) {
        double x = l2 - l1 * Math.cos(phy1) - l3 * Math.cos(phy2);
        double y = l3 * Math.sin(phy2) * Math.cos(dihed) - l1 * Math.sin(phy1);
        double z = l3 * Math.sin(phy2) * Math.sin(dihed);
        return x * x + y * y + z * z;
    }

    public static double getDihedralMetrid(double l1, double l2, double l3, double phy1, double phy2, double dihed) {
        double x = l2 - l1 * Math.cos(phy1) - l3 * Math.cos(phy2);
        double y = l3 * Math.sin(phy2) * Math.cos(dihed) - l1 * Math.sin(phy1);
        double z = l3 * Math.sin(phy2) * Math.sin(dihed);
        return x * x + y * y + z * z;
    }

    public static double getDihedralMetrid(double[][][] M2, int[] ii, double dihed) {
        double l1 = Math.sqrt(DistanceMatrixCalculator.getDistM(M2, ii[0], ii[1]));
        double l2 = Math.sqrt(DistanceMatrixCalculator.getDistM(M2, ii[1], ii[2]));
        double l3 = Math.sqrt(DistanceMatrixCalculator.getDistM(M2, ii[2], ii[3]));
        int[] iii = new int[]{ii[0], ii[1], ii[2]};
        double phi1 = DistanceMatrixCalculator.getValueFromMetrids(M2, iii, 3, 2);
        int[] jjj = new int[]{ii[1], ii[2], ii[3]};
        double phi2 = DistanceMatrixCalculator.getValueFromMetrids(M2, jjj, 3, 2);
        return DistanceMatrixCalculator.getDihedralMetrid(l1, l2, l3, phi1, phi2, dihed);
    }

    public static int locateDihedralAtom(int idx0, int idx1, int idx2, int[][] ctab) {
        int aN3 = -1;
        if (ctab[idx2].length == 2) {
            aN3 = ctab[idx2][0] == idx1 ? ctab[idx2][1] : ctab[idx2][0];
        }
        return aN3;
    }

    public static void setDistM(double[][][] M2, int i1, int i2, double d, int t) {
        int ii1 = Math.min(i1, i2);
        int ii2 = Math.max(i1, i2);
        M2[0][ii1][ii2 - ii1 - 1] = d;
        M2[1][ii1][ii2 - ii1 - 1] = t;
    }

    public static void setMetridM(double[][][] M2, int[] ii, double d, int t, int opt, debugPrintout debug) {
        int numAt = 2;
        double dd = 0.0;
        if (t == 1) {
            dd = d * d;
        }
        if (t == 2) {
            double b2;
            numAt = 3;
            double a2 = DistanceMatrixCalculator.getDistM(M2, ii[0], ii[1]);
            if (a2 * (b2 = DistanceMatrixCalculator.getDistM(M2, ii[1], ii[2])) < 0.0) {
                // empty if block
            }
            double ab = Math.sqrt(a2 * b2);
            dd = a2 + b2 - 2.0 * ab * Math.cos(d);
        }
        if (t == 4 || t == 3) {
            numAt = 4;
            double l1 = Math.sqrt(DistanceMatrixCalculator.getDistM(M2, ii[0], ii[1]));
            double l2 = Math.sqrt(DistanceMatrixCalculator.getDistM(M2, ii[1], ii[2]));
            double l3 = Math.sqrt(DistanceMatrixCalculator.getDistM(M2, ii[2], ii[3]));
            int[] iii = new int[]{ii[0], ii[1], ii[2]};
            double phi1 = DistanceMatrixCalculator.getValueFromMetrids(M2, iii, 3, 2);
            int[] jjj = new int[]{ii[1], ii[2], ii[3]};
            double phi2 = DistanceMatrixCalculator.getValueFromMetrids(M2, jjj, 3, 2);
            dd = DistanceMatrixCalculator.getDihedralMetrid(l1, l2, l3, phi1, phi2, d);
        }
        for (int i = 0; i < numAt; ++i) {
            for (int j = 0; j < i; ++j) {
                if (ii[i] != ii[j]) continue;
                return;
            }
        }
        int ii1 = Math.min(ii[0], ii[numAt - 1]);
        int ii2 = Math.max(ii[0], ii[numAt - 1]);
        debug.println("setMetridM: " + ii1 + " " + ii2 + " " + t + " " + dd);
        double t0 = DistanceMatrixCalculator.getTypeM(M2, ii1, ii2);
        if (t0 <= 0.0 || opt == 3 || opt == 1 && t0 > (double)t || opt == 2 && t0 >= (double)t) {
            M2[0][ii1][ii2 - ii1 - 1] = dd;
            M2[1][ii1][ii2 - ii1 - 1] = t;
        } else if (DistanceMatrixCalculator.getDistM(M2, ii1, ii2) != dd || (double)t != t0) {
            debug.println("Setting the desired metrid was unsuccessful.");
        }
    }

    public static double getDistM(double[][][] M2, int i1, int i2) {
        if (i1 == i2) {
            return 0.0;
        }
        if (i1 < i2) {
            return M2[0][i1][i2 - i1 - 1];
        }
        return M2[0][i2][i1 - i2 - 1];
    }

    public static double getTypeM(double[][][] M2, int i1, int i2) {
        if (i1 == i2) {
            return -1.0;
        }
        if (i1 < i2) {
            return M2[1][i1][i2 - i1 - 1];
        }
        return M2[1][i2][i1 - i2 - 1];
    }
}

