/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.clean;

public class FRPRMinimalization {
    boolean Time_Check = true;
    long Time_Limit = 5000L;
    boolean Debug = false;
    int ITMAX_frprmin = 300;
    int ITMAX_brent = 100;
    static double GOLD = 1.618034;
    static double EPS = 1.0E-10;

    double frprmin(double[] p, double[][] dom, double ftol, int[] iter, double[] d, long itime) throws Exception {
        int i;
        double fret = 0.0;
        double fp = this.f(p);
        int n = p.length;
        double[] g = new double[n];
        double[] xi = new double[n];
        double[] h = new double[n];
        xi = this.df(p, d);
        for (i = 0; i < n; ++i) {
            g[i] = -xi[i];
            xi[i] = h[i] = g[i];
        }
        for (i = 0; i < this.ITMAX_frprmin; ++i) {
            int j;
            if (this.Time_Check && System.currentTimeMillis() - this.Time_Limit > itime) {
                if (this.Debug) {
                    System.err.println("Time limit reached in Optimization.");
                }
                i = this.ITMAX_frprmin;
            }
            iter[0] = i;
            fret = this.linmin(p, xi, dom);
            if (2.0 * Math.abs(fret - fp) < ftol * (Math.abs(fret) + Math.abs(fp) + EPS)) {
                return fret;
            }
            fp = this.f(p);
            xi = this.df(p, d);
            double gg = 0.0;
            double dgg = 0.0;
            for (j = 0; j < n; ++j) {
                gg += g[j] * g[j];
                dgg += (xi[j] + g[j]) * xi[j];
            }
            if (gg == 0.0) {
                return fret;
            }
            double gam = dgg / gg;
            for (j = 0; j < n; ++j) {
                g[j] = -xi[j];
                xi[j] = h[j] = g[j] + gam * h[j];
            }
        }
        if (this.Debug) {
            System.err.println(" Iteration limit reached in frprmn");
        }
        return fret;
    }

    double linmin(double[] min, double[] xi, double[][] dom) throws Exception {
        double TOL = 2.0E-10;
        double ret = 0.0;
        int n = min.length;
        double[] pcom = new double[n];
        double[] xicom = new double[n];
        for (int i = 0; i < n; ++i) {
            pcom[i] = min[i];
            xicom[i] = xi[i];
        }
        double[] x = new double[3];
        double[] fx = new double[3];
        double[] xmintol = new double[2];
        x[0] = 0.0;
        x[1] = 1.0;
        while (dom != null && Double.isNaN(this.f1dim(x[1], pcom, xicom))) {
            x[1] = x[1] / 2.0;
        }
        xmintol[0] = 0.0;
        xmintol[1] = TOL;
        this.mnbrak(x, fx, pcom, xicom, dom);
        ret = this.brent(x, xmintol, pcom, xicom);
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            xi[n2] = xi[n2] * xmintol[0];
            int n3 = i;
            min[n3] = min[n3] + xi[i];
        }
        return ret;
    }

    double f1dim(double x, double[] pcom, double[] xicom) throws Exception {
        int n = pcom.length;
        double[] xt = new double[n];
        for (int i = 0; i < n; ++i) {
            xt[i] = pcom[i] + x * xicom[i];
        }
        double ff = this.f(xt);
        return ff;
    }

    void mnbrak(double[] x, double[] fx, double[] pcom, double[] xicom, double[][] dom) throws Exception {
        int GLIMIT = 100;
        double TINY = 1.0E-20;
        double dum = 0.0;
        fx[0] = this.f1dim(x[0], pcom, xicom);
        fx[1] = this.f1dim(x[1], pcom, xicom);
        if (fx[1] > fx[0]) {
            dum = x[0];
            x[0] = x[1];
            x[1] = dum;
            dum = fx[1];
            fx[1] = fx[0];
            fx[0] = dum;
        }
        dum = GOLD;
        x[2] = x[1] + dum * (x[1] - x[0]);
        while (dom != null && Double.isNaN(fx[2] = this.f1dim(x[2], pcom, xicom))) {
            x[2] = x[1] + (dum /= 2.0) * (x[1] - x[2]);
        }
        while (fx[1] > fx[2]) {
            double fu;
            double r = (x[1] - x[0]) * (fx[1] - fx[2]);
            double q = (x[1] - x[2]) * (fx[1] - fx[0]);
            double u = x[1] - ((x[1] - x[2]) * q - (x[1] - x[0]) * r) / (2.0 * FRPRMinimalization.sign(Math.max(Math.abs(q - r), TINY), q - r));
            double ulim = x[1] + (double)GLIMIT * (x[2] - x[1]);
            if ((x[1] - u) * (u - x[2]) > 0.0) {
                fu = this.f1dim(u, pcom, xicom);
                if (fu < fx[2]) {
                    x[0] = x[1];
                    x[1] = u;
                    fx[0] = fx[1];
                    fx[1] = fu;
                    return;
                }
                if (fu > fx[1]) {
                    x[2] = u;
                    fx[2] = fu;
                    return;
                }
                u = x[2] + GOLD * (x[2] - x[1]);
                fu = this.f1dim(u, pcom, xicom);
            } else if ((x[2] - u) * (u - ulim) > 0.0) {
                fu = this.f1dim(u, pcom, xicom);
                if (fu < fx[2]) {
                    x[1] = x[2];
                    x[2] = u;
                    u = x[2] + GOLD * (x[2] - x[1]);
                    fx[1] = fx[2];
                    fx[2] = fu;
                    fu = this.f1dim(u, pcom, xicom);
                }
            } else if ((u - ulim) * (ulim - x[2]) >= 0.0) {
                u = ulim;
                fu = this.f1dim(u, pcom, xicom);
            } else {
                u = x[2] + GOLD * (x[2] - x[1]);
                fu = this.f1dim(u, pcom, xicom);
            }
            x[0] = x[1];
            x[1] = x[2];
            x[2] = u;
            fx[0] = fx[1];
            fx[1] = fx[2];
            fx[2] = fu;
        }
    }

    static double sign(double a, double b) {
        return b >= 0.0 ? Math.abs(a) : -Math.abs(a);
    }

    double brent(double[] xx, double[] xmtol, double[] pcom, double[] xicom) throws Exception {
        double fx;
        double v;
        double ZEPS = 1.0E-10;
        double CGOLD = 0.381966;
        double d = 0.0;
        double e = 0.0;
        double a = xx[0] < xx[2] ? xx[0] : xx[2];
        double b = xx[0] > xx[2] ? xx[0] : xx[2];
        double w = v = xx[1];
        double x = v;
        double fv = fx = this.f1dim(x, pcom, xicom);
        double fw = fx;
        for (int i = 0; i < this.ITMAX_brent; ++i) {
            double u;
            double xm = 0.5 * (a + b);
            double tol1 = xmtol[1] * Math.abs(x) + ZEPS;
            double tol2 = 2.0 * tol1;
            if (Math.abs(x - xm) <= tol2 - 0.5 * (b - a)) {
                xmtol[0] = x;
                return fx;
            }
            if (Math.abs(e) > tol1) {
                double r = (x - w) * (fx - fv);
                double q = (x - v) * (fx - fw);
                double p = (x - v) * q - (x - w) * r;
                if ((q = 2.0 * (q - r)) > 0.0) {
                    p = -p;
                }
                q = Math.abs(q);
                double etemp = e;
                e = d;
                if (Math.abs(p) >= Math.abs(0.5 * q * etemp) || p <= q * (a - x) || p >= q * (b - x)) {
                    e = x >= xm ? a - x : b - x;
                    d = CGOLD * e;
                } else {
                    d = p / q;
                    u = x + d;
                    if (u - a < tol2 || b - u < tol2) {
                        d = FRPRMinimalization.sign(tol1, xm - x);
                    }
                }
            } else {
                e = x >= xm ? a - x : b - x;
                d = CGOLD * e;
            }
            u = Math.abs(d) >= tol1 ? x + d : x + FRPRMinimalization.sign(tol1, d);
            double fu = this.f1dim(u, pcom, xicom);
            if (fu <= fx) {
                if (u >= x) {
                    a = x;
                } else {
                    b = x;
                }
                v = w;
                w = x;
                x = u;
                fv = fw;
                fw = fx;
                fx = fu;
                continue;
            }
            if (u < x) {
                a = u;
            } else {
                b = u;
            }
            if (fu <= fw || w == x) {
                v = w;
                w = u;
                fv = fw;
                fw = fu;
                continue;
            }
            if (!(fu <= fv) && v != x && v != w) continue;
            v = u;
            fv = fu;
        }
        xmtol[0] = x;
        if (this.Debug) {
            System.err.println("Iteration limit reached in brent");
        }
        return fx;
    }

    double f(double[] x) throws Exception {
        return 0.0;
    }

    double[] df(double[] x, double[] d) {
        return new double[x.length];
    }

    static double min(double[] x) {
        double v = x[x.length - 1];
        for (int i = x.length - 2; i >= 0; --i) {
            v = x[i] < v ? x[i] : v;
        }
        return v;
    }
}

