/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.clean;

import chemaxon.calculations.clean.Clean3D;
import chemaxon.calculations.clean.Optimization;
import chemaxon.core.util.BondTable;
import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.TextUtils;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.struc.myMolecule;
import chemaxon.marvin.modelling.util.Pinger;
import chemaxon.marvin.modelling.util.U;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.SelectionMolecule;
import java.text.DecimalFormat;
import java.util.BitSet;

public class Opt3D
extends Optimization {
    public static boolean dodebug = false;
    static final double LINEAR = Math.PI;
    static final double TRIGONAL = 2.0943951023931953;
    static final double TETRAHEDRAL = 1.9106119;
    static final double TRIGONAL_BIPYRAMIDAL_1 = 1.5707963267948966;
    static final double TRIGONAL_BIPYRAMIDAL_2 = 2.0943951023931953;
    static final double TRIGONAL_BIPYRAMIDAL_3 = Math.PI;
    static final double OCTAHEDRAL_1 = 1.5707963267948966;
    static final double OCTAHEDRAL_2 = Math.PI;
    static final double BOND_WEIGHT = 5.0;
    static final double ANGLE_WEIGHT = 2.0;
    static final double PLANAR_TORSION_WEIGHT = 1.0;
    static final double TORSION_WEIGHT = 0.05;
    static double NOT_CONNECTED_WEIGHT = 50.0;
    static double DIMENSION_WEIGHT = 0.1;
    static double ABS_DIMENSION_WEIGHT = 0.001;
    static double MAX_QUAD_METRIC_PENALTY = 100.0;
    static double INVALID_METRID_WEIGHT = 1000000.0;
    static double MIN_DIST = 0.5;
    static final double EPS_DIMENSION = 0.1;
    static double DELTA = 1.0E-5;
    static final int EXCLUDE_ATOM = -1;
    SelectionMolecule m;
    int[][] ctab;
    BondTable btab;
    double[][] metridM;
    double[][] metridMFlags;
    int[] optFlag;
    BitSet[] distA;
    double[] csMetric;
    int dimension;
    int reducedDimension;

    public Opt3D(SelectionMolecule molecule, double[][] metridMat, double[][] metridMatFlags, BitSet[] atomDist, int[] optFl, int dim, double[] coordMetric, int redDim, debugPrintout debugClass) {
        debug = debugClass;
        this.m = molecule;
        this.dimension = dim;
        this.distA = atomDist;
        this.csMetric = coordMetric;
        this.reducedDimension = redDim;
        int mn = this.m.getAtomCount();
        this.ctab = new int[mn][];
        this.btab = BondTable.createBondTable(mn);
        this.ctab = this.m.getCtab();
        this.btab = this.m.getBondTable();
        this.optFlag = optFl;
        this.metridM = metridMat;
        this.metridMFlags = metridMatFlags;
        this.ITMAX_frprmin = 10000;
        this.Use_Derivatives = true;
    }

    public void setWeight_dimension(double w) {
        DIMENSION_WEIGHT = w;
    }

    public void setWeight_not_conn(double w) {
        NOT_CONNECTED_WEIGHT = w;
    }

    public double[][] gradMin(int methodFlag, double[] coordinates, double FTOL, long itime) {
        int d = this.dimension;
        int[] iter = new int[]{0};
        this.frprmin(coordinates, FTOL, iter, itime);
        if (dodebug) {
            debug.println("Ossziteracio " + iter[0]);
        }
        double[][] coords = new double[this.m.getAtomCount()][3];
        for (int i = 0; i < this.m.getAtomCount(); ++i) {
            for (int j = 0; j < 3; ++j) {
                double dd;
                coords[i][j] = dd = coordinates[i * d + j];
            }
        }
        return coords;
    }

    public double[][] findMin(double[] coordinates, double FTOL, long itime) {
        int d = this.dimension;
        int[] iter = new int[]{0};
        if (dodebug) {
            debug.println("Metric");
            debug.printVector(this.csMetric);
        }
        this.frprmin(coordinates, FTOL, iter, itime);
        if (dodebug) {
            debug.println("Ossziteracio " + iter[0]);
        }
        double[][] coords = new double[this.m.getAtomCount()][3];
        boolean moreIterationNeeded = false;
        if (moreIterationNeeded) {
            if (dodebug) {
                debug.println("Perturbacio utan ");
                debug.printVector(coordinates);
            }
            iter[0] = 0;
            this.frprmin(coordinates, FTOL, iter, itime);
        }
        for (int i = 0; i < this.m.getAtomCount(); ++i) {
            for (int j = 0; j < 3; ++j) {
                double dd;
                coords[i][j] = dd = coordinates[i * d + j];
            }
        }
        return coords;
    }

    @Override
    double f(double[] x) {
        int d = this.dimension;
        int mn = this.m.getAtomCount();
        double sum = 0.0;
        double m0_ij = 0.0;
        for (int i = 0; i < mn; ++i) {
            int j;
            if (this.optFlag[i] == -1) continue;
            for (j = i + 1; j < mn; ++j) {
                double deltaD;
                if (this.optFlag[j] == -1) continue;
                int jj = j - i - 1;
                double w = 0.0;
                if (this.metridMFlags[i][jj] == 0.0) {
                    w = NOT_CONNECTED_WEIGHT;
                } else if (this.metridMFlags[i][jj] == 1.0) {
                    w = 5.0;
                } else if (this.metridMFlags[i][jj] == 2.0) {
                    w = 2.0;
                } else if (this.metridMFlags[i][jj] == 3.0) {
                    w = 1.0;
                } else if (this.metridMFlags[i][jj] == 4.0) {
                    w = 0.05;
                } else if (dodebug) {
                    debug.reportError("ERROR: Invalid metrid flag for " + i + " " + j + " " + this.metridMFlags[i][jj]);
                }
                double m_ij = this.calcDist2(i, j, d, x);
                if (m_ij <= 0.0) {
                    // empty if block
                }
                if (this.metridMFlags[i][jj] == 0.0) {
                    m0_ij = Math.max(6.0, m_ij);
                } else {
                    if (this.metridM[i][jj] < 0.0) {
                        if (dodebug) {
                            debug.reportError("ERROR: Invalid desired metrid for " + i + " " + j);
                        }
                        return 0.0;
                    }
                    m0_ij = this.metridM[i][jj];
                }
                if (m_ij >= MIN_DIST * MIN_DIST) {
                    deltaD = Math.abs(Math.sqrt(m_ij) - Math.sqrt(m0_ij));
                    sum += w * deltaD * deltaD / 2.0;
                    continue;
                }
                deltaD = Math.sqrt(MIN_DIST * MIN_DIST - m_ij);
                if (m_ij > 0.0) {
                    deltaD = Math.abs(Math.sqrt(m_ij) - MIN_DIST);
                }
                w = INVALID_METRID_WEIGHT;
                sum += w * deltaD * deltaD / 2.0;
                if (!(m_ij <= 0.0) || !dodebug) continue;
                debug.println("ERROR: Invalid actual metrid for " + i + " " + j + " " + m_ij + " " + sum);
            }
            for (j = this.reducedDimension; j < d; ++j) {
                double linearPenalty = DIMENSION_WEIGHT * Math.min(Math.abs(x[i * d + j]), 0.0);
                double quadPenalty = Math.min(Math.abs(x[i * d + j]), MAX_QUAD_METRIC_PENALTY);
                double dimPenalty = ABS_DIMENSION_WEIGHT * quadPenalty * quadPenalty / 2.0 + linearPenalty;
                sum += dimPenalty;
            }
        }
        return sum;
    }

    @Override
    double[] df(double[] x) {
        int d = this.dimension;
        int mn = this.m.getAtomCount();
        double sum = 0.0;
        double m0_ij = 0.0;
        double[] grad = new double[x.length];
        for (int i = 0; i < mn; ++i) {
            int j;
            if (this.optFlag[i] == -1) continue;
            for (j = i + 1; j < mn; ++j) {
                double deltaD;
                if (this.optFlag[j] == -1) continue;
                int jj = j - i - 1;
                double w = 0.0;
                if (this.metridMFlags[i][jj] == 0.0) {
                    w = NOT_CONNECTED_WEIGHT;
                } else if (this.metridMFlags[i][jj] == 1.0) {
                    w = 5.0;
                } else if (this.metridMFlags[i][jj] == 2.0) {
                    w = 2.0;
                } else if (this.metridMFlags[i][jj] == 3.0) {
                    w = 1.0;
                } else if (this.metridMFlags[i][jj] == 4.0) {
                    w = 0.05;
                } else if (dodebug) {
                    debug.println("ERROR: Invalid metrid flag for " + i + " " + j);
                }
                double m_ij = this.calcDist2(i, j, d, x);
                if (m_ij <= 0.0) {
                    double penalty = -Math.sqrt(-m_ij) * INVALID_METRID_WEIGHT;
                }
                if (this.metridMFlags[i][jj] == 0.0) {
                    m0_ij = Math.max(6.0, m_ij);
                } else {
                    if (this.metridM[i][jj] < 0.0) {
                        if (dodebug) {
                            debug.println("ERROR: Invalid desired metrid for " + i + " " + j);
                        }
                        return grad;
                    }
                    m0_ij = this.metridM[i][jj];
                }
                if (m_ij >= MIN_DIST * MIN_DIST) {
                    deltaD = Math.sqrt(m_ij) - Math.sqrt(m0_ij);
                    this.addGrad(grad, i, j, x, w * deltaD, d);
                    this.addGrad(grad, j, i, x, w * deltaD, d);
                    sum += w * deltaD * deltaD / 2.0;
                    continue;
                }
                deltaD = -Math.sqrt(MIN_DIST * MIN_DIST - m_ij);
                if (m_ij > 0.0) {
                    deltaD = Math.sqrt(m_ij) - MIN_DIST;
                }
                w = INVALID_METRID_WEIGHT;
                this.addGrad(grad, i, j, x, w * deltaD, d);
                this.addGrad(grad, j, i, x, w * deltaD, d);
                sum += w * deltaD * deltaD / 2.0;
                if (!(m_ij <= 0.0) || !dodebug) continue;
                debug.println("ERROR: Invalid actual metrid for " + i + " " + j + " " + m_ij);
            }
            for (j = this.reducedDimension; j < d; ++j) {
                double deriv = ABS_DIMENSION_WEIGHT * x[i * d + j];
                if (Math.abs(x[i * d + j]) > MAX_QUAD_METRIC_PENALTY) {
                    deriv = DIMENSION_WEIGHT * x[i * d + j] / Math.abs(x[i * d + j]);
                }
                int n = i * d + j;
                grad[n] = grad[n] + deriv;
            }
        }
        return grad;
    }

    double f_old(double[] x) {
        int d = this.dimension;
        int mn = this.m.getAtomCount();
        double sum = 0.0;
        for (int i = 0; i < mn; ++i) {
            double dist2;
            int j;
            if (this.optFlag[i] == -1) continue;
            for (j = 0; j < this.ctab[i].length; ++j) {
                int i2 = this.ctab[i][j];
                if (i2 > i && this.optFlag[i2] != -1) {
                    dist2 = this.calcDist2(i, i2, d, x);
                    sum += 5.0 * this.f_dist(i, i2, dist2);
                }
                for (int k = 0; k < this.ctab[i2].length; ++k) {
                    int i3 = this.ctab[i2][k];
                    if (i3 <= i || this.optFlag[i3] == -1) continue;
                    dist2 = this.calcDist2(i, i3, d, x);
                    sum += 2.0 * this.f_angle(i, i2, i3, dist2);
                }
            }
            for (j = i + 1; j < mn; ++j) {
                if (this.distA[i].get(j) || this.optFlag[i] == -1) continue;
                dist2 = this.calcDist2(i, j, d, x);
                sum += NOT_CONNECTED_WEIGHT * this.f_notConn(dist2);
            }
            for (j = this.reducedDimension; j < d; ++j) {
                dist2 = x[i * d + j] * x[i * d + j];
                sum += DIMENSION_WEIGHT * dist2;
            }
        }
        return sum;
    }

    double[] df_old(double[] x) {
        int d = this.dimension;
        int mn = this.m.getAtomCount();
        double[] grad = new double[x.length];
        double[] numericGrad = new double[x.length];
        if (dodebug) {
            debug.println("Start Numeric Gradient ");
        }
        for (int i = 0; i < mn; ++i) {
            double deriv;
            int j;
            for (j = 0; j < d; ++j) {
                int n = i * d + j;
                x[n] = x[n] + DELTA;
                double fp = this.f(x);
                int n2 = i * d + j;
                x[n2] = x[n2] - 2.0 * DELTA;
                double fm = this.f(x);
                int n3 = i * d + j;
                numericGrad[n3] = numericGrad[n3] + (fp - fm) / (2.0 * DELTA);
                int n4 = i * d + j;
                x[n4] = x[n4] + DELTA;
            }
            if (this.optFlag[i] != -1) {
                for (j = 0; j < this.ctab[i].length; ++j) {
                    int i2 = this.ctab[i][j];
                    if (i2 > i && this.optFlag[i2] != -1) {
                        double dist2 = this.calcDist2(i, i2, d, x);
                        double deriv2 = 5.0 * this.f_distDeriv(i, i2, dist2);
                        this.addGrad(grad, i, i2, x, deriv2, d);
                    }
                    for (int k = 0; k < this.ctab[i2].length; ++k) {
                        int i3 = this.ctab[i2][k];
                        if (i3 <= i || this.optFlag[i3] == -1) continue;
                        double dist2 = this.calcDist2(i, i3, d, x);
                        double deriv3 = 2.0 * this.f_angleDeriv(i, i2, i3, dist2);
                        this.addGrad(grad, i, i3, x, deriv3, d);
                    }
                }
            }
            for (j = 0; j < mn; ++j) {
                if (this.distA[i].get(j) || this.optFlag[i] == -1) continue;
                double dist2 = this.calcDist2(i, j, d, x);
                deriv = NOT_CONNECTED_WEIGHT * this.f_notConnDeriv(dist2);
                this.addGrad(grad, i, j, x, deriv, d);
            }
            for (j = this.reducedDimension; j < d; ++j) {
                double dist = x[i * d + j];
                deriv = 2.0 * dist;
                int n = i * d + j;
                grad[n] = grad[n] + DIMENSION_WEIGHT * deriv;
            }
        }
        if (dodebug) {
            debug.println("Complete Numeric Gradient ");
        }
        return numericGrad;
    }

    double f_dist(int i1, int i2, double dist2) {
        int bN = this.btab.getBondIndex(i1, i2);
        if (bN < 0) {
            return 0.0;
        }
        MolBond b = this.m.getBond(bN);
        double length = this.m.getDesiredLength(b);
        dist2 = Math.sqrt(Math.abs(dist2));
        length = dist2 - length;
        return length * length;
    }

    double f_distDeriv(int i1, int i2, double dist2) {
        int bN = this.btab.getBondIndex(i1, i2);
        if (bN < 0) {
            return 0.0;
        }
        MolBond b = this.m.getBond(bN);
        double length = this.m.getDesiredLength(b);
        dist2 = Math.sqrt(Math.abs(dist2));
        return 2.0 * (dist2 - length);
    }

    double f_angle(int i1, int i2, int i3, double dist2) {
        MolBond b1 = this.m.getBond(this.btab.getBondIndex(i1, i2));
        MolBond b2 = this.m.getBond(this.btab.getBondIndex(i2, i3));
        double length1 = this.m.getDesiredLength(b1);
        double length2 = this.m.getDesiredLength(b2);
        MolAtom a = this.m.getAtom(i2);
        int hybr = a.getHybridizationState();
        double fi = this.getAngleFromHybridization(hybr);
        double lenSin = length2 * Math.sin(fi);
        double lenCos = length2 * Math.cos(fi);
        length2 = lenSin * lenSin + (length1 - lenCos) * (length1 - lenCos);
        dist2 = Math.sqrt(Math.abs(dist2));
        length2 = Math.sqrt(length2);
        return (dist2 - length2) * (dist2 - length2);
    }

    double f_angleDeriv(int i1, int i2, int i3, double dist2) {
        MolBond b1 = this.m.getBond(this.btab.getBondIndex(i1, i2));
        MolBond b2 = this.m.getBond(this.btab.getBondIndex(i2, i3));
        double length1 = this.m.getDesiredLength(b1);
        double length2 = this.m.getDesiredLength(b2);
        MolAtom a = this.m.getAtom(i2);
        int hybr = a.getHybridizationState();
        double fi = this.getAngleFromHybridization(hybr);
        double lenSin = length2 * Math.sin(fi);
        double lenCos = length2 * Math.cos(fi);
        length2 = lenSin * lenSin + (length1 - lenCos) * (length1 - lenCos);
        dist2 = Math.sqrt(Math.abs(dist2));
        length2 = Math.sqrt(length2);
        return 2.0 * (dist2 - length2);
    }

    double f_torsion(int i1, int i2, int i3, int i4, double dist2) {
        MolBond b1 = this.m.getBond(this.btab.getBondIndex(i1, i2));
        MolBond b2 = this.m.getBond(this.btab.getBondIndex(i2, i3));
        MolBond b3 = this.m.getBond(this.btab.getBondIndex(i3, i4));
        double length1 = this.m.getDesiredLength(b1);
        double length2 = this.m.getDesiredLength(b2);
        double length3 = this.m.getDesiredLength(b3);
        return dist2 > (length3 = length1 * length1 + length2 * length2 + length3 * length3) ? dist2 - length3 : length3 - dist2;
    }

    double f_torsionDeriv(int i1, int i2, int i3, int i4, double dist2) {
        MolBond b1 = this.m.getBond(this.btab.getBondIndex(i1, i2));
        MolBond b2 = this.m.getBond(this.btab.getBondIndex(i2, i3));
        MolBond b3 = this.m.getBond(this.btab.getBondIndex(i3, i4));
        double length1 = this.m.getDesiredLength(b1);
        double length2 = this.m.getDesiredLength(b2);
        double length3 = this.m.getDesiredLength(b3);
        return dist2 > (length3 = length1 * length1 + length2 * length2 + length3 * length3) ? Math.sqrt(Math.abs(dist2)) : -Math.sqrt(Math.abs(dist2));
    }

    double f_notConn(double dist2) {
        return 1.0 / Math.sqrt(Math.abs(dist2));
    }

    double f_notConnDeriv(double dist2) {
        return -1.0 / dist2;
    }

    double getAngleFromHybridization(int hybr) {
        if (hybr == 2) {
            return Math.PI;
        }
        if (hybr == 3) {
            return 2.0943951023931953;
        }
        if (hybr == 4) {
            return 1.9106119;
        }
        if (dodebug) {
            debug.println("Oh my God, I don't know the hybridization");
        }
        return 0.0;
    }

    double calcDist2(int i1, int i2, int d, double[] x) {
        double s = 0.0;
        for (int i = 0; i < d; ++i) {
            double x1 = x[i1 * d + i];
            double x2 = x[i2 * d + i];
            s += (x1 - x2) * (x1 - x2) * this.csMetric[i];
        }
        return s;
    }

    void addGrad(double[] g, int i1, int i2, double[] x, double deriv, int d) {
        double[] x1 = new double[d];
        double[] x2 = new double[d];
        for (int i = 0; i < d; ++i) {
            x1[i] = x[i1 * d + i];
            x2[i] = x[i2 * d + i];
        }
        double[] dx = Opt3D.minus(x1, x2);
        Opt3D.normalizeWithMetric(dx, this.csMetric);
        for (int i = 0; i < d; ++i) {
            int n = i1 * d + i;
            g[n] = g[n] + dx[i] * deriv * this.csMetric[i];
        }
    }

    static void normalizeWithMetric(double[] v, double[] metric) {
        int i;
        double l = 0.0;
        for (i = 0; i < v.length; ++i) {
            l += v[i] * v[i] * metric[i];
        }
        l = Math.sqrt(Math.abs(l));
        for (i = 0; i < v.length; ++i) {
            v[i] = v[i] / l;
        }
    }

    static void normalize(double[] v) {
        int i;
        double l = 0.0;
        for (i = 0; i < v.length; ++i) {
            l += v[i] * v[i];
        }
        l = Math.sqrt(l);
        for (i = 0; i < v.length; ++i) {
            v[i] = v[i] / l;
        }
    }

    static double metricLength(double[] v, double[] metric) {
        double l = 0.0;
        for (int i = 0; i < v.length; ++i) {
            l += v[i] * v[i] * metric[i];
        }
        l = Math.sqrt(Math.abs(l));
        return l;
    }

    public static double[] minus(double[] a, double[] b) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] - b[i];
        }
        return result;
    }

    public static double[] minus(double[] a, double[] b, int ia, int ib, int d) {
        double[] result = new double[d];
        for (int i = 0; i < d; ++i) {
            result[i] = a[ia * d + i] - b[ib * d + i];
        }
        return result;
    }

    public static void norma(double[] a) {
        double dot = 0.0;
        for (int i = 0; i < a.length; ++i) {
            dot += a[i] * a[i];
        }
        double len_a = Math.sqrt(dot);
        double sc = 0.0;
        if (len_a > 0.0) {
            sc = 1.0 / len_a;
        }
        int i = 0;
        while (i < a.length) {
            int n = i++;
            a[n] = a[n] * sc;
        }
    }

    boolean checkHighDimension(double[] x, double eps) {
        for (int i = 0; i < this.m.getAtomCount(); ++i) {
            for (int j = this.reducedDimension; j < this.dimension; ++j) {
                if (!(Math.abs(x[i * this.dimension + j]) > eps)) continue;
                return true;
            }
        }
        return false;
    }

    void rearrangeDim(double[] coords, double[] metric, int d, int redD, int nc) {
        int i;
        if (dodebug) {
            debug.println(nc + " atom " + coords.length / d);
        }
        double[] subdimSum = new double[d];
        for (i = 0; i < d; ++i) {
            if (!(metric[i] > 0.0)) continue;
            double sum = 0.0;
            for (int j = 0; j < nc; ++j) {
                sum += Math.abs(coords[j * d + i]);
            }
            subdimSum[i] = sum;
        }
        for (i = 0; i < 3; ++i) {
            int maxDim = -1;
            double maxsum = -1.0;
            for (int j = 0; j < d; ++j) {
                if (!(maxsum < subdimSum[j])) continue;
                maxDim = j;
                maxsum = subdimSum[j];
            }
            for (int j = 0; j < nc; ++j) {
                double tmp = coords[j * d + i];
                coords[j * d + i] = coords[j * d + maxDim];
                coords[j * d + maxDim] = tmp;
            }
            double tmp = metric[i];
            metric[i] = metric[maxDim];
            metric[maxDim] = tmp;
            subdimSum[maxDim] = subdimSum[i];
            subdimSum[i] = 0.0;
        }
    }

    static void verlet(double[] xt_m, double[] xt, double[] xt_p, double[] a, double dt, int n, int d) {
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < d; ++j) {
                xt_p[i * d + j] = 2.0 * xt[i * d + j] - xt_m[i * d + j] - a[i * d + j] * dt * dt;
            }
        }
    }

    void dynamics(double[] xt, int Dynamic_steps, double dt) {
        int d = this.dimension;
        int n = xt.length;
        double[] xt_m = new double[n];
        double[] xt_p = new double[n];
        double[] a = new double[n];
        System.arraycopy(xt, 0, xt_m, 0, n);
        for (int i = 0; i < Dynamic_steps; ++i) {
            a = this.df(xt);
            Opt3D.verlet(xt_m, xt, xt_p, a, dt, n / d, d);
            System.arraycopy(xt, 0, xt_m, 0, n);
            System.arraycopy(xt_p, 0, xt, 0, n);
            Opt3D.setCoordinates(this.m, xt);
        }
    }

    double[][] Verlet_MD(double[] coordinates, int steps) {
        this.dynamics(coordinates, steps, 0.1);
        int d = this.dimension;
        double[][] coords = new double[this.m.getAtomCount()][3];
        for (int i = 0; i < this.m.getAtomCount(); ++i) {
            for (int j = 0; j < 3; ++j) {
                coords[i][j] = coordinates[i * d + j];
            }
        }
        return coords;
    }

    static void setCoordinates(SelectionMolecule m, double[] x) {
        int mn = m.getAtomCount();
        int dim = 3;
        for (int i = 0; i < mn; ++i) {
            MolAtom a = m.getAtom(i);
            a.setXYZ(x[i * dim], x[i * dim + 1], x[i * dim + 2]);
        }
    }

    public static double Mathacos(double x) {
        x = Math.max(-1.0, Math.min(1.0, x));
        return Math.acos(x);
    }

    public static class DreidingParms {
        public static int MaxAtomType = 57;
        public static int a_H__ = 0;
        public static int a_H_HB = 1;
        public static int a_H__b = 2;
        public static int a_B_3 = 3;
        public static int a_B_2 = 4;
        public static int a_C_3 = 5;
        public static int a_C_R = 6;
        public static int a_C_2 = 7;
        public static int a_C_1 = 8;
        public static int a_N_3 = 9;
        public static int a_N_R = 10;
        public static int a_N_2 = 11;
        public static int a_N_1 = 12;
        public static int a_O_3 = 13;
        public static int a_O_R = 14;
        public static int a_O_2 = 15;
        public static int a_O_1 = 16;
        public static int a_F__ = 17;
        public static int a_Al3 = 18;
        public static int a_Si3 = 19;
        public static int a_P_3 = 20;
        public static int a_S_3 = 21;
        public static int a_Cl_ = 22;
        public static int a_Ga3 = 23;
        public static int a_Ge3 = 24;
        public static int a_As3 = 25;
        public static int a_Se3 = 26;
        public static int a_Br_ = 27;
        public static int a_In3 = 28;
        public static int a_Sn3 = 29;
        public static int a_Sb3 = 30;
        public static int a_Te3 = 31;
        public static int a_I__ = 32;
        public static int a_Na_ = 33;
        public static int a_Ca_ = 34;
        public static int a_Fe_ = 35;
        public static int a_Zn_ = 36;
        public static int a_C_R1 = 37;
        public static int a_C_34 = 38;
        public static int a_C_33 = 39;
        public static int a_C_32 = 40;
        public static int a_C_31 = 41;
        public static int a_Li__ = 42;
        public static int a_default = 43;
        public static int a_S_non = 44;
        public static int a_Al_non = 45;
        public static int a_Si_non = 46;
        public static int a_Ga_non = 47;
        public static int a_Ge_non = 48;
        public static int a_As_non = 49;
        public static int a_Se_non = 50;
        public static int a_In_non = 51;
        public static int a_Sn_non = 52;
        public static int a_Sb_non = 53;
        public static int a_Te_non = 54;
        public static int a_Fe_non = 55;
        public static int a_Zn_non = 56;
        public static int a_P_non = 57;
        public static String[] Type = new String[]{"H__", "H_HB", "H__b", "B_3", "B_2", "C_3", "C_R", "C_2", "C_1", "N_3", "N_R", "N_2", "N_1", "O_3", "O_R", "O_2", "O_1", "F__", "Al3", "Si3", "P_3", "S_3", "Cl_", "Ga3", "Ge3", "As3", "Se3", "Br_", "In3", "Sn3", "Sb3", "Te3", "I__", "Na_", "Ca_", "Fe_", "Zn_", "C_R1", "C_34", "C_33", "C_32", "C_31", "Li__", "default", "S_non", "a_Al_non", "a_Si_non", "a_Ga_non", "a_Ge_non", "a_As_non", "a_Se_non", "a_In_non", "a_Sn_non", "a_Sb_non", "a_Te_non", "a_Fe_non", "a_Zn_non", "a_P_non"};
        public static int[] Hybr = new int[]{1, 1, 1, 3, 2, 3, 2, 2, 1, 3, 2, 2, 1, 3, 2, 2, 1, 1, 3, 3, 3, 3, 1, 3, 3, 3, 3, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 2, 3, 3, 3, 3, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};
        public static boolean[] Ocol = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, false, false, false, false, true, false, false, false, false, true, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, true, false, false, false, true, false, false, false};
        public static double[] BondRadius = new double[]{0.33, 0.33, 0.51, 0.88, 0.79, 0.77, 0.7, 0.67, 0.602, 0.702, 0.65, 0.615, 0.556, 0.66, 0.66, 0.56, 0.528, 0.611, 1.047, 0.937, 0.89, 1.04, 0.997, 1.21, 1.21, 1.21, 1.21, 1.167, 1.39, 1.373, 1.432, 1.28, 1.36, 1.86, 1.94, 1.285, 1.33, 0.7, 0.77, 0.77, 0.77, 0.77, 1.1, 1.5, 1.04, 1.047, 0.937, 1.21, 1.21, 1.21, 1.21, 1.39, 1.373, 1.432, 1.28, 1.285, 1.33, 0.89};
        public static double[] CosAngle = new double[]{-1.0, -1.0, 0.0, -0.333329702763402, -0.5, -0.333329702763402, -0.5, -0.5, -1.0, -0.287360519849712, -0.5, -0.5, -1.0, -0.250548973879778, -0.5, -0.5, -1.0, -1.0, -0.333329702763402, -0.333329702763402, -0.0575640269595672, -0.0366437087065559, -1.0, -0.333329702763402, -0.333329702763402, -0.0366437087065559, -0.0104717841162455, -1.0, -0.333329702763402, -0.333329702763402, -0.0279216387235686, -0.00523596383141964, -1.0, 0.0, 0.0, 0.0, -0.333329702763402, -0.5, -0.333329702763402, -0.333329702763402, -0.333329702763402, -0.333329702763402, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0};
        public static double[] AngleInRadian = new double[]{3.14159265, 3.14159265, 1.57079633, 1.91062939, 2.0943951, 1.91062939, 2.0943951, 2.0943951, 3.14159265, 1.86226631, 2.0943951, 2.0943951, 3.14159265, 1.8240436, 2.0943951, 2.0943951, 3.14159265, 3.14159265, 1.91062939, 1.91062939, 1.62839219, 1.60744824, 3.14159265, 1.91062939, 1.91062939, 1.60744824, 1.5812683, 3.14159265, 1.91062939, 1.91062939, 1.59872159, 1.57603231, 3.14159265, 1.57079633, 1.57079633, 1.57079633, 1.91062939, 2.0943951, 1.91062939, 1.91062939, 1.91062939, 1.91062939, 3.14159265, 3.14159265, 3.14159265, 3.14159265, 3.14159265, 3.14159265, 3.14159265, 3.14159265, 3.14159265, 3.14159265, 3.14159265, 3.14159265, 3.14159265, 3.14159265, 3.14159265, 3.14159265};
        public static double[] Angle = new double[]{180.0, 180.0, 90.0, 109.471, 120.0, 109.471, 120.0, 120.0, 180.0, 106.7, 120.0, 120.0, 180.0, 104.51, 120.0, 120.0, 180.0, 180.0, 109.471, 109.471, 93.3, 92.1, 180.0, 109.471, 109.471, 92.1, 90.6, 180.0, 109.471, 109.471, 91.6, 90.3, 180.0, 90.0, 90.0, 90.0, 109.471, 120.0, 109.471, 109.471, 109.471, 109.471, 180.0, 180.0, 180.0, 180.0, 180.0, 180.0, 180.0, 180.0, 180.0, 180.0, 180.0, 180.0, 180.0, 180.0, 180.0, 180.0};
        public static double[] vdWR0 = new double[]{3.195, 3.195, 3.195, 4.02, 4.02, 3.8983, 3.8983, 3.8983, 3.8983, 3.6621, 3.6621, 3.6621, 3.6621, 3.4046, 3.4046, 3.4046, 3.4046, 3.472, 4.39, 4.27, 4.15, 4.03, 3.9503, 4.39, 4.27, 4.15, 4.03, 3.95, 4.59, 4.47, 4.35, 4.23, 4.15, 3.144, 3.472, 4.54, 4.54, 4.23, 4.237, 4.1524, 4.0677, 3.983, 3.195, 4.0, 4.03, 4.39, 4.27, 4.39, 4.27, 4.15, 4.03, 4.59, 4.47, 4.35, 4.23, 4.54, 4.54, 4.15};
        public static double[] vdWKhi0 = new double[]{12.382, 12.0, 12.382, 14.23, 14.23, 14.034, 14.034, 14.034, 14.034, 13.843, 13.843, 13.843, 13.843, 13.483, 13.483, 13.483, 13.483, 14.444, 12.0, 12.0, 12.0, 12.0, 13.861, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 14.034, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0};
        public static double[] vdWD0 = new double[]{0.0152, 1.0E-4, 0.0152, 0.095, 0.095, 0.0951, 0.0951, 0.0951, 0.0951, 0.0774, 0.0774, 0.0774, 0.0774, 0.0957, 0.0957, 0.0957, 0.0957, 0.0725, 0.31, 0.31, 0.32, 0.344, 0.2833, 0.4, 0.4, 0.41, 0.43, 0.37, 0.55, 0.55, 0.55, 0.57, 0.51, 0.5, 0.05, 0.055, 0.055, 0.1356, 0.3016, 0.25, 0.1984, 0.1984, 0.0152, 0.055, 0.344, 0.31, 0.31, 0.4, 0.4, 0.41, 0.43, 0.55, 0.55, 0.55, 0.57, 0.055, 0.055, 0.32};
        public static double Tors33V = 2.0;
        public static int Tors33N = 3;
        public static double Tors33Psi = 180.0;
        public static double Tors33Psi_rad = Math.PI;
        public static double Tors23V = 1.0;
        public static int Tors23N = 6;
        public static double Tors23Psi = 0.0;
        public static double Tors23Psi_rad = 0.0;
        public static double Tors22V = 45.0;
        public static int Tors22N = 2;
        public static double Tors22Psi = 180.0;
        public static double Tors22Psi_rad = Math.PI;
        public static double Tors22resV = 25.0;
        public static int Tors22resN = 2;
        public static double Tors22resPsi = 180.0;
        public static double Tors22resPsi_rad = Math.PI;
        public static double Tors22sinV = 5.0;
        public static int Tors22sinN = 2;
        public static double Tors22sinPsi = 180.0;
        public static double Tors22sinPsi_rad = Math.PI;
        public static double Tors22sinArV = 10.0;
        public static int Tors22sinArN = 2;
        public static double Tors22sinArPsi = 180.0;
        public static double Tors22sinArPsi_rad = Math.PI;
        public static double Tors11V = 0.0;
        public static int Tors11N = 0;
        public static double Tors11Psi = 0.0;
        public static double Tors11Psi_rad = 0.0;
        public static double Tors3O3OV = 2.0;
        public static int Tors3O3ON = 2;
        public static double Tors3O3OPsi = 90.0;
        public static double Tors3O3OPsi_rad = 1.5707963267948966;
        public static double Tors3O2V = 2.0;
        public static int Tors3O2N = 2;
        public static double Tors3O2Psi = 180.0;
        public static double Tors3O2Psi_rad = Math.PI;
        public static double Tors332V = 1.0;
        public static int Tors332N = 3;
        public static double Tors332Psi = 180.0;
        public static double Tors332Psi_rad = Math.PI;
        public static double defaultscale = 0.3;
        public static double defaultAngleScale = 0.1;
        public static double bond_delta = 0.01;
        public static double bond_K = 700.0;
        public static double bond_D = 70.0;
        public static double angle_K = 100.0;
        public static double invK = 40.0;
        public static double invPsi0 = 0.0;
        public static double invC = 59.9935;
        public static double invCPsi0 = 54.74;
        public static double invCcosPsi0 = 0.5772877;
        public static double HydDhb = 9.5;
        public static double HydRhb = 2.75;

        public static int NeighAt(int[] Neighbours, int[] Anum, int a) {
            int b = 0;
            int n = Neighbours.length;
            for (int j = 0; j < n; ++j) {
                if (Anum[Neighbours[j]] != a) continue;
                ++b;
            }
            return b;
        }

        public static int GetHybr(int[] Border2) {
            if (Border2.length == 2 && Border2[0] == 4 && Border2[1] == 4) {
                return 1;
            }
            int b = 3;
            int n = Border2.length;
            for (int j = 0; j < n; ++j) {
                if (Border2[j] == 6) {
                    b = 1;
                    return b;
                }
                if (Border2[j] == 4) {
                    b = 2;
                    return b;
                }
                if (Border2[j] != 3) continue;
                b = 4;
                return b;
            }
            return b;
        }

        public static int setAtTyp(int at1, int at2, int n, int lignum) {
            if (n >= lignum) {
                return at2;
            }
            return at1;
        }

        public static int GetType(int[] Anum, int[][] Ctab, int[][] Bolist, int j) {
            int DreidingType = a_default;
            int AtomicNumber = Anum[j];
            int[] Neighbours = Ctab[j];
            int[] Border2 = Bolist[j];
            switch (AtomicNumber) {
                case 1: {
                    DreidingType = a_H__;
                    if (DreidingParms.NeighAt(Neighbours, Anum, 5) == 2) {
                        DreidingType = a_H__b;
                    }
                    if (DreidingParms.NeighAt(Neighbours, Anum, 7) == 1) {
                        DreidingType = a_H_HB;
                    }
                    if (DreidingParms.NeighAt(Neighbours, Anum, 8) == 1) {
                        DreidingType = a_H_HB;
                    }
                    if (DreidingParms.NeighAt(Neighbours, Anum, 9) == 1) {
                        DreidingType = a_H_HB;
                    }
                    if (DreidingParms.NeighAt(Neighbours, Anum, 16) == 1) {
                        DreidingType = a_H_HB;
                    }
                    if (DreidingParms.NeighAt(Neighbours, Anum, 17) != 1) break;
                    DreidingType = a_H_HB;
                    break;
                }
                case 3: {
                    DreidingType = a_Li__;
                    break;
                }
                case 5: {
                    if (DreidingParms.GetHybr(Border2) == 3) {
                        DreidingType = a_B_3;
                    }
                    if (DreidingParms.GetHybr(Border2) == 2) {
                        DreidingType = a_B_2;
                    }
                    if (DreidingParms.GetHybr(Border2) != 4) break;
                    DreidingType = a_B_2;
                    break;
                }
                case 6: {
                    DreidingType = a_C_3;
                    if (DreidingParms.GetHybr(Border2) == 3) {
                        if (Neighbours.length == 4) {
                            DreidingType = a_C_3;
                        }
                        if (Neighbours.length == 3) {
                            DreidingType = a_C_31;
                        }
                        if (Neighbours.length == 2) {
                            DreidingType = a_C_32;
                        }
                        if (Neighbours.length == 1) {
                            DreidingType = a_C_33;
                        }
                        if (Neighbours.length == 0) {
                            DreidingType = a_C_34;
                        }
                    }
                    if (DreidingParms.GetHybr(Border2) == 2) {
                        DreidingType = a_C_2;
                    }
                    if (DreidingParms.GetHybr(Border2) == 4) {
                        DreidingType = a_C_R;
                        if (Neighbours.length == 2) {
                            DreidingType = a_C_R1;
                        }
                    }
                    if (DreidingParms.GetHybr(Border2) != 1) break;
                    DreidingType = a_C_1;
                    break;
                }
                case 7: {
                    if (DreidingParms.GetHybr(Border2) == 3) {
                        DreidingType = a_N_3;
                        if (Neighbours.length < 4) {
                            for (int jj = 0; jj < Neighbours.length; ++jj) {
                                if (DreidingParms.GetHybr(Bolist[Neighbours[jj]]) == 2) {
                                    DreidingType = a_N_2;
                                }
                                if (DreidingParms.GetHybr(Bolist[Neighbours[jj]]) != 4) continue;
                                DreidingType = a_N_2;
                            }
                        }
                    }
                    if (DreidingParms.GetHybr(Border2) == 2) {
                        DreidingType = a_N_2;
                    }
                    if (DreidingParms.GetHybr(Border2) == 4) {
                        DreidingType = a_N_R;
                    }
                    if (DreidingParms.GetHybr(Border2) != 1) break;
                    DreidingType = a_N_1;
                    break;
                }
                case 8: {
                    if (DreidingParms.GetHybr(Border2) == 3) {
                        DreidingType = a_O_3;
                        if (Neighbours.length < 3) {
                            for (int jj = 0; jj < Neighbours.length; ++jj) {
                                if (DreidingParms.GetHybr(Bolist[Neighbours[jj]]) == 2) {
                                    DreidingType = a_O_2;
                                }
                                if (DreidingParms.GetHybr(Bolist[Neighbours[jj]]) != 4) continue;
                                DreidingType = a_O_2;
                            }
                        }
                    }
                    if (DreidingParms.GetHybr(Border2) == 2) {
                        DreidingType = a_O_2;
                    }
                    if (DreidingParms.GetHybr(Border2) == 4) {
                        DreidingType = a_O_R;
                    }
                    if (DreidingParms.GetHybr(Border2) != 1) break;
                    DreidingType = a_O_1;
                    break;
                }
                case 9: {
                    DreidingType = a_F__;
                    break;
                }
                case 13: {
                    DreidingType = DreidingParms.setAtTyp(a_Al3, a_Al_non, Neighbours.length, 5);
                    break;
                }
                case 14: {
                    DreidingType = DreidingParms.setAtTyp(a_Si3, a_Si_non, Neighbours.length, 5);
                    break;
                }
                case 15: {
                    DreidingType = DreidingParms.setAtTyp(a_P_3, a_P_non, Neighbours.length, 5);
                    break;
                }
                case 16: {
                    DreidingType = DreidingParms.setAtTyp(a_S_3, a_S_non, Neighbours.length, 5);
                    break;
                }
                case 17: {
                    DreidingType = a_Cl_;
                    break;
                }
                case 31: {
                    DreidingType = DreidingParms.setAtTyp(a_Ga3, a_Ga_non, Neighbours.length, 5);
                    break;
                }
                case 32: {
                    DreidingType = DreidingParms.setAtTyp(a_Ge3, a_Ge_non, Neighbours.length, 5);
                    break;
                }
                case 33: {
                    DreidingType = DreidingParms.setAtTyp(a_As3, a_As_non, Neighbours.length, 5);
                    break;
                }
                case 34: {
                    DreidingType = DreidingParms.setAtTyp(a_Se3, a_Se_non, Neighbours.length, 5);
                    break;
                }
                case 35: {
                    DreidingType = a_Br_;
                    break;
                }
                case 49: {
                    DreidingType = DreidingParms.setAtTyp(a_In3, a_In_non, Neighbours.length, 5);
                    break;
                }
                case 50: {
                    DreidingType = DreidingParms.setAtTyp(a_Sn3, a_Sn_non, Neighbours.length, 4);
                    break;
                }
                case 51: {
                    DreidingType = DreidingParms.setAtTyp(a_Sb3, a_Sb_non, Neighbours.length, 4);
                    break;
                }
                case 52: {
                    DreidingType = DreidingParms.setAtTyp(a_Te3, a_Te_non, Neighbours.length, 4);
                    break;
                }
                case 53: {
                    DreidingType = a_I__;
                    break;
                }
                case 11: {
                    DreidingType = a_Na_;
                    break;
                }
                case 20: {
                    DreidingType = a_Ca_;
                    break;
                }
                case 26: {
                    DreidingType = DreidingParms.setAtTyp(a_Fe_, a_Fe_non, Neighbours.length, 4);
                    break;
                }
                case 30: {
                    DreidingType = DreidingParms.setAtTyp(a_Zn_, a_Zn_non, Neighbours.length, 4);
                }
            }
            return DreidingType;
        }

        public static int[] GetTypes(int[] Anum, int[][] Ctab, int[][] Bolist) {
            int n = Anum.length;
            int[] AtomTypes = new int[n];
            for (int j = 0; j < n; ++j) {
                AtomTypes[j] = DreidingParms.GetType(Anum, Ctab, Bolist, j);
            }
            return AtomTypes;
        }

        public static void PrintParams() {
            DecimalFormat myFormatter = new DecimalFormat("000.000");
            DecimalFormat myFormatter2 = new DecimalFormat("0.000");
            System.out.println("  No   |Type| Bond | Angle |vdWr0|vdwD0|");
            System.out.println("------------------------------------------------");
            for (int i = 0; i < MaxAtomType; ++i) {
                System.out.println(DreidingParms.clip0(myFormatter.format((double)i)) + "|" + Type[i] + (Type[i].length() == 3 ? " |" : "|") + DreidingParms.clip0(myFormatter2.format(BondRadius[i])) + (DreidingParms.clip0(myFormatter2.format(BondRadius[i])).length() == 5 ? " |" : "|") + DreidingParms.clip0(myFormatter2.format(Angle[i])) + (DreidingParms.clip0(myFormatter2.format(Angle[i])).length() == 6 ? " |" : "|") + DreidingParms.clip0(myFormatter2.format(vdWR0[i])) + (DreidingParms.clip0(myFormatter2.format(vdWR0[i])).length() == 6 ? " |" : "|") + DreidingParms.clip0(myFormatter2.format(vdWD0[i])) + "| ");
            }
        }

        public static String clip0(String s) {
            if (s.length() > 0) {
                char[] c = s.toCharArray();
                boolean flag = true;
                int i = 0;
                while (flag) {
                    if (i >= c.length) {
                        flag = false;
                        continue;
                    }
                    if (c[i] == '0') {
                        if (i < c.length - 1 && c[i + 1] != '.') {
                            c[i] = 32;
                        }
                    } else {
                        flag = false;
                    }
                    ++i;
                }
                boolean hasdot = false;
                for (i = 0; i < c.length && !hasdot; hasdot |= c[i] == '.', ++i) {
                }
                if (hasdot) {
                    i = c.length - 1;
                    flag = true;
                    while (flag) {
                        if (i <= 0) {
                            flag = false;
                        } else if (c[i] == '0') {
                            c[i] = 32;
                        } else {
                            if (c[i] == '.') {
                                c[i] = 32;
                            }
                            flag = false;
                        }
                        --i;
                    }
                }
                return String.valueOf(c);
            }
            return s;
        }
    }

    public static class Dreiding {
        MolCT mol = null;
        int[] intAtoms = null;
        int[] Types = null;
        int[][] cTab = null;
        int[] bAtom1 = null;
        int[] bAtom2 = null;
        int[] bondOrders = null;
        int[][] bOList = null;
        int[][] BList = null;
        int[] Anum = null;
        double[][] intAtomCoords = null;
        double[][] AllBonds = null;
        double[][] AllNormalizedBonds = null;
        double[][] tmp = null;
        double[][] tmp4D = null;
        double[] Etmp = null;
        double tol = 1.0E-6;
        int alltmp = 10;
        int lasttmp;
        double[][] Deriv = null;
        boolean useCosAngleTermForBendEnergy = false;
        boolean useExpTermForVanDerWaalsEnergy = false;
        boolean derivatesRequested = false;
        boolean disableHBond = false;
        debugPrintout debug = null;
        BitSet[] notNeighborCache = null;
        boolean corrupted = false;

        public double[][] getDeriv() {
            return this.Deriv;
        }

        public int[] getTypes() {
            return this.Types;
        }

        public int[][] getCTab() {
            return this.cTab;
        }

        public int[] getBAtom1() {
            return this.bAtom1;
        }

        public int[] getBAtom2() {
            return this.bAtom2;
        }

        public int[][] getBList() {
            return this.BList;
        }

        public int[][] getBOList() {
            return this.bOList;
        }

        public int[] getBondOrders() {
            return this.bondOrders;
        }

        public int[] getAnum() {
            return this.Anum;
        }

        public MolCT getMol() {
            return this.mol;
        }

        public Molecule getTopologyMol(boolean fromctab) {
            Molecule ret;
            if (fromctab) {
                int atct = this.cTab.length;
                ret = new Molecule();
                int i = 0;
                while (i < atct) {
                    MolAtom a = new MolAtom(this.Anum[i]);
                    this.intAtoms[0] = i++;
                    this.mol.askLocalCoordinates(1);
                    a.setXYZ(this.intAtomCoords[0][0], this.intAtomCoords[0][1], this.intAtomCoords[0][2]);
                    ret.add(a);
                }
                for (i = 0; i < this.bAtom1.length; ++i) {
                    MolBond b = new MolBond(ret.getAtom(this.bAtom1[i]), ret.getAtom(this.bAtom2[i]));
                    ret.add(b);
                }
            } else {
                ret = myMolecule.constructMolecule(this.getMol());
            }
            return ret;
        }

        public Dreiding(MolCT molFrag, debugPrintout debugClass) {
            this.debug = debugClass;
            boolean bl = dodebug = this.debug != null && this.debug.getWillPrint();
            if (dodebug) {
                this.debug.println("Dreiding initialization.");
            }
            this.mol = molFrag;
            this.cTab = this.mol.getCtab();
            this.bAtom1 = this.mol.getBAtom1();
            this.bAtom2 = this.mol.getBAtom2();
            this.bondOrders = this.mol.getBondOrders();
            this.bOList = this.mol.getBOlist();
            this.BList = this.mol.getBList();
            this.Anum = this.mol.getAtomNumbers();
            this.intAtoms = this.mol.getAtomNumberScratch();
            this.intAtomCoords = this.mol.getAtomLocalCoordinateScratch();
            this.AllBonds = new double[this.bAtom1.length][4];
            this.AllNormalizedBonds = new double[this.bAtom1.length][3];
            this.tmp = new double[this.alltmp][3];
            this.tmp4D = new double[this.alltmp][4];
            this.Etmp = new double[2];
            this.Deriv = new double[this.Anum.length][3];
            this.Types = DreidingParms.GetTypes(this.Anum, this.cTab, this.bOList);
            if (dodebug) {
                this.debug.println("Atomic numbers ");
                this.debug.Tstart();
                this.debug.Trow();
                this.debug.TprintBC("#");
                this.debug.TprintBC("anum");
                this.debug.TprintBC("Type");
                this.debug.TprintBC("Types");
                this.debug.TprintBC("Hybr");
                for (int jj = 0; jj < this.Anum.length; ++jj) {
                    this.debug.Trow();
                    this.debug.TprintBC("" + jj);
                    this.debug.Tprint("" + this.Anum[jj]);
                    this.debug.Tprint("" + DreidingParms.Type[this.Types[jj]]);
                    this.debug.Tprint("" + this.Types[jj]);
                    this.debug.Tprint("" + DreidingParms.Hybr[this.Types[jj]]);
                }
                this.debug.Tstop();
            }
        }

        public void getCoords(int i, int j, int k, int l, int nAtoms) {
            this.intAtoms[0] = i;
            this.intAtoms[1] = j;
            this.intAtoms[2] = k;
            this.intAtoms[3] = l;
            this.mol.askLocalCoordinates(nAtoms);
        }

        public void getCoords(int i, int j, int k, int l) {
            this.getCoords(i, j, k, l, 4);
        }

        public void getCoords(int i, int j, int k) {
            this.getCoords(i, j, k, 0, 3);
        }

        public void getCoords(int i, int j) {
            this.getCoords(i, j, 0, 0, 2);
        }

        public double getDesiredBondLength(int a1, int a2) {
            return DreidingEqn.Bond(this.Types[a1], this.Types[a2]);
        }

        public static void mul(double[] v, double s, double[] result) {
            int l = 3;
            for (int i = 0; i < l; ++i) {
                result[i] = v[i] * s;
            }
        }

        public static void add(double[] v1, double[] v2, double[] result) {
            int l = 3;
            for (int i = 0; i < l; ++i) {
                result[i] = v1[i] + v2[i];
            }
        }

        public void getBondLength(int atom1, int atom2, double[] d) {
            this.getCoords(atom1, atom2);
            d[0] = this.intAtomCoords[0][0] - this.intAtomCoords[1][0];
            d[1] = this.intAtomCoords[0][1] - this.intAtomCoords[1][1];
            d[2] = this.intAtomCoords[0][2] - this.intAtomCoords[1][2];
            d[3] = Math.sqrt(d[0] * d[0] + d[1] * d[1] + d[2] * d[2]);
        }

        public static double getScalar(double[] d1, double[] d2) {
            return d1[0] * d2[0] + d1[1] * d2[1] + d1[2] * d2[2];
        }

        public static void getVector(double[] d1, double[] d2, double[] result) {
            result[0] = d1[1] * d2[2] - d1[2] * d2[1];
            result[1] = d1[2] * d2[0] - d1[0] * d2[2];
            result[2] = d1[0] * d2[1] - d1[1] * d2[0];
        }

        public static void Normalize(double[] v, double[] result) {
            int l = v.length;
            double norm = 0.0;
            for (int i = 0; i < l; ++i) {
                norm += v[i] * v[i];
            }
            norm = 1.0 / Math.sqrt(norm);
            Dreiding.mul(v, norm, result);
        }

        public void CpVec(double[] from, double[] to) {
            for (int i = 0; i < from.length; ++i) {
                to[i] = from[i];
            }
        }

        public boolean ifTransitionMetal(int atom) {
            int a = this.Anum[atom];
            if (a >= 21 && a <= 30) {
                return true;
            }
            if (a >= 39 && a <= 48) {
                return true;
            }
            if (a >= 71 && a <= 80) {
                return true;
            }
            if (a >= 103 && a <= 112) {
                return true;
            }
            if (a >= 57 && a <= 70) {
                return true;
            }
            return a >= 89 && a <= 102;
        }

        public double getCosAngle(int i, int j, boolean inv1, boolean inv2) {
            this.CpVec(this.AllNormalizedBonds[i], this.tmp[0]);
            this.CpVec(this.AllNormalizedBonds[j], this.tmp[1]);
            if (inv1) {
                Dreiding.mul(this.tmp[0], -1.0, this.tmp[0]);
            }
            if (inv2) {
                Dreiding.mul(this.tmp[1], -1.0, this.tmp[1]);
            }
            return Dreiding.getScalar(this.tmp[0], this.tmp[1]);
        }

        public double getCosAngle(int i, int j, int k) {
            this.getBondLength(i, j, this.tmp4D[0]);
            this.getBondLength(k, j, this.tmp4D[1]);
            return Dreiding.getScalar(this.tmp4D[0], this.tmp4D[1]) / (this.tmp4D[0][3] * this.tmp4D[1][3]);
        }

        public double getDihed(int i, int j, int k, boolean inv1, boolean inv2, boolean inv3) {
            double[] v1 = new double[3];
            double[] v2 = new double[3];
            this.CpVec(this.AllNormalizedBonds[i], this.tmp[0]);
            this.CpVec(this.AllNormalizedBonds[j], this.tmp[1]);
            this.CpVec(this.AllNormalizedBonds[k], this.tmp[2]);
            if (inv1) {
                Dreiding.mul(this.tmp[0], -1.0, this.tmp[0]);
            }
            if (inv2) {
                Dreiding.mul(this.tmp[1], -1.0, this.tmp[1]);
            }
            if (inv3) {
                Dreiding.mul(this.tmp[2], -1.0, this.tmp[2]);
            }
            double cos1 = Dreiding.getScalar(this.tmp[0], this.tmp[1]);
            double cos2 = -1.0 * Dreiding.getScalar(this.tmp[2], this.tmp[1]);
            double sin1 = Math.sqrt(1.0 - cos1 * cos1);
            double sin2 = Math.sqrt(1.0 - cos2 * cos2);
            Dreiding.getVector(this.tmp[0], this.tmp[1], v1);
            Dreiding.getVector(this.tmp[2], this.tmp[1], v1);
            double coscos = Dreiding.getScalar(v1, v2) / (sin1 * sin2);
            coscos = Math.min(1.0, Math.max(-1.0, coscos));
            double delta = Math.acos(coscos);
            if (dodebug) {
                this.debug.println("bi,bj,bk " + i + " " + j + " " + k + "  " + "TORSION:" + Math.toDegrees(delta));
            }
            return delta;
        }

        public double getInversionAngle(int iu, int iv, int iw, int Type2) {
            double Cos_uv;
            double SinSq_uv;
            double Sin_uv;
            double[] E = this.Etmp;
            this.lasttmp = 0;
            double[] u = this.tmp[this.lasttmp];
            ++this.lasttmp;
            double[] v = this.tmp[this.lasttmp];
            ++this.lasttmp;
            double[] w = this.tmp[this.lasttmp];
            this.CpVec(this.AllNormalizedBonds[iu], u);
            this.CpVec(this.AllNormalizedBonds[iv], v);
            this.CpVec(this.AllNormalizedBonds[iw], w);
            int o = 0;
            int n = 0;
            int p = 0;
            int m = 0;
            if (this.bAtom1[iu] == this.bAtom1[iv]) {
                Dreiding.mul(u, -1.0, u);
                Dreiding.mul(v, -1.0, v);
                o = this.bAtom1[iu];
                p = this.bAtom2[iv];
                m = this.bAtom2[iu];
            }
            if (this.bAtom1[iu] == this.bAtom2[iv]) {
                Dreiding.mul(u, -1.0, u);
                o = this.bAtom1[iu];
                p = this.bAtom1[iv];
                m = this.bAtom2[iu];
            }
            if (this.bAtom2[iu] == this.bAtom1[iv]) {
                Dreiding.mul(v, -1.0, v);
                o = this.bAtom2[iu];
                p = this.bAtom2[iv];
                m = this.bAtom1[iu];
            }
            if (this.bAtom2[iu] == this.bAtom2[iv]) {
                o = this.bAtom2[iu];
                p = this.bAtom1[iv];
                m = this.bAtom1[iu];
            }
            if (this.bAtom2[iw] == o) {
                n = this.bAtom1[iw];
            }
            if (this.bAtom1[iw] == o) {
                Dreiding.mul(w, -1.0, w);
                n = this.bAtom2[iw];
            }
            if (dodebug) {
                this.debug.println("u: " + o + " ->" + m);
                this.debug.println("w: " + o + " ->" + n);
                this.debug.println("v: " + o + " ->" + p);
                this.debug.println("Atom numbers  : " + m + ", " + o + ", " + p + ", " + n);
                this.debug.println("Bond numbers  : " + iu + " " + iw + " " + iv);
            }
            if (this.ifzero(Sin_uv = Math.sqrt(SinSq_uv = 1.0 - (Cos_uv = Dreiding.getScalar(u, v)) * Cos_uv))) {
                return 0.0;
            }
            ++this.lasttmp;
            double[] uv = this.tmp[this.lasttmp];
            ++this.lasttmp;
            double[] norm_uv = this.tmp[this.lasttmp];
            Dreiding.getVector(u, v, uv);
            Dreiding.mul(uv, 1.0 / Sin_uv, norm_uv);
            double Inv_sin = Math.min(1.0, Math.max(-1.0, Dreiding.getScalar(w, norm_uv)));
            double Inv_cos = Math.sqrt(1.0 - Inv_sin * Inv_sin);
            if (Dreiding.getScalar(u, w) + Dreiding.getScalar(v, w) > 0.0) {
                Inv_cos = -Inv_cos;
            }
            ++this.lasttmp;
            double[] Projection_w = this.tmp[this.lasttmp];
            Dreiding.mul(norm_uv, -Inv_sin, Projection_w);
            Dreiding.add(w, Projection_w, Projection_w);
            Dreiding.Normalize(Projection_w, Projection_w);
            ++this.lasttmp;
            double[] uplusv_norm = this.tmp[this.lasttmp];
            Dreiding.add(u, v, uplusv_norm);
            Dreiding.Normalize(uplusv_norm, uplusv_norm);
            double side = Dreiding.getScalar(Projection_w, uplusv_norm);
            DreidingEqn.Inversion(Type2, Inv_cos, Inv_sin, E);
            if (this.derivatesRequested) {
                ++this.lasttmp;
                double[] vw = this.tmp[this.lasttmp];
                ++this.lasttmp;
                double[] wu = this.tmp[this.lasttmp];
                Dreiding.getVector(v, w, vw);
                Dreiding.getVector(w, u, wu);
                double T1 = 1.0 / (Inv_cos * Sin_uv);
                double TanT = Inv_sin / Inv_cos;
                double T2 = TanT / SinSq_uv;
                double l_u = this.AllBonds[iu][3];
                double l_w = this.AllBonds[iw][3];
                double l_v = this.AllBonds[iv][3];
                for (int icrd = 0; icrd < 3; ++icrd) {
                    double component_n = (T1 * uv[icrd] - TanT * w[icrd]) / l_w;
                    double component_m = (T1 * vw[icrd] - T2 * (u[icrd] - Cos_uv * v[icrd])) / l_u;
                    double component_p = (T1 * wu[icrd] - T2 * (v[icrd] - Cos_uv * u[icrd])) / l_v;
                    double component_o = -(component_m + component_n + component_p);
                    this.Deriv[n][icrd] = this.Deriv[n][icrd] + component_n * E[1] / 3.0;
                    this.Deriv[m][icrd] = this.Deriv[m][icrd] + component_m * E[1] / 3.0;
                    this.Deriv[p][icrd] = this.Deriv[p][icrd] + component_p * E[1] / 3.0;
                    this.Deriv[o][icrd] = this.Deriv[o][icrd] + component_o * E[1] / 3.0;
                }
            }
            if (dodebug) {
                this.debug.println("Bondangle uv: " + Math.toDegrees(Math.acos(Cos_uv)));
                this.debug.println("u: " + u[0] + " " + u[1] + " " + u[2]);
                this.debug.println("v: " + v[0] + " " + v[1] + " " + v[2]);
                this.debug.println("w: " + w[0] + " " + w[1] + " " + w[2]);
                this.debug.println("inv_sin:" + Inv_sin + " inv_cos: " + Inv_cos);
                this.debug.println("Energy: " + E[0] + " Derivateive:" + E[1]);
                this.debug.println("length nuv : " + (norm_uv[0] * norm_uv[0] + norm_uv[1] * norm_uv[1] + norm_uv[2] * norm_uv[2]));
                double sign = 1.0;
                if (Inv_sin < 0.0) {
                    sign = -1.0;
                }
                double angle = Math.acos(Inv_cos) * sign;
                this.debug.println("<b> The inversion angle: " + Math.toDegrees(angle) + " </b>");
                this.debug.println("lasttmp: " + this.lasttmp + " alltmp:" + this.alltmp);
                this.debug.printHR();
            }
            return E[0];
        }

        public double getBondEnergy() {
            double Ebond = 0.0;
            double[] E = this.Etmp;
            if (dodebug) {
                this.debug.println("Run through bonds:");
                this.debug.Tstart();
                this.debug.Trow();
                this.debug.TprintBC("i");
                this.debug.TprintBC("m-n");
                this.debug.TprintBC("Type[m]");
                this.debug.TprintBC("Type[n]");
                this.debug.TprintBC("order");
                this.debug.TprintBC("length");
                this.debug.TprintBC("energy E[0]");
                this.debug.TprintBC("derivate E[1]");
            }
            for (int i = 0; i < this.bAtom1.length; ++i) {
                int m = this.bAtom1[i];
                int n = this.bAtom2[i];
                DreidingEqn.Bond(this.Types[m], this.Types[n], this.bondOrders[i], this.AllBonds[i][3], E);
                if (dodebug) {
                    this.debug.Trow();
                    this.debug.TprintBC(i);
                    this.debug.TprintC(m + " - " + n);
                    this.debug.TprintC(DreidingParms.Type[this.Types[m]]);
                    this.debug.TprintC(DreidingParms.Type[this.Types[n]]);
                    this.debug.TprintC("" + this.bondOrders[i]);
                    this.debug.TprintC("" + this.AllBonds[i][3]);
                    this.debug.TprintC("" + E[0]);
                    this.debug.TprintC("" + E[1]);
                }
                Ebond += E[0];
                if (!this.derivatesRequested) continue;
                for (int j = 0; j < 3; ++j) {
                    this.Deriv[m][j] = this.Deriv[m][j] + this.AllNormalizedBonds[i][j] * E[1];
                    this.Deriv[n][j] = this.Deriv[n][j] + this.AllNormalizedBonds[i][j] * -E[1];
                }
            }
            if (dodebug) {
                this.debug.Tstop();
            }
            return Ebond;
        }

        public double getBondEnergy(int atomi) {
            double Ebond = 0.0;
            double[] E = this.Etmp;
            if (dodebug) {
                this.debug.println("Run through bonds:");
                this.debug.Tstart();
                this.debug.Trow();
                this.debug.TprintBC("i");
                this.debug.TprintBC("m-n");
                this.debug.TprintBC("Type[m]");
                this.debug.TprintBC("Type[n]");
                this.debug.TprintBC("order");
                this.debug.TprintBC("length");
                this.debug.TprintBC("energy");
            }
            int m = atomi;
            for (int i = 0; i < this.cTab[m].length; ++i) {
                int n = this.cTab[m][i];
                DreidingEqn.Bond(this.Types[m], this.Types[n], this.bOList[m][i], this.AllBonds[this.BList[m][i]][3], E);
                Ebond += E[0];
                if (!dodebug) continue;
                this.debug.Trow();
                this.debug.TprintBC(i);
                this.debug.TprintC(m + " - " + n);
                this.debug.TprintC(DreidingParms.Type[this.Types[m]]);
                this.debug.TprintC(DreidingParms.Type[this.Types[n]]);
                this.debug.TprintC("" + this.bondOrders[i]);
                this.debug.TprintC("" + this.AllBonds[this.BList[m][i]][3]);
                this.debug.TprintC("" + E[0]);
            }
            if (dodebug) {
                this.debug.Tstop();
            }
            return Ebond;
        }

        public double getEquilibriumBondLength(int a1, int a2) {
            return DreidingEqn.Bond(this.Types[a1], this.Types[a2]);
        }

        public boolean ifnullvector(double[] w) {
            double r = Math.sqrt(w[0] * w[0] + w[1] * w[1] + w[2] * w[2]);
            return this.ifzero(r);
        }

        public boolean ifzero(double r) {
            boolean result = false;
            if (0.0 - this.tol < r && 0.0 + this.tol > r) {
                result = true;
            }
            return result;
        }

        public double OneCenterAngle(int bu, int bv, int aType, boolean tabledebug) {
            if (dodebug && !tabledebug) {
                this.debug.println("Calculate analitical derivatives for angle");
            }
            this.lasttmp = 0;
            double[] u = this.tmp[this.lasttmp];
            ++this.lasttmp;
            double[] v = this.tmp[this.lasttmp];
            this.CpVec(this.AllNormalizedBonds[bu], u);
            this.CpVec(this.AllNormalizedBonds[bv], v);
            int m = 0;
            int o = 0;
            int n = 0;
            if (this.bAtom1[bu] == this.bAtom2[bv]) {
                Dreiding.mul(u, -1.0, u);
                if (dodebug && !tabledebug) {
                    this.debug.println("U inverted");
                }
                m = this.bAtom2[bu];
                o = this.bAtom1[bu];
                n = this.bAtom1[bv];
            }
            if (this.bAtom1[bv] == this.bAtom2[bu]) {
                if (dodebug && !tabledebug) {
                    this.debug.println(v[0] + " " + v[1] + " " + v[2]);
                }
                if (dodebug && !tabledebug) {
                    this.debug.println("V inverted");
                }
                Dreiding.mul(v, -1.0, v);
                if (dodebug && !tabledebug) {
                    this.debug.println(v[0] + " " + v[1] + " " + v[2]);
                }
                m = this.bAtom1[bu];
                o = this.bAtom2[bu];
                n = this.bAtom2[bv];
            }
            if (this.bAtom2[bv] == this.bAtom2[bu]) {
                if (dodebug && !tabledebug) {
                    this.debug.println("No inversion");
                }
                m = this.bAtom1[bu];
                o = this.bAtom2[bu];
                n = this.bAtom1[bv];
            }
            if (this.bAtom1[bv] == this.bAtom1[bu]) {
                Dreiding.mul(v, -1.0, v);
                Dreiding.mul(u, -1.0, u);
                if (dodebug && !tabledebug) {
                    this.debug.println("U&V inverted");
                }
                m = this.bAtom2[bu];
                o = this.bAtom1[bu];
                n = this.bAtom2[bv];
            }
            if (dodebug) {
                this.debug.println(" bAtom1[bu] " + this.bAtom1[bu] + " bAtom2[bu] " + this.bAtom2[bu]);
                this.debug.println(" bAtom1[bv] " + this.bAtom1[bv] + " bAtom2[bv] " + this.bAtom2[bv]);
                this.debug.println(" bu" + bu + " bv " + bv);
                this.debug.println(" o " + o + " m " + m + " n " + n + " ");
            }
            if (DreidingParms.Hybr[this.Types[o]] == 2 && (this.ifTransitionMetal(m) || this.ifTransitionMetal(n))) {
                if (dodebug) {
                    this.debug.println("Transition metal compexed with aromatic ligand; return 0");
                }
                return 0.0;
            }
            double cos = Dreiding.getScalar(u, v);
            cos = Math.max(-1.0, Math.min(1.0, cos));
            double angleInRadian = Math.acos(cos);
            if (dodebug) {
                this.debug.println("<b>bondangle (deg):" + debugPrintout.formatNumber(angleInRadian * 180.0 / Math.PI) + "</b>");
            }
            double[] E = this.Etmp;
            if (this.useCosAngleTermForBendEnergy) {
                System.err.println("Bond angle with cos");
                DreidingEqn.AngleCosE(aType, cos, E);
            } else {
                DreidingEqn.AngleE(aType, angleInRadian, m, o, n, E);
            }
            if (this.derivatesRequested) {
                ++this.lasttmp;
                double[] w = this.tmp[this.lasttmp];
                Dreiding.getVector(u, v, w);
                if (this.ifnullvector(w)) {
                    if (dodebug) {
                        this.debug.println("U,V parallel:");
                    }
                    ++this.lasttmp;
                    double[] base1 = this.tmp[this.lasttmp];
                    base1[0] = 1.0;
                    base1[1] = -1.0;
                    base1[2] = 1.0;
                    Dreiding.getVector(u, base1, w);
                    if (this.ifnullvector(w)) {
                        if (dodebug) {
                            this.debug.println("U [1,-1,1] parallel:");
                        }
                        base1[0] = -1.0;
                        base1[1] = 1.0;
                        base1[2] = 1.0;
                        Dreiding.getVector(u, base1, w);
                    }
                }
                Dreiding.Normalize(w, w);
                ++this.lasttmp;
                double[] uw = this.tmp[this.lasttmp];
                ++this.lasttmp;
                double[] wv = this.tmp[this.lasttmp];
                Dreiding.getVector(u, w, uw);
                Dreiding.mul(uw, 1.0 / this.AllBonds[bu][3], uw);
                Dreiding.getVector(w, v, wv);
                Dreiding.mul(wv, 1.0 / this.AllBonds[bv][3], wv);
                if (dodebug) {
                    this.debug.printHR();
                    this.debug.println("length of w:" + (w[0] * w[0] + w[1] * w[1] + w[2] * w[2]));
                    this.debug.println("w: " + w[0] + " " + w[1] + " " + w[2]);
                    this.debug.println("u: " + u[0] + " " + u[1] + " " + u[2]);
                    this.debug.println("v: " + v[0] + " " + v[1] + " " + v[2]);
                    this.debug.println("wv:" + wv[0] + " " + wv[1] + " " + wv[2]);
                }
                for (int icrd = 0; icrd < 3; ++icrd) {
                    this.Deriv[m][icrd] = this.Deriv[m][icrd] + uw[icrd] * E[1];
                    this.Deriv[o][icrd] = this.Deriv[o][icrd] - (uw[icrd] + wv[icrd]) * E[1];
                    this.Deriv[n][icrd] = this.Deriv[n][icrd] + wv[icrd] * E[1];
                }
            }
            return E[0];
        }

        public double OneCenterHbond(int A, int D, int i) {
            this.getBondLength(A, i, this.tmp4D[0]);
            this.lasttmp = 0;
            double[] u = this.tmp[this.lasttmp];
            Dreiding.mul(this.tmp4D[this.lasttmp], 1.0 / this.tmp4D[this.lasttmp][3], u);
            ++this.lasttmp;
            this.getBondLength(D, i, this.tmp4D[this.lasttmp]);
            double[] v = this.tmp[this.lasttmp];
            Dreiding.mul(this.tmp4D[this.lasttmp], 1.0 / this.tmp4D[this.lasttmp][3], v);
            ++this.lasttmp;
            this.getBondLength(D, A, this.tmp4D[this.lasttmp]);
            double[] z = this.tmp[this.lasttmp];
            double R = this.tmp4D[this.lasttmp][3];
            Dreiding.mul(this.tmp4D[this.lasttmp], 1.0 / R, z);
            double cos = Dreiding.getScalar(u, v);
            cos = Math.max(-1.0, Math.min(1.0, cos));
            double[] E = new double[3];
            DreidingEqn.Hbond(R, cos, E);
            if (dodebug) {
                this.debug.printHR();
                this.debug.println("<b>donor-H-acceptor angle:" + Math.toDegrees(Math.acos(cos)) + "</b>");
                this.debug.println("Energy:" + E[0]);
                this.debug.println("Energy:" + E[1]);
                this.debug.println("Energy:" + E[2]);
                this.debug.println("z:");
                this.debug.printVector(z);
            }
            if (this.derivatesRequested) {
                for (int icrd = 0; icrd < 3; ++icrd) {
                    this.Deriv[D][icrd] = this.Deriv[D][icrd] + z[icrd] * E[1];
                    this.Deriv[A][icrd] = this.Deriv[A][icrd] + z[icrd] * -E[1];
                }
                if (dodebug) {
                    for (int ij = 0; ij < this.Deriv.length; ++ij) {
                        this.debug.println("D:" + this.Deriv[ij][0]);
                        this.debug.println("D:" + this.Deriv[ij][1]);
                        this.debug.println("D:" + this.Deriv[ij][2]);
                    }
                }
                ++this.lasttmp;
                double[] w = this.tmp[this.lasttmp];
                Dreiding.getVector(u, v, w);
                if (this.ifnullvector(w)) {
                    if (dodebug) {
                        this.debug.println("U,V parallel:");
                    }
                    ++this.lasttmp;
                    double[] base1 = this.tmp[this.lasttmp];
                    base1[0] = 1.0;
                    base1[1] = -1.0;
                    base1[2] = 1.0;
                    Dreiding.getVector(u, base1, w);
                    if (this.ifnullvector(w)) {
                        if (dodebug) {
                            this.debug.println("U [1,-1,1] parallel:");
                        }
                        base1[0] = -1.0;
                        base1[1] = 1.0;
                        base1[2] = 1.0;
                        Dreiding.getVector(u, base1, w);
                    }
                }
                Dreiding.Normalize(w, w);
                ++this.lasttmp;
                double[] uw = this.tmp[this.lasttmp];
                ++this.lasttmp;
                double[] wv = this.tmp[this.lasttmp];
                Dreiding.getVector(u, w, uw);
                Dreiding.mul(uw, 1.0 / this.tmp4D[0][3], uw);
                Dreiding.getVector(w, v, wv);
                Dreiding.mul(wv, 1.0 / this.tmp4D[1][3], wv);
                if (dodebug) {
                    this.debug.println("length of w:" + (w[0] * w[0] + w[1] * w[1] + w[2] * w[2]));
                    this.debug.println("w: " + w[0] + " " + w[1] + " " + w[2]);
                    this.debug.println("u: " + u[0] + " " + u[1] + " " + u[2]);
                    this.debug.println("v: " + v[0] + " " + v[1] + " " + v[2]);
                    this.debug.println("wv:" + wv[0] + " " + wv[1] + " " + wv[2]);
                }
                for (int icrd = 0; icrd < 3; ++icrd) {
                    this.Deriv[A][icrd] = this.Deriv[A][icrd] + uw[icrd] * E[2];
                    this.Deriv[i][icrd] = this.Deriv[i][icrd] - (uw[icrd] + wv[icrd]) * E[2];
                    this.Deriv[D][icrd] = this.Deriv[D][icrd] + wv[icrd] * E[2];
                }
                if (dodebug) {
                    for (int ij = 0; ij < this.Deriv.length; ++ij) {
                        this.debug.println("D:" + this.Deriv[ij][0]);
                        this.debug.println("D:" + this.Deriv[ij][1]);
                        this.debug.println("D:" + this.Deriv[ij][2]);
                    }
                    this.debug.printHR();
                }
            }
            return E[0];
        }

        public double getAngleEnergy() {
            double Eangle = 0.0;
            if (dodebug) {
                this.debug.printB("Run through angles:");
                this.debug.Tstart();
                this.debug.Trow();
                this.debug.TprintBC("aj");
                this.debug.TprintBC("ai");
                this.debug.TprintBC("ak");
                this.debug.TprintBC("bond1");
                this.debug.TprintBC("bond2");
                this.debug.TprintBC("aj T");
                this.debug.TprintBC("ai T");
                this.debug.TprintBC("ak T");
                this.debug.TprintBC("angle0");
                this.debug.TprintBC("?");
            }
            for (int i = 0; i < this.Anum.length; ++i) {
                int aType = this.Types[i];
                int ai = i;
                for (int j = 0; j < this.cTab[i].length; ++j) {
                    int aj = this.cTab[i][j];
                    int bond1 = this.BList[i][j];
                    for (int k = j + 1; k < this.cTab[i].length; ++k) {
                        int ak = this.cTab[i][k];
                        int bond2 = this.BList[i][k];
                        if (dodebug) {
                            this.debug.Trow();
                            this.debug.TprintBC("" + aj);
                            this.debug.TprintBC("" + ai);
                            this.debug.TprintBC("" + ak);
                            this.debug.TprintC(bond1 + " (" + this.bAtom1[bond1] + "-" + this.bAtom2[bond1] + ")");
                            this.debug.TprintC(bond2 + " (" + this.bAtom1[bond2] + "-" + this.bAtom2[bond2] + ")");
                            this.debug.TprintC(DreidingParms.Type[this.Types[aj]] + " (" + this.Types[aj] + ")");
                            this.debug.TprintC(DreidingParms.Type[this.Types[ai]] + " (" + this.Types[ai] + ")");
                            this.debug.TprintC(DreidingParms.Type[this.Types[ak]] + " (" + this.Types[ak] + ")");
                            this.debug.Tprint(debugPrintout.formatNumber(DreidingParms.AngleInRadian[aType] * 180.0 / Math.PI));
                            this.debug.print("<TD>");
                        }
                        Eangle += this.OneCenterAngle(bond1, bond2, aType, true);
                        if (!dodebug) continue;
                        this.debug.print("</TD>");
                    }
                }
            }
            if (dodebug) {
                this.debug.Tstop();
            }
            return Eangle;
        }

        public double getAngleEnergy(int atomi) {
            double Eangle = 0.0;
            double[] E = this.Etmp;
            int n = this.cTab[atomi].length;
            if (n > 1) {
                boolean inv1 = false;
                boolean inv2 = false;
                for (int j = 0; j < n - 1; ++j) {
                    int bond1 = this.BList[atomi][j];
                    inv1 = this.bAtom1[bond1] == atomi;
                    for (int k = j + 1; k < n; ++k) {
                        int bond2 = this.BList[atomi][k];
                        inv2 = this.bAtom1[bond2] == atomi;
                        Eangle += this.OneCenterAngle(bond1, bond2, this.Types[atomi], false);
                    }
                }
            }
            for (int j = 0; j < n; ++j) {
                int ak;
                int k;
                int aj = this.cTab[atomi][j];
                int m = this.cTab[aj].length;
                int[] bond2 = new int[m];
                int bond1 = 0;
                boolean inv1 = false;
                boolean[] inv2 = new boolean[m];
                if (m <= 1) continue;
                for (k = 0; k < m; ++k) {
                    ak = this.cTab[aj][k];
                    if (ak != atomi) {
                        bond2[k] = this.BList[aj][k];
                        inv2[k] = this.bAtom1[bond2[k]] == aj;
                    }
                    if (ak != atomi) continue;
                    bond1 = this.BList[aj][k];
                    inv1 = this.bAtom1[bond1] != atomi;
                }
                for (k = 0; k < m; ++k) {
                    ak = this.cTab[aj][k];
                    if (ak == atomi) continue;
                    Eangle += this.OneCenterAngle(bond1, bond2[k], this.Types[aj], false);
                }
            }
            return Eangle;
        }

        public double getDihedEnergy() {
            double Edihed = 0.0;
            double[] E = this.Etmp;
            if (dodebug) {
                this.debug.println("Run through dihedrals (ENERGY) :");
            }
            for (int i = 0; i < this.bAtom1.length; ++i) {
                if (dodebug) {
                    this.debug.println("F O R   B O N D :" + i);
                }
                Edihed += this.getDihedEnergyAroundBond(i, this.bondOrders[i]);
            }
            return Edihed;
        }

        public double getDihedEnergyAroundBond(int bjk, int bondOrder) {
            double eDihed = 0.0;
            double[] E = this.Etmp;
            int aj = this.bAtom2[bjk];
            int ak = this.bAtom1[bjk];
            int nj = this.cTab[aj].length;
            int nk = this.cTab[ak].length;
            if (nj > 1 && nk > 1) {
                int nDihed = (nj - 1) * (nk - 1);
                for (int i = 0; i < nj; ++i) {
                    int ai = this.cTab[aj][i];
                    if (ai == ak) continue;
                    int bij = this.BList[aj][i];
                    for (int l = 0; l < nk; ++l) {
                        int al = this.cTab[ak][l];
                        if (al == aj) continue;
                        int bkl = this.BList[ak][l];
                        E[0] = this.OneCenterDihedral(bij, bjk, bkl, bondOrder, nDihed, E);
                        eDihed += E[0];
                    }
                }
            }
            return eDihed;
        }

        public double OneCenterDihedral(int iu, int iw, int iv, int bondOrder, int nDihed, double[] E) {
            int m = 0;
            int n = 0;
            int o = 0;
            int p = 0;
            this.lasttmp = 0;
            double[] u = this.tmp[this.lasttmp];
            ++this.lasttmp;
            double[] w = this.tmp[this.lasttmp];
            ++this.lasttmp;
            double[] v = this.tmp[this.lasttmp];
            this.CpVec(this.AllNormalizedBonds[iu], u);
            this.CpVec(this.AllNormalizedBonds[iw], w);
            this.CpVec(this.AllNormalizedBonds[iv], v);
            if (this.bAtom1[iw] == this.bAtom2[iv]) {
                p = this.bAtom2[iv];
                n = this.bAtom1[iv];
                o = this.bAtom2[iw];
                if (dodebug) {
                    this.debug.println("No inversion on v and w");
                }
            }
            if (this.bAtom1[iw] == this.bAtom1[iv]) {
                p = this.bAtom1[iv];
                n = this.bAtom2[iv];
                Dreiding.mul(v, -1.0, v);
                o = this.bAtom2[iw];
                if (dodebug) {
                    this.debug.println("v has to be inverted");
                }
            }
            if (this.bAtom2[iw] == this.bAtom1[iv]) {
                p = this.bAtom2[iw];
                n = this.bAtom2[iv];
                o = this.bAtom1[iw];
                Dreiding.mul(v, -1.0, v);
                Dreiding.mul(w, -1.0, w);
                if (dodebug) {
                    this.debug.println("v and  w has to be inverted");
                }
            }
            if (this.bAtom2[iw] == this.bAtom2[iv]) {
                p = this.bAtom2[iv];
                n = this.bAtom1[iv];
                Dreiding.mul(w, -1.0, w);
                o = this.bAtom1[iw];
                if (dodebug) {
                    this.debug.println("w has to be inverted");
                }
            }
            if (this.bAtom2[iu] == o) {
                m = this.bAtom1[iu];
                if (dodebug) {
                    this.debug.println("No inversion on u");
                }
            }
            if (this.bAtom1[iu] == o) {
                m = this.bAtom2[iu];
                if (dodebug) {
                    this.debug.println("u has to be inverted");
                }
                Dreiding.mul(u, -1.0, u);
            }
            if (dodebug) {
                this.debug.println("u: " + this.bAtom1[iu] + " " + this.bAtom2[iu]);
                this.debug.println("w: " + this.bAtom1[iw] + " " + this.bAtom2[iw]);
                this.debug.println("v: " + this.bAtom1[iv] + " " + this.bAtom2[iv]);
            }
            if (this.ifTransitionMetal(m) || this.ifTransitionMetal(n) || this.ifTransitionMetal(o) || this.ifTransitionMetal(p)) {
                return 0.0;
            }
            ++this.lasttmp;
            double[] uw = this.tmp[this.lasttmp];
            ++this.lasttmp;
            double[] vw = this.tmp[this.lasttmp];
            Dreiding.getVector(u, w, uw);
            Dreiding.getVector(v, w, vw);
            double cos_u = Dreiding.getScalar(u, w);
            cos_u = Math.max(-1.0, Math.min(1.0, cos_u));
            double cos_v = -1.0 * Dreiding.getScalar(v, w);
            cos_v = Math.max(-1.0, Math.min(1.0, cos_v));
            double sinSq_u = 1.0 - cos_u * cos_u;
            double sinSq_v = 1.0 - cos_v * cos_v;
            double sin_u = Math.sqrt(sinSq_u);
            double sin_v = Math.sqrt(sinSq_v);
            if (this.ifzero(sin_u)) {
                E[0] = 0.0;
                E[1] = 0.0;
                return 0.0;
            }
            if (this.ifzero(sin_v)) {
                E[0] = 0.0;
                E[1] = 0.0;
                return 0.0;
            }
            double cosdelta = Dreiding.getScalar(uw, vw) / (sin_u * sin_v);
            cosdelta = Math.min(1.0, Math.max(-1.0, cosdelta));
            double cossign = Dreiding.getScalar(u, vw) / sin_v;
            cossign = Math.min(1.0, Math.max(-1.0, cossign));
            double Deltasign = 0.0;
            Deltasign = cossign <= 0.0 ? -1.0 : 1.0;
            double delta = Math.acos(cosdelta) * Deltasign;
            DreidingEqn.Torsion(this.Types[m], this.Types[o], this.Types[p], this.Types[n], bondOrder, delta, nDihed, E);
            if (this.derivatesRequested) {
                double l_u = this.AllBonds[iu][3];
                double l_w = this.AllBonds[iw][3];
                double l_v = this.AllBonds[iv][3];
                double component1 = 0.0;
                double component2 = 0.0;
                double component3 = 0.0;
                for (int icrd = 0; icrd < 3; ++icrd) {
                    component1 = uw[icrd] / l_u / sinSq_u * E[1];
                    component2 = vw[icrd] / l_v / sinSq_v * E[1];
                    component3 = (uw[icrd] * cos_u / (l_w * sinSq_u) + vw[icrd] * cos_v / (l_w * sinSq_v)) * E[1];
                    this.Deriv[m][icrd] = this.Deriv[m][icrd] + component1;
                    this.Deriv[n][icrd] = this.Deriv[n][icrd] - component2;
                    this.Deriv[o][icrd] = this.Deriv[o][icrd] - component1 + component3;
                    this.Deriv[p][icrd] = this.Deriv[p][icrd] + component2 - component3;
                }
                if (dodebug) {
                    this.debug.println("Atom numbers  : " + m + ", " + o + ", " + p + ", " + n);
                    this.debug.println("Bond numbers  : " + iu + " " + iw + " " + iv);
                    this.debug.println("Dihedral angle:" + Math.toDegrees(delta));
                    this.debug.println("Sign          :" + Deltasign);
                    this.debug.println("Energy        :" + E[0]);
                    this.debug.println("dE/d(dihed)   :" + E[1]);
                    this.debug.println("Three bond lengths:" + l_u + " " + l_w + " " + l_v);
                    this.debug.println("Two bond angles:" + Math.toDegrees(Math.acos(cos_u)) + "  " + Math.toDegrees(Math.acos(cos_v)));
                    this.debug.printHR();
                }
            }
            return E[0];
        }

        public double getDihedEnergy(int atomi) {
            double Edihed = 0.0;
            double[] E = this.Etmp;
            int aj = atomi;
            int nj = this.cTab[aj].length;
            if (nj > 1) {
                for (int i = 0; i < nj; ++i) {
                    int ak = this.cTab[aj][i];
                    int bondOrder = this.bOList[aj][i];
                    int bjk = this.BList[aj][i];
                    Edihed += this.getDihedEnergyAroundBond(bjk, bondOrder);
                }
                if (dodebug) {
                    this.debug.println("Partial dihedral energy if the atom is in the middle:" + Edihed);
                }
            }
            int ai = atomi;
            int[] ctabi = this.cTab[aj];
            for (int j = 0; j < ctabi.length; ++j) {
                aj = this.cTab[ai][j];
                nj = this.cTab[aj].length;
                this.debug.println("nj at the terminal:" + nj);
                if (nj <= 1) continue;
                for (int k = 0; k < nj; ++k) {
                    int ak = this.cTab[aj][k];
                    if (ak == ai) continue;
                    int bondOrder = this.bOList[aj][k];
                    int bjk = this.BList[aj][k];
                    Edihed += this.getDihedEnergyAroundBond(bjk, bondOrder);
                    if (!dodebug) continue;
                    this.debug.println("Partial dihedral energy if the atom is at the terminal:" + Edihed);
                }
            }
            return Edihed;
        }

        public double OneCenterInversion(int i) {
            double Einv = 0.0;
            double Efor1center = 0.0;
            for (int j = 0; j < 3; ++j) {
                int jj = this.BList[i][j % 3];
                int kk = this.BList[i][(j + 1) % 3];
                int ll = this.BList[i][(j + 2) % 3];
                Einv = this.getInversionAngle(jj, kk, ll, this.Types[i]);
                Efor1center += Einv / 3.0;
            }
            return Efor1center;
        }

        public double getInversionEnergy() {
            double Etot = 0.0;
            double Efor1center = 0.0;
            for (int i = 0; i < this.Anum.length; ++i) {
                boolean doInv;
                int n1 = this.cTab[i].length;
                if (n1 != 3 || this.Types[i] == DreidingParms.a_N_3 || this.Types[i] == DreidingParms.a_P_3 || !(doInv = true)) continue;
                Efor1center = this.OneCenterInversion(i);
                Etot = Efor1center + Etot;
            }
            return Etot;
        }

        public double getInversionEnergy(int atomi) {
            double Efor1center = 0.0;
            double Etot = 0.0;
            int i = atomi;
            int[] ctabi = this.cTab[i];
            int n1 = ctabi.length;
            if (n1 == 3 && this.Types[i] != DreidingParms.a_N_3 && this.Types[i] != DreidingParms.a_P_3) {
                Efor1center = this.OneCenterInversion(i);
                Etot = Efor1center + Etot;
            }
            for (int j = 0; j < n1; ++j) {
                int aj = ctabi[j];
                int[] ctabj = this.cTab[aj];
                int n2 = ctabj.length;
                if (n2 != 3 || this.Types[aj] == DreidingParms.a_N_3 || this.Types[aj] == DreidingParms.a_P_3) continue;
                Efor1center = this.OneCenterInversion(aj);
                Etot = Efor1center + Etot;
            }
            return Etot;
        }

        public boolean isMetal(int type) {
            if (type == DreidingParms.a_default) {
                return true;
            }
            if (type > 17 && type < 22) {
                return true;
            }
            if (type > 22 && type < 26) {
                return true;
            }
            if (type > 27 && type < 37) {
                return true;
            }
            return type >= 43;
        }

        boolean calcNeighbor(int i, int j) {
            if (i == j) {
                return true;
            }
            int[] ctabi = this.cTab[i];
            int[] ctabj = this.cTab[j];
            for (int k = 0; k < ctabi.length; ++k) {
                if (ctabi[k] != j) continue;
                return true;
            }
            int commonCount = 0;
            int metalCount = 0;
            for (int k = 0; k < ctabi.length; ++k) {
                for (int l = 0; l < ctabj.length; ++l) {
                    if (ctabi[k] != ctabj[l]) continue;
                    ++commonCount;
                    int commonAt = ctabi[k];
                    if (!this.isMetal(this.Types[commonAt])) continue;
                    ++metalCount;
                }
                if (metalCount < true || metalCount != commonCount) continue;
                return false;
            }
            return commonCount > 0;
        }

        public boolean Neihgbor(int i, int j) {
            if (this.notNeighborCache == null) {
                int ii;
                this.notNeighborCache = new BitSet[this.cTab.length];
                for (ii = 0; ii < this.notNeighborCache.length; ++ii) {
                    this.notNeighborCache[ii] = new BitSet();
                }
                for (ii = 0; ii < this.notNeighborCache.length; ++ii) {
                    for (int jj = ii; jj < this.notNeighborCache.length; ++jj) {
                        if (this.calcNeighbor(ii, jj)) continue;
                        this.notNeighborCache[ii].set(jj);
                        this.notNeighborCache[jj].set(ii);
                    }
                }
            }
            return !this.notNeighborCache[i].get(j);
        }

        public double getVdWEnergy() {
            double Evdw = 0.0;
            double[] E = this.Etmp;
            if (dodebug) {
                this.debug.println("Run through vdW:");
                this.debug.Tstart();
                this.debug.Trow();
                this.debug.TprintBC("A1");
                this.debug.TprintBC("A2");
                this.debug.TprintBC("Bond R");
                this.debug.TprintBC("E");
            }
            for (int i = 0; i < this.mol.getAtomNumbers().length - 1; ++i) {
                for (int j = i + 1; j < this.Anum.length; ++j) {
                    if (this.Neihgbor(i, j)) continue;
                    this.getBondLength(i, j, this.tmp4D[0]);
                    double R = this.tmp4D[0][3];
                    double[] norm = this.tmp[0];
                    Dreiding.mul(this.tmp4D[0], 1.0 / R, norm);
                    if (this.useExpTermForVanDerWaalsEnergy) {
                        DreidingEqn.vDWexp(this.Types[i], this.Types[j], R, E);
                    } else {
                        DreidingEqn.vDW(this.Types[i], this.Types[j], R, E);
                    }
                    Evdw += E[0];
                    if (this.derivatesRequested) {
                        for (int icrd = 0; icrd < 3; ++icrd) {
                            this.Deriv[i][icrd] = this.Deriv[i][icrd] + norm[icrd] * E[1];
                            this.Deriv[j][icrd] = this.Deriv[j][icrd] + norm[icrd] * -E[1];
                        }
                    }
                    if (!dodebug) continue;
                    this.debug.Trow();
                    this.debug.TprintBC("" + i);
                    this.debug.TprintBC("" + j);
                    this.debug.Tprint(debugPrintout.formatNumber(R));
                    this.debug.Tprint(debugPrintout.formatNumber(E[0]));
                }
            }
            if (dodebug) {
                this.debug.Tstop();
            }
            return Evdw;
        }

        public double getVdWEnergy(int atomi) {
            double Evdw = 0.0;
            double[] E = this.Etmp;
            if (dodebug) {
                this.debug.println("Run through vdW:");
            }
            int i = atomi;
            for (int j = 0; j < this.mol.getAtomNumbers().length; ++j) {
                if (this.Neihgbor(i, j)) continue;
                this.getBondLength(i, j, this.tmp4D[0]);
                double R = this.tmp4D[0][3];
                if (dodebug) {
                    this.debug.println("vdW for:" + i + " " + j + " " + R);
                }
                if (this.useExpTermForVanDerWaalsEnergy) {
                    DreidingEqn.vDWexp(this.Types[i], this.Types[j], R, E);
                } else {
                    DreidingEqn.vDW(this.Types[i], this.Types[j], R, E);
                }
                Evdw += E[0];
            }
            return Evdw;
        }

        public boolean ifAcceptor(int j) {
            return this.Types[j] == DreidingParms.a_N_3 && this.cTab[j].length < 4 || this.Anum[j] == 8 || this.Anum[j] == 9;
        }

        public double getHydBondEnergy() {
            double Ehyd = 0.0;
            if (this.disableHBond) {
                return Ehyd;
            }
            int H_HB = DreidingParms.a_H_HB;
            for (int i = 0; i < this.Anum.length; ++i) {
                if (this.Types[i] != H_HB) continue;
                int D = this.cTab[i][0];
                for (int j = 0; j < this.Anum.length; ++j) {
                    if (!this.ifAcceptor(j) || j == D || this.noHBond(D, j)) continue;
                    int A = j;
                    if (dodebug) {
                        this.debug.println("Donor (allmol): " + DreidingParms.Type[this.Types[D]] + " Acceptor(allmol): " + DreidingParms.Type[this.Types[A]]);
                    }
                    Ehyd += this.OneCenterHbond(A, D, i);
                }
            }
            return Ehyd;
        }

        private boolean noHBond(int D, int j) {
            boolean neighbor = false;
            block0: for (int k = 0; k < this.cTab[D].length; ++k) {
                if (this.cTab[D][k] == j) {
                    neighbor = true;
                    break;
                }
                for (int l = 0; l < this.cTab[k].length; ++l) {
                    if (this.cTab[k][l] != j) continue;
                    neighbor = true;
                    continue block0;
                }
            }
            return neighbor;
        }

        public void setDisableHBond(boolean disable) {
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("H-bond disable flag: " + disable);
            }
            this.disableHBond = disable;
        }

        public double getHydBondEnergy(int atomi) {
            double cos;
            double R;
            int D;
            if (atomi > -1) {
                throw new UnsupportedOperationException();
            }
            System.err.println("getHydBondEnergy(atomi) was called!!!!");
            double Ehyd = 0.0;
            double[] E = new double[3];
            int H_HB = DreidingParms.a_H_HB;
            int i = atomi;
            if (this.Types[i] == H_HB) {
                D = this.cTab[i][0];
                for (int j = 0; j < this.Anum.length; ++j) {
                    if (!this.ifAcceptor(j) || j == D) continue;
                    int A = j;
                    this.getBondLength(D, A, this.tmp4D[0]);
                    R = this.tmp4D[0][3];
                    cos = this.getCosAngle(D, i, A);
                    DreidingEqn.Hbond(R, cos, E);
                    Ehyd += E[0];
                    if (!dodebug) continue;
                    this.debug.println("This atom is the Hydrogen in the hbond");
                    this.debug.println("Angle: " + Math.toDegrees(Math.acos(cos)));
                    this.debug.println("E: " + E[0]);
                    this.debug.println("Donor: " + DreidingParms.Type[this.Types[D]] + " Acceptor: " + DreidingParms.Type[this.Types[A]]);
                }
            }
            if (this.ifAcceptor(i)) {
                int A = i;
                for (int j = 0; j < this.Anum.length; ++j) {
                    if (this.Types[j] != H_HB || (D = this.cTab[j][0]) == A) continue;
                    this.getBondLength(D, A, this.tmp4D[0]);
                    R = this.tmp4D[0][3];
                    cos = this.getCosAngle(D, j, A);
                    DreidingEqn.Hbond(R, cos, E);
                    Ehyd += E[0];
                    if (!dodebug) continue;
                    this.debug.println("This atom is the acceptor in the hbond");
                    this.debug.println("Angle: " + Math.toDegrees(Math.acos(cos)));
                    this.debug.println("E: " + E[0]);
                    this.debug.println("Donor: " + DreidingParms.Type[this.Types[D]] + " Acceptor: " + DreidingParms.Type[this.Types[A]]);
                }
            }
            for (int L = 0; L < this.cTab[atomi].length; ++L) {
                if (this.Types[this.cTab[atomi][L]] != H_HB) continue;
                D = atomi;
                int H = this.cTab[atomi][L];
                for (int k = 0; k < this.Anum.length; ++k) {
                    if (!this.ifAcceptor(k) || k == D) continue;
                    int A = k;
                    this.getBondLength(D, A, this.tmp4D[0]);
                    double R2 = this.tmp4D[0][3];
                    double cos2 = this.getCosAngle(D, H, A);
                    DreidingEqn.Hbond(R2, cos2, E);
                    Ehyd += E[0];
                    if (!dodebug) continue;
                    this.debug.println("This atom is the donor in the hbond");
                    this.debug.println("Angle: " + Math.toDegrees(Math.acos(cos2)));
                    this.debug.println("E: " + E[0]);
                    this.debug.println("Donor: " + DreidingParms.Type[this.Types[D]] + " Acceptor: " + DreidingParms.Type[this.Types[A]]);
                }
            }
            return Ehyd;
        }

        public double getEnergy(int m) {
            return this.getEnergy(m, false, false);
        }

        public double getEnergy(int m, boolean cosForAngle, boolean expForVdW) {
            this.useCosAngleTermForBendEnergy = cosForAngle;
            this.useExpTermForVanDerWaalsEnergy = expForVdW;
            double[] eVec = this.getEnergyComponents(m);
            double E = 0.0;
            this.derivatesRequested = false;
            for (int i = 0; i < eVec.length; ++i) {
                E += eVec[i];
            }
            if (dodebug) {
                this.debug.println("Dreiding energy for atom: " + m + " " + E);
            }
            return E;
        }

        public double[] getEnergyComponents(int m) {
            double dE;
            int j;
            double[][] Bondsm = new double[this.cTab[m].length][4];
            double[][] NormalizedBondsm = new double[this.cTab[m].length][3];
            for (int i = 0; i < Bondsm.length; ++i) {
                int ii = this.BList[m][i];
                for (j = 0; j < 4; ++j) {
                    Bondsm[i][j] = this.AllBonds[ii][j];
                }
                for (j = 0; j < 3; ++j) {
                    NormalizedBondsm[i][j] = this.AllNormalizedBonds[ii][j];
                }
            }
            if (dodebug) {
                this.debug.incLevel("Calculating bond vectors");
            }
            for (int ii = 0; ii < this.cTab[m].length; ++ii) {
                int i = this.BList[m][ii];
                this.getBondLength(this.bAtom1[i], this.bAtom2[i], this.AllBonds[i]);
                for (j = 0; j < 3; ++j) {
                    this.AllNormalizedBonds[i][j] = this.AllBonds[i][j] / this.AllBonds[i][3];
                }
                if (!dodebug) continue;
                this.debug.println("Precalculated bondvector cooordinates and length for atoms " + this.bAtom1[i] + " " + this.bAtom2[i]);
                this.debug.printVector(this.AllBonds[i]);
            }
            if (dodebug) {
                this.debug.decLevel();
            }
            if (dodebug) {
                this.debug.println(" Single atomic Energy calculation from:");
            }
            double[] E = new double[6];
            if (dodebug) {
                this.debug.incLevel("Bond");
            }
            E[0] = dE = this.getBondEnergy(m);
            if (dodebug) {
                this.debug.decLevel();
                this.debug.println("dE = " + dE);
            }
            if (dodebug) {
                this.debug.incLevel("Angle");
            }
            E[1] = dE = this.getAngleEnergy(m);
            if (dodebug) {
                this.debug.decLevel();
                this.debug.println("dE = " + dE);
            }
            if (dodebug) {
                this.debug.incLevel("Dihedral for atom " + m);
            }
            E[2] = dE = this.getDihedEnergy(m);
            if (dodebug) {
                this.debug.decLevel();
                this.debug.println("dE = " + dE);
            }
            if (dodebug) {
                this.debug.incLevel("Inversion");
            }
            E[3] = dE = this.getInversionEnergy(m);
            if (dodebug) {
                this.debug.decLevel();
                this.debug.println("dE = " + dE);
            }
            if (dodebug) {
                this.debug.incLevel("VdW");
            }
            E[4] = dE = this.getVdWEnergy(m);
            if (dodebug) {
                this.debug.decLevel();
                this.debug.println("dE = " + dE);
            }
            if (dodebug) {
                this.debug.incLevel("HBond_numerical");
            }
            E[5] = dE = this.getHydBondEnergy(m);
            if (dodebug) {
                this.debug.decLevel();
                this.debug.println("dE = " + dE);
            }
            for (int i = 0; i < Bondsm.length; ++i) {
                int j2;
                int ii = this.BList[m][i];
                for (j2 = 0; j2 < 4; ++j2) {
                    this.AllBonds[ii][j2] = Bondsm[i][j2];
                }
                for (j2 = 0; j2 < 3; ++j2) {
                    this.AllNormalizedBonds[ii][j2] = NormalizedBondsm[i][j2];
                }
            }
            return E;
        }

        public double getEnergy() {
            double E = this.getEnergy(false, false, false);
            return E;
        }

        public double getEnergy(boolean derivatesRequested) {
            double E = this.getEnergy(derivatesRequested, false, false);
            return E;
        }

        public double getEnergy(boolean derivatesRequested, boolean cosForAngle, boolean expForVdW) {
            this.derivatesRequested = derivatesRequested;
            this.useCosAngleTermForBendEnergy = cosForAngle;
            this.useExpTermForVanDerWaalsEnergy = expForVdW;
            if (dodebug) {
                this.debug.printB("getEnergy()");
                this.debug.println("derivatesRequested: " + derivatesRequested);
                this.debug.println("cosForAngle: " + cosForAngle);
                this.debug.println("expForVdW: " + expForVdW);
            }
            double E = 0.0;
            try {
                double[] eVec = this.getEnergyComponents();
                for (int i = 0; i < eVec.length; ++i) {
                    E += eVec[i];
                }
                if (dodebug) {
                    this.debug.println("Dreiding energy: " + E);
                }
            }
            catch (Exception e) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Exception in Dreiding: " + e.getMessage());
                    e.printStackTrace();
                }
                E = Double.POSITIVE_INFINITY;
            }
            return E;
        }

        public void clearCorrupted() {
            this.corrupted = false;
        }

        public boolean getCorrupted() {
            return this.corrupted;
        }

        private void reportCorrupted() {
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Dreiding parameters corrupted");
            }
            this.corrupted = true;
        }

        public double[] getEnergyComponents() {
            double dE;
            int j;
            if (dodebug) {
                this.debug.incLevel("Calculating bond vectors");
                this.debug.printB("Precalculated bondvector cooordinates and lengtg");
                this.debug.Tstart();
                this.debug.Trow();
                this.debug.TprintBC(2, "Atom 1,2");
                this.debug.TprintBC("AllBonds");
                this.debug.TprintBC("AllNormalizedBonds");
            }
            for (int i = 0; i < this.bAtom1.length; ++i) {
                this.getBondLength(this.bAtom1[i], this.bAtom2[i], this.AllBonds[i]);
                for (int j2 = 0; j2 < 3; ++j2) {
                    this.AllNormalizedBonds[i][j2] = this.AllBonds[i][j2] / this.AllBonds[i][3];
                }
                if (!dodebug) continue;
                this.debug.Trow();
                this.debug.Tprint("" + this.bAtom1[i]);
                this.debug.Tprint("" + this.bAtom2[i]);
                String s = "";
                for (j = 0; j < this.AllBonds[i].length; ++j) {
                    s = s + debugPrintout.formatNumber(this.AllBonds[i][j]) + " ";
                }
                this.debug.Tprint(s);
                s = "";
                for (j = 0; j < this.AllNormalizedBonds[i].length; ++j) {
                    s = s + debugPrintout.formatNumber(this.AllNormalizedBonds[i][j]) + " ";
                }
                this.debug.Tprint(s);
            }
            if (dodebug) {
                this.debug.Tstop();
                this.debug.decLevel();
            }
            if (this.derivatesRequested) {
                int i;
                double[][] localDerivates = this.mol.getLocalDerivateScratch();
                for (i = 0; i < localDerivates.length; ++i) {
                    for (j = 0; j < localDerivates[i].length; ++j) {
                        localDerivates[i][j] = 0.0;
                    }
                }
                for (i = 0; i < this.Deriv.length; ++i) {
                    for (j = 0; j < this.Deriv[i].length; ++j) {
                        this.Deriv[i][j] = 0.0;
                    }
                }
            }
            if (dodebug) {
                this.debug.println(" Total molecular Energy calculation from:");
            }
            double[] E = new double[6];
            if (dodebug) {
                this.debug.incLevel("Bond");
            }
            E[0] = dE = this.getBondEnergy();
            if (!U.isDoubleOK(dE)) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Bond energy failed;");
                }
                this.reportCorrupted();
            }
            if (dodebug) {
                this.debug.decLevel();
                this.debug.println("dE = " + dE);
            }
            if (dodebug) {
                this.debug.incLevel("Angle");
            }
            E[1] = dE = this.getAngleEnergy();
            if (!U.isDoubleOK(dE)) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Angle energy failed;");
                }
                this.reportCorrupted();
            }
            if (dodebug) {
                this.debug.decLevel();
                this.debug.println("dE = " + dE);
            }
            if (dodebug) {
                this.debug.incLevel("Dihedral for all atoms");
            }
            if (!U.isDoubleOK(dE = this.getDihedEnergy())) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Dihedral energy failed;");
                }
                this.reportCorrupted();
            }
            E[2] = dE;
            if (dodebug) {
                this.debug.decLevel();
                this.debug.println("dE = " + dE);
            }
            if (dodebug) {
                this.debug.incLevel("Inversion");
            }
            E[3] = dE = this.getInversionEnergy();
            if (!U.isDoubleOK(dE)) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Inversion energy failed;");
                }
                this.reportCorrupted();
            }
            if (dodebug) {
                this.debug.decLevel();
                this.debug.println("dE = " + dE);
            }
            if (dodebug) {
                this.debug.incLevel("VdW");
            }
            E[4] = dE = this.getVdWEnergy();
            if (!U.isDoubleOK(dE)) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("VdW energy failed;");
                }
                this.reportCorrupted();
            }
            if (dodebug) {
                this.debug.decLevel();
                this.debug.println("dE = " + dE);
            }
            if (dodebug) {
                this.debug.incLevel("HBond");
            }
            if (!U.isDoubleOK(dE = this.getHydBondEnergy())) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("H-Bond energy failed;");
                }
                this.reportCorrupted();
            }
            E[5] = dE;
            if (dodebug) {
                this.debug.decLevel();
                this.debug.println("dE = " + dE);
            }
            if (dodebug) {
                int i;
                this.debug.incLevel("Actual analitical derivatives");
                for (i = 0; i < this.Deriv.length; ++i) {
                    for (int j3 = 0; j3 < this.Deriv[i].length; ++j3) {
                        this.debug.println("" + this.Deriv[i][j3]);
                    }
                }
                this.debug.decLevel();
                this.debug.incLevel("Allbonds");
                for (i = 0; i < this.bAtom1.length; ++i) {
                    this.debug.printVector(this.AllBonds[i]);
                    this.debug.printVector(this.AllNormalizedBonds[i]);
                }
                this.debug.decLevel();
            }
            return E;
        }
    }

    public static interface MolCT {
        public int[] getAtomNumberScratch();

        public double[][] getAtomLocalCoordinateScratch();

        public double[] getAtomCoordinateScratch();

        public double[][] getLocalDerivateScratch();

        public void askLocalCoordinates(int var1);

        public void askCoordinates(int var1);

        public void setCoordinates(int var1);

        public void derivateUpdatedNotification();

        public int[] getAtomNumbers();

        public int[] getBondOrders();

        public int[] getBAtom1();

        public int[] getBAtom2();

        public int[][] getCtab();

        public int[][] getBOlist();

        public int[][] getBList();

        public int getBond(int var1, int var2);
    }

    public static class MMOptimization
    implements Optimization.FunctionOptimization {
        public debugPrintout debug = null;
        MolCT mol = null;
        double[] atomCoords = null;
        public Dreiding MM = null;
        int nAtoms = 0;
        int nDim = 0;
        double[] var;
        double[] grad;
        public double dX = 1.0E-6;
        double scale = 0.0015936001019904065;
        Pinger molUpdatePing = null;
        Pinger functEvalPing = null;

        public MMOptimization(Dreiding dreiding, debugPrintout debug) {
            this.debug = debug;
            boolean mydodebug = dodebug;
            if (mydodebug) {
                debug.println("MMOptimization constructor invoked.");
            }
            this.mol = dreiding.getMol();
            this.atomCoords = this.mol.getAtomCoordinateScratch();
            if (mydodebug) {
                debug.println("Atomic numbers:");
                debug.printVector(this.mol.getAtomNumbers());
            }
            this.MM = dreiding;
            this.nAtoms = this.mol.getAtomNumbers().length;
            this.nDim = this.atomCoords.length;
        }

        public MMOptimization(MolCT molFrag, debugPrintout debugClass) {
            this.debug = debugClass;
            boolean mydodebug = dodebug;
            if (mydodebug) {
                this.debug.println("MMOptimization constructor invoked.");
            }
            this.mol = molFrag;
            this.atomCoords = this.mol.getAtomCoordinateScratch();
            if (mydodebug) {
                this.debug.println("Atomic numbers:");
                this.debug.printVector(this.mol.getAtomNumbers());
            }
            if (mydodebug) {
                this.debug.incLevel("Invoke Dreiding constructor.");
            }
            this.MM = new Dreiding(this.mol, this.debug);
            if (mydodebug) {
                this.debug.decLevel();
            }
            this.nAtoms = this.mol.getAtomNumbers().length;
            this.nDim = this.atomCoords.length;
        }

        public void UpdateCoords() {
            if (dodebug && this.debug != null) {
                this.debug.println("Before update");
            }
            if (this.molUpdatePing != null) {
                this.molUpdatePing.ping();
            }
            if (dodebug && this.debug != null) {
                this.debug.incLevel("New coordinates:");
                this.debug.Tstart();
                this.debug.Trow();
                this.debug.TprintBC("Atom");
                this.debug.TprintBC("Old");
                this.debug.TprintBC("New");
            }
            for (int i = 0; i < this.nAtoms; ++i) {
                int j;
                String oc = "";
                String nc = "";
                if (dodebug && this.debug != null) {
                    this.mol.askCoordinates(i);
                    for (j = 0; j < this.nDim; ++j) {
                        oc = oc + TextUtils.formatNumber(this.atomCoords[j]) + " ";
                    }
                }
                for (j = 0; j < this.nDim; ++j) {
                    this.atomCoords[j] = this.var[i * this.nDim + j];
                    this.mol.setCoordinates(i);
                    if (!dodebug || this.debug == null) continue;
                    nc = nc + TextUtils.formatNumber(this.atomCoords[j]) + " ";
                }
                if (!dodebug || this.debug == null) continue;
                this.debug.Trow();
                this.debug.TprintBC(i);
                this.debug.Tprint(oc);
                this.debug.Tprint(nc);
            }
            if (dodebug && this.debug != null) {
                this.debug.Tstop();
                this.debug.decLevel();
            }
            if (dodebug && this.debug != null) {
                this.debug.println("After update");
            }
            if (this.molUpdatePing != null) {
                this.molUpdatePing.ping();
            }
        }

        public void setMolUpdatePing(Pinger molUpdatePing) {
            this.molUpdatePing = molUpdatePing;
        }

        public void setFunctEvalPing(Pinger functEvalPing) {
            this.functEvalPing = functEvalPing;
        }

        @Override
        public double GetFunction(BitSet funcFlags) {
            if (this.functEvalPing != null) {
                this.functEvalPing.ping();
            }
            if (dodebug && this.debug != null) {
                this.debug.incLevel("Function evaluation:");
            }
            BitSet fFlags = funcFlags;
            double fValue = 0.0;
            if (fFlags.get(3)) {
                this.UpdateCoords();
            }
            if (fFlags.get(0) && fFlags.get(1) && !fFlags.get(2)) {
                if (dodebug && this.debug != null) {
                    this.debug.println("Get the energy and the analytic gradients");
                }
                fValue = this.MM.getEnergy(fFlags.get(1));
                this.setAnaliticGradients();
            } else if (fFlags.get(0)) {
                if (dodebug && this.debug != null) {
                    this.debug.println("Get the energy no gradient");
                }
                fValue = this.MM.getEnergy();
            } else if (fFlags.get(1) && !fFlags.get(2)) {
                fValue = this.MM.getEnergy(fFlags.get(1));
                this.setAnaliticGradients();
                if (dodebug && this.debug != null) {
                    this.debug.println("Get the analytic gradient, no energy");
                }
            }
            if (fFlags.get(1) && fFlags.get(2)) {
                if (dodebug && this.debug != null) {
                    this.debug.println("Numeric gradient started");
                }
                this.NumericGradients();
            }
            if (dodebug && this.debug != null) {
                this.debug.decLevel();
            }
            return fValue * this.scale;
        }

        public void AnaliticGradients(double[][] anal) {
            for (int il = 0; il < this.mol.getAtomNumbers().length; ++il) {
                for (int jl = 0; jl < 3; ++jl) {
                    anal[il][jl] = this.MM.Deriv[il][jl] * this.scale;
                }
            }
        }

        public void setAnaliticGradients() {
            for (int il = 0; il < this.mol.getAtomNumbers().length; ++il) {
                for (int jl = 0; jl < 3; ++jl) {
                    int k = il * 3 + jl;
                    this.grad[k] = this.MM.Deriv[il][jl] * this.scale;
                }
            }
        }

        public void CompareGradients(double[][] anal) {
            if (dodebug && this.debug != null) {
                int l = this.mol.getAtomNumbers().length * 3;
                l = 3;
                double[][] output = new double[l][3];
                this.debug.incLevel("Gradients");
                this.debug.println("Numeric / Analitic / Diff ");
                double v = 0.0;
                double[] s = new double[3];
                double[] sn = new double[3];
                int k = 0;
                for (int i = 0; i < this.mol.getAtomNumbers().length; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        k = i * 3 + j;
                        s[j] = s[j] + anal[i][j];
                        sn[j] = sn[j] + this.grad[k];
                        v = this.grad[k] - anal[i][j];
                        output[j][0] = this.grad[k];
                        output[j][1] = anal[i][j];
                        output[j][2] = v;
                    }
                    this.debug.printMatrix(output);
                }
                this.debug.printHR();
                this.debug.println("summs (anal):" + s[0] + " " + s[1] + " " + s[2]);
                this.debug.println("summs (numer):" + sn[0] + " " + sn[1] + " " + sn[2]);
                this.debug.decLevel();
            }
            double v = 0.0;
            double v2 = 0.0;
            int k = 0;
            System.err.println("Anal / Num / Diff ");
            for (int i = 0; i < this.mol.getAtomNumbers().length; ++i) {
                for (int j = 0; j < 3; ++j) {
                    k = i * 3 + j;
                    v = anal[i][j] - this.grad[k];
                    v2 += v;
                    System.err.println(" " + anal[i][j] + " " + this.grad[k] + " " + v);
                }
            }
            System.err.println("summ: " + v2);
            System.exit(0);
        }

        public void MvGrad(double[][] anal) {
            int k = 0;
            for (int it = 0; it < this.mol.getAtomNumbers().length; ++it) {
                for (int jt = 0; jt < 3; ++jt) {
                    k = it * 3 + jt;
                    this.grad[k] = anal[it][jt];
                    System.err.println("" + k + ". " + this.grad[k]);
                }
            }
        }

        public void NumericGradients() {
            boolean debugLevel = false;
            if (dodebug) {
                this.debug.incLevel("Numeric gradient evaluation:");
            }
            double E1 = 0.0;
            double E2 = 0.0;
            for (int i = 0; i < this.nAtoms; ++i) {
                this.mol.askCoordinates(i);
                for (int j = 0; j < this.nDim; ++j) {
                    int n = j;
                    this.atomCoords[n] = this.atomCoords[n] + this.dX;
                    this.mol.setCoordinates(i);
                    if (dodebug) {
                        this.debug.incLevel("getEnergy, E1");
                    }
                    E1 = this.MM.getEnergy(i);
                    if (dodebug) {
                        this.debug.decLevel();
                    }
                    int n2 = j;
                    this.atomCoords[n2] = this.atomCoords[n2] - 2.0 * this.dX;
                    this.mol.setCoordinates(i);
                    if (dodebug) {
                        this.debug.incLevel("getEnergy, E2");
                    }
                    E2 = this.MM.getEnergy(i);
                    if (dodebug) {
                        this.debug.decLevel();
                    }
                    int n3 = j;
                    this.atomCoords[n3] = this.atomCoords[n3] + this.dX;
                    this.mol.setCoordinates(i);
                    this.grad[i * this.nDim + j] = (E1 - E2) / (2.0 * this.dX) * this.scale;
                }
            }
            if (dodebug) {
                this.debug.decLevel();
            }
        }

        @Override
        public double[] getGradientsScratch() {
            if (this.grad == null) {
                this.grad = new double[this.nAtoms * this.nDim];
            }
            if (dodebug) {
                this.debug.printVector(this.grad);
            }
            return this.grad;
        }

        public void initVar() {
            if (this.var == null) {
                System.err.println("Invalid var init request");
                throw new UnsupportedOperationException();
            }
            for (int i = 0; i < this.nAtoms; ++i) {
                for (int j = 0; j < this.nDim; ++j) {
                    this.mol.askCoordinates(i);
                    this.var[i * this.nDim + j] = this.atomCoords[j];
                }
            }
        }

        @Override
        public double[] getVariablesScratch() {
            if (this.var == null) {
                this.var = new double[this.nAtoms * this.nDim];
            }
            if (dodebug) {
                this.debug.incLevel("Starting coordinates:");
            }
            for (int i = 0; i < this.nAtoms; ++i) {
                for (int j = 0; j < this.nDim; ++j) {
                    this.mol.askCoordinates(i);
                    this.var[i * this.nDim + j] = this.atomCoords[j];
                }
                if (!dodebug) continue;
                this.debug.printVector(this.atomCoords);
            }
            if (dodebug) {
                this.debug.decLevel();
            }
            return this.var;
        }

        @Override
        public debugPrintout getDebug() {
            return this.debug;
        }

        @Override
        public int GetBlockSize() {
            return this.nDim;
        }

        @Override
        public double GetXFunction(double x, double[] direction) {
            BitSet flags = new BitSet(4);
            flags.set(0);
            for (int i = 0; i < this.var.length; ++i) {
                int n = i;
                this.var[n] = this.var[n] + x * direction[i];
            }
            this.UpdateCoords();
            double fx = this.GetFunction(flags);
            for (int i = 0; i < this.var.length; ++i) {
                int n = i;
                this.var[n] = this.var[n] - x * direction[i];
            }
            this.UpdateCoords();
            return fx;
        }

        @Override
        public double GetDFunction(double x, double[] direction) {
            double fx1 = this.GetXFunction(x + this.dX, direction);
            double fx2 = this.GetXFunction(x - this.dX, direction);
            return (fx1 - fx2) / (2.0 * this.dX);
        }
    }

    public static class DreidingEqn {
        public static double Bond(int Type1, int Type2) {
            return DreidingParms.BondRadius[Type1] + DreidingParms.BondRadius[Type2] - DreidingParms.bond_delta;
        }

        public static void Bond(int Type1, int Type2, int order, double R, double[] E) {
            E[0] = 0.0;
            E[1] = 0.0;
            int a_default = DreidingParms.a_default;
            double unknownFactor = 1.0;
            if (Type1 == a_default || Type2 == a_default) {
                unknownFactor = DreidingParms.defaultscale;
            }
            double Re = DreidingParms.BondRadius[Type1] + DreidingParms.BondRadius[Type2] - DreidingParms.bond_delta;
            double k = DreidingParms.bond_K * ((double)order / 2.0) * unknownFactor;
            E[0] = 0.5 * k * (R - Re) * (R - Re);
            E[1] = k * (R - Re);
        }

        public static void AngleCosE(int Type2, double cosang, double[] E) {
            E[0] = 0.0;
            E[1] = 0.0;
            double cosAng0 = DreidingParms.CosAngle[Type2];
            double SinAngSq = 1.0 - cosang * cosang;
            double sinang = Math.sqrt(SinAngSq);
            double unknownFactor = 1.0;
            int a_default = DreidingParms.a_default;
            if (Type2 == a_default) {
                unknownFactor = DreidingParms.defaultAngleScale;
            }
            double K = DreidingParms.angle_K * unknownFactor;
            double x = 0.0;
            if (cosAng0 == -1.0) {
                E[0] = K * (1.0 + cosang);
                E[1] = -1.0 * K * sinang;
            } else {
                double SinAngSq0 = 1.0 - cosAng0 * cosAng0;
                double C = K / SinAngSq0;
                x = cosang - cosAng0;
                E[0] = 0.5 * C * x * x;
                E[1] = -1.0 * C * x * sinang;
            }
        }

        public static void AngleE(int Type2, double angle, int a1, int a2, int a3, double[] E) {
            E[0] = 0.0;
            E[1] = 0.0;
            double angle0 = DreidingParms.AngleInRadian[Type2];
            double unknownFactor = 1.0;
            int a_default = DreidingParms.a_default;
            if (Type2 >= a_default) {
                unknownFactor = DreidingParms.defaultAngleScale;
            }
            double K = DreidingParms.angle_K * unknownFactor;
            double x = angle - angle0;
            debugPrintout debug = CleanArgs.getDebug();
            if (debug != null) {
                debug.println("K=" + K + " x=" + x);
            }
            E[0] = 0.5 * K * x * x;
            E[1] = K * x;
        }

        public static boolean GetArom(int atomi, int atomj) {
            return atomi == DreidingParms.a_C_R && atomj == DreidingParms.a_C_R || atomi == DreidingParms.a_C_R && atomj == DreidingParms.a_N_R || atomi == DreidingParms.a_N_R && atomj == DreidingParms.a_C_R || atomi == DreidingParms.a_N_R && atomj == DreidingParms.a_N_R;
        }

        public static void Torsion(int atomi, int atomj, int atomk, int atoml, int Border2, double psi, int ntors, double[] E) {
            double psi0 = 0.0;
            double V2 = 0.0;
            int n = 0;
            E[0] = 0.0;
            E[1] = 0.0;
            double Hybr_i = DreidingParms.Hybr[atomi];
            double Hybr_j = DreidingParms.Hybr[atomj];
            double Hybr_k = DreidingParms.Hybr[atomk];
            double Hybr_l = DreidingParms.Hybr[atoml];
            boolean Ocol_j = DreidingParms.Ocol[atomj];
            boolean Ocol_k = DreidingParms.Ocol[atomk];
            if (Hybr_j + Hybr_k == 6.0) {
                if (Ocol_j && Ocol_k) {
                    V2 = DreidingParms.Tors3O3OV;
                    n = DreidingParms.Tors3O3ON;
                    psi0 = DreidingParms.Tors3O3OPsi_rad;
                } else {
                    V2 = DreidingParms.Tors33V;
                    n = DreidingParms.Tors33N;
                    psi0 = DreidingParms.Tors33Psi_rad;
                }
            }
            if (Hybr_j + Hybr_k == 5.0) {
                if (Hybr_i == 2.0 && Hybr_j == 2.0 || Hybr_l == 2.0 && Hybr_k == 2.0) {
                    V2 = DreidingParms.Tors23V;
                    n = DreidingParms.Tors23N;
                    psi0 = DreidingParms.Tors23Psi_rad;
                    if (Ocol_j && Hybr_j == 3.0 && !Ocol_k || Ocol_k && Hybr_k == 3.0 && !Ocol_j) {
                        V2 = DreidingParms.Tors3O2V;
                        n = DreidingParms.Tors3O2N;
                        psi0 = DreidingParms.Tors3O2Psi_rad;
                    }
                } else {
                    V2 = DreidingParms.Tors332V;
                    n = DreidingParms.Tors332N;
                    psi0 = DreidingParms.Tors332Psi_rad;
                }
            }
            if (Hybr_j == 2.0 && Hybr_k == 2.0) {
                switch (Border2) {
                    case 4: {
                        V2 = DreidingParms.Tors22V;
                        n = DreidingParms.Tors22N;
                        psi0 = DreidingParms.Tors22Psi_rad;
                        break;
                    }
                    case 3: {
                        V2 = DreidingParms.Tors22resV;
                        n = DreidingParms.Tors22resN;
                        psi0 = DreidingParms.Tors22resPsi_rad;
                        break;
                    }
                    case 2: {
                        boolean BothAromatic = DreidingEqn.GetArom(atomi, atomj);
                        if (BothAromatic) {
                            V2 = DreidingParms.Tors22sinArV;
                            n = DreidingParms.Tors22sinArN;
                            psi0 = DreidingParms.Tors22sinArPsi_rad;
                            break;
                        }
                        V2 = DreidingParms.Tors22sinV;
                        n = DreidingParms.Tors22sinN;
                        psi0 = DreidingParms.Tors22sinPsi_rad;
                    }
                }
            }
            int a_default = DreidingParms.a_default;
            double unknownFactor = 1.0;
            if (atomj == a_default || atomk == a_default) {
                unknownFactor = DreidingParms.defaultscale;
                V2 = DreidingParms.Tors3O3OV;
                n = DreidingParms.Tors3O3ON;
                psi0 = DreidingParms.Tors3O3OPsi;
            }
            E[0] = 0.5 * (V2 *= unknownFactor) / (double)ntors * (1.0 - Math.cos((double)n * (psi - psi0)));
            E[1] = 0.5 * V2 / (double)ntors * (double)n * Math.sin((double)n * (psi - psi0));
        }

        public static void Inversion(int atomi, double CosInv, double SinInv, double[] E) {
            E[0] = 0.0;
            E[1] = 0.0;
            if (atomi == DreidingParms.a_C_31) {
                double C = DreidingParms.invC;
                double CosPsi0 = DreidingParms.invCcosPsi0;
                double x = CosInv - CosPsi0;
                E[0] = 0.5 * C * x * x;
                E[1] = -1.0 * C * x * SinInv;
            } else {
                double K = DreidingParms.invK;
                E[0] = K * (1.0 - CosInv);
                E[1] = K * SinInv;
            }
        }

        public static double intPow(double a, int e) {
            double r = 1.0;
            int ee = Math.abs(e);
            for (int i = 0; i < ee; ++i) {
                r *= a;
            }
            return e > 0 ? r : 1.0 / r;
        }

        public static void vDW(int atomi, int atomj, double r, double[] E) {
            double r0;
            double D0;
            ++Clean3D.OPT_counter_dreidingvdwcount;
            E[0] = 0.0;
            E[1] = 0.0;
            if (atomi == atomj) {
                D0 = DreidingParms.vdWD0[atomi];
                r0 = DreidingParms.vdWR0[atomi];
            } else {
                D0 = Math.sqrt(DreidingParms.vdWD0[atomi] * DreidingParms.vdWD0[atomj]);
                r0 = (DreidingParms.vdWR0[atomi] + DreidingParms.vdWR0[atomj]) / 2.0;
            }
            double ro = r / r0;
            E[0] = D0 * (DreidingEqn.intPow(ro, -12) - 2.0 * DreidingEqn.intPow(ro, -6));
            E[1] = D0 * (2.0 * (6.0 * DreidingEqn.intPow(r0, 6) / DreidingEqn.intPow(r, 7)) - 12.0 * DreidingEqn.intPow(r0, 12) / DreidingEqn.intPow(r, 13));
            if (!(!CleanArgs.doVerbose() || U.isDoubleOK(E[0]) && U.isDoubleOK(E[1]))) {
                CleanArgs.verbose("VDW r=" + r + " ro=" + ro + " r0=" + r0 + " E[0]=" + E[0] + " E[1]=" + E[1]);
            }
        }

        public static void vDWexp(int atomi, int atomj, double r, double[] E) {
            double khi0;
            double r0;
            double D0;
            E[0] = 0.0;
            E[1] = 0.0;
            ++Clean3D.OPT_counter_dreidingvdwcount;
            if (atomi == atomj) {
                D0 = DreidingParms.vdWD0[atomi];
                r0 = DreidingParms.vdWR0[atomi];
                khi0 = DreidingParms.vdWKhi0[atomi];
            } else {
                D0 = Math.sqrt(DreidingParms.vdWD0[atomi] * DreidingParms.vdWD0[atomj]);
                r0 = Math.sqrt(DreidingParms.vdWR0[atomi] * DreidingParms.vdWR0[atomj]);
                khi0 = (DreidingParms.vdWKhi0[atomi] + DreidingParms.vdWKhi0[atomj]) / 2.0;
            }
            double ro = r / r0;
            double x1 = 6.0 / (khi0 - 6.0);
            double x2 = khi0 / (khi0 - 6.0);
            double exp = Math.exp(khi0 * (1.0 - ro));
            E[0] = D0 * (x1 * exp - x2 * DreidingEqn.intPow(ro, -6));
            E[1] = D0 * (6.0 * x2 * DreidingEqn.intPow(ro, -7) / r0 - exp * khi0 * x1 / r0);
        }

        public static void Hbond(double Rda, double cosDha, double[] E) {
            E[0] = 0.0;
            E[1] = 0.0;
            E[2] = 0.0;
            double Dhb = DreidingParms.HydDhb;
            double Rhb = DreidingParms.HydRhb;
            double x = Rhb / Rda;
            double sinDha = Math.sqrt(1.0 - cosDha * cosDha);
            E[0] = Dhb * (5.0 * DreidingEqn.intPow(x, 12) - 6.0 * DreidingEqn.intPow(x, 10)) * DreidingEqn.intPow(cosDha, 4);
            E[1] = Dhb * 60.0 * (DreidingEqn.intPow(Rhb, 10) / DreidingEqn.intPow(Rda, 11) - DreidingEqn.intPow(Rhb, 12) / DreidingEqn.intPow(Rda, 13)) * DreidingEqn.intPow(cosDha, 4);
            E[2] = -4.0 * Dhb * (-6.0 * DreidingEqn.intPow(x, 10) + 5.0 * DreidingEqn.intPow(x, 12)) * DreidingEqn.intPow(cosDha, 3) * sinDha;
        }
    }
}

