/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.clean;

import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.TextUtils;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.linalg.V;
import chemaxon.marvin.modelling.util.SimpleCanceller;
import chemaxon.marvin.modelling.util.U;
import java.util.BitSet;

public class Optimization {
    static final int NO_SET_OPT_METHOD = -1;
    static final int DO_IS_OPT = 1;
    static final int DIAG_HESSIAN = 2;
    static final int IS_BDIAG_H = 4;
    static final int DO_RFO = 8;
    static final int DO_ELS = 16;
    static final int DO_CG = 32;
    public static final int OLD_OPT_TO_USE = 48;
    public static final int NEW_OPT_TO_USE = 1;
    static final int DEFAULT_OPT_METHOD = 48;
    static int OPT_TO_USE = 48;
    static double DEFAULT_FTOL = 0.001;
    static final double zeroLimit = 1.0E-7;
    static final double goldCut = 1.618034;
    static debugPrintout debug;
    SimpleCanceller canceller = null;
    boolean Debug = true;
    boolean Use_Derivatives = true;
    boolean Time_Check = false;
    private long Time_Limit = 50000L;
    int ITMAX_frprmin = 5000;
    private int ITMAX_brent = 100;
    static int M_STORE;
    public int laststepcount = -1;
    double GRADIENT_LENGTH_LIMIT = 0.1;
    double[] coordinates;
    double[] var = null;
    double[] grad = null;
    BitSet funcFlags = null;
    FunctionOptimization funct = null;

    public FunctionOptimization getFunct() {
        return this.funct;
    }

    public Optimization() {
    }

    public Optimization(FunctionOptimization functInterface) {
        this.funcFlags = new BitSet(4);
        this.funct = functInterface;
        this.var = this.funct.getVariablesScratch();
        this.grad = this.funct.getGradientsScratch();
        debug = this.funct.getDebug();
        if (debug != null && debug.getWillPrint()) {
            debug.println("Optimization has been initialized");
        }
    }

    public Optimization(FunctionOptimization functInterface, SimpleCanceller canceller) {
        this.funcFlags = new BitSet(4);
        this.funct = functInterface;
        this.var = this.funct.getVariablesScratch();
        this.grad = this.funct.getGradientsScratch();
        debug = this.funct.getDebug();
        this.canceller = canceller;
        if (debug != null && debug.getWillPrint()) {
            debug.println("Optimization has been initialized");
        }
    }

    public double[] findMin(long itime) {
        double FTOL = 1.0E-10;
        int[] iter = new int[]{0};
        this.frprmin(this.coordinates, FTOL, iter, itime);
        return this.coordinates;
    }

    public double GradOpt(int methodFlag, double ftol, long itime) {
        int[] iter = new int[]{0};
        return this.GradOpt(methodFlag, ftol, iter, itime);
    }

    public double GradOpt(int methodFlag, long itime) {
        double ftol = DEFAULT_FTOL;
        int[] iter = new int[]{0};
        return this.GradOpt(methodFlag, ftol, iter, itime);
    }

    public double GradOpt(long itime) {
        int methodFlag = 48;
        double ftol = DEFAULT_FTOL;
        int[] iter = new int[]{0};
        return this.GradOpt(methodFlag, ftol, iter, itime);
    }

    public double GradOpt(int methodFlag) {
        long itime = 0L;
        double ftol = DEFAULT_FTOL;
        int[] iter = new int[]{0};
        return this.GradOpt(methodFlag, ftol, iter, itime);
    }

    public double GradOpt(int methodFlag, double ftol) {
        long itime = 0L;
        int[] iter = new int[]{0};
        return this.GradOpt(methodFlag, ftol, iter, itime);
    }

    public double GradOpt() {
        long itime = 0L;
        int methodFlag = 48;
        double ftol = DEFAULT_FTOL;
        int[] iter = new int[]{0};
        return this.GradOpt(methodFlag, ftol, iter, itime);
    }

    public double GradOpt(int methodFlag, double ftol, int[] iter, long itime) {
        int bDim = this.funct.GetBlockSize();
        double fval = 0.0;
        if (debug != null && debug.getWillPrint()) {
            debug.println("Starting values of the variables");
        }
        if (debug != null && debug.getWillPrint()) {
            debug.printVector(this.var);
        }
        if (methodFlag == -1) {
            methodFlag = 48;
        }
        double[] var0 = (double[])this.var.clone();
        try {
            return this.ISOpt(ftol, iter, itime);
        }
        catch (Exception e) {
            if (CleanArgs.verboseLevel > 0) {
                CleanArgs.verbose("Error in ISOpt");
                CleanArgs.verbose(e.getMessage());
            }
            for (int i = 0; i < this.var.length; ++i) {
                this.var[i] = var0[i];
            }
            return Double.NaN;
        }
    }

    double frprmin(double[] p, double ftol, int[] iter, long itime) {
        int i;
        double fp;
        double EPS = 1.0E-10;
        double fret = 0.0;
        double eMin = fp = this.f(p);
        int n = p.length;
        double[] g = new double[n];
        double[] xi = new double[n];
        double[] h = new double[n];
        double[] xmintol = new double[2];
        double sc = 1.0;
        xi = this.df(p);
        for (i = 0; i < n; ++i) {
            g[i] = -xi[i];
            xi[i] = h[i] = g[i];
        }
        for (i = 0; i < this.ITMAX_frprmin; ++i) {
            int j;
            if (this.Time_Check && System.currentTimeMillis() - this.Time_Limit > itime) {
                if (this.Debug) {
                    debug.println("Time limit reached in Optimization.");
                }
                i = this.ITMAX_frprmin;
            }
            iter[0] = i;
            boolean cGradFailed = false;
            if (this.Use_Derivatives) {
                double stepLimit = 0.1;
                double norm = sc * Math.sqrt(this.dot(xi, xi) / (double)n);
                sc *= Math.min(1.0, stepLimit / norm);
                int ii = 0;
                while (ii < n) {
                    int n2 = ii++;
                    xi[n2] = xi[n2] * sc;
                }
                fret = this.lineSearch(p, xi, xmintol);
                sc *= xmintol[0];
                ii = 0;
                while (ii < n) {
                    int n3 = ii++;
                    xi[n3] = xi[n3] * xmintol[0];
                }
                norm = Math.sqrt(this.dot(xi, xi) / (double)n);
                double sc1 = Math.min(1.0, stepLimit / norm);
                for (int ii2 = 0; ii2 < n; ++ii2) {
                    int n4 = ii2;
                    p[n4] = p[n4] + sc1 * xi[ii2];
                }
                sc *= sc1;
            } else {
                fret = this.linmin(p, xi);
            }
            cGradFailed = eMin - fp <= EPS || (iter[0] + 1) % 25 == 0;
            eMin = Math.min(eMin, fp);
            fp = this.f(p);
            xi = this.df(p);
            double gg = 0.0;
            double dgg = 0.0;
            for (j = 0; j < n; ++j) {
                gg += g[j] * g[j];
                dgg += (xi[j] + g[j]) * xi[j];
            }
            if (Math.sqrt(gg / (double)n) < ftol) {
                return fret;
            }
            double gam = dgg / gg;
            for (j = 0; j < n; ++j) {
                g[j] = -xi[j];
                if (cGradFailed) {
                    gam = 0.0;
                }
                xi[j] = h[j] = g[j] + gam * h[j];
            }
        }
        if (this.Debug) {
            debug.println(" Iteration limit reached in frprmn");
        }
        return fp;
    }

    double ISOpt(double ftol, int[] iter, long itime) {
        if (debug != null && debug.getWillPrint()) {
            debug.incLevel("empty");
        }
        debugPrintout debugL = CleanArgs.getDebug();
        double EPS = 1.0E-10;
        double fret = 0.0;
        double fp = 0.0;
        int n = this.var.length;
        int mStore = 6;
        boolean doRFO = false;
        boolean checkEigVal = true;
        double ovlLimit = 0.95;
        double gPOrthLimit = 0.9;
        double gPOrthTightLimit = 0.01;
        double stepLimit = 0.1;
        double[] var0 = new double[n];
        double[] dVar = new double[n];
        double[] step = new double[n];
        double[] dG = new double[n];
        boolean doConjugateStep = true;
        boolean doMDSStep = false;
        int minCoeffInd = 0;
        Optimization.VectCopy(this.var, var0);
        BitSet gxType = new BitSet(4);
        gxType.set(3);
        VectorSet gxSet = new VectorSet(2 * mStore, n, gxType);
        int[] gInd = new int[mStore];
        int[] xInd = new int[mStore];
        for (int i = 0; i < mStore; ++i) {
            xInd[i] = 2 * i;
            gInd[i] = 2 * i + 1;
        }
        VectorSubSet gSet = new VectorSubSet(gxSet, 0, gInd);
        VectorSubSet xSet = new VectorSubSet(gxSet, 0, xInd);
        this.funcFlags.set(3);
        this.funcFlags.set(0);
        this.funcFlags.set(1);
        fp = this.funct.GetFunction(this.funcFlags);
        double eMin = 0.0;
        double e0 = 0.0;
        int workingSpaceStart = workingSpace.wEnd;
        for (int it = 0; it < this.ITMAX_frprmin; ++it) {
            String s;
            int ind0;
            this.laststepcount = it;
            fp = this.funct.GetFunction(this.funcFlags);
            if (debugL != null) {
                debugL.println("Energy: " + fp);
                debugL.println("Gradient=");
                debugL.printVector(this.grad);
            }
            if (it == 0) {
                eMin = fp;
            }
            double gLen = Optimization.VDot(n, this.grad, 0, this.grad, 0);
            if ((gLen = Math.sqrt(gLen / (double)n)) < 1.0E-7) {
                if (debug != null && debug.getWillPrint()) {
                    debug.decLevel("Iteration: " + it + "Final energy: " + fp);
                }
                return fp;
            }
            if (doConjugateStep) {
                gSet.InsertVector(this.grad, 0);
            } else {
                gSet.ChangeVector(minCoeffInd, this.grad, 0);
                ind0 = gSet.vInd[minCoeffInd];
                gSet.vInd[minCoeffInd] = gSet.vInd[0];
                gSet.vInd[0] = ind0;
            }
            if (gSet.nVec == mStore && gSet.vInd[0] == 1) {
                Optimization.VectSubstract(var0, this.var, var0);
                for (int j = 0; j < xSet.nVec; ++j) {
                    xSet.vSetVectAdd(j, var0);
                }
                Optimization.VectCopy(this.var, var0);
            }
            Optimization.VectSubstract(this.var, var0, dVar);
            if (doConjugateStep) {
                xSet.InsertVector(dVar, 0);
            } else {
                xSet.ChangeVector(minCoeffInd, dVar, 0);
                ind0 = xSet.vInd[minCoeffInd];
                xSet.vInd[minCoeffInd] = xSet.vInd[0];
                xSet.vInd[0] = ind0;
            }
            double dERatio = 0.0;
            if (it > 0) {
                Optimization.VectAdd(n, gSet.vSet.vSet[gSet.vInd[0]], gSet.vSet.vShft[gSet.vInd[0]], gSet.vSet.vSet[gSet.vInd[1]], gSet.vSet.vShft[gSet.vInd[1]], dG, 0);
                Optimization.VectScale(n, dG, 0, 0.5, dG, 0);
                Optimization.VectSubstract(n, xSet.vSet.vSet[xSet.vInd[0]], xSet.vSet.vShft[xSet.vInd[0]], xSet.vSet.vSet[xSet.vInd[1]], xSet.vSet.vShft[xSet.vInd[1]], step, 0);
                double stepLen = Math.sqrt(Optimization.VDot(n, step, 0, step, 0));
                double dEPred = Optimization.VDot(n, dG, 0, step, 0);
                double dE = fp - e0;
                dERatio = 1.0;
                if (Math.abs(dEPred) > 1.0E-7) {
                    dERatio = dE / dEPred;
                }
                boolean bl = doMDSStep = dERatio > 0.3;
                if (dERatio < 0.3 || dE > 0.0) {
                    stepLimit /= 1.618034;
                } else if (dERatio > Math.sqrt(2.0) / 2.0) {
                    stepLimit = dERatio > 0.9 && dERatio < 1.1 ? (stepLimit *= 1.618034) : (stepLimit *= 1.1);
                }
                if (doConjugateStep) {
                    stepLimit = Math.min(3.0 * stepLen, stepLimit);
                }
                stepLimit = Math.max(stepLimit, 0.001);
            }
            double gCos = -1.0;
            double eLowest = 0.0;
            int nRank = 0;
            boolean symmHess = true;
            boolean doGDIIS = true;
            if (doMDSStep) {
                SubSpace xSS = new SubSpace(xSet);
                VectorSet gSSC = new VectorSet(xSS.vSet.nVec, xSS.vSet.vLen, xSS.vSet.vMtr);
                for (int i = 0; i < gSSC.nVec; ++i) {
                    for (int j = 1; j < gSSC.vLen; j += 2) {
                        gSSC.vSet[i][gSSC.vShft[i] + j] = xSS.vSet.vSet[i][xSS.vSet.vShft[i] + j - 1];
                    }
                }
                SubSpace gSS = new SubSpace(gSet, gSSC);
                Matrix MDS_H = Optimization.MDot(gSS.vSet, xSS.vSet);
                MDS_H.Diagonalize(1.0E-7, ovlLimit);
                nRank = MDS_H.nRank;
                if (MDS_H.nRank > 0) {
                    eLowest = MDS_H.aEVa.getElement(0, 0);
                    symmHess = MDS_H.aREV == MDS_H.aLEV;
                    double[] gSub = xSS.Components(this.grad);
                    double Lambda2 = 0.0;
                    doRFO = eLowest < 0.001 && MDS_H.nRank > 0;
                    double[] sSub = this.NR_RFO_TRM_Step(MDS_H, gSub, null, Lambda2, checkEigVal, 0.0, 0.0, doRFO);
                    dVar = xSS.LinComb(gSub, 0, dVar, 0);
                    double dGLen = Math.sqrt(Optimization.VDot(n, dVar, 0, dVar, 0) / (double)n);
                    gCos = dGLen / gLen;
                    doConjugateStep = gCos <= gPOrthLimit;
                    doConjugateStep = doConjugateStep && eLowest > 0.0;
                    doConjugateStep = doConjugateStep && (fp <= eMin || gCos <= gPOrthTightLimit);
                    eMin = Math.min(fp, eMin);
                    dVar = xSS.LinComb(sSub, 0, dVar, 0);
                    double[] sCC = Optimization.VectCompress(xSS.vSSet.nVec, xSS.vSSet.vInd, null, 0, Optimization.VLinComb(sSub, xSS.vSet), 0);
                    sCC[0] = sCC[0] + 1.0;
                    sCC[0] = sCC[0] - 1.0;
                    Optimization.VectCopy(n, dVar, 0, step, 0);
                    double sLen = Math.sqrt(Optimization.VDot(n, step, 0, step, 0));
                    if (sLen > stepLimit) {
                        double Sc = stepLimit / sLen;
                        Optimization.VectScale(n, step, 0, Sc, step, 0);
                        doConjugateStep = false;
                    }
                    if (doConjugateStep) {
                        dVar = gSS.LinComb(sSub, 0, dVar, 0);
                    } else {
                        int lastInd = xSS.vSSet.vInd[0];
                        minCoeffInd = Optimization.VectMinIndex(sCC.length, sCC, 0, false);
                    }
                } else {
                    doConjugateStep = true;
                    doMDSStep = false;
                    Optimization.VectClear(n, step, 0);
                    Optimization.VectClear(n, dVar, 0);
                }
            } else {
                doConjugateStep = true;
                Optimization.VectClear(n, step, 0);
                Optimization.VectClear(n, dVar, 0);
            }
            boolean bl = doGDIIS = Math.abs(1.0 - dERatio) < 0.1 && doConjugateStep && doMDSStep && nRank > 1 && gCos > gPOrthTightLimit;
            if (doGDIIS) {
                doConjugateStep = false;
                SubSpace gSSO = new SubSpace(gSet);
                double[] gPP = gSSO.Components(this.grad);
                dG = gSSO.LinComb(gPP, 0, dG, 0);
                double[] sCC = Optimization.VectCompress(gSSO.vSSet.nVec, gSSO.vSSet.vInd, null, 0, Optimization.VLinComb(gPP, gSSO.vSet), 0);
                sCC[0] = sCC[0] - 1.0;
                Optimization.VectScale(sCC.length, sCC, 0, -1.0, sCC, 0);
                if (debug != null) {
                    Optimization.VectPrint("GDIIS coefficients", sCC.length, sCC, 0, debug);
                }
                VectorSet xSSC = new VectorSet(gSSO.vSet.nVec, gSSO.vSet.vLen, gSSO.vSet.vMtr);
                for (int i = 0; i < xSSC.nVec; ++i) {
                    for (int j = 1; j < xSSC.vLen; j += 2) {
                        xSSC.vSet[i][xSSC.vShft[i] + j - 1] = -gSSO.vSet.vSet[i][gSSO.vSet.vShft[i] + j];
                    }
                }
                SubSpace xSSX = new SubSpace(xSet, xSSC);
                dVar = xSSX.LinComb(gPP, 0, dVar, 0);
                if (!doConjugateStep) {
                    Optimization.VectSubstract(n, this.grad, 0, dG, 0, dG, 0);
                    Optimization.VectScale(n, dG, 0, -1.0, dG, 0);
                    double sMax = Optimization.VDot(n, dG, 0, dG, 0);
                }
            }
            if (doConjugateStep) {
                Optimization.VectAdd(n, this.grad, 0, dVar, 0, dVar, 0);
                if (doMDSStep) {
                    double gPLen = Math.sqrt(Optimization.VDot(n, dVar, 0, dVar, 0));
                    SubSpace gSSO = new SubSpace(gSet);
                    double[] gPP = gSSO.Components(dVar);
                    dG = gSSO.LinComb(gPP, 0, dG, 0);
                    double[] dGStore = Optimization.VectCopy(n, dG, 0);
                    Optimization.VectSubstract(n, dVar, 0, dG, 0, dG, 0);
                    double l1 = Optimization.VDot(n, dG, 0, dG, 0);
                    Optimization.VectNormalize(n, dG, 0, dG, 0);
                    double cDCos = 0.0;
                    if (gPLen > 1.0E-7) {
                        cDCos = -Optimization.VDot(n, dVar, 0, dG, 0) / gPLen;
                    }
                    cDCos = Math.abs(cDCos) > 1.0E-7 ? gPLen * cDCos : 0.0;
                    Optimization.VectScale(n, dG, 0, cDCos, dG, 0);
                } else {
                    Optimization.VectScale(n, dVar, 0, -1.0, dG, 0);
                }
                Optimization.VectAdd(n, step, 0, dG, 0, step, 0);
                double sMax = Optimization.VDot(n, step, 0, step, 0);
                sMax = Math.sqrt(sMax);
                if (sMax > stepLimit) {
                    double Sc = stepLimit / sMax;
                    Optimization.VectScale(n, step, 0, Sc, step, 0);
                    if (Sc < 1.0E-10 && it > 50) {
                        if (debug != null && debug.getWillPrint()) {
                            debug.decLevel("Step limit exceeded in ISOpt");
                        }
                        return fp;
                    }
                }
            }
            double stepRMSLen = Math.sqrt(Optimization.VDot(n, step, 0, step, 0) / (double)n);
            if (it % 100 == 0) {
                if (CleanArgs.doVerbose()) {
                    double gradRMSLen = Math.sqrt(Optimization.VDot(n, this.grad, 0, this.grad, 0) / (double)n);
                    s = " Opt: " + it + " " + nRank + " " + TextUtils.formatNumber(eLowest) + " " + TextUtils.formatNumber(gCos) + " " + debugPrintout.formatNumber(10, 6, gradRMSLen) + " " + debugPrintout.formatNumber(10, 6, stepRMSLen) + " " + debugPrintout.formatNumber(11, 7, fp) + " " + doConjugateStep + " " + symmHess + " " + doGDIIS;
                    CleanArgs.verbose(s);
                }
                if (this.canceller != null && this.canceller.isCancelled()) {
                    if (CleanArgs.doVerbose()) {
                        double gradRMSLen = Math.sqrt(Optimization.VDot(n, this.grad, 0, this.grad, 0) / (double)n);
                        s = " Opt: " + it + " " + nRank + " " + TextUtils.formatNumber(eLowest) + " " + TextUtils.formatNumber(gCos) + " " + debugPrintout.formatNumber(10, 6, gradRMSLen) + " " + debugPrintout.formatNumber(10, 6, stepRMSLen) + " " + debugPrintout.formatNumber(11, 7, fp) + " " + doConjugateStep + " " + symmHess + " " + doGDIIS;
                        CleanArgs.verbose(s);
                        CleanArgs.verbose("Optimization cancelled.");
                    }
                    return fp;
                }
            }
            if (debug != null && debug.getWillPrint()) {
                double gradRMSLen = Math.sqrt(Optimization.VDot(n, this.grad, 0, this.grad, 0) / (double)n);
                s = " Opt: " + it + " " + nRank + " " + TextUtils.formatNumber(eLowest) + " " + TextUtils.formatNumber(gCos) + " " + debugPrintout.formatNumber(10, 6, gradRMSLen) + " " + debugPrintout.formatNumber(10, 6, stepRMSLen) + " " + debugPrintout.formatNumber(11, 7, fp) + " " + doConjugateStep + " " + symmHess + " " + doGDIIS;
                debug.println(s);
                System.err.println(s);
            }
            if (gLen < ftol && stepRMSLen < ftol && (doMDSStep && doConjugateStep || doGDIIS)) {
                if (CleanArgs.doVerbose()) {
                    double gradRMSLen = Math.sqrt(Optimization.VDot(n, this.grad, 0, this.grad, 0) / (double)n);
                    s = " Opt: " + it + " " + nRank + " " + TextUtils.formatNumber(eLowest) + " " + TextUtils.formatNumber(gCos) + " " + debugPrintout.formatNumber(10, 6, gradRMSLen) + " " + debugPrintout.formatNumber(10, 6, stepRMSLen) + " " + debugPrintout.formatNumber(11, 7, fp) + " " + doConjugateStep + " " + symmHess + " " + doGDIIS;
                    CleanArgs.verbose(s);
                }
                return fp;
            }
            if (debugL != null) {
                debugL.println("Var-var0=");
                debugL.printVector(V.minus(this.var, var0));
            }
            Optimization.VectAdd(n, this.var, 0, step, 0, this.var, 0);
            if (debugL != null) {
                debugL.println("Var-var0=");
                debugL.printVector(V.minus(this.var, var0));
                debugL.println("step=");
                debugL.printVector(step);
            }
            e0 = fp;
            workingSpace.wEnd = workingSpaceStart;
            if (this.canceller != null && this.canceller.isCancelled()) break;
        }
        if (debug != null && debug.getWillPrint()) {
            debug.decLevel("Iteration limit reached in ISOpt");
        }
        return fp;
    }

    double CGMin(double ftol, int[] iter, long itime) {
        int i;
        double EPS = 1.0E-10;
        double fret = 0.0;
        double fp = 0.0;
        int n = this.var.length;
        double[] g = new double[n];
        double[] xi = new double[n];
        double[] h = new double[n];
        double[] xmintol = new double[2];
        double[] x0 = new double[n];
        double sc = 1.0;
        this.funcFlags.set(3);
        this.funcFlags.set(0);
        this.funcFlags.set(1);
        double eMin = fp = this.funct.GetFunction(this.funcFlags);
        for (i = 0; i < n; ++i) {
            xi[i] = this.grad[i];
        }
        for (i = 0; i < n; ++i) {
            g[i] = -xi[i];
            xi[i] = h[i] = g[i];
        }
        for (i = 0; i < this.ITMAX_frprmin; ++i) {
            int j;
            if (this.Debug) {
                debug.incLevel("empty");
            }
            if (this.Time_Check && System.currentTimeMillis() - this.Time_Limit > itime) {
                if (this.Debug) {
                    debug.println("Time limit reached in Optimization.");
                }
                i = this.ITMAX_frprmin;
            }
            iter[0] = i;
            boolean cGradFailed = false;
            if (this.Use_Derivatives) {
                double stepLimit = 0.01;
                double norm = sc * Math.sqrt(this.dot(xi, xi) / (double)n);
                sc *= Math.min(1.0, stepLimit / norm);
                int ii = 0;
                while (ii < n) {
                    int n2 = ii++;
                    xi[n2] = xi[n2] * sc;
                }
                for (ii = 0; ii < n; ++ii) {
                    x0[ii] = this.var[ii];
                }
                fret = this.lineSearch(xi, xmintol);
                sc *= xmintol[0];
                ii = 0;
                while (ii < n) {
                    int n3 = ii++;
                    xi[n3] = xi[n3] * xmintol[0];
                }
                norm = Math.sqrt(this.dot(xi, xi) / (double)n);
                double sc1 = Math.min(1.0, stepLimit / norm);
                for (int ii2 = 0; ii2 < n; ++ii2) {
                    this.var[ii2] = x0[ii2] + sc1 * xi[ii2];
                }
                sc *= sc1;
                this.funcFlags.set(3);
            }
            cGradFailed = eMin - fp <= EPS || (iter[0] + 1) % 25 == 0;
            eMin = Math.min(eMin, fp);
            this.funcFlags.set(3);
            this.funcFlags.set(0);
            this.funcFlags.set(1);
            fp = this.funct.GetFunction(this.funcFlags);
            for (int ii = 0; ii < n; ++ii) {
                xi[ii] = this.grad[ii];
            }
            double gg = 0.0;
            double dgg = 0.0;
            for (j = 0; j < n; ++j) {
                gg += g[j] * g[j];
                dgg += (xi[j] + g[j]) * xi[j];
            }
            if (this.Debug) {
                debug.println(" Opt: " + cGradFailed + " " + i + " " + Math.sqrt(gg / (double)n) + " " + fp);
                debug.decLevel(" Opt: " + cGradFailed + " " + i + " " + Math.sqrt(gg / (double)n) + " " + fp);
            }
            if (Math.sqrt(gg / (double)n) < ftol) {
                return fret;
            }
            double gam = dgg / gg;
            for (j = 0; j < n; ++j) {
                g[j] = -xi[j];
                if (cGradFailed) {
                    gam = 0.0;
                }
                xi[j] = h[j] = g[j] + gam * h[j];
            }
            if (this.canceller != null && this.canceller.isCancelled()) break;
        }
        if (this.Debug) {
            debug.println(" Iteration limit reached in CGMin");
        }
        return fp;
    }

    double[] NR_RFO_TRM_Step(Matrix H, double[] g, double[] s, double Lambda2, boolean checkEigVal, double StepLimitRMS, double StepLimitMax, boolean optimizeLambda) {
        int IT_MAX = 1000;
        double LambdaMin = 0.0;
        double LambdaMax = 1000.0;
        double scDLam = 1.0;
        if (!checkEigVal) {
            LambdaMin = Math.max(0.0, -H.aEVa.getElement(0, 0) + 0.001);
            LambdaMax = 1000.0 - H.aEVa.getElement(0, 0);
        }
        if (optimizeLambda) {
            Lambda2 = Math.min(Math.max(LambdaMin, Lambda2), LambdaMax);
        }
        if (s == null) {
            s = new double[g.length];
        }
        double smallEigVal = 1.0E-7;
        boolean lambdaConverged = false;
        int n = H.nRank;
        double[] ge = Optimization.mVMultiply(H.aLEV, g);
        double[] se = new double[H.nRank];
        double L0 = Lambda2;
        double L00 = Lambda2;
        double dL = 0.0;
        double dLLimit = 1.0E-4;
        for (int it = 0; it < IT_MAX && !lambdaConverged; ++it) {
            for (int i = 0; i < n; ++i) {
                double eInv = H.aEVa.getElement(i, i);
                if (checkEigVal) {
                    eInv = Math.abs(eInv);
                }
                eInv = Math.abs(eInv += Lambda2) <= smallEigVal ? 0.0 : 1.0 / eInv;
                se[i] = -ge[i] * eInv;
            }
            if (optimizeLambda) {
                Lambda2 = -Optimization.VDot(n, se, 0, ge, 0);
                if (StepLimitRMS > 0.0) {
                    double stepLenRMS = Math.sqrt(Optimization.VDot(n, se, 0, se, 0) / (double)n);
                    Lambda2 = Math.max(Lambda2, L0 * stepLenRMS / StepLimitRMS);
                }
                Lambda2 = Math.min(Math.max(LambdaMin, Lambda2), LambdaMax);
                dL = Lambda2 - L00;
                boolean bl = lambdaConverged = Math.abs(Lambda2) <= 1.0E-7;
                if (!lambdaConverged && Math.abs(dL / Lambda2) <= dLLimit) {
                    scDLam *= Math.sqrt(2.0) / 2.0;
                }
                dL = Lambda2 - L0;
                Lambda2 = L0 + scDLam * dL;
                L00 = L0;
                L0 = Lambda2;
                boolean bl2 = lambdaConverged = Math.abs(Lambda2) <= 1.0E-7;
                if (lambdaConverged) continue;
                lambdaConverged = Math.abs(dL / Lambda2) <= dLLimit;
                continue;
            }
            lambdaConverged = true;
        }
        if (H.aREV.nRows != H.nRank) {
            // empty if block
        }
        Optimization.mtVMultiply(H.aREV, se, 0, s, 0);
        return s;
    }

    double dot(double[] a, double[] b) {
        int l1 = a.length;
        int l2 = b.length;
        double dot = 0.0;
        l1 = l1 < l2 ? l1 : l2;
        for (int i = 0; i < l1; ++i) {
            dot += a[i] * b[i];
        }
        return dot;
    }

    double linmin(double[] min, double[] xi) {
        double TOL = 2.0E-4;
        double ret = 0.0;
        int n = min.length;
        double[] pcom = new double[n];
        double[] xicom = new double[n];
        for (int i = 0; i < n; ++i) {
            pcom[i] = min[i];
            xicom[i] = xi[i];
        }
        double[] x = new double[3];
        double[] fx = new double[3];
        double[] xmintol = new double[2];
        x[0] = 0.0;
        x[1] = 1.0;
        xmintol[0] = 0.0;
        xmintol[1] = TOL;
        this.mnbrak(x, fx, pcom, xicom);
        ret = this.brent(x, xmintol, pcom, xicom);
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            xi[n2] = xi[n2] * xmintol[0];
            int n3 = i;
            min[n3] = min[n3] + xi[i];
        }
        return ret;
    }

    double f1dim(double x, double[] pcom, double[] xicom) {
        int n = pcom.length;
        double[] xt = new double[n];
        for (int i = 0; i < n; ++i) {
            xt[i] = pcom[i] + x * xicom[i];
        }
        double ff = this.f(xt);
        return ff;
    }

    double FuncAtScaledStep(double x, double[] xicom) {
        return this.funct.GetXFunction(x, xicom);
    }

    void mnbrak(double[] x, double[] fx, double[] pcom, double[] xicom) {
        double GOLD = 1.618034;
        int GLIMIT = 100;
        double TINY = 1.0E-20;
        double dum = 0.0;
        fx[0] = this.f1dim(x[0], pcom, xicom);
        fx[1] = this.f1dim(x[1], pcom, xicom);
        x[2] = x[1] + GOLD * (x[1] - x[0]);
        fx[2] = this.f1dim(x[2], pcom, xicom);
    }

    void mnBracket(double[] x, double[] fx, double[] xicom) {
        double GOLD = 1.618034;
        int GLIMIT = 100;
        double TINY = 1.0E-20;
        double dum = 0.0;
        fx[0] = this.FuncAtScaledStep(x[0], xicom);
        fx[1] = this.FuncAtScaledStep(x[1], xicom);
        x[2] = x[1] + GOLD * (x[1] - x[0]);
        fx[2] = this.FuncAtScaledStep(x[2], xicom);
    }

    double brent(double[] xx, double[] xmtol, double[] pcom, double[] xicom) {
        double fx;
        double v;
        double ZEPS = 1.0E-10;
        double CGOLD = 0.381966;
        double d = 0.0;
        double e = 0.0;
        double a = xx[0] < xx[2] ? xx[0] : xx[2];
        double b = xx[0] > xx[2] ? xx[0] : xx[2];
        double w = v = xx[1];
        double x = v;
        double fv = fx = this.f1dim(x, pcom, xicom);
        double fw = fx;
        for (int i = 0; i < this.ITMAX_brent; ++i) {
            double u;
            double xm = 0.5 * (a + b);
            double tol1 = xmtol[1] * Math.abs(x) + ZEPS;
            double tol2 = 2.0 * tol1;
            if (Math.abs(x - xm) <= tol2 - 0.5 * (b - a)) {
                xmtol[0] = x;
                return fx;
            }
            if (Math.abs(e) > tol1) {
                double r = (x - w) * (fx - fv);
                double q = (x - v) * (fx - fw);
                double p = (x - v) * q - (x - w) * r;
                if ((q = 2.0 * (q - r)) > 0.0) {
                    p = -p;
                }
                q = Math.abs(q);
                double etemp = e;
                e = d;
                if (Math.abs(p) >= Math.abs(0.5 * q * etemp) || p <= q * (a - x) || p >= q * (b - x)) {
                    e = x >= xm ? a - x : b - x;
                    d = CGOLD * e;
                } else {
                    d = p / q;
                    u = x + d;
                    if (u - a < tol2 || b - u < tol2) {
                        d = Optimization.sign(tol1, xm - x);
                    }
                }
            } else {
                e = x >= xm ? a - x : b - x;
                d = CGOLD * e;
            }
            u = Math.abs(d) >= tol1 ? x + d : x + Optimization.sign(tol1, d);
            double fu = this.f1dim(u, pcom, xicom);
            if (fu <= fx) {
                if (u >= x) {
                    a = x;
                } else {
                    b = x;
                }
                v = w;
                w = x;
                x = u;
                fv = fw;
                fw = fx;
                fx = fu;
                continue;
            }
            if (u < x) {
                a = u;
            } else {
                b = u;
            }
            if (fu <= fw || w == x) {
                v = w;
                w = u;
                fv = fw;
                fw = fu;
                continue;
            }
            if (!(fu <= fv) && v != x && v != w) continue;
            v = u;
            fv = fu;
        }
        xmtol[0] = x;
        if (this.Debug) {
            debug.println("Iteration limit reached in brent");
        }
        return fx;
    }

    double Brent(double[] xx, double[] xmtol, double[] xicom) {
        double fx;
        double v;
        double ZEPS = 1.0E-10;
        double CGOLD = 0.381966;
        double d = 0.0;
        double e = 0.0;
        double a = xx[0] < xx[2] ? xx[0] : xx[2];
        double b = xx[0] > xx[2] ? xx[0] : xx[2];
        double w = v = xx[1];
        double x = v;
        double fv = fx = this.FuncAtScaledStep(x, xicom);
        double fw = fx;
        for (int i = 0; i < this.ITMAX_brent; ++i) {
            double u;
            double xm = 0.5 * (a + b);
            double tol1 = xmtol[1] * Math.abs(x) + ZEPS;
            double tol2 = 2.0 * tol1;
            if (Math.abs(x - xm) <= tol2 - 0.5 * (b - a)) {
                xmtol[0] = x;
                return fx;
            }
            if (Math.abs(e) > tol1) {
                double r = (x - w) * (fx - fv);
                double q = (x - v) * (fx - fw);
                double p = (x - v) * q - (x - w) * r;
                if ((q = 2.0 * (q - r)) > 0.0) {
                    p = -p;
                }
                q = Math.abs(q);
                double etemp = e;
                e = d;
                if (Math.abs(p) >= Math.abs(0.5 * q * etemp) || p <= q * (a - x) || p >= q * (b - x)) {
                    e = x >= xm ? a - x : b - x;
                    d = CGOLD * e;
                } else {
                    d = p / q;
                    u = x + d;
                    if (u - a < tol2 || b - u < tol2) {
                        d = Optimization.sign(tol1, xm - x);
                    }
                }
            } else {
                e = x >= xm ? a - x : b - x;
                d = CGOLD * e;
            }
            u = Math.abs(d) >= tol1 ? x + d : x + Optimization.sign(tol1, d);
            double fu = this.FuncAtScaledStep(u, xicom);
            if (fu <= fx) {
                if (u >= x) {
                    a = x;
                } else {
                    b = x;
                }
                v = w;
                w = x;
                x = u;
                fv = fw;
                fw = fx;
                fx = fu;
                continue;
            }
            if (u < x) {
                a = u;
            } else {
                b = u;
            }
            if (fu <= fw || w == x) {
                v = w;
                w = u;
                fv = fw;
                fw = fu;
                continue;
            }
            if (!(fu <= fv) && v != x && v != w) continue;
            v = u;
            fv = fu;
        }
        xmtol[0] = x;
        if (this.Debug) {
            debug.println("Iteration limit reached in brent");
        }
        return fx;
    }

    double dlinmin(double[] min, double[] xi) {
        double TOL = 2.0E-4;
        double ret = 0.0;
        int n = min.length;
        double[] pcom = new double[n];
        double[] xicom = new double[n];
        for (int i = 0; i < n; ++i) {
            pcom[i] = min[i];
            xicom[i] = xi[i];
        }
        double[] x = new double[3];
        double[] fx = new double[3];
        double[] xmintol = new double[2];
        x[0] = 0.0;
        x[1] = 1.0;
        xmintol[0] = 0.0;
        xmintol[1] = TOL;
        this.mnbrak(x, fx, pcom, xicom);
        ret = this.dbrent(x, xmintol, pcom, xicom);
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            xi[n2] = xi[n2] * xmintol[0];
            int n3 = i;
            min[n3] = min[n3] + xi[i];
        }
        return ret;
    }

    double lineSearch(double[] min, double[] xi, double[] xmintol) {
        double TOL = 2.0E-4;
        double ret = 0.0;
        int n = min.length;
        double[] pcom = new double[n];
        double[] xicom = new double[n];
        for (int i = 0; i < n; ++i) {
            pcom[i] = min[i];
            xicom[i] = xi[i];
        }
        double[] x = new double[3];
        double[] fx = new double[3];
        x[0] = 0.0;
        x[1] = 1.0;
        xmintol[0] = 0.0;
        xmintol[1] = TOL;
        this.mnbrak(x, fx, pcom, xicom);
        ret = this.dbrent(x, xmintol, pcom, xicom);
        return ret;
    }

    double lineSearch(double[] xi, double[] xmintol) {
        double TOL = 2.0E-4;
        double ret = 0.0;
        int n = this.var.length;
        double[] xx = new double[21];
        double[] yy = new double[21];
        double[] gg = new double[21];
        double[] xicom = new double[n];
        for (int i = 0; i < n; ++i) {
            xicom[i] = xi[i];
        }
        double[] x = new double[3];
        double[] fx = new double[3];
        x[0] = 0.0;
        x[1] = 1.0;
        xmintol[0] = 0.0;
        xmintol[1] = TOL;
        this.mnBracket(x, fx, xicom);
        ret = this.dBrent(x, xmintol, xicom);
        if (debug != null && debug.getWillPrint()) {
            double dx = (x[2] - x[0]) / 20.0;
            for (int i = 0; i < 21; ++i) {
                xx[i] = x[0] + (double)i * dx;
                yy[i] = this.FuncAtScaledStep(xx[i], xicom);
                gg[i] = this.GradAtScaledStep(xx[i], xicom);
            }
            debug.println("Step line search:" + xmintol[0]);
            debug.printVector(yy);
            debug.printVector(gg);
            debug.printVector(xx);
        }
        return ret;
    }

    double dbrent(double[] xx, double[] xmtol, double[] pcom, double[] xicom) {
        double dx;
        double fx;
        double v;
        double ZEPS = 1.0E-10;
        double e = 0.0;
        double d = 0.0;
        double a = xx[0] < xx[2] ? xx[0] : xx[2];
        double b = xx[0] > xx[2] ? xx[0] : xx[2];
        double w = v = xx[1];
        double x = v;
        double fv = fx = this.f1dim(x, pcom, xicom);
        double fw = fx;
        double dv = dx = this.df1dim(x, pcom, xicom);
        double dw = dx;
        for (int i = 0; i < this.ITMAX_brent; ++i) {
            double fu;
            double u;
            double xm = 0.5 * (a + b);
            double tol1 = xmtol[1] * Math.abs(x) + ZEPS;
            double tol2 = 2.0 * tol1;
            if (Math.abs(x - xm) <= tol2 - 0.5 * (b - a) || b - x < b * 0.05) {
                xmtol[0] = x;
                if (debug != null && debug.getWillPrint()) {
                    debug.println("Dbrent #1: " + x + " in " + i + " steps.");
                }
                return fx;
            }
            if (Math.abs(e) > tol1) {
                double d1;
                double d2 = d1 = 2.0 * (b - a);
                if (dw != dx) {
                    d1 = (w - x) * dx / (dx - dw);
                }
                if (dv != dx) {
                    d2 = (v - x) * dx / (dx - dv);
                }
                double u1 = x + d1;
                double u2 = x + d2;
                boolean ok1 = (a - u1) * (u1 - b) > 0.0 && dx * d1 <= 0.0;
                boolean ok2 = (a - u2) * (u2 - b) > 0.0 && dx * d2 <= 0.0;
                double olde = e;
                e = d;
                if (ok1 || ok2) {
                    d = ok1 && ok2 ? (Math.abs(d1) < Math.abs(d2) ? d1 : d2) : (ok1 ? d1 : d2);
                    if (Math.abs(d) <= Math.abs(0.5 * olde)) {
                        u = x + d;
                        if (u - a < tol2 || b - u < tol2) {
                            d = Optimization.sign(tol1, xm - x);
                        }
                    } else {
                        e = dx >= 0.0 ? a - x : b - x;
                        d = 0.5 * e;
                    }
                } else {
                    e = dx >= 0.0 ? a - x : b - x;
                    d = 0.5 * e;
                }
            } else {
                e = dx >= 0.0 ? a - x : b - x;
                d = 0.5 * e;
            }
            if (Math.abs(d) >= tol1) {
                u = x + d;
                fu = this.f1dim(u, pcom, xicom);
            } else {
                u = x + Optimization.sign(tol1, d);
                fu = this.f1dim(u, pcom, xicom);
                if (fu > fx) {
                    xmtol[0] = x;
                    if (debug != null && debug.getWillPrint()) {
                        debug.println("Dbrent #2: " + x + " in " + i + " steps.");
                    }
                    return fx;
                }
            }
            double du = this.df1dim(u, pcom, xicom);
            if (fu <= fx) {
                if (u >= x) {
                    a = x;
                } else {
                    b = x;
                }
                v = w;
                fv = fw;
                dv = dw;
                w = x;
                fw = fx;
                dw = dx;
                x = u;
                fx = fu;
                dx = du;
                continue;
            }
            if (u < x) {
                a = u;
            } else {
                b = u;
            }
            if (fu <= fw || w == x) {
                v = w;
                dv = dw;
                w = u;
                fv = fw;
                fw = fu;
                dw = du;
                continue;
            }
            if (!(fu <= fv) && v != x && v != w) continue;
            v = u;
            fv = fu;
            dv = du;
        }
        if (this.Debug) {
            debug.println("Iteration limit reached in dbrent");
        }
        return 0.0;
    }

    double dBrent(double[] xx, double[] xmtol, double[] xicom) {
        double dx;
        double fx;
        double v;
        double ZEPS = 1.0E-10;
        double e = 0.0;
        double d = 0.0;
        double a = xx[0] < xx[2] ? xx[0] : xx[2];
        double b = xx[0] > xx[2] ? xx[0] : xx[2];
        double w = v = xx[1];
        double x = v;
        double fv = fx = this.FuncAtScaledStep(x, xicom);
        double fw = fx;
        double dv = dx = this.GradAtScaledStep(x, xicom);
        double dw = dx;
        for (int i = 0; i < this.ITMAX_brent; ++i) {
            double fu;
            double u;
            double xm = 0.5 * (a + b);
            double tol1 = xmtol[1] * Math.abs(x) + ZEPS;
            double tol2 = 2.0 * tol1;
            if (Math.abs(x - xm) <= tol2 - 0.5 * (b - a) || b - x < b * 0.05) {
                xmtol[0] = x;
                if (debug != null && debug.getWillPrint()) {
                    debug.println("Dbrent #1: " + x + " in " + i + " steps.");
                }
                return fx;
            }
            if (Math.abs(e) > tol1) {
                double d1;
                double d2 = d1 = 2.0 * (b - a);
                if (dw != dx) {
                    d1 = (w - x) * dx / (dx - dw);
                }
                if (dv != dx) {
                    d2 = (v - x) * dx / (dx - dv);
                }
                double u1 = x + d1;
                double u2 = x + d2;
                boolean ok1 = (a - u1) * (u1 - b) > 0.0 && dx * d1 <= 0.0;
                boolean ok2 = (a - u2) * (u2 - b) > 0.0 && dx * d2 <= 0.0;
                double olde = e;
                e = d;
                if (ok1 || ok2) {
                    d = ok1 && ok2 ? (Math.abs(d1) < Math.abs(d2) ? d1 : d2) : (ok1 ? d1 : d2);
                    if (Math.abs(d) <= Math.abs(0.5 * olde)) {
                        u = x + d;
                        if (u - a < tol2 || b - u < tol2) {
                            d = Optimization.sign(tol1, xm - x);
                        }
                    } else {
                        e = dx >= 0.0 ? a - x : b - x;
                        d = 0.5 * e;
                    }
                } else {
                    e = dx >= 0.0 ? a - x : b - x;
                    d = 0.5 * e;
                }
            } else {
                e = dx >= 0.0 ? a - x : b - x;
                d = 0.5 * e;
            }
            if (Math.abs(d) >= tol1) {
                u = x + d;
                fu = this.FuncAtScaledStep(u, xicom);
            } else {
                u = x + Optimization.sign(tol1, d);
                fu = this.FuncAtScaledStep(u, xicom);
                if (fu > fx) {
                    xmtol[0] = x;
                    if (debug != null && debug.getWillPrint()) {
                        debug.println("Dbrent #2: " + x + " in " + i + " steps.");
                    }
                    return fx;
                }
            }
            double du = this.GradAtScaledStep(u, xicom);
            if (fu <= fx) {
                if (u >= x) {
                    a = x;
                } else {
                    b = x;
                }
                v = w;
                fv = fw;
                dv = dw;
                w = x;
                fw = fx;
                dw = dx;
                x = u;
                fx = fu;
                dx = du;
                continue;
            }
            if (u < x) {
                a = u;
            } else {
                b = u;
            }
            if (fu <= fw || w == x) {
                v = w;
                dv = dw;
                w = u;
                fv = fw;
                fw = fu;
                dw = du;
                continue;
            }
            if (!(fu <= fv) && v != x && v != w) continue;
            v = u;
            fv = fu;
            dv = du;
        }
        if (this.Debug) {
            debug.println("Iteration limit reached in dbrent");
        }
        return 0.0;
    }

    double df1dim(double x, double[] pcom, double[] xicom) {
        double dX = 1.0E-4;
        double df1 = 0.0;
        int n = pcom.length;
        double[] xt = new double[n];
        for (int i = 0; i < n; ++i) {
            xt[i] = pcom[i] + (x + dX) * xicom[i];
        }
        double f1 = this.f(xt);
        for (int i = 0; i < n; ++i) {
            xt[i] = pcom[i] + (x - dX) * xicom[i];
        }
        double f2 = this.f(xt);
        return (f1 - f2) / (2.0 * dX);
    }

    double GradAtScaledStep(double x, double[] xicom) {
        return this.funct.GetDFunction(x, xicom);
    }

    void switchValues(double[] a, double[] b, double[] f) {
        int l = a.length;
        double[] tmp = new double[l];
        System.arraycopy(a, 0, tmp, 0, l);
        System.arraycopy(b, 0, a, 0, l);
        System.arraycopy(tmp, 0, b, 0, l);
        double t = f[0];
        f[0] = f[1];
        f[1] = t;
    }

    static double sign(double a, double b) {
        return b >= 0.0 ? Math.abs(a) : -Math.abs(a);
    }

    public static double[] minus(double[] a, double[] b) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] - b[i];
        }
        return result;
    }

    public static double[] ScalarWithVectorDot(double a, double[] b) {
        int l = b.length;
        double[] result = new double[l];
        for (int i = 0; i < l; ++i) {
            result[i] = a * b[i];
        }
        return result;
    }

    double f(double[] x) {
        return 0.0;
    }

    double[] df(double[] x) {
        return null;
    }

    double VectorLength2(double[] x) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += x[i] * x[i];
        }
        return sum;
    }

    public static double VDot(Matrix m1, int row1, Matrix m2, int row2) {
        double d = 0.0;
        int len = Math.min(m1.nCols, m2.nCols);
        if (m1.mType.get(2) || m1.mType.get(3) || m2.mType.get(2) || m2.mType.get(3)) {
            for (int i = 0; i < len; ++i) {
                d += m1.getElement(row1, i) * m2.getElement(row2, i);
            }
        } else {
            d = Optimization.VDot(len, m1.aVec, m1.pShft + row1 * m1.nCols, m2.aVec, m2.pShft + row2 * m2.nCols);
        }
        return d;
    }

    public static double VDot(int len, double[] v1, int pV1Shft, double[] v2, int pV2Shft) {
        double d = 0.0;
        for (int i = 0; i < len; ++i) {
            d += v1[pV1Shft + i] * v2[pV2Shft + i];
        }
        return d;
    }

    public static double VDot(int len, double[] v1, int pV1Shft, double[] v2, int pV2Shft, Matrix metric) {
        if (metric != null) {
            double[] w = Optimization.mVMultiply(metric, v2, pV2Shft);
            return Optimization.VDot(len, v1, pV1Shft, w, 0);
        }
        return Optimization.VDot(len, v1, pV1Shft, v2, pV2Shft);
    }

    public static Matrix MDot(VectorSet vSet1, VectorSet vSet2) {
        return Optimization.MDot(vSet1, vSet2, null);
    }

    public static void VCoeff(VectorSet vSet1, int Ind1, VectorSet vSet2, double[] w, int wShft) {
        Matrix metric = null;
        if (vSet1.sType.get(2)) {
            if (vSet2.sType.get(2) && vSet1.vMtr == vSet2.vMtr) {
                metric = vSet1.vMtr;
            }
        }
        int len = vSet1.vLen;
        if (vSet1.vLen != vSet2.vLen) {
            System.err.println("Vector length mismatch in VCoeff");
            System.exit(-2);
        }
    }

    public static void VSchmidtO(VectorSet vSet1, VectorSet vSet2, double zlimit) {
        if (vSet2 == null) {
            vSet2 = new VectorSet(vSet1.nVec, vSet1.vLen, null, 0, vSet1.sType, vSet1.vOvr, vSet1.vMtr);
        }
        int nVec2 = 0;
        double[] w = new double[vSet1.nVec + vSet1.vLen];
        int wShft = vSet1.nVec;
        for (int i = 0; i < vSet1.nVec; ++i) {
            boolean OK;
            Optimization.VectCopy(vSet1.vLen, vSet1.vSet[i], vSet1.vShft[i], vSet2.vSet[nVec2], vSet2.vShft[nVec2]);
            if (vSet2.sType.get(0)) {
                Optimization.VectNormalize(vSet2.vLen, vSet2.vSet[nVec2], vSet2.vShft[nVec2], vSet2.vSet[nVec2], vSet2.vShft[nVec2], vSet2.vMtr, zlimit);
            }
            Optimization.VCoeff(vSet2.vLen, vSet2.vSet[nVec2], vSet2.vShft[nVec2], nVec2, vSet2.vSet, vSet2.vShft, vSet2.vMtr, w, 0);
            Optimization.VLinComb(vSet2.vLen, w, 0, nVec2, vSet2.vSet, vSet2.vShft, w, wShft);
            Optimization.VectSubstract(vSet2.vLen, vSet2.vSet[nVec2], vSet2.vShft[nVec2], w, wShft, vSet2.vSet[nVec2], vSet2.vShft[nVec2]);
            if (vSet2.sType.get(0)) {
                OK = Optimization.VectNormalize(vSet2.vLen, vSet2.vSet[nVec2], vSet2.vShft[nVec2], vSet2.vSet[nVec2], vSet2.vShft[nVec2], vSet2.vMtr, zlimit);
            } else {
                boolean bl = OK = Math.sqrt(Optimization.VDot(vSet2.vLen, vSet2.vSet[nVec2], vSet2.vShft[nVec2], vSet2.vSet[nVec2], vSet2.vShft[nVec2], vSet2.vMtr)) > zlimit;
            }
            if (!OK) continue;
            ++nVec2;
        }
        vSet2.nVec = nVec2;
    }

    public static void VCoeff(int len, double[] v1, int pV1Shft, int nVec2, double[][] v2, int[] pV2Shft, Matrix metric, double[] w, int wShft) {
        if (w == null) {
            w = new double[nVec2];
        }
        for (int i = 0; i < nVec2; ++i) {
            w[wShft + i] = Optimization.VDot(len, v1, pV1Shft, v2[i], pV2Shft[i], metric);
        }
    }

    public static double[] VLinComb(double[] c, VectorSet v) {
        return Optimization.VLinComb(v.vLen, c, 0, v.nVec, v.vSet, v.vShft, null, 0);
    }

    public static double[] VLinComb(double[] c, VectorSet v, double[] w) {
        return Optimization.VLinComb(v.vLen, c, 0, v.nVec, v.vSet, v.vShft, w, 0);
    }

    public static double[] VLinComb(double[] c, int cShft, VectorSet v, double[] w, int wShft) {
        return Optimization.VLinComb(v.vLen, c, cShft, v.nVec, v.vSet, v.vShft, w, wShft);
    }

    public static double[] VLinComb(int len, double[] c, int cShft, int nVec2, double[][] v2, int[] pV2Shft, double[] w, int wShft) {
        if (w == null) {
            w = new double[len];
        } else {
            Optimization.VectClear(len, w, wShft);
        }
        for (int i = 0; i < nVec2; ++i) {
            Optimization.VectScaleAndAdd(len, w, wShft, c[cShft + i], v2[i], pV2Shft[i], w, wShft);
        }
        return w;
    }

    public static double[] VLinComb(double[] c, VectorSubSet v) {
        double[] w = new double[v.vSet.vLen];
        Optimization.VLinComb(c, 0, v, w, 0);
        return w;
    }

    public static double[] VLinComb(double[] c, VectorSubSet v, double[] w) {
        return Optimization.VLinComb(c, 0, v, w, 0);
    }

    public static double[] VLinComb(double[] c, int cShft, VectorSubSet v, double[] w, int wShft) {
        int len = v.vSet.vLen;
        int nVec = v.nVec;
        if (w == null) {
            w = new double[len];
        } else {
            Optimization.VectClear(len, w, wShft);
        }
        for (int i = 0; i < nVec; ++i) {
            Optimization.VectScaleAndAdd(len, w, wShft, c[cShft + i], v.vSet.vSet[v.vInd[i]], v.vSet.vShft[v.vInd[i]], w, wShft);
        }
        return w;
    }

    public static double[] VLinComb(int len, double[] c, int cShft, int nVec2, double[] v2, int pV2Shft, double[] w, int wShft) {
        if (w == null) {
            w = new double[len];
        } else {
            Optimization.VectClear(len, w, wShft);
        }
        for (int i = 0; i < nVec2; ++i) {
            Optimization.VectScaleAndAdd(len, w, wShft, c[cShft + i], v2, pV2Shft + i * len, w, wShft);
        }
        return w;
    }

    public static double[] VectCompress(int len, int[] index, double[] c, int cShft, double[] v, int vShft) {
        if (c == null) {
            c = new double[len];
        } else {
            Optimization.VectClear(len, c, cShft);
        }
        for (int i = 0; i < len; ++i) {
            c[cShft + i] = v[vShft + index[i]];
        }
        return c;
    }

    public static double[] VectExtract(int len, int[] index, double[] c, int cShft, int vLen, double[] v, int vShft) {
        if (v == null) {
            c = new double[vShft + vLen];
        } else {
            Optimization.VectClear(vLen, v, vShft);
        }
        for (int i = 0; i < len; ++i) {
            v[vShft + index[i]] = c[cShft + i];
        }
        return v;
    }

    public static Matrix MDot(VectorSet vSet1, VectorSet vSet2, Matrix v3) {
        Matrix metric = null;
        if (vSet1.sType.get(2)) {
            if (vSet2.sType.get(2) && vSet1.vMtr == vSet2.vMtr) {
                metric = vSet1.vMtr;
            }
        }
        int len = vSet1.vLen;
        if (vSet1.vLen != vSet2.vLen) {
            System.err.println("Vector length mismatch in MDot");
            System.exit(-2);
        }
        return Optimization.MDot(len, vSet1.nVec, vSet1.vSet, vSet1.vShft, vSet2.nVec, vSet2.vSet, vSet2.vShft, metric, v3);
    }

    public static Matrix MDot(int len, int nVec1, double[][] v1, int[] pV1Shft, int nVec2, double[][] v2, int[] pV2Shft, Matrix metric) {
        return Optimization.MDot(len, nVec1, v1, pV1Shft, nVec2, v2, pV2Shft, metric, null);
    }

    public static Matrix MDot(int len, int nVec1, double[][] v1, int[] pV1Shft, int nVec2, double[][] v2, int[] pV2Shft, Matrix metric, Matrix v3) {
        if (v3 == null) {
            BitSet v3_sType = null;
            if (nVec1 == nVec2 && v1 == v2 && pV1Shft == pV2Shft) {
                v3_sType = new BitSet(8);
                v3_sType.set(2);
                v3_sType.set(1);
            }
            v3 = new Matrix(nVec1, nVec2, v3_sType);
        }
        boolean doSymm = nVec1 == nVec2 && v1 == v2 && pV1Shft == pV2Shft;
        int lim2 = nVec2;
        for (int i = 0; i < nVec1; ++i) {
            if (doSymm) {
                lim2 = i + 1;
            }
            for (int j = 0; j < nVec2; ++j) {
                v3.setElement(i, j, Optimization.VDot(len, v1[i], pV1Shft[i], v2[j], pV2Shft[j], metric));
            }
        }
        return v3;
    }

    public static boolean VectNormalize(int len, double[] v1, int pV1Shft, double[] v2, int pV2Shft, Matrix metric, double zLimit) {
        double Sc = Optimization.VDot(len, v1, pV1Shft, v1, pV1Shft, metric);
        Sc = Sc < 0.0 ? 0.0 : Math.sqrt(Sc);
        if (Sc <= zLimit) {
            Optimization.VectClear(len, v2, pV2Shft);
            return false;
        }
        Sc = 1.0 / Sc;
        Optimization.VectScale(len, v1, pV1Shft, Sc, v2, pV2Shft);
        return true;
    }

    public static boolean VectNormalize(int len, double[] v1, int pV1Shft, double[] v2, int pV2Shft, Matrix metric) {
        return Optimization.VectNormalize(len, v1, pV1Shft, v2, pV2Shft, metric, 1.0E-7);
    }

    public static boolean VectNormalize(int len, double[] v1, int pV1Shft, double[] v2, int pV2Shft) {
        return Optimization.VectNormalize(len, v1, pV1Shft, v2, pV2Shft, null, 1.0E-7);
    }

    public static double[] VectUnit(int len, double[] v1, int pV1Shft, Matrix metric) {
        double[] v2 = new double[len];
        Optimization.VectNormalize(len, v1, pV1Shft, v2, 0, metric, 1.0E-7);
        return v2;
    }

    public static double VSum(int len, double[] v1, int pV1Shft, boolean doAbs) {
        double d = 0.0;
        if (doAbs) {
            for (int i = 0; i < len; ++i) {
                d += Math.abs(v1[pV1Shft + i]);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                d += v1[pV1Shft + i];
            }
        }
        return d;
    }

    public static void VVMul(int len, double[] v1, int pV1Shft, double[] v2, int pV2Shft, double[] v3, int pV3Shft) {
        for (int i = 0; i < len; ++i) {
            v3[pV3Shft + i] = v1[pV1Shft + i] * v2[pV2Shft + i];
        }
    }

    public static void VectClear(int len, double[] v, int pVShft) {
        for (int i = 0; i < len; ++i) {
            v[pVShft + i] = 0.0;
        }
    }

    public static void VectCopy(double[] v1, double[] v2) {
        int len = Math.min(v1.length, v2.length);
        int pV1Shft = 0;
        int pV2Shft = 0;
        Optimization.VectCopy(len, v1, pV1Shft, v2, pV2Shft);
    }

    public static void VectCopy(int len, double[] v1, int pV1Shft, double[] v2, int pV2Shft) {
        if (v1 == v2) {
            Optimization.VectCopy(len, v1, pV1Shft, pV2Shft);
        } else {
            for (int i = 0; i < len; ++i) {
                v2[pV2Shft + i] = v1[pV1Shft + i];
            }
        }
    }

    public static double[] VectCopy(int len, double[] v1, int pV1Shft) {
        double[] v2 = new double[len];
        int pV2Shft = 0;
        for (int i = 0; i < len; ++i) {
            v2[pV2Shft + i] = v1[pV1Shft + i];
        }
        return v2;
    }

    public static void VectCopy(int len, double[] v, int pV1Shft, int pV2Shft) {
        if (pV1Shft == pV2Shft) {
            return;
        }
        if (pV1Shft > pV2Shft) {
            for (int i = 0; i < len; ++i) {
                v[pV2Shft + i] = v[pV1Shft + i];
            }
        } else {
            for (int i = len - 1; i >= 0; --i) {
                v[pV2Shft + i] = v[pV1Shft + i];
            }
        }
    }

    public static double VectMaxComponent(int len, double[] v1, int pV1Shft, boolean Absolute) {
        double maxValue = v1[pV1Shft];
        double value = 0.0;
        if (Absolute) {
            maxValue = Math.abs(v1[pV1Shft]);
        }
        for (int i = 1; i < len; ++i) {
            value = Absolute ? Math.abs(v1[pV1Shft + i]) : v1[pV1Shft + i];
            maxValue = Math.max(maxValue, value);
        }
        return maxValue;
    }

    public static double VectMinComponent(int len, double[] v1, int pV1Shft, boolean Absolute) {
        double minValue = v1[pV1Shft];
        double value = 0.0;
        if (Absolute) {
            minValue = Math.abs(v1[pV1Shft]);
        }
        for (int i = 1; i < len; ++i) {
            value = Absolute ? Math.abs(v1[pV1Shft + i]) : v1[pV1Shft + i];
            minValue = Math.min(minValue, value);
        }
        return minValue;
    }

    public static int VectMaxIndex(int len, double[] v1, int pV1Shft, boolean Absolute) {
        if (len < 1) {
            return 0;
        }
        double maxValue = v1[pV1Shft];
        double value = 0.0;
        int iMax = 0;
        if (Absolute) {
            maxValue = Math.abs(v1[pV1Shft]);
        }
        for (int i = 1; i < len; ++i) {
            value = Absolute ? Math.abs(v1[pV1Shft + i]) : v1[pV1Shft + i];
            if (!(maxValue < value)) continue;
            iMax = i;
            maxValue = value;
        }
        return iMax;
    }

    public static int VectMinIndex(int len, double[] v1, int pV1Shft, boolean Absolute) {
        if (len < 1) {
            return 0;
        }
        double minValue = v1[pV1Shft];
        double value = 0.0;
        int iMin = 0;
        if (Absolute) {
            minValue = Math.abs(v1[pV1Shft]);
        }
        for (int i = 1; i < len; ++i) {
            value = Absolute ? Math.abs(v1[pV1Shft + i]) : v1[pV1Shft + i];
            if (!(minValue > value)) continue;
            iMin = i;
            minValue = value;
        }
        return iMin;
    }

    public static void VectScale(Matrix m1, int i1, double Sc, Matrix m2, int i2) {
        Optimization.VectScale(m1.nCols, m1.aVec, m1.pShft + i1 * m1.nCols, Sc, m2.aVec, m2.pShft + i2 * m2.nCols);
    }

    public static double[] VectScale(int len, double[] v1, int pV1Shft, double Sc) {
        double[] v2 = new double[len];
        Optimization.VectScale(len, v1, pV1Shft, Sc, v2, 0);
        return v2;
    }

    public static double[] VectScale(int len, double[] v1, int pV1Shft, double Sc, double[] v2, int pV2Shft) {
        for (int i = 0; i < len; ++i) {
            v2[pV2Shft + i] = Sc * v1[pV1Shft + i];
        }
        return v2;
    }

    public static double[] VectAdd(int len, double[] v1, int pV1Shft, double[] v2, int pV2Shft, double[] v3, int pV3Shft) {
        for (int i = 0; i < len; ++i) {
            v3[pV3Shft + i] = v1[pV1Shft + i] + v2[pV2Shft + i];
        }
        return v3;
    }

    public static void VectSubstract(double[] v1, double[] v2, double[] v3) {
        int len = Math.min(v1.length, v2.length);
        Optimization.VectSubstract(len, v1, 0, v2, 0, v3, 0);
    }

    public static double[] VectSubstract(int len, double[] v1, int pV1Shft, double[] v2, int pV2Shft) {
        return Optimization.VectSubstract(len, v1, pV1Shft, v2, pV2Shft, null, 0);
    }

    public static double[] VectSubstract(int len, double[] v1, int pV1Shft, double[] v2, int pV2Shft, double[] v3, int pV3Shft) {
        if (v3 == null) {
            v3 = new double[len];
            pV3Shft = 0;
        }
        for (int i = 0; i < len; ++i) {
            v3[pV3Shft + i] = v1[pV1Shft + i] - v2[pV2Shft + i];
        }
        return v3;
    }

    public static void VectPrint(String Message, int len, double[] w, int wShft) {
        System.err.println(Message);
        for (int i = 0; i < len; ++i) {
            System.err.print(debugPrintout.formatNumber(8, 4, w[wShft + i]));
        }
        System.err.println();
    }

    public static void VectPrint(String Message, int len, double[] w, int wShft, debugPrintout debug) {
        if (debug != null) {
            debug.println(Message);
            for (int i = 0; i < len; ++i) {
                debug.print(debugPrintout.formatNumber(8, 4, w[wShft + i]));
            }
            debug.println();
        } else {
            Optimization.VectPrint(Message, len, w, wShft);
        }
    }

    public static double[] VectScaleAndAdd(int len, double[] v1, int pV1Shft, double Sc, double[] v2, int pV2Shft, double[] v3, int pV3Shft) {
        if (v3 == null) {
            v3 = new double[len];
        }
        for (int i = 0; i < len; ++i) {
            v3[pV3Shft + i] = v1[pV1Shft + i] + Sc * v2[pV2Shft + i];
        }
        return v3;
    }

    public static void mMMultiply(Matrix a, Matrix b, Matrix c) {
        block6: {
            double[] w;
            int nCols;
            block7: {
                int nRows;
                block5: {
                    nRows = a.nRows;
                    nCols = b.nCols;
                    w = new double[b.nRows];
                    if (!a.mType.get(4)) break block5;
                    if (!a.mType.get(0)) break block5;
                    for (int i = 0; i < a.nCols; ++i) {
                        int bRowIndex = b.pShft + b.rowIndex(i);
                        int cRowIndex = c.pShft + c.rowIndex(i);
                        Optimization.VectScale(b.nCols, b.aVec, bRowIndex, a.getElement(i, i), c.aVec, cRowIndex);
                    }
                    break block6;
                }
                if (c.mType.get(3) || c.mType.get(2)) break block7;
                for (int i = 0; i < nCols; ++i) {
                    b.getCol(i, w, 0);
                    for (int j = 0; j < nRows; ++j) {
                        int aIndex = a.pShft + j * a.nCols;
                        c.aVec[c.pShft + j * c.nCols + i] = Optimization.VDot(b.nRows, a.aVec, aIndex, w, 0);
                    }
                }
                break block6;
            }
            if (!c.mType.get(3) && !c.mType.get(2)) break block6;
            c.mType.set(1);
            for (int i = 0; i < nCols; ++i) {
                b.getCol(i, w, 0);
                for (int j = 0; j <= i; ++j) {
                    int aIndex = a.pShft + j * a.nCols;
                    c.setElement(j, i, Optimization.VDot(b.nRows, a.aVec, aIndex, w, 0));
                }
            }
        }
    }

    public static Matrix mMMultiply(Matrix a, Matrix b, BitSet mType) {
        int nRows = a.nRows;
        int nCols = b.nCols;
        Matrix c = new Matrix(nRows, nCols, mType);
        Optimization.mMMultiply(a, b, c);
        return c;
    }

    public static Matrix mMMultiply(Matrix a, Matrix b) {
        BitSet mType = new BitSet(8);
        if (a.mType.get(0) || b.mType.get(0)) {
            mType.set(0);
        }
        return Optimization.mMMultiply(a, b, mType);
    }

    public static void mMtMultiply(Matrix a, Matrix b_tr, Matrix c) {
        block5: {
            int nCols;
            block4: {
                int nRows = a.nRows;
                nCols = b_tr.nRows;
                if (c.mType.get(3) || c.mType.get(2)) break block4;
                for (int i = 0; i < nCols; ++i) {
                    for (int j = 0; j < nRows; ++j) {
                        c.aVec[c.pShft + i * c.nCols + j] = Optimization.VDot(a, i, b_tr, j);
                    }
                }
                break block5;
            }
            if (!c.mType.get(3) && !c.mType.get(2)) break block5;
            c.mType.set(1);
            for (int i = 0; i < nCols; ++i) {
                for (int j = 0; j <= i; ++j) {
                    c.setElement(i, j, Optimization.VDot(a, i, b_tr, j));
                }
            }
        }
    }

    public static Matrix mMtMultiply(Matrix a, Matrix b_tr, BitSet mType) {
        int nRows = a.nRows;
        int nCols = b_tr.nRows;
        Matrix c = new Matrix(nRows, nCols, mType);
        Optimization.mMtMultiply(a, b_tr, c);
        return c;
    }

    public static Matrix mMtMultiply(Matrix a, Matrix b_tr) {
        BitSet mType = new BitSet(8);
        if (a.mType.get(0) || b_tr.mType.get(0)) {
            mType.set(0);
        }
        return Optimization.mMtMultiply(a, b_tr, mType);
    }

    public static void mtMtMultiply(Matrix a, Matrix b, Matrix c) {
        block5: {
            double[] w;
            int nRows;
            block4: {
                nRows = a.nCols;
                int nCols = b.nRows;
                w = new double[a.nRows];
                if (c.mType.get(3) || c.mType.get(2)) break block4;
                for (int i = 0; i < nRows; ++i) {
                    a.getCol(i, w, 0);
                    for (int j = 0; j < nCols; ++j) {
                        int bIndex = b.pShft + j * b.nCols;
                        c.aVec[c.pShft + i * c.nCols + j] = Optimization.VDot(a.nRows, b.aVec, bIndex, w, 0);
                    }
                }
                break block5;
            }
            if (!c.mType.get(3) && !c.mType.get(2)) break block5;
            c.mType.set(1);
            for (int i = 0; i < nRows; ++i) {
                a.getCol(i, w, 0);
                for (int j = 0; j <= i; ++j) {
                    int bIndex = b.pShft + j * b.nCols;
                    c.setElement(i, j, Optimization.VDot(a.nRows, b.aVec, bIndex, w, 0));
                }
            }
        }
    }

    public static Matrix mtMtMultiply(Matrix a, Matrix b, BitSet mType) {
        int nRows = a.nCols;
        int nCols = b.nRows;
        Matrix c = new Matrix(nRows, nCols, mType);
        Optimization.mtMtMultiply(a, b, c);
        return c;
    }

    public static Matrix mtMtMultiply(Matrix a, Matrix b) {
        BitSet mType = new BitSet(8);
        if (a.mType.get(0) || b.mType.get(0)) {
            mType.set(0);
        }
        return Optimization.mtMtMultiply(a, b, mType);
    }

    public static double[] mVMultiply(Matrix a, double[] v, int vLen, int vShft, double[] w, int wShft) {
        int wLen = a.nRows;
        int Len = Math.min(a.nCols, vLen);
        if (a.mType.get(4)) {
            Optimization.VVMul(Len, a.aVec, a.pShft, v, vShft, w, wShft);
        } else if (a.mType.get(2) && a.mType.get(1)) {
            int n = Math.min(a.nCols, wLen);
            Optimization.VectClear(wLen, w, wShft);
            int ij = 0;
            for (int ii = 0; ii < n; ++ii) {
                for (int jj = 0; jj < ii; ++jj) {
                    double a_ij = a.aVec[a.pShft + ij];
                    int n2 = wShft + ii;
                    w[n2] = w[n2] + v[jj] * a_ij;
                    int n3 = wShft + jj;
                    w[n3] = w[n3] + v[ii] * a_ij;
                    ++ij;
                }
                double a_ij = a.aVec[a.pShft + ij];
                int n4 = wShft + ii;
                w[n4] = w[n4] + v[ii] * a_ij;
                ++ij;
            }
        } else {
            double d = 0.0;
            for (int i = 0; i < wLen; ++i) {
                d = 0.0;
                if (a.mType.get(0)) {
                    if (a.mType.get(2) || a.mType.get(3)) {
                        int kStart = 0;
                        int kEnd = a.nCols;
                        if (!a.mType.get(1)) {
                            if (a.mType.get(3)) {
                                kStart = i;
                            } else {
                                kEnd = i + 1;
                            }
                        }
                        for (int k = kStart; k < kEnd; ++k) {
                            d += a.getElement(i, k) * v[vShft + k];
                        }
                    } else {
                        d = Optimization.VDot(Len, a.aVec, a.pShft + i * a.nCols, v, vShft);
                    }
                }
                w[i] = d;
            }
        }
        return w;
    }

    public static double[] mVMultiply(Matrix a, double[] v, int vShft) {
        int wLen = a.nRows;
        double[] w = new double[wLen];
        int vLen = a.nCols;
        return Optimization.mVMultiply(a, v, vLen, vShft, w, 0);
    }

    public static double[] mVMultiply(Matrix a, double[] v, int vShft, double[] w, int wShft) {
        int vLen = a.nCols;
        return Optimization.mVMultiply(a, v, vLen, vShft, w, wShft);
    }

    public static double[] vectVectDivide(int len, double[] v1, int v1Shft, double[] v2, int v2Shft, double[] v3, int v3Shft) {
        if (v3 == null) {
            v3 = new double[len];
            v3Shft = 0;
        }
        for (int i = 0; i < len; ++i) {
            if (!(Math.abs(v2[v1Shft + i]) > 1.0E-7)) continue;
            v3[v3Shft + i] = v1[v1Shft + i] / v2[v2Shft + i];
        }
        return v3;
    }

    public static double[] miVMultiply(Matrix a, double[] v, int vShft) {
        int wLen = a.nCols;
        double[] w = new double[wLen];
        return Optimization.miVMultiply(a, v, vShft, w, 0);
    }

    public static double[] miVMultiply(Matrix a, double[] v, int vShft, double[] w, int wShft) {
        if (!a.mType.get(7)) {
            a.Diagonalize();
        }
        double[] w1 = Optimization.mVMultiply(a.aLEV, v, vShft);
        w1 = Optimization.vectVectDivide(a.nRank, w1, 0, a.aEVa.aVec, a.aEVa.pShft, w1, 0);
        return Optimization.mtVMultiply(a.aREV, w1, 0, w, wShft);
    }

    public static double[] mitVMultiply(Matrix a, double[] v, int vShft) {
        int wLen = a.nRows;
        double[] w = new double[wLen];
        return Optimization.mitVMultiply(a, v, vShft, w, 0);
    }

    public static double[] mitVMultiply(Matrix a, double[] v, int vShft, double[] w, int wShft) {
        if (!a.mType.get(7)) {
            a.Diagonalize();
        }
        double[] w1 = Optimization.mVMultiply(a.aREV, v, vShft);
        w1 = Optimization.vectVectDivide(a.nRank, w1, 0, a.aEVa.aVec, a.aEVa.pShft, w1, 0);
        return Optimization.mtVMultiply(a.aLEV, w1, 0, w, wShft);
    }

    public static double[] mVMultiply(Matrix a, double[] v) {
        return Optimization.mVMultiply(a, v, 0);
    }

    public static double[] mtVMultiply(Matrix a, double[] v, int vShft) {
        double[] w = null;
        Optimization.mtVMultiply(a, v, vShft, w, 0);
        return w;
    }

    public static double[] mtVMultiply(Matrix a, double[] v, int vShft, double[] w, int wShft) {
        int wLen = a.nCols;
        int nVec = a.nRows;
        return Optimization.VLinComb(wLen, v, vShft, nVec, a.aVec, a.pShft, w, wShft);
    }

    public static Matrix cpMatrix(Matrix a) {
        Matrix b = new Matrix(a.nRows, a.nCols, a.mType);
        Optimization.cpMatrix(a, b);
        return b;
    }

    public static void cpMatrix(Matrix a, Matrix b) {
        if (a.aLen == b.aLen) {
            int shft;
            Optimization.VectCopy(a.aLen, a.aVec, a.pShft, b.aVec, b.pShft);
            if (a.mType.get(7)) {
                shft = 0;
                if (b.aEVa != null) {
                    shft = b.aEVa.pShft;
                }
                Optimization.VectCopy(a.aEVa.aLen, a.aEVa.aVec, a.aEVa.pShft, b.aEVa.aVec, shft);
                if (b.aLEV != null) {
                    shft = b.aLEV.pShft;
                }
                Optimization.VectCopy(a.aLEV.aLen, a.aLEV.aVec, a.aLEV.pShft, b.aLEV.aVec, shft);
                if (b.aLEV != null) {
                    shft = b.aREV.pShft;
                }
                Optimization.VectCopy(a.aREV.aLen, a.aREV.aVec, a.aREV.pShft, b.aREV.aVec, shft);
            }
            if (a.aMtr != null) {
                shft = 0;
                if (b.aMtr != null) {
                    shft = b.aMtr.pShft;
                }
                Optimization.VectCopy(a.aMtr.aLen, a.aMtr.aVec, a.aMtr.pShft, b.aMtr.aVec, shft);
            }
        } else {
            System.err.println("Length mismatch in cpMatrix");
            System.exit(-1);
        }
    }

    public static double[][] cpMatrixDB(Matrix a) {
        double[][] b = new double[a.nRows][a.nCols];
        Optimization.cpMatrix(a, b);
        return b;
    }

    public static void cpMatrix(Matrix a, double[][] b) {
        if (a.nRows != b.length) {
            System.err.println("Row count mismatch in cpMatrix");
        }
        for (int i = 0; i < a.nRows; ++i) {
            if (a.nCols != b[i].length) {
                System.err.println("Row length mismatch in cpMatrix");
            }
            for (int j = 0; j < a.nCols; ++j) {
                b[i][j] = a.getElement(i, j);
            }
        }
    }

    public static void SetRank(Matrix m) {
        Optimization.SetRank(m, m.zeroLimit);
    }

    public static void SetRank(Matrix m, double zLimit) {
        int nnRows;
        if (m.aEVa == null) {
            return;
        }
        int From = 0;
        int To = m.aEVa.nRows;
        for (int i = 0; i < m.aEVa.nRows; ++i) {
            if (Math.abs(m.aEVa.getElement(i, i)) > zLimit) {
                if (i >= To) break;
                ++From;
            }
            if (!(Math.abs(m.aEVa.getElement(i, i)) <= zLimit)) continue;
            To = i + 1;
        }
        if ((nnRows = To - From) > 0) {
            m.aEVa.removeRows(From, nnRows);
            if (m.aLEV != null) {
                m.aLEV.removeRows(From, nnRows);
            }
            if (m.aREV != null && m.aREV != m.aLEV) {
                m.aREV.removeRows(From, nnRows);
            }
        }
        m.nRank = m.aEVa.nRows;
        m.zeroLimit = zLimit;
    }

    public static void matrixDiagonalize(Matrix m, double small, double overlapLimit) {
        if (m.mType.get(7)) {
            return;
        }
        m.nRank = Math.min(m.nRows, m.nCols);
        boolean diagLoop = true;
        double ovl = 0.0;
        while (diagLoop) {
            if (m.mType.get(1)) {
                Optimization.matrixJacobiDiagonalize(m);
                Optimization.SortEigValVect(m);
                m.aREV = m.aLEV;
                Optimization.SetRank(m, small);
                diagLoop = false;
            } else {
                int i;
                BitSet symmMType = new BitSet(8);
                symmMType.set(2);
                Matrix mMt = Optimization.mMtMultiply(m, m, symmMType);
                Optimization.matrixJacobiDiagonalize(mMt);
                m.nRank = mMt.nRows;
                if (m.aLEV != null) {
                    Optimization.cpMatrix(mMt.aLEV, m.aLEV);
                } else {
                    m.aLEV = Optimization.cpMatrix(mMt.aLEV);
                }
                if (m.aEVa != null) {
                    Optimization.cpMatrix(mMt.aEVa, m.aEVa);
                } else {
                    m.aEVa = Optimization.cpMatrix(mMt.aEVa);
                }
                Optimization.SortEigValVect(m, RICTStep.debug);
                Optimization.SetRank(m, small);
                if (m.aREV != null) {
                    Optimization.mMMultiply(m.aLEV, m, m.aREV);
                } else {
                    m.aREV = Optimization.mMMultiply(m.aLEV, m);
                }
                m.aREV.Unitary();
                diagLoop = false;
                if (m.nRows == m.nCols) {
                    for (i = 0; i < m.aLEV.nRows && !diagLoop; ++i) {
                        double eVal = Math.sqrt(Math.abs(m.aEVa.getElement(i, i)));
                        ovl = Optimization.VDot(m.aLEV, i, m.aREV, i);
                        boolean bl = diagLoop = diagLoop || Math.abs(ovl) <= overlapLimit;
                        if (ovl < 0.0) {
                            Optimization.VectScale(m.aREV, i, -1.0, m.aREV, i);
                            eVal = -eVal;
                        }
                        m.aEVa.setElement(i, i, eVal);
                    }
                } else {
                    for (i = 0; i < m.aEVa.nRows; ++i) {
                        m.aEVa.setElement(i, i, Math.sqrt(Math.abs(m.aEVa.getElement(i, i))));
                    }
                }
                if (diagLoop) {
                    m.Symmetrize(0);
                } else {
                    Optimization.SortEigValVect(m);
                    Optimization.SetRank(m, small);
                }
            }
            if (!diagLoop) continue;
        }
        m.mType.set(7);
        if (m.nRank != m.aREV.nRows || m.nRank != m.aLEV.nRows) {
            int realRank;
            m.nRank = realRank = Math.min(Math.min(m.aLEV.nRows, m.aREV.nRows), m.nRank);
            m.aLEV.nRows = realRank;
            m.aREV.nRows = realRank;
        }
    }

    public static void SortEigValVect(Matrix m) {
        Optimization.SortEigValVect(m, null);
    }

    public static void SortEigValVect(final Matrix m, debugPrintout debug) {
        if (m.aEVa != null && m.aEVa.nRows > 0) {
            int i;
            sortEigValVect funcInterface = new sortEigValVect(m);
            debug = CleanArgs.getDebug();
            if (debug != null && debug.getWillPrint()) {
                debug.Tstart();
                debug.Trow();
                debug.TprintBC(m.aEVa.nRows - 2, "Before sort");
                debug.Trow();
                for (i = 0; i < m.aEVa.nRows - 2; ++i) {
                    debug.Tprint("" + debugPrintout.formatNumber(m.aEVa.getElement(i, i)));
                }
                debug.Trow();
                for (i = 0; i < m.aEVa.nRows - 2; ++i) {
                    debug.Tprint("" + debugPrintout.formatNumber(m.aEVa.getElement(i + 1, i + 1)));
                }
                debug.Trow();
                for (i = 0; i < m.aEVa.nRows - 2; ++i) {
                    debug.Tprint("" + funcInterface.isGreater(i, i + 1));
                }
                debug.Trow();
                for (i = 0; i < m.aEVa.nRows - 2; ++i) {
                    debug.Tprint("" + funcInterface.isGreater(i + 1, i));
                }
                debug.Tstop();
            }
            if ((debug = CleanArgs.getDebug()) == null || !debug.getWillPrint()) {
                Optimization.quickSort(0, m.aEVa.nRows - 1, funcInterface);
            } else {
                debug.incLevel("Detailed sort debug");
                Optimization.quickSortWithDebug(0, m.aEVa.nRows - 1, funcInterface, debug, new SortableGetter(){

                    @Override
                    public String get(int i) {
                        return debugPrintout.formatNumber(m.aEVa.getElement(i, i));
                    }
                });
                debug.decLevel();
            }
            if (!Optimization.isSorted(0, m.aEVa.nRows - 1, funcInterface)) {
                System.err.println("ERROR: SORT FAILED");
                if (debug != null) {
                    debug.reportError("SORT FAILED");
                }
            }
            if (debug != null && debug.getWillPrint()) {
                debug.Tstart();
                debug.Trow();
                debug.TprintBC(m.aEVa.nRows - 2, "After sort");
                debug.Trow();
                for (i = 0; i < m.aEVa.nRows - 2; ++i) {
                    debug.Tprint("" + debugPrintout.formatNumber(m.aEVa.getElement(i, i)));
                }
                debug.Trow();
                for (i = 0; i < m.aEVa.nRows - 2; ++i) {
                    debug.Tprint("" + debugPrintout.formatNumber(m.aEVa.getElement(i + 1, i + 1)));
                }
                debug.Trow();
                for (i = 0; i < m.aEVa.nRows - 2; ++i) {
                    debug.Tprint("" + funcInterface.isGreater(i, i + 1));
                }
                debug.Trow();
                for (i = 0; i < m.aEVa.nRows - 2; ++i) {
                    debug.Tprint("" + funcInterface.isGreater(i + 1, i));
                }
                debug.Tstop();
            }
        }
    }

    public static void matrixJacobiDiagonalize(Matrix m) {
        Matrix d;
        int ip;
        Matrix v;
        double JACOBI_EPS = 1.0E-5;
        int nrot = 0;
        if (m.nCols != m.nRows) {
            return;
        }
        int n = m.nCols;
        double[][] a = Optimization.cpMatrixDB(m);
        double[] b = new double[n];
        double[] z = new double[n];
        if (m.aLEV == null) {
            v = new Matrix(n, n);
            v.mType.set(5);
            m.aLEV = v;
        } else {
            v = m.aLEV;
        }
        for (ip = 0; ip < n; ++ip) {
            v.setElement(ip, ip, 1.0);
        }
        if (m.aEVa == null) {
            BitSet mType = new BitSet(8);
            mType.set(4);
            m.aEVa = d = new Matrix(n, n, mType);
        } else {
            d = m.aEVa;
        }
        for (ip = 0; ip < n; ++ip) {
            b[ip] = a[ip][ip];
            d.setElement(ip, ip, b[ip]);
        }
        for (int i = 1; i <= 50; ++i) {
            int iq;
            double sm = 0.0;
            for (ip = 0; ip < n - 1; ++ip) {
                for (iq = ip + 1; iq < n; ++iq) {
                    sm += Math.abs(a[ip][iq]);
                }
            }
            if (Math.abs(sm) < JACOBI_EPS) {
                return;
            }
            double tresh = i < 4 ? 0.2 * sm / (double)(n * n) : 0.0;
            for (ip = 0; ip < n - 1; ++ip) {
                for (iq = ip + 1; iq < n; ++iq) {
                    int j;
                    double t;
                    double g = 100.0 * Math.abs(a[ip][iq]);
                    double d_ip = d.getElement(ip, ip);
                    double d_iq = d.getElement(iq, iq);
                    if (i > 4 && Math.abs(d_ip) + g == Math.abs(d_ip) && Math.abs(d_iq) + g == Math.abs(d_iq)) {
                        a[ip][iq] = 0.0;
                        continue;
                    }
                    if (!(Math.abs(a[ip][iq]) > tresh)) continue;
                    double h = d_iq - d_ip;
                    if (Math.abs(h) + g == Math.abs(h)) {
                        t = a[ip][iq] / h;
                    } else {
                        double theta = 0.5 * h / a[ip][iq];
                        t = 1.0 / (Math.abs(theta) + Math.sqrt(1.0 + theta * theta));
                        if (theta < 0.0) {
                            t = -t;
                        }
                    }
                    double c = 1.0 / Math.sqrt(1.0 + t * t);
                    double s = t * c;
                    double tau = s / (1.0 + c);
                    h = t * a[ip][iq];
                    int n2 = ip;
                    z[n2] = z[n2] - h;
                    int n3 = iq;
                    z[n3] = z[n3] + h;
                    d.setElement(ip, ip, d_ip - h);
                    d.setElement(iq, iq, d_iq + h);
                    a[ip][iq] = 0.0;
                    for (j = 0; j < ip; ++j) {
                        Optimization.rotate(a, j, ip, j, iq, tau, s);
                    }
                    for (j = ip + 1; j < iq; ++j) {
                        Optimization.rotate(a, ip, j, j, iq, tau, s);
                    }
                    for (j = iq + 1; j < n; ++j) {
                        Optimization.rotate(a, ip, j, iq, j, tau, s);
                    }
                    for (j = 0; j < n; ++j) {
                        Optimization.rotate(v, ip, j, iq, j, tau, s);
                    }
                    ++nrot;
                }
            }
            for (ip = 0; ip < n; ++ip) {
                int n4 = ip;
                b[n4] = b[n4] + z[ip];
                d.setElement(ip, ip, b[ip]);
                z[ip] = 0.0;
            }
        }
    }

    static void rotate(double[][] a, int i, int j, int k, int l, double tau, double s) {
        double g = a[i][j];
        double h = a[k][l];
        a[i][j] = g - s * (h + g * tau);
        a[k][l] = h + s * (g - h * tau);
    }

    static void rotate(Matrix a, int i, int j, int k, int l, double tau, double s) {
        double g = a.aVec[a.pShft + i * a.nCols + j];
        double h = a.aVec[a.pShft + k * a.nCols + l];
        a.aVec[a.pShft + i * a.nCols + j] = g - s * (h + g * tau);
        a.aVec[a.pShft + k * a.nCols + l] = h + s * (g - h * tau);
    }

    static double[] OuterProduct3D(double[] v1, int p1, double[] v2, int p2) {
        return Optimization.OuterProduct3D(v1, p1, v2, p2, null, 0);
    }

    static double[] OuterProduct3D(double[] v1, int p1, double[] v2, int p2, double[] v3, int p3) {
        double[] r = v3;
        int rp = p3;
        boolean doCopy = false;
        if (v3 == null || v3 == v1 && p3 == p1 || v3 == v2 && p3 == p2) {
            doCopy = v3 != null;
            v3 = new double[3];
            p3 = 0;
            if (!doCopy) {
                r = v3;
                rp = p3;
            }
        }
        v3[p3] = v1[p1 + 1] * v2[p2 + 2] - v1[p1 + 2] * v2[p2 + 1];
        v3[p3 + 1] = v1[p1 + 2] * v2[p2] - v1[p1] * v2[p2 + 2];
        v3[p3 + 2] = v1[p1] * v2[p2 + 1] - v1[p1 + 1] * v2[p2];
        if (doCopy) {
            Optimization.VectCopy(3, v3, p3, r, rp);
            v3 = r;
            p3 = rp;
        }
        return r;
    }

    public static boolean isSorted(int From, int To, Sortable data) {
        for (int i = From; i < To; ++i) {
            if (!data.isGreater(i, i + 1)) continue;
            return false;
        }
        return true;
    }

    public static void quickSort(int From, int To, Sortable data) {
        Optimization.quickSort(From, To, data, null);
    }

    public static void quickSort(int From, int To, Sortable data, SortableCallback callback) {
        int left = From;
        int right = To;
        int base = (left + right) / 2;
        if (callback != null) {
            callback.invoked(From, To);
            callback.setBase(base);
        }
        while (true) {
            if (data.isGreater(base, left)) {
                ++left;
                continue;
            }
            while (data.isGreater(right, base)) {
                --right;
            }
            if (left <= right) {
                if (left != right) {
                    data.swap(left, right);
                    if (callback != null) {
                        callback.swapped(left, right);
                    }
                    if (base == left) {
                        base = right;
                        if (callback != null) {
                            callback.setBase(base);
                        }
                    } else if (base == right) {
                        base = left;
                        if (callback != null) {
                            callback.setBase(base);
                        }
                    }
                }
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (callback != null) {
            callback.swapsdone(From, To);
        }
        if (From < right) {
            if (callback != null) {
                callback.newrun(From, right);
            }
            Optimization.quickSort(From, right, data, callback);
            if (callback != null) {
                callback.returned(From, right);
            }
        }
        if (left < To) {
            if (callback != null) {
                callback.newrun(left, To);
            }
            Optimization.quickSort(left, To, data, callback);
            if (callback != null) {
                callback.returned(left, To);
            }
        }
        if (callback != null) {
            callback.done(From, To);
        }
    }

    public static void quickSortWithDebug(final int From, int To, Sortable data, final debugPrintout debug, final SortableGetter getter) {
        if (debug == null || !debug.getWillPrint() || getter == null) {
            Optimization.quickSort(From, To, data);
            return;
        }
        debug.Tstart();
        debug.TprintBC(To - From + 2, "Detailed quicksort trace");
        Optimization.quickSort(From, To, data, new SortableCallback(){

            @Override
            public void invoked(int from, int to) {
                int i;
                debug.Trow();
                debug.TprintBC("Invoked");
                for (i = From; i < from; ++i) {
                    debug.Tprint("");
                }
                for (i = from; i <= to; ++i) {
                    debug.Tprint(getter.get(i));
                }
            }

            @Override
            public void swapped(int i, int j) {
                int x;
                debug.Trow();
                debug.TprintBC("swap");
                int a = Math.min(i, j);
                int b = Math.max(i, j);
                for (x = From; x < a; ++x) {
                    debug.Tprint("");
                }
                debug.Tprint(getter.get(a));
                if (b > a) {
                    for (x = a + 1; x < b; ++x) {
                        debug.Tprint("");
                    }
                    debug.Tprint(getter.get(b));
                }
            }

            @Override
            public void swapsdone(int from, int to) {
                int i;
                debug.Trow();
                debug.TprintBC("Swaps done");
                for (i = From; i < from; ++i) {
                    debug.Tprint("");
                }
                for (i = from; i <= to; ++i) {
                    debug.Tprint(getter.get(i));
                }
            }

            @Override
            public void setBase(int i) {
                debug.Trow();
                debug.TprintBC("Set base");
                for (int j = From; j < i; ++j) {
                    debug.Tprint("");
                }
                debug.Tprint(getter.get(i));
            }

            @Override
            public void newrun(int from, int to) {
            }

            @Override
            public void returned(int from, int to) {
            }

            @Override
            public void done(int from, int to) {
                int i;
                debug.Trow();
                debug.TprintBC("Done");
                for (i = From; i < from; ++i) {
                    debug.Tprint("");
                }
                for (i = from; i <= to; ++i) {
                    debug.Tprint(getter.get(i));
                }
            }
        });
        debug.Tstop();
    }

    static {
        M_STORE = 20;
    }

    public static class RICTStep {
        public static final int FLAG_SUCCESS = 0;
        public static final int FLAG_FAILED = 1;
        public static final int FLAG_STEPLIMITREACH = 2;
        public static debugPrintout debug = null;
        public int maxstep = 40;
        public int laststeps = -1;
        public double convLimit = 1.0E-6;
        public double dXMaxAllowed = 0.2;

        double getQValue(int nDim, double[] coord, int[] qDef) {
            int i1 = 0;
            int i2 = 0;
            int i3 = 0;
            int i4 = 0;
            int qType = qDef[0] & 0xF;
            int qLen = 0;
            qLen = qType < 3 ? 1 : (qType == 3 ? 2 : (qType == 4 ? 3 : 4));
            double value = 0.0;
            switch (qType) {
                case 0: {
                    i1 = qDef[1] * nDim;
                    value = coord[i1];
                    break;
                }
                case 1: {
                    i1 = qDef[1] * nDim + 1;
                    value = coord[i1];
                    break;
                }
                case 2: {
                    i1 = qDef[1] * nDim + 2;
                    value = coord[i1];
                    break;
                }
                case 3: {
                    i1 = qDef[1] * nDim;
                    i2 = qDef[2] * nDim;
                    double[] b = Optimization.VectSubstract(nDim, coord, i2, coord, i1);
                    value = Math.sqrt(Optimization.VDot(nDim, b, 0, b, 0));
                    break;
                }
                case 4: {
                    i1 = qDef[1] * nDim;
                    i2 = qDef[2] * nDim;
                    i3 = qDef[3] * nDim;
                    double cosAngle = Optimization.VDot(nDim, Optimization.VectUnit(nDim, Optimization.VectSubstract(nDim, coord, i2, coord, i1), 0, null), 0, Optimization.VectUnit(nDim, Optimization.VectSubstract(nDim, coord, i2, coord, i3), 0, null), 0);
                    cosAngle = Math.max(-1.0, Math.min(1.0, cosAngle));
                    value = Math.acos(cosAngle);
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    i1 = qDef[1] * nDim;
                    i2 = qDef[2] * nDim;
                    i3 = qDef[3] * nDim;
                    i4 = qDef[4] * nDim;
                    double[] nb12 = Optimization.VectUnit(nDim, Optimization.VectSubstract(nDim, coord, i1, coord, i2), 0, null);
                    double[] nb23 = Optimization.VectUnit(nDim, Optimization.VectSubstract(nDim, coord, i2, coord, i3), 0, null);
                    double[] nb34 = Optimization.VectUnit(nDim, Optimization.VectSubstract(nDim, coord, i3, coord, i4), 0, null);
                    double[] e1 = Optimization.VectUnit(nDim, Optimization.OuterProduct3D(nb12, 0, nb23, 0), 0, null);
                    double[] e2 = Optimization.VectUnit(nDim, Optimization.OuterProduct3D(nb23, 0, nb34, 0), 0, null);
                    double cosAngle = Optimization.VDot(nDim, e1, 0, e2, 0);
                    cosAngle = Math.max(-1.0, Math.min(1.0, cosAngle));
                    value = Math.acos(cosAngle);
                    if (!(Optimization.VDot(nDim, nb23, 0, Optimization.OuterProduct3D(e1, 0, e2, 0), 0) > 0.0)) break;
                    value *= -1.0;
                }
            }
            return value;
        }

        double[] getQValues(int nA, int nDim, int nQ, double[] coord, int[][] qDef, double[] qVal) {
            if (qVal == null) {
                qVal = new double[nQ];
            }
            for (int iQ = 0; iQ < nQ; ++iQ) {
                qVal[iQ] = this.getQValue(nDim, coord, qDef[iQ]);
            }
            return qVal;
        }

        double[] getDeltaQValues(int nA, int nDim, int nQ, double[] coord, int[][] qDef, double[] qVal, double[] dQVal) {
            double torsLimit = 0.05;
            if (dQVal == null) {
                dQVal = new double[nQ];
            }
            for (int iQ = 0; iQ < nQ; ++iQ) {
                dQVal[iQ] = qVal[iQ] - this.getQValue(nDim, coord, qDef[iQ]);
                if (qDef[iQ][0] != 8) continue;
                while (dQVal[iQ] > Math.PI) {
                    int n = iQ;
                    dQVal[n] = dQVal[n] - Math.PI * 2;
                }
                while (dQVal[iQ] < -Math.PI) {
                    int n = iQ;
                    dQVal[n] = dQVal[n] + Math.PI * 2;
                }
                dQVal[iQ] = Math.max(Math.min(torsLimit, dQVal[iQ]), -torsLimit);
            }
            return dQVal;
        }

        Matrix buildSingleAtomBtMatrix(int nA, int iA, int nDim, int nQ, double[] coord, int[][] qDef, Matrix BtMat) {
            boolean doDebug;
            boolean bl = doDebug = debug != null;
            if (nDim != 3) {
                return null;
            }
            if (BtMat == null) {
                BtMat = new Matrix(nDim, nQ);
            }
            int nC = nDim * nA;
            BtMat.mType.clear(7);
            BtMat.nRows = nDim;
            BtMat.nCols = nQ;
            int bLineLen = 4 * nDim;
            double[] bLine = new double[bLineLen];
            int i1 = 0;
            int i2 = 0;
            int i3 = 0;
            int i4 = 0;
            for (int iQ = 0; iQ < nQ; ++iQ) {
                Optimization.VectClear(bLineLen, bLine, 0);
                int qType = qDef[iQ][0] & 0xF;
                int qLen = 0;
                qLen = qType < 3 ? 1 : (qType == 3 ? 2 : (qType == 4 ? 3 : 4));
                if (qType == 0) {
                    bLine[0] = 1.0;
                }
                if (qType == 1) {
                    bLine[1] = 1.0;
                }
                if (qType == 2) {
                    bLine[2] = 1.0;
                }
                if (qType == 3) {
                    i1 = qDef[iQ][1] * nDim;
                    i2 = qDef[iQ][2] * nDim;
                    double[] d = Optimization.VectUnit(nDim, Optimization.VectSubstract(nDim, coord, i2, coord, i1), 0, null);
                    Optimization.VectSubstract(nDim, bLine, 0, d, 0, bLine, 0);
                    Optimization.VectAdd(nDim, bLine, nDim, d, 0, bLine, nDim);
                }
                if (qType == 4) {
                    i1 = qDef[iQ][1] * nDim;
                    i2 = qDef[iQ][2] * nDim;
                    i3 = qDef[iQ][3] * nDim;
                    double[] b1 = Optimization.VectSubstract(nDim, coord, i2, coord, i1);
                    double b1sq = Optimization.VDot(nDim, b1, 0, b1, 0);
                    double[] b2 = Optimization.VectSubstract(nDim, coord, i2, coord, i3);
                    double b2sq = Optimization.VDot(nDim, b2, 0, b2, 0);
                    double[] v = Optimization.VectUnit(nDim, Optimization.OuterProduct3D(b1, 0, b2, 0), 0, null);
                    double[] w = Optimization.OuterProduct3D(b1, 0, v, 0);
                    Optimization.VectScale(nDim, w, 0, -1.0 / b1sq, w, 0);
                    Optimization.VectAdd(nDim, bLine, 0, w, 0, bLine, 0);
                    Optimization.VectSubstract(nDim, bLine, nDim, w, 0, bLine, nDim);
                    w = Optimization.OuterProduct3D(v, 0, b2, 0);
                    Optimization.VectScale(nDim, w, 0, -1.0 / b2sq, w, 0);
                    Optimization.VectAdd(nDim, bLine, 2 * nDim, w, 0, bLine, 2 * nDim);
                    Optimization.VectSubstract(nDim, bLine, nDim, w, 0, bLine, nDim);
                }
                if (qType == 5) {
                    // empty if block
                }
                if (qType == 6) {
                    // empty if block
                }
                if (qType == 7) {
                    // empty if block
                }
                if (qType == 8) {
                    i1 = qDef[iQ][1] * nDim;
                    i2 = qDef[iQ][2] * nDim;
                    i3 = qDef[iQ][3] * nDim;
                    i4 = qDef[iQ][4] * nDim;
                    double[] ub12 = Optimization.VectSubstract(nDim, coord, i1, coord, i2);
                    double[] ub23 = Optimization.VectSubstract(nDim, coord, i2, coord, i3);
                    double[] ub34 = Optimization.VectSubstract(nDim, coord, i3, coord, i4);
                    double len12 = Math.sqrt(Optimization.VDot(nDim, ub12, 0, ub12, 0));
                    double len23 = Math.sqrt(Optimization.VDot(nDim, ub23, 0, ub23, 0));
                    double len34 = Math.sqrt(Optimization.VDot(nDim, ub34, 0, ub34, 0));
                    Optimization.VectScale(nDim, ub12, 0, 1.0 / len12, ub12, 0);
                    Optimization.VectScale(nDim, ub23, 0, 1.0 / len23, ub23, 0);
                    Optimization.VectScale(nDim, ub34, 0, 1.0 / len34, ub34, 0);
                    double cos123 = Optimization.VDot(nDim, ub12, 0, ub23, 0);
                    double sinsq123 = 1.0 - cos123 * cos123;
                    double cos234 = Optimization.VDot(nDim, ub23, 0, ub34, 0);
                    double sinsq234 = 1.0 - cos234 * cos234;
                    double[] vp123 = Optimization.OuterProduct3D(ub12, 0, ub23, 0);
                    double[] vp234 = Optimization.OuterProduct3D(ub23, 0, ub34, 0);
                    double c1 = -1.0 / (len12 * sinsq123);
                    double c2 = 1.0 / (len34 * sinsq234);
                    double c3 = cos123 / (len23 * sinsq123);
                    double c4 = cos234 / (len23 * sinsq234);
                    Optimization.VectScaleAndAdd(nDim, bLine, 0, c1, vp123, 0, bLine, 0);
                    Optimization.VectScaleAndAdd(nDim, bLine, nDim, -c1 + c3, vp123, 0, bLine, nDim);
                    Optimization.VectScaleAndAdd(nDim, bLine, nDim, c4, vp234, 0, bLine, nDim);
                    Optimization.VectScaleAndAdd(nDim, bLine, 2 * nDim, -c2 - c4, vp234, 0, bLine, 2 * nDim);
                    Optimization.VectScaleAndAdd(nDim, bLine, 2 * nDim, -c3, vp123, 0, bLine, 2 * nDim);
                    Optimization.VectScaleAndAdd(nDim, bLine, 3 * nDim, c2, vp234, 0, bLine, 3 * nDim);
                }
                for (int jQ = 0; jQ < qLen; ++jQ) {
                    if (qDef[iQ][jQ + 1] != iA) continue;
                    for (int k = 0; k < nDim; ++k) {
                        BtMat.setElement(k, iQ, bLine[jQ * nDim + k]);
                    }
                }
            }
            return BtMat;
        }

        Matrix buildBMatrices(int nA, int nDim, int nQ, double[] coord, int[][] qDef, Matrix fullBMat, Matrix cnstBMat, boolean doFrozen) {
            int iQ;
            boolean doDebug;
            boolean bl = doDebug = debug != null;
            if (fullBMat == null) {
                return null;
            }
            if (nDim != 3) {
                return null;
            }
            int nC = nDim * nA;
            fullBMat.mType.clear(7);
            fullBMat.nRows = nQ;
            fullBMat.nCols = nC;
            int bLineLen = 4 * nDim;
            double[] bLine = new double[bLineLen];
            int i1 = 0;
            int i2 = 0;
            int i3 = 0;
            int i4 = 0;
            for (int iQ2 = 0; iQ2 < nQ; ++iQ2) {
                Optimization.VectClear(bLineLen, bLine, 0);
                int indRow = fullBMat.pShft + fullBMat.rowIndex(iQ2);
                Optimization.VectClear(nC, fullBMat.aVec, indRow);
                int qType = qDef[iQ2][0] & 0xF;
                int qLen = 0;
                qLen = qType < 3 ? 1 : (qType == 3 ? 2 : (qType == 4 ? 3 : 4));
                if (qType == 0) {
                    bLine[0] = 1.0;
                }
                if (qType == 1) {
                    bLine[1] = 1.0;
                }
                if (qType == 2) {
                    bLine[2] = 1.0;
                }
                if (qType == 3) {
                    i1 = qDef[iQ2][1] * nDim;
                    i2 = qDef[iQ2][2] * nDim;
                    double[] d = Optimization.VectUnit(nDim, Optimization.VectSubstract(nDim, coord, i2, coord, i1), 0, null);
                    Optimization.VectSubstract(nDim, bLine, 0, d, 0, bLine, 0);
                    Optimization.VectAdd(nDim, bLine, nDim, d, 0, bLine, nDim);
                }
                if (qType == 4) {
                    i1 = qDef[iQ2][1] * nDim;
                    i2 = qDef[iQ2][2] * nDim;
                    i3 = qDef[iQ2][3] * nDim;
                    double[] b1 = Optimization.VectSubstract(nDim, coord, i2, coord, i1);
                    double b1sq = Optimization.VDot(nDim, b1, 0, b1, 0);
                    double[] b2 = Optimization.VectSubstract(nDim, coord, i2, coord, i3);
                    double b2sq = Optimization.VDot(nDim, b2, 0, b2, 0);
                    double[] v = Optimization.VectUnit(nDim, Optimization.OuterProduct3D(b1, 0, b2, 0), 0, null);
                    double[] w = Optimization.OuterProduct3D(b1, 0, v, 0);
                    Optimization.VectScale(nDim, w, 0, -1.0 / b1sq, w, 0);
                    Optimization.VectAdd(nDim, bLine, 0, w, 0, bLine, 0);
                    Optimization.VectSubstract(nDim, bLine, nDim, w, 0, bLine, nDim);
                    w = Optimization.OuterProduct3D(v, 0, b2, 0);
                    Optimization.VectScale(nDim, w, 0, -1.0 / b2sq, w, 0);
                    Optimization.VectAdd(nDim, bLine, 2 * nDim, w, 0, bLine, 2 * nDim);
                    Optimization.VectSubstract(nDim, bLine, nDim, w, 0, bLine, nDim);
                }
                if (qType == 5) {
                    // empty if block
                }
                if (qType == 6) {
                    // empty if block
                }
                if (qType == 7) {
                    // empty if block
                }
                if (qType == 8) {
                    i1 = qDef[iQ2][1] * nDim;
                    i2 = qDef[iQ2][2] * nDim;
                    i3 = qDef[iQ2][3] * nDim;
                    i4 = qDef[iQ2][4] * nDim;
                    double[] ub12 = Optimization.VectSubstract(nDim, coord, i1, coord, i2);
                    double[] ub23 = Optimization.VectSubstract(nDim, coord, i2, coord, i3);
                    double[] ub34 = Optimization.VectSubstract(nDim, coord, i3, coord, i4);
                    double len12 = Math.sqrt(Optimization.VDot(nDim, ub12, 0, ub12, 0));
                    double len23 = Math.sqrt(Optimization.VDot(nDim, ub23, 0, ub23, 0));
                    double len34 = Math.sqrt(Optimization.VDot(nDim, ub34, 0, ub34, 0));
                    Optimization.VectScale(nDim, ub12, 0, 1.0 / len12, ub12, 0);
                    Optimization.VectScale(nDim, ub23, 0, 1.0 / len23, ub23, 0);
                    Optimization.VectScale(nDim, ub34, 0, 1.0 / len34, ub34, 0);
                    double cos123 = Optimization.VDot(nDim, ub12, 0, ub23, 0);
                    double sinsq123 = 1.0 - cos123 * cos123;
                    double cos234 = Optimization.VDot(nDim, ub23, 0, ub34, 0);
                    double sinsq234 = 1.0 - cos234 * cos234;
                    double[] vp123 = Optimization.OuterProduct3D(ub12, 0, ub23, 0);
                    double[] vp234 = Optimization.OuterProduct3D(ub23, 0, ub34, 0);
                    double c1 = -1.0 / (len12 * sinsq123);
                    double c2 = 1.0 / (len34 * sinsq234);
                    double c3 = cos123 / (len23 * sinsq123);
                    double c4 = cos234 / (len23 * sinsq234);
                    Optimization.VectScaleAndAdd(nDim, bLine, 0, c1, vp123, 0, bLine, 0);
                    Optimization.VectScaleAndAdd(nDim, bLine, nDim, -c1 + c3, vp123, 0, bLine, nDim);
                    Optimization.VectScaleAndAdd(nDim, bLine, nDim, c4, vp234, 0, bLine, nDim);
                    Optimization.VectScaleAndAdd(nDim, bLine, 2 * nDim, -c2 - c4, vp234, 0, bLine, 2 * nDim);
                    Optimization.VectScaleAndAdd(nDim, bLine, 2 * nDim, -c3, vp123, 0, bLine, 2 * nDim);
                    Optimization.VectScaleAndAdd(nDim, bLine, 3 * nDim, c2, vp234, 0, bLine, 3 * nDim);
                }
                for (int jQ = 0; jQ < qLen; ++jQ) {
                    Optimization.VectCopy(nDim, bLine, jQ * nDim, fullBMat.aVec, indRow + qDef[iQ2][jQ + 1] * nDim);
                }
                if (!doDebug) continue;
            }
            int nFQ = 0;
            if (doFrozen) {
                for (iQ = 0; iQ < nQ; ++iQ) {
                    if ((0x10 & qDef[iQ][0]) != 16) continue;
                    ++nFQ;
                    break;
                }
                boolean bl2 = doFrozen = nFQ > 0;
            }
            if (doFrozen) {
                if (cnstBMat == null) {
                    cnstBMat = new Matrix(nQ, nC);
                } else {
                    cnstBMat.nRows = nQ;
                    cnstBMat.nCols = nC;
                }
                for (iQ = 0; iQ < nQ; ++iQ) {
                    Optimization.VectClear(nC, cnstBMat.aVec, cnstBMat.pShft + cnstBMat.rowIndex(iQ));
                    if ((0x10 & qDef[iQ][0]) != 16) continue;
                    int indRowF = fullBMat.pShft + fullBMat.rowIndex(iQ);
                    cnstBMat.setRow(iQ, fullBMat.aVec, indRowF);
                }
            }
            return cnstBMat;
        }

        public int doSingleAtomStep(RICT env) {
            boolean doDebug = debug != null && debug.getWillPrint();
            int nDim = env.getDimensionCount();
            int nA = env.getAtomCount();
            int nQ = env.getInternalCoordinateCount();
            int nC = nDim * nA;
            double[] coord = env.getCartesianCoordinates();
            if (doDebug) {
                Optimization.VectPrint("Initial Cartesian coordinates", nC, coord, 0, debug);
                env.requestStructureWindow();
            }
            int[][] qDef = env.getInternalCoordinateDescriptors();
            double[] metric = env.getMetric();
            if (doDebug) {
                debug.println(" We are going to make an internal coordinate step! ");
                debug.println("nA: " + nA + " nC: " + nC + " nQ: " + nQ + " nDim: " + nDim);
            }
            boolean converged = false;
            if (nDim != 3) {
                return 1;
            }
            double[] qGoal = env.getInternalCoordinateValues();
            double[] qGoalOrig = Optimization.VectCopy(nQ, qGoal, 0);
            double[] dQ = new double[nQ];
            double[] dQTmp = new double[nQ];
            double[] dQScr = new double[nQ];
            double[] dQC = new double[nQ];
            double[] dQCTmp = new double[nQ];
            double[] dX = new double[nC];
            double[] dXOld = new double[nC];
            double[] dXTmp = new double[nC];
            Optimization.VectClear(nC, dXOld, 0);
            double ScOld = 0.0;
            int workingSpaceStart = workingSpace.wEnd;
            for (int iCyc = 0; iCyc <= this.maxstep; ++iCyc) {
                double Sc;
                double dXMax;
                this.laststeps = iCyc;
                int cycMod = iCyc % 5;
                Matrix BtMat = new Matrix(nDim, nQ);
                this.getDeltaQValues(nA, nDim, nQ, coord, qDef, qGoal, dQ);
                BtMat = this.buildSingleAtomBtMatrix(nA, 0, nDim, nQ, coord, qDef, BtMat);
                if (iCyc == 0 && doDebug) {
                    BtMat.Print("Full B-matrix:", debug);
                    debug.println("Starting coordinates: ");
                    for (int iA = 0; iA < nA; ++iA) {
                        for (int j = 0; j < 3; ++j) {
                            debug.print(" " + coord[iA * 3 + j]);
                        }
                        debug.println();
                    }
                }
                try {
                    BtMat.Diagonalize(1.0E-8);
                }
                catch (Exception e) {
                    if (CleanArgs.verboseLevel > 0) {
                        CleanArgs.verbose("Error in RICT");
                        CleanArgs.verbose(e.getMessage());
                    }
                    return 0;
                }
                if (doDebug) {
                    Optimization.VectPrint("Desired internal coordinate step:", nQ, dQ, 0, debug);
                    Optimization.VectPrint("Eigenvalues of the full B-matrix:", BtMat.aEVa.nRows, BtMat.aEVa.aVec, BtMat.aEVa.pShft, debug);
                    Optimization.VectPrint("Eigenvalues of the frozen part B-matrix:", BtMat.aEVa.nRows, BtMat.aEVa.aVec, BtMat.aEVa.pShft, debug);
                }
                Optimization.mitVMultiply(BtMat, dQ, 0, dX, 0);
                Optimization.mtVMultiply(BtMat, dX, 0, dQTmp, 0);
                if (iCyc > 15 && cycMod == 0) {
                    Optimization.VectAdd(nQ, this.getQValues(nA, nDim, nQ, coord, qDef, null), 0, dQTmp, 0, qGoal, 0);
                }
                if (doDebug) {
                    Optimization.VectPrint("Internal coordinate representation of the Cartesian step:", nQ, dQTmp, 0, debug);
                }
                boolean bl = converged = (dXMax = Optimization.VectMaxComponent(nC, dX, 0, true)) <= this.convLimit;
                if (doDebug) {
                    debug.println("Cycle: " + iCyc + " dXMax: " + dXMax + " Limit: " + this.convLimit + " " + converged);
                }
                if (Double.isInfinite(dXMax) || Double.isNaN(dXMax)) {
                    if (doDebug) {
                        debug.println("NAN OR INF STEP, FAILED!");
                    }
                    return 1;
                }
                workingSpace.wEnd = workingSpaceStart;
                if (!converged) {
                    double SP;
                    if (ScOld > 0.0 && (SP = Optimization.VDot(nC, dX, 0, dXOld, 0)) < 0.0) {
                        double sOLen = Math.sqrt(Optimization.VDot(nC, dXOld, 0, dXOld, 0)) / ScOld;
                        double ScOStep = 1.0 / (1.0 - SP / (Math.sqrt(Optimization.VDot(nC, dXOld, 0, dXOld, 0)) / ScOld));
                        if (ScOStep < 0.8) {
                            Optimization.VectScaleAndAdd(nC, Optimization.VectScale(nC, dXOld, 0, (1.0 + ScOld) * (1.0 - ScOStep), dXTmp, 0), 0, ScOStep, dX, 0, dX, 0);
                            dXMax = Optimization.VectMaxComponent(nC, dX, 0, true);
                            if (doDebug) {
                                debug.println("BackScale: " + ScOStep);
                            }
                        }
                    }
                    double Sc0 = 1.0;
                    if (dXMax > this.dXMaxAllowed) {
                        Sc0 = this.dXMaxAllowed / dXMax;
                        dXTmp = Optimization.VectScaleAndAdd(nC, coord, 0, Sc0, dX, 0, dXTmp, 0);
                        if (doDebug) {
                            debug.println("ScaleAllowed: " + Sc0);
                        }
                    } else {
                        dXTmp = Optimization.VectAdd(nC, coord, 0, dX, 0, dXTmp, 0);
                    }
                    this.getDeltaQValues(nA, nDim, nQ, coord, qDef, this.getQValues(nA, nDim, nQ, dXTmp, qDef, null), dQ);
                    double len0 = Optimization.VDot(nQ, Optimization.VectUnit(nQ, dQ, 0, null), 0, dQTmp, 0);
                    double len1 = Optimization.VDot(nQ, Optimization.VectUnit(nQ, dQ, 0, null), 0, dQ, 0);
                    Sc = Math.max(0.01, Math.min(1.0, len0 / len1)) * Sc0;
                    Optimization.VectScaleAndAdd(nC, coord, 0, Sc, dX, 0, coord, 0);
                    if (doDebug) {
                        Optimization.VectPrint("Realized internal coordinate step:", nQ, dQ, 0, debug);
                        Optimization.VectPrint("Cartesian coordinate step before scale", nC, dX, 0, debug);
                        debug.println("Scaling step by: " + Sc);
                        Optimization.VectPrint("Cartesian coordinates after step", nC, dXTmp, 0, debug);
                        Optimization.VectPrint("Internal coordinates after step:", nQ, this.getQValues(nA, nDim, nQ, coord, qDef, null), 0, debug);
                        env.requestStructureWindow();
                    }
                } else {
                    return 0;
                }
                Optimization.VectCopy(nC, dX, 0, dXOld, 0);
                ScOld = Sc;
            }
            workingSpace.wEnd = workingSpaceStart;
            if (!U.isDoubleOK(env.getCartesianCoordinates()) || !U.isDoubleOK(env.getInternalCoordinateValues())) {
                return 1;
            }
            return 0;
        }

        public int doStep(RICT env) {
            boolean doDebug = debug != null && debug.getWillPrint();
            int nDim = env.getDimensionCount();
            int nA = env.getAtomCount();
            int nQ = env.getInternalCoordinateCount();
            int nC = nDim * nA;
            double[] coord = env.getCartesianCoordinates();
            if (doDebug) {
                Optimization.VectPrint("Initial Cartesian coordinates", nC, coord, 0, debug);
                env.requestStructureWindow();
            }
            int[][] qDef = env.getInternalCoordinateDescriptors();
            double[] metric = env.getMetric();
            if (doDebug) {
                debug.println(" We are going to make an internal coordinate step! ");
                debug.println("nA: " + nA + " nC: " + nC + " nQ: " + nQ + " nDim: " + nDim);
            }
            boolean converged = false;
            if (nDim != 3) {
                return 1;
            }
            int nQC = 0;
            boolean doFrozen = true;
            double[] qGoal = env.getInternalCoordinateValues();
            double[] qGoalOrig = Optimization.VectCopy(nQ, qGoal, 0);
            double[] dQ = new double[nQ];
            double[] dQTmp = new double[nQ];
            double[] dQScr = new double[nQ];
            double[] dQC = new double[nQ];
            double[] dQCTmp = new double[nQ];
            double[] dX = new double[nC];
            double[] dXOld = new double[nC];
            double[] dXTmp = new double[nC];
            Optimization.VectClear(nC, dXOld, 0);
            double ScOld = 0.0;
            int workingSpaceStart = workingSpace.wEnd;
            for (int iCyc = 0; iCyc <= this.maxstep; ++iCyc) {
                double Sc;
                double dXMax;
                this.laststeps = iCyc;
                int cycMod = iCyc % 5;
                Matrix fullBMat = new Matrix(nQ, nC);
                Matrix cnstBMat = null;
                this.getDeltaQValues(nA, nDim, nQ, coord, qDef, qGoal, dQ);
                nQC = 0;
                Optimization.VectClear(nQ, dQC, 0);
                for (int iQ = 0; iQ < nQ; ++iQ) {
                    if ((qDef[iQ][0] & 0x10) == 16) {
                        dQC[iQ] = dQ[iQ];
                        ++nQC;
                    }
                    int qType = qDef[iQ][0] & 0xF;
                    int qLen = 0;
                    qLen = qType < 3 ? 1 : (qType == 3 ? 2 : (qType == 4 ? 3 : 4));
                    if (iCyc != 0 || !doDebug) continue;
                    debug.print(iQ + ": qDef: " + qDef[iQ][0] + "   ");
                    for (int iiQ = 1; iiQ <= qLen; ++iiQ) {
                        debug.print(" " + qDef[iQ][iiQ]);
                    }
                    debug.println();
                }
                doFrozen = nQC > 0;
                cnstBMat = this.buildBMatrices(nA, nDim, nQ, coord, qDef, fullBMat, cnstBMat, doFrozen);
                if (iCyc == 0 && doDebug) {
                    fullBMat.Print("Full B-matrix:", debug);
                    debug.println("Starting coordinates: ");
                    for (int iA = 0; iA < nA; ++iA) {
                        for (int j = 0; j < 3; ++j) {
                            debug.print(" " + coord[iA * 3 + j]);
                        }
                        debug.println();
                    }
                }
                fullBMat.Diagonalize(0.001);
                boolean bl = doFrozen = cnstBMat != null;
                if (doFrozen) {
                    cnstBMat.Diagonalize(0.001);
                }
                if (doDebug) {
                    Optimization.VectPrint("Desired internal coordinate step:", nQ, dQ, 0, debug);
                    Optimization.VectPrint("Eigenvalues of the full B-matrix:", fullBMat.aEVa.nRows, fullBMat.aEVa.aVec, fullBMat.aEVa.pShft, debug);
                    Optimization.VectPrint("Eigenvalues of the frozen part B-matrix:", cnstBMat.aEVa.nRows, cnstBMat.aEVa.aVec, cnstBMat.aEVa.pShft, debug);
                }
                if (doFrozen) {
                    Optimization.miVMultiply(fullBMat, dQ, 0, dXTmp, 0);
                    Optimization.mVMultiply(fullBMat, dXTmp, 0, dQTmp, 0);
                    Optimization.miVMultiply(cnstBMat, dQC, 0, dXTmp, 0);
                    Optimization.mVMultiply(fullBMat, dXTmp, 0, dQCTmp, 0);
                    dXTmp = Optimization.miVMultiply(cnstBMat, dQTmp, 0, dXTmp, 0);
                    dQC = Optimization.mVMultiply(fullBMat, dXTmp, 0, dQC, 0);
                    dQ = Optimization.VectAdd(nQ, dQCTmp, 0, Optimization.VectSubstract(nQ, dQTmp, 0, dQC, 0), 0, dQ, 0);
                    if (iCyc != 0 && cycMod == 0) {
                        Optimization.VectAdd(nQ, this.getQValues(nA, nDim, nQ, coord, qDef, null), 0, dQ, 0, qGoal, 0);
                    }
                }
                Optimization.miVMultiply(fullBMat, dQ, 0, dX, 0);
                Optimization.mVMultiply(fullBMat, dX, 0, dQTmp, 0);
                if (doDebug) {
                    Optimization.VectPrint("Internal coordinate representation of the Cartesian step:", nQ, dQTmp, 0, debug);
                }
                boolean bl2 = converged = (dXMax = Optimization.VectMaxComponent(nC, dX, 0, true)) <= this.convLimit;
                if (doDebug) {
                    debug.println("Cycle: " + iCyc + " dXMax: " + dXMax + " Limit: " + this.convLimit + " " + converged);
                }
                if (Double.isInfinite(dXMax) || Double.isNaN(dXMax)) {
                    if (doDebug) {
                        debug.println("NAN OR INF STEP, FAILED!");
                    }
                    return 1;
                }
                workingSpace.wEnd = workingSpaceStart;
                if (!converged) {
                    double SP;
                    if (ScOld > 0.0 && (SP = Optimization.VDot(nC, dX, 0, dXOld, 0)) < 0.0) {
                        double sOLen = Math.sqrt(Optimization.VDot(nC, dXOld, 0, dXOld, 0)) / ScOld;
                        double ScOStep = 1.0 / (1.0 - SP / (Math.sqrt(Optimization.VDot(nC, dXOld, 0, dXOld, 0)) / ScOld));
                        if (ScOStep < 0.8) {
                            Optimization.VectScaleAndAdd(nC, Optimization.VectScale(nC, dXOld, 0, (1.0 + ScOld) * (1.0 - ScOStep), dXTmp, 0), 0, ScOStep, dX, 0, dX, 0);
                            dXMax = Optimization.VectMaxComponent(nC, dX, 0, true);
                            if (doDebug) {
                                debug.println("BackScale: " + ScOStep);
                            }
                        }
                    }
                    double Sc0 = 1.0;
                    if (dXMax > this.dXMaxAllowed) {
                        Sc0 = this.dXMaxAllowed / dXMax;
                        dXTmp = Optimization.VectScaleAndAdd(nC, coord, 0, Sc0, dX, 0, dXTmp, 0);
                        if (doDebug) {
                            debug.println("ScaleAllowed: " + Sc0);
                        }
                    } else {
                        dXTmp = Optimization.VectAdd(nC, coord, 0, dX, 0, dXTmp, 0);
                    }
                    this.getDeltaQValues(nA, nDim, nQ, coord, qDef, this.getQValues(nA, nDim, nQ, dXTmp, qDef, null), dQ);
                    double len0 = Optimization.VDot(nQ, Optimization.VectUnit(nQ, dQ, 0, null), 0, dQTmp, 0);
                    double len1 = Optimization.VDot(nQ, Optimization.VectUnit(nQ, dQ, 0, null), 0, dQ, 0);
                    Sc = Math.max(0.01, Math.min(1.0, len0 / len1)) * Sc0;
                    Optimization.VectScaleAndAdd(nC, coord, 0, Sc, dX, 0, coord, 0);
                    if (doDebug) {
                        Optimization.VectPrint("Realized internal coordinate step:", nQ, dQ, 0, debug);
                        Optimization.VectPrint("Cartesian coordinate step before scale", nC, dX, 0, debug);
                        debug.println("Scaling step by: " + Sc);
                        Optimization.VectPrint("Cartesian coordinates after step", nC, dXTmp, 0, debug);
                        Optimization.VectPrint("Internal coordinates after step:", nQ, this.getQValues(nA, nDim, nQ, coord, qDef, null), 0, debug);
                        env.requestStructureWindow();
                    }
                } else {
                    return 0;
                }
                Optimization.VectCopy(nC, dX, 0, dXOld, 0);
                ScOld = Sc;
            }
            workingSpace.wEnd = workingSpaceStart;
            return 1;
        }

        public void printout(RICT r, int[] l, debugPrintout d) {
            int a = r.getAtomCount();
            d.println("Atom count: " + a);
            int c = r.getInternalCoordinateCount();
            d.println("Internal coordinates: " + c);
            d.Tstart();
            d.Trow();
            d.TprintBC(4, "Cartesian coordinates");
            d.Trow();
            d.TprintBC("#");
            d.TprintBC("X");
            d.TprintBC("Y");
            d.TprintBC("Z");
            double[] cc = r.getCartesianCoordinates();
            for (int i = 0; i < a; ++i) {
                d.Trow();
                d.TprintBC("" + i + "m:" + l[i]);
                d.Tprint("" + debugPrintout.formatNumber(cc[3 * i]));
                d.Tprint("" + debugPrintout.formatNumber(cc[3 * i + 1]));
                d.Tprint("" + debugPrintout.formatNumber(cc[3 * i + 2]));
            }
            d.Tstop();
            d.Tstart();
            d.Trow();
            d.TprintBC(7, "Internal coordinates");
            d.Trow();
            d.TprintBC("#");
            d.TprintBC("type");
            d.TprintBC("A1");
            d.TprintBC("A2");
            d.TprintBC("A3");
            d.TprintBC("A4");
            d.TprintBC("value");
            int[][] icd = r.getInternalCoordinateDescriptors();
            double[] icv = r.getInternalCoordinateValues();
            block9: for (int i = 0; i < c; ++i) {
                d.Trow();
                d.TprintBC("" + i);
                switch (icd[i][0] & 0xF) {
                    case 3: {
                        d.Tprint("Bond length");
                        d.Tprint("" + icd[i][1] + "m:" + l[icd[i][1]]);
                        d.Tprint("" + icd[i][2] + "m:" + l[icd[i][2]]);
                        d.Tprint("");
                        d.Tprint("");
                        d.Tprint("" + debugPrintout.formatNumber(icv[i]));
                        continue block9;
                    }
                    case 4: {
                        d.Tprint("Bond angle");
                        d.Tprint("" + icd[i][1] + "m:" + l[icd[i][1]]);
                        d.Tprint("" + icd[i][2] + "m:" + l[icd[i][2]]);
                        d.Tprint("" + icd[i][3] + "m:" + l[icd[i][3]]);
                        d.Tprint("");
                        d.Tprint("" + debugPrintout.formatNumber(icv[i] * 180.0 / Math.PI));
                        continue block9;
                    }
                    case 8: {
                        d.Tprint("Torsion");
                        d.Tprint("" + icd[i][1] + "m:" + l[icd[i][1]]);
                        d.Tprint("" + icd[i][2] + "m:" + l[icd[i][2]]);
                        d.Tprint("" + icd[i][3] + "m:" + l[icd[i][3]]);
                        d.Tprint("" + icd[i][4] + "m:" + l[icd[i][4]]);
                        d.Tprint("" + debugPrintout.formatNumber(icv[i] * 180.0 / Math.PI));
                        continue block9;
                    }
                    case 0: {
                        d.Tprint("Cartesian X");
                        d.Tprint("" + icd[i][1] + "m:" + l[icd[i][1]]);
                        d.Tprint("");
                        d.Tprint("");
                        d.Tprint("");
                        d.Tprint("" + debugPrintout.formatNumber(icv[i]));
                        continue block9;
                    }
                    case 1: {
                        d.Tprint("Cartesian Y");
                        d.Tprint("" + icd[i][1] + "m:" + l[icd[i][1]]);
                        d.Tprint("");
                        d.Tprint("");
                        d.Tprint("");
                        d.Tprint("" + debugPrintout.formatNumber(icv[i]));
                        continue block9;
                    }
                    case 2: {
                        d.Tprint("Cartesian Z");
                        d.Tprint("" + icd[i][1] + "m:" + l[icd[i][1]]);
                        d.Tprint("");
                        d.Tprint("");
                        d.Tprint("");
                        d.Tprint("" + debugPrintout.formatNumber(icv[i]));
                    }
                }
            }
            d.Tstop();
        }
    }

    public static interface RICT {
        public static final int CT_MASKVALUE = 15;
        public static final int CT_CARTESIAN_X = 0;
        public static final int CT_CARTESIAN_Y = 1;
        public static final int CT_CARTESIAN_Z = 2;
        public static final int CT_BONDLENGTH = 3;
        public static final int CT_BONDANGLE = 4;
        public static final int CT_LINEARBONDANGLE_I = 5;
        public static final int CT_LINEARBONDANGLE_II = 6;
        public static final int CT_OUTOFPLANE = 7;
        public static final int CT_TORSION = 8;
        public static final int FLAG_FROZEN = 16;
        public static final int FLAG_VARLISTLENGTH = 32;

        public int getDimensionCount();

        public int getAtomCount();

        public int getInternalCoordinateCount();

        public double[] getCartesianCoordinates();

        public double[] getMetric();

        public void requestStructureWindow();

        public int[][] getInternalCoordinateDescriptors();

        public double[] getInternalCoordinateValues();
    }

    public static interface Sortable {
        public boolean isGreater(int var1, int var2);

        public void swap(int var1, int var2);
    }

    public static interface SortableGetter {
        public String get(int var1);
    }

    public static interface SortableCallback {
        public void invoked(int var1, int var2);

        public void setBase(int var1);

        public void swapped(int var1, int var2);

        public void swapsdone(int var1, int var2);

        public void newrun(int var1, int var2);

        public void returned(int var1, int var2);

        public void done(int var1, int var2);
    }

    public static class sortEigValVect
    implements Sortable {
        Matrix m = null;

        public sortEigValVect(Matrix pMatrix) {
            this.m = pMatrix;
            for (int i = 0; i < this.m.aEVa.nRows; ++i) {
                if (U.isDoubleOK(this.m.aEVa.getElement(i, i))) continue;
                throw new IndexOutOfBoundsException("Invalid eigenvalue in sortEigValVect().");
            }
        }

        @Override
        public boolean isGreater(int i, int j) {
            return this.m.aEVa.getElement(i, i) > this.m.aEVa.getElement(j, j);
        }

        @Override
        public void swap(int i, int j) {
            double[] tmpVec;
            int vLen;
            double xx = this.m.aEVa.getElement(i, i);
            this.m.aEVa.setElement(i, i, this.m.aEVa.getElement(j, j));
            this.m.aEVa.setElement(j, j, xx);
            if (this.m.aLEV != null) {
                vLen = this.m.aLEV.nCols;
                tmpVec = new double[vLen];
                Optimization.VectCopy(vLen, this.m.aLEV.aVec, this.m.aLEV.pShft + i * this.m.aLEV.nCols, tmpVec, 0);
                Optimization.VectCopy(vLen, this.m.aLEV.aVec, this.m.aLEV.pShft + j * this.m.aLEV.nCols, this.m.aLEV.aVec, this.m.aLEV.pShft + i * this.m.aLEV.nCols);
                Optimization.VectCopy(vLen, tmpVec, 0, this.m.aLEV.aVec, this.m.aLEV.pShft + j * this.m.aLEV.nCols);
            }
            if (this.m.aREV != null) {
                vLen = this.m.aREV.nCols;
                tmpVec = new double[vLen];
                Optimization.VectCopy(vLen, this.m.aREV.aVec, this.m.aREV.pShft + i * this.m.aREV.nCols, tmpVec, 0);
                Optimization.VectCopy(vLen, this.m.aREV.aVec, this.m.aREV.pShft + j * this.m.aREV.nCols, this.m.aREV.aVec, this.m.aREV.pShft + i * this.m.aREV.nCols);
                Optimization.VectCopy(vLen, tmpVec, 0, this.m.aREV.aVec, this.m.aREV.pShft + j * this.m.aREV.nCols);
            }
        }
    }

    public static class JacobiTransformation {
        public double[][] a;
        public Matrix d;
        public Matrix v;
        public int n;
        public int nrot;
        static final double JACOBI_EPS = 1.0E-5;

        public JacobiTransformation(Matrix m) {
            int ip;
            if (m.nCols != m.nRows) {
                return;
            }
            this.n = m.nCols;
            this.a = Optimization.cpMatrixDB(m);
            double[] b = new double[this.n];
            double[] z = new double[this.n];
            if (m.aLEV == null) {
                this.v = new Matrix(this.n, this.n);
                this.v.mType.set(5);
                m.aLEV = this.v;
            } else {
                this.v = m.aLEV;
            }
            for (ip = 0; ip < this.n; ++ip) {
                this.v.setElement(ip, ip, 1.0);
            }
            if (m.aEVa == null) {
                BitSet mType = new BitSet(8);
                mType.set(4);
                m.aEVa = this.d = new Matrix(this.n, this.n, mType);
            } else {
                this.d = m.aEVa;
            }
            for (ip = 0; ip < this.n; ++ip) {
                b[ip] = this.a[ip][ip];
                this.d.setElement(ip, ip, b[ip]);
            }
            for (int i = 1; i <= 50; ++i) {
                int iq;
                double sm = 0.0;
                for (ip = 0; ip < this.n - 1; ++ip) {
                    for (iq = ip + 1; iq < this.n; ++iq) {
                        sm += Math.abs(this.a[ip][iq]);
                    }
                }
                if (Math.abs(sm) < 1.0E-5) {
                    return;
                }
                double tresh = i < 4 ? 0.2 * sm / (double)(this.n * this.n) : 0.0;
                for (ip = 0; ip < this.n - 1; ++ip) {
                    for (iq = ip + 1; iq < this.n; ++iq) {
                        int j;
                        double t;
                        double g = 100.0 * Math.abs(this.a[ip][iq]);
                        double d_ip = this.d.getElement(ip, ip);
                        double d_iq = this.d.getElement(iq, iq);
                        if (i > 4 && Math.abs(d_ip) + g == Math.abs(d_ip) && Math.abs(d_iq) + g == Math.abs(d_iq)) {
                            this.a[ip][iq] = 0.0;
                            continue;
                        }
                        if (!(Math.abs(this.a[ip][iq]) > tresh)) continue;
                        double h = d_iq - d_ip;
                        if (Math.abs(h) + g == Math.abs(h)) {
                            t = this.a[ip][iq] / h;
                        } else {
                            double theta = 0.5 * h / this.a[ip][iq];
                            t = 1.0 / (Math.abs(theta) + Math.sqrt(1.0 + theta * theta));
                            if (theta < 0.0) {
                                t = -t;
                            }
                        }
                        double c = 1.0 / Math.sqrt(1.0 + t * t);
                        double s = t * c;
                        double tau = s / (1.0 + c);
                        h = t * this.a[ip][iq];
                        int n = ip;
                        z[n] = z[n] - h;
                        int n2 = iq;
                        z[n2] = z[n2] + h;
                        this.d.setElement(ip, ip, d_ip - h);
                        this.d.setElement(iq, iq, d_iq + h);
                        this.a[ip][iq] = 0.0;
                        for (j = 0; j < ip; ++j) {
                            this.rotate(this.a, j, ip, j, iq, tau, s);
                        }
                        for (j = ip + 1; j < iq; ++j) {
                            this.rotate(this.a, ip, j, j, iq, tau, s);
                        }
                        for (j = iq + 1; j < this.n; ++j) {
                            this.rotate(this.a, ip, j, iq, j, tau, s);
                        }
                        for (j = 0; j < this.n; ++j) {
                            this.rotate(this.v, j, ip, j, iq, tau, s);
                        }
                        ++this.nrot;
                    }
                }
                for (ip = 0; ip < this.n; ++ip) {
                    int n = ip;
                    b[n] = b[n] + z[ip];
                    this.d.setElement(ip, ip, b[ip]);
                    z[ip] = 0.0;
                }
            }
        }

        void rotate(double[][] a, int i, int j, int k, int l, double tau, double s) {
            double g = a[i][j];
            double h = a[k][l];
            a[i][j] = g - s * (h + g * tau);
            a[k][l] = h + s * (g - h * tau);
        }

        void rotate(Matrix a, int i, int j, int k, int l, double tau, double s) {
            double g = a.aVec[a.pShft + i * a.nCols + j];
            double h = a.aVec[a.pShft + k * a.nCols + l];
            a.aVec[a.pShft + i * a.nCols + j] = g - s * (h + g * tau);
            a.aVec[a.pShft + k * a.nCols + l] = h + s * (g - h * tau);
        }
    }

    public static class SubSpace {
        VectorSubSet vSSet = null;
        VectorSet vSet = null;
        public BitSet sSType = null;
        public static final int lSSType = 4;
        public static final int UNIT_V = 0;
        public static final int ORTH_V = 1;
        public static final int SEQV_S = 2;
        public static final int DIAG_O = 3;

        public SubSpace(VectorSubSet wSSet) {
            this.sSType = new BitSet(4);
            this.sSType.set(0);
            this.sSType.set(1);
            this.SetupSubSpace(wSSet, null, this.sSType);
        }

        public SubSpace(VectorSubSet wSSet, VectorSet wSet) {
            this.SetupSubSpace(wSSet, wSet, null);
        }

        public void SetupSubSpace(VectorSubSet wSSet, VectorSet wSet, BitSet wSSType) {
            this.sSType = wSSType;
            if (this.sSType == null) {
                this.sSType = new BitSet(4);
            }
            this.vSSet = wSSet;
            if (wSet == null) {
                this.vSet = new VectorSet(this.vSSet.nVec - 1, this.vSSet.vSet.nVec, this.vSSet.vSet.vOvr);
                if (this.vSet.sType.get(2)) {
                    // empty if block
                }
                int i0 = 0;
                for (int i = 0; i < this.vSet.nVec; ++i) {
                    int j = i + 1;
                    if (this.sSType.get(2)) {
                        i0 = i;
                    }
                    this.vSet.vSet[i][this.vSet.vShft[i] + this.vSSet.vInd[j]] = -1.0;
                    this.vSet.vSet[i][this.vSet.vShft[i] + this.vSSet.vInd[i0]] = 1.0;
                }
            } else {
                this.vSet = wSet;
            }
            if (this.sSType.get(0)) {
                this.vSet.NormalizeSet();
                this.vSet.sType.set(0);
            }
            if (this.sSType.get(1)) {
                this.vSet.sType.set(1);
                this.SchmidtO();
            } else if (this.vSet.sType.get(0)) {
                for (int i = 0; i < this.vSet.nVec; ++i) {
                    this.vSet.Normalize(i);
                }
            }
        }

        public double[] LinComb(double[] c, int cShft, double[] w, int wShft) {
            int i;
            int wLen = this.vSSet.vSet.vLen;
            int nVec = this.vSet.nVec;
            if (w == null) {
                w = new double[wLen];
            } else {
                Optimization.VectClear(wLen, w, wShft);
            }
            double[] ww = new double[this.vSet.vLen];
            for (i = 0; i < nVec; ++i) {
                Optimization.VectScaleAndAdd(this.vSet.vLen, ww, 0, c[cShft + i], this.vSet.vSet[i], this.vSet.vShft[i], ww, 0);
            }
            for (i = 0; i < this.vSet.vLen; ++i) {
                Optimization.VectScaleAndAdd(wLen, w, wShft, ww[i], this.vSSet.vSet.vSet[i], this.vSSet.vSet.vShft[i], w, wShft);
            }
            return w;
        }

        public void SchmidtO() {
            Optimization.VSchmidtO(this.vSet, this.vSet, 1.0E-4);
        }

        public double[] Components(double[] v) {
            return this.Components(v, 0, null, 0);
        }

        public double[] Components(double[] v, int vShft) {
            return this.Components(v, vShft, null, 0);
        }

        public double[] Components(double[] v, int vShft, double[] c, int cShft) {
            int i;
            if (c == null) {
                c = new double[this.vSet.nVec];
                cShft = 0;
            }
            double[] w = new double[this.vSSet.vSet.nVec];
            int wShft = 0;
            for (i = 0; i < this.vSSet.vSet.nVec; ++i) {
                w[i] = Optimization.VDot(this.vSSet.vSet.vLen, this.vSSet.vSet.vSet[i], this.vSSet.vSet.vShft[i], v, vShft);
            }
            for (i = 0; i < this.vSet.nVec; ++i) {
                c[i] = Optimization.VDot(this.vSet.vLen, this.vSet.vSet[i], this.vSet.vShft[i], w, wShft);
            }
            return c;
        }
    }

    public static class VectorSubSet {
        VectorSet vSet = null;
        int nVec = 0;
        int[] vInd = null;

        public VectorSubSet(VectorSet wSet, int nWVec, int[] wInd) {
            this.SetupVectorSubSet(wSet, nWVec, wInd);
        }

        public VectorSubSet(VectorSet wSet, int nWVec) {
            this.SetupVectorSubSet(wSet, nWVec, this.vInd);
        }

        public void SetupVectorSubSet(VectorSet wSet, int nWVec, int[] wInd) {
            this.vSet = wSet;
            this.nVec = nWVec;
            if (wInd == null) {
                wInd = new int[this.vSet.nVec];
                for (int i = 0; i < this.nVec; ++i) {
                    wInd[i] = i;
                }
            }
            this.vInd = wInd;
        }

        public void AddVector(double[] w, int wShft) {
            int iVec = 0;
            if (this.nVec == this.vInd.length) {
                iVec = this.vInd[0];
                --this.nVec;
                for (int i = 0; i < this.nVec; ++i) {
                    this.vInd[i] = this.vInd[i + 1];
                }
            } else {
                iVec = this.vInd[this.nVec];
            }
            this.vInd[this.nVec] = iVec;
            this.ChangeVector(this.nVec, w, wShft);
            ++this.nVec;
        }

        public void InsertVector(double[] w, int wShft) {
            if (this.nVec == this.vInd.length) {
                --this.nVec;
            }
            int iVec = this.vInd[this.nVec];
            ++this.nVec;
            for (int i = this.nVec - 1; i > 0; --i) {
                this.vInd[i] = this.vInd[i - 1];
            }
            this.vInd[0] = iVec;
            this.ChangeVector(0, w, wShft);
        }

        public void ChangeVector(int iSVec, double[] w, int wShft) {
            this.vSet.ChangeVector(this.vInd[iSVec], w, wShft);
        }

        public double vSetDot(int i, int j) {
            return this.vSet.vSetDot(this.vInd[i], this.vInd[j]);
        }

        public void vSetVectAdd(int i, int wLen, double[] w, int wShft) {
            this.vSet.vSetVectAdd(this.vInd[i], wLen, w, wShft);
        }

        public void vSetVectAdd(int i, double[] w) {
            int wLen = w.length;
            int wShft = 0;
            this.vSet.vSetVectAdd(this.vInd[i], wLen, w, wShft);
        }

        public void Normalize(int i, int j) {
            this.Normalize(this.vInd[i], this.vInd[j], 1.0E-7);
        }

        public void Normalize(int i, double zLimit) {
            this.Normalize(this.vInd[i], this.vInd[i], zLimit);
        }

        public void Normalize(int i) {
            this.Normalize(this.vInd[i], this.vInd[i], 1.0E-7);
        }

        public void Normalize(int i, int j, double zLimit) {
            this.vSet.Normalize(i, i, zLimit);
        }

        public double[] Unit(int i) {
            return this.vSet.Unit(this.vInd[i], 1.0E-7);
        }

        public double[] Unit(int i, double zLimit) {
            return this.vSet.Unit(this.vInd[i], zLimit);
        }

        public void Print(String Message) {
            System.err.println(Message);
            for (int i = 0; i < this.nVec; ++i) {
                for (int j = 0; j < this.vSet.vLen; ++j) {
                    System.err.print(" " + this.vSet.vSet[this.vInd[i]][this.vSet.vShft[this.vInd[i]] + j]);
                }
                System.err.println();
            }
        }
    }

    public static class VectorSet {
        double[][] vSet = null;
        int[] vShft = null;
        int nVec = 0;
        int vLen = 0;
        Matrix vOvr = null;
        Matrix vMtr = null;
        public BitSet sType = null;
        public static final int lType = 4;
        public static final int UNIT_V = 0;
        public static final int ORTH_V = 1;
        public static final int METR_M = 2;
        public static final int VOVR_M = 3;

        public VectorSet(int nVectors, int vLength, double[] w, int wShft, BitSet wType, Matrix wOvr, Matrix wMtr) {
            this.CreateVectorSet(nVectors, vLength, w, wShft, wType, wOvr, wMtr);
        }

        public VectorSet(int nVectors, int vLength, double[] w, int wShft, BitSet wType) {
            this.CreateVectorSet(nVectors, vLength, w, wShft, wType, null, null);
        }

        public VectorSet(int nVectors, int vLength, double[] w, int wShft, Matrix wOvr) {
            this.sType = new BitSet(4);
            this.sType.set(3);
            this.CreateVectorSet(nVectors, vLength, w, wShft, this.sType, wOvr, null);
        }

        public VectorSet(int nVectors, int vLength, double[] w, int wShft) {
            this.CreateVectorSet(nVectors, vLength, w, wShft, null, null, null);
        }

        public VectorSet(int nVectors, int vLength, Matrix wMtr) {
            this.CreateVectorSet(nVectors, vLength, null, 0, null, null, wMtr);
        }

        public VectorSet(int nVectors, int vLength) {
            this.CreateVectorSet(nVectors, vLength, null, 0, null, null, null);
        }

        public VectorSet(int nVectors, int vLength, BitSet wType) {
            this.CreateVectorSet(nVectors, vLength, null, 0, wType, null, null);
        }

        public void CreateVectorSet(int nVectors, int vLength, double[] w, int wShft, BitSet wType, Matrix wOvr, Matrix wMtr) {
            this.nVec = nVectors;
            this.vLen = vLength;
            this.vSet = new double[nVectors][];
            this.vShft = new int[nVectors];
            if (w == null) {
                workingSpace wS = new workingSpace(this.nVec * vLength);
                w = wS.wVec;
                wShft = wS.wPtr;
            }
            if (w != null) {
                for (int i = 0; i < this.nVec; ++i) {
                    this.vSet[i] = w;
                    this.vShft[i] = wShft + i * this.vLen;
                }
            } else {
                System.exit(-1);
            }
            this.sType = wType != null ? wType : new BitSet(4);
            if (wMtr != null) {
                this.AddMetric(wMtr);
            }
            if (this.sType.get(3) || wOvr != null) {
                this.AddOverlap(wOvr);
            }
        }

        public void AddMetric(Matrix wMtr) {
            this.sType.set(2);
            this.vMtr = wMtr;
            if (this.vMtr == null) {
                System.err.println("Required metric tensor is missing in VectorSet.");
                System.exit(-2);
            }
        }

        public void AddOverlap() {
            this.AddOverlap(null);
        }

        public void AddOverlap(Matrix wOvr) {
            this.sType.set(3);
            this.vOvr = wOvr;
            if (this.vOvr == null) {
                BitSet oType = new BitSet(8);
                oType.set(2);
                oType.set(1);
                int mVec = this.vSet.length;
                this.vOvr = new Matrix(mVec, mVec, oType);
                this.UpdateOverlap();
            }
        }

        public void UpdateOverlap() {
            this.UpdateOverlap(0, this.nVec);
        }

        public void UpdateOverlap(int iVec) {
            if (this.vOvr == null) {
                this.AddOverlap();
            } else if (iVec < 0) {
                for (int i = 0; i < this.nVec; ++i) {
                    for (int j = 0; j <= i; ++j) {
                        this.vOvr.setElement(i, j, this.vSetDot0(i, j));
                    }
                }
            } else {
                for (int j = 0; j < this.nVec; ++j) {
                    this.vOvr.setElement(iVec, j, this.vSetDot0(iVec, j));
                }
            }
        }

        public void UpdateOverlap(int iFrom, int iEnd) {
            if (this.vOvr == null) {
                this.AddOverlap();
                return;
            }
            for (int i = iFrom; i < iEnd; ++i) {
                for (int j = 0; j <= i; ++j) {
                    this.vOvr.setElement(i, j, this.vSetDot0(i, j));
                }
            }
        }

        public void ChangeVector(int iVec, double[] w) {
            this.ChangeVector(iVec, w, 0);
        }

        public void ChangeVector(int iVec, double[] w, int wShft) {
            if (this.vSet[iVec] == null) {
                this.vSet[iVec] = w;
                this.vShft[iVec] = wShft;
            } else {
                Optimization.VectCopy(this.vLen, w, wShft, this.vSet[iVec], this.vShft[iVec]);
            }
            if (this.sType.get(0)) {
                this.Normalize(iVec);
            }
            if (this.sType.get(3)) {
                this.UpdateOverlap(iVec);
            }
        }

        public double vSetDot(int i, int j) {
            if (this.sType.get(3) && this.vOvr != null) {
                return this.vOvr.getElement(i, j);
            }
            if (this.sType.get(2)) {
                return Optimization.VDot(this.vLen, this.vSet[i], this.vShft[i], this.vSet[j], this.vShft[j], this.vMtr);
            }
            return Optimization.VDot(this.vLen, this.vSet[i], this.vShft[i], this.vSet[j], this.vShft[j]);
        }

        public double vSetDot0(int i, int j) {
            if (this.sType.get(2)) {
                return Optimization.VDot(this.vLen, this.vSet[i], this.vShft[i], this.vSet[j], this.vShft[j], this.vMtr);
            }
            return Optimization.VDot(this.vLen, this.vSet[i], this.vShft[i], this.vSet[j], this.vShft[j]);
        }

        public void vSetVectAdd(int i, int wLen, double[] w, int wShft) {
            int len = Math.min(this.vLen, wLen);
            Optimization.VectAdd(len, this.vSet[i], this.vShft[i], w, wShft, this.vSet[i], this.vShft[i]);
            if (this.sType.get(3)) {
                this.UpdateOverlap(i);
            }
        }

        public void Normalize(int i, int j) {
            this.Normalize(i, j, 1.0E-7);
        }

        public void Normalize(int i, double zLimit) {
            this.Normalize(i, i, zLimit);
        }

        public void Normalize(int i) {
            this.Normalize(i, i, 1.0E-7);
        }

        public void Normalize(int i, int j, double zLimit) {
            if (this.sType.get(2)) {
                Optimization.VectNormalize(this.vLen, this.vSet[i], this.vShft[i], this.vSet[j], this.vShft[j], this.vMtr, zLimit);
            } else {
                Optimization.VectNormalize(this.vLen, this.vSet[i], this.vShft[i], this.vSet[j], this.vShft[j], null, zLimit);
            }
            if (this.sType.get(3)) {
                this.UpdateOverlap(j);
            }
        }

        public void NormalizeSet(double zLimit) {
            if (!this.sType.get(0)) {
                for (int i = 0; i < this.nVec; ++i) {
                    this.Normalize(i, i, zLimit);
                }
            }
            this.sType.set(0);
        }

        public void NormalizeSet() {
            this.NormalizeSet(1.0E-7);
        }

        public double[] Unit(int i) {
            return this.Unit(i, 1.0E-7);
        }

        public double[] Unit(int i, double zLimit) {
            double[] w = new double[this.vLen];
            this.Unit(i, w, 0, zLimit);
            return w;
        }

        public void Unit(int i, double[] w, int wShft, double zLimit) {
            if (this.sType.get(2)) {
                Optimization.VectNormalize(this.vLen, this.vSet[i], this.vShft[i], w, wShft, this.vMtr, zLimit);
            } else {
                Optimization.VectNormalize(this.vLen, this.vSet[i], this.vShft[i], w, wShft, null, zLimit);
            }
        }

        public void Print(String Message) {
            System.err.println(Message);
            for (int i = 0; i < this.nVec; ++i) {
                for (int j = 0; j < this.vLen; ++j) {
                    System.err.print(" " + this.vSet[i][this.vShft[i] + j]);
                }
                System.err.println();
            }
        }
    }

    public static class Matrix {
        double zeroLimit = 1.0E-10;
        public double[] aVec = null;
        public int[] aInd = null;
        public Matrix aMtr = null;
        public Matrix aLEV = null;
        public Matrix aREV = null;
        public Matrix aEVa = null;
        public Matrix oMat = null;
        public int nCols = 0;
        public int nRows = 0;
        public int aLen = 0;
        public int pShft = 0;
        public int nRank = 0;
        public BitSet mType = null;
        public static final int lType = 8;
        public static final int FULL_M = 0;
        public static final int SYMM_M = 1;
        public static final int L_TRIA = 2;
        public static final int U_TRIA = 3;
        public static final int DIAG_M = 4;
        public static final int UNIT_M = 5;
        public static final int METR_M = 6;
        public static final int HAVE_D = 7;

        public Matrix(double[] v, int n_rows) {
            BitSet matrixType = new BitSet(8);
            int n_cols = v.length / n_rows;
            this.setupFullMatrix(v, n_rows, n_cols, 0, null, matrixType);
        }

        public Matrix(double[] v, int n_rows, int n_cols, int pointerShift) {
            BitSet matrixType = new BitSet(8);
            this.setupFullMatrix(v, n_rows, n_cols, pointerShift, null, matrixType);
        }

        public Matrix(double[] v, int n_rows, Matrix metric) {
            BitSet matrixType = new BitSet(8);
            int n_cols = v.length / n_rows;
            this.setupFullMatrix(v, n_rows, n_cols, 0, metric, matrixType);
        }

        public Matrix(double[] v, int n_rows, int n_cols, int pointerShift, Matrix metric) {
            BitSet matrixType = new BitSet(8);
            this.setupFullMatrix(v, n_rows, n_cols, pointerShift, metric, matrixType);
        }

        public Matrix(double[] v) {
            BitSet matrixType = new BitSet(8);
            matrixType.set(4);
            this.setupFullMatrix(v, v.length, v.length, 0, null, matrixType);
        }

        public Matrix(int n_rows, int n_cols) {
            this.setupFullMatrix(null, n_rows, n_cols, 0, null, null);
        }

        public Matrix(int n_rows, int n_cols, BitSet matrixType) {
            this.setupFullMatrix(null, n_rows, n_cols, 0, null, matrixType);
        }

        public Matrix(double[][] m) {
            BitSet matrixType = new BitSet(8);
            this.storeDDMatrix(m, 0, matrixType);
        }

        void storeDDMatrix(double[][] m, int pointerShift, BitSet matrixType) {
            int nRows = m.length;
            int nCols = 0;
            for (int i = 0; i < m.length; ++i) {
                nCols = Math.max(m[i].length, nCols);
            }
            double[] aVec = new double[nRows * nCols];
            for (int i = 0; i < m.length; ++i) {
                int j = 0;
                while (j < m[i].length) {
                    aVec[this.pShft + i * nCols + j] = m[i][j];
                    ++i;
                }
            }
            this.setupFullMatrix(aVec, nRows, nCols, 0, null, matrixType);
        }

        void setupFullMatrix(double[] v, int n_rows, int n_cols, int pointerShift, Matrix metric, BitSet matrixType) {
            if (n_cols == 0) {
                n_cols = n_rows;
            }
            if (n_rows == 0) {
                n_rows = n_cols;
            }
            this.mType = matrixType != null ? (BitSet)matrixType.clone() : new BitSet(8);
            this.mType.set(0);
            this.nRows = n_rows;
            this.nCols = n_cols;
            this.aVec = v;
            int vLen = 0;
            if (this.mType.get(2) || this.mType.get(3)) {
                this.nCols = this.nRows = Math.min(this.nRows, this.nCols);
                vLen = this.nCols * (this.nCols + 1) / 2;
            } else {
                vLen = this.mType.get(4) ? (this.nCols = (this.nRows = Math.min(this.nRows, this.nCols))) : this.nRows * this.nCols;
            }
            this.aLen = vLen;
            if (this.aVec == null) {
                workingSpace wS = new workingSpace(vLen);
                this.aVec = wS.wVec;
                this.pShft = wS.wPtr;
            }
            if (metric != null) {
                this.mType.set(6);
                this.aMtr = metric;
            }
        }

        public double getElement(int i, int j) {
            double d = 0.0;
            if (this.mType.get(0)) {
                if (this.mType.get(4)) {
                    if (i == j) {
                        d = this.aVec[this.pShft + i];
                    }
                } else if (this.mType.get(2)) {
                    if (this.mType.get(1) || i >= j) {
                        d = this.aVec[this.pShft + Matrix.lIndex(i, j)];
                    }
                } else if (this.mType.get(3) && (this.mType.get(1) || i <= j)) {
                    if (this.mType.get(1) || j >= i) {
                        d = this.aVec[this.pShft + this.uIndex(i, j)];
                    }
                } else {
                    d = this.aVec[this.pShft + i * this.nCols + j];
                }
            }
            return d;
        }

        public double[] getRow(int i) {
            double[] w = new double[this.nCols];
            this.getRow(i, w, 0);
            return w;
        }

        public void getRow(int i, double[] w, int wShft) {
            if (this.mType.get(0)) {
                if (this.mType.get(3) || this.mType.get(3)) {
                    int kStart = 0;
                    int kEnd = this.nCols;
                    if (!this.mType.get(1)) {
                        if (this.mType.get(3)) {
                            kStart = i;
                            Optimization.VectClear(i + 1, w, wShft);
                        } else {
                            kEnd = i + 1;
                            Optimization.VectClear(this.nCols - kEnd, w, wShft + kEnd);
                        }
                    }
                    for (int k = kStart; k < kEnd; ++k) {
                        w[k] = this.getElement(i, k);
                    }
                } else if (this.mType.get(4)) {
                    Optimization.VectClear(this.nCols, w, wShft);
                    w[i] = this.aVec[this.pShft + i];
                } else {
                    Optimization.VectCopy(this.nCols, this.aVec, this.pShft + this.rowIndex(i), w, wShft);
                }
            }
        }

        public double[] getCol(int i) {
            double[] w = new double[this.nRows];
            this.getCol(i, w, 0);
            return w;
        }

        public void getCol(int i, double[] w, int wShft) {
            block9: {
                if (!this.mType.get(0)) break block9;
                if (this.mType.get(3) || this.mType.get(3)) {
                    int kStart = 0;
                    int kEnd = this.nCols;
                    if (!this.mType.get(1)) {
                        if (this.mType.get(3)) {
                            kStart = i;
                            Optimization.VectClear(i + 1, w, wShft);
                        } else {
                            kEnd = i + 1;
                            Optimization.VectClear(this.nCols - kEnd, w, wShft + kEnd);
                        }
                    }
                    for (int k = kStart; k < kEnd; ++k) {
                        w[k] = this.getElement(k, i);
                    }
                } else if (this.mType.get(4)) {
                    Optimization.VectClear(this.nCols, w, wShft);
                    w[i] = this.aVec[this.pShft + i];
                } else {
                    for (int k = 0; k < this.nRows; ++k) {
                        w[k] = this.getElement(k, i);
                    }
                }
            }
        }

        public void setElement(int i, int j, double d) {
            if (this.mType.get(0)) {
                if (this.mType.get(4)) {
                    if (i == j) {
                        this.aVec[this.pShft + i] = d;
                    }
                } else if (this.mType.get(2)) {
                    if (this.mType.get(1) || i >= j) {
                        this.aVec[this.pShft + Matrix.lIndex((int)i, (int)j)] = d;
                    }
                } else if (this.mType.get(3)) {
                    if (this.mType.get(1) || j >= i) {
                        this.aVec[this.pShft + this.uIndex((int)i, (int)j)] = d;
                    }
                } else {
                    this.aVec[this.pShft + i * this.nCols + j] = d;
                }
            }
            this.mType.clear(7);
        }

        public void setRow(int i, double[] vec, int vecInd) {
            if (this.mType.get(0)) {
                if (this.mType.get(4)) {
                    this.aVec[this.pShft + i] = vec[vecInd + i];
                } else if (this.mType.get(2)) {
                    for (int j = 0; j <= i; ++j) {
                        this.aVec[this.pShft + Matrix.lIndex((int)i, (int)j)] = vec[vecInd + j];
                    }
                } else if (this.mType.get(3)) {
                    for (int j = i; j < this.nCols; ++j) {
                        this.aVec[this.pShft + this.uIndex((int)i, (int)j)] = vec[vecInd + j];
                    }
                } else {
                    Optimization.VectCopy(this.nCols, vec, vecInd, this.aVec, this.pShft + this.rowIndex(i));
                }
            }
            this.mType.clear(7);
        }

        public int rowIndex(int i) {
            if (this.mType.get(2)) {
                return Matrix.lIndex(i, 0);
            }
            if (this.mType.get(3)) {
                return this.uIndex(i, 0);
            }
            if (this.mType.get(4)) {
                return i;
            }
            return i * this.nCols;
        }

        public int endIndex() {
            int lastIndex = 0;
            lastIndex = this.mType.get(2) ? Matrix.lIndex(this.nRows, this.nRows) : (this.mType.get(3) ? this.uIndex(this.nRows, this.nRows) : (this.mType.get(4) ? this.nRows - 1 : this.nRows * this.nCols - 1));
            return lastIndex + 1;
        }

        private static int lIndex(int i, int j) {
            int ii = Math.max(i, j);
            int jj = Math.min(i, j);
            return ii * (ii + 1) / 2 + jj;
        }

        private int uIndex(int i, int j) {
            int ii = Math.min(i, j);
            int jj = Math.max(i, j);
            return this.nCols * ii - ii * (ii - 1) / 2 + jj - ii;
        }

        public double rowDot(int i, int j) {
            double d = 0.0;
            if (this.mType.get(6)) {
                double[] v = this.getRow(j);
                double[] w = Optimization.mVMultiply(this, v, 0);
                this.getRow(i, v, 0);
                d = Optimization.VDot(this.nCols, v, 0, w, 0);
            } else if (this.mType.get(0)) {
                if (this.mType.get(3) || this.mType.get(3)) {
                    int kStart = 0;
                    int kEnd = this.nCols;
                    if (!this.mType.get(1)) {
                        if (this.mType.get(3)) {
                            kStart = Math.max(i, j);
                        } else {
                            kEnd = Math.min(i, j) + 1;
                        }
                    }
                    for (int k = kStart; k < kEnd; ++k) {
                        d += this.getElement(i, k) * this.getElement(j, k);
                    }
                } else if (this.mType.get(4)) {
                    if (i == j) {
                        d = this.aVec[this.pShft + i] * this.aVec[this.pShft + i];
                    }
                } else {
                    d = Optimization.VDot(this.nCols, this.aVec, this.pShft + i * this.nCols, this.aVec, this.pShft + j * this.nCols);
                }
            }
            return d;
        }

        public double colDot(int i, int j) {
            double d = 0.0;
            for (int k = 0; k < this.nRows; ++k) {
                d += this.aVec[this.pShft + k * this.nCols + i] * this.aVec[this.pShft + k * this.nCols + j];
            }
            return d;
        }

        public void removeRows(int iFrom, int nnnRows) throws RuntimeException {
            int From = Math.max(0, iFrom);
            int nnRows = Math.min(this.nRows - From, nnnRows);
            if (this.mType.get(2) || this.mType.get(2)) {
                throw new RuntimeException("Triangular matrix is not allowed in removeRows.");
            }
            int To = From + nnRows;
            if (To >= this.nRows) {
                this.nRows = From;
            } else {
                int vLen = this.endIndex() - this.rowIndex(To);
                int iDiff = To - From;
                Optimization.VectCopy(vLen, this.aVec, this.pShft + this.rowIndex(To), this.pShft + this.rowIndex(From));
                this.nRows -= nnRows;
            }
            if (this.mType.get(4)) {
                this.nCols = this.nRows;
            }
        }

        public void insertRows(int From, int nnRows) {
            this.insertRows(From, nnRows, null, 0);
        }

        public void insertRows(int From, int nnRows, double[] vect, int vPShift) {
            if (this.mType.get(2) || this.mType.get(2)) {
                return;
            }
            if (this.nRows * this.nCols > this.aLen) {
                return;
            }
            int vLen = 0;
            int To = From + nnRows;
            if (From != this.nRows) {
                vLen = this.endIndex() - this.rowIndex(From);
                Optimization.VectCopy(vLen, this.aVec, this.pShft + this.rowIndex(From), this.pShft + this.rowIndex(To));
            }
            vLen = nnRows * this.nCols;
            if (vect != null) {
                Optimization.VectCopy(vLen, this.aVec, this.pShft + this.rowIndex(From), vect, vPShift);
            }
            this.nRows += nnRows;
            if (this.mType.get(4)) {
                this.nCols = this.nRows;
            }
        }

        public void Unitary() {
            this.Unitary(this.zeroLimit);
        }

        public void Unitary(double zLimit) {
            if (this.mType.get(0) && !this.mType.get(2) && !this.mType.get(3) && !this.mType.get(4)) {
                for (int i = 0; i < this.nRows; ++i) {
                    Optimization.VectNormalize(this.nCols, this.aVec, this.pShft + i * this.nCols, this.aVec, this.pShft + i * this.nCols);
                }
            }
        }

        public Matrix Transpose() {
            BitSet aTrType = new BitSet(8);
            int essentialBits = 5;
            for (int i = 0; i < essentialBits; ++i) {
                if (!this.mType.get(i)) continue;
                aTrType.set(i);
            }
            Matrix aTr = new Matrix(this.nCols, this.nRows, aTrType);
            if (this.mType.get(4)) {
                Optimization.VectCopy(this.nRows, this.aVec, this.pShft, aTr.aVec, aTr.pShft);
            } else {
                for (int i = 0; i < this.nCols; ++i) {
                    for (int j = 0; j < this.nRows; ++j) {
                        aTr.setElement(i, j, this.getElement(j, i));
                    }
                }
            }
            return aTr;
        }

        public void Symmetrize(int iType) {
            int i;
            if (this.mType.get(1)) {
                return;
            }
            if (this.mType.get(2) || this.mType.get(3) || iType > 2 | iType < 0) {
                System.err.println("Error in matrix symmetrization.");
                System.exit(-1);
            }
            for (i = 0; i < this.nRows; ++i) {
                for (int j = 0; j < i; ++j) {
                    double lTVal = this.getElement(i, j);
                    double uTVal = this.getElement(j, i);
                    if (iType == 0) {
                        this.setElement(i, j, (lTVal + uTVal) / 2.0);
                        this.setElement(j, i, (lTVal + uTVal) / 2.0);
                        continue;
                    }
                    if (iType == 1) {
                        this.setElement(i, j, lTVal);
                        this.setElement(j, i, lTVal);
                        continue;
                    }
                    if (iType != 2) continue;
                    this.setElement(i, j, uTVal);
                    this.setElement(j, i, uTVal);
                }
            }
            this.mType.set(1);
            if (this.mType.get(0) && !this.mType.get(2) && !this.mType.get(3) && !this.mType.get(4)) {
                for (i = 0; i < this.nRows; ++i) {
                    Optimization.VectNormalize(this.nCols, this.aVec, this.pShft + i * this.nCols, this.aVec, this.pShft + i * this.nCols);
                }
            }
        }

        public void Diagonalize(double zLimit, double ovlLimit) {
            Optimization.matrixDiagonalize(this, zLimit, ovlLimit);
        }

        public void Diagonalize(double zLimit) {
            Optimization.matrixDiagonalize(this, zLimit, 0.0);
        }

        public void Diagonalize() {
            if (!this.mType.get(7)) {
                Optimization.matrixDiagonalize(this, this.zeroLimit, 0.0);
            }
        }

        public void checkRank() {
            Optimization.SetRank(this, this.zeroLimit);
        }

        public void checkRank(double zLimit) {
            Optimization.SetRank(this, zLimit);
        }

        public void Print() {
            String Message = "Matrix printout";
            this.Print(Message);
        }

        public void Print(String Message) {
            System.err.println(Message);
            for (int i = 0; i < this.nCols; ++i) {
                for (int j = 0; j < this.nRows; ++j) {
                    System.err.print(debugPrintout.formatNumber(8, 4, this.getElement(i, j)));
                }
                System.err.println();
            }
        }

        public void Print(String Message, debugPrintout debug) {
            if (debug != null) {
                debug.println(Message);
                for (int i = 0; i < this.nRows; ++i) {
                    for (int j = 0; j < this.nCols; ++j) {
                        debug.print(debugPrintout.formatNumber(8, 4, this.getElement(i, j)));
                    }
                    debug.println();
                }
            } else {
                this.Print(Message);
            }
        }
    }

    public static class workingSpace {
        public static double[] w = null;
        public static int wLen = 0;
        public static int wEnd = 0;
        public double[] wVec = null;
        public int wPtr = -1;

        public workingSpace(int length) {
            if (length < 0) {
                if (w == null) {
                    w = new double[-length];
                    wLen = -length;
                    wEnd = 0;
                } else {
                    System.err.println("Reallocation is not allowed in workingSpace yet, doing reset.");
                    w = new double[-length];
                    wLen = -length;
                    wEnd = 0;
                }
            } else if (w == null || wEnd + length > wLen) {
                this.wVec = new double[length];
                this.wPtr = 0;
            } else {
                this.wPtr = wEnd;
                this.wVec = w;
                wEnd += length;
                Optimization.VectClear(length, this.wVec, this.wPtr);
            }
        }
    }

    public static interface FunctionOptimization {
        public static final int getValue = 0;
        public static final int getGradient = 1;
        public static final int numericGradient = 2;
        public static final int newVariables = 3;

        public int GetBlockSize();

        public debugPrintout getDebug();

        public double[] getVariablesScratch();

        public double[] getGradientsScratch();

        public double GetFunction(BitSet var1);

        public double GetXFunction(double var1, double[] var3);

        public double GetDFunction(double var1, double[] var3);
    }
}

