/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.nmr;

import chemaxon.calculations.nmr.NMRCoefficient;
import chemaxon.calculations.nmr.NMRSpectrum;
import chemaxon.calculations.nmr.SpectrumLine;
import chemaxon.calculations.nmr.SpectrumLineComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class Multiplet {
    private int[] atomIndices = new int[0];
    private ArrayList<SpectrumLine> lines = new ArrayList();
    private double shift;
    private double shiftError;
    private NMRCoefficient.ErrorClassification shiftErrorClassification;
    private double halfWidth;
    private double domainMin;
    private double domainMax;
    private double[] peakDomainMin;
    private double[] peakDomainMax;
    private boolean couplingNeeded;
    private ArrayList<double[]> couplingConstants = new ArrayList();
    private int[][] multiplicities;
    private double functionScale = 1.0;
    private static final double DOMAIN_PARAMETER = 5.0;
    private static final String[] ABBREVIATIONS = new String[]{"m", "s", "d", "t", "q", "p", "sx", "sp", "o", "n"};
    private static final double COUPLING_THRESHOLD = 1.0E-4;

    public Multiplet(boolean couplingNeeded) {
        this.couplingNeeded = couplingNeeded;
    }

    public void generateMultiplet() {
        this.lines.clear();
        this.multiplicities = new int[this.getAtomCount()][];
        if (this.couplingNeeded) {
            this.generateSplittings();
        } else {
            this.lines.add(new SpectrumLine(this.shift, this.getNetIntensity()));
            for (int i = 0; i < this.multiplicities.length; ++i) {
                this.multiplicities[i] = new int[1];
                this.multiplicities[i][0] = 1;
            }
        }
        this.domainMin = this.lines.get(0).getPosition() - 5.0 * this.halfWidth;
        this.domainMax = this.lines.get(this.lines.size() - 1).getPosition() + 5.0 * this.halfWidth;
        if (this.couplingNeeded) {
            int numberOfLines = this.getNumberOfLines();
            this.peakDomainMin = new double[numberOfLines];
            this.peakDomainMax = new double[numberOfLines];
            this.peakDomainMin[0] = this.domainMin;
            this.peakDomainMax[numberOfLines - 1] = this.domainMax;
            for (int i = 1; i < numberOfLines; ++i) {
                this.peakDomainMin[i] = (this.getPosition(i - 1) + this.getPosition(i)) / 2.0;
                this.peakDomainMax[i - 1] = this.peakDomainMin[i];
            }
        } else {
            this.peakDomainMin = new double[1];
            this.peakDomainMax = new double[1];
            this.peakDomainMin[0] = this.domainMin;
            this.peakDomainMax[0] = this.domainMax;
        }
    }

    private void generateSplittings() {
        ArrayList<SpectrumLine> linesWithDuplicates = new ArrayList<SpectrumLine>();
        this.multiplicities = new int[this.getAtomCount()][];
        for (int i = 0; i < this.atomIndices.length; ++i) {
            int j;
            ArrayList<SpectrumLine> linesOfANucleus = new ArrayList<SpectrumLine>();
            ArrayList<Integer> mult = new ArrayList<Integer>();
            ArrayList<Double> Js = new ArrayList<Double>();
            linesOfANucleus.add(new SpectrumLine(this.shift, 1.0));
            double[] couplings = this.couplingConstants.get(i);
            boolean[] examined = new boolean[couplings.length];
            for (j = 0; j < couplings.length; ++j) {
                double J = couplings[j];
                if (!(J > Double.MIN_VALUE) || examined[j]) continue;
                int count = 1;
                examined[j] = true;
                for (int k = j + 1; k < couplings.length; ++k) {
                    if (!(Math.abs(J - couplings[k]) < 1.0E-4)) continue;
                    ++count;
                    examined[k] = true;
                }
                int multiplicity = count + 1;
                mult.add(new Integer(multiplicity));
                Js.add(new Double(Math.abs(J)));
                ArrayList<SpectrumLine> linesTemp = new ArrayList<SpectrumLine>();
                for (SpectrumLine line : linesOfANucleus) {
                    double firstPosition = 0.0;
                    double intensity = line.getIntensity();
                    firstPosition = multiplicity % 2 == 0 ? line.getPosition() - ((double)(multiplicity / 2) - 0.5) * J : line.getPosition() - Math.floor((double)multiplicity / 2.0) * J;
                    for (int k = 0; k < multiplicity; ++k) {
                        double position = firstPosition + (double)k * J;
                        double intens = intensity * (double)this.binom(multiplicity - 1, k) / Math.pow(2.0, multiplicity - 1);
                        linesTemp.add(new SpectrumLine(position, intens));
                    }
                }
                linesOfANucleus = linesTemp;
            }
            linesWithDuplicates.addAll(linesOfANucleus);
            if (mult.size() > 0) {
                this.multiplicities[i] = new int[mult.size()];
                for (j = 0; j < mult.size(); ++j) {
                    int maxInd = j;
                    Double max = (Double)Js.get(j);
                    for (int k = j + 1; k < mult.size(); ++k) {
                        if (((Double)Js.get(k)).compareTo(max) <= 0) continue;
                        maxInd = k;
                        max = (Double)Js.get(k);
                    }
                    this.multiplicities[i][j] = (Integer)mult.get(maxInd);
                    Double tempJs = max;
                    Js.set(maxInd, (Double)Js.get(j));
                    Js.set(j, tempJs);
                    Integer tempMult = (Integer)mult.get(maxInd);
                    mult.set(maxInd, (Integer)mult.get(j));
                    mult.set(j, tempMult);
                }
                continue;
            }
            this.multiplicities[i] = new int[1];
            this.multiplicities[i][0] = 1;
        }
        this.mergeLines(linesWithDuplicates);
    }

    private void mergeLines(ArrayList<SpectrumLine> linesWithDuplicates) {
        boolean[] linesExamined = new boolean[linesWithDuplicates.size()];
        for (int i = 0; i < linesWithDuplicates.size(); ++i) {
            if (linesExamined[i]) continue;
            SpectrumLine line1 = linesWithDuplicates.get(i);
            linesExamined[i] = true;
            int count = 1;
            for (int j = i + 1; j < linesWithDuplicates.size(); ++j) {
                SpectrumLine line2 = linesWithDuplicates.get(j);
                if (linesExamined[j] || line1.getPosition() != line2.getPosition()) continue;
                ++count;
                linesExamined[j] = true;
            }
            this.lines.add(new SpectrumLine(line1.getPosition(), line1.getIntensity() * (double)count));
        }
        Collections.sort(this.lines, new SpectrumLineComparator());
    }

    public int[] getMultiplicities(int i) {
        return this.multiplicities[i];
    }

    public void addAtom(int index) {
        int len = this.atomIndices.length;
        int[] temp = new int[len];
        System.arraycopy(this.atomIndices, 0, temp, 0, len);
        this.atomIndices = new int[len + 1];
        System.arraycopy(temp, 0, this.atomIndices, 0, len);
        this.atomIndices[len] = index;
    }

    public void convert(double scaleForShift, double scaleForCoupling) {
        this.shift *= scaleForShift;
        this.shiftError *= scaleForShift;
        this.halfWidth *= scaleForCoupling;
        this.domainMin *= scaleForShift;
        this.domainMax *= scaleForShift;
        for (double[] c : this.couplingConstants) {
            int i = 0;
            while (i < c.length) {
                int n = i++;
                c[n] = c[n] * scaleForCoupling;
            }
        }
        this.generateMultiplet();
    }

    private int binom(int n, int k) {
        int i;
        int x = 1;
        int y = 1;
        if (k > n / 2) {
            k = n - k;
        }
        for (i = n - k + 1; i <= n; ++i) {
            x *= i;
        }
        for (i = 1; i <= k; ++i) {
            y *= i;
        }
        return x / y;
    }

    public double getShift() {
        return this.shift;
    }

    public void setShift(double shift) {
        this.shift = shift;
    }

    public int getNetIntensity() {
        return this.atomIndices.length;
    }

    public int getAtomCount() {
        return this.atomIndices.length;
    }

    public int getNumberOfLines() {
        return this.lines.size();
    }

    public double getPosition(int i) {
        return this.lines.get(i).getPosition();
    }

    public void setPosition(int i, double position) {
        this.lines.get(i).setPosition(position);
    }

    public double getIntensity(int i) {
        return this.lines.get(i).getIntensity();
    }

    public void setIntensity(int i, double intensity) {
        this.lines.get(i).setIntensity(intensity);
    }

    public int[] getIntesityPattern() {
        int i;
        if (this.lines.isEmpty()) {
            return new int[0];
        }
        double[] intensityPattern = new double[this.getNumberOfLines()];
        double min = this.lines.get(0).getIntensity();
        for (i = 0; i < intensityPattern.length; ++i) {
            intensityPattern[i] = this.lines.get(i).getIntensity();
            if (!(min > intensityPattern[i])) continue;
            min = intensityPattern[i];
        }
        i = 0;
        while (i < intensityPattern.length) {
            int n = i++;
            intensityPattern[n] = intensityPattern[n] / min;
        }
        int[] intIntensityPattern = new int[intensityPattern.length];
        for (int i2 = 0; i2 < intensityPattern.length; ++i2) {
            intIntensityPattern[i2] = (int)Math.round(intensityPattern[i2]);
        }
        return intIntensityPattern;
    }

    public int[] getAtomIndices() {
        return this.atomIndices;
    }

    public void setAtomIndices(int[] atomIndices) {
        this.atomIndices = atomIndices;
    }

    public int getAtomIndex(int i) {
        return this.atomIndices[i];
    }

    public void setAtomIndex(int i, int index) {
        this.atomIndices[i] = index;
    }

    public double getDomainMin() {
        return this.domainMin;
    }

    public void setDomainMin(double domainMin) {
        this.domainMin = domainMin;
    }

    public double getDomainMax() {
        return this.domainMax;
    }

    public void setDomainMax(double domainMax) {
        this.domainMax = domainMax;
    }

    public double[] getPeakDomainMin() {
        return this.peakDomainMin;
    }

    public void setPeakDomainMin(double[] peakDomainMin) {
        this.peakDomainMin = new double[peakDomainMin.length];
        System.arraycopy(peakDomainMin, 0, this.peakDomainMin, 0, peakDomainMin.length);
    }

    public double[] getPeakDomainMax() {
        return this.peakDomainMax;
    }

    public void setPeakDomainMax(double[] peakDomainMax) {
        this.peakDomainMax = new double[peakDomainMax.length];
        System.arraycopy(peakDomainMax, 0, this.peakDomainMax, 0, peakDomainMax.length);
    }

    public double getPeakDomainMin(int i) {
        if (this.peakDomainMin != null && i >= 0 && i < this.getNumberOfLines()) {
            return this.peakDomainMin[i];
        }
        return Double.NaN;
    }

    public void setPeakDomainMin(int i, double value) {
        if (this.peakDomainMin != null && i >= 0 && i < this.getNumberOfLines()) {
            this.peakDomainMin[i] = value;
        }
    }

    public double getPeakDomainMax(int i) {
        if (this.peakDomainMax != null && i >= 0 && i < this.getNumberOfLines()) {
            return this.peakDomainMax[i];
        }
        return Double.NaN;
    }

    public void setPeakDomainMax(int i, double value) {
        if (this.peakDomainMax != null && i >= 0 && i < this.getNumberOfLines()) {
            this.peakDomainMax[i] = value;
        }
    }

    public double getHalfWidth() {
        return this.halfWidth;
    }

    public void setHalfWidth(double halfWidth) {
        this.halfWidth = halfWidth;
    }

    public boolean getCouplingNeeded() {
        return this.couplingNeeded;
    }

    public void setCouplingNeeded(boolean couplingNeeded) {
        if (this.couplingNeeded != couplingNeeded) {
            this.couplingNeeded = couplingNeeded;
            this.generateMultiplet();
        }
    }

    public double[] getCouplingConstants(int i) {
        return this.couplingConstants.get(i);
    }

    public void addCouplingConstants(double[] couplings) {
        this.couplingConstants.add(couplings);
    }

    public String toString() {
        int[] pattern = this.getIntesityPattern();
        if (pattern != null) {
            if (pattern.length > 9) {
                return ABBREVIATIONS[0];
            }
            return ABBREVIATIONS[pattern.length];
        }
        return "";
    }

    public double getFunctionScale() {
        return this.functionScale;
    }

    public void setFunctionScale(double functionScale) {
        this.functionScale = functionScale;
    }

    public double getValueAt(double location) {
        double value = 0.0;
        for (int i = 0; i < this.getNumberOfLines(); ++i) {
            value += NMRSpectrum.lorentzian(this.getPosition(i), this.halfWidth, this.getIntensity(i), location);
        }
        return value * this.functionScale;
    }

    public double getDefaultValue() {
        return 0.0;
    }

    public double[] getLocalMaximumPlaces() {
        double[] localMaximumPlaces = new double[this.getNumberOfLines()];
        for (int i = 0; i < this.getNumberOfLines(); ++i) {
            localMaximumPlaces[i] = this.getPosition(i);
        }
        Arrays.sort(localMaximumPlaces);
        return localMaximumPlaces;
    }

    public double getShiftError() {
        return this.shiftError;
    }

    public void setShiftError(double shiftError) {
        this.shiftError = shiftError;
    }

    public NMRCoefficient.ErrorClassification getShiftErrorClassification() {
        return this.shiftErrorClassification;
    }

    public void setShiftErrorClassification(NMRCoefficient.ErrorClassification shiftErrorClassification) {
        this.shiftErrorClassification = shiftErrorClassification;
    }
}

