/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.nmr;

import chemaxon.calculations.nmr.NMRCoefficient;
import chemaxon.calculations.nmr.NMRSpectrum;
import chemaxon.calculations.training.PredictionAlgorithm;
import chemaxon.marvin.modelling.linalg.JLinAlg;

public class NMRShiftPredictionAlgorithm
implements PredictionAlgorithm<double[]> {
    private double[] coefficients;
    private double shiftError;
    private NMRCoefficient.ErrorClassification classification;
    private NMRSpectrum.Nucleus nucleus = NMRSpectrum.Nucleus.C13;

    @Override
    public double predict(double[] descriptors) {
        double[] lowCoeff;
        double[] upCoeff;
        double[] errorClass;
        this.shiftError = 0.0;
        if (descriptors.length == 0) {
            this.shiftError = Double.NaN;
            this.classification = NMRCoefficient.ErrorClassification.poor;
            return Double.NaN;
        }
        double shift = JLinAlg.VDot(this.coefficients, descriptors) + this.coefficients[this.coefficients.length - 1];
        if (this.nucleus.equals((Object)NMRSpectrum.Nucleus.C13)) {
            errorClass = NMRCoefficient.C13_ERROR_CLASS;
            upCoeff = NMRCoefficient.C13UP;
            lowCoeff = NMRCoefficient.C13LOW;
        } else {
            errorClass = NMRCoefficient.H1_ERROR_CLASS;
            upCoeff = NMRCoefficient.H1UP;
            lowCoeff = NMRCoefficient.H1LOW;
        }
        double lowShift = JLinAlg.VDot(lowCoeff, descriptors) + lowCoeff[lowCoeff.length - 1];
        double upShift = JLinAlg.VDot(upCoeff, descriptors) + upCoeff[upCoeff.length - 1];
        this.shiftError = 0.5 * Math.abs(upShift - lowShift) / 1.96;
        if (this.shiftError < errorClass[0]) {
            this.classification = NMRCoefficient.ErrorClassification.good;
        } else if (this.shiftError >= errorClass[0] && this.shiftError < errorClass[1]) {
            this.classification = NMRCoefficient.ErrorClassification.medium;
        } else if (this.shiftError >= errorClass[1]) {
            this.classification = NMRCoefficient.ErrorClassification.poor;
        }
        return shift;
    }

    @Override
    public void setCoefficients(double[] results) {
        this.coefficients = new double[results.length];
        System.arraycopy(results, 0, this.coefficients, 0, results.length);
    }

    public double[] getCoefficients() {
        return this.coefficients;
    }

    @Override
    public float getProgress() {
        return -1.0f;
    }

    public double getShiftError() {
        return this.shiftError;
    }

    public NMRCoefficient.ErrorClassification getClassification() {
        return this.classification;
    }

    public void setNucleus(NMRSpectrum.Nucleus nucleus) {
        this.nucleus = nucleus;
    }
}

