/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.nmr;

import chemaxon.calculations.hydrogenize.Hydrogenize;
import chemaxon.calculations.nmr.Multiplet;
import chemaxon.calculations.nmr.Shift;
import chemaxon.calculations.nmr.Spectrum;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class NMRSpectrum
implements Spectrum {
    private static final int HAtNo = 1;
    private Molecule mol;
    private int numberOfNMRActiveNuclei;
    private Shift[] shifts;
    private double[][] couplingConstants;
    private Nucleus nucleusType;
    private double frequency;
    private double halfWidth;
    private Multiplet[] multiplets;
    private Unit unit;
    private boolean couplingNeeded;
    private double domainMin;
    private double domainMax;
    private double functionScale;
    private boolean implicitHydrogenMode = false;
    private int[] originalAtomindices;
    static final double DEFAULT_VALUE = 0.0;

    public NMRSpectrum() {
    }

    public NMRSpectrum(Nucleus nucleusType) {
        this.nucleusType = nucleusType;
    }

    public NMRSpectrum(Molecule mol, Nucleus nucleusType) {
        this.mol = mol;
        this.nucleusType = nucleusType;
    }

    static double lorentzian(double center, double halfWidth, double integral, double x) {
        return integral * (halfWidth /= 2.0) / Math.PI / (Math.pow(x - center, 2.0) + Math.pow(halfWidth, 2.0));
    }

    static double lorentzianIntegral(double center, double halfWidth, double integral, double x) {
        return integral * (0.5 - Math.atan((center - x) / (halfWidth /= 2.0)) / Math.PI);
    }

    public Molecule getMolecule() {
        if (this.implicitHydrogenMode) {
            Molecule cloneMol = this.mol.cloneMolecule();
            Hydrogenize.removeHAtoms(cloneMol);
            return cloneMol;
        }
        return this.mol;
    }

    public void setMolecule(Molecule mol) {
        this.mol = mol;
    }

    public int getNumberOfNMRActiveNuclei() {
        return this.numberOfNMRActiveNuclei;
    }

    public void setNumberOfNMRActiveNuclei(int numberOfNMRActiveNuclei) {
        this.numberOfNMRActiveNuclei = numberOfNMRActiveNuclei;
    }

    public Shift[] getShifts() {
        return this.shifts;
    }

    public void setShifts(Shift[] shifts) {
        this.shifts = shifts;
    }

    public List<Integer> getAtomIndexes() {
        if (this.getMultiplets() == null) {
            return null;
        }
        ArrayList<Integer> atomIndexes = new ArrayList<Integer>();
        for (Multiplet multiplet : this.multiplets) {
            int[] indexes = multiplet.getAtomIndices();
            for (int i = 0; i < indexes.length; ++i) {
                atomIndexes.add(indexes[i]);
            }
        }
        Collections.sort(atomIndexes);
        return atomIndexes;
    }

    public double[][] getCouplingConstants() {
        return this.couplingConstants;
    }

    public void setCouplingConstants(double[][] couplingConstants) {
        this.couplingConstants = couplingConstants;
    }

    public Nucleus getNucleusType() {
        return this.nucleusType;
    }

    public String getNucleusString() {
        String nucleusString;
        switch (this.nucleusType) {
            case H1: {
                nucleusString = "1H";
                break;
            }
            case C13: {
                nucleusString = "13C";
                break;
            }
            default: {
                nucleusString = "unknown";
            }
        }
        return nucleusString;
    }

    public boolean getImplicitHydrogenMode() {
        return this.implicitHydrogenMode;
    }

    public void setImplicitHydrogenMode(boolean implicitHydrogenMode) {
        if (this.nucleusType == Nucleus.H1) {
            if (implicitHydrogenMode && !this.implicitHydrogenMode) {
                if (this.multiplets != null) {
                    for (Multiplet m : this.multiplets) {
                        for (int i = 0; i < m.getAtomCount(); ++i) {
                            MolAtom hydrogen = this.mol.getAtom(m.getAtomIndex(i));
                            if (hydrogen.getBondCount() <= 0) continue;
                            m.setAtomIndex(i, this.mol.indexOf(hydrogen.getLigand(0)));
                        }
                    }
                }
                if (this.shifts != null) {
                    this.originalAtomindices = new int[this.shifts.length];
                    for (int i = 0; i < this.shifts.length; ++i) {
                        int index;
                        this.originalAtomindices[i] = index = this.shifts[i].getAtomIndex();
                        MolAtom hydrogen = this.mol.getAtom(index);
                        if (hydrogen.getBondCount() <= 0) continue;
                        this.shifts[i].setAtomIndex(this.mol.indexOf(hydrogen.getLigand(0)));
                    }
                }
            }
            if (!implicitHydrogenMode && this.implicitHydrogenMode) {
                if (this.multiplets != null) {
                    for (Multiplet m : this.multiplets) {
                        TreeSet<Integer> indicesSet = new TreeSet<Integer>();
                        int[] hydrogenIndices = new int[m.getAtomCount()];
                        for (int i = 0; i < m.getAtomCount(); ++i) {
                            indicesSet.add(m.getAtomIndex(i));
                        }
                        Iterator it = indicesSet.iterator();
                        int count = 0;
                        while (it.hasNext()) {
                            MolAtom atom = this.mol.getAtom((Integer)it.next());
                            for (int j = 0; j < atom.getBondCount(); ++j) {
                                MolAtom neighbor = atom.getLigand(j);
                                if (neighbor.getAtno() != 1) continue;
                                hydrogenIndices[count] = this.mol.indexOf(neighbor);
                                ++count;
                            }
                        }
                        m.setAtomIndices(hydrogenIndices);
                    }
                }
                if (this.shifts != null && this.originalAtomindices != null) {
                    for (int i = 0; i < this.shifts.length; ++i) {
                        this.shifts[i].setAtomIndex(this.originalAtomindices[i]);
                    }
                }
            }
            this.implicitHydrogenMode = implicitHydrogenMode;
        }
    }

    public double getFrequency() {
        return this.frequency;
    }

    public void setFrequency(double frequency) {
        double oldFrequency = this.frequency;
        this.frequency = frequency;
        if (this.unit == Unit.Hz) {
            this.convert(frequency / oldFrequency, 1.0);
        }
        if (this.unit == Unit.ppm) {
            this.convert(1.0, oldFrequency / frequency);
        }
        this.computeFunctionScale();
    }

    public double getHalfWidth() {
        return this.halfWidth;
    }

    public void setHalfWidth(double halfWidth) {
        this.halfWidth = halfWidth;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        Unit oldUnit = this.unit;
        this.unit = unit;
        if (oldUnit == Unit.ppm && unit == Unit.Hz) {
            this.convert(this.frequency, this.frequency);
        } else if (oldUnit == Unit.Hz && unit == Unit.ppm) {
            this.convert(1.0 / this.frequency, 1.0 / this.frequency);
        }
        this.computeFunctionScale();
    }

    public boolean getCouplingNeeded() {
        return this.couplingNeeded;
    }

    public void setCouplingNeeded(boolean couplingNeeded) {
        this.couplingNeeded = couplingNeeded;
        if (this.multiplets != null) {
            for (int i = 0; i < this.multiplets.length; ++i) {
                this.multiplets[i].setCouplingNeeded(couplingNeeded);
            }
        }
        this.computeFunctionScale();
    }

    public static double[] getMeaningfulFrequencies() {
        double[] freq = new double[]{60.0, 100.0, 150.0, 200.0, 300.0, 400.0, 500.0, 600.0, 700.0, 800.0, 900.0, 1000.0};
        return freq;
    }

    @Override
    public double[] getLocalMaximumPlaces() {
        int maxNo = 0;
        int count = 0;
        if (this.multiplets != null) {
            for (Multiplet m : this.multiplets) {
                maxNo += m.getNumberOfLines();
            }
            double[] localMaximumPlaces = new double[maxNo];
            for (Multiplet m : this.multiplets) {
                for (int i = 0; i < m.getNumberOfLines(); ++i) {
                    localMaximumPlaces[count] = m.getPosition(i);
                    ++count;
                }
            }
            Arrays.sort(localMaximumPlaces);
            return localMaximumPlaces;
        }
        return new double[0];
    }

    public double getDomainMin() {
        return this.domainMin;
    }

    public void setDomainMin(double domainMin) {
        this.domainMin = domainMin;
    }

    public double getDomainMax() {
        return this.domainMax;
    }

    public void setDomainMax(double domainMax) {
        this.domainMax = domainMax;
    }

    public double getValueAt(double location) {
        double y = 0.0;
        if (this.multiplets != null) {
            for (Multiplet m : this.multiplets) {
                for (int i = 0; i < m.getNumberOfLines(); ++i) {
                    y += NMRSpectrum.lorentzian(m.getPosition(i), this.halfWidth, m.getIntensity(i), location);
                }
            }
            return y * this.functionScale;
        }
        return this.getDefaultValue();
    }

    public double getRawValueAt(double location) {
        double y = 0.0;
        if (this.multiplets != null) {
            for (Multiplet m : this.multiplets) {
                for (int i = 0; i < m.getNumberOfLines(); ++i) {
                    y += NMRSpectrum.lorentzian(m.getPosition(i), this.halfWidth, m.getIntensity(i), location);
                }
            }
            return y;
        }
        return this.getDefaultValue();
    }

    public double getIntegralValueAt(double location) {
        double y = 0.0;
        if (this.multiplets != null) {
            for (Multiplet m : this.multiplets) {
                for (int i = 0; i < m.getNumberOfLines(); ++i) {
                    y += NMRSpectrum.lorentzianIntegral(m.getPosition(i), this.halfWidth, m.getIntensity(i), location);
                }
            }
            return (double)this.getNumberOfNMRActiveNuclei() - y;
        }
        return this.getDefaultValue();
    }

    @Override
    public Multiplet[] getMultiplets() {
        return this.multiplets;
    }

    public void setMultiplets(Multiplet[] multiplets) {
        this.multiplets = multiplets;
    }

    @Override
    public double getDefaultValue() {
        return 0.0;
    }

    public double getRangeMax() {
        double[] maxes = this.getLocalMaximumPlaces();
        if (maxes == null || maxes.length == 0) {
            return 1.0;
        }
        int maxIndex = 0;
        for (int i = 0; i < maxes.length; ++i) {
            if (!(this.getValueAt(maxes[i]) > this.getValueAt(maxes[maxIndex]))) continue;
            maxIndex = i;
        }
        return this.getValueAt(maxes[maxIndex]) * 1.05;
    }

    public double getRangeMin() {
        return this.getDefaultValue();
    }

    public void computeFunctionScale() {
        double[] localMaximumPlaces;
        this.functionScale = 1.0;
        double yMax = 0.0;
        for (double x : localMaximumPlaces = this.getLocalMaximumPlaces()) {
            double y = this.getRawValueAt(x);
            if (!(y > yMax)) continue;
            yMax = y;
        }
        if (yMax > Double.MIN_VALUE) {
            this.functionScale = (double)this.getNumberOfNMRActiveNuclei() / yMax;
        }
        if (this.multiplets != null) {
            for (Multiplet m : this.multiplets) {
                m.setFunctionScale(this.functionScale);
            }
        }
    }

    private void convert(double scaleForShift, double scaleForCoupling) {
        int i;
        if (this.shifts != null) {
            for (i = 0; i < this.shifts.length; ++i) {
                this.shifts[i].scaleShift(scaleForShift);
            }
        }
        if (this.couplingConstants != null) {
            for (i = 0; i < this.couplingConstants.length; ++i) {
                int j = 0;
                while (j < this.couplingConstants[i].length) {
                    double[] dArray = this.couplingConstants[i];
                    int n = j++;
                    dArray[n] = dArray[n] * scaleForCoupling;
                }
            }
        }
        if (this.multiplets != null) {
            for (i = 0; i < this.multiplets.length; ++i) {
                this.multiplets[i].convert(scaleForShift, scaleForCoupling);
            }
        }
        this.halfWidth *= scaleForCoupling;
        this.domainMin *= scaleForShift;
        this.domainMax *= scaleForShift;
    }

    public static enum Unit {
        ppm,
        Hz;

    }

    public static enum Nucleus {
        C13,
        H1;


        public String toString() {
            if (this.equals((Object)C13)) {
                return "13C";
            }
            return "1H";
        }
    }
}

