/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.nmr.io;

import chemaxon.calculations.nmr.Multiplet;
import chemaxon.calculations.nmr.NMRSpectrum;
import chemaxon.struc.Molecule;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import org.jcamp.parser.JCAMPException;
import org.jcamp.parser.JCAMPWriter;
import org.jcamp.spectrum.ArrayData;
import org.jcamp.spectrum.Assignment;
import org.jcamp.spectrum.IDataArray1D;
import org.jcamp.spectrum.IOrderedDataArray1D;
import org.jcamp.spectrum.OrderedArrayData;
import org.jcamp.spectrum.Pattern;
import org.jcamp.spectrum.Peak1D;
import org.jcamp.spectrum.Spectrum;
import org.jcamp.spectrum.Spectrum1D;
import org.jcamp.units.CommonUnit;

public class NMRExporter {
    private static final double Y_THRESHOLD = 1.0E-4;

    public static double[][] export(NMRSpectrum spectrum, double xMin, double xMax, double resolution) {
        int i;
        double y;
        int i2;
        ArrayList<Double> xValues = new ArrayList<Double>();
        ArrayList<Double> yValues = new ArrayList<Double>();
        double[] localMaximumPlaces = spectrum.getLocalMaximumPlaces();
        if (localMaximumPlaces.length == 0 || xMax < localMaximumPlaces[0] || xMin > localMaximumPlaces[localMaximumPlaces.length - 1]) {
            return new double[2][0];
        }
        int minIndex = 0;
        int maxIndex = localMaximumPlaces.length - 1;
        for (i2 = 0; i2 < localMaximumPlaces.length; ++i2) {
            if (!(localMaximumPlaces[i2] > xMin)) continue;
            minIndex = i2;
            break;
        }
        for (i2 = minIndex; i2 < localMaximumPlaces.length; ++i2) {
            if (!(localMaximumPlaces[i2] > xMax)) continue;
            maxIndex = i2 - 1;
            break;
        }
        double max = 0.0;
        for (int i3 = minIndex; i3 <= maxIndex; ++i3) {
            double y2 = spectrum.getValueAt(localMaximumPlaces[i3]);
            if (!(y2 > max)) continue;
            max = y2;
        }
        double threshold = max * 1.0E-4;
        for (double x = xMin; x < localMaximumPlaces[minIndex]; x += resolution) {
            y = spectrum.getValueAt(x);
            if (!(y > threshold)) continue;
            xValues.add(new Double(x));
            yValues.add(new Double(y));
        }
        for (int i4 = minIndex; i4 < maxIndex; ++i4) {
            for (double x = localMaximumPlaces[i4]; x < localMaximumPlaces[i4 + 1]; x += resolution) {
                double y3 = spectrum.getValueAt(x);
                if (!(y3 > threshold)) continue;
                xValues.add(new Double(x));
                yValues.add(new Double(y3));
            }
        }
        for (double x = localMaximumPlaces[maxIndex]; x < xMax; x += resolution) {
            y = spectrum.getValueAt(x);
            if (!(y > threshold)) continue;
            xValues.add(new Double(x));
            yValues.add(new Double(y));
        }
        double[][] spectrumPoints = new double[2][xValues.size()];
        for (i = 0; i < spectrumPoints[0].length; ++i) {
            spectrumPoints[0][i] = (Double)xValues.get(i);
        }
        for (i = 0; i < spectrumPoints[1].length; ++i) {
            spectrumPoints[1][i] = (Double)yValues.get(i);
        }
        return spectrumPoints;
    }

    public static Molecule exportToMol(NMRSpectrum spectrum) throws IOException {
        return NMRExporter.exportToMol(spectrum, spectrum.getNucleusString() + " NMR");
    }

    public static Molecule exportToMol(NMRSpectrum spectrum, String propertyName) throws IOException {
        int DATA_DELIMITER = 59;
        int ATOM_DELIMITER = 124;
        int UNIT_DELIMITER = 44;
        int MULTIPLICITY_DELIMITER = 46;
        String[] multipletName = new String[]{"S", "D", "T", "Q", "P", "Sx", "Sp", "O", "N"};
        String defaultMultipletName = "M";
        StringBuilder NMRProperty = new StringBuilder();
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        DecimalFormat df = new DecimalFormat("#.##", decimalFormatSymbols);
        Multiplet[] multiplets = spectrum.getMultiplets();
        NMRSpectrum.Unit unit = spectrum.getUnit();
        Molecule mol = spectrum.getMolecule();
        for (int i = 0; i < multiplets.length; ++i) {
            Multiplet m = multiplets[i];
            for (int j = 0; j < m.getAtomCount(); ++j) {
                NMRProperty.append(df.format(m.getShift()));
                NMRProperty.append(';');
                NMRProperty.append((Object)unit);
                NMRProperty.append(',');
                int[] mult = m.getMultiplicities(j);
                for (int k = 0; k < mult.length; ++k) {
                    if (mult[k] < 10) {
                        NMRProperty.append(multipletName[mult[k] - 1]);
                    } else {
                        NMRProperty.append("M");
                    }
                    if (k >= mult.length - 1) continue;
                    NMRProperty.append('.');
                }
                NMRProperty.append(';');
                NMRProperty.append(m.getAtomIndex(j));
                NMRProperty.append('|');
            }
        }
        if (NMRProperty.length() > 0) {
            NMRProperty.deleteCharAt(NMRProperty.length() - 1);
        }
        mol.setProperty(propertyName, NMRProperty.toString());
        return mol;
    }

    public static String exportToJcampDX(NMRSpectrum spectrum) throws IOException {
        return NMRExporter.exportToJcampDX(spectrum, 8192);
    }

    public static String exportToJcampDX(NMRSpectrum spectrum, int numberOfPoints) throws IOException {
        String title = "ChemAxon NMR prediction";
        Multiplet[] multiplets = spectrum.getMultiplets();
        NMRSpectrum.Unit unit = spectrum.getUnit();
        double frequency = spectrum.getFrequency();
        String nucleusString = spectrum.getNucleusString();
        double domainMin = spectrum.getDomainMin();
        double domainMax = spectrum.getDomainMax();
        double[] localMaximumPlaces = spectrum.getLocalMaximumPlaces();
        double resolution = (domainMax - domainMin) / (double)(numberOfPoints - 1);
        double[][] xy = new double[2][numberOfPoints];
        double x = domainMin;
        for (int i = 0; i < numberOfPoints; ++i) {
            xy[0][i] = x;
            x += resolution;
        }
        for (double max : localMaximumPlaces) {
            int ind = 0;
            if (max > domainMin && max < domainMax) {
                int ind1 = 0;
                int ind2 = numberOfPoints - 1;
                ind = (ind1 + ind2) / 2;
                while (!(Math.abs(xy[0][ind] - max) < Double.MIN_VALUE || ind2 - ind1 == 1 && max > xy[0][ind1] && max < xy[0][ind2])) {
                    if (xy[0][ind] > max) {
                        ind2 = ind;
                    } else {
                        ind1 = ind;
                    }
                    ind = (ind1 + ind2) / 2;
                }
            }
            xy[0][ind] = max;
        }
        for (int i = 0; i < numberOfPoints; ++i) {
            xy[1][i] = spectrum.getValueAt(xy[0][i]);
        }
        OrderedArrayData xValues = null;
        xValues = unit == NMRSpectrum.Unit.ppm ? new OrderedArrayData(xy[0], CommonUnit.ppm) : new OrderedArrayData(xy[0], CommonUnit.hertz);
        ArrayData yValues = new ArrayData(xy[1], CommonUnit.intensity);
        double reference = 0.0;
        org.jcamp.spectrum.NMRSpectrum jdxSpectrum = new org.jcamp.spectrum.NMRSpectrum((IOrderedDataArray1D)xValues, (IDataArray1D)yValues, nucleusString, frequency, reference);
        jdxSpectrum.setTitle(title);
        double[] peaks = localMaximumPlaces;
        Peak1D[] jcampPeaks = new Peak1D[peaks.length];
        for (int i = 0; i < peaks.length; ++i) {
            double peakValue = spectrum.getValueAt(peaks[i]);
            jcampPeaks[i] = new Peak1D(peaks[i], peakValue);
            double[] pos = new double[]{peaks[i], peakValue};
            jcampPeaks[i].setPosition(pos);
            jcampPeaks[i].setHeight(peakValue);
        }
        jdxSpectrum.setPeakTable(jcampPeaks);
        Assignment[] assignments = new Assignment[multiplets.length];
        for (int i = 0; i < multiplets.length; ++i) {
            Multiplet m = multiplets[i];
            int lineCount = m.getNumberOfLines();
            Peak1D[] lines = new Peak1D[lineCount];
            for (int j = 0; j < lineCount; ++j) {
                lines[j] = new Peak1D(m.getPosition(j), m.getIntensity(j));
            }
            assignments[i] = new Assignment(new Pattern((Spectrum1D)jdxSpectrum, lines), m.getAtomIndices());
        }
        jdxSpectrum.setAssignments(assignments);
        JCAMPWriter jcampWriter = JCAMPWriter.getInstance();
        try {
            String jcampString = jcampWriter.toJCAMP((Spectrum)jdxSpectrum);
            jcampString = jcampString.replaceAll("<<", "<");
            jcampString = jcampString.replaceAll(">>", ">");
            jcampString = unit == NMRSpectrum.Unit.ppm ? jcampString.replaceAll("XUNITS=HZ", "XUNITS=PPM") : jcampString.replaceAll("XUNITS=PPM", "XUNITS=HZ");
            return jcampString;
        }
        catch (JCAMPException e) {
            throw new IOException(e.getMessage());
        }
    }
}

