/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.pka;

import chemaxon.calculations.PolarGroups;
import chemaxon.calculations.pka.BasicPKa;
import chemaxon.calculations.pka.IntrinsicIonization;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

class AcidicPKa {
    private IntrinsicIonization pka;
    protected Molecule mol;
    private int[][] pkaAcidType;
    private int[][] cHtab;
    private double[] cyanoInc;
    private boolean[] isInRing;
    private int[] aza;
    private PolarGroups pg;
    private final double e = 2.718282;
    private final int NOTDELOC = -2;

    protected AcidicPKa(IntrinsicIonization pka) {
        this.pka = pka;
        this.mol = pka.mol;
        this.pkaAcidType = pka.pkaAcidType;
        this.cHtab = pka.cHtab;
        this.cyanoInc = pka.cyanoInc;
        this.isInRing = pka.isInRing;
        this.aza = pka.getAza();
        this.pg = pka.getPolarGroups();
    }

    protected double calculate(int atom) {
        switch (this.pka.acidAtomType[atom]) {
            case 1: {
                return this.getAlcoholicAcidicpKa(atom);
            }
            case 2: {
                return this.getNHAcidicpKa(atom);
            }
            case 3: 
            case 6: {
                return this.getSHAcidicpKa(atom);
            }
            case 4: {
                return this.getCHAcidicpKa(atom);
            }
            case 5: {
                return this.getHaloAcidicpKa(atom);
            }
        }
        return Double.NaN;
    }

    protected double getAlcoholicAcidicpKa(int atom) {
        if (this.pkaAcidType[atom][0] != -2) {
            return this.getOHAcidicpKa(atom);
        }
        if (this.mol.getAtom(atom).getCharge() != 1) {
            double p = this.setAtomSphere(atom, 5, 0.75);
            if (this.isJustCarbon()) {
                return 1.55 * p - 35.23 * this.getBondCharge2(atom) - 0.49;
            }
            int alpha = this.pkaAcidType[atom][8];
            if (this.getAtno(alpha) == 6) {
                double pka = -19.26 * this.getBondCharge2(atom) + 1.94 * Math.log(this.setAtomSphere(atom, 3, 0.75) / (double)this.getAtomCount()) + 9.19;
                pka += this.addBetaOHCorrection(alpha);
                return pka += -1.023 * this.getAccumulatedBondCharge2(alpha) + 0.1945;
            }
            double pka = -19.26 * this.getBondCharge18(atom) + 1.94 * Math.log(this.setAtomSphere(atom, 3, 0.75) / (double)this.getAtomCount()) + 9.19;
            return pka += this.addROHHeteroInc(alpha);
        }
        return Double.NaN;
    }

    private double getCHAcidicpKa(int atom) {
        if (this.pkaAcidType[atom][0] == -2) {
            return Double.NaN;
        }
        double pka = Double.NaN;
        double charge = this.mol.getAtom(atom).getCharge();
        int subType = this.pkaAcidType[atom][7];
        int rIndex = this.pkaAcidType[atom][8];
        int araInd1 = this.pkaAcidType[atom][10];
        int araInd2 = this.pkaAcidType[atom][11];
        int araInd3 = this.pkaAcidType[atom][4];
        int ketoRoot = this.pkaAcidType[atom][3];
        int ketoType = this.pkaAcidType[atom][9];
        if (charge == 0.0) {
            switch (this.pkaAcidType[atom][0]) {
                case 1: 
                case 11: {
                    if (subType == 10) {
                        this.getDelIsland(atom, 3);
                        pka = 11.07 - 18.26 * this.getBondCharge8(atom, 11) - 0.56 * this.getDL(atom);
                    } else if (this.justNO2(atom)) {
                        pka = 11.07 - 12.26 * this.getBondCharge8(atom, 11) - 1.68;
                    } else {
                        this.getDelIsland(atom, 3);
                        pka = 11.07 - 12.26 * this.getBondCharge8(atom, 11) - 0.56 * this.getDL(atom);
                    }
                    if (ketoType == 1 || ketoType == 2) {
                        pka += -1.7;
                    }
                    if (ketoType == 3 || ketoType == 4) {
                        pka += 3.5;
                    }
                    if (subType == 10) {
                        pka += 7.0;
                    }
                    return pka;
                }
                case 2: {
                    this.getDelIsland(atom, 3);
                    pka = 8.37 - 12.26 * this.getBondCharge8(atom, 11) - 0.56 * this.getDL(atom);
                    if (subType == 10) {
                        pka += 7.0;
                    }
                    return pka;
                }
                case 3: {
                    this.getDelIsland(atom, 3);
                    double c = 27.0;
                    if (subType == 1 || subType == 4) {
                        c = 18.0;
                    } else if (subType == 2 || subType == 3) {
                        c = 10.0;
                    } else if (subType == 5) {
                        c = 18.0;
                    }
                    pka = c - 12.26 * this.getBondCharge8(atom, 3) - 0.56 * this.getDL(atom);
                    return pka += this.cyanoInc[atom];
                }
                case 31: {
                    this.getDelIsland(atom, 3);
                    pka = 9.8 - 12.26 * this.getBondCharge8(atom, 31) - 0.56 * this.getDL(atom);
                    if (subType == 2) {
                        pka += -2.5;
                    }
                    return pka;
                }
                case 4: {
                    this.getDelIsland(atom, 3);
                    pka = 15.07 - 12.26 * this.getBondCharge8(atom, 4) - 0.56 * this.getDL(atom);
                    if (subType == 2 || subType == 4) {
                        pka += -2.0;
                    }
                    if (subType == 3) {
                        pka += -8.0;
                    }
                    return pka;
                }
                case 5: {
                    return pka;
                }
                case 6: {
                    return pka;
                }
                case 65: {
                    this.getDelIsland(atom, 3);
                    if (subType == 16) {
                        pka = 8.8 - 12.26 * this.getBondCharge8(atom, 65) - 0.46 * this.getDL(atom);
                    } else if (subType == 15) {
                        pka = 12.8 - 12.26 * this.getBondCharge8(atom, 65) - 0.46 * this.getDL(atom);
                    } else if (subType == 80) {
                        pka = 16.8 - 12.26 * this.getBondCharge8(atom, 65) - 0.46 * this.getDL(atom);
                    } else if (subType == 90) {
                        double dist;
                        double r = 0.0;
                        double inc = 0.0;
                        double corr = 0.0;
                        if (araInd1 != -1 || araInd2 != -1) {
                            r = this.getBondCharge22(atom);
                            dist = this.isPOsResRing(araInd1, araInd2, atom);
                            if (dist == 2.0) {
                                inc += -0.5;
                            } else if (dist == 4.0) {
                                inc += -2.0;
                            } else if (dist == 6.0) {
                                inc += -1.0;
                            }
                        }
                        if (araInd3 != -1) {
                            r += this.getBondCharge22(ketoRoot);
                            dist = this.isPOsResRing(araInd3, -1, ketoRoot);
                            if (dist == 2.0) {
                                inc += -1.0;
                            } else if (dist == 4.0) {
                                inc += -1.0;
                            } else if (dist == 6.0) {
                                inc += -1.0;
                            }
                        }
                        if (r < -0.22) {
                            corr = -12.5 * r - 3.75 + inc;
                        } else if (r < -0.15 && r > -0.22) {
                            corr = -19.45 * r - 5.27 + inc;
                        } else if (r > -0.15) {
                            corr = -4.32 * r - 3.0 + inc;
                        }
                        pka = 16.8 - 12.26 * this.getBondCharge8(atom, 65) - 0.46 * this.getDL(atom) + corr;
                    }
                    if (ketoType == 1 || ketoType == 2) {
                        pka += -1.7;
                    }
                    if (ketoType == 3 || ketoType == 4) {
                        pka += 3.5;
                    }
                    if (ketoType == 5) {
                        pka += 10.5;
                    }
                    return pka;
                }
                case 650: {
                    this.getDelIsland(atom, 3);
                    pka = subType == 16 ? 9.9 - 12.26 * this.getBondCharge8(atom, 65) - 0.46 * this.getDL(atom) : (subType == 15 ? 13.9 - 12.26 * this.getBondCharge8(atom, 65) - 0.46 * this.getDL(atom) : 17.9 - 12.26 * this.getBondCharge8(atom, 65) - 0.46 * this.getDL(atom));
                    if (ketoType == 1 || ketoType == 2) {
                        pka += -1.7;
                    }
                    if (ketoType == 3 || ketoType == 4) {
                        pka += 3.5;
                    }
                    if (ketoType == 5) {
                        pka += 8.5;
                    }
                    return pka;
                }
                case 67: {
                    this.getDelIsland(atom, 3);
                    if (subType == 16) {
                        pka = 9.3 - 12.26 * this.getBondCharge8(atom, 67) - 0.46 * this.getDL(atom);
                        pka += this.addEsterCorr(atom);
                    } else {
                        pka = subType == 15 ? 16.3 - 12.26 * this.getBondCharge8(atom, 67) - 0.46 * this.getDL(atom) : (this.pkaAcidType[atom][1] == 10 ? 17.0 - 12.26 * this.getBondCharge8(atom, 67) - 0.46 * this.getDL(atom) : (ketoType == 3 || ketoType == 4 ? 31.8 - 12.26 * this.getBondCharge8(atom, 67) - 0.46 * this.getDL(atom) : 21.8 - 12.26 * this.getBondCharge8(atom, 67) - 0.46 * this.getDL(atom)));
                    }
                    if (ketoType == 1 || ketoType == 2) {
                        pka += -1.7;
                    }
                    if (ketoType == 5) {
                        pka += 3.5;
                    }
                    pka += this.cyanoInc[atom];
                    if (this.cHtab[atom].length != 4) {
                        pka += 15.5;
                    }
                    return pka;
                }
                case 705: {
                    int L = this.cHtab[atom].length;
                    this.getDelIsland(atom, 3);
                    pka = L == 4 ? (subType == 16 ? 9.3 - 12.26 * this.getBondCharge8(atom, 67) - 0.46 * this.getDL(atom) : (!this.isInRing[atom] ? 26.0 - 12.26 * this.getBondCharge8(atom, 67) - 0.46 * this.getDL(atom) : 18.0 - 12.26 * this.getBondCharge8(atom, 67) - 0.46 * this.getDL(atom))) : 16.0 - 12.26 * this.getBondCharge8(atom, 67) - 0.46 * this.getDL(atom);
                    return pka;
                }
                case 706: {
                    int L = this.cHtab[atom].length;
                    this.getDelIsland(atom, 3);
                    pka = L == 4 ? (subType == 16 ? 9.3 - 12.26 * this.getBondCharge8(atom, 67) - 0.46 * this.getDL(atom) : (!this.isInRing[atom] ? 26.0 - 12.26 * this.getBondCharge8(atom, 67) - 0.46 * this.getDL(atom) : 18.0 - 12.26 * this.getBondCharge8(atom, 67) - 0.46 * this.getDL(atom))) : 15.0 - 12.26 * this.getBondCharge8(atom, 67) - 0.46 * this.getDL(atom);
                    return pka;
                }
                case 68: {
                    this.getDelIsland(atom, 3);
                    pka = subType == 16 ? 12.0 - 12.26 * this.getBondCharge8(atom, 68) - 0.46 * this.getDL(atom) : (subType == 15 ? 19.0 - 12.26 * this.getBondCharge8(atom, 68) - 0.46 * this.getDL(atom) : 22.0 - 12.26 * this.getBondCharge8(atom, 68) - 0.46 * this.getDL(atom));
                    if (ketoType == 1 || ketoType == 2) {
                        pka += -1.7;
                    }
                    if (ketoType == 3 || ketoType == 4) {
                        pka += 3.5;
                    }
                    if (ketoType == 5) {
                        pka += 3.5;
                    }
                    return pka;
                }
                case 69: {
                    this.getDelIsland(atom, 3);
                    pka = subType == 16 ? 16.8 - 12.26 * this.getBondCharge8(atom, 69) - 0.46 * this.getDL(atom) : (subType == 15 ? 20.8 - 12.26 * this.getBondCharge8(atom, 69) - 0.46 * this.getDL(atom) : (subType == 32 ? 18.0 - 12.26 * this.getBondCharge8(atom, 69) - 0.56 * this.getDL(atom) : (subType == 22 ? 32.8 - 12.26 * this.getBondCharge8(atom, 69) - 0.46 * this.getDL(atom) : 25.4 - 12.26 * this.getBondCharge8(atom, 69) - 0.46 * this.getDL(atom))));
                    if (ketoType == 1 || ketoType == 2) {
                        pka += -1.7;
                    }
                    if (ketoType == 3 || ketoType == 4) {
                        pka += 3.5;
                    }
                    if (ketoType == 5) {
                        pka += 3.5;
                    }
                    return pka += this.cyanoInc[atom];
                }
                case 70: {
                    this.getDelIsland(atom, 3);
                    pka = subType == 16 ? 10.8 - 12.26 * this.getBondCharge8(atom, 70) - 0.46 * this.getDL(atom) : (subType == 15 ? 13.8 - 12.26 * this.getBondCharge8(atom, 70) - 0.46 * this.getDL(atom) : 16.8 - 12.26 * this.getBondCharge8(atom, 70) - 0.46 * this.getDL(atom));
                    if (ketoType == 1 || ketoType == 2) {
                        pka += -1.7;
                    }
                    if (ketoType == 3 || ketoType == 4) {
                        pka += 3.5;
                    }
                    if (ketoType == 5) {
                        pka += 3.5;
                    }
                    return pka;
                }
                case 71: {
                    this.getDelIsland(atom, 3);
                    pka = subType == 16 ? 10.8 - 12.26 * this.getBondCharge8(atom, 71) - 0.46 * this.getDL(atom) : (subType == 15 ? 13.8 - 12.26 * this.getBondCharge8(atom, 71) - 0.46 * this.getDL(atom) : 15.8 - 12.26 * this.getBondCharge8(atom, 71) - 0.46 * this.getDL(atom));
                    if (ketoType == 1 || ketoType == 2) {
                        pka += -1.7;
                    }
                    if (ketoType == 3 || ketoType == 4) {
                        pka += 3.5;
                    }
                    if (ketoType == 5) {
                        pka += 3.5;
                    }
                    return pka;
                }
                case 7: {
                    pka = 9.5;
                    return pka;
                }
                case 100: {
                    this.getDelIsland(atom, 3);
                    double dl = this.getDL(atom);
                    boolean dr = false;
                    pka = 7.72 - 0.64 * this.getBondCharge8(atom, 100) + 1.16 * this.getApol_C() - 1.42 * dl;
                    if (subType == 30) {
                        pka = 9.4 - 1.64 * this.getBondCharge8(atom, 100) + 1.16 * this.getApol_C() - 1.42 * dl;
                        pka = this.isTripleKeto(atom) ? (pka += -6.2) : (this.isAraConnected(atom) ? (pka += -5.5) : (rIndex != -1 ? (pka += -3.0) : (pka += -0.7)));
                    } else if (subType == 35) {
                        pka = 7.72 - 5.64 * this.getBondCharge8(atom, 100) + 1.16 * this.getApol_C() - 1.42 * dl;
                        if (this.isAraConnected(atom)) {
                            pka += -3.5;
                        } else if (this.isTripleKeto(atom)) {
                            pka += -6.2;
                        }
                        if (rIndex != -1) {
                            pka += -1.0;
                        }
                    } else if (subType == 10 || subType == 15) {
                        if (!this.isTripleKeto(atom)) {
                            pka += 3.4;
                        } else if (this.isAraConnected(atom)) {
                            pka += -5.5;
                        }
                        if (subType == 15) {
                            pka += -2.5;
                        }
                    } else if (subType == 40) {
                        pka = rIndex == -1 ? (pka += 3.0) : (this.isTripleKeto(atom) ? (pka += -6.2) : (pka += -2.5));
                    } else if (subType == 50) {
                        double a = this.addDelocCorr(atom, rIndex);
                        pka -= a;
                    } else if (subType == 501) {
                        double a = this.addDelocCorr(atom, rIndex);
                        pka += -5.0;
                        pka -= a;
                    } else if (subType == 55 || subType == 36) {
                        pka = 11.07 - 12.26 * this.getBondCharge8(atom, 100) - 0.56 * this.getDL(atom);
                        dr = true;
                    } else if (this.isAraConnected(atom)) {
                        pka += -3.4;
                    } else if (this.isTripleKeto(atom)) {
                        pka += -6.2;
                    }
                    if (ketoType == 1 || ketoType == 2) {
                        pka += -1.7;
                    }
                    if (ketoType == 3 || ketoType == 4) {
                        pka += 3.5;
                    }
                    if (ketoType == 5 && !dr) {
                        pka += 5.5;
                    }
                    return pka += this.addaCHHaloCorr(atom);
                }
                case 101: {
                    this.getDelIsland(atom, 3);
                    double dl = this.getDL(atom);
                    pka = 11.07 - 12.26 * this.getBondCharge8(atom, 101) - 0.56 * dl;
                    if (subType == 20) {
                        pka += 7.2;
                    } else if (subType == 233) {
                        pka += 0.2;
                    } else if (subType == 23) {
                        pka += 0.8;
                    } else if (subType == 21 || subType == 211) {
                        this.getDelIsland(atom, 4);
                        dl = this.getDL(atom);
                        double apol = this.setAtomSphere(atom, 10, 0.75) / (double)this.getAtomCount();
                        pka = 7.72 - 0.64 * this.getBondCharge8(atom, 101) + 1.16 * apol - 1.42 * dl;
                    } else if (subType == 22 || subType == 222) {
                        pka -= 1.5;
                        double s = this.setAtomSphere(atom, 10, 0.75) / (double)this.getAtomCount();
                        pka += 8.04 * (s - 0.354) - 0.5632;
                    } else if (subType == 16) {
                        pka += 0.0;
                    } else if (subType == 15) {
                        pka += 0.0;
                    }
                    if (ketoType == 1 || ketoType == 2) {
                        pka += -1.7;
                    }
                    if (ketoType == 3 || ketoType == 4) {
                        pka += 3.5;
                    }
                    if (ketoType == 5) {
                        pka += 5.5;
                    }
                    return pka;
                }
                case 120: {
                    this.getDelIsland(atom, 3);
                    double dl = this.getDL(atom);
                    if (subType == 1 || subType == 2) {
                        pka = 14.07 - 6.26 * this.getBondCharge8(atom, 120) - 0.56 * dl;
                        pka += this.addEsterCorr(atom);
                    } else if (subType == 3) {
                        pka = 18.07 - 6.26 * this.getBondCharge8(atom, 120) - 0.56 * dl;
                        pka += this.addEsterCorr(atom);
                    } else {
                        pka = 35.07 - 6.26 * this.getBondCharge8(atom, 120) - 0.56 * dl;
                        pka += this.addEsterCorr(atom);
                    }
                    if (subType == 2) {
                        rIndex = this.pka.charge.getRings().getSmallestRingIndex(atom);
                        if (rIndex != -1) {
                            this.setSphereSize(this.pka.nonAring[rIndex].length);
                        }
                    } else {
                        this.getDelIsland(atom, 20);
                    }
                    return pka += -(0.216 * (double)this.getSphereSize() - 1.08);
                }
                case 510: {
                    pka = 12.07 - 12.26 * this.getBondCharge2(atom);
                    return pka;
                }
                case 520: {
                    int L = this.cHtab[atom].length;
                    int H = this.mol.getAtom(atom).getImplicitHcount();
                    int m = this.pkaAcidType[atom][3];
                    if (subType == 5) {
                        double r = this.getAvarageAromaticRingCharge(rIndex);
                        pka = 30.0 - 52.5 * (r + this.pka.Qsum[atom]);
                    } else if (subType == 10) {
                        if (H == 3) {
                            double r = this.getAvarageAromaticRingCharge(rIndex);
                            this.getDelIsland(atom, 10);
                            pka = 39.5 - 52.5 * (0.15 * r + this.pka.Qsum[atom]) - 0.2 * (double)this.getSphereSize();
                        } else if (H == 2) {
                            pka = 36.0 - 32.5 * this.getBondCharge2(atom) + 6.0;
                            if (m == 2) {
                                this.getDelIsland(atom, 3);
                                pka = 29.0 - 12.26 * this.getBondCharge8(atom, 65) - 0.46 * this.getDL(atom);
                            }
                        } else if (H == 1) {
                            if (m == 3) {
                                this.getDelIsland(atom, 3);
                                pka = 26.0 - 12.26 * this.getBondCharge8(atom, 65) - 0.46 * this.getDL(atom);
                            } else {
                                pka = 36.0 - 32.5 * this.getBondCharge2(atom) + 6.0;
                            }
                        }
                    } else if (subType == 20 || subType == 40) {
                        double s = this.setAtomSphere(atom, 4, 0.75) / (double)this.getAtomCount();
                        this.getDelIsland(atom, 3);
                        int inc = this.getSphereSize() > 2 ? this.getSphereSize() - 2 : 0;
                        double dl = this.getDL(atom);
                        boolean chgNb = false;
                        boolean dbv = false;
                        if (L == 4) {
                            double cchg = 0.0;
                            if (this.isNbCharged(atom) == -1) {
                                cchg = this.getBondCharge2_C(atom);
                                chgNb = true;
                            } else {
                                cchg = this.getBondCharge2(atom);
                            }
                            if (this.isnbCarboxy(atom)) {
                                pka = 28.8 * Math.pow(2.718282, -1.5818 * cchg) - (double)inc;
                            } else if (this.pka.isDBViniliLike(atom)) {
                                pka = 28.8 * Math.pow(2.718282, -1.5818 * cchg) - (double)inc + 1.0;
                                dbv = true;
                            } else {
                                pka = chgNb ? 28.8 * Math.pow(2.718282, -1.5818 * cchg) - (double)inc + 15.0 : 28.8 * Math.pow(2.718282, -1.5818 * cchg) - (double)inc + 10.0;
                            }
                            pka += this.addEsterCorr(atom);
                            pka += this.cyanoInc[atom];
                            if (subType == 40 && !dbv) {
                                pka += -6.0;
                            }
                        } else if (L == 3) {
                            double y = -35.5 * this.pka.Qsum[atom] - 0.5;
                            pka = 12.56 * s + 20.7 - dl + y + 10.0;
                        } else if (L == 2) {
                            pka = 21.01 + 0.25 * s - 17.0 * this.getBondCharge2(atom) - 1.65 * dl;
                        }
                    } else if (subType == 30) {
                        double p = this.pka.setAtomSphere(atom, 10, 0.75);
                        double chg2 = this.getBondCharge2_C(atom);
                        pka = this.isJustCarbon() ? 1.55 * p - 35.23 * chg2 - 0.49 + 46.0 : 1.55 * p - 15.23 * chg2 - 0.49 + 46.0;
                    }
                    return pka;
                }
                case 522: {
                    double pp = this.pka.setAtomSphere(atom, 10, 0.75);
                    this.getDelIsland(atom, 10);
                    int ylideType = this.pkaAcidType[atom][3];
                    if (ylideType == 15) {
                        double r = this.getAvarageAromaticRingCharge(rIndex);
                        pka = 39.5 - 52.5 * (0.15 * r + this.pka.Qsum[atom]) - 0.2 * (double)this.getSphereSize();
                    } else if (this.pkaAcidType[atom][7] == 20) {
                        pka = 1.5 * pp + 6.68 - 0.2 * (double)this.getSphereSize();
                    } else if (this.pkaAcidType[atom][7] == 21) {
                        pka = 1.5 * pp + 7.68 - 0.2 * (double)this.getSphereSize();
                    } else if (this.pkaAcidType[atom][7] == 22) {
                        pka = 1.5 * pp + 8.68 - 0.2 * (double)this.getSphereSize();
                    } else if (this.pkaAcidType[atom][7] == 23) {
                        pka = 1.5 * pp + 9.68 - 0.2 * (double)this.getSphereSize();
                    } else if (this.pkaAcidType[atom][7] == 24) {
                        pka = 1.5 * pp - 22.26 * this.getBondCharge23(atom) + 12.68 - 0.2 * (double)this.getSphereSize();
                    } else if (this.pkaAcidType[atom][7] == 25) {
                        pka = 1.5 * pp - 22.26 * this.getBondCharge23(atom) + 18.68 - 0.2 * (double)this.getSphereSize();
                    } else if (this.pkaAcidType[atom][7] == 26) {
                        pka = 1.5 * pp - 22.26 * this.getBondCharge23(atom) + 23.68 - 0.2 * (double)this.getSphereSize();
                    } else if (this.pkaAcidType[atom][7] == 27) {
                        pka = 1.5 * pp - 22.26 * this.getBondCharge23(atom) + 28.68 - 0.2 * (double)this.getSphereSize();
                    }
                    return pka;
                }
            }
        }
        return pka;
    }

    private double getHaloAcidicpKa(int atom) {
        switch (this.pkaAcidType[atom][0]) {
            case 1: {
                return 3.17;
            }
            case 2: {
                return -7.0;
            }
            case 3: {
                return -8.0;
            }
            case 4: {
                return -9.0;
            }
        }
        return Double.NaN;
    }

    private double getNHAcidicpKa(int atom) {
        if (this.pkaAcidType[atom][0] == -2) {
            return Double.NaN;
        }
        double charge = this.mol.getAtom(atom).getCharge();
        int aAroma = this.pkaAcidType[atom][1];
        int bAroma = this.pkaAcidType[atom][2];
        int crossAtom = this.pkaAcidType[atom][3];
        int ketoCarbon = this.pkaAcidType[atom][4];
        int ketoCarbon2 = this.pkaAcidType[atom][6];
        int subType = this.pkaAcidType[atom][7];
        int rInd = this.pkaAcidType[atom][8];
        double[] Qsum = this.pka.Qsum;
        if (charge != 0.0) {
            return Double.NaN;
        }
        switch (this.pkaAcidType[atom][0]) {
            case 0: {
                this.setProtonationState();
                double bdchg = this.getBondCharge2(atom);
                double S = 0.15 * this.getHeteroIncrement(atom) + bdchg;
                double pkaVal = S < -0.34 ? -6.1329 * S + 15.88 : -31.4 * S + 7.66;
                pkaVal += this.getRingResInc(atom);
                pkaVal += this.getAlphaHBond(atom);
                pkaVal += this.cyanoInc[atom];
                if (subType == 10) {
                    pkaVal += -1.0;
                    if (bdchg < -0.32) {
                        pkaVal += 5.0 * bdchg + 1.6;
                    }
                }
                return pkaVal += this.addBetaPyrNInc(atom);
            }
            case 1: {
                double pkaVal = Double.NaN;
                if (subType == 10) {
                    double s = Qsum[atom] + Qsum[crossAtom];
                    if (s > 0.01) {
                        pkaVal = 0.2309 * Math.pow(s, -0.57429) + 4.052;
                    } else {
                        double w = Qsum[atom] / Qsum[crossAtom];
                        pkaVal = 52.0 * (s / w) + 6.52;
                    }
                    pkaVal += this.getHeteroCorrection(aAroma, atom, 1);
                } else {
                    double s = Qsum[atom] + Qsum[crossAtom];
                    double w = Qsum[atom] / Qsum[crossAtom];
                    pkaVal = 52.0 * (s / w) + 6.52;
                }
                return pkaVal += this.cyanoInc[atom];
            }
            case 2: {
                double w = this.getBondCharge14(crossAtom);
                double y = this.getBondCharge2(atom);
                double pkaVal = Double.NaN;
                if (subType == 10) {
                    double s = this.getBondCharge6(atom);
                    pkaVal = s <= 0.0 ? -43.2 * Qsum[atom] + 11.505 + 2.0 : 3.6811 * Math.pow(s, -0.3859);
                    pkaVal += -5.0 * w;
                } else {
                    pkaVal = -43.2 * Qsum[atom] + 11.505 + 2.0;
                    pkaVal += -8.5 * w;
                    pkaVal = y < 0.11 ? (pkaVal += 39.695 * y * y - 49.03 * y + 2.73) : (pkaVal += -10.0 * y - 1.0);
                }
                return pkaVal;
            }
            case 3: {
                double corr = 0.0;
                double r = this.getBondCharge22(atom);
                double pkaVal = Double.NaN;
                if (r < -0.22) {
                    corr = -12.5 * r - 3.75;
                } else if (r < -0.15 && r > -0.22) {
                    corr = -19.45 * r - 5.27;
                } else if (r > -0.15) {
                    corr = -4.32 * r - 3.0;
                }
                this.getDelIsland(atom, 3);
                pkaVal = 16.8 - 12.26 * this.getBondCharge8(atom, 65) - 0.46 * this.getDL(atom) + corr;
                if (this.aza[atom] != -1) {
                    pkaVal += -1.5;
                }
                if (this.isPidefficientRing(aAroma)) {
                    pkaVal += -2.0;
                }
                return pkaVal += this.cyanoInc[atom];
            }
            case 4: {
                double pkaVal = Double.NaN;
                double s = this.pka.Qsum[atom] + 0.1644;
                if (s > 0.01) {
                    pkaVal = 2.5567 * Math.pow(s, -0.4456) + 0.85;
                } else {
                    this.getDelIsland(atom, 3);
                    pkaVal = 16.8 - 12.26 * this.getBondCharge8(atom, 65) - 0.46 * this.getDL(atom);
                    if (this.aza[atom] != -1) {
                        pkaVal += -1.5;
                        int d = this.isAzaPosRes(this.aza[atom]);
                        if (d == 2) {
                            pkaVal += -2.0;
                        } else if (d == 4) {
                            pkaVal += -2.0;
                        }
                    }
                }
                double h = this.getHeteroCorrection(aAroma, atom, 4);
                pkaVal += h;
                if (subType == 100) {
                    s = 0.0;
                    if (h == 0.0) {
                        s = this.addCarbamideCorrection(ketoCarbon);
                    }
                    if (s != 0.0) {
                        pkaVal += s;
                    } else if (this.pka.sAra[atom] == 1) {
                        pkaVal += 0.0;
                    } else if (this.pg.getCarboxy()[ketoCarbon] != 700) {
                        pkaVal += -1.7;
                    }
                } else {
                    pkaVal += this.addCarbamoylCorrection(ketoCarbon);
                }
                return pkaVal;
            }
            case 5: {
                this.setProtonationState();
                double s = this.getBondCharge2(atom);
                double pkaVal = -39.032 * s + 16.784;
                return pkaVal += this.getPiDefficientFactor(aAroma) / 4.0;
            }
            case 6: {
                double s = this.getBondCharge16(atom);
                double pkaVal = Double.NaN;
                if (subType == 20 || subType == 200) {
                    int[] vinilInfo = this.getnVinilInfo(atom);
                    int a = vinilInfo[0];
                    s = this.mol.getAtom(a).getCharge() == 1 ? 0.25 * Qsum[a] : Qsum[a];
                    a = vinilInfo[1];
                    s = this.mol.getAtom(a).getCharge() == 1 ? (s += 0.25 * Qsum[a]) : (s += Qsum[a]);
                    s += this.getBondCharge20(atom);
                    if (s < 0.05) {
                        pkaVal = s > -1.0 ? -23.634 * s * s - 42.906 * s + 12.719 : 60.0;
                    } else if (s < 1.0 && s > 0.05) {
                        pkaVal = 4.3747 * s * s - 9.7368 * s + 11.866;
                    }
                    if (subType == 200) {
                        pkaVal += -6.0;
                    }
                } else if (subType != 10) {
                    pkaVal = s < 0.086 ? 163.3 * s * s - 38.804 * s + 11.75 : -35.14 * s + 12.64;
                } else {
                    pkaVal = s < 0.086 ? 163.3 * s * s - 38.804 * s + 11.75 : -35.14 * s + 12.64;
                    double c = -15.13 * this.getBondCharge2(atom) + 5.01 + this.orthoNPlus(aAroma);
                    if (c > 0.0) {
                        pkaVal += c;
                    }
                }
                if (this.aza[atom] != -1) {
                    if (this.mol.getAtom(this.aza[atom]).getCharge() == 1) {
                        pkaVal += 2.5;
                    }
                    if (this.pka.sAra[atom] == 1) {
                        pkaVal += -4.0;
                    }
                }
                return pkaVal;
            }
            case 7: {
                double pkaVal = Double.NaN;
                pkaVal = subType == 10 || subType == 20 ? -43.2 * Qsum[atom] + 11.505 : -49.668 * Qsum[atom] + 10.667;
                if (subType == 100 || subType == 20) {
                    pkaVal += -1.3;
                }
                return pkaVal;
            }
            case 8: {
                return -49.668 * Qsum[atom] + 10.667;
            }
            case 9: {
                double pkaVal = 10.128 * Math.pow(2.718282, -1.8243 * Qsum[this.pkaAcidType[atom][2]]);
                if (subType == 100) {
                    pkaVal += -1.7;
                }
                pkaVal += -14.0 * Qsum[crossAtom] - 1.26;
                pkaVal += this.addAmideHaloCorr(atom);
                return pkaVal += this.cyanoInc[atom];
            }
            case 10: {
                double pkaVal = -49.668 * Qsum[atom] + 10.667;
                if (subType == 100) {
                    pkaVal += -2.2;
                }
                return pkaVal;
            }
            case 11: {
                double pkaVal = Double.NaN;
                if (subType == 80) {
                    pkaVal = -7.14 * this.getBondCharge2(atom) + 11.51;
                    pkaVal += -2.5 * this.getBondCharge2(bAroma);
                } else if (subType == 70) {
                    pkaVal = -7.14 * this.getBondCharge2(atom) + 11.51;
                    pkaVal = rInd != -1 ? (pkaVal += -49.5 * this.getAvarageAliphaticRingCharge(rInd) + 1.5) : (pkaVal += -1.5);
                } else {
                    pkaVal = -33.819 * this.getBondCharge2(atom) + 14.963;
                    pkaVal += 2.0 * this.getHeteroCorrection(bAroma, ketoCarbon, 11);
                    if (subType == 100 && this.pg.getGroupType(atom) == 10) {
                        pkaVal += 1.8;
                    }
                }
                return pkaVal += this.cyanoInc[atom];
            }
            case 12: {
                double pkaVal = Double.NaN;
                double s = this.getCONHCharge(ketoCarbon);
                double alpha = this.setAtomSphere(ketoCarbon, 3, 0.75);
                pkaVal = 1.0 + s > 0.8 ? 0.45299 * Math.pow(1.0 + s, -6.3512) + 0.67553 * alpha + 4.975 : -14.06 * (1.0 + s) + 13.85 + 0.67553 * alpha + 4.975 + 0.7;
                if (this.getHAraCount() != 0) {
                    pkaVal += 1.1;
                }
                double hc = this.getHeteroCorrection(bAroma, ketoCarbon, 12);
                pkaVal = subType == 200 ? (this.isOrthoHetero(this.pkaAcidType[atom][2]) ? (pkaVal += 1.2) : (pkaVal += -2.2)) : (subType == 100 ? (this.aza[atom] != -1 ? (pkaVal += 1.1) : -23.37 * this.getBondCharge2(atom) + 11.607) : (pkaVal += hc));
                return pkaVal;
            }
            case 13: 
            case 14: {
                return -49.668 * Qsum[atom] + 10.667;
            }
            case 15: {
                this.getDelIsland(crossAtom, 3);
                double pka1 = 11.07 - 10.26 * this.getBondCharge19(crossAtom, 11) - 0.56 * this.getDL(crossAtom);
                double s1 = this.setAtomSphere(crossAtom, 4, 0.75) / (double)this.getAtomCount();
                this.getDelIsland(atom, 3);
                double pka2 = 11.07 - 10.26 * this.getBondCharge19(atom, 11) - 0.56 * this.getDL(atom);
                double s2 = this.setAtomSphere(atom, 4, 0.75) / (double)this.getAtomCount();
                double pkaVal = pka1 < pka2 ? 0.75 * pka1 + 0.25 * pka2 : 0.75 * pka2 + 0.25 * pka1;
                pkaVal += 3.0 * (s1 - 0.5) + 3.0 * (s2 - 0.4);
                return pkaVal += this.cyanoInc[atom];
            }
            case 16: {
                double pkaVal = Double.NaN;
                if (this.aza[atom] != -1) {
                    double k1 = this.getCONHCharge(ketoCarbon);
                    double k2 = this.getCONHCharge(ketoCarbon2);
                    pkaVal = -7.95 * (k1 + k2) + 6.97;
                } else {
                    pkaVal = -43.2 * Qsum[atom] + 11.805;
                }
                if (subType == 100) {
                    pkaVal += 1.3;
                    pkaVal += this.addSideCorr(rInd, atom, 16);
                } else if (subType == 600) {
                    pkaVal += 0.0;
                } else if (subType == 300) {
                    double w = this.getSorOCarbamoyl(ketoCarbon, ketoCarbon2);
                    pkaVal = w == 0.0 ? (pkaVal += 1.3) : (pkaVal += w);
                    pkaVal += this.addSideCorr(rInd, atom, 16);
                } else if (subType == 500) {
                    pkaVal += 1.3;
                } else if (subType != 200) {
                    pkaVal += 3.2;
                    if (this.pg.getGroupType(atom) == 10 && subType == 400) {
                        pkaVal += 1.3;
                    }
                    pkaVal += this.addKetoKetoCorr(ketoCarbon, ketoCarbon2);
                } else if (subType == 200) {
                    pkaVal += this.addSideCorr(rInd, atom, 16);
                }
                return pkaVal += this.cyanoInc[atom];
            }
            case 17: {
                int aN;
                double chg;
                double pkaVal = Double.NaN;
                if (subType != 100) {
                    chg = this.getBondCharge2_0(atom);
                    if (chg > 0.0106) {
                        double div = 18.18 * chg + 0.81;
                        pkaVal = -81.0 / div * chg + 3.06 * (this.setAtomSphere(atom, 10, 1.0) / (double)this.getAtomCount()) + 10.7;
                    } else {
                        pkaVal = -54.3 * Qsum[atom] + 3.06 * (this.setAtomSphere(atom, 10, 1.0) / (double)this.getAtomCount()) + 6.8;
                    }
                } else {
                    chg = this.getBondCharge2_0(atom);
                    double div = chg > 0.0106 ? 18.18 * chg + 0.81 : 1.0;
                    pkaVal = -81.0 / div * chg + 3.06 * (this.setAtomSphere(atom, 10, 1.0) / (double)this.getAtomCount()) + 6.8;
                }
                if (this.isInRing[atom]) {
                    pkaVal += -1.2;
                }
                if (this.pg.getGroupProperty()[atom] == 410 && subType != 320) {
                    pkaVal += -4.3;
                }
                pkaVal += this.cyanoInc[atom];
                if (this.pg.getCarboxy()[ketoCarbon] == 600) {
                    pkaVal += 1.5;
                }
                if ((aN = this.aza[atom]) != -1) {
                    if (this.pg.getCarboxy()[aN] == 1500 || this.pg.getCarboxy()[aN] == 1600) {
                        pkaVal -= 0.5;
                    } else if (this.isAnilineAzaN(atom)) {
                        pkaVal -= 0.5;
                    } else if (subType != 100) {
                        pkaVal -= 2.5;
                    }
                }
                if (subType == 100) {
                    pkaVal = this.pka.nonAring[rInd].length == 5 ? (pkaVal -= 3.0) : (pkaVal -= 2.0);
                } else if (subType == 200) {
                    pkaVal += 0.0;
                } else if (subType == 220) {
                    pkaVal -= 1.7;
                }
                return pkaVal;
            }
            case 18: {
                return 5.9533 * Math.pow(2.718282, -10.1003 * Qsum[atom]) + 6.0;
            }
            case 21: {
                double s = this.getBondCharge2(ketoCarbon) + Qsum[atom];
                double pkaVal = Double.NaN;
                if (s < 0.136) {
                    pkaVal = -24.618 * s + 13.55;
                    pkaVal += -5.3 * this.getNbBondCharge2(atom) - 1.05;
                } else {
                    pkaVal = 0.6224 * Math.pow(s, -1.3858);
                }
                return pkaVal;
            }
            case 19: {
                double c = this.getCONHCharge(ketoCarbon);
                double pkaVal = -23.73 * c - 14.76 * Qsum[atom] - 0.13 * this.setAtomSphere(ketoCarbon, 3, 0.75) + 4.49;
                if (this.pg.getCarboxy()[ketoCarbon] == 600) {
                    pkaVal -= 5.0;
                }
                pkaVal += 10.0 * c + 2.8;
                if (this.aza[atom] != -1) {
                    pkaVal += 1.5;
                }
                return pkaVal;
            }
            case 20: {
                if (this.aza[atom] != -1) {
                    double k1 = this.getCONHCharge(ketoCarbon);
                    double k2 = this.getCONHCharge(ketoCarbon2);
                    return -7.95 * (k1 + k2) + 6.97 - 2.5;
                }
                return -43.2 * Qsum[atom] + 11.505 - 2.5;
            }
            case 22: {
                this.getDelIsland(atom, 3);
                double dl = this.getDL(atom);
                double apol = this.setAtomSphere(atom, 4, 0.75) / (double)this.getAtomCount();
                double pkaVal = 7.72 - 0.64 * this.getBondCharge8(atom, 22) + 1.16 * apol - 1.42 * dl;
                pkaVal += this.getHeteroCorrection(aAroma, atom, 4);
                return pkaVal += this.addCarbamoylCorrection(ketoCarbon);
            }
            case 23: {
                return -10.0 * (this.getBondCharge2(atom) + 0.1997) + 11.6;
            }
            case 24: {
                double pkaVal = -42.71 * Qsum[atom] + 13.18;
                int aN = this.aza[atom];
                if (aN != -1) {
                    if (this.pg.getCarboxy()[aN] != 200) {
                        pkaVal += 1.5;
                    }
                    if (this.mol.getAtom(aN).getCharge() == -1) {
                        pkaVal += 4.0;
                    }
                }
                return pkaVal += this.addHeteroKetoCorrection(ketoCarbon);
            }
            case 25: {
                double pkaVal = Double.NaN;
                if (this.aza[atom] != -1) {
                    double k1 = this.getCONHCharge(ketoCarbon);
                    double k2 = this.getCONHCharge(ketoCarbon2);
                    pkaVal = -7.95 * (k1 + k2) + 6.97;
                } else {
                    pkaVal = -43.2 * Qsum[atom] + 11.505;
                }
                if (subType == 200) {
                    pkaVal -= 2.0;
                }
                pkaVal = subType == 100 ? (pkaVal += -1.7) : (pkaVal += this.addCarbamoylCorrection(ketoCarbon));
                return pkaVal;
            }
            case 26: {
                Double pkaVal = -43.2 * Qsum[atom] + 11.505;
                if (subType == 125) {
                    pkaVal = pkaVal + -2.2;
                } else if (subType == 200) {
                    pkaVal = pkaVal + -1.5;
                } else if (subType != 100) {
                    int aN = this.aza[atom];
                    if (aN != -1) {
                        if (this.pg.getCarboxy()[aN] == 1700) {
                            pkaVal = subType == 120 ? Double.valueOf(pkaVal + 1.5) : Double.valueOf(pkaVal + 3.0);
                        } else if (this.pg.getCarboxy()[aN] != 200) {
                            pkaVal = pkaVal + 1.5;
                        }
                    } else if (subType == -1 && (this.pg.getCarboxy()[ketoCarbon] == -1 || this.pg.getCarboxy()[ketoCarbon2] == -1)) {
                        pkaVal = !this.isInRing[atom] ? Double.valueOf(pkaVal + 2.8) : Double.valueOf(pkaVal + 2.0);
                    }
                }
                if (subType == 300) {
                    pkaVal = pkaVal - 1.5;
                } else if (subType == 100 || subType == 120) {
                    pkaVal = pkaVal + this.addSideCorr(rInd, atom, 26);
                }
                return pkaVal;
            }
            case 27: {
                double bc = 0.0;
                for (int i = 0; i < 6; ++i) {
                    int vi = this.getnVinilInfo(atom)[i];
                    if (vi == -1) continue;
                    bc += this.getBondCharge12(vi);
                    bc += -Qsum[vi];
                }
                return 10.93 * Math.pow(2.718282, -1.2263 * bc);
            }
            case 28: {
                double bc = 0.0;
                for (int i = 0; i < 6; ++i) {
                    int vi = this.getnVinilInfo(atom)[i];
                    if (vi == -1) continue;
                    bc += this.getBondCharge12(vi);
                    bc += -Qsum[vi];
                }
                bc += this.getBondCharge12(this.pkaAcidType[atom][1]);
                return 10.93 * Math.pow(2.718282, -1.2263 * (bc += -Qsum[this.pkaAcidType[atom][1]]));
            }
            case 29: {
                this.setProtonationState();
                double bdchg = this.getBondCharge2(atom);
                double S = 0.15 * this.getHeteroIncrement(atom) + bdchg;
                double pkaVal = S < -0.34 ? -6.1329 * S + 15.88 : -31.4 * S + 7.66;
                pkaVal += this.getAlphaHBond(atom);
                pkaVal += this.cyanoInc[atom];
                if (subType == 21) {
                    pkaVal += -1.0;
                } else if (subType == 10) {
                    pkaVal += -4.75;
                } else if (subType == 11) {
                    pkaVal += -7.0;
                } else if (subType == 115) {
                    pkaVal += -2.55;
                } else if (subType == 116) {
                    pkaVal += -4.8;
                }
                return pkaVal;
            }
            case 30: 
            case 31: 
            case 32: {
                double bpka = new BasicPKa(this.pka).getAliphaticBasicpKa(atom, false);
                double exp = bpka >= 0.0 ? 0.0508 : 0.0108;
                return 21.43 * Math.pow(2.718282, exp * bpka);
            }
            case 33: {
                return -62.0 * Qsum[atom] + 13.6;
            }
        }
        return Double.NaN;
    }

    private double getSHAcidicpKa(int atom) {
        if (this.pkaAcidType[atom][0] == -2) {
            return -9.0 * this.getBondCharge2(atom) + 8.5;
        }
        int aAroma = this.pkaAcidType[atom][1];
        int subType = this.pkaAcidType[atom][7];
        double[] Qsum = this.pka.Qsum;
        switch (this.pkaAcidType[atom][0]) {
            case 0: {
                if (subType == 10) {
                    this.setProtonationState();
                    return -2.35 * this.getBondCharge2(atom) + 2.1 * (this.setAtomSphere(atom, 10, 1.0) / (double)this.getAtomCount()) + 2.86 + 0.5 * this.getTautomerIncrement(atom, aAroma) + this.cyanoInc[atom];
                }
                return -2.35 * this.getBondCharge2(atom) + 2.1 * (this.setAtomSphere(atom, 10, 1.0) / (double)this.getAtomCount()) + 2.86 + this.cyanoInc[atom];
            }
            case 1: {
                if (subType == 10) {
                    return -8.05 * (this.getBondCharge(atom) - Qsum[atom]) + 2.4;
                }
                return -80.10000000000001 * this.getBondCharge(atom) + 5.67;
            }
            case 4: {
                return -8.05 * (this.getBondCharge(atom) - Qsum[atom]) + 2.4;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 21: {
                return -7.748 * this.getBondCharge2(atom) + 1.209;
            }
            case 13: {
                double pkaVal = -9.924 * (this.getBondCharge3(atom) - Qsum[atom]) + 1.255 * (this.setAtomSphere(atom, 10, 1.0) / (double)this.getAtomCount()) + 6.908999999999999;
                if (subType == 1) {
                    pkaVal += -2.5;
                } else if (subType == 2) {
                    pkaVal += -1.0;
                }
                return pkaVal += this.addBetaCorr(atom);
            }
            case 25: {
                return -8.0 * Qsum[atom] + 5.39;
            }
            case 26: {
                return -18.2336 * Qsum[atom] + 3.03;
            }
        }
        return Double.NaN;
    }

    private boolean justNO2(int atom) {
        int c = 0;
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int nb = this.cHtab[atom][i];
            if (nb >= this.mol.getAtomCount() || this.pg.getCarboxy()[nb] == -1) continue;
            ++c;
        }
        return c <= 1;
    }

    private int isPOsResRing(int ri1, int ri2, int ch) {
        int ra;
        int i;
        this.getAtomDistances(ch, 6);
        int[][] aAtoms = this.pka.aAtoms;
        if (ri1 != -1 && ri1 < aAtoms.length) {
            for (i = 0; i < aAtoms[ri1].length; ++i) {
                ra = aAtoms[ri1][i];
                if (this.mol.getAtom(ra).getCharge() != 1 || !this.pka.isEvenDist()) continue;
                return this.pka.dist[ra];
            }
        }
        if (ri2 != -1 && ri2 < aAtoms.length) {
            for (i = 0; i < aAtoms[ri2].length; ++i) {
                ra = aAtoms[ri2][i];
                if (this.mol.getAtom(ra).getCharge() != 1 || !this.pka.isEvenDist()) continue;
                return this.pka.dist[ra];
            }
        }
        return -1;
    }

    private double addEsterCorr(int atom) {
        double sum = 0.0;
        int t = this.pkaAcidType[atom][0];
        int st = this.pkaAcidType[atom][7];
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int nb = this.cHtab[atom][i];
            if (nb >= this.mol.getAtomCount() || this.pg.getCarboxy()[nb] != 2) continue;
            if (this.getAtno(nb) == 8) {
                sum += 2.0;
                continue;
            }
            if (this.getAtno(nb) != 16) continue;
            if (t == 120 && (st == 1 || st == 2)) {
                if (this.pg.getGroupProperty()[nb] == 410 || this.pg.getGroupProperty()[nb] == 409) {
                    sum += 7.0;
                    continue;
                }
                sum += 5.0;
                continue;
            }
            if (t != 67 || st != 16) continue;
            sum += 7.0;
        }
        return sum;
    }

    private boolean isTripleKeto(int atom) {
        int ketoCount = 0;
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int nb = this.cHtab[atom][i];
            if (nb >= this.mol.getAtomCount() || this.pg.getCarboxy()[nb] != 1 && this.pg.getCarboxy()[nb] != 2 && this.pg.getCarboxy()[nb] != 200 && this.pg.getCarboxy()[nb] != 500) continue;
            ++ketoCount;
        }
        return ketoCount == 3;
    }

    private boolean isAraConnected(int atom) {
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            if (!this.isArA(this.cHtab[atom][i])) continue;
            return true;
        }
        return false;
    }

    private double addDelocCorr(int atom, int rIndex) {
        int[][] nonAring = this.pka.nonAring;
        int[] delocAble = this.pka.delocAble;
        int r = 0;
        int arCount = 0;
        if (rIndex == -1) {
            return 0.0;
        }
        for (int i = 0; i < nonAring[rIndex].length; ++i) {
            if (delocAble[nonAring[rIndex][i]] != 1) continue;
            ++r;
            if (!this.isArA(nonAring[rIndex][i])) continue;
            ++arCount;
        }
        if (r == nonAring[rIndex].length - 1) {
            if (arCount >= 2) {
                if (this.isTripleKeto(atom)) {
                    return 5.0;
                }
                if (this.isAraConnected(atom)) {
                    return 7.5;
                }
                return 1.0;
            }
            if (this.isAraConnected(atom)) {
                return 3.6;
            }
            if (this.isPiDeficientRing(rIndex, nonAring)) {
                return 3.4;
            }
            return -1.0;
        }
        if (this.isAraConnected(atom)) {
            return 4.0;
        }
        if (this.isTripleKeto(atom)) {
            return 4.5;
        }
        if (nonAring[rIndex].length < 6) {
            if (!this.isBothKetoInRing(atom)) {
                return 2.5 + this.isWitdrawedRing(rIndex, nonAring);
            }
            return this.isWitdrawedRing(rIndex, nonAring);
        }
        if (nonAring[rIndex].length >= 6) {
            if (!this.isBothKetoInRing(atom)) {
                return 1.0 + this.isWitdrawedRing(rIndex, nonAring);
            }
            return this.isWitdrawedRing(rIndex, nonAring);
        }
        return 0.0;
    }

    private boolean isPiDeficientRing(int rInd, int[][] nonAring) {
        int c = 0;
        for (int i = 0; i < nonAring[rInd].length; ++i) {
            int a = nonAring[rInd][i];
            if (this.getAtno(a) == 6 && this.pg.getCarboxy()[a] == -1) continue;
            ++c;
        }
        return c > 2;
    }

    private boolean isBothKetoInRing(int a) {
        int c = 0;
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int nb = this.cHtab[a][i];
            if (nb >= this.mol.getAtomCount() || !this.isInRing[nb] || this.pg.getCarboxy()[nb] != 1 && this.pg.getCarboxy()[nb] != 2 && this.pg.getCarboxy()[nb] != 200 && this.pg.getCarboxy()[nb] != 500) continue;
            ++c;
        }
        return c >= 2;
    }

    private double isWitdrawedRing(int rIndex, int[][] nonAring) {
        int polCount = 0;
        int chg = 0;
        boolean hetero = false;
        boolean piDrawer = false;
        for (int i = 0; i < nonAring[rIndex].length; ++i) {
            int ra = nonAring[rIndex][i];
            chg += this.mol.getAtom(ra).getCharge();
            if (this.pg.getCarboxy()[ra] != -1) {
                ++polCount;
                continue;
            }
            if (this.getAtno(ra) == 6) continue;
            if (!this.isSingleBonded(ra)) {
                piDrawer = true;
                continue;
            }
            hetero = true;
        }
        if (polCount >= 3) {
            return 3.4;
        }
        if (chg >= 1) {
            return 1.7;
        }
        if (hetero || piDrawer) {
            return 1.0;
        }
        return 0.0;
    }

    private double addaCHHaloCorr(int atom) {
        double sum = 0.0;
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int nb = this.cHtab[atom][i];
            if (nb >= this.mol.getAtomCount() || this.pg.getCarboxy()[nb] != 1400) continue;
            if (this.getAtno(nb) == 53) {
                sum += -3.72;
                continue;
            }
            if (this.getAtno(nb) == 35) {
                sum += -2.2;
                continue;
            }
            sum += -1.4;
        }
        return sum;
    }

    private int isNbCharged(int ai) {
        boolean minus = false;
        boolean plus = false;
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.mol.getAtomCount()) continue;
            if (this.mol.getAtom(nb).getCharge() < 0) {
                minus = true;
                continue;
            }
            if (this.mol.getAtom(nb).getCharge() <= 0) continue;
            plus = true;
        }
        if (minus) {
            return -1;
        }
        if (plus) {
            return 1;
        }
        return 0;
    }

    private double getBondCharge2_C(int atom) {
        double sum = this.pka.Qsum[atom];
        for (int j = 0; j < this.cHtab[atom].length; ++j) {
            MolAtom neighbour;
            int nb = this.cHtab[atom][j];
            if (nb >= this.mol.getAtomCount() || (neighbour = this.mol.getAtom(nb)).getAtno() != 6) continue;
            sum += (neighbour.getCharge() == -1 ? 0.5 : 1.0) * this.pka.Qsum[nb];
        }
        return sum;
    }

    private boolean isnbCarboxy(int atom) {
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int nb = this.cHtab[atom][i];
            if (nb >= this.mol.getAtomCount() || this.pg.getCarboxy()[nb] == -1 || !this.isDBonded(nb)) continue;
            return true;
        }
        return false;
    }

    private boolean isDBonded(int atomIndex) {
        for (int i = 0; i < this.mol.getAtom(atomIndex).getBondCount(); ++i) {
            if (this.mol.getAtom(atomIndex).getBond(i).getType() < 2) continue;
            return true;
        }
        return false;
    }

    private double getBondCharge23(int atom) {
        double sum = this.pka.Qsum[atom];
        for (int j = 0; j < this.cHtab[atom].length; ++j) {
            int nb = this.cHtab[atom][j];
            if (nb >= this.mol.getAtomCount()) continue;
            MolAtom a = this.mol.getAtom(nb);
            if (this.getAtno(nb) == 6) {
                sum += a.getCharge() == -1 ? 0.25 : this.pka.Qsum[nb];
                continue;
            }
            if (a.getCharge() != 1) continue;
            int pc = this.getAtno(nb);
            if (pc == 15 || pc == 33 || pc == 16 || pc == 8) {
                sum += this.pka.Qsum[nb];
                continue;
            }
            if (pc != 7) continue;
            if (this.isArA(nb)) {
                sum += this.pka.Qsum[nb];
                continue;
            }
            sum += this.pka.getBondCharge2(nb);
        }
        return sum;
    }

    private boolean isJustCarbon() {
        for (int i = 0; i < this.getSphereSize(); ++i) {
            if (this.getAtno(this.pka.sphere[i]) != 6) {
                return false;
            }
            if (!this.isArA(this.pka.sphere[i])) continue;
            return false;
        }
        return true;
    }

    private double getOHAcidicpKa(int atom) {
        int aAroma = this.pkaAcidType[atom][1];
        int bAroma = this.pkaAcidType[atom][2];
        int crossAtom = this.pkaAcidType[atom][3];
        int betaAtom = this.pkaAcidType[atom][4];
        int alphaAtom = this.pkaAcidType[atom][8];
        int subType = this.pkaAcidType[atom][7];
        int rIndex = this.pkaAcidType[atom][10];
        switch (this.pkaAcidType[atom][0]) {
            case 0: {
                double pka = -55.010000000000005 * this.getBondCharge(atom) + 162.36 * this.pka.charge.getPiCharge(atom) - 18.4691;
                if (subType == 10) {
                    this.setProtonationState();
                    pka += this.getTautomerIncrement(atom, aAroma);
                }
                pka += this.gethBond1Inc(atom, 0, pka);
                pka += this.getArOHArOHnc(atom);
                return pka += this.cyanoInc[atom];
            }
            case 1: {
                double incHN = 0.0;
                double bc = this.getBondCharge(atom);
                double pka = Double.NaN;
                if (subType == 10 || subType == 20 || subType == 30) {
                    incHN = this.getHBondInc(atom, bc);
                    if (incHN != 0.0) {
                        pka = -97.707 * bc - 9.2063 + incHN;
                    } else if (subType == 20) {
                        pka = -13.05 * (bc - this.pka.Qsum[atom]) + 4.73;
                        if (this.isChargedRing(rIndex)) {
                            pka += -0.6;
                        }
                    } else {
                        pka = subType == 30 ? -97.707 * bc - 9.2063 : -13.05 * (bc - this.pka.Qsum[atom]) + 4.73;
                    }
                } else {
                    pka = -97.707 * bc - 9.2063;
                }
                if (incHN == 0.0) {
                    pka += this.gethBond1Inc(atom, 1, pka);
                }
                return pka += this.cyanoInc[atom];
            }
            case 2: {
                return -97.707 * this.getBondCharge(atom) - 9.2063;
            }
            case 3: {
                double pkaVal = 0.89 * this.pka.Qsum[crossAtom] - 17.87 * this.pka.Qsum[atom];
                pkaVal += 1.94 * (this.setAtomSphere(atom, 10, 1.0) / (double)this.getAtomCount()) - 4.26;
                return pkaVal += this.add2ndIonizationInc(crossAtom, 3);
            }
            case 4: {
                return -17.87 * this.pka.Qsum[atom] + 1.94 * (this.setAtomSphere(atom, 10, 1.0) / (double)this.getAtomCount()) - 4.26;
            }
            case 5: {
                return -22.68 * this.pka.Qsum[atom] + 2.56 * (this.setAtomSphere(atom, 10, 1.0) / (double)this.getAtomCount()) - 8.3;
            }
            case 6: {
                double pkaVal = -16.54 * (this.getBondCharge3(atom) - this.pka.Qsum[atom]);
                pkaVal += 2.51 * (this.setAtomSphere(atom, 10, 1.0) / (double)this.getAtomCount()) + 9.87;
                return pkaVal += this.addHeteroCorr(bAroma) + this.cyanoInc[atom];
            }
            case 8: {
                double pkaVal = -54.3 * this.pka.Qsum[atom] + 3.06 * (this.setAtomSphere(atom, 10, 1.0) / (double)this.getAtomCount()) - 11.978 + this.getHeteroInc();
                pkaVal += this.addAmideCorrection(betaAtom) + this.cyanoInc[atom];
                pkaVal += this.addMalonCorrection(atom, pkaVal);
                pkaVal += this.addGammaCOOHCorrection(atom);
                return pkaVal += this.addExternalHBondCorr(atom);
            }
            case 9: {
                return -54.3 * this.pka.Qsum[atom] + 3.06 * (this.setAtomSphere(atom, 10, 1.0) / (double)this.getAtomCount()) - 16.44;
            }
            case 10: {
                boolean isCarbamoyl = this.pg.getCarboxy()[crossAtom] == 600;
                double pkaVal = isCarbamoyl ? -25.991 * this.pka.Qsum[crossAtom] + 1.2045 : -36.937 * this.pka.Qsum[crossAtom] + 2.633;
                double corr = 0.0;
                if (subType == 11) {
                    corr = 0.68 + -0.2287 * pkaVal + 1.34;
                } else if (subType == 1) {
                    if (this.mol.getAtom(betaAtom).getCharge() == -1) {
                        corr = -0.8;
                    }
                    corr += -2.494 * this.getMonoPhosphorEsterInc(atom) + 0.5193;
                    pkaVal += this.cyanoInc[atom];
                }
                return pkaVal + corr;
            }
            case 11: {
                return -17.87 * this.pka.Qsum[atom] + 1.94 * (this.setAtomSphere(atom, 10, 1.0) / (double)this.getAtomCount()) - 4.26;
            }
            case 12: {
                return -22.68 * this.pka.Qsum[atom] + 2.56 * (this.setAtomSphere(atom, 10, 1.0) / (double)this.getAtomCount()) - 7.53;
            }
            case 13: {
                double pkaVal = 0.0;
                if (subType == 4) {
                    pkaVal = -16.54 * (this.getBondCharge15(atom) - this.pka.Qsum[atom]);
                    pkaVal += 2.51 * (this.setAtomSphere(atom, 10, 1.0) / (double)this.getAtomCount()) + 9.87 - 3.0;
                } else {
                    pkaVal = subType == 3 ? (this.isInRing[alphaAtom] ? -16.54 * (this.getBondCharge15(atom) - this.pka.Qsum[atom]) + 2.51 * (this.setAtomSphere(atom, 10, 1.0) / (double)this.getAtomCount()) + 9.87 + 0.7 : -6.54 * (this.getBondCharge15(atom) - this.pka.Qsum[atom]) + 2.51 * (this.setAtomSphere(atom, 10, 1.0) / (double)this.getAtomCount()) + 9.87 - 3.0) : -16.54 * (this.getBondCharge15(atom) - this.pka.Qsum[atom]) + 2.51 * (this.setAtomSphere(atom, 10, 1.0) / (double)this.getAtomCount()) + 9.87;
                }
                if (subType == 1) {
                    pkaVal += -2.5;
                } else if (subType == 2) {
                    pkaVal += -0.3;
                }
                pkaVal += this.addBetaCorr(atom);
                return pkaVal += this.cyanoInc[atom];
            }
            case 7: 
            case 14: {
                double s = this.setAtomSphere(atom, 3, 0.75);
                double c = this.pka.Qsum[atom];
                if (this.getAtomCount() == 0) {
                    return Double.NaN;
                }
                if (c > -0.18 || c < -0.22) {
                    return -(13.964 * c * c) - 18.989 * c + 3.895 + this.addAlphaOHCorrection(this.pkaAcidType[atom][8]);
                }
                return -126.87 * c - 3.13 * (s / (double)this.getAtomCount()) - 16.88 + this.addAlphaOHCorrection(this.pkaAcidType[atom][8]);
            }
            case 15: {
                double pkaVal = -54.3 * this.pka.Qsum[atom] + 3.06 * (this.setAtomSphere(atom, 10, 1.0) / (double)this.getAtomCount()) - 11.978;
                pkaVal += this.addExternalHBondCorr(atom);
                pkaVal += this.addCTinc(atom);
                return pkaVal += this.cyanoInc[atom];
            }
            case 16: {
                return -56.993 * this.pka.Qsum[crossAtom] + 14.14 + this.add2ndIonizationInc(crossAtom, 16);
            }
            case 17: {
                return -36.825 * this.pka.Qsum[crossAtom] + 11.995 + this.add2ndIonizationInc(crossAtom, 17);
            }
            case 18: {
                return -111.5 * this.pka.Qsum[atom] - 24.0;
            }
            case 19: {
                return -111.5 * this.pka.Qsum[atom] - 24.0;
            }
            case 20: {
                return -1.4;
            }
            case 21: {
                return 3.32;
            }
            case 22: {
                double pkaVal;
                int nitrogen = this.pkaAcidType[atom][3];
                double s = this.getBondCharge2(nitrogen);
                double d = pkaVal = s < 0.057 ? -7.64 * s + 10.23 : 6.1428 * Math.pow(s, -0.1578);
                if (subType == 10) {
                    pkaVal += -2.0;
                }
                return pkaVal;
            }
            case 23: {
                int nitrogen = this.pkaAcidType[atom][3];
                double s = this.getBondCharge2(nitrogen);
                return -1.93 * s + 7.77 * (this.setAtomSphere(atom, 4, 0.75) / (double)this.getAtomCount()) + 5.3;
            }
            case 24: {
                double chg = this.getBondCharge2(betaAtom);
                double ac = 0.0;
                if (this.isInRing[betaAtom]) {
                    ac = this.getAvarageAliphaticRingCharge(this.pkaAcidType[atom][10]);
                }
                double pkaVal = subType == 15 ? -19.26 * ac + 2.51 * (this.setAtomSphere(atom, 10, 1.0) / (double)this.getAtomCount()) + 9.87 - 2.5 : (subType == 20 ? -19.26 * ac + 2.51 * (this.setAtomSphere(atom, 10, 1.0) / (double)this.getAtomCount()) + 9.87 - 4.5 : -19.26 * chg + 2.51 * (this.setAtomSphere(atom, 10, 1.0) / (double)this.getAtomCount()) + 9.87 - 2.3);
                if (subType == 10 && chg < 0.12) {
                    pkaVal += -2.5;
                }
                return pkaVal += this.cyanoInc[atom];
            }
            case 25: {
                if (this.mol.getAtom(atom).getCharge() != -1) {
                    return 15.7;
                }
                return Double.NaN;
            }
            case 26: {
                return -18.2336 * this.pka.Qsum[atom] + 3.03;
            }
            case 27: {
                return 9.77 * Math.pow(2.718282, -0.9434 * this.getBondCharge2(alphaAtom));
            }
            case 28: {
                return 12.15 - 16.94 * this.pka.Qsum[alphaAtom];
            }
            case 29: {
                return -22.68 * this.pka.Qsum[atom] + 2.56 * (this.setAtomSphere(atom, 10, 1.0) / (double)this.getAtomCount()) - 3.3;
            }
            case 30: {
                double pkaVal = -54.3 * this.pka.Qsum[atom] + 3.06 * (this.setAtomSphere(atom, 10, 1.0) / (double)this.getAtomCount()) - 11.978 - 3.0;
                pkaVal += this.addAmideCorrection(betaAtom);
                pkaVal += this.cyanoInc[atom];
                pkaVal += this.addMalonCorrection(atom, pkaVal);
                pkaVal += this.addGammaCOOHCorrection(atom);
                return pkaVal += this.addExternalHBondCorr(atom);
            }
            case 31: {
                double pkaVal = -54.3 * this.pka.Qsum[atom] + 3.06 * (this.setAtomSphere(atom, 10, 1.0) / (double)this.getAtomCount()) - 11.978 - 2.2;
                pkaVal += this.addAmideCorrection(betaAtom);
                pkaVal += this.cyanoInc[atom];
                pkaVal += this.addMalonCorrection(atom, pkaVal);
                pkaVal += this.addGammaCOOHCorrection(atom);
                return pkaVal += this.addExternalHBondCorr(atom);
            }
            case 32: 
            case 33: {
                double incHN = 0.0;
                double bc = this.getBondCharge(atom);
                double pkaVal = subType == 10 || subType == 20 || subType == 30 ? ((incHN = this.getHBondInc(atom, bc)) != 0.0 ? -97.707 * bc - 9.2063 + incHN : (subType == 20 ? -13.05 * (bc - this.pka.Qsum[atom]) + 4.73 : (subType == 30 ? -97.707 * bc - 9.2063 : -13.05 * (bc - this.pka.Qsum[atom]) + 4.73))) : -97.707 * bc + 3.7063;
                if (incHN == 0.0) {
                    pkaVal += this.gethBond1Inc(atom, 1, pkaVal);
                }
                return pkaVal += this.cyanoInc[atom];
            }
            case 34: {
                return -11.9;
            }
            case 35: {
                return -54.3 * this.pka.Qsum[atom] + 3.06 * (this.setAtomSphere(atom, 10, 1.0) / (double)this.getAtomCount()) - 10.4 + this.cyanoInc[atom];
            }
            case 36: {
                return 3.7928 * Math.exp(-5.6818 * this.pka.Qsum[crossAtom]);
            }
            case 37: {
                return -114.3 * this.pka.Qsum[atom] - 13.26 * this.getBondCharge2(aAroma) - 5.11;
            }
            case 38: {
                return -64.3 * this.pka.Qsum[atom] - 13.26 * this.getBondCharge2(aAroma) - 9.11;
            }
            case 39: {
                return 8.36 - 90.0 * this.pka.Qsum[alphaAtom];
            }
        }
        return Double.NaN;
    }

    private double addBetaOHCorrection(int alpha) {
        int k = 0;
        for (int i = 0; i < this.cHtab[alpha].length; ++i) {
            int nb = this.cHtab[alpha][i];
            if (nb >= this.mol.getAtomCount()) continue;
            if (this.pka.acidAtomType[nb] == 1 && this.pkaAcidType[nb][0] == -2 && this.pg.getCarboxy()[nb] == 900) {
                ++k;
                continue;
            }
            if (this.pg.getCarboxy()[nb] != 1000 && this.pg.getCarboxy()[nb] != 1100) continue;
            ++k;
        }
        if (k > 2) {
            return 2.2 * (double)(k - 2);
        }
        return 0.0;
    }

    private double getBondCharge18(int atom) {
        double sum = this.pka.Qsum[atom];
        for (int j = 0; j < this.cHtab[atom].length; ++j) {
            int nb = this.cHtab[atom][j];
            int atno = this.getAtno(nb);
            if (atno != 6 && atno != 14 && atno != 32 && atno != 50) continue;
            sum += this.mol.getAtom(nb).getCharge() == -1 ? 0.25 : this.pka.Qsum[nb];
        }
        return sum;
    }

    private double addROHHeteroInc(int alpha) {
        if (this.pg.getCarboxy()[alpha] == 1400) {
            return -3.6;
        }
        double k = 0.0;
        for (int i = 0; i < this.cHtab[alpha].length; ++i) {
            int nb = this.cHtab[alpha][i];
            if (nb >= this.mol.getAtomCount()) continue;
            if (this.pka.acidAtomType[nb] == 1 && this.pkaAcidType[nb][0] == -2 && this.pg.getCarboxy()[nb] == 900) {
                k += 1.25;
                continue;
            }
            if (this.pg.getCarboxy()[nb] != 1000 && this.pg.getCarboxy()[nb] != 1100) continue;
            k += 0.85;
        }
        if (k > 2.0) {
            if (this.getAtno(alpha) == 32 || this.getAtno(alpha) == 50) {
                return 2.6 * (k - 1.0);
            }
            return 2.2 * (k - 2.0);
        }
        return 0.0;
    }

    private double gethBond1Inc(int atom, int acidType, double pkaVal) {
        double sum = 0.0;
        double prevSum = 0.0;
        if (this.pka.HBT != null) {
            int azaAtom;
            for (int i = 0; i < 2; ++i) {
                int hbType = this.pka.HBT[this.pka.hbtAIndex[atom]][i + 2];
                if (hbType == 2) {
                    if (acidType == 1) {
                        sum += -0.126;
                        continue;
                    }
                    if (acidType != 0) continue;
                    prevSum = sum;
                    if (this.mol.getAtom(this.pka.HBT[this.pka.hbtAIndex[atom]][i]).getCharge() == -1) {
                        double ch = this.getBondCharge(this.pka.HBT[this.pka.hbtAIndex[atom]][i]) - this.getBondCharge(atom);
                        sum = 35.086 * ch + 11.007;
                    } else {
                        sum = 2.0;
                    }
                    if (!(prevSum > sum)) continue;
                    sum = prevSum;
                    continue;
                }
                if (hbType != 3) continue;
                if (this.mol.getAtom(this.pka.HBT[this.pka.hbtAIndex[atom]][i]).getCharge() == -1) {
                    sum += 1.2;
                    continue;
                }
                sum += 0.5;
            }
            if (acidType != 0) {
                return sum;
            }
            int OH2 = this.pka.HBT[this.pka.hbtAIndex[atom]][1];
            if (OH2 != -1) {
                sum = this.mol.getAtom(OH2).getCharge() == -1 ? 1.75 : 0.8;
            }
            if (this.pka.HBT[this.pka.hbtAIndex[atom]][10] != -1) {
                double charge = 100.0 * this.pka.Qsum[atom] + this.getBondCharge6(this.pkaAcidType[atom][1]);
                sum = charge > -2.3 ? 0.0 : (charge > -9.1 ? -0.9474 * charge - 2.38 : 3.5);
            } else if (this.pka.HBT[this.pka.hbtAIndex[atom]][9] != -1 && this.mol.getAtom(this.aza[azaAtom = this.pka.HBT[this.pka.hbtAIndex[atom]][9]]).getCharge() != 1 && pkaVal > 6.0) {
                sum = 4.3;
            }
        }
        return sum;
    }

    private double getArOHArOHnc(int OH1) {
        if (this.pka.mpk0 == null || this.pka.HBT == null) {
            return 0.0;
        }
        int OH2 = this.pka.HBT[this.pka.hbtAIndex[OH1]][26];
        if (OH2 == -1) {
            return 0.0;
        }
        if (this.pka.mpk0[OH1] > this.pka.mpk0[OH2]) {
            return 1.8;
        }
        return -1.8;
    }

    private double getHBondInc(int atom, double bcharge) {
        int hbt;
        int n = hbt = this.pka.HBT == null ? -1 : this.pka.HBT[this.pka.hbtAIndex[atom]][11];
        if (hbt == -1) {
            return 0.0;
        }
        if (this.mol.getAtom(hbt).getCharge() == 1) {
            return 49.64 * bcharge + 8.02;
        }
        return 60.77 * bcharge + 9.18;
    }

    private boolean isChargedRing(int ri) {
        for (int i = 0; i < this.pka.aAtoms[ri].length; ++i) {
            if (this.mol.getAtom(this.pka.aAtoms[ri][i]).getCharge() != 1) continue;
            return true;
        }
        return false;
    }

    private double add2ndIonizationInc(int crossAtom, int type) {
        for (int i = 0; i < this.cHtab[crossAtom].length; ++i) {
            int nb = this.cHtab[crossAtom][i];
            if (nb >= this.mol.getAtomCount() || this.mol.getAtom(nb).getCharge() != -1) continue;
            switch (type) {
                case 3: {
                    return 1.5;
                }
                case 16: {
                    return -2.2;
                }
                case 17: {
                    return -2.2;
                }
            }
        }
        return 0.3;
    }

    private double addHeteroCorr(int bAroma) {
        int sum = 0;
        for (int i = 0; i < this.cHtab[bAroma].length; ++i) {
            int nb = this.cHtab[bAroma][i];
            if (nb >= this.mol.getAtomCount()) continue;
            int bt = this.pka.pkaBasicType[nb][0];
            boolean valid = bt == 500 || bt == 600 || bt == 200;
            if (!(valid &= this.mol.getAtom(nb).getCharge() == 1 || this.pka.mpk0 != null && this.pka.mpk0[nb] < 0.0)) continue;
            sum = (int)((double)sum + 2.0);
        }
        return sum;
    }

    private double addAmideCorrection(int betaAtom) {
        if (betaAtom == -1) {
            return 0.0;
        }
        for (int i = 0; i < this.cHtab[betaAtom].length; ++i) {
            int nb = this.cHtab[betaAtom][i];
            if (nb >= this.mol.getAtomCount() || this.pg.getCarboxy()[nb] != 200) continue;
            return -0.2;
        }
        return 0.0;
    }

    private double getRingResInc(int atom) {
        int[][] RRPairs = this.pka.charge.RRPairs;
        if (RRPairs != null) {
            for (int i = 0; i < RRPairs.length; ++i) {
                if (RRPairs[i][0] != atom && RRPairs[i][3] != atom) continue;
                return 2.2;
            }
        }
        return 0.0;
    }

    private double addMalonCorrection(int atom, double mpk) {
        int betaAtom = this.pkaAcidType[atom][4];
        if (betaAtom == -1) {
            return 0.0;
        }
        double sum = 0.0;
        for (int i = 0; i < this.cHtab[betaAtom].length; ++i) {
            int gii;
            int nb = this.cHtab[betaAtom][i];
            if (nb >= this.mol.getAtomCount() || (gii = this.pg.getGroupIndex()[nb]) == this.pg.getGroupIndex()[atom] || gii == -1) continue;
            for (int j = 0; j < this.pg.getGroups()[gii].length; ++j) {
                int ga = this.pg.getGroups()[gii][j];
                if (this.pkaAcidType[ga][5] != 1 || this.pkaAcidType[ga][0] != 8) continue;
                sum = this.mol.getAtom(ga).getCharge() == -1 ? 0.3158 * Math.pow(2.718282, 0.4425 * mpk) : -0.0103 * Math.pow(mpk, 3.4332);
            }
        }
        if (!Double.isNaN(sum)) {
            return sum;
        }
        return 0.0;
    }

    private double addGammaCOOHCorrection(int atom) {
        if (this.pka.mpk0 == null) {
            return 0.0;
        }
        int gi = this.pg.getGroupIndex()[atom];
        int betaAtom1 = this.pkaAcidType[atom][4];
        boolean lt = false;
        boolean gt = false;
        boolean inr = false;
        for (int i = 0; i < this.pg.getGroups().length; ++i) {
            if (i == gi) continue;
            for (int j = 0; j < this.pg.getGroups()[i].length; ++j) {
                int ga = this.pg.getGroups()[i][j];
                int betaAtom2 = this.pkaAcidType[ga][4];
                if (this.pkaAcidType[ga][5] != 1 || this.pkaAcidType[ga][0] != 8 || !this.isNbAtom(betaAtom1, betaAtom2)) continue;
                double chg2 = this.mol.getAtom(ga).getCharge();
                if (chg2 == -1.0) {
                    return 1.3;
                }
                double d = this.pka.mpk0[atom] - this.pka.mpk0[ga];
                if (Math.abs(d) < 0.001) {
                    return 0.0;
                }
                if (d < 0.0) {
                    if (this.isInRing[betaAtom1] && this.isInRing[betaAtom2]) {
                        inr = true;
                    }
                    lt = true;
                    continue;
                }
                gt = true;
            }
        }
        if (lt && gt) {
            return 0.65;
        }
        if (lt && inr) {
            return 0.45;
        }
        if (gt) {
            return 1.3;
        }
        return 0.0;
    }

    private boolean isNbAtom(int a1, int a2) {
        return this.mol.getAtom(a1).isBoundTo(this.mol.getAtom(a2));
    }

    private double addExternalHBondCorr(int atom) {
        if (this.pka.modelType == this.pka.large || this.pka.getAliAminCount() == 0.0) {
            return 0.0;
        }
        int beta = this.pkaAcidType[atom][4];
        if (beta == -1) {
            return 0.0;
        }
        for (int i = 0; i < this.cHtab[beta].length; ++i) {
            int type;
            int nb = this.cHtab[beta][i];
            int n = type = nb < this.mol.getAtomCount() ? this.pka.pkaBasicType[nb][0] : -1;
            if (type != 1000 && type != 3) continue;
            return 0.0;
        }
        if (this.pka.getAliAminCount() >= 3.0) {
            return -0.4;
        }
        return -0.13 * Math.log(this.pka.getAliAminCount()) - 0.3;
    }

    private double getMonoPhosphorEsterInc(int OH) {
        int gInd = this.pg.getGroupIndex()[OH];
        double sum = 0.0;
        for (int i = 0; i < this.pg.getGroups()[gInd].length; ++i) {
            int a = this.pg.getGroups()[gInd][i];
            if (this.cHtab[a].length != 2) continue;
            for (int j = 0; j < this.cHtab[a].length; ++j) {
                int nb = this.cHtab[a][j];
                if (nb >= this.mol.getAtomCount() || this.isArA(nb) || this.pg.getGroupIndex()[nb] != -1) continue;
                sum += this.getAccumulatedBondCharge2(nb);
            }
        }
        return sum;
    }

    private double addAlphaOHCorrection(int alpha) {
        int[] carboxy = this.pg.getCarboxy();
        if (carboxy[alpha] == 900 || carboxy[alpha] == 1000) {
            return 4.0;
        }
        if (carboxy[alpha] == 1400) {
            return -3.5;
        }
        return 0.0;
    }

    private double addCTinc(int atom) {
        int b;
        int n = b = this.pka.HBT == null ? -1 : this.pka.HBT[this.pka.hbtAIndex[atom]][25];
        if (b == -1 || b >= this.mol.getAtomCount()) {
            return 0.0;
        }
        if (this.mol.getAtom(b).getCharge() == -1) {
            return 1.5;
        }
        double d = this.pka.mpk0[atom] - this.pka.mpk0[b];
        if (Math.abs(d) < 0.001) {
            return -0.5;
        }
        if (d < 0.0) {
            return -1.5;
        }
        return 1.5;
    }

    private double getAvarageAliphaticRingCharge(int rind) {
        double sum = 0.0;
        int L = this.pka.nonAring[rind].length;
        for (int i = 0; i < L; ++i) {
            int ra = this.pka.nonAring[rind][i];
            sum += this.getAtno(ra) == 6 ? this.pka.Qsum[ra] : 0.35 * this.pka.Qsum[ra];
        }
        return sum / (double)L;
    }

    private double getHeteroIncrement(int atom) {
        double hInc = 0.0;
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int nb = this.cHtab[atom][i];
            int atno = this.getAtno(this.cHtab[atom][i]);
            if (atno == 6 || atno == 1) continue;
            hInc += this.pka.Qsum[nb];
        }
        return hInc;
    }

    private double getAlphaHBond(int atom) {
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int nb = this.cHtab[atom][i];
            if (this.getAtno(nb) != 7 || !(this.isArA(nb) & this.pka.Qsum[atom] < 0.0)) continue;
            return 2.2;
        }
        return 0.0;
    }

    private double addBetaPyrNInc(int nh) {
        int a;
        if (this.pka.HBT != null && (a = this.pka.HBT[this.pka.hbtAIndex[nh]][10]) != -1 && this.mol.getAtom(a).getCharge() == 1) {
            return 2.4;
        }
        return 0.0;
    }

    private double getHeteroCorrection(int aAroma, int atom, int aType) {
        int nCount = 0;
        int oCount = 0;
        int nhCount = 0;
        int nnCount = 0;
        int sCount = 0;
        for (int i = 0; i < 3; ++i) {
            int n = this.cHtab[aAroma][i];
            if (n == atom) continue;
            if (this.getAtno(n) == 7) {
                if (this.cHtab[n].length == 3 && this.mol.getAtom(n).getCharge() != 1) {
                    ++nhCount;
                    continue;
                }
                if (this.cHtab[n].length == 2 && this.mol.getAtom(n).getCharge() == -1) {
                    ++nnCount;
                    continue;
                }
                ++nCount;
                continue;
            }
            if (this.getAtno(n) == 8) {
                ++oCount;
                continue;
            }
            if (this.getAtno(n) != 16) continue;
            ++sCount;
        }
        if (aType == 4 || aType == 3) {
            return (double)Math.abs(nCount - nhCount) * 1.6;
        }
        if (aType == 12) {
            double x = (double)nnCount * -3.5;
            if (oCount != 0) {
                return x + (double)Math.abs(nCount + oCount) * 1.2;
            }
            if (nCount == 0 && nhCount != 0) {
                return x;
            }
            return x + (double)Math.abs(nCount - nhCount) * 1.6;
        }
        if (aType == 11) {
            return (double)Math.abs(nCount - nhCount + oCount + sCount) * 1.0;
        }
        if (aType == 6) {
            double c = Math.abs(2 * nCount - nhCount + 2 * oCount + 2 * sCount);
            if (nCount == 1 || oCount == 1 || sCount == 1) {
                c += 1.2;
            } else if (nCount > 1 || oCount > 1 || sCount > 1) {
                c += 0.5;
            }
            return c;
        }
        if (nCount + oCount == 2 || nhCount + oCount == 2) {
            return 1.5;
        }
        return 0.0;
    }

    private double getBondCharge14(int sulfur) {
        double sum = this.pka.Qsum[sulfur];
        for (int i = 0; i < this.cHtab[sulfur].length; ++i) {
            if (this.getAtno(this.cHtab[sulfur][i]) != 6) continue;
            sum += this.getBondCharge2(this.cHtab[sulfur][i]);
        }
        return sum;
    }

    private boolean isPidefficientRing(int ai) {
        if (ai == -1) {
            return false;
        }
        int c = 0;
        int ridx = this.findSmallestAraRing(ai);
        if (ridx == -1) {
            return false;
        }
        int[][] aAtoms = this.pka.aAtoms;
        for (int i = 0; i < aAtoms[ridx].length; ++i) {
            if (this.getAtno(aAtoms[ridx][i]) == 6) continue;
            ++c;
        }
        return c > 2;
    }

    private int isAzaPosRes(int a) {
        this.getAtomDistances(a, 4);
        int ri = this.findSmallestAraRing(a);
        if (ri != -1) {
            for (int i = 0; i < this.pka.aAtoms[ri].length; ++i) {
                int ra = this.pka.aAtoms[ri][i];
                if (this.mol.getAtom(ra).getCharge() != 1 || !this.isEvenDist()) continue;
                return this.pka.dist[ra];
            }
        }
        return -1;
    }

    private double addCarbamideCorrection(int ketoX) {
        if (this.pg.getGroupType(ketoX) == 10 || this.pg.getGroupType(ketoX) == 12) {
            return 2.0;
        }
        return 0.0;
    }

    private double addCarbamoylCorrection(int ketoX) {
        if (this.pg.getCarboxy()[ketoX] == 700) {
            return 2.5;
        }
        return 0.0;
    }

    private double getPiDefficientFactor(int ra) {
        int ri = this.findSmallestAraRing(ra);
        if (ri == -1 || this.pka.aAtoms[ri].length >= 6) {
            return 0.0;
        }
        int c = 0;
        for (int i = 0; i < this.pka.aAtoms[ri].length; ++i) {
            int a = this.pka.aAtoms[ri][i];
            if (this.getAtno(a) == 6) continue;
            ++c;
        }
        if (c == 3) {
            return -4.7;
        }
        if (c >= 4) {
            return -7.0;
        }
        return 0.0;
    }

    private double getBondCharge16(int atom) {
        double sum = this.pka.Qsum[atom];
        for (int j = 0; j < this.cHtab[atom].length; ++j) {
            int nb = this.cHtab[atom][j];
            if (this.getAtno(nb) != 6) continue;
            if (this.mol.getAtom(nb).getCharge() != -1) {
                sum += this.pka.Qsum[nb];
                continue;
            }
            if (this.pkaAcidType[nb][0] != -1) continue;
            sum += 0.25;
        }
        return sum;
    }

    private double getBondCharge20(int n) {
        double[] Qsum = this.pka.Qsum;
        double s = Qsum[n];
        for (int i = 0; i < this.cHtab[n].length; ++i) {
            int nb = this.cHtab[n][i];
            if (nb >= this.mol.getAtomCount() || !this.isArA(nb)) continue;
            s += Qsum[nb];
        }
        return s;
    }

    private double orthoNPlus(int ai) {
        int c = 0;
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.mol.getAtomCount() || this.mol.getAtom(nb).getCharge() != 1) continue;
            ++c;
        }
        return 7.1 * (double)c;
    }

    private double addAmideHaloCorr(int atom) {
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int nb = this.cHtab[atom][i];
            if (nb >= this.mol.getAtomCount()) continue;
            int t = this.pg.getCarboxy()[nb];
            if (t == 200 || t == 500 || t == 600 || t == 400) {
                return -4.6;
            }
            if (t != 1400) continue;
            return -5.0;
        }
        return 0.0;
    }

    private double getCONHCharge(int ketoAtom) {
        double[] Qsum = this.pka.Qsum;
        double sum = Qsum[ketoAtom];
        for (int j = 0; j < this.cHtab[ketoAtom].length; ++j) {
            int nb = this.cHtab[ketoAtom][j];
            if (this.getAtno(nb) == 1) continue;
            int c = this.mol.getAtom(nb).getCharge();
            if (c == -1) {
                sum += 0.25 * Qsum[nb];
                continue;
            }
            if (c == 0) {
                sum += Qsum[nb];
                continue;
            }
            if (this.getAtno(nb) == 8) continue;
            sum += 0.5 * Qsum[nb];
        }
        return sum;
    }

    private boolean isOrthoHetero(int b) {
        for (int i = 0; i < this.cHtab[b].length; ++i) {
            int nb = this.cHtab[b][i];
            if (!this.isArA(nb) || this.getAtno(nb) == 6) continue;
            return true;
        }
        return false;
    }

    private double getBondCharge19(int atom, int type) {
        double[] Qsum = this.pka.Qsum;
        double sum = Qsum[atom];
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int nb = this.cHtab[atom][i];
            if (nb >= this.mol.getAtomCount()) continue;
            if (this.getAtno(nb) == 6) {
                sum += this.getBondCharge2(nb);
                continue;
            }
            if (this.pg.getCarboxy()[nb] == -1 || !(Qsum[nb] > 0.0)) continue;
            sum += 2.0 * Qsum[nb];
        }
        return sum;
    }

    private double addSideCorr(int rInd, int atom, int type) {
        if (rInd == -1) {
            return 0.0;
        }
        double sum = 0.0;
        for (int i = 0; i < this.pka.nonAring[rInd].length; ++i) {
            int ra = this.pka.nonAring[rInd][i];
            for (int j = 0; j < this.cHtab[ra].length; ++j) {
                int nb = this.cHtab[ra][j];
                if (nb >= this.mol.getAtomCount() || this.pg.getGroupIndex()[nb] == this.pg.getGroupIndex()[atom]) continue;
                if (this.pg.getCarboxy()[nb] != -1) {
                    if (this.pg.getCarboxy()[nb] == 100) {
                        sum += -2.0;
                        continue;
                    }
                    if (this.pg.getCarboxy()[nb] == 400) {
                        sum += -3.5;
                        continue;
                    }
                    if (this.pg.getCarboxy()[nb] == 200) {
                        sum += -0.5;
                        continue;
                    }
                    if (this.pg.getCarboxy()[nb] == 1400 && type == 26) {
                        sum += -1.0;
                        continue;
                    }
                    if (this.pg.getCarboxy()[nb] != 1400 && this.pg.getCarboxy()[nb] != 2 && this.pg.getCarboxy()[nb] != 1) continue;
                    sum += -0.3;
                    continue;
                }
                if (this.getAtno(nb) != 6 || this.cHtab[nb].length != 4) continue;
                double r = this.getBondCharge2(nb);
                if (this.getAtno(ra) == 6) {
                    r -= this.pka.Qsum[ra];
                }
                if (r < 0.0) {
                    sum += 0.3;
                    continue;
                }
                if (!(r > 0.0) || type != 26) continue;
                sum -= 5.35 * this.pka.Qsum[nb] - 0.07;
            }
        }
        return sum;
    }

    private double getSorOCarbamoyl(int k1, int k2) {
        if (this.pg.getCarboxy()[k1] != 600) {
            k1 = k2;
        }
        if (this.pg.getCarboxy()[k1] == 600) {
            for (int i = 0; i < this.cHtab[k1].length; ++i) {
                int atno = this.getAtno(this.cHtab[k1][i]);
                if (atno == 16) {
                    return -1.7;
                }
                if (atno != 8) continue;
                return -0.7;
            }
        }
        return 0.0;
    }

    private double addKetoKetoCorr(int keto1, int keto2) {
        return this.countKeto(keto1) + this.countKeto(keto2);
    }

    private int countKeto(int keto) {
        int c = 0;
        for (int i = 0; i < this.cHtab[keto].length; ++i) {
            int nb = this.cHtab[keto][i];
            if (nb >= this.mol.getAtomCount()) continue;
            int t = this.pg.getCarboxy()[nb];
            if (t == 100) {
                c = (int)((double)c + -3.5);
                continue;
            }
            if (t == 400) {
                c -= 4;
                continue;
            }
            if (t == 1200 || t == 1) {
                c = (int)((double)c + -3.3);
                continue;
            }
            if (t == 2) {
                c = (int)((double)c + -2.2);
                continue;
            }
            if (t != 800) continue;
            c = (int)((double)c + -2.5);
        }
        return c;
    }

    private boolean isAnilineAzaN(int a) {
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int nb = this.cHtab[a][i];
            if (this.getAtno(nb) != 7 || !this.pka.isAraNBexist(nb)) continue;
            return true;
        }
        return false;
    }

    private double getNbBondCharge2(int a) {
        double[] Qsum = this.pka.Qsum;
        double sum = this.getBondCharge2(a) - Qsum[a];
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int nb = this.cHtab[a][i];
            if (nb >= this.mol.getAtomCount()) continue;
            sum += this.getBondCharge2(nb) - Qsum[nb];
        }
        return sum;
    }

    private double addHeteroKetoCorrection(int ketoCarbon) {
        return this.getAtno(ketoCarbon) == 15 ? -3.0 : 0.0;
    }

    private void getDelIsland(int atomIndex, int deep) {
        this.pka.getDelIsland(atomIndex, deep);
    }

    private double getBondCharge8(int atom, int type) {
        return this.pka.getBondCharge8(atom, type);
    }

    private double getBondCharge2(int atom) {
        return this.pka.getBondCharge2(atom);
    }

    private double getDL(int atom) {
        return this.pka.getDL(atom);
    }

    private double getBondCharge22(int atomIndex) {
        return this.pka.getBondCharge22(atomIndex);
    }

    private int getAtno(int index) {
        return this.pka.getAtno(index);
    }

    private double setAtomSphere(int atom, int shellCount, double dFact) {
        return this.pka.setAtomSphere(atom, shellCount, dFact);
    }

    private int getAtomCount() {
        return this.pka.atomCount;
    }

    private double getApol_C() {
        return this.pka.apol_C;
    }

    private double getHeteroInc() {
        return this.pka.heteroInc;
    }

    private double getAccumulatedBondCharge2(int alpha) {
        return this.pka.getAccumulatedBondCharge2(alpha);
    }

    private void setProtonationState() {
        this.pka.setProtonationState();
    }

    private double getBondCharge(int atom) {
        return this.pka.getBondCharge(atom);
    }

    private double getTautomerIncrement(int atom, int aAroma) {
        return this.pka.getTautomerIncrement(atom, aAroma);
    }

    private double getBondCharge6(int atom) {
        return this.pka.getBondCharge6(atom);
    }

    private double getBondCharge3(int atom) {
        return this.pka.getBondCharge3(atom);
    }

    private double getBondCharge15(int atom) {
        return this.pka.getBondCharge15(atom);
    }

    private double addBetaCorr(int atom) {
        return this.pka.addBetaCorr(atom);
    }

    private boolean isArA(int atom) {
        if (atom < 0 || atom >= this.mol.getAtomCount()) {
            return false;
        }
        return this.mol.getAtom(atom).hasAromaticBond();
    }

    private boolean isEvenDist() {
        return this.pka.isEvenDist();
    }

    private int findSmallestAraRing(int a) {
        return this.pka.charge.getRings().findSmallestAraRing(a);
    }

    private void getAtomDistances(int a, int maxsphere) {
        this.pka.getAtomDistances(a, maxsphere);
    }

    private int[] getnVinilInfo(int atom) {
        return this.pka.getnVinilInfo(atom);
    }

    private int getHAraCount() {
        return this.pka.hAraCount;
    }

    private double getBondCharge2_0(int atom) {
        return this.pka.getBondCharge2_0(atom);
    }

    private double getBondCharge12(int atom) {
        return this.pka.getBondCharge12(atom);
    }

    private void setSphereSize(int size) {
        this.pka.sphereSize = size;
    }

    private int getSphereSize() {
        return this.pka.sphereSize;
    }

    private double getAvarageAromaticRingCharge(int index) {
        return this.pka.getAvarageAromaticRingCharge(index);
    }

    private boolean isSingleBonded(int atomIndex) {
        if (atomIndex < 0 || atomIndex >= this.mol.getAtomCount()) {
            return false;
        }
        MolAtom atom = this.mol.getAtom(atomIndex);
        for (int i = 0; i < atom.getBondCount(); ++i) {
            if (atom.getBond(i).getType() == 1) continue;
            return false;
        }
        return true;
    }
}

