/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.pka;

import chemaxon.calculations.AtomPolarizability;
import chemaxon.calculations.Charge;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class AtomPolarizabilityPKa
extends AtomPolarizability {
    protected static final double[] APOL = new double[]{0.314, 1.294, 1.428, 1.8, 1.393, 1.435, 1.262, 1.22, 1.304, 1.29, 1.216, 1.099, 1.046, 1.42, 3.077, 4.82, 3.0, 2.496, 2.982, 2.967, 1.8, 4.0, 3.5, 1.046};

    protected AtomPolarizabilityPKa(Molecule molecule) {
        super(molecule);
    }

    public AtomPolarizabilityPKa(Charge charge) {
        super(charge.getMolecule());
        this.standardizedMolecule = charge.getMolecule();
        this.charge = charge;
        this.isMolStandardized = true;
    }

    @Override
    protected double[] getDefaultPolarizability(int protonCount) {
        double[] result;
        result = new double[]{0.5 * (0.1493 * (double)protonCount + 0.713), protonCount, 4.0 * result[0] * result[0] / (double)protonCount};
        return result;
    }

    @Override
    protected double[] getSulfurPolarizability(int atomIndex, Charge charge, int protonCount, boolean polCharge) {
        MolAtom atom = this.standardizedMolecule.getAtom(atomIndex);
        double[] res = new double[]{0.0, protonCount, 0.0};
        int valence = this.getBondCount(atom);
        switch (valence) {
            case 2: {
                if (atom.hasAromaticBond()) {
                    res[0] = (1.0 + 5.0 * (-0.231 - charge.getTotalCharge(atomIndex))) * APOL[18];
                    res[2] = 4.0 * res[0] * res[0] / (double)protonCount;
                    break;
                }
                res[0] = (1.0 + 1.0 * (-0.1968 - charge.getTotalCharge(atomIndex))) * APOL[17];
                res[2] = 4.0 * res[0] * res[0] / (double)protonCount;
                break;
            }
            case 1: {
                res[0] = APOL[19];
                res[2] = 4.0 * res[0] * res[0] / (double)protonCount;
                break;
            }
            default: {
                res = this.getDefaultPolarizability(protonCount);
            }
        }
        return res;
    }

    @Override
    protected double[] getNitrogenPolarizability(int atomIndex, Charge charge, int carboxyType) {
        int protonCount = 7;
        MolAtom atom = this.standardizedMolecule.getAtom(atomIndex);
        double[] res = new double[]{0.0, protonCount, 0.0};
        int valence = this.getBondCount(atom);
        switch (valence) {
            case 4: {
                res[0] = 0.2;
                res[2] = 4.0 * res[0] * res[0] / (double)protonCount;
                return res;
            }
            case 3: {
                int ind = 0;
                ind = atom.hasAromaticBond() ? 7 : (carboxyType == 1300 || carboxyType == 100 ? 12 : 5);
                res[0] = APOL[ind];
                res[2] = 4.0 * res[0] * res[0] / (double)protonCount;
                return res;
            }
            case 2: {
                res[0] = APOL[6];
                res[2] = 4.0 * res[0] * res[0] / (double)protonCount;
                return res;
            }
            case 1: {
                res[0] = APOL[8];
                res[2] = 4.0 * res[0] * res[0] / (double)protonCount;
                return res;
            }
        }
        res[0] = APOL[5];
        res[2] = 4.0 * res[0] * res[0] / (double)protonCount;
        return res;
    }

    @Override
    protected double[] getOxigenPolarizability(int atomIndex, Charge charge) {
        int protonCount = 8;
        MolAtom atom = this.standardizedMolecule.getAtom(atomIndex);
        double[] res = new double[]{0.0, protonCount, 0.0};
        int valence = this.getBondCount(atom);
        switch (valence) {
            case 2: {
                res[0] = APOL[atom.hasAromaticBond() ? 11 : 9];
                res[2] = 4.0 * res[0] * res[0] / (double)protonCount;
                return res;
            }
            case 1: {
                res[0] = APOL[atom.getCharge() == -1 ? 20 : 10];
                res[2] = 4.0 * res[0] * res[0] / (double)protonCount;
                return res;
            }
        }
        return this.getDefaultPolarizability(protonCount);
    }

    @Override
    protected double[] getPhosphinePolarizability() {
        double[] result = new double[]{APOL[16], 15.0, 2.4};
        return result;
    }

    @Override
    protected double[] getIodinePolarizability(int atomIndex, boolean polCharge, Charge charge) {
        double[] res;
        res = new double[]{(1.0 + 3.0 * (-0.09 - charge.getTotalCharge(atomIndex))) * APOL[15], 53.0, 4.0 * res[0] * res[0] / 53.0};
        return res;
    }

    @Override
    protected double[] getBrominePolarizability(int atomIndex, boolean polCharge, Charge charge) {
        double[] res;
        res = new double[]{(1.0 + 3.0 * (-0.0964 - charge.getTotalCharge(atomIndex))) * APOL[14], 35.0, 4.0 * res[0] * res[0] / 35.0};
        return res;
    }

    @Override
    protected double[] getChlorPolarizability(int atomIndex, boolean polCharge, Charge charge) {
        double[] res;
        res = new double[]{(1.0 + 3.0 * (-0.1303 - charge.getTotalCharge(atomIndex))) * APOL[13], 17.0, 4.0 * res[0] * res[0] / 17.0};
        return res;
    }

    @Override
    protected double[] getFluorPolarizability(int atomIndex, boolean polCharge, Charge charge) {
        double[] res;
        res = new double[]{(1.0 + 3.0 * (-0.2545 - charge.getTotalCharge(atomIndex))) * APOL[12], 9.0, 4.0 * res[0] * res[0] / 9.0};
        return res;
    }

    @Override
    protected double[] getCarbonPolarizability(int atomIndex, Charge charge, boolean polCharge) {
        int protonCount = 6;
        MolAtom atom = this.standardizedMolecule.getAtom(atomIndex);
        double[] res = new double[]{0.0, protonCount, 0.0};
        int valence = this.getBondCount(atom);
        switch (valence) {
            case 4: {
                res[0] = APOL[1];
                res[2] = 6.697744 / (double)protonCount;
                return res;
            }
            case 3: {
                res[0] = atom.hasAromaticBond() ? (this.getAromaticNeighbourCount(atom) >= 3 ? APOL[3] : (1.0 + 3.0 * (-0.0622 - charge.getTotalCharge(atomIndex))) * APOL[2]) : APOL[2];
                res[2] = 4.0 * res[0] * res[0] / (double)protonCount;
                return res;
            }
            case 2: {
                res[0] = (1.0 + 3.0 * (-0.1234 - charge.getTotalCharge(atomIndex))) * APOL[4];
                res[2] = 4.0 * res[0] * res[0] / (double)protonCount;
                return res;
            }
        }
        return this.getDefaultPolarizability(protonCount);
    }

    @Override
    protected double[] getHydrogenPolarizability() {
        double[] res = new double[]{APOL[0], 1.0, 0.394384};
        return res;
    }

    @Override
    protected double[] getPolarizabilityParameter(int atomIndex) {
        return super.getPolarizabilityParameter(atomIndex);
    }
}

