/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.pka;

import chemaxon.calculations.Aza;
import chemaxon.calculations.Charge;
import chemaxon.calculations.PolarGroups;
import chemaxon.calculations.pka.AcidicPKa;
import chemaxon.calculations.pka.AtomPolarizabilityPKa;
import chemaxon.calculations.pka.BasicPKa;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

class IntrinsicIonization {
    private AcidicPKa acidicPKa;
    private BasicPKa basicPKa;
    protected int atomCount;
    public boolean deprotonation = false;
    public boolean protonation = false;
    protected int[] sphere;
    protected int[][] pkaAcidType = null;
    protected int[][] pkaBasicType = null;
    protected int[][] vinilPath = null;
    private int[][] nVinilInfo = null;
    protected int[] pkaActiveAtoms = null;
    protected int[] pkaAtomIndex = null;
    protected int[] aMultiplicity = null;
    protected double[] mpk0 = null;
    protected int[] pKaType = null;
    int[] nAtIndex = null;
    protected int[] hbtAIndex = null;
    private int[] hCount;
    private int macropKaCount;
    protected int pkaAtomCount;
    protected int[][] HBT = null;
    protected int[] dist = null;
    protected int sphereSize;
    private int acidicCarbon;
    private final int UNKNOWN = -1;
    private final int NOTDELOC = -2;
    public static final int OHACID = 1;
    public static final int NHACID = 2;
    public static final int SHACID = 3;
    public static final int CHACID = 4;
    public static final int HALOACID = 5;
    protected static final int SH_Chg_ACID = 6;
    final int large = 1;
    final int small = 0;
    int modelType;
    private int logPHBondCounter = 0;
    protected int[] acidAtomType = null;
    private boolean baseTypesAvailable = false;
    private final int cis = 1;
    private final int trans = 2;
    private int aliAminCount;
    private boolean vinilPathBreaked = false;
    protected boolean radicalBase;
    static final int H2O = 0;
    static final int DMSO = 1;
    boolean tautomerCalc = false;
    boolean setSingleAtomHBTable;
    int actHeteroCount;
    int actIndx;
    int actAtType;
    int actAraNb;
    int hAraCount;
    double heteroInc;
    double apol_C;
    private int[] aza;
    Charge charge;
    Molecule mol;
    double[] Qsum;
    int[][] cHtab;
    private MolAtom[] atomArray;
    private PolarGroups pg;
    int[][] aAtoms;
    int[] sAra;
    int[] delocAble;
    private int[][] bHtab;
    boolean[] isInRing;
    private int maxDelocLength;
    int[][] nonAring;
    private int[] hconj;
    private int[] sigmaAtomType;
    int aromatizationType = -1;
    public double[] cyanoInc;

    public IntrinsicIonization(Molecule m) {
        this(m, true);
    }

    IntrinsicIonization(Charge charge) {
        this.mol = charge.getMolecule();
        this.charge = charge;
        this.charge.setChargeCalcType(true);
        if (charge.getCriticalErrorFlag()) {
            return;
        }
        this.setDelegatedValues(charge);
        this.initValues();
    }

    public IntrinsicIonization(Molecule m, boolean calcCharges) {
        this.mol = m;
        if (!this.initCharge(this.mol, calcCharges)) {
            return;
        }
        this.initValues();
    }

    private void initValues() {
        int i;
        int i2;
        this.baseTypesAvailable = false;
        int an = this.mol.getAtomCount();
        this.pkaAcidType = new int[an][12];
        this.pkaBasicType = new int[an][12];
        this.pkaAtomIndex = new int[an];
        this.hCount = new int[an];
        for (int j = 0; j < an; ++j) {
            this.pkaAtomIndex[j] = -1;
            for (i2 = 0; i2 < 12; ++i2) {
                this.pkaAcidType[j][i2] = -1;
                this.pkaBasicType[j][i2] = -1;
            }
        }
        int vCount = 0;
        for (i2 = 0; i2 < an; ++i2) {
            MolAtom a = this.mol.getAtom(i2);
            if (a.getAtno() == 7) {
                ++vCount;
                continue;
            }
            if (a.getCharge() != -1 || a.getAtno() != 6) continue;
            ++vCount;
        }
        int j = 0;
        this.nAtIndex = new int[vCount];
        for (i = 0; i < an; ++i) {
            MolAtom a = this.mol.getAtom(i);
            if (a.getAtno() != 7) continue;
            this.nAtIndex[j] = i;
            ++j;
        }
        this.vinilPath = new int[vCount][12];
        for (i = 0; i < vCount; ++i) {
            for (j = 0; j < 12; ++j) {
                this.vinilPath[i][j] = -1;
            }
        }
        this.nVinilInfo = new int[vCount][6];
        for (i = 0; i < vCount; ++i) {
            for (int k = 0; k < 6; ++k) {
                this.nVinilInfo[i][k] = -1;
            }
        }
        this.cyanoInc = new double[this.mol.getAtomCount()];
    }

    private boolean initCharge(Molecule mol, boolean calcCharges) {
        this.charge = new Charge();
        this.charge.setChargeCalcType(true);
        this.charge.setMolecule(mol);
        this.charge.setAromatizationType(this.aromatizationType);
        if (!this.charge.getCriticalErrorFlag() && calcCharges) {
            this.charge.calcCharges();
        } else {
            this.charge.initChargeCalc();
        }
        this.setDelegatedValues(this.charge);
        return !this.charge.getCriticalErrorFlag();
    }

    private void setDelegatedValues(Charge charge) {
        this.cHtab = charge.cHtab;
        this.atomArray = charge.atomArray;
        this.aAtoms = charge.getRings().getAromaticRings();
        this.sAra = charge.getSemiAromaticAtomIndexes();
        this.delocAble = charge.delocAble;
        this.bHtab = this.mol.createBHtab();
        this.isInRing = charge.isInRing();
        this.maxDelocLength = charge.maxDelocLength;
        this.nonAring = charge.getRings().getNonAromaticRings();
        this.hconj = charge.hconj;
        this.sigmaAtomType = charge.getSigmaAtomType();
        this.pg = charge.getPolarGroups();
        this.Qsum = new double[this.mol.getAtomCount() + this.mol.getImplicitHcount()];
        for (int i = 0; i < this.Qsum.length; ++i) {
            this.Qsum[i] = charge.getTotalCharge(i);
        }
    }

    protected void setpKaModelType(int mt) {
        this.modelType = mt;
    }

    public double getAcidicpKa(int atom) {
        if (this.Qsum == null) {
            return Double.NaN;
        }
        return this.getApKa(atom);
    }

    public double getBasicpKa(int atom) {
        if (this.Qsum == null) {
            return Double.NaN;
        }
        return this.getBpKa(atom);
    }

    protected int getNind(int ai) {
        if (this.nAtIndex == null) {
            return -1;
        }
        for (int i = 0; i < this.nAtIndex.length; ++i) {
            if (this.nAtIndex[i] != ai) continue;
            return i;
        }
        return -1;
    }

    protected void storemicropk0(double[] microK, int[] aIndex) {
        int i;
        this.mpk0 = new double[this.mol.getAtomCount()];
        int k = 0;
        this.hbtAIndex = new int[this.mol.getAtomCount()];
        for (i = 0; i < aIndex.length; ++i) {
            this.mpk0[aIndex[i]] = microK[i];
            if (this.mpk0[aIndex[i]] == 0.0) continue;
            int n = aIndex[i];
            this.mpk0[n] = this.mpk0[n] + (double)i * 1.0E-7;
            this.hbtAIndex[aIndex[i]] = k++;
        }
        for (i = 0; i < this.mol.getAtomCount(); ++i) {
            if (this.getAza(i) == -1 || this.mpk0[i] != 0.0) continue;
            this.hbtAIndex[i] = k++;
        }
        if (k != 0) {
            this.HBT = new int[k][29];
            for (i = 0; i < k; ++i) {
                for (int j = 0; j < 29; ++j) {
                    this.HBT[i][j] = -1;
                }
            }
        }
    }

    public void storepk0(double[] microK) {
        for (int i = 0; i < this.mol.getAtomCount(); ++i) {
            this.mpk0[i] = microK[i];
            if (this.mpk0[i] == 0.0 && this.getAza(i) == -1) continue;
            int n = i;
            this.mpk0[n] = this.mpk0[n] + (double)i * 1.0E-7;
        }
    }

    public void initGeneralHBondTable(double[] microK) {
        int i;
        int k = 0;
        this.mpk0 = new double[this.mol.getAtomCount()];
        this.hbtAIndex = new int[this.mol.getAtomCount()];
        for (i = 0; i < this.mol.getAtomCount(); ++i) {
            if (microK[i] == 0.0 && this.getAza(i) == -1) continue;
            this.hbtAIndex[i] = k++;
        }
        if (k != 0) {
            this.HBT = new int[k][29];
            for (i = 0; i < k; ++i) {
                for (int j = 0; j < 29; ++j) {
                    this.HBT[i][j] = -1;
                }
            }
        }
    }

    protected double getBondCharge(int atom) {
        double sum = 0.0;
        sum = this.Qsum[atom];
        for (int j = 0; j < this.cHtab[atom].length; ++j) {
            int atno2 = this.getAtno(this.cHtab[atom][j]);
            if (atno2 == 1) continue;
            sum += this.Qsum[this.cHtab[atom][j]];
        }
        return sum;
    }

    private boolean isNitrogen(int aIndex) {
        return this.getNind(aIndex) != -1;
    }

    protected double getBondCharge2(int atom) {
        double sum = this.Qsum[atom];
        for (int j = 0; j < this.cHtab[atom].length; ++j) {
            MolAtom neighbour;
            int nb = this.cHtab[atom][j];
            if (nb >= this.mol.getAtomCount() || (neighbour = this.atomArray[nb]).getAtno() != 6) continue;
            sum += neighbour.getCharge() == -1 ? 0.25 : this.Qsum[nb];
        }
        return sum;
    }

    protected double getBondCharge3(int atom) {
        double sum = 0.0;
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int nb = this.cHtab[atom][i];
            for (int j = 0; j < this.cHtab[nb].length; ++j) {
                int nnb = this.cHtab[nb][j];
                if (nnb == atom || this.getAtno(nnb) != 6) continue;
                sum += this.Qsum[nnb];
            }
            if (this.cHtab[nb].length == 1) continue;
            sum += this.Qsum[nb];
        }
        return sum;
    }

    protected double getBondCharge6(int atom) {
        double sum = this.Qsum[atom];
        for (int j = 0; j < this.cHtab[atom].length; ++j) {
            if (!this.isArA(this.cHtab[atom][j])) continue;
            sum += this.Qsum[this.cHtab[atom][j]];
        }
        return sum;
    }

    protected boolean isArA(int i) {
        return this.charge.getRings().isAra(i);
    }

    protected double getBondCharge8(int atom, int type) {
        double sum = this.Qsum[atom];
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            boolean isSpecialType;
            int nb = this.cHtab[atom][i];
            boolean bl = isSpecialType = type > 66 && type < 72;
            if (nb >= this.mol.getAtomCount()) continue;
            int atno = this.getAtno(nb);
            if (this.pg.getCarboxy()[nb] == 2) {
                sum += 0.5 * this.Qsum[atom];
                continue;
            }
            if (atno == 6) {
                sum += isSpecialType ? this.getBondCharge17(nb) : this.getBondCharge2(nb);
                sum -= this.Qsum[atom];
                continue;
            }
            if (atno == 9) {
                sum += isSpecialType ? -0.3 * this.Qsum[nb] : 1.3 * this.Qsum[nb];
                continue;
            }
            if (atno == 17 || atno == 35 || atno == 53) {
                sum += isSpecialType ? -this.Qsum[nb] : 0.3 * this.Qsum[nb];
                continue;
            }
            if (this.pg.getCarboxy()[nb] == 100) continue;
            if (this.pkaBasicType[nb][0] != -1 && this.pkaAcidType[nb][0] < 0) {
                sum += this.atomArray[nb].getCharge() == 1 ? -0.25 : 0.5 * this.Qsum[nb];
                continue;
            }
            if (type == 67) continue;
            sum += this.atomArray[nb].getCharge() != -1 ? 0.75 * this.Qsum[nb] : 0.3 * this.Qsum[nb];
        }
        return sum;
    }

    protected double getBondCharge12(int atom) {
        double sum = this.Qsum[atom];
        for (int j = 0; j < this.cHtab[atom].length; ++j) {
            int nb = this.cHtab[atom][j];
            if (nb >= this.mol.getAtomCount()) continue;
            if (this.getAtno(nb) == 6) {
                sum += this.atomArray[nb].getCharge() == -1 ? 0.25 : this.Qsum[nb];
                continue;
            }
            if (this.getAtno(nb) == 16) {
                if (this.pg.getCarboxy()[nb] != 1000 && this.pg.getCarboxy()[nb] != 1100) continue;
                sum += this.Qsum[nb];
                continue;
            }
            if (this.atomArray[nb].getCharge() != -1) continue;
            sum += 0.25;
        }
        return sum;
    }

    protected double getBondCharge15(int atom) {
        double sum = 0.0;
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int nb = this.cHtab[atom][i];
            for (int j = 0; j < this.cHtab[nb].length; ++j) {
                int nnb = this.cHtab[nb][j];
                if (nnb == atom || this.getAtno(nnb) != 6) continue;
                sum += this.Qsum[nnb];
                if (this.pg.getCarboxy()[nnb] != 300 || this.atomArray[nnb].getCharge() != 0) continue;
                sum += -0.1;
            }
            if (this.cHtab[nb].length == 1) continue;
            sum += this.Qsum[nb];
        }
        return sum;
    }

    private double getBondCharge17(int atom) {
        double sum = this.Qsum[atom];
        for (int j = 0; j < this.cHtab[atom].length; ++j) {
            int nb = this.cHtab[atom][j];
            if (this.getAtno(nb) != 6) continue;
            if (this.atomArray[nb].getCharge() != -1) {
                sum += this.Qsum[nb];
                continue;
            }
            sum += this.Qsum[nb] / 5.0;
        }
        return sum;
    }

    protected double getBondCharge22(int ch) {
        double s = 0.0;
        for (int i = 0; i < this.cHtab[ch].length; ++i) {
            int nb = this.cHtab[ch][i];
            if (nb >= this.mol.getAtomCount() || !this.isArA(nb)) continue;
            s += this.getBondCharge2(nb) - this.Qsum[ch];
        }
        return s;
    }

    protected double getBondCharge23(int atom) {
        double sum = this.Qsum[atom];
        for (int j = 0; j < this.cHtab[atom].length; ++j) {
            int nb = this.cHtab[atom][j];
            if (nb >= this.mol.getAtomCount()) continue;
            if (this.getAtno(nb) == 6) {
                sum += this.atomArray[nb].getCharge() == -1 ? 0.25 : this.Qsum[nb];
                continue;
            }
            if (this.atomArray[nb].getCharge() != 1) continue;
            int pc = this.getAtno(nb);
            if (pc == 15 || pc == 33 || pc == 16 || pc == 8) {
                sum += this.Qsum[nb];
                continue;
            }
            if (pc != 7) continue;
            if (this.isArA(nb)) {
                sum += this.Qsum[nb];
                continue;
            }
            sum += this.getBondCharge2(nb);
        }
        return sum;
    }

    protected double getBondCharge2_0(int atom) {
        double sum = this.Qsum[atom];
        for (int j = 0; j < this.cHtab[atom].length; ++j) {
            int nb = this.cHtab[atom][j];
            if (this.getAtno(nb) != 6 || this.atomArray[nb].getCharge() == -1) continue;
            sum += this.Qsum[nb];
        }
        return sum;
    }

    protected double getNbEWDCount(int atom) {
        double c = 0.0;
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int nb = this.cHtab[atom][i];
            if (nb >= this.mol.getAtomCount()) continue;
            int t = this.pg.getCarboxy()[nb];
            if (t == 100 || t == 800 || t == 1 || t == 200 || t == 400) {
                c += 1.0;
                continue;
            }
            if (t != 14) continue;
            c += 0.5;
        }
        return c;
    }

    protected double getAvarageAromaticRingCharge(int rind) {
        double sum = 0.0;
        int L = this.aAtoms[rind].length;
        for (int i = 0; i < L; ++i) {
            int ra = this.aAtoms[rind][i];
            if (this.getAtno(ra) == 6) {
                sum += this.Qsum[ra];
                continue;
            }
            sum += 0.35 * this.Qsum[ra];
        }
        return sum / (double)L;
    }

    protected double getAccumulatedBondCharge2(int atom) {
        double sum = this.charge.getAccumulatedCharge(atom);
        for (int j = 0; j < this.cHtab[atom].length; ++j) {
            int nb = this.cHtab[atom][j];
            if (this.getAtno(nb) != 6) continue;
            if (this.atomArray[nb].getCharge() != -1) {
                sum += this.charge.getAccumulatedCharge(nb);
                continue;
            }
            sum += 0.25;
        }
        return sum;
    }

    private int getAcidAtom(int atom) {
        if (this.atomArray[atom].getRadical() != 0) {
            return 0;
        }
        double charge = this.atomArray[atom].getCharge();
        int acidAtom = 0;
        if (charge == 0.0) {
            int atno = -1;
            for (int i = 0; i < this.cHtab[atom].length; ++i) {
                if (this.getAtno(this.cHtab[atom][i]) != 1) continue;
                atno = this.getAtno(atom);
                break;
            }
            if (atno == 8) {
                acidAtom = 1;
            } else if (atno == 7) {
                if (this.cHtab[atom].length > 2 || this.pkaBasicType[atom][0] == 5 || this.pkaBasicType[atom][0] == 3) {
                    acidAtom = 2;
                }
            } else if (atno == 16) {
                acidAtom = 3;
            } else if (atno == 6) {
                acidAtom = 4;
            } else if (atno == 9 || atno == 17 || atno == 35 || atno == 53) {
                acidAtom = 5;
            }
        } else if (charge < 0.0) {
            if (this.getAtno(atom) == 16) {
                acidAtom = 6;
            } else if (this.getAtno(atom) == 6) {
                acidAtom = 7;
            }
        }
        return acidAtom;
    }

    protected double getTautomerIncrement(int atom, int alpha) {
        double tInc = 0.0;
        if (this.cHtab[alpha].length != 3) {
            return 0.0;
        }
        for (int i = 0; i < 3; ++i) {
            int nnb = this.cHtab[alpha][i];
            if (!this.isNitrogen(nnb)) continue;
            if (this.pkaAcidType[nnb][0] != 0 && this.pg.getCarboxy()[nnb] != 1200) {
                if (this.cHtab[nnb].length != 2 && this.atomArray[nnb].getCharge() != 1) continue;
                tInc += 4.0;
                continue;
            }
            if (this.atomArray[nnb].getCharge() != -1) continue;
            tInc += -2.0;
        }
        if (this.tautomerCalc && tInc >= 0.0) {
            int xCount = this.pkaAcidType[atom][9];
            return (double)(-xCount) * 0.65;
        }
        return tInc;
    }

    public void setTautomerCalcFlag(boolean tauCalc) {
        this.tautomerCalc = tauCalc;
    }

    public void setAcidTypes() {
        int i;
        this.acidAtomType = new int[this.mol.getAtomCount()];
        for (i = 0; i < this.mol.getAtomCount(); ++i) {
            if (this.getAcidAtom(i) != 4 || this.pkaAcidType[i][0] != -1) continue;
            this.setCHAcidDelocState(i);
            break;
        }
        block6: for (i = 0; i < this.mol.getAtomCount(); ++i) {
            this.acidAtomType[i] = this.getAcidAtom(i);
            switch (this.acidAtomType[i]) {
                case 1: 
                case 3: 
                case 6: {
                    this.getOHAcidDelocState(i, this.acidAtomType[i]);
                    continue block6;
                }
                case 2: {
                    if (this.pkaBasicType[i][0] != 1000) {
                        if (this.pkaBasicType[i][0] == 5 || this.pkaBasicType[i][0] == 3) {
                            this.getAliNHAcidDelocState(i, 2);
                            continue block6;
                        }
                        this.getNHAcidDelocState(i, 2);
                        continue block6;
                    }
                    if (this.pkaBasicType[i][7] == 100 || this.pkaBasicType[i][7] == 200 || this.pkaBasicType[i][7] == 300) {
                        this.getNHAcidDelocState(i, 2);
                        continue block6;
                    }
                    if (this.pkaBasicType[i][0] != 1000) continue block6;
                    if (this.sAra[i] == 1) {
                        this.getNHAcidDelocState(i, 2);
                        continue block6;
                    }
                    this.getAliNHAcidDelocState(i, 2);
                    continue block6;
                }
                case 5: {
                    this.getHaloAcidDelocState(i, 5);
                }
            }
        }
    }

    private double getApKa(int atom) {
        if (!this.baseTypesAvailable) {
            this.setBasicAtoms();
            this.baseTypesAvailable = true;
        }
        if (this.acidAtomType == null) {
            this.setAcidTypes();
            this.setAcidBaseCount();
        }
        if (this.acidAtomType[atom] == 0) {
            return Double.NaN;
        }
        if (this.acidicPKa == null || this.acidicPKa.mol != this.mol) {
            this.acidicPKa = new AcidicPKa(this);
        }
        return this.acidicPKa.calculate(atom);
    }

    private void setAcidBaseCount() {
        this.macropKaCount = 0;
        this.pkaAtomCount = 0;
        for (int atom = 0; atom < this.mol.getAtomCount(); ++atom) {
            int acidicHCount = 0;
            int charge = this.atomArray[atom].getCharge();
            if (this.pkaAcidType[atom][0] != -1) {
                if (this.pkaAcidType[atom][0] == -2) {
                    switch (this.acidAtomType[atom]) {
                        case 3: {
                            acidicHCount = this.getHCount(atom);
                            this.macropKaCount += acidicHCount;
                            break;
                        }
                        case 1: {
                            acidicHCount = 1;
                            this.macropKaCount += acidicHCount;
                            break;
                        }
                    }
                } else {
                    switch (this.acidAtomType[atom]) {
                        case 6: {
                            acidicHCount = 1;
                            this.macropKaCount += acidicHCount + -1 * charge;
                            break;
                        }
                        case 3: {
                            acidicHCount = this.getHCount(atom);
                            this.macropKaCount += acidicHCount;
                            break;
                        }
                        default: {
                            acidicHCount = 1;
                            this.macropKaCount += acidicHCount;
                            break;
                        }
                    }
                }
            } else if (charge < 0) {
                acidicHCount = 1;
                this.macropKaCount += acidicHCount + -1 * charge;
            } else if (charge > 0 && this.atomArray[atom].getImplicitHcount() != 0) {
                acidicHCount = 1;
                this.macropKaCount += acidicHCount + charge;
            }
            if (this.pkaBasicType[atom][0] != -1 && this.pkaBasicType[atom][0] != -2 && acidicHCount == 0) {
                acidicHCount = 1;
                this.macropKaCount += acidicHCount;
            }
            if (acidicHCount != 0) {
                this.pkaAtomIndex[atom] = acidicHCount;
            }
            this.pkaAtomCount += acidicHCount;
        }
        this.pkaActiveAtoms = new int[this.pkaAtomCount];
        this.aMultiplicity = new int[this.pkaAtomCount];
        this.pKaType = new int[this.pkaAtomCount];
        int ind = 0;
        for (int i = 0; i < this.mol.getAtomCount(); ++i) {
            int c = this.pkaAtomIndex[i];
            if (c == -1) continue;
            this.pkaAtomIndex[i] = ind;
            for (int j = 0; j < c; ++j) {
                this.pkaActiveAtoms[ind] = i;
                this.aMultiplicity[ind] = c;
                ++ind;
            }
        }
    }

    private int getHCount(int atom) {
        int c = 0;
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            if (this.cHtab[atom][i] < this.mol.getAtomCount()) continue;
            ++c;
        }
        return c;
    }

    protected int getMaxpKaCount() {
        return this.macropKaCount;
    }

    protected boolean isEvenDist() {
        for (int i = 0; i < this.sphereSize; ++i) {
            int a = this.sphere[i];
            if (this.dist[a] != 2 && this.dist[a] != 4 && this.dist[a] != 6) continue;
            return true;
        }
        return false;
    }

    protected boolean isDBViniliLike(int atom) {
        int c = 0;
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int nb = this.cHtab[atom][i];
            if (nb >= this.mol.getAtomCount() || this.delocAble[nb] != 1 || !this.isDBonded(nb)) continue;
            ++c;
        }
        return c >= 2;
    }

    private int isCCDBonded(int atom) {
        if (this.getAtno(atom) != 6) {
            return -1;
        }
        int exist = -1;
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int nb = this.cHtab[atom][i];
            if (nb >= this.mol.getAtomCount() || this.mol.getBond(this.bHtab[atom][nb]).getType() < 2) continue;
            if (this.getAtno(nb) != 6) {
                return -1;
            }
            exist = 1;
        }
        return exist;
    }

    public boolean isDBonded(int atom) {
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int nb = this.cHtab[atom][i];
            if (nb >= this.mol.getAtomCount() || this.mol.getBond(this.bHtab[atom][nb]).getType() < 2) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected double getDL(int atom) {
        dl = 0.0;
        type = this.pkaAcidType[atom][0];
        sType = this.pkaAcidType[atom][7];
        block13: for (i = 0; i < this.sphereSize; ++i) {
            a = this.sphere[i];
            switch (this.pg.getCarboxy()[a]) {
                case 100: {
                    dl += 1.0;
                    continue block13;
                }
                case 1300: {
                    dl += 1.0;
                    continue block13;
                }
                case 1: {
                    dl = type == 100 ? (this.isNbNegative(a) ? (dl += -0.5) : (dl += 1.0)) : (dl += 1.0);
                    if (this.atomArray[a].getCharge() != 1) continue block13;
                    dl += 2.0;
                    continue block13;
                }
                case 400: {
                    dl += 1.0;
                    if (this.atomArray[a].getCharge() != 1) continue block13;
                    dl += 8.0;
                    continue block13;
                }
                case 200: {
                    if (this.pg.getGroupType()[a] != 10 && this.pg.getGroupType()[a] != 12) {
                        if (!this.isNHCOConnect(atom)) {
                            dl += 1.0;
                            continue block13;
                        }
                        dl += -0.5;
                        continue block13;
                    }
                    dl -= 0.7;
                    continue block13;
                }
                case 500: {
                    if (type != 100) continue block13;
                    dl += 1.0;
                    continue block13;
                }
                case 300: {
                    dl += 0.0;
                    continue block13;
                }
                case 2: {
                    if (type == 11) {
                        if (this.isOxigenConnected(atom)) {
                            dl += -1.5;
                            continue block13;
                        }
                        dl -= 0.5;
                        continue block13;
                    }
                    if (type == 100) {
                        if (sType == 30) {
                            dl += 0.4;
                            continue block13;
                        }
                        if (sType == 55) {
                            dl += 0.4;
                            continue block13;
                        }
                        if (sType != 36) continue block13;
                        dl += 0.5;
                        continue block13;
                    }
                    dl += 0.0;
                    continue block13;
                }
                case 3: {
                    dl += 0.0;
                    continue block13;
                }
                case 800: {
                    dl += 0.4;
                    continue block13;
                }
                case 1000: {
                    if (this.getAtno(a) != 16 && this.getAtno(a) != 34 && this.getAtno(a) != 52) ** GOTO lbl68
                    dl += 2.0;
                    ** GOTO lbl70
lbl68:
                    // 1 sources

                    if (this.getAtno(a) == 8) {
                        dl += -1.2;
                    }
                }
lbl70:
                // 5 sources

                default: {
                    if (type == 120) {
                        if (this.atomArray[a].getCharge() == 1) {
                            if (sType == 2) {
                                dl += 1.2;
                                continue block13;
                            }
                            dl += 6.0;
                            continue block13;
                        }
                        if (this.getAtno(a) == 6 || !this.isInRing[a]) continue block13;
                        if (!this.isSingleBonded(a)) {
                            if (sType == 2) {
                                dl += 0.7;
                                continue block13;
                            }
                            dl += 6.0;
                            continue block13;
                        }
                        if (this.getAtno(a) == 7) continue block13;
                        if (sType == 2) {
                            dl += 1.5;
                            continue block13;
                        }
                        dl += 3.0;
                        continue block13;
                    }
                    if (type != 2 || !this.isArA(a) || this.getAtno(a) == 6) continue block13;
                    if (this.atomArray[a].getCharge() == 1) {
                        dl += -6.0;
                        continue block13;
                    }
                    dl += -3.0;
                }
            }
        }
        return dl;
    }

    private boolean isNbNegative(int ketoAtom) {
        for (int i = 0; i < this.cHtab[ketoAtom].length; ++i) {
            int nb = this.cHtab[ketoAtom][i];
            if (nb >= this.mol.getAtomCount() || this.atomArray[nb].getCharge() != -1) continue;
            return true;
        }
        return false;
    }

    private boolean isNHCOConnect(int carbon) {
        for (int i = 0; i < this.cHtab[carbon].length; ++i) {
            int nb = this.cHtab[carbon][i];
            if (nb >= this.mol.getAtomCount() || !this.isNitrogen(nb)) continue;
            return true;
        }
        return false;
    }

    private boolean isOxigenConnected(int carbon) {
        for (int i = 0; i < this.cHtab[carbon].length; ++i) {
            int nb = this.cHtab[carbon][i];
            if (nb >= this.mol.getAtomCount() || this.getAtno(nb) != 8) continue;
            return true;
        }
        return false;
    }

    protected boolean isAraNB(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            if (!this.isArA(this.cHtab[ai][i])) continue;
            return true;
        }
        return false;
    }

    protected double addBetaCorr(int atom) {
        int nb;
        int i;
        int alpha = this.pkaAcidType[atom][8];
        int beta = this.pkaAcidType[atom][4];
        if (this.mol.getBond(this.bHtab[alpha][beta]).getType() == 3) {
            return -6.0;
        }
        double sum = 0.0;
        if (beta != -1) {
            for (i = 0; i < this.cHtab[beta].length; ++i) {
                nb = this.cHtab[beta][i];
                if (nb >= this.mol.getAtomCount() || nb == alpha || this.pkaAcidType[nb][0] != 13 || this.atomArray[nb].getCharge() != -1) continue;
                sum += 1.0;
            }
        }
        for (i = 0; i < this.cHtab[alpha].length; ++i) {
            nb = this.cHtab[alpha][i];
            if (nb >= this.mol.getAtomCount() || nb == atom) continue;
            if (this.pkaBasicType[nb][0] == 1000) {
                if (this.atomArray[nb].getCharge() == 0) {
                    sum += 0.0;
                    continue;
                }
                sum += 1.5;
                continue;
            }
            if (this.pkaAcidType[nb][0] != 13) continue;
            if (this.atomArray[nb].getCharge() == 0) {
                sum += -4.5;
                continue;
            }
            sum += -1.0;
        }
        if (this.getAtno(beta) != 6) {
            sum += -1.2;
        }
        return sum;
    }

    protected void setProtonationState() {
        this.protonation = false;
        for (int i = 0; !this.protonation && i < this.pkaAtomCount; ++i) {
            int atom = this.pkaActiveAtoms[i];
            if (this.atomArray[atom].getCharge() != 1 || this.pkaBasicType[atom][0] == -1) continue;
            this.protonation = true;
        }
    }

    private double getBpKa(int atom) {
        if (!this.baseTypesAvailable) {
            this.setBasicAtoms();
            this.baseTypesAvailable = true;
        }
        if (this.acidAtomType == null) {
            this.setAcidTypes();
            this.setAcidBaseCount();
        }
        if (this.basicPKa == null || !this.basicPKa.isValid()) {
            this.basicPKa = new BasicPKa(this);
        }
        double pka = this.basicPKa.calculate(atom);
        return pka;
    }

    protected boolean isStrained(int atomInd) {
        return this.HBT != null && this.HBT[this.hbtAIndex[atomInd]][4] == atomInd;
    }

    private int getBondType(int bondIndex) {
        if (bondIndex < 0) {
            return -1;
        }
        return this.mol.getBond(bondIndex).getType();
    }

    private void getHaloAcidDelocState(int atom, int aType) {
        this.pkaAcidType[atom][5] = aType;
        int atno = this.getAtno(atom);
        if (atno == 9) {
            this.pkaAcidType[atom][0] = 1;
        } else if (atno == 17) {
            this.pkaAcidType[atom][0] = 2;
        } else if (atno == 35) {
            this.pkaAcidType[atom][0] = 3;
        } else if (atno == 53) {
            this.pkaAcidType[atom][0] = 4;
        }
    }

    private int getHeteroAtomCount() {
        int c = 0;
        for (int i = 0; i < this.sphereSize; ++i) {
            int a = this.sphere[i];
            int d = this.dist[a];
            if (d > 4) continue;
            if (this.isArA(a)) {
                if (this.getAtno(a) == 6) continue;
                ++c;
                continue;
            }
            if (this.sAra[a] != 1 || this.getAtno(a) == 6) continue;
            ++c;
        }
        return c;
    }

    private boolean isHBondedArOH(int atom) {
        for (int i = 0; i < this.sphereSize; ++i) {
            int a = this.sphere[i];
            int d = this.dist[a];
            if (d != 4 || this.pg.getCarboxy()[a] != 1 || this.getAtno(a) == 6) continue;
            return true;
        }
        return false;
    }

    private boolean getOHAcidDelocState(int atom, int aType) {
        int crossAtom;
        String alphaAtomSymb;
        int nnb;
        int sizenb;
        this.pkaAcidType[atom][5] = aType;
        int j = 0;
        int i = 0;
        int alphaAtom = -1;
        int betaAtom = -1;
        int nit = -1;
        int vinbeta = -1;
        int bAroma = -1;
        int size = this.cHtab[atom].length;
        boolean betaAromRoot = false;
        while (i < size & !betaAromRoot) {
            int nb = this.cHtab[atom][i];
            sizenb = this.cHtab[nb].length;
            if (sizenb == 1) {
                if (nb > this.mol.getAtomCount()) {
                    sizenb = 0;
                } else if (this.getAtno(nb) == 1) {
                    sizenb = 0;
                } else {
                    if (alphaAtom == -1) {
                        alphaAtom = nb;
                    }
                    sizenb = 0;
                }
            } else {
                alphaAtom = nb;
            }
            if (this.isArA(nb)) {
                int aAroma = nb;
                this.pkaAcidType[atom][0] = this.getAtno(nb) != 6 ? (this.atomArray[nb].getCharge() == 1 ? 37 : 38) : 0;
                this.pkaAcidType[atom][1] = aAroma;
                int[] rInfo = this.charge.findLargestRing(aAroma);
                this.pkaAcidType[atom][10] = rInfo[0];
                int c = 0;
                if (rInfo[1] == 1) {
                    this.pkaAcidType[atom][7] = 10;
                    this.getAtomDistances(atom, 6);
                    this.pkaAcidType[atom][9] = c = this.getHeteroAtomCount();
                } else {
                    this.getAtomDistances(atom, 4);
                    if (this.isHBondedArOH(atom)) {
                        this.pkaAcidType[atom][7] = 105;
                    }
                }
                return true;
            }
            j = 0;
            while (j < sizenb & !betaAromRoot) {
                nnb = this.cHtab[nb][j];
                if (this.isArA(nnb)) {
                    alphaAtom = nb;
                    betaAromRoot = true;
                    this.pkaAcidType[atom][2] = bAroma = this.cHtab[nb][j];
                }
                ++j;
            }
            ++i;
        }
        if (alphaAtom == -1) {
            alphaAtomSymb = "H";
            alphaAtom = 0;
        } else {
            alphaAtomSymb = this.atomArray[alphaAtom].getSymbol();
        }
        this.pkaAcidType[atom][8] = alphaAtom;
        sizenb = this.cHtab[alphaAtom].length;
        int bondOrder = 0;
        int sCount = 0;
        int oCount = 0;
        int ketoCount = 0;
        int ohCount = 0;
        int shCount = 0;
        boolean vinil = false;
        int betaAtom2 = -1;
        for (i = 0; i < sizenb; ++i) {
            int atno;
            nnb = this.cHtab[alphaAtom][i];
            if (!(nnb != atom & nnb < this.mol.getAtomCount())) continue;
            bondOrder = this.getBondType(this.bHtab[nnb][alphaAtom]);
            if (bondOrder > 1 & bondOrder < 4) {
                atno = this.getAtno(nnb);
                if (this.pg.getChargeState()[nnb] == 900) {
                    this.pkaAcidType[atom][6] = nnb;
                }
                if (atno == 16) {
                    ++sCount;
                    ++ketoCount;
                    continue;
                }
                if (atno == 8) {
                    ++oCount;
                    ++ketoCount;
                    continue;
                }
                vinil = true;
                vinbeta = nnb;
                continue;
            }
            if (bondOrder != 1) continue;
            atno = this.getAtno(nnb);
            if (atno == 16) {
                ++shCount;
            }
            if (atno == 8) {
                ++ohCount;
            }
            if (this.pg.getCarboxy()[nnb] != 2) {
                betaAtom = nnb;
            } else if (betaAtom == -1) {
                betaAtom = nnb;
            }
            if (alphaAtomSymb.equals("C") || atno != 6) continue;
            betaAtom2 = nnb;
        }
        if (betaAtom2 != -1) {
            betaAtom = betaAtom2;
        }
        this.pkaAcidType[atom][3] = crossAtom = alphaAtom;
        if (betaAromRoot) {
            if (ketoCount == 1) {
                if (oCount == 1) {
                    if (alphaAtomSymb.equals("C")) {
                        this.pkaAcidType[atom][0] = 1;
                        int[] rInfo = this.charge.findLargestRing(bAroma);
                        if (rInfo[0] != -1) {
                            this.pkaAcidType[atom][10] = this.charge.getRings().findSmallestAraRing(bAroma);
                        }
                        if (rInfo[1] == 1) {
                            this.pkaAcidType[atom][7] = 10;
                            if (rInfo[2] > 0) {
                                this.pkaAcidType[atom][7] = 20;
                                if (this.pg.getCarboxy()[rInfo[3]] == 1200) {
                                    this.pkaAcidType[atom][7] = 30;
                                }
                            }
                        }
                        return true;
                    }
                    if (alphaAtomSymb.equals("S")) {
                        if (vinil) {
                            this.pkaAcidType[atom][0] = 29;
                            return true;
                        }
                        this.pkaAcidType[atom][0] = 2;
                        return true;
                    }
                    if (alphaAtomSymb.equals("N")) {
                        this.pkaAcidType[atom][0] = 32;
                        return true;
                    }
                    if (alphaAtomSymb.equals("P")) {
                        this.pkaAcidType[atom][0] = 3;
                        return true;
                    }
                    if (this.isHalogen(alphaAtomSymb)) {
                        this.pkaAcidType[atom][0] = 30;
                        int[] rInfo = this.charge.findLargestRing(bAroma);
                        if (rInfo[1] == 1) {
                            this.pkaAcidType[atom][7] = 10;
                            if (rInfo[2] > 0) {
                                this.pkaAcidType[atom][7] = 20;
                                if (this.pg.getCarboxy()[rInfo[3]] == 1200) {
                                    this.pkaAcidType[atom][7] = 30;
                                }
                            }
                        }
                        return true;
                    }
                }
                if (sCount == 1) {
                    if (alphaAtomSymb.equals("C")) {
                        this.pkaAcidType[atom][0] = 33;
                        return true;
                    }
                    if (alphaAtomSymb.equals("N")) {
                        this.pkaAcidType[atom][0] = 3;
                        return true;
                    }
                }
            }
            if (ketoCount == 2 && oCount == 2 && alphaAtomSymb.equals("S")) {
                this.pkaAcidType[atom][0] = 5;
                return true;
            }
            if (vinil) {
                this.pkaAcidType[atom][0] = 6;
                return true;
            }
            if (alphaAtomSymb.equals("O")) {
                this.pkaAcidType[atom][0] = 7;
                return true;
            }
            if (alphaAtomSymb.equals("As")) {
                this.pkaAcidType[atom][0] = ohCount != 0 ? 16 : 18;
                return true;
            }
            if (alphaAtomSymb.equals("N") && ((nit = this.pg.getCarboxy()[alphaAtom]) == 700 || nit == 500)) {
                this.pkaAcidType[atom][0] = 23;
                return true;
            }
            if (alphaAtomSymb.equals("B")) {
                this.pkaAcidType[atom][8] = alphaAtom;
                this.pkaAcidType[atom][0] = 27;
                return true;
            }
        }
        if (!betaAromRoot) {
            if (ketoCount == 1) {
                if (oCount == 1) {
                    if (alphaAtomSymb.equals("C")) {
                        if (ohCount != 0 || shCount != 0) {
                            this.pkaAcidType[atom][0] = 26;
                            return true;
                        }
                        this.charge.calcExtendedDelocPath(alphaAtom, 2);
                        this.delocAble = this.charge.delocAble;
                        this.maxDelocLength = this.charge.maxDelocLength;
                        this.pkaAcidType[atom][0] = this.maxDelocLength < 4 ? 8 : 15;
                        this.pkaAcidType[atom][4] = betaAtom;
                        return true;
                    }
                    if (alphaAtomSymb.equals("S")) {
                        this.pkaAcidType[atom][0] = 9;
                        this.pkaAcidType[atom][4] = betaAtom;
                        return true;
                    }
                    if (alphaAtomSymb.equals("P")) {
                        int sType;
                        this.pkaAcidType[atom][0] = 10;
                        this.pkaAcidType[atom][4] = betaAtom;
                        this.pkaAcidType[atom][7] = sType = this.getEsterCount(alphaAtom);
                        if (this.isNbCarboxylExist(atom, alphaAtom)) {
                            this.pkaAcidType[atom][7] = 11;
                        }
                        return true;
                    }
                    if (alphaAtomSymb.equals("N")) {
                        this.pkaAcidType[atom][0] = 21;
                        this.pkaAcidType[atom][4] = betaAtom;
                        if (this.atomArray[alphaAtom].getCharge() == 1) {
                            this.pkaAcidType[atom][0] = 34;
                        } else if (this.isNitronicAcid(alphaAtom)) {
                            this.pkaAcidType[atom][0] = 35;
                        }
                        return true;
                    }
                    if (this.isHalogen(alphaAtomSymb)) {
                        this.pkaAcidType[atom][0] = 31;
                        this.pkaAcidType[atom][4] = betaAtom;
                        return true;
                    }
                }
                if (sCount == 1) {
                    if (alphaAtomSymb.equals("C")) {
                        this.pkaAcidType[atom][0] = 11;
                        return true;
                    }
                    if (!alphaAtomSymb.equals("C")) {
                        this.pkaAcidType[atom][0] = 11;
                        return true;
                    }
                }
            }
            if (ketoCount == 2 && oCount == 2) {
                if (alphaAtomSymb.equals("S")) {
                    this.pkaAcidType[atom][0] = 12;
                    return true;
                }
                if (alphaAtomSymb.equals("N")) {
                    this.pkaAcidType[atom][0] = 20;
                    return true;
                }
            }
            if (vinil) {
                if (alphaAtomSymb.equals("N")) {
                    int ri;
                    this.pkaAcidType[atom][0] = 24;
                    this.pkaAcidType[atom][4] = vinbeta;
                    if (this.isAraNBexist(vinbeta)) {
                        this.pkaAcidType[atom][7] = 10;
                        int ri2 = this.charge.getRings().findSmallestAraRing(this.actAraNb);
                        if (ri2 != -1) {
                            if (this.isHeteroAraRing(ri2)) {
                                this.pkaAcidType[atom][7] = 11;
                            }
                            if (this.isInRing[vinbeta]) {
                                this.pkaAcidType[atom][10] = this.charge.getRings().getSmallestRingIndex(vinbeta);
                            }
                        } else if (this.isInRing[vinbeta] && (ri2 = this.charge.getRings().getSmallestRingIndex(vinbeta)) != -1) {
                            this.pkaAcidType[atom][10] = ri2;
                        }
                    } else if (this.isInRing[vinbeta] && (ri = this.charge.getRings().getSmallestRingIndex(vinbeta)) != -1) {
                        this.pkaAcidType[atom][10] = ri;
                        this.pkaAcidType[atom][7] = 15;
                        if (this.isAllAtomDelocAble(ri)) {
                            this.pkaAcidType[atom][7] = 20;
                        }
                    }
                    return true;
                }
                this.pkaAcidType[atom][0] = 13;
                this.pkaAcidType[atom][4] = vinbeta;
                this.pkaAcidType[atom][8] = alphaAtom;
                int y = this.isKetoNbExist(atom, vinbeta);
                if (y != 0) {
                    if (y == 1) {
                        this.pkaAcidType[atom][7] = 3;
                    } else if (y == 2) {
                        this.pkaAcidType[atom][7] = 4;
                    }
                } else if (!this.isInRing[alphaAtom] && this.isInRing[vinbeta]) {
                    int ri = this.charge.getRings().getSmallestRingIndex(vinbeta);
                    this.pkaAcidType[atom][7] = this.isAllAtomDelocAble(ri) ? 1 : 2;
                }
                return true;
            }
            if (alphaAtomSymb.equals("O")) {
                this.pkaAcidType[atom][0] = 14;
                this.pkaAcidType[atom][4] = betaAtom;
                return true;
            }
            if (alphaAtomSymb.equals("H")) {
                this.pkaAcidType[atom][0] = 25;
                return true;
            }
            if (alphaAtomSymb.equals("As")) {
                this.pkaAcidType[atom][0] = ohCount != 0 ? 17 : 19;
                return true;
            }
            if (alphaAtomSymb.equals("N") && ((nit = this.pg.getCarboxy()[alphaAtom]) == 200 || nit == 600 || nit == 700 || nit == 500)) {
                if (this.sAra[alphaAtom] == 1) {
                    this.pkaAcidType[atom][7] = 10;
                }
                this.pkaAcidType[atom][0] = 22;
                return true;
            }
            if (alphaAtomSymb.equals("B")) {
                if (ohCount == 2) {
                    this.pkaAcidType[atom][0] = 28;
                    this.pkaAcidType[atom][8] = alphaAtom;
                }
                return true;
            }
            if (alphaAtomSymb.equals("P") && this.cHtab[alphaAtom].length == 5) {
                this.pkaAcidType[atom][0] = 36;
                this.pkaAcidType[atom][8] = alphaAtom;
                return true;
            }
            if (alphaAtomSymb.equals("Cl") || alphaAtomSymb.equals("I") || alphaAtomSymb.equals("Br")) {
                if (ketoCount == 3) {
                    this.pkaAcidType[atom][0] = 39;
                    this.pkaAcidType[atom][8] = alphaAtom;
                    this.pkaAcidType[atom][7] = 10;
                    return true;
                }
                if (ketoCount == 2) {
                    this.pkaAcidType[atom][0] = 39;
                    this.pkaAcidType[atom][8] = alphaAtom;
                    this.pkaAcidType[atom][7] = 20;
                    return true;
                }
                if (ketoCount == 1) {
                    this.pkaAcidType[atom][0] = 39;
                    this.pkaAcidType[atom][8] = alphaAtom;
                    this.pkaAcidType[atom][7] = 30;
                    return true;
                }
                if (ketoCount == 0) {
                    this.pkaAcidType[atom][0] = 39;
                    this.pkaAcidType[atom][8] = alphaAtom;
                    this.pkaAcidType[atom][7] = 40;
                    return true;
                }
            }
        }
        this.pkaAcidType[atom][0] = -2;
        return false;
    }

    private boolean isHeteroAraRing(int ri) {
        for (int i = 0; i < this.aAtoms[ri].length; ++i) {
            int ra = this.aAtoms[ri][i];
            if (this.getAtno(ra) == 6) continue;
            return true;
        }
        return false;
    }

    private int getHeteroAraNCount(int ri) {
        int c = 0;
        for (int i = 0; i < this.aAtoms[ri].length; ++i) {
            int ra = this.aAtoms[ri][i];
            if (this.getAtno(ra) != 7) continue;
            ++c;
        }
        return c;
    }

    private int isKetoNbExist(int atom, int beta) {
        int c = 0;
        int alpha = this.pkaAcidType[atom][8];
        for (int i = 0; i < this.cHtab[beta].length; ++i) {
            int nb = this.cHtab[beta][i];
            if (nb >= this.mol.getAtomCount() || nb == alpha || this.pg.getCarboxy()[nb] != 1 && this.pg.getCarboxy()[nb] != 200 && this.pg.getCarboxy()[nb] != 2 && this.pg.getCarboxy()[nb] != 1830 || !this.isDBonded(nb)) continue;
            ++c;
            if (this.pg.getCarboxy()[nb] != 1) continue;
            this.resetOBaseSubType(nb);
        }
        return c;
    }

    private void resetOBaseSubType(int alpha) {
        for (int i = 0; i < this.cHtab[alpha].length; ++i) {
            int nb = this.cHtab[alpha][i];
            if (nb >= this.mol.getAtomCount() || this.pkaBasicType[nb][0] != 4300) continue;
            this.pkaBasicType[nb][1] = 415;
        }
    }

    private boolean isHBondedKeto(int alpha) {
        for (int i = 0; i < this.cHtab[alpha].length; ++i) {
            int nb = this.cHtab[alpha][i];
            if (nb >= this.mol.getAtomCount() || this.pkaBasicType[nb][1] != 415) continue;
            return true;
        }
        return false;
    }

    private boolean isNbCarboxylExist(int atom, int alpha) {
        for (int i = 0; i < this.cHtab[alpha].length; ++i) {
            int beta;
            int pc;
            int nb = this.cHtab[alpha][i];
            if (nb >= this.mol.getAtomCount() || nb == atom || (pc = this.mol.getAtom(beta = nb).getAtno()) == 6 || this.cHtab[beta].length <= 1) continue;
            for (int j = 0; j < this.cHtab[beta].length; ++j) {
                int nnb = this.cHtab[beta][j];
                if (nnb >= this.mol.getAtomCount() || nnb == alpha || this.pg.getCarboxy()[nnb] != 300) continue;
                return true;
            }
        }
        return false;
    }

    private int getEsterCount(int a) {
        int c = 0;
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int nb = this.cHtab[a][i];
            if (nb >= this.mol.getAtomCount() || this.pg.getCarboxy()[nb] != 2) continue;
            ++c;
        }
        return c;
    }

    private boolean isNitronicAcid(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.mol.getAtomCount() || this.charge.getValenceState(ai) != 5) continue;
            return true;
        }
        return false;
    }

    private boolean isHalogen(String symb) {
        return symb.equals("F") || symb.equals("Cl") || symb.equals("Br") || symb.equals("I");
    }

    private void setCHAcidDelocState(int atom) {
        int i;
        for (i = 0; i < this.mol.getAtomCount(); ++i) {
            if (this.getAtno(i) != 6) continue;
            this.pkaAcidType[i][0] = -2;
        }
        for (i = 0; i < this.mol.getAtomCount(); ++i) {
            if (this.isNitrogen(i)) {
                if (this.pg.getCarboxy()[i] == 100 || this.pg.getCarboxy()[i] == 400 || this.pg.getCarboxy()[i] == 1200) {
                    this.setNO2orCNAcid(i);
                } else if (this.pkaBasicType[i][0] == 5 && this.isCHNbExist(this.pkaBasicType[i][2])) {
                    this.setKetoAcid(i);
                }
            }
            if (this.getAtno(i) != 8 && this.getAtno(i) != 16 && this.getAtno(i) != 34) continue;
            if (this.cHtab[i].length == 1) {
                if (this.pg.getCarboxy()[i] != 1 && this.pg.getCarboxy()[i] != 2 && this.pg.getCarboxy()[i] != 200 && this.pg.getCarboxy()[i] != 500) continue;
                this.setKetoAcid(i);
                continue;
            }
            if (this.cHtab[i].length != 2 || this.pg.getChargeState()[i] != 900 || this.pg.getCarboxy()[i] != 1 && this.pg.getCarboxy()[i] != 2 && this.pg.getCarboxy()[i] != 200 && this.pg.getCarboxy()[i] != 500) continue;
            this.setKetoAcid(i);
        }
        for (int i2 = 0; i2 < this.mol.getAtomCount(); ++i2) {
            int c;
            if (this.getAtno(i2) != 6) continue;
            if (this.isInRing[i2] && !this.isArA(i2) && this.isRCH(i2) && this.cHtab[i2].length == 4 && this.pkaAcidType[i2][0] == -2) {
                int ri = -1;
                boolean ChdelocRing = false;
                boolean LargeCdr = false;
                int riLarge = -1;
                ri = this.charge.getRings().getSmallestRingIndex(i2);
                ChdelocRing = this.isCHAcidDelocAbleRing(ri, i2);
                if (!ChdelocRing) {
                    ri = this.charge.getLargestRingIndex(i2);
                    ChdelocRing = this.isCHAcidDelocAbleRing(ri, i2);
                } else {
                    riLarge = this.charge.getLargestRingIndex(i2);
                    LargeCdr = this.isCHAcidDelocAbleRing(riLarge, i2);
                }
                if (ChdelocRing) {
                    int ra = this.charge.isSemiAromaticRing(ri);
                    if (ra == 4 || ra == 8 || ra == 12 || ra == 16 || ra == 20) {
                        this.pkaAcidType[i2][7] = 1;
                    } else if (LargeCdr && ((ra = this.charge.isSemiAromaticRing(riLarge)) == 4 || ra == 8 || ra == 12 || ra == 16 || ra == 20)) {
                        this.pkaAcidType[i2][7] = 1;
                        ri = riLarge;
                    }
                    this.pkaAcidType[i2][8] = ri;
                    this.pkaAcidType[i2][5] = 4;
                    this.pkaAcidType[i2][0] = 120;
                    if (this.pkaAcidType[i2][7] == 1) {
                        c = 0;
                        for (int j = 0; j < this.nonAring[ri].length; ++j) {
                            ra = this.nonAring[ri][j];
                            if (this.isArA(ra)) {
                                ++c;
                            }
                            if (this.getAtno(ra) == 6) continue;
                            this.pkaAcidType[i2][7] = 2;
                        }
                        if (this.pkaAcidType[i2][7] != 2 && c >= 2) {
                            this.pkaAcidType[i2][7] = 3;
                        }
                    }
                }
            }
            if (this.pkaAcidType[i2][0] != -2) continue;
            c = 0;
            int d = 0;
            int aNb = 0;
            int dBond = 0;
            int chg = this.mol.getAtom(i2).getCharge();
            boolean heteroDB = false;
            if (!this.isRCH(i2) && chg != -1) continue;
            this.pkaAcidType[i2][0] = 520;
            if (this.isYlide(i2)) {
                this.pkaAcidType[i2][0] = 522;
            }
            this.pkaAcidType[i2][5] = 4;
            if (!this.isArA(i2)) {
                if (this.pkaAcidType[i2][0] == 522) {
                    if (this.actAtType == 7) {
                        if (this.isArA(this.actIndx)) {
                            this.pkaAcidType[i2][3] = 15;
                            this.pkaAcidType[i2][8] = this.charge.getRings().getLargestAraRingIndex(this.actIndx);
                        } else {
                            this.pkaAcidType[i2][3] = 10;
                        }
                    } else if (this.actAtType == 8) {
                        this.pkaAcidType[i2][3] = 25;
                    } else if (this.actAtType == 16) {
                        this.pkaAcidType[i2][3] = this.isOxoCation(i2) ? 35 : 30;
                    } else if (this.actAtType == 15) {
                        this.pkaAcidType[i2][3] = 40;
                    } else if (this.actAtType == 33) {
                        this.pkaAcidType[i2][3] = 45;
                    }
                    int cc = 0;
                    cc = this.isArA(this.actIndx) ? 0 : this.isWittingType(this.actIndx);
                    if (this.isAraNBexist(i2)) {
                        if (cc == 3) {
                            this.pkaAcidType[i2][7] = 20;
                            continue;
                        }
                        if (cc == 2) {
                            this.pkaAcidType[i2][7] = 21;
                            continue;
                        }
                        if (cc == 1) {
                            this.pkaAcidType[i2][7] = 22;
                            continue;
                        }
                        if (cc != 0) continue;
                        this.pkaAcidType[i2][7] = 23;
                        continue;
                    }
                    if (cc == 3) {
                        this.pkaAcidType[i2][7] = 24;
                        continue;
                    }
                    if (cc == 2) {
                        this.pkaAcidType[i2][7] = 25;
                        continue;
                    }
                    if (cc == 1) {
                        this.pkaAcidType[i2][7] = 26;
                        continue;
                    }
                    if (cc != 0) continue;
                    this.pkaAcidType[i2][7] = 27;
                    continue;
                }
                for (int j = 0; j < this.cHtab[i2].length; ++j) {
                    int nb = this.cHtab[i2][j];
                    if (nb >= this.mol.getAtomCount()) continue;
                    if (this.isArA(nb)) {
                        ++c;
                        aNb = nb;
                        continue;
                    }
                    if (this.delocAble[nb] == -1 || this.hconj[nb] != 0) continue;
                    ++d;
                    if (this.isCCDBonded(nb) == 1) {
                        ++dBond;
                        continue;
                    }
                    heteroDB = true;
                }
                if (c >= 1) {
                    this.pkaAcidType[i2][7] = 10;
                    this.pkaAcidType[i2][3] = c;
                    this.pkaAcidType[i2][8] = this.charge.getRings().getLargestAraRingIndex(aNb);
                    continue;
                }
                if (d >= 1) {
                    this.pkaAcidType[i2][7] = 20;
                    this.pkaAcidType[i2][3] = d;
                    if (dBond == 0 || heteroDB) continue;
                    this.pkaAcidType[i2][7] = 40;
                    continue;
                }
                this.pkaAcidType[i2][7] = 30;
                continue;
            }
            this.pkaAcidType[i2][7] = 5;
            this.pkaAcidType[i2][8] = this.charge.getRings().getLargestAraRingIndex(i2);
        }
    }

    private boolean isOxoCation(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.mol.getAtomCount() || this.mol.getBond(this.bHtab[nb][ai]).getType() != 2 || this.atomArray[nb].getAtno() == 6) continue;
            return true;
        }
        return false;
    }

    private int isWittingType(int phos) {
        int c = 0;
        for (int i = 0; i < this.cHtab[phos].length; ++i) {
            int nb = this.cHtab[phos][i];
            if (nb >= this.mol.getAtomCount() || !this.isArA(nb)) continue;
            ++c;
        }
        return c;
    }

    private boolean isYlide(int ai) {
        if (this.isArA(ai)) {
            return false;
        }
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.mol.getAtomCount()) continue;
            int pc = this.atomArray[nb].getAtno();
            if (pc == 15 || pc == 33) {
                if (this.mol.getAtom(nb).getCharge() == 1) {
                    this.actIndx = nb;
                    this.actAtType = pc;
                    return true;
                }
                if (this.mol.getBond(this.bHtab[nb][ai]).getType() != 2) continue;
                return true;
            }
            if (pc != 7 && pc != 16 || this.mol.getAtom(nb).getCharge() != 1) continue;
            if (pc == 7) {
                if (this.cHtab[nb].length != 4) continue;
                this.actIndx = nb;
                this.actAtType = pc;
                return true;
            }
            this.actIndx = nb;
            this.actAtType = pc;
            return true;
        }
        return false;
    }

    private void setKetoAcid(int ketoAtom) {
        int nb;
        boolean nketo = false;
        int alphaRIndex = -1;
        if (this.getAtno(ketoAtom) == 7) {
            nketo = true;
            nb = this.pkaBasicType[ketoAtom][2];
        } else {
            nb = this.cHtab[ketoAtom][0];
            if (this.isInRing[nb]) {
                alphaRIndex = this.charge.getRings().getSmallestRingIndex(nb);
            }
        }
        int ketoCount = 0;
        int amideCount = 0;
        int PhamideCount = 0;
        int esterCount = 0;
        int alphaK = -1;
        boolean aldehyde = false;
        boolean sKeto = false;
        boolean seKeto = false;
        boolean sulphoxide = false;
        boolean xoxide = false;
        boolean halfPhenacyl = false;
        if (this.getAtno(ketoAtom) == 16) {
            sKeto = true;
        } else if (this.getAtno(ketoCount) == 34) {
            seKeto = true;
        }
        if (this.getAtno(nb) == 16) {
            sulphoxide = true;
        } else if (this.getAtno(nb) != 6) {
            xoxide = true;
        }
        for (int i = 0; i < this.cHtab[nb].length; ++i) {
            if (this.cHtab[nb][i] >= this.mol.getAtomCount()) {
                aldehyde = true;
                continue;
            }
            if (this.getAtno(this.cHtab[nb][i]) == 1) {
                aldehyde = true;
                continue;
            }
            if (!this.isArA(this.cHtab[nb][i])) continue;
            halfPhenacyl = true;
            alphaK = this.cHtab[nb][i];
        }
        int ri = 0;
        int okc = 0;
        int oec = 0;
        int ra = 0;
        boolean ChdelocRing = false;
        boolean araRing = false;
        boolean semiAromatic = false;
        boolean delocLikeNb = false;
        if (this.pg.getCarboxy()[ketoAtom] == 200 || this.pg.getCarboxy()[ketoAtom] == 500) {
            amideCount = 1;
            if (this.pg.getCarboxy()[ketoAtom] == 500) {
                PhamideCount = 1;
            }
        } else if (this.pg.getCarboxy()[ketoAtom] == 2) {
            esterCount = 1;
            oec = 1;
        } else {
            ketoCount = 1;
            okc = 1;
        }
        for (int i = 0; i < this.cHtab[nb].length; ++i) {
            int nbc = this.cHtab[nb][i];
            if (this.getAtno(nbc) != 6) continue;
            if (!this.isArA(nbc)) {
                if (!this.isRCH(nbc)) continue;
                this.acidicCarbon = nbc;
                ketoCount = okc;
                esterCount = oec;
                if (this.isYlide(this.acidicCarbon)) continue;
                if (sKeto) {
                    this.pkaAcidType[this.acidicCarbon][9] = 1;
                }
                if (seKeto) {
                    this.pkaAcidType[this.acidicCarbon][9] = 2;
                }
                if (sulphoxide) {
                    this.pkaAcidType[this.acidicCarbon][9] = 3;
                }
                if (nketo) {
                    this.pkaAcidType[this.acidicCarbon][9] = 5;
                }
                if (xoxide) {
                    this.pkaAcidType[this.acidicCarbon][9] = 4;
                }
                araRing = false;
                int ria = -1;
                int nba = -1;
                int bgKeto = -1;
                boolean chdcR = false;
                for (int j = 0; j < this.cHtab[this.acidicCarbon].length; ++j) {
                    int chType;
                    nba = this.cHtab[this.acidicCarbon][j];
                    if (this.getAtno(nba) != 6 || nba == nb) continue;
                    int ct = this.pg.getCarboxy()[nba];
                    if (this.isDBBonded(nba)) {
                        bgKeto = nba;
                        int[] xy = this.isGammaKeto(nba, this.acidicCarbon);
                        if (xy[0] != -1) {
                            this.pkaAcidType[xy[0]][5] = 4;
                            this.pkaAcidType[xy[0]][0] = this.isDBViniliLike(xy[0]) ? 706 : 705;
                            if (this.isTheSameRing(alphaRIndex, xy[0]) && (chdcR = this.isCHAcidDelocAbleRing(alphaRIndex, xy[0])) && ((ra = this.charge.isSemiAromaticRing(alphaRIndex)) == 4 || ra == 8 || ra == 12 || ra == 16 || ra == 20)) {
                                this.pkaAcidType[xy[0]][7] = 16;
                            }
                            if (xy[1] != -1) {
                                this.pkaAcidType[xy[1]][5] = 4;
                                this.pkaAcidType[xy[1]][0] = this.isDBViniliLike(xy[1]) ? 706 : 705;
                                if (this.isTheSameRing(alphaRIndex, xy[1]) && (chdcR = this.isCHAcidDelocAbleRing(alphaRIndex, xy[1])) && ((ra = this.charge.isSemiAromaticRing(alphaRIndex)) == 4 || ra == 8 || ra == 12 || ra == 16 || ra == 20)) {
                                    this.pkaAcidType[xy[1]][7] = 16;
                                }
                            }
                        }
                    }
                    if (this.isArA(nba)) {
                        araRing = true;
                        ria = nba;
                    }
                    if (ct == 1 || ct == 2) {
                        delocLikeNb = true;
                        this.pkaAcidType[this.acidicCarbon][5] = 4;
                        this.pkaAcidType[this.acidicCarbon][0] = chType = 100;
                        if (ct == 2) {
                            ++esterCount;
                            continue;
                        }
                        ++ketoCount;
                        continue;
                    }
                    if (ct == 200 || ct == 500) {
                        delocLikeNb = true;
                        if (this.pkaAcidType[this.acidicCarbon][0] == 100) continue;
                        this.pkaAcidType[this.acidicCarbon][5] = 4;
                        this.pkaAcidType[this.acidicCarbon][0] = chType = 101;
                        ++amideCount;
                        if (ct != 500) continue;
                        ++PhamideCount;
                        continue;
                    }
                    if (ct != 400) continue;
                    delocLikeNb = true;
                }
                ri = alphaRIndex != -1 ? alphaRIndex : this.charge.getRings().getSmallestRingIndex(this.acidicCarbon);
                this.pkaAcidType[this.acidicCarbon][8] = ri;
                ChdelocRing = this.isCHAcidDelocAbleRing(ri, this.acidicCarbon);
                if (ketoCount >= 1 && amideCount >= 1) {
                    this.pkaAcidType[this.acidicCarbon][7] = 10;
                    if (ri == -1 || !ChdelocRing) continue;
                    ra = this.charge.isSemiAromaticRing(ri);
                    if (ra == 4 || ra == 8 || ra == 12 || ra == 16 || ra == 20) {
                        this.pkaAcidType[this.acidicCarbon][7] = 16;
                        continue;
                    }
                    this.pkaAcidType[this.acidicCarbon][7] = 15;
                    continue;
                }
                if (amideCount >= 2) {
                    if (ChdelocRing) {
                        ra = this.charge.isSemiAromaticRing(ri);
                        semiAromatic = false;
                        if (ra == 4 || ra == 8 || ra == 12 || ra == 16 || ra == 20) {
                            semiAromatic = true;
                        }
                        if (PhamideCount == 1) {
                            if (semiAromatic) {
                                this.pkaAcidType[this.acidicCarbon][7] = 211;
                                continue;
                            }
                            this.pkaAcidType[this.acidicCarbon][7] = 21;
                            continue;
                        }
                        if (PhamideCount == 2) {
                            if (semiAromatic) {
                                this.pkaAcidType[this.acidicCarbon][7] = 222;
                                continue;
                            }
                            this.pkaAcidType[this.acidicCarbon][7] = 22;
                            continue;
                        }
                        if (semiAromatic) {
                            this.pkaAcidType[this.acidicCarbon][7] = 233;
                            continue;
                        }
                        this.pkaAcidType[this.acidicCarbon][7] = 23;
                        continue;
                    }
                    this.pkaAcidType[this.acidicCarbon][7] = 20;
                    continue;
                }
                if (esterCount >= 1 && ketoCount >= 1) {
                    if (ri != -1) {
                        if (ChdelocRing) {
                            this.pkaAcidType[this.acidicCarbon][7] = 55;
                            continue;
                        }
                        this.pkaAcidType[this.acidicCarbon][7] = 30;
                        continue;
                    }
                    this.pkaAcidType[this.acidicCarbon][7] = 30;
                    continue;
                }
                if (esterCount >= 1 && amideCount >= 1) {
                    this.pkaAcidType[this.acidicCarbon][7] = 40;
                    continue;
                }
                if (ketoCount >= 2) {
                    ra = this.charge.isSemiAromaticRing(ri);
                    semiAromatic = false;
                    if (ra == 4 || ra == 8 || ra == 12 || ra == 16 || ra == 20) {
                        semiAromatic = true;
                    }
                    if (semiAromatic) {
                        this.pkaAcidType[this.acidicCarbon][7] = 501;
                        continue;
                    }
                    if (ri == -1) continue;
                    this.pkaAcidType[this.acidicCarbon][7] = 50;
                    continue;
                }
                if (esterCount >= 2) {
                    if (ChdelocRing) {
                        this.pkaAcidType[this.acidicCarbon][7] = 36;
                        continue;
                    }
                    this.pkaAcidType[this.acidicCarbon][7] = 35;
                    continue;
                }
                if (this.pkaAcidType[this.acidicCarbon][0] != -2) continue;
                if (esterCount == 1 && araRing) {
                    if (ChdelocRing) {
                        ra = this.charge.isSemiAromaticRing(ri);
                        this.pkaAcidType[this.acidicCarbon][7] = ra == 4 || ra == 8 || ra == 12 || ra == 16 || ra == 20 ? 16 : 15;
                    }
                    this.pkaAcidType[this.acidicCarbon][5] = 4;
                    this.pkaAcidType[this.acidicCarbon][0] = 68;
                    continue;
                }
                if (esterCount == 1) {
                    this.pkaAcidType[this.acidicCarbon][5] = 4;
                    this.pkaAcidType[this.acidicCarbon][0] = 69;
                    if (delocLikeNb) {
                        this.pkaAcidType[this.acidicCarbon][7] = 32;
                    } else if (this.cHtab[this.acidicCarbon].length < 4) {
                        this.pkaAcidType[this.acidicCarbon][7] = 22;
                    }
                    if (!ChdelocRing) continue;
                    ra = this.charge.isSemiAromaticRing(ri);
                    if (ra == 4 || ra == 8 || ra == 12 || ra == 16 || ra == 20) {
                        this.pkaAcidType[this.acidicCarbon][7] = 16;
                        continue;
                    }
                    this.pkaAcidType[this.acidicCarbon][7] = 15;
                    continue;
                }
                if (ketoCount == 1 && araRing) {
                    if (ChdelocRing) {
                        ra = this.charge.isSemiAromaticRing(ri);
                        this.pkaAcidType[this.acidicCarbon][7] = ra == 4 || ra == 8 || ra == 12 || ra == 16 || ra == 20 ? 16 : 15;
                    }
                    this.pkaAcidType[this.acidicCarbon][5] = 4;
                    if (aldehyde) {
                        this.pkaAcidType[this.acidicCarbon][0] = 71;
                        continue;
                    }
                    this.pkaAcidType[this.acidicCarbon][0] = 65;
                    if (this.pkaAcidType[this.acidicCarbon][1] == -1) {
                        this.pkaAcidType[this.acidicCarbon][1] = ria;
                        this.pkaAcidType[this.acidicCarbon][10] = this.charge.getRings().findSmallestAraRing(ria);
                    } else {
                        this.pkaAcidType[this.acidicCarbon][2] = ria;
                        this.pkaAcidType[this.acidicCarbon][11] = this.charge.getRings().findSmallestAraRing(ria);
                    }
                    this.pkaAcidType[this.acidicCarbon][3] = nb;
                    if (halfPhenacyl) {
                        this.pkaAcidType[this.acidicCarbon][4] = this.charge.getRings().findSmallestAraRing(alphaK);
                        this.pkaAcidType[this.acidicCarbon][7] = 90;
                        continue;
                    }
                    this.pkaAcidType[this.acidicCarbon][7] = 80;
                    continue;
                }
                if (ketoCount == 1 && halfPhenacyl) {
                    if (ChdelocRing) {
                        ra = this.charge.isSemiAromaticRing(ri);
                        this.pkaAcidType[this.acidicCarbon][7] = ra == 4 || ra == 8 || ra == 12 || ra == 16 || ra == 20 ? 16 : 15;
                    }
                    this.pkaAcidType[this.acidicCarbon][5] = 4;
                    if (aldehyde) {
                        this.pkaAcidType[this.acidicCarbon][0] = 71;
                        continue;
                    }
                    this.pkaAcidType[this.acidicCarbon][0] = 650;
                    continue;
                }
                if (ketoCount != 1 || this.isDBBonded(this.acidicCarbon)) continue;
                if (ChdelocRing) {
                    ra = this.charge.isSemiAromaticRing(ri);
                    this.pkaAcidType[this.acidicCarbon][7] = ra == 4 || ra == 8 || ra == 12 || ra == 16 || ra == 20 ? 16 : 15;
                }
                this.pkaAcidType[this.acidicCarbon][5] = 4;
                if (aldehyde) {
                    this.pkaAcidType[this.acidicCarbon][0] = 70;
                    if (bgKeto == -1) continue;
                    this.pkaAcidType[this.acidicCarbon][1] = 10;
                    continue;
                }
                this.pkaAcidType[this.acidicCarbon][0] = 67;
                if (bgKeto == -1) continue;
                this.pkaAcidType[this.acidicCarbon][1] = 10;
                continue;
            }
            halfPhenacyl = true;
        }
    }

    private int[] isGammaKeto(int nba, int acCarb) {
        int[] zz = new int[]{-1, -1};
        if (!this.isInRing[acCarb]) {
            return zz;
        }
        if (this.mol.getBond(this.bHtab[nba][acCarb]).getType() > 1) {
            int k = 0;
            for (int i = 0; i < this.cHtab[nba].length; ++i) {
                int nb = this.cHtab[nba][i];
                if (nb >= this.mol.getAtomCount() || nb == acCarb || this.cHtab[nb].length != 4 || this.getAtno(nb) != 6 || !this.isRCH(nb)) continue;
                zz[k] = nb;
                if (++k <= 1) continue;
                return zz;
            }
        }
        return zz;
    }

    private boolean isCrossRingBond(int ai) {
        int c = 0;
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.mol.getAtomCount() || !this.isInRing[nb]) continue;
            ++c;
        }
        return c >= 3;
    }

    private boolean isDBBonded(int nba) {
        if (nba == -1 || nba >= this.mol.getAtomCount()) {
            return false;
        }
        for (int i = 0; i < this.cHtab[nba].length; ++i) {
            int nb = this.cHtab[nba][i];
            if (nb >= this.mol.getAtomCount() || this.mol.getBond(this.bHtab[nb][nba]).getType() <= 1) continue;
            return true;
        }
        return false;
    }

    private boolean isAllAtomDelocAble(int rIndex) {
        if (rIndex == -1) {
            return false;
        }
        int r = 0;
        for (int i = 0; i < this.nonAring[rIndex].length; ++i) {
            if (this.hconj[this.nonAring[rIndex][i]] == 1 || this.delocAble[this.nonAring[rIndex][i]] != 1) continue;
            ++r;
        }
        return r == this.nonAring[rIndex].length;
    }

    protected boolean isCHAcidDelocAbleRing(int rIndex, int acidC) {
        if (rIndex == -1) {
            return false;
        }
        if (this.hconj[acidC] != 1 && this.delocAble[acidC] == 1) {
            return false;
        }
        int r = 0;
        for (int i = 0; i < this.nonAring[rIndex].length; ++i) {
            if (this.hconj[this.nonAring[rIndex][i]] == 1 || this.delocAble[this.nonAring[rIndex][i]] != 1) continue;
            ++r;
        }
        return r == this.nonAring[rIndex].length - 1;
    }

    private void setNO2orCNAcid(int atom) {
        int f;
        int[] z = new int[]{-1, -1};
        if (this.pg.getGroupProperty()[atom] == 3600 && this.atomArray[atom].getCharge() == 1 && (f = this.getNbChCarbon(atom)) != -1) {
            this.acidicCarbon = f;
            this.pkaAcidType[this.acidicCarbon][0] = 510;
            this.pkaAcidType[this.acidicCarbon][5] = 4;
            return;
        }
        if (!this.isArA(atom)) {
            int nb;
            int i;
            int no = 0;
            boolean cn = false;
            int cnCarbon = -1;
            for (i = 0; i < this.cHtab[atom].length; ++i) {
                nb = this.cHtab[atom][i];
                if (nb >= this.mol.getAtomCount()) continue;
                int bondOrder = this.mol.getBond(this.bHtab[atom][nb]).getType();
                if (bondOrder == 2 && this.getAtno(nb) == 8) {
                    ++no;
                }
                if (bondOrder == 3 && this.getAtno(nb) == 6) {
                    cn = true;
                    cnCarbon = nb;
                }
                if (bondOrder != 1) continue;
                this.acidicCarbon = nb;
                if (z[0] == -1) {
                    z[0] = this.acidicCarbon;
                    continue;
                }
                z[1] = this.acidicCarbon;
            }
            if (no == 2) {
                if (!this.isArA(this.acidicCarbon) && this.isRCH(this.acidicCarbon) & this.cHtab[this.acidicCarbon].length == 4) {
                    int chType;
                    if (this.pkaAcidType[this.acidicCarbon][5] == 4) {
                        chType = 11;
                    } else {
                        this.pkaAcidType[this.acidicCarbon][5] = 4;
                        chType = 1;
                    }
                    for (i = 0; i < this.cHtab[this.acidicCarbon].length; ++i) {
                        nb = this.cHtab[this.acidicCarbon][i];
                        if (!this.isArA(nb)) continue;
                        chType = 2;
                    }
                    this.pkaAcidType[this.acidicCarbon][0] = chType;
                }
            } else if (cn) {
                if (this.setCNAcidicCarbon(cnCarbon)) {
                    int ri;
                    int chType = 3;
                    int subType = -1;
                    int dd = this.isDoubleDeloc(this.acidicCarbon);
                    if (dd == 2) {
                        subType = 1;
                    } else if (dd == 3) {
                        subType = 2;
                    } else if (dd == 5) {
                        subType = 5;
                    }
                    int holep = this.isChgNb(this.acidicCarbon);
                    if (holep == 2) {
                        subType = 3;
                    }
                    if (holep == 1) {
                        subType = 4;
                    }
                    this.pkaAcidType[this.acidicCarbon][5] = 4;
                    this.pkaAcidType[this.acidicCarbon][8] = ri = this.charge.getRings().getSmallestRingIndex(this.acidicCarbon);
                    if (this.isCHAcidDelocAbleRing(ri, this.acidicCarbon)) {
                        chType = 31;
                        if (this.isDoubleArA(this.acidicCarbon)) {
                            subType = 2;
                        }
                    } else {
                        for (int i2 = 0; i2 < this.cHtab[this.acidicCarbon].length; ++i2) {
                            nb = this.cHtab[this.acidicCarbon][i2];
                            if (!this.isArA(nb)) continue;
                            chType = 4;
                        }
                    }
                    if (this.pkaAcidType[this.acidicCarbon][0] == -2) {
                        this.pkaAcidType[this.acidicCarbon][0] = chType;
                        this.pkaAcidType[this.acidicCarbon][7] = subType;
                    }
                } else if (this.mol.getAtomCount() == 2) {
                    int chType = 7;
                    this.pkaAcidType[cnCarbon][5] = 4;
                    this.pkaAcidType[cnCarbon][0] = chType;
                }
            } else if (no == 1) {
                if (this.atomArray[atom].getCharge() == 1) {
                    if (z[0] != -1) {
                        this.setRNOCHAcid(z[0]);
                        if (z[1] != -1) {
                            this.setRNOCHAcid(z[1]);
                        }
                    }
                } else if (this.pg.getCarboxy()[atom] == 1200 && this.isRCH(this.acidicCarbon) && this.cHtab[this.acidicCarbon].length == 4) {
                    this.pkaAcidType[this.acidicCarbon][5] = 4;
                    this.pkaAcidType[this.acidicCarbon][0] = 11;
                    this.pkaAcidType[this.acidicCarbon][7] = 10;
                }
            }
        }
    }

    private int getNbChCarbon(int atom) {
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int nb = this.cHtab[atom][i];
            if (nb >= this.mol.getAtomCount() || this.getAtno(nb) != 6 || !this.isRCH(nb) || this.cHtab[nb].length != 4) continue;
            return nb;
        }
        return -1;
    }

    private void setRNOCHAcid(int ai) {
        if (this.isRCH(ai) && this.cHtab[ai].length == 4 && !this.isArA(ai)) {
            int chType;
            if (this.pkaAcidType[ai][5] == 4) {
                chType = 11;
            } else {
                this.pkaAcidType[ai][5] = 4;
                chType = 1;
            }
            for (int i = 0; i < this.cHtab[ai].length; ++i) {
                int nb = this.cHtab[ai][i];
                if (!this.isArA(nb)) continue;
                chType = 2;
            }
            this.pkaAcidType[ai][0] = chType;
            this.pkaAcidType[ai][7] = 10;
        }
    }

    private int isDoubleDeloc(int acidicC) {
        int c = 0;
        boolean sda = false;
        for (int i = 0; i < this.cHtab[acidicC].length; ++i) {
            int nb = this.cHtab[acidicC][i];
            if (nb >= this.mol.getAtomCount()) continue;
            if (this.isArA(nb)) {
                ++c;
                continue;
            }
            if (this.pg.getCarboxy()[nb] == -1) continue;
            if (!this.isSingleBonded(nb)) {
                ++c;
                continue;
            }
            sda = true;
        }
        if (sda && c == 2) {
            return 5;
        }
        if (c >= 2) {
            return c;
        }
        return c;
    }

    private boolean isDoubleArA(int acidicC) {
        int c = 0;
        for (int i = 0; i < this.cHtab[acidicC].length; ++i) {
            int nb = this.cHtab[acidicC][i];
            if (nb >= this.mol.getAtomCount() || !this.isArA(nb)) continue;
            ++c;
        }
        return c == 2;
    }

    private int isChgNb(int acidicC) {
        boolean holePos = false;
        boolean pos = false;
        for (int i = 0; i < this.cHtab[acidicC].length; ++i) {
            int nb = this.cHtab[acidicC][i];
            if (nb >= this.mol.getAtomCount() || this.atomArray[nb].getCharge() <= 0) continue;
            if (this.atomArray[nb].getAtno() > 10) {
                if (this.charge.getValenceState(nb) < 5) {
                    holePos = true;
                    continue;
                }
                pos = true;
                continue;
            }
            pos = true;
        }
        if (holePos) {
            return 2;
        }
        if (pos) {
            return 1;
        }
        return -1;
    }

    private boolean isCHNbExist(int ai) {
        if (ai == -1) {
            return false;
        }
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.mol.getAtomCount() || this.getAtno(nb) != 6 || this.cHtab[nb].length != 4 || !this.isRCH(nb)) continue;
            return true;
        }
        return false;
    }

    private boolean isRCH(int atom) {
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int nb = this.cHtab[atom][i];
            if (nb < this.mol.getAtomCount()) {
                if (this.getAtno(nb) != 1) continue;
                return this.atomArray[atom].getRadical() == 0;
            }
            return true;
        }
        return false;
    }

    private boolean setCNAcidicCarbon(int atom) {
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int nb = this.cHtab[atom][i];
            if (this.getAtno(nb) != 6 || this.isArA(nb) || !this.isRCH(nb)) continue;
            this.acidicCarbon = nb;
            return true;
        }
        return false;
    }

    private boolean getAliNHAcidDelocState(int atom, int aType) {
        if (this.pkaBasicType[atom][0] == 5) {
            this.pkaAcidType[atom][0] = 33;
            this.pkaAcidType[atom][5] = aType;
            this.pkaAcidType[atom][7] = 1;
            if (this.pg.getGroupProperty()[atom] == 3200) {
                this.pkaAcidType[atom][7] = 3;
            }
            return true;
        }
        if (this.pkaBasicType[atom][0] == 3) {
            this.pkaAcidType[atom][0] = 33;
            this.pkaAcidType[atom][5] = aType;
            this.pkaAcidType[atom][7] = 2;
            return true;
        }
        if (this.pkaBasicType[atom][3] == 1 || this.pkaBasicType[atom][3] == 2 || this.pkaBasicType[atom][3] == 3) {
            this.pkaAcidType[atom][0] = 30;
            this.pkaAcidType[atom][5] = aType;
            if (this.pkaBasicType[atom][1] == 20) {
                this.pkaAcidType[atom][7] = 20;
            } else if (this.pkaBasicType[atom][1] == 25) {
                this.pkaAcidType[atom][7] = 25;
            }
            return true;
        }
        return false;
    }

    private boolean isCHAcidNbType(int a, int rIndx, boolean semiAra) {
        if (rIndx == -1) {
            return false;
        }
        int L = 0;
        L = !semiAra ? this.aAtoms[rIndx].length : this.nonAring[rIndx].length;
        for (int i = 0; i < L; ++i) {
            int ra = !semiAra ? this.aAtoms[rIndx][i] : this.nonAring[rIndx][i];
            for (int j = 0; j < this.cHtab[ra].length; ++j) {
                int nb = this.cHtab[ra][j];
                if (nb >= this.mol.getAtomCount() || this.isArA(nb) || this.getAtno(nb) != 6 || this.pkaAcidType[nb][0] < 0 || this.pkaAcidType[nb][0] == 520) continue;
                return true;
            }
        }
        return false;
    }

    private boolean getNHAcidDelocState(int atom, int aType) {
        int rIdx;
        int info;
        int crossAtom;
        int ketoCarbon;
        int nb;
        int sizenb;
        int i;
        this.pkaAcidType[atom][5] = aType;
        int aAroma = -1;
        int bAroma = -1;
        int ac = 0;
        int typeHydroxamic = 0;
        boolean anyVinil = false;
        boolean hydrazo = false;
        if (this.isArA(atom)) {
            int ri;
            this.pkaAcidType[atom][0] = 0;
            this.pkaAcidType[atom][8] = ri = this.charge.getRings().findSmallestAraRing(atom);
            if (this.isCHAcidNbType(atom, ri, false)) {
                this.pkaAcidType[atom][7] = 10;
            }
            return true;
        }
        int size = this.cHtab[atom].length;
        boolean alphaAromRoot = false;
        boolean betaAromRoot = false;
        for (i = 0; i < size; ++i) {
            if (!this.isArA(this.cHtab[atom][i])) continue;
            if (ac == 0) {
                alphaAromRoot = true;
                this.pkaAcidType[atom][1] = aAroma = this.cHtab[atom][i];
                ac = 1;
                continue;
            }
            ++ac;
        }
        if (alphaAromRoot) {
            int ketoCount = 0;
            boolean betaAromAtom = false;
            for (i = 0; i < size; ++i) {
                int ketoCarbon2;
                int nb2 = this.cHtab[atom][i];
                sizenb = this.isArA(nb2) ? 0 : this.cHtab[nb2].length;
                ketoCount = 0;
                for (int j = 0; j < sizenb; ++j) {
                    int nnb = this.cHtab[nb2][j];
                    if (!(nnb < this.mol.getAtomCount() & nnb != atom)) continue;
                    int bondOrder = this.getBondType(this.bHtab[nb2][nnb]);
                    if (this.isArA(nnb)) {
                        this.pkaAcidType[atom][2] = nnb;
                        betaAromAtom = true;
                    }
                    if (!(bondOrder > 1 & bondOrder < 4)) continue;
                    if (this.getAtno(nnb) == 16 || this.getAtno(nnb) == 8) {
                        ++ketoCount;
                        continue;
                    }
                    this.nVinilInfo[this.getNind((int)atom)][0] = nb2;
                    this.nVinilInfo[this.getNind((int)atom)][1] = nnb;
                    if (this.getAtno(nb2) == 7) {
                        hydrazo = true;
                    }
                    anyVinil = true;
                }
                if (ketoCount > 1) {
                    int crossAtom2;
                    this.pkaAcidType[atom][3] = crossAtom2 = nb2;
                    int[] rInfo = this.charge.findLargestRing(aAroma);
                    if (rInfo[1] == 1) {
                        this.pkaAcidType[atom][7] = 10;
                    }
                    if (betaAromAtom) {
                        this.pkaAcidType[atom][0] = 1;
                        return true;
                    }
                    this.pkaAcidType[atom][0] = 2;
                    return true;
                }
                if (ketoCount != true) continue;
                this.pkaAcidType[atom][4] = ketoCarbon2 = nb2;
                if (betaAromAtom) {
                    if (this.isThion(ketoCarbon2)) {
                        this.pkaAcidType[atom][0] = 23;
                        return true;
                    }
                    this.pkaAcidType[atom][0] = 3;
                    return true;
                }
                if (this.isThion(ketoCarbon2)) {
                    if (this.isDelocAbleRing(this.charge.getRings().getSmallestRingIndex(atom))) {
                        this.pkaAcidType[atom][7] = 100;
                        this.pkaAcidType[atom][0] = 22;
                        return true;
                    }
                    this.pkaAcidType[atom][0] = 22;
                    return true;
                }
                if (this.isDelocAbleRing(this.charge.getRings().getSmallestRingIndex(atom))) {
                    this.pkaAcidType[atom][7] = 100;
                    this.pkaAcidType[atom][0] = 4;
                    return true;
                }
                this.pkaAcidType[atom][0] = 4;
                return true;
            }
            if (ketoCount == 0) {
                if (ac == 2) {
                    this.pkaAcidType[atom][0] = 5;
                    return true;
                }
                if (ac == 1) {
                    int u;
                    int[] rInfo = this.charge.findLargestRing(aAroma);
                    if (rInfo[1] == 1) {
                        this.pkaAcidType[atom][7] = 10;
                    }
                    if ((u = this.isAraPyridone(atom)) != -1) {
                        this.pkaAcidType[atom][0] = 28;
                        if (u == 1) {
                            this.pkaAcidType[atom][7] = 10;
                        } else if (u == 2) {
                            this.pkaAcidType[atom][7] = 20;
                        }
                    } else {
                        this.pkaAcidType[atom][0] = 6;
                        if (anyVinil) {
                            this.pkaAcidType[atom][7] = hydrazo ? 200 : 20;
                        }
                    }
                    return true;
                }
            }
        }
        i = 0;
        int j = 0;
        int alphaAtom = 0;
        while (i < size & !betaAromRoot) {
            nb = this.cHtab[atom][i];
            sizenb = this.cHtab[nb].length;
            j = 0;
            while (j < sizenb & !betaAromRoot) {
                if (this.isArA(this.cHtab[nb][j])) {
                    alphaAtom = nb;
                    betaAromRoot = true;
                    this.pkaAcidType[atom][2] = bAroma = this.cHtab[nb][j];
                }
                ++j;
            }
            ++i;
        }
        if (betaAromRoot & this.delocAble[alphaAtom] == 1) {
            boolean alphaSO2 = false;
            boolean sideSO2 = false;
            boolean alphaKeto = false;
            boolean sideKeto = false;
            ketoCarbon = -1;
            for (i = 0; i < size; ++i) {
                nb = this.cHtab[atom][i];
                sizenb = this.cHtab[nb].length;
                int ketoCount = 0;
                for (j = 0; j < sizenb; ++j) {
                    int bondOrder;
                    int nnb = this.cHtab[nb][j];
                    if (!(nnb < this.mol.getAtomCount() & nnb != atom) || !((bondOrder = this.getBondType(this.bHtab[nb][nnb])) > 1 & bondOrder < 4) || this.getAtno(nnb) != 16 && this.getAtno(nnb) != 8) continue;
                    ++ketoCount;
                }
                if (ketoCount > 1) {
                    this.pkaAcidType[atom][3] = crossAtom = nb;
                    if (nb == alphaAtom) {
                        alphaSO2 = true;
                    } else {
                        sideSO2 = true;
                    }
                }
                if (ketoCount != true) continue;
                if (nb == alphaAtom) {
                    alphaKeto = true;
                    this.pkaAcidType[atom][4] = ketoCarbon = nb;
                    continue;
                }
                sideKeto = true;
            }
            if (alphaSO2) {
                if (this.isDelocAbleRing(this.charge.getRings().getSmallestRingIndex(atom))) {
                    this.pkaAcidType[atom][7] = 100;
                }
                if (bAroma != -1) {
                    this.pkaAcidType[atom][8] = this.charge.getRings().findSmallestAraRing(bAroma);
                }
                if (sideKeto) {
                    this.pkaAcidType[atom][0] = 7;
                    int[] rInfo = this.charge.findLargestRing(bAroma);
                    if (rInfo[1] == 1) {
                        this.pkaAcidType[atom][7] = this.pkaAcidType[atom][7] == 100 ? 20 : 10;
                    }
                    return true;
                }
                if (sideSO2) {
                    this.pkaAcidType[atom][0] = 8;
                    return true;
                }
                this.pkaAcidType[atom][0] = 9;
                return true;
            }
            if (alphaKeto) {
                int ridx = this.charge.getRings().getSmallestRingIndex(atom);
                if (this.isDelocAbleRing(ridx)) {
                    this.pkaAcidType[atom][7] = 100;
                }
                if (sideSO2) {
                    this.pkaAcidType[atom][0] = 10;
                    return true;
                }
                if (sideKeto) {
                    this.pkaAcidType[atom][0] = 11;
                    if (this.sAra[atom] == 1) {
                        this.pkaAcidType[atom][7] = this.nonAring[ridx].length == 5 || this.nonAring[ridx].length == 7 ? 70 : 80;
                        this.pkaAcidType[atom][8] = this.findNonAring(ridx, bAroma, atom);
                    }
                    return true;
                }
                if (this.isThion(this.pkaAcidType[atom][4])) {
                    this.pkaAcidType[atom][7] = 200;
                }
                this.pkaAcidType[atom][0] = 12;
                return true;
            }
        }
        boolean RSO2 = false;
        boolean RCO = false;
        boolean doubleRSO2 = false;
        boolean doubleRCO = false;
        boolean RCX = false;
        boolean RCN = false;
        int ketoCount = 0;
        int ketoS = 0;
        ketoCarbon = -1;
        for (i = 0; i < size; ++i) {
            nb = this.cHtab[atom][i];
            sizenb = this.cHtab[nb].length;
            ketoCount = 0;
            for (j = 0; j < sizenb; ++j) {
                int bondOrder;
                int nnb = this.cHtab[nb][j];
                if (!(nnb < this.mol.getAtomCount() & nnb != atom) || !((bondOrder = this.getBondType(this.bHtab[nb][nnb])) > 1 & bondOrder < 4)) continue;
                int atno = this.getAtno(nnb);
                if (atno == 16 || atno == 34 || atno == 52) {
                    ++ketoCount;
                    ++ketoS;
                    continue;
                }
                if (atno == 8) {
                    ++ketoCount;
                    continue;
                }
                if (atno == 6) {
                    RCX = true;
                    this.pkaAcidType[atom][6] = nb;
                    continue;
                }
                if (atno != 7) continue;
                RCN = true;
                this.pkaAcidType[atom][6] = nb;
            }
            if (ketoCount > 1) {
                this.pkaAcidType[atom][3] = crossAtom = nb;
                if (!RSO2) {
                    RSO2 = true;
                    continue;
                }
                doubleRSO2 = true;
                continue;
            }
            if (ketoCount != true) continue;
            if (!RCO) {
                RCO = true;
                this.pkaAcidType[atom][4] = ketoCarbon = nb;
                continue;
            }
            doubleRCO = true;
            this.pkaAcidType[atom][6] = nb;
        }
        if (RSO2) {
            if (RCO) {
                this.pkaAcidType[atom][0] = 13;
                return true;
            }
            if (doubleRSO2) {
                this.pkaAcidType[atom][0] = 14;
                return true;
            }
            this.pkaAcidType[atom][0] = 15;
            return true;
        }
        if (RCO) {
            int rInd;
            if (doubleRCO) {
                int barbType = this.getBarbital(atom);
                if (barbType == 1) {
                    this.pkaAcidType[atom][0] = 20;
                    return true;
                }
                if (this.isThion(this.pkaAcidType[atom][4]) || this.isThion(this.pkaAcidType[atom][6])) {
                    if (this.isDelocAbleRing(this.charge.getRings().getSmallestRingIndex(atom))) {
                        this.pkaAcidType[atom][7] = 100;
                        this.pkaAcidType[atom][0] = 25;
                        return true;
                    }
                    if (barbType == 2) {
                        this.pkaAcidType[atom][7] = 200;
                    }
                    this.pkaAcidType[atom][0] = 25;
                    return true;
                }
                int ri = this.charge.getRings().getSmallestRingIndex(atom);
                if (this.isDelocAbleRing(ri)) {
                    this.setRindex(ri);
                    this.pkaAcidType[atom][7] = this.isPolRing(ri) ? 100 : 600;
                    this.pkaAcidType[atom][0] = 16;
                    return true;
                }
                if (barbType == 2) {
                    this.pkaAcidType[atom][7] = 200;
                    this.pkaAcidType[atom][0] = 16;
                    this.setRindex(ri);
                    return true;
                }
                if (barbType == 3) {
                    this.pkaAcidType[atom][7] = 300;
                    this.pkaAcidType[atom][0] = 16;
                    this.setRindex(ri);
                    return true;
                }
                if (ri == -1) {
                    this.pkaAcidType[atom][7] = 400;
                    this.pkaAcidType[atom][0] = 16;
                    return true;
                }
                this.pkaAcidType[atom][0] = 16;
                return true;
            }
            if (RCX) {
                rInd = this.charge.getRings().getSmallestRingIndex(atom);
                if (this.isDelocAbleRing(rInd)) {
                    this.setRindex(rInd);
                    if (this.isCondensed(atom, rInd)) {
                        this.pkaAcidType[atom][7] = 200;
                        this.pkaAcidType[atom][0] = 26;
                        return true;
                    }
                    this.pkaAcidType[atom][7] = this.sAra[atom] == 1 ? (ketoS != 0 ? 125 : 120) : (this.isPolRing(rInd) ? 100 : 600);
                    this.pkaAcidType[atom][0] = 26;
                    return true;
                }
                if (this.pg.getGroupType()[atom] == 11 || this.pg.getGroupType()[atom] == 12) {
                    this.pkaAcidType[atom][7] = 300;
                }
                this.pkaAcidType[atom][0] = 26;
                return true;
            }
            if (RCN) {
                rInd = this.charge.getRings().getSmallestRingIndex(atom);
                if (this.isDelocAbleRing(rInd)) {
                    this.pkaAcidType[atom][7] = 500;
                    this.pkaAcidType[atom][0] = 16;
                }
                this.pkaAcidType[atom][0] = 16;
                return true;
            }
            typeHydroxamic = this.isHydroxamic(atom);
            if (typeHydroxamic == 1) {
                this.pkaAcidType[atom][0] = 18;
                return true;
            }
            if (typeHydroxamic == 2) {
                this.pkaAcidType[atom][0] = 21;
                return true;
            }
            if (this.isThion(ketoCarbon)) {
                this.pkaAcidType[atom][0] = 19;
                return true;
            }
            if ((this.pg.getCarboxy()[ketoCarbon] == 600 || this.pg.getCarboxy()[ketoCarbon] == 500) && this.isAraXCarbamoyl(ketoCarbon)) {
                this.pkaAcidType[atom][0] = 24;
                return true;
            }
            rInd = this.charge.getRings().getSmallestRingIndex(atom);
            if (this.isDelocAbleRing(rInd)) {
                this.pkaAcidType[atom][7] = 100;
                this.pkaAcidType[atom][8] = rInd;
            } else if (rInd != -1) {
                int yy = this.isSemiAraJoined(atom, rInd);
                if (yy != -1) {
                    this.pkaAcidType[atom][7] = 220;
                    this.pkaAcidType[atom][8] = yy;
                } else {
                    this.pkaAcidType[atom][7] = 200;
                }
            } else if (rInd == -1) {
                this.pkaAcidType[atom][7] = this.isTerminalCONH2(atom) ? 320 : 300;
            }
            this.pkaAcidType[atom][0] = 17;
            return true;
        }
        int z = this.isAliPyridone(atom);
        if (z != -1) {
            this.pkaAcidType[atom][0] = 27;
            if (z == 1) {
                this.pkaAcidType[atom][7] = 10;
            } else if (z == 2) {
                this.pkaAcidType[atom][7] = 20;
            }
            return true;
        }
        if (this.isInRing[atom] && ((info = this.charge.isSemiAromaticRing(rIdx = this.charge.getLargestRingIndex(atom))) == 100 || info == 200)) {
            this.pkaAcidType[atom][0] = 29;
            if (this.isCHAcidNbType(atom, rIdx, true)) {
                this.pkaAcidType[atom][7] = 21;
            }
            boolean stronger = this.isDelocAbleSideExist(rIdx, atom);
            if (this.getAza(atom) != -1) {
                this.pkaAcidType[atom][7] = 10;
                if (this.pg.getCarboxy()[this.getAza(atom)] == 500) {
                    this.pkaAcidType[atom][7] = 115;
                    if (stronger) {
                        this.pkaAcidType[atom][7] = 116;
                    }
                } else if (this.pg.getCarboxy()[atom] == 1500) {
                    this.pkaAcidType[atom][7] = 15;
                    if (stronger) {
                        this.pkaAcidType[atom][7] = 16;
                    }
                } else if (stronger) {
                    this.pkaAcidType[atom][7] = 11;
                }
            }
            return true;
        }
        int uu = this.isSemiAraNHR(atom);
        if (uu != -1) {
            aAroma = uu;
            this.pkaAcidType[atom][0] = 6;
            this.pkaAcidType[atom][1] = aAroma;
            this.pkaAcidType[atom][7] = 10;
            return true;
        }
        this.pkaAcidType[atom][0] = -2;
        return false;
    }

    private boolean isDelocAbleSideExist(int ri, int nh) {
        for (int i = 0; i < this.nonAring[ri].length; ++i) {
            int ra = this.nonAring[ri][i];
            for (int j = 0; j < this.cHtab[ra].length; ++j) {
                int nb = this.cHtab[ra][j];
                if (this.isTheSameRing(ri, nb) || this.getAtno(nb) != 6 || this.pg.getCarboxy()[nb] != 1 || this.isNbAtoms(nh, ra)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNbAtoms(int nh, int ra) {
        int c = 0;
        for (int i = 0; i < this.cHtab[ra].length; ++i) {
            int nb = this.cHtab[ra][i];
            if (nb >= this.mol.getAtomCount() || nb != nh) continue;
            ++c;
        }
        return c != 0;
    }

    private int isSemiAraJoined(int ai, int rInd) {
        int gi = this.pg.getGroupIndex()[ai];
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int uu;
            int nb = this.cHtab[ai][i];
            if (nb >= this.mol.getAtomCount() || this.pg.getGroupIndex()[nb] != gi || (uu = this.isSemiAraNbExist(nb, gi, rInd)) == -1) continue;
            return uu;
        }
        return -1;
    }

    private int isSemiAraNbExist(int ai, int gi, int rIndx) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int ind;
            int hh;
            int nb = this.cHtab[ai][i];
            if (nb >= this.mol.getAtomCount() || !this.isInRing[nb] || this.pg.getGroupIndex()[nb] == gi || (hh = this.charge.isSemiAromaticRing(ind = this.charge.getRings().getSmallestExclusiveRingIndex(nb, rIndx))) != 100 && hh != 200) continue;
            return ind;
        }
        return -1;
    }

    private boolean isTerminalCONH2(int ai) {
        int c = 0;
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.mol.getAtomCount() || this.pg.getCarboxy()[nb] != 200) continue;
            ++c;
        }
        return c <= true;
    }

    private int findNonAring(int rIdx, int bAroma, int aIndx) {
        int raIdx = this.charge.getRings().findSmallestAraRing(bAroma);
        int rSize = this.aAtoms[raIdx].length + this.nonAring[rIdx].length - 2;
        for (int i = 0; i < this.nonAring.length; ++i) {
            int c = 0;
            if (this.nonAring[i].length != rSize) continue;
            for (int j = 0; j < this.nonAring[i].length; ++j) {
                int ra = this.nonAring[i][j];
                if (ra == bAroma) {
                    ++c;
                    continue;
                }
                if (ra != aIndx) continue;
                ++c;
            }
            if (c != 2) continue;
            return i;
        }
        return -1;
    }

    private int isSemiAraNHR(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.mol.getAtomCount() || this.sAra[nb] != 1) continue;
            return nb;
        }
        return -1;
    }

    private int isAliPyridone(int atom) {
        if (this.pkaBasicType[atom][0] == 1000 && this.pkaBasicType[atom][1] == 25 && this.isInRing[atom]) {
            int ri = this.charge.getRings().getSmallestRingIndex(atom);
            int a = this.isKetoRing(ri);
            if (a == 1) {
                return 1;
            }
            if (a == 2) {
                return 2;
            }
        }
        return -1;
    }

    private int isAraPyridone(int atom) {
        if (this.pkaBasicType[atom][0] == 1 && this.isInRing[atom]) {
            int ri = this.charge.getRings().getSmallestRingIndex(atom);
            int a = this.isKetoRing(ri);
            if (a == 1) {
                return 1;
            }
            if (a == 2) {
                return 2;
            }
        }
        return -1;
    }

    private void setRindex(int rInd) {
        for (int i = 0; i < this.nonAring[rInd].length; ++i) {
            int ra = this.nonAring[rInd][i];
            this.pkaAcidType[ra][8] = rInd;
        }
    }

    private boolean isPolRing(int rIndex) {
        int polCount = 0;
        for (int i = 0; i < this.nonAring[rIndex].length; ++i) {
            int ra = this.nonAring[rIndex][i];
            if (this.pg.getCarboxy()[ra] != -1) continue;
            ++polCount;
        }
        return polCount >= 2;
    }

    private boolean isCondensed(int atom, int rInd) {
        int carbon = this.pkaAcidType[atom][6];
        for (int i = 0; i < this.cHtab[carbon].length; ++i) {
            int ri;
            int nb = this.cHtab[carbon][i];
            if (nb >= this.mol.getAtomCount() || nb == atom || (ri = this.charge.getRings().getSmallestRingIndex(nb)) == rInd || !this.isDelocAbleRing(ri)) continue;
            return true;
        }
        return false;
    }

    protected boolean isDelocAbleRing(int rIndex) {
        if (rIndex == -1) {
            return false;
        }
        int r = 0;
        for (int i = 0; i < this.nonAring[rIndex].length; ++i) {
            if (this.delocAble[this.nonAring[rIndex][i]] != 1) continue;
            ++r;
        }
        return r == this.nonAring[rIndex].length;
    }

    private boolean isPolarizedRing(int rIndex) {
        if (this.isDelocAbleRing(rIndex)) {
            for (int i = 0; i < this.nonAring[rIndex].length; ++i) {
                int tt = this.pg.getCarboxy()[this.nonAring[rIndex][i]];
                int a = this.nonAring[rIndex][i];
                if (tt == 1 || tt == 1200) {
                    return true;
                }
                if (tt != 200 && tt != 800 || this.getAtno(a) != 6 && this.getAtno(a) != 16) continue;
                return true;
            }
        }
        return false;
    }

    private int isKetoRing(int rIndex) {
        for (int i = 0; i < this.nonAring[rIndex].length; ++i) {
            if (this.pg.getCarboxy()[this.nonAring[rIndex][i]] == 1) {
                return 1;
            }
            if (this.pg.getCarboxy()[this.nonAring[rIndex][i]] != 1700) continue;
            return 2;
        }
        return -1;
    }

    private boolean isAraXCarbamoyl(int ketoCarbon) {
        for (int i = 0; i < this.cHtab[ketoCarbon].length; ++i) {
            int nb = this.cHtab[ketoCarbon][i];
            for (int j = 0; j < this.cHtab[nb].length; ++j) {
                if (!this.isArA(this.cHtab[nb][j])) continue;
                return true;
            }
        }
        return false;
    }

    private int getBarbital(int NH) {
        int rInd = this.charge.getRings().getSmallestRingIndex(NH);
        int ac = 0;
        int ch2 = 0;
        int size = 0;
        int n = 0;
        int c = 0;
        boolean any = false;
        if (rInd != -1) {
            size = this.nonAring[rInd].length;
            if (size <= 6) {
                for (int i = 0; i < size; ++i) {
                    int nb = this.nonAring[rInd][i];
                    if (this.pg.getCarboxy()[nb] == 200 || this.pg.getCarboxy()[nb] == 500) {
                        ++ac;
                        if (this.isNitrogen(nb)) {
                            ++n;
                            continue;
                        }
                        if (this.getAtno(nb) != 6) continue;
                        ++c;
                        continue;
                    }
                    if (this.pg.getCarboxy()[nb] != -1) continue;
                    any = true;
                    ch2 = nb;
                }
            }
            if (ac == 5 && size == 6) {
                if (any) {
                    if (this.isCH2(ch2) && c - n == 1) {
                        return 1;
                    }
                    return 2;
                }
                return 2;
            }
            if (ac <= 5 && size < 6) {
                return 3;
            }
        }
        return 0;
    }

    private boolean isCH2(int atom) {
        int hCount = 0;
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int nb = this.cHtab[atom][i];
            if (this.getAtno(nb) != 1) continue;
            ++hCount;
        }
        return hCount == 2;
    }

    private boolean isThion(int ketoCarbon) {
        int bondOrder = 0;
        for (int i = 0; i < this.cHtab[ketoCarbon].length; ++i) {
            int nb = this.cHtab[ketoCarbon][i];
            if (this.getAtno(nb) != 16 || (bondOrder = this.getBondType(this.bHtab[ketoCarbon][nb])) != 2) continue;
            return true;
        }
        return false;
    }

    private int isHydroxamic(int atom) {
        int nb1 = this.cHtab[atom][0];
        int nb2 = this.cHtab[atom][1];
        int ind = 0;
        if (nb1 < this.mol.getAtomCount()) {
            if (this.pg.getCarboxy()[nb1] == 900) {
                ind = 1;
                return ind;
            }
            if (this.pg.getCarboxy()[nb1] == 1000) {
                ind = 2;
                return ind;
            }
        }
        if (nb2 < this.mol.getAtomCount()) {
            if (this.pg.getCarboxy()[nb2] == 900) {
                ind = 1;
                return ind;
            }
            if (this.pg.getCarboxy()[nb2] == 1000) {
                ind = 2;
                return ind;
            }
        }
        return ind;
    }

    public double setAtomSphere(int atom, int shellCount, double dFact) {
        AtomPolarizabilityPKa atomPol = new AtomPolarizabilityPKa(this.charge);
        int MAXSPHERE = shellCount;
        int actAtom = atom;
        this.sphereSize = 0;
        int hCount = 0;
        int[] sAtom = new int[this.mol.getAtomCount()];
        this.sphere = new int[this.mol.getAtomCount()];
        for (int i = 0; i < this.mol.getAtomCount(); ++i) {
            this.sphere[i] = -1;
        }
        int distance = 1;
        boolean sChange = true;
        double hInc = 0.0;
        int i = 0;
        double sum11 = 0.0;
        while (distance < MAXSPHERE + 1 & sChange) {
            sChange = false;
            if (actAtom != -1) {
                int length = this.cHtab[actAtom].length;
                for (int j = 0; j < length; ++j) {
                    int sphereAtom = this.cHtab[actAtom][j];
                    if (sphereAtom < this.mol.getAtomCount()) {
                        if (!(sAtom[sphereAtom] == 0 & sphereAtom != atom)) continue;
                        sAtom[sphereAtom] = distance;
                        this.sphere[this.sphereSize] = sphereAtom;
                        ++this.sphereSize;
                        continue;
                    }
                    ++hCount;
                    hInc += 0.314 * Math.pow(dFact, distance - 1);
                }
            }
            if (this.sphere[i] != -1) {
                actAtom = this.sphere[i];
                distance = sAtom[actAtom] + 1;
                sChange = true;
            } else {
                sChange = false;
            }
            if (++i != this.mol.getAtomCount()) continue;
            sChange = false;
        }
        double sum1 = 0.0;
        double sum2 = 0.0;
        double[] res = new double[]{0.0, 0.0, 0.0};
        double apol = 0.0;
        this.atomCount = 0;
        this.hAraCount = 0;
        this.heteroInc = 0.0;
        for (i = 0; i < this.sphereSize; ++i) {
            int a = this.sphere[i];
            distance = sAtom[a];
            if (this.isArA(a)) {
                if (this.getAtno(a) == 8) {
                    ++this.hAraCount;
                    if (distance >= 4) {
                        this.heteroInc = 0.65;
                    }
                } else if (this.getAtno(a) == 16) {
                    ++this.hAraCount;
                    if (distance >= 4) {
                        this.heteroInc = 0.55;
                    }
                }
            } else if (this.isCH4likeCarbon(a)) {
                sum11 += 0.5 * Math.pow(dFact, distance - 1) * res[0];
            }
            res = atomPol.getPolarizabilityParameter(a);
            sum1 += Math.pow(dFact, distance - 1) * res[0];
            ++this.atomCount;
            sum2 += res[1];
        }
        double sum_1 = Math.pow(sum1 + hInc - sum11, 2.0);
        this.apol_C = 4.0 * sum_1 / (sum2 += (double)hCount);
        sum1 = Math.pow(sum1 + hInc, 2.0);
        apol = 4.0 * sum1 / sum2;
        return apol;
    }

    private boolean isCH4likeCarbon(int ai) {
        return this.getAtno(ai) == 6 && this.cHtab[ai].length == 4 && this.pg.getCarboxy()[ai] == -1 && this.isOnlyCHNbExist(ai);
    }

    private boolean isOnlyCHNbExist(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.mol.getAtomCount() || this.cHtab[nb].length == 4) continue;
            if (this.getAtno(nb) != 6) {
                return false;
            }
            return false;
        }
        return true;
    }

    public void setHBondTable() {
        boolean start = true;
        for (int i = 0; i < this.pkaAtomCount; ++i) {
            int abAtom;
            int atom = this.pkaActiveAtoms[i];
            int acidType1 = this.pkaAcidType[atom][0];
            if (this.pkaAcidType[atom][5] == 1) {
                if (acidType1 == 0 || acidType1 == 1) {
                    abAtom = acidType1 == 0 ? this.pkaAcidType[atom][1] : this.pkaAcidType[atom][2];
                    this.sethBond1(atom, abAtom, acidType1);
                    if (acidType1 == 0) {
                        this.setSimplePhenol(abAtom, atom);
                        this.setEsterHbond(atom, abAtom);
                        this.setArOHDelocalization(atom);
                        this.setParaMetaCorr(atom, abAtom);
                        this.setArOHBond(atom, abAtom);
                        this.setOrthoCorr(atom, abAtom);
                        if (this.pkaAcidType[atom][7] != 10) {
                            this.setAzaOHBond(atom);
                        }
                    }
                    if (acidType1 == 1) {
                        this.setOrthoEffect(atom, abAtom);
                        this.setParaMeataEffect(atom, abAtom);
                    }
                } else if (acidType1 == 15) {
                    this.setCarboxylCN(atom);
                }
                if (acidType1 == 8 || acidType1 == 15) {
                    this.getAtomDistances(atom, 10);
                    this.setAlphaAminInc(atom);
                    this.setHaloCorrection(atom);
                    continue;
                }
                if (acidType1 == 10) {
                    this.getAtomDistances(this.pkaAcidType[atom][3], 4);
                    this.setEWDeffect(atom);
                    continue;
                }
                if (acidType1 == 6) {
                    this.getAtomDistances(atom, 4);
                    this.setSO2Corr(atom);
                    continue;
                }
                if (acidType1 == 24) {
                    if (this.pkaAcidType[atom][7] != 10) continue;
                    int b = this.pkaAcidType[atom][4];
                    for (int g = 0; g < this.cHtab[b].length; ++g) {
                        int p = this.cHtab[b][g];
                        if (p >= this.mol.getAtomCount() || !this.isArA(p)) continue;
                        this.setPMOEffect(atom, p);
                    }
                    continue;
                }
                if (acidType1 != 13) continue;
                int alpha = this.pkaAcidType[atom][8];
                this.setVinilOHModifier(alpha, atom);
                continue;
            }
            if (this.pkaBasicType[atom][0] == 1000 && this.pKaType[i] == 1) {
                this.getAtomDistances(atom, 10);
                if (this.pkaBasicType[atom][3] == 3) {
                    this.setStericHidrance(atom);
                }
                if (this.isInRing[atom] && !this.isHeteroNbExist(atom)) {
                    this.setPyrrolidineInc(atom, this.pkaBasicType[atom][3]);
                }
                this.setAminCN(atom);
                if (!(this.mpk0[atom] > 4.0) || this.isAlphaAmineAcid()) continue;
                ++this.aliAminCount;
                continue;
            }
            if (this.pkaBasicType[atom][0] == 2000) {
                this.getAtomDistances(atom, 10);
                this.setAminCN(atom);
                continue;
            }
            if (this.pkaBasicType[atom][0] == 200) {
                if (!this.twoCNbExist(atom)) continue;
                this.getAtomDistances(atom, 3);
                int ri = this.charge.getRings().findSmallestAraRing(atom);
                this.setAzaInc(atom, ri);
                this.setSemiAraInc(atom, ri);
                continue;
            }
            if (this.pkaBasicType[atom][0] == 500 || this.pkaBasicType[atom][0] == 600) {
                this.getAtomDistances(atom, 5);
                if (this.pkaBasicType[atom][0] == 500) {
                    this.setHBond3(atom);
                }
                this.setHaloAndPyrazineInc(atom);
                this.setCyanoCorrection(atom);
                this.setDecreasedHyperConj(atom);
                continue;
            }
            if (this.pkaBasicType[atom][0] == 1) {
                this.setAminHCount(atom);
                for (int j = 0; j < this.cHtab[atom].length; ++j) {
                    if (!this.isArA(this.cHtab[atom][j])) continue;
                    abAtom = this.cHtab[atom][j];
                    this.setAnilinOrthoEffect(atom, abAtom, start);
                    start = false;
                    this.setAnilinParaEffect(atom, abAtom, this.pkaBasicType[atom][3]);
                }
                continue;
            }
            if (this.pkaAcidType[atom][5] == 2) {
                int rInd;
                if (this.pkaAcidType[atom][0] == 1) {
                    this.setOrthoMeta(atom);
                    continue;
                }
                if (this.pg.getCarboxy()[atom] == 500) {
                    if (this.isArA(atom)) continue;
                    this.setCarboAmidHBond(atom);
                    continue;
                }
                if (this.pkaAcidType[atom][0] == 0) {
                    this.getAtomDistances(atom, 3);
                    this.setAraNHNO2Inc(atom);
                    this.setArANHInc(atom);
                    this.setAraNInc(atom);
                    continue;
                }
                if (this.pkaAcidType[atom][0] == 17) {
                    int a = this.getKetoRoot(atom);
                    this.getAtomDistances(a, 10);
                    this.setCONHHaloCorrection(atom);
                    continue;
                }
                if (this.pkaAcidType[atom][0] == 15) {
                    int crossA = this.pkaAcidType[atom][3];
                    this.setImidlikeEffect(crossA, atom);
                    continue;
                }
                if (this.pkaAcidType[atom][0] == 16) {
                    this.getAtomDistances(atom, 10);
                    this.setCONHHaloCorrection(atom);
                    continue;
                }
                if (this.pkaAcidType[atom][0] == 29) {
                    if (this.pg.getCarboxy()[atom] != 1600) continue;
                    int n = atom;
                    this.cyanoInc[n] = this.cyanoInc[n] + 1.5;
                    continue;
                }
                if (this.pkaAcidType[atom][0] == 9) {
                    rInd = this.pkaAcidType[atom][8];
                    this.setHaloInc(rInd, atom);
                    continue;
                }
                if (this.pkaAcidType[atom][0] == 11) {
                    rInd = this.pkaAcidType[atom][8];
                    this.addHeteroRingInc(rInd, atom);
                    continue;
                }
                if (this.pkaAcidType[atom][0] != 27) continue;
                this.getAtomDistances(atom, 3);
                continue;
            }
            if (this.pkaBasicType[atom][0] == 3) {
                int y = this.pkaBasicType[atom][1];
                if (y == 1 || y == 2) {
                    this.setCHAcidCorrection(atom);
                    if (y == 1) {
                        this.getAtomDistances(atom, 5);
                        this.setAminCN(atom);
                    }
                } else if (y == 120 || y == 121 || y == 122) {
                    this.setOrthoAmidinInc(atom);
                    if (this.sAra[atom] == 1) {
                        this.getAtomDistances(atom, 4);
                        this.setCyanoCorrection(atom);
                    }
                } else if (this.sAra[atom] == 1) {
                    this.getAtomDistances(atom, 4);
                    this.setCyanoCorrection(atom);
                }
                if (!(this.mpk0[atom] > 4.0)) continue;
                this.getAtomDistances(atom, 2);
                if (this.isAlphaAmineAcid()) continue;
                ++this.aliAminCount;
                continue;
            }
            if (this.pkaBasicType[atom][0] == 5) {
                this.setHeteroAraCorr(atom);
                continue;
            }
            if (this.pkaAcidType[atom][5] != 4) continue;
            int rr = this.pkaAcidType[atom][0];
            if (rr == 67) {
                this.getAtomDistances(atom, 5);
                this.setCHAcidCorr(atom);
                continue;
            }
            if (rr == 3) {
                this.getAtomDistances(atom, 5);
                this.setCHAcidCorrection2(atom);
                continue;
            }
            if (rr == 69) {
                this.getAtomDistances(atom, 5);
                this.setCHAcidCorrection2(atom);
                continue;
            }
            if (rr != 520 || this.cHtab[atom].length != 4 || this.pkaAcidType[atom][7] != 40) continue;
            this.getDelIsland(atom, 5);
            this.setTauCHCorrection(atom);
        }
    }

    private void setTauCHCorrection(int atom) {
        double sum = 0.0;
        for (int i = 0; i < this.sphereSize; ++i) {
            int a = this.sphere[i];
            if (this.dist[a] != 3 || this.pg.getCarboxy()[a] == -1 || !this.isDBonded(a)) continue;
            if (this.pg.getCarboxy()[a] == 2) {
                sum += -7.0;
                continue;
            }
            if (this.pg.getCarboxy()[a] == 1) {
                sum += -7.0;
                continue;
            }
            if (this.pg.getCarboxy()[a] == 200) {
                sum += -7.0;
                continue;
            }
            if (this.pg.getCarboxy()[a] != 800) continue;
            sum += -7.0;
        }
        if (sum != 0.0) {
            int n = atom;
            this.cyanoInc[n] = this.cyanoInc[n] + (sum * 0.1122 - 12.58);
        }
    }

    private void setOrthoMeta(int ai) {
        int nb;
        int i;
        int alpha = -1;
        for (i = 0; i < this.cHtab[ai].length; ++i) {
            nb = this.cHtab[ai][i];
            if (nb >= this.mol.getAtomCount() || !this.isArA(nb)) continue;
            alpha = nb;
        }
        if (alpha != -1) {
            for (i = 0; i < this.cHtab[alpha].length; ++i) {
                nb = this.cHtab[alpha][i];
                if (nb >= this.mol.getAtomCount() || !this.isArA(nb)) continue;
                int type = this.getNbType(nb);
                if (type == 1400) {
                    int n = ai;
                    this.cyanoInc[n] = this.cyanoInc[n] + 1.7;
                    continue;
                }
                if (this.getAtno(nb) == 6 || type != 5) continue;
                int n = ai;
                this.cyanoInc[n] = this.cyanoInc[n] + 1.5;
            }
        }
    }

    private int getNbType(int ra) {
        for (int i = 0; i < this.cHtab[ra].length; ++i) {
            int rindx;
            int nb = this.cHtab[ra][i];
            if (nb >= this.mol.getAtomCount()) continue;
            if (this.pg.getCarboxy()[nb] == 1400) {
                return 1400;
            }
            if (!this.isArA(nb) || this.getAtno(nb) == 6 || this.pkaBasicType[nb][0] == 500 || this.heteroCount(rindx = this.charge.getRings().findSmallestAraRing(nb)) != 2) continue;
            return 5;
        }
        return -1;
    }

    private int heteroCount(int rind) {
        int c = 0;
        if (rind == -1) {
            return 0;
        }
        for (int i = 0; i < this.aAtoms[rind].length; ++i) {
            int ra = this.aAtoms[rind][i];
            if (this.getAtno(ra) == 6) continue;
            ++c;
        }
        return c;
    }

    private void setCHAcidCorrection2(int ai) {
        for (int i = 0; i < this.sphereSize; ++i) {
            int a = this.sphere[i];
            int d = this.dist[a];
            if (d <= 2 || !this.isDBonded(a)) continue;
            if (this.pg.getCarboxy()[a] == 2) {
                int n = ai;
                this.cyanoInc[n] = this.cyanoInc[n] + -0.5;
                continue;
            }
            if (this.pg.getCarboxy()[a] != 400) continue;
            int n = ai;
            this.cyanoInc[n] = this.cyanoInc[n] + -1.25;
        }
    }

    private void addHeteroRingInc(int rInd, int ai) {
        if (rInd == -1) {
            return;
        }
        for (int i = 0; i < this.nonAring[rInd].length; ++i) {
            int ra = this.nonAring[rInd][i];
            for (int j = 0; j < this.cHtab[ra].length; ++j) {
                int indx;
                int nb = this.cHtab[ra][j];
                if (nb >= this.mol.getAtomCount() || !this.isArA(nb) || !this.isArA(ra) || !this.isPyrroleNHExist(indx = this.charge.getRings().findSmallestAraRing(nb))) continue;
                int n = ai;
                this.cyanoInc[n] = this.cyanoInc[n] + 1.0;
                return;
            }
        }
    }

    private boolean isPyrroleNHExist(int indx) {
        if (indx == -1) {
            return false;
        }
        for (int i = 0; i < this.aAtoms[indx].length; ++i) {
            int ra = this.aAtoms[indx][i];
            if (this.pkaAcidType[ra][5] != 2) continue;
            return true;
        }
        return false;
    }

    private void setHaloInc(int rindx, int ai) {
        for (int i = 0; i < this.aAtoms[rindx].length; ++i) {
            int ra = this.aAtoms[rindx][i];
            for (int j = 0; j < this.cHtab[ra].length; ++j) {
                int nb = this.cHtab[ra][j];
                if (nb >= this.mol.getAtomCount() || this.pg.getCarboxy()[nb] != 1400) continue;
                int n = ai;
                this.cyanoInc[n] = this.cyanoInc[n] + -0.5;
            }
        }
    }

    private void setImidlikeEffect(int crossA, int ai) {
        for (int i = 0; i < this.cHtab[crossA].length; ++i) {
            int nb = this.cHtab[crossA][i];
            if (nb >= this.mol.getAtomCount()) continue;
            if (this.pg.getCarboxy()[nb] == 1700) {
                int n = ai;
                this.cyanoInc[n] = this.cyanoInc[n] + -1.0;
                continue;
            }
            if (this.pg.getCarboxy()[nb] != 1600 && this.pg.getCarboxy()[nb] != 1500) continue;
            int n = ai;
            this.cyanoInc[n] = this.cyanoInc[n] + -1.5;
        }
    }

    private void setAraNInc(int nh) {
        int ra;
        int i;
        int rIndx = this.charge.getRings().findSmallestAraRing(nh);
        int c = 0;
        for (i = 0; i < this.cHtab[nh].length; ++i) {
            int nb = this.cHtab[nh][i];
            if (nb >= this.mol.getAtomCount() || this.getAtno(nb) != 6) continue;
            ++c;
        }
        if (c != 2) {
            return;
        }
        c = 0;
        for (i = 0; i < this.aAtoms[rIndx].length; ++i) {
            ra = this.aAtoms[rIndx][i];
            if (this.getAtno(ra) == 6) continue;
            ++c;
        }
        if (c == 3) {
            int n = nh;
            this.cyanoInc[n] = this.cyanoInc[n] + 2.0;
        }
        if (this.aAtoms[rIndx].length > 5 && this.pg.getCarboxy()[nh] == -1) {
            rIndx = this.charge.getRings().getLargestAraRingIndex(nh);
            c = 0;
            for (i = 0; i < this.aAtoms[rIndx].length; ++i) {
                ra = this.aAtoms[rIndx][i];
                if (this.getAtno(ra) == 6) continue;
                ++c;
            }
            int n = nh;
            this.cyanoInc[n] = this.cyanoInc[n] + -1.27 * (double)c;
        }
    }

    private boolean twoCNbExist(int ai) {
        int c = 0;
        int f = 0;
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.mol.getAtomCount()) continue;
            if (this.getAtno(nb) == 6) {
                ++c;
                continue;
            }
            if (this.getAtno(nb) != 7 || this.cHtab[nb].length != 3 || !this.isArA(nb)) continue;
            ++f;
        }
        if (f != 0) {
            int n = ai;
            this.cyanoInc[n] = this.cyanoInc[n] + -0.7;
        }
        return c == 2;
    }

    private boolean isHExist(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb < this.mol.getAtomCount() && this.getAtno(nb) != 1) continue;
            return true;
        }
        return false;
    }

    private void setVinilOHModifier(int alpha, int atom) {
        for (int i = 0; i < this.cHtab[alpha].length; ++i) {
            int nb = this.cHtab[alpha][i];
            if (nb >= this.mol.getAtomCount()) continue;
            if (this.pg.getCarboxy()[nb] == 200) {
                int n = atom;
                this.cyanoInc[n] = this.cyanoInc[n] + -2.0;
                continue;
            }
            if (this.pg.getCarboxy()[nb] == 2) {
                if (this.mol.getBond(this.bHtab[alpha][nb]).getType() == 2) continue;
                if (this.isDBonded(nb)) {
                    int n = atom;
                    this.cyanoInc[n] = this.cyanoInc[n] + 4.0;
                    continue;
                }
                if (this.getAtno(nb) == 6) continue;
                int n = atom;
                this.cyanoInc[n] = this.cyanoInc[n] + -2.0;
                continue;
            }
            if (this.pg.getCarboxy()[nb] != 1) continue;
            int n = atom;
            this.cyanoInc[n] = this.cyanoInc[n] + 2.9;
        }
    }

    private void setEWDeffect(int atom) {
        for (int i = 0; i < this.sphereSize; ++i) {
            int a = this.sphere[i];
            if (this.dist[a] == 3) {
                if (this.pg.getCarboxy()[a] == 900) {
                    int n = atom;
                    this.cyanoInc[n] = this.cyanoInc[n] + 0.25;
                    continue;
                }
                if (this.pg.getCarboxy()[a] != 3 && this.pg.getCarboxy()[a] != 1000) continue;
                int n = atom;
                this.cyanoInc[n] = this.cyanoInc[n] + 0.25;
                continue;
            }
            if (this.dist[a] != 4) continue;
            if (this.pg.getCarboxy()[a] == 900) {
                int n = atom;
                this.cyanoInc[n] = this.cyanoInc[n] + 0.15;
                continue;
            }
            if (this.pg.getCarboxy()[a] != 3 && this.pg.getCarboxy()[a] != 1000) continue;
            int n = atom;
            this.cyanoInc[n] = this.cyanoInc[n] - 0.1;
        }
    }

    private boolean isHeteroNbExist(int atom) {
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int nb = this.cHtab[atom][i];
            if (nb >= this.mol.getAtomCount() || this.getAtno(nb) == 6) continue;
            return true;
        }
        return false;
    }

    private void setPyrrolidineInc(int atom, int type) {
        int size;
        int ri = this.charge.getRings().getSmallestRingIndex(atom);
        if (ri != -1 && ((size = this.nonAring[ri].length) == 5 || size == 4)) {
            if (type == 2) {
                int n = atom;
                this.cyanoInc[n] = this.cyanoInc[n] + 1.23;
            } else if (type == 3) {
                if (this.isCrossRingBond(atom) && this.charge.getRings().getMultiRingCount() > 1) {
                    int n = atom;
                    this.cyanoInc[n] = this.cyanoInc[n] + 1.5;
                } else {
                    int n = atom;
                    this.cyanoInc[n] = this.cyanoInc[n] + 0.6;
                }
            }
        }
    }

    private void setHaloAndPyrazineInc(int atom) {
        int i;
        int nb0;
        int a;
        int i2;
        int ri = this.charge.getRings().findSmallestAraRing(atom);
        int rindx = this.charge.getRings().getLargestAraRingIndex(atom);
        int rSize = this.aAtoms[ri].length;
        int nCount = 0;
        for (i2 = 0; i2 < rSize; ++i2) {
            if (this.getAtno(this.aAtoms[ri][i2]) != 7) continue;
            ++nCount;
        }
        if (nCount == 1 && rSize == 6) {
            for (i2 = 0; i2 < this.sphereSize; ++i2) {
                a = this.sphere[i2];
                if (this.pg.getCarboxy()[a] != 1400 || !this.isArA(nb0 = this.cHtab[a][0]) || !this.isTheSameAraRing(ri, nb0)) continue;
                int n = atom;
                this.cyanoInc[n] = this.cyanoInc[n] - 0.8;
            }
        }
        if (nCount == 2) {
            boolean pyrazine = false;
            for (i = 0; i < rSize; ++i) {
                int ra = this.aAtoms[ri][i];
                if (ra == atom || this.getAtno(ra) != 7 || this.dist[ra] != 3) continue;
                pyrazine = true;
            }
            if (pyrazine) {
                int riL = this.charge.getRings().getLargestAraRingIndex(atom);
                if (this.aAtoms[riL].length == 6) {
                    int n = atom;
                    this.cyanoInc[n] = this.cyanoInc[n] - 2.4;
                } else {
                    int n = atom;
                    this.cyanoInc[n] = this.cyanoInc[n] - 1.2;
                }
            }
        } else if (nCount == 3 && rSize == 6) {
            for (i = 0; i < rSize; ++i) {
                int ra = this.aAtoms[ri][i];
                for (int j = 0; j < this.cHtab[ra].length; ++j) {
                    int nb = this.cHtab[ra][j];
                    if (nb >= this.mol.getAtomCount() || this.getAtno(nb) != 7 || this.pkaBasicType[nb][0] != 1 || this.pkaBasicType[nb][1] != 11) continue;
                    int n = atom;
                    this.cyanoInc[n] = this.cyanoInc[n] + 0.6;
                }
            }
        }
        if (ri != rindx) {
            for (i2 = 0; i2 < this.sphereSize; ++i2) {
                a = this.sphere[i2];
                if (this.pg.getCarboxy()[a] != 1400 || !this.isArA(nb0 = this.cHtab[a][0]) || this.isTheSameAraRing(ri, nb0)) continue;
                int d = this.dist[nb0];
                if (d == 4) {
                    int n = atom;
                    this.cyanoInc[n] = this.cyanoInc[n] - 0.8;
                    continue;
                }
                int n = atom;
                this.cyanoInc[n] = this.cyanoInc[n] - 0.2;
            }
        }
    }

    private void setCHAcidCorr(int cH) {
        double sum = 0.0;
        for (int i = 0; i < this.sphereSize; ++i) {
            int a = this.sphere[i];
            int d = this.dist[a];
            int chg = this.atomArray[a].getCharge();
            if (this.pkaBasicType[a][0] != -1 && chg == 0) {
                if (this.mpk0[a] < 0.0) {
                    sum += -this.mpk0[a] / ((double)d * 10.0);
                    continue;
                }
                sum -= this.mpk0[a] / ((double)d * 5.0);
                continue;
            }
            if (this.atomArray[a].getCharge() <= 0) continue;
            sum += -10.0 / ((double)d * 4.0);
        }
        int n = cH;
        this.cyanoInc[n] = this.cyanoInc[n] + sum;
    }

    private void setHeteroAraCorr(int nitrogen) {
        this.getAtomDistances(nitrogen, 4);
        for (int i = 0; i < this.sphereSize; ++i) {
            int a = this.sphere[i];
            int chg = this.atomArray[a].getCharge();
            if (this.pkaBasicType[a][0] != 200 || chg != 0) continue;
            if (this.dist[a] == 4) {
                int n = nitrogen;
                this.cyanoInc[n] = this.cyanoInc[n] + 0.5;
                continue;
            }
            if (this.dist[a] != 3) continue;
            int n = nitrogen;
            this.cyanoInc[n] = this.cyanoInc[n] + 1.0;
        }
    }

    private void setSO2Corr(int oh) {
        for (int i = 0; i < this.sphereSize; ++i) {
            int a = this.sphere[i];
            if (this.pg.getCarboxy()[a] != 800 || this.getAtno(a) != 16) continue;
            if (this.dist[a] == 4) {
                int n = oh;
                this.cyanoInc[n] = this.cyanoInc[n] + -1.3;
                continue;
            }
            if (this.dist[a] != 3) continue;
            int n = oh;
            this.cyanoInc[n] = this.cyanoInc[n] + -2.0;
        }
    }

    private void setArANHInc(int araNH) {
        for (int i = 0; i < this.cHtab[araNH].length; ++i) {
            int nb = this.cHtab[araNH][i];
            if (nb >= this.mol.getAtomCount() || !this.isArA(nb)) continue;
            for (int j = 0; j < this.cHtab[nb].length; ++j) {
                int nnb = this.cHtab[nb][j];
                if (nnb >= this.mol.getAtomCount() || this.isArA(nnb) || this.getAtno(nnb) != 8) continue;
                int chg = this.atomArray[nnb].getCharge();
                if (this.pkaAcidType[nnb][0] != 0 || chg != 0) continue;
                int n = araNH;
                this.cyanoInc[n] = this.cyanoInc[n] + 2.2;
                int n2 = nnb;
                this.cyanoInc[n2] = this.cyanoInc[n2] + -2.2;
            }
        }
        int[] ringInfo = this.charge.findLargestRing(araNH);
        int y = ringInfo[4];
        if (y >= 4) {
            int n = araNH;
            this.cyanoInc[n] = this.cyanoInc[n] + -0.75;
        }
    }

    private void setAraNHNO2Inc(int nh) {
        for (int i = 0; i < this.sphereSize; ++i) {
            int ind;
            int y;
            int a = this.sphere[i];
            if (this.getAtno(a) == 7) {
                if (this.pg.getCarboxy()[a] == 1820) {
                    if (this.dist[a] == 3) {
                        int n = nh;
                        this.cyanoInc[n] = this.cyanoInc[n] + -0.9;
                        continue;
                    }
                    if (this.dist[a] != 2) continue;
                    int n = nh;
                    this.cyanoInc[n] = this.cyanoInc[n] + -0.9;
                    continue;
                }
                if (this.pg.getCarboxy()[a] == 1300) {
                    if (this.dist[a] != 3) continue;
                    int n = nh;
                    this.cyanoInc[n] = this.cyanoInc[n] + 1.5;
                    continue;
                }
                if (this.isArA(a)) {
                    int ind2;
                    int ind1;
                    if (this.dist[a] != 2 || (ind1 = this.charge.getRings().findSmallestAraRing(a)) == (ind2 = this.charge.getRings().findSmallestAraRing(nh))) continue;
                    this.HBT[this.hbtAIndex[nh]][10] = a;
                    int n = nh;
                    this.cyanoInc[n] = this.cyanoInc[n] + 2.5;
                    continue;
                }
                if (this.sAra[a] == 1) {
                    if (this.dist[a] != 2) continue;
                    this.HBT[this.hbtAIndex[nh]][10] = a;
                    int n = nh;
                    this.cyanoInc[n] = this.cyanoInc[n] + 3.0;
                    continue;
                }
                if (this.dist[a] != 2) continue;
                int chg = this.atomArray[a].getCharge();
                if (this.pkaBasicType[a][1] < 901 || this.pkaBasicType[a][1] > 905 || chg != 0) continue;
                int n = nh;
                this.cyanoInc[n] = this.cyanoInc[n] + 2.2;
                continue;
            }
            if (this.getAtno(a) == 16) {
                if (this.pg.getCarboxy()[a] != 800 || this.dist[a] != 3) continue;
                int n = nh;
                this.cyanoInc[n] = this.cyanoInc[n] + 2.0;
                continue;
            }
            if (this.getAtno(a) != 6) continue;
            if (this.pg.getCarboxy()[a] == 1 || this.pg.getCarboxy()[a] == 2) {
                if (this.dist[a] != 3) continue;
                if (this.pg.getGroupType()[a] == 18) {
                    int n = nh;
                    this.cyanoInc[n] = this.cyanoInc[n] + -2.5;
                    continue;
                }
                if (this.pg.getGroupType()[a] != 22) continue;
                int n = nh;
                this.cyanoInc[n] = this.cyanoInc[n] + -2.0;
                continue;
            }
            if (this.pg.getCarboxy()[a] == 200) {
                if (this.dist[a] == 3) {
                    if (this.pg.getGroupType()[a] == 11 || this.pg.getGroupType()[a] == 12) {
                        int n = nh;
                        this.cyanoInc[n] = this.cyanoInc[n] + -2.5;
                    } else if (this.isAcidCONH2(a)) {
                        int n = nh;
                        this.cyanoInc[n] = this.cyanoInc[n] + -1.0;
                    }
                    if (this.sAra[a] != 1) continue;
                    int n = nh;
                    this.cyanoInc[n] = this.cyanoInc[n] + 0.7;
                    continue;
                }
                if (this.dist[a] != 2 || this.sAra[a] != 1) continue;
                if (this.pg.getGroupProperty()[a] == 410) {
                    int n = nh;
                    this.cyanoInc[n] = this.cyanoInc[n] + -0.8;
                    continue;
                }
                int n = nh;
                this.cyanoInc[n] = this.cyanoInc[n] + 0.2;
                continue;
            }
            if (this.isArA(a) || !this.isInRing[a] || (y = this.charge.isSemiAromaticRing(ind = this.charge.getRings().getSmallestRingIndex(a))) != 100 && y != 200) continue;
            int n = nh;
            this.cyanoInc[n] = this.cyanoInc[n] - 0.8;
        }
    }

    private boolean isAcidCONH2(int ketoCarbon) {
        for (int i = 0; i < this.cHtab[ketoCarbon].length; ++i) {
            int nb = this.cHtab[ketoCarbon][i];
            if (nb >= this.mol.getAtomCount() || this.pkaAcidType[nb][5] != 2) continue;
            return true;
        }
        return false;
    }

    private void setOrthoAmidinInc(int atom) {
        int a;
        int alpha = this.pkaBasicType[atom][4];
        this.getAtomDistances(alpha, 2);
        for (int i = 0; i < this.sphereSize; ++i) {
            a = this.sphere[i];
            if (this.dist[a] != 2 || this.pg.getCarboxy()[a] != 1000 && this.pg.getCarboxy()[a] != 1100) continue;
            int n = atom;
            this.cyanoInc[n] = this.cyanoInc[n] + 1.35;
        }
        int common = this.pkaBasicType[atom][2];
        for (int i = 0; i < this.cHtab[common].length; ++i) {
            a = this.cHtab[common][i];
            if (a >= this.mol.getAtomCount() || this.pg.getCarboxy()[a] != 1000 && this.pg.getCarboxy()[a] != 1100 || this.getAtno(a) != 16) continue;
            int n = atom;
            this.cyanoInc[n] = this.cyanoInc[n] - 2.0;
        }
    }

    protected boolean isAlphaAmineAcid() {
        for (int i = 0; i < this.sphereSize; ++i) {
            int a = this.sphere[i];
            if (this.dist[a] != 2 || this.pg.getCarboxy()[a] != 300) continue;
            return true;
        }
        return false;
    }

    private void setArOHDelocalization(int oh) {
        this.getDelIsland(oh, 11);
        double sum = 0.0;
        int chg = 0;
        block5: for (int i = 0; i < this.sphereSize; ++i) {
            int a = this.sphere[i];
            int y = this.dist[a];
            chg = this.atomArray[a].getCharge();
            switch (y) {
                case 3: {
                    if (!this.isNitrogen(a)) continue block5;
                    if (this.pg.getCarboxy()[a] == 1300) {
                        sum += -0.15;
                        continue block5;
                    }
                    if (this.pg.getCarboxy()[a] != 1200) continue block5;
                    sum += 0.6;
                    continue block5;
                }
                case 5: 
                case 7: 
                case 9: 
                case 11: {
                    if (this.isNitrogen(a)) {
                        if (this.pg.getCarboxy()[a] == 1300) {
                            sum += 0.125 * (double)this.dist[a] - 1.625;
                            continue block5;
                        }
                        if (this.pg.getCarboxy()[a] == 100) {
                            sum += 0.125 * (double)this.dist[a] - 1.625;
                            continue block5;
                        }
                        if (chg != 0 || this.pkaBasicType[a][0] != 1 || this.pkaBasicType[a][1] != 901) continue block5;
                        sum += -0.5;
                        continue block5;
                    }
                    if (this.getAtno(a) != 6) continue block5;
                    if (this.pg.getCarboxy()[a] == 400) {
                        sum += 0.15 * (double)this.dist[a] - 1.9;
                        continue block5;
                    }
                    if (this.pg.getCarboxy()[a] != 1) continue block5;
                    sum += -0.4;
                    continue block5;
                }
                case 4: 
                case 6: 
                case 8: 
                case 10: {
                    if (this.getAtno(a) != 6 || this.pg.getCarboxy()[a] != 400) continue block5;
                    sum += 0.05556 * (double)this.dist[a] - 0.7222;
                }
            }
        }
        int n = oh;
        this.cyanoInc[n] = this.cyanoInc[n] + sum;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setCarboxylCN(int oh) {
        int b = this.pkaAcidType[oh][4];
        int alpha1 = this.pkaAcidType[oh][3];
        boolean find = false;
        int bb = -1;
        int carboxylType2 = -1;
        for (int i = 0; i < this.cHtab[b].length && !find; ++i) {
            int nb = this.cHtab[b][i];
            if (nb >= this.mol.getAtomCount() || nb == alpha1 || this.mol.getBond(this.bHtab[b][nb]).getType() < 2) continue;
            find = true;
            bb = nb;
        }
        if (find) {
            boolean hb1 = false;
            if (this.setArKetoHBond(b, oh)) {
                hb1 = true;
            }
            block19: for (int k = 0; k < this.cHtab[bb].length; ++k) {
                int alpha2 = this.cHtab[bb][k];
                if (alpha2 >= this.mol.getAtomCount() || alpha2 == b) continue;
                int ct = this.isInRing[alpha2] ? 2 : this.isCisorTrans(alpha1, b, bb, alpha2);
                if (this.pg.getCarboxy()[alpha2] != -1) {
                    switch (this.pg.getCarboxy()[alpha2]) {
                        case 2: {
                            if (ct == 2) {
                                int n = oh;
                                this.cyanoInc[n] = this.cyanoInc[n] + -0.75;
                                break;
                            }
                            int n = oh;
                            this.cyanoInc[n] = this.cyanoInc[n] + -1.15;
                            break;
                        }
                        case 100: {
                            if (ct == 2) {
                                int n = oh;
                                this.cyanoInc[n] = this.cyanoInc[n] + -0.75;
                                break;
                            }
                            int n = oh;
                            this.cyanoInc[n] = this.cyanoInc[n] + -1.0;
                            break;
                        }
                        case 1: {
                            if (ct == 2) {
                                int n = oh;
                                this.cyanoInc[n] = this.cyanoInc[n] + -0.7;
                                break;
                            }
                            int n = oh;
                            this.cyanoInc[n] = this.cyanoInc[n] + -1.1;
                            break;
                        }
                        case 400: {
                            if (ct == 2) {
                                int n = oh;
                                this.cyanoInc[n] = this.cyanoInc[n] + -0.7;
                                break;
                            }
                            int n = oh;
                            this.cyanoInc[n] = this.cyanoInc[n] + -0.95;
                            break;
                        }
                        case 200: {
                            if (ct == 2) {
                                int n = oh;
                                this.cyanoInc[n] = this.cyanoInc[n] + -0.6;
                                break;
                            }
                            int n = oh;
                            this.cyanoInc[n] = this.cyanoInc[n] + -0.85;
                            break;
                        }
                        case 500: {
                            if (ct == 2) {
                                int n = oh;
                                this.cyanoInc[n] = this.cyanoInc[n] + -0.7;
                                break;
                            }
                            int n = oh;
                            this.cyanoInc[n] = this.cyanoInc[n] + -0.95;
                            break;
                        }
                        case 1000: {
                            if (ct == 2) {
                                int n = oh;
                                this.cyanoInc[n] = this.cyanoInc[n] + 0.4;
                                break;
                            }
                            continue block19;
                        }
                        case 1100: {
                            if (ct != 2) continue block19;
                            int n = oh;
                            this.cyanoInc[n] = this.cyanoInc[n] + 0.4;
                            break;
                        }
                        case 600: {
                            if (ct == 2) {
                                int n = oh;
                                this.cyanoInc[n] = this.cyanoInc[n] + -0.4;
                                break;
                            }
                            int n = oh;
                            this.cyanoInc[n] = this.cyanoInc[n] + -0.6;
                            break;
                        }
                        case 700: {
                            if (ct == 2) {
                                int n = oh;
                                this.cyanoInc[n] = this.cyanoInc[n] + -0.7;
                                break;
                            }
                            int n = oh;
                            this.cyanoInc[n] = this.cyanoInc[n] + -0.9;
                            break;
                        }
                        case 1400: {
                            if (ct != 1) continue block19;
                            int n = oh;
                            this.cyanoInc[n] = this.cyanoInc[n] - 0.3;
                            break;
                        }
                        case 300: {
                            if (ct != 1) continue block19;
                            int oh2 = this.getCarboxylOH(alpha2);
                            carboxylType2 = this.pkaAcidType[oh2][0];
                            if (this.atomArray[oh2].getCharge() != 0) continue block19;
                            switch (carboxylType2) {
                                case 17: {
                                    break;
                                }
                                case 15: {
                                    int beta2 = this.pkaAcidType[oh2][4];
                                    boolean hb2 = false;
                                    if (this.setArKetoHBond(beta2, oh2)) {
                                        hb2 = true;
                                    }
                                    if (hb1 || hb2 || ct != 1) break;
                                    this.HBT[this.hbtAIndex[oh]][25] = oh2;
                                    this.HBT[this.hbtAIndex[oh2]][25] = oh;
                                    break;
                                }
                            }
                            break;
                        }
                    }
                    continue;
                }
                if (this.isArA(alpha2)) {
                    if (ct == 1) {
                        int n = oh;
                        this.cyanoInc[n] = this.cyanoInc[n] + -0.7;
                        continue;
                    }
                    if (ct != 2) continue;
                    int n = oh;
                    this.cyanoInc[n] = this.cyanoInc[n] + -0.2;
                    continue;
                }
                if (ct != 1) continue;
            }
        }
    }

    private int getCarboxylOH(int alpha) {
        for (int i = 0; i < this.mol.getAtomCount(); ++i) {
            if (this.pkaAcidType[i][3] != alpha) continue;
            return i;
        }
        return 0;
    }

    private int isCisorTrans(int a1, int a2, int a3, int a4) {
        if (this.mol.getStereo2(a1, a2, a3, a4) == 128) {
            return 1;
        }
        if (this.mol.getStereo2(a1, a2, a3, a4) == 64) {
            return 2;
        }
        return 0;
    }

    private void setCyanoCorrection(int nitrogen) {
        int ri = this.charge.getRings().findSmallestAraRing(nitrogen);
        int riL = this.charge.getRings().getLargestAraRingIndex(nitrogen);
        boolean semiArAN = false;
        if (this.pkaBasicType[nitrogen][0] == 3 && this.sAra[nitrogen] == 1) {
            semiArAN = true;
        }
        for (int i = 0; i < this.sphereSize; ++i) {
            int chg;
            int a = this.sphere[i];
            int d = this.dist[a];
            int t = this.pg.getCarboxy()[a];
            if (d == 5) {
                if (this.pkaBasicType[a][0] != 1000 || this.pkaBasicType[a][3] == 3) continue;
                int n = nitrogen;
                this.cyanoInc[n] = this.cyanoInc[n] - 0.8;
                continue;
            }
            if (d == 3 || d == 4) {
                int m;
                t = this.pg.getCarboxy()[a];
                boolean commonRing = false;
                boolean commonLRing = false;
                if (this.pkaAcidType[a][5] == 2 && d == 3 && this.pkaAcidType[a][0] == 6 && !this.isTheSameAraRing(ri, this.pkaAcidType[a][4])) {
                    double g = this.getBondCharge2(a);
                    int n = nitrogen;
                    this.cyanoInc[n] = this.cyanoInc[n] + (-5.6 * g - 0.78);
                }
                if (t == 400 || t == 1300 || t == 2 && d == 4) {
                    for (m = 0; !commonRing && m < this.cHtab[a].length; ++m) {
                        if (!this.isArA(this.cHtab[a][m])) continue;
                        if (this.isTheSameAraRing(ri, this.cHtab[a][m])) {
                            commonRing = true;
                        }
                        if (!this.isTheSameAraRing(riL, this.cHtab[a][m])) continue;
                        commonLRing = true;
                    }
                    if (t == 400 && commonRing) {
                        int n = nitrogen;
                        this.cyanoInc[n] = this.cyanoInc[n] + -2.0;
                    } else if (t == 1300 && commonRing) {
                        if (this.dist[a] == 3) {
                            int n = nitrogen;
                            this.cyanoInc[n] = this.cyanoInc[n] + -1.3;
                        }
                    } else if (t == 2 && commonRing) {
                        int n = nitrogen;
                        this.cyanoInc[n] = this.cyanoInc[n] + 1.0;
                    } else if (t == 2 && commonLRing) {
                        int n = nitrogen;
                        this.cyanoInc[n] = this.cyanoInc[n] + 1.0;
                    }
                }
                if (this.getAtno(a) == 8) {
                    if (this.pkaAcidType[a][0] == 0 && this.dist[a] == 3 && (chg = this.atomArray[a].getCharge()) == 0) {
                        if (this.pkaBasicType[nitrogen][0] == 500) {
                            int n = nitrogen;
                            this.cyanoInc[n] = this.cyanoInc[n] + 1.0;
                            if (this.pkaBasicType[nitrogen][1] == 122) {
                                int n2 = a;
                                this.cyanoInc[n2] = this.cyanoInc[n2] + 0.7;
                            } else {
                                int n3 = a;
                                this.cyanoInc[n3] = this.cyanoInc[n3] + 0.4;
                            }
                        } else if (this.pkaBasicType[nitrogen][0] == 600) {
                            int n = nitrogen;
                            this.cyanoInc[n] = this.cyanoInc[n] + 0.4;
                            int n4 = a;
                            this.cyanoInc[n4] = this.cyanoInc[n4] + 1.5;
                        }
                    }
                    if (t != 1000 && t != 1100 || this.dist[a] != 3) continue;
                    commonRing = false;
                    for (m = 0; !commonRing && m < this.cHtab[a].length; ++m) {
                        if (!this.isArA(this.cHtab[a][m]) || !this.isTheSameAraRing(ri, this.cHtab[a][m])) continue;
                        commonRing = true;
                    }
                    if (!commonRing) continue;
                    int n = nitrogen;
                    this.cyanoInc[n] = this.cyanoInc[n] + 0.6;
                    continue;
                }
                if (this.getAtno(a) == 6) {
                    if (this.pkaAcidType[a][0] >= 0) {
                        chg = this.atomArray[a].getCharge();
                        if (chg != 0 || this.mpk0[a] == 0.0 || !(this.mpk0[a] < 11.0) || this.dist[a] != 4) continue;
                        int n = nitrogen;
                        this.cyanoInc[n] = this.cyanoInc[n] + -(-0.226 * this.mpk0[a] + 3.44);
                        continue;
                    }
                    if (this.cHtab[a].length == 2) {
                        if (d == 4) {
                            if (!this.isArA(this.cHtab[a][0]) && !this.isArA(this.cHtab[a][1])) continue;
                            int n = nitrogen;
                            this.cyanoInc[n] = this.cyanoInc[n] + -1.1;
                            continue;
                        }
                        if (d != 3 || !this.isArA(this.cHtab[a][0]) && !this.isArA(this.cHtab[a][1])) continue;
                        int n = nitrogen;
                        this.cyanoInc[n] = this.cyanoInc[n] + -0.4;
                        continue;
                    }
                    if (!this.isArA(a) || d != 3) continue;
                    if (!this.isTheSameAraRing(ri, a)) {
                        if (!this.isBridgeExist(a)) continue;
                        int n = nitrogen;
                        this.cyanoInc[n] = this.cyanoInc[n] + -0.25;
                        continue;
                    }
                    if (!this.isPhAmideNbExist(a)) continue;
                    if (!this.isHExist(this.actAraNb)) {
                        int n = nitrogen;
                        this.cyanoInc[n] = this.cyanoInc[n] + -0.5;
                        continue;
                    }
                    if (this.pkaBasicType[nitrogen][0] != 500) continue;
                    int n = nitrogen;
                    this.cyanoInc[n] = this.cyanoInc[n] + 0.4;
                    continue;
                }
                if (this.getAtno(a) == 7) {
                    if (!this.isArA(a) || d != 3 || this.pkaBasicType[a][0] != 200 || (chg = this.atomArray[a].getCharge()) != 0) continue;
                    if (semiArAN) {
                        int n = nitrogen;
                        this.cyanoInc[n] = this.cyanoInc[n] + -3.0;
                        continue;
                    }
                    int n = nitrogen;
                    this.cyanoInc[n] = this.cyanoInc[n] + -1.5;
                    continue;
                }
                if (this.getAtno(a) != 16) continue;
                if (this.pg.getCarboxy()[a] == 1) {
                    if (this.dist[a] != 3) continue;
                    int n = nitrogen;
                    this.cyanoInc[n] = this.cyanoInc[n] + -2.0;
                    continue;
                }
                if (this.pg.getCarboxy()[a] != 800 || this.dist[a] != 3) continue;
                int n = nitrogen;
                this.cyanoInc[n] = this.cyanoInc[n] + -1.5;
                continue;
            }
            if (this.dist[a] != 2) continue;
            if (this.getAtno(a) == 6) {
                if (this.pg.getCarboxy()[a] != 1) continue;
                if (this.pg.getGroupProperty()[a] == 421) {
                    int n = nitrogen;
                    this.cyanoInc[n] = this.cyanoInc[n] + 2.1;
                    continue;
                }
                int n = nitrogen;
                this.cyanoInc[n] = this.cyanoInc[n] + 1.5;
                continue;
            }
            if (this.getAtno(a) == 7) {
                if (!semiArAN || !this.isArA(a) || (chg = this.atomArray[a].getCharge()) != 0 || this.pkaBasicType[a][0] != 200 && this.pkaBasicType[a][0] != 500 && this.pkaBasicType[a][0] != 600) continue;
                int n = nitrogen;
                this.cyanoInc[n] = this.cyanoInc[n] + -2.0;
                continue;
            }
            if (this.getAtno(a) != 16 || !this.isArA(a)) continue;
            int n = nitrogen;
            this.cyanoInc[n] = this.cyanoInc[n] + 1.0;
        }
    }

    private boolean isPhAmideNbExist(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.mol.getAtomCount() || this.pg.getCarboxy()[nb] != 500) continue;
            this.actAraNb = nb;
            return true;
        }
        return false;
    }

    private boolean isBridgeExist(int a) {
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int nb = this.cHtab[a][i];
            if (nb >= this.mol.getAtomCount() || this.isArA(nb)) continue;
            return true;
        }
        return false;
    }

    private int isCarbonAldehyde(int atom) {
        if (this.getAtno(atom) != 6) {
            return 0;
        }
        if (this.cHtab[atom].length != 3) {
            return 0;
        }
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int nb = this.cHtab[atom][i];
            if (nb < this.mol.getAtomCount()) {
                if (this.getAtno(nb) == 1) {
                    return 1;
                }
                if (this.getAtno(nb) != 6 || this.cHtab[nb].length != 4 || this.pg.getCarboxy()[nb] != -1) continue;
                return 2;
            }
            return 1;
        }
        return 0;
    }

    private void setArOHBond(int OH, int alpha) {
        boolean find = false;
        if (this.HBT[this.hbtAIndex[OH]][26] != -1) {
            return;
        }
        int ri = this.charge.getRings().findSmallestAraRing(alpha);
        int j = 0;
        int c = 0;
        for (int i = 0; !find && i < this.mol.getAtomCount(); ++i) {
            if (this.hconj[i] != 1 && this.pg.getCarboxy()[i] != 1100 || !this.isTwoFoldHyperConj(i) && this.pg.getCarboxy()[i] != 1100 || this.isInRing[i]) continue;
            this.getAtomDistances(i, 3);
            c = 0;
            for (j = 0; !find && j < this.sphereSize; ++j) {
                int a = this.sphere[j];
                if (this.dist[a] != 3) continue;
                int chg = this.atomArray[a].getCharge();
                if (this.pkaAcidType[a][0] == 0 && a != OH && chg == 0) {
                    int alpha2 = this.pkaAcidType[a][1];
                    int ri2 = this.charge.getRings().findSmallestAraRing(alpha2);
                    if (ri == ri2 || ++c != 2 || this.HBT[this.hbtAIndex[OH]][26] != -1 || this.HBT[this.hbtAIndex[a]][26] != -1) continue;
                    find = true;
                    this.HBT[this.hbtAIndex[OH]][26] = a;
                    this.HBT[this.hbtAIndex[a]][26] = OH;
                    continue;
                }
                if (a != OH || ++c != 2 || this.HBT[this.hbtAIndex[OH]][26] != -1 || this.HBT[this.hbtAIndex[a]][26] != -1) continue;
                find = true;
                this.HBT[this.hbtAIndex[OH]][26] = a;
                this.HBT[this.hbtAIndex[a]][26] = OH;
            }
        }
    }

    private boolean isTwoFoldHyperConj(int Carbon) {
        int c = 0;
        for (int i = 0; i < this.cHtab[Carbon].length; ++i) {
            int nb = this.cHtab[Carbon][i];
            if (nb >= this.mol.getAtomCount() || !this.isArA(nb)) continue;
            ++c;
        }
        return c == 2;
    }

    private void setAnilinParaEffect(int aniline, int alpha, int aat) {
        int hc = 3 - aat;
        int ri = this.charge.getRings().findSmallestAraRing(alpha);
        double sum = 0.0;
        int oNO2Count = 0;
        this.getAtomDistances(aniline, 5);
        for (int i = 0; i < this.sphereSize; ++i) {
            int chg;
            int a = this.sphere[i];
            int d = this.dist[a];
            if (d != 3 && d != 5 && d != 4) continue;
            boolean commonRing = false;
            int t = this.pg.getCarboxy()[a];
            if (t == 1300 || t == 400 || t == 900 || t == 1000 || t == 1100) {
                for (int m = 0; !commonRing && m < this.cHtab[a].length; ++m) {
                    if (!this.isArA(this.cHtab[a][m]) || !this.isTheSameAraRing(ri, this.cHtab[a][m])) continue;
                    commonRing = true;
                }
            }
            if (t == 1300 && commonRing) {
                if (hc == 2) {
                    if (this.dist[a] == 5) {
                        sum += -0.7;
                        continue;
                    }
                    if (this.dist[a] != 3) continue;
                    sum += ++oNO2Count == 1 ? -0.7 : -2.2;
                    continue;
                }
                if (hc == 1) {
                    if (this.dist[a] == 5) {
                        sum += -2.2;
                        continue;
                    }
                    if (this.dist[a] != 3) continue;
                    sum += ++oNO2Count == 1 ? -1.8 : 2.0;
                    continue;
                }
                if (hc != 0) continue;
                if (this.dist[a] == 5) {
                    sum += -1.5;
                    continue;
                }
                if (this.dist[a] != 3) continue;
                sum += ++oNO2Count == 1 ? 2.0 : 2.0;
                continue;
            }
            if (t == 400 && commonRing) {
                if (this.dist[a] == 5) {
                    sum += -1.5;
                    continue;
                }
                if (this.dist[a] != 4) continue;
                sum += -0.5;
                continue;
            }
            if (t == 900 && commonRing) {
                if (this.dist[a] != 5) continue;
                sum += 0.75;
                continue;
            }
            if (t == 1000 && commonRing) {
                if (this.dist[a] != 5) continue;
                sum += 0.45;
                continue;
            }
            if (t == 1100 && commonRing) {
                if (this.dist[a] != 5) continue;
                sum += 0.15;
                continue;
            }
            if (this.dist[a] == 4) {
                if (!this.isNitrogen(a)) continue;
                chg = this.atomArray[a].getCharge();
                if (this.pkaBasicType[a][0] != 1000 && this.pkaBasicType[a][0] != 5 || chg != 0) continue;
                sum += -0.5;
                continue;
            }
            if (this.dist[a] != 5) continue;
            chg = this.atomArray[a].getCharge();
            if (this.pkaAcidType[a][0] != 1 || this.pkaAcidType[a][5] != 1 || chg != 0) continue;
            int alphaAtom = this.pkaAcidType[a][2];
            commonRing = false;
            if (this.isArA(alphaAtom) && this.isTheSameAraRing(ri, alphaAtom)) {
                commonRing = true;
            }
            if (!commonRing) continue;
            sum += 0.5;
        }
        int n = aniline;
        this.cyanoInc[n] = this.cyanoInc[n] + sum;
    }

    private void setDecreasedHyperConj(int nitrogen) {
        int chg;
        int nb;
        int j;
        int ra;
        int i;
        int ri;
        int[] ringInfo = this.charge.findLargestRing(nitrogen);
        int an = 0;
        int metaN = 0;
        int Quinoline = 122;
        int Acridine = 600;
        if (ringInfo[2] >= 2) {
            ri = ringInfo[0];
            for (i = 0; i < this.aAtoms[ri].length; ++i) {
                ra = this.aAtoms[ri][i];
                for (j = 0; j < this.cHtab[ra].length; ++j) {
                    nb = this.cHtab[ra][j];
                    if (nb >= this.mol.getAtomCount()) continue;
                    chg = this.atomArray[nb].getCharge();
                    if (this.hconj[nb] == 1) {
                        if (ringInfo[2] > 2) continue;
                        int n = nitrogen;
                        this.cyanoInc[n] = this.cyanoInc[n] + -0.4;
                        continue;
                    }
                    if (chg != 0 || this.pkaBasicType[nb][0] != 1 || !this.isOrthoNH2(ra, nb)) continue;
                    ++an;
                }
            }
            if (an > 2 && ringInfo[2] == 2) {
                int n = nitrogen;
                this.cyanoInc[n] = this.cyanoInc[n] + -2.2;
            }
        } else if (ringInfo[2] == 1) {
            ri = ringInfo[0];
            for (i = 0; i < this.aAtoms[ri].length; ++i) {
                ra = this.aAtoms[ri][i];
                for (j = 0; j < this.cHtab[ra].length; ++j) {
                    nb = this.cHtab[ra][j];
                    if (nb >= this.mol.getAtomCount() || this.hconj[nb] != 1) continue;
                    if (this.dist[nb] == 2 || this.dist[nb] == 4) {
                        int n = nitrogen;
                        this.cyanoInc[n] = this.cyanoInc[n] + -0.32;
                        continue;
                    }
                    if (this.dist[nb] != 3) continue;
                    int n = nitrogen;
                    this.cyanoInc[n] = this.cyanoInc[n] + 0.21;
                }
            }
        }
        if ((this.pkaBasicType[nitrogen][1] == Quinoline || this.pkaBasicType[nitrogen][0] == Acridine) && ringInfo[2] >= 1) {
            ri = ringInfo[0];
            this.getAtomDistances(nitrogen, 3);
            for (i = 0; i < this.aAtoms[ri].length; ++i) {
                ra = this.aAtoms[ri][i];
                for (j = 0; j < this.cHtab[ra].length; ++j) {
                    nb = this.cHtab[ra][j];
                    if (nb >= this.mol.getAtomCount() || this.dist[nb] != 3) continue;
                    for (int k = 0; k < this.mol.getAtomCount(); ++k) {
                        int ri2;
                        chg = this.atomArray[k].getCharge();
                        if (chg != 0 || this.pkaBasicType[k][0] != 1 || this.pkaBasicType[k][4] != nb || (ri2 = (ringInfo = this.charge.findLargestRing(nb))[0]) == ri) continue;
                        ++metaN;
                    }
                }
            }
        }
        if (metaN != 0) {
            int n = nitrogen;
            this.cyanoInc[n] = this.cyanoInc[n] + -1.4;
        }
    }

    private boolean isOrthoNH2(int ringArA, int nh2) {
        for (int i = 0; i < this.cHtab[ringArA].length; ++i) {
            int nb = this.cHtab[ringArA][i];
            if (nb >= this.mol.getAtomCount() || !this.isNitrogen(nb) || nb == nh2) continue;
            return true;
        }
        return false;
    }

    private void setCHAcidCorrection(int atom) {
        block6: for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int nb = this.cHtab[atom][i];
            if (nb >= this.mol.getAtomCount() || this.pkaAcidType[nb][5] != 4 || this.atomArray[nb].getCharge() != 0) continue;
            int CHType = this.pkaAcidType[nb][0];
            switch (CHType) {
                case 1: {
                    int n = atom;
                    this.cyanoInc[n] = this.cyanoInc[n] + -3.5;
                    continue block6;
                }
                case 11: {
                    int n = atom;
                    this.cyanoInc[n] = this.cyanoInc[n] + -4.5;
                    continue block6;
                }
                case 100: {
                    int n = atom;
                    this.cyanoInc[n] = this.cyanoInc[n] + -3.5;
                    continue block6;
                }
                case 101: {
                    int n = atom;
                    this.cyanoInc[n] = this.cyanoInc[n] + -4.5;
                }
            }
        }
    }

    private void setCarboAmidHBond(int nh) {
        int abAtom = this.pkaAcidType[nh][1];
        int rindx = -1;
        if (abAtom != -1) {
            rindx = this.charge.getRings().findSmallestAraRing(abAtom);
        }
        for (int i = 0; i < this.cHtab[abAtom].length; ++i) {
            int nb1 = this.cHtab[abAtom][i];
            if (nb1 == nh) continue;
            for (int j = 0; j < this.cHtab[nb1].length; ++j) {
                int nb2 = this.cHtab[nb1][j];
                if (nb2 >= this.mol.getAtomCount() || nb2 == abAtom) continue;
                if (this.isArA(nb2) && this.getAtno(nb2) == 7 && this.isTheSameAraRing(rindx, nb2)) {
                    int n = nh;
                    this.cyanoInc[n] = this.cyanoInc[n] + 0.75;
                }
                if (this.pg.getCarboxy()[nb2] != 200 && this.pg.getCarboxy()[nb2] != 300 && this.pg.getCarboxy()[nb2] != 1 && this.pg.getCarboxy()[nb2] != 2) continue;
                ++this.logPHBondCounter;
                if (this.pg.getCarboxy()[nb2] == 300) continue;
                int n = nh;
                this.cyanoInc[n] = this.cyanoInc[n] + 0.4;
            }
        }
    }

    private void setAminCN(int amine) {
        double sum = 0.0;
        int[] minDist = new int[3];
        boolean minArADist3 = false;
        boolean minArADist4 = false;
        boolean minArADist2 = false;
        int FCount = 0;
        int ClCount = 0;
        boolean[] usedGroup = new boolean[this.pg.getGCount()];
        int ri = -1;
        int ara2 = -1;
        int ara3 = -1;
        int ara4 = -1;
        for (int i = 0; i < this.pg.getGCount(); ++i) {
            usedGroup[i] = false;
        }
        if (this.isInRing[amine]) {
            ri = this.charge.getRings().getSmallestRingIndex(amine);
        }
        for (int i = 0; i < this.sphereSize; ++i) {
            int chg;
            int y;
            int a = this.sphere[i];
            if (this.pg.getCarboxy()[a] == 400) {
                int atno = this.getAtno(a);
                if (atno != 6) continue;
                if (this.dist[a] == 1) {
                    sum += -10.0;
                    continue;
                }
                if (this.dist[a] == 2) {
                    if (this.pkaBasicType[amine][0] == 3) {
                        sum += -3.0;
                        continue;
                    }
                    if (this.pkaBasicType[amine][3] != 3) continue;
                    sum += 1.0;
                    continue;
                }
                if (this.dist[a] == 3) {
                    if (this.pkaBasicType[amine][0] == 3) {
                        sum += -4.0;
                        continue;
                    }
                    sum += -1.55;
                    continue;
                }
                if (this.dist[a] == 4) {
                    if (this.pkaBasicType[amine][0] == 3) {
                        sum += -2.0;
                        continue;
                    }
                    sum += -0.7;
                    continue;
                }
                if (this.dist[a] <= 4 || this.pkaBasicType[amine][0] != 3) continue;
                sum += -5.0 / (double)this.dist[a];
                continue;
            }
            if (this.pg.getCarboxy()[a] == 2 || this.pg.getCarboxy()[a] == 600 || this.pg.getCarboxy()[a] == 700) {
                if (usedGroup[this.pg.getGroupIndex()[a]]) continue;
                minDist = this.findClosestGroupDist(a);
                if (this.pg.getGroupType()[a] == 20) {
                    int tt = this.pkaBasicType[amine][3];
                    if (tt == 1 || tt == 3) {
                        if (minDist[0] == 3) {
                            sum += 0.75;
                        } else if (minDist[0] == 2) {
                            sum += 1.5;
                        }
                        usedGroup[this.pg.getGroupIndex()[a]] = true;
                        continue;
                    }
                    if (tt != 2) continue;
                    if (minDist[0] == 3) {
                        sum += 0.75;
                    } else if (minDist[0] == 2) {
                        sum += 1.5;
                    }
                    usedGroup[this.pg.getGroupIndex()[a]] = true;
                    continue;
                }
                if (minDist[0] == 2) {
                    if (minDist[1] != 12 && minDist[1] != 14) continue;
                    if (this.pkaBasicType[amine][3] == 3) {
                        sum += 1.2;
                    }
                    usedGroup[this.pg.getGroupIndex()[a]] = true;
                    continue;
                }
                if (minDist[0] == 4) {
                    if (minDist[1] == 12) {
                        if ((this.pkaBasicType[amine][3] == 3 || this.pkaBasicType[amine][3] == 2) && this.isREster(a)) {
                            sum -= 0.7;
                        }
                        usedGroup[this.pg.getGroupIndex()[a]] = true;
                        continue;
                    }
                    if (minDist[1] != 14) continue;
                    sum += -0.3;
                    usedGroup[this.pg.getGroupIndex()[a]] = true;
                    continue;
                }
                if (minDist[0] != 3) continue;
                if (minDist[1] == 12) {
                    if (this.pkaBasicType[amine][3] == 1) {
                        sum -= 0.7;
                    } else if (this.pkaBasicType[amine][3] == 2) {
                        sum = this.pkaBasicType[amine][1] == 25 ? (sum += 2.5) : (this.pkaBasicType[amine][1] == 20 ? (sum += 1.5) : (this.isInRing[amine] ? (sum += -0.6) : (sum += -0.3)));
                    } else if (this.pkaBasicType[amine][3] == 3) {
                        if (this.pkaBasicType[amine][1] == 25) {
                            sum += 1.2;
                        } else if (this.pkaBasicType[amine][1] == 20) {
                            sum += 0.5;
                        } else if (this.isInRing[amine]) {
                            sum += -0.3;
                        }
                    }
                    usedGroup[this.pg.getGroupIndex()[a]] = true;
                    continue;
                }
                if (minDist[1] != 14) continue;
                double dd = this.pkaBasicType[amine][3] == 3 ? -0.3 : -0.5;
                usedGroup[this.pg.getGroupIndex()[a]] = true;
                y = minDist[2];
                if (ri != -1 && y != -1 && this.isInRing[y] && this.isTheSameRing(ri, y) && this.pkaBasicType[amine][3] == 2) {
                    dd = -1.0;
                }
                sum += dd;
                continue;
            }
            if (this.pg.getCarboxy()[a] == 200 || this.pg.getCarboxy()[a] == 500) {
                if (usedGroup[this.pg.getGroupIndex()[a]]) continue;
                minDist = this.findClosestGroupDist(a);
                if (minDist[0] >= 2 && minDist[0] <= 4) {
                    if (minDist[1] == 12) {
                        if (this.pkaBasicType[amine][3] == 3) {
                            sum = minDist[0] == 3 ? (sum += 0.0) : (minDist[0] == 2 ? (this.pg.getCarboxy()[a] == 500 ? (sum += 1.2) : (sum += 1.3)) : (sum += -0.2));
                            usedGroup[this.pg.getGroupIndex()[a]] = true;
                        } else if (this.pkaBasicType[amine][3] == 2) {
                            sum = minDist[0] == 3 ? (sum += -0.4) : (minDist[0] == 2 ? (sum += 1.64) : (sum += -0.2));
                            usedGroup[this.pg.getGroupIndex()[a]] = true;
                        } else if (this.pkaBasicType[amine][3] == 1) {
                            if (this.pg.getGroupProperty()[a] == 410) {
                                sum = minDist[0] == 2 ? (sum += -1.2) : (minDist[0] == 3 ? (sum += -0.5) : (sum += -0.1));
                                usedGroup[this.pg.getGroupIndex()[a]] = true;
                            } else if (this.pg.getGroupProperty()[a] == 409) {
                                sum = minDist[0] == 3 ? (sum += -0.9) : (minDist[0] == 2 ? (sum += 0.5) : (sum += -0.2));
                                usedGroup[this.pg.getGroupIndex()[a]] = true;
                            }
                        }
                    } else if (minDist[1] == 14) {
                        if (this.pkaBasicType[amine][3] == 3) {
                            sum = minDist[0] == 3 ? (sum += -0.7) : (minDist[0] == 2 ? (sum += 0.3) : (minDist[0] == 4 ? (sum += -0.4) : (sum += -0.2)));
                            if (this.pg.getGroupProperty()[a] == 420) {
                                if (minDist[0] == 4) {
                                    sum += -0.6;
                                } else if (minDist[0] == 5) {
                                    sum += -0.3;
                                } else if (minDist[0] > 5) {
                                    sum += -0.2;
                                }
                            }
                            usedGroup[this.pg.getGroupIndex()[a]] = true;
                        } else if (this.pkaBasicType[amine][3] == 2) {
                            sum = minDist[0] == 3 ? (sum += -0.4) : (minDist[0] == 2 ? (sum += 0.95) : (sum += -0.2));
                            if (this.pg.getGroupProperty()[a] == 420) {
                                if (minDist[0] == 4) {
                                    sum += -0.3;
                                } else if (minDist[0] == 5) {
                                    sum += -0.25;
                                } else if (minDist[0] > 5) {
                                    sum += -0.2;
                                }
                            }
                            usedGroup[this.pg.getGroupIndex()[a]] = true;
                        } else if (this.pkaBasicType[amine][3] == 1) {
                            if (minDist[0] == 3) {
                                sum += -0.6;
                            } else if (minDist[0] == 4) {
                                sum += -0.4;
                            } else if (minDist[0] == 5) {
                                sum += -0.25;
                            } else if (minDist[0] > 5) {
                                sum += -0.2;
                            }
                            if (this.pg.getGroupProperty()[a] == 420) {
                                if (minDist[0] == 3) {
                                    sum += -0.25;
                                } else if (minDist[0] == 4) {
                                    sum += -0.4;
                                } else if (minDist[0] == 5) {
                                    sum += -0.3;
                                } else if (minDist[0] > 5) {
                                    sum += -0.2;
                                }
                            }
                            usedGroup[this.pg.getGroupIndex()[a]] = true;
                        }
                    }
                }
                if (minDist[0] == 5) {
                    if (this.sAra[a] != 1) {
                        sum += -0.3;
                    }
                    usedGroup[this.pg.getGroupIndex()[a]] = true;
                }
                if (!usedGroup[this.pg.getGroupIndex()[a]]) continue;
                y = minDist[2];
                if (ri == -1 || y == -1 || !this.isInRing[y] || !this.isTheSameRing(ri, y)) continue;
                if (this.pkaBasicType[amine][3] == 2) {
                    sum += -1.0;
                    continue;
                }
                sum += -0.2;
                continue;
            }
            if (this.pg.getCarboxy()[a] == 300) {
                if (this.dist[a] != 3 || this.pkaBasicType[amine][3] != 3 && this.pkaBasicType[amine][3] != 2) continue;
                sum -= 0.2;
                continue;
            }
            if (this.pg.getCarboxy()[a] == 1500 || this.pg.getCarboxy()[a] == 1600) {
                if (usedGroup[this.pg.getGroupIndex()[a]]) continue;
                minDist = this.findClosestGroupDist(a);
                if (minDist[0] == 2) {
                    if (this.pg.getCarboxy()[amine] != -1) continue;
                    if (!this.isDBBondedAtom(minDist[2])) {
                        sum += -1.0;
                    } else if (this.pkaBasicType[amine][3] == 1) {
                        sum += 0.6;
                    } else if (this.pkaBasicType[amine][3] == 3) {
                        sum += 1.6;
                    } else if (this.pkaBasicType[amine][3] == 2) {
                        sum += 1.7;
                    }
                    usedGroup[this.pg.getGroupIndex()[a]] = true;
                    continue;
                }
                if (minDist[0] == 3) {
                    double dd = 0.0;
                    if (this.pkaBasicType[amine][3] == 1) {
                        dd = -1.3;
                    } else if (this.pkaBasicType[amine][3] == 3) {
                        dd = -0.6;
                    } else if (this.pkaBasicType[amine][3] == 2) {
                        dd = -0.7;
                    }
                    if (!this.isInRing[amine]) {
                        sum += dd;
                    }
                    usedGroup[this.pg.getGroupIndex()[a]] = true;
                    int[] nArray = this.HBT[this.hbtAIndex[amine]];
                    nArray[23] = nArray[23] + 1;
                    continue;
                }
                if (minDist[0] == 4) {
                    if (!this.isInRing[amine]) {
                        sum += -0.6;
                    }
                    usedGroup[this.pg.getGroupIndex()[a]] = true;
                    int[] nArray = this.HBT[this.hbtAIndex[amine]];
                    nArray[23] = nArray[23] + 1;
                    continue;
                }
                if (minDist[0] != 5) continue;
                if (!this.isInRing[amine]) {
                    sum += -0.3;
                }
                usedGroup[this.pg.getGroupIndex()[a]] = true;
                int[] nArray = this.HBT[this.hbtAIndex[amine]];
                nArray[23] = nArray[23] + 1;
                continue;
            }
            if (this.pg.getCarboxy()[a] == 900) {
                if (this.dist[a] == 2) {
                    int t;
                    if (this.getAtno(a) != 8) continue;
                    if (this.pkaBasicType[amine][3] == 1) {
                        sum += 3.0;
                        continue;
                    }
                    if (this.pkaBasicType[amine][3] == 2) {
                        t = this.pkaBasicType[amine][1];
                        if (t == 20 || t == 25) {
                            sum += 1.2;
                            continue;
                        }
                        sum += 3.9;
                        continue;
                    }
                    if (this.pkaBasicType[amine][3] != 3) continue;
                    t = this.pkaBasicType[amine][1];
                    if (t == 20 || t == 25) {
                        sum += 1.2;
                        continue;
                    }
                    sum += 3.9;
                    continue;
                }
                if (this.dist[a] == 3) {
                    if (this.getAtno(a) != 8) continue;
                    if (this.pkaBasicType[amine][3] == 1) {
                        sum += 0.3;
                        continue;
                    }
                    if (this.pkaBasicType[amine][3] == 2) {
                        sum += 0.5;
                        continue;
                    }
                    if (this.pkaBasicType[amine][3] != 3) continue;
                    sum += 0.6;
                    continue;
                }
                if (this.dist[a] == 4) {
                    if (this.getAtno(a) != 8) continue;
                    sum += -0.3;
                    continue;
                }
                if (this.dist[a] != 5 || this.getAtno(a) != 8) continue;
                sum += -0.3;
                continue;
            }
            if (this.pg.getCarboxy()[a] == 1000) {
                if (this.dist[a] == 2) {
                    if (this.getAtno(a) != 8) continue;
                    if (this.pkaBasicType[amine][3] == 1) {
                        sum += 2.5;
                        continue;
                    }
                    if (this.pkaBasicType[amine][3] == 2) {
                        sum += 3.5;
                        continue;
                    }
                    if (this.pkaBasicType[amine][3] != 3) continue;
                    if (this.isInRing[a]) {
                        sum += 2.9;
                        continue;
                    }
                    sum += 3.0;
                    continue;
                }
                if (this.dist[a] == 3) {
                    if (this.getAtno(a) != 8) continue;
                    if (this.pkaBasicType[amine][3] == 1) {
                        sum += 0.2;
                        continue;
                    }
                    if (this.pkaBasicType[amine][3] == 2) {
                        if (this.pg.getGroupType()[a] == 23) {
                            sum += 0.6;
                            continue;
                        }
                        sum += 0.4;
                        continue;
                    }
                    if (this.pkaBasicType[amine][3] != 3) continue;
                    if (this.isInRing[a]) {
                        if (this.pg.getGroupType()[a] == 23) {
                            sum += 0.4;
                            continue;
                        }
                        sum += 0.2;
                        continue;
                    }
                    if (this.pg.getGroupType()[a] == 23) {
                        sum += 0.7;
                        continue;
                    }
                    sum += 0.5;
                    continue;
                }
                if (this.dist[a] != 4 || this.getAtno(a) != 8) continue;
                if (this.pg.getGroupType()[a] == 23) {
                    sum += -0.2;
                }
                if (this.pkaBasicType[amine][0] != 3) continue;
                sum += 1.0;
                continue;
            }
            if (this.pg.getCarboxy()[a] == 1) {
                if (this.getAtno(a) != 8) continue;
                if (this.dist[a] == 4) {
                    if (this.pkaBasicType[amine][3] == 3) {
                        sum -= 0.7;
                    } else if (this.pkaBasicType[amine][3] == 1) {
                        sum -= 0.4;
                    } else if (this.pkaBasicType[amine][3] == 2) {
                        sum -= 0.3;
                    }
                } else if (this.dist[a] == 3) {
                    if (this.pkaBasicType[amine][3] == 1) {
                        sum += -0.3;
                    } else if (this.pkaBasicType[amine][3] == 2) {
                        sum += 0.7;
                    } else if (this.pkaBasicType[amine][3] == 3) {
                        sum += 0.5;
                    }
                } else if (this.dist[a] > 4) {
                    if (this.dist[a] == 5) {
                        if (this.pkaBasicType[amine][0] == 3) {
                            sum += -1.2;
                        } else if (this.pkaBasicType[amine][3] == 3) {
                            sum += -0.8;
                        } else if (this.pkaBasicType[amine][3] == 1) {
                            sum += -0.4;
                        } else if (this.pkaBasicType[amine][3] == 2) {
                            sum += -0.3;
                        }
                    } else if (this.pkaBasicType[amine][3] == 3) {
                        sum -= 0.7;
                    } else if (this.pkaBasicType[amine][3] == 1) {
                        sum -= 0.2;
                    } else if (this.pkaBasicType[amine][3] == 2) {
                        sum -= 0.1;
                    }
                }
                if (!this.isInRing[amine] || (y = this.isRingKeto(a)) == -1 || ri != y) continue;
                sum += -1.2;
                continue;
            }
            if (this.pg.getCarboxy()[a] == 1400) {
                if (this.dist[a] != 3) continue;
                if (this.pkaBasicType[amine][3] == 1) {
                    int atno = this.getAtno(a);
                    if (atno == 35 || atno == 53) {
                        int n = amine;
                        this.cyanoInc[n] = this.cyanoInc[n] + -0.5;
                        continue;
                    }
                    if (atno == 17) {
                        ++ClCount;
                        continue;
                    }
                    if (atno != 9) continue;
                    ++FCount;
                    continue;
                }
                if (this.pkaBasicType[amine][3] == 3) {
                    int atno = this.getAtno(a);
                    if (atno == 35 || atno == 53) {
                        int n = amine;
                        this.cyanoInc[n] = this.cyanoInc[n] + -0.3;
                        continue;
                    }
                    if (atno == 17) {
                        ++ClCount;
                        continue;
                    }
                    if (atno != 9) continue;
                    ++FCount;
                    continue;
                }
                if (this.dist[a] != 4) continue;
                if (this.pkaBasicType[amine][3] == 1) {
                    if (!this.isArAConnectHalogen(a)) continue;
                    sum += 0.28;
                    continue;
                }
                if (this.pkaBasicType[amine][3] == 2) {
                    if (!this.isArAConnectHalogen(a)) continue;
                    sum += 0.62;
                    continue;
                }
                if (this.pkaBasicType[amine][3] != 3 || !this.isArAConnectHalogen(a)) continue;
                sum += 1.02;
                continue;
            }
            if (this.isArA(a) || this.sAra[a] == 1) {
                if (this.dist[a] == 3) {
                    minArADist3 = true;
                    ara3 = a;
                } else if (this.dist[a] == 4) {
                    minArADist4 = true;
                    ara4 = a;
                } else if (this.dist[a] == 2) {
                    minArADist2 = true;
                    ara2 = a;
                }
                int protonCount = this.atomArray[a].getAtno();
                switch (protonCount) {
                    case 8: {
                        if (this.pkaBasicType[amine][3] == 3) {
                            if (this.dist[a] == 3) {
                                sum += 1.5;
                            }
                            if (this.dist[a] != 4) break;
                            sum += 0.5;
                            break;
                        }
                        if (this.pkaBasicType[amine][3] != 2) break;
                        if (this.dist[a] == 3) {
                            sum += 0.5;
                        }
                        if (this.dist[a] != 4) break;
                        sum += 0.1;
                        break;
                    }
                    case 16: 
                    case 34: 
                    case 52: {
                        if (this.pkaBasicType[amine][3] == 3) {
                            if (this.dist[a] == 3) {
                                sum += 0.75;
                            }
                            if (this.dist[a] != 4) break;
                            sum += 0.25;
                            break;
                        }
                        if (this.pkaBasicType[amine][3] != 2) break;
                        if (this.dist[a] == 3) {
                            sum += 0.3;
                        }
                        if (this.dist[a] != 4) break;
                        sum += 0.1;
                    }
                }
                continue;
            }
            if (this.sigmaAtomType[a] == 3) {
                if (this.pg.getCarboxy()[a] != 1840 || this.dist[a] != 2) continue;
                if (this.pkaBasicType[amine][3] == 3) {
                    sum += 2.0;
                    continue;
                }
                if (this.pkaBasicType[amine][3] == 2) {
                    sum += 1.7;
                    continue;
                }
                if (this.pkaBasicType[amine][3] != 1) continue;
                sum += 1.1;
                continue;
            }
            if (this.dist[a] == 4) {
                chg = this.atomArray[a].getCharge();
                if (chg != 0) continue;
                if (this.pkaBasicType[a][0] == 1) {
                    if (this.pkaBasicType[amine][3] == 3) {
                        sum += -0.3;
                    } else if (this.pkaBasicType[amine][3] == 1) {
                        sum += -0.35;
                    } else if (this.pkaBasicType[amine][3] == 2) {
                        sum += -0.25;
                    }
                    if (this.pkaBasicType[a][1] != 155) continue;
                    sum += -0.2;
                    continue;
                }
                if (this.pkaBasicType[a][0] != 1000 && this.pkaBasicType[a][0] != 5 && this.pkaBasicType[a][0] != 2000) continue;
                int[] nArray = this.HBT[this.hbtAIndex[amine]];
                nArray[23] = nArray[23] + 1;
                continue;
            }
            if (this.dist[a] == 3) {
                chg = this.atomArray[a].getCharge();
                if ((this.pkaBasicType[a][0] == 1000 || this.pkaBasicType[a][0] == 2000) && chg == 0) {
                    if (this.pkaBasicType[amine][3] == 3) {
                        int[] nArray = this.HBT[this.hbtAIndex[amine]];
                        nArray[27] = nArray[27] + 1;
                        continue;
                    }
                    if (this.pkaBasicType[amine][3] == 2) {
                        if (this.pkaBasicType[a][3] == 3) {
                            if (this.isInRing[amine] && this.isInRing[a]) {
                                if (!this.isTheSameRing(ri, a)) {
                                    int n = a;
                                    this.cyanoInc[n] = this.cyanoInc[n] + -0.5;
                                    continue;
                                }
                                int n = a;
                                this.cyanoInc[n] = this.cyanoInc[n] + 0.5;
                                continue;
                            }
                            int n = a;
                            this.cyanoInc[n] = this.cyanoInc[n] + -0.5;
                            continue;
                        }
                        if (this.pkaBasicType[a][3] != 2) continue;
                        if (!this.isInRing[a] || !this.isInRing[amine]) {
                            int[] nArray = this.HBT[this.hbtAIndex[amine]];
                            nArray[23] = nArray[23] + 1;
                            continue;
                        }
                        if (this.isTheSameRing(ri, a)) continue;
                        int[] nArray = this.HBT[this.hbtAIndex[amine]];
                        nArray[23] = nArray[23] + 1;
                        continue;
                    }
                    if (this.pkaBasicType[amine][3] != 1) continue;
                    int[] nArray = this.HBT[this.hbtAIndex[amine]];
                    nArray[23] = nArray[23] + 1;
                    continue;
                }
                if (this.sigmaAtomType[a] != 2 || !this.isRingEten(a, ri)) continue;
                if (this.pkaBasicType[amine][3] == 3) {
                    sum += -0.7;
                    continue;
                }
                if (this.pkaBasicType[amine][3] != 2) continue;
                sum += -0.4;
                continue;
            }
            if (this.dist[a] != 2) continue;
            if (this.isALiRingEten(a, ri)) {
                int n = amine;
                this.cyanoInc[n] = this.cyanoInc[n] + 0.5;
                continue;
            }
            if (this.isTertButylGroup(a)) {
                if (this.pkaBasicType[amine][3] == 3) {
                    sum += -0.45;
                    continue;
                }
                if (this.pkaBasicType[amine][3] == 1) {
                    sum += -0.35;
                    continue;
                }
                if (this.pkaBasicType[amine][3] != 2) continue;
                sum += -0.25;
                continue;
            }
            if (this.pkaBasicType[amine][1] != 20 && this.pkaBasicType[amine][1] != 25 || this.pkaBasicType[amine][0] != 1000 || this.pkaBasicType[a][0] != 1000) continue;
            sum += -2.4;
        }
        if (FCount > 2) {
            int n = amine;
            this.cyanoInc[n] = this.cyanoInc[n] + (double)(-FCount) * 0.3;
        }
        if (ClCount >= 2) {
            int n = amine;
            this.cyanoInc[n] = this.cyanoInc[n] + (double)(-ClCount) * 0.4;
        }
        if (this.pkaBasicType[amine][0] == 1000 || this.pkaBasicType[amine][0] == 2000) {
            if (this.isStrained(amine)) {
                sum += 0.0;
            } else if (this.isAlphaAmineAcid()) {
                sum += 0.15;
            } else if (minArADist2) {
                if (this.isPyrroleLike(ara2)) {
                    if (this.pkaBasicType[amine][3] == 3) {
                        sum += 2.3;
                    } else if (this.pkaBasicType[amine][3] == 2) {
                        sum += 1.9;
                    } else if (this.pkaBasicType[amine][3] == 1) {
                        sum += 1.2;
                    }
                } else {
                    sum += 0.0;
                }
            } else if (minArADist3) {
                if (this.pkaBasicType[amine][3] == 3) {
                    sum += -0.5;
                } else if (this.pkaBasicType[amine][3] == 2) {
                    sum += -0.35;
                } else if (this.pkaBasicType[amine][3] == 1) {
                    sum += -0.35;
                }
                if (this.isPyrroleLike(ara3)) {
                    sum += 0.5;
                }
            } else if (minArADist4) {
                if (this.pkaBasicType[amine][3] == 1) {
                    sum += -0.15;
                } else if (this.pkaBasicType[amine][3] == 3) {
                    sum += -0.2;
                } else if (this.pkaBasicType[amine][3] == 2) {
                    sum += -0.3;
                }
                if (this.isPyrroleLike(ara4)) {
                    sum += 0.3;
                }
            }
        }
        int n = amine;
        this.cyanoInc[n] = this.cyanoInc[n] + sum;
    }

    protected boolean isPyrroleLike(int ai) {
        return this.pkaBasicType[ai][0] == 250;
    }

    protected boolean isRingEten(int a, int ri) {
        if (ri == -1) {
            return false;
        }
        if (this.isArA(a)) {
            return false;
        }
        if (this.pg.getCarboxy()[a] != -1) {
            return false;
        }
        if (this.isInRing[a] && this.isTheSameRing(ri, a)) {
            for (int i = 0; i < this.cHtab[a].length; ++i) {
                int nb = this.cHtab[a][i];
                if (nb >= this.mol.getAtomCount() || this.getBondType(this.bHtab[a][nb]) != 2 || this.isTheSameRing(ri, nb)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isALiRingEten(int a, int ri) {
        if (ri == -1) {
            return false;
        }
        if (this.isArA(a)) {
            return false;
        }
        if (!this.isInRing[a]) {
            return false;
        }
        if (!this.isTheSameRing(ri, a)) {
            return false;
        }
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int nb = this.cHtab[a][i];
            if (nb >= this.mol.getAtomCount() || !this.isTheSameRing(ri, nb) || this.getBondType(this.bHtab[a][nb]) != 2 || this.pg.getCarboxy()[a] != -1 || this.pg.getCarboxy()[nb] != -1) continue;
            return true;
        }
        return false;
    }

    protected boolean isDBBondedAtom(int n) {
        if (n == -1) {
            return false;
        }
        for (int i = 0; i < this.cHtab[n].length; ++i) {
            int nb = this.cHtab[n][i];
            if (nb >= this.mol.getAtomCount() || this.getBondType(this.bHtab[n][nb]) != 2) continue;
            return true;
        }
        return false;
    }

    protected boolean isTheSameRing(int ri, int ai) {
        if (ri == -1) {
            return false;
        }
        for (int i = 0; i < this.nonAring[ri].length; ++i) {
            if (this.nonAring[ri][i] != ai) continue;
            return true;
        }
        return false;
    }

    protected boolean isTheSameAraRing(int ri, int ai) {
        if (ri == -1) {
            return false;
        }
        for (int i = 0; i < this.aAtoms[ri].length; ++i) {
            if (this.aAtoms[ri][i] != ai) continue;
            return true;
        }
        return false;
    }

    protected int isRingKeto(int a) {
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int nb = this.cHtab[a][i];
            if (nb >= this.mol.getAtomCount() || !this.isInRing[nb]) continue;
            return this.charge.getRings().getSmallestRingIndex(nb);
        }
        return -1;
    }

    protected boolean isTertButylGroup(int a) {
        if (this.pg.getCarboxy()[a] == -1 && this.getAtno(a) == 6 && this.cHtab[a].length == 4) {
            for (int i = 0; i < this.cHtab[a].length; ++i) {
                int nb = this.cHtab[a][i];
                if (nb < this.mol.getAtomCount()) {
                    if (this.getAtno(nb) != 6) {
                        return false;
                    }
                    if (this.pg.getCarboxy()[nb] == -1) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean isArAConnectHalogen(int atom) {
        return this.isArA(this.cHtab[atom][0]);
    }

    protected int[] findClosestGroupDist(int atom) {
        int[] info = new int[]{0, 0, -1};
        info[0] = this.dist[atom];
        if (this.getAtno(atom) == 6) {
            info[1] = 12;
        } else if (this.isNitrogen(atom)) {
            info[1] = 14;
        }
        if (this.isInRing[atom]) {
            info[2] = atom;
        }
        int gInd = this.pg.getGroupIndex()[atom];
        for (int w = 0; w < this.pg.getGroups()[gInd].length; ++w) {
            int a = this.pg.getGroups()[gInd][w];
            int atno = this.getAtno(a);
            if (atno == 8 || a == atom || this.dist[a] == 0 || this.dist[a] >= info[0]) continue;
            info[0] = this.dist[a];
            if (atno == 6) {
                info[1] = 12;
            } else if (atno == 7) {
                info[1] = 14;
            }
            info[2] = a;
        }
        return info;
    }

    protected boolean isREster(int carbon) {
        for (int i = 0; i < this.cHtab[carbon].length; ++i) {
            int nb = this.cHtab[carbon][i];
            if (nb >= this.mol.getAtomCount() || this.cHtab[nb].length != 2 || this.pg.getCarboxy()[nb] != 2 || this.dist[nb] != 3) continue;
            return false;
        }
        return true;
    }

    private void setAnilinOrthoEffect(int anil, int alphaAtom, boolean start) {
        for (int i = 0; i < this.cHtab[alphaAtom].length; ++i) {
            int nb1 = this.cHtab[alphaAtom][i];
            if (nb1 == anil) continue;
            for (int j = 0; j < this.cHtab[nb1].length; ++j) {
                int nb2 = this.cHtab[nb1][j];
                if (nb2 >= this.mol.getAtomCount() || nb2 == alphaAtom) continue;
                int chg = this.atomArray[nb2].getCharge();
                if (this.pkaBasicType[nb2][0] == 1 && chg == 0) {
                    int n = anil;
                    this.cyanoInc[n] = this.cyanoInc[n] + -0.6;
                    int n2 = nb2;
                    this.cyanoInc[n2] = this.cyanoInc[n2] + -0.6;
                } else if (this.pkaAcidType[nb2][0] == 0 && chg == 0) {
                    int n = anil;
                    this.cyanoInc[n] = this.cyanoInc[n] + 0.85;
                } else if (this.getAtno(nb2) != 16 && (this.pg.getCarboxy()[nb2] == 1000 || this.pg.getCarboxy()[nb2] == 900)) {
                    int n = anil;
                    this.cyanoInc[n] = this.cyanoInc[n] + 0.8;
                }
                if (this.isArA(nb2)) continue;
                if (this.getAtno(nb2) == 6 && this.cHtab[nb2].length == 4) {
                    int n = anil;
                    this.cyanoInc[n] = this.cyanoInc[n] + -0.5;
                }
                this.collectlogPHBond(nb2, anil);
            }
        }
    }

    private void setAminHCount(int amin) {
        for (int j = 0; j < this.cHtab[amin].length; ++j) {
            int nb = this.cHtab[amin][j];
            if (this.getAtno(nb) != 1) continue;
            int n = amin;
            this.hCount[n] = this.hCount[n] + 1;
        }
    }

    private void setHBond3(int ArN) {
        boolean pyrazineType = false;
        boolean pyrimidin = false;
        boolean etherInteraction = false;
        boolean tautomerN = false;
        boolean orthoTautomer = false;
        boolean SHtautomer = false;
        boolean SHInc = false;
        int esterCount = 0;
        int paraOH = -1;
        int ror = 0;
        int riN = this.charge.getRings().findSmallestAraRing(ArN);
        boolean qr = false;
        int Quinoline = 122;
        int Acridine = 600;
        if (this.pkaBasicType[ArN][1] == Quinoline || this.pkaBasicType[ArN][0] == Acridine) {
            qr = true;
        }
        for (int i = 0; i < this.sphereSize; ++i) {
            int baseType;
            int a = this.sphere[i];
            double chg = this.atomArray[a].getCharge();
            if (this.dist[a] == 5) {
                baseType = this.pkaBasicType[a][0];
                if (this.pg.getCarboxy()[a] == 1820) {
                    int n = ArN;
                    this.cyanoInc[n] = this.cyanoInc[n] + -0.6;
                    continue;
                }
                if (baseType == 1000) {
                    int n = ArN;
                    this.cyanoInc[n] = this.cyanoInc[n] + -0.75;
                    continue;
                }
                if (baseType == 3) {
                    int n = ArN;
                    this.cyanoInc[n] = this.cyanoInc[n] + -0.75;
                    continue;
                }
                if (baseType != 6) continue;
                int n = ArN;
                this.cyanoInc[n] = this.cyanoInc[n] + -0.75;
                continue;
            }
            if (this.dist[a] == 4) {
                int acidType = this.pkaAcidType[a][5];
                baseType = this.pkaBasicType[a][0];
                if (this.pg.getCarboxy()[a] == 1820) {
                    if (qr) {
                        if (this.isParaPos(a, riN)) {
                            int n = ArN;
                            this.cyanoInc[n] = this.cyanoInc[n] + -3.0;
                            continue;
                        }
                        int n = ArN;
                        this.cyanoInc[n] = this.cyanoInc[n] + -0.6;
                        continue;
                    }
                    int n = ArN;
                    this.cyanoInc[n] = this.cyanoInc[n] + -3.0;
                    continue;
                }
                if (acidType == 1 || acidType == 3) {
                    int riOH;
                    if (this.pkaAcidType[a][0] != 0 || (riOH = this.charge.getRings().findSmallestAraRing(this.pkaAcidType[a][1])) != riN) continue;
                    paraOH = a;
                    if (acidType == 3) {
                        int n = ArN;
                        this.cyanoInc[n] = this.cyanoInc[n] + -1.0;
                        SHInc = true;
                        SHtautomer = true;
                        continue;
                    }
                    tautomerN = true;
                    continue;
                }
                if (baseType == 1000) {
                    int n = ArN;
                    this.cyanoInc[n] = this.cyanoInc[n] + -1.0;
                    continue;
                }
                if (baseType == 3) {
                    int n = ArN;
                    this.cyanoInc[n] = this.cyanoInc[n] + -1.0;
                    continue;
                }
                if (baseType != 6) continue;
                int n = ArN;
                this.cyanoInc[n] = this.cyanoInc[n] + -0.7;
                continue;
            }
            if (this.dist[a] == 3) {
                int alpha;
                if (this.pkaAcidType[a][5] == 1) {
                    if (this.pkaAcidType[a][0] == 1 && chg == 0.0) {
                        this.HBT[this.hbtAIndex[ArN]][11] = a;
                        this.HBT[this.hbtAIndex[a]][11] = ArN;
                        continue;
                    }
                    if (this.pkaAcidType[a][0] == 5) {
                        if (!(this.mpk0[ArN] < -2.5)) continue;
                        int n = ArN;
                        this.cyanoInc[n] = this.cyanoInc[n] + 3.85;
                        continue;
                    }
                    if (this.pkaAcidType[a][0] != -2) continue;
                    int n = ArN;
                    this.cyanoInc[n] = this.cyanoInc[n] + 0.9;
                    continue;
                }
                if (this.pkaAcidType[a][5] == 3) {
                    if (this.pkaAcidType[a][0] != -2) continue;
                    int n = ArN;
                    this.cyanoInc[n] = this.cyanoInc[n] + 0.65;
                    continue;
                }
                if (this.pkaAcidType[a][5] != 2 || this.pkaAcidType[a][0] != 1 && this.pkaAcidType[a][0] != 2 || !this.isTheSameAraRing(riN, alpha = this.pkaAcidType[a][1])) continue;
                int n = ArN;
                this.cyanoInc[n] = this.cyanoInc[n] + -1.7;
                continue;
            }
            if (this.dist[a] == 2) {
                if (this.pg.getCarboxy()[a] == 1820) {
                    int n = ArN;
                    this.cyanoInc[n] = this.cyanoInc[n] + -0.6;
                    continue;
                }
                if (this.pkaAcidType[a][5] == 2) {
                    if (this.pkaAcidType[a][0] == 4) {
                        double inc = this.getArNInc(a);
                        if (inc == 0.0) {
                            int n = ArN;
                            this.cyanoInc[n] = this.cyanoInc[n] + 1.3;
                            continue;
                        }
                        int n = ArN;
                        this.cyanoInc[n] = this.cyanoInc[n] + inc;
                        continue;
                    }
                    if (this.pkaAcidType[a][0] == 2 || this.pkaAcidType[a][0] == 6) {
                        int n = ArN;
                        this.cyanoInc[n] = this.cyanoInc[n] + this.getArNInc(a);
                        continue;
                    }
                    if (this.pkaAcidType[a][0] != 0) continue;
                    int n = ArN;
                    this.cyanoInc[n] = this.cyanoInc[n] + -0.9;
                    continue;
                }
                if (this.pkaAcidType[a][5] == 1 || this.pkaAcidType[a][5] == 3) {
                    if (this.pkaAcidType[a][0] != 0 || !(this.mpk0[ArN] > 3.0)) continue;
                    tautomerN = true;
                    orthoTautomer = true;
                    if (this.pkaAcidType[a][5] != 3) continue;
                    SHtautomer = true;
                    continue;
                }
                if (this.pg.getCarboxy()[a] == 2) {
                    int n = ArN;
                    this.cyanoInc[n] = this.cyanoInc[n] + (esterCount == 0 ? 2.4 : 4.0);
                    ++esterCount;
                    continue;
                }
                if (this.pg.getCarboxy()[a] == 1000 || this.pg.getCarboxy()[a] == 1100) {
                    if (ror == 0) {
                        if (this.isSOR(a)) {
                            int n = ArN;
                            this.cyanoInc[n] = this.cyanoInc[n] + 0.2;
                        } else {
                            int n = ArN;
                            this.cyanoInc[n] = this.cyanoInc[n] + 0.7;
                        }
                        etherInteraction = true;
                    } else {
                        int n = ArN;
                        this.cyanoInc[n] = this.cyanoInc[n] + 1.5;
                        etherInteraction = false;
                    }
                    ++ror;
                    continue;
                }
                if (this.isNitrogen(a)) {
                    if (this.isArA(a)) {
                        if (this.cHtab[a].length == 2) {
                            pyrimidin = true;
                            continue;
                        }
                        if (this.cHtab[a].length != 3) continue;
                        int n = ArN;
                        this.cyanoInc[n] = this.cyanoInc[n] + -0.9;
                        continue;
                    }
                    double inc = this.getArNInc(a);
                    int n = ArN;
                    this.cyanoInc[n] = this.cyanoInc[n] + inc;
                    continue;
                }
                if (this.getAza(a) == -1 || this.isArA(a) || this.pg.getCarboxy()[a] != -1) continue;
                int n = ArN;
                this.cyanoInc[n] = this.cyanoInc[n] + 2.0;
                continue;
            }
            if (this.dist[a] != 1 || !this.isArA(a) || this.cHtab[a].length != 2) continue;
            pyrazineType = true;
        }
        if (pyrimidin && etherInteraction) {
            int n = ArN;
            this.cyanoInc[n] = this.cyanoInc[n] + 1.4;
        }
        if (tautomerN) {
            if (SHtautomer) {
                int n = ArN;
                this.cyanoInc[n] = this.cyanoInc[n] + (43.21 * this.Qsum[ArN] + 7.35);
                if (!orthoTautomer) {
                    int n2 = paraOH;
                    this.cyanoInc[n2] = this.cyanoInc[n2] + 3.1;
                } else if (paraOH != -1 && !pyrazineType) {
                    int n3 = paraOH;
                    this.cyanoInc[n3] = this.cyanoInc[n3] - 1.0;
                }
            } else {
                int n = ArN;
                this.cyanoInc[n] = this.cyanoInc[n] + (30.769 * this.Qsum[ArN] + 4.865);
                if (!orthoTautomer) {
                    int n4 = paraOH;
                    this.cyanoInc[n4] = this.cyanoInc[n4] + 2.1;
                } else if (paraOH != -1 && !pyrazineType) {
                    int n5 = paraOH;
                    this.cyanoInc[n5] = this.cyanoInc[n5] - 1.5;
                }
            }
        } else if (paraOH != -1 && !SHInc && !pyrazineType) {
            int n = paraOH;
            this.cyanoInc[n] = this.cyanoInc[n] - 1.9;
        }
    }

    private boolean isParaPos(int a, int riN) {
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int nb = this.cHtab[a][i];
            if (nb >= this.mol.getAtomCount() || !this.isArA(nb) || !this.isTheSameAraRing(riN, nb)) continue;
            return true;
        }
        return false;
    }

    private double getArNInc(int a) {
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int nb = this.cHtab[a][i];
            if (nb >= this.mol.getAtomCount()) continue;
            if (this.pg.getCarboxy()[nb] == 100) {
                return -4.5;
            }
            if (this.pg.getCarboxy()[nb] == 1200) {
                return -2.5;
            }
            if (this.pg.getCarboxy()[nb] == 400) {
                return -3.5;
            }
            if (this.pg.getCarboxy()[nb] == 800) {
                return -3.0;
            }
            if (this.pkaBasicType[nb][0] != 1000) continue;
            int n = nb;
            this.cyanoInc[n] = this.cyanoInc[n] + -1.0;
            return 2.5;
        }
        return 0.0;
    }

    private boolean isSOR(int atom) {
        int protonCount = this.atomArray[atom].getAtno();
        return protonCount == 16;
    }

    private void setSemiAraInc(int ai, int rIndx) {
        for (int i = 0; i < this.aAtoms[rIndx].length; ++i) {
            int ra = this.aAtoms[rIndx][i];
            for (int j = 0; j < this.cHtab[ra].length; ++j) {
                int ind;
                int y;
                int nb = this.cHtab[ra][j];
                if (nb >= this.mol.getAtomCount() || this.isArA(nb) || !this.isInRing[nb] || (y = this.charge.isSemiAromaticRing(ind = this.charge.getRings().getSmallestRingIndex(nb))) != 100 && y != 200 || this.isTheSameRing(ind, ra) || this.pg.getCarboxy()[nb] == 200) continue;
                int n = ai;
                this.cyanoInc[n] = this.cyanoInc[n] - 2.0;
            }
        }
    }

    private void setAzaInc(int atom, int ri) {
        for (int i = 0; i < this.sphereSize; ++i) {
            int chg;
            int a = this.sphere[i];
            if (this.dist[a] == 2) {
                chg = this.atomArray[a].getCharge();
                if (this.pg.getCarboxy()[a] == 1) {
                    if (this.getAtno(a) != 6 && this.getAtno(a) == 16) {
                        int n = atom;
                        this.cyanoInc[n] = this.cyanoInc[n] + -2.2;
                    }
                } else if (this.pg.getCarboxy()[a] == 200 || this.pg.getCarboxy()[a] == 500) {
                    if (this.getAtno(a) == 6) {
                        int n = atom;
                        this.cyanoInc[n] = this.cyanoInc[n] + -0.8;
                    } else {
                        int n = atom;
                        this.cyanoInc[n] = this.cyanoInc[n] + -1.27;
                    }
                } else if (this.pg.getCarboxy()[a] == 1300 || this.pg.getCarboxy()[a] == 400) {
                    int n = atom;
                    this.cyanoInc[n] = this.cyanoInc[n] + -2.2;
                } else if (this.pg.getCarboxy()[a] == 1820) {
                    int n = atom;
                    this.cyanoInc[n] = this.cyanoInc[n] + -1.6;
                } else if (this.pkaBasicType[a][3] == 1 && chg == 0) {
                    if (this.getAtno(a) == 7) {
                        int n = atom;
                        this.cyanoInc[n] = this.cyanoInc[n] + 1.7;
                    }
                } else if (this.pkaBasicType[a][3] == 2 && chg == 0) {
                    if (this.getAtno(a) == 7 && !this.isArA(a)) {
                        int n = atom;
                        this.cyanoInc[n] = this.cyanoInc[n] + 0.7;
                    }
                } else if (this.isNitrogen(a) && this.isCrossArA(a)) {
                    int n = atom;
                    this.cyanoInc[n] = this.cyanoInc[n] + 1.67;
                }
            } else if (this.dist[a] == 3) {
                chg = this.atomArray[a].getCharge();
                if (this.pg.getCarboxy()[a] == 1300 || this.pg.getCarboxy()[a] == 400) {
                    if (this.getAtno(a) == 6 || this.isNitrogen(a)) {
                        int n = atom;
                        this.cyanoInc[n] = this.cyanoInc[n] + -0.7;
                    }
                } else if (this.getAtno(a) == 7) {
                    if (this.isArA(a)) {
                        if ((this.pkaBasicType[a][0] == 500 || this.pkaBasicType[a][0] == 600) && chg == 0) {
                            int ind = this.charge.getRings().findSmallestAraRing(atom);
                            if (this.isTheSameAraRing(ind, a)) {
                                int n = atom;
                                this.cyanoInc[n] = this.cyanoInc[n] + -2.7;
                            } else {
                                int n = atom;
                                this.cyanoInc[n] = this.cyanoInc[n] + -0.0;
                            }
                        }
                    } else if (this.sAra[a] == 1 && this.pkaAcidType[a][0] < 0 && chg == 0) {
                        int n = atom;
                        this.cyanoInc[n] = this.cyanoInc[n] + 1.0;
                    }
                }
            }
            if (this.getAtno(a) != 6) continue;
            chg = this.atomArray[a].getCharge();
            if (this.NbAtom(atom, a) || this.pkaAcidType[a][0] < 0 || chg != 0 || this.mpk0[a] == 0.0 || !(this.mpk0[a] < 11.0) || this.dist[a] != 3 && this.dist[a] != 2) continue;
            int n = atom;
            this.cyanoInc[n] = this.cyanoInc[n] + -(-0.226 * this.mpk0[a] + 3.44);
        }
    }

    private boolean NbAtom(int atom, int a) {
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int nb = this.cHtab[atom][i];
            if (nb >= this.mol.getAtomCount() || a != nb) continue;
            return true;
        }
        return false;
    }

    protected boolean isCrossArA(int ai) {
        if (!this.isArA(ai)) {
            return false;
        }
        int c = 0;
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.mol.getAtomCount() || !this.isArA(nb) || this.mol.getBond(this.bHtab[nb][ai]).getType() != 4) continue;
            ++c;
        }
        return c == 3 && this.atomArray[ai].getCharge() == 0;
    }

    private void setHaloCorrection(int atom) {
        int haloCount = 0;
        for (int i = 0; i < this.sphereSize; ++i) {
            int a = this.sphere[i];
            if (this.dist[a] < 3) continue;
            int atno = this.getAtno(a);
            if (atno == 9 || atno == 17) {
                ++haloCount;
                continue;
            }
            if (atno != 35 && atno != 53) continue;
            int n = atom;
            this.cyanoInc[n] = this.cyanoInc[n] + -1.0 / (double)this.dist[a];
        }
        int n = atom;
        this.cyanoInc[n] = this.cyanoInc[n] + (-0.05 * (double)haloCount * (double)haloCount + 0.45 * (double)haloCount);
    }

    private void setCONHHaloCorrection(int atom) {
        boolean haloCount = false;
        double sum = 0.0;
        for (int i = 0; i < this.sphereSize; ++i) {
            int a = this.sphere[i];
            if (this.dist[a] == 1) {
                if (this.pg.getCarboxy()[a] == 1400) {
                    sum += -1.5;
                    continue;
                }
                if (this.pg.getCarboxy()[a] != 400) continue;
                sum += -4.5;
                continue;
            }
            if (this.dist[a] == 2) {
                if (this.pg.getCarboxy()[a] == 1400) {
                    sum += -1.8;
                    continue;
                }
                if (this.pg.getCarboxy()[a] == 400) {
                    sum += -3.0;
                    continue;
                }
                if (this.pg.getCarboxy()[a] != 1000 || this.pg.getGroupProperty()[a] != 3700) continue;
                sum += -2.0;
                continue;
            }
            if (this.dist[a] == 3) {
                if (this.pg.getCarboxy()[a] == 1400) {
                    sum += -1.1;
                    continue;
                }
                if (this.pg.getCarboxy()[a] != 400) continue;
                sum += -2.2;
                continue;
            }
            if (this.dist[a] == 4) {
                if (this.pg.getCarboxy()[a] == 1400) {
                    sum += -0.6;
                    continue;
                }
                if (this.pg.getCarboxy()[a] != 400) continue;
                sum += -1.5;
                continue;
            }
            if (this.dist[a] <= 4) continue;
            if (this.pg.getCarboxy()[a] == 1400) {
                sum += -0.25;
                continue;
            }
            if (this.pg.getCarboxy()[a] != 400) continue;
            sum += -0.3;
        }
        sum += -0.05 * (double)haloCount * (double)haloCount + 0.45 * (double)haloCount;
        if (this.isHydrazideNHAcid(atom)) {
            int n = atom;
            this.cyanoInc[n] = this.cyanoInc[n] + sum / 3.0;
        } else {
            int n = atom;
            this.cyanoInc[n] = this.cyanoInc[n] + sum;
        }
    }

    private boolean isHydrazideNHAcid(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.mol.getAtomCount() || this.pg.getCarboxy()[nb] != 1820) continue;
            return true;
        }
        return false;
    }

    private int getKetoRoot(int nh) {
        int gi = this.pg.getGroupIndex()[nh];
        for (int i = 0; i < this.cHtab[nh].length; ++i) {
            int nb = this.cHtab[nh][i];
            if (nb >= this.mol.getAtomCount() || this.pg.getGroupIndex()[nb] != gi) continue;
            return nb;
        }
        return 0;
    }

    private void setAlphaAminInc(int ai) {
        for (int i = 0; i < this.sphereSize; ++i) {
            int a = this.sphere[i];
            if (this.dist[a] != 3) continue;
            int chg = this.atomArray[a].getCharge();
            if (chg == 0) {
                if ((this.pkaBasicType[a][0] == 1000 || this.pkaBasicType[a][0] == 1) & this.pkaBasicType[a][3] == 3) {
                    int[] nArray = this.HBT[this.hbtAIndex[a]];
                    nArray[5] = nArray[5] + 100;
                    continue;
                }
                if ((this.pkaBasicType[a][0] == 1000 || this.pkaBasicType[a][0] == 1) & this.pkaBasicType[a][3] == 2) {
                    int[] nArray = this.HBT[this.hbtAIndex[a]];
                    nArray[5] = nArray[5] + 100;
                    continue;
                }
                if (!(this.pkaBasicType[a][0] == 1000 & this.pkaBasicType[a][3] == 1)) continue;
                int[] nArray = this.HBT[this.hbtAIndex[a]];
                nArray[5] = nArray[5] + 100;
                continue;
            }
            if (chg != 1) continue;
            int n = ai;
            this.cyanoInc[n] = this.cyanoInc[n] + -1.0;
        }
    }

    private boolean setArKetoHBond(int beta, int oh) {
        if (!this.isInRing[beta]) {
            return false;
        }
        for (int i = 0; i < this.cHtab[beta].length; ++i) {
            int nb = this.cHtab[beta][i];
            if (nb >= this.mol.getAtomCount() || this.pg.getCarboxy()[nb] != 1 || !this.isInRing[nb]) continue;
            for (int j = 0; j < this.cHtab[nb].length; ++j) {
                int nnb = this.cHtab[nb][j];
                if (nnb >= this.mol.getAtomCount() || !this.isArA(nnb)) continue;
                int n = oh;
                this.cyanoInc[n] = this.cyanoInc[n] + 2.3;
                return true;
            }
        }
        return false;
    }

    private void setOrthoEffect(int cooh, int aAtom) {
        int no2Count = 0;
        int aminCount = 0;
        for (int i = 0; i < this.cHtab[aAtom].length; ++i) {
            int nb1 = this.cHtab[aAtom][i];
            if (nb1 == cooh) continue;
            for (int j = 0; j < this.cHtab[nb1].length; ++j) {
                int nb2 = this.cHtab[nb1][j];
                if (!(nb2 < this.mol.getAtomCount() & nb2 != aAtom)) continue;
                if (this.getAtno(nb2) == 9) {
                    int n = cooh;
                    this.cyanoInc[n] = this.cyanoInc[n] + 1.0;
                    continue;
                }
                if (this.getAtno(nb2) == 8) {
                    if (this.pg.getCarboxy()[nb2] == 1000 || this.pg.getCarboxy()[nb2] == 1100) {
                        int n = cooh;
                        this.cyanoInc[n] = this.cyanoInc[n] + 0.85;
                        continue;
                    }
                    if (this.pg.getCarboxy()[nb2] != 2) continue;
                    int n = cooh;
                    this.cyanoInc[n] = this.cyanoInc[n] + 0.75;
                    continue;
                }
                if (this.getAtno(nb2) == 6) {
                    if (this.pg.getCarboxy()[nb2] == 2) {
                        int n = cooh;
                        this.cyanoInc[n] = this.cyanoInc[n] + 0.35;
                        continue;
                    }
                    if (this.pg.getCarboxy()[nb2] == 200) {
                        int n = cooh;
                        this.cyanoInc[n] = this.cyanoInc[n] + 0.7;
                        continue;
                    }
                    if (this.pg.getCarboxy()[nb2] == 1) {
                        if (this.isAraKeto(nb2)) {
                            int n = cooh;
                            this.cyanoInc[n] = this.cyanoInc[n] + (-8.6085 * this.Qsum[nb2] + 1.0257);
                            continue;
                        }
                        int n = cooh;
                        this.cyanoInc[n] = this.cyanoInc[n] + 1.0;
                        continue;
                    }
                    if (this.hconj[nb2] != 1 || this.isInRing[nb2]) continue;
                    int n = cooh;
                    this.cyanoInc[n] = this.cyanoInc[n] + -0.2;
                    continue;
                }
                if (!this.isNitrogen(nb2)) continue;
                if (this.pg.getCarboxy()[nb2] == 1300) {
                    int n = cooh;
                    this.cyanoInc[n] = this.cyanoInc[n] + (++no2Count == 1 ? 0.5 : 0.9);
                    continue;
                }
                if (this.pg.getCarboxy()[nb2] == 500) {
                    int n = cooh;
                    this.cyanoInc[n] = this.cyanoInc[n] + 0.3;
                    continue;
                }
                if (this.pkaBasicType[nb2][0] != 1 || this.atomArray[nb2].getCharge() != 0) continue;
                int n = cooh;
                this.cyanoInc[n] = this.cyanoInc[n] + (++aminCount == 1 ? -5.5594 * this.Qsum[nb2] : -3.9 * this.Qsum[nb2]);
            }
        }
    }

    private void setPMOEffect(int atom, int abAtom) {
        int beta = this.pkaAcidType[atom][4];
        this.getAtomDistances(beta, 5);
        int ri = this.charge.getRings().findSmallestAraRing(abAtom);
        for (int i = 0; i < this.sphereSize; ++i) {
            int a = this.sphere[i];
            int chg = this.atomArray[a].getCharge();
            boolean commonRing = false;
            int t = this.pg.getCarboxy()[a];
            if (t == 1400) {
                for (int m = 0; !commonRing && m < this.cHtab[a].length; ++m) {
                    if (!this.isArA(this.cHtab[a][m]) || !this.isTheSameAraRing(ri, this.cHtab[a][m])) continue;
                    commonRing = true;
                }
                if (!commonRing) continue;
                if (this.dist[a] == 3) {
                    if (this.getAtno(a) == 9) {
                        int n = atom;
                        this.cyanoInc[n] = this.cyanoInc[n] + 1.35;
                        continue;
                    }
                    int n = atom;
                    this.cyanoInc[n] = this.cyanoInc[n] + 0.85;
                    continue;
                }
                if (this.dist[a] != 4) continue;
                int n = atom;
                this.cyanoInc[n] = this.cyanoInc[n] + 0.75;
                continue;
            }
            if (this.dist[a] != 4 && this.dist[a] != 2 && this.dist[a] != 3 || !this.isArA(a) || !this.isTheSameAraRing(ri, a) || this.getAtno(a) != 7 || chg != 1 || this.isImphExist(a)) continue;
            if (this.dist[a] == 2) {
                int n = atom;
                this.cyanoInc[n] = this.cyanoInc[n] + 2.5;
                continue;
            }
            if (this.dist[a] == 3) {
                int n = atom;
                this.cyanoInc[n] = this.cyanoInc[n] + 1.0;
                continue;
            }
            int n = atom;
            this.cyanoInc[n] = this.cyanoInc[n] + -1.1;
        }
    }

    private boolean isImphExist(int atom) {
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int nb = this.cHtab[atom][i];
            if (nb < this.mol.getAtomCount()) continue;
            return true;
        }
        return false;
    }

    private void setParaMeataEffect(int atom, int abAtom) {
        this.getAtomDistances(abAtom, 4);
        int[] rInfo = this.charge.findLargestRing(abAtom);
        int type = 0;
        int ring1 = rInfo[0];
        boolean find = false;
        boolean find2 = false;
        for (int i = 0; i < this.sphereSize; ++i) {
            int ring2;
            int a = this.sphere[i];
            if (this.dist[a] == 4) {
                type = this.pg.getCarboxy()[a];
                if (type != 1300 && type != 400) continue;
                for (int j = 0; j < this.cHtab[a].length; ++j) {
                    if (!this.isArA(this.cHtab[a][j]) || (ring2 = (rInfo = this.charge.findLargestRing(this.cHtab[a][j]))[0]) != ring1) continue;
                    find = true;
                }
                continue;
            }
            if (this.dist[a] == 3) {
                int basicType = this.pkaBasicType[a][0];
                if (basicType != 1 || this.atomArray[a].getCharge() != 0) continue;
                find2 = false;
                for (int k = 0; !find && k < this.cHtab[a].length; ++k) {
                    if (!this.isArA(this.cHtab[a][k]) || (ring2 = (rInfo = this.charge.findLargestRing(this.cHtab[a][k]))[0]) != ring1) continue;
                    find2 = true;
                }
                if (!find2) continue;
                int n = atom;
                this.cyanoInc[n] = this.cyanoInc[n] + 0.75;
                continue;
            }
            if (this.dist[a] != 2 || this.pkaBasicType[a][0] != 500 && this.pkaBasicType[a][0] != 600 || this.atomArray[a].getCharge() != 0) continue;
            int n = atom;
            this.cyanoInc[n] = this.cyanoInc[n] + 0.2;
        }
        if (find) {
            if (type == 1300) {
                int n = atom;
                this.cyanoInc[n] = this.cyanoInc[n] + -0.15;
            } else if (type == 400) {
                int n = atom;
                this.cyanoInc[n] = this.cyanoInc[n] + -0.4;
            }
        }
    }

    private boolean isAraKeto(int atom) {
        int cc = 0;
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int nb = this.cHtab[atom][i];
            if (nb >= this.mol.getAtomCount() || !this.isArA(nb)) continue;
            ++cc;
        }
        return cc == 2;
    }

    private void setParaMetaCorr(int oh, int abAtom) {
        this.getAtomDistances(oh, 5);
        int ring1 = -1;
        int[] rInfo = this.charge.findLargestRing(abAtom);
        ring1 = rInfo[0];
        for (int i = 0; i < this.sphereSize; ++i) {
            int a = this.sphere[i];
            int chg = this.atomArray[a].getCharge();
            if (this.dist[a] == 5) {
                int j;
                if (this.pkaBasicType[a][0] == 1 && this.pkaBasicType[a][1] == -1 && chg == 0) {
                    for (j = 0; j < this.cHtab[a].length; ++j) {
                        if (!this.isArA(this.cHtab[a][j]) || !this.isTheSameAraRing(ring1, this.cHtab[a][j])) continue;
                        int n = oh;
                        this.cyanoInc[n] = this.cyanoInc[n] + -0.5;
                    }
                    continue;
                }
                if (this.pg.getCarboxy()[a] == 200) {
                    for (j = 0; j < this.cHtab[a].length; ++j) {
                        if (!this.isArA(this.cHtab[a][j]) || !this.isTheSameAraRing(ring1, this.cHtab[a][j])) continue;
                        int n = oh;
                        this.cyanoInc[n] = this.cyanoInc[n] + -0.4;
                    }
                    continue;
                }
                if (this.pg.getCarboxy()[a] == 1) {
                    for (j = 0; j < this.cHtab[a].length; ++j) {
                        if (!this.isArA(this.cHtab[a][j]) || !this.isTheSameAraRing(ring1, this.cHtab[a][j])) continue;
                        if (this.pg.getGroupProperty()[a] == 421) {
                            int n = oh;
                            this.cyanoInc[n] = this.cyanoInc[n] + -1.0;
                            continue;
                        }
                        int n = oh;
                        this.cyanoInc[n] = this.cyanoInc[n] + -0.5;
                    }
                    continue;
                }
                if (this.pg.getCarboxy()[a] == 1400) {
                    if (!this.isArA(this.cHtab[a][0]) || !this.isTheSameAraRing(ring1, this.cHtab[a][0])) continue;
                    int n = oh;
                    this.cyanoInc[n] = this.cyanoInc[n] + -0.3;
                    continue;
                }
                if (this.pg.getCarboxy()[a] != 1600 && this.pg.getCarboxy()[a] != 1500) continue;
                for (j = 0; j < this.cHtab[a].length; ++j) {
                    if (!this.isArA(this.cHtab[a][j]) || !this.isTheSameAraRing(ring1, this.cHtab[a][j])) continue;
                    int n = oh;
                    this.cyanoInc[n] = this.cyanoInc[n] + -0.5;
                }
                continue;
            }
            if (this.dist[a] == 4) {
                int k;
                boolean find;
                if (this.pkaAcidType[a][0] == 0 && this.pkaAcidType[a][5] == 1 && chg == 0) {
                    if (!this.isTheSameAraRing(ring1, this.pkaAcidType[a][1])) continue;
                    int n = oh;
                    this.cyanoInc[n] = this.cyanoInc[n] + 0.35;
                    continue;
                }
                if (this.pg.getCarboxy()[a] == 2) {
                    find = false;
                    for (k = 0; k < this.cHtab[a].length && !find; ++k) {
                        if (!this.isArA(this.cHtab[a][k]) || !this.isTheSameAraRing(ring1, this.cHtab[a][k])) continue;
                        if (this.sAra[a] == 1) {
                            int n = oh;
                            this.cyanoInc[n] = this.cyanoInc[n] + -1.2;
                            find = true;
                            continue;
                        }
                        if (this.getAtno(a) != 6 || this.isInRing[a]) continue;
                        int n = oh;
                        this.cyanoInc[n] = this.cyanoInc[n] + 0.5;
                        find = true;
                    }
                    continue;
                }
                if (this.pg.getGroupType()[a] == 23) {
                    find = false;
                    for (k = 0; k < this.cHtab[a].length && !find; ++k) {
                        if (!this.isArA(this.cHtab[a][k]) || !this.isTheSameAraRing(ring1, this.cHtab[a][k])) continue;
                        if (this.sAra[a] == 1) {
                            int n = oh;
                            this.cyanoInc[n] = this.cyanoInc[n] + -1.0;
                        } else {
                            int n = oh;
                            this.cyanoInc[n] = this.cyanoInc[n] + 0.3;
                        }
                        find = true;
                    }
                    continue;
                }
                if (this.pg.getCarboxy()[a] != 1400 || !this.isArA(this.cHtab[a][0]) || !this.isTheSameAraRing(ring1, this.cHtab[a][0])) continue;
                int n = oh;
                this.cyanoInc[n] = this.cyanoInc[n] + -0.3;
                continue;
            }
            if (this.dist[a] != 3 || this.hconj[a] != 1) continue;
            int cc = 0;
            for (int j = 0; j < this.cHtab[a].length; ++j) {
                if (!this.isArA(this.cHtab[a][j]) || !this.isTheSameAraRing(ring1, this.cHtab[a][j])) continue;
                cc = this.getCaseCount(a);
                if (cc == 4) {
                    int n = oh;
                    this.cyanoInc[n] = this.cyanoInc[n] + 0.45;
                    continue;
                }
                if (cc != 3) continue;
                int n = oh;
                this.cyanoInc[n] = this.cyanoInc[n] + 0.25;
            }
        }
    }

    private void setOrthoCorr(int oh, int a) {
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int beta = this.cHtab[a][i];
            if (!this.isArA(beta)) continue;
            for (int j = 0; j < this.cHtab[beta].length; ++j) {
                int nnb = this.cHtab[beta][j];
                if (nnb == a || nnb >= this.mol.getAtomCount()) continue;
                this.setBenzylXH(nnb, oh);
                if (this.pg.getGroupProperty()[nnb] == 422) {
                    int n = oh;
                    this.cyanoInc[n] = this.cyanoInc[n] + 0.7;
                    continue;
                }
                if (this.mol.getBond(this.bHtab[nnb][beta]).getType() != 4 || this.getAtno(nnb) == 6 || this.getAtno(beta) == 6) continue;
                int n = oh;
                this.cyanoInc[n] = this.cyanoInc[n] - 2.7;
            }
        }
    }

    private void setBenzylXH(int g, int oh) {
        if (this.isArA(g)) {
            return;
        }
        boolean hbondedKeto = this.isHBondedKeto(g);
        if (!hbondedKeto && this.pg.getCarboxy()[g] == 1) {
            if (this.isInRing[g]) {
                int ri = this.charge.getRings().getSmallestRingIndex(g);
                if (this.nonAring[ri].length == 5) {
                    int n = oh;
                    this.cyanoInc[n] = this.cyanoInc[n] + 0.5;
                } else if (this.nonAring[ri].length >= 6) {
                    int n = oh;
                    this.cyanoInc[n] = this.cyanoInc[n] + 0.7;
                }
            } else {
                int y = this.isCarbonAldehyde(g);
                if (y == 1) {
                    int n = oh;
                    this.cyanoInc[n] = this.cyanoInc[n] + 0.2;
                } else if (y == 2) {
                    int n = oh;
                    this.cyanoInc[n] = this.cyanoInc[n] + 2.0;
                }
            }
        }
        for (int i = 0; i < this.cHtab[g].length; ++i) {
            int nb = this.cHtab[g][i];
            if (nb >= this.mol.getAtomCount()) continue;
            if (this.pkaBasicType[nb][0] == 1000) {
                int n = nb;
                this.cyanoInc[n] = this.cyanoInc[n] + 1.1;
                int n2 = oh;
                this.cyanoInc[n2] = this.cyanoInc[n2] + -0.5;
                continue;
            }
            if (this.pg.getCarboxy()[nb] != 900) continue;
            int n = oh;
            this.cyanoInc[n] = this.cyanoInc[n] + 0.8;
        }
    }

    private int getCaseCount(int a) {
        int c = 0;
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int nb = this.cHtab[a][i];
            if (nb >= this.mol.getAtomCount()) continue;
            ++c;
        }
        return c;
    }

    private void setSimplePhenol(int alpha, int oh) {
        int[] rInfo = this.charge.findLargestRing(alpha);
        int ri = rInfo[0];
        if (this.aAtoms[ri].length != 6) {
            return;
        }
        for (int i = 0; i < this.aAtoms[ri].length; ++i) {
            int ra = this.aAtoms[ri][i];
            if (ra == alpha) continue;
            for (int j = 0; j < this.cHtab[ra].length; ++j) {
                int nb = this.cHtab[ra][j];
                if (nb >= this.mol.getAtomCount() || this.isArA(nb) || this.getAtno(nb) == 6 && this.hconj[nb] == 1) continue;
                return;
            }
        }
        int n = oh;
        this.cyanoInc[n] = this.cyanoInc[n] + 0.48;
    }

    private void setEsterHbond(int oh, int aAtom) {
        int rorc = 0;
        int rInd = 0;
        int size = 0;
        boolean start = true;
        for (int i = 0; i < this.cHtab[aAtom].length; ++i) {
            int nb1 = this.cHtab[aAtom][i];
            if (nb1 == oh) continue;
            for (int j = 0; j < this.cHtab[nb1].length; ++j) {
                int nb2 = this.cHtab[nb1][j];
                if (!(nb2 < this.mol.getAtomCount() & nb2 != aAtom)) continue;
                if (this.pg.getCarboxy()[nb2] == 2) {
                    if (!start) continue;
                    start = false;
                    ++this.logPHBondCounter;
                    int n = oh;
                    this.cyanoInc[n] = this.cyanoInc[n] + 2.0;
                    continue;
                }
                if (this.pg.getCarboxy()[nb2] == 1000) {
                    if (this.isSOR(nb2)) {
                        int n = oh;
                        this.cyanoInc[n] = this.cyanoInc[n] + 0.3;
                        continue;
                    }
                    if (rorc != 0) continue;
                    int n = oh;
                    this.cyanoInc[n] = this.cyanoInc[n] + 1.2;
                    ++rorc;
                    continue;
                }
                if (this.pg.getCarboxy()[nb2] == 200 || this.pg.getCarboxy()[nb2] == 300 || this.pg.getCarboxy()[nb2] == 1) {
                    ++this.logPHBondCounter;
                    if (this.pg.getCarboxy()[nb2] != 1 || (rInd = this.charge.getRings().getSmallestRingIndex(nb2)) == -1) continue;
                    size = this.nonAring[rInd].length;
                    if (size == 6) {
                        int n = oh;
                        this.cyanoInc[n] = this.cyanoInc[n] + 1.1;
                        continue;
                    }
                    if (size <= 6) continue;
                    int n = oh;
                    this.cyanoInc[n] = this.cyanoInc[n] + 0.5;
                    continue;
                }
                if (this.getAtno(nb2) == 35) {
                    int n = oh;
                    this.cyanoInc[n] = this.cyanoInc[n] + -0.5;
                    continue;
                }
                if (this.getAtno(nb2) == 17) {
                    int n = oh;
                    this.cyanoInc[n] = this.cyanoInc[n] + -0.5;
                    continue;
                }
                if (this.getAtno(nb2) == 9) {
                    int n = oh;
                    this.cyanoInc[n] = this.cyanoInc[n] + 0.5;
                    continue;
                }
                if (this.getAtno(nb2) != 53) continue;
                int n = oh;
                this.cyanoInc[n] = this.cyanoInc[n] + -0.3;
            }
        }
    }

    private void sethBond1(int atom, int abAtom, int acidType1) {
        int hbType = 0;
        int h = 0;
        this.getAtomDistances(atom, 5);
        for (int i = 0; i < this.sphereSize; ++i) {
            int a = this.sphere[i];
            int acidType2 = this.pkaAcidType[a][0];
            int chg = this.atomArray[a].getCharge();
            if ((acidType2 == 0 || acidType2 == 1) && chg == 0) {
                int bondOrder;
                int k;
                int alphaAtom = this.pkaAcidType[a][1];
                int betaAtom = this.pkaAcidType[a][2];
                int n = k = alphaAtom < 0 ? betaAtom : alphaAtom;
                if (k < 0 || (bondOrder = this.getBondType(this.bHtab[abAtom][k])) != 4) continue;
                if (acidType1 == 0 & acidType2 == 1) {
                    hbType = 2;
                    this.HBT[this.hbtAIndex[atom]][h] = a;
                } else if (acidType1 == 0 & acidType2 == 0) {
                    hbType = 1;
                    this.HBT[this.hbtAIndex[atom]][1] = a;
                } else if (acidType1 == 1 & acidType2 == 0) {
                    hbType = 2;
                    this.HBT[this.hbtAIndex[atom]][h] = a;
                } else if (acidType1 == 1 & acidType2 == 1) {
                    hbType = 3;
                    this.HBT[this.hbtAIndex[atom]][h] = a;
                }
                this.HBT[this.hbtAIndex[atom]][h + 2] = hbType;
                ++h;
                continue;
            }
            if (acidType1 != 0 || chg != 0 || this.pkaAcidType[a][0] != 5 || this.pkaAcidType[a][5] != 1 || !this.isConnected(abAtom, this.pkaAcidType[a][2])) continue;
            this.HBT[this.hbtAIndex[atom]][10] = a;
        }
    }

    private boolean isConnected(int atom1, int atom2) {
        for (int i = 0; i < this.cHtab[atom1].length; ++i) {
            if (this.cHtab[atom1][i] != atom2) continue;
            return true;
        }
        return false;
    }

    private void setAzaOHBond(int oh) {
        this.getAtomDistances(oh, 3);
        double npk = -100.0;
        int azan = -1;
        int azann = -1;
        for (int i = 0; i < this.sphereSize; ++i) {
            int a = this.sphere[i];
            int chg = this.atomArray[a].getCharge();
            if (this.dist[a] != 3 || this.pkaBasicType[a][1] != 901 || this.getAza(a) == -1 || chg != 0 || !(this.mpk0[a] > npk)) continue;
            npk = this.mpk0[a];
            azann = a;
            azan = this.getAza(a);
            if (this.getAza(azan) == a) continue;
            azan = -1;
            azann = -1;
        }
        if (azan != -1) {
            int c1 = this.atomArray[azan].getCharge();
            int c2 = this.atomArray[azann].getCharge();
            if (c1 != 1 && c2 != 1 && !this.isArA(azann) && !this.isInRing[azan]) {
                int x;
                if (this.HBT[this.hbtAIndex[azan]][9] == -1) {
                    this.HBT[this.hbtAIndex[oh]][9] = azann;
                    this.HBT[this.hbtAIndex[azann]][9] = oh;
                    this.HBT[this.hbtAIndex[azan]][9] = oh;
                } else if (this.HBT[this.hbtAIndex[azan]][9] != -1 && this.mpk0[x = this.HBT[this.hbtAIndex[azan]][9]] < this.mpk0[oh]) {
                    this.HBT[this.hbtAIndex[x]][9] = -1;
                    this.HBT[this.hbtAIndex[oh]][9] = azann;
                    this.HBT[this.hbtAIndex[azann]][9] = oh;
                    this.HBT[this.hbtAIndex[azan]][9] = oh;
                }
            }
        }
    }

    private void collectlogPHBond(int atom, int amin) {
        int protonCount = this.atomArray[atom].getAtno();
        if (protonCount != 16 && protonCount != 15 && this.hCount[amin] != 0 && this.isKetoHolder(atom)) {
            this.logPHBondCounter = this.isArNHAr(amin) ? (this.logPHBondCounter += 2) : ++this.logPHBondCounter;
            int n = amin;
            this.hCount[n] = this.hCount[n] - 1;
        }
    }

    public int getlogPHBondCount() {
        return this.logPHBondCounter;
    }

    private boolean isArNHAr(int amine) {
        int c = 0;
        for (int i = 0; i < this.cHtab[amine].length; ++i) {
            int nb = this.cHtab[amine][i];
            if (nb >= this.mol.getAtomCount() || !this.isArA(nb)) continue;
            ++c;
        }
        return c == 2;
    }

    private boolean isKetoHolder(int atom) {
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int nb = this.cHtab[atom][i];
            if (nb >= this.mol.getAtomCount() || !(this.cHtab[nb].length == 1 & this.atomArray[nb].getCharge() != -1) || this.getAtno(nb) != 8) continue;
            return true;
        }
        return this.pg.getCarboxy()[atom] == 1200;
    }

    protected void getAtomDistances(int atom, int MAXSPHERE) {
        int actAtom = atom;
        this.sphereSize = 0;
        this.dist = new int[this.mol.getAtomCount()];
        this.sphere = new int[this.mol.getAtomCount()];
        for (int i = 0; i < this.mol.getAtomCount(); ++i) {
            this.sphere[i] = -1;
        }
        int distance = 1;
        boolean sChange = true;
        int i = 0;
        while (distance < MAXSPHERE + 1 & sChange) {
            sChange = false;
            if (actAtom != -1) {
                int length = this.cHtab[actAtom].length;
                for (int j = 0; j < length; ++j) {
                    int sphereAtom = this.cHtab[actAtom][j];
                    if (sphereAtom >= this.mol.getAtomCount() || !(this.dist[sphereAtom] == 0 & sphereAtom != atom)) continue;
                    this.dist[sphereAtom] = distance;
                    this.sphere[this.sphereSize] = sphereAtom;
                    ++this.sphereSize;
                }
            }
            if (this.sphere[i] != -1) {
                actAtom = this.sphere[i];
                distance = this.dist[actAtom] + 1;
                sChange = true;
            } else {
                sChange = false;
            }
            ++i;
        }
    }

    protected void getDelIsland(int atom, int deep) {
        int actAtom = atom;
        this.sphereSize = 0;
        this.dist = new int[this.mol.getAtomCount()];
        this.sphere = new int[this.mol.getAtomCount()];
        for (int i = 0; i < this.mol.getAtomCount(); ++i) {
            this.sphere[i] = -1;
        }
        int distance = 1;
        boolean sChange = true;
        int i = 0;
        if (this.delocAble[atom] == 1) {
            this.sphere[this.sphereSize] = atom;
            ++this.sphereSize;
        }
        while (distance < deep + 1 & sChange) {
            sChange = false;
            if (actAtom != -1) {
                int length = this.cHtab[actAtom].length;
                for (int j = 0; j < length; ++j) {
                    int sphereAtom = this.cHtab[actAtom][j];
                    if (sphereAtom >= this.mol.getAtomCount() || this.dist[sphereAtom] != 0 || sphereAtom == atom || this.delocAble[sphereAtom] != 1) continue;
                    this.dist[sphereAtom] = distance;
                    this.sphere[this.sphereSize] = sphereAtom;
                    ++this.sphereSize;
                }
            }
            if (this.sphere[i] != -1) {
                actAtom = this.sphere[i];
                distance = this.dist[actAtom] + 1;
                sChange = true;
            } else {
                sChange = false;
            }
            if (++i != this.mol.getAtomCount()) continue;
            sChange = false;
        }
        this.dist[atom] = 0;
    }

    private boolean setStericHidrance(int atom) {
        int rInd = this.charge.getRings().getSmallestRingIndex(atom);
        int rc = 0;
        if (rInd != -1) {
            if (this.nonAring.length > 3) {
                for (int j = 0; j < this.nonAring[rInd].length; ++j) {
                    int rAtom = this.nonAring[rInd][j];
                    rc += this.charge.getAllNonAringIndex(rAtom);
                }
            }
            if (rc > 16) {
                int n = atom;
                this.cyanoInc[n] = this.cyanoInc[n] + -1.2;
                return true;
            }
            rInd = this.charge.getLargestRingIndex(atom);
            if (rInd != -1 && this.nonAring[rInd].length > 10 && (rc = this.getACount(rInd)) >= 8) {
                int n = atom;
                this.cyanoInc[n] = this.cyanoInc[n] + -1.2;
                return true;
            }
        }
        return false;
    }

    protected int getACount(int rInd) {
        int c = 0;
        for (int i = 0; i < this.nonAring[rInd].length; ++i) {
            int nb = this.nonAring[rInd][i];
            if (!this.isArA(nb)) continue;
            ++c;
        }
        return c;
    }

    protected boolean isRingHidrance(int atom1, int[] keyAtoms) {
        int n1 = keyAtoms[0];
        int n2 = keyAtoms[1];
        int n3 = keyAtoms[2];
        for (int i = 0; i < this.cHtab[n1].length; ++i) {
            if (!(this.cHtab[n1][i] != n2 & this.cHtab[n1][i] != n3)) continue;
            for (int j = 0; j < this.cHtab[atom1].length; ++j) {
                if (this.cHtab[n1][i] != this.cHtab[atom1][j]) continue;
                return true;
            }
        }
        return false;
    }

    public void setBasicAtoms() {
        int charge = 0;
        this.radicalBase = false;
        for (int i = 0; i < this.mol.getAtomCount(); ++i) {
            charge = this.atomArray[i].getCharge();
            int rc = this.atomArray[i].getRadical();
            int atno = this.getAtno(i);
            if (charge != 0) continue;
            if (atno == 7) {
                if (this.pg.getCarboxy()[i] == 100 || this.pg.getCarboxy()[i] == 400 || this.pg.getCarboxy()[i] == 1300 || this.pg.getCarboxy()[i] == 1200 || this.pg.getCarboxy()[i] == 200 || this.pg.getCarboxy()[i] == 500) continue;
                if (rc == 0) {
                    this.getNitrogenBasicType(i, false);
                    continue;
                }
                this.radicalBase = true;
                continue;
            }
            if (atno == 15) {
                if (rc == 0) {
                    if (this.cHtab[i].length != 3) continue;
                    this.getNitrogenBasicType(i, true);
                    continue;
                }
                this.radicalBase = true;
                continue;
            }
            if (atno != 8 && atno != 16) continue;
            if (this.cHtab[i].length == 1) {
                if (this.isNitrogen(this.cHtab[i][0])) {
                    if (rc == 0) {
                        this.getOxigenBasicType(i);
                        continue;
                    }
                    this.radicalBase = true;
                    continue;
                }
                if (this.pg.getCarboxy()[i] == 2) {
                    if (rc == 0) {
                        this.getOxigenBasicType(i);
                        continue;
                    }
                    this.radicalBase = true;
                    continue;
                }
                if (this.pg.getCarboxy()[i] == 1) {
                    if (rc == 0) {
                        this.getOxigenBasicType(i);
                        continue;
                    }
                    this.radicalBase = true;
                    continue;
                }
                if (this.pg.getCarboxy()[i] == 200 || this.pg.getCarboxy()[i] == 500) {
                    if (rc == 0) {
                        this.getOxigenBasicType(i);
                        continue;
                    }
                    this.radicalBase = true;
                    continue;
                }
                if (this.pg.getCarboxy()[i] != 300) continue;
                if (rc == 0) {
                    this.getOxigenBasicType(i);
                    continue;
                }
                this.radicalBase = true;
                continue;
            }
            if (this.cHtab[i].length != 2 || this.pg.getCarboxy()[i] != 900 && this.pg.getCarboxy()[i] != 1000 && this.pg.getCarboxy()[i] != 1100) continue;
            if (rc == 0) {
                this.getOxigenBasicType(i);
                continue;
            }
            this.radicalBase = true;
        }
    }

    private boolean isCondensedSemiArARing(int arIndx) {
        for (int i = 0; i < this.aAtoms[arIndx].length; ++i) {
            int ra = this.aAtoms[arIndx][i];
            if (this.sAra[ra] != 1) continue;
            return true;
        }
        return false;
    }

    private void getNitrogenBasicType(int atom, boolean isPhosphine) {
        int baseType = -2;
        int commonAtom = -1;
        int cAtomArNVinil = -1;
        int subBaseType = -1;
        boolean cond1 = false;
        boolean cond2 = false;
        boolean iminNitrogen = false;
        boolean atomIsImin = false;
        boolean guanidine = false;
        boolean amidine = false;
        boolean amide = false;
        boolean sAmide = false;
        boolean vinilAmine = false;
        boolean atomIsVinil = false;
        boolean thioamideFlag = false;
        boolean dRingfind = false;
        int ketoCarbon = -1;
        int[] iminN = new int[]{-1, -1, -1};
        int[] aminN = new int[]{-1, -1, -1};
        int aa = 0;
        int iminAtom = 0;
        int aminAtom = 0;
        int aminCounter = 0;
        int araAtom = 0;
        int vinilCount = 0;
        boolean hX = false;
        boolean heteroRing = false;
        if (this.isArA(atom)) {
            int[] ringInfo = this.charge.getRingInfo(atom);
            int ringSize = ringInfo[0];
            int ringIndex = ringInfo[1];
            if (ringSize == 5) {
                if (this.cHtab[atom].length == 2) {
                    this.pkaBasicType[atom][0] = 200;
                    if (this.isImidazoleRing(atom)) {
                        this.pkaBasicType[atom][1] = 10;
                    }
                    if (this.isCondensedSemiArARing(ringIndex)) {
                        this.pkaBasicType[atom][1] = 20;
                    }
                } else if (this.cHtab[atom].length == 3) {
                    this.pkaBasicType[atom][0] = 250;
                }
            } else if (this.cHtab[atom].length == 2) {
                if (this.isCovalentHydration(atom)) {
                    this.pkaBasicType[atom][0] = 500;
                    this.pkaBasicType[atom][1] = 125;
                } else {
                    int rType = this.isCrossArom(atom);
                    if (rType == 2) {
                        this.pkaBasicType[atom][0] = 600;
                    } else if (rType == 1) {
                        this.pkaBasicType[atom][0] = 500;
                        this.pkaBasicType[atom][1] = 122;
                    } else if (rType == 8) {
                        this.pkaBasicType[atom][0] = 500;
                        this.pkaBasicType[atom][1] = 222;
                    } else if (rType == 15) {
                        this.pkaBasicType[atom][0] = 500;
                        this.pkaBasicType[atom][1] = 322;
                    } else if (rType == 25) {
                        this.pkaBasicType[atom][0] = 500;
                        this.pkaBasicType[atom][1] = 422;
                    } else if (rType == 35) {
                        this.pkaBasicType[atom][0] = 500;
                        this.pkaBasicType[atom][1] = 522;
                    } else {
                        this.pkaBasicType[atom][0] = 500;
                    }
                }
            }
        } else if (!this.isArA(atom)) {
            int y;
            int inf;
            int aat;
            int nhAcidCount;
            int j;
            int nb;
            int i;
            for (i = 0; i < this.cHtab[atom].length; ++i) {
                int bondOrder;
                nb = this.cHtab[atom][i];
                if (this.isArA(nb)) {
                    int[] rinfo;
                    cond1 = true;
                    araAtom = nb;
                    ++aa;
                    this.pkaBasicType[atom][4] = nb;
                    if (heteroRing || (rinfo = this.charge.findLargestRing(araAtom))[1] == -1) continue;
                    heteroRing = true;
                    continue;
                }
                if (nb >= this.mol.getAtomCount()) continue;
                int atno = this.getAtno(nb);
                if (atno != 6 && atno != 7 && atno != 15) {
                    hX = true;
                    if (this.pg.getCarboxy()[nb] == 900 || this.pg.getCarboxy()[nb] == 1800) {
                        this.pkaBasicType[atom][5] = 10;
                        if (this.pg.getCarboxy()[nb] == 1800) {
                            this.pkaBasicType[atom][1] = subBaseType = 55;
                        }
                    } else {
                        this.pkaBasicType[atom][5] = this.pg.getChargeState()[nb] == 1000 ? 10 : 20;
                    }
                }
                if (this.getBondType(this.bHtab[nb][atom]) == 2) {
                    iminNitrogen = true;
                    aminCounter = 0;
                    atomIsImin = true;
                } else if (this.isImin(atom)) {
                    iminNitrogen = true;
                    aminCounter = 0;
                    atomIsImin = true;
                } else {
                    iminNitrogen = false;
                    aminCounter = 1;
                }
                for (j = 0; j < this.cHtab[nb].length; ++j) {
                    int nnb = this.cHtab[nb][j];
                    if (nnb == atom || nnb >= this.mol.getAtomCount()) continue;
                    if (this.isArA(nnb)) {
                        cond2 = true;
                    }
                    bondOrder = this.getBondType(this.bHtab[nb][nnb]);
                    atno = this.getAtno(nnb);
                    if (bondOrder > 1 & bondOrder < 4) {
                        if (atno == 6) {
                            if (!isPhosphine && vinilCount < 3) {
                                this.nVinilInfo[this.getNind((int)atom)][vinilCount] = nb;
                                this.nVinilInfo[this.getNind((int)atom)][vinilCount + 3] = nnb;
                            }
                            ++vinilCount;
                            vinilAmine = true;
                            atomIsVinil = true;
                            continue;
                        }
                        if (atno == 8) {
                            amide = true;
                            ketoCarbon = nb;
                            continue;
                        }
                        if (atno == 16 || atno == 34) {
                            sAmide = true;
                            amide = true;
                            ketoCarbon = nb;
                            continue;
                        }
                        if (atno != 7) continue;
                        if (iminAtom < 3) {
                            iminN[iminAtom] = nnb;
                            iminNitrogen = true;
                            ++iminAtom;
                        }
                        if (!isPhosphine) {
                            this.nVinilInfo[this.getNind((int)atom)][vinilCount] = nb;
                            this.nVinilInfo[this.getNind((int)atom)][vinilCount + 3] = nnb;
                        }
                        ++vinilCount;
                        vinilAmine = true;
                        atomIsVinil = true;
                        continue;
                    }
                    if (bondOrder != 1) continue;
                    if (atno == 7) {
                        if (!this.isImin(nnb)) {
                            if (aminAtom >= 3) continue;
                            aminN[aminAtom] = nnb;
                            ++aminCounter;
                            ++aminAtom;
                            continue;
                        }
                        if (iminAtom < 3) {
                            iminN[iminAtom] = nnb;
                            iminNitrogen = true;
                            ++iminAtom;
                        }
                        vinilAmine = true;
                        continue;
                    }
                    if (atno != 6) continue;
                    cAtomArNVinil = nb;
                }
                bondOrder = this.getBondType(this.bHtab[nb][atom]);
                if (bondOrder != 2) continue;
                if (aminCounter >= 2 && iminNitrogen) {
                    guanidine = true;
                } else if (aminCounter == 1 && iminNitrogen) {
                    amidine = true;
                }
                commonAtom = nb;
            }
            if (amide) {
                if (cond1) {
                    baseType = 0;
                    this.pkaBasicType[atom][4] = ketoCarbon;
                } else {
                    baseType = cond2 ? 2 : 2;
                }
                if (sAmide) {
                    subBaseType = 201;
                }
            } else if (guanidine) {
                baseType = 3;
                subBaseType = 1;
                for (i = 0; i < 3; ++i) {
                    if (aminN[i] == -1) continue;
                    this.pkaBasicType[aminN[i]][10] = 31;
                }
                nhAcidCount = 0;
                for (int i2 = 0; i2 < 3; ++i2) {
                    int tt;
                    if (aminN[i2] == -1 || (tt = this.pg.getCarboxy()[aminN[i2]]) != 200 && tt != 600 && tt != 800 && tt != 500) continue;
                    ++nhAcidCount;
                }
                if (cond1) {
                    subBaseType = 12;
                    if (this.isInRing[atom]) {
                        int rIdx = this.charge.getRings().getSmallestRingIndex(atom);
                        if (this.isPolarizedRing(rIdx)) {
                            subBaseType = 14;
                            if (nhAcidCount > 0) {
                                subBaseType = 17;
                            }
                        } else if (this.isDelocAbleRing(rIdx)) {
                            if (nhAcidCount > 0) {
                                subBaseType = 17;
                            }
                        } else if (nhAcidCount > 0) {
                            subBaseType = 17;
                            if (nhAcidCount > 1) {
                                subBaseType = 18;
                            }
                        }
                    } else if (nhAcidCount > 0) {
                        subBaseType = 17;
                        if (nhAcidCount > 1) {
                            subBaseType = 18;
                        }
                    }
                } else if (nhAcidCount != 0) {
                    subBaseType = this.isInRing[atom] ? (this.isPolarizedRing(this.charge.getRings().getSmallestRingIndex(atom)) ? 11 : 51) : 55;
                }
            } else if (amidine) {
                int i3;
                subBaseType = 2;
                baseType = 3;
                for (i = 0; i < 3; ++i) {
                    if (aminN[i] == -1) continue;
                    this.pkaBasicType[aminN[i]][10] = 32;
                    this.pkaBasicType[atom][11] = aminN[i];
                }
                if (this.isInRing[atom]) {
                    dRingfind = false;
                    for (int w = 0; w < 3 && !dRingfind; ++w) {
                        int ri;
                        if (aminN[w] == -1 || !this.isInRing[aminN[w]] || this.isTheSameRing(ri = this.charge.getRings().getSmallestRingIndex(atom), aminN[w])) continue;
                        subBaseType = 130;
                        dRingfind = true;
                    }
                }
                nhAcidCount = 0;
                for (i3 = 0; i3 < 3; ++i3) {
                    int t;
                    if (aminN[i3] == -1 || (t = this.pg.getCarboxy()[aminN[i3]]) != 200 && t != 600 && t != 800 && t != 500) continue;
                    ++nhAcidCount;
                    if (this.pg.getGroupType()[aminN[i3]] != 11) continue;
                    thioamideFlag = true;
                }
                if (cond1) {
                    subBaseType = dRingfind ? 136 : 120;
                    if (heteroRing) {
                        subBaseType = 122;
                    } else if (this.isInRing[atom] && this.isDelocAbleRing(this.charge.getRings().getSmallestRingIndex(atom))) {
                        subBaseType = dRingfind ? 135 : 121;
                    }
                    if (nhAcidCount > 0) {
                        subBaseType = thioamideFlag ? (heteroRing ? 126 : 125) : (heteroRing ? 128 : 127);
                    }
                } else if (nhAcidCount > 0) {
                    subBaseType = 22;
                    if (this.isInRing[atom]) {
                        subBaseType = 72;
                        if (this.isDelocAbleRing(this.charge.getRings().getSmallestRingIndex(atom))) {
                            subBaseType = 75;
                        }
                    }
                }
                for (i3 = 0; i3 < 3; ++i3) {
                    if (aminN[i3] == -1 || !this.isHaloAmine(aminN[i3])) continue;
                    this.pkaBasicType[atom][5] = 10;
                }
            } else if (cond1) {
                baseType = 1;
                if (aa == 2 && this.isImin(atom)) {
                    subBaseType = 244;
                    commonAtom = atom;
                }
                if (aa == 3) {
                    subBaseType = 144;
                } else if (heteroRing) {
                    subBaseType = atomIsVinil ? 15 : 11;
                } else if (atomIsVinil) {
                    subBaseType = 15;
                }
                if (atomIsImin) {
                    subBaseType = 90;
                    commonAtom = cAtomArNVinil;
                    boolean forb = false;
                    int ty = 0;
                    if (commonAtom != -1) {
                        for (j = 0; j < this.cHtab[commonAtom].length; ++j) {
                            nb = this.cHtab[commonAtom][j];
                            if (nb >= this.mol.getAtomCount() || nb == atom) continue;
                            if (this.isArA(nb)) {
                                subBaseType = 901;
                                forb = true;
                                continue;
                            }
                            if (this.delocAble[nb] == 1) {
                                if (this.getAtno(nb) != 6 || forb) continue;
                                subBaseType = this.pg.getCarboxy()[nb] == 200 || this.pg.getCarboxy()[nb] == 500 ? 904 : 902;
                                forb = true;
                                ty = this.pg.getGroupType()[nb];
                                if (ty != 18 && ty != 11 && ty != 12) continue;
                                subBaseType = 905;
                                continue;
                            }
                            if (forb) continue;
                            subBaseType = 903;
                        }
                    } else {
                        subBaseType = 903;
                    }
                }
            } else if (vinilAmine) {
                baseType = 3;
                if (subBaseType == -1) {
                    baseType = -2;
                    if (vinilCount == 1) {
                        subBaseType = 20;
                    } else if (vinilCount > 1) {
                        subBaseType = 25;
                    }
                }
            }
            if ((aat = this.getAliphaticAminType(atom)) == 3 && aa == 2) {
                subBaseType = 155;
            }
            this.pkaBasicType[atom][3] = aat;
            if (this.pg.getCarboxy()[atom] == 800) {
                baseType = -2;
                commonAtom = -1;
                subBaseType = -1;
                aat = -1;
            }
            this.pkaBasicType[atom][0] = baseType;
            this.pkaBasicType[atom][1] = subBaseType;
            this.pkaBasicType[atom][2] = commonAtom;
            if (this.pkaBasicType[atom][1] == 55) {
                if (this.isInRing[commonAtom]) {
                    this.pkaBasicType[atom][5] = this.charge.getRings().getSmallestRingIndex(commonAtom);
                } else if (this.isArA(atom)) {
                    this.pkaBasicType[atom][5] = this.charge.getRings().findSmallestAraRing(commonAtom);
                }
            } else if (commonAtom != -1 && this.isInRing[commonAtom] && !this.isInRing[atom] && baseType == 3 && subBaseType == 22 && ((inf = this.charge.isSemiAromaticRing(y = this.charge.getRings().getSmallestRingIndex(commonAtom))) == 100 || inf == 200)) {
                this.pkaBasicType[commonAtom][4] = y;
            }
            if (aat == 4 & (baseType < 0 || baseType == 2)) {
                if (baseType == 2) {
                    this.pkaBasicType[atom][0] = baseType = 5;
                    if (sAmide) {
                        this.pkaBasicType[atom][1] = 11;
                    }
                } else if (baseType < 0) {
                    this.pkaBasicType[atom][0] = baseType = 5;
                }
                if (baseType == 5 && this.isInRing[atom]) {
                    this.pkaBasicType[atom][5] = this.charge.getRings().getSmallestRingIndex(atom);
                }
                this.calcVinilPath(atom, 12);
                if (this.maxDelocLength > 2) {
                    this.storeVinilPath(atom);
                    if (amide & guanidine) {
                        subBaseType = 60;
                    } else if (amide) {
                        subBaseType = 50;
                        if (sAmide) {
                            subBaseType = 51;
                        }
                    } else {
                        subBaseType = !this.vinilPathBreaked ? 40 : (hX ? 40 : 402);
                    }
                    this.pkaBasicType[atom][1] = subBaseType;
                }
            }
            if (baseType < 0 & aat > 0) {
                int semiAType;
                this.pkaBasicType[atom][0] = 1000;
                if (this.getAza(atom) != -1 && this.isAraNBexist(this.getAza(atom)) && !isPhosphine) {
                    subBaseType = 44;
                    if (this.pg.getCarboxy()[this.getAza(atom)] == 200 || this.pg.getCarboxy()[this.getAza(atom)] == 500) {
                        subBaseType = 444;
                    }
                    this.pkaBasicType[atom][1] = subBaseType;
                    this.pkaBasicType[atom][2] = this.getAza(atom);
                }
                if (isPhosphine) {
                    this.pkaBasicType[atom][0] = 2000;
                }
                int n = semiAType = isPhosphine ? 0 : this.isSemiAromaticRingMember(atom);
                if (semiAType != 0) {
                    if (semiAType == 500) {
                        this.pkaBasicType[atom][7] = 100;
                    } else if (semiAType == -500) {
                        int ri = this.charge.getRings().getSmallestRingIndex(atom);
                        if (this.nonAring[ri].length != 5) {
                            this.pkaBasicType[atom][7] = 200;
                            this.pkaBasicType[atom][8] = ri;
                        } else if (this.nonAring[ri].length == 5) {
                            this.pkaBasicType[atom][7] = 300;
                            this.pkaBasicType[atom][8] = ri;
                        }
                    }
                } else if (aat == 3 && this.isInCondensedRing(atom)) {
                    this.pkaBasicType[atom][9] = 100;
                }
            }
            if (this.isAraNBexist(atom) && !isPhosphine && this.isInRing[atom]) {
                int info = this.charge.isSemiAromaticRing(this.charge.getLargestRingIndex(atom));
                if (info == 200) {
                    if (aat == 3 || aat == 2) {
                        this.pkaBasicType[atom][1] = subBaseType = 17;
                    }
                } else if (info == 100 && (aat == 3 || aat == 2)) {
                    this.pkaBasicType[atom][1] = subBaseType = 16;
                }
            }
        }
    }

    boolean isAraNBexist(int ai) {
        if (this.isArA(ai)) {
            return false;
        }
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.mol.getAtomCount() || !this.isArA(nb)) continue;
            this.actAraNb = nb;
            return true;
        }
        return false;
    }

    private boolean isImidazoleRing(int atom) {
        int i;
        int ringInfo = -1;
        int nCount = 0;
        boolean find = false;
        for (i = this.aAtoms.length - 1; i > -1 && !find; --i) {
            for (int j = 0; j < this.aAtoms[i].length && !find; ++j) {
                if (this.aAtoms[i][j] != atom) continue;
                ringInfo = i;
                find = true;
            }
        }
        if (this.aAtoms[ringInfo].length == 5) {
            for (i = 0; i < 5; ++i) {
                if (!this.isNitrogen(this.aAtoms[ringInfo][i])) continue;
                ++nCount;
            }
        }
        return nCount == 2;
    }

    private boolean isCovalentHydration(int atom) {
        int i = 0;
        int riS = -1;
        int riL = -1;
        riS = this.charge.getRings().findSmallestAraRing(atom);
        int nCount = 0;
        if (riS > -1 && this.aAtoms[riS].length == 6) {
            for (i = 0; i < 6; ++i) {
                if (!this.isNitrogen(this.aAtoms[riS][i]) || this.getAza(this.aAtoms[riS][i]) != -1) continue;
                ++nCount;
            }
        }
        if (nCount == 2 || nCount == 3) {
            int a;
            int k;
            riL = this.charge.getRings().getLargestAraRingIndex(atom);
            int L = this.aAtoms[riL].length;
            if (L > 10) {
                return false;
            }
            if (L <= 6) {
                return false;
            }
            int b = -1;
            int c = 0;
            double s = -1.0;
            for (k = 0; k < this.aAtoms[riL].length; ++k) {
                a = this.aAtoms[riL][k];
                if (!this.isTheSameAraRing(riL, a)) continue;
                if (this.getAtno(a) == 6) {
                    if (!(this.Qsum[a] > s) || !this.isRCH(a)) continue;
                    s = this.Qsum[a];
                    b = a;
                    continue;
                }
                if (!this.isNitrogen(a)) continue;
                ++c;
            }
            if (c > nCount) {
                if (b != -1) {
                    riS = this.charge.getRings().findSmallestAraRing(b);
                    if (!this.isTheSameAraRing(riS, atom)) {
                        return false;
                    }
                    for (k = 0; k < this.aAtoms[riS].length; ++k) {
                        a = this.aAtoms[riS][k];
                        if (!this.isNitrogen(a) || !(this.Qsum[a] < this.Qsum[atom])) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private boolean isHaloAmine(int amine) {
        for (int i = 0; i < this.cHtab[amine].length; ++i) {
            int nb = this.cHtab[amine][i];
            if (nb >= this.mol.getAtomCount() || this.pg.getCarboxy()[nb] != 1400) continue;
            return true;
        }
        return false;
    }

    private boolean isInCondensedRing(int amine) {
        if (this.isInRing[amine]) {
            int ri1 = this.charge.getRings().getSmallestRingIndex(amine);
            this.setBasicRindex(ri1);
            for (int i = 0; i < this.nonAring[ri1].length; ++i) {
                int ra = this.nonAring[ri1][i];
                for (int j = 0; j < this.cHtab[ra].length; ++j) {
                    int ri2;
                    int nb = this.cHtab[ra][j];
                    if (nb >= this.mol.getAtomCount() || this.pkaBasicType[nb][8] == ri1 || !this.isInRing[nb] || !this.isFused(ri2 = this.charge.getRings().getSmallestRingIndex(nb), ra)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isFused(int rIndex, int atom) {
        for (int i = 0; i < this.nonAring[rIndex].length; ++i) {
            if (this.nonAring[rIndex][i] != atom) continue;
            return true;
        }
        return false;
    }

    private void setBasicRindex(int rInd) {
        for (int i = 0; i < this.nonAring[rInd].length; ++i) {
            this.pkaBasicType[this.nonAring[rInd][i]][8] = rInd;
        }
    }

    private int isSemiAromaticRingMember(int atom) {
        block7: {
            int i;
            int s = this.pkaBasicType[atom][1];
            int info = 0;
            if (s != 20 && s != 25) break block7;
            if (!this.isInRing[atom]) {
                for (i = 0; i < 6; ++i) {
                    int nb = this.nVinilInfo[this.getNind(atom)][i];
                    if (nb == -1 || !this.isInRing[nb] || (info = this.charge.isSemiAromaticRing(this.charge.getLargestRingIndex(nb))) != 100 && info != 200) continue;
                    return 500;
                }
            } else {
                int rInd = this.charge.getRings().getSmallestRingIndex(atom);
                info = this.charge.isSemiAromaticRing(rInd);
                if (info == 200) {
                    int n = atom;
                    this.cyanoInc[n] = this.cyanoInc[n] + -1.3;
                    return 500;
                }
                if (info == 100) {
                    return -500;
                }
                for (i = 0; i < 6; ++i) {
                    int nb = this.nVinilInfo[this.getNind(atom)][i];
                    if (nb == -1) continue;
                    for (int k = 0; k < this.cHtab[nb].length; ++k) {
                        int ri;
                        int nnb = this.cHtab[nb][k];
                        if (nnb >= this.mol.getAtomCount() || !this.isInRing[nnb] || nnb == atom || (ri = this.charge.getLargestRingIndex(nnb)) == rInd || (info = this.charge.isSemiAromaticRing(ri)) != 100 && info != 200) continue;
                        return 500;
                    }
                }
            }
        }
        return 0;
    }

    private int isCrossArom(int atom) {
        int nb;
        int i;
        int nb1 = this.cHtab[atom][0];
        int nb2 = this.cHtab[atom][1];
        int a = 0;
        int b = 0;
        int k = 0;
        int[] aInd = new int[]{-1, -1};
        int[] bInd = new int[]{-1, -1};
        int rs = this.charge.getRings().findSmallestAraRing(atom);
        int rL = this.charge.getRings().getLargestAraRingIndex(atom);
        boolean finda = false;
        boolean findb = false;
        for (i = 0; i < this.cHtab[nb1].length; ++i) {
            nb = this.cHtab[nb1][i];
            if (nb == atom || !this.isArA(nb) || this.mol.getBond(this.bHtab[nb][nb1]).getType() != 4) continue;
            ++a;
            if (this.isTheSameAraRing(rs, nb)) continue;
            if (k < 2) {
                aInd[k] = nb;
                ++k;
            }
            finda = true;
        }
        k = 0;
        for (i = 0; i < this.cHtab[nb2].length; ++i) {
            nb = this.cHtab[nb2][i];
            if (nb == atom || !this.isArA(nb) || this.mol.getBond(this.bHtab[nb][nb2]).getType() != 4) continue;
            ++b;
            if (this.isTheSameAraRing(rs, nb)) continue;
            if (k < 2) {
                bInd[k] = nb;
                ++k;
            }
            findb = true;
        }
        int rv = 0;
        if (a == 2 && b == 2) {
            rv = 2;
        } else if (a == 2) {
            rv = 1;
            if (finda && this.isBayType(aInd)) {
                rv = 8;
            }
        } else if (b == 2) {
            rv = 1;
            if (findb && this.isBayType(bInd)) {
                rv = 8;
            }
        }
        int nc = this.getHeteroAraNCount(rL);
        if (this.aAtoms[rL].length > 10) {
            if (rv == 1 && nc > 1) {
                rv = 15;
            } else if (rv == 8 && nc > 2) {
                rv = 25;
            } else if (rv == 2 && nc > 1) {
                rv = 35;
            }
        }
        return rv;
    }

    private boolean isBayType(int[] Ind) {
        int nb = Ind[0];
        for (int i = 0; i < this.cHtab[nb].length; ++i) {
            int y = this.cHtab[nb][i];
            if (!this.isArA(y) || this.mol.getBond(this.bHtab[nb][y]).getType() != 4 || !this.isNitrogen(y)) continue;
            return true;
        }
        return false;
    }

    private boolean isImin(int atom) {
        double charge;
        if (this.cHtab[atom].length == 2 & (charge = (double)this.atomArray[atom].getCharge()) != -1.0) {
            return true;
        }
        return this.cHtab[atom].length == 3 & charge == 1.0;
    }

    private int getAliphaticAminType(int atom) {
        int nb = this.cHtab[atom].length;
        int hCount = 0;
        int type = 0;
        for (int i = 0; i < nb; ++i) {
            if (this.getAtno(this.cHtab[atom][i]) != 1) continue;
            ++hCount;
        }
        if (hCount >= 2) {
            type = 1;
        } else if (hCount == 1 & nb == 3) {
            type = 2;
        } else if (hCount == 0 & nb == 3) {
            type = 3;
        } else if (nb == 2) {
            type = 4;
        }
        this.pkaBasicType[atom][3] = type;
        return type;
    }

    private void storeVinilPath(int atom) {
        int j = 0;
        int ind = this.getNind(atom);
        for (int i = 0; i < this.sphereSize && j < 12; ++j, ++i) {
            this.vinilPath[ind][j] = this.sphere[i];
        }
    }

    private void calcVinilPath(int atom, int maxDistance) {
        int actAtom = atom;
        this.sphereSize = 0;
        this.dist = new int[this.mol.getAtomCount()];
        this.sphere = new int[this.mol.getAtomCount()];
        for (int i = 0; i < this.mol.getAtomCount(); ++i) {
            this.sphere[i] = -1;
        }
        int distance = 1;
        boolean sChange = true;
        boolean direction = false;
        int i = 0;
        int bondOrder = 0;
        this.maxDelocLength = 0;
        boolean[] usedGroupIndex = new boolean[this.mol.getAtomCount()];
        for (int k = 0; k < this.mol.getAtomCount(); ++k) {
            usedGroupIndex[k] = false;
        }
        this.vinilPathBreaked = false;
        while (distance < maxDistance + 1 && sChange) {
            sChange = false;
            if (actAtom != -1) {
                int length = this.cHtab[actAtom].length;
                for (int j = 0; j < length; ++j) {
                    int sphereAtom = this.cHtab[actAtom][j];
                    if (sphereAtom >= this.mol.getAtomCount()) continue;
                    if (actAtom == atom) {
                        bondOrder = this.mol.getBond(this.bHtab[atom][sphereAtom]).getType();
                        direction = bondOrder == 2;
                    }
                    if (!direction || !(this.dist[sphereAtom] == 0 & sphereAtom != atom) || this.delocAble[sphereAtom] != 1) continue;
                    if (!this.isArA(sphereAtom) && this.pg.getCarboxy()[sphereAtom] == -1) {
                        this.dist[sphereAtom] = distance;
                        this.sphere[this.sphereSize] = sphereAtom;
                        ++this.sphereSize;
                        continue;
                    }
                    if (this.pg.getGroupIndex()[sphereAtom] == -1 || usedGroupIndex[this.pg.getGroupIndex()[sphereAtom]]) continue;
                    usedGroupIndex[this.pg.getGroupIndex()[sphereAtom]] = true;
                    if (this.getVinilBreakerInc(sphereAtom) == 0.0) continue;
                    this.vinilPathBreaked = true;
                }
            }
            if (this.sphere[i] != -1) {
                actAtom = this.sphere[i];
                distance = this.dist[actAtom] + 1;
                sChange = true;
                direction = true;
            } else {
                sChange = false;
            }
            ++i;
        }
        if (this.sphereSize != 0) {
            this.dist[atom] = 0;
            this.maxDelocLength = this.sphereSize + 1;
        }
    }

    protected double getVinilBreakerInc(int atom) {
        int t = this.pg.getCarboxy()[atom];
        double sum = 0.0;
        switch (t) {
            case 1: {
                sum = -2.5;
                break;
            }
            case 200: {
                sum = -2.5;
                break;
            }
            case 100: {
                sum = -2.2;
                break;
            }
            case 300: {
                sum = -1.0;
                break;
            }
            case 500: {
                sum = -2.2;
                break;
            }
            case 2: {
                sum = -1.5;
                break;
            }
            case 1200: {
                sum = -2.5;
                break;
            }
            case 1300: {
                sum = -2.5;
                break;
            }
            case 800: {
                sum = -2.0;
                break;
            }
            case 600: {
                sum = -2.0;
                break;
            }
            case 400: {
                sum = -2.5;
                break;
            }
            case 700: {
                sum = -2.0;
            }
        }
        return sum;
    }

    private boolean isH2OType(int a) {
        int c = 0;
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            if (this.cHtab[a][i] < this.mol.getAtomCount()) continue;
            ++c;
        }
        return c == 2;
    }

    private void getOxigenBasicType(int atom) {
        int UNKNOWN = -1;
        int NOTDELOC = -2;
        int aN = -1;
        for (int i = 0; i < 11; ++i) {
            this.pkaBasicType[atom][i] = UNKNOWN;
        }
        if (this.pg.getCarboxy()[atom] == 900) {
            int baseType;
            if (this.isArA(this.cHtab[atom][0]) || this.isArA(this.cHtab[atom][1])) {
                int baseType2;
                this.pkaBasicType[atom][0] = baseType2 = 2600;
                return;
            }
            this.pkaBasicType[atom][0] = baseType = 2500;
            if (this.isH2OType(atom)) {
                this.pkaBasicType[atom][1] = 100;
            }
            return;
        }
        if (this.pg.getCarboxy()[atom] == 1000) {
            int baseType;
            this.pkaBasicType[atom][0] = baseType = 2700;
            return;
        }
        if (this.pg.getCarboxy()[atom] == 1100) {
            int baseType;
            this.pkaBasicType[atom][0] = baseType = 2800;
            return;
        }
        if (this.isArA(this.cHtab[atom][0]) && this.getAtno(this.cHtab[atom][0]) == 7) {
            int baseType = 2000;
            aN = this.cHtab[atom][0];
            this.pkaBasicType[atom][0] = baseType;
            this.pkaBasicType[atom][3] = aN;
        } else if (this.pg.getCarboxy()[atom] == 1200) {
            int baseType = 3000;
            this.pkaBasicType[atom][3] = aN = this.cHtab[atom][0];
            for (int j = 0; j < this.cHtab[aN].length; ++j) {
                if (!this.isArA(this.cHtab[aN][j])) continue;
                baseType = 4000;
                if (this.getAza(aN) == -1) continue;
                this.pkaBasicType[atom][1] = 100;
            }
            this.pkaBasicType[atom][0] = baseType;
        } else {
            if (this.pg.getCarboxy()[atom] == 2 && this.cHtab[atom].length == 1) {
                int baseType;
                this.pkaBasicType[atom][0] = baseType = 2900;
                return;
            }
            if (this.pg.getCarboxy()[atom] == 100) {
                int baseType;
                this.pkaBasicType[atom][0] = baseType = 4100;
                this.pkaBasicType[atom][3] = aN = this.cHtab[atom][0];
                return;
            }
            if (this.pg.getCarboxy()[atom] == 1300) {
                int baseType;
                this.pkaBasicType[atom][0] = baseType = 4200;
                this.pkaBasicType[atom][3] = aN = this.cHtab[atom][0];
                this.isAraNBexist(aN);
                this.pkaBasicType[atom][2] = this.charge.getRings().getLargestAraRingIndex(this.actAraNb);
                return;
            }
            if (this.pg.getCarboxy()[atom] == 1) {
                int baseType;
                this.pkaBasicType[atom][0] = baseType = 4300;
                int alphaAtom = this.cHtab[atom].length == 2 ? (this.cHtab[atom][0] < this.mol.getAtomCount() ? this.cHtab[atom][0] : this.cHtab[atom][1]) : this.cHtab[atom][0];
                this.pkaBasicType[atom][2] = alphaAtom;
                if (this.isBetaAra(alphaAtom)) {
                    this.pkaBasicType[atom][1] = 200;
                } else if (this.isVinilTypeKeto(alphaAtom, atom)) {
                    this.pkaBasicType[atom][1] = 300;
                }
            } else if (this.pg.getCarboxy()[atom] == 200 || this.pg.getCarboxy()[atom] == 500) {
                int alphaAtom = -1;
                if (this.cHtab[atom].length == 2 && this.pg.getChargeState()[atom] == 900) {
                    alphaAtom = this.cHtab[atom][0] < this.mol.getAtomCount() ? this.cHtab[atom][0] : this.cHtab[atom][1];
                } else if (this.cHtab[atom].length == 1) {
                    alphaAtom = this.cHtab[atom][0];
                }
                if (alphaAtom != -1) {
                    int baseType;
                    int[] y = this.getNbAtom(alphaAtom);
                    if (y == null) {
                        return;
                    }
                    if (y[0] != -1) {
                        int subBaseType;
                        this.pkaBasicType[atom][2] = y[0];
                        if (y[1] != -1) {
                            this.pkaBasicType[atom][3] = y[1];
                            subBaseType = this.pg.getCarboxy()[atom] == 500 ? 150 : 100;
                        } else {
                            subBaseType = this.pg.getCarboxy()[atom] == 500 ? 175 : 200;
                        }
                        this.pkaBasicType[atom][1] = subBaseType;
                    }
                    this.pkaBasicType[atom][0] = baseType = 4350;
                    if (this.isInRing[alphaAtom]) {
                        int ri;
                        this.pkaBasicType[atom][7] = ri = this.charge.getRings().getSmallestRingIndex(alphaAtom);
                        int w = this.charge.isSemiAromaticRing(ri);
                        if (w == 100 || w == 200) {
                            int n = 220;
                        }
                    }
                }
            } else if (this.pg.getCarboxy()[atom] == 300) {
                int alphaAtom;
                int baseType = 4400;
                if (this.cHtab[atom].length == 2 && this.pg.getChargeState()[atom] == 900) {
                    alphaAtom = this.cHtab[atom][0] < this.mol.getAtomCount() ? this.cHtab[atom][0] : this.cHtab[atom][1];
                } else if (this.cHtab[atom].length == 1 && this.pg.getChargeState()[atom] != 1000) {
                    alphaAtom = this.cHtab[atom][0];
                } else {
                    return;
                }
                this.pkaBasicType[atom][0] = baseType;
                this.pkaBasicType[atom][2] = alphaAtom;
                if (this.isBetaAra(alphaAtom)) {
                    this.pkaBasicType[atom][1] = 200;
                }
            } else {
                this.pkaBasicType[atom][0] = NOTDELOC;
            }
        }
    }

    private int[] getNbAtom(int ai) {
        int j = 0;
        int[] k = new int[]{-1, -1, -1, -1, -1, -1, -1, -1};
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.mol.getAtomCount() || this.getAtno(nb = this.cHtab[ai][i]) != 7) continue;
            if (this.isQuaternerAmine(nb)) {
                return null;
            }
            k[j] = nb;
            ++j;
        }
        return k;
    }

    public boolean isQuaternerAmine(int ai) {
        return this.cHtab[ai].length == 4 && this.atomArray[ai].getCharge() == 1 && this.atomArray[ai].getImplicitHcount() == 0;
    }

    private boolean isVinilTypeKeto(int alpha, int keto) {
        int k = 0;
        boolean find = false;
        for (int i = 0; i < this.cHtab[alpha].length; ++i) {
            int nb = this.cHtab[alpha][i];
            if (nb == keto || nb >= this.mol.getAtomCount()) continue;
            find = false;
            for (int j = 0; !find && j < this.cHtab[nb].length; ++j) {
                int nnb = this.cHtab[nb][j];
                if (nnb == alpha || nnb >= this.mol.getAtomCount() || this.mol.getBond(this.bHtab[nb][nnb]).getType() < 2) continue;
                if (k < 6) {
                    this.pkaBasicType[keto][11 - k] = nnb;
                    this.pkaBasicType[keto][11 - ++k] = nb;
                }
                ++k;
                find = true;
            }
        }
        return k != 0;
    }

    private boolean isBetaAra(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.mol.getAtomCount() || !this.isArA(nb)) continue;
            return true;
        }
        return false;
    }

    public void setMolecule(Molecule m) {
        this.mol = m;
        this.charge.setMolecule(this.mol);
        this.charge.calcCharges();
        this.setDelegatedValues(this.charge);
    }

    protected double getAliAminCount() {
        return this.aliAminCount;
    }

    protected int[] getnVinilInfo(int atom) {
        return this.nVinilInfo[this.getNind(atom)];
    }

    protected int getBaseType(int atom) {
        return this.pkaBasicType[atom][0];
    }

    private int getAza(int index) {
        if (this.aza == null) {
            this.aza = Aza.calculate(this.mol);
        }
        if (index < 0 || index >= this.aza.length) {
            return -1;
        }
        return this.aza[index];
    }

    protected int[] getAza() {
        if (this.aza == null) {
            this.aza = Aza.calculate(this.mol);
        }
        return this.aza;
    }

    protected PolarGroups getPolarGroups() {
        if (this.pg == null) {
            this.pg = new PolarGroups(this.mol);
            this.pg.setGroups();
        }
        return this.pg;
    }

    protected int getAtno(int index) {
        if (index < 0 || index >= this.mol.getAtomCount()) {
            return 1;
        }
        return this.mol.getAtom(index).getAtno();
    }

    protected boolean getCriticalErrorFlag() {
        if (this.charge == null) {
            return false;
        }
        return this.charge.getCriticalErrorFlag();
    }

    protected Molecule getMolecule() {
        return this.mol;
    }

    protected int getValenceState(int atomIndex) {
        if (atomIndex < 0 || atomIndex >= this.mol.getAtomCount()) {
            return 0;
        }
        MolAtom atom = this.mol.getAtom(atomIndex);
        int vs = atom.getImplicitHcount();
        for (int i = 0; i < atom.getBondCount(); ++i) {
            vs += atom.getBond(i).getType();
        }
        return vs;
    }

    private boolean isSingleBonded(int atomIndex) {
        if (atomIndex < 0 || atomIndex >= this.mol.getAtomCount()) {
            return false;
        }
        MolAtom atom = this.mol.getAtom(atomIndex);
        for (int i = 0; i < atom.getBondCount(); ++i) {
            if (atom.getBond(i).getType() <= 1) continue;
            return false;
        }
        return true;
    }
}

