/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.pka;

import chemaxon.calculations.pka.Ionizer;
import chemaxon.calculations.pka.PKaLargeModel;
import chemaxon.calculations.pka.StandardMoleculeCalculator;
import chemaxon.calculator.Calculator;
import chemaxon.calculator.CalculatorException;
import chemaxon.calculator.CalculatorInputValidator;
import chemaxon.calculator.CalculatorLogger;
import chemaxon.calculator.Parameter;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.calculations.TautomerizationPlugin;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class IonizationBasedCalculator
implements Calculator {
    @Parameter(name="model", shortName="d", description="calculation model")
    protected ModelType model = ModelType.SMALL;
    @Parameter(name="mode", shortName="m", description="")
    protected CalculationMode mode = CalculationMode.MACRO;
    @Parameter(name="prefix", shortName="P", description="")
    protected PKaPrefix prefix = PKaPrefix.STATIC;
    @Parameter(name="min", shortName="i", description="min basic pKa")
    protected double basicpKaLowerLimit = -10.0;
    @Parameter(name="max", shortName="x", description="max acidic pKa")
    protected double acidicpKaUpperLimit = 20.0;
    @Parameter(name="temperature", shortName="T", description="temperature in Kelvin")
    protected double temperature = 298.0;
    @Parameter(name="considertautomerization", shortName="M", description="consider tautomerization and resonance")
    protected boolean considerTautomerization = false;
    @Parameter(name="correctionlibrary", shortName="L", description="correction library ID")
    protected String correctionLibrary = "";
    protected boolean mscalc = true;
    protected int maxIons = 8;
    protected Ionizer ionizer = null;
    protected PKaLargeModel proteinIonization = null;
    protected Molecule calcMolecule;
    protected Molecule molecule;
    protected StandardMoleculeCalculator standardizer;
    protected List<CalculatorInputValidator.Result> result;
    private String licenseEnvironment = "";
    private CalculatorLogger logger;

    @Override
    public boolean setMolecule(Molecule molecule) {
        this.invalidate(this.molecule, molecule);
        this.molecule = molecule;
        ArrayList<CalculatorInputValidator.Result> checkList = new ArrayList<CalculatorInputValidator.Result>();
        checkList.addAll(CalculatorInputValidator.getDefaultCheckList());
        checkList.add(CalculatorInputValidator.Result.RGROUP);
        checkList.add(CalculatorInputValidator.Result.VALENCE);
        this.result = CalculatorInputValidator.getErrorList(molecule, checkList);
        if (!this.result.isEmpty()) {
            this.getLogger().log(molecule, this.getClass().getSimpleName(), new CalculatorException(this.result.get(0).getMessage()));
        }
        return this.result.isEmpty();
    }

    public ModelType getModel() {
        return this.model;
    }

    public void setModel(ModelType model) {
        this.invalidate(this.model, model);
        this.model = model;
    }

    public CalculationMode getMode() {
        return this.mode;
    }

    public void setMode(CalculationMode mode) {
        this.invalidate(this.mode, mode);
        this.mode = mode;
    }

    public PKaPrefix getPrefix() {
        return this.prefix;
    }

    public void setPrefix(PKaPrefix prefix) {
        this.invalidate(this.prefix, prefix);
        this.prefix = prefix;
    }

    public double getBasicpKaLowerLimit() {
        return this.basicpKaLowerLimit;
    }

    public void setBasicpKaLowerLimit(double minBasicPKa) {
        this.invalidate(this.basicpKaLowerLimit, minBasicPKa);
        this.basicpKaLowerLimit = minBasicPKa;
    }

    public double getAcidicpKaUpperLimit() {
        return this.acidicpKaUpperLimit;
    }

    public void setAcidicpKaUpperLimit(double maxAcidicPKa) {
        this.invalidate(this.acidicpKaUpperLimit, maxAcidicPKa);
        this.acidicpKaUpperLimit = maxAcidicPKa;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(double temperature) {
        this.invalidate(this.temperature, temperature);
        this.temperature = temperature;
    }

    public boolean isConsiderTautomerization() {
        return this.considerTautomerization;
    }

    public void setConsiderTautomerization(boolean considerTautomerization) {
        this.invalidate(this.considerTautomerization, considerTautomerization);
        this.considerTautomerization = considerTautomerization;
    }

    public String getCorrectionLibrary() {
        return this.correctionLibrary;
    }

    public void setCorrectionLibrary(String correctionLibrary) {
        this.invalidate(this.correctionLibrary, correctionLibrary);
        this.correctionLibrary = correctionLibrary;
    }

    public boolean isMscalc() {
        return this.mscalc;
    }

    public void setMscalc(boolean mscalc) {
        this.invalidate(this.mscalc, mscalc);
        this.mscalc = mscalc;
    }

    public int getMaxIons() {
        return this.maxIons;
    }

    public void setMaxIons(int maxIons) {
        this.invalidate(this.maxIons, maxIons);
        this.maxIons = maxIons;
    }

    protected PKaLargeModel getLargeModel() throws CalculatorException {
        if (this.proteinIonization == null) {
            this.proteinIonization = new PKaLargeModel();
            this.proteinIonization.setMolecule(this.getCalcMolecule());
            this.setProperties(this.proteinIonization);
            this.proteinIonization.calcMacropKa();
            if (this.isOverflowCalculation() && this.mscalc) {
                this.proteinIonization.calcMacroSpeciesDistribution();
            }
        }
        return this.proteinIonization;
    }

    protected Ionizer getIonizer() {
        if (this.ionizer == null) {
            this.ionizer = new Ionizer();
            this.ionizer.setMolecule(this.getCalcMolecule());
            this.setProperties(this.ionizer);
            this.getIonizer().calculatepKa();
        }
        return this.ionizer;
    }

    protected StandardMoleculeCalculator getStandardizer() {
        if (this.standardizer == null) {
            this.standardizer = new StandardMoleculeCalculator(this.molecule, false);
        }
        return this.standardizer;
    }

    protected Molecule getCalcMolecule() {
        if (this.calcMolecule == null) {
            this.calcMolecule = this.getStandardizer().calculate(this.getStandardizationPlugin(), true);
        }
        return this.calcMolecule;
    }

    protected <T> boolean invalidate(T oldValue, T newValue) {
        if (oldValue == null || !oldValue.equals(newValue)) {
            this.calcMolecule = null;
            this.ionizer = null;
            this.proteinIonization = null;
            this.standardizer = null;
            return true;
        }
        return false;
    }

    protected void setProperties(Ionizer ionizer) {
        ionizer.setModelType(ModelType.LARGE.equals((Object)this.model));
        ionizer.setmicropKaCalc(CalculationMode.MICRO.equals((Object)this.mode));
        ionizer.setpKaPrefixType(PKaPrefix.STATIC.equals((Object)this.prefix) ? 1 : 2);
        ionizer.setAcidicpKaUpperLimit(this.acidicpKaUpperLimit);
        ionizer.setBasicpKaLowerLimit(this.basicpKaLowerLimit);
        ionizer.setTemperature(this.temperature);
        ionizer.setCorrectionLibrary(this.correctionLibrary);
        ionizer.setMspHCalc(this.mscalc);
        ionizer.setMaxIons(this.maxIons);
    }

    protected void setProperties(PKaLargeModel proteinIonization) {
        proteinIonization.setpKaPrefixType(PKaPrefix.STATIC.equals((Object)this.prefix) ? 1 : 2);
        proteinIonization.setAcidicpKaUpperLimit(this.acidicpKaUpperLimit);
        proteinIonization.setBasicpKaLowerLimit(this.basicpKaLowerLimit);
        proteinIonization.setCorrectionLibraryAbsolutePath(this.getIonizer().getCorrectionLibraryAbsolutePath());
    }

    public boolean isOverflowCalculation() throws CalculatorException {
        this.inputCheck();
        return ModelType.LARGE.equals((Object)this.model) && this.getIonizer().getIonOverflowStatus();
    }

    protected final void checkLicense() {
        LicenseHandler.getInstance().checkLicense(this.getProductName(), this.licenseEnvironment);
    }

    public String getProductName() {
        return "Protonation Plugin Group";
    }

    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed(this.getProductName(), this.licenseEnvironment);
    }

    protected final void inputCheck() throws CalculatorException {
        if (this.result == null) {
            this.result = Arrays.asList(CalculatorInputValidator.Result.NOINPUT);
        }
        if (!this.result.isEmpty()) {
            throw new CalculatorException(this.result.get(0).getMessage());
        }
    }

    public List<CalculatorInputValidator.Result> getErrorResultList() {
        return this.result;
    }

    protected abstract TautomerizationPlugin getStandardizationPlugin();

    protected CalculatorLogger getLogger() {
        if (this.logger == null) {
            this.logger = new CalculatorLogger();
            this.logger.setLogLevel(CalculatorLogger.Level.OFF);
        }
        return this.logger;
    }

    @Override
    public void setLogger(CalculatorLogger logger) {
        this.logger = logger;
    }

    public static enum PKaPrefix {
        STATIC,
        DYNAMIC;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }

    public static enum CalculationMode {
        MICRO,
        MACRO;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }

    public static enum CalculationType {
        PKA,
        ACIDIC,
        BASIC;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }

    public static enum ModelType {
        SMALL,
        LARGE;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

