/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.pka;

import chemaxon.calculations.Charge;
import chemaxon.calculations.PolarGroups;
import chemaxon.calculations.pka.IntrinsicIonization;
import chemaxon.calculations.pka.createpKaCenterDataFile;
import chemaxon.formats.MolExporter;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.util.ConfigUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Ionizer {
    public static final String PKA_PARAMETER_FOLDER_NAME = "calculations/training/";
    public static final String PKA_PARAMETER_FILE_SUFFIX = "pkadata";
    public static final String CONFIG_FOLDER_NAME = "config/";
    String pKaDirectoryPath = null;
    public double BCUTOFF = -10.0;
    public double ACUTOFF = 20.0;
    private double msdistLimit = 0.01;
    private int maxIons = 8;
    private int ionizableAtomCount;
    private int[] ionizedAtoms;
    public int microSpecCount;
    private int[] microSpec;
    private int[][] microSpecInfo;
    private int[] ionizationState;
    public boolean speciesDistribution = false;
    private int[] msOrd;
    private double[] msdist = null;
    private double[] msdistMan;
    private double[] macropKa = null;
    private int[] macropKaType = null;
    private int[] macropKaAtoms = null;
    public static final int ACIDIC = -1;
    public static final int BASIC = 1;
    public static final int UNKNOWN = 0;
    protected IntrinsicIonization pkalc;
    protected Molecule mol = null;
    public boolean micropKaCalc = false;
    private double[] logDInfok = null;
    private int[] logDInfoms = null;
    public boolean ionOverflow = false;
    private double[] microK;
    private double[] secondMacropKa;
    private int[] secondMacropKaType;
    public int maxIonCounter = 0;
    private double[][] pHMsDist = null;
    private boolean mspHCalc = false;
    private boolean mspHAvailable = false;
    private double pHLower = 0.0;
    private double pHUpper = 14.0;
    private double pHStepSize = 1.0;
    private int pHStepCount;
    private double[] pHPoints = null;
    private boolean symmetric = false;
    int[] TO = null;
    private double[] pHCharge = null;
    public double pI = Double.NaN;
    private int pKaPrefixType = 1;
    public static final int STATICpKaPREFIX = 1;
    public static final int DYNAMICpKaPREFIX = 2;
    private int logPHBondCounter = 0;
    double TOLERANCE = 0.001;
    private int acidCount = 0;
    private int baseCount = 0;
    double temp = 298.0;
    boolean hValenceError;
    boolean aromaticAzaError;
    boolean repairabelAzaError;
    boolean notFixableAzaError;
    boolean fixableAzaError;
    boolean saltEffect = false;
    boolean saltExist = false;
    protected double majpH = 7.4;
    protected int aromType = -1;
    boolean largeModelAllowed = false;
    boolean largeModelRecomended = false;
    boolean isTautomerCalculation = false;
    Molecule molCopy;
    boolean logDFlag = false;
    boolean majorMsCalc;
    boolean structureError;
    boolean negativeCFlag;
    boolean createCenterInfo = false;
    int[][] center;
    String[][] molCenterParams;
    double[][] molCenterParamValue;
    double[] ApKaCorrFactor;
    double[] BpKaCorrFactor;
    double pKaCorFactor;
    int[][] symInfo;
    boolean reversStartOrder = false;
    boolean correctionInfoAvailable = false;
    int[][] fileInfo;
    String[][][] paramInfo = null;
    int dirIndex;
    boolean ionizableAtomInfoAvailable;
    boolean pkaTeach = false;
    boolean loocvFlag = false;
    boolean clear;
    int sortedMspCount;

    public void setMolecule(Molecule m) {
        this.molCopy = m;
        this.mol = m.cloneMoleculeWithDocument();
        this.hValenceError = false;
    }

    public Molecule getMolecule() {
        return this.molCopy;
    }

    protected void setTemporarypKaDirectionPath(String u) {
        this.pKaDirectoryPath = u;
        this.pkaTeach = true;
    }

    protected void setLoocvFlag(boolean b) {
        this.loocvFlag = b;
    }

    protected void setCorrectionLibraryAbsolutePath(String path) {
        this.pKaDirectoryPath = path;
        this.createCenterInfo = this.pKaDirectoryPath != null;
    }

    public String getCorrectionLibraryAbsolutePath() {
        return this.pKaDirectoryPath;
    }

    private String convertToAbsolutePath(String path) {
        String absolutePath;
        if (!path.endsWith(".pkadata")) {
            path = path + ".pkadata";
        }
        if ((absolutePath = ConfigUtils.getFilePathFromUserHomeDir(path)) == null) {
            absolutePath = ConfigUtils.searchFileInMarvinPackageDir(CONFIG_FOLDER_NAME + path);
        }
        return absolutePath;
    }

    public void setCorrectionLibrary(String correctionLibraryId) {
        if (correctionLibraryId != null) {
            this.setCorrectionLibraryAbsolutePath(this.convertToAbsolutePath(PKA_PARAMETER_FOLDER_NAME + correctionLibraryId));
        }
    }

    public void useCorrectionLibrary(boolean utp) {
        this.createCenterInfo = utp;
    }

    public void setMaxIons(int maxIons) {
        this.maxIons = maxIons;
    }

    public int getMaxIons() {
        return this.maxIons;
    }

    public void setpKaPrefixType(int pKaPtype) {
        this.pKaPrefixType = pKaPtype;
    }

    public int getpKaPrefixType() {
        return this.pKaPrefixType;
    }

    public boolean getIonOverflowStatus() {
        return this.ionOverflow;
    }

    public void setLargeModelFlag(boolean largeModelInvoked) {
        this.largeModelAllowed = largeModelInvoked;
    }

    public boolean isLargeModelRecomended() {
        return this.largeModelRecomended;
    }

    public void setTautomerCalculationFlag(boolean tauCalc) {
        this.isTautomerCalculation = tauCalc;
    }

    public boolean getHValenceError() {
        return this.hValenceError;
    }

    public int getMaxIonsCounter() {
        return this.maxIonCounter;
    }

    public void setBasicpKaLowerLimit(double bpka) {
        this.BCUTOFF = bpka;
    }

    public void setAcidicpKaUpperLimit(double apka) {
        this.ACUTOFF = apka;
    }

    public void setmicropKaCalc(boolean microCalc) {
        this.micropKaCalc = microCalc;
    }

    public void setTemperature(double Temp) {
        this.temp = Temp;
    }

    public double getTemperature() {
        return this.temp;
    }

    public double getMultypKa(int ind) {
        if (this.hasCriticalError()) {
            return Double.NaN;
        }
        return this.addTempCorrection(ind, this.macropKa[ind]);
    }

    public double getpKa(int atomIndex) {
        if (this.hasCriticalError()) {
            return Double.NaN;
        }
        int ind = this.pkalc.pkaAtomIndex[atomIndex];
        if (ind == -1) {
            return Double.NaN;
        }
        return this.addTempCorrection(ind, this.macropKa[ind]);
    }

    private int getAtomIndex(int macropKaIndx) {
        for (int i = 0; i < this.pkalc.pkaAtomIndex.length; ++i) {
            if (this.pkalc.pkaAtomIndex[i] != macropKaIndx) continue;
            return i;
        }
        return -1;
    }

    public double getpKa(int atomIndex, int type) {
        int ind;
        if (this.hasCriticalError()) {
            return Double.NaN;
        }
        try {
            ind = this.pkalc.pkaAtomIndex[atomIndex];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return Double.NaN;
        }
        if (ind == -1) {
            return Double.NaN;
        }
        double pKa = Double.NaN;
        int type1 = this.macropKaType[ind];
        if (type == type1) {
            pKa = this.macropKa[ind];
        } else if (!Double.isNaN(this.secondMacropKa[ind]) && this.secondMacropKaType[ind] == type) {
            pKa = this.secondMacropKa[ind];
        }
        return this.addTempCorrection(ind, pKa);
    }

    public int getpKaType(int atomIndex) {
        if (this.hasCriticalError()) {
            return 0;
        }
        int ind = this.pkalc.pkaAtomIndex[atomIndex];
        if (ind == -1) {
            return 0;
        }
        return this.macropKaType[ind];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double[] getpKaSet(int atomIndex, int type) {
        if (this.hasCriticalError()) {
            return null;
        }
        int ind = this.pkalc.pkaAtomIndex[atomIndex];
        if (ind == -1) {
            return null;
        }
        double[] result = null;
        double[] K = new double[]{0.0, 0.0, 0.0, 0.0};
        K[0] = Double.NaN;
        K[1] = Double.NaN;
        K[2] = Double.NaN;
        K[3] = Double.NaN;
        int s = 0;
        int chg = 0;
        if (this.pKaPrefixType == 2) {
            if (Double.isNaN(this.macropKa[ind]) && Double.isNaN(this.secondMacropKa[ind])) return result;
            Molecule m = this.getMolecule();
            MolAtom a = m.getAtom(atomIndex);
            chg = a.getCharge();
            if (this.pkalc.aMultiplicity[ind] == 1) {
                if (this.macropKaType[ind] == type) {
                    K[0] = this.macropKa[ind];
                    ++s;
                    this.addTempCorrection(ind, K[0]);
                    if (!Double.isNaN(this.secondMacropKa[ind]) && chg != 0) {
                        K[1] = this.secondMacropKa[ind];
                        ++s;
                        this.addTempCorrection(ind, K[1]);
                    }
                } else if (this.secondMacropKaType[ind] == type && chg == 0) {
                    K[0] = this.secondMacropKa[ind];
                    ++s;
                    this.addTempCorrection(ind, K[0]);
                }
            } else if (this.pkalc.aMultiplicity[ind] == 2) {
                if (this.macropKaType[ind] == type) {
                    K[0] = this.macropKa[ind];
                    ++s;
                    this.addTempCorrection(ind, K[0]);
                    if (this.macropKaType[ind + 1] == type) {
                        K[s] = this.macropKa[ind + 1];
                        this.addTempCorrection(ind + 1, K[++s]);
                    }
                    if (!Double.isNaN(this.secondMacropKa[ind]) && chg != 0) {
                        K[s] = this.secondMacropKa[ind];
                        this.addTempCorrection(ind, K[++s]);
                    }
                } else if (this.macropKaType[ind + 1] == type) {
                    K[0] = this.macropKa[ind + 1];
                    ++s;
                    this.addTempCorrection(ind + 1, K[0]);
                }
                if (this.secondMacropKaType[ind] == type && chg == 0) {
                    K[0] = this.secondMacropKa[ind];
                    ++s;
                    this.addTempCorrection(ind, K[0]);
                }
            }
        } else if (this.pKaPrefixType == 1) {
            double p;
            if (this.pkalc.aMultiplicity[ind] != 1 || Double.isNaN(p = this.getpKa(atomIndex, type))) return result;
            result = new double[]{p};
            return result;
        }
        if (Double.isNaN(K[0])) {
            return null;
        }
        result = new double[s];
        if (s == 1) {
            result[0] = K[0];
            return result;
        } else if (s == 2) {
            result[0] = K[0];
            result[1] = K[1];
            if (chg > 0) {
                if (!(result[0] > result[1])) return result;
                double c = result[0];
                result[0] = result[1];
                result[1] = c;
                return result;
            } else {
                if (chg >= 0 || !(result[0] < result[1])) return result;
                double b = result[0];
                result[0] = result[1];
                result[1] = b;
            }
            return result;
        } else {
            if (s != 3) return result;
            result[0] = K[0];
            result[1] = K[1];
            result[2] = K[2];
            if (chg < 0) {
                if (!(result[0] < result[1])) return result;
                double b = result[1];
                result[1] = result[0];
                result[0] = b;
                return result;
            } else {
                if (chg <= 0) return result;
                if (result[2] < result[0]) {
                    double b = result[0];
                    result[0] = result[2];
                    result[2] = b;
                }
                if (!(result[1] > result[2])) return result;
                double b = result[2];
                result[2] = result[1];
                result[1] = b;
            }
        }
        return result;
    }

    private void setDynamicpKaPrefixes() {
        int jj;
        int kk;
        int i;
        int ind;
        Molecule m = this.getMolecule();
        int y = this.ionizableAtomCount;
        double[] ca = new double[y];
        double[] cb = new double[y];
        int[] caInd = new int[y];
        int[] cbInd = new int[y];
        int[] used = new int[y];
        for (int i2 = 0; i2 < y; ++i2) {
            ca[i2] = -1.0;
            cb[i2] = -1.0;
        }
        int k = 0;
        int j = 0;
        for (int i3 = 0; i3 < y; ++i3) {
            int ai = this.ionizedAtoms[i3];
            ind = this.pkalc.pkaAtomIndex[ai];
            MolAtom a = m.getAtom(ai);
            int chg = a.getCharge();
            if (this.pkalc.aMultiplicity[ind] == 2) {
                if (used[ind] == 1) continue;
                if (chg > 0 || chg == 0 && this.macropKaType[ind] == -1) {
                    ca[j] = this.getMultypKa(ind);
                    caInd[j] = ind;
                    ca[++j] = this.getMultypKa(ind + 1);
                    caInd[j] = ind + 1;
                    ++j;
                } else if (chg < 0 || chg == 0 && this.macropKaType[ind] == 1) {
                    if (chg == -1) {
                        cb[k] = this.getMultypKa(ind);
                        cbInd[k] = ind;
                        ++k;
                        ca[j] = this.getMultypKa(ind + 1);
                        caInd[j] = ind + 1;
                        ++j;
                    } else {
                        cb[k] = this.getMultypKa(ind);
                        cbInd[k] = ind;
                        cb[++k] = this.getMultypKa(ind + 1);
                        cbInd[k] = ind + 1;
                        ++k;
                    }
                }
                used[ind] = 1;
                continue;
            }
            if (chg > 0 || chg == 0 && this.macropKaType[ind] == -1) {
                ca[j] = this.getpKa(ai);
                caInd[j] = ind;
                ++j;
                continue;
            }
            if (chg >= 0 && (chg != 0 || this.macropKaType[ind] != 1)) continue;
            cb[k] = this.getpKa(ai);
            cbInd[k] = ind;
            ++k;
        }
        for (i = 0; i < y; ++i) {
            kk = i;
            double p = ca[i];
            ind = caInd[i];
            for (jj = i + 1; jj < y; ++jj) {
                if (!(ca[jj] <= p)) continue;
                kk = jj;
                p = ca[jj];
                ind = caInd[jj];
            }
            if (kk == i) continue;
            ca[kk] = ca[i];
            ca[i] = p;
            caInd[kk] = caInd[i];
            caInd[i] = ind;
        }
        for (i = 0; i < y; ++i) {
            kk = i;
            double p = cb[i];
            ind = cbInd[i];
            for (jj = i + 1; jj < y; ++jj) {
                if (!(cb[jj] <= p)) continue;
                kk = jj;
                p = cb[jj];
                ind = cbInd[jj];
            }
            if (kk == i) continue;
            cb[kk] = cb[i];
            cb[i] = p;
            cbInd[kk] = cbInd[i];
            cbInd[i] = ind;
        }
        for (i = 0; i < y; ++i) {
            if (ca[i] == -1.0) continue;
            this.macropKaType[caInd[i]] = -1;
        }
        for (i = 0; i < y; ++i) {
            if (cb[i] == -1.0) continue;
            this.macropKaType[cbInd[i]] = 1;
        }
    }

    private double getStrongestAcidicpKa() {
        double SApKa = 1.0E100;
        boolean exist = false;
        for (int i = 0; i < this.pkalc.pkaAtomCount; ++i) {
            int atom = this.pkalc.pkaActiveAtoms[i];
            double apKa = this.getpKa(atom, -1);
            if (Double.isNaN(apKa) || !(SApKa > apKa)) continue;
            SApKa = apKa;
            exist = true;
        }
        if (!exist) {
            SApKa = Double.NaN;
        }
        return SApKa;
    }

    private double addTempCorrection(int ind, double mpKa) {
        double newpKa = mpKa;
        if (this.macropKaType[ind] == 1) {
            newpKa = 298.0 / this.temp * (mpKa - 0.9) + 0.9;
        } else if (this.macropKaType[ind] == -1) {
            newpKa = 298.0 / this.temp * (mpKa - 4.3) + 4.3;
        }
        return newpKa;
    }

    public boolean isTrueZwitterIon() {
        double sapka;
        double sbpka = this.getStrongestBasicpKa();
        return sbpka - (sapka = this.getStrongestAcidicpKa()) > -2.0;
    }

    private double getStrongestBasicpKa() {
        double SBpKa = -1.0E100;
        boolean exist = false;
        for (int i = 0; i < this.pkalc.pkaAtomCount; ++i) {
            int atom = this.pkalc.pkaActiveAtoms[i];
            double bpKa = this.getpKa(atom, 1);
            if (Double.isNaN(bpKa) || !(bpKa > SBpKa)) continue;
            SBpKa = bpKa;
            exist = true;
        }
        if (!exist) {
            SBpKa = Double.NaN;
        }
        return SBpKa;
    }

    public void calcMicroSpecies() {
        this.initMsCalculation();
        if (this.largeModelRecomended) {
            return;
        }
        if (this.hasCriticalError()) {
            return;
        }
        if (this.ionizableAtomCount != 0) {
            int bitPos;
            int N = this.ionizableAtomCount;
            int ionizationLevel = 1;
            int startMsIndex = 1;
            int finalMsIndex = 1;
            int[] parentInfo = new int[]{0, 0, 0};
            for (bitPos = 0; bitPos < N; ++bitPos) {
                this.setMsBit(bitPos, finalMsIndex);
                ++finalMsIndex;
            }
            this.setMsInfo(ionizationLevel, startMsIndex, finalMsIndex - 1);
            for (ionizationLevel = 2; ionizationLevel < N; ++ionizationLevel) {
                parentInfo = this.getMsInfo(ionizationLevel - 1);
                int parentCount = parentInfo[2] - parentInfo[1] + 1;
                for (int parent = 0; parent < parentCount; ++parent) {
                    int parentMsIndex = parent + parentInfo[1];
                    bitPos = this.getLargestBitPos(parentMsIndex);
                    for (int i = bitPos + 1; i < this.ionizableAtomCount; ++i) {
                        this.copyParent(parentMsIndex, finalMsIndex);
                        this.setMsBit(i, finalMsIndex);
                        ++finalMsIndex;
                    }
                }
                startMsIndex = parentInfo[2] + 1;
                this.setMsInfo(ionizationLevel, startMsIndex, finalMsIndex - 1);
            }
            if (this.ionizableAtomCount > 1) {
                this.microSpec[this.microSpecCount - 1] = this.microSpecCount - 1;
                this.setMsInfo(this.ionizableAtomCount, finalMsIndex, finalMsIndex);
            }
        }
        this.microSpec[0] = 0;
        this.setMsInfo(0, 0, 0);
    }

    private void setMsBit(int bitPos, int MsIndex) {
        bitPos = (int)Math.pow(2.0, bitPos);
        this.microSpec[MsIndex] = this.microSpec[MsIndex] | bitPos;
    }

    private void setMsInfo(int ionizationLevel, int fistIndex, int lastIndex) {
        this.microSpecInfo[ionizationLevel][0] = ionizationLevel;
        this.microSpecInfo[ionizationLevel][1] = fistIndex;
        this.microSpecInfo[ionizationLevel][2] = lastIndex;
    }

    private int[] getMsInfo(int ionizationLevel) {
        int i = 0;
        while (this.microSpecInfo[i][0] != ionizationLevel) {
            ++i;
        }
        return this.microSpecInfo[i];
    }

    private int getLargestBitPos(int globalMsIndex) {
        int i = 1;
        int mSpecies = this.microSpec[globalMsIndex];
        int bitCount = 0;
        int maxBitPos = 0;
        while (bitCount < this.maxIons) {
            maxBitPos = (mSpecies & i) == i ? bitCount : maxBitPos;
            ++bitCount;
            i = 2 * i;
        }
        return maxBitPos;
    }

    private void copyParent(int parent, int child) {
        this.microSpec[child] = this.microSpec[parent];
    }

    public int getIonizableAtomCount() {
        return this.ionizableAtomCount;
    }

    private double[] getMicropKa(int msIndex, int ionIndex, boolean newCalc) {
        if (newCalc) {
            Molecule m = this.getMicroSpecies(msIndex);
            if (this.createCenterInfo) {
                boolean origin = this.correctionInfoAvailable;
                if (this.correctionInfoAvailable) {
                    this.setCenters(m);
                    this.correctionInfoAvailable = origin;
                }
            }
            this.pkalc.charge.debug = msIndex == 3 && ionIndex == 3;
            this.pkalc.aromatizationType = this.aromType;
            this.pkalc.setMolecule(m);
            if (this.createCenterInfo && this.correctionInfoAvailable) {
                for (int i = 0; i < m.getAtomCount(); ++i) {
                    this.pkalc.cyanoInc[i] = 0.0;
                }
                this.pkalc.setHBondTable();
            }
        }
        double[] micropKa = new double[]{0.0, 0.0, 0.0};
        double[] corr = new double[2];
        corr = this.getCenterCorrection(this.ionizedAtoms[ionIndex]);
        if (this.ionizationState[ionIndex] == 1) {
            micropKa[1] = Double.NaN;
            micropKa[0] = this.pkalc.getBasicpKa(this.ionizedAtoms[ionIndex]) + corr[0];
            micropKa[2] = this.pkalc.getAcidicpKa(this.ionizedAtoms[ionIndex]) + corr[1];
        } else {
            micropKa[0] = Double.NaN;
            micropKa[1] = this.pkalc.getAcidicpKa(this.ionizedAtoms[ionIndex]) + corr[1];
            micropKa[2] = this.pkalc.getBasicpKa(this.ionizedAtoms[ionIndex]) + corr[0];
        }
        if (this.pkalc.deprotonation && !Double.isNaN(micropKa[0])) {
            micropKa[0] = this.microK[ionIndex];
            this.pkalc.deprotonation = false;
        }
        if (this.pkalc.protonation && !Double.isNaN(micropKa[1])) {
            micropKa[1] = this.microK[ionIndex];
            this.pkalc.protonation = false;
        }
        return micropKa;
    }

    public void calcpKa(double pH) {
        if (this.speciesDistribution) {
            int i;
            double ln10 = 2.302585092994046;
            boolean zwitterion = false;
            boolean acidicMolecule = false;
            boolean basicMolecule = false;
            double H = Math.pow(10.0, -pH);
            int[] c = this.getSpeciesCharge(this.microSpecCount - 1);
            int startCharge = c[0];
            if (c[0] > 0 && c[1] > 0) {
                zwitterion = true;
            } else if (c[0] == this.ionizableAtomCount) {
                acidicMolecule = true;
            } else {
                basicMolecule = true;
            }
            int pKaCount = 0;
            int ionState = 1;
            while (pKaCount < this.ionizableAtomCount) {
                double N1 = 0.0;
                double D1 = 0.0;
                double maxN1 = -1.0E10;
                double maxD1 = -1.0E10;
                for (int j = 0; j < this.microSpecCount; ++j) {
                    c = this.getSpeciesCharge(j);
                    if (zwitterion) {
                        if (c[0] - c[1] == startCharge) {
                            if (this.msdistMan[j] > maxN1) {
                                maxN1 = this.msdistMan[j];
                            }
                            N1 += this.msdist[j];
                        }
                        if (c[0] - c[1] != startCharge - 1) continue;
                        if (this.msdistMan[j] > maxD1) {
                            maxD1 = this.msdistMan[j];
                        }
                        D1 += this.msdist[j];
                        continue;
                    }
                    if (acidicMolecule) {
                        if (ionState == c[0]) {
                            if (this.msdistMan[j] > maxN1) {
                                maxN1 = this.msdistMan[j];
                            }
                            N1 += this.msdist[j];
                            continue;
                        }
                        if (c[0] != ionState - 1) continue;
                        if (this.msdistMan[j] > maxD1) {
                            maxD1 = this.msdistMan[j];
                        }
                        D1 += this.msdist[j];
                        continue;
                    }
                    if (!basicMolecule) continue;
                    if (ionState == c[1]) {
                        if (this.msdistMan[j] > maxD1) {
                            maxD1 = this.msdistMan[j];
                        }
                        D1 += this.msdist[j];
                        continue;
                    }
                    if (c[1] != ionState - 1) continue;
                    if (this.msdistMan[j] > maxN1) {
                        maxN1 = this.msdistMan[j];
                    }
                    N1 += this.msdist[j];
                }
                if (N1 == 0.0) {
                    N1 = maxN1;
                    D1 = D1 == 0.0 ? maxD1 : Math.log(D1) / ln10;
                    double t = Math.pow(10.0, N1 - D1);
                    this.macropKa[pKaCount] = -Math.log(H * t) / ln10;
                } else {
                    this.macropKa[pKaCount] = -Math.log(H * N1 / D1) / ln10;
                }
                ++pKaCount;
                ++ionState;
                --startCharge;
            }
            this.macropKaAtoms = new int[this.pkalc.pkaAtomCount];
            this.assignAtom();
            double[] a = new double[this.pkalc.pkaAtomCount];
            for (int i2 = 0; i2 < this.pkalc.pkaAtomCount; ++i2) {
                a[i2] = Double.NaN;
            }
            for (int j = 0; j < this.pkalc.pkaAtomCount; ++j) {
                int ind = this.macropKaAtoms[j];
                if (!Double.isNaN(a[ind])) {
                    if (this.pkalc.aMultiplicity[ind] != 2) continue;
                    a[ind + 1] = this.macropKa[j];
                    continue;
                }
                a[ind] = this.macropKa[j];
            }
            for (i = 0; i < this.pkalc.pkaAtomCount; ++i) {
                if (!Double.isNaN(a[i])) {
                    this.macropKa[i] = a[i];
                    continue;
                }
                this.macropKa[i] = Double.NaN;
                this.secondMacropKa[i] = Double.NaN;
                this.macropKaType[i] = 0;
            }
            for (i = 1; i <= this.pkalc.pkaAtomCount; ++i) {
                if (this.macropKa[i - 1] < this.BCUTOFF && this.macropKaType[i - 1] == 1) {
                    this.macropKa[i - 1] = Double.NaN;
                    this.macropKaType[i - 1] = 0;
                }
                if (this.macropKa[i - 1] > this.ACUTOFF && this.macropKaType[i - 1] == -1) {
                    this.macropKa[i - 1] = Double.NaN;
                    this.macropKaType[i - 1] = 0;
                }
                if (this.secondMacropKa[i - 1] < this.BCUTOFF && this.secondMacropKaType[i - 1] == 1) {
                    this.secondMacropKa[i - 1] = Double.NaN;
                }
                if (!(this.secondMacropKa[i - 1] > this.ACUTOFF) || this.secondMacropKaType[i - 1] != -1) continue;
                this.secondMacropKa[i - 1] = Double.NaN;
            }
        }
    }

    private void assignAtom() {
        int x;
        int i;
        int i2;
        int atomIndex = 0;
        int mpKaCount = 0;
        int selected = 0;
        double[] msdistSumIonized = new double[this.ionizableAtomCount];
        boolean[] alreadyIonized = new boolean[this.ionizableAtomCount];
        double[][] ionArray = new double[this.ionizableAtomCount][this.ionizableAtomCount];
        for (i2 = 0; i2 < this.ionizableAtomCount; ++i2) {
            alreadyIonized[i2] = false;
        }
        if (this.mspHCalc || this.symmetric) {
            this.TO = new int[this.microSpecCount];
            if (this.symmetric) {
                this.setDegIndex();
            }
        }
        for (i2 = 0; i2 < this.ionizableAtomCount; ++i2) {
            if (Double.isNaN(this.macropKa[i2])) continue;
            double pH = this.macropKa[i2];
            this.recalcSpeciesOrder(pH);
            this.calcMsDistribution(pH);
            double min = 1.0E10;
            for (int j = 0; j < this.ionizableAtomCount; ++j) {
                atomIndex = this.ionizedAtoms[j];
                int bitValue = (int)Math.pow(2.0, j);
                for (int k = 0; k < this.microSpecCount; ++k) {
                    if ((this.microSpec[k] & bitValue) != bitValue) continue;
                    if (this.symmetric) {
                        int n = j;
                        msdistSumIonized[n] = msdistSumIonized[n] + (double)this.TO[k] * this.msdist[k];
                        continue;
                    }
                    int n = j;
                    msdistSumIonized[n] = msdistSumIonized[n] + this.msdist[k];
                }
                ionArray[j][i2] = msdistSumIonized[j];
                msdistSumIonized[j] = 50.0 - msdistSumIonized[j];
                double d = Math.abs(msdistSumIonized[j]);
                if (d < min && !alreadyIonized[j]) {
                    min = d;
                    this.macropKaAtoms[mpKaCount] = this.pkalc.pkaAtomIndex[atomIndex];
                    selected = j;
                }
                msdistSumIonized[j] = 0.0;
            }
            alreadyIonized[selected] = true;
            ++mpKaCount;
        }
        int L = this.macropKaAtoms.length;
        int[] os = new int[L];
        for (int i3 = 0; i3 < L; ++i3) {
            os[i3] = this.macropKaAtoms[i3];
        }
        int macroIndex = 0;
        int N = this.ionizableAtomCount;
        int[] used = new int[N];
        for (int i4 = 0; i4 < N; ++i4) {
            used[i4] = -1;
        }
        boolean failed = false;
        int ai = 0;
        int s = 0;
        for (i = 0; i < N && !failed; ++i) {
            double min = 1.0E10;
            for (int j = 0; j < N; ++j) {
                atomIndex = this.ionizedAtoms[j];
                x = j;
                int y = i;
                double p1 = Math.abs(50.0 - ionArray[x][y]);
                if (!(p1 < min)) continue;
                min = p1;
                macroIndex = i;
                ai = atomIndex;
                s = j;
            }
            if (used[s] == -1) {
                this.macropKaAtoms[macroIndex] = this.pkalc.pkaAtomIndex[ai];
                used[s] = 0;
                continue;
            }
            failed = true;
        }
        for (i = 0; i < N; ++i) {
            used[i] = -1;
        }
        boolean sFailed = false;
        for (i = 0; i < N && failed; ++i) {
            atomIndex = this.ionizedAtoms[i];
            double min = 1.0E10;
            for (int j = 0; j < N; ++j) {
                x = i;
                int y = j;
                double p1 = Math.abs(50.0 - ionArray[x][y]);
                if (!(p1 < min)) continue;
                min = p1;
                macroIndex = j;
            }
            if (used[macroIndex] == -1) {
                this.macropKaAtoms[macroIndex] = this.pkalc.pkaAtomIndex[atomIndex];
                used[macroIndex] = 0;
                continue;
            }
            sFailed = true;
        }
        for (i = 0; i < N; ++i) {
            used[i] = -1;
        }
        boolean tFailed = false;
        for (i = 0; i < N && sFailed; ++i) {
            double p2;
            atomIndex = this.ionizedAtoms[i];
            x = i;
            int y = i;
            double p1 = Math.abs(50.0 - ionArray[y][x]);
            if (p1 < (p2 = Math.abs(50.0 - ionArray[y = i][x = N - i - 1]))) {
                if (used[i] == -1) {
                    macroIndex = i;
                    used[macroIndex] = 0;
                } else {
                    tFailed = true;
                }
            } else if (used[N - i - 1] == -1) {
                macroIndex = N - i - 1;
                used[macroIndex] = 0;
            } else {
                tFailed = true;
            }
            this.macropKaAtoms[macroIndex] = this.pkalc.pkaAtomIndex[atomIndex];
        }
        if (tFailed) {
            for (i = 0; i < L; ++i) {
                this.macropKaAtoms[i] = os[i];
            }
        }
    }

    private int[] getSpeciesCharge(int msIndex) {
        int bitPos = 1;
        int[] s = new int[]{0, 0};
        for (int i = 0; i < this.maxIons; ++i) {
            if ((this.microSpec[msIndex] & bitPos) == bitPos) {
                if (this.ionizationState[i] == -1) {
                    s[0] = s[0] + 1;
                } else if (this.ionizationState[i] == 1) {
                    s[1] = s[1] + 1;
                }
            }
            bitPos = 2 * bitPos;
        }
        return s;
    }

    public Molecule getMicroSpecies(int msIndex) {
        if (!this.hasCriticalError()) {
            Molecule microSpecies = this.mol.cloneMoleculeWithDocument();
            this.calcMsIonizationState(microSpecies, this.microSpec[msIndex]);
            return microSpecies;
        }
        Molecule microSpecies = this.mol.cloneMoleculeWithDocument();
        return microSpecies;
    }

    private int getMajorIndex() {
        int maxInd = this.msOrd[0];
        if (this.symmetric) {
            double[] y = new double[this.microSpecCount];
            double max = -1.0;
            this.TO = null;
            this.setDegIndex();
            for (int i = 0; i < this.microSpecCount; ++i) {
                y[i] = (double)this.TO[i] * this.msdist[i];
                if (!(y[i] > max)) continue;
                maxInd = i;
                max = y[i];
            }
        }
        return maxInd;
    }

    private Molecule calcMsIonizationState(Molecule microSpecies, int bitRow) {
        int i = 1;
        int bitCount = 0;
        while (bitCount < this.maxIons) {
            if ((bitRow & i) == i) {
                if (this.ionizationState[bitCount] == 1) {
                    this.addHidrogen(this.ionizedAtoms[bitCount], 1, microSpecies);
                } else {
                    this.removeHidrogen(this.ionizedAtoms[bitCount], -1, microSpecies);
                }
            }
            ++bitCount;
            i = 2 * i;
        }
        return microSpecies;
    }

    private void addHidrogen(int atom, int q, Molecule microSpecies) {
        MolAtom a = microSpecies.getAtom(atom);
        int pc = a.getAtno();
        if (pc != 6) {
            int actualHcount = a.getImplicitHcount();
            a.setImplicitHcount(actualHcount + 1);
            a.setCharge(q);
        } else if (this.pkalc.getBaseType(atom) == 100) {
            int actualHcount = a.getImplicitHcount();
            a.setImplicitHcount(actualHcount + 1);
            a.setCharge(0);
        }
    }

    private void removeHidrogen(int atom, int q, Molecule microSpecies) {
        MolAtom a = microSpecies.getAtom(atom);
        int actualHcount = a.getImplicitHcount();
        if (actualHcount != 0) {
            a.setImplicitHcount(actualHcount - 1);
        } else {
            this.hValenceError = true;
        }
        a.setCharge(q);
    }

    public int getMicroSpeciesCount() {
        if (this.hasCriticalError()) {
            return 0;
        }
        return this.microSpecCount;
    }

    public int[] getIonizableAtoms() {
        return this.ionizedAtoms;
    }

    public boolean getAromaticAzaError() {
        return this.aromaticAzaError;
    }

    public void initMsCalculation() {
        this.aromaticAzaError = false;
        this.notFixableAzaError = false;
        this.fixableAzaError = false;
        this.saltExist = false;
        this.calcStartValues();
        if (this.hasCriticalError()) {
            return;
        }
    }

    public void setModelType(boolean mt) {
        this.largeModelAllowed = mt;
    }

    private void calcStartValues() {
        this.ionOverflow = false;
        this.ionizableAtomCount = 0;
        this.ionizableAtomInfoAvailable = false;
        this.largeModelRecomended = false;
        this.structureError = false;
        this.clear = false;
        if (!this.micropKaCalc) {
            this.neutralize(this.mol);
        }
        this.setSpecOrderFlag(false);
        Charge charge = new Charge();
        charge.setMolecule(this.mol);
        charge.setAromatizationType(this.aromType);
        charge.setChargeCalcType(true);
        if (this.structureError) {
            charge.setCriticalErrorFlag(true);
        }
        if (this.mol.getAtomCount() == 0) {
            charge.setCriticalErrorFlag(true);
            this.pkalc = new IntrinsicIonization(charge);
            return;
        }
        charge.calcCharges();
        this.hValenceError |= charge.getHValenceError();
        this.pkalc = new IntrinsicIonization(charge);
        if (charge.getCriticalErrorFlag()) {
            return;
        }
        this.correctionInfoAvailable = false;
        if (this.createCenterInfo) {
            if (this.paramInfo == null) {
                if (!this.pkaTeach && this.pKaDirectoryPath == null) {
                    this.setCorrectionLibraryAbsolutePath(ConfigUtils.searchFileInMarvinPackageDir("config/pKaReg"));
                }
                this.setCorrectionParameters();
            }
            this.setCenters(this.mol);
        }
        if (this.micropKaCalc) {
            if (this.isTautomerCalculation) {
                this.pkalc.setTautomerCalcFlag(true);
            }
            if (this.negativeCFlag) {
                this.setCchgState();
            }
            this.initializepKaType();
            this.setpKaArrays(this.pkalc.getMaxpKaCount());
            this.initMicropk0();
            this.setIonizedAtoms();
            this.pkalc.storemicropk0(this.microK, this.ionizedAtoms);
            if (this.ionizableAtomCount > 0) {
                this.pkalc.setHBondTable();
                for (int i = 0; i < this.pkalc.getMaxpKaCount(); ++i) {
                    this.macropKa[i] = Double.NaN;
                    this.macropKaType[i] = 0;
                    this.secondMacropKa[i] = Double.NaN;
                    this.secondMacropKaType[i] = 0;
                }
                this.clear = true;
                this.initMicropk0();
                this.setIonizedAtoms();
                this.pkalc.storemicropk0(this.microK, this.ionizedAtoms);
            }
            this.ionOverflow = false;
        } else {
            if (this.isTautomerCalculation) {
                this.pkalc.setTautomerCalcFlag(true);
            }
            if (this.negativeCFlag) {
                this.setCchgState();
            }
            this.initializepKaType();
            this.setpKaArrays(this.pkalc.getMaxpKaCount());
            this.initMicropk0();
            if (this.ionizableAtomCount > this.maxIons && this.largeModelAllowed) {
                this.largeModelRecomended = true;
                this.ionOverflow = true;
                return;
            }
            this.setIonizedAtoms();
        }
        this.maxIonCounter = this.ionizableAtomCount;
        if (!this.micropKaCalc) {
            this.setMicroArrayInfo();
            this.pkalc.storemicropk0(this.microK, this.ionizedAtoms);
            if (this.ionizableAtomCount > 0) {
                this.pkalc.setHBondTable();
                if (this.createCenterInfo && this.correctionInfoAvailable) {
                    this.setpKaArrays(this.pkalc.getMaxpKaCount());
                    this.clear = true;
                    this.initMicropk0();
                    this.setIonizedAtoms();
                    this.setMicroArrayInfo();
                    this.pkalc.storemicropk0(this.microK, this.ionizedAtoms);
                }
                this.CorrectSecMacpKa();
            }
        }
        this.setlogPHBondCount();
        this.ionizableAtomInfoAvailable = true;
    }

    private void setMicroArrayInfo() {
        boolean bl = this.ionOverflow = this.ionizableAtomCount > this.maxIons;
        if (this.ionOverflow) {
            this.setStrengthOrder(this.microK);
        }
        this.setStartAtomOrder(this.microK);
        if (this.ionOverflow) {
            this.ionizableAtomCount = this.maxIons;
        }
        this.microSpecCount = (int)Math.pow(2.0, this.ionizableAtomCount);
        this.microSpec = new int[this.microSpecCount];
        this.microSpecInfo = new int[this.ionizableAtomCount + 1][3];
    }

    protected boolean isCenterInfoAvailable() {
        return this.correctionInfoAvailable;
    }

    protected void setCenters(Molecule m) {
        createpKaCenterDataFile crpka = new createpKaCenterDataFile();
        crpka.setMolecule(m);
        crpka.setIonizableAtoms(this.ionizableAtomCount, this.ionizedAtoms);
        crpka.calcpKaCenterDataFile();
        int L = crpka.getCenterCount();
        this.center = new int[L][2];
        this.molCenterParams = new String[L][];
        this.molCenterParamValue = new double[L][];
        this.ApKaCorrFactor = new double[m.getAtomCount()];
        this.BpKaCorrFactor = new double[m.getAtomCount()];
        if (this.pKaDirectoryPath == null) {
            return;
        }
        for (int i = 0; i < crpka.getCenterCount(); ++i) {
            int ci = crpka.getCenterIndex(i);
            this.dirIndex = crpka.mainDirIndex;
            int ai = crpka.getParameterCenterIndex(i);
            int type = crpka.pKaType;
            this.center[i][0] = crpka.getParameterCenterIndex(i);
            this.center[i][1] = ci;
            int pc = crpka.getPTypeCount(i);
            this.molCenterParams[i] = new String[pc];
            this.molCenterParamValue[i] = new double[pc];
            for (int j = 0; j < pc; ++j) {
                this.molCenterParams[i][j] = crpka.getPType(i, j);
                this.molCenterParamValue[i][j] = 0.0;
            }
            if (type == -1) {
                this.ApKaCorrFactor[ai] = this.getpKaCorrectionFactor(ci, i);
                continue;
            }
            if (type != 1) continue;
            this.BpKaCorrFactor[ai] = this.getpKaCorrectionFactor(ci, i);
        }
    }

    private double getpKaCorrectionFactor(int cIndx, int count) {
        this.pKaCorFactor = 0.0;
        if (this.fileInfo[this.dirIndex] == null) {
            return this.pKaCorFactor;
        }
        boolean find = false;
        for (int i = 0; i < this.fileInfo[this.dirIndex].length && !find; ++i) {
            if (this.fileInfo[this.dirIndex][i] != cIndx) continue;
            for (int j = 0; j < this.paramInfo[this.dirIndex][i].length; ++j) {
                this.setParameters(this.paramInfo[this.dirIndex][i][j], count);
            }
            find = true;
        }
        if (this.pKaCorFactor != 0.0) {
            this.correctionInfoAvailable = true;
        }
        return this.pKaCorFactor;
    }

    private void setParameters(String s, int count) {
        int i;
        double pv = 0.0;
        boolean find = false;
        int ie = 0;
        String p = "";
        for (i = 0; i < s.length() && !find; ++i) {
            String ch = s.substring(i, i + 1);
            if (ch.equals("\t")) {
                find = true;
                ie = i;
                p = s.substring(0, i);
            }
            if (!find) continue;
            String z = s.substring(ie + 1, s.length());
            pv = Double.parseDouble(z);
        }
        int L = this.molCenterParams[count].length;
        String y = "";
        int pLength = p.length();
        int mpLength = 0;
        for (i = 0; i < L; ++i) {
            if (this.molCenterParams[count][i].equals(p)) {
                this.molCenterParamValue[count][i] = pv;
                this.pKaCorFactor += pv;
                continue;
            }
            if (this.correctionInfoAvailable) continue;
            mpLength = this.molCenterParams[count][i].length();
            if (this.molCenterParams[count][i].startsWith("CHARGE+,") || this.molCenterParams[count][i].startsWith("CHARGE-,")) {
                y = this.molCenterParams[count][i].substring(8, mpLength);
                if (!y.equals(p)) continue;
                this.correctionInfoAvailable = true;
                continue;
            }
            if (!p.startsWith("CHARGE+,") && !p.startsWith("CHARGE-,") || !(y = p.substring(8, pLength)).equals(this.molCenterParams[count][i])) continue;
            this.correctionInfoAvailable = true;
        }
    }

    public void setCorrectionParameters() {
        int d = createpKaCenterDataFile.PKA_TYPES.length;
        this.fileInfo = new int[d][];
        this.paramInfo = new String[d][][];
        try {
            File zip = new File(this.pKaDirectoryPath);
            ZipInputStream zipStream = new ZipInputStream(new FileInputStream(zip));
            ArrayList<String> entryNames = new ArrayList<String>();
            ZipEntry entry = null;
            while ((entry = zipStream.getNextEntry()) != null) {
                entryNames.add(entry.getName());
            }
            zipStream = new ZipInputStream(new FileInputStream(zip));
            BufferedReader in = new BufferedReader(new InputStreamReader(zipStream));
            while ((entry = zipStream.getNextEntry()) != null) {
                int[] flags = this.getEntryCountAndDirIndex(entry, entryNames);
                if (flags[0] < 0) continue;
                this.fileInfo[flags[0]] = new int[flags[1]];
                this.paramInfo[flags[0]] = new String[flags[1]][];
                for (int j = 0; j < flags[1]; ++j) {
                    int b;
                    if (j > 0) {
                        entry = zipStream.getNextEntry();
                    }
                    String name = entry.getName();
                    int L = name.length();
                    String v = "nnnnnnnnnnn";
                    int lastSepindex = name.lastIndexOf(File.separator);
                    if (!this.loocvFlag) {
                        v = name.substring(lastSepindex + 1, L - 4);
                    } else {
                        String x = name.substring(L - 2, L);
                        if (x.equals("cv")) {
                            v = name.substring(lastSepindex + 1, L - 6);
                        }
                    }
                    try {
                        b = Integer.parseInt(v);
                    }
                    catch (NumberFormatException e) {
                        this.fileInfo[flags[0]][j] = -1;
                        continue;
                    }
                    this.fileInfo[flags[0]][j] = b;
                    try {
                        String line;
                        ArrayList<String> params = new ArrayList<String>();
                        while ((line = in.readLine()) != null) {
                            params.add(line);
                        }
                        this.paramInfo[flags[0]][j] = params.toArray(new String[0]);
                        continue;
                    }
                    catch (IOException e) {
                        System.err.println("Exception reading");
                    }
                }
            }
            in.close();
        }
        catch (IOException e) {
            System.err.println("Error reading parameter file.");
        }
    }

    private int[] getEntryCountAndDirIndex(ZipEntry entry, List<String> entryNames) {
        int i;
        int[] result = new int[2];
        result[0] = -1;
        for (i = 0; i < createpKaCenterDataFile.PKA_TYPES.length; ++i) {
            if (entry.getName().indexOf(createpKaCenterDataFile.PKA_TYPES[i]) <= -1) continue;
            result[0] = i;
            break;
        }
        if (result[0] == -1) {
            return result;
        }
        for (i = 0; i < entryNames.size(); ++i) {
            if (entryNames.get(i).indexOf(createpKaCenterDataFile.PKA_TYPES[result[0]]) <= 0) continue;
            result[1] = result[1] + 1;
            entryNames.remove(i--);
        }
        return result;
    }

    private void setCchgState() {
        for (int i = 0; i < this.molCopy.getAtomCount(); ++i) {
            MolAtom a = this.molCopy.getAtom(i);
            int charge = a.getCharge();
            int pc = a.getAtno();
            if (pc != 6 || charge != -1) continue;
            this.pkalc.getPolarGroups().setChargeState(i, 1000);
        }
    }

    private void setpKaArrays(int L) {
        this.microK = new double[L];
        this.macropKa = new double[L];
        this.macropKaType = new int[L];
        this.secondMacropKa = new double[L];
        this.secondMacropKaType = new int[L];
        for (int i = 0; i < L; ++i) {
            this.macropKa[i] = Double.NaN;
            this.macropKaType[i] = 0;
            this.secondMacropKa[i] = Double.NaN;
            this.secondMacropKaType[i] = 0;
        }
    }

    private void initMicropk0() {
        this.ionizableAtomCount = 0;
        this.acidCount = 0;
        this.baseCount = 0;
        double[] corr = new double[2];
        for (int i = 0; i < this.pkalc.pkaAtomCount; ++i) {
            int atom = this.pkalc.pkaActiveAtoms[i];
            corr = this.getCenterCorrection(atom);
            double apka = this.pkalc.getAcidicpKa(atom) + corr[1];
            double bpka = this.pkalc.getBasicpKa(atom) + corr[0];
            if (this.majorMsCalc && (Double.isNaN(bpka) || Double.isNaN(apka))) {
                apka = this.setAcidicSafetypKa(apka);
                bpka = this.setBasicSafetypKa(bpka);
            }
            boolean acid = false;
            boolean base = false;
            if (!Double.isNaN(bpka) && !Double.isNaN(apka)) {
                if (2.0 * this.majpH - (bpka + apka) > 0.0) {
                    if (apka < this.ACUTOFF) {
                        acid = true;
                        ++this.acidCount;
                        if (this.clear) {
                            if (bpka > this.BCUTOFF) {
                                this.secondMacropKa[i] = bpka;
                                this.secondMacropKaType[i] = 1;
                                ++this.baseCount;
                            } else {
                                this.secondMacropKa[i] = Double.NaN;
                                this.secondMacropKaType[i] = 0;
                            }
                        } else {
                            this.secondMacropKa[i] = bpka;
                            this.secondMacropKaType[i] = 1;
                            ++this.baseCount;
                        }
                    } else if (bpka > this.BCUTOFF) {
                        base = true;
                        ++this.baseCount;
                        if (this.clear) {
                            if (apka < this.ACUTOFF) {
                                this.secondMacropKa[i] = apka;
                                this.secondMacropKaType[i] = -1;
                                ++this.acidCount;
                            } else {
                                this.secondMacropKa[i] = Double.NaN;
                                this.secondMacropKaType[i] = 0;
                            }
                        } else {
                            this.secondMacropKa[i] = apka;
                            this.secondMacropKaType[i] = -1;
                            ++this.acidCount;
                        }
                    }
                } else if (bpka > this.BCUTOFF) {
                    base = true;
                    ++this.baseCount;
                    this.secondMacropKa[i] = apka;
                    this.secondMacropKaType[i] = -1;
                    ++this.acidCount;
                } else if (apka < this.ACUTOFF) {
                    acid = true;
                    ++this.acidCount;
                    this.secondMacropKa[i] = bpka;
                    this.secondMacropKaType[i] = 1;
                    ++this.baseCount;
                }
            } else if (bpka > this.BCUTOFF) {
                base = true;
                ++this.baseCount;
            } else if (apka < this.ACUTOFF) {
                acid = true;
                ++this.acidCount;
            } else if (!Double.isNaN(bpka) && this.clear) {
                base = false;
                this.pkalc.pkaBasicType[atom][0] = -1;
            } else if (!Double.isNaN(apka) && this.clear) {
                acid = false;
                this.pkalc.pkaAcidType[atom][0] = -1;
            }
            if (acid) {
                if (this.micropKaCalc) {
                    this.macropKa[i] = apka;
                }
                this.macropKaType[i] = -1;
                this.microK[this.ionizableAtomCount] = apka;
                ++this.ionizableAtomCount;
                continue;
            }
            if (!base) continue;
            if (this.micropKaCalc) {
                this.macropKa[i] = bpka;
            }
            this.macropKaType[i] = 1;
            this.microK[this.ionizableAtomCount] = bpka;
            ++this.ionizableAtomCount;
        }
        this.pkalc.pKaType = this.macropKaType;
        this.clear = false;
    }

    protected double[] getCenterCorrection(int atom) {
        double[] c = new double[2];
        if (this.createCenterInfo && this.correctionInfoAvailable) {
            c[0] = -this.BpKaCorrFactor[atom];
            c[1] = -this.ApKaCorrFactor[atom];
        }
        return c;
    }

    private void initializepKaType() {
        this.pkalc.getAcidicpKa(0);
    }

    private double setAcidicSafetypKa(double a) {
        if (a >= 15.0) {
            return Double.NaN;
        }
        if (a >= this.majpH + 6.0) {
            return Double.NaN;
        }
        return a;
    }

    private double setBasicSafetypKa(double b) {
        if (b <= -2.0) {
            return Double.NaN;
        }
        if (b <= this.majpH - 6.0) {
            return Double.NaN;
        }
        return b;
    }

    private void setIonizedAtoms() {
        this.ionizedAtoms = new int[this.ionizableAtomCount];
        this.ionizationState = new int[this.ionizableAtomCount];
        if (this.ionizableAtomCount == 0) {
            return;
        }
        int k = 0;
        for (int i = 0; i < this.pkalc.pkaAtomCount; ++i) {
            int atom = this.pkalc.pkaActiveAtoms[i];
            if (this.macropKaType[i] == -1) {
                this.ionizedAtoms[k] = atom;
                this.ionizationState[k] = -1;
                ++k;
                continue;
            }
            if (this.macropKaType[i] != 1) continue;
            this.ionizedAtoms[k] = atom;
            this.ionizationState[k] = 1;
            ++k;
        }
    }

    private void setlogPHBondCount() {
        this.logPHBondCounter = this.pkalc.getlogPHBondCount();
    }

    protected void setSaltFlag(boolean salt) {
        this.saltEffect = salt;
    }

    protected boolean isSaltExist() {
        return this.saltExist;
    }

    private void CorrectSecMacpKa() {
        int i = 0;
        while (i < this.pkalc.pkaAtomCount) {
            int atom = this.pkalc.pkaActiveAtoms[i];
            int n = i++;
            this.secondMacropKa[n] = this.secondMacropKa[n] + this.pkalc.cyanoInc[atom];
        }
    }

    public int getlogPHBondCount() {
        return this.logPHBondCounter;
    }

    protected double getMicropKa(int atomIndex) {
        int i = 0;
        while (this.ionizedAtoms[i] != atomIndex) {
            ++i;
        }
        return this.microK[i];
    }

    protected void setSymmetryGroupInfo() {
        int[] t = new int[this.ionizableAtomCount];
        int k = 0;
        for (int i = 0; i < this.pkalc.getMaxpKaCount(); ++i) {
            if (Double.isNaN(this.macropKa[i])) continue;
            t[k] = i;
            ++k;
        }
        this.symInfo = new int[this.ionizableAtomCount][2];
        boolean added = false;
        int symGCount = 1;
        for (int i = 0; i < this.ionizableAtomCount; ++i) {
            double r1 = this.macropKa[t[i]];
            if (this.symInfo[i][0] == 0) {
                added = false;
                for (int j = 0; j < this.ionizableAtomCount; ++j) {
                    double r2;
                    if (i == j || this.symInfo[j][0] != 0 || !(Math.abs(r1 - (r2 = this.macropKa[t[j]])) < 1.0E-8)) continue;
                    this.symInfo[i][0] = symGCount;
                    this.symInfo[i][1] = this.getAtomIndex(t[i]);
                    this.symInfo[j][0] = symGCount;
                    this.symInfo[j][1] = this.getAtomIndex(t[j]);
                    added = true;
                }
            }
            if (!added) continue;
            ++symGCount;
            added = false;
        }
    }

    protected void setReversStartOrder(boolean rso) {
        this.reversStartOrder = rso;
    }

    private void setStartAtomOrder(double[] microK) {
        double c;
        int b;
        int a;
        int aInd;
        Molecule mo = this.getMolecule();
        int symGCount = 1;
        this.symInfo = new int[this.ionizableAtomCount][2];
        boolean added = false;
        for (int i = 0; i < this.ionizableAtomCount; ++i) {
            double r = microK[i];
            if (this.symInfo[i][0] == 0) {
                added = false;
                for (int j = 0; j < this.ionizableAtomCount; ++j) {
                    if (i == j || this.symInfo[j][0] != 0 || !(Math.abs(r - microK[j]) < 1.0E-8)) continue;
                    this.symInfo[i][0] = symGCount;
                    this.symInfo[i][1] = aInd = this.ionizedAtoms[i];
                    this.symInfo[j][0] = symGCount;
                    this.symInfo[j][1] = aInd = this.ionizedAtoms[j];
                    added = true;
                }
            }
            if (!added) continue;
            ++symGCount;
            added = false;
        }
        --symGCount;
        boolean find = false;
        for (int i = 0; i < this.ionizableAtomCount; ++i) {
            MolAtom at;
            int chg;
            if (this.symInfo[i][0] == 0 || (chg = (at = mo.getAtom(aInd = this.ionizedAtoms[i])).getCharge()) == 0) continue;
            int ref = this.symInfo[i][0];
            find = false;
            for (int y = 0; y < this.ionizableAtomCount && !find; ++y) {
                if (y == i || this.symInfo[y][0] != ref || (chg = (at = mo.getAtom(aInd = this.ionizedAtoms[y])).getCharge()) != 0) continue;
                a = this.ionizedAtoms[y];
                this.ionizedAtoms[y] = this.ionizedAtoms[i];
                this.ionizedAtoms[i] = a;
                b = this.ionizationState[y];
                this.ionizationState[y] = this.ionizationState[i];
                this.ionizationState[i] = b;
                c = microK[y];
                microK[y] = microK[i];
                microK[i] = c;
                find = true;
            }
        }
        this.symmetric = false;
        for (int j = 1; j < this.ionizableAtomCount; ++j) {
            for (int i = 0; i < this.ionizableAtomCount - j; ++i) {
                boolean Change;
                if (Math.abs(microK[i] - microK[i + 1]) < 1.0E-8) {
                    double apol2;
                    double apol1 = this.pkalc.setAtomSphere(this.ionizedAtoms[i], 1, 1.0);
                    Change = apol1 < (apol2 = this.pkalc.setAtomSphere(this.ionizedAtoms[i + 1], 1, 1.0));
                    this.symmetric = true;
                } else {
                    Change = this.createCenterInfo && this.correctionInfoAvailable || this.reversStartOrder ? this.getChangeFlag(i, i + 1) : microK[i] > microK[i + 1];
                }
                if (!Change) continue;
                a = this.ionizedAtoms[i];
                this.ionizedAtoms[i] = this.ionizedAtoms[i + 1];
                this.ionizedAtoms[i + 1] = a;
                b = this.ionizationState[i];
                this.ionizationState[i] = this.ionizationState[i + 1];
                this.ionizationState[i + 1] = b;
                c = microK[i];
                microK[i] = microK[i + 1];
                microK[i + 1] = c;
            }
        }
    }

    private boolean getChangeFlag(int indx1, int indx2) {
        boolean change;
        int state1 = this.ionizationState[indx1];
        int state2 = this.ionizationState[indx2];
        boolean bl = change = this.microK[indx1] <= this.microK[indx2];
        if (state2 == 1 && (state1 == 1 || state1 == -1)) {
            return change;
        }
        if (state2 == -1 && (state1 == 1 || state1 == -1)) {
            return !change;
        }
        return false;
    }

    private void setStrengthOrder(double[] microK) {
        boolean doChange = false;
        for (int j = 1; j < this.ionizableAtomCount; ++j) {
            for (int i = 0; i < this.ionizableAtomCount - j; ++i) {
                int code = 10 * this.ionizationState[i] + 5 * this.ionizationState[i + 1] + 100;
                switch (code) {
                    case 115: {
                        if (!(microK[i] < microK[i + 1])) break;
                        doChange = true;
                        break;
                    }
                    case 85: {
                        if (!(microK[i] > microK[i + 1])) break;
                        doChange = true;
                        break;
                    }
                    case 95: {
                        if (!(2.0 * this.majpH - (microK[i] + microK[i + 1]) < 0.0)) break;
                        doChange = true;
                        break;
                    }
                    case 105: {
                        if (!(2.0 * this.majpH - (microK[i] + microK[i + 1]) > 0.0)) break;
                        doChange = true;
                    }
                }
                if (!doChange) continue;
                int a = this.ionizedAtoms[i];
                this.ionizedAtoms[i] = this.ionizedAtoms[i + 1];
                this.ionizedAtoms[i + 1] = a;
                int b = this.ionizationState[i];
                this.ionizationState[i] = this.ionizationState[i + 1];
                this.ionizationState[i + 1] = b;
                double c = microK[i];
                microK[i] = microK[i + 1];
                microK[i + 1] = c;
                doChange = false;
            }
        }
        this.ionizableAtomCount = this.maxIons;
    }

    public int getBasicAtomCount() {
        return this.baseCount;
    }

    public int getAcidicAtomCount() {
        return this.acidCount;
    }

    private void neutralize(Molecule m) {
        this.negativeCFlag = false;
        int atomCount = m.getAtomCount();
        if (this.pKaPrefixType == 2) {
            m.dearomatize();
        }
        for (int atom = 0; atom < atomCount; ++atom) {
            MolAtom a = m.getAtom(atom);
            int charge = a.getCharge();
            int pc = a.getAtno();
            boolean single = false;
            if (this.isSingleAnion(a, charge)) {
                single = true;
            }
            if (pc != 8 && pc != 7 && pc != 16 && pc != 15 && !single && (pc != 6 || charge != -1) || charge == 0) continue;
            int implicitHCount = a.getImplicitHcount();
            boolean dearomaOccured = false;
            if (charge < 0) {
                int absChg = -1 * charge;
                int v = a.getBondCount() + (implicitHCount + absChg);
                if (pc == 7 && v > 3) {
                    this.structureError = true;
                    return;
                }
                if (pc <= 10 && v > 4) {
                    this.structureError = true;
                    return;
                }
                if (pc == 6 && v == 4) {
                    if (a.hasAromaticBond()) {
                        m.dearomatize();
                        a = m.getAtom(atom);
                        dearomaOccured = true;
                        if (this.isUnsaturated(a)) {
                            this.structureError = true;
                            return;
                        }
                    } else if (this.getValCount(a) == 8) {
                        this.structureError = true;
                        return;
                    }
                }
                a.setImplicitHcount(implicitHCount + absChg);
                a.setCharge(0);
                if (pc == 6) {
                    this.negativeCFlag = true;
                }
                if (!dearomaOccured) continue;
                m.aromatize();
                continue;
            }
            if (implicitHCount <= 0) continue;
            if (implicitHCount - charge < 0) {
                this.structureError = true;
                return;
            }
            a.setImplicitHcount(implicitHCount - charge);
            a.setCharge(0);
        }
        if (this.pKaPrefixType == 2) {
            m.aromatize(1);
        }
    }

    private boolean isUnsaturated(MolAtom a) {
        for (int i = 0; i < a.getBondCount(); ++i) {
            if (a.getBond(i).getType() <= 1) continue;
            return true;
        }
        return false;
    }

    private int getValCount(MolAtom a) {
        int y = 0;
        for (int i = 0; i < a.getBondCount(); ++i) {
            y += a.getBond(i).getType();
        }
        return y;
    }

    private boolean isNeutralizeThisAtom(Molecule m, int ai) {
        MolAtom a = m.getAtom(ai);
        int charge = a.getCharge();
        int pc = a.getAtno();
        int implicitHCount = a.getImplicitHcount();
        if (charge < 0) {
            int absChg = -1 * charge;
            int v = a.getBondCount() + (implicitHCount + absChg);
            if (pc == 7 && v > 3) {
                this.structureError = true;
                return false;
            }
            a.setImplicitHcount(implicitHCount + absChg);
            a.setCharge(0);
            return true;
        }
        if (implicitHCount > 0) {
            if (implicitHCount - charge < 0) {
                this.structureError = true;
                return false;
            }
            a.setImplicitHcount(implicitHCount - charge);
            a.setCharge(0);
            return true;
        }
        return false;
    }

    private void chargingBackThisAtom(Molecule m, int ai, int chg) {
        MolAtom a = m.getAtom(ai);
        int implicitHCount = a.getImplicitHcount();
        a.setImplicitHcount(implicitHCount + chg);
        a.setCharge(chg);
    }

    public int getMsIndex(int bitCode) {
        for (int i = 0; i < this.microSpecCount; ++i) {
            if ((this.microSpec[i] & bitCode) != bitCode) continue;
            return i;
        }
        return 0;
    }

    private double calcSpeciesRatio(int msIndex, double pH, boolean newCalc) {
        double[] pKa = new double[]{0.0, 0.0, 0.0};
        int bitPos = 1;
        int childBit = 0;
        int parentBit = 0;
        int ionIndex = 0;
        for (int i = 0; i < this.maxIons; ++i) {
            if ((this.microSpec[msIndex] & bitPos) == bitPos) {
                parentBit = childBit;
                ionIndex = i;
                childBit |= bitPos;
            }
            bitPos = 2 * bitPos;
        }
        int ms = this.getMsIndex(parentBit);
        double ratio = ms == 0 ? 1.0 : this.msdist[ms - 1];
        pKa = this.getMicropKa(ms, ionIndex, newCalc);
        double b = 0.0;
        double a = 0.0;
        if (this.logDFlag) {
            if (!Double.isNaN(pKa[0]) && !Double.isNaN(pKa[2])) {
                b = pKa[0];
                a = pKa[2];
            } else if (!Double.isNaN(pKa[1]) && !Double.isNaN(pKa[2])) {
                b = pKa[2];
                a = pKa[1];
            }
        }
        if (a != 0.0 && b != 0.0) {
            if (2.0 * this.majpH - (b + a) > 0.0) {
                if (a < this.ACUTOFF) {
                    this.logDInfok[msIndex - 1] = a - 10000.0;
                    this.logDInfoms[msIndex - 1] = ms;
                    ratio *= Math.pow(10.0, a - pH);
                    int n = msIndex - 1;
                    this.msdistMan[n] = this.msdistMan[n] + (a - pH);
                } else if (b > this.BCUTOFF) {
                    this.logDInfok[msIndex - 1] = b;
                    this.logDInfoms[msIndex - 1] = ms;
                    ratio *= Math.pow(10.0, pH - b);
                    int n = msIndex - 1;
                    this.msdistMan[n] = this.msdistMan[n] + (pH - b);
                }
            } else if (!Double.isNaN(b)) {
                this.logDInfok[msIndex - 1] = b;
                this.logDInfoms[msIndex - 1] = ms;
                ratio *= Math.pow(10.0, pH - b);
                int n = msIndex - 1;
                this.msdistMan[n] = this.msdistMan[n] + (pH - b);
            } else if (!Double.isNaN(a)) {
                this.logDInfok[msIndex - 1] = a - 10000.0;
                this.logDInfoms[msIndex - 1] = ms;
                ratio *= Math.pow(10.0, a - pH);
                int n = msIndex - 1;
                this.msdistMan[n] = this.msdistMan[n] + (a - pH);
            }
        } else if (!Double.isNaN(pKa[0])) {
            this.logDInfok[msIndex - 1] = pKa[0];
            this.logDInfoms[msIndex - 1] = ms;
            ratio *= Math.pow(10.0, pH - pKa[0]);
            int n = msIndex - 1;
            this.msdistMan[n] = this.msdistMan[n] + (pH - pKa[0]);
        } else if (!Double.isNaN(pKa[1])) {
            this.logDInfok[msIndex - 1] = pKa[1] - 10000.0;
            this.logDInfoms[msIndex - 1] = ms;
            ratio *= Math.pow(10.0, pKa[1] - pH);
            int n = msIndex - 1;
            this.msdistMan[n] = this.msdistMan[n] + (pKa[1] - pH);
        }
        if (ms == 0) {
            int n = msIndex - 1;
            this.msdistMan[n] = this.msdistMan[n] + 0.0;
        } else {
            int n = msIndex - 1;
            this.msdistMan[n] = this.msdistMan[n] + this.msdistMan[ms - 1];
        }
        return ratio;
    }

    private void setSpecOrderFlag(boolean specOrderCalc) {
        this.speciesDistribution = specOrderCalc;
    }

    public void setlogDFlag(boolean logDf) {
        this.logDFlag = logDf;
    }

    public double[] getMicroKInfo() {
        return this.logDInfok;
    }

    public int[] getMicroIndexInfo() {
        return this.logDInfoms;
    }

    private void calcSpeciesOrder(double pH) {
        int i;
        this.msOrd = new int[this.microSpecCount];
        this.msdist = new double[this.microSpecCount];
        this.msdistMan = new double[this.microSpecCount];
        this.logDInfok = new double[this.microSpecCount];
        this.logDInfoms = new int[this.microSpecCount];
        for (int i2 = 0; i2 < this.microSpecCount; ++i2) {
            this.msOrd[i2] = i2;
        }
        int msCount = 0;
        int[] msInfo = new int[]{0, 0, 0};
        int iL = 1;
        msInfo = this.getMsInfo(iL);
        msCount = msInfo[2] - msInfo[1] + 1;
        int outDegree = this.ionizableAtomCount;
        boolean newCalc = true;
        int startLength = outDegree;
        int initLength = outDegree;
        int steps = 0;
        int missingMs = msCount;
        for (int i3 = 1; i3 < this.microSpecCount; ++i3) {
            if (missingMs == 0) {
                msInfo = this.getMsInfo(++iL);
                missingMs = msCount = msInfo[2] - msInfo[1] + 1;
                startLength = --outDegree;
                initLength = outDegree;
                newCalc = true;
                steps = 0;
            } else if (steps == startLength) {
                newCalc = true;
                steps = 0;
                if (--startLength == 0 & missingMs != 0 && (startLength = --initLength) <= 0) {
                    startLength = 1;
                }
            }
            this.msdist[i3 - 1] = this.calcSpeciesRatio(i3, pH, newCalc);
            newCalc = false;
            --missingMs;
            ++steps;
        }
        for (i = 0; i < this.microSpecCount - 1; ++i) {
            double ratio = this.msdistMan[i];
            if (!(ratio < 0.0)) continue;
            this.changeMsRatioOrder(0, i + 1);
        }
        for (i = 0; i < this.microSpecCount - 1; ++i) {
            for (int j = i + 1; j < this.microSpecCount - 1; ++j) {
                double ratio = this.msdistMan[j] - this.msdistMan[i];
                if (!(ratio < 0.0)) continue;
                this.changeMsRatioOrder(i + 1, j + 1);
            }
        }
        this.setSpecOrderFlag(true);
    }

    public void recalcSpeciesOrder(double otherpH) {
        int i;
        int i2;
        for (i2 = 0; i2 < this.microSpecCount; ++i2) {
            this.msOrd[i2] = i2;
        }
        for (i2 = 0; i2 < this.microSpecCount; ++i2) {
            this.msdist[i2] = 0.0;
            this.msdistMan[i2] = 0.0;
        }
        for (i = 1; i < this.microSpecCount; ++i) {
            int ms = this.logDInfoms[i - 1];
            double ratio = ms == 0 ? 1.0 : this.msdist[ms - 1];
            double k = this.logDInfok[i - 1];
            if (k > -9000.0) {
                ratio *= Math.pow(10.0, otherpH - k);
                int n = i - 1;
                this.msdistMan[n] = this.msdistMan[n] + (otherpH - k);
            } else {
                ratio *= Math.pow(10.0, (k += 10000.0) - otherpH);
                int n = i - 1;
                this.msdistMan[n] = this.msdistMan[n] + (k - otherpH);
            }
            this.msdist[i - 1] = ratio;
            if (ms == 0) {
                int n = i - 1;
                this.msdistMan[n] = this.msdistMan[n] + 0.0;
                continue;
            }
            int n = i - 1;
            this.msdistMan[n] = this.msdistMan[n] + this.msdistMan[ms - 1];
        }
        for (i = 0; i < this.microSpecCount - 1; ++i) {
            double ratio = this.msdistMan[i];
            if (!(ratio < 0.0)) continue;
            this.changeMsRatioOrder(0, i + 1);
        }
        for (i = 0; i < this.microSpecCount - 1; ++i) {
            for (int j = i + 1; j < this.microSpecCount - 1; ++j) {
                double ratio = this.msdistMan[j] - this.msdistMan[i];
                if (!(ratio < 0.0)) continue;
                this.changeMsRatioOrder(i + 1, j + 1);
            }
        }
    }

    private void changeMsRatioOrder(int ratioIndex1, int ratioIndex2) {
        int indexOf1 = 0;
        while (this.msOrd[indexOf1] != ratioIndex1) {
            ++indexOf1;
        }
        int indexOf2 = 0;
        while (this.msOrd[indexOf2] != ratioIndex2) {
            ++indexOf2;
        }
        if (indexOf2 - indexOf1 > 1) {
            int a = this.msOrd[indexOf2];
            int i = 0;
            while (indexOf2 - i > indexOf1) {
                this.msOrd[indexOf2 - i] = this.msOrd[indexOf2 - i - 1];
                ++i;
            }
            this.msOrd[indexOf1] = a;
        } else if (indexOf2 > indexOf1) {
            int a = this.msOrd[indexOf1];
            this.msOrd[indexOf1] = this.msOrd[indexOf2];
            this.msOrd[indexOf2] = a;
        }
    }

    public Molecule getSortedMicroSpecies(int i) {
        Molecule sm = null;
        sm = this.microSpecCount == 1 ? this.getMicroSpecies(0) : this.getMicroSpecies(this.msOrd[i]);
        return sm;
    }

    public double[] calcMsDistribution(double pH) {
        if (this.ionizableAtomCount != 0) {
            if (!this.speciesDistribution) {
                this.calcSpeciesOrder(pH);
            }
            double[] m = new double[this.microSpecCount];
            double[] mr = new double[this.microSpecCount];
            double ln10 = 2.302585092994046;
            m[this.msOrd[0]] = 1000000.0 * (double)this.microSpecCount;
            m[this.msOrd[0]] = Math.log(m[this.msOrd[0]]) / ln10;
            int argD = this.msOrd[0] - 1 < 0 ? 0 : this.msOrd[0] - 1;
            for (int i = 1; i < this.microSpecCount; ++i) {
                int argN;
                int n = argN = this.msOrd[i] - 1 < 0 ? 0 : this.msOrd[i] - 1;
                double ratio = this.msOrd[i] == 0 ? -this.msdistMan[argD] : (this.msOrd[0] - 1 < 0 ? this.msdistMan[argN] : this.msdistMan[argN] - this.msdistMan[argD]);
                m[this.msOrd[i]] = m[this.msOrd[0]] - ratio;
                mr[this.msOrd[i]] = ratio;
            }
            double sum = 0.0;
            for (int i = 0; i < this.microSpecCount; ++i) {
                sum += Math.pow(10.0, -mr[i]);
            }
            double c = 100.0 / sum;
            c = Math.log(c) / ln10;
            for (int i = 0; i < this.microSpecCount; ++i) {
                this.msdist[i] = 100.0 * Math.pow(10.0, -mr[i]) / sum;
                this.msdistMan[i] = c - mr[i];
            }
        }
        return this.msdist;
    }

    public double getSortedMsDistribution(int i) {
        double dist = this.microSpecCount == 1 ? 100.0 : this.msdist[this.msOrd[i]];
        return dist;
    }

    public double getMsDist(int i) {
        return this.msdist[i];
    }

    public Molecule getMainMicroSpecies() {
        Molecule mainSpecies = null;
        if (this.speciesDistribution) {
            mainSpecies = this.getMicroSpecies(this.getMajorIndex());
        } else if (this.ionizableAtomCount == 0) {
            mainSpecies = this.getMicroSpecies(0);
        }
        return mainSpecies;
    }

    public Molecule getMajorMicroSpecies(double pH, Molecule mol) {
        this.majpH = pH;
        Molecule mainSpecies = null;
        this.majorMsCalc = true;
        this.setNewMolecule(mol);
        if (this.speciesDistribution) {
            if (this.getIonizableAtomCount() != 0) {
                this.recalcSpeciesOrder(pH);
                this.calcMsDistribution(pH);
                mainSpecies = this.getMicroSpecies(this.getMajorIndex());
            } else {
                mainSpecies = this.getMicroSpecies(0);
            }
            this.setSpecOrderFlag(false);
        } else if (!this.speciesDistribution) {
            this.setMolecule(mol);
            this.calcMicroSpecies();
            if (this.getIonizableAtomCount() != 0) {
                this.calcMsDistribution(pH);
                mainSpecies = this.getMicroSpecies(this.getMajorIndex());
            } else {
                if (this.hasCriticalError()) {
                    this.setSpecOrderFlag(false);
                    return this.getMolecule();
                }
                mainSpecies = this.getMicroSpecies(0);
            }
            this.setSpecOrderFlag(false);
        }
        this.majorMsCalc = false;
        return mainSpecies;
    }

    private void setNewMolecule(Molecule m) {
        try {
            String s1 = MolExporter.exportToFormat(m, "smiles");
            String s2 = null;
            if (this.molCopy != null) {
                s2 = MolExporter.exportToFormat(this.molCopy, "smiles");
            }
            if (!s1.equals(s2)) {
                this.setMolecule(m);
                this.setSpecOrderFlag(false);
            }
        }
        catch (IllegalArgumentException ex2) {
        }
        catch (NullPointerException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getSortedMsIndex(int i) {
        int Index2 = 0;
        Index2 = this.microSpecCount == 1 ? 0 : this.msOrd[i];
        return Index2;
    }

    public void calculatepKa(Molecule target, double pH) {
        this.setMolecule(target);
        this.calculatepKa(pH);
    }

    public void calculatepKa() {
        this.calculatepKa(1.0);
    }

    public void calculatepKa(double pH) {
        if (this.mspHCalc) {
            this.setpH();
            this.setMspH(false);
        }
        if (!this.micropKaCalc) {
            this.calcMicroSpecies();
            if (this.largeModelRecomended) {
                return;
            }
            if (this.ionizableAtomCount != 0) {
                this.calcMsDistribution(pH);
                this.calcpKa(pH);
                if (this.pKaPrefixType == 2) {
                    this.setDynamicpKaPrefixes();
                }
            }
        } else if (this.pKaPrefixType == 2) {
            this.calcMicropKa();
        } else {
            this.calcMicropKa();
        }
    }

    private void calcMicropKa() {
        int atom;
        int i;
        int i2;
        this.initMsCalculation();
        int oldHbc = this.logPHBondCounter;
        if (this.hasCriticalError()) {
            this.resetCalc();
            return;
        }
        if (this.pkalc.pkaAtomCount == 0) {
            return;
        }
        int pKaIonCount = 0;
        int maxMacroPKaCount = this.pkalc.getMaxpKaCount();
        double[] neuMicropKa = new double[maxMacroPKaCount];
        double[] neuSecMicropKa = new double[maxMacroPKaCount];
        int[] chgInd = new int[maxMacroPKaCount];
        int[] neupKaType = new int[maxMacroPKaCount];
        int[] neuSecpKaType = new int[maxMacroPKaCount];
        int[] neuAInd = new int[maxMacroPKaCount];
        int[] neuAIndMulty = new int[maxMacroPKaCount];
        for (int i3 = 0; i3 < maxMacroPKaCount; ++i3) {
            neuMicropKa[i3] = Double.NaN;
            neuSecMicropKa[i3] = Double.NaN;
            neuAInd[i3] = -1;
        }
        int ind = 0;
        for (i2 = 0; i2 < this.pkalc.charge.getMolecule().getAtomCount(); ++i2) {
            if (this.pkalc.pkaAtomIndex[i2] == -1) continue;
            neuAInd[ind] = i2;
            ++ind;
        }
        for (i2 = 0; i2 < this.pkalc.pkaAtomCount; ++i2) {
            neuAIndMulty[i2] = this.pkalc.pkaActiveAtoms[i2];
        }
        int[] neuMultiplicity = new int[this.pkalc.pkaAtomCount];
        for (int i4 = 0; i4 < this.pkalc.pkaAtomCount; ++i4) {
            neuMultiplicity[i4] = this.pkalc.aMultiplicity[i4];
        }
        int L = this.pkalc.getMaxpKaCount();
        int LL = this.pkalc.pkaAtomCount;
        for (i = 0; i < LL; ++i) {
            atom = neuAIndMulty[i];
            MolAtom a = this.mol.getAtom(atom);
            int charge = a.getCharge();
            int radC = a.getRadicalCount();
            int pc = a.getAtno();
            if (!Double.isNaN(this.macropKa[i])) {
                if (charge != 0) {
                    if (neuMultiplicity[i] > 1) {
                        chgInd[i] = charge;
                    } else {
                        this.setStartAtomOrder(this.microK);
                        if (this.pKaPrefixType == 2) {
                            this.setDynamicpKaPrefixes();
                        }
                    }
                }
                neuMicropKa[i] = this.macropKa[i];
                neuSecMicropKa[i] = this.secondMacropKa[i];
                neupKaType[i] = this.macropKaType[i];
                neuSecpKaType[i] = this.secondMacropKaType[i];
                ++pKaIonCount;
                continue;
            }
            if (charge == 0 || radC != 0) continue;
            boolean single = false;
            if (this.isSingleAnion(a, charge)) {
                single = true;
            }
            if (pc != 8 && pc != 7 && pc != 16 && pc != 15 && !single && (pc != 6 || charge != -1)) continue;
            chgInd[i] = charge;
        }
        for (i = 0; i < LL; ++i) {
            atom = neuAIndMulty[i];
            boolean neutral = false;
            if (chgInd[i] == 0) continue;
            this.negativeCFlag = false;
            if (this.pkalc.getAtno(atom) == 6) {
                this.mol.dearomatize();
                if (!this.isNeutralizeThisAtom(this.mol, atom)) {
                    this.pkalc.charge.setCriticalErrorFlag(true);
                    this.resetCalc();
                    return;
                }
                neutral = true;
                this.mol.aromatize(1);
                this.negativeCFlag = true;
            } else if (this.isNeutralizeThisAtom(this.mol, atom)) {
                neutral = true;
            } else {
                this.pkalc.charge.setCriticalErrorFlag(true);
                this.resetCalc();
                return;
            }
            if (!neutral) continue;
            this.initMsCalculation();
            if (this.hasCriticalError()) {
                this.resetCalc();
                return;
            }
            ind = this.getpKaIndex(atom);
            if (ind != -1) {
                if (this.hasCriticalError()) {
                    this.resetCalc();
                    return;
                }
                this.setStartAtomOrder(this.microK);
                if (this.pKaPrefixType == 2) {
                    this.setDynamicpKaPrefixes();
                }
                neuMicropKa[i] = this.macropKa[ind];
                neuSecMicropKa[i] = this.secondMacropKa[ind];
                neupKaType[i] = this.macropKaType[ind];
                neuSecpKaType[i] = this.secondMacropKaType[ind];
                if (!Double.isNaN(this.macropKa[ind])) {
                    ++pKaIonCount;
                }
            }
            if (this.pkalc.getAtno(atom) == 6) {
                this.mol.dearomatize();
                this.chargingBackThisAtom(this.mol, atom, chgInd[i]);
                this.mol.aromatize(1);
                continue;
            }
            this.chargingBackThisAtom(this.mol, atom, chgInd[i]);
        }
        this.setpKaArrays(L);
        for (i = 0; i < L; ++i) {
            this.macropKa[i] = neuMicropKa[i];
            this.secondMacropKa[i] = neuSecMicropKa[i];
            this.macropKaType[i] = neupKaType[i];
            this.secondMacropKaType[i] = neuSecpKaType[i];
        }
        this.maxIonCounter = this.ionizableAtomCount = pKaIonCount;
        for (i = 0; i < this.pkalc.charge.getMolecule().getAtomCount(); ++i) {
            this.pkalc.pkaAtomIndex[i] = -1;
        }
        for (i = 0; i < neuAInd.length; ++i) {
            if (neuAInd[i] == -1) continue;
            this.pkalc.pkaAtomIndex[neuAInd[i]] = i;
        }
        this.pkalc.aMultiplicity = new int[LL];
        for (i = 0; i < LL; ++i) {
            this.pkalc.aMultiplicity[i] = neuMultiplicity[i];
        }
        this.logPHBondCounter = oldHbc;
    }

    private boolean isSingleAnion(MolAtom a, int chg) {
        return chg < 0 && a.getImplicitHcount() == 0 && a.getBondCount() == 0;
    }

    private int getpKaIndex(int atom) {
        return this.pkalc.pkaAtomIndex[atom];
    }

    private void resetCalc() {
        for (int z = 0; z < this.pkalc.pkaAtomCount; ++z) {
            this.macropKa[z] = Double.NaN;
            this.macropKaType[z] = 0;
            this.secondMacropKa[z] = Double.NaN;
            this.secondMacropKaType[z] = 0;
        }
        this.ionizableAtomCount = 0;
        this.maxIonCounter = 0;
    }

    public boolean getCriticalErrorFlag() {
        return this.hasCriticalError();
    }

    public void setMspHCalc(boolean mspH) {
        this.mspHCalc = mspH;
    }

    public void setMspH(boolean mspHCalcReady) {
        this.mspHAvailable = mspHCalcReady;
    }

    public void setMajorpH(double mpH) {
        this.majpH = mpH;
    }

    public double getMajorpH() {
        return this.majpH;
    }

    public void setDefaultMajpH() {
        this.majpH = 7.4;
    }

    public void setDistributionLowerLimit(double limit) {
        this.msdistLimit = limit;
    }

    public int getSortedMicrspeciesCount() {
        return this.microSpecCount - this.sortedMspCount;
    }

    public double[] getMspH(int msIndex) {
        int i;
        int ionCount = this.getIonizableAtomCount();
        if (!this.mspHAvailable) {
            this.pHMsDist = new double[this.microSpecCount][this.pHStepCount + 1];
            if (this.mspHCalc & this.speciesDistribution) {
                if (this.symmetric) {
                    this.setDegIndex();
                }
                this.sortedMspCount = 0;
                for (i = 0; i <= this.pHStepCount; ++i) {
                    this.recalcSpeciesOrder(this.pHPoints[i]);
                    this.calcMsDistribution(this.pHPoints[i]);
                    for (int j = 0; j < this.microSpecCount; ++j) {
                        this.pHMsDist[j][i] = this.symmetric ? (double)this.TO[j] * this.msdist[j] : this.msdist[j];
                        if (!(this.pHMsDist[j][i] < this.msdistLimit)) continue;
                        ++this.sortedMspCount;
                    }
                }
                this.setMspH(true);
            }
        }
        if (ionCount == 0) {
            this.sortedMspCount = 0;
            for (i = 0; i <= this.pHStepCount; ++i) {
                this.pHMsDist[0][i] = 100.0;
            }
        }
        return this.pHMsDist[msIndex];
    }

    public double[] getMspH(double pH) {
        double[] pHMs = new double[this.microSpecCount];
        if (this.symmetric) {
            this.setDegIndex();
        }
        this.recalcSpeciesOrder(pH);
        this.calcMsDistribution(pH);
        this.sortedMspCount = 0;
        for (int j = 0; j < this.microSpecCount; ++j) {
            pHMs[j] = this.symmetric ? (double)this.TO[j] * this.msdist[j] : this.msdist[j];
            if (!(pHMs[j] < this.msdistLimit)) continue;
            ++this.sortedMspCount;
        }
        return pHMs;
    }

    public void setDegIndex() {
        int i;
        int nn = this.mol.getAtomCount();
        String[] smiles = new String[this.microSpecCount];
        boolean unkonwAromAtom = false;
        if (nn < 300) {
            for (int i2 = 0; i2 < this.microSpecCount; ++i2) {
                Molecule x = this.getMicroSpecies(i2);
                try {
                    smiles[i2] = MolExporter.exportToFormat(x, "smiles");
                    continue;
                }
                catch (IllegalArgumentException ex2) {
                    unkonwAromAtom = true;
                    continue;
                }
                catch (NullPointerException ex) {
                    unkonwAromAtom = true;
                    continue;
                }
                catch (IOException ex) {
                    unkonwAromAtom = true;
                }
            }
        }
        if (this.TO == null) {
            this.TO = new int[this.microSpecCount];
        }
        for (i = 0; i < this.microSpecCount; ++i) {
            this.TO[i] = 1;
        }
        if (unkonwAromAtom || nn >= 300) {
            return;
        }
        for (i = 0; i < this.microSpecCount; ++i) {
            String s0 = smiles[i];
            if (s0.equals("deleted")) continue;
            for (int j = i + 1; j < this.microSpecCount; ++j) {
                String s1 = smiles[j];
                if (!s0.equals(s1)) continue;
                smiles[j] = "deleted";
                this.TO[j] = 0;
                int n = i;
                this.TO[n] = this.TO[n] + 1;
            }
        }
    }

    public int getDegIndex(int i) {
        return this.TO[i];
    }

    public double calcpI() {
        if (this.mspHAvailable) {
            int i;
            int[] c = this.getSpeciesCharge(this.microSpecCount - 1);
            this.pI = Double.NaN;
            int mspCharge = 0;
            this.pHCharge = new double[this.pHStepCount + 1];
            int[] pHIndex = new int[this.pHStepCount + 1];
            for (i = 0; i <= this.pHStepCount; ++i) {
                pHIndex[i] = i;
            }
            for (i = 0; i <= this.pHStepCount; ++i) {
                double brutCharge = 0.0;
                for (int j = 0; j < this.microSpecCount; ++j) {
                    c = this.getSpeciesCharge(j);
                    mspCharge = c[1] - c[0];
                    brutCharge += (double)mspCharge * this.pHMsDist[j][i] / 100.0;
                }
                this.pHCharge[i] = brutCharge;
            }
            for (int i2 = 0; i2 <= this.pHStepCount - 1; ++i2) {
                for (int j = i2 + 1; j <= this.pHStepCount; ++j) {
                    if (!(Math.abs(this.pHCharge[i2]) < Math.abs(this.pHCharge[j]))) continue;
                    double w = this.pHCharge[i2];
                    this.pHCharge[i2] = this.pHCharge[j];
                    this.pHCharge[j] = w;
                    int indx = pHIndex[i2];
                    pHIndex[i2] = pHIndex[j];
                    pHIndex[j] = indx;
                }
            }
            this.pI = this.pHPoints[pHIndex[this.pHStepCount]];
        }
        return this.pI;
    }

    public double[] getMacroChargeDist() {
        return this.pHCharge;
    }

    public Molecule getMspHMolecule(int msIndex) {
        Molecule mspecies = this.getMicroSpecies(msIndex);
        return mspecies;
    }

    public double[] getpH() {
        return this.pHPoints;
    }

    private void setpH() {
        this.pHStepCount = (int)Math.round((this.pHUpper - this.pHLower) / this.pHStepSize);
        this.pHPoints = new double[this.pHStepCount + 1];
        for (int i = 0; i <= this.pHStepCount; ++i) {
            this.pHPoints[i] = this.pHLower + (double)i * this.pHStepSize;
        }
    }

    public void setpHL(double pHL) {
        this.pHLower = pHL;
    }

    public void setpHU(double pHU) {
        this.pHUpper = pHU;
    }

    public void setpHS(double pHS) {
        this.pHStepSize = pHS;
    }

    public int[] getSpecialGroups() {
        return this.pkalc.getPolarGroups().getCarboxy();
    }

    public boolean isSymmetric() {
        return this.symmetric;
    }

    public int getCarboxy(int index) {
        if (this.pkalc.getPolarGroups() == null) {
            return -1;
        }
        return this.pkalc.getPolarGroups().getCarboxy()[index];
    }

    public int getPolarGroupType(int index) {
        if (this.pkalc.getPolarGroups() == null) {
            return -1;
        }
        return this.pkalc.getPolarGroups().getGroupType(index);
    }

    public int getPolarGroupProperty(int index) {
        if (this.pkalc.getPolarGroups() == null) {
            return -1;
        }
        return this.pkalc.getPolarGroups().getGroupProperty()[index];
    }

    public int getpKaBasicType(int atomIndex, int typeIndex) {
        if (this.pkalc.pkaBasicType == null) {
            return -1;
        }
        return this.pkalc.pkaBasicType[atomIndex][typeIndex];
    }

    public int getsAra(int index) {
        if (this.pkalc.sAra == null) {
            return -1;
        }
        return this.pkalc.sAra[index];
    }

    public boolean isInRing(int index) {
        return this.pkalc.isInRing[index];
    }

    public int delocable(int index) {
        return this.pkalc.delocAble[index];
    }

    public int findSmallestAraRing(int atom) {
        return this.pkalc.charge.getRings().findSmallestAraRing(atom);
    }

    public int[][] getAraAtoms() {
        return this.pkalc.aAtoms;
    }

    public boolean hasCriticalError() {
        return this.pkalc != null && this.pkalc.charge.getCriticalErrorFlag();
    }

    public boolean isArA(int atom) {
        return this.mol.getAtom(atom).hasAromaticBond();
    }

    public double getMpk0(int index) {
        return this.pkalc.mpk0[index];
    }

    public int getGroupType(int index) {
        return this.pkalc.getPolarGroups().getGroupType(index);
    }

    public int getValenceState(int index) {
        return this.pkalc.getValenceState(index);
    }

    public boolean isAnilineTypeNitrogen(int index) {
        return this.pkalc.isAraNBexist(index);
    }

    public void setAromatizationType(int aromType) {
        this.aromType = aromType;
    }

    public int[] getBasicPKaType(int atomIndex) {
        return this.pkalc.pkaBasicType[atomIndex];
    }

    public PolarGroups getPolarGroups() {
        return this.pkalc.getPolarGroups();
    }
}

