/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.pka;

import chemaxon.calculations.hydrogenize.Hydrogenize;
import chemaxon.calculations.pka.IonizationBasedCalculator;
import chemaxon.calculations.pka.Ionizer;
import chemaxon.calculations.pka.PKaLargeModel;
import chemaxon.calculator.CalculatorException;
import chemaxon.calculator.CalculatorFormatter;
import chemaxon.calculator.Command;
import chemaxon.calculator.Parameter;
import chemaxon.formats.MolExporter;
import chemaxon.marvin.calculations.TautomerizationPlugin;
import chemaxon.struc.Molecule;
import java.io.IOException;

@Parameter(description="Microspecies Calculator")
public class MicroSpeciesCalculator
extends IonizationBasedCalculator {
    private static String PHNOTSET_ERROR_MSG = "Microspecies distribution is calculated only if pH is set.";
    private static String PHSET_ERROR_MSG = "Microspecies are calculated only if pH is not set.";
    private boolean isInputAromatic = false;
    @Parameter(name="pH", shortName="H", description="microspecies will be calculated at this pH")
    private double pH = Double.NaN;
    private static final double defaultPH = 7.4;
    @Parameter(name="format", shortName="f", description="output format")
    private String format = null;
    @Parameter(name="tag", shortName="t", description="SDF/MRV tag to store the distribution value")
    private String tag = "DISTR[pH=...]";
    private Ionizer simpleIonizer;
    private double pHUpper = 14.0;
    private double pHLower = 0.0;
    private double pHStep = 0.2;

    @Override
    public CalculatorFormatter getFormatter() {
        return new CalculatorFormatter(){

            @Override
            protected String convertSingle(Object o) {
                String f;
                String string = f = MicroSpeciesCalculator.this.format == null ? "smiles" : MicroSpeciesCalculator.this.format;
                if (o instanceof Molecule) {
                    try {
                        return MolExporter.exportToFormat((Molecule)o, f);
                    }
                    catch (IOException e) {
                        MicroSpeciesCalculator.this.getLogger().log(MicroSpeciesCalculator.this.molecule, "", "Result cannot converted to " + MicroSpeciesCalculator.this.format + " format");
                        return "";
                    }
                }
                return super.convertSingle(o);
            }

            @Override
            public CalculatorFormatter.FormattedResult convert(Object o) {
                if (o instanceof Molecule[] && ((Molecule[])o).length > 0) {
                    Molecule[] mols = (Molecule[])o;
                    if (MicroSpeciesCalculator.this.format == null) {
                        Molecule fused = mols[0];
                        for (int i = 1; i < mols.length; ++i) {
                            fused.fuse(mols[i]);
                        }
                        return super.convert(fused);
                    }
                    return new CalculatorFormatter.FormattedResult(mols, MicroSpeciesCalculator.this.format);
                }
                SEPARATOR = "\n";
                return super.convert(o);
            }

            @Override
            public String getHeader(String command) {
                return super.getHeader(command);
            }

            @Override
            public boolean needHeader() {
                return MicroSpeciesCalculator.this.format == null;
            }
        };
    }

    public double getPH() {
        return this.pH;
    }

    public void setPH(double pH) {
        this.invalidate(this.pH, pH);
        this.pH = pH;
    }

    protected String getFormat() {
        return this.format;
    }

    protected void setFormat(String format2) {
        this.format = format2;
    }

    protected String getTag() {
        if (this.tag.equals("DISTR[pH=...]") && !Double.isNaN(this.getPH())) {
            return this.tag.replace("...", this.getFormatter().format(this.getPH()).toString());
        }
        return this.tag;
    }

    protected void setTag(String tag) {
        this.tag = tag;
    }

    public double getpHUpper() {
        return this.pHUpper;
    }

    public void setpHUpper(double pHUpper) {
        this.setMscalc(true);
        this.invalidate(this.pHUpper, pHUpper);
        this.pHUpper = pHUpper;
    }

    public double getpHLower() {
        return this.pHLower;
    }

    public void setpHLower(double pHLower) {
        this.setMscalc(true);
        this.invalidate(this.pHLower, pHLower);
        this.pHLower = pHLower;
    }

    public double getpHStep() {
        return this.pHStep;
    }

    public void setpHStep(double pHStep) {
        this.setMscalc(true);
        this.invalidate(this.pHStep, pHStep);
        this.pHStep = pHStep;
    }

    @Override
    public boolean setMolecule(Molecule molecule) {
        this.isInputAromatic = false;
        for (int i = 0; i < molecule.getBondCount() && !this.isInputAromatic; ++i) {
            if (molecule.getBond(i).getType() != 4) continue;
            this.isInputAromatic = true;
        }
        return super.setMolecule(molecule);
    }

    @Override
    protected Molecule getCalcMolecule() {
        if (this.calcMolecule == null) {
            Hydrogenize.removeHAtoms(super.getCalcMolecule());
        }
        return super.getCalcMolecule();
    }

    public int getMsCount() throws CalculatorException {
        return this.isOverflowCalculation() ? this.getLargeModel().getMacroSpeciesCount() : this.getIonizer().getMicroSpeciesCount();
    }

    public Molecule getMsMolecule(int msIndex) throws CalculatorException {
        return this.isOverflowCalculation() ? null : this.getIonizer().getMspHMolecule(msIndex);
    }

    public double getSingleMsDistribution(int msIndex) throws CalculatorException {
        return this.isOverflowCalculation() ? this.getLargeModel().getMacroSpeciesDistribution(msIndex)[0] : this.getIonizer().getMspH(msIndex)[0];
    }

    public double[] getMsDistribution(int msIndex) throws CalculatorException {
        return this.isOverflowCalculation() ? this.getLargeModel().getMacroSpeciesDistribution(msIndex) : this.getIonizer().getMspH(msIndex);
    }

    public double[][] getMsDistributions() throws CalculatorException {
        int count = this.getMsCount();
        double[][] distributions = new double[count][];
        for (int i = 0; i < count; ++i) {
            distributions[i] = this.getMsDistribution(i);
        }
        return distributions;
    }

    @Command(name={"mscalculator", "microspeciesdistributioncalculator"}, description={"Microspecies list with distributions at given pH."}, example="test.mol", group=Command.Group.PROTONATION, exclude={"d", "m", "P", "i", "x", "L", "T"}, defaults={"format=sdf:-a pH=7.4"})
    public Molecule[] getMsDistribution() {
        double ph = this.getPH();
        if (Double.isNaN(ph)) {
            this.setPH(7.4);
        }
        if (this.format == null) {
            this.setFormat("sdf:-a");
        }
        Molecule[] mols = new Molecule[this.getMicrospeciesCount()];
        for (int i = 0; i < mols.length; ++i) {
            try {
                mols[i] = this.getSortedMicrospecies(i);
                double distr = this.getSortedMsDistribution(i);
                mols[i].setProperty(this.getTag(), this.getFormatter().format(distr).toString());
                continue;
            }
            catch (CalculatorException e) {
                this.setPH(ph);
                this.getLogger().log(this.molecule, "mscalculator", e);
            }
        }
        this.setPH(ph);
        return mols;
    }

    @Command(name={"majormscalculator"}, description={"Major microspecies at given pH."}, example="-H 3.5 -f mol test.mol", group=Command.Group.PROTONATION, exclude={"d", "m", "P", "i", "x", "L", "T", "t"})
    public Molecule[] getMicrospecies() {
        if (Double.isNaN(this.getPH())) {
            Molecule[] mols = new Molecule[this.getMicrospeciesCount()];
            for (int i = 0; i < mols.length; ++i) {
                try {
                    mols[i] = this.getMicrospecies(i);
                    continue;
                }
                catch (CalculatorException e) {
                    this.getLogger().log(this.molecule, "majormscalculator", e);
                }
            }
            return mols;
        }
        return new Molecule[]{this.dearomIfNeed(this.getMajorMicroSpecies(this.getCalcMolecule(), this.getPH()))};
    }

    @Override
    protected TautomerizationPlugin getStandardizationPlugin() {
        if (!this.considerTautomerization) {
            return null;
        }
        TautomerizationPlugin tplugin = new TautomerizationPlugin();
        tplugin.setLicenseEnvironment("LicenseEnvironmentForPartitioningPluginGroup");
        tplugin.setDominantTautomerDistributionCalculation(true);
        return tplugin;
    }

    private Ionizer getSimpleIonizer() {
        if (this.simpleIonizer == null) {
            this.simpleIonizer = new Ionizer();
            this.simpleIonizer.setMolecule(this.getCalcMolecule());
            this.simpleIonizer.calcMicroSpecies();
            if (!Double.isNaN(this.getPH())) {
                this.simpleIonizer.calcMsDistribution(this.getPH());
            }
        }
        return this.simpleIonizer;
    }

    @Override
    protected void setProperties(Ionizer ionizer) {
        super.setProperties(ionizer);
        ionizer.setpHS(this.pHStep);
        ionizer.setpHL(this.pHLower);
        ionizer.setpHU(this.pHUpper);
    }

    @Override
    protected void setProperties(PKaLargeModel proteinIonization) {
        super.setProperties(proteinIonization);
        proteinIonization.setpHS(this.pHStep);
        proteinIonization.setpHL(this.pHLower);
        proteinIonization.setpHU(this.pHUpper);
    }

    @Override
    protected <T> boolean invalidate(T oldValue, T newValue) {
        if (super.invalidate(oldValue, newValue)) {
            this.simpleIonizer = null;
            return true;
        }
        return false;
    }

    public Molecule getSortedMicrospecies(int index) throws CalculatorException {
        if (Double.isNaN(this.getPH())) {
            throw new CalculatorException(PHNOTSET_ERROR_MSG);
        }
        return this.dearomIfNeed(this.getSimpleIonizer().getSortedMicroSpecies(index));
    }

    public double getSortedMsDistribution(int index) throws CalculatorException {
        if (Double.isNaN(this.getPH())) {
            throw new CalculatorException(PHNOTSET_ERROR_MSG);
        }
        return this.getSimpleIonizer().getSortedMsDistribution(index);
    }

    public int getMicrospeciesCount() {
        return this.getSimpleIonizer().getMicroSpeciesCount();
    }

    public Molecule getMicrospecies(int index) throws CalculatorException {
        if (!Double.isNaN(this.getPH())) {
            throw new CalculatorException(PHSET_ERROR_MSG);
        }
        return this.dearomIfNeed(this.getSimpleIonizer().getMicroSpecies(index));
    }

    public Molecule getMajorMicrospecies() throws CalculatorException {
        if (Double.isNaN(this.getPH())) {
            throw new CalculatorException(PHNOTSET_ERROR_MSG);
        }
        return this.dearomIfNeed(this.getMajorMicroSpecies(this.getCalcMolecule(), this.getPH()));
    }

    protected Molecule getMajorMicroSpecies(Molecule standardizedMolecule, double pH) {
        Molecule mol = this.getSimpleIonizer().getMajorMicroSpecies(pH, standardizedMolecule);
        if (this.getSimpleIonizer().getIonOverflowStatus()) {
            mol = new PKaLargeModel().getMajorMicroSpecies(pH, mol);
        }
        return mol;
    }

    protected Molecule dearomIfNeed(Molecule mol) {
        if (!this.isInputAromatic) {
            mol.dearomatize();
        }
        return mol;
    }

    public int getMacroSpeciesCharge(int msIndex) throws CalculatorException {
        return this.getLargeModel().getMacroSpeciesCharge(msIndex);
    }
}

