/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.pka;

import chemaxon.calculations.pka.IonizationBasedCalculator;
import chemaxon.calculator.CalculatorException;
import chemaxon.calculator.CalculatorFormatter;
import chemaxon.calculator.Command;
import chemaxon.calculator.Parameter;
import chemaxon.marvin.calculations.TautomerizationPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

@Parameter(description="pKa Calculator")
public class PKaCalculator
extends IonizationBasedCalculator {
    public static final int ACIDIC = -1;
    public static final int BASIC = 1;
    private static final String NO_IONIZABLE_ATOMS_FOUND = "No ionizable atoms found.";
    private static final String INVALID_ATOM_INDEX = "Invalid atom index ";
    @Parameter(name="na", shortName="a", description="number of acidic pKa values displayed")
    protected int acidicResultCount = 2;
    @Parameter(name="nb", shortName="b", description="number of basic pKa values displayed")
    protected int basicResultCount = 2;
    @Parameter(name="type", shortName="t", description="")
    protected IonizationBasedCalculator.CalculationType type = IonizationBasedCalculator.CalculationType.PKA;

    @Override
    public CalculatorFormatter getFormatter() {
        return new CalculatorFormatter(){

            @Override
            public CalculatorFormatter.FormattedResult convert(Object o) {
                PKaResult[] result = (PKaResult[])o;
                ArrayList<Double> list = new ArrayList<Double>();
                for (int i = 0; i < result.length; ++i) {
                    list.add(result[i].value);
                }
                StringBuffer pkaValues = new StringBuffer(super.convert(list).getResult());
                pkaValues.append(CalculatorFormatter.SEPARATOR);
                boolean hasIndex = false;
                for (int i = 0; i < result.length; ++i) {
                    if (result[i].index == -1) continue;
                    pkaValues.append(this.convertSingle(result[i].index + 1)).append(",");
                    hasIndex = true;
                }
                if (hasIndex) {
                    pkaValues.delete(pkaValues.length() - 1, pkaValues.length());
                }
                return new CalculatorFormatter.FormattedResult(pkaValues.toString());
            }

            @Override
            public String getHeader(String command) {
                if ("pkacalculator".equalsIgnoreCase(command)) {
                    int i;
                    StringBuffer header = new StringBuffer();
                    for (i = 0; i < PKaCalculator.this.getAcidicResultCount(); ++i) {
                        header.append("apKa").append(i + 1).append(CalculatorFormatter.SEPARATOR);
                    }
                    for (i = 0; i < PKaCalculator.this.getBasicResultCount(); ++i) {
                        header.append("bpKa").append(i + 1).append(CalculatorFormatter.SEPARATOR);
                    }
                    header.append("atoms");
                    return header.toString();
                }
                return super.getHeader(command);
            }
        };
    }

    protected int getAcidicResultCount() {
        return this.acidicResultCount;
    }

    protected void setAcidicResultCount(int acidicResultCount) {
        if (!IonizationBasedCalculator.CalculationType.BASIC.equals((Object)this.type)) {
            this.acidicResultCount = acidicResultCount;
        }
    }

    protected int getBasicResultCount() {
        return this.basicResultCount;
    }

    protected void setBasicResultCount(int basicResultCount) {
        if (!IonizationBasedCalculator.CalculationType.ACIDIC.equals((Object)this.type)) {
            this.basicResultCount = basicResultCount;
        }
    }

    public IonizationBasedCalculator.CalculationType getType() {
        return this.type;
    }

    public void setType(IonizationBasedCalculator.CalculationType type) {
        switch (type) {
            case ACIDIC: {
                this.setBasicResultCount(0);
                break;
            }
            case BASIC: {
                this.setAcidicResultCount(0);
            }
        }
        this.type = type;
    }

    @Command(name={"pkacalculator"}, description={"pka calculation"}, example="-i -15 -x 25 -a 3 -b 3 -d large test.mol", group=Command.Group.PROTONATION, options={""})
    protected PKaResult[] getpKa() throws CalculatorException {
        int i;
        if (!this.result.isEmpty()) {
            return new PKaResult[0];
        }
        double[] acidicValues = new double[this.acidicResultCount];
        int[] acidicIndexes = new int[this.acidicResultCount];
        this.getMacropKaValues(-1, acidicValues, acidicIndexes);
        double[] basicValues = new double[this.basicResultCount];
        int[] basicIndexes = new int[this.basicResultCount];
        this.getMacropKaValues(1, basicValues, basicIndexes);
        boolean hasIonizableGroup = false;
        PKaResult[] result = new PKaResult[this.acidicResultCount + this.basicResultCount];
        for (i = 0; i < this.acidicResultCount; ++i) {
            result[i] = new PKaResult(acidicIndexes[i], acidicValues[i]);
            hasIonizableGroup |= acidicIndexes[i] != -1;
        }
        for (i = 0; i < this.basicResultCount; ++i) {
            result[i + this.acidicResultCount] = new PKaResult(basicIndexes[i], basicValues[i]);
            hasIonizableGroup |= basicIndexes[i] != -1;
        }
        if (!hasIonizableGroup) {
            this.getLogger().log(this.molecule, "pkacalculator", NO_IONIZABLE_ATOMS_FOUND);
        }
        return result;
    }

    public double getpKa(int index) throws CalculatorException {
        this.getStandardizer().calculate(this.getStandardizationPlugin(), true);
        index = this.getStandardizer().getModifiedIndex(index);
        if (index == -1) {
            this.getLogger().log(this.molecule, "getpKa", INVALID_ATOM_INDEX + index);
            return Double.NaN;
        }
        return this.isOverflowCalculation() ? this.getLargeModel().getMacropKa(index) : this.getIonizer().getpKa(index);
    }

    public double[] getpKaValues(int index, int type) throws CalculatorException {
        this.getStandardizer().calculate(this.getStandardizationPlugin(), true);
        index = this.getStandardizer().getModifiedIndex(index);
        if (index == -1) {
            this.getLogger().log(this.molecule, "getpKaValues", INVALID_ATOM_INDEX + index);
            return new double[0];
        }
        double[] values = this.isOverflowCalculation() ? this.getLargeModel().getpKaSet(index, type) : this.getIonizer().getpKaSet(index, type);
        return values == null ? new double[]{} : values;
    }

    public int getpKaType(Integer index) throws CalculatorException {
        int type;
        this.getStandardizer().calculate(this.getStandardizationPlugin(), true);
        index = this.getStandardizer().getModifiedIndex(index);
        if (index == -1) {
            this.getLogger().log(this.molecule, "getpKaType", INVALID_ATOM_INDEX + index);
            return 0;
        }
        int n = type = this.isOverflowCalculation() ? this.getLargeModel().getMacropKaType(index) : this.getIonizer().getpKaType(index);
        if (type == -2) {
            type = 0;
        }
        return type;
    }

    public double[] getpHs() throws CalculatorException {
        return this.isOverflowCalculation() ? this.getLargeModel().getpHPoints() : this.getIonizer().getpH();
    }

    public void getMacropKaValues(int pkatype, double[] values, int[] indexes) throws CalculatorException {
        int i;
        this.inputCheck();
        Arrays.fill(values, Double.NaN);
        ArrayList<Double> vals = new ArrayList<Double>();
        ArrayList<Integer> inds = null;
        if (indexes != null) {
            Arrays.fill(indexes, -1);
            inds = new ArrayList<Integer>();
        }
        double sign = pkatype == -1 ? 1.0 : -1.0;
        for (int i2 = 0; i2 < this.getCalcMolecule().getAtomCount(); ++i2) {
            double[] v = this.getpKaValues(i2, pkatype);
            if (v == null) continue;
            for (int j = 0; j < v.length; ++j) {
                if (Double.isNaN(v[j])) continue;
                int n = j;
                v[n] = v[n] * sign;
                vals.add(v[j]);
                if (indexes == null) continue;
                inds.add(i2);
            }
        }
        ArrayList<Double> sortVals = new ArrayList<Double>();
        sortVals.addAll(vals);
        Collections.sort(sortVals);
        for (i = 0; i < sortVals.size() && i < values.length; ++i) {
            values[i] = (Double)sortVals.get(i);
            if (indexes == null || i >= indexes.length) continue;
            int indexInList = vals.indexOf(sortVals.get(i));
            indexes[i] = (Integer)inds.get(indexInList);
            vals.remove(indexInList);
            inds.remove(indexInList);
        }
        i = 0;
        while (i < values.length && !Double.isNaN(values[i])) {
            int n = i++;
            values[n] = values[n] * sign;
        }
    }

    @Override
    protected TautomerizationPlugin getStandardizationPlugin() {
        if (!this.considerTautomerization) {
            return null;
        }
        TautomerizationPlugin tplugin = new TautomerizationPlugin();
        tplugin.setLicenseEnvironment("LicenseEnvironmentForPartitioningPluginGroup");
        tplugin.setWigglyBondVisibility(false);
        tplugin.setTakeCanonicalForm(true);
        return tplugin;
    }

    private static class PKaResult {
        int index;
        double value;

        PKaResult(int index, double value) {
            this.index = index;
            this.value = value;
        }
    }
}

