/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.pka;

import chemaxon.calculations.hydrogenize.Hydrogenize;
import chemaxon.calculations.pka.createpKaCenterDataFile;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.io.MPropHandler;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.util.DotfileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class PKaTraining {
    private static void standardize(Molecule m) {
        Hydrogenize.removeHAtoms(m, 2047);
        m.dearomatize();
        PKaTraining.standardizeIonicGroups(m);
        m.aromatize(1);
    }

    private static void standardizeIonicGroups(Molecule mol) {
        block0: for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            MolAtom a = mol.getAtom(i);
            if (a.getAtno() == 7 && a.getCharge() == 1) {
                int radical = a.getRadical();
                if (radical == 2 || radical == 6 || radical == 10) continue;
                for (int j = a.getBondCount() - 1; j >= 0; --j) {
                    MolBond b;
                    MolAtom o = a.getLigand(j);
                    if (o.getAtno() != 8 || (b = a.getBond(j)).getType() != 1 || o.getCharge() != -1) continue;
                    PKaTraining.transformIonic(mol, a, o, b);
                    continue block0;
                }
                continue;
            }
            if (a.getAtno() != 16 || a.getCharge() != 1) continue;
            int sc = 0;
            MolBond b1 = null;
            MolAtom o1 = null;
            for (int j = a.getBondCount() - 1; j >= 0; --j) {
                MolBond b;
                MolAtom o = a.getLigand(j);
                if (o.getAtno() == 8) {
                    b = a.getBond(j);
                    if (b.getType() != 1 || o.getCharge() != -1) continue;
                    b1 = b;
                    o1 = o;
                    continue;
                }
                if (o.getAtno() != 6 || (b = a.getBond(j)).getType() != 1 || o.getCharge() != 0) continue;
                ++sc;
            }
            if (b1 == null || sc < 2) continue;
            PKaTraining.transformIonic(mol, a, o1, b1);
        }
    }

    private static void transformIonic(Molecule mol, MolAtom a1, MolAtom a2, MolBond b) {
        MolAtom a = a1.getCharge() > 0 ? a1 : a2;
        int type = 2;
        if (a.getImplicitHcount() > 0) {
            type = 1;
        } else {
            for (int i = a.getBondCount() - 1; i >= 0; --i) {
                MolAtom ligand = a.getLigand(i);
                if (!ligand.isImplicitizableH(0)) continue;
                mol.removeAtom(ligand);
                type = 1;
                break;
            }
        }
        b.setType(type);
        a1.setCharge(0);
        a2.setCharge(0);
        a1.valenceCheck();
        a2.valenceCheck();
    }

    private static double[][] getExperimentalpKaCouples(Molecule m) {
        int i;
        int k;
        int baseIndex = 1;
        int zz = m.getExplicitHcount();
        int xx = m.getAtomCount();
        int maxIndex = xx - zz - 1;
        int q = 0;
        int[] eH = new int[zz];
        if (zz != 0) {
            for (int h = 0; h < xx; ++h) {
                MolAtom a = m.getAtom(h);
                int pc = a.getAtno();
                if (pc != 1) continue;
                eH[q] = h;
                ++q;
            }
        }
        int size = m.getPropertyCount();
        int j = 0;
        int jj = 0;
        double[] pka = new double[size];
        int[] pkaIndx = new int[size];
        int[] atomIndx = new int[size];
        int[] idIndx = new int[size];
        for (k = 0; k < size; ++k) {
            String property;
            int indx;
            String ps = m.getPropertyKey(k);
            String s = "";
            if (ps.length() > 3) {
                s = ps.substring(0, 3);
            } else if (ps.length() > 2) {
                s = ps.substring(0, 2);
            }
            if (s.equals("pKa") || s.equals("pka")) {
                try {
                    s = ps.substring(3, ps.length());
                    pkaIndx[j] = indx = Integer.parseInt(s);
                    property = MPropHandler.convertToString(m.properties(), ps);
                    pka[j] = Double.parseDouble(property);
                    ++j;
                    continue;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            if (!s.equals("ID") && !s.equals("id")) continue;
            try {
                s = ps.substring(2, ps.length());
                idIndx[jj] = indx = Integer.parseInt(s);
                property = MPropHandler.convertToString(m.properties(), ps);
                atomIndx[jj] = Integer.parseInt(property);
                int shift = PKaTraining.getBaseIndexShift(atomIndx[jj], eH);
                atomIndx[jj] = atomIndx[jj] - shift;
                if (!PKaTraining.isCorrect(atomIndx[jj] - baseIndex, maxIndex)) {
                    return null;
                }
                ++jj;
                continue;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        int ss = 0;
        ss = j < jj ? j : jj;
        double[][] pkaCouple = new double[2][ss];
        for (i = 0; i < ss; ++i) {
            pkaCouple[0][i] = Double.NaN;
            pkaCouple[1][i] = Double.NaN;
        }
        int x = 0;
        for (i = 0; i < jj; ++i) {
            boolean find = false;
            for (k = 0; k < j && !find; ++k) {
                if (pkaIndx[k] != idIndx[i]) continue;
                find = true;
            }
            if (!find) continue;
            pkaCouple[0][x] = pka[k - 1];
            pkaCouple[1][x] = atomIndx[i] - baseIndex;
            ++x;
        }
        return pkaCouple;
    }

    private static boolean isCorrect(int ai, int max) {
        if (ai < 0) {
            return false;
        }
        return ai <= max;
    }

    private static int getBaseIndexShift(int aindx, int[] h) {
        --aindx;
        int c = 0;
        for (int y = 0; y < h.length; ++y) {
            if (aindx <= h[y]) continue;
            ++c;
        }
        return c;
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = PKaTraining.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void deleteAllUnUsedFiles(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                PKaTraining.deleteAllUnUsedFiles(new File(dir, children[i]));
            }
            return;
        } else {
            String f = dir.getName();
            int L = f.length();
            String y = f.substring(L - 5, L - 4);
            try {
                if (y.equals("V")) return;
                Integer.parseInt(y);
                return;
            }
            catch (NumberFormatException ex) {
                dir.delete();
            }
        }
    }

    private static void deleteAllUnUsedDirs(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            if (children.length == 0) {
                dir.delete();
            }
            for (int i = 0; i < children.length; ++i) {
                PKaTraining.deleteAllUnUsedDirs(new File(dir, children[i]));
            }
        }
    }

    private static void addDirectory(ZipOutputStream zout, File fileSource) {
        File[] files = fileSource.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                PKaTraining.addDirectory(zout, files[i]);
                continue;
            }
            try {
                int length;
                byte[] buffer = new byte[1024];
                FileInputStream fin = new FileInputStream(files[i]);
                String relativePath = files[i].getPath().replace(DotfileUtil.getDotFile("calculations/training/").getPath() + File.separator, "");
                zout.putNextEntry(new ZipEntry(relativePath));
                while ((length = fin.read(buffer)) > 0) {
                    zout.write(buffer, 0, length);
                }
                zout.closeEntry();
                fin.close();
                continue;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    private static void zipAllParamterFiles(File sourceDirectory) {
        String sourceDir = sourceDirectory.getAbsolutePath();
        String zipFile = sourceDirectory.getAbsolutePath() + "." + "pkadata";
        try {
            FileOutputStream fout = new FileOutputStream(zipFile);
            ZipOutputStream zout = new ZipOutputStream(fout);
            File fileSource = new File(sourceDir);
            PKaTraining.addDirectory(zout, fileSource);
            zout.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void calculatepKaIncrements(MolImporter importer, String pKaTrainingId, String validationFilePath) throws NumberFormatException, IOException, IllegalArgumentException {
        if (pKaTrainingId == null) {
            throw new IllegalArgumentException("pKa training ID cannot be null.");
        }
        String pKaParameterFilePath = DotfileUtil.getDotFile("calculations/training/").getAbsolutePath() + File.separator + pKaTrainingId.toLowerCase();
        File d = new File(pKaParameterFilePath);
        if (d.exists()) {
            PKaTraining.deleteDir(d);
        }
        boolean isCVwanted = true;
        if (validationFilePath == null || validationFilePath.length() == 0) {
            isCVwanted = false;
        }
        createpKaCenterDataFile crpka = new createpKaCenterDataFile();
        crpka.setWorkdirectoryPath(pKaParameterFilePath);
        crpka.setpKaModelFileName(validationFilePath);
        crpka.initCenterDirectories();
        Molecule mol = new Molecule();
        double[][] pKaCouples = null;
        int y = 0;
        while (importer.read(mol)) {
            pKaCouples = PKaTraining.getExperimentalpKaCouples(mol);
            if (pKaCouples != null) {
                PKaTraining.standardize(mol);
                crpka.setpKaExpAtomIdCouples(pKaCouples);
                crpka.setActMolIndex(y);
                crpka.createpKaCenterDataFile2(mol);
            }
            ++y;
        }
        crpka.setUnknownpKaParameters();
        int w = 0;
        if (isCVwanted) {
            try {
                if (importer.isRewindable()) {
                    importer.seekRecord(0, null);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            y = 0;
            while (importer.read(mol)) {
                pKaCouples = PKaTraining.getExperimentalpKaCouples(mol);
                if (pKaCouples != null) {
                    PKaTraining.standardize(mol);
                    crpka.setpKaExpAtomIdCouples(pKaCouples);
                    if (w == 0) {
                        crpka.calcPredictedpKa(mol, y, false);
                        ++w;
                    } else {
                        crpka.calcPredictedpKa(mol, y, true);
                    }
                }
                ++y;
            }
            w = 0;
            crpka.setLOOCVFlag(true);
            for (int i = 0; i < y; ++i) {
                importer.seekRecord(0, null);
                for (int k = 0; importer.read(mol) && k != i; ++k) {
                }
                pKaCouples = PKaTraining.getExperimentalpKaCouples(mol);
                if (pKaCouples == null) continue;
                crpka.setReducedUnknownpKaParameters(i);
                PKaTraining.standardize(mol);
                crpka.setpKaExpAtomIdCouples(pKaCouples);
                if (w == 0) {
                    crpka.calcPredictedpKa(mol, i, false);
                    ++w;
                    continue;
                }
                crpka.calcPredictedpKa(mol, i, true);
            }
            crpka.setLOOCVFlag(false);
        }
        PKaTraining.deleteAllUnUsedFiles(new File(pKaParameterFilePath));
        PKaTraining.deleteAllUnUsedDirs(new File(pKaParameterFilePath));
        PKaTraining.zipAllParamterFiles(new File(pKaParameterFilePath));
        PKaTraining.deleteDir(new File(pKaParameterFilePath));
    }
}

