/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.pka;

import chemaxon.calculations.hydrogenize.Hydrogenize;
import chemaxon.marvin.calculations.TautomerizationPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import java.util.ArrayList;

class StandardMoleculeCalculator {
    private final Molecule original;
    private Molecule result = null;
    private int[] indexMap;
    private boolean isMultiFragmentAllowed = false;
    private boolean tautomerCalculated = false;

    public StandardMoleculeCalculator(Molecule molecule, boolean isMultiFragmentAllowed) {
        this.original = molecule;
        this.isMultiFragmentAllowed = isMultiFragmentAllowed;
    }

    public Molecule calculate(TautomerizationPlugin plugin, boolean implicitizeHs) {
        if (this.result == null || this.tautomerCalculated == (plugin == null)) {
            this.tautomerCalculated = plugin != null;
            this.setMolecule(true, true, this.isMultiFragmentAllowed, plugin, implicitizeHs);
        }
        return this.result;
    }

    public int getModifiedIndex(int originalindex) {
        if (this.indexMap == null || originalindex < 0 || originalindex >= this.indexMap.length) {
            return -1;
        }
        return this.indexMap[originalindex];
    }

    public void setMolecule(boolean st, boolean om, boolean isMultiFragmentAllowed, TautomerizationPlugin plugin, boolean implicitizeHs) {
        int i;
        Molecule cloneMol = this.original.cloneMoleculeWithDocument();
        cloneMol.ungroupSgroups();
        ArrayList<MolAtom> atomList = new ArrayList<MolAtom>();
        for (i = 0; i < cloneMol.getAtomCount(); ++i) {
            atomList.add(cloneMol.getAtom(i));
        }
        if (st) {
            cloneMol = this.createStandardizedMolecule(cloneMol, isMultiFragmentAllowed);
            cloneMol.clearExtraLabels();
            cloneMol.setAtomSetSeqs(0);
            cloneMol.setBondSetSeqs(0);
        }
        if (implicitizeHs) {
            Hydrogenize.removeHAtoms(cloneMol, 2047);
        }
        this.indexMap = new int[atomList.size()];
        for (i = 0; i < this.indexMap.length; ++i) {
            this.indexMap[i] = cloneMol.indexOf((MolAtom)atomList.get(i));
        }
        if (plugin != null) {
            try {
                cloneMol = this.takeMajorTautomer(cloneMol, plugin);
            }
            catch (PluginException e) {
                // empty catch block
            }
        }
        this.setResultMolecule(cloneMol);
    }

    protected void setResultMolecule(Molecule molecule) {
        this.result = molecule;
    }

    protected Molecule getOriginal() {
        return this.original;
    }

    protected Molecule createStandardizedMolecule(Molecule mol, boolean isMultiFragmentAllowed) {
        if (!isMultiFragmentAllowed && mol.getFragCount(1) > 1) {
            MoleculeGraph[] frags = mol.findFrags(mol.getClass(), 1);
            MoleculeGraph frag = frags[0];
            int m = frag.getAtomCount();
            for (int i = 1; i < frags.length; ++i) {
                if (frags[i].getAtomCount() <= m) continue;
                frag = frags[i];
                m = frag.getAtomCount();
            }
            mol = (Molecule)frag;
        }
        this.standardize(mol);
        return mol;
    }

    public void standardize(Molecule mol) {
        mol.dearomatize();
        StandardMoleculeCalculator.standardizeIonicGroups(mol);
        mol.aromatize(1);
    }

    protected static void standardizeIonicGroups(Molecule mol) {
        block0: for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            MolAtom a = mol.getAtom(i);
            if (a.getAtno() == 7 && a.getCharge() == 1) {
                int radical = a.getRadical();
                if (radical == 2 || radical == 6 || radical == 10) continue;
                for (int j = a.getBondCount() - 1; j >= 0; --j) {
                    MolBond b;
                    MolAtom o = a.getLigand(j);
                    if (o.getAtno() != 8 || (b = a.getBond(j)).getType() != 1 || o.getCharge() != -1) continue;
                    StandardMoleculeCalculator.transformIonic(mol, a, o, b);
                    continue block0;
                }
                continue;
            }
            if (a.getAtno() != 16 || a.getCharge() != 1) continue;
            int sc = 0;
            MolBond b1 = null;
            MolAtom o1 = null;
            for (int j = a.getBondCount() - 1; j >= 0; --j) {
                MolBond b;
                MolAtom o = a.getLigand(j);
                if (o.getAtno() == 8) {
                    b = a.getBond(j);
                    if (b.getType() != 1 || o.getCharge() != -1) continue;
                    b1 = b;
                    o1 = o;
                    continue;
                }
                if (o.getAtno() != 6 || (b = a.getBond(j)).getType() != 1 || o.getCharge() != 0) continue;
                ++sc;
            }
            if (b1 == null || sc < 2) continue;
            StandardMoleculeCalculator.transformIonic(mol, a, o1, b1);
        }
    }

    private static void transformIonic(Molecule mol, MolAtom a1, MolAtom a2, MolBond b) {
        MolAtom a = a1.getCharge() > 0 ? a1 : a2;
        int type = 2;
        if (a.getImplicitHcount() > 0) {
            type = 1;
        } else {
            for (int i = a.getBondCount() - 1; i >= 0; --i) {
                MolAtom ligand = a.getLigand(i);
                if (!ligand.isImplicitizableH(0)) continue;
                mol.removeAtom(ligand);
                type = 1;
                break;
            }
        }
        b.setType(type);
        a1.setCharge(0);
        a2.setCharge(0);
        a1.valenceCheck();
        a2.valenceCheck();
    }

    protected Molecule takeMajorTautomer(Molecule mol, TautomerizationPlugin plugin) throws PluginException {
        plugin.setMolecule(mol);
        plugin.run();
        Molecule canonicalTautomericForm = plugin.getStructure(0);
        this.standardize(canonicalTautomericForm);
        return canonicalTautomericForm;
    }
}

