/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.pka;

import chemaxon.calculations.LinearFitting;
import chemaxon.calculations.pka.Ionizer;
import chemaxon.calculations.pka.pKaParameters;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;

class createpKaCenterDataFile {
    static final String[] PKA_TYPES = new String[]{"OHAcpKa.dat", "SHAcpKa.dat", "NHAcpKa.dat", "CHAcpKa.dat", "OBasicpKa.dat", "SBasicpKa.dat", "NBasicpKa.dat", "PBasicpKa.dat", "CBasicpKa.dat", "HALOAcpKa.dat"};
    private static final int PKA_TYPE_COUNT = PKA_TYPES.length;
    private static final int PARAMETER_COUNT = 1000;
    private pKaParameters pKapara;
    private Molecule mol;
    private Molecule molCopy;
    private PrintWriter center;
    private String[] pV;
    private int[][] parameters;
    private final int ACIDIC = -1;
    private final int BASIC = 1;
    private String wDirPath;
    private String pkamodel;
    private Ionizer ionizer;
    private File actDir;
    private String actFileName;
    protected int mainDirIndex;
    protected int pKaType;
    private int actParIndx;
    private int actParamCount;
    private int actRowCount;
    private double[] actExppKa;
    private double[] actPredpKa;
    private double[] pKaExp;
    private int[] pKaAtomId;
    private double[] actCalcpKa;
    private int[] actpKaType;
    private boolean deltapKa = true;
    private int actExpKaCount;
    private double actDiff;
    private double actCpKa;
    private int[] ioAtoms;
    private int actMolIndex;
    private int ionizableAtomCount = 0;
    private boolean loocv;

    protected createpKaCenterDataFile() {
    }

    protected createpKaCenterDataFile(Molecule m) {
        this.setMolecule(m);
    }

    protected void setMolecule(Molecule m) {
        this.mol = m.cloneMoleculeWithDocument();
    }

    protected void calcpKaCenterDataFile() {
        this.pKapara = new pKaParameters(this.mol);
        this.pKapara.setIonizableAtoms(this.ionizableAtomCount, this.ioAtoms);
        this.pKapara.createpKaParamters();
    }

    protected void setIonizableAtoms(int ioac, int[] io) {
        this.ionizableAtomCount = ioac;
        this.ioAtoms = io;
    }

    protected void setActMolIndex(int molIndx) {
        this.actMolIndex = molIndx;
    }

    protected void createpKaCenterDataFile2(Molecule m) {
        this.actCalcpKa = new double[this.actExpKaCount];
        this.actpKaType = new int[this.actExpKaCount];
        for (int i = 0; i < this.actExpKaCount; ++i) {
            this.mol = m.cloneMoleculeWithDocument();
            this.calcpKa(this.mol);
            this.mol = this.setIonizationState(i, this.mol);
            if (this.mol == null) {
                return;
            }
            this.calcpKa(this.mol);
            this.pKapara = new pKaParameters(this.mol);
            this.pKapara.createpKaParamters();
            this.printpKaParameters(i);
        }
    }

    private Molecule setIonizationState(int count, Molecule m) {
        MolAtom a;
        double givenpKa = this.pKaExp[count];
        int givenAtom = this.pKaAtomId[count];
        try {
            a = m.getAtom(givenAtom);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
        if (a.getAtno() == 6) {
            return m;
        }
        for (int i = 0; i < m.getAtomCount(); ++i) {
            double diff;
            if (i == givenAtom) continue;
            double cApKa = this.ionizer.getpKa(i, -1);
            double cBpKa = this.ionizer.getpKa(i, 1);
            if (Double.isNaN(cApKa) && Double.isNaN(cBpKa)) continue;
            boolean chgAdjusted = false;
            int otherGivenId = this.getOtherGivenpKaIndex(i);
            if (otherGivenId != -1) {
                if (this.actpKaType[otherGivenId] == -1) {
                    cApKa = this.pKaExp[otherGivenId];
                } else if (this.actpKaType[otherGivenId] == 1) {
                    cBpKa = this.pKaExp[otherGivenId];
                }
            }
            if (!Double.isNaN(cApKa) && (diff = givenpKa - cApKa) > 1.0) {
                a = m.getAtom(i);
                this.setCahrge(a, -1);
                chgAdjusted = true;
            }
            if (chgAdjusted || Double.isNaN(cBpKa) || !((diff = givenpKa - cBpKa) < -1.0)) continue;
            a = m.getAtom(i);
            this.setCahrge(a, 1);
            chgAdjusted = true;
        }
        return m;
    }

    private int getOtherGivenpKaIndex(int ai) {
        for (int i = 0; i < this.actExpKaCount; ++i) {
            if (this.pKaAtomId[i] != ai) continue;
            return i;
        }
        return -1;
    }

    private void setCahrge(MolAtom a, int chg) {
        int implicitHCount = a.getImplicitHcount();
        if (chg == 1) {
            a.setImplicitHcount(implicitHCount + 1);
        } else if (chg == -1 && implicitHCount != 0) {
            a.setImplicitHcount(implicitHCount - 1);
        }
        a.setCharge(chg);
    }

    protected void setWorkdirectoryPath(String wdp) {
        this.wDirPath = wdp;
    }

    protected void setpKaModelFileName(String x) {
        this.pkamodel = x;
    }

    protected void setpKaExpAtomIdCouples(double[][] pkaExp) {
        int L = pkaExp[0].length;
        this.pKaExp = new double[L];
        this.pKaAtomId = new int[L];
        this.actExpKaCount = 0;
        for (int i = 0; i < L; ++i) {
            if (Double.isNaN(pkaExp[0][i])) continue;
            this.pKaExp[i] = pkaExp[0][i];
            this.pKaAtomId[i] = (int)pkaExp[1][i];
            ++this.actExpKaCount;
        }
    }

    protected void initCenterDirectories() {
        File f = null;
        for (int i = 0; i < PKA_TYPE_COUNT; ++i) {
            String dir = this.wDirPath + "/" + PKA_TYPES[i];
            f = new File(dir);
            if (f.exists()) continue;
            f.mkdirs();
        }
    }

    private void printpKaParameters(int count) {
        for (int i = 0; i < this.pKapara.cc; ++i) {
            int centerIndx = this.getCenterIndex(i);
            if (centerIndx == -1) continue;
            this.setCenterInfo(true, i, centerIndx, count);
        }
    }

    private void calcpKa(Molecule m) {
        this.ionizer = new Ionizer();
        this.ionizer.micropKaCalc = true;
        this.ionizer.setpKaPrefixType(1);
        this.ionizer.setReversStartOrder(true);
        this.molCopy = m.cloneMoleculeWithDocument();
        this.ionizer.setMolecule(this.molCopy);
        this.ionizer.setMspHCalc(false);
        this.ionizer.setAcidicpKaUpperLimit(100.0);
        this.ionizer.calculatepKa(0.0);
        this.ionizer.setSymmetryGroupInfo();
        int[] used = new int[m.getAtomCount()];
        for (int i = 0; i < this.actExpKaCount; ++i) {
            int si;
            this.actCalcpKa[i] = Double.NaN;
            boolean find = false;
            int ai = this.pKaAtomId[i];
            double cApKa = this.ionizer.getpKa(ai, -1);
            double cBpKa = this.ionizer.getpKa(ai, 1);
            double diff1 = 1000.0;
            double diff2 = 1000.0;
            if (!Double.isNaN(cApKa)) {
                diff1 = Math.abs(this.pKaExp[i] - cApKa);
                si = this.checkOtherSymmetricCenter(i, diff1, -1, this.ionizer);
                if (si != ai) {
                    if (used[si] != 1) {
                        used[si] = 1;
                        diff1 = this.actDiff;
                        cApKa = this.actCpKa;
                    } else {
                        used[ai] = 1;
                    }
                } else {
                    used[ai] = 1;
                }
                find = true;
            }
            if (!Double.isNaN(cBpKa)) {
                diff2 = Math.abs(this.pKaExp[i] - cBpKa);
                si = this.checkOtherSymmetricCenter(i, diff2, 1, this.ionizer);
                if (si != ai) {
                    if (used[si] != 1) {
                        used[si] = 1;
                        diff2 = this.actDiff;
                        cBpKa = this.actCpKa;
                    } else {
                        used[ai] = 1;
                    }
                } else {
                    used[ai] = 1;
                }
                find = true;
            }
            if (!find) continue;
            if (diff1 < diff2) {
                this.actCalcpKa[i] = cApKa;
                this.actpKaType[i] = -1;
                continue;
            }
            this.actCalcpKa[i] = cBpKa;
            this.actpKaType[i] = 1;
        }
    }

    private int checkOtherSymmetricCenter(int count, double d, int type, Ionizer ionizer) {
        int ai;
        int indx = ai = this.pKaAtomId[count];
        if (ionizer.isSymmetric()) {
            int i;
            int y = ionizer.getIonizableAtomCount();
            boolean find = false;
            int sIndx = 0;
            for (i = 0; i < y && !find; ++i) {
                if (ionizer.symInfo[i][1] != ai) continue;
                find = true;
                sIndx = i;
            }
            this.actDiff = d;
            if (find) {
                int sg = ionizer.symInfo[sIndx][0];
                for (i = 0; i < y; ++i) {
                    double diff;
                    int atom;
                    double cpKa;
                    if (ionizer.symInfo[i][0] != sg || i == sIndx || Double.isNaN(cpKa = ionizer.getpKa(atom = ionizer.symInfo[i][1], type)) || !((diff = Math.abs(this.pKaExp[count] - cpKa)) < this.actDiff)) continue;
                    this.actDiff = diff;
                    this.actCpKa = cpKa;
                    indx = atom;
                }
            }
        }
        return indx;
    }

    protected void setUnknownpKaParameters() {
        for (int i = 0; i < PKA_TYPES.length; ++i) {
            this.actDir = new File(this.wDirPath + "/" + PKA_TYPES[i]);
            String[] children = this.actDir.list();
            for (int j = 0; j < children.length; ++j) {
                this.actFileName = children[j];
                File g = new File(this.actDir, this.actFileName);
                int lcount = 0;
                try {
                    String line;
                    BufferedReader in = new BufferedReader(new FileReader(g));
                    while ((line = in.readLine()) != null) {
                        ++lcount;
                    }
                    in.close();
                    this.initParamVector(lcount);
                    in = new BufferedReader(new FileReader(g));
                    int k = 0;
                    while ((line = in.readLine()) != null) {
                        this.setParameters(line, k);
                        ++k;
                    }
                    in.close();
                    this.center = new PrintWriter(new FileOutputStream(g, true));
                    k = 0;
                    while (!this.pV[k].equals("")) {
                        this.center.println(this.pV[k]);
                        ++k;
                    }
                    this.actParamCount = k;
                    this.actRowCount = this.getActObservationCount(lcount);
                    this.center.println("DESIGN MATRIX\t" + this.actRowCount + "\t" + this.actParamCount);
                    for (int y = 0; y < lcount; ++y) {
                        if (Double.isNaN(this.actExppKa[y])) continue;
                        if (!this.deltapKa) {
                            this.center.print(this.actExppKa[y] + "\t");
                        } else {
                            double dif = this.actPredpKa[y] - this.actExppKa[y];
                            this.center.print(dif + "\t");
                        }
                        for (k = 0; k < this.actParamCount; ++k) {
                            this.center.print(this.parameters[y][k] + "\t");
                        }
                        this.center.println();
                    }
                    this.pKaRegression(lcount);
                    this.center.close();
                    continue;
                }
                catch (IOException e) {
                    System.err.println("Exception reading");
                }
            }
        }
    }

    protected void setLOOCVFlag(boolean isYes) {
        this.loocv = isYes;
    }

    private boolean isRightFileName(String fn) {
        int L = fn.length();
        String z = fn.substring(L - 4, L - 3);
        if (!z.equals(".")) {
            return false;
        }
        z = fn.substring(L - 5, L - 4);
        try {
            Integer.parseInt(z);
        }
        catch (NumberFormatException e) {
            return true;
        }
        return false;
    }

    protected void setReducedUnknownpKaParameters(int mIndx) {
        for (int i = 0; i < PKA_TYPES.length; ++i) {
            this.actDir = new File(this.wDirPath + "/" + PKA_TYPES[i]);
            String[] children = this.actDir.list();
            for (int j = 0; j < children.length; ++j) {
                this.actFileName = children[j];
                if (!this.isRightFileName(this.actFileName)) continue;
                File g = new File(this.actDir, this.actFileName);
                File gloocv = new File(this.actDir, this.actFileName + "cv");
                int lcount = 0;
                try {
                    int mi;
                    String line;
                    BufferedReader in = new BufferedReader(new FileReader(g));
                    while ((line = in.readLine()) != null && (mi = this.getMolIndex(line)) != -1) {
                        if (mi == mIndx) continue;
                        ++lcount;
                    }
                    in.close();
                    this.initParamVector(lcount);
                    in = new BufferedReader(new FileReader(g));
                    int k = 0;
                    this.actRowCount = 0;
                    while ((line = in.readLine()) != null && (mi = this.getMolIndex(line)) != -1) {
                        if (mi == mIndx) continue;
                        this.setParameters(line, k);
                        if (!Double.isNaN(this.actExppKa[k])) {
                            ++this.actRowCount;
                        }
                        ++k;
                    }
                    in.close();
                    this.center = new PrintWriter(new FileOutputStream(gloocv, false));
                    k = 0;
                    while (!this.pV[k].equals("")) {
                        this.center.println(this.pV[k]);
                        ++k;
                    }
                    k = 0;
                    while (!this.pV[k].equals("")) {
                        ++k;
                    }
                    this.actParamCount = k;
                    this.center.println("DESIGN MATRIX\t" + this.actRowCount + "\t" + this.actParamCount);
                    for (int y = 0; y < lcount; ++y) {
                        if (Double.isNaN(this.actExppKa[y])) continue;
                        if (!this.deltapKa) {
                            this.center.print(this.actExppKa[y] + "\t");
                        } else {
                            double dif = this.actPredpKa[y] - this.actExppKa[y];
                            this.center.print(dif + "\t");
                        }
                        for (k = 0; k < this.actParamCount; ++k) {
                            this.center.print(this.parameters[y][k] + "\t");
                        }
                        this.center.println();
                    }
                    this.pKaRegression(lcount);
                    this.center.close();
                    continue;
                }
                catch (IOException e) {
                    System.err.println("Exception reading");
                }
            }
        }
    }

    private int getMolIndex(String line) {
        for (int i = 0; i < line.length(); ++i) {
            String ch = line.substring(i, i + 1);
            if (!ch.equals("\t")) continue;
            String z = line.substring(0, i);
            try {
                return Integer.parseInt(z);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    private int getActObservationCount(int lcount) {
        int y = 0;
        for (int i = 0; i < lcount; ++i) {
            if (Double.isNaN(this.actExppKa[i])) continue;
            ++y;
        }
        return y;
    }

    private void initParamVector(int lineCount) {
        this.parameters = new int[lineCount][1000];
        this.actExppKa = new double[lineCount];
        this.actPredpKa = new double[lineCount];
        this.pV = new String[1000];
        for (int i = 0; i < 1000; ++i) {
            this.pV[i] = "";
        }
    }

    private void setParameters(String s, int line) {
        int i = 0;
        boolean find = false;
        boolean first = false;
        int ib = 0;
        int ie = 0;
        int tc = 0;
        String[] p = new String[1000];
        for (int y = 0; y < 1000; ++y) {
            p[y] = "";
        }
        int j = 0;
        while (i < s.length()) {
            String ch = s.substring(i, i + 1);
            if (ch.equals("\t")) {
                find = true;
                ie = i;
                ++tc;
            }
            if (find) {
                String z;
                if (tc == 1) {
                    ib = ie + 1;
                } else if (tc == 2) {
                    z = s.substring(ib, ie);
                    if (z.equals("NaN")) {
                        this.actExppKa[line] = Double.NaN;
                        return;
                    }
                    this.actExppKa[line] = Double.parseDouble(z);
                    ib = ie + 1;
                } else if (tc == 3) {
                    z = s.substring(ib, ie);
                    this.actPredpKa[line] = Double.parseDouble(z);
                } else if (tc == 6) {
                    ib = ie + 1;
                    first = true;
                } else if (tc > 6) {
                    p[j] = s.substring(ib, ie);
                    ib = ie + 1;
                    ++j;
                }
                find = false;
            }
            if (i == s.length() - 1 && first) {
                p[j] = s.substring(ib, i + 1);
                ++j;
            }
            ++i;
        }
        boolean end = false;
        for (int k = 0; k < 1000 && !end; ++k) {
            if (!p[k].equals("")) {
                if (!this.isParameterExist(p[k])) {
                    this.pV[this.actParIndx] = p[k];
                }
                int[] nArray = this.parameters[line];
                int n = this.actParIndx;
                nArray[n] = nArray[n] + 1;
                continue;
            }
            end = true;
        }
    }

    private boolean isParameterExist(String pi) {
        this.actParIndx = 0;
        for (int i = 0; i < 1000; ++i) {
            if (this.pV[i].equals(pi)) {
                this.actParIndx = i;
                return true;
            }
            if (!this.pV[i].equals("")) continue;
            this.actParIndx = i;
            return false;
        }
        return false;
    }

    private void setCenterInfo(boolean append, int ci, int type, int count) {
        String fn;
        String dir = this.wDirPath + "/" + PKA_TYPES[this.mainDirIndex];
        File f = new File(dir, fn = String.valueOf(type) + PKA_TYPES[this.mainDirIndex]);
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException ex) {
                System.err.println(ex);
            }
        }
        this.center = null;
        try {
            this.center = new PrintWriter(new FileOutputStream(f, append));
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
        if (this.pKaAtomId[count] == this.pKapara.centerIndex[ci] && this.pKaType == this.actpKaType[count]) {
            this.center.print(this.actMolIndex + "\t" + this.pKaExp[count] + "\t" + this.actCalcpKa[count] + "\t" + this.pKapara.centerType[ci] + "\t" + this.pKapara.centerIndex[ci] + "\t" + type);
        } else {
            this.center.print(this.actMolIndex + "\t" + "NaN" + "\t" + "NaN" + "\t" + this.pKapara.centerType[ci] + "\t" + this.pKapara.centerIndex[ci] + "\t" + type);
        }
        int j = 0;
        while (!this.pKapara.pType[ci][j].equals("END")) {
            this.center.print("\t" + this.pKapara.pType[ci][j]);
            ++j;
        }
        this.center.println();
        this.center.close();
    }

    protected int getCenterIndex(int ci) {
        if (this.pKapara.centerType[ci] == null) {
            return -1;
        }
        String str = this.pKapara.centerType[ci];
        String subStr = str.substring(0, 7);
        if (subStr.equals("OH-ACID")) {
            this.mainDirIndex = 0;
            this.pKaType = -1;
            return this.getOHACIDIndx(ci);
        }
        if (subStr.equals("SH-ACID")) {
            this.mainDirIndex = 1;
            this.pKaType = -1;
            return this.getSHACIDIndx(ci);
        }
        if (subStr.equals("NH-ACID")) {
            this.mainDirIndex = 2;
            this.pKaType = -1;
            return this.getNHACIDIndx(ci);
        }
        if (subStr.equals("XH-ACID")) {
            this.mainDirIndex = 9;
            this.pKaType = -1;
            return this.getXHACIDIndx(ci);
        }
        if (subStr.equals("CH-ACID")) {
            this.mainDirIndex = 3;
            this.pKaType = -1;
            return this.getCHACIDIndx(ci);
        }
        if (subStr.equals("N-BASIC")) {
            this.mainDirIndex = 6;
            this.pKaType = 1;
            return this.getNBASICIndx(ci);
        }
        if (subStr.equals("P-BASIC")) {
            this.mainDirIndex = 7;
            this.pKaType = 1;
            return this.getPBASICIndx(ci);
        }
        if (subStr.equals("S-BASIC")) {
            this.mainDirIndex = 5;
            this.pKaType = 1;
            return this.getSBASICIndx(ci);
        }
        if (subStr.equals("O-BASIC")) {
            this.mainDirIndex = 4;
            this.pKaType = 1;
            return this.getOBASICIndx(ci);
        }
        if (subStr.equals("C-BASIC")) {
            this.mainDirIndex = 8;
            this.pKaType = 1;
            return this.getCBASICIndx(ci);
        }
        return -1;
    }

    private int getOHACIDIndx(int ind) {
        int L = pKaParameters.PKACENTERS_OH_ACID.length;
        for (int i = 0; i < L; ++i) {
            if (!pKaParameters.PKACENTERS_OH_ACID[i].equals(this.pKapara.centerType[ind])) continue;
            return i;
        }
        return -1;
    }

    private int getSHACIDIndx(int ind) {
        int L = pKaParameters.PKACENTERS_SH_ACID.length;
        for (int i = 0; i < L; ++i) {
            if (!pKaParameters.PKACENTERS_SH_ACID[i].equals(this.pKapara.centerType[ind])) continue;
            return i;
        }
        return -1;
    }

    private int getNHACIDIndx(int ind) {
        int L = pKaParameters.PKACENTERS_NH_ACID.length;
        for (int i = 0; i < L; ++i) {
            if (!pKaParameters.PKACENTERS_NH_ACID[i].equals(this.pKapara.centerType[ind])) continue;
            return i;
        }
        return -1;
    }

    private int getCHACIDIndx(int ind) {
        int L = pKaParameters.PKACENTERS_CH_ACID.length;
        for (int i = 0; i < L; ++i) {
            if (!pKaParameters.PKACENTERS_CH_ACID[i].equals(this.pKapara.centerType[ind])) continue;
            return i;
        }
        return -1;
    }

    private int getXHACIDIndx(int ind) {
        int L = pKaParameters.PKACENTERS_XH_ACID.length;
        for (int i = 0; i < L; ++i) {
            if (!pKaParameters.PKACENTERS_XH_ACID[i].equals(this.pKapara.centerType[ind])) continue;
            return i;
        }
        return -1;
    }

    private int getNBASICIndx(int ind) {
        int L = pKaParameters.PKACENTERS_N_BASIC.length;
        for (int i = 0; i < L; ++i) {
            if (!pKaParameters.PKACENTERS_N_BASIC[i].equals(this.pKapara.centerType[ind])) continue;
            return i;
        }
        return -1;
    }

    private int getOBASICIndx(int ind) {
        int L = pKaParameters.PKACENTERS_O_BASIC.length;
        for (int i = 0; i < L; ++i) {
            if (!pKaParameters.PKACENTERS_O_BASIC[i].equals(this.pKapara.centerType[ind])) continue;
            return i;
        }
        return -1;
    }

    private int getPBASICIndx(int ind) {
        int L = pKaParameters.PKACENTERS_P_BASIC.length;
        for (int i = 0; i < L; ++i) {
            if (!pKaParameters.PKACENTERS_P_BASIC[i].equals(this.pKapara.centerType[ind])) continue;
            return i;
        }
        return -1;
    }

    private int getSBASICIndx(int ind) {
        int L = pKaParameters.PKACENTERS_S_BASIC.length;
        for (int i = 0; i < L; ++i) {
            if (!pKaParameters.PKACENTERS_S_BASIC[i].equals(this.pKapara.centerType[ind])) continue;
            return i;
        }
        return -1;
    }

    private int getCBASICIndx(int ind) {
        int L = pKaParameters.PKACENTERS_C_BASIC.length;
        for (int i = 0; i < L; ++i) {
            if (!pKaParameters.PKACENTERS_C_BASIC[i].equals(this.pKapara.centerType[ind])) continue;
            return i;
        }
        return -1;
    }

    private void pKaRegression(int lcount) {
        if (this.actRowCount != 0 && this.actParamCount != 0 && this.actRowCount >= this.actParamCount) {
            PKaFitting pKafitting = new PKaFitting();
            pKafitting.setMultyXYSize(this.actRowCount, this.actParamCount);
            int k = 0;
            for (int y = 0; y < lcount; ++y) {
                if (Double.isNaN(this.actExppKa[y])) continue;
                if (!this.deltapKa) {
                    pKafitting.setYValue(k, this.actExppKa[y]);
                } else {
                    double dif = this.actPredpKa[y] - this.actExppKa[y];
                    pKafitting.setYValue(k, dif);
                }
                pKafitting.setMultyXValue(k, this.getUnknows(y));
                ++k;
            }
            pKafitting.runMultyRegression();
            double[] fp = pKafitting.getFittedParameters();
            this.center.println("PREDICTED PARAMETERS");
            for (int i = 0; i < fp.length; ++i) {
                this.center.println(this.pV[i] + " = " + "\t" + fp[i]);
            }
            this.writePredictedParameters(fp);
        }
    }

    private void writePredictedParameters(double[] fittedParameters) {
        String f = "";
        boolean find = false;
        int i = 3;
        int y = 0;
        while (!find) {
            try {
                String ch = this.actFileName.substring(0, i);
                y = Integer.parseInt(ch);
                find = true;
            }
            catch (NumberFormatException e) {
                --i;
                find = false;
            }
        }
        f = !this.loocv ? String.valueOf(y) + ".dat" : String.valueOf(y) + ".datcv";
        File gg = new File(this.actDir, f);
        PrintWriter params = null;
        try {
            params = new PrintWriter(new FileOutputStream(gg));
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
        for (i = 0; i < fittedParameters.length; ++i) {
            params.println(this.pV[i] + "\t" + fittedParameters[i]);
        }
        params.close();
    }

    protected void calcPredictedpKa(Molecule mm, int molIndex, boolean append) {
        this.ionizer = new Ionizer();
        this.ionizer.micropKaCalc = false;
        this.ionizer.setpKaPrefixType(1);
        this.ionizer.setReversStartOrder(true);
        this.molCopy = mm.cloneMoleculeWithDocument();
        this.ionizer.setMolecule(this.molCopy);
        this.ionizer.setMspHCalc(false);
        this.ionizer.useCorrectionLibrary(true);
        this.ionizer.setTemporarypKaDirectionPath(this.wDirPath);
        if (this.loocv) {
            this.ionizer.setLoocvFlag(true);
        }
        this.ionizer.calculatepKa(0.0);
        int L = this.pKaExp.length;
        double[] pka_model = new double[L];
        int[] used = new int[mm.getAtomCount()];
        for (int i = 0; i < L; ++i) {
            int si;
            int ai = this.pKaAtomId[i];
            double pb = this.ionizer.getpKa(ai, 1);
            double pa = this.ionizer.getpKa(ai, -1);
            double diff1 = 1.0E10;
            double diff2 = 1.0E10;
            if (!Double.isNaN(pb)) {
                diff1 = Math.abs(pb - this.pKaExp[i]);
                si = this.checkOtherSymmetricCenter(i, diff1, 1, this.ionizer);
                if (si != ai) {
                    if (used[si] != 1) {
                        used[si] = 1;
                        diff1 = this.actDiff;
                        pb = this.actCpKa;
                    } else {
                        used[ai] = 1;
                    }
                } else {
                    used[ai] = 1;
                }
            }
            if (!Double.isNaN(pa)) {
                diff2 = Math.abs(pa - this.pKaExp[i]);
                si = this.checkOtherSymmetricCenter(i, diff2, -1, this.ionizer);
                if (si != ai) {
                    if (used[si] != 1) {
                        used[si] = 1;
                        diff2 = this.actDiff;
                        pa = this.actCpKa;
                    } else {
                        used[ai] = 1;
                    }
                } else {
                    used[ai] = 1;
                }
            }
            pka_model[i] = diff1 < diff2 ? pb : pa;
        }
        PrintWriter params = null;
        if (!this.loocv) {
            File res = new File(this.wDirPath, "/pKaModel.txt");
            try {
                params = new PrintWriter(new FileOutputStream(res, append));
            }
            catch (IOException ex) {
                System.err.println(ex);
            }
            for (int i = 0; i < L; ++i) {
                params.print(molIndex + "\t" + this.pKaExp[i] + "\t" + pka_model[i]);
                params.println();
            }
            params.close();
        } else if (this.loocv) {
            File res = new File(this.wDirPath, "/pKaModel.txt");
            File sumres = new File(this.pkamodel);
            try {
                String line;
                BufferedReader in = new BufferedReader(new FileReader(res));
                params = new PrintWriter(new FileOutputStream(sumres, append));
                int k = 0;
                while ((line = in.readLine()) != null) {
                    int mi = this.getMolIndex(line);
                    if (mi == molIndex) {
                        params.print(line + "\t" + pka_model[k]);
                        params.println();
                        ++k;
                    }
                    if (k != L) continue;
                }
                in.close();
                params.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        this.ionizer.useCorrectionLibrary(false);
        this.ionizer.setLoocvFlag(false);
    }

    private int[] getUnknows(int indx) {
        int[] u = new int[this.actParamCount];
        for (int i = 0; i < this.actParamCount; ++i) {
            u[i] = this.parameters[indx][i];
        }
        return u;
    }

    protected int getCenterCount() {
        return this.pKapara.getCenterCount();
    }

    protected int getParameterCenterIndex(int index) {
        return this.pKapara.centerIndex[index];
    }

    protected int getPTypeCount(int index) {
        return this.pKapara.pTypeCount[index];
    }

    protected String getPType(int i, int j) {
        return this.pKapara.pType[i][j];
    }

    class PKaFitting
    extends LinearFitting {
        PKaFitting() {
        }

        @Override
        protected void setMultyXYSize(int mm, int nn) {
            super.setMultyXYSize(mm, nn);
        }

        @Override
        protected void setYValue(int indx, double yValue) {
            super.setYValue(indx, yValue);
        }

        @Override
        protected void setMultyXValue(int rowIndx, int[] xValues) {
            super.setMultyXValue(rowIndx, xValues);
        }

        @Override
        protected void runMultyRegression() {
            super.runMultyRegression();
        }

        @Override
        protected double[] getFittedParameters() {
            return super.getFittedParameters();
        }
    }
}

