/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.stereo;

import chemaxon.calculations.clean.Clean2D;
import chemaxon.common.util.IntVector;
import chemaxon.core.util.GeomUtil;
import chemaxon.struc.BicycloStereoDescriptor;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeMap;

public class BicycloStereoRecognizer {
    private static final int TO_HB = 4;
    private static final int TO_LB = 5;
    private static final int TO_EB = 6;
    private MoleculeGraph m = null;
    private int[] grinvs = null;
    private BitSet[] sssrSet = null;
    private HashMap<Integer, BicycloStereoDescriptor[]> descriptors = null;
    private ArrayList<BicycloSystem> ringSystem = null;

    public void calculateDescriptors(MoleculeGraph mg) {
        this.m = mg.getGraphUnion();
        this.grinvs = new int[this.m.getAtomCount()];
        this.m.getGrinv(this.grinvs, 2);
        this.descriptors = new HashMap();
        if (this.m.getDim() < 2) {
            this.getDescriptors0D();
            return;
        }
        this.findBicycloRings();
        if (this.ringSystem.size() == 0) {
            return;
        }
        int[][] ctab = this.m.getCtab();
        for (int i = 0; i < this.ringSystem.size(); ++i) {
            BicycloSystem system = this.ringSystem.get(i);
            this.evaluateRingSystem(ctab, system);
        }
    }

    private void findBicycloRings() {
        this.ringSystem = new ArrayList();
        int ac = this.m.getAtomCount();
        int[][] sssr = this.m.getSSSR();
        int l = sssr.length;
        this.sssrSet = BicycloStereoRecognizer.getSSSRSet(ac, sssr);
        for (int i = 0; i < l; ++i) {
            BitSet s1 = this.sssrSet[i];
            for (int j = i + 1; j < l; ++j) {
                BitSet s2 = this.sssrSet[j];
                this.checkRingPair(i, s1, j, s2);
            }
        }
    }

    private void checkRingPair(int i, BitSet s1, int j, BitSet s2) {
        int ac = this.m.getAtomCount();
        BitSet twoLargestBridge = new BitSet(ac);
        BitSet smallestBridge = new BitSet(ac);
        this.initSet(twoLargestBridge, s1);
        twoLargestBridge.xor(s2);
        this.initSet(smallestBridge, s1);
        smallestBridge.and(s2);
        if (smallestBridge.cardinality() > 2 && twoLargestBridge.cardinality() < 8) {
            BicycloSystem system = new BicycloSystem();
            system.buildingSSSRIdx1 = i;
            system.buildingSSSRIdx2 = j;
            BitSet systemWithoutBH = this.setSystemWithoutBridgeHead(s1, s2, system, twoLargestBridge, smallestBridge);
            system.activeRingAtomIdxes = this.checkLigands(systemWithoutBH, system);
            this.ringSystem.add(system);
        }
    }

    private void initSet(BitSet s1, BitSet s2) {
        s1.clear();
        s1.or(s2);
    }

    private static BitSet[] getSSSRSet(int ac, int[][] sssr) {
        int l = sssr.length;
        BitSet[] sssrSet = new BitSet[l];
        for (int i = 0; i < l; ++i) {
            int[] r = sssr[i];
            int rl = r.length;
            BitSet s = new BitSet(ac);
            for (int j = 0; j < rl; ++j) {
                s.set(r[j]);
            }
            sssrSet[i] = s;
        }
        return sssrSet;
    }

    private BitSet setSystemWithoutBridgeHead(BitSet s1, BitSet s2, BicycloSystem system, BitSet twoLargestBridge, BitSet smallestBridge) {
        BitSet systemWithoutBridgeHead = new BitSet();
        systemWithoutBridgeHead.or(s1);
        systemWithoutBridgeHead.or(s2);
        int[][] ctab = this.m.getCtab();
        int bridgeheadCount = 0;
        int i = smallestBridge.nextSetBit(0);
        while (i >= 0) {
            int[] an = ctab[i];
            for (int j = 0; j < an.length; ++j) {
                int lidx = an[j];
                if (smallestBridge.get(lidx) || !twoLargestBridge.get(lidx)) continue;
                if (bridgeheadCount > 2) {
                    throw new RuntimeException("More than two bridgehead found");
                }
                systemWithoutBridgeHead.clear(i);
                if (bridgeheadCount == 1) {
                    system.bridgeHead1 = i;
                } else {
                    system.bridgeHead2 = i;
                }
                ++bridgeheadCount;
                break;
            }
            i = smallestBridge.nextSetBit(i + 1);
        }
        return systemWithoutBridgeHead;
    }

    private int[] checkLigands(BitSet s, BicycloSystem system) {
        IntVector idxes = new IntVector();
        int i = s.nextSetBit(0);
        while (i >= 0) {
            MolAtom a = this.m.getAtom(i);
            int bc = a.getBondCount();
            if (bc > 2 && bc < 5) {
                int grinv1 = Integer.MIN_VALUE;
                int grinv2 = Integer.MIN_VALUE;
                boolean first = true;
                for (int j = 0; j < bc; ++j) {
                    int ligandIndex;
                    MolAtom l = a.getLigand(j);
                    if (BicycloStereoRecognizer.isHydrogen(l) || this.isPartOf(ligandIndex = this.m.indexOf(l), s, system)) continue;
                    if (first) {
                        grinv1 = this.grinvs[ligandIndex];
                        first = false;
                        continue;
                    }
                    grinv2 = this.grinvs[ligandIndex];
                }
                if (grinv1 != grinv2) {
                    idxes.add(i);
                }
            }
            i = s.nextSetBit(i + 1);
        }
        return idxes.toArray();
    }

    private boolean isPartOf(int index, BitSet s, BicycloSystem system) {
        return s.get(index) || system.bridgeHead1 == index || system.bridgeHead2 == index;
    }

    private void evaluateRingSystem(int[][] ctab, BicycloSystem system) {
        DPoint3[] bridgeVector = new DPoint3[3];
        int r1 = system.buildingSSSRIdx1;
        int r2 = system.buildingSSSRIdx2;
        BitSet ring1 = this.sssrSet[r1];
        BitSet ring2 = this.sssrSet[r2];
        int bh1 = system.bridgeHead1;
        int bh2 = system.bridgeHead2;
        BitSet ringSystemSet = new BitSet();
        ringSystemSet.or(ring1);
        ringSystemSet.or(ring2);
        BitSet[] bridgeSet = BicycloStereoRecognizer.calcBridgeSet(bh1, bh2, ring1, ring2);
        DPoint3 center = this.calcCM(bh1, bh2);
        for (int j = 0; j < bridgeVector.length; ++j) {
            bridgeVector[j] = this.calcCM(bridgeSet[j]);
            bridgeVector[j].subtract(center);
        }
        this.orderPopsAccordingToNum(bridgeSet, bridgeVector);
        MolAtom[][] bridgeAtoms = this.fillBridgeAtoms(bridgeSet);
        boolean[] validBridge = this.checkValidBridges(bridgeSet, bh1, bh2, bridgeVector);
        double[][] planeEqParams = this.m.getDim() > 2 ? (Object)this.calculatePlaneEquations(bridgeVector, center, bh1, bh2) : new double[3][];
        int[] idxes = system.activeRingAtomIdxes;
        for (int j = 0; j < idxes.length; ++j) {
            int idx = idxes[j];
            this.calcFromCoords(validBridge, bridgeAtoms, bridgeSet, bridgeVector, idx, ctab[idx], ringSystemSet, planeEqParams);
        }
    }

    private double[][] calculatePlaneEquations(DPoint3[] bridgeVector, DPoint3 center, int bh1, int bh2) {
        double[][] planeEQs = new double[bridgeVector.length][];
        for (int i = 0; i < planeEQs.length; ++i) {
            DPoint3 p1 = this.m.getAtom(bh1).getLocation();
            p1.subtract(center);
            DPoint3 p2 = this.m.getAtom(bh2).getLocation();
            p2.subtract(center);
            DPoint3 p3 = bridgeVector[i];
            double D = this.determinant(p1, p2, p3);
            double d = 1.0;
            double a = -d / D * this.determinant(p1, p2, p3, 0);
            double b = -d / D * this.determinant(p1, p2, p3, 1);
            double c = -d / D * this.determinant(p1, p2, p3, 2);
            double[] eq = new double[]{a, b, c, d};
            planeEQs[i] = eq;
        }
        return planeEQs;
    }

    private double determinant(DPoint3 p1, DPoint3 p2, DPoint3 p3) {
        return p1.x * p2.y * p3.z + p1.y * p2.z * p3.x + p1.z * p2.x * p3.y - p3.x * p2.y * p1.z - p3.y * p2.z * p1.x - p3.z * p2.x * p1.y;
    }

    private double determinant(DPoint3 p1, DPoint3 p2, DPoint3 p3, int i) {
        if (i == 0) {
            return p2.y * p3.z + p1.y * p2.z + p1.z * p3.y - p2.y * p1.z - p3.y * p2.z - p3.z * p1.y;
        }
        if (i == 1) {
            return p1.x * p3.z + p2.z * p3.x + p1.z * p2.x - p3.x * p1.z - p2.z * p1.x - p3.z * p2.x;
        }
        return p1.x * p2.y + p1.y * p3.x + p2.x * p3.y - p3.x * p2.y - p3.y * p1.x - p2.x * p1.y;
    }

    private void getDescriptors0D() {
        for (int i = 0; i < this.m.getAtomCount(); ++i) {
            MolAtom a = this.m.getAtom(i);
            BicycloStereoDescriptor[] v = a.getBicycloStereo();
            if (v == null) continue;
            this.descriptors.put(i, v);
        }
    }

    private boolean[] checkValidBridges(BitSet[] s, int bh2, int bh1, DPoint3[] sv) {
        if (this.m.getDim() > 2) {
            return new boolean[]{true, true, true};
        }
        if (BicycloStereoRecognizer.allAngleLargerThanHalfPI(sv)) {
            return new boolean[]{true, true, true};
        }
        return this.checkBridgeheadWedges(s, bh1, bh2, sv);
    }

    private boolean[] checkBridgeheadWedges(BitSet[] bridgeSet, int bh1, int bh2, DPoint3[] bridgeVectors) {
        int[][] ctab = this.m.getCtab();
        IntVector[] wInfo = new IntVector[]{new IntVector(), new IntVector(), new IntVector()};
        int[] an = ctab[bh1];
        MolAtom a = this.m.getAtom(bh1);
        this.checkBridgeheadLigands(bridgeSet, wInfo, an, a);
        an = ctab[bh2];
        a = this.m.getAtom(bh2);
        if (!this.checkBridgeheadLigands(bridgeSet, wInfo, an, a)) {
            return new boolean[]{false, false, false};
        }
        if (wInfo[0].size() + wInfo[1].size() == 0) {
            ArrayList<MolBond> otherBridge2Bonds;
            ArrayList<MolBond> otherBridge1Bonds;
            ArrayList<MolBond> centralBridgeBonds;
            int centralBridgeIdx;
            double distance01 = bridgeVectors[0].distance2D(bridgeVectors[1]);
            double distance02 = bridgeVectors[0].distance2D(bridgeVectors[2]);
            double distance12 = bridgeVectors[1].distance2D(bridgeVectors[2]);
            if (distance12 >= distance01 && distance12 >= distance02) {
                centralBridgeIdx = 0;
                centralBridgeBonds = this.calculateBridgeBonds(bh1, bh2, bridgeSet[0]);
                otherBridge1Bonds = this.calculateBridgeBonds(bh1, bh2, bridgeSet[1]);
                otherBridge2Bonds = this.calculateBridgeBonds(bh1, bh2, bridgeSet[2]);
            } else if (distance02 >= distance01 && distance02 >= distance12) {
                centralBridgeIdx = 1;
                centralBridgeBonds = this.calculateBridgeBonds(bh1, bh2, bridgeSet[1]);
                otherBridge1Bonds = this.calculateBridgeBonds(bh1, bh2, bridgeSet[0]);
                otherBridge2Bonds = this.calculateBridgeBonds(bh1, bh2, bridgeSet[2]);
            } else {
                centralBridgeIdx = 2;
                centralBridgeBonds = this.calculateBridgeBonds(bh1, bh2, bridgeSet[2]);
                otherBridge1Bonds = this.calculateBridgeBonds(bh1, bh2, bridgeSet[0]);
                otherBridge2Bonds = this.calculateBridgeBonds(bh1, bh2, bridgeSet[1]);
            }
            if (!(this.hasCrossingBonds(centralBridgeBonds, otherBridge1Bonds) || this.hasCrossingBonds(otherBridge1Bonds, otherBridge2Bonds) || this.hasCrossingBonds(centralBridgeBonds, otherBridge2Bonds))) {
                wInfo[0].add(centralBridgeIdx);
            }
        }
        BicycloStereoRecognizer.fillNoWedges(wInfo);
        if (wInfo[0].size() == 1 && wInfo[1].size() == 1 && wInfo[2].size() == 1) {
            return new boolean[]{false, false, false};
        }
        for (int i = 0; i < wInfo.length; ++i) {
            IntVector wBIdx = wInfo[i];
            if (wBIdx.size() != 1) continue;
            boolean[] v = new boolean[]{false, false, false};
            v[wBIdx.get((int)0)] = true;
            bridgeVectors[wBIdx.get((int)0)] = BicycloStereoRecognizer.minus(this.m.getAtom(bh1), this.m.getAtom(bh2));
            return v;
        }
        IntVector wBIdx = wInfo[2];
        if (wBIdx.size() == 3) {
            return new boolean[]{true, true, true};
        }
        return new boolean[]{false, false, false};
    }

    private static void fillNoWedges(IntVector[] wInfo) {
        for (int i = 0; i < 3; ++i) {
            if (wInfo[0].contains(i) || wInfo[1].contains(i)) continue;
            wInfo[2].add(i);
        }
    }

    private boolean checkBridgeheadLigands(BitSet[] bridgeSet, IntVector[] wInfo, int[] an, MolAtom bridgehead) {
        for (int i = 0; i < an.length; ++i) {
            MolBond b = bridgehead.getBond(i);
            int f = b.getFlags() & 0x30;
            int bridgeIdx = -1;
            int ligandIdx = an[i];
            if (bridgeSet[0].get(ligandIdx)) {
                bridgeIdx = 0;
            } else if (bridgeSet[1].get(ligandIdx)) {
                bridgeIdx = 1;
            } else if (bridgeSet[2].get(ligandIdx)) {
                bridgeIdx = 2;
            }
            if (bridgeIdx < 0) continue;
            if (f == 16) {
                if (wInfo[1].contains(bridgeIdx)) {
                    return false;
                }
                if (wInfo[0].contains(bridgeIdx)) continue;
                wInfo[0].add(bridgeIdx);
                continue;
            }
            if (f != 32) continue;
            if (wInfo[0].contains(bridgeIdx)) {
                return false;
            }
            if (wInfo[1].contains(bridgeIdx)) continue;
            wInfo[1].add(bridgeIdx);
        }
        return true;
    }

    private boolean hasCrossingBonds(ArrayList<MolBond> bonds1, ArrayList<MolBond> bonds2) {
        for (MolBond molBond1 : bonds1) {
            for (MolBond molBond2 : bonds2) {
                if (Clean2D.hasCommonAtom(molBond1, molBond2) || !Clean2D.crossing(molBond1, molBond2)) continue;
                return true;
            }
        }
        return false;
    }

    private ArrayList<MolBond> calculateBridgeBonds(int bridgeHead1, int bridgeHead2, BitSet centralBridgeAtoms) {
        MolAtom[] atoms = new MolAtom[centralBridgeAtoms.cardinality() + 2];
        int n = 0;
        atoms[n++] = this.m.getAtom(bridgeHead1);
        atoms[n++] = this.m.getAtom(bridgeHead2);
        int j = centralBridgeAtoms.nextSetBit(0);
        while (j >= 0) {
            atoms[n++] = this.m.getAtom(j);
            j = centralBridgeAtoms.nextSetBit(j + 1);
        }
        return BicycloStereoRecognizer.getAllBonds(atoms);
    }

    private static ArrayList<MolBond> getAllBonds(MolAtom[] atoms) {
        ArrayList<MolBond> result = new ArrayList<MolBond>();
        if (atoms != null && atoms.length > 1) {
            for (int i = 0; i < atoms.length; ++i) {
                MolAtom atom = atoms[i];
                for (int j = i + 1; j < atoms.length; ++j) {
                    MolBond bond = atom.getBondTo(atoms[j]);
                    if (bond == null) continue;
                    result.add(bond);
                }
            }
        }
        return result;
    }

    private static boolean allAngleLargerThanHalfPI(DPoint3[] sv) {
        double halfPI = 1.5707963267948966;
        DPoint3 o = new DPoint3(0.0, 0.0, 0.0);
        for (int i = 0; i < sv.length; ++i) {
            DPoint3 v1 = sv[i];
            for (int j = i + 1; j < sv.length; ++j) {
                DPoint3 v2 = sv[j];
                if (!(GeomUtil.calculateAngle(v1, v2, o) <= halfPI)) continue;
                return false;
            }
        }
        return true;
    }

    private MolAtom[][] fillBridgeAtoms(BitSet[] s) {
        MolAtom[][] bridgeAtoms = new MolAtom[s.length][];
        for (int i = 0; i < s.length; ++i) {
            BitSet set = s[i];
            MolAtom[] atoms = new MolAtom[set.cardinality()];
            int n = 0;
            int j = set.nextSetBit(0);
            while (j >= 0) {
                MolAtom a = this.m.getAtom(j);
                atoms[n++] = a;
                j = set.nextSetBit(j + 1);
            }
            bridgeAtoms[i] = atoms;
        }
        return bridgeAtoms;
    }

    private static BitSet[] calcBridgeSet(int bh1, int bh2, BitSet ring1, BitSet ring2) {
        BitSet[] s = new BitSet[]{(BitSet)ring1.clone(), (BitSet)ring2.clone(), new BitSet()};
        s[0].or(s[1]);
        s[1].or(s[0]);
        s[0].xor(ring2);
        s[1].xor(ring1);
        s[2].or(ring1);
        s[2].and(ring2);
        s[2].clear(bh1);
        s[2].clear(bh2);
        return s;
    }

    private static DPoint3 minus(MolAtom a, MolAtom ca) {
        return new DPoint3(a.getX() - ca.getX(), a.getY() - ca.getY(), a.getZ() - ca.getZ());
    }

    private DPoint3 calcCM(BitSet s) {
        DPoint3 v = new DPoint3();
        int l = 0;
        int i = s.nextSetBit(0);
        while (i >= 0) {
            MolAtom a = this.m.getAtom(i);
            v.x += a.getX();
            v.y += a.getY();
            v.z += a.getZ();
            ++l;
            i = s.nextSetBit(i + 1);
        }
        v.x /= (double)l;
        v.y /= (double)l;
        v.z /= (double)l;
        return v;
    }

    private DPoint3 calcCM(int bh1, int bh2) {
        DPoint3 center = new DPoint3();
        MolAtom bha1 = this.m.getAtom(bh1);
        MolAtom bha2 = this.m.getAtom(bh2);
        center.x = (bha1.getX() + bha2.getX()) / 2.0;
        center.y = (bha1.getY() + bha2.getY()) / 2.0;
        center.z = (bha1.getZ() + bha2.getZ()) / 2.0;
        return center;
    }

    private void orderPopsAccordingToNum(BitSet[] s, DPoint3[] sv) {
        int[] maxVal = new int[]{s[0].length(), s[1].length(), s[2].length()};
        TreeMap<Integer, Object[]> sorter = new TreeMap<Integer, Object[]>();
        for (int i = 0; i < maxVal.length; ++i) {
            sorter.put(maxVal[i], new Object[]{s[i], sv[i]});
        }
        Collection sortedV = sorter.values();
        int n = 2;
        for (Object[] o : sortedV) {
            s[n] = (BitSet)o[0];
            sv[n] = (DPoint3)o[1];
            --n;
        }
    }

    private void calcFromCoords(boolean[] validBridge, MolAtom[][] bridgeAtoms, BitSet[] bridgeSets, DPoint3[] bridgeVectors, int idx, int[] an, BitSet ringSystem, double[][] planeEqParams) {
        MolAtom connectionAtom = this.m.getAtom(idx);
        for (int i = 0; i < an.length; ++i) {
            int lIdx = an[i];
            MolAtom ligand = this.m.getAtom(lIdx);
            if (ringSystem.get(lIdx) || BicycloStereoRecognizer.isHydrogen(ligand)) continue;
            MolBond b = connectionAtom.getBond(i);
            boolean wavy = (b.getFlags() & 0x30) == 48;
            DPoint3 bondVector = BicycloStereoRecognizer.minus(ligand, connectionAtom);
            int value = 0;
            MolAtom[] r1 = null;
            MolAtom[] r2 = null;
            if (bridgeSets[0].get(idx)) {
                r1 = bridgeAtoms[1];
                r2 = bridgeAtoms[2];
                value = this.calculateStereoValue(validBridge[0], wavy, bridgeVectors[0], bridgeVectors[1], bondVector, planeEqParams[0]);
            } else if (bridgeSets[1].get(idx)) {
                r1 = bridgeAtoms[0];
                r2 = bridgeAtoms[2];
                value = this.calculateStereoValue(validBridge[1], wavy, bridgeVectors[1], bridgeVectors[0], bondVector, planeEqParams[1]);
            } else {
                r1 = bridgeAtoms[0];
                r2 = bridgeAtoms[1];
                value = this.calculateStereoValue(validBridge[2], wavy, bridgeVectors[2], bridgeVectors[0], bondVector, planeEqParams[2]);
            }
            if (value == 0) continue;
            BicycloStereoDescriptor d = new BicycloStereoDescriptor(connectionAtom, value, r1, r2);
            BicycloStereoDescriptor[] val = this.descriptors.get(lIdx);
            val = BicycloStereoRecognizer.addStereoDescriptor(d, val);
            this.descriptors.put(lIdx, val);
        }
    }

    private int calculateStereoValue(boolean validBranch, boolean wavy, DPoint3 connectedBridge, DPoint3 higherBridge, DPoint3 bondVector, double[] eqParams) {
        return this.m.getDim() == 2 ? this.calculateStereoValue2D(validBranch, connectedBridge, higherBridge, wavy, bondVector) : BicycloStereoRecognizer.calculateStereoValue3D(eqParams, wavy, bondVector, higherBridge);
    }

    private static int calculateStereoValue3D(double[] eqParams, boolean wavy, DPoint3 bondVector, DPoint3 higherBridge) {
        if (wavy) {
            return 6;
        }
        boolean pos = BicycloStereoRecognizer.distanceFromPlane(bondVector, eqParams) > 0.0;
        boolean pos1 = BicycloStereoRecognizer.distanceFromPlane(higherBridge, eqParams) > 0.0;
        return pos ^ pos1 ? 5 : 4;
    }

    private static double distanceFromPlane(DPoint3 p, double[] eqParams) {
        return eqParams[0] * p.x + eqParams[1] * p.y + eqParams[2] * p.z + eqParams[3];
    }

    private int calculateStereoValue2D(boolean validBridge, DPoint3 connectedBridge, DPoint3 higherBridge, boolean wavy, DPoint3 bondVector) {
        double angle;
        double angle_threshold = 0.17453293;
        if (wavy) {
            return 6;
        }
        if (validBridge && (angle = BicycloStereoRecognizer.getAngle(bondVector, connectedBridge)) > angle_threshold) {
            boolean pos = BicycloStereoRecognizer.getAngleSign(bondVector, connectedBridge) > 0;
            boolean pos1 = BicycloStereoRecognizer.getAngleSign(higherBridge, connectedBridge) > 0;
            return pos ^ pos1 ? 5 : 4;
        }
        return 0;
    }

    public static BicycloStereoDescriptor[] addStereoDescriptor(BicycloStereoDescriptor d, BicycloStereoDescriptor[] val) {
        if (val == null) {
            val = new BicycloStereoDescriptor[]{d};
        } else {
            int l = val.length;
            BicycloStereoDescriptor[] tmp = new BicycloStereoDescriptor[l + 1];
            System.arraycopy(val, 0, tmp, 0, l);
            tmp[l] = d;
            val = tmp;
        }
        return val;
    }

    public static boolean isSameStereoClass(BicycloStereoDescriptor d, int[] map) {
        int highest2;
        if (d.getStereoValue() == 6) {
            return true;
        }
        int[] bridge1 = d.getHighBridgeAtomIndexes();
        int[] bridge2 = d.getLowBridgeAtomIndexes();
        int highest1 = BicycloStereoRecognizer.getHighest(bridge1, map);
        return highest1 >= (highest2 = BicycloStereoRecognizer.getHighest(bridge2, map));
    }

    private static int getHighest(int[] b, int[] m) {
        int h = m[b[0]];
        for (int i = 1; i < b.length; ++i) {
            int next = m[b[i]];
            if (next <= h) continue;
            h = next;
        }
        return h;
    }

    private static boolean isHydrogen(MolAtom a) {
        return a.getAtno() == 1 && a.getMassno() == 0;
    }

    private static double getAngle(DPoint3 v1, DPoint3 v2) {
        double dp = v1.x * v2.x + v1.y * v2.y + v1.z * v2.z;
        double v1l = BicycloStereoRecognizer.getLength(v1);
        double v2l = BicycloStereoRecognizer.getLength(v2);
        return Math.acos(dp / (v1l * v2l));
    }

    private static int getAngleSign(DPoint3 v1, DPoint3 v2) {
        double cp = v1.x * v2.y - v1.y * v2.x;
        return (int)Math.signum(cp);
    }

    private static double getLength(DPoint3 v1) {
        return Math.sqrt(v1.x * v1.x + v1.y * v1.y + v1.z * v1.z);
    }

    public HashMap<Integer, BicycloStereoDescriptor[]> getDescriptors() {
        HashMap<Integer, BicycloStereoDescriptor[]> globaldesc = new HashMap<Integer, BicycloStereoDescriptor[]>();
        this.addNonSymmetrical(globaldesc);
        return globaldesc;
    }

    private void addNonSymmetrical(HashMap<Integer, BicycloStereoDescriptor[]> globalDescriptors) {
        int[] grinv = new int[this.m.getAtomCount()];
        this.m.getGrinv(grinv, 2);
        Set<Integer> k = this.descriptors.keySet();
        for (Integer key : k) {
            BicycloStereoDescriptor[] v = this.descriptors.get(key);
            ArrayList<BicycloStereoDescriptor> nonSymmetricDescr = new ArrayList<BicycloStereoDescriptor>();
            for (int i = 0; i < v.length; ++i) {
                BicycloStereoDescriptor desc = v[i];
                if (BicycloStereoRecognizer.isSymmetric(desc, grinv)) continue;
                nonSymmetricDescr.add(desc);
            }
            if (nonSymmetricDescr.size() <= 0) continue;
            BicycloStereoDescriptor[] nonSymmetricDescArray = new BicycloStereoDescriptor[nonSymmetricDescr.size()];
            nonSymmetricDescr.toArray(nonSymmetricDescArray);
            globalDescriptors.put(key, nonSymmetricDescArray);
        }
    }

    private static boolean isSymmetric(BicycloStereoDescriptor d, int[] grinv) {
        int idx;
        int i;
        int[] r2;
        int[] r1 = d.getHighBridgeAtomIndexes();
        if (r1.length != (r2 = d.getLowBridgeAtomIndexes()).length) {
            return false;
        }
        BitSet s1 = new BitSet();
        BitSet s2 = new BitSet();
        for (i = 0; i < r1.length; ++i) {
            idx = r1[i];
            s1.set(grinv[idx]);
        }
        for (i = 0; i < r2.length; ++i) {
            idx = r2[i];
            s2.set(grinv[idx]);
        }
        return s1.equals(s2);
    }

    public HashMap<Integer, BicycloStereoDescriptor[]> getLocalDescriptors() {
        return this.descriptors;
    }

    private class BicycloSystem {
        int buildingSSSRIdx1 = -1;
        int buildingSSSRIdx2 = -1;
        int bridgeHead1 = -1;
        int bridgeHead2 = -1;
        int[] activeRingAtomIdxes = null;

        private BicycloSystem() {
        }
    }
}

