/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.stereo;

import chemaxon.core.calculations.Parity;
import chemaxon.core.util.BondTable;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.MoleculeGraph;

public class Stereochemistry {
    public static final int ODD = 1;
    public static final int EVEN = 2;
    private static final int GRAPHINVARIANTMASK = 2;
    private static final int ATOMTABLEMASK = 4;
    private static final int CHIRALCENTERMASK = 8;
    private static final int ASYMMETRYMASK = 16;
    private MoleculeGraph mol;
    private int initialized = 0;
    private int[] atoms;
    private BondTable btab;
    private int[][] ctab;
    private int[] graphInvariant;

    public MoleculeGraph getMolecule() {
        return this.mol;
    }

    public void setMolecule(MoleculeGraph mol) {
        this.mol = mol;
        this.atoms = new int[mol.getAtomCount()];
        this.btab = mol.getBondTable();
        this.initialized = 0;
    }

    public int asymmetricAtomCount() {
        if ((this.initialized & 0x10) == 0) {
            this.findAsymmetricAtoms();
        }
        int result = 0;
        for (int i = 0; i < this.atoms.length; ++i) {
            if ((this.atoms[i] & 0x10) != 16) continue;
            ++result;
        }
        return result;
    }

    public int[] asymmetricAtoms() {
        int c = this.asymmetricAtomCount();
        if (c == 0) {
            return null;
        }
        int[] result = new int[c];
        c = 0;
        for (int i = 0; i < this.atoms.length; ++i) {
            if ((this.atoms[i] & 0x10) != 16) continue;
            result[c] = i;
            ++c;
        }
        return result;
    }

    private int[][] atomTable() {
        if ((this.initialized & 4) == 0) {
            this.ctab = this.mol.getCtab();
            this.initialized |= 4;
        }
        return this.ctab;
    }

    public int chiralCenterCount() {
        if ((this.initialized & 8) == 0) {
            this.findChiralCenters();
        }
        int result = 0;
        for (int i = 0; i < this.atoms.length; ++i) {
            if ((this.atoms[i] & 8) != 8) continue;
            ++result;
        }
        return result;
    }

    public int[] chiralCenters() {
        int c = this.chiralCenterCount();
        if (c == 0) {
            return null;
        }
        int[] result = new int[c];
        c = 0;
        for (int i = 0; i < this.atoms.length; ++i) {
            if ((this.atoms[i] & 8) != 8) continue;
            result[c] = i;
            ++c;
        }
        return result;
    }

    private void findAsymmetricAtoms() {
        boolean[] asymmetricAtoms = Parity.asymmetricAtoms(this.mol);
        if (asymmetricAtoms != null) {
            for (int i = 0; i < asymmetricAtoms.length; ++i) {
                if (!asymmetricAtoms[i]) continue;
                int n = i;
                this.atoms[n] = this.atoms[n] | 0x10;
            }
        }
        this.initialized |= 0x10;
    }

    private void findChiralCenters() {
        boolean[] chiralAtoms = Parity.chiralAtoms(this.mol);
        if (chiralAtoms != null) {
            for (int i = 0; i < chiralAtoms.length; ++i) {
                if (!chiralAtoms[i]) continue;
                int n = i;
                this.atoms[n] = this.atoms[n] | 8;
            }
        }
        this.initialized |= 8;
    }

    public int[] graphInvariant() {
        if ((this.initialized & 2) == 0) {
            this.graphInvariant = new int[this.atoms.length];
            this.mol.calcDehydrogenizedGrinv(this.graphInvariant);
            this.initialized |= 2;
        }
        return this.graphInvariant;
    }

    public boolean isAsymmetricAtom(int a) {
        int i;
        this.atomTable();
        int d = this.ctab[a].length;
        if (d < 3 || d > 4) {
            return false;
        }
        if (d == 3 && this.mol.getAtom(a).getImplicitHcount() == 0) {
            return false;
        }
        for (i = 0; i < this.ctab[a].length; ++i) {
            if (this.mol.getAtom(this.ctab[a][i]).getAtno() != 1 || this.mol.getAtom(this.ctab[a][i]).getMassno() != 0 || --d >= 3) continue;
            return false;
        }
        this.graphInvariant();
        for (i = 0; i < this.ctab[a].length; ++i) {
            for (int j = i + 1; j < this.ctab[a].length; ++j) {
                if (this.graphInvariant[this.ctab[a][i]] != this.graphInvariant[this.ctab[a][j]]) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isChiral() {
        for (int i = 0; i < this.atoms.length; ++i) {
            int ch = this.mol.getChirality(i);
            if (ch != 8 && ch != 16) continue;
            return true;
        }
        return false;
    }

    public boolean isChiralCenter(int a) {
        return this.mol.getParity(a) != 0;
    }

    public String stereo(int a) {
        switch (this.mol.getChirality(a)) {
            case 8: {
                return "R";
            }
            case 16: {
                return "S";
            }
        }
        return "";
    }

    public String stereo(int a1, int a2) {
        if (this.btab.getBondIndex(a1, a2) == -1) {
            return "";
        }
        switch (this.mol.getStereo2(this.mol.getBond(this.btab.getBondIndex(a1, a2)))) {
            case 128: {
                return "Z";
            }
            case 64: {
                return "E";
            }
        }
        return "";
    }

    public int stereoDoubleBondCount() {
        int c = 0;
        for (int i = 0; i < this.btab.getAtomCount(); ++i) {
            for (int j = i + 1; j < this.btab.getAtomCount(); ++j) {
                int s;
                if (this.btab.getBondIndex(i, j) == -1 || (s = this.mol.getStereo2(this.mol.getBond(this.btab.getBondIndex(i, j)))) != 128 && s != 64) continue;
                ++c;
            }
        }
        return c;
    }

    public static MoleculeGraph getEnantiomer(MoleculeGraph m) {
        int dim = m.getDim();
        MoleculeGraph enant = (MoleculeGraph)m.clone();
        int ac = enant.getAtomCount();
        if (dim == 0) {
            int[] p = new int[ac];
            for (int i = 0; i < ac; ++i) {
                int parity = enant.getParity(i);
                p[i] = parity = parity == 1 ? 2 : (parity == 2 ? 1 : parity);
            }
            enant.setParity(p);
        } else if (dim == 2 || dim == 3) {
            CTransform3D t = new CTransform3D();
            t.setIdentity();
            t.m00 = -1.0;
            enant.transform(t);
        } else {
            throw new RuntimeException("Not suppported dimension for enantiomer generation");
        }
        return enant;
    }
}

