/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training;

import chemaxon.calculations.training.PredictionAlgorithm;
import chemaxon.calculations.training.SVDTrainingResult;
import chemaxon.calculations.training.Stat;

public class AtomicContributionBasedPredictionAlgorithm
implements PredictionAlgorithm<SVDTrainingResult> {
    protected SVDTrainingResult result = null;
    protected double[] descriptors;
    private double confL = 0.95;

    @Override
    public float getProgress() {
        return -1.0f;
    }

    @Override
    public void setCoefficients(SVDTrainingResult result) {
        this.result = result;
    }

    @Override
    public double predict(double[] descriptors) {
        this.descriptors = this.filter(descriptors);
        return Stat.multiply(descriptors, this.result.getCoefficient(), true);
    }

    public double predictStandardError(double[] descriptors) {
        if (descriptors == null || this.result.getMatrix() == null) {
            return Double.NaN;
        }
        return Stat.calcPredictionError(descriptors, this.result.getStandardError(), this.confL, this.result.getMatrix());
    }

    public double getStandardError() {
        return this.predictStandardError(this.descriptors);
    }

    protected double[] filter(double[] descriptor) {
        if (this.result.getMatrix() == null) {
            return descriptor;
        }
        double[] filtered = new double[this.result.getMatrix().length];
        int index = 0;
        for (int i = 0; i < this.result.getCoefficient().length; ++i) {
            if (Double.isNaN(this.result.getCoefficient()[i])) continue;
            filtered[index++] = descriptor[i];
        }
        return filtered;
    }
}

