/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training;

import chemaxon.calculations.pka.Ionizer;
import chemaxon.calculations.training.AtomicContributionBasedPostProcessor;
import chemaxon.calculations.training.AtomicContributionBasedPreProcessor;
import chemaxon.calculations.training.AtomicContributionBasedPredictionAlgorithm;
import chemaxon.calculations.training.AtomicContributionBasedTrainingModel;
import chemaxon.calculations.training.FuturePredictor;
import chemaxon.calculations.training.Postprocessor;
import chemaxon.calculations.training.PredictionAlgorithm;
import chemaxon.calculations.training.Predictor;
import chemaxon.calculations.training.Preprocessor;
import chemaxon.calculations.training.SVDTrainingResult;
import chemaxon.calculations.training.TrainingModel;
import chemaxon.struc.Molecule;

public class AtomicContributionBasedPredictor
implements Predictor<Molecule, SVDTrainingResult> {
    protected final AtomicContributionBasedPrediction prediction;
    protected Preprocessor<Molecule> preprocessor = null;
    protected AtomicContributionBasedPostProcessor postprocessor = null;

    public AtomicContributionBasedPredictor() {
        this(new AtomicContributionBasedPrediction(new AtomicContributionBasedPredictionAlgorithm(), new AtomicContributionBasedTrainingModel()));
    }

    protected AtomicContributionBasedPredictor(AtomicContributionBasedPrediction prediction) {
        this.prediction = prediction;
        this.setPreprocessor(new AtomicContributionBasedPreProcessor());
    }

    protected double predictAtomicIncrement(Molecule item, Ionizer ionizer, int index, boolean reset) {
        Molecule preprocessedItem;
        Molecule molecule = preprocessedItem = this.preprocessor == null ? item : this.preprocessor.preprocess(item);
        if (reset) {
            this.prediction.createDescriptors(preprocessedItem, ionizer);
        }
        double result = this.prediction.getIncrementOf(index);
        if (this.postprocessor != null) {
            result = this.postprocessor.postprocess(preprocessedItem, index, result);
        }
        return result;
    }

    public double[] predictAtomicIncrements(Molecule item) {
        Molecule preprocessedItem = this.preprocessor == null ? item : this.preprocessor.preprocess(item);
        this.prediction.createDescriptors(preprocessedItem, null);
        double[] result = new double[item.getAtomCount()];
        for (int i = 0; i < item.getAtomCount(); ++i) {
            result[i] = this.prediction.getIncrementOf(i);
            if (this.postprocessor == null) continue;
            result[i] = this.postprocessor.postprocess(preprocessedItem, i, result[i]);
        }
        return result;
    }

    @Override
    public void setTrainingResults(SVDTrainingResult results) {
        this.prediction.trainingResults = results;
    }

    @Override
    public double predict(Molecule item) {
        Molecule preprocessedItem = this.preprocessor != null ? this.preprocessor.preprocess(item) : item;
        this.prediction.item = preprocessedItem;
        double result = Double.NaN;
        try {
            result = this.prediction.call();
            if (this.postprocessor != null) {
                result = this.postprocessor.postprocess(preprocessedItem, result);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    public void setPreprocessor(Preprocessor<Molecule> preprocessor) {
        this.preprocessor = preprocessor;
    }

    public Preprocessor<Molecule> getPreprocessor() {
        return this.preprocessor;
    }

    public void setPosprocessor(AtomicContributionBasedPostProcessor postprocessor) {
        this.postprocessor = postprocessor;
    }

    public Postprocessor<Molecule> getPostprocessor() {
        return this.postprocessor;
    }

    public PredictionAlgorithm<SVDTrainingResult> getPredictionAlgorithm() {
        return this.prediction.algorithm;
    }

    @Override
    public void setPredictOnlyTrainables(boolean predictOnlyTrainables) {
        this.prediction.predictOnlytrainables = predictOnlyTrainables;
    }

    @Override
    public boolean isPredictOnlyTrainables() {
        return this.prediction.predictOnlytrainables;
    }

    public double[] predictWithError(Molecule item) {
        double result = this.predict(item);
        double stdError = this.prediction.getStandardError();
        return new double[]{result, stdError};
    }

    protected static class AtomicContributionBasedPrediction
    extends FuturePredictor.Prediction<Molecule, SVDTrainingResult> {
        protected double[][] atomicDescriptors;
        protected double stdError = Double.NaN;

        public AtomicContributionBasedPrediction(PredictionAlgorithm<SVDTrainingResult> algorithm, TrainingModel<Molecule> model) {
            super(algorithm, model);
        }

        protected void createDescriptors(Molecule molecule, Ionizer ionizer) {
            this.atomicDescriptors = ((AtomicContributionBasedTrainingModel)this.model).getDescriptorsByAtomId(molecule, !this.predictOnlytrainables, ionizer);
        }

        protected double getIncrementOf(int atomIndex) {
            if (this.atomicDescriptors == null) {
                return Double.NaN;
            }
            this.algorithm.setCoefficients(this.trainingResults);
            return this.algorithm.predict(this.atomicDescriptors[atomIndex]);
        }

        @Override
        public Double call() throws Exception {
            Double result = super.call();
            this.stdError = Double.isNaN(result) ? Double.NaN : ((AtomicContributionBasedPredictionAlgorithm)this.algorithm).getStandardError();
            return result;
        }

        protected Double getStandardError() {
            return this.stdError;
        }
    }
}

