/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training;

import chemaxon.calculations.training.DescriptorMatrix;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class CachedMatrix
implements DescriptorMatrix {
    private RandomAccessFile cache;
    private int columnCount;
    private int rowCount;

    public CachedMatrix() {
        try {
            File temp = File.createTempFile("descriptor", "");
            temp.deleteOnExit();
            this.cache = new RandomAccessFile(temp, "rw");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public CachedMatrix(RandomAccessFile cache) {
        this.cache = cache;
    }

    @Override
    public boolean insertRow(int rowIndex, double[] data) {
        if (this.getRowCount() == 0) {
            this.setColumnCount(data.length);
        } else if (this.getColumnCount() != data.length) {
            return false;
        }
        if (rowIndex < 0 || rowIndex > this.getRowCount()) {
            rowIndex = this.getRowCount();
        }
        this.setRowCount(this.getRowCount() + 1);
        try {
            if (this.cache.length() < (long)(this.getRowCount() * this.getColumnCount() * 8)) {
                this.cache.setLength(Math.max(8L, this.cache.length() * 3L / 2L + 1L));
            }
            for (int i = this.getRowCount() - 2; i >= rowIndex; --i) {
                this.shiftRight(i);
            }
            this.seekTo(rowIndex, 0);
            this.cache.write(CachedMatrix.doubleArraytoByteArray(data));
        }
        catch (IOException e) {
            this.setRowCount(this.getRowCount() - 1);
            return false;
        }
        return true;
    }

    public boolean setRow(int rowIndex, double[] data) {
        if (rowIndex >= this.rowCount) {
            return false;
        }
        if (this.getRowCount() == 0) {
            this.setColumnCount(data.length);
        } else if (this.getColumnCount() != data.length) {
            return false;
        }
        try {
            this.seekTo(rowIndex, 0);
            this.cache.write(CachedMatrix.doubleArraytoByteArray(data));
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private void shiftRight(int rowIndex) throws IOException {
        double[] data = this.getRow(rowIndex);
        this.seekTo(rowIndex + 1, 0);
        this.cache.write(CachedMatrix.doubleArraytoByteArray(data));
    }

    private void shiftLeft(int rowIndex) throws IOException {
        double[] data = this.getRow(rowIndex);
        this.seekTo(rowIndex - 1, 0);
        this.cache.write(CachedMatrix.doubleArraytoByteArray(data));
    }

    @Override
    public double[] removeRow(int rowIndex) throws IndexOutOfBoundsException {
        if (rowIndex >= this.getRowCount()) {
            throw new IndexOutOfBoundsException();
        }
        double[] data = this.getRow(rowIndex);
        try {
            for (int i = rowIndex + 1; i < this.getRowCount(); ++i) {
                this.shiftLeft(i);
            }
        }
        catch (IOException e) {
            data = null;
        }
        this.setRowCount(this.getRowCount() - 1);
        return data;
    }

    @Override
    public double[] getRow(int rowIndex) throws IndexOutOfBoundsException {
        if (this.getRowCount() <= rowIndex) {
            throw new IndexOutOfBoundsException();
        }
        double[] data = new double[this.getColumnCount()];
        try {
            data = new double[this.getColumnCount()];
            this.seekTo(rowIndex, 0);
            byte[] value = new byte[this.getColumnCount() * 8];
            this.cache.read(value);
            data = CachedMatrix.byteArraytoDoubleArray(value);
        }
        catch (IOException e) {
            data = null;
        }
        return data;
    }

    private void seekTo(int row, int col) throws IndexOutOfBoundsException, IOException {
        if (this.getRowCount() <= row || this.getColumnCount() <= col) {
            throw new IndexOutOfBoundsException();
        }
        this.cache.seek((row * this.columnCount + col) * 8);
    }

    @Override
    public double getValueAt(int rowIndex, int colIndex) throws IndexOutOfBoundsException {
        double data = Double.NaN;
        try {
            this.seekTo(rowIndex, colIndex);
            data = this.cache.readDouble();
        }
        catch (IOException e) {
            // empty catch block
        }
        return data;
    }

    @Override
    public void setValueAt(int rowIndex, int colIndex, double value) throws IndexOutOfBoundsException {
        try {
            this.seekTo(rowIndex, colIndex);
            this.cache.writeDouble(value);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public void transpose() {
        CachedMatrix tmpMatrix = new CachedMatrix();
        for (int i = 0; i < this.columnCount; ++i) {
            double[] data = new double[this.rowCount];
            for (int j = 0; j < this.rowCount; ++j) {
                data[j] = this.getValueAt(j, i);
            }
            tmpMatrix.insertRow(-1, data);
        }
        this.columnCount = tmpMatrix.columnCount;
        this.rowCount = tmpMatrix.rowCount;
        this.cache = tmpMatrix.cache;
    }

    private void setColumnCount(int count) {
        this.columnCount = count;
    }

    private void setRowCount(int count) {
        this.rowCount = count;
    }

    private static byte[] doubleArraytoByteArray(double[] data) {
        if (data == null) {
            return null;
        }
        byte[] byts = new byte[data.length * 8];
        for (int i = 0; i < data.length; ++i) {
            System.arraycopy(CachedMatrix.longToByteArray(Double.doubleToLongBits(data[i])), 0, byts, i * 8, 8);
        }
        return byts;
    }

    private static byte[] longToByteArray(long data) {
        return new byte[]{(byte)(data >> 56 & 0xFFL), (byte)(data >> 48 & 0xFFL), (byte)(data >> 40 & 0xFFL), (byte)(data >> 32 & 0xFFL), (byte)(data >> 24 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data >> 0 & 0xFFL)};
    }

    private static double[] byteArraytoDoubleArray(byte[] data) {
        if (data == null) {
            return null;
        }
        double[] result = new double[data.length / 8];
        for (int i = 0; i < result.length; ++i) {
            byte[] tmp = new byte[8];
            System.arraycopy(data, i * 8, tmp, 0, 8);
            result[i] = Double.longBitsToDouble(CachedMatrix.toLong(tmp));
        }
        return result;
    }

    public static long toLong(byte[] data) {
        if (data == null || data.length != 8) {
            return 0L;
        }
        return (long)(0xFF & data[0]) << 56 | (long)(0xFF & data[1]) << 48 | (long)(0xFF & data[2]) << 40 | (long)(0xFF & data[3]) << 32 | (long)(0xFF & data[4]) << 24 | (long)(0xFF & data[5]) << 16 | (long)(0xFF & data[6]) << 8 | (long)(0xFF & data[7]) << 0;
    }
}

