/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training;

import chemaxon.calculations.training.DescriptorMatrix;
import java.util.ArrayList;

public class FullMatrix
implements DescriptorMatrix {
    private ArrayList<double[]> rows;
    private int columnCount;
    private int rowCount;

    public FullMatrix(int columnCount) {
        this.columnCount = columnCount;
        this.rowCount = 0;
        this.rows = new ArrayList();
    }

    public FullMatrix(int rowCount, int columnCount) {
        this.columnCount = columnCount;
        this.rowCount = rowCount;
        this.rows = new ArrayList(rowCount);
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public double[] getRow(int rowIndex) throws IndexOutOfBoundsException {
        return this.rows.get(rowIndex);
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public double getValueAt(int rowIndex, int colIndex) throws IndexOutOfBoundsException {
        return this.rows.get(rowIndex)[colIndex];
    }

    @Override
    public boolean insertRow(int rowIndex, double[] data) {
        if (data.length != this.columnCount) {
            return false;
        }
        if (rowIndex < 0 || rowIndex > this.rowCount) {
            rowIndex = this.rowCount;
        }
        this.rows.add(rowIndex, data);
        ++this.rowCount;
        return true;
    }

    @Override
    public double[] removeRow(int rowIndex) throws IndexOutOfBoundsException {
        double[] values = this.rows.remove(rowIndex);
        --this.rowCount;
        return values;
    }

    @Override
    public void setValueAt(int rowIndex, int colIndex, double value) throws IndexOutOfBoundsException {
        this.rows.get((int)rowIndex)[colIndex] = value;
    }

    @Override
    public void transpose() {
        ArrayList<double[]> tmpElements = new ArrayList<double[]>(this.columnCount);
        for (int i = 0; i < this.columnCount; ++i) {
            tmpElements.add(i, new double[this.rowCount]);
            for (int j = 0; j < this.rowCount; ++j) {
                ((double[])tmpElements.get((int)i))[j] = this.rows.get(j)[i];
            }
        }
        this.rows = tmpElements;
        int tmp = this.rowCount;
        this.rowCount = this.columnCount;
        this.columnCount = tmp;
    }

    public String toString() {
        StringBuffer matrixImage = new StringBuffer();
        for (int i = 0; i < this.rowCount; ++i) {
            for (int j = 0; j < this.columnCount; ++j) {
                matrixImage.append(this.rows.get(i)[j] + "\t");
            }
            matrixImage.append("\n");
        }
        return matrixImage.toString();
    }
}

