/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training;

import chemaxon.calculations.training.LongRunningTask;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public abstract class FutureCalculation<CT> {
    public static final String PROGRESS = "Progress";
    protected final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    protected FutureTask<CT> result = null;
    protected LongRunningTask<CT> longRunningTask = null;

    protected void start() {
        this.initializeFuture();
        Thread futureResultTask = new Thread(this.result);
        futureResultTask.start();
        if (this.propertyChangeSupport.getPropertyChangeListeners().length > 0) {
            Thread progressMonitorTask = new Thread(new ProgressMonitor(this.propertyChangeSupport, this.longRunningTask, this.result));
            progressMonitorTask.start();
        }
    }

    protected CT getAndWait() {
        CT result = null;
        if (this.result == null) {
            this.start();
        }
        try {
            result = this.result.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected void initializeFuture() {
        if (this.result != null) {
            this.cancel();
            this.result = null;
        }
        this.result = new FutureTask<CT>(this.longRunningTask);
    }

    public boolean isDone() {
        if (this.result != null) {
            return this.result.isDone();
        }
        return false;
    }

    public boolean isCancelled() {
        if (this.result != null) {
            return this.result.isCancelled();
        }
        return false;
    }

    public float getProgress() {
        if (this.result != null && !this.result.isDone()) {
            return this.longRunningTask.getProgress();
        }
        return -1.0f;
    }

    public void cancel() {
        if (this.result != null) {
            this.result.cancel(true);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.propertyChangeSupport.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.propertyChangeSupport.getPropertyChangeListeners(propertyName);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected class ProgressMonitor
    implements Runnable {
        private final PropertyChangeSupport propertyChangeSupport;
        private final LongRunningTask<CT> task;
        private final Future<CT> future;
        private float lastProgress = -1.0f;

        public ProgressMonitor(PropertyChangeSupport propertyChangeSupport, LongRunningTask<CT> task, Future<CT> future) {
            this.propertyChangeSupport = propertyChangeSupport;
            this.task = task;
            this.future = future;
        }

        @Override
        public void run() {
            try {
                if (this.propertyChangeSupport != null && this.propertyChangeSupport.hasListeners(FutureCalculation.PROGRESS)) {
                    float progress = this.lastProgress;
                    while (!this.future.isDone()) {
                        progress = this.task.getProgress();
                        if (progress != this.lastProgress) {
                            this.propertyChangeSupport.firePropertyChange(FutureCalculation.PROGRESS, Float.valueOf(this.lastProgress), Float.valueOf(progress));
                            progress = this.lastProgress;
                        }
                        Thread.sleep(500L);
                    }
                    if (!FutureCalculation.this.isCancelled()) {
                        this.propertyChangeSupport.firePropertyChange(FutureCalculation.PROGRESS, Float.valueOf(this.lastProgress), Float.valueOf(1.0f));
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

