/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training;

import chemaxon.calculations.training.DescriptorMatrix;
import chemaxon.calculations.training.FittingAlgorithm;
import chemaxon.calculations.training.FutureTrainer;
import chemaxon.calculations.training.TrainingModel;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class ParallelTrainer<TT, CT>
extends FutureTrainer<TT, CT> {
    protected transient BlockingQueue<Thread> threadQueue;
    protected transient BlockingQueue<TrainingModel<TT>> modelQueue;

    public ParallelTrainer(FittingAlgorithm<CT> algoritm, DescriptorMatrix descriptorMatrix, TrainingModel<TT> ... models) {
        super(algoritm, models.length == 1 ? models[0] : null, descriptorMatrix);
        if (models.length != 1) {
            this.threadQueue = new ArrayBlockingQueue<Thread>(models.length);
            this.modelQueue = new ArrayBlockingQueue<TrainingModel<TT>>(models.length);
            for (int i = 0; i < models.length; ++i) {
                try {
                    this.modelQueue.put(models[i]);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        } else {
            this.threadQueue = null;
            this.modelQueue = null;
        }
    }

    protected ParallelTrainer(FittingAlgorithm<CT> algoritm, DescriptorMatrix descriptorMatrix, TrainingModel<TT> model) {
        super(algoritm, model, descriptorMatrix);
        this.threadQueue = null;
        this.modelQueue = null;
    }

    @Override
    public CT getResults() {
        if (this.threadQueue != null) {
            while (!this.threadQueue.isEmpty()) {
                try {
                    ((Thread)this.threadQueue.peek()).join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return super.getResults();
    }

    @Override
    public void add(final TT data, final double value) {
        if (this.threadQueue == null) {
            super.add(data, value);
        } else {
            this.result = null;
            try {
                Thread thread = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        TrainingModel model = null;
                        double[] descriptors = null;
                        try {
                            model = ParallelTrainer.this.modelQueue.take();
                            Object object = model;
                            synchronized (object) {
                                Object processedData = ParallelTrainer.this.preprocessor != null ? ParallelTrainer.this.preprocessor.preprocess(data) : data;
                                descriptors = model.getDescriptors(processedData, false);
                            }
                            object = ParallelTrainer.this.descriptorMatrix;
                            synchronized (object) {
                                if (ParallelTrainer.this.descriptorMatrix.insertRow(ParallelTrainer.this.descriptorMatrix.getRowCount(), descriptors)) {
                                    ((FutureTrainer.FittingCalculation)ParallelTrainer.this.longRunningTask).experimentalValues.add(value);
                                }
                            }
                        }
                        catch (InterruptedException e) {
                        }
                        finally {
                            if (model != null) {
                                try {
                                    ParallelTrainer.this.modelQueue.put(model);
                                }
                                catch (InterruptedException e) {}
                            }
                        }
                        ParallelTrainer.this.threadQueue.remove(Thread.currentThread());
                    }
                });
                this.threadQueue.put(thread);
                thread.start();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean add(double[] descriptors, double value) {
        return super.add(descriptors, value);
    }
}

