/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training;

import chemaxon.calculations.training.FuturePredictor;
import chemaxon.calculations.training.PredictionAlgorithm;
import chemaxon.calculations.training.Predictor;
import chemaxon.calculations.training.Stat;
import chemaxon.calculations.training.TrainingModel;
import chemaxon.calculations.training.Validator;
import java.util.ArrayList;
import java.util.List;

public class PearsonValidator<TT, CT>
implements Validator<TT> {
    protected final Predictor<TT, CT> predictor;
    protected final List<Double> experimentalValues = new ArrayList<Double>();
    protected final List<Double> predictedValues = new ArrayList<Double>();

    public PearsonValidator(PredictionAlgorithm<CT> algorithm, TrainingModel<TT> trainingModel, CT results) {
        this.predictor = new FuturePredictor<TT, CT>(algorithm, trainingModel);
        this.predictor.setTrainingResults(results);
    }

    public PearsonValidator(Predictor<TT, CT> predictor, CT results) {
        this.predictor = predictor;
        this.predictor.setTrainingResults(results);
    }

    @Override
    public boolean add(TT data, double experimentalValue) {
        this.predictedValues.add(this.predictor.predict(data));
        this.experimentalValues.add(experimentalValue);
        return true;
    }

    @Override
    public double validate() {
        double[] exp = new double[this.experimentalValues.size()];
        for (int i = 0; i < exp.length; ++i) {
            exp[i] = this.experimentalValues.get(i);
        }
        return Stat.pearsonR2(exp, this.getPrediction());
    }

    public double getR2() {
        return this.validate();
    }

    public double[] getPrediction() {
        double[] result = new double[this.predictedValues.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.predictedValues.get(i);
        }
        return result;
    }
}

