/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training;

import chemaxon.calculations.training.AtomicContributionBasedTrainer;
import chemaxon.calculations.training.AtomicContributionBasedTrainingModel;
import chemaxon.calculations.training.DescriptorMatrix;
import chemaxon.calculations.training.FittingAlgorithm;
import chemaxon.calculations.training.FullMatrix;
import chemaxon.calculations.training.ParallelTrainer;
import chemaxon.calculations.training.SVDFitting;
import chemaxon.calculations.training.SVDTrainingResult;
import chemaxon.calculations.training.Trainer;
import chemaxon.calculations.training.TrainingModel;
import java.beans.PropertyChangeListener;

public class TrainerFactory {
    public static final AtomicContributionBasedTrainer createAtomicContributionBasedTrainer() {
        return TrainerFactory.createAtomicContributionBasedTrainer(new SVDFitting(), new FullMatrix(300), null);
    }

    public static final AtomicContributionBasedTrainer createAtomicContributionBasedTrainer(FittingAlgorithm<SVDTrainingResult> algorithm, DescriptorMatrix matrix, PropertyChangeListener progressListener) {
        AtomicContributionBasedTrainingModel[] models = new AtomicContributionBasedTrainingModel[Runtime.getRuntime().availableProcessors()];
        for (int i = 0; i < models.length; ++i) {
            models[i] = new AtomicContributionBasedTrainingModel();
        }
        AtomicContributionBasedTrainer trainer = new AtomicContributionBasedTrainer(algorithm, matrix, models);
        if (progressListener != null) {
            trainer.addPropertyChangeListener("Progress", progressListener);
        }
        return trainer;
    }

    public static final <TT, CT> Trainer<TT, CT> createTrainer(FittingAlgorithm<CT> algorithm, DescriptorMatrix matrix, PropertyChangeListener progressListener, TrainingModel<TT> ... models) {
        ParallelTrainer<TT, CT> trainer = new ParallelTrainer<TT, CT>(algorithm, matrix, models);
        if (progressListener != null) {
            trainer.addPropertyChangeListener("Progress", progressListener);
        }
        return trainer;
    }
}

