/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training;

import chemaxon.calculations.training.AtomicContributionBasedPredictionAlgorithm;
import chemaxon.calculations.training.AtomicContributionBasedTrainingModel;
import chemaxon.calculations.training.CrossValidator;
import chemaxon.calculations.training.FullMatrix;
import chemaxon.calculations.training.SVDFitting;
import chemaxon.calculations.training.SVDTrainingResult;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class ValidatorFactory {
    public static <TT, CT> CrossValidator<Molecule, SVDTrainingResult> createAtomicContributionBasedCrossValidator() {
        return ValidatorFactory.createAtomicContributionBasedCrossValidator(Runtime.getRuntime().availableProcessors());
    }

    public static CrossValidator<Molecule, SVDTrainingResult> createAtomicContributionBasedCrossValidator(int threadCount) {
        ArrayList fitting = new ArrayList();
        ArrayList models = new ArrayList();
        ArrayList algorithms = new ArrayList();
        for (int i = 0; i < threadCount; ++i) {
            fitting.add(new SVDFitting());
            models.add(new AtomicContributionBasedTrainingModel());
            algorithms.add(new AtomicContributionBasedPredictionAlgorithm());
        }
        FullMatrix matrix = new FullMatrix(300);
        return new CrossValidator<Molecule, SVDTrainingResult>(fitting, models, matrix, algorithms);
    }
}

